/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.runner.ExpressionRunner;
import org.jetbrains.kotlin.runner.FindCompilerKt;
import org.jetbrains.kotlin.runner.JarRunner;
import org.jetbrains.kotlin.runner.MainClassRunner;
import org.jetbrains.kotlin.runner.ReplRunner;
import org.jetbrains.kotlin.runner.Runner;
import org.jetbrains.kotlin.runner.RunnerException;
import org.jetbrains.kotlin.runner.RunnerWithCompiler;
import org.jetbrains.kotlin.runner.ScriptRunner;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\u0006H\u0002J\b\u0010\f\u001a\u00020\u0006H\u0002J\u001b\u0010\r\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000e\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/runner/Main;", "", "()V", "KOTLIN_HOME", "Ljava/io/File;", "main", "", "args", "", "", "([Ljava/lang/String;)V", "printUsageAndExit", "printVersionAndExit", "run", "addPath", "", "Ljava/net/URL;", "path", "HowToRun", "kotlin-runner"})
public final class Main {
    @NotNull
    public static final Main INSTANCE = new Main();
    @NotNull
    private static final File KOTLIN_HOME;

    private Main() {
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void run(String[] args) {
        classpath = new ArrayList<E>();
        compilerClasspath = new ArrayList<URL>();
        runner = new Ref.ObjectRef<Runner>();
        arguments = new ArrayList<String>();
        compilerArguments = new ArrayList<String>();
        noStdLib = false;
        noReflect = false;
        howtorun = HowToRun.GUESS;
        i = new Ref.IntRef();
        while (i.element < args.length) {
            block23: {
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    block25: {
                                        block24: {
                                            block22: {
                                                arg = args[i.element];
                                                if (!Intrinsics.areEqual("-help", arg) && !Intrinsics.areEqual("-h", arg)) break block22;
                                                this.printUsageAndExit();
                                                break block23;
                                            }
                                            if (!Intrinsics.areEqual("-version", arg)) break block24;
                                            this.printVersionAndExit();
                                            break block23;
                                        }
                                        if (!Intrinsics.areEqual("-classpath", arg) && !Intrinsics.areEqual("-cp", arg)) break block25;
                                        v0 = Main.run$next(i, args, arg);
                                        var13_18 = new String[1];
                                        Intrinsics.checkNotNullExpressionValue(File.pathSeparator, "pathSeparator");
                                        $this$filter$iv = StringsKt.split$default(v0, var13_18, false, 0, 6, null);
                                        $i$f$filter = false;
                                        var15_23 = $this$filter$iv;
                                        destination$iv$iv = new ArrayList<E>();
                                        $i$f$filterTo = false;
                                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                                            p0 = (String)element$iv$iv;
                                            $i$a$-filter-Main$run$1 = false;
                                            if (!(((CharSequence)p0).length() > 0)) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        for (String[] path : (List)destination$iv$iv) {
                                            this.addPath((List<URL>)classpath, (String)path /* !! */ );
                                        }
                                        break block23;
                                    }
                                    if (!Intrinsics.areEqual("-compiler-path", arg)) break block26;
                                    v1 = Main.run$next(i, args, arg);
                                    path /* !! */  = new String[1];
                                    Intrinsics.checkNotNullExpressionValue(File.pathSeparator, "pathSeparator");
                                    $this$filter$iv = StringsKt.split$default(v1, path /* !! */ , false, 0, 6, null);
                                    $i$f$filter = false;
                                    $this$filterTo$iv$iv = $this$filter$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$filterTo = false;
                                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                                        p0 = (String)element$iv$iv;
                                        $i$a$-filter-Main$run$2 = false;
                                        if (!(((CharSequence)p0).length() > 0)) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    for (String[] path : (List)destination$iv$iv) {
                                        this.addPath((List<URL>)compilerClasspath, (String)path /* !! */ );
                                    }
                                    break block23;
                                }
                                if (!Intrinsics.areEqual("-howtorun", arg)) break block27;
                                if (howtorun != HowToRun.GUESS) {
                                    throw new RunnerException("-howtorun is already set to " + howtorun.getArgName(), null, 2, null);
                                }
                                howToRunArg = Main.run$next(i, args, arg);
                                if (StringsKt.startsWith$default(howToRunArg, ".", false, 2, null)) {
                                    howtorun = HowToRun.SCRIPT;
                                    compilerArguments.add("-Xdefault-script-extension=" + howToRunArg);
                                } else if (HowToRun.Companion.fromArg(howToRunArg) == null) {
                                    throw new RunnerException("invalid argument to the option -howtorun " + howToRunArg + ", valid arguments are: " + HowToRun.Companion.getValidValues(), null, 2, null);
                                }
                                break block23;
                            }
                            if (Intrinsics.areEqual("-expression", arg) || Intrinsics.areEqual("-e", arg)) {
                                if (howtorun != HowToRun.GUESS && howtorun != HowToRun.SCRIPT) {
                                    throw new RunnerException("expression evaluation is not compatible with -howtorun argument " + howtorun.getArgName(), null, 2, null);
                                }
                                Main.run$setRunner(runner, new ExpressionRunner(Main.run$next(i, args, arg)));
                                Main.run$restAsArguments(arguments, args, i);
                                break;
                            }
                            if (!Intrinsics.areEqual("-no-stdlib", arg)) break block28;
                            noStdLib = true;
                            compilerArguments.add(arg);
                            break block23;
                        }
                        if (!Intrinsics.areEqual("-no-reflect", arg)) break block29;
                        noReflect = true;
                        compilerArguments.add(arg);
                        break block23;
                    }
                    if (StringsKt.startsWith$default(arg, "-X", false, 2, null)) break block30;
                    if (StringsKt.startsWith$default(arg, "-", false, 2, null)) {
                        throw new RunnerException("unknown option: " + arg, null, 2, null);
                    }
                    if (howtorun == HowToRun.JAR || howtorun == HowToRun.GUESS && StringsKt.endsWith$default(arg, ".jar", false, 2, null)) {
                        Main.run$setRunner(runner, new JarRunner(arg));
                        Main.run$restAsArguments(arguments, args, i);
                        break;
                    }
                    if (howtorun == HowToRun.SCRIPT || howtorun == HowToRun.GUESS && StringsKt.endsWith$default(arg, ".kts", false, 2, null)) {
                        Main.run$setRunner(runner, new ScriptRunner(arg));
                        Main.run$restAsArguments(arguments, args, i);
                        break;
                    }
                    workingDir = new File(".");
                    classFile = new File(arg);
                    if (!StringsKt.endsWith$default(arg, ".class", false, 2, null) || !classFile.exists()) ** GOTO lbl-1000
                    v2 = classFile.getCanonicalPath();
                    Intrinsics.checkNotNullExpressionValue(v2, "classFile.canonicalPath");
                    v3 = v2;
                    v4 = workingDir.getCanonicalPath();
                    Intrinsics.checkNotNullExpressionValue(v4, "workingDir.canonicalPath");
                    if (StringsKt.contains$default(v3, v4, false, 2, null)) {
                        v5 = classFile.getCanonicalFile();
                        Intrinsics.checkNotNullExpressionValue(v5, "classFile.canonicalFile");
                        v6 = workingDir.getCanonicalFile();
                        Intrinsics.checkNotNullExpressionValue(v6, "workingDir.canonicalFile");
                        v7 = StringsKt.replace$default(StringsKt.removeSuffix(FilesKt.toRelativeString(v5, v6), (CharSequence)".class"), File.separatorChar, '.', false, 4, null);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v7 = arg;
                    }
                    className = v7;
                    Main.run$setRunner(runner, new MainClassRunner(className));
                    Main.run$restAsArguments(arguments, args, i);
                    break;
                }
                compilerArguments.add(arg);
            }
            workingDir = i.element;
            i.element = workingDir + 1;
        }
        if (classpath.isEmpty()) {
            this.addPath((List<URL>)classpath, ".");
        }
        if (!noStdLib) {
            this.addPath((List<URL>)classpath, Main.KOTLIN_HOME + "/lib/kotlin-stdlib.jar");
        }
        if (!noReflect) {
            this.addPath((List<URL>)classpath, Main.KOTLIN_HOME + "/lib/kotlin-reflect.jar");
        }
        if (runner.element == null) {
            Main.run$setRunner(runner, new ReplRunner());
        }
        if (runner.element instanceof RunnerWithCompiler && compilerClasspath.isEmpty()) {
            $this$forEach$iv = FindCompilerKt.findCompilerJar(this.getClass(), FilesKt.resolve(Main.KOTLIN_HOME, "lib"));
            $i$f$forEach = false;
            for (E element$iv : $this$forEach$iv) {
                it = (File)element$iv;
                $i$a$-forEach-Main$run$3 = false;
                compilerClasspath.add(it.getAbsoluteFile().toURI().toURL());
            }
        }
        v8 = runner.element;
        Intrinsics.checkNotNull(v8);
        ((Runner)v8).run((List<URL>)classpath, (List<String>)compilerArguments, (List<String>)arguments, (List<URL>)compilerClasspath);
    }

    private final void addPath(List<URL> $this$addPath, String path) {
        URL uRL = new File(path).getAbsoluteFile().toURI().toURL();
        Intrinsics.checkNotNullExpressionValue(uRL, "File(path).absoluteFile.toURI().toURL()");
        $this$addPath.add(uRL);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter(args, "args");
        try {
            INSTANCE.run(args);
        }
        catch (RunnerException e) {
            System.err.println("error: " + e.getMessage());
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void printUsageAndExit() {
        System.out.println((Object)("kotlin: run Kotlin programs, scripts or REPL.\n\nUsage: kotlin <options> <command> [<arguments>]\nwhere possible options include:\n  -howtorun <value>          How to run the supplied command with arguments, \n                             valid values: " + HowToRun.Companion.getValidValues() + "\n  -classpath (-cp) <path>    Paths where to find user class files\n  -Dname=value               Set a system JVM property\n  -J<option>                 Pass an option directly to JVM\n  -no-stdlib                 Don't include Kotlin standard library into classpath\n  -no-reflect                Don't include Kotlin reflection implementation into classpath\n  -compiler-path             Kotlin compiler classpath for compiling script or expression or running REPL \n                             If not specified, try to find the compiler in the environment\n  -X<flag>[=value]           Pass -X argument to the compiler\n  -version                   Display Kotlin version\n  -help (-h)                 Print a synopsis of options\nand command is interpreted according to the -howtorun option argument \nor, in case of guess, according to the following rules:\n  foo.Bar                    Runs the 'main' function from the class with the given qualified name\n                             (compiler arguments are ignored) \n  app.jar                    Runs the given JAR file as 'java -jar' would do\n                             (compiler arguments are ignored and no Kotlin stdlib is added to the classpath)\n  script.kts                 Compiles and runs the given script, passing <arguments> to it\n  -expression (-e) '2+2'     Evaluates the expression and prints the result, passing <arguments> to it\n  <no command>               Runs Kotlin REPL\narguments are passed to the main function when running class or jar file, and for standard script definitions\nas the 'args' parameter when running script or expression\n"));
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private final void printVersionAndExit() {
        String string;
        try {
            string = new Scanner(new File(KOTLIN_HOME, "build.txt")).nextLine();
        }
        catch (FileNotFoundException e) {
            throw new RunnerException("no build.txt was found at home=" + KOTLIN_HOME, null, 2, null);
        }
        String version = string;
        System.out.println((Object)("Kotlin version " + version + " (JRE " + System.getProperty("java.runtime.version") + ')'));
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final void run$setRunner(Ref.ObjectRef<Runner> runner, Runner newRunner) {
        if (runner.element != null) {
            throw new AssertionError((Object)"conflicting runner settings");
        }
        runner.element = newRunner;
    }

    private static final String run$next(Ref.IntRef i, String[] $args, String arg) {
        ++i.element;
        if (i.element == $args.length) {
            throw new RunnerException("argument expected to " + arg, null, 2, null);
        }
        return $args[i.element];
    }

    private static final void run$restAsArguments(ArrayList<String> arguments, String[] $args, Ref.IntRef i) {
        String[] stringArray = $args;
        int n = i.element + 1;
        int n2 = $args.length;
        CollectionsKt.addAll((Collection)arguments, ArraysKt.copyOfRange(stringArray, n, n2));
    }

    static {
        String home = System.getProperty("kotlin.home");
        if (home == null) {
            System.err.println("error: no kotlin.home system property was passed");
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        KOTLIN_HOME = new File(home);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0001\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/runner/Main$HowToRun;", "", "argName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getArgName", "()Ljava/lang/String;", "GUESS", "CLASSFILE", "JAR", "SCRIPT", "Companion", "kotlin-runner"})
    public static final class HowToRun
    extends Enum<HowToRun> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String argName;
        @NotNull
        private static final String validValues;
        public static final /* enum */ HowToRun GUESS;
        public static final /* enum */ HowToRun CLASSFILE;
        public static final /* enum */ HowToRun JAR;
        public static final /* enum */ HowToRun SCRIPT;
        private static final /* synthetic */ HowToRun[] $VALUES;

        private HowToRun(String argName) {
            this.argName = argName;
        }

        @NotNull
        public final String getArgName() {
            return this.argName;
        }

        public static HowToRun[] values() {
            return (HowToRun[])$VALUES.clone();
        }

        public static HowToRun valueOf(String value) {
            return Enum.valueOf(HowToRun.class, value);
        }

        static {
            GUESS = new HowToRun("guess");
            CLASSFILE = new HowToRun("classfile");
            JAR = new HowToRun("jar");
            SCRIPT = new HowToRun("script");
            $VALUES = howToRunArray = new HowToRun[]{HowToRun.GUESS, HowToRun.CLASSFILE, HowToRun.JAR, HowToRun.SCRIPT};
            Companion = new Companion(null);
            validValues = HowToRun.GUESS.argName + " (default), " + HowToRun.CLASSFILE.argName + ", " + HowToRun.JAR.argName + ", " + HowToRun.SCRIPT.argName + " (or .<script filename extension>)";
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/runner/Main$HowToRun$Companion;", "", "()V", "validValues", "", "getValidValues", "()Ljava/lang/String;", "fromArg", "Lorg/jetbrains/kotlin/runner/Main$HowToRun;", "name", "kotlin-runner"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String getValidValues() {
                return validValues;
            }

            @Nullable
            public final HowToRun fromArg(@NotNull String name) {
                HowToRun howToRun;
                block1: {
                    Intrinsics.checkNotNullParameter(name, "name");
                    HowToRun[] howToRunArray = HowToRun.values();
                    int n = howToRunArray.length;
                    for (int i = 0; i < n; ++i) {
                        HowToRun howToRun2;
                        HowToRun it = howToRun2 = howToRunArray[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getArgName(), name)) continue;
                        howToRun = howToRun2;
                        break block1;
                    }
                    howToRun = null;
                }
                return howToRun;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

