// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from nrf5340_application.svd, see https://github.com/NordicSemiconductor/nrfx/tree/master/mdk

//go:build nrf && nrf5340_application
// +build nrf,nrf5340_application

// nRF53 reference description for system-on-chip with dual ARM 32-bit Cortex-M33 microcontrollers
//
//     Copyright (c) 2010 - 2020, Nordic Semiconductor ASA All rights reserved. Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer. 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution. 3. Neither the name of Nordic Semiconductor ASA nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL NORDIC SEMICONDUCTOR ASA OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
package nrf

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "nrf5340_application"
	CPU          = "CM33"
	FPUPresent   = true
	NVICPrioBits = 3
)

// Interrupt numbers.
const (
	// FPU control peripheral 0 // FPU control peripheral 1
	IRQ_FPU = 0

	// FPU control peripheral 0
	IRQ_FPU_NS = 0

	// FPU control peripheral 1
	IRQ_FPU_S = 0

	// Cache
	IRQ_CACHE = 1

	// Cache
	IRQ_CACHE_S = 1

	// System protection unit
	IRQ_SPU = 3

	// System protection unit
	IRQ_SPU_S = 3

	// Clock management 0 // Power control 0 // Clock management 1 // Power control 1
	IRQ_CLOCK_POWER = 5

	// Clock management 0
	IRQ_CLOCK_NS = 5

	// Power control 0
	IRQ_POWER_NS = 5

	// Clock management 1
	IRQ_CLOCK_S = 5

	// Power control 1
	IRQ_POWER_S = 5

	// Serial Peripheral Interface Master with EasyDMA 0 // SPI Slave 0 // I2C compatible Two-Wire Master Interface with EasyDMA 0 // I2C compatible Two-Wire Slave Interface with EasyDMA 0 // UART with EasyDMA 0 // Serial Peripheral Interface Master with EasyDMA 1 // SPI Slave 1 // I2C compatible Two-Wire Master Interface with EasyDMA 1 // I2C compatible Two-Wire Slave Interface with EasyDMA 1 // UART with EasyDMA 1
	IRQ_SPIM0_SPIS0_TWIM0_TWIS0_UARTE0 = 8

	// Serial Peripheral Interface Master with EasyDMA 0
	IRQ_SPIM0_NS = 8

	// SPI Slave 0
	IRQ_SPIS0_NS = 8

	// I2C compatible Two-Wire Master Interface with EasyDMA 0
	IRQ_TWIM0_NS = 8

	// I2C compatible Two-Wire Slave Interface with EasyDMA 0
	IRQ_TWIS0_NS = 8

	// UART with EasyDMA 0
	IRQ_UARTE0_NS = 8

	// Serial Peripheral Interface Master with EasyDMA 1
	IRQ_SPIM0_S = 8

	// SPI Slave 1
	IRQ_SPIS0_S = 8

	// I2C compatible Two-Wire Master Interface with EasyDMA 1
	IRQ_TWIM0_S = 8

	// I2C compatible Two-Wire Slave Interface with EasyDMA 1
	IRQ_TWIS0_S = 8

	// UART with EasyDMA 1
	IRQ_UARTE0_S = 8

	// Serial Peripheral Interface Master with EasyDMA 2 // SPI Slave 2 // I2C compatible Two-Wire Master Interface with EasyDMA 2 // I2C compatible Two-Wire Slave Interface with EasyDMA 2 // UART with EasyDMA 2 // Serial Peripheral Interface Master with EasyDMA 3 // SPI Slave 3 // I2C compatible Two-Wire Master Interface with EasyDMA 3 // I2C compatible Two-Wire Slave Interface with EasyDMA 3 // UART with EasyDMA 3
	IRQ_SPIM1_SPIS1_TWIM1_TWIS1_UARTE1 = 9

	// Serial Peripheral Interface Master with EasyDMA 2
	IRQ_SPIM1_NS = 9

	// SPI Slave 2
	IRQ_SPIS1_NS = 9

	// I2C compatible Two-Wire Master Interface with EasyDMA 2
	IRQ_TWIM1_NS = 9

	// I2C compatible Two-Wire Slave Interface with EasyDMA 2
	IRQ_TWIS1_NS = 9

	// UART with EasyDMA 2
	IRQ_UARTE1_NS = 9

	// Serial Peripheral Interface Master with EasyDMA 3
	IRQ_SPIM1_S = 9

	// SPI Slave 3
	IRQ_SPIS1_S = 9

	// I2C compatible Two-Wire Master Interface with EasyDMA 3
	IRQ_TWIM1_S = 9

	// I2C compatible Two-Wire Slave Interface with EasyDMA 3
	IRQ_TWIS1_S = 9

	// UART with EasyDMA 3
	IRQ_UARTE1_S = 9

	// Serial Peripheral Interface Master with EasyDMA 4 // Serial Peripheral Interface Master with EasyDMA 5
	IRQ_SPIM4 = 10

	// Serial Peripheral Interface Master with EasyDMA 4
	IRQ_SPIM4_NS = 10

	// Serial Peripheral Interface Master with EasyDMA 5
	IRQ_SPIM4_S = 10

	// Serial Peripheral Interface Master with EasyDMA 6 // SPI Slave 4 // I2C compatible Two-Wire Master Interface with EasyDMA 4 // I2C compatible Two-Wire Slave Interface with EasyDMA 4 // UART with EasyDMA 4 // Serial Peripheral Interface Master with EasyDMA 7 // SPI Slave 5 // I2C compatible Two-Wire Master Interface with EasyDMA 5 // I2C compatible Two-Wire Slave Interface with EasyDMA 5 // UART with EasyDMA 5
	IRQ_SPIM2_SPIS2_TWIM2_TWIS2_UARTE2 = 11

	// Serial Peripheral Interface Master with EasyDMA 6
	IRQ_SPIM2_NS = 11

	// SPI Slave 4
	IRQ_SPIS2_NS = 11

	// I2C compatible Two-Wire Master Interface with EasyDMA 4
	IRQ_TWIM2_NS = 11

	// I2C compatible Two-Wire Slave Interface with EasyDMA 4
	IRQ_TWIS2_NS = 11

	// UART with EasyDMA 4
	IRQ_UARTE2_NS = 11

	// Serial Peripheral Interface Master with EasyDMA 7
	IRQ_SPIM2_S = 11

	// SPI Slave 5
	IRQ_SPIS2_S = 11

	// I2C compatible Two-Wire Master Interface with EasyDMA 5
	IRQ_TWIM2_S = 11

	// I2C compatible Two-Wire Slave Interface with EasyDMA 5
	IRQ_TWIS2_S = 11

	// UART with EasyDMA 5
	IRQ_UARTE2_S = 11

	// Serial Peripheral Interface Master with EasyDMA 8 // SPI Slave 6 // I2C compatible Two-Wire Master Interface with EasyDMA 6 // I2C compatible Two-Wire Slave Interface with EasyDMA 6 // UART with EasyDMA 6 // Serial Peripheral Interface Master with EasyDMA 9 // SPI Slave 7 // I2C compatible Two-Wire Master Interface with EasyDMA 7 // I2C compatible Two-Wire Slave Interface with EasyDMA 7 // UART with EasyDMA 7
	IRQ_SPIM3_SPIS3_TWIM3_TWIS3_UARTE3 = 12

	// Serial Peripheral Interface Master with EasyDMA 8
	IRQ_SPIM3_NS = 12

	// SPI Slave 6
	IRQ_SPIS3_NS = 12

	// I2C compatible Two-Wire Master Interface with EasyDMA 6
	IRQ_TWIM3_NS = 12

	// I2C compatible Two-Wire Slave Interface with EasyDMA 6
	IRQ_TWIS3_NS = 12

	// UART with EasyDMA 6
	IRQ_UARTE3_NS = 12

	// Serial Peripheral Interface Master with EasyDMA 9
	IRQ_SPIM3_S = 12

	// SPI Slave 7
	IRQ_SPIS3_S = 12

	// I2C compatible Two-Wire Master Interface with EasyDMA 7
	IRQ_TWIM3_S = 12

	// I2C compatible Two-Wire Slave Interface with EasyDMA 7
	IRQ_TWIS3_S = 12

	// UART with EasyDMA 7
	IRQ_UARTE3_S = 12

	// GPIO Tasks and Events 0
	IRQ_GPIOTE0 = 13

	// GPIO Tasks and Events 0
	IRQ_GPIOTE0_S = 13

	// Analog to Digital Converter 0 // Analog to Digital Converter 1
	IRQ_SAADC = 14

	// Analog to Digital Converter 0
	IRQ_SAADC_NS = 14

	// Analog to Digital Converter 1
	IRQ_SAADC_S = 14

	// Timer/Counter 0 // Timer/Counter 1
	IRQ_TIMER0 = 15

	// Timer/Counter 0
	IRQ_TIMER0_NS = 15

	// Timer/Counter 1
	IRQ_TIMER0_S = 15

	// Timer/Counter 2 // Timer/Counter 3
	IRQ_TIMER1 = 16

	// Timer/Counter 2
	IRQ_TIMER1_NS = 16

	// Timer/Counter 3
	IRQ_TIMER1_S = 16

	// Timer/Counter 4 // Timer/Counter 5
	IRQ_TIMER2 = 17

	// Timer/Counter 4
	IRQ_TIMER2_NS = 17

	// Timer/Counter 5
	IRQ_TIMER2_S = 17

	// Real-time counter 0 // Real-time counter 1
	IRQ_RTC0 = 20

	// Real-time counter 0
	IRQ_RTC0_NS = 20

	// Real-time counter 1
	IRQ_RTC0_S = 20

	// Real-time counter 2 // Real-time counter 3
	IRQ_RTC1 = 21

	// Real-time counter 2
	IRQ_RTC1_NS = 21

	// Real-time counter 3
	IRQ_RTC1_S = 21

	// Watchdog Timer 0 // Watchdog Timer 1
	IRQ_WDT0 = 24

	// Watchdog Timer 0
	IRQ_WDT0_NS = 24

	// Watchdog Timer 1
	IRQ_WDT0_S = 24

	// Watchdog Timer 2 // Watchdog Timer 3
	IRQ_WDT1 = 25

	// Watchdog Timer 2
	IRQ_WDT1_NS = 25

	// Watchdog Timer 3
	IRQ_WDT1_S = 25

	// Comparator 0 // Low-power comparator 0 // Comparator 1 // Low-power comparator 1
	IRQ_COMP_LPCOMP = 26

	// Comparator 0
	IRQ_COMP_NS = 26

	// Low-power comparator 0
	IRQ_LPCOMP_NS = 26

	// Comparator 1
	IRQ_COMP_S = 26

	// Low-power comparator 1
	IRQ_LPCOMP_S = 26

	// Event generator unit 0 // Event generator unit 1
	IRQ_EGU0 = 27

	// Event generator unit 0
	IRQ_EGU0_NS = 27

	// Event generator unit 1
	IRQ_EGU0_S = 27

	// Event generator unit 2 // Event generator unit 3
	IRQ_EGU1 = 28

	// Event generator unit 2
	IRQ_EGU1_NS = 28

	// Event generator unit 3
	IRQ_EGU1_S = 28

	// Event generator unit 4 // Event generator unit 5
	IRQ_EGU2 = 29

	// Event generator unit 4
	IRQ_EGU2_NS = 29

	// Event generator unit 5
	IRQ_EGU2_S = 29

	// Event generator unit 6 // Event generator unit 7
	IRQ_EGU3 = 30

	// Event generator unit 6
	IRQ_EGU3_NS = 30

	// Event generator unit 7
	IRQ_EGU3_S = 30

	// Event generator unit 8 // Event generator unit 9
	IRQ_EGU4 = 31

	// Event generator unit 8
	IRQ_EGU4_NS = 31

	// Event generator unit 9
	IRQ_EGU4_S = 31

	// Event generator unit 10 // Event generator unit 11
	IRQ_EGU5 = 32

	// Event generator unit 10
	IRQ_EGU5_NS = 32

	// Event generator unit 11
	IRQ_EGU5_S = 32

	// Pulse width modulation unit 0 // Pulse width modulation unit 1
	IRQ_PWM0 = 33

	// Pulse width modulation unit 0
	IRQ_PWM0_NS = 33

	// Pulse width modulation unit 1
	IRQ_PWM0_S = 33

	// Pulse width modulation unit 2 // Pulse width modulation unit 3
	IRQ_PWM1 = 34

	// Pulse width modulation unit 2
	IRQ_PWM1_NS = 34

	// Pulse width modulation unit 3
	IRQ_PWM1_S = 34

	// Pulse width modulation unit 4 // Pulse width modulation unit 5
	IRQ_PWM2 = 35

	// Pulse width modulation unit 4
	IRQ_PWM2_NS = 35

	// Pulse width modulation unit 5
	IRQ_PWM2_S = 35

	// Pulse width modulation unit 6 // Pulse width modulation unit 7
	IRQ_PWM3 = 36

	// Pulse width modulation unit 6
	IRQ_PWM3_NS = 36

	// Pulse width modulation unit 7
	IRQ_PWM3_S = 36

	// Pulse Density Modulation (Digital Microphone) Interface 0 // Pulse Density Modulation (Digital Microphone) Interface 1
	IRQ_PDM0 = 38

	// Pulse Density Modulation (Digital Microphone) Interface 0
	IRQ_PDM0_NS = 38

	// Pulse Density Modulation (Digital Microphone) Interface 1
	IRQ_PDM0_S = 38

	// Inter-IC Sound 0 // Inter-IC Sound 1
	IRQ_I2S0 = 40

	// Inter-IC Sound 0
	IRQ_I2S0_NS = 40

	// Inter-IC Sound 1
	IRQ_I2S0_S = 40

	// Interprocessor communication 0 // Interprocessor communication 1
	IRQ_IPC = 42

	// Interprocessor communication 0
	IRQ_IPC_NS = 42

	// Interprocessor communication 1
	IRQ_IPC_S = 42

	// External flash interface 0 // External flash interface 1
	IRQ_QSPI = 43

	// External flash interface 0
	IRQ_QSPI_NS = 43

	// External flash interface 1
	IRQ_QSPI_S = 43

	// NFC-A compatible radio 0 // NFC-A compatible radio 1
	IRQ_NFCT = 45

	// NFC-A compatible radio 0
	IRQ_NFCT_NS = 45

	// NFC-A compatible radio 1
	IRQ_NFCT_S = 45

	// GPIO Tasks and Events 1
	IRQ_GPIOTE1 = 47

	// GPIO Tasks and Events 1
	IRQ_GPIOTE1_NS = 47

	// Quadrature Decoder 0 // Quadrature Decoder 1
	IRQ_QDEC0 = 51

	// Quadrature Decoder 0
	IRQ_QDEC0_NS = 51

	// Quadrature Decoder 1
	IRQ_QDEC0_S = 51

	// Quadrature Decoder 2 // Quadrature Decoder 3
	IRQ_QDEC1 = 52

	// Quadrature Decoder 2
	IRQ_QDEC1_NS = 52

	// Quadrature Decoder 3
	IRQ_QDEC1_S = 52

	// Universal serial bus device 0 // Universal serial bus device 1
	IRQ_USBD = 54

	// Universal serial bus device 0
	IRQ_USBD_NS = 54

	// Universal serial bus device 1
	IRQ_USBD_S = 54

	// USB Regulator 0 // USB Regulator 1
	IRQ_USBREGULATOR = 55

	// USB Regulator 0
	IRQ_USBREGULATOR_NS = 55

	// USB Regulator 1
	IRQ_USBREGULATOR_S = 55

	// Key management unit 0 // Key management unit 1
	IRQ_KMU = 57

	// Key management unit 0
	IRQ_KMU_NS = 57

	// Key management unit 1
	IRQ_KMU_S = 57

	// ARM TrustZone CryptoCell register interface
	IRQ_CRYPTOCELL = 68

	// ARM TrustZone CryptoCell register interface
	IRQ_CRYPTOCELL_S = 68

	// Highest interrupt number on this device.
	IRQ_max = 68
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

//export CACHE_IRQHandler
func interruptCACHE() {
	callHandlers(IRQ_CACHE)
}

//export SPU_IRQHandler
func interruptSPU() {
	callHandlers(IRQ_SPU)
}

//export CLOCK_POWER_IRQHandler
func interruptCLOCK_POWER() {
	callHandlers(IRQ_CLOCK_POWER)
}

//export SPIM0_SPIS0_TWIM0_TWIS0_UARTE0_IRQHandler
func interruptSPIM0_SPIS0_TWIM0_TWIS0_UARTE0() {
	callHandlers(IRQ_SPIM0_SPIS0_TWIM0_TWIS0_UARTE0)
}

//export SPIM1_SPIS1_TWIM1_TWIS1_UARTE1_IRQHandler
func interruptSPIM1_SPIS1_TWIM1_TWIS1_UARTE1() {
	callHandlers(IRQ_SPIM1_SPIS1_TWIM1_TWIS1_UARTE1)
}

//export SPIM4_IRQHandler
func interruptSPIM4() {
	callHandlers(IRQ_SPIM4)
}

//export SPIM2_SPIS2_TWIM2_TWIS2_UARTE2_IRQHandler
func interruptSPIM2_SPIS2_TWIM2_TWIS2_UARTE2() {
	callHandlers(IRQ_SPIM2_SPIS2_TWIM2_TWIS2_UARTE2)
}

//export SPIM3_SPIS3_TWIM3_TWIS3_UARTE3_IRQHandler
func interruptSPIM3_SPIS3_TWIM3_TWIS3_UARTE3() {
	callHandlers(IRQ_SPIM3_SPIS3_TWIM3_TWIS3_UARTE3)
}

//export GPIOTE0_IRQHandler
func interruptGPIOTE0() {
	callHandlers(IRQ_GPIOTE0)
}

//export SAADC_IRQHandler
func interruptSAADC() {
	callHandlers(IRQ_SAADC)
}

//export TIMER0_IRQHandler
func interruptTIMER0() {
	callHandlers(IRQ_TIMER0)
}

//export TIMER1_IRQHandler
func interruptTIMER1() {
	callHandlers(IRQ_TIMER1)
}

//export TIMER2_IRQHandler
func interruptTIMER2() {
	callHandlers(IRQ_TIMER2)
}

//export RTC0_IRQHandler
func interruptRTC0() {
	callHandlers(IRQ_RTC0)
}

//export RTC1_IRQHandler
func interruptRTC1() {
	callHandlers(IRQ_RTC1)
}

//export WDT0_IRQHandler
func interruptWDT0() {
	callHandlers(IRQ_WDT0)
}

//export WDT1_IRQHandler
func interruptWDT1() {
	callHandlers(IRQ_WDT1)
}

//export COMP_LPCOMP_IRQHandler
func interruptCOMP_LPCOMP() {
	callHandlers(IRQ_COMP_LPCOMP)
}

//export EGU0_IRQHandler
func interruptEGU0() {
	callHandlers(IRQ_EGU0)
}

//export EGU1_IRQHandler
func interruptEGU1() {
	callHandlers(IRQ_EGU1)
}

//export EGU2_IRQHandler
func interruptEGU2() {
	callHandlers(IRQ_EGU2)
}

//export EGU3_IRQHandler
func interruptEGU3() {
	callHandlers(IRQ_EGU3)
}

//export EGU4_IRQHandler
func interruptEGU4() {
	callHandlers(IRQ_EGU4)
}

//export EGU5_IRQHandler
func interruptEGU5() {
	callHandlers(IRQ_EGU5)
}

//export PWM0_IRQHandler
func interruptPWM0() {
	callHandlers(IRQ_PWM0)
}

//export PWM1_IRQHandler
func interruptPWM1() {
	callHandlers(IRQ_PWM1)
}

//export PWM2_IRQHandler
func interruptPWM2() {
	callHandlers(IRQ_PWM2)
}

//export PWM3_IRQHandler
func interruptPWM3() {
	callHandlers(IRQ_PWM3)
}

//export PDM0_IRQHandler
func interruptPDM0() {
	callHandlers(IRQ_PDM0)
}

//export I2S0_IRQHandler
func interruptI2S0() {
	callHandlers(IRQ_I2S0)
}

//export IPC_IRQHandler
func interruptIPC() {
	callHandlers(IRQ_IPC)
}

//export QSPI_IRQHandler
func interruptQSPI() {
	callHandlers(IRQ_QSPI)
}

//export NFCT_IRQHandler
func interruptNFCT() {
	callHandlers(IRQ_NFCT)
}

//export GPIOTE1_IRQHandler
func interruptGPIOTE1() {
	callHandlers(IRQ_GPIOTE1)
}

//export QDEC0_IRQHandler
func interruptQDEC0() {
	callHandlers(IRQ_QDEC0)
}

//export QDEC1_IRQHandler
func interruptQDEC1() {
	callHandlers(IRQ_QDEC1)
}

//export USBD_IRQHandler
func interruptUSBD() {
	callHandlers(IRQ_USBD)
}

//export USBREGULATOR_IRQHandler
func interruptUSBREGULATOR() {
	callHandlers(IRQ_USBREGULATOR)
}

//export KMU_IRQHandler
func interruptKMU() {
	callHandlers(IRQ_KMU)
}

//export CRYPTOCELL_IRQHandler
func interruptCRYPTOCELL() {
	callHandlers(IRQ_CRYPTOCELL)
}

// Peripherals.
var (
	// CACHEDATA
	CACHEDATA_S = (*CACHEDATA_Type)(unsafe.Pointer(uintptr(0xf00000)))

	// CACHEINFO
	CACHEINFO_S = (*CACHEINFO_Type)(unsafe.Pointer(uintptr(0xf08000)))

	// Factory Information Configuration Registers
	FICR_S = (*FICR_Type)(unsafe.Pointer(uintptr(0xff0000)))

	// User Information Configuration Registers User information configuration registers
	UICR_S = (*UICR_Type)(unsafe.Pointer(uintptr(0xff8000)))

	// Cross-Trigger Interface control. NOTE: this is not a separate peripheral, but describes CM33 functionality.
	CTI_S = (*CTI_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// Trace and debug control
	TAD_S = (*TAD_Type)(unsafe.Pointer(uintptr(0xe0080000)))

	// Domain configuration management 0
	DCNF_NS = (*DCNF_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// FPU control peripheral 0
	FPU_NS = (*FPU_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Cache
	CACHE_S = (*CACHE_Type)(unsafe.Pointer(uintptr(0x50001000)))

	// System protection unit
	SPU_S = (*SPU_Type)(unsafe.Pointer(uintptr(0x50003000)))

	// Oscillator control 0
	OSCILLATORS_NS = (*OSCILLATORS_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Voltage regulators 0
	REGULATORS_NS = (*REGULATORS_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Clock management 0
	CLOCK_NS = (*CLOCK_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Power control 0
	POWER_NS = (*POWER_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Reset control 0
	RESET_NS = (*RESET_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Control access port 0
	CTRLAP_NS = (*CTRLAPPERI_Type)(unsafe.Pointer(uintptr(0x40006000)))

	// Serial Peripheral Interface Master with EasyDMA 0
	SPIM0_NS = (*SPIM_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// SPI Slave 0
	SPIS0_NS = (*SPIS_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 0
	TWIM0_NS = (*TWIM_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 0
	TWIS0_NS = (*TWIS_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// UART with EasyDMA 0
	UARTE0_NS = (*UARTE_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// GPIO Tasks and Events 0
	GPIOTE0_S = (*GPIOTE_Type)(unsafe.Pointer(uintptr(0x5000d000)))

	// Analog to Digital Converter 0
	SAADC_NS = (*SAADC_Type)(unsafe.Pointer(uintptr(0x4000e000)))

	// Timer/Counter 0
	TIMER0_NS = (*TIMER_Type)(unsafe.Pointer(uintptr(0x4000f000)))

	// Real-time counter 0
	RTC0_NS = (*RTC_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// Distributed programmable peripheral interconnect controller 0
	DPPIC_NS = (*DPPIC_Type)(unsafe.Pointer(uintptr(0x40017000)))

	// Watchdog Timer 0
	WDT0_NS = (*WDT_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// Comparator 0
	COMP_NS = (*COMP_Type)(unsafe.Pointer(uintptr(0x4001a000)))

	// Low-power comparator 0
	LPCOMP_NS = (*LPCOMP_Type)(unsafe.Pointer(uintptr(0x4001a000)))

	// Event generator unit 0
	EGU0_NS = (*EGU_Type)(unsafe.Pointer(uintptr(0x4001b000)))

	// Pulse width modulation unit 0
	PWM0_NS = (*PWM_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// Pulse Density Modulation (Digital Microphone) Interface 0
	PDM0_NS = (*PDM_Type)(unsafe.Pointer(uintptr(0x40026000)))

	// Inter-IC Sound 0
	I2S0_NS = (*I2S_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// Interprocessor communication 0
	IPC_NS = (*IPC_Type)(unsafe.Pointer(uintptr(0x4002a000)))

	// External flash interface 0
	QSPI_NS = (*QSPI_Type)(unsafe.Pointer(uintptr(0x4002b000)))

	// NFC-A compatible radio 0
	NFCT_NS = (*NFCT_Type)(unsafe.Pointer(uintptr(0x4002d000)))

	// MUTEX 0
	MUTEX_NS = (*MUTEX_Type)(unsafe.Pointer(uintptr(0x40030000)))

	// Quadrature Decoder 0
	QDEC0_NS = (*QDEC_Type)(unsafe.Pointer(uintptr(0x40033000)))

	// Universal serial bus device 0
	USBD_NS = (*USBD_Type)(unsafe.Pointer(uintptr(0x40036000)))

	// USB Regulator 0
	USBREGULATOR_NS = (*USBREG_Type)(unsafe.Pointer(uintptr(0x40037000)))

	// Key management unit 0
	KMU_NS = (*KMU_Type)(unsafe.Pointer(uintptr(0x40039000)))

	// Non-volatile memory controller 0
	NVMC_NS = (*NVMC_Type)(unsafe.Pointer(uintptr(0x40039000)))

	// GPIO Port 0
	P0_NS = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40842500)))

	// ARM TrustZone CryptoCell register interface
	CRYPTOCELL_S = (*CRYPTOCELL_Type)(unsafe.Pointer(uintptr(0x50844000)))

	// Volatile Memory controller 0
	VMC_NS = (*VMC_Type)(unsafe.Pointer(uintptr(0x40081000)))

	// Domain configuration management 1
	DCNF_S = (*DCNF_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// FPU control peripheral 1
	FPU_S = (*FPU_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// Oscillator control 1
	OSCILLATORS_S = (*OSCILLATORS_Type)(unsafe.Pointer(uintptr(0x50004000)))

	// Voltage regulators 1
	REGULATORS_S = (*REGULATORS_Type)(unsafe.Pointer(uintptr(0x50004000)))

	// Clock management 1
	CLOCK_S = (*CLOCK_Type)(unsafe.Pointer(uintptr(0x50005000)))

	// Power control 1
	POWER_S = (*POWER_Type)(unsafe.Pointer(uintptr(0x50005000)))

	// Reset control 1
	RESET_S = (*RESET_Type)(unsafe.Pointer(uintptr(0x50005000)))

	// Control access port 1
	CTRLAP_S = (*CTRLAPPERI_Type)(unsafe.Pointer(uintptr(0x50006000)))

	// Serial Peripheral Interface Master with EasyDMA 1
	SPIM0_S = (*SPIM_Type)(unsafe.Pointer(uintptr(0x50008000)))

	// SPI Slave 1
	SPIS0_S = (*SPIS_Type)(unsafe.Pointer(uintptr(0x50008000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 1
	TWIM0_S = (*TWIM_Type)(unsafe.Pointer(uintptr(0x50008000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 1
	TWIS0_S = (*TWIS_Type)(unsafe.Pointer(uintptr(0x50008000)))

	// UART with EasyDMA 1
	UARTE0_S = (*UARTE_Type)(unsafe.Pointer(uintptr(0x50008000)))

	// Serial Peripheral Interface Master with EasyDMA 2
	SPIM1_NS = (*SPIM_Type)(unsafe.Pointer(uintptr(0x40009000)))

	// SPI Slave 2
	SPIS1_NS = (*SPIS_Type)(unsafe.Pointer(uintptr(0x40009000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 2
	TWIM1_NS = (*TWIM_Type)(unsafe.Pointer(uintptr(0x40009000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 2
	TWIS1_NS = (*TWIS_Type)(unsafe.Pointer(uintptr(0x40009000)))

	// UART with EasyDMA 2
	UARTE1_NS = (*UARTE_Type)(unsafe.Pointer(uintptr(0x40009000)))

	// Serial Peripheral Interface Master with EasyDMA 3
	SPIM1_S = (*SPIM_Type)(unsafe.Pointer(uintptr(0x50009000)))

	// SPI Slave 3
	SPIS1_S = (*SPIS_Type)(unsafe.Pointer(uintptr(0x50009000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 3
	TWIM1_S = (*TWIM_Type)(unsafe.Pointer(uintptr(0x50009000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 3
	TWIS1_S = (*TWIS_Type)(unsafe.Pointer(uintptr(0x50009000)))

	// UART with EasyDMA 3
	UARTE1_S = (*UARTE_Type)(unsafe.Pointer(uintptr(0x50009000)))

	// Serial Peripheral Interface Master with EasyDMA 4
	SPIM4_NS = (*SPIM_Type)(unsafe.Pointer(uintptr(0x4000a000)))

	// Serial Peripheral Interface Master with EasyDMA 5
	SPIM4_S = (*SPIM_Type)(unsafe.Pointer(uintptr(0x5000a000)))

	// Serial Peripheral Interface Master with EasyDMA 6
	SPIM2_NS = (*SPIM_Type)(unsafe.Pointer(uintptr(0x4000b000)))

	// SPI Slave 4
	SPIS2_NS = (*SPIS_Type)(unsafe.Pointer(uintptr(0x4000b000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 4
	TWIM2_NS = (*TWIM_Type)(unsafe.Pointer(uintptr(0x4000b000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 4
	TWIS2_NS = (*TWIS_Type)(unsafe.Pointer(uintptr(0x4000b000)))

	// UART with EasyDMA 4
	UARTE2_NS = (*UARTE_Type)(unsafe.Pointer(uintptr(0x4000b000)))

	// Serial Peripheral Interface Master with EasyDMA 7
	SPIM2_S = (*SPIM_Type)(unsafe.Pointer(uintptr(0x5000b000)))

	// SPI Slave 5
	SPIS2_S = (*SPIS_Type)(unsafe.Pointer(uintptr(0x5000b000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 5
	TWIM2_S = (*TWIM_Type)(unsafe.Pointer(uintptr(0x5000b000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 5
	TWIS2_S = (*TWIS_Type)(unsafe.Pointer(uintptr(0x5000b000)))

	// UART with EasyDMA 5
	UARTE2_S = (*UARTE_Type)(unsafe.Pointer(uintptr(0x5000b000)))

	// Serial Peripheral Interface Master with EasyDMA 8
	SPIM3_NS = (*SPIM_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// SPI Slave 6
	SPIS3_NS = (*SPIS_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 6
	TWIM3_NS = (*TWIM_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 6
	TWIS3_NS = (*TWIS_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// UART with EasyDMA 6
	UARTE3_NS = (*UARTE_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// Serial Peripheral Interface Master with EasyDMA 9
	SPIM3_S = (*SPIM_Type)(unsafe.Pointer(uintptr(0x5000c000)))

	// SPI Slave 7
	SPIS3_S = (*SPIS_Type)(unsafe.Pointer(uintptr(0x5000c000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 7
	TWIM3_S = (*TWIM_Type)(unsafe.Pointer(uintptr(0x5000c000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 7
	TWIS3_S = (*TWIS_Type)(unsafe.Pointer(uintptr(0x5000c000)))

	// UART with EasyDMA 7
	UARTE3_S = (*UARTE_Type)(unsafe.Pointer(uintptr(0x5000c000)))

	// Analog to Digital Converter 1
	SAADC_S = (*SAADC_Type)(unsafe.Pointer(uintptr(0x5000e000)))

	// Timer/Counter 1
	TIMER0_S = (*TIMER_Type)(unsafe.Pointer(uintptr(0x5000f000)))

	// Timer/Counter 2
	TIMER1_NS = (*TIMER_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Timer/Counter 3
	TIMER1_S = (*TIMER_Type)(unsafe.Pointer(uintptr(0x50010000)))

	// Timer/Counter 4
	TIMER2_NS = (*TIMER_Type)(unsafe.Pointer(uintptr(0x40011000)))

	// Timer/Counter 5
	TIMER2_S = (*TIMER_Type)(unsafe.Pointer(uintptr(0x50011000)))

	// Real-time counter 1
	RTC0_S = (*RTC_Type)(unsafe.Pointer(uintptr(0x50014000)))

	// Real-time counter 2
	RTC1_NS = (*RTC_Type)(unsafe.Pointer(uintptr(0x40015000)))

	// Real-time counter 3
	RTC1_S = (*RTC_Type)(unsafe.Pointer(uintptr(0x50015000)))

	// Distributed programmable peripheral interconnect controller 1
	DPPIC_S = (*DPPIC_Type)(unsafe.Pointer(uintptr(0x50017000)))

	// Watchdog Timer 1
	WDT0_S = (*WDT_Type)(unsafe.Pointer(uintptr(0x50018000)))

	// Watchdog Timer 2
	WDT1_NS = (*WDT_Type)(unsafe.Pointer(uintptr(0x40019000)))

	// Watchdog Timer 3
	WDT1_S = (*WDT_Type)(unsafe.Pointer(uintptr(0x50019000)))

	// Comparator 1
	COMP_S = (*COMP_Type)(unsafe.Pointer(uintptr(0x5001a000)))

	// Low-power comparator 1
	LPCOMP_S = (*LPCOMP_Type)(unsafe.Pointer(uintptr(0x5001a000)))

	// Event generator unit 1
	EGU0_S = (*EGU_Type)(unsafe.Pointer(uintptr(0x5001b000)))

	// Event generator unit 2
	EGU1_NS = (*EGU_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// Event generator unit 3
	EGU1_S = (*EGU_Type)(unsafe.Pointer(uintptr(0x5001c000)))

	// Event generator unit 4
	EGU2_NS = (*EGU_Type)(unsafe.Pointer(uintptr(0x4001d000)))

	// Event generator unit 5
	EGU2_S = (*EGU_Type)(unsafe.Pointer(uintptr(0x5001d000)))

	// Event generator unit 6
	EGU3_NS = (*EGU_Type)(unsafe.Pointer(uintptr(0x4001e000)))

	// Event generator unit 7
	EGU3_S = (*EGU_Type)(unsafe.Pointer(uintptr(0x5001e000)))

	// Event generator unit 8
	EGU4_NS = (*EGU_Type)(unsafe.Pointer(uintptr(0x4001f000)))

	// Event generator unit 9
	EGU4_S = (*EGU_Type)(unsafe.Pointer(uintptr(0x5001f000)))

	// Event generator unit 10
	EGU5_NS = (*EGU_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Event generator unit 11
	EGU5_S = (*EGU_Type)(unsafe.Pointer(uintptr(0x50020000)))

	// Pulse width modulation unit 1
	PWM0_S = (*PWM_Type)(unsafe.Pointer(uintptr(0x50021000)))

	// Pulse width modulation unit 2
	PWM1_NS = (*PWM_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// Pulse width modulation unit 3
	PWM1_S = (*PWM_Type)(unsafe.Pointer(uintptr(0x50022000)))

	// Pulse width modulation unit 4
	PWM2_NS = (*PWM_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Pulse width modulation unit 5
	PWM2_S = (*PWM_Type)(unsafe.Pointer(uintptr(0x50023000)))

	// Pulse width modulation unit 6
	PWM3_NS = (*PWM_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// Pulse width modulation unit 7
	PWM3_S = (*PWM_Type)(unsafe.Pointer(uintptr(0x50024000)))

	// Pulse Density Modulation (Digital Microphone) Interface 1
	PDM0_S = (*PDM_Type)(unsafe.Pointer(uintptr(0x50026000)))

	// Inter-IC Sound 1
	I2S0_S = (*I2S_Type)(unsafe.Pointer(uintptr(0x50028000)))

	// Interprocessor communication 1
	IPC_S = (*IPC_Type)(unsafe.Pointer(uintptr(0x5002a000)))

	// External flash interface 1
	QSPI_S = (*QSPI_Type)(unsafe.Pointer(uintptr(0x5002b000)))

	// NFC-A compatible radio 1
	NFCT_S = (*NFCT_Type)(unsafe.Pointer(uintptr(0x5002d000)))

	// GPIO Tasks and Events 1
	GPIOTE1_NS = (*GPIOTE_Type)(unsafe.Pointer(uintptr(0x4002f000)))

	// MUTEX 1
	MUTEX_S = (*MUTEX_Type)(unsafe.Pointer(uintptr(0x50030000)))

	// Quadrature Decoder 1
	QDEC0_S = (*QDEC_Type)(unsafe.Pointer(uintptr(0x50033000)))

	// Quadrature Decoder 2
	QDEC1_NS = (*QDEC_Type)(unsafe.Pointer(uintptr(0x40034000)))

	// Quadrature Decoder 3
	QDEC1_S = (*QDEC_Type)(unsafe.Pointer(uintptr(0x50034000)))

	// Universal serial bus device 1
	USBD_S = (*USBD_Type)(unsafe.Pointer(uintptr(0x50036000)))

	// USB Regulator 1
	USBREGULATOR_S = (*USBREG_Type)(unsafe.Pointer(uintptr(0x50037000)))

	// Key management unit 1
	KMU_S = (*KMU_Type)(unsafe.Pointer(uintptr(0x50039000)))

	// Non-volatile memory controller 1
	NVMC_S = (*NVMC_Type)(unsafe.Pointer(uintptr(0x50039000)))

	// GPIO Port 1
	P1_NS = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40842800)))

	// GPIO Port 2
	P0_S = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50842500)))

	// GPIO Port 3
	P1_S = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50842800)))

	// Volatile Memory controller 1
	VMC_S = (*VMC_Type)(unsafe.Pointer(uintptr(0x50081000)))
)

// CACHEDATA
type CACHEDATA_Type struct {
	SET [256]CACHEDATA_SET_Type // 0x0
}

// CACHEINFO
type CACHEINFO_Type struct {
	SET [256]CACHEINFO_SET_Type // 0x0
}

type CACHEINFO_SET_Type struct {
	WAY [2]volatile.Register32 // 0x0
}

// Factory Information Configuration Registers
type FICR_Type struct {
	_           [512]byte
	INFO        FICR_INFO_Type // 0x200
	_           [212]byte
	TRIMCNF     [32]FICR_TRIMCNF_Type // 0x300
	_           [80]byte
	NFC         FICR_NFC_Type // 0x450
	_           [1952]byte
	TRNG90B     FICR_TRNG90B_Type   // 0xC00
	XOSC32MTRIM volatile.Register32 // 0xC20
}

// FICR.XOSC32MTRIM: XOSC32M capacitor selection trim values
func (o *FICR_Type) SetXOSC32MTRIM_SLOPE(value uint32) {
	volatile.StoreUint32(&o.XOSC32MTRIM.Reg, volatile.LoadUint32(&o.XOSC32MTRIM.Reg)&^(0x1f)|value)
}
func (o *FICR_Type) GetXOSC32MTRIM_SLOPE() uint32 {
	return volatile.LoadUint32(&o.XOSC32MTRIM.Reg) & 0x1f
}
func (o *FICR_Type) SetXOSC32MTRIM_OFFSET(value uint32) {
	volatile.StoreUint32(&o.XOSC32MTRIM.Reg, volatile.LoadUint32(&o.XOSC32MTRIM.Reg)&^(0x3e0)|value<<5)
}
func (o *FICR_Type) GetXOSC32MTRIM_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.XOSC32MTRIM.Reg) & 0x3e0) >> 5
}

type FICR_INFO_Type struct {
	CONFIGID     volatile.Register32    // 0x200
	DEVICEID     [2]volatile.Register32 // 0x204
	PART         volatile.Register32    // 0x20C
	VARIANT      volatile.Register32    // 0x210
	PACKAGE      volatile.Register32    // 0x214
	RAM          volatile.Register32    // 0x218
	FLASH        volatile.Register32    // 0x21C
	CODEPAGESIZE volatile.Register32    // 0x220
	CODESIZE     volatile.Register32    // 0x224
	DEVICETYPE   volatile.Register32    // 0x228
}

// FICR_INFO.CONFIGID: Configuration identifier
func (o *FICR_INFO_Type) SetCONFIGID_HWID(value uint32) {
	volatile.StoreUint32(&o.CONFIGID.Reg, volatile.LoadUint32(&o.CONFIGID.Reg)&^(0xffff)|value)
}
func (o *FICR_INFO_Type) GetCONFIGID_HWID() uint32 {
	return volatile.LoadUint32(&o.CONFIGID.Reg) & 0xffff
}

// FICR_INFO.PART: Part code
func (o *FICR_INFO_Type) SetPART(value uint32) {
	volatile.StoreUint32(&o.PART.Reg, value)
}
func (o *FICR_INFO_Type) GetPART() uint32 {
	return volatile.LoadUint32(&o.PART.Reg)
}

// FICR_INFO.VARIANT: Part Variant, Hardware version and Production configuration
func (o *FICR_INFO_Type) SetVARIANT(value uint32) {
	volatile.StoreUint32(&o.VARIANT.Reg, value)
}
func (o *FICR_INFO_Type) GetVARIANT() uint32 {
	return volatile.LoadUint32(&o.VARIANT.Reg)
}

// FICR_INFO.PACKAGE: Package option
func (o *FICR_INFO_Type) SetPACKAGE(value uint32) {
	volatile.StoreUint32(&o.PACKAGE.Reg, value)
}
func (o *FICR_INFO_Type) GetPACKAGE() uint32 {
	return volatile.LoadUint32(&o.PACKAGE.Reg)
}

// FICR_INFO.RAM: RAM variant
func (o *FICR_INFO_Type) SetRAM(value uint32) {
	volatile.StoreUint32(&o.RAM.Reg, value)
}
func (o *FICR_INFO_Type) GetRAM() uint32 {
	return volatile.LoadUint32(&o.RAM.Reg)
}

// FICR_INFO.FLASH: Flash variant
func (o *FICR_INFO_Type) SetFLASH(value uint32) {
	volatile.StoreUint32(&o.FLASH.Reg, value)
}
func (o *FICR_INFO_Type) GetFLASH() uint32 {
	return volatile.LoadUint32(&o.FLASH.Reg)
}

// FICR_INFO.CODEPAGESIZE: Code memory page size in bytes
func (o *FICR_INFO_Type) SetCODEPAGESIZE(value uint32) {
	volatile.StoreUint32(&o.CODEPAGESIZE.Reg, value)
}
func (o *FICR_INFO_Type) GetCODEPAGESIZE() uint32 {
	return volatile.LoadUint32(&o.CODEPAGESIZE.Reg)
}

// FICR_INFO.CODESIZE: Code memory size
func (o *FICR_INFO_Type) SetCODESIZE(value uint32) {
	volatile.StoreUint32(&o.CODESIZE.Reg, value)
}
func (o *FICR_INFO_Type) GetCODESIZE() uint32 {
	return volatile.LoadUint32(&o.CODESIZE.Reg)
}

// FICR_INFO.DEVICETYPE: Device type
func (o *FICR_INFO_Type) SetDEVICETYPE(value uint32) {
	volatile.StoreUint32(&o.DEVICETYPE.Reg, value)
}
func (o *FICR_INFO_Type) GetDEVICETYPE() uint32 {
	return volatile.LoadUint32(&o.DEVICETYPE.Reg)
}

type FICR_TRIMCNF_Type struct {
	ADDR volatile.Register32 // 0x300
	DATA volatile.Register32 // 0x304
}

// FICR_TRIMCNF.ADDR: Description cluster: Address of the PAR register which will be written
func (o *FICR_TRIMCNF_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, value)
}
func (o *FICR_TRIMCNF_Type) GetADDR() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg)
}

// FICR_TRIMCNF.DATA: Description cluster: Data
func (o *FICR_TRIMCNF_Type) SetDATA(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, value)
}
func (o *FICR_TRIMCNF_Type) GetDATA() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg)
}

type FICR_NFC_Type struct {
	TAGHEADER0 volatile.Register32 // 0x450
	TAGHEADER1 volatile.Register32 // 0x454
	TAGHEADER2 volatile.Register32 // 0x458
	TAGHEADER3 volatile.Register32 // 0x45C
}

// FICR_NFC.TAGHEADER0: Default header for NFC Tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST and NFCID1_LAST.
func (o *FICR_NFC_Type) SetTAGHEADER0_MFGID(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER0.Reg, volatile.LoadUint32(&o.TAGHEADER0.Reg)&^(0xff)|value)
}
func (o *FICR_NFC_Type) GetTAGHEADER0_MFGID() uint32 {
	return volatile.LoadUint32(&o.TAGHEADER0.Reg) & 0xff
}
func (o *FICR_NFC_Type) SetTAGHEADER0_UD1(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER0.Reg, volatile.LoadUint32(&o.TAGHEADER0.Reg)&^(0xff00)|value<<8)
}
func (o *FICR_NFC_Type) GetTAGHEADER0_UD1() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER0.Reg) & 0xff00) >> 8
}
func (o *FICR_NFC_Type) SetTAGHEADER0_UD2(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER0.Reg, volatile.LoadUint32(&o.TAGHEADER0.Reg)&^(0xff0000)|value<<16)
}
func (o *FICR_NFC_Type) GetTAGHEADER0_UD2() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER0.Reg) & 0xff0000) >> 16
}
func (o *FICR_NFC_Type) SetTAGHEADER0_UD3(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER0.Reg, volatile.LoadUint32(&o.TAGHEADER0.Reg)&^(0xff000000)|value<<24)
}
func (o *FICR_NFC_Type) GetTAGHEADER0_UD3() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER0.Reg) & 0xff000000) >> 24
}

// FICR_NFC.TAGHEADER1: Default header for NFC Tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST and NFCID1_LAST.
func (o *FICR_NFC_Type) SetTAGHEADER1_UD4(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER1.Reg, volatile.LoadUint32(&o.TAGHEADER1.Reg)&^(0xff)|value)
}
func (o *FICR_NFC_Type) GetTAGHEADER1_UD4() uint32 {
	return volatile.LoadUint32(&o.TAGHEADER1.Reg) & 0xff
}
func (o *FICR_NFC_Type) SetTAGHEADER1_UD5(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER1.Reg, volatile.LoadUint32(&o.TAGHEADER1.Reg)&^(0xff00)|value<<8)
}
func (o *FICR_NFC_Type) GetTAGHEADER1_UD5() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER1.Reg) & 0xff00) >> 8
}
func (o *FICR_NFC_Type) SetTAGHEADER1_UD6(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER1.Reg, volatile.LoadUint32(&o.TAGHEADER1.Reg)&^(0xff0000)|value<<16)
}
func (o *FICR_NFC_Type) GetTAGHEADER1_UD6() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER1.Reg) & 0xff0000) >> 16
}
func (o *FICR_NFC_Type) SetTAGHEADER1_UD7(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER1.Reg, volatile.LoadUint32(&o.TAGHEADER1.Reg)&^(0xff000000)|value<<24)
}
func (o *FICR_NFC_Type) GetTAGHEADER1_UD7() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER1.Reg) & 0xff000000) >> 24
}

// FICR_NFC.TAGHEADER2: Default header for NFC Tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST and NFCID1_LAST.
func (o *FICR_NFC_Type) SetTAGHEADER2_UD8(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER2.Reg, volatile.LoadUint32(&o.TAGHEADER2.Reg)&^(0xff)|value)
}
func (o *FICR_NFC_Type) GetTAGHEADER2_UD8() uint32 {
	return volatile.LoadUint32(&o.TAGHEADER2.Reg) & 0xff
}
func (o *FICR_NFC_Type) SetTAGHEADER2_UD9(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER2.Reg, volatile.LoadUint32(&o.TAGHEADER2.Reg)&^(0xff00)|value<<8)
}
func (o *FICR_NFC_Type) GetTAGHEADER2_UD9() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER2.Reg) & 0xff00) >> 8
}
func (o *FICR_NFC_Type) SetTAGHEADER2_UD10(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER2.Reg, volatile.LoadUint32(&o.TAGHEADER2.Reg)&^(0xff0000)|value<<16)
}
func (o *FICR_NFC_Type) GetTAGHEADER2_UD10() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER2.Reg) & 0xff0000) >> 16
}
func (o *FICR_NFC_Type) SetTAGHEADER2_UD11(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER2.Reg, volatile.LoadUint32(&o.TAGHEADER2.Reg)&^(0xff000000)|value<<24)
}
func (o *FICR_NFC_Type) GetTAGHEADER2_UD11() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER2.Reg) & 0xff000000) >> 24
}

// FICR_NFC.TAGHEADER3: Default header for NFC Tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST and NFCID1_LAST.
func (o *FICR_NFC_Type) SetTAGHEADER3_UD12(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER3.Reg, volatile.LoadUint32(&o.TAGHEADER3.Reg)&^(0xff)|value)
}
func (o *FICR_NFC_Type) GetTAGHEADER3_UD12() uint32 {
	return volatile.LoadUint32(&o.TAGHEADER3.Reg) & 0xff
}
func (o *FICR_NFC_Type) SetTAGHEADER3_UD13(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER3.Reg, volatile.LoadUint32(&o.TAGHEADER3.Reg)&^(0xff00)|value<<8)
}
func (o *FICR_NFC_Type) GetTAGHEADER3_UD13() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER3.Reg) & 0xff00) >> 8
}
func (o *FICR_NFC_Type) SetTAGHEADER3_UD14(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER3.Reg, volatile.LoadUint32(&o.TAGHEADER3.Reg)&^(0xff0000)|value<<16)
}
func (o *FICR_NFC_Type) GetTAGHEADER3_UD14() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER3.Reg) & 0xff0000) >> 16
}
func (o *FICR_NFC_Type) SetTAGHEADER3_UD15(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER3.Reg, volatile.LoadUint32(&o.TAGHEADER3.Reg)&^(0xff000000)|value<<24)
}
func (o *FICR_NFC_Type) GetTAGHEADER3_UD15() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER3.Reg) & 0xff000000) >> 24
}

type FICR_TRNG90B_Type struct {
	BYTES    volatile.Register32 // 0xC00
	RCCUTOFF volatile.Register32 // 0xC04
	APCUTOFF volatile.Register32 // 0xC08
	STARTUP  volatile.Register32 // 0xC0C
	ROSC1    volatile.Register32 // 0xC10
	ROSC2    volatile.Register32 // 0xC14
	ROSC3    volatile.Register32 // 0xC18
	ROSC4    volatile.Register32 // 0xC1C
}

// FICR_TRNG90B.BYTES: Amount of bytes for the required entropy bits
func (o *FICR_TRNG90B_Type) SetBYTES(value uint32) {
	volatile.StoreUint32(&o.BYTES.Reg, value)
}
func (o *FICR_TRNG90B_Type) GetBYTES() uint32 {
	return volatile.LoadUint32(&o.BYTES.Reg)
}

// FICR_TRNG90B.RCCUTOFF: Repetition counter cutoff
func (o *FICR_TRNG90B_Type) SetRCCUTOFF(value uint32) {
	volatile.StoreUint32(&o.RCCUTOFF.Reg, value)
}
func (o *FICR_TRNG90B_Type) GetRCCUTOFF() uint32 {
	return volatile.LoadUint32(&o.RCCUTOFF.Reg)
}

// FICR_TRNG90B.APCUTOFF: Adaptive proportion cutoff
func (o *FICR_TRNG90B_Type) SetAPCUTOFF(value uint32) {
	volatile.StoreUint32(&o.APCUTOFF.Reg, value)
}
func (o *FICR_TRNG90B_Type) GetAPCUTOFF() uint32 {
	return volatile.LoadUint32(&o.APCUTOFF.Reg)
}

// FICR_TRNG90B.STARTUP: Amount of bytes for the startup tests
func (o *FICR_TRNG90B_Type) SetSTARTUP(value uint32) {
	volatile.StoreUint32(&o.STARTUP.Reg, value)
}
func (o *FICR_TRNG90B_Type) GetSTARTUP() uint32 {
	return volatile.LoadUint32(&o.STARTUP.Reg)
}

// FICR_TRNG90B.ROSC1: Sample count for ring oscillator 1
func (o *FICR_TRNG90B_Type) SetROSC1(value uint32) {
	volatile.StoreUint32(&o.ROSC1.Reg, value)
}
func (o *FICR_TRNG90B_Type) GetROSC1() uint32 {
	return volatile.LoadUint32(&o.ROSC1.Reg)
}

// FICR_TRNG90B.ROSC2: Sample count for ring oscillator 2
func (o *FICR_TRNG90B_Type) SetROSC2(value uint32) {
	volatile.StoreUint32(&o.ROSC2.Reg, value)
}
func (o *FICR_TRNG90B_Type) GetROSC2() uint32 {
	return volatile.LoadUint32(&o.ROSC2.Reg)
}

// FICR_TRNG90B.ROSC3: Sample count for ring oscillator 3
func (o *FICR_TRNG90B_Type) SetROSC3(value uint32) {
	volatile.StoreUint32(&o.ROSC3.Reg, value)
}
func (o *FICR_TRNG90B_Type) GetROSC3() uint32 {
	return volatile.LoadUint32(&o.ROSC3.Reg)
}

// FICR_TRNG90B.ROSC4: Sample count for ring oscillator 4
func (o *FICR_TRNG90B_Type) SetROSC4(value uint32) {
	volatile.StoreUint32(&o.ROSC4.Reg, value)
}
func (o *FICR_TRNG90B_Type) GetROSC4() uint32 {
	return volatile.LoadUint32(&o.ROSC4.Reg)
}

// User Information Configuration Registers User information configuration registers
type UICR_Type struct {
	APPROTECT       volatile.Register32 // 0x0
	_               [8]byte
	EXTSUPPLY       volatile.Register32 // 0xC
	VREGHVOUT       volatile.Register32 // 0x10
	HFXOCNT         volatile.Register32 // 0x14
	_               [4]byte
	SECUREAPPROTECT volatile.Register32 // 0x1C
	ERASEPROTECT    volatile.Register32 // 0x20
	TINSTANCE       volatile.Register32 // 0x24
	NFCPINS         volatile.Register32 // 0x28
	_               [212]byte
	OTP             [192]volatile.Register32 // 0x100
	KEYSLOT         UICR_KEYSLOT_Type        // 0x400
}

// UICR.APPROTECT: Access port protection
func (o *UICR_Type) SetAPPROTECT(value uint32) {
	volatile.StoreUint32(&o.APPROTECT.Reg, value)
}
func (o *UICR_Type) GetAPPROTECT() uint32 {
	return volatile.LoadUint32(&o.APPROTECT.Reg)
}

// UICR.EXTSUPPLY: Enable external circuitry to be supplied from VDD pin. Applicable in 'High voltage mode' only.
func (o *UICR_Type) SetEXTSUPPLY(value uint32) {
	volatile.StoreUint32(&o.EXTSUPPLY.Reg, volatile.LoadUint32(&o.EXTSUPPLY.Reg)&^(0x1)|value)
}
func (o *UICR_Type) GetEXTSUPPLY() uint32 {
	return volatile.LoadUint32(&o.EXTSUPPLY.Reg) & 0x1
}

// UICR.VREGHVOUT: GPIO reference voltage / external output supply voltage in 'High voltage mode'.
func (o *UICR_Type) SetVREGHVOUT(value uint32) {
	volatile.StoreUint32(&o.VREGHVOUT.Reg, volatile.LoadUint32(&o.VREGHVOUT.Reg)&^(0x7)|value)
}
func (o *UICR_Type) GetVREGHVOUT() uint32 {
	return volatile.LoadUint32(&o.VREGHVOUT.Reg) & 0x7
}

// UICR.HFXOCNT: HFXO startup counter
func (o *UICR_Type) SetHFXOCNT(value uint32) {
	volatile.StoreUint32(&o.HFXOCNT.Reg, volatile.LoadUint32(&o.HFXOCNT.Reg)&^(0xff)|value)
}
func (o *UICR_Type) GetHFXOCNT() uint32 {
	return volatile.LoadUint32(&o.HFXOCNT.Reg) & 0xff
}

// UICR.SECUREAPPROTECT: Secure access port protection
func (o *UICR_Type) SetSECUREAPPROTECT(value uint32) {
	volatile.StoreUint32(&o.SECUREAPPROTECT.Reg, value)
}
func (o *UICR_Type) GetSECUREAPPROTECT() uint32 {
	return volatile.LoadUint32(&o.SECUREAPPROTECT.Reg)
}

// UICR.ERASEPROTECT: Erase protection
func (o *UICR_Type) SetERASEPROTECT(value uint32) {
	volatile.StoreUint32(&o.ERASEPROTECT.Reg, value)
}
func (o *UICR_Type) GetERASEPROTECT() uint32 {
	return volatile.LoadUint32(&o.ERASEPROTECT.Reg)
}

// UICR.TINSTANCE: SW-DP Target instance
func (o *UICR_Type) SetTINSTANCE(value uint32) {
	volatile.StoreUint32(&o.TINSTANCE.Reg, volatile.LoadUint32(&o.TINSTANCE.Reg)&^(0xf0000000)|value<<28)
}
func (o *UICR_Type) GetTINSTANCE() uint32 {
	return (volatile.LoadUint32(&o.TINSTANCE.Reg) & 0xf0000000) >> 28
}

// UICR.NFCPINS: Setting of pins dedicated to NFC functionality: NFC antenna or GPIO
func (o *UICR_Type) SetNFCPINS_PROTECT(value uint32) {
	volatile.StoreUint32(&o.NFCPINS.Reg, volatile.LoadUint32(&o.NFCPINS.Reg)&^(0x1)|value)
}
func (o *UICR_Type) GetNFCPINS_PROTECT() uint32 {
	return volatile.LoadUint32(&o.NFCPINS.Reg) & 0x1
}

// UICR.OTP: Description collection: One time programmable memory
func (o *UICR_Type) SetOTP_LOWER(idx int, value uint32) {
	volatile.StoreUint32(&o.OTP[idx].Reg, volatile.LoadUint32(&o.OTP[idx].Reg)&^(0xffff)|value)
}
func (o *UICR_Type) GetOTP_LOWER(idx int) uint32 {
	return volatile.LoadUint32(&o.OTP[idx].Reg) & 0xffff
}
func (o *UICR_Type) SetOTP_UPPER(idx int, value uint32) {
	volatile.StoreUint32(&o.OTP[idx].Reg, volatile.LoadUint32(&o.OTP[idx].Reg)&^(0xffff0000)|value<<16)
}
func (o *UICR_Type) GetOTP_UPPER(idx int) uint32 {
	return (volatile.LoadUint32(&o.OTP[idx].Reg) & 0xffff0000) >> 16
}

// Cross-Trigger Interface control. NOTE: this is not a separate peripheral, but describes CM33 functionality.
type CTI_Type struct {
	CTICONTROL       volatile.Register32 // 0x0
	_                [12]byte
	CTIINTACK        volatile.Register32    // 0x10
	CTIAPPSET        volatile.Register32    // 0x14
	CTIAPPCLEAR      volatile.Register32    // 0x18
	CTIAPPPULSE      volatile.Register32    // 0x1C
	CTIINEN          [8]volatile.Register32 // 0x20
	_                [96]byte
	CTIOUTEN         [8]volatile.Register32 // 0xA0
	_                [112]byte
	CTITRIGINSTATUS  volatile.Register32 // 0x130
	CTITRIGOUTSTATUS volatile.Register32 // 0x134
	CTICHINSTATUS    volatile.Register32 // 0x138
	_                [4]byte
	CTIGATE          volatile.Register32 // 0x140
	_                [3704]byte
	DEVARCH          volatile.Register32 // 0xFBC
	_                [8]byte
	DEVID            volatile.Register32 // 0xFC8
	DEVTYPE          volatile.Register32 // 0xFCC
	PIDR4            volatile.Register32 // 0xFD0
	PIDR5            volatile.Register32 // 0xFD4
	PIDR6            volatile.Register32 // 0xFD8
	PIDR7            volatile.Register32 // 0xFDC
	PIDR0            volatile.Register32 // 0xFE0
	PIDR1            volatile.Register32 // 0xFE4
	PIDR2            volatile.Register32 // 0xFE8
	PIDR3            volatile.Register32 // 0xFEC
	CIDR0            volatile.Register32 // 0xFF0
	CIDR1            volatile.Register32 // 0xFF4
	CIDR2            volatile.Register32 // 0xFF8
	CIDR3            volatile.Register32 // 0xFFC
}

// CTI.CTICONTROL: CTI Control register
func (o *CTI_Type) SetCTICONTROL_GLBEN(value uint32) {
	volatile.StoreUint32(&o.CTICONTROL.Reg, volatile.LoadUint32(&o.CTICONTROL.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTICONTROL_GLBEN() uint32 {
	return volatile.LoadUint32(&o.CTICONTROL.Reg) & 0x1
}

// CTI.CTIINTACK: CTI Interrupt Acknowledge register
func (o *CTI_Type) SetCTIINTACK_DEBUGREQ(value uint32) {
	volatile.StoreUint32(&o.CTIINTACK.Reg, volatile.LoadUint32(&o.CTIINTACK.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTIINTACK_DEBUGREQ() uint32 {
	return volatile.LoadUint32(&o.CTIINTACK.Reg) & 0x1
}
func (o *CTI_Type) SetCTIINTACK_CPURESTART(value uint32) {
	volatile.StoreUint32(&o.CTIINTACK.Reg, volatile.LoadUint32(&o.CTIINTACK.Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTIINTACK_CPURESTART() uint32 {
	return (volatile.LoadUint32(&o.CTIINTACK.Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTIINTACK_UNUSED0(value uint32) {
	volatile.StoreUint32(&o.CTIINTACK.Reg, volatile.LoadUint32(&o.CTIINTACK.Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTIINTACK_UNUSED0() uint32 {
	return (volatile.LoadUint32(&o.CTIINTACK.Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTIINTACK_UNUSED1(value uint32) {
	volatile.StoreUint32(&o.CTIINTACK.Reg, volatile.LoadUint32(&o.CTIINTACK.Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTIINTACK_UNUSED1() uint32 {
	return (volatile.LoadUint32(&o.CTIINTACK.Reg) & 0x8) >> 3
}
func (o *CTI_Type) SetCTIINTACK_ETMEVTIN0(value uint32) {
	volatile.StoreUint32(&o.CTIINTACK.Reg, volatile.LoadUint32(&o.CTIINTACK.Reg)&^(0x10)|value<<4)
}
func (o *CTI_Type) GetCTIINTACK_ETMEVTIN0() uint32 {
	return (volatile.LoadUint32(&o.CTIINTACK.Reg) & 0x10) >> 4
}
func (o *CTI_Type) SetCTIINTACK_ETMEVTIN1(value uint32) {
	volatile.StoreUint32(&o.CTIINTACK.Reg, volatile.LoadUint32(&o.CTIINTACK.Reg)&^(0x20)|value<<5)
}
func (o *CTI_Type) GetCTIINTACK_ETMEVTIN1() uint32 {
	return (volatile.LoadUint32(&o.CTIINTACK.Reg) & 0x20) >> 5
}
func (o *CTI_Type) SetCTIINTACK_ETMEVTIN2(value uint32) {
	volatile.StoreUint32(&o.CTIINTACK.Reg, volatile.LoadUint32(&o.CTIINTACK.Reg)&^(0x40)|value<<6)
}
func (o *CTI_Type) GetCTIINTACK_ETMEVTIN2() uint32 {
	return (volatile.LoadUint32(&o.CTIINTACK.Reg) & 0x40) >> 6
}
func (o *CTI_Type) SetCTIINTACK_ETMEVTIN3(value uint32) {
	volatile.StoreUint32(&o.CTIINTACK.Reg, volatile.LoadUint32(&o.CTIINTACK.Reg)&^(0x80)|value<<7)
}
func (o *CTI_Type) GetCTIINTACK_ETMEVTIN3() uint32 {
	return (volatile.LoadUint32(&o.CTIINTACK.Reg) & 0x80) >> 7
}

// CTI.CTIAPPSET: CTI Application Trigger Set register
func (o *CTI_Type) SetCTIAPPSET_APPSET_0(value uint32) {
	volatile.StoreUint32(&o.CTIAPPSET.Reg, volatile.LoadUint32(&o.CTIAPPSET.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTIAPPSET_APPSET_0() uint32 {
	return volatile.LoadUint32(&o.CTIAPPSET.Reg) & 0x1
}
func (o *CTI_Type) SetCTIAPPSET_APPSET_1(value uint32) {
	volatile.StoreUint32(&o.CTIAPPSET.Reg, volatile.LoadUint32(&o.CTIAPPSET.Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTIAPPSET_APPSET_1() uint32 {
	return (volatile.LoadUint32(&o.CTIAPPSET.Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTIAPPSET_APPSET_2(value uint32) {
	volatile.StoreUint32(&o.CTIAPPSET.Reg, volatile.LoadUint32(&o.CTIAPPSET.Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTIAPPSET_APPSET_2() uint32 {
	return (volatile.LoadUint32(&o.CTIAPPSET.Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTIAPPSET_APPSET_3(value uint32) {
	volatile.StoreUint32(&o.CTIAPPSET.Reg, volatile.LoadUint32(&o.CTIAPPSET.Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTIAPPSET_APPSET_3() uint32 {
	return (volatile.LoadUint32(&o.CTIAPPSET.Reg) & 0x8) >> 3
}

// CTI.CTIAPPCLEAR: CTI Application Trigger Clear register
func (o *CTI_Type) SetCTIAPPCLEAR_APPCLEAR_0(value uint32) {
	volatile.StoreUint32(&o.CTIAPPCLEAR.Reg, volatile.LoadUint32(&o.CTIAPPCLEAR.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTIAPPCLEAR_APPCLEAR_0() uint32 {
	return volatile.LoadUint32(&o.CTIAPPCLEAR.Reg) & 0x1
}
func (o *CTI_Type) SetCTIAPPCLEAR_APPCLEAR_1(value uint32) {
	volatile.StoreUint32(&o.CTIAPPCLEAR.Reg, volatile.LoadUint32(&o.CTIAPPCLEAR.Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTIAPPCLEAR_APPCLEAR_1() uint32 {
	return (volatile.LoadUint32(&o.CTIAPPCLEAR.Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTIAPPCLEAR_APPCLEAR_2(value uint32) {
	volatile.StoreUint32(&o.CTIAPPCLEAR.Reg, volatile.LoadUint32(&o.CTIAPPCLEAR.Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTIAPPCLEAR_APPCLEAR_2() uint32 {
	return (volatile.LoadUint32(&o.CTIAPPCLEAR.Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTIAPPCLEAR_APPCLEAR_3(value uint32) {
	volatile.StoreUint32(&o.CTIAPPCLEAR.Reg, volatile.LoadUint32(&o.CTIAPPCLEAR.Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTIAPPCLEAR_APPCLEAR_3() uint32 {
	return (volatile.LoadUint32(&o.CTIAPPCLEAR.Reg) & 0x8) >> 3
}

// CTI.CTIAPPPULSE: CTI Application Pulse register
func (o *CTI_Type) SetCTIAPPPULSE_APPULSE_0(value uint32) {
	volatile.StoreUint32(&o.CTIAPPPULSE.Reg, volatile.LoadUint32(&o.CTIAPPPULSE.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTIAPPPULSE_APPULSE_0() uint32 {
	return volatile.LoadUint32(&o.CTIAPPPULSE.Reg) & 0x1
}
func (o *CTI_Type) SetCTIAPPPULSE_APPULSE_1(value uint32) {
	volatile.StoreUint32(&o.CTIAPPPULSE.Reg, volatile.LoadUint32(&o.CTIAPPPULSE.Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTIAPPPULSE_APPULSE_1() uint32 {
	return (volatile.LoadUint32(&o.CTIAPPPULSE.Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTIAPPPULSE_APPULSE_2(value uint32) {
	volatile.StoreUint32(&o.CTIAPPPULSE.Reg, volatile.LoadUint32(&o.CTIAPPPULSE.Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTIAPPPULSE_APPULSE_2() uint32 {
	return (volatile.LoadUint32(&o.CTIAPPPULSE.Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTIAPPPULSE_APPULSE_3(value uint32) {
	volatile.StoreUint32(&o.CTIAPPPULSE.Reg, volatile.LoadUint32(&o.CTIAPPPULSE.Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTIAPPPULSE_APPULSE_3() uint32 {
	return (volatile.LoadUint32(&o.CTIAPPPULSE.Reg) & 0x8) >> 3
}

// CTI.CTIINEN: Description collection: CTI Trigger input
func (o *CTI_Type) SetCTIINEN_TRIGINEN_0(idx int, value uint32) {
	volatile.StoreUint32(&o.CTIINEN[idx].Reg, volatile.LoadUint32(&o.CTIINEN[idx].Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTIINEN_TRIGINEN_0(idx int) uint32 {
	return volatile.LoadUint32(&o.CTIINEN[idx].Reg) & 0x1
}
func (o *CTI_Type) SetCTIINEN_TRIGINEN_1(idx int, value uint32) {
	volatile.StoreUint32(&o.CTIINEN[idx].Reg, volatile.LoadUint32(&o.CTIINEN[idx].Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTIINEN_TRIGINEN_1(idx int) uint32 {
	return (volatile.LoadUint32(&o.CTIINEN[idx].Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTIINEN_TRIGINEN_2(idx int, value uint32) {
	volatile.StoreUint32(&o.CTIINEN[idx].Reg, volatile.LoadUint32(&o.CTIINEN[idx].Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTIINEN_TRIGINEN_2(idx int) uint32 {
	return (volatile.LoadUint32(&o.CTIINEN[idx].Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTIINEN_TRIGINEN_3(idx int, value uint32) {
	volatile.StoreUint32(&o.CTIINEN[idx].Reg, volatile.LoadUint32(&o.CTIINEN[idx].Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTIINEN_TRIGINEN_3(idx int) uint32 {
	return (volatile.LoadUint32(&o.CTIINEN[idx].Reg) & 0x8) >> 3
}

// CTI.CTIOUTEN: Description collection: CTI Trigger output
func (o *CTI_Type) SetCTIOUTEN_TRIGOUTEN_0(idx int, value uint32) {
	volatile.StoreUint32(&o.CTIOUTEN[idx].Reg, volatile.LoadUint32(&o.CTIOUTEN[idx].Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTIOUTEN_TRIGOUTEN_0(idx int) uint32 {
	return volatile.LoadUint32(&o.CTIOUTEN[idx].Reg) & 0x1
}
func (o *CTI_Type) SetCTIOUTEN_TRIGOUTEN_1(idx int, value uint32) {
	volatile.StoreUint32(&o.CTIOUTEN[idx].Reg, volatile.LoadUint32(&o.CTIOUTEN[idx].Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTIOUTEN_TRIGOUTEN_1(idx int) uint32 {
	return (volatile.LoadUint32(&o.CTIOUTEN[idx].Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTIOUTEN_TRIGOUTEN_2(idx int, value uint32) {
	volatile.StoreUint32(&o.CTIOUTEN[idx].Reg, volatile.LoadUint32(&o.CTIOUTEN[idx].Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTIOUTEN_TRIGOUTEN_2(idx int) uint32 {
	return (volatile.LoadUint32(&o.CTIOUTEN[idx].Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTIOUTEN_TRIGOUTEN_3(idx int, value uint32) {
	volatile.StoreUint32(&o.CTIOUTEN[idx].Reg, volatile.LoadUint32(&o.CTIOUTEN[idx].Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTIOUTEN_TRIGOUTEN_3(idx int) uint32 {
	return (volatile.LoadUint32(&o.CTIOUTEN[idx].Reg) & 0x8) >> 3
}

// CTI.CTITRIGINSTATUS: CTI Trigger In Status register
func (o *CTI_Type) SetCTITRIGINSTATUS_CPUHALTED(value uint32) {
	volatile.StoreUint32(&o.CTITRIGINSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTITRIGINSTATUS_CPUHALTED() uint32 {
	return volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg) & 0x1
}
func (o *CTI_Type) SetCTITRIGINSTATUS_DWTCOMPOUT0(value uint32) {
	volatile.StoreUint32(&o.CTITRIGINSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTITRIGINSTATUS_DWTCOMPOUT0() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTITRIGINSTATUS_DWTCOMPOUT1(value uint32) {
	volatile.StoreUint32(&o.CTITRIGINSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTITRIGINSTATUS_DWTCOMPOUT1() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTITRIGINSTATUS_DWTCOMPOUT2(value uint32) {
	volatile.StoreUint32(&o.CTITRIGINSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTITRIGINSTATUS_DWTCOMPOUT2() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg) & 0x8) >> 3
}
func (o *CTI_Type) SetCTITRIGINSTATUS_ETMEVTOUT0(value uint32) {
	volatile.StoreUint32(&o.CTITRIGINSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *CTI_Type) GetCTITRIGINSTATUS_ETMEVTOUT0() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg) & 0x10) >> 4
}
func (o *CTI_Type) SetCTITRIGINSTATUS_ETMEVTOUT1(value uint32) {
	volatile.StoreUint32(&o.CTITRIGINSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *CTI_Type) GetCTITRIGINSTATUS_ETMEVTOUT1() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg) & 0x20) >> 5
}
func (o *CTI_Type) SetCTITRIGINSTATUS_UNUSED0(value uint32) {
	volatile.StoreUint32(&o.CTITRIGINSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *CTI_Type) GetCTITRIGINSTATUS_UNUSED0() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg) & 0x40) >> 6
}
func (o *CTI_Type) SetCTITRIGINSTATUS_UNUSED1(value uint32) {
	volatile.StoreUint32(&o.CTITRIGINSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *CTI_Type) GetCTITRIGINSTATUS_UNUSED1() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg) & 0x80) >> 7
}

// CTI.CTITRIGOUTSTATUS: CTI Trigger Out Status register
func (o *CTI_Type) SetCTITRIGOUTSTATUS_DEBUGREQ(value uint32) {
	volatile.StoreUint32(&o.CTITRIGOUTSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTITRIGOUTSTATUS_DEBUGREQ() uint32 {
	return volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg) & 0x1
}
func (o *CTI_Type) SetCTITRIGOUTSTATUS_CPURESTART(value uint32) {
	volatile.StoreUint32(&o.CTITRIGOUTSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTITRIGOUTSTATUS_CPURESTART() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTITRIGOUTSTATUS_UNUSED0(value uint32) {
	volatile.StoreUint32(&o.CTITRIGOUTSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTITRIGOUTSTATUS_UNUSED0() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTITRIGOUTSTATUS_UNUSED1(value uint32) {
	volatile.StoreUint32(&o.CTITRIGOUTSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTITRIGOUTSTATUS_UNUSED1() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg) & 0x8) >> 3
}
func (o *CTI_Type) SetCTITRIGOUTSTATUS_ETMEVTIN0(value uint32) {
	volatile.StoreUint32(&o.CTITRIGOUTSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *CTI_Type) GetCTITRIGOUTSTATUS_ETMEVTIN0() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg) & 0x10) >> 4
}
func (o *CTI_Type) SetCTITRIGOUTSTATUS_ETMEVTIN1(value uint32) {
	volatile.StoreUint32(&o.CTITRIGOUTSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *CTI_Type) GetCTITRIGOUTSTATUS_ETMEVTIN1() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg) & 0x20) >> 5
}
func (o *CTI_Type) SetCTITRIGOUTSTATUS_ETMEVTIN2(value uint32) {
	volatile.StoreUint32(&o.CTITRIGOUTSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *CTI_Type) GetCTITRIGOUTSTATUS_ETMEVTIN2() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg) & 0x40) >> 6
}
func (o *CTI_Type) SetCTITRIGOUTSTATUS_ETMEVTIN3(value uint32) {
	volatile.StoreUint32(&o.CTITRIGOUTSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *CTI_Type) GetCTITRIGOUTSTATUS_ETMEVTIN3() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg) & 0x80) >> 7
}

// CTI.CTICHINSTATUS: CTI Channel In Status register
func (o *CTI_Type) SetCTICHINSTATUS_CTICHINSTATUS_0(value uint32) {
	volatile.StoreUint32(&o.CTICHINSTATUS.Reg, volatile.LoadUint32(&o.CTICHINSTATUS.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTICHINSTATUS_CTICHINSTATUS_0() uint32 {
	return volatile.LoadUint32(&o.CTICHINSTATUS.Reg) & 0x1
}
func (o *CTI_Type) SetCTICHINSTATUS_CTICHINSTATUS_1(value uint32) {
	volatile.StoreUint32(&o.CTICHINSTATUS.Reg, volatile.LoadUint32(&o.CTICHINSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTICHINSTATUS_CTICHINSTATUS_1() uint32 {
	return (volatile.LoadUint32(&o.CTICHINSTATUS.Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTICHINSTATUS_CTICHINSTATUS_2(value uint32) {
	volatile.StoreUint32(&o.CTICHINSTATUS.Reg, volatile.LoadUint32(&o.CTICHINSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTICHINSTATUS_CTICHINSTATUS_2() uint32 {
	return (volatile.LoadUint32(&o.CTICHINSTATUS.Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTICHINSTATUS_CTICHINSTATUS_3(value uint32) {
	volatile.StoreUint32(&o.CTICHINSTATUS.Reg, volatile.LoadUint32(&o.CTICHINSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTICHINSTATUS_CTICHINSTATUS_3() uint32 {
	return (volatile.LoadUint32(&o.CTICHINSTATUS.Reg) & 0x8) >> 3
}

// CTI.CTIGATE: Enable CTI Channel Gate register
func (o *CTI_Type) SetCTIGATE_CTIGATEEN_0(value uint32) {
	volatile.StoreUint32(&o.CTIGATE.Reg, volatile.LoadUint32(&o.CTIGATE.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTIGATE_CTIGATEEN_0() uint32 {
	return volatile.LoadUint32(&o.CTIGATE.Reg) & 0x1
}
func (o *CTI_Type) SetCTIGATE_CTIGATEEN_1(value uint32) {
	volatile.StoreUint32(&o.CTIGATE.Reg, volatile.LoadUint32(&o.CTIGATE.Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTIGATE_CTIGATEEN_1() uint32 {
	return (volatile.LoadUint32(&o.CTIGATE.Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTIGATE_CTIGATEEN_2(value uint32) {
	volatile.StoreUint32(&o.CTIGATE.Reg, volatile.LoadUint32(&o.CTIGATE.Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTIGATE_CTIGATEEN_2() uint32 {
	return (volatile.LoadUint32(&o.CTIGATE.Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTIGATE_CTIGATEEN_3(value uint32) {
	volatile.StoreUint32(&o.CTIGATE.Reg, volatile.LoadUint32(&o.CTIGATE.Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTIGATE_CTIGATEEN_3() uint32 {
	return (volatile.LoadUint32(&o.CTIGATE.Reg) & 0x8) >> 3
}

// CTI.DEVARCH: Device Architecture register
func (o *CTI_Type) SetDEVARCH_Architecture(value uint32) {
	volatile.StoreUint32(&o.DEVARCH.Reg, volatile.LoadUint32(&o.DEVARCH.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetDEVARCH_Architecture() uint32 {
	return volatile.LoadUint32(&o.DEVARCH.Reg) & 0x1
}

// CTI.DEVID: Device Configuration register
func (o *CTI_Type) SetDEVID_EXTMUXNUM(value uint32) {
	volatile.StoreUint32(&o.DEVID.Reg, volatile.LoadUint32(&o.DEVID.Reg)&^(0x1f)|value)
}
func (o *CTI_Type) GetDEVID_EXTMUXNUM() uint32 {
	return volatile.LoadUint32(&o.DEVID.Reg) & 0x1f
}
func (o *CTI_Type) SetDEVID_NUMTRIG(value uint32) {
	volatile.StoreUint32(&o.DEVID.Reg, volatile.LoadUint32(&o.DEVID.Reg)&^(0xff00)|value<<8)
}
func (o *CTI_Type) GetDEVID_NUMTRIG() uint32 {
	return (volatile.LoadUint32(&o.DEVID.Reg) & 0xff00) >> 8
}
func (o *CTI_Type) SetDEVID_NUMCH(value uint32) {
	volatile.StoreUint32(&o.DEVID.Reg, volatile.LoadUint32(&o.DEVID.Reg)&^(0xf0000)|value<<16)
}
func (o *CTI_Type) GetDEVID_NUMCH() uint32 {
	return (volatile.LoadUint32(&o.DEVID.Reg) & 0xf0000) >> 16
}

// CTI.DEVTYPE: Device Type Identifier register
func (o *CTI_Type) SetDEVTYPE_MAJOR(value uint32) {
	volatile.StoreUint32(&o.DEVTYPE.Reg, volatile.LoadUint32(&o.DEVTYPE.Reg)&^(0xf)|value)
}
func (o *CTI_Type) GetDEVTYPE_MAJOR() uint32 {
	return volatile.LoadUint32(&o.DEVTYPE.Reg) & 0xf
}
func (o *CTI_Type) SetDEVTYPE_SUB(value uint32) {
	volatile.StoreUint32(&o.DEVTYPE.Reg, volatile.LoadUint32(&o.DEVTYPE.Reg)&^(0xf0)|value<<4)
}
func (o *CTI_Type) GetDEVTYPE_SUB() uint32 {
	return (volatile.LoadUint32(&o.DEVTYPE.Reg) & 0xf0) >> 4
}

// CTI.PIDR4: Peripheral ID4 Register
func (o *CTI_Type) SetPIDR4_DES_2(value uint32) {
	volatile.StoreUint32(&o.PIDR4.Reg, volatile.LoadUint32(&o.PIDR4.Reg)&^(0xf)|value)
}
func (o *CTI_Type) GetPIDR4_DES_2() uint32 {
	return volatile.LoadUint32(&o.PIDR4.Reg) & 0xf
}
func (o *CTI_Type) SetPIDR4_SIZE(value uint32) {
	volatile.StoreUint32(&o.PIDR4.Reg, volatile.LoadUint32(&o.PIDR4.Reg)&^(0xf0)|value<<4)
}
func (o *CTI_Type) GetPIDR4_SIZE() uint32 {
	return (volatile.LoadUint32(&o.PIDR4.Reg) & 0xf0) >> 4
}

// CTI.PIDR0: Peripheral ID0 Register
func (o *CTI_Type) SetPIDR0_PART_0(value uint32) {
	volatile.StoreUint32(&o.PIDR0.Reg, volatile.LoadUint32(&o.PIDR0.Reg)&^(0xff)|value)
}
func (o *CTI_Type) GetPIDR0_PART_0() uint32 {
	return volatile.LoadUint32(&o.PIDR0.Reg) & 0xff
}

// CTI.PIDR1: Peripheral ID1 Register
func (o *CTI_Type) SetPIDR1_PART_1(value uint32) {
	volatile.StoreUint32(&o.PIDR1.Reg, volatile.LoadUint32(&o.PIDR1.Reg)&^(0xf)|value)
}
func (o *CTI_Type) GetPIDR1_PART_1() uint32 {
	return volatile.LoadUint32(&o.PIDR1.Reg) & 0xf
}
func (o *CTI_Type) SetPIDR1_DES_0(value uint32) {
	volatile.StoreUint32(&o.PIDR1.Reg, volatile.LoadUint32(&o.PIDR1.Reg)&^(0xf0)|value<<4)
}
func (o *CTI_Type) GetPIDR1_DES_0() uint32 {
	return (volatile.LoadUint32(&o.PIDR1.Reg) & 0xf0) >> 4
}

// CTI.PIDR2: Peripheral ID2 Register
func (o *CTI_Type) SetPIDR2_DES_1(value uint32) {
	volatile.StoreUint32(&o.PIDR2.Reg, volatile.LoadUint32(&o.PIDR2.Reg)&^(0x7)|value)
}
func (o *CTI_Type) GetPIDR2_DES_1() uint32 {
	return volatile.LoadUint32(&o.PIDR2.Reg) & 0x7
}
func (o *CTI_Type) SetPIDR2_JEDEC(value uint32) {
	volatile.StoreUint32(&o.PIDR2.Reg, volatile.LoadUint32(&o.PIDR2.Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetPIDR2_JEDEC() uint32 {
	return (volatile.LoadUint32(&o.PIDR2.Reg) & 0x8) >> 3
}
func (o *CTI_Type) SetPIDR2_REVISION(value uint32) {
	volatile.StoreUint32(&o.PIDR2.Reg, volatile.LoadUint32(&o.PIDR2.Reg)&^(0xf0)|value<<4)
}
func (o *CTI_Type) GetPIDR2_REVISION() uint32 {
	return (volatile.LoadUint32(&o.PIDR2.Reg) & 0xf0) >> 4
}

// CTI.PIDR3: Peripheral ID3 Register
func (o *CTI_Type) SetPIDR3_CMOD(value uint32) {
	volatile.StoreUint32(&o.PIDR3.Reg, volatile.LoadUint32(&o.PIDR3.Reg)&^(0xf)|value)
}
func (o *CTI_Type) GetPIDR3_CMOD() uint32 {
	return volatile.LoadUint32(&o.PIDR3.Reg) & 0xf
}
func (o *CTI_Type) SetPIDR3_REVAND(value uint32) {
	volatile.StoreUint32(&o.PIDR3.Reg, volatile.LoadUint32(&o.PIDR3.Reg)&^(0xf0)|value<<4)
}
func (o *CTI_Type) GetPIDR3_REVAND() uint32 {
	return (volatile.LoadUint32(&o.PIDR3.Reg) & 0xf0) >> 4
}

// CTI.CIDR0: Component ID0 Register
func (o *CTI_Type) SetCIDR0_PRMBL_0(value uint32) {
	volatile.StoreUint32(&o.CIDR0.Reg, volatile.LoadUint32(&o.CIDR0.Reg)&^(0xff)|value)
}
func (o *CTI_Type) GetCIDR0_PRMBL_0() uint32 {
	return volatile.LoadUint32(&o.CIDR0.Reg) & 0xff
}

// CTI.CIDR1: Component ID1 Register
func (o *CTI_Type) SetCIDR1_PRMBL_1(value uint32) {
	volatile.StoreUint32(&o.CIDR1.Reg, volatile.LoadUint32(&o.CIDR1.Reg)&^(0xf)|value)
}
func (o *CTI_Type) GetCIDR1_PRMBL_1() uint32 {
	return volatile.LoadUint32(&o.CIDR1.Reg) & 0xf
}
func (o *CTI_Type) SetCIDR1_CLASS(value uint32) {
	volatile.StoreUint32(&o.CIDR1.Reg, volatile.LoadUint32(&o.CIDR1.Reg)&^(0xf0)|value<<4)
}
func (o *CTI_Type) GetCIDR1_CLASS() uint32 {
	return (volatile.LoadUint32(&o.CIDR1.Reg) & 0xf0) >> 4
}

// CTI.CIDR2: Component ID2 Register
func (o *CTI_Type) SetCIDR2_PRMBL_2(value uint32) {
	volatile.StoreUint32(&o.CIDR2.Reg, volatile.LoadUint32(&o.CIDR2.Reg)&^(0xff)|value)
}
func (o *CTI_Type) GetCIDR2_PRMBL_2() uint32 {
	return volatile.LoadUint32(&o.CIDR2.Reg) & 0xff
}

// CTI.CIDR3: Component ID3 Register
func (o *CTI_Type) SetCIDR3_PRMBL_3(value uint32) {
	volatile.StoreUint32(&o.CIDR3.Reg, volatile.LoadUint32(&o.CIDR3.Reg)&^(0xff)|value)
}
func (o *CTI_Type) GetCIDR3_PRMBL_3() uint32 {
	return volatile.LoadUint32(&o.CIDR3.Reg) & 0xff
}

// Trace and debug control
type TAD_Type struct {
	_              [4]byte
	CLOCKSTART     volatile.Register32 // 0x4
	CLOCKSTOP      volatile.Register32 // 0x8
	_              [1268]byte
	ENABLE         volatile.Register32 // 0x500
	PSEL           TAD_PSEL_Type       // 0x504
	TRACEPORTSPEED volatile.Register32 // 0x518
}

// TAD.CLOCKSTART: Start all trace and debug clocks.
func (o *TAD_Type) SetCLOCKSTART_START(value uint32) {
	volatile.StoreUint32(&o.CLOCKSTART.Reg, volatile.LoadUint32(&o.CLOCKSTART.Reg)&^(0x1)|value)
}
func (o *TAD_Type) GetCLOCKSTART_START() uint32 {
	return volatile.LoadUint32(&o.CLOCKSTART.Reg) & 0x1
}

// TAD.CLOCKSTOP: Stop all trace and debug clocks.
func (o *TAD_Type) SetCLOCKSTOP_STOP(value uint32) {
	volatile.StoreUint32(&o.CLOCKSTOP.Reg, volatile.LoadUint32(&o.CLOCKSTOP.Reg)&^(0x1)|value)
}
func (o *TAD_Type) GetCLOCKSTOP_STOP() uint32 {
	return volatile.LoadUint32(&o.CLOCKSTOP.Reg) & 0x1
}

// TAD.ENABLE: Enable debug domain and aquire selected GPIOs
func (o *TAD_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *TAD_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// TAD.TRACEPORTSPEED: Clocking options for the Trace Port debug interface.
func (o *TAD_Type) SetTRACEPORTSPEED(value uint32) {
	volatile.StoreUint32(&o.TRACEPORTSPEED.Reg, volatile.LoadUint32(&o.TRACEPORTSPEED.Reg)&^(0x3)|value)
}
func (o *TAD_Type) GetTRACEPORTSPEED() uint32 {
	return volatile.LoadUint32(&o.TRACEPORTSPEED.Reg) & 0x3
}

type TAD_PSEL_Type struct {
	TRACECLK   volatile.Register32 // 0x504
	TRACEDATA0 volatile.Register32 // 0x508
	TRACEDATA1 volatile.Register32 // 0x50C
	TRACEDATA2 volatile.Register32 // 0x510
	TRACEDATA3 volatile.Register32 // 0x514
}

// TAD_PSEL.TRACECLK: Pin configuration for TRACECLK
func (o *TAD_PSEL_Type) SetTRACECLK_PIN(value uint32) {
	volatile.StoreUint32(&o.TRACECLK.Reg, volatile.LoadUint32(&o.TRACECLK.Reg)&^(0x1f)|value)
}
func (o *TAD_PSEL_Type) GetTRACECLK_PIN() uint32 {
	return volatile.LoadUint32(&o.TRACECLK.Reg) & 0x1f
}
func (o *TAD_PSEL_Type) SetTRACECLK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.TRACECLK.Reg, volatile.LoadUint32(&o.TRACECLK.Reg)&^(0x80000000)|value<<31)
}
func (o *TAD_PSEL_Type) GetTRACECLK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.TRACECLK.Reg) & 0x80000000) >> 31
}

// TAD_PSEL.TRACEDATA0: Pin configuration for TRACEDATA[0] and SWO
func (o *TAD_PSEL_Type) SetTRACEDATA0_PIN(value uint32) {
	volatile.StoreUint32(&o.TRACEDATA0.Reg, volatile.LoadUint32(&o.TRACEDATA0.Reg)&^(0x1f)|value)
}
func (o *TAD_PSEL_Type) GetTRACEDATA0_PIN() uint32 {
	return volatile.LoadUint32(&o.TRACEDATA0.Reg) & 0x1f
}
func (o *TAD_PSEL_Type) SetTRACEDATA0_CONNECT(value uint32) {
	volatile.StoreUint32(&o.TRACEDATA0.Reg, volatile.LoadUint32(&o.TRACEDATA0.Reg)&^(0x80000000)|value<<31)
}
func (o *TAD_PSEL_Type) GetTRACEDATA0_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.TRACEDATA0.Reg) & 0x80000000) >> 31
}

// TAD_PSEL.TRACEDATA1: Pin configuration for TRACEDATA[1]
func (o *TAD_PSEL_Type) SetTRACEDATA1_PIN(value uint32) {
	volatile.StoreUint32(&o.TRACEDATA1.Reg, volatile.LoadUint32(&o.TRACEDATA1.Reg)&^(0x1f)|value)
}
func (o *TAD_PSEL_Type) GetTRACEDATA1_PIN() uint32 {
	return volatile.LoadUint32(&o.TRACEDATA1.Reg) & 0x1f
}
func (o *TAD_PSEL_Type) SetTRACEDATA1_CONNECT(value uint32) {
	volatile.StoreUint32(&o.TRACEDATA1.Reg, volatile.LoadUint32(&o.TRACEDATA1.Reg)&^(0x80000000)|value<<31)
}
func (o *TAD_PSEL_Type) GetTRACEDATA1_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.TRACEDATA1.Reg) & 0x80000000) >> 31
}

// TAD_PSEL.TRACEDATA2: Pin configuration for TRACEDATA[2]
func (o *TAD_PSEL_Type) SetTRACEDATA2_PIN(value uint32) {
	volatile.StoreUint32(&o.TRACEDATA2.Reg, volatile.LoadUint32(&o.TRACEDATA2.Reg)&^(0x1f)|value)
}
func (o *TAD_PSEL_Type) GetTRACEDATA2_PIN() uint32 {
	return volatile.LoadUint32(&o.TRACEDATA2.Reg) & 0x1f
}
func (o *TAD_PSEL_Type) SetTRACEDATA2_CONNECT(value uint32) {
	volatile.StoreUint32(&o.TRACEDATA2.Reg, volatile.LoadUint32(&o.TRACEDATA2.Reg)&^(0x80000000)|value<<31)
}
func (o *TAD_PSEL_Type) GetTRACEDATA2_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.TRACEDATA2.Reg) & 0x80000000) >> 31
}

// TAD_PSEL.TRACEDATA3: Pin configuration for TRACEDATA[3]
func (o *TAD_PSEL_Type) SetTRACEDATA3_PIN(value uint32) {
	volatile.StoreUint32(&o.TRACEDATA3.Reg, volatile.LoadUint32(&o.TRACEDATA3.Reg)&^(0x1f)|value)
}
func (o *TAD_PSEL_Type) GetTRACEDATA3_PIN() uint32 {
	return volatile.LoadUint32(&o.TRACEDATA3.Reg) & 0x1f
}
func (o *TAD_PSEL_Type) SetTRACEDATA3_CONNECT(value uint32) {
	volatile.StoreUint32(&o.TRACEDATA3.Reg, volatile.LoadUint32(&o.TRACEDATA3.Reg)&^(0x80000000)|value<<31)
}
func (o *TAD_PSEL_Type) GetTRACEDATA3_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.TRACEDATA3.Reg) & 0x80000000) >> 31
}

// Domain configuration management 0
type DCNF_Type struct {
	_       [1056]byte
	CPUID   volatile.Register32 // 0x420
	_       [28]byte
	EXTPERI [1]DCNF_EXTPERI_Type // 0x440
	_       [32]byte
	EXTRAM  [1]DCNF_EXTRAM_Type // 0x460
	_       [32]byte
	EXTCODE [1]DCNF_EXTCODE_Type // 0x480
}

// DCNF.CPUID: CPU ID of this subsystem
func (o *DCNF_Type) SetCPUID(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xff)|value)
}
func (o *DCNF_Type) GetCPUID() uint32 {
	return volatile.LoadUint32(&o.CPUID.Reg) & 0xff
}

type DCNF_EXTPERI_Type struct {
	PROTECT volatile.Register32 // 0x440
}

// DCNF_EXTPERI.PROTECT: Description cluster: Control access for master connected to AMLI master port EXTPERI[n]
func (o *DCNF_EXTPERI_Type) SetPROTECT_SLAVE0(value uint32) {
	volatile.StoreUint32(&o.PROTECT.Reg, volatile.LoadUint32(&o.PROTECT.Reg)&^(0x1)|value)
}
func (o *DCNF_EXTPERI_Type) GetPROTECT_SLAVE0() uint32 {
	return volatile.LoadUint32(&o.PROTECT.Reg) & 0x1
}

type DCNF_EXTRAM_Type struct {
	PROTECT volatile.Register32 // 0x460
}

// DCNF_EXTRAM.PROTECT: Description cluster: Control access from master connected to AMLI master port EXTRAM[n]
func (o *DCNF_EXTRAM_Type) SetPROTECT_SLAVE0(value uint32) {
	volatile.StoreUint32(&o.PROTECT.Reg, volatile.LoadUint32(&o.PROTECT.Reg)&^(0x1)|value)
}
func (o *DCNF_EXTRAM_Type) GetPROTECT_SLAVE0() uint32 {
	return volatile.LoadUint32(&o.PROTECT.Reg) & 0x1
}
func (o *DCNF_EXTRAM_Type) SetPROTECT_SLAVE1(value uint32) {
	volatile.StoreUint32(&o.PROTECT.Reg, volatile.LoadUint32(&o.PROTECT.Reg)&^(0x2)|value<<1)
}
func (o *DCNF_EXTRAM_Type) GetPROTECT_SLAVE1() uint32 {
	return (volatile.LoadUint32(&o.PROTECT.Reg) & 0x2) >> 1
}
func (o *DCNF_EXTRAM_Type) SetPROTECT_SLAVE2(value uint32) {
	volatile.StoreUint32(&o.PROTECT.Reg, volatile.LoadUint32(&o.PROTECT.Reg)&^(0x4)|value<<2)
}
func (o *DCNF_EXTRAM_Type) GetPROTECT_SLAVE2() uint32 {
	return (volatile.LoadUint32(&o.PROTECT.Reg) & 0x4) >> 2
}
func (o *DCNF_EXTRAM_Type) SetPROTECT_SLAVE3(value uint32) {
	volatile.StoreUint32(&o.PROTECT.Reg, volatile.LoadUint32(&o.PROTECT.Reg)&^(0x8)|value<<3)
}
func (o *DCNF_EXTRAM_Type) GetPROTECT_SLAVE3() uint32 {
	return (volatile.LoadUint32(&o.PROTECT.Reg) & 0x8) >> 3
}
func (o *DCNF_EXTRAM_Type) SetPROTECT_SLAVE4(value uint32) {
	volatile.StoreUint32(&o.PROTECT.Reg, volatile.LoadUint32(&o.PROTECT.Reg)&^(0x10)|value<<4)
}
func (o *DCNF_EXTRAM_Type) GetPROTECT_SLAVE4() uint32 {
	return (volatile.LoadUint32(&o.PROTECT.Reg) & 0x10) >> 4
}
func (o *DCNF_EXTRAM_Type) SetPROTECT_SLAVE5(value uint32) {
	volatile.StoreUint32(&o.PROTECT.Reg, volatile.LoadUint32(&o.PROTECT.Reg)&^(0x20)|value<<5)
}
func (o *DCNF_EXTRAM_Type) GetPROTECT_SLAVE5() uint32 {
	return (volatile.LoadUint32(&o.PROTECT.Reg) & 0x20) >> 5
}
func (o *DCNF_EXTRAM_Type) SetPROTECT_SLAVE6(value uint32) {
	volatile.StoreUint32(&o.PROTECT.Reg, volatile.LoadUint32(&o.PROTECT.Reg)&^(0x40)|value<<6)
}
func (o *DCNF_EXTRAM_Type) GetPROTECT_SLAVE6() uint32 {
	return (volatile.LoadUint32(&o.PROTECT.Reg) & 0x40) >> 6
}
func (o *DCNF_EXTRAM_Type) SetPROTECT_SLAVE7(value uint32) {
	volatile.StoreUint32(&o.PROTECT.Reg, volatile.LoadUint32(&o.PROTECT.Reg)&^(0x80)|value<<7)
}
func (o *DCNF_EXTRAM_Type) GetPROTECT_SLAVE7() uint32 {
	return (volatile.LoadUint32(&o.PROTECT.Reg) & 0x80) >> 7
}

type DCNF_EXTCODE_Type struct {
	PROTECT volatile.Register32 // 0x480
}

// DCNF_EXTCODE.PROTECT: Description cluster: Control access from master connected to AMLI master port EXTCODE[n]
func (o *DCNF_EXTCODE_Type) SetPROTECT_SLAVE0(value uint32) {
	volatile.StoreUint32(&o.PROTECT.Reg, volatile.LoadUint32(&o.PROTECT.Reg)&^(0x1)|value)
}
func (o *DCNF_EXTCODE_Type) GetPROTECT_SLAVE0() uint32 {
	return volatile.LoadUint32(&o.PROTECT.Reg) & 0x1
}

// FPU control peripheral 0
type FPU_Type struct {
	_                       [256]byte
	EVENTS_INVALIDOPERATION volatile.Register32 // 0x100
	EVENTS_DIVIDEBYZERO     volatile.Register32 // 0x104
	EVENTS_OVERFLOW         volatile.Register32 // 0x108
	EVENTS_UNDERFLOW        volatile.Register32 // 0x10C
	EVENTS_INEXACT          volatile.Register32 // 0x110
	EVENTS_DENORMALINPUT    volatile.Register32 // 0x114
	_                       [488]byte
	INTEN                   volatile.Register32 // 0x300
	INTENSET                volatile.Register32 // 0x304
	INTENCLR                volatile.Register32 // 0x308
}

// FPU.EVENTS_INVALIDOPERATION: An FPUIOC exception triggered by an invalid operation has occurred in the FPU
func (o *FPU_Type) SetEVENTS_INVALIDOPERATION(value uint32) {
	volatile.StoreUint32(&o.EVENTS_INVALIDOPERATION.Reg, volatile.LoadUint32(&o.EVENTS_INVALIDOPERATION.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetEVENTS_INVALIDOPERATION() uint32 {
	return volatile.LoadUint32(&o.EVENTS_INVALIDOPERATION.Reg) & 0x1
}

// FPU.EVENTS_DIVIDEBYZERO: An FPUDZC exception triggered by a floating-point divide-by-zero operation has occurred in the FPU
func (o *FPU_Type) SetEVENTS_DIVIDEBYZERO(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DIVIDEBYZERO.Reg, volatile.LoadUint32(&o.EVENTS_DIVIDEBYZERO.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetEVENTS_DIVIDEBYZERO() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DIVIDEBYZERO.Reg) & 0x1
}

// FPU.EVENTS_OVERFLOW: An FPUOFC exception triggered by a floating-point overflow has occurred in the FPU
func (o *FPU_Type) SetEVENTS_OVERFLOW(value uint32) {
	volatile.StoreUint32(&o.EVENTS_OVERFLOW.Reg, volatile.LoadUint32(&o.EVENTS_OVERFLOW.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetEVENTS_OVERFLOW() uint32 {
	return volatile.LoadUint32(&o.EVENTS_OVERFLOW.Reg) & 0x1
}

// FPU.EVENTS_UNDERFLOW: An FPUUFC exception triggered by a floating-point underflow has occurred in the FPU
func (o *FPU_Type) SetEVENTS_UNDERFLOW(value uint32) {
	volatile.StoreUint32(&o.EVENTS_UNDERFLOW.Reg, volatile.LoadUint32(&o.EVENTS_UNDERFLOW.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetEVENTS_UNDERFLOW() uint32 {
	return volatile.LoadUint32(&o.EVENTS_UNDERFLOW.Reg) & 0x1
}

// FPU.EVENTS_INEXACT: An FPUIXC exception triggered by an inexact floating-point operation has occurred in the FPU
func (o *FPU_Type) SetEVENTS_INEXACT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_INEXACT.Reg, volatile.LoadUint32(&o.EVENTS_INEXACT.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetEVENTS_INEXACT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_INEXACT.Reg) & 0x1
}

// FPU.EVENTS_DENORMALINPUT: An FPUIDC exception triggered by a denormal floating-point input has occurred in the FPU
func (o *FPU_Type) SetEVENTS_DENORMALINPUT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DENORMALINPUT.Reg, volatile.LoadUint32(&o.EVENTS_DENORMALINPUT.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetEVENTS_DENORMALINPUT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DENORMALINPUT.Reg) & 0x1
}

// FPU.INTEN: Enable or disable interrupt
func (o *FPU_Type) SetINTEN_INVALIDOPERATION(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetINTEN_INVALIDOPERATION() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *FPU_Type) SetINTEN_DIVIDEBYZERO(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *FPU_Type) GetINTEN_DIVIDEBYZERO() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *FPU_Type) SetINTEN_OVERFLOW(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *FPU_Type) GetINTEN_OVERFLOW() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *FPU_Type) SetINTEN_UNDERFLOW(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *FPU_Type) GetINTEN_UNDERFLOW() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *FPU_Type) SetINTEN_INEXACT(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *FPU_Type) GetINTEN_INEXACT() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *FPU_Type) SetINTEN_DENORMALINPUT(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *FPU_Type) GetINTEN_DENORMALINPUT() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}

// FPU.INTENSET: Enable interrupt
func (o *FPU_Type) SetINTENSET_INVALIDOPERATION(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetINTENSET_INVALIDOPERATION() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *FPU_Type) SetINTENSET_DIVIDEBYZERO(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *FPU_Type) GetINTENSET_DIVIDEBYZERO() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *FPU_Type) SetINTENSET_OVERFLOW(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *FPU_Type) GetINTENSET_OVERFLOW() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *FPU_Type) SetINTENSET_UNDERFLOW(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *FPU_Type) GetINTENSET_UNDERFLOW() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *FPU_Type) SetINTENSET_INEXACT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *FPU_Type) GetINTENSET_INEXACT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *FPU_Type) SetINTENSET_DENORMALINPUT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *FPU_Type) GetINTENSET_DENORMALINPUT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}

// FPU.INTENCLR: Disable interrupt
func (o *FPU_Type) SetINTENCLR_INVALIDOPERATION(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetINTENCLR_INVALIDOPERATION() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *FPU_Type) SetINTENCLR_DIVIDEBYZERO(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *FPU_Type) GetINTENCLR_DIVIDEBYZERO() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *FPU_Type) SetINTENCLR_OVERFLOW(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *FPU_Type) GetINTENCLR_OVERFLOW() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *FPU_Type) SetINTENCLR_UNDERFLOW(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *FPU_Type) GetINTENCLR_UNDERFLOW() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *FPU_Type) SetINTENCLR_INEXACT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *FPU_Type) GetINTENCLR_INEXACT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *FPU_Type) SetINTENCLR_DENORMALINPUT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *FPU_Type) GetINTENCLR_DENORMALINPUT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}

// Cache
type CACHE_Type struct {
	_               [1024]byte
	PROFILING       [2]CACHE_PROFILING_Type // 0x400
	_               [192]byte
	ENABLE          volatile.Register32 // 0x500
	INVALIDATE      volatile.Register32 // 0x504
	ERASE           volatile.Register32 // 0x508
	PROFILINGENABLE volatile.Register32 // 0x50C
	PROFILINGCLEAR  volatile.Register32 // 0x510
	MODE            volatile.Register32 // 0x514
	DEBUGLOCK       volatile.Register32 // 0x518
	ERASESTATUS     volatile.Register32 // 0x51C
	WRITELOCK       volatile.Register32 // 0x520
}

// CACHE.ENABLE: Enable cache
func (o *CACHE_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// CACHE.INVALIDATE: Invalidate the cache
func (o *CACHE_Type) SetINVALIDATE(value uint32) {
	volatile.StoreUint32(&o.INVALIDATE.Reg, volatile.LoadUint32(&o.INVALIDATE.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetINVALIDATE() uint32 {
	return volatile.LoadUint32(&o.INVALIDATE.Reg) & 0x1
}

// CACHE.ERASE: Erase the cache
func (o *CACHE_Type) SetERASE(value uint32) {
	volatile.StoreUint32(&o.ERASE.Reg, volatile.LoadUint32(&o.ERASE.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetERASE() uint32 {
	return volatile.LoadUint32(&o.ERASE.Reg) & 0x1
}

// CACHE.PROFILINGENABLE: Enable the profiling counters
func (o *CACHE_Type) SetPROFILINGENABLE_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PROFILINGENABLE.Reg, volatile.LoadUint32(&o.PROFILINGENABLE.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetPROFILINGENABLE_ENABLE() uint32 {
	return volatile.LoadUint32(&o.PROFILINGENABLE.Reg) & 0x1
}

// CACHE.PROFILINGCLEAR: Clear the profiling counters
func (o *CACHE_Type) SetPROFILINGCLEAR_CLEAR(value uint32) {
	volatile.StoreUint32(&o.PROFILINGCLEAR.Reg, volatile.LoadUint32(&o.PROFILINGCLEAR.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetPROFILINGCLEAR_CLEAR() uint32 {
	return volatile.LoadUint32(&o.PROFILINGCLEAR.Reg) & 0x1
}

// CACHE.MODE: Cache mode. Switching from Cache to RAM mode causes the RAM to be cleared. Switching from RAM to Cache mode causes the cache to be invalidated.
func (o *CACHE_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x1
}

// CACHE.DEBUGLOCK: Lock debug mode Ignored in RAM mode.
func (o *CACHE_Type) SetDEBUGLOCK(value uint32) {
	volatile.StoreUint32(&o.DEBUGLOCK.Reg, volatile.LoadUint32(&o.DEBUGLOCK.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetDEBUGLOCK() uint32 {
	return volatile.LoadUint32(&o.DEBUGLOCK.Reg) & 0x1
}

// CACHE.ERASESTATUS: Cache erase status
func (o *CACHE_Type) SetERASESTATUS(value uint32) {
	volatile.StoreUint32(&o.ERASESTATUS.Reg, volatile.LoadUint32(&o.ERASESTATUS.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetERASESTATUS() uint32 {
	return volatile.LoadUint32(&o.ERASESTATUS.Reg) & 0x1
}

// CACHE.WRITELOCK: Lock cache updates. Prevents updating of cache content on cache misses, but will continue to lookup instruction/data fetches in content already present in the cache. Ignored in RAM mode.
func (o *CACHE_Type) SetWRITELOCK(value uint32) {
	volatile.StoreUint32(&o.WRITELOCK.Reg, volatile.LoadUint32(&o.WRITELOCK.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetWRITELOCK() uint32 {
	return volatile.LoadUint32(&o.WRITELOCK.Reg) & 0x1
}

type CACHE_PROFILING_Type struct {
	IHIT  volatile.Register32 // 0x400
	IMISS volatile.Register32 // 0x404
	DHIT  volatile.Register32 // 0x408
	DMISS volatile.Register32 // 0x40C
	_     [16]byte
}

// CACHE_PROFILING.IHIT: Description cluster: Instruction fetch cache hit counter for cache region n, where n=0 means Flash and n=1 means XIP.
func (o *CACHE_PROFILING_Type) SetIHIT(value uint32) {
	volatile.StoreUint32(&o.IHIT.Reg, value)
}
func (o *CACHE_PROFILING_Type) GetIHIT() uint32 {
	return volatile.LoadUint32(&o.IHIT.Reg)
}

// CACHE_PROFILING.IMISS: Description cluster: Instruction fetch cache miss counter for cache region n, where n=0 means Flash and n=1 means XIP.
func (o *CACHE_PROFILING_Type) SetIMISS(value uint32) {
	volatile.StoreUint32(&o.IMISS.Reg, value)
}
func (o *CACHE_PROFILING_Type) GetIMISS() uint32 {
	return volatile.LoadUint32(&o.IMISS.Reg)
}

// CACHE_PROFILING.DHIT: Description cluster: Data fetch cache hit counter for cache region n, where n=0 means Flash and n=1 means XIP.
func (o *CACHE_PROFILING_Type) SetDHIT(value uint32) {
	volatile.StoreUint32(&o.DHIT.Reg, value)
}
func (o *CACHE_PROFILING_Type) GetDHIT() uint32 {
	return volatile.LoadUint32(&o.DHIT.Reg)
}

// CACHE_PROFILING.DMISS: Description cluster: Data fetch cache miss counter for cache region n, where n=0 means Flash and n=1 means XIP.
func (o *CACHE_PROFILING_Type) SetDMISS(value uint32) {
	volatile.StoreUint32(&o.DMISS.Reg, value)
}
func (o *CACHE_PROFILING_Type) GetDMISS() uint32 {
	return volatile.LoadUint32(&o.DMISS.Reg)
}

// System protection unit
type SPU_Type struct {
	_                    [256]byte
	EVENTS_RAMACCERR     volatile.Register32 // 0x100
	EVENTS_FLASHACCERR   volatile.Register32 // 0x104
	EVENTS_PERIPHACCERR  volatile.Register32 // 0x108
	_                    [116]byte
	PUBLISH_RAMACCERR    volatile.Register32 // 0x180
	PUBLISH_FLASHACCERR  volatile.Register32 // 0x184
	PUBLISH_PERIPHACCERR volatile.Register32 // 0x188
	_                    [372]byte
	INTEN                volatile.Register32 // 0x300
	INTENSET             volatile.Register32 // 0x304
	INTENCLR             volatile.Register32 // 0x308
	_                    [244]byte
	CAP                  volatile.Register32 // 0x400
	CPULOCK              volatile.Register32 // 0x404
	_                    [56]byte
	EXTDOMAIN            [1]SPU_EXTDOMAIN_Type // 0x440
	_                    [64]byte
	DPPI                 [1]SPU_DPPI_Type // 0x480
	_                    [60]byte
	GPIOPORT             [2]SPU_GPIOPORT_Type // 0x4C0
	_                    [48]byte
	FLASHNSC             [2]SPU_FLASHNSC_Type // 0x500
	_                    [48]byte
	RAMNSC               [2]SPU_RAMNSC_Type // 0x540
	_                    [176]byte
	FLASHREGION          [64]SPU_FLASHREGION_Type // 0x600
	RAMREGION            [64]SPU_RAMREGION_Type   // 0x700
	PERIPHID             [256]SPU_PERIPHID_Type   // 0x800
}

// SPU.EVENTS_RAMACCERR: A security violation has been detected for the RAM memory space
func (o *SPU_Type) SetEVENTS_RAMACCERR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RAMACCERR.Reg, volatile.LoadUint32(&o.EVENTS_RAMACCERR.Reg)&^(0x1)|value)
}
func (o *SPU_Type) GetEVENTS_RAMACCERR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RAMACCERR.Reg) & 0x1
}

// SPU.EVENTS_FLASHACCERR: A security violation has been detected for the flash memory space
func (o *SPU_Type) SetEVENTS_FLASHACCERR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_FLASHACCERR.Reg, volatile.LoadUint32(&o.EVENTS_FLASHACCERR.Reg)&^(0x1)|value)
}
func (o *SPU_Type) GetEVENTS_FLASHACCERR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_FLASHACCERR.Reg) & 0x1
}

// SPU.EVENTS_PERIPHACCERR: A security violation has been detected on one or several peripherals
func (o *SPU_Type) SetEVENTS_PERIPHACCERR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_PERIPHACCERR.Reg, volatile.LoadUint32(&o.EVENTS_PERIPHACCERR.Reg)&^(0x1)|value)
}
func (o *SPU_Type) GetEVENTS_PERIPHACCERR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_PERIPHACCERR.Reg) & 0x1
}

// SPU.PUBLISH_RAMACCERR: Publish configuration for event RAMACCERR
func (o *SPU_Type) SetPUBLISH_RAMACCERR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RAMACCERR.Reg, volatile.LoadUint32(&o.PUBLISH_RAMACCERR.Reg)&^(0xff)|value)
}
func (o *SPU_Type) GetPUBLISH_RAMACCERR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RAMACCERR.Reg) & 0xff
}
func (o *SPU_Type) SetPUBLISH_RAMACCERR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RAMACCERR.Reg, volatile.LoadUint32(&o.PUBLISH_RAMACCERR.Reg)&^(0x80000000)|value<<31)
}
func (o *SPU_Type) GetPUBLISH_RAMACCERR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RAMACCERR.Reg) & 0x80000000) >> 31
}

// SPU.PUBLISH_FLASHACCERR: Publish configuration for event FLASHACCERR
func (o *SPU_Type) SetPUBLISH_FLASHACCERR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_FLASHACCERR.Reg, volatile.LoadUint32(&o.PUBLISH_FLASHACCERR.Reg)&^(0xff)|value)
}
func (o *SPU_Type) GetPUBLISH_FLASHACCERR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_FLASHACCERR.Reg) & 0xff
}
func (o *SPU_Type) SetPUBLISH_FLASHACCERR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_FLASHACCERR.Reg, volatile.LoadUint32(&o.PUBLISH_FLASHACCERR.Reg)&^(0x80000000)|value<<31)
}
func (o *SPU_Type) GetPUBLISH_FLASHACCERR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_FLASHACCERR.Reg) & 0x80000000) >> 31
}

// SPU.PUBLISH_PERIPHACCERR: Publish configuration for event PERIPHACCERR
func (o *SPU_Type) SetPUBLISH_PERIPHACCERR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_PERIPHACCERR.Reg, volatile.LoadUint32(&o.PUBLISH_PERIPHACCERR.Reg)&^(0xff)|value)
}
func (o *SPU_Type) GetPUBLISH_PERIPHACCERR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_PERIPHACCERR.Reg) & 0xff
}
func (o *SPU_Type) SetPUBLISH_PERIPHACCERR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_PERIPHACCERR.Reg, volatile.LoadUint32(&o.PUBLISH_PERIPHACCERR.Reg)&^(0x80000000)|value<<31)
}
func (o *SPU_Type) GetPUBLISH_PERIPHACCERR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_PERIPHACCERR.Reg) & 0x80000000) >> 31
}

// SPU.INTEN: Enable or disable interrupt
func (o *SPU_Type) SetINTEN_RAMACCERR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *SPU_Type) GetINTEN_RAMACCERR() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *SPU_Type) SetINTEN_FLASHACCERR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *SPU_Type) GetINTEN_FLASHACCERR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *SPU_Type) SetINTEN_PERIPHACCERR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *SPU_Type) GetINTEN_PERIPHACCERR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}

// SPU.INTENSET: Enable interrupt
func (o *SPU_Type) SetINTENSET_RAMACCERR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SPU_Type) GetINTENSET_RAMACCERR() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *SPU_Type) SetINTENSET_FLASHACCERR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SPU_Type) GetINTENSET_FLASHACCERR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SPU_Type) SetINTENSET_PERIPHACCERR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SPU_Type) GetINTENSET_PERIPHACCERR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}

// SPU.INTENCLR: Disable interrupt
func (o *SPU_Type) SetINTENCLR_RAMACCERR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SPU_Type) GetINTENCLR_RAMACCERR() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *SPU_Type) SetINTENCLR_FLASHACCERR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SPU_Type) GetINTENCLR_FLASHACCERR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SPU_Type) SetINTENCLR_PERIPHACCERR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SPU_Type) GetINTENCLR_PERIPHACCERR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}

// SPU.CAP: Show implemented features for the current device
func (o *SPU_Type) SetCAP_TZM(value uint32) {
	volatile.StoreUint32(&o.CAP.Reg, volatile.LoadUint32(&o.CAP.Reg)&^(0x1)|value)
}
func (o *SPU_Type) GetCAP_TZM() uint32 {
	return volatile.LoadUint32(&o.CAP.Reg) & 0x1
}

// SPU.CPULOCK: Configure bits to lock down CPU features at runtime
func (o *SPU_Type) SetCPULOCK_LOCKSVTAIRCR(value uint32) {
	volatile.StoreUint32(&o.CPULOCK.Reg, volatile.LoadUint32(&o.CPULOCK.Reg)&^(0x1)|value)
}
func (o *SPU_Type) GetCPULOCK_LOCKSVTAIRCR() uint32 {
	return volatile.LoadUint32(&o.CPULOCK.Reg) & 0x1
}
func (o *SPU_Type) SetCPULOCK_LOCKNSVTOR(value uint32) {
	volatile.StoreUint32(&o.CPULOCK.Reg, volatile.LoadUint32(&o.CPULOCK.Reg)&^(0x2)|value<<1)
}
func (o *SPU_Type) GetCPULOCK_LOCKNSVTOR() uint32 {
	return (volatile.LoadUint32(&o.CPULOCK.Reg) & 0x2) >> 1
}
func (o *SPU_Type) SetCPULOCK_LOCKSMPU(value uint32) {
	volatile.StoreUint32(&o.CPULOCK.Reg, volatile.LoadUint32(&o.CPULOCK.Reg)&^(0x4)|value<<2)
}
func (o *SPU_Type) GetCPULOCK_LOCKSMPU() uint32 {
	return (volatile.LoadUint32(&o.CPULOCK.Reg) & 0x4) >> 2
}
func (o *SPU_Type) SetCPULOCK_LOCKNSMPU(value uint32) {
	volatile.StoreUint32(&o.CPULOCK.Reg, volatile.LoadUint32(&o.CPULOCK.Reg)&^(0x8)|value<<3)
}
func (o *SPU_Type) GetCPULOCK_LOCKNSMPU() uint32 {
	return (volatile.LoadUint32(&o.CPULOCK.Reg) & 0x8) >> 3
}
func (o *SPU_Type) SetCPULOCK_LOCKSAU(value uint32) {
	volatile.StoreUint32(&o.CPULOCK.Reg, volatile.LoadUint32(&o.CPULOCK.Reg)&^(0x10)|value<<4)
}
func (o *SPU_Type) GetCPULOCK_LOCKSAU() uint32 {
	return (volatile.LoadUint32(&o.CPULOCK.Reg) & 0x10) >> 4
}

type SPU_EXTDOMAIN_Type struct {
	PERM volatile.Register32 // 0x440
}

// SPU_EXTDOMAIN.PERM: Description cluster: Access for bus access generated from the external domain n List capabilities of the external domain n
func (o *SPU_EXTDOMAIN_Type) SetPERM_SECUREMAPPING(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x3)|value)
}
func (o *SPU_EXTDOMAIN_Type) GetPERM_SECUREMAPPING() uint32 {
	return volatile.LoadUint32(&o.PERM.Reg) & 0x3
}
func (o *SPU_EXTDOMAIN_Type) SetPERM_SECATTR(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x10)|value<<4)
}
func (o *SPU_EXTDOMAIN_Type) GetPERM_SECATTR() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x10) >> 4
}
func (o *SPU_EXTDOMAIN_Type) SetPERM_LOCK(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x100)|value<<8)
}
func (o *SPU_EXTDOMAIN_Type) GetPERM_LOCK() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x100) >> 8
}

type SPU_DPPI_Type struct {
	PERM volatile.Register32 // 0x480
	LOCK volatile.Register32 // 0x484
}

// SPU_DPPI.PERM: Description cluster: Select between secure and non-secure attribute for the DPPI channels.
func (o *SPU_DPPI_Type) SetPERM_CHANNEL0(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x1)|value)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL0() uint32 {
	return volatile.LoadUint32(&o.PERM.Reg) & 0x1
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL1(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x2)|value<<1)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL1() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x2) >> 1
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL2(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x4)|value<<2)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL2() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x4) >> 2
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL3(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x8)|value<<3)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL3() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x8) >> 3
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL4(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x10)|value<<4)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL4() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x10) >> 4
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL5(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x20)|value<<5)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL5() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x20) >> 5
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL6(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x40)|value<<6)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL6() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x40) >> 6
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL7(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x80)|value<<7)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL7() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x80) >> 7
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL8(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x100)|value<<8)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL8() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x100) >> 8
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL9(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x200)|value<<9)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL9() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x200) >> 9
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL10(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x400)|value<<10)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL10() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x400) >> 10
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL11(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x800)|value<<11)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL11() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x800) >> 11
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL12(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x1000)|value<<12)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL12() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x1000) >> 12
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL13(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x2000)|value<<13)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL13() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x2000) >> 13
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL14(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x4000)|value<<14)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL14() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x4000) >> 14
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL15(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x8000)|value<<15)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL15() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x8000) >> 15
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL16(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x10000)|value<<16)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL16() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x10000) >> 16
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL17(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x20000)|value<<17)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL17() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x20000) >> 17
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL18(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x40000)|value<<18)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL18() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x40000) >> 18
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL19(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x80000)|value<<19)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL19() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x80000) >> 19
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL20(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x100000)|value<<20)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL20() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x100000) >> 20
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL21(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x200000)|value<<21)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL21() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x200000) >> 21
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL22(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x400000)|value<<22)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL22() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x400000) >> 22
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL23(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x800000)|value<<23)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL23() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x800000) >> 23
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL24(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x1000000)|value<<24)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL24() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x1000000) >> 24
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL25(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x2000000)|value<<25)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL25() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x2000000) >> 25
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL26(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x4000000)|value<<26)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL26() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x4000000) >> 26
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL27(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x8000000)|value<<27)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL27() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x8000000) >> 27
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL28(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x10000000)|value<<28)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL28() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x10000000) >> 28
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL29(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x20000000)|value<<29)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL29() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x20000000) >> 29
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL30(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x40000000)|value<<30)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL30() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x40000000) >> 30
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL31(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x80000000)|value<<31)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL31() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x80000000) >> 31
}

// SPU_DPPI.LOCK: Description cluster: Prevent further modification of the corresponding PERM register
func (o *SPU_DPPI_Type) SetLOCK(value uint32) {
	volatile.StoreUint32(&o.LOCK.Reg, volatile.LoadUint32(&o.LOCK.Reg)&^(0x1)|value)
}
func (o *SPU_DPPI_Type) GetLOCK() uint32 {
	return volatile.LoadUint32(&o.LOCK.Reg) & 0x1
}

type SPU_GPIOPORT_Type struct {
	PERM volatile.Register32 // 0x4C0
	LOCK volatile.Register32 // 0x4C4
}

// SPU_GPIOPORT.PERM: Description cluster: Select between secure and non-secure attribute for pins 0 to 31 of port n.
func (o *SPU_GPIOPORT_Type) SetPERM_PIN0(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x1)|value)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN0() uint32 {
	return volatile.LoadUint32(&o.PERM.Reg) & 0x1
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN1(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x2)|value<<1)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN1() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x2) >> 1
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN2(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x4)|value<<2)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN2() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x4) >> 2
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN3(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x8)|value<<3)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN3() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x8) >> 3
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN4(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x10)|value<<4)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN4() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x10) >> 4
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN5(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x20)|value<<5)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN5() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x20) >> 5
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN6(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x40)|value<<6)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN6() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x40) >> 6
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN7(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x80)|value<<7)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN7() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x80) >> 7
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN8(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x100)|value<<8)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN8() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x100) >> 8
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN9(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x200)|value<<9)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN9() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x200) >> 9
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN10(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x400)|value<<10)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN10() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x400) >> 10
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN11(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x800)|value<<11)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN11() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x800) >> 11
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN12(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x1000)|value<<12)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN12() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x1000) >> 12
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN13(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x2000)|value<<13)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN13() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x2000) >> 13
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN14(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x4000)|value<<14)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN14() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x4000) >> 14
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN15(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x8000)|value<<15)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN15() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x8000) >> 15
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN16(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x10000)|value<<16)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN16() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x10000) >> 16
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN17(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x20000)|value<<17)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN17() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x20000) >> 17
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN18(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x40000)|value<<18)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN18() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x40000) >> 18
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN19(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x80000)|value<<19)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN19() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x80000) >> 19
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN20(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x100000)|value<<20)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN20() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x100000) >> 20
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN21(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x200000)|value<<21)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN21() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x200000) >> 21
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN22(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x400000)|value<<22)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN22() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x400000) >> 22
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN23(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x800000)|value<<23)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN23() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x800000) >> 23
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN24(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x1000000)|value<<24)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN24() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x1000000) >> 24
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN25(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x2000000)|value<<25)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN25() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x2000000) >> 25
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN26(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x4000000)|value<<26)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN26() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x4000000) >> 26
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN27(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x8000000)|value<<27)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN27() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x8000000) >> 27
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN28(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x10000000)|value<<28)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN28() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x10000000) >> 28
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN29(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x20000000)|value<<29)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN29() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x20000000) >> 29
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN30(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x40000000)|value<<30)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN30() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x40000000) >> 30
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN31(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x80000000)|value<<31)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN31() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x80000000) >> 31
}

// SPU_GPIOPORT.LOCK: Description cluster: Prevent further modification of the corresponding PERM register
func (o *SPU_GPIOPORT_Type) SetLOCK(value uint32) {
	volatile.StoreUint32(&o.LOCK.Reg, volatile.LoadUint32(&o.LOCK.Reg)&^(0x1)|value)
}
func (o *SPU_GPIOPORT_Type) GetLOCK() uint32 {
	return volatile.LoadUint32(&o.LOCK.Reg) & 0x1
}

type SPU_FLASHNSC_Type struct {
	REGION volatile.Register32 // 0x500
	SIZE   volatile.Register32 // 0x504
}

// SPU_FLASHNSC.REGION: Description cluster: Define which flash region can contain the non-secure callable (NSC) region n
func (o *SPU_FLASHNSC_Type) SetREGION(value uint32) {
	volatile.StoreUint32(&o.REGION.Reg, volatile.LoadUint32(&o.REGION.Reg)&^(0x3f)|value)
}
func (o *SPU_FLASHNSC_Type) GetREGION() uint32 {
	return volatile.LoadUint32(&o.REGION.Reg) & 0x3f
}
func (o *SPU_FLASHNSC_Type) SetREGION_LOCK(value uint32) {
	volatile.StoreUint32(&o.REGION.Reg, volatile.LoadUint32(&o.REGION.Reg)&^(0x100)|value<<8)
}
func (o *SPU_FLASHNSC_Type) GetREGION_LOCK() uint32 {
	return (volatile.LoadUint32(&o.REGION.Reg) & 0x100) >> 8
}

// SPU_FLASHNSC.SIZE: Description cluster: Define the size of the non-secure callable (NSC) region n
func (o *SPU_FLASHNSC_Type) SetSIZE(value uint32) {
	volatile.StoreUint32(&o.SIZE.Reg, volatile.LoadUint32(&o.SIZE.Reg)&^(0xf)|value)
}
func (o *SPU_FLASHNSC_Type) GetSIZE() uint32 {
	return volatile.LoadUint32(&o.SIZE.Reg) & 0xf
}
func (o *SPU_FLASHNSC_Type) SetSIZE_LOCK(value uint32) {
	volatile.StoreUint32(&o.SIZE.Reg, volatile.LoadUint32(&o.SIZE.Reg)&^(0x100)|value<<8)
}
func (o *SPU_FLASHNSC_Type) GetSIZE_LOCK() uint32 {
	return (volatile.LoadUint32(&o.SIZE.Reg) & 0x100) >> 8
}

type SPU_RAMNSC_Type struct {
	REGION volatile.Register32 // 0x540
	SIZE   volatile.Register32 // 0x544
}

// SPU_RAMNSC.REGION: Description cluster: Define which RAM region can contain the non-secure callable (NSC) region n
func (o *SPU_RAMNSC_Type) SetREGION(value uint32) {
	volatile.StoreUint32(&o.REGION.Reg, volatile.LoadUint32(&o.REGION.Reg)&^(0x3f)|value)
}
func (o *SPU_RAMNSC_Type) GetREGION() uint32 {
	return volatile.LoadUint32(&o.REGION.Reg) & 0x3f
}
func (o *SPU_RAMNSC_Type) SetREGION_LOCK(value uint32) {
	volatile.StoreUint32(&o.REGION.Reg, volatile.LoadUint32(&o.REGION.Reg)&^(0x100)|value<<8)
}
func (o *SPU_RAMNSC_Type) GetREGION_LOCK() uint32 {
	return (volatile.LoadUint32(&o.REGION.Reg) & 0x100) >> 8
}

// SPU_RAMNSC.SIZE: Description cluster: Define the size of the non-secure callable (NSC) region n
func (o *SPU_RAMNSC_Type) SetSIZE(value uint32) {
	volatile.StoreUint32(&o.SIZE.Reg, volatile.LoadUint32(&o.SIZE.Reg)&^(0xf)|value)
}
func (o *SPU_RAMNSC_Type) GetSIZE() uint32 {
	return volatile.LoadUint32(&o.SIZE.Reg) & 0xf
}
func (o *SPU_RAMNSC_Type) SetSIZE_LOCK(value uint32) {
	volatile.StoreUint32(&o.SIZE.Reg, volatile.LoadUint32(&o.SIZE.Reg)&^(0x100)|value<<8)
}
func (o *SPU_RAMNSC_Type) GetSIZE_LOCK() uint32 {
	return (volatile.LoadUint32(&o.SIZE.Reg) & 0x100) >> 8
}

type SPU_FLASHREGION_Type struct {
	PERM volatile.Register32 // 0x600
}

// SPU_FLASHREGION.PERM: Description cluster: Access permissions for flash region n
func (o *SPU_FLASHREGION_Type) SetPERM_EXECUTE(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x1)|value)
}
func (o *SPU_FLASHREGION_Type) GetPERM_EXECUTE() uint32 {
	return volatile.LoadUint32(&o.PERM.Reg) & 0x1
}
func (o *SPU_FLASHREGION_Type) SetPERM_WRITE(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x2)|value<<1)
}
func (o *SPU_FLASHREGION_Type) GetPERM_WRITE() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x2) >> 1
}
func (o *SPU_FLASHREGION_Type) SetPERM_READ(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x4)|value<<2)
}
func (o *SPU_FLASHREGION_Type) GetPERM_READ() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x4) >> 2
}
func (o *SPU_FLASHREGION_Type) SetPERM_SECATTR(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x10)|value<<4)
}
func (o *SPU_FLASHREGION_Type) GetPERM_SECATTR() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x10) >> 4
}
func (o *SPU_FLASHREGION_Type) SetPERM_LOCK(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x100)|value<<8)
}
func (o *SPU_FLASHREGION_Type) GetPERM_LOCK() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x100) >> 8
}

type SPU_RAMREGION_Type struct {
	PERM volatile.Register32 // 0x700
}

// SPU_RAMREGION.PERM: Description cluster: Access permissions for RAM region n
func (o *SPU_RAMREGION_Type) SetPERM_EXECUTE(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x1)|value)
}
func (o *SPU_RAMREGION_Type) GetPERM_EXECUTE() uint32 {
	return volatile.LoadUint32(&o.PERM.Reg) & 0x1
}
func (o *SPU_RAMREGION_Type) SetPERM_WRITE(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x2)|value<<1)
}
func (o *SPU_RAMREGION_Type) GetPERM_WRITE() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x2) >> 1
}
func (o *SPU_RAMREGION_Type) SetPERM_READ(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x4)|value<<2)
}
func (o *SPU_RAMREGION_Type) GetPERM_READ() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x4) >> 2
}
func (o *SPU_RAMREGION_Type) SetPERM_SECATTR(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x10)|value<<4)
}
func (o *SPU_RAMREGION_Type) GetPERM_SECATTR() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x10) >> 4
}
func (o *SPU_RAMREGION_Type) SetPERM_LOCK(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x100)|value<<8)
}
func (o *SPU_RAMREGION_Type) GetPERM_LOCK() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x100) >> 8
}

type SPU_PERIPHID_Type struct {
	PERM volatile.Register32 // 0x800
}

// SPU_PERIPHID.PERM: Description cluster: List capabilities and access permissions for the peripheral with ID n
func (o *SPU_PERIPHID_Type) SetPERM_SECUREMAPPING(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x3)|value)
}
func (o *SPU_PERIPHID_Type) GetPERM_SECUREMAPPING() uint32 {
	return volatile.LoadUint32(&o.PERM.Reg) & 0x3
}
func (o *SPU_PERIPHID_Type) SetPERM_DMA(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0xc)|value<<2)
}
func (o *SPU_PERIPHID_Type) GetPERM_DMA() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0xc) >> 2
}
func (o *SPU_PERIPHID_Type) SetPERM_SECATTR(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x10)|value<<4)
}
func (o *SPU_PERIPHID_Type) GetPERM_SECATTR() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x10) >> 4
}
func (o *SPU_PERIPHID_Type) SetPERM_DMASEC(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x20)|value<<5)
}
func (o *SPU_PERIPHID_Type) GetPERM_DMASEC() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x20) >> 5
}
func (o *SPU_PERIPHID_Type) SetPERM_LOCK(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x100)|value<<8)
}
func (o *SPU_PERIPHID_Type) GetPERM_LOCK() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x100) >> 8
}
func (o *SPU_PERIPHID_Type) SetPERM_PRESENT(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x80000000)|value<<31)
}
func (o *SPU_PERIPHID_Type) GetPERM_PRESENT() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x80000000) >> 31
}

// Oscillator control 0
type OSCILLATORS_Type struct {
	_           [1476]byte
	XOSC32MCAPS volatile.Register32 // 0x5C4
	_           [248]byte
	XOSC32KI    OSCILLATORS_XOSC32KI_Type // 0x6C0
}

// OSCILLATORS.XOSC32MCAPS: Programmable capacitance of XC1 and XC2
func (o *OSCILLATORS_Type) SetXOSC32MCAPS_CAPVALUE(value uint32) {
	volatile.StoreUint32(&o.XOSC32MCAPS.Reg, volatile.LoadUint32(&o.XOSC32MCAPS.Reg)&^(0x1f)|value)
}
func (o *OSCILLATORS_Type) GetXOSC32MCAPS_CAPVALUE() uint32 {
	return volatile.LoadUint32(&o.XOSC32MCAPS.Reg) & 0x1f
}
func (o *OSCILLATORS_Type) SetXOSC32MCAPS_ENABLE(value uint32) {
	volatile.StoreUint32(&o.XOSC32MCAPS.Reg, volatile.LoadUint32(&o.XOSC32MCAPS.Reg)&^(0x100)|value<<8)
}
func (o *OSCILLATORS_Type) GetXOSC32MCAPS_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.XOSC32MCAPS.Reg) & 0x100) >> 8
}

type OSCILLATORS_XOSC32KI_Type struct {
	BYPASS volatile.Register32 // 0x6C0
	_      [12]byte
	INTCAP volatile.Register32 // 0x6D0
}

// OSCILLATORS_XOSC32KI.BYPASS: Enable or disable bypass of LFCLK crystal oscillator with external clock source
func (o *OSCILLATORS_XOSC32KI_Type) SetBYPASS(value uint32) {
	volatile.StoreUint32(&o.BYPASS.Reg, volatile.LoadUint32(&o.BYPASS.Reg)&^(0x1)|value)
}
func (o *OSCILLATORS_XOSC32KI_Type) GetBYPASS() uint32 {
	return volatile.LoadUint32(&o.BYPASS.Reg) & 0x1
}

// OSCILLATORS_XOSC32KI.INTCAP: Control usage of internal load capacitors
func (o *OSCILLATORS_XOSC32KI_Type) SetINTCAP(value uint32) {
	volatile.StoreUint32(&o.INTCAP.Reg, volatile.LoadUint32(&o.INTCAP.Reg)&^(0x3)|value)
}
func (o *OSCILLATORS_XOSC32KI_Type) GetINTCAP() uint32 {
	return volatile.LoadUint32(&o.INTCAP.Reg) & 0x3
}

// Voltage regulators 0
type REGULATORS_Type struct {
	_             [1064]byte
	MAINREGSTATUS volatile.Register32 // 0x428
	_             [212]byte
	SYSTEMOFF     volatile.Register32 // 0x500
	_             [12]byte
	POFCON        volatile.Register32 // 0x510
	_             [496]byte
	VREGMAIN      REGULATORS_VREGMAIN_Type // 0x704
	_             [504]byte
	VREGRADIO     REGULATORS_VREGRADIO_Type // 0x900
	_             [504]byte
	VREGH         REGULATORS_VREGH_Type // 0xB00
}

// REGULATORS.MAINREGSTATUS: Main supply status
func (o *REGULATORS_Type) SetMAINREGSTATUS_VREGH(value uint32) {
	volatile.StoreUint32(&o.MAINREGSTATUS.Reg, volatile.LoadUint32(&o.MAINREGSTATUS.Reg)&^(0x1)|value)
}
func (o *REGULATORS_Type) GetMAINREGSTATUS_VREGH() uint32 {
	return volatile.LoadUint32(&o.MAINREGSTATUS.Reg) & 0x1
}

// REGULATORS.SYSTEMOFF: System OFF register
func (o *REGULATORS_Type) SetSYSTEMOFF(value uint32) {
	volatile.StoreUint32(&o.SYSTEMOFF.Reg, volatile.LoadUint32(&o.SYSTEMOFF.Reg)&^(0x1)|value)
}
func (o *REGULATORS_Type) GetSYSTEMOFF() uint32 {
	return volatile.LoadUint32(&o.SYSTEMOFF.Reg) & 0x1
}

// REGULATORS.POFCON: Power-fail comparator configuration
func (o *REGULATORS_Type) SetPOFCON_POF(value uint32) {
	volatile.StoreUint32(&o.POFCON.Reg, volatile.LoadUint32(&o.POFCON.Reg)&^(0x1)|value)
}
func (o *REGULATORS_Type) GetPOFCON_POF() uint32 {
	return volatile.LoadUint32(&o.POFCON.Reg) & 0x1
}
func (o *REGULATORS_Type) SetPOFCON_THRESHOLD(value uint32) {
	volatile.StoreUint32(&o.POFCON.Reg, volatile.LoadUint32(&o.POFCON.Reg)&^(0x1e)|value<<1)
}
func (o *REGULATORS_Type) GetPOFCON_THRESHOLD() uint32 {
	return (volatile.LoadUint32(&o.POFCON.Reg) & 0x1e) >> 1
}
func (o *REGULATORS_Type) SetPOFCON_THRESHOLDVDDH(value uint32) {
	volatile.StoreUint32(&o.POFCON.Reg, volatile.LoadUint32(&o.POFCON.Reg)&^(0xf00)|value<<8)
}
func (o *REGULATORS_Type) GetPOFCON_THRESHOLDVDDH() uint32 {
	return (volatile.LoadUint32(&o.POFCON.Reg) & 0xf00) >> 8
}

type REGULATORS_VREGMAIN_Type struct {
	DCDCEN volatile.Register32 // 0x704
}

// REGULATORS_VREGMAIN.DCDCEN: DC/DC enable register for VREGMAIN
func (o *REGULATORS_VREGMAIN_Type) SetDCDCEN(value uint32) {
	volatile.StoreUint32(&o.DCDCEN.Reg, volatile.LoadUint32(&o.DCDCEN.Reg)&^(0x1)|value)
}
func (o *REGULATORS_VREGMAIN_Type) GetDCDCEN() uint32 {
	return volatile.LoadUint32(&o.DCDCEN.Reg) & 0x1
}

type REGULATORS_VREGRADIO_Type struct {
	_      [4]byte
	DCDCEN volatile.Register32 // 0x904
}

// REGULATORS_VREGRADIO.DCDCEN: DC/DC enable register for VREGRADIO
func (o *REGULATORS_VREGRADIO_Type) SetDCDCEN(value uint32) {
	volatile.StoreUint32(&o.DCDCEN.Reg, volatile.LoadUint32(&o.DCDCEN.Reg)&^(0x1)|value)
}
func (o *REGULATORS_VREGRADIO_Type) GetDCDCEN() uint32 {
	return volatile.LoadUint32(&o.DCDCEN.Reg) & 0x1
}

type REGULATORS_VREGH_Type struct {
	DCDCEN volatile.Register32 // 0xB00
}

// REGULATORS_VREGH.DCDCEN: DC/DC enable register for VREGH
func (o *REGULATORS_VREGH_Type) SetDCDCEN(value uint32) {
	volatile.StoreUint32(&o.DCDCEN.Reg, volatile.LoadUint32(&o.DCDCEN.Reg)&^(0x1)|value)
}
func (o *REGULATORS_VREGH_Type) GetDCDCEN() uint32 {
	return volatile.LoadUint32(&o.DCDCEN.Reg) & 0x1
}

// Clock management 0
type CLOCK_Type struct {
	TASKS_HFCLKSTART          volatile.Register32 // 0x0
	TASKS_HFCLKSTOP           volatile.Register32 // 0x4
	TASKS_LFCLKSTART          volatile.Register32 // 0x8
	TASKS_LFCLKSTOP           volatile.Register32 // 0xC
	TASKS_CAL                 volatile.Register32 // 0x10
	_                         [4]byte
	TASKS_HFCLKAUDIOSTART     volatile.Register32 // 0x18
	TASKS_HFCLKAUDIOSTOP      volatile.Register32 // 0x1C
	TASKS_HFCLK192MSTART      volatile.Register32 // 0x20
	TASKS_HFCLK192MSTOP       volatile.Register32 // 0x24
	_                         [88]byte
	SUBSCRIBE_HFCLKSTART      volatile.Register32 // 0x80
	SUBSCRIBE_HFCLKSTOP       volatile.Register32 // 0x84
	SUBSCRIBE_LFCLKSTART      volatile.Register32 // 0x88
	SUBSCRIBE_LFCLKSTOP       volatile.Register32 // 0x8C
	SUBSCRIBE_CAL             volatile.Register32 // 0x90
	_                         [4]byte
	SUBSCRIBE_HFCLKAUDIOSTART volatile.Register32 // 0x98
	SUBSCRIBE_HFCLKAUDIOSTOP  volatile.Register32 // 0x9C
	SUBSCRIBE_HFCLK192MSTART  volatile.Register32 // 0xA0
	SUBSCRIBE_HFCLK192MSTOP   volatile.Register32 // 0xA4
	_                         [88]byte
	EVENTS_HFCLKSTARTED       volatile.Register32 // 0x100
	EVENTS_LFCLKSTARTED       volatile.Register32 // 0x104
	_                         [20]byte
	EVENTS_DONE               volatile.Register32 // 0x11C
	EVENTS_HFCLKAUDIOSTARTED  volatile.Register32 // 0x120
	EVENTS_HFCLK192MSTARTED   volatile.Register32 // 0x124
	_                         [88]byte
	PUBLISH_HFCLKSTARTED      volatile.Register32 // 0x180
	PUBLISH_LFCLKSTARTED      volatile.Register32 // 0x184
	_                         [20]byte
	PUBLISH_DONE              volatile.Register32 // 0x19C
	PUBLISH_HFCLKAUDIOSTARTED volatile.Register32 // 0x1A0
	PUBLISH_HFCLK192MSTARTED  volatile.Register32 // 0x1A4
	_                         [344]byte
	INTEN                     volatile.Register32 // 0x300
	INTENSET                  volatile.Register32 // 0x304
	INTENCLR                  volatile.Register32 // 0x308
	INTPEND                   volatile.Register32 // 0x30C
	_                         [248]byte
	HFCLKRUN                  volatile.Register32 // 0x408
	HFCLKSTAT                 volatile.Register32 // 0x40C
	_                         [4]byte
	LFCLKRUN                  volatile.Register32 // 0x414
	LFCLKSTAT                 volatile.Register32 // 0x418
	LFCLKSRCCOPY              volatile.Register32 // 0x41C
	_                         [48]byte
	HFCLKAUDIORUN             volatile.Register32 // 0x450
	HFCLKAUDIOSTAT            volatile.Register32 // 0x454
	HFCLK192MRUN              volatile.Register32 // 0x458
	HFCLK192MSTAT             volatile.Register32 // 0x45C
	_                         [180]byte
	HFCLKSRC                  volatile.Register32 // 0x514
	LFCLKSRC                  volatile.Register32 // 0x518
	_                         [60]byte
	HFCLKCTRL                 volatile.Register32   // 0x558
	HFCLKAUDIO                CLOCK_HFCLKAUDIO_Type // 0x55C
	_                         [16]byte
	HFCLKALWAYSRUN            volatile.Register32 // 0x570
	LFCLKALWAYSRUN            volatile.Register32 // 0x574
	_                         [4]byte
	HFCLKAUDIOALWAYSRUN       volatile.Register32 // 0x57C
	HFCLK192MSRC              volatile.Register32 // 0x580
	HFCLK192MALWAYSRUN        volatile.Register32 // 0x584
	_                         [48]byte
	HFCLK192MCTRL             volatile.Register32 // 0x5B8
}

// CLOCK.TASKS_HFCLKSTART: Start HFCLK128M/HFCLK64M source as selected in HFCLKSRC
func (o *CLOCK_Type) SetTASKS_HFCLKSTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_HFCLKSTART.Reg, volatile.LoadUint32(&o.TASKS_HFCLKSTART.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_HFCLKSTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_HFCLKSTART.Reg) & 0x1
}

// CLOCK.TASKS_HFCLKSTOP: Stop HFCLK128M/HFCLK64M source
func (o *CLOCK_Type) SetTASKS_HFCLKSTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_HFCLKSTOP.Reg, volatile.LoadUint32(&o.TASKS_HFCLKSTOP.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_HFCLKSTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_HFCLKSTOP.Reg) & 0x1
}

// CLOCK.TASKS_LFCLKSTART: Start LFCLK source as selected in LFCLKSRC
func (o *CLOCK_Type) SetTASKS_LFCLKSTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_LFCLKSTART.Reg, volatile.LoadUint32(&o.TASKS_LFCLKSTART.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_LFCLKSTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_LFCLKSTART.Reg) & 0x1
}

// CLOCK.TASKS_LFCLKSTOP: Stop LFCLK source
func (o *CLOCK_Type) SetTASKS_LFCLKSTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_LFCLKSTOP.Reg, volatile.LoadUint32(&o.TASKS_LFCLKSTOP.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_LFCLKSTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_LFCLKSTOP.Reg) & 0x1
}

// CLOCK.TASKS_CAL: Start calibration of LFRC oscillator
func (o *CLOCK_Type) SetTASKS_CAL(value uint32) {
	volatile.StoreUint32(&o.TASKS_CAL.Reg, volatile.LoadUint32(&o.TASKS_CAL.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_CAL() uint32 {
	return volatile.LoadUint32(&o.TASKS_CAL.Reg) & 0x1
}

// CLOCK.TASKS_HFCLKAUDIOSTART: Start HFCLKAUDIO source
func (o *CLOCK_Type) SetTASKS_HFCLKAUDIOSTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_HFCLKAUDIOSTART.Reg, volatile.LoadUint32(&o.TASKS_HFCLKAUDIOSTART.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_HFCLKAUDIOSTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_HFCLKAUDIOSTART.Reg) & 0x1
}

// CLOCK.TASKS_HFCLKAUDIOSTOP: Stop HFCLKAUDIO source
func (o *CLOCK_Type) SetTASKS_HFCLKAUDIOSTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_HFCLKAUDIOSTOP.Reg, volatile.LoadUint32(&o.TASKS_HFCLKAUDIOSTOP.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_HFCLKAUDIOSTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_HFCLKAUDIOSTOP.Reg) & 0x1
}

// CLOCK.TASKS_HFCLK192MSTART: Start HFCLK192M source as selected in HFCLK192MSRC
func (o *CLOCK_Type) SetTASKS_HFCLK192MSTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_HFCLK192MSTART.Reg, volatile.LoadUint32(&o.TASKS_HFCLK192MSTART.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_HFCLK192MSTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_HFCLK192MSTART.Reg) & 0x1
}

// CLOCK.TASKS_HFCLK192MSTOP: Stop HFCLK192M source
func (o *CLOCK_Type) SetTASKS_HFCLK192MSTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_HFCLK192MSTOP.Reg, volatile.LoadUint32(&o.TASKS_HFCLK192MSTOP.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_HFCLK192MSTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_HFCLK192MSTOP.Reg) & 0x1
}

// CLOCK.SUBSCRIBE_HFCLKSTART: Subscribe configuration for task HFCLKSTART
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLKSTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLKSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTART.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLKSTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTART.Reg) & 0xff
}
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLKSTART_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLKSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTART.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLKSTART_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTART.Reg) & 0x80000000) >> 31
}

// CLOCK.SUBSCRIBE_HFCLKSTOP: Subscribe configuration for task HFCLKSTOP
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLKSTOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLKSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTOP.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLKSTOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTOP.Reg) & 0xff
}
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLKSTOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLKSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTOP.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLKSTOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTOP.Reg) & 0x80000000) >> 31
}

// CLOCK.SUBSCRIBE_LFCLKSTART: Subscribe configuration for task LFCLKSTART
func (o *CLOCK_Type) SetSUBSCRIBE_LFCLKSTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_LFCLKSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTART.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetSUBSCRIBE_LFCLKSTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTART.Reg) & 0xff
}
func (o *CLOCK_Type) SetSUBSCRIBE_LFCLKSTART_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_LFCLKSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTART.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetSUBSCRIBE_LFCLKSTART_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTART.Reg) & 0x80000000) >> 31
}

// CLOCK.SUBSCRIBE_LFCLKSTOP: Subscribe configuration for task LFCLKSTOP
func (o *CLOCK_Type) SetSUBSCRIBE_LFCLKSTOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_LFCLKSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTOP.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetSUBSCRIBE_LFCLKSTOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTOP.Reg) & 0xff
}
func (o *CLOCK_Type) SetSUBSCRIBE_LFCLKSTOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_LFCLKSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTOP.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetSUBSCRIBE_LFCLKSTOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTOP.Reg) & 0x80000000) >> 31
}

// CLOCK.SUBSCRIBE_CAL: Subscribe configuration for task CAL
func (o *CLOCK_Type) SetSUBSCRIBE_CAL_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CAL.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CAL.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetSUBSCRIBE_CAL_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CAL.Reg) & 0xff
}
func (o *CLOCK_Type) SetSUBSCRIBE_CAL_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CAL.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CAL.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetSUBSCRIBE_CAL_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CAL.Reg) & 0x80000000) >> 31
}

// CLOCK.SUBSCRIBE_HFCLKAUDIOSTART: Subscribe configuration for task HFCLKAUDIOSTART
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLKAUDIOSTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLKAUDIOSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLKAUDIOSTART.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLKAUDIOSTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_HFCLKAUDIOSTART.Reg) & 0xff
}
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLKAUDIOSTART_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLKAUDIOSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLKAUDIOSTART.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLKAUDIOSTART_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_HFCLKAUDIOSTART.Reg) & 0x80000000) >> 31
}

// CLOCK.SUBSCRIBE_HFCLKAUDIOSTOP: Subscribe configuration for task HFCLKAUDIOSTOP
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLKAUDIOSTOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLKAUDIOSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLKAUDIOSTOP.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLKAUDIOSTOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_HFCLKAUDIOSTOP.Reg) & 0xff
}
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLKAUDIOSTOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLKAUDIOSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLKAUDIOSTOP.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLKAUDIOSTOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_HFCLKAUDIOSTOP.Reg) & 0x80000000) >> 31
}

// CLOCK.SUBSCRIBE_HFCLK192MSTART: Subscribe configuration for task HFCLK192MSTART
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLK192MSTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLK192MSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLK192MSTART.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLK192MSTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_HFCLK192MSTART.Reg) & 0xff
}
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLK192MSTART_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLK192MSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLK192MSTART.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLK192MSTART_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_HFCLK192MSTART.Reg) & 0x80000000) >> 31
}

// CLOCK.SUBSCRIBE_HFCLK192MSTOP: Subscribe configuration for task HFCLK192MSTOP
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLK192MSTOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLK192MSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLK192MSTOP.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLK192MSTOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_HFCLK192MSTOP.Reg) & 0xff
}
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLK192MSTOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLK192MSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLK192MSTOP.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLK192MSTOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_HFCLK192MSTOP.Reg) & 0x80000000) >> 31
}

// CLOCK.EVENTS_HFCLKSTARTED: HFCLK128M/HFCLK64M source started
func (o *CLOCK_Type) SetEVENTS_HFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_HFCLKSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_HFCLKSTARTED.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetEVENTS_HFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_HFCLKSTARTED.Reg) & 0x1
}

// CLOCK.EVENTS_LFCLKSTARTED: LFCLK source started
func (o *CLOCK_Type) SetEVENTS_LFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_LFCLKSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_LFCLKSTARTED.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetEVENTS_LFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_LFCLKSTARTED.Reg) & 0x1
}

// CLOCK.EVENTS_DONE: Calibration of LFRC oscillator complete event
func (o *CLOCK_Type) SetEVENTS_DONE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DONE.Reg, volatile.LoadUint32(&o.EVENTS_DONE.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetEVENTS_DONE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DONE.Reg) & 0x1
}

// CLOCK.EVENTS_HFCLKAUDIOSTARTED: HFCLKAUDIO source started
func (o *CLOCK_Type) SetEVENTS_HFCLKAUDIOSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_HFCLKAUDIOSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_HFCLKAUDIOSTARTED.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetEVENTS_HFCLKAUDIOSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_HFCLKAUDIOSTARTED.Reg) & 0x1
}

// CLOCK.EVENTS_HFCLK192MSTARTED: HFCLK192M source started
func (o *CLOCK_Type) SetEVENTS_HFCLK192MSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_HFCLK192MSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_HFCLK192MSTARTED.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetEVENTS_HFCLK192MSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_HFCLK192MSTARTED.Reg) & 0x1
}

// CLOCK.PUBLISH_HFCLKSTARTED: Publish configuration for event HFCLKSTARTED
func (o *CLOCK_Type) SetPUBLISH_HFCLKSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_HFCLKSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_HFCLKSTARTED.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetPUBLISH_HFCLKSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_HFCLKSTARTED.Reg) & 0xff
}
func (o *CLOCK_Type) SetPUBLISH_HFCLKSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_HFCLKSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_HFCLKSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetPUBLISH_HFCLKSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_HFCLKSTARTED.Reg) & 0x80000000) >> 31
}

// CLOCK.PUBLISH_LFCLKSTARTED: Publish configuration for event LFCLKSTARTED
func (o *CLOCK_Type) SetPUBLISH_LFCLKSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LFCLKSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_LFCLKSTARTED.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetPUBLISH_LFCLKSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_LFCLKSTARTED.Reg) & 0xff
}
func (o *CLOCK_Type) SetPUBLISH_LFCLKSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LFCLKSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_LFCLKSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetPUBLISH_LFCLKSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_LFCLKSTARTED.Reg) & 0x80000000) >> 31
}

// CLOCK.PUBLISH_DONE: Publish configuration for event DONE
func (o *CLOCK_Type) SetPUBLISH_DONE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DONE.Reg, volatile.LoadUint32(&o.PUBLISH_DONE.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetPUBLISH_DONE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_DONE.Reg) & 0xff
}
func (o *CLOCK_Type) SetPUBLISH_DONE_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DONE.Reg, volatile.LoadUint32(&o.PUBLISH_DONE.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetPUBLISH_DONE_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_DONE.Reg) & 0x80000000) >> 31
}

// CLOCK.PUBLISH_HFCLKAUDIOSTARTED: Publish configuration for event HFCLKAUDIOSTARTED
func (o *CLOCK_Type) SetPUBLISH_HFCLKAUDIOSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_HFCLKAUDIOSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_HFCLKAUDIOSTARTED.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetPUBLISH_HFCLKAUDIOSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_HFCLKAUDIOSTARTED.Reg) & 0xff
}
func (o *CLOCK_Type) SetPUBLISH_HFCLKAUDIOSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_HFCLKAUDIOSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_HFCLKAUDIOSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetPUBLISH_HFCLKAUDIOSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_HFCLKAUDIOSTARTED.Reg) & 0x80000000) >> 31
}

// CLOCK.PUBLISH_HFCLK192MSTARTED: Publish configuration for event HFCLK192MSTARTED
func (o *CLOCK_Type) SetPUBLISH_HFCLK192MSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_HFCLK192MSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_HFCLK192MSTARTED.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetPUBLISH_HFCLK192MSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_HFCLK192MSTARTED.Reg) & 0xff
}
func (o *CLOCK_Type) SetPUBLISH_HFCLK192MSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_HFCLK192MSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_HFCLK192MSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetPUBLISH_HFCLK192MSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_HFCLK192MSTARTED.Reg) & 0x80000000) >> 31
}

// CLOCK.INTEN: Enable or disable interrupt
func (o *CLOCK_Type) SetINTEN_HFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetINTEN_HFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *CLOCK_Type) SetINTEN_LFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *CLOCK_Type) GetINTEN_LFCLKSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *CLOCK_Type) SetINTEN_DONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *CLOCK_Type) GetINTEN_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *CLOCK_Type) SetINTEN_HFCLKAUDIOSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *CLOCK_Type) GetINTEN_HFCLKAUDIOSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *CLOCK_Type) SetINTEN_HFCLK192MSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *CLOCK_Type) GetINTEN_HFCLK192MSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}

// CLOCK.INTENSET: Enable interrupt
func (o *CLOCK_Type) SetINTENSET_HFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetINTENSET_HFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *CLOCK_Type) SetINTENSET_LFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *CLOCK_Type) GetINTENSET_LFCLKSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *CLOCK_Type) SetINTENSET_DONE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *CLOCK_Type) GetINTENSET_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *CLOCK_Type) SetINTENSET_HFCLKAUDIOSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *CLOCK_Type) GetINTENSET_HFCLKAUDIOSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *CLOCK_Type) SetINTENSET_HFCLK192MSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *CLOCK_Type) GetINTENSET_HFCLK192MSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}

// CLOCK.INTENCLR: Disable interrupt
func (o *CLOCK_Type) SetINTENCLR_HFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetINTENCLR_HFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *CLOCK_Type) SetINTENCLR_LFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *CLOCK_Type) GetINTENCLR_LFCLKSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *CLOCK_Type) SetINTENCLR_DONE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *CLOCK_Type) GetINTENCLR_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *CLOCK_Type) SetINTENCLR_HFCLKAUDIOSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *CLOCK_Type) GetINTENCLR_HFCLKAUDIOSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *CLOCK_Type) SetINTENCLR_HFCLK192MSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *CLOCK_Type) GetINTENCLR_HFCLK192MSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}

// CLOCK.INTPEND: Pending interrupts
func (o *CLOCK_Type) SetINTPEND_HFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetINTPEND_HFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.INTPEND.Reg) & 0x1
}
func (o *CLOCK_Type) SetINTPEND_LFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x2)|value<<1)
}
func (o *CLOCK_Type) GetINTPEND_LFCLKSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x2) >> 1
}
func (o *CLOCK_Type) SetINTPEND_DONE(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x80)|value<<7)
}
func (o *CLOCK_Type) GetINTPEND_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x80) >> 7
}
func (o *CLOCK_Type) SetINTPEND_HFCLKAUDIOSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x100)|value<<8)
}
func (o *CLOCK_Type) GetINTPEND_HFCLKAUDIOSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x100) >> 8
}
func (o *CLOCK_Type) SetINTPEND_HFCLK192MSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x200)|value<<9)
}
func (o *CLOCK_Type) GetINTPEND_HFCLK192MSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x200) >> 9
}

// CLOCK.HFCLKRUN: Status indicating that HFCLKSTART task has been triggered
func (o *CLOCK_Type) SetHFCLKRUN_STATUS(value uint32) {
	volatile.StoreUint32(&o.HFCLKRUN.Reg, volatile.LoadUint32(&o.HFCLKRUN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetHFCLKRUN_STATUS() uint32 {
	return volatile.LoadUint32(&o.HFCLKRUN.Reg) & 0x1
}

// CLOCK.HFCLKSTAT: Status indicating which HFCLK128M/HFCLK64M source is running This register value in any CLOCK instance reflects status only due to configurations/actions in that CLOCK instance.
func (o *CLOCK_Type) SetHFCLKSTAT_SRC(value uint32) {
	volatile.StoreUint32(&o.HFCLKSTAT.Reg, volatile.LoadUint32(&o.HFCLKSTAT.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetHFCLKSTAT_SRC() uint32 {
	return volatile.LoadUint32(&o.HFCLKSTAT.Reg) & 0x1
}
func (o *CLOCK_Type) SetHFCLKSTAT_ALWAYSRUNNING(value uint32) {
	volatile.StoreUint32(&o.HFCLKSTAT.Reg, volatile.LoadUint32(&o.HFCLKSTAT.Reg)&^(0x10)|value<<4)
}
func (o *CLOCK_Type) GetHFCLKSTAT_ALWAYSRUNNING() uint32 {
	return (volatile.LoadUint32(&o.HFCLKSTAT.Reg) & 0x10) >> 4
}
func (o *CLOCK_Type) SetHFCLKSTAT_STATE(value uint32) {
	volatile.StoreUint32(&o.HFCLKSTAT.Reg, volatile.LoadUint32(&o.HFCLKSTAT.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCK_Type) GetHFCLKSTAT_STATE() uint32 {
	return (volatile.LoadUint32(&o.HFCLKSTAT.Reg) & 0x10000) >> 16
}

// CLOCK.LFCLKRUN: Status indicating that LFCLKSTART task has been triggered
func (o *CLOCK_Type) SetLFCLKRUN_STATUS(value uint32) {
	volatile.StoreUint32(&o.LFCLKRUN.Reg, volatile.LoadUint32(&o.LFCLKRUN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetLFCLKRUN_STATUS() uint32 {
	return volatile.LoadUint32(&o.LFCLKRUN.Reg) & 0x1
}

// CLOCK.LFCLKSTAT: Status indicating which LFCLK source is running This register value in any CLOCK instance reflects status only due to configurations/actions in that CLOCK instance.
func (o *CLOCK_Type) SetLFCLKSTAT_SRC(value uint32) {
	volatile.StoreUint32(&o.LFCLKSTAT.Reg, volatile.LoadUint32(&o.LFCLKSTAT.Reg)&^(0x3)|value)
}
func (o *CLOCK_Type) GetLFCLKSTAT_SRC() uint32 {
	return volatile.LoadUint32(&o.LFCLKSTAT.Reg) & 0x3
}
func (o *CLOCK_Type) SetLFCLKSTAT_ALWAYSRUNNING(value uint32) {
	volatile.StoreUint32(&o.LFCLKSTAT.Reg, volatile.LoadUint32(&o.LFCLKSTAT.Reg)&^(0x10)|value<<4)
}
func (o *CLOCK_Type) GetLFCLKSTAT_ALWAYSRUNNING() uint32 {
	return (volatile.LoadUint32(&o.LFCLKSTAT.Reg) & 0x10) >> 4
}
func (o *CLOCK_Type) SetLFCLKSTAT_STATE(value uint32) {
	volatile.StoreUint32(&o.LFCLKSTAT.Reg, volatile.LoadUint32(&o.LFCLKSTAT.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCK_Type) GetLFCLKSTAT_STATE() uint32 {
	return (volatile.LoadUint32(&o.LFCLKSTAT.Reg) & 0x10000) >> 16
}

// CLOCK.LFCLKSRCCOPY: Copy of LFCLKSRC register, set when LFCLKSTART task was triggered
func (o *CLOCK_Type) SetLFCLKSRCCOPY_SRC(value uint32) {
	volatile.StoreUint32(&o.LFCLKSRCCOPY.Reg, volatile.LoadUint32(&o.LFCLKSRCCOPY.Reg)&^(0x3)|value)
}
func (o *CLOCK_Type) GetLFCLKSRCCOPY_SRC() uint32 {
	return volatile.LoadUint32(&o.LFCLKSRCCOPY.Reg) & 0x3
}

// CLOCK.HFCLKAUDIORUN: Status indicating that HFCLKAUDIOSTART task has been triggered
func (o *CLOCK_Type) SetHFCLKAUDIORUN_STATUS(value uint32) {
	volatile.StoreUint32(&o.HFCLKAUDIORUN.Reg, volatile.LoadUint32(&o.HFCLKAUDIORUN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetHFCLKAUDIORUN_STATUS() uint32 {
	return volatile.LoadUint32(&o.HFCLKAUDIORUN.Reg) & 0x1
}

// CLOCK.HFCLKAUDIOSTAT: Status indicating which HFCLKAUDIO source is running
func (o *CLOCK_Type) SetHFCLKAUDIOSTAT_ALWAYSRUNNING(value uint32) {
	volatile.StoreUint32(&o.HFCLKAUDIOSTAT.Reg, volatile.LoadUint32(&o.HFCLKAUDIOSTAT.Reg)&^(0x10)|value<<4)
}
func (o *CLOCK_Type) GetHFCLKAUDIOSTAT_ALWAYSRUNNING() uint32 {
	return (volatile.LoadUint32(&o.HFCLKAUDIOSTAT.Reg) & 0x10) >> 4
}
func (o *CLOCK_Type) SetHFCLKAUDIOSTAT_STATE(value uint32) {
	volatile.StoreUint32(&o.HFCLKAUDIOSTAT.Reg, volatile.LoadUint32(&o.HFCLKAUDIOSTAT.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCK_Type) GetHFCLKAUDIOSTAT_STATE() uint32 {
	return (volatile.LoadUint32(&o.HFCLKAUDIOSTAT.Reg) & 0x10000) >> 16
}

// CLOCK.HFCLK192MRUN: Status indicating that HFCLK192MSTART task has been triggered
func (o *CLOCK_Type) SetHFCLK192MRUN_STATUS(value uint32) {
	volatile.StoreUint32(&o.HFCLK192MRUN.Reg, volatile.LoadUint32(&o.HFCLK192MRUN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetHFCLK192MRUN_STATUS() uint32 {
	return volatile.LoadUint32(&o.HFCLK192MRUN.Reg) & 0x1
}

// CLOCK.HFCLK192MSTAT: Status indicating which HFCLK192M source is running
func (o *CLOCK_Type) SetHFCLK192MSTAT_SRC(value uint32) {
	volatile.StoreUint32(&o.HFCLK192MSTAT.Reg, volatile.LoadUint32(&o.HFCLK192MSTAT.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetHFCLK192MSTAT_SRC() uint32 {
	return volatile.LoadUint32(&o.HFCLK192MSTAT.Reg) & 0x1
}
func (o *CLOCK_Type) SetHFCLK192MSTAT_ALWAYSRUNNING(value uint32) {
	volatile.StoreUint32(&o.HFCLK192MSTAT.Reg, volatile.LoadUint32(&o.HFCLK192MSTAT.Reg)&^(0x10)|value<<4)
}
func (o *CLOCK_Type) GetHFCLK192MSTAT_ALWAYSRUNNING() uint32 {
	return (volatile.LoadUint32(&o.HFCLK192MSTAT.Reg) & 0x10) >> 4
}
func (o *CLOCK_Type) SetHFCLK192MSTAT_STATE(value uint32) {
	volatile.StoreUint32(&o.HFCLK192MSTAT.Reg, volatile.LoadUint32(&o.HFCLK192MSTAT.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCK_Type) GetHFCLK192MSTAT_STATE() uint32 {
	return (volatile.LoadUint32(&o.HFCLK192MSTAT.Reg) & 0x10000) >> 16
}

// CLOCK.HFCLKSRC: Clock source for HFCLK128M/HFCLK64M
func (o *CLOCK_Type) SetHFCLKSRC_SRC(value uint32) {
	volatile.StoreUint32(&o.HFCLKSRC.Reg, volatile.LoadUint32(&o.HFCLKSRC.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetHFCLKSRC_SRC() uint32 {
	return volatile.LoadUint32(&o.HFCLKSRC.Reg) & 0x1
}

// CLOCK.LFCLKSRC: Clock source for LFCLK
func (o *CLOCK_Type) SetLFCLKSRC_SRC(value uint32) {
	volatile.StoreUint32(&o.LFCLKSRC.Reg, volatile.LoadUint32(&o.LFCLKSRC.Reg)&^(0x3)|value)
}
func (o *CLOCK_Type) GetLFCLKSRC_SRC() uint32 {
	return volatile.LoadUint32(&o.LFCLKSRC.Reg) & 0x3
}

// CLOCK.HFCLKCTRL: HFCLK128M frequency configuration
func (o *CLOCK_Type) SetHFCLKCTRL_HCLK(value uint32) {
	volatile.StoreUint32(&o.HFCLKCTRL.Reg, volatile.LoadUint32(&o.HFCLKCTRL.Reg)&^(0x3)|value)
}
func (o *CLOCK_Type) GetHFCLKCTRL_HCLK() uint32 {
	return volatile.LoadUint32(&o.HFCLKCTRL.Reg) & 0x3
}

// CLOCK.HFCLKALWAYSRUN: Automatic or manual control of HFCLK128M/HFCLK64M
func (o *CLOCK_Type) SetHFCLKALWAYSRUN_ALWAYSRUN(value uint32) {
	volatile.StoreUint32(&o.HFCLKALWAYSRUN.Reg, volatile.LoadUint32(&o.HFCLKALWAYSRUN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetHFCLKALWAYSRUN_ALWAYSRUN() uint32 {
	return volatile.LoadUint32(&o.HFCLKALWAYSRUN.Reg) & 0x1
}

// CLOCK.LFCLKALWAYSRUN: Automatic or manual control of LFCLK
func (o *CLOCK_Type) SetLFCLKALWAYSRUN_ALWAYSRUN(value uint32) {
	volatile.StoreUint32(&o.LFCLKALWAYSRUN.Reg, volatile.LoadUint32(&o.LFCLKALWAYSRUN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetLFCLKALWAYSRUN_ALWAYSRUN() uint32 {
	return volatile.LoadUint32(&o.LFCLKALWAYSRUN.Reg) & 0x1
}

// CLOCK.HFCLKAUDIOALWAYSRUN: Automatic or manual control of HFCLKAUDIO
func (o *CLOCK_Type) SetHFCLKAUDIOALWAYSRUN_ALWAYSRUN(value uint32) {
	volatile.StoreUint32(&o.HFCLKAUDIOALWAYSRUN.Reg, volatile.LoadUint32(&o.HFCLKAUDIOALWAYSRUN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetHFCLKAUDIOALWAYSRUN_ALWAYSRUN() uint32 {
	return volatile.LoadUint32(&o.HFCLKAUDIOALWAYSRUN.Reg) & 0x1
}

// CLOCK.HFCLK192MSRC: Clock source for HFCLK192M
func (o *CLOCK_Type) SetHFCLK192MSRC_SRC(value uint32) {
	volatile.StoreUint32(&o.HFCLK192MSRC.Reg, volatile.LoadUint32(&o.HFCLK192MSRC.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetHFCLK192MSRC_SRC() uint32 {
	return volatile.LoadUint32(&o.HFCLK192MSRC.Reg) & 0x1
}

// CLOCK.HFCLK192MALWAYSRUN: Automatic or manual control of HFCLK192M
func (o *CLOCK_Type) SetHFCLK192MALWAYSRUN_ALWAYSRUN(value uint32) {
	volatile.StoreUint32(&o.HFCLK192MALWAYSRUN.Reg, volatile.LoadUint32(&o.HFCLK192MALWAYSRUN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetHFCLK192MALWAYSRUN_ALWAYSRUN() uint32 {
	return volatile.LoadUint32(&o.HFCLK192MALWAYSRUN.Reg) & 0x1
}

// CLOCK.HFCLK192MCTRL: HFCLK192M frequency configuration
func (o *CLOCK_Type) SetHFCLK192MCTRL_HCLK192M(value uint32) {
	volatile.StoreUint32(&o.HFCLK192MCTRL.Reg, volatile.LoadUint32(&o.HFCLK192MCTRL.Reg)&^(0x3)|value)
}
func (o *CLOCK_Type) GetHFCLK192MCTRL_HCLK192M() uint32 {
	return volatile.LoadUint32(&o.HFCLK192MCTRL.Reg) & 0x3
}

type CLOCK_HFCLKAUDIO_Type struct {
	FREQUENCY volatile.Register32 // 0x55C
}

// CLOCK_HFCLKAUDIO.FREQUENCY: Audio PLL frequency in 11.176 MHz - 11.402 MHz or 12.165 MHz - 12.411 MHz frequency bands
func (o *CLOCK_HFCLKAUDIO_Type) SetFREQUENCY(value uint32) {
	volatile.StoreUint32(&o.FREQUENCY.Reg, volatile.LoadUint32(&o.FREQUENCY.Reg)&^(0xffff)|value)
}
func (o *CLOCK_HFCLKAUDIO_Type) GetFREQUENCY() uint32 {
	return volatile.LoadUint32(&o.FREQUENCY.Reg) & 0xffff
}

// Power control 0
type POWER_Type struct {
	_                  [120]byte
	TASKS_CONSTLAT     volatile.Register32 // 0x78
	TASKS_LOWPWR       volatile.Register32 // 0x7C
	_                  [120]byte
	SUBSCRIBE_CONSTLAT volatile.Register32 // 0xF8
	SUBSCRIBE_LOWPWR   volatile.Register32 // 0xFC
	_                  [8]byte
	EVENTS_POFWARN     volatile.Register32 // 0x108
	_                  [8]byte
	EVENTS_SLEEPENTER  volatile.Register32 // 0x114
	EVENTS_SLEEPEXIT   volatile.Register32 // 0x118
	_                  [108]byte
	PUBLISH_POFWARN    volatile.Register32 // 0x188
	_                  [8]byte
	PUBLISH_SLEEPENTER volatile.Register32 // 0x194
	PUBLISH_SLEEPEXIT  volatile.Register32 // 0x198
	_                  [356]byte
	INTEN              volatile.Register32 // 0x300
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [528]byte
	GPREGRET           [2]volatile.Register32 // 0x51C
}

// POWER.TASKS_CONSTLAT: Enable Constant Latency mode
func (o *POWER_Type) SetTASKS_CONSTLAT(value uint32) {
	volatile.StoreUint32(&o.TASKS_CONSTLAT.Reg, volatile.LoadUint32(&o.TASKS_CONSTLAT.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetTASKS_CONSTLAT() uint32 {
	return volatile.LoadUint32(&o.TASKS_CONSTLAT.Reg) & 0x1
}

// POWER.TASKS_LOWPWR: Enable Low-Power mode (variable latency)
func (o *POWER_Type) SetTASKS_LOWPWR(value uint32) {
	volatile.StoreUint32(&o.TASKS_LOWPWR.Reg, volatile.LoadUint32(&o.TASKS_LOWPWR.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetTASKS_LOWPWR() uint32 {
	return volatile.LoadUint32(&o.TASKS_LOWPWR.Reg) & 0x1
}

// POWER.SUBSCRIBE_CONSTLAT: Subscribe configuration for task CONSTLAT
func (o *POWER_Type) SetSUBSCRIBE_CONSTLAT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CONSTLAT.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CONSTLAT.Reg)&^(0xff)|value)
}
func (o *POWER_Type) GetSUBSCRIBE_CONSTLAT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CONSTLAT.Reg) & 0xff
}
func (o *POWER_Type) SetSUBSCRIBE_CONSTLAT_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CONSTLAT.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CONSTLAT.Reg)&^(0x80000000)|value<<31)
}
func (o *POWER_Type) GetSUBSCRIBE_CONSTLAT_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CONSTLAT.Reg) & 0x80000000) >> 31
}

// POWER.SUBSCRIBE_LOWPWR: Subscribe configuration for task LOWPWR
func (o *POWER_Type) SetSUBSCRIBE_LOWPWR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_LOWPWR.Reg, volatile.LoadUint32(&o.SUBSCRIBE_LOWPWR.Reg)&^(0xff)|value)
}
func (o *POWER_Type) GetSUBSCRIBE_LOWPWR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_LOWPWR.Reg) & 0xff
}
func (o *POWER_Type) SetSUBSCRIBE_LOWPWR_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_LOWPWR.Reg, volatile.LoadUint32(&o.SUBSCRIBE_LOWPWR.Reg)&^(0x80000000)|value<<31)
}
func (o *POWER_Type) GetSUBSCRIBE_LOWPWR_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_LOWPWR.Reg) & 0x80000000) >> 31
}

// POWER.EVENTS_POFWARN: Power failure warning
func (o *POWER_Type) SetEVENTS_POFWARN(value uint32) {
	volatile.StoreUint32(&o.EVENTS_POFWARN.Reg, volatile.LoadUint32(&o.EVENTS_POFWARN.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetEVENTS_POFWARN() uint32 {
	return volatile.LoadUint32(&o.EVENTS_POFWARN.Reg) & 0x1
}

// POWER.EVENTS_SLEEPENTER: CPU entered WFI/WFE sleep
func (o *POWER_Type) SetEVENTS_SLEEPENTER(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SLEEPENTER.Reg, volatile.LoadUint32(&o.EVENTS_SLEEPENTER.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetEVENTS_SLEEPENTER() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SLEEPENTER.Reg) & 0x1
}

// POWER.EVENTS_SLEEPEXIT: CPU exited WFI/WFE sleep
func (o *POWER_Type) SetEVENTS_SLEEPEXIT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SLEEPEXIT.Reg, volatile.LoadUint32(&o.EVENTS_SLEEPEXIT.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetEVENTS_SLEEPEXIT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SLEEPEXIT.Reg) & 0x1
}

// POWER.PUBLISH_POFWARN: Publish configuration for event POFWARN
func (o *POWER_Type) SetPUBLISH_POFWARN_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_POFWARN.Reg, volatile.LoadUint32(&o.PUBLISH_POFWARN.Reg)&^(0xff)|value)
}
func (o *POWER_Type) GetPUBLISH_POFWARN_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_POFWARN.Reg) & 0xff
}
func (o *POWER_Type) SetPUBLISH_POFWARN_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_POFWARN.Reg, volatile.LoadUint32(&o.PUBLISH_POFWARN.Reg)&^(0x80000000)|value<<31)
}
func (o *POWER_Type) GetPUBLISH_POFWARN_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_POFWARN.Reg) & 0x80000000) >> 31
}

// POWER.PUBLISH_SLEEPENTER: Publish configuration for event SLEEPENTER
func (o *POWER_Type) SetPUBLISH_SLEEPENTER_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SLEEPENTER.Reg, volatile.LoadUint32(&o.PUBLISH_SLEEPENTER.Reg)&^(0xff)|value)
}
func (o *POWER_Type) GetPUBLISH_SLEEPENTER_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_SLEEPENTER.Reg) & 0xff
}
func (o *POWER_Type) SetPUBLISH_SLEEPENTER_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SLEEPENTER.Reg, volatile.LoadUint32(&o.PUBLISH_SLEEPENTER.Reg)&^(0x80000000)|value<<31)
}
func (o *POWER_Type) GetPUBLISH_SLEEPENTER_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_SLEEPENTER.Reg) & 0x80000000) >> 31
}

// POWER.PUBLISH_SLEEPEXIT: Publish configuration for event SLEEPEXIT
func (o *POWER_Type) SetPUBLISH_SLEEPEXIT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SLEEPEXIT.Reg, volatile.LoadUint32(&o.PUBLISH_SLEEPEXIT.Reg)&^(0xff)|value)
}
func (o *POWER_Type) GetPUBLISH_SLEEPEXIT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_SLEEPEXIT.Reg) & 0xff
}
func (o *POWER_Type) SetPUBLISH_SLEEPEXIT_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SLEEPEXIT.Reg, volatile.LoadUint32(&o.PUBLISH_SLEEPEXIT.Reg)&^(0x80000000)|value<<31)
}
func (o *POWER_Type) GetPUBLISH_SLEEPEXIT_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_SLEEPEXIT.Reg) & 0x80000000) >> 31
}

// POWER.INTEN: Enable or disable interrupt
func (o *POWER_Type) SetINTEN_POFWARN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *POWER_Type) GetINTEN_POFWARN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *POWER_Type) SetINTEN_SLEEPENTER(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *POWER_Type) GetINTEN_SLEEPENTER() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *POWER_Type) SetINTEN_SLEEPEXIT(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *POWER_Type) GetINTEN_SLEEPEXIT() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}

// POWER.INTENSET: Enable interrupt
func (o *POWER_Type) SetINTENSET_POFWARN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *POWER_Type) GetINTENSET_POFWARN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *POWER_Type) SetINTENSET_SLEEPENTER(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *POWER_Type) GetINTENSET_SLEEPENTER() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *POWER_Type) SetINTENSET_SLEEPEXIT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *POWER_Type) GetINTENSET_SLEEPEXIT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}

// POWER.INTENCLR: Disable interrupt
func (o *POWER_Type) SetINTENCLR_POFWARN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *POWER_Type) GetINTENCLR_POFWARN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *POWER_Type) SetINTENCLR_SLEEPENTER(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *POWER_Type) GetINTENCLR_SLEEPENTER() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *POWER_Type) SetINTENCLR_SLEEPEXIT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *POWER_Type) GetINTENCLR_SLEEPEXIT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}

// POWER.GPREGRET: Description collection: General purpose retention register
func (o *POWER_Type) SetGPREGRET(idx int, value uint32) {
	volatile.StoreUint32(&o.GPREGRET[idx].Reg, volatile.LoadUint32(&o.GPREGRET[idx].Reg)&^(0xff)|value)
}
func (o *POWER_Type) GetGPREGRET(idx int) uint32 {
	return volatile.LoadUint32(&o.GPREGRET[idx].Reg) & 0xff
}

// Reset control 0
type RESET_Type struct {
	_         [1024]byte
	RESETREAS volatile.Register32 // 0x400
	_         [524]byte
	NETWORK   RESET_NETWORK_Type // 0x610
}

// RESET.RESETREAS: Reset reason
func (o *RESET_Type) SetRESETREAS_RESETPIN(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x1)|value)
}
func (o *RESET_Type) GetRESETREAS_RESETPIN() uint32 {
	return volatile.LoadUint32(&o.RESETREAS.Reg) & 0x1
}
func (o *RESET_Type) SetRESETREAS_DOG0(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x2)|value<<1)
}
func (o *RESET_Type) GetRESETREAS_DOG0() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x2) >> 1
}
func (o *RESET_Type) SetRESETREAS_CTRLAP(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x4)|value<<2)
}
func (o *RESET_Type) GetRESETREAS_CTRLAP() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x4) >> 2
}
func (o *RESET_Type) SetRESETREAS_SREQ(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x8)|value<<3)
}
func (o *RESET_Type) GetRESETREAS_SREQ() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x8) >> 3
}
func (o *RESET_Type) SetRESETREAS_LOCKUP(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x10)|value<<4)
}
func (o *RESET_Type) GetRESETREAS_LOCKUP() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x10) >> 4
}
func (o *RESET_Type) SetRESETREAS_OFF(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x20)|value<<5)
}
func (o *RESET_Type) GetRESETREAS_OFF() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x20) >> 5
}
func (o *RESET_Type) SetRESETREAS_LPCOMP(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x40)|value<<6)
}
func (o *RESET_Type) GetRESETREAS_LPCOMP() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x40) >> 6
}
func (o *RESET_Type) SetRESETREAS_DIF(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x80)|value<<7)
}
func (o *RESET_Type) GetRESETREAS_DIF() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x80) >> 7
}
func (o *RESET_Type) SetRESETREAS_NFC(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x1000000)|value<<24)
}
func (o *RESET_Type) GetRESETREAS_NFC() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x1000000) >> 24
}
func (o *RESET_Type) SetRESETREAS_DOG1(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x2000000)|value<<25)
}
func (o *RESET_Type) GetRESETREAS_DOG1() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x2000000) >> 25
}
func (o *RESET_Type) SetRESETREAS_VBUS(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x4000000)|value<<26)
}
func (o *RESET_Type) GetRESETREAS_VBUS() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x4000000) >> 26
}

type RESET_NETWORK_Type struct {
	_        [4]byte
	FORCEOFF volatile.Register32 // 0x614
}

// RESET_NETWORK.FORCEOFF: Force network core off
func (o *RESET_NETWORK_Type) SetFORCEOFF(value uint32) {
	volatile.StoreUint32(&o.FORCEOFF.Reg, volatile.LoadUint32(&o.FORCEOFF.Reg)&^(0x1)|value)
}
func (o *RESET_NETWORK_Type) GetFORCEOFF() uint32 {
	return volatile.LoadUint32(&o.FORCEOFF.Reg) & 0x1
}

// Control access port 0
type CTRLAPPERI_Type struct {
	_               [1024]byte
	MAILBOX         CTRLAPPERI_MAILBOX_Type // 0x400
	_               [120]byte
	ERASEPROTECT    CTRLAPPERI_ERASEPROTECT_Type // 0x500
	_               [56]byte
	APPROTECT       CTRLAPPERI_APPROTECT_Type       // 0x540
	SECUREAPPROTECT CTRLAPPERI_SECUREAPPROTECT_Type // 0x548
	_               [176]byte
	STATUS          volatile.Register32 // 0x600
}

// CTRLAPPERI.STATUS: Status bits for CTRL-AP peripheral
func (o *CTRLAPPERI_Type) SetSTATUS_APPROTECT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *CTRLAPPERI_Type) GetSTATUS_APPROTECT() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *CTRLAPPERI_Type) SetSTATUS_SECUREAPPROTECT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *CTRLAPPERI_Type) GetSTATUS_SECUREAPPROTECT() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *CTRLAPPERI_Type) SetSTATUS_DBGIFACEMODE(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *CTRLAPPERI_Type) GetSTATUS_DBGIFACEMODE() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}

type CTRLAPPERI_MAILBOX_Type struct {
	RXDATA   volatile.Register32 // 0x400
	RXSTATUS volatile.Register32 // 0x404
	_        [120]byte
	TXDATA   volatile.Register32 // 0x480
	TXSTATUS volatile.Register32 // 0x484
}

// CTRLAPPERI_MAILBOX.RXDATA: Data sent from the debugger to the CPU.
func (o *CTRLAPPERI_MAILBOX_Type) SetRXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDATA.Reg, value)
}
func (o *CTRLAPPERI_MAILBOX_Type) GetRXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDATA.Reg)
}

// CTRLAPPERI_MAILBOX.RXSTATUS: This register shows a status that indicates if data sent from the debugger to the CPU has been read.
func (o *CTRLAPPERI_MAILBOX_Type) SetRXSTATUS(value uint32) {
	volatile.StoreUint32(&o.RXSTATUS.Reg, volatile.LoadUint32(&o.RXSTATUS.Reg)&^(0x1)|value)
}
func (o *CTRLAPPERI_MAILBOX_Type) GetRXSTATUS() uint32 {
	return volatile.LoadUint32(&o.RXSTATUS.Reg) & 0x1
}

// CTRLAPPERI_MAILBOX.TXDATA: Data sent from the CPU to the debugger.
func (o *CTRLAPPERI_MAILBOX_Type) SetTXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDATA.Reg, value)
}
func (o *CTRLAPPERI_MAILBOX_Type) GetTXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDATA.Reg)
}

// CTRLAPPERI_MAILBOX.TXSTATUS: This register shows a status that indicates if the data sent from the CPU to the debugger has been read.
func (o *CTRLAPPERI_MAILBOX_Type) SetTXSTATUS(value uint32) {
	volatile.StoreUint32(&o.TXSTATUS.Reg, volatile.LoadUint32(&o.TXSTATUS.Reg)&^(0x1)|value)
}
func (o *CTRLAPPERI_MAILBOX_Type) GetTXSTATUS() uint32 {
	return volatile.LoadUint32(&o.TXSTATUS.Reg) & 0x1
}

type CTRLAPPERI_ERASEPROTECT_Type struct {
	LOCK    volatile.Register32 // 0x500
	DISABLE volatile.Register32 // 0x504
}

// CTRLAPPERI_ERASEPROTECT.LOCK: This register locks the ERASEPROTECT.DISABLE register from being written until next reset.
func (o *CTRLAPPERI_ERASEPROTECT_Type) SetLOCK(value uint32) {
	volatile.StoreUint32(&o.LOCK.Reg, volatile.LoadUint32(&o.LOCK.Reg)&^(0x1)|value)
}
func (o *CTRLAPPERI_ERASEPROTECT_Type) GetLOCK() uint32 {
	return volatile.LoadUint32(&o.LOCK.Reg) & 0x1
}

// CTRLAPPERI_ERASEPROTECT.DISABLE: This register disables the ERASEPROTECT register and performs an ERASEALL operation.
func (o *CTRLAPPERI_ERASEPROTECT_Type) SetDISABLE(value uint32) {
	volatile.StoreUint32(&o.DISABLE.Reg, value)
}
func (o *CTRLAPPERI_ERASEPROTECT_Type) GetDISABLE() uint32 {
	return volatile.LoadUint32(&o.DISABLE.Reg)
}

type CTRLAPPERI_APPROTECT_Type struct {
	LOCK    volatile.Register32 // 0x540
	DISABLE volatile.Register32 // 0x544
}

// CTRLAPPERI_APPROTECT.LOCK: This register locks the APPROTECT.DISABLE register from being written to until next reset.
func (o *CTRLAPPERI_APPROTECT_Type) SetLOCK(value uint32) {
	volatile.StoreUint32(&o.LOCK.Reg, volatile.LoadUint32(&o.LOCK.Reg)&^(0x1)|value)
}
func (o *CTRLAPPERI_APPROTECT_Type) GetLOCK() uint32 {
	return volatile.LoadUint32(&o.LOCK.Reg) & 0x1
}

// CTRLAPPERI_APPROTECT.DISABLE: This register disables the APPROTECT register and enables debug access to non-secure mode.
func (o *CTRLAPPERI_APPROTECT_Type) SetDISABLE(value uint32) {
	volatile.StoreUint32(&o.DISABLE.Reg, value)
}
func (o *CTRLAPPERI_APPROTECT_Type) GetDISABLE() uint32 {
	return volatile.LoadUint32(&o.DISABLE.Reg)
}

type CTRLAPPERI_SECUREAPPROTECT_Type struct {
	LOCK    volatile.Register32 // 0x548
	DISABLE volatile.Register32 // 0x54C
}

// CTRLAPPERI_SECUREAPPROTECT.LOCK: This register locks the SECUREAPPROTECT.DISABLE register from being written until next reset.
func (o *CTRLAPPERI_SECUREAPPROTECT_Type) SetLOCK(value uint32) {
	volatile.StoreUint32(&o.LOCK.Reg, volatile.LoadUint32(&o.LOCK.Reg)&^(0x1)|value)
}
func (o *CTRLAPPERI_SECUREAPPROTECT_Type) GetLOCK() uint32 {
	return volatile.LoadUint32(&o.LOCK.Reg) & 0x1
}

// CTRLAPPERI_SECUREAPPROTECT.DISABLE: This register disables the SECUREAPPROTECT register and enables debug access to secure mode.
func (o *CTRLAPPERI_SECUREAPPROTECT_Type) SetDISABLE(value uint32) {
	volatile.StoreUint32(&o.DISABLE.Reg, value)
}
func (o *CTRLAPPERI_SECUREAPPROTECT_Type) GetDISABLE() uint32 {
	return volatile.LoadUint32(&o.DISABLE.Reg)
}

// Serial Peripheral Interface Master with EasyDMA 0
type SPIM_Type struct {
	_                 [16]byte
	TASKS_START       volatile.Register32 // 0x10
	TASKS_STOP        volatile.Register32 // 0x14
	_                 [4]byte
	TASKS_SUSPEND     volatile.Register32 // 0x1C
	TASKS_RESUME      volatile.Register32 // 0x20
	_                 [108]byte
	SUBSCRIBE_START   volatile.Register32 // 0x90
	SUBSCRIBE_STOP    volatile.Register32 // 0x94
	_                 [4]byte
	SUBSCRIBE_SUSPEND volatile.Register32 // 0x9C
	SUBSCRIBE_RESUME  volatile.Register32 // 0xA0
	_                 [96]byte
	EVENTS_STOPPED    volatile.Register32 // 0x104
	_                 [8]byte
	EVENTS_ENDRX      volatile.Register32 // 0x110
	_                 [4]byte
	EVENTS_END        volatile.Register32 // 0x118
	_                 [4]byte
	EVENTS_ENDTX      volatile.Register32 // 0x120
	_                 [40]byte
	EVENTS_STARTED    volatile.Register32 // 0x14C
	_                 [52]byte
	PUBLISH_STOPPED   volatile.Register32 // 0x184
	_                 [8]byte
	PUBLISH_ENDRX     volatile.Register32 // 0x190
	_                 [4]byte
	PUBLISH_END       volatile.Register32 // 0x198
	_                 [4]byte
	PUBLISH_ENDTX     volatile.Register32 // 0x1A0
	_                 [40]byte
	PUBLISH_STARTED   volatile.Register32 // 0x1CC
	_                 [48]byte
	SHORTS            volatile.Register32 // 0x200
	_                 [256]byte
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
	_                 [244]byte
	STALLSTAT         volatile.Register32 // 0x400
	_                 [252]byte
	ENABLE            volatile.Register32 // 0x500
	_                 [4]byte
	PSEL              SPIM_PSEL_Type // 0x508
	_                 [12]byte
	FREQUENCY         volatile.Register32 // 0x524
	_                 [12]byte
	RXD               SPIM_RXD_Type       // 0x534
	TXD               SPIM_TXD_Type       // 0x544
	CONFIG            volatile.Register32 // 0x554
	_                 [8]byte
	IFTIMING          SPIM_IFTIMING_Type  // 0x560
	CSNPOL            volatile.Register32 // 0x568
	PSELDCX           volatile.Register32 // 0x56C
	DCXCNT            volatile.Register32 // 0x570
	_                 [76]byte
	ORC               volatile.Register32 // 0x5C0
}

// SPIM.TASKS_START: Start SPI transaction
func (o *SPIM_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// SPIM.TASKS_STOP: Stop SPI transaction
func (o *SPIM_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// SPIM.TASKS_SUSPEND: Suspend SPI transaction
func (o *SPIM_Type) SetTASKS_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.TASKS_SUSPEND.Reg, volatile.LoadUint32(&o.TASKS_SUSPEND.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetTASKS_SUSPEND() uint32 {
	return volatile.LoadUint32(&o.TASKS_SUSPEND.Reg) & 0x1
}

// SPIM.TASKS_RESUME: Resume SPI transaction
func (o *SPIM_Type) SetTASKS_RESUME(value uint32) {
	volatile.StoreUint32(&o.TASKS_RESUME.Reg, volatile.LoadUint32(&o.TASKS_RESUME.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetTASKS_RESUME() uint32 {
	return volatile.LoadUint32(&o.TASKS_RESUME.Reg) & 0x1
}

// SPIM.SUBSCRIBE_START: Subscribe configuration for task START
func (o *SPIM_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xff
}
func (o *SPIM_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// SPIM.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *SPIM_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *SPIM_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// SPIM.SUBSCRIBE_SUSPEND: Subscribe configuration for task SUSPEND
func (o *SPIM_Type) SetSUBSCRIBE_SUSPEND_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SUSPEND.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetSUBSCRIBE_SUSPEND_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg) & 0xff
}
func (o *SPIM_Type) SetSUBSCRIBE_SUSPEND_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SUSPEND.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetSUBSCRIBE_SUSPEND_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg) & 0x80000000) >> 31
}

// SPIM.SUBSCRIBE_RESUME: Subscribe configuration for task RESUME
func (o *SPIM_Type) SetSUBSCRIBE_RESUME_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RESUME.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetSUBSCRIBE_RESUME_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg) & 0xff
}
func (o *SPIM_Type) SetSUBSCRIBE_RESUME_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RESUME.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetSUBSCRIBE_RESUME_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg) & 0x80000000) >> 31
}

// SPIM.EVENTS_STOPPED: SPI transaction has stopped
func (o *SPIM_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// SPIM.EVENTS_ENDRX: End of RXD buffer reached
func (o *SPIM_Type) SetEVENTS_ENDRX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDRX.Reg, volatile.LoadUint32(&o.EVENTS_ENDRX.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_ENDRX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDRX.Reg) & 0x1
}

// SPIM.EVENTS_END: End of RXD buffer and TXD buffer reached
func (o *SPIM_Type) SetEVENTS_END(value uint32) {
	volatile.StoreUint32(&o.EVENTS_END.Reg, volatile.LoadUint32(&o.EVENTS_END.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_END() uint32 {
	return volatile.LoadUint32(&o.EVENTS_END.Reg) & 0x1
}

// SPIM.EVENTS_ENDTX: End of TXD buffer reached
func (o *SPIM_Type) SetEVENTS_ENDTX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDTX.Reg, volatile.LoadUint32(&o.EVENTS_ENDTX.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_ENDTX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDTX.Reg) & 0x1
}

// SPIM.EVENTS_STARTED: Transaction started
func (o *SPIM_Type) SetEVENTS_STARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STARTED.Reg, volatile.LoadUint32(&o.EVENTS_STARTED.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_STARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STARTED.Reg) & 0x1
}

// SPIM.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *SPIM_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xff
}
func (o *SPIM_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// SPIM.PUBLISH_ENDRX: Publish configuration for event ENDRX
func (o *SPIM_Type) SetPUBLISH_ENDRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetPUBLISH_ENDRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0xff
}
func (o *SPIM_Type) SetPUBLISH_ENDRX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetPUBLISH_ENDRX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0x80000000) >> 31
}

// SPIM.PUBLISH_END: Publish configuration for event END
func (o *SPIM_Type) SetPUBLISH_END_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetPUBLISH_END_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0xff
}
func (o *SPIM_Type) SetPUBLISH_END_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetPUBLISH_END_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0x80000000) >> 31
}

// SPIM.PUBLISH_ENDTX: Publish configuration for event ENDTX
func (o *SPIM_Type) SetPUBLISH_ENDTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDTX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetPUBLISH_ENDTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg) & 0xff
}
func (o *SPIM_Type) SetPUBLISH_ENDTX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDTX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetPUBLISH_ENDTX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg) & 0x80000000) >> 31
}

// SPIM.PUBLISH_STARTED: Publish configuration for event STARTED
func (o *SPIM_Type) SetPUBLISH_STARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STARTED.Reg, volatile.LoadUint32(&o.PUBLISH_STARTED.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetPUBLISH_STARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STARTED.Reg) & 0xff
}
func (o *SPIM_Type) SetPUBLISH_STARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STARTED.Reg, volatile.LoadUint32(&o.PUBLISH_STARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetPUBLISH_STARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STARTED.Reg) & 0x80000000) >> 31
}

// SPIM.SHORTS: Shortcuts between local events and tasks
func (o *SPIM_Type) SetSHORTS_END_START(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20000)|value<<17)
}
func (o *SPIM_Type) GetSHORTS_END_START() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20000) >> 17
}

// SPIM.INTENSET: Enable interrupt
func (o *SPIM_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SPIM_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SPIM_Type) SetINTENSET_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SPIM_Type) GetINTENSET_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SPIM_Type) SetINTENSET_END(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *SPIM_Type) GetINTENSET_END() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *SPIM_Type) SetINTENSET_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *SPIM_Type) GetINTENSET_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *SPIM_Type) SetINTENSET_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *SPIM_Type) GetINTENSET_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}

// SPIM.INTENCLR: Disable interrupt
func (o *SPIM_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SPIM_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SPIM_Type) SetINTENCLR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SPIM_Type) GetINTENCLR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SPIM_Type) SetINTENCLR_END(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *SPIM_Type) GetINTENCLR_END() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *SPIM_Type) SetINTENCLR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *SPIM_Type) GetINTENCLR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *SPIM_Type) SetINTENCLR_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *SPIM_Type) GetINTENCLR_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}

// SPIM.STALLSTAT: Stall status for EasyDMA RAM accesses. The fields in this register is set to STALL by hardware whenever a stall occurres and can be cleared (set to NOSTALL) by the CPU.
func (o *SPIM_Type) SetSTALLSTAT_TX(value uint32) {
	volatile.StoreUint32(&o.STALLSTAT.Reg, volatile.LoadUint32(&o.STALLSTAT.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetSTALLSTAT_TX() uint32 {
	return volatile.LoadUint32(&o.STALLSTAT.Reg) & 0x1
}
func (o *SPIM_Type) SetSTALLSTAT_RX(value uint32) {
	volatile.StoreUint32(&o.STALLSTAT.Reg, volatile.LoadUint32(&o.STALLSTAT.Reg)&^(0x2)|value<<1)
}
func (o *SPIM_Type) GetSTALLSTAT_RX() uint32 {
	return (volatile.LoadUint32(&o.STALLSTAT.Reg) & 0x2) >> 1
}

// SPIM.ENABLE: Enable SPIM
func (o *SPIM_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *SPIM_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// SPIM.FREQUENCY: SPI frequency. Accuracy depends on the HFCLK source selected.
func (o *SPIM_Type) SetFREQUENCY(value uint32) {
	volatile.StoreUint32(&o.FREQUENCY.Reg, value)
}
func (o *SPIM_Type) GetFREQUENCY() uint32 {
	return volatile.LoadUint32(&o.FREQUENCY.Reg)
}

// SPIM.CONFIG: Configuration register
func (o *SPIM_Type) SetCONFIG_ORDER(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetCONFIG_ORDER() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *SPIM_Type) SetCONFIG_CPHA(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x2)|value<<1)
}
func (o *SPIM_Type) GetCONFIG_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x2) >> 1
}
func (o *SPIM_Type) SetCONFIG_CPOL(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x4)|value<<2)
}
func (o *SPIM_Type) GetCONFIG_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x4) >> 2
}

// SPIM.CSNPOL: Polarity of CSN output
func (o *SPIM_Type) SetCSNPOL(value uint32) {
	volatile.StoreUint32(&o.CSNPOL.Reg, volatile.LoadUint32(&o.CSNPOL.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetCSNPOL() uint32 {
	return volatile.LoadUint32(&o.CSNPOL.Reg) & 0x1
}

// SPIM.PSELDCX: Pin select for DCX signal
func (o *SPIM_Type) SetPSELDCX_PIN(value uint32) {
	volatile.StoreUint32(&o.PSELDCX.Reg, volatile.LoadUint32(&o.PSELDCX.Reg)&^(0x1f)|value)
}
func (o *SPIM_Type) GetPSELDCX_PIN() uint32 {
	return volatile.LoadUint32(&o.PSELDCX.Reg) & 0x1f
}
func (o *SPIM_Type) SetPSELDCX_PORT(value uint32) {
	volatile.StoreUint32(&o.PSELDCX.Reg, volatile.LoadUint32(&o.PSELDCX.Reg)&^(0x20)|value<<5)
}
func (o *SPIM_Type) GetPSELDCX_PORT() uint32 {
	return (volatile.LoadUint32(&o.PSELDCX.Reg) & 0x20) >> 5
}
func (o *SPIM_Type) SetPSELDCX_CONNECT(value uint32) {
	volatile.StoreUint32(&o.PSELDCX.Reg, volatile.LoadUint32(&o.PSELDCX.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetPSELDCX_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.PSELDCX.Reg) & 0x80000000) >> 31
}

// SPIM.DCXCNT: DCX configuration
func (o *SPIM_Type) SetDCXCNT(value uint32) {
	volatile.StoreUint32(&o.DCXCNT.Reg, volatile.LoadUint32(&o.DCXCNT.Reg)&^(0xf)|value)
}
func (o *SPIM_Type) GetDCXCNT() uint32 {
	return volatile.LoadUint32(&o.DCXCNT.Reg) & 0xf
}

// SPIM.ORC: Byte transmitted after TXD.MAXCNT bytes have been transmitted in the case when RXD.MAXCNT is greater than TXD.MAXCNT
func (o *SPIM_Type) SetORC(value uint32) {
	volatile.StoreUint32(&o.ORC.Reg, volatile.LoadUint32(&o.ORC.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetORC() uint32 {
	return volatile.LoadUint32(&o.ORC.Reg) & 0xff
}

type SPIM_PSEL_Type struct {
	SCK  volatile.Register32 // 0x508
	MOSI volatile.Register32 // 0x50C
	MISO volatile.Register32 // 0x510
	CSN  volatile.Register32 // 0x514
}

// SPIM_PSEL.SCK: Pin select for SCK
func (o *SPIM_PSEL_Type) SetSCK_PIN(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x1f)|value)
}
func (o *SPIM_PSEL_Type) GetSCK_PIN() uint32 {
	return volatile.LoadUint32(&o.SCK.Reg) & 0x1f
}
func (o *SPIM_PSEL_Type) SetSCK_PORT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x20)|value<<5)
}
func (o *SPIM_PSEL_Type) GetSCK_PORT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x20) >> 5
}
func (o *SPIM_PSEL_Type) SetSCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_PSEL_Type) GetSCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x80000000) >> 31
}

// SPIM_PSEL.MOSI: Pin select for MOSI signal
func (o *SPIM_PSEL_Type) SetMOSI_PIN(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x1f)|value)
}
func (o *SPIM_PSEL_Type) GetMOSI_PIN() uint32 {
	return volatile.LoadUint32(&o.MOSI.Reg) & 0x1f
}
func (o *SPIM_PSEL_Type) SetMOSI_PORT(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x20)|value<<5)
}
func (o *SPIM_PSEL_Type) GetMOSI_PORT() uint32 {
	return (volatile.LoadUint32(&o.MOSI.Reg) & 0x20) >> 5
}
func (o *SPIM_PSEL_Type) SetMOSI_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_PSEL_Type) GetMOSI_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MOSI.Reg) & 0x80000000) >> 31
}

// SPIM_PSEL.MISO: Pin select for MISO signal
func (o *SPIM_PSEL_Type) SetMISO_PIN(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x1f)|value)
}
func (o *SPIM_PSEL_Type) GetMISO_PIN() uint32 {
	return volatile.LoadUint32(&o.MISO.Reg) & 0x1f
}
func (o *SPIM_PSEL_Type) SetMISO_PORT(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x20)|value<<5)
}
func (o *SPIM_PSEL_Type) GetMISO_PORT() uint32 {
	return (volatile.LoadUint32(&o.MISO.Reg) & 0x20) >> 5
}
func (o *SPIM_PSEL_Type) SetMISO_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_PSEL_Type) GetMISO_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MISO.Reg) & 0x80000000) >> 31
}

// SPIM_PSEL.CSN: Pin select for CSN
func (o *SPIM_PSEL_Type) SetCSN_PIN(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x1f)|value)
}
func (o *SPIM_PSEL_Type) GetCSN_PIN() uint32 {
	return volatile.LoadUint32(&o.CSN.Reg) & 0x1f
}
func (o *SPIM_PSEL_Type) SetCSN_PORT(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x20)|value<<5)
}
func (o *SPIM_PSEL_Type) GetCSN_PORT() uint32 {
	return (volatile.LoadUint32(&o.CSN.Reg) & 0x20) >> 5
}
func (o *SPIM_PSEL_Type) SetCSN_CONNECT(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_PSEL_Type) GetCSN_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.CSN.Reg) & 0x80000000) >> 31
}

type SPIM_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
	LIST   volatile.Register32 // 0x540
}

// SPIM_RXD.PTR: Data pointer
func (o *SPIM_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SPIM_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SPIM_RXD.MAXCNT: Maximum number of bytes in receive buffer
func (o *SPIM_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *SPIM_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// SPIM_RXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *SPIM_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *SPIM_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// SPIM_RXD.LIST: EasyDMA list type
func (o *SPIM_RXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *SPIM_RXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

type SPIM_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
	LIST   volatile.Register32 // 0x550
}

// SPIM_TXD.PTR: Data pointer
func (o *SPIM_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SPIM_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SPIM_TXD.MAXCNT: Number of bytes in transmit buffer
func (o *SPIM_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *SPIM_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// SPIM_TXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *SPIM_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *SPIM_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// SPIM_TXD.LIST: EasyDMA list type
func (o *SPIM_TXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *SPIM_TXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

type SPIM_IFTIMING_Type struct {
	RXDELAY volatile.Register32 // 0x560
	CSNDUR  volatile.Register32 // 0x564
}

// SPIM_IFTIMING.RXDELAY: Sample delay for input serial data on MISO
func (o *SPIM_IFTIMING_Type) SetRXDELAY(value uint32) {
	volatile.StoreUint32(&o.RXDELAY.Reg, volatile.LoadUint32(&o.RXDELAY.Reg)&^(0x7)|value)
}
func (o *SPIM_IFTIMING_Type) GetRXDELAY() uint32 {
	return volatile.LoadUint32(&o.RXDELAY.Reg) & 0x7
}

// SPIM_IFTIMING.CSNDUR: Minimum duration between edge of CSN and edge of SCK and minimum duration CSN must stay high between transactions
func (o *SPIM_IFTIMING_Type) SetCSNDUR(value uint32) {
	volatile.StoreUint32(&o.CSNDUR.Reg, volatile.LoadUint32(&o.CSNDUR.Reg)&^(0xff)|value)
}
func (o *SPIM_IFTIMING_Type) GetCSNDUR() uint32 {
	return volatile.LoadUint32(&o.CSNDUR.Reg) & 0xff
}

// SPI Slave 0
type SPIS_Type struct {
	_                 [36]byte
	TASKS_ACQUIRE     volatile.Register32 // 0x24
	TASKS_RELEASE     volatile.Register32 // 0x28
	_                 [120]byte
	SUBSCRIBE_ACQUIRE volatile.Register32 // 0xA4
	SUBSCRIBE_RELEASE volatile.Register32 // 0xA8
	_                 [88]byte
	EVENTS_END        volatile.Register32 // 0x104
	_                 [8]byte
	EVENTS_ENDRX      volatile.Register32 // 0x110
	_                 [20]byte
	EVENTS_ACQUIRED   volatile.Register32 // 0x128
	_                 [88]byte
	PUBLISH_END       volatile.Register32 // 0x184
	_                 [8]byte
	PUBLISH_ENDRX     volatile.Register32 // 0x190
	_                 [20]byte
	PUBLISH_ACQUIRED  volatile.Register32 // 0x1A8
	_                 [84]byte
	SHORTS            volatile.Register32 // 0x200
	_                 [256]byte
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
	_                 [244]byte
	SEMSTAT           volatile.Register32 // 0x400
	_                 [60]byte
	STATUS            volatile.Register32 // 0x440
	_                 [188]byte
	ENABLE            volatile.Register32 // 0x500
	_                 [4]byte
	PSEL              SPIS_PSEL_Type // 0x508
	_                 [28]byte
	RXD               SPIS_RXD_Type       // 0x534
	TXD               SPIS_TXD_Type       // 0x544
	CONFIG            volatile.Register32 // 0x554
	_                 [4]byte
	DEF               volatile.Register32 // 0x55C
	_                 [96]byte
	ORC               volatile.Register32 // 0x5C0
}

// SPIS.TASKS_ACQUIRE: Acquire SPI semaphore
func (o *SPIS_Type) SetTASKS_ACQUIRE(value uint32) {
	volatile.StoreUint32(&o.TASKS_ACQUIRE.Reg, volatile.LoadUint32(&o.TASKS_ACQUIRE.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetTASKS_ACQUIRE() uint32 {
	return volatile.LoadUint32(&o.TASKS_ACQUIRE.Reg) & 0x1
}

// SPIS.TASKS_RELEASE: Release SPI semaphore, enabling the SPI slave to acquire it
func (o *SPIS_Type) SetTASKS_RELEASE(value uint32) {
	volatile.StoreUint32(&o.TASKS_RELEASE.Reg, volatile.LoadUint32(&o.TASKS_RELEASE.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetTASKS_RELEASE() uint32 {
	return volatile.LoadUint32(&o.TASKS_RELEASE.Reg) & 0x1
}

// SPIS.SUBSCRIBE_ACQUIRE: Subscribe configuration for task ACQUIRE
func (o *SPIS_Type) SetSUBSCRIBE_ACQUIRE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_ACQUIRE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_ACQUIRE.Reg)&^(0xff)|value)
}
func (o *SPIS_Type) GetSUBSCRIBE_ACQUIRE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_ACQUIRE.Reg) & 0xff
}
func (o *SPIS_Type) SetSUBSCRIBE_ACQUIRE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_ACQUIRE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_ACQUIRE.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_Type) GetSUBSCRIBE_ACQUIRE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_ACQUIRE.Reg) & 0x80000000) >> 31
}

// SPIS.SUBSCRIBE_RELEASE: Subscribe configuration for task RELEASE
func (o *SPIS_Type) SetSUBSCRIBE_RELEASE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RELEASE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RELEASE.Reg)&^(0xff)|value)
}
func (o *SPIS_Type) GetSUBSCRIBE_RELEASE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_RELEASE.Reg) & 0xff
}
func (o *SPIS_Type) SetSUBSCRIBE_RELEASE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RELEASE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RELEASE.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_Type) GetSUBSCRIBE_RELEASE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_RELEASE.Reg) & 0x80000000) >> 31
}

// SPIS.EVENTS_END: Granted transaction completed
func (o *SPIS_Type) SetEVENTS_END(value uint32) {
	volatile.StoreUint32(&o.EVENTS_END.Reg, volatile.LoadUint32(&o.EVENTS_END.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetEVENTS_END() uint32 {
	return volatile.LoadUint32(&o.EVENTS_END.Reg) & 0x1
}

// SPIS.EVENTS_ENDRX: End of RXD buffer reached
func (o *SPIS_Type) SetEVENTS_ENDRX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDRX.Reg, volatile.LoadUint32(&o.EVENTS_ENDRX.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetEVENTS_ENDRX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDRX.Reg) & 0x1
}

// SPIS.EVENTS_ACQUIRED: Semaphore acquired
func (o *SPIS_Type) SetEVENTS_ACQUIRED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ACQUIRED.Reg, volatile.LoadUint32(&o.EVENTS_ACQUIRED.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetEVENTS_ACQUIRED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ACQUIRED.Reg) & 0x1
}

// SPIS.PUBLISH_END: Publish configuration for event END
func (o *SPIS_Type) SetPUBLISH_END_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0xff)|value)
}
func (o *SPIS_Type) GetPUBLISH_END_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0xff
}
func (o *SPIS_Type) SetPUBLISH_END_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_Type) GetPUBLISH_END_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0x80000000) >> 31
}

// SPIS.PUBLISH_ENDRX: Publish configuration for event ENDRX
func (o *SPIS_Type) SetPUBLISH_ENDRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0xff)|value)
}
func (o *SPIS_Type) GetPUBLISH_ENDRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0xff
}
func (o *SPIS_Type) SetPUBLISH_ENDRX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_Type) GetPUBLISH_ENDRX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0x80000000) >> 31
}

// SPIS.PUBLISH_ACQUIRED: Publish configuration for event ACQUIRED
func (o *SPIS_Type) SetPUBLISH_ACQUIRED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ACQUIRED.Reg, volatile.LoadUint32(&o.PUBLISH_ACQUIRED.Reg)&^(0xff)|value)
}
func (o *SPIS_Type) GetPUBLISH_ACQUIRED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ACQUIRED.Reg) & 0xff
}
func (o *SPIS_Type) SetPUBLISH_ACQUIRED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ACQUIRED.Reg, volatile.LoadUint32(&o.PUBLISH_ACQUIRED.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_Type) GetPUBLISH_ACQUIRED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ACQUIRED.Reg) & 0x80000000) >> 31
}

// SPIS.SHORTS: Shortcuts between local events and tasks
func (o *SPIS_Type) SetSHORTS_END_ACQUIRE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *SPIS_Type) GetSHORTS_END_ACQUIRE() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}

// SPIS.INTENSET: Enable interrupt
func (o *SPIS_Type) SetINTENSET_END(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SPIS_Type) GetINTENSET_END() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SPIS_Type) SetINTENSET_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SPIS_Type) GetINTENSET_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SPIS_Type) SetINTENSET_ACQUIRED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *SPIS_Type) GetINTENSET_ACQUIRED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}

// SPIS.INTENCLR: Disable interrupt
func (o *SPIS_Type) SetINTENCLR_END(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SPIS_Type) GetINTENCLR_END() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SPIS_Type) SetINTENCLR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SPIS_Type) GetINTENCLR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SPIS_Type) SetINTENCLR_ACQUIRED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *SPIS_Type) GetINTENCLR_ACQUIRED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}

// SPIS.SEMSTAT: Semaphore status register
func (o *SPIS_Type) SetSEMSTAT(value uint32) {
	volatile.StoreUint32(&o.SEMSTAT.Reg, volatile.LoadUint32(&o.SEMSTAT.Reg)&^(0x3)|value)
}
func (o *SPIS_Type) GetSEMSTAT() uint32 {
	return volatile.LoadUint32(&o.SEMSTAT.Reg) & 0x3
}

// SPIS.STATUS: Status from last transaction
func (o *SPIS_Type) SetSTATUS_OVERREAD(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetSTATUS_OVERREAD() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *SPIS_Type) SetSTATUS_OVERFLOW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SPIS_Type) GetSTATUS_OVERFLOW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}

// SPIS.ENABLE: Enable SPI slave
func (o *SPIS_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *SPIS_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// SPIS.CONFIG: Configuration register
func (o *SPIS_Type) SetCONFIG_ORDER(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetCONFIG_ORDER() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *SPIS_Type) SetCONFIG_CPHA(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x2)|value<<1)
}
func (o *SPIS_Type) GetCONFIG_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x2) >> 1
}
func (o *SPIS_Type) SetCONFIG_CPOL(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x4)|value<<2)
}
func (o *SPIS_Type) GetCONFIG_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x4) >> 2
}

// SPIS.DEF: Default character. Character clocked out in case of an ignored transaction.
func (o *SPIS_Type) SetDEF(value uint32) {
	volatile.StoreUint32(&o.DEF.Reg, volatile.LoadUint32(&o.DEF.Reg)&^(0xff)|value)
}
func (o *SPIS_Type) GetDEF() uint32 {
	return volatile.LoadUint32(&o.DEF.Reg) & 0xff
}

// SPIS.ORC: Over-read character
func (o *SPIS_Type) SetORC(value uint32) {
	volatile.StoreUint32(&o.ORC.Reg, volatile.LoadUint32(&o.ORC.Reg)&^(0xff)|value)
}
func (o *SPIS_Type) GetORC() uint32 {
	return volatile.LoadUint32(&o.ORC.Reg) & 0xff
}

type SPIS_PSEL_Type struct {
	SCK  volatile.Register32 // 0x508
	MISO volatile.Register32 // 0x50C
	MOSI volatile.Register32 // 0x510
	CSN  volatile.Register32 // 0x514
}

// SPIS_PSEL.SCK: Pin select for SCK
func (o *SPIS_PSEL_Type) SetSCK_PIN(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x1f)|value)
}
func (o *SPIS_PSEL_Type) GetSCK_PIN() uint32 {
	return volatile.LoadUint32(&o.SCK.Reg) & 0x1f
}
func (o *SPIS_PSEL_Type) SetSCK_PORT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x20)|value<<5)
}
func (o *SPIS_PSEL_Type) GetSCK_PORT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x20) >> 5
}
func (o *SPIS_PSEL_Type) SetSCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_PSEL_Type) GetSCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x80000000) >> 31
}

// SPIS_PSEL.MISO: Pin select for MISO signal
func (o *SPIS_PSEL_Type) SetMISO_PIN(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x1f)|value)
}
func (o *SPIS_PSEL_Type) GetMISO_PIN() uint32 {
	return volatile.LoadUint32(&o.MISO.Reg) & 0x1f
}
func (o *SPIS_PSEL_Type) SetMISO_PORT(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x20)|value<<5)
}
func (o *SPIS_PSEL_Type) GetMISO_PORT() uint32 {
	return (volatile.LoadUint32(&o.MISO.Reg) & 0x20) >> 5
}
func (o *SPIS_PSEL_Type) SetMISO_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_PSEL_Type) GetMISO_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MISO.Reg) & 0x80000000) >> 31
}

// SPIS_PSEL.MOSI: Pin select for MOSI signal
func (o *SPIS_PSEL_Type) SetMOSI_PIN(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x1f)|value)
}
func (o *SPIS_PSEL_Type) GetMOSI_PIN() uint32 {
	return volatile.LoadUint32(&o.MOSI.Reg) & 0x1f
}
func (o *SPIS_PSEL_Type) SetMOSI_PORT(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x20)|value<<5)
}
func (o *SPIS_PSEL_Type) GetMOSI_PORT() uint32 {
	return (volatile.LoadUint32(&o.MOSI.Reg) & 0x20) >> 5
}
func (o *SPIS_PSEL_Type) SetMOSI_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_PSEL_Type) GetMOSI_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MOSI.Reg) & 0x80000000) >> 31
}

// SPIS_PSEL.CSN: Pin select for CSN signal
func (o *SPIS_PSEL_Type) SetCSN_PIN(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x1f)|value)
}
func (o *SPIS_PSEL_Type) GetCSN_PIN() uint32 {
	return volatile.LoadUint32(&o.CSN.Reg) & 0x1f
}
func (o *SPIS_PSEL_Type) SetCSN_PORT(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x20)|value<<5)
}
func (o *SPIS_PSEL_Type) GetCSN_PORT() uint32 {
	return (volatile.LoadUint32(&o.CSN.Reg) & 0x20) >> 5
}
func (o *SPIS_PSEL_Type) SetCSN_CONNECT(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_PSEL_Type) GetCSN_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.CSN.Reg) & 0x80000000) >> 31
}

type SPIS_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
	LIST   volatile.Register32 // 0x540
}

// SPIS_RXD.PTR: RXD data pointer
func (o *SPIS_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SPIS_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SPIS_RXD.MAXCNT: Maximum number of bytes in receive buffer
func (o *SPIS_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *SPIS_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// SPIS_RXD.AMOUNT: Number of bytes received in last granted transaction
func (o *SPIS_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *SPIS_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// SPIS_RXD.LIST: EasyDMA list type
func (o *SPIS_RXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *SPIS_RXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

type SPIS_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
	LIST   volatile.Register32 // 0x550
}

// SPIS_TXD.PTR: TXD data pointer
func (o *SPIS_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SPIS_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SPIS_TXD.MAXCNT: Maximum number of bytes in transmit buffer
func (o *SPIS_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *SPIS_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// SPIS_TXD.AMOUNT: Number of bytes transmitted in last granted transaction
func (o *SPIS_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *SPIS_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// SPIS_TXD.LIST: EasyDMA list type
func (o *SPIS_TXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *SPIS_TXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

// I2C compatible Two-Wire Master Interface with EasyDMA 0
type TWIM_Type struct {
	TASKS_STARTRX     volatile.Register32 // 0x0
	_                 [4]byte
	TASKS_STARTTX     volatile.Register32 // 0x8
	_                 [8]byte
	TASKS_STOP        volatile.Register32 // 0x14
	_                 [4]byte
	TASKS_SUSPEND     volatile.Register32 // 0x1C
	TASKS_RESUME      volatile.Register32 // 0x20
	_                 [92]byte
	SUBSCRIBE_STARTRX volatile.Register32 // 0x80
	_                 [4]byte
	SUBSCRIBE_STARTTX volatile.Register32 // 0x88
	_                 [8]byte
	SUBSCRIBE_STOP    volatile.Register32 // 0x94
	_                 [4]byte
	SUBSCRIBE_SUSPEND volatile.Register32 // 0x9C
	SUBSCRIBE_RESUME  volatile.Register32 // 0xA0
	_                 [96]byte
	EVENTS_STOPPED    volatile.Register32 // 0x104
	_                 [28]byte
	EVENTS_ERROR      volatile.Register32 // 0x124
	_                 [32]byte
	EVENTS_SUSPENDED  volatile.Register32 // 0x148
	EVENTS_RXSTARTED  volatile.Register32 // 0x14C
	EVENTS_TXSTARTED  volatile.Register32 // 0x150
	_                 [8]byte
	EVENTS_LASTRX     volatile.Register32 // 0x15C
	EVENTS_LASTTX     volatile.Register32 // 0x160
	_                 [32]byte
	PUBLISH_STOPPED   volatile.Register32 // 0x184
	_                 [28]byte
	PUBLISH_ERROR     volatile.Register32 // 0x1A4
	_                 [32]byte
	PUBLISH_SUSPENDED volatile.Register32 // 0x1C8
	PUBLISH_RXSTARTED volatile.Register32 // 0x1CC
	PUBLISH_TXSTARTED volatile.Register32 // 0x1D0
	_                 [8]byte
	PUBLISH_LASTRX    volatile.Register32 // 0x1DC
	PUBLISH_LASTTX    volatile.Register32 // 0x1E0
	_                 [28]byte
	SHORTS            volatile.Register32 // 0x200
	_                 [252]byte
	INTEN             volatile.Register32 // 0x300
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
	_                 [440]byte
	ERRORSRC          volatile.Register32 // 0x4C4
	_                 [56]byte
	ENABLE            volatile.Register32 // 0x500
	_                 [4]byte
	PSEL              TWIM_PSEL_Type // 0x508
	_                 [20]byte
	FREQUENCY         volatile.Register32 // 0x524
	_                 [12]byte
	RXD               TWIM_RXD_Type // 0x534
	TXD               TWIM_TXD_Type // 0x544
	_                 [52]byte
	ADDRESS           volatile.Register32 // 0x588
}

// TWIM.TASKS_STARTRX: Start TWI receive sequence
func (o *TWIM_Type) SetTASKS_STARTRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTRX.Reg, volatile.LoadUint32(&o.TASKS_STARTRX.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_STARTRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTRX.Reg) & 0x1
}

// TWIM.TASKS_STARTTX: Start TWI transmit sequence
func (o *TWIM_Type) SetTASKS_STARTTX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTTX.Reg, volatile.LoadUint32(&o.TASKS_STARTTX.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_STARTTX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTTX.Reg) & 0x1
}

// TWIM.TASKS_STOP: Stop TWI transaction. Must be issued while the TWI master is not suspended.
func (o *TWIM_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// TWIM.TASKS_SUSPEND: Suspend TWI transaction
func (o *TWIM_Type) SetTASKS_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.TASKS_SUSPEND.Reg, volatile.LoadUint32(&o.TASKS_SUSPEND.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_SUSPEND() uint32 {
	return volatile.LoadUint32(&o.TASKS_SUSPEND.Reg) & 0x1
}

// TWIM.TASKS_RESUME: Resume TWI transaction
func (o *TWIM_Type) SetTASKS_RESUME(value uint32) {
	volatile.StoreUint32(&o.TASKS_RESUME.Reg, volatile.LoadUint32(&o.TASKS_RESUME.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_RESUME() uint32 {
	return volatile.LoadUint32(&o.TASKS_RESUME.Reg) & 0x1
}

// TWIM.SUBSCRIBE_STARTRX: Subscribe configuration for task STARTRX
func (o *TWIM_Type) SetSUBSCRIBE_STARTRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetSUBSCRIBE_STARTRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg) & 0xff
}
func (o *TWIM_Type) SetSUBSCRIBE_STARTRX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetSUBSCRIBE_STARTRX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg) & 0x80000000) >> 31
}

// TWIM.SUBSCRIBE_STARTTX: Subscribe configuration for task STARTTX
func (o *TWIM_Type) SetSUBSCRIBE_STARTTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetSUBSCRIBE_STARTTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg) & 0xff
}
func (o *TWIM_Type) SetSUBSCRIBE_STARTTX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetSUBSCRIBE_STARTTX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg) & 0x80000000) >> 31
}

// TWIM.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *TWIM_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *TWIM_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// TWIM.SUBSCRIBE_SUSPEND: Subscribe configuration for task SUSPEND
func (o *TWIM_Type) SetSUBSCRIBE_SUSPEND_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SUSPEND.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetSUBSCRIBE_SUSPEND_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg) & 0xff
}
func (o *TWIM_Type) SetSUBSCRIBE_SUSPEND_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SUSPEND.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetSUBSCRIBE_SUSPEND_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg) & 0x80000000) >> 31
}

// TWIM.SUBSCRIBE_RESUME: Subscribe configuration for task RESUME
func (o *TWIM_Type) SetSUBSCRIBE_RESUME_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RESUME.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetSUBSCRIBE_RESUME_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg) & 0xff
}
func (o *TWIM_Type) SetSUBSCRIBE_RESUME_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RESUME.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetSUBSCRIBE_RESUME_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg) & 0x80000000) >> 31
}

// TWIM.EVENTS_STOPPED: TWI stopped
func (o *TWIM_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// TWIM.EVENTS_ERROR: TWI error
func (o *TWIM_Type) SetEVENTS_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_ERROR.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERROR.Reg) & 0x1
}

// TWIM.EVENTS_SUSPENDED: SUSPEND task has been issued, TWI traffic is now suspended.
func (o *TWIM_Type) SetEVENTS_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SUSPENDED.Reg, volatile.LoadUint32(&o.EVENTS_SUSPENDED.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_SUSPENDED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SUSPENDED.Reg) & 0x1
}

// TWIM.EVENTS_RXSTARTED: Receive sequence started
func (o *TWIM_Type) SetEVENTS_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_RXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg) & 0x1
}

// TWIM.EVENTS_TXSTARTED: Transmit sequence started
func (o *TWIM_Type) SetEVENTS_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_TXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg) & 0x1
}

// TWIM.EVENTS_LASTRX: Byte boundary, starting to receive the last byte
func (o *TWIM_Type) SetEVENTS_LASTRX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_LASTRX.Reg, volatile.LoadUint32(&o.EVENTS_LASTRX.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_LASTRX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_LASTRX.Reg) & 0x1
}

// TWIM.EVENTS_LASTTX: Byte boundary, starting to transmit the last byte
func (o *TWIM_Type) SetEVENTS_LASTTX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_LASTTX.Reg, volatile.LoadUint32(&o.EVENTS_LASTTX.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_LASTTX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_LASTTX.Reg) & 0x1
}

// TWIM.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *TWIM_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xff
}
func (o *TWIM_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// TWIM.PUBLISH_ERROR: Publish configuration for event ERROR
func (o *TWIM_Type) SetPUBLISH_ERROR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetPUBLISH_ERROR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0xff
}
func (o *TWIM_Type) SetPUBLISH_ERROR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_ERROR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0x80000000) >> 31
}

// TWIM.PUBLISH_SUSPENDED: Publish configuration for event SUSPENDED
func (o *TWIM_Type) SetPUBLISH_SUSPENDED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SUSPENDED.Reg, volatile.LoadUint32(&o.PUBLISH_SUSPENDED.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetPUBLISH_SUSPENDED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_SUSPENDED.Reg) & 0xff
}
func (o *TWIM_Type) SetPUBLISH_SUSPENDED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SUSPENDED.Reg, volatile.LoadUint32(&o.PUBLISH_SUSPENDED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_SUSPENDED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_SUSPENDED.Reg) & 0x80000000) >> 31
}

// TWIM.PUBLISH_RXSTARTED: Publish configuration for event RXSTARTED
func (o *TWIM_Type) SetPUBLISH_RXSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetPUBLISH_RXSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg) & 0xff
}
func (o *TWIM_Type) SetPUBLISH_RXSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_RXSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg) & 0x80000000) >> 31
}

// TWIM.PUBLISH_TXSTARTED: Publish configuration for event TXSTARTED
func (o *TWIM_Type) SetPUBLISH_TXSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetPUBLISH_TXSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg) & 0xff
}
func (o *TWIM_Type) SetPUBLISH_TXSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_TXSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg) & 0x80000000) >> 31
}

// TWIM.PUBLISH_LASTRX: Publish configuration for event LASTRX
func (o *TWIM_Type) SetPUBLISH_LASTRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LASTRX.Reg, volatile.LoadUint32(&o.PUBLISH_LASTRX.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetPUBLISH_LASTRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_LASTRX.Reg) & 0xff
}
func (o *TWIM_Type) SetPUBLISH_LASTRX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LASTRX.Reg, volatile.LoadUint32(&o.PUBLISH_LASTRX.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_LASTRX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_LASTRX.Reg) & 0x80000000) >> 31
}

// TWIM.PUBLISH_LASTTX: Publish configuration for event LASTTX
func (o *TWIM_Type) SetPUBLISH_LASTTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LASTTX.Reg, volatile.LoadUint32(&o.PUBLISH_LASTTX.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetPUBLISH_LASTTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_LASTTX.Reg) & 0xff
}
func (o *TWIM_Type) SetPUBLISH_LASTTX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LASTTX.Reg, volatile.LoadUint32(&o.PUBLISH_LASTTX.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_LASTTX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_LASTTX.Reg) & 0x80000000) >> 31
}

// TWIM.SHORTS: Shortcuts between local events and tasks
func (o *TWIM_Type) SetSHORTS_LASTTX_STARTRX(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x80)|value<<7)
}
func (o *TWIM_Type) GetSHORTS_LASTTX_STARTRX() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x80) >> 7
}
func (o *TWIM_Type) SetSHORTS_LASTTX_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x100)|value<<8)
}
func (o *TWIM_Type) GetSHORTS_LASTTX_SUSPEND() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x100) >> 8
}
func (o *TWIM_Type) SetSHORTS_LASTTX_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x200)|value<<9)
}
func (o *TWIM_Type) GetSHORTS_LASTTX_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x200) >> 9
}
func (o *TWIM_Type) SetSHORTS_LASTRX_STARTTX(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x400)|value<<10)
}
func (o *TWIM_Type) GetSHORTS_LASTRX_STARTTX() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x400) >> 10
}
func (o *TWIM_Type) SetSHORTS_LASTRX_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x800)|value<<11)
}
func (o *TWIM_Type) GetSHORTS_LASTRX_SUSPEND() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x800) >> 11
}
func (o *TWIM_Type) SetSHORTS_LASTRX_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1000)|value<<12)
}
func (o *TWIM_Type) GetSHORTS_LASTRX_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x1000) >> 12
}

// TWIM.INTEN: Enable or disable interrupt
func (o *TWIM_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *TWIM_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *TWIM_Type) SetINTEN_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *TWIM_Type) GetINTEN_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *TWIM_Type) SetINTEN_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40000)|value<<18)
}
func (o *TWIM_Type) GetINTEN_SUSPENDED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40000) >> 18
}
func (o *TWIM_Type) SetINTEN_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *TWIM_Type) GetINTEN_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *TWIM_Type) SetINTEN_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *TWIM_Type) GetINTEN_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *TWIM_Type) SetINTEN_LASTRX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800000)|value<<23)
}
func (o *TWIM_Type) GetINTEN_LASTRX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800000) >> 23
}
func (o *TWIM_Type) SetINTEN_LASTTX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000000)|value<<24)
}
func (o *TWIM_Type) GetINTEN_LASTTX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000000) >> 24
}

// TWIM.INTENSET: Enable interrupt
func (o *TWIM_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TWIM_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TWIM_Type) SetINTENSET_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *TWIM_Type) GetINTENSET_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *TWIM_Type) SetINTENSET_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *TWIM_Type) GetINTENSET_SUSPENDED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *TWIM_Type) SetINTENSET_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *TWIM_Type) GetINTENSET_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *TWIM_Type) SetINTENSET_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *TWIM_Type) GetINTENSET_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *TWIM_Type) SetINTENSET_LASTRX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800000)|value<<23)
}
func (o *TWIM_Type) GetINTENSET_LASTRX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800000) >> 23
}
func (o *TWIM_Type) SetINTENSET_LASTTX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000000)|value<<24)
}
func (o *TWIM_Type) GetINTENSET_LASTTX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000000) >> 24
}

// TWIM.INTENCLR: Disable interrupt
func (o *TWIM_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TWIM_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TWIM_Type) SetINTENCLR_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *TWIM_Type) GetINTENCLR_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *TWIM_Type) SetINTENCLR_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *TWIM_Type) GetINTENCLR_SUSPENDED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *TWIM_Type) SetINTENCLR_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *TWIM_Type) GetINTENCLR_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *TWIM_Type) SetINTENCLR_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *TWIM_Type) GetINTENCLR_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *TWIM_Type) SetINTENCLR_LASTRX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800000)|value<<23)
}
func (o *TWIM_Type) GetINTENCLR_LASTRX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800000) >> 23
}
func (o *TWIM_Type) SetINTENCLR_LASTTX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *TWIM_Type) GetINTENCLR_LASTTX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000000) >> 24
}

// TWIM.ERRORSRC: Error source
func (o *TWIM_Type) SetERRORSRC_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetERRORSRC_OVERRUN() uint32 {
	return volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x1
}
func (o *TWIM_Type) SetERRORSRC_ANACK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x2)|value<<1)
}
func (o *TWIM_Type) GetERRORSRC_ANACK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x2) >> 1
}
func (o *TWIM_Type) SetERRORSRC_DNACK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x4)|value<<2)
}
func (o *TWIM_Type) GetERRORSRC_DNACK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x4) >> 2
}

// TWIM.ENABLE: Enable TWIM
func (o *TWIM_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *TWIM_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// TWIM.FREQUENCY: TWI frequency. Accuracy depends on the HFCLK source selected.
func (o *TWIM_Type) SetFREQUENCY(value uint32) {
	volatile.StoreUint32(&o.FREQUENCY.Reg, value)
}
func (o *TWIM_Type) GetFREQUENCY() uint32 {
	return volatile.LoadUint32(&o.FREQUENCY.Reg)
}

// TWIM.ADDRESS: Address used in the TWI transfer
func (o *TWIM_Type) SetADDRESS(value uint32) {
	volatile.StoreUint32(&o.ADDRESS.Reg, volatile.LoadUint32(&o.ADDRESS.Reg)&^(0x7f)|value)
}
func (o *TWIM_Type) GetADDRESS() uint32 {
	return volatile.LoadUint32(&o.ADDRESS.Reg) & 0x7f
}

type TWIM_PSEL_Type struct {
	SCL volatile.Register32 // 0x508
	SDA volatile.Register32 // 0x50C
}

// TWIM_PSEL.SCL: Pin select for SCL signal
func (o *TWIM_PSEL_Type) SetSCL_PIN(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x1f)|value)
}
func (o *TWIM_PSEL_Type) GetSCL_PIN() uint32 {
	return volatile.LoadUint32(&o.SCL.Reg) & 0x1f
}
func (o *TWIM_PSEL_Type) SetSCL_PORT(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x20)|value<<5)
}
func (o *TWIM_PSEL_Type) GetSCL_PORT() uint32 {
	return (volatile.LoadUint32(&o.SCL.Reg) & 0x20) >> 5
}
func (o *TWIM_PSEL_Type) SetSCL_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_PSEL_Type) GetSCL_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCL.Reg) & 0x80000000) >> 31
}

// TWIM_PSEL.SDA: Pin select for SDA signal
func (o *TWIM_PSEL_Type) SetSDA_PIN(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x1f)|value)
}
func (o *TWIM_PSEL_Type) GetSDA_PIN() uint32 {
	return volatile.LoadUint32(&o.SDA.Reg) & 0x1f
}
func (o *TWIM_PSEL_Type) SetSDA_PORT(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x20)|value<<5)
}
func (o *TWIM_PSEL_Type) GetSDA_PORT() uint32 {
	return (volatile.LoadUint32(&o.SDA.Reg) & 0x20) >> 5
}
func (o *TWIM_PSEL_Type) SetSDA_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_PSEL_Type) GetSDA_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SDA.Reg) & 0x80000000) >> 31
}

type TWIM_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
	LIST   volatile.Register32 // 0x540
}

// TWIM_RXD.PTR: Data pointer
func (o *TWIM_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *TWIM_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// TWIM_RXD.MAXCNT: Maximum number of bytes in receive buffer
func (o *TWIM_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *TWIM_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// TWIM_RXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *TWIM_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *TWIM_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// TWIM_RXD.LIST: EasyDMA list type
func (o *TWIM_RXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x7)|value)
}
func (o *TWIM_RXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x7
}

type TWIM_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
	LIST   volatile.Register32 // 0x550
}

// TWIM_TXD.PTR: Data pointer
func (o *TWIM_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *TWIM_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// TWIM_TXD.MAXCNT: Maximum number of bytes in transmit buffer
func (o *TWIM_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *TWIM_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// TWIM_TXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *TWIM_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *TWIM_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// TWIM_TXD.LIST: EasyDMA list type
func (o *TWIM_TXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x7)|value)
}
func (o *TWIM_TXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x7
}

// I2C compatible Two-Wire Slave Interface with EasyDMA 0
type TWIS_Type struct {
	_                   [20]byte
	TASKS_STOP          volatile.Register32 // 0x14
	_                   [4]byte
	TASKS_SUSPEND       volatile.Register32 // 0x1C
	TASKS_RESUME        volatile.Register32 // 0x20
	_                   [12]byte
	TASKS_PREPARERX     volatile.Register32 // 0x30
	TASKS_PREPARETX     volatile.Register32 // 0x34
	_                   [92]byte
	SUBSCRIBE_STOP      volatile.Register32 // 0x94
	_                   [4]byte
	SUBSCRIBE_SUSPEND   volatile.Register32 // 0x9C
	SUBSCRIBE_RESUME    volatile.Register32 // 0xA0
	_                   [12]byte
	SUBSCRIBE_PREPARERX volatile.Register32 // 0xB0
	SUBSCRIBE_PREPARETX volatile.Register32 // 0xB4
	_                   [76]byte
	EVENTS_STOPPED      volatile.Register32 // 0x104
	_                   [28]byte
	EVENTS_ERROR        volatile.Register32 // 0x124
	_                   [36]byte
	EVENTS_RXSTARTED    volatile.Register32 // 0x14C
	EVENTS_TXSTARTED    volatile.Register32 // 0x150
	_                   [16]byte
	EVENTS_WRITE        volatile.Register32 // 0x164
	EVENTS_READ         volatile.Register32 // 0x168
	_                   [24]byte
	PUBLISH_STOPPED     volatile.Register32 // 0x184
	_                   [28]byte
	PUBLISH_ERROR       volatile.Register32 // 0x1A4
	_                   [36]byte
	PUBLISH_RXSTARTED   volatile.Register32 // 0x1CC
	PUBLISH_TXSTARTED   volatile.Register32 // 0x1D0
	_                   [16]byte
	PUBLISH_WRITE       volatile.Register32 // 0x1E4
	PUBLISH_READ        volatile.Register32 // 0x1E8
	_                   [20]byte
	SHORTS              volatile.Register32 // 0x200
	_                   [252]byte
	INTEN               volatile.Register32 // 0x300
	INTENSET            volatile.Register32 // 0x304
	INTENCLR            volatile.Register32 // 0x308
	_                   [452]byte
	ERRORSRC            volatile.Register32 // 0x4D0
	MATCH               volatile.Register32 // 0x4D4
	_                   [40]byte
	ENABLE              volatile.Register32 // 0x500
	_                   [4]byte
	PSEL                TWIS_PSEL_Type // 0x508
	_                   [36]byte
	RXD                 TWIS_RXD_Type // 0x534
	TXD                 TWIS_TXD_Type // 0x544
	_                   [52]byte
	ADDRESS             [2]volatile.Register32 // 0x588
	_                   [4]byte
	CONFIG              volatile.Register32 // 0x594
	_                   [40]byte
	ORC                 volatile.Register32 // 0x5C0
}

// TWIS.TASKS_STOP: Stop TWI transaction
func (o *TWIS_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// TWIS.TASKS_SUSPEND: Suspend TWI transaction
func (o *TWIS_Type) SetTASKS_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.TASKS_SUSPEND.Reg, volatile.LoadUint32(&o.TASKS_SUSPEND.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_SUSPEND() uint32 {
	return volatile.LoadUint32(&o.TASKS_SUSPEND.Reg) & 0x1
}

// TWIS.TASKS_RESUME: Resume TWI transaction
func (o *TWIS_Type) SetTASKS_RESUME(value uint32) {
	volatile.StoreUint32(&o.TASKS_RESUME.Reg, volatile.LoadUint32(&o.TASKS_RESUME.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_RESUME() uint32 {
	return volatile.LoadUint32(&o.TASKS_RESUME.Reg) & 0x1
}

// TWIS.TASKS_PREPARERX: Prepare the TWI slave to respond to a write command
func (o *TWIS_Type) SetTASKS_PREPARERX(value uint32) {
	volatile.StoreUint32(&o.TASKS_PREPARERX.Reg, volatile.LoadUint32(&o.TASKS_PREPARERX.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_PREPARERX() uint32 {
	return volatile.LoadUint32(&o.TASKS_PREPARERX.Reg) & 0x1
}

// TWIS.TASKS_PREPARETX: Prepare the TWI slave to respond to a read command
func (o *TWIS_Type) SetTASKS_PREPARETX(value uint32) {
	volatile.StoreUint32(&o.TASKS_PREPARETX.Reg, volatile.LoadUint32(&o.TASKS_PREPARETX.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_PREPARETX() uint32 {
	return volatile.LoadUint32(&o.TASKS_PREPARETX.Reg) & 0x1
}

// TWIS.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *TWIS_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *TWIS_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// TWIS.SUBSCRIBE_SUSPEND: Subscribe configuration for task SUSPEND
func (o *TWIS_Type) SetSUBSCRIBE_SUSPEND_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SUSPEND.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetSUBSCRIBE_SUSPEND_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg) & 0xff
}
func (o *TWIS_Type) SetSUBSCRIBE_SUSPEND_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SUSPEND.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetSUBSCRIBE_SUSPEND_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg) & 0x80000000) >> 31
}

// TWIS.SUBSCRIBE_RESUME: Subscribe configuration for task RESUME
func (o *TWIS_Type) SetSUBSCRIBE_RESUME_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RESUME.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetSUBSCRIBE_RESUME_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg) & 0xff
}
func (o *TWIS_Type) SetSUBSCRIBE_RESUME_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RESUME.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetSUBSCRIBE_RESUME_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg) & 0x80000000) >> 31
}

// TWIS.SUBSCRIBE_PREPARERX: Subscribe configuration for task PREPARERX
func (o *TWIS_Type) SetSUBSCRIBE_PREPARERX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_PREPARERX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_PREPARERX.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetSUBSCRIBE_PREPARERX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_PREPARERX.Reg) & 0xff
}
func (o *TWIS_Type) SetSUBSCRIBE_PREPARERX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_PREPARERX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_PREPARERX.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetSUBSCRIBE_PREPARERX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_PREPARERX.Reg) & 0x80000000) >> 31
}

// TWIS.SUBSCRIBE_PREPARETX: Subscribe configuration for task PREPARETX
func (o *TWIS_Type) SetSUBSCRIBE_PREPARETX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_PREPARETX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_PREPARETX.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetSUBSCRIBE_PREPARETX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_PREPARETX.Reg) & 0xff
}
func (o *TWIS_Type) SetSUBSCRIBE_PREPARETX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_PREPARETX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_PREPARETX.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetSUBSCRIBE_PREPARETX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_PREPARETX.Reg) & 0x80000000) >> 31
}

// TWIS.EVENTS_STOPPED: TWI stopped
func (o *TWIS_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// TWIS.EVENTS_ERROR: TWI error
func (o *TWIS_Type) SetEVENTS_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_ERROR.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERROR.Reg) & 0x1
}

// TWIS.EVENTS_RXSTARTED: Receive sequence started
func (o *TWIS_Type) SetEVENTS_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_RXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg) & 0x1
}

// TWIS.EVENTS_TXSTARTED: Transmit sequence started
func (o *TWIS_Type) SetEVENTS_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_TXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg) & 0x1
}

// TWIS.EVENTS_WRITE: Write command received
func (o *TWIS_Type) SetEVENTS_WRITE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_WRITE.Reg, volatile.LoadUint32(&o.EVENTS_WRITE.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_WRITE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_WRITE.Reg) & 0x1
}

// TWIS.EVENTS_READ: Read command received
func (o *TWIS_Type) SetEVENTS_READ(value uint32) {
	volatile.StoreUint32(&o.EVENTS_READ.Reg, volatile.LoadUint32(&o.EVENTS_READ.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_READ() uint32 {
	return volatile.LoadUint32(&o.EVENTS_READ.Reg) & 0x1
}

// TWIS.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *TWIS_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xff
}
func (o *TWIS_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// TWIS.PUBLISH_ERROR: Publish configuration for event ERROR
func (o *TWIS_Type) SetPUBLISH_ERROR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetPUBLISH_ERROR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0xff
}
func (o *TWIS_Type) SetPUBLISH_ERROR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetPUBLISH_ERROR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0x80000000) >> 31
}

// TWIS.PUBLISH_RXSTARTED: Publish configuration for event RXSTARTED
func (o *TWIS_Type) SetPUBLISH_RXSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetPUBLISH_RXSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg) & 0xff
}
func (o *TWIS_Type) SetPUBLISH_RXSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetPUBLISH_RXSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg) & 0x80000000) >> 31
}

// TWIS.PUBLISH_TXSTARTED: Publish configuration for event TXSTARTED
func (o *TWIS_Type) SetPUBLISH_TXSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetPUBLISH_TXSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg) & 0xff
}
func (o *TWIS_Type) SetPUBLISH_TXSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetPUBLISH_TXSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg) & 0x80000000) >> 31
}

// TWIS.PUBLISH_WRITE: Publish configuration for event WRITE
func (o *TWIS_Type) SetPUBLISH_WRITE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_WRITE.Reg, volatile.LoadUint32(&o.PUBLISH_WRITE.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetPUBLISH_WRITE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_WRITE.Reg) & 0xff
}
func (o *TWIS_Type) SetPUBLISH_WRITE_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_WRITE.Reg, volatile.LoadUint32(&o.PUBLISH_WRITE.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetPUBLISH_WRITE_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_WRITE.Reg) & 0x80000000) >> 31
}

// TWIS.PUBLISH_READ: Publish configuration for event READ
func (o *TWIS_Type) SetPUBLISH_READ_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_READ.Reg, volatile.LoadUint32(&o.PUBLISH_READ.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetPUBLISH_READ_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_READ.Reg) & 0xff
}
func (o *TWIS_Type) SetPUBLISH_READ_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_READ.Reg, volatile.LoadUint32(&o.PUBLISH_READ.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetPUBLISH_READ_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_READ.Reg) & 0x80000000) >> 31
}

// TWIS.SHORTS: Shortcuts between local events and tasks
func (o *TWIS_Type) SetSHORTS_WRITE_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2000)|value<<13)
}
func (o *TWIS_Type) GetSHORTS_WRITE_SUSPEND() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2000) >> 13
}
func (o *TWIS_Type) SetSHORTS_READ_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4000)|value<<14)
}
func (o *TWIS_Type) GetSHORTS_READ_SUSPEND() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4000) >> 14
}

// TWIS.INTEN: Enable or disable interrupt
func (o *TWIS_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *TWIS_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *TWIS_Type) SetINTEN_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *TWIS_Type) GetINTEN_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *TWIS_Type) SetINTEN_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *TWIS_Type) GetINTEN_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *TWIS_Type) SetINTEN_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *TWIS_Type) GetINTEN_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *TWIS_Type) SetINTEN_WRITE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2000000)|value<<25)
}
func (o *TWIS_Type) GetINTEN_WRITE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2000000) >> 25
}
func (o *TWIS_Type) SetINTEN_READ(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000000)|value<<26)
}
func (o *TWIS_Type) GetINTEN_READ() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000000) >> 26
}

// TWIS.INTENSET: Enable interrupt
func (o *TWIS_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TWIS_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TWIS_Type) SetINTENSET_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *TWIS_Type) GetINTENSET_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *TWIS_Type) SetINTENSET_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *TWIS_Type) GetINTENSET_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *TWIS_Type) SetINTENSET_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *TWIS_Type) GetINTENSET_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *TWIS_Type) SetINTENSET_WRITE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000000)|value<<25)
}
func (o *TWIS_Type) GetINTENSET_WRITE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000000) >> 25
}
func (o *TWIS_Type) SetINTENSET_READ(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000000)|value<<26)
}
func (o *TWIS_Type) GetINTENSET_READ() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000000) >> 26
}

// TWIS.INTENCLR: Disable interrupt
func (o *TWIS_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TWIS_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TWIS_Type) SetINTENCLR_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *TWIS_Type) GetINTENCLR_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *TWIS_Type) SetINTENCLR_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *TWIS_Type) GetINTENCLR_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *TWIS_Type) SetINTENCLR_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *TWIS_Type) GetINTENCLR_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *TWIS_Type) SetINTENCLR_WRITE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *TWIS_Type) GetINTENCLR_WRITE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000000) >> 25
}
func (o *TWIS_Type) SetINTENCLR_READ(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *TWIS_Type) GetINTENCLR_READ() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000000) >> 26
}

// TWIS.ERRORSRC: Error source
func (o *TWIS_Type) SetERRORSRC_OVERFLOW(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetERRORSRC_OVERFLOW() uint32 {
	return volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x1
}
func (o *TWIS_Type) SetERRORSRC_DNACK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x4)|value<<2)
}
func (o *TWIS_Type) GetERRORSRC_DNACK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x4) >> 2
}
func (o *TWIS_Type) SetERRORSRC_OVERREAD(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x8)|value<<3)
}
func (o *TWIS_Type) GetERRORSRC_OVERREAD() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x8) >> 3
}

// TWIS.MATCH: Status register indicating which address had a match
func (o *TWIS_Type) SetMATCH(value uint32) {
	volatile.StoreUint32(&o.MATCH.Reg, volatile.LoadUint32(&o.MATCH.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetMATCH() uint32 {
	return volatile.LoadUint32(&o.MATCH.Reg) & 0x1
}

// TWIS.ENABLE: Enable TWIS
func (o *TWIS_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *TWIS_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// TWIS.ADDRESS: Description collection: TWI slave address n
func (o *TWIS_Type) SetADDRESS(idx int, value uint32) {
	volatile.StoreUint32(&o.ADDRESS[idx].Reg, volatile.LoadUint32(&o.ADDRESS[idx].Reg)&^(0x7f)|value)
}
func (o *TWIS_Type) GetADDRESS(idx int) uint32 {
	return volatile.LoadUint32(&o.ADDRESS[idx].Reg) & 0x7f
}

// TWIS.CONFIG: Configuration register for the address match mechanism
func (o *TWIS_Type) SetCONFIG_ADDRESS0(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetCONFIG_ADDRESS0() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *TWIS_Type) SetCONFIG_ADDRESS1(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x2)|value<<1)
}
func (o *TWIS_Type) GetCONFIG_ADDRESS1() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x2) >> 1
}

// TWIS.ORC: Over-read character. Character sent out in case of an over-read of the transmit buffer.
func (o *TWIS_Type) SetORC(value uint32) {
	volatile.StoreUint32(&o.ORC.Reg, volatile.LoadUint32(&o.ORC.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetORC() uint32 {
	return volatile.LoadUint32(&o.ORC.Reg) & 0xff
}

type TWIS_PSEL_Type struct {
	SCL volatile.Register32 // 0x508
	SDA volatile.Register32 // 0x50C
}

// TWIS_PSEL.SCL: Pin select for SCL signal
func (o *TWIS_PSEL_Type) SetSCL_PIN(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x1f)|value)
}
func (o *TWIS_PSEL_Type) GetSCL_PIN() uint32 {
	return volatile.LoadUint32(&o.SCL.Reg) & 0x1f
}
func (o *TWIS_PSEL_Type) SetSCL_PORT(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x20)|value<<5)
}
func (o *TWIS_PSEL_Type) GetSCL_PORT() uint32 {
	return (volatile.LoadUint32(&o.SCL.Reg) & 0x20) >> 5
}
func (o *TWIS_PSEL_Type) SetSCL_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_PSEL_Type) GetSCL_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCL.Reg) & 0x80000000) >> 31
}

// TWIS_PSEL.SDA: Pin select for SDA signal
func (o *TWIS_PSEL_Type) SetSDA_PIN(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x1f)|value)
}
func (o *TWIS_PSEL_Type) GetSDA_PIN() uint32 {
	return volatile.LoadUint32(&o.SDA.Reg) & 0x1f
}
func (o *TWIS_PSEL_Type) SetSDA_PORT(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x20)|value<<5)
}
func (o *TWIS_PSEL_Type) GetSDA_PORT() uint32 {
	return (volatile.LoadUint32(&o.SDA.Reg) & 0x20) >> 5
}
func (o *TWIS_PSEL_Type) SetSDA_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_PSEL_Type) GetSDA_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SDA.Reg) & 0x80000000) >> 31
}

type TWIS_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
	LIST   volatile.Register32 // 0x540
}

// TWIS_RXD.PTR: RXD Data pointer
func (o *TWIS_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *TWIS_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// TWIS_RXD.MAXCNT: Maximum number of bytes in RXD buffer
func (o *TWIS_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *TWIS_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// TWIS_RXD.AMOUNT: Number of bytes transferred in the last RXD transaction
func (o *TWIS_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *TWIS_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// TWIS_RXD.LIST: EasyDMA list type
func (o *TWIS_RXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *TWIS_RXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

type TWIS_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
	LIST   volatile.Register32 // 0x550
}

// TWIS_TXD.PTR: TXD Data pointer
func (o *TWIS_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *TWIS_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// TWIS_TXD.MAXCNT: Maximum number of bytes in TXD buffer
func (o *TWIS_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *TWIS_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// TWIS_TXD.AMOUNT: Number of bytes transferred in the last TXD transaction
func (o *TWIS_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *TWIS_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// TWIS_TXD.LIST: EasyDMA list type
func (o *TWIS_TXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *TWIS_TXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

// UART with EasyDMA 0
type UARTE_Type struct {
	TASKS_STARTRX     volatile.Register32 // 0x0
	TASKS_STOPRX      volatile.Register32 // 0x4
	TASKS_STARTTX     volatile.Register32 // 0x8
	TASKS_STOPTX      volatile.Register32 // 0xC
	_                 [28]byte
	TASKS_FLUSHRX     volatile.Register32 // 0x2C
	_                 [80]byte
	SUBSCRIBE_STARTRX volatile.Register32 // 0x80
	SUBSCRIBE_STOPRX  volatile.Register32 // 0x84
	SUBSCRIBE_STARTTX volatile.Register32 // 0x88
	SUBSCRIBE_STOPTX  volatile.Register32 // 0x8C
	_                 [28]byte
	SUBSCRIBE_FLUSHRX volatile.Register32 // 0xAC
	_                 [80]byte
	EVENTS_CTS        volatile.Register32 // 0x100
	EVENTS_NCTS       volatile.Register32 // 0x104
	EVENTS_RXDRDY     volatile.Register32 // 0x108
	_                 [4]byte
	EVENTS_ENDRX      volatile.Register32 // 0x110
	_                 [8]byte
	EVENTS_TXDRDY     volatile.Register32 // 0x11C
	EVENTS_ENDTX      volatile.Register32 // 0x120
	EVENTS_ERROR      volatile.Register32 // 0x124
	_                 [28]byte
	EVENTS_RXTO       volatile.Register32 // 0x144
	_                 [4]byte
	EVENTS_RXSTARTED  volatile.Register32 // 0x14C
	EVENTS_TXSTARTED  volatile.Register32 // 0x150
	_                 [4]byte
	EVENTS_TXSTOPPED  volatile.Register32 // 0x158
	_                 [36]byte
	PUBLISH_CTS       volatile.Register32 // 0x180
	PUBLISH_NCTS      volatile.Register32 // 0x184
	PUBLISH_RXDRDY    volatile.Register32 // 0x188
	_                 [4]byte
	PUBLISH_ENDRX     volatile.Register32 // 0x190
	_                 [8]byte
	PUBLISH_TXDRDY    volatile.Register32 // 0x19C
	PUBLISH_ENDTX     volatile.Register32 // 0x1A0
	PUBLISH_ERROR     volatile.Register32 // 0x1A4
	_                 [28]byte
	PUBLISH_RXTO      volatile.Register32 // 0x1C4
	_                 [4]byte
	PUBLISH_RXSTARTED volatile.Register32 // 0x1CC
	PUBLISH_TXSTARTED volatile.Register32 // 0x1D0
	_                 [4]byte
	PUBLISH_TXSTOPPED volatile.Register32 // 0x1D8
	_                 [36]byte
	SHORTS            volatile.Register32 // 0x200
	_                 [252]byte
	INTEN             volatile.Register32 // 0x300
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
	_                 [372]byte
	ERRORSRC          volatile.Register32 // 0x480
	_                 [124]byte
	ENABLE            volatile.Register32 // 0x500
	_                 [4]byte
	PSEL              UARTE_PSEL_Type // 0x508
	_                 [12]byte
	BAUDRATE          volatile.Register32 // 0x524
	_                 [12]byte
	RXD               UARTE_RXD_Type // 0x534
	_                 [4]byte
	TXD               UARTE_TXD_Type // 0x544
	_                 [28]byte
	CONFIG            volatile.Register32 // 0x56C
}

// UARTE.TASKS_STARTRX: Start UART receiver
func (o *UARTE_Type) SetTASKS_STARTRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTRX.Reg, volatile.LoadUint32(&o.TASKS_STARTRX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_STARTRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTRX.Reg) & 0x1
}

// UARTE.TASKS_STOPRX: Stop UART receiver
func (o *UARTE_Type) SetTASKS_STOPRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOPRX.Reg, volatile.LoadUint32(&o.TASKS_STOPRX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_STOPRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOPRX.Reg) & 0x1
}

// UARTE.TASKS_STARTTX: Start UART transmitter
func (o *UARTE_Type) SetTASKS_STARTTX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTTX.Reg, volatile.LoadUint32(&o.TASKS_STARTTX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_STARTTX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTTX.Reg) & 0x1
}

// UARTE.TASKS_STOPTX: Stop UART transmitter
func (o *UARTE_Type) SetTASKS_STOPTX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOPTX.Reg, volatile.LoadUint32(&o.TASKS_STOPTX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_STOPTX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOPTX.Reg) & 0x1
}

// UARTE.TASKS_FLUSHRX: Flush RX FIFO into RX buffer
func (o *UARTE_Type) SetTASKS_FLUSHRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_FLUSHRX.Reg, volatile.LoadUint32(&o.TASKS_FLUSHRX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_FLUSHRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_FLUSHRX.Reg) & 0x1
}

// UARTE.SUBSCRIBE_STARTRX: Subscribe configuration for task STARTRX
func (o *UARTE_Type) SetSUBSCRIBE_STARTRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetSUBSCRIBE_STARTRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg) & 0xff
}
func (o *UARTE_Type) SetSUBSCRIBE_STARTRX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetSUBSCRIBE_STARTRX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg) & 0x80000000) >> 31
}

// UARTE.SUBSCRIBE_STOPRX: Subscribe configuration for task STOPRX
func (o *UARTE_Type) SetSUBSCRIBE_STOPRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOPRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOPRX.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetSUBSCRIBE_STOPRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOPRX.Reg) & 0xff
}
func (o *UARTE_Type) SetSUBSCRIBE_STOPRX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOPRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOPRX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetSUBSCRIBE_STOPRX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOPRX.Reg) & 0x80000000) >> 31
}

// UARTE.SUBSCRIBE_STARTTX: Subscribe configuration for task STARTTX
func (o *UARTE_Type) SetSUBSCRIBE_STARTTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetSUBSCRIBE_STARTTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg) & 0xff
}
func (o *UARTE_Type) SetSUBSCRIBE_STARTTX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetSUBSCRIBE_STARTTX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg) & 0x80000000) >> 31
}

// UARTE.SUBSCRIBE_STOPTX: Subscribe configuration for task STOPTX
func (o *UARTE_Type) SetSUBSCRIBE_STOPTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOPTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOPTX.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetSUBSCRIBE_STOPTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOPTX.Reg) & 0xff
}
func (o *UARTE_Type) SetSUBSCRIBE_STOPTX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOPTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOPTX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetSUBSCRIBE_STOPTX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOPTX.Reg) & 0x80000000) >> 31
}

// UARTE.SUBSCRIBE_FLUSHRX: Subscribe configuration for task FLUSHRX
func (o *UARTE_Type) SetSUBSCRIBE_FLUSHRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_FLUSHRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_FLUSHRX.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetSUBSCRIBE_FLUSHRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_FLUSHRX.Reg) & 0xff
}
func (o *UARTE_Type) SetSUBSCRIBE_FLUSHRX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_FLUSHRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_FLUSHRX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetSUBSCRIBE_FLUSHRX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_FLUSHRX.Reg) & 0x80000000) >> 31
}

// UARTE.EVENTS_CTS: CTS is activated (set low). Clear To Send.
func (o *UARTE_Type) SetEVENTS_CTS(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CTS.Reg, volatile.LoadUint32(&o.EVENTS_CTS.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_CTS() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CTS.Reg) & 0x1
}

// UARTE.EVENTS_NCTS: CTS is deactivated (set high). Not Clear To Send.
func (o *UARTE_Type) SetEVENTS_NCTS(value uint32) {
	volatile.StoreUint32(&o.EVENTS_NCTS.Reg, volatile.LoadUint32(&o.EVENTS_NCTS.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_NCTS() uint32 {
	return volatile.LoadUint32(&o.EVENTS_NCTS.Reg) & 0x1
}

// UARTE.EVENTS_RXDRDY: Data received in RXD (but potentially not yet transferred to Data RAM)
func (o *UARTE_Type) SetEVENTS_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXDRDY.Reg, volatile.LoadUint32(&o.EVENTS_RXDRDY.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_RXDRDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXDRDY.Reg) & 0x1
}

// UARTE.EVENTS_ENDRX: Receive buffer is filled up
func (o *UARTE_Type) SetEVENTS_ENDRX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDRX.Reg, volatile.LoadUint32(&o.EVENTS_ENDRX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_ENDRX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDRX.Reg) & 0x1
}

// UARTE.EVENTS_TXDRDY: Data sent from TXD
func (o *UARTE_Type) SetEVENTS_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXDRDY.Reg, volatile.LoadUint32(&o.EVENTS_TXDRDY.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_TXDRDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXDRDY.Reg) & 0x1
}

// UARTE.EVENTS_ENDTX: Last TX byte transmitted
func (o *UARTE_Type) SetEVENTS_ENDTX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDTX.Reg, volatile.LoadUint32(&o.EVENTS_ENDTX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_ENDTX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDTX.Reg) & 0x1
}

// UARTE.EVENTS_ERROR: Error detected
func (o *UARTE_Type) SetEVENTS_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_ERROR.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERROR.Reg) & 0x1
}

// UARTE.EVENTS_RXTO: Receiver timeout
func (o *UARTE_Type) SetEVENTS_RXTO(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXTO.Reg, volatile.LoadUint32(&o.EVENTS_RXTO.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_RXTO() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXTO.Reg) & 0x1
}

// UARTE.EVENTS_RXSTARTED: UART receiver has started
func (o *UARTE_Type) SetEVENTS_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_RXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg) & 0x1
}

// UARTE.EVENTS_TXSTARTED: UART transmitter has started
func (o *UARTE_Type) SetEVENTS_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_TXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg) & 0x1
}

// UARTE.EVENTS_TXSTOPPED: Transmitter stopped
func (o *UARTE_Type) SetEVENTS_TXSTOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXSTOPPED.Reg, volatile.LoadUint32(&o.EVENTS_TXSTOPPED.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_TXSTOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXSTOPPED.Reg) & 0x1
}

// UARTE.PUBLISH_CTS: Publish configuration for event CTS
func (o *UARTE_Type) SetPUBLISH_CTS_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CTS.Reg, volatile.LoadUint32(&o.PUBLISH_CTS.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_CTS_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_CTS.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_CTS_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CTS.Reg, volatile.LoadUint32(&o.PUBLISH_CTS.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_CTS_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_CTS.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_NCTS: Publish configuration for event NCTS
func (o *UARTE_Type) SetPUBLISH_NCTS_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_NCTS.Reg, volatile.LoadUint32(&o.PUBLISH_NCTS.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_NCTS_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_NCTS.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_NCTS_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_NCTS.Reg, volatile.LoadUint32(&o.PUBLISH_NCTS.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_NCTS_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_NCTS.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_RXDRDY: Publish configuration for event RXDRDY
func (o *UARTE_Type) SetPUBLISH_RXDRDY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXDRDY.Reg, volatile.LoadUint32(&o.PUBLISH_RXDRDY.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_RXDRDY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXDRDY.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_RXDRDY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXDRDY.Reg, volatile.LoadUint32(&o.PUBLISH_RXDRDY.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_RXDRDY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXDRDY.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_ENDRX: Publish configuration for event ENDRX
func (o *UARTE_Type) SetPUBLISH_ENDRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_ENDRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_ENDRX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_ENDRX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_TXDRDY: Publish configuration for event TXDRDY
func (o *UARTE_Type) SetPUBLISH_TXDRDY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXDRDY.Reg, volatile.LoadUint32(&o.PUBLISH_TXDRDY.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_TXDRDY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXDRDY.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_TXDRDY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXDRDY.Reg, volatile.LoadUint32(&o.PUBLISH_TXDRDY.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_TXDRDY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXDRDY.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_ENDTX: Publish configuration for event ENDTX
func (o *UARTE_Type) SetPUBLISH_ENDTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDTX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_ENDTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_ENDTX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDTX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_ENDTX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_ERROR: Publish configuration for event ERROR
func (o *UARTE_Type) SetPUBLISH_ERROR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_ERROR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_ERROR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_ERROR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_RXTO: Publish configuration for event RXTO
func (o *UARTE_Type) SetPUBLISH_RXTO_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXTO.Reg, volatile.LoadUint32(&o.PUBLISH_RXTO.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_RXTO_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXTO.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_RXTO_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXTO.Reg, volatile.LoadUint32(&o.PUBLISH_RXTO.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_RXTO_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXTO.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_RXSTARTED: Publish configuration for event RXSTARTED
func (o *UARTE_Type) SetPUBLISH_RXSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_RXSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_RXSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_RXSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_TXSTARTED: Publish configuration for event TXSTARTED
func (o *UARTE_Type) SetPUBLISH_TXSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_TXSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_TXSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_TXSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_TXSTOPPED: Publish configuration for event TXSTOPPED
func (o *UARTE_Type) SetPUBLISH_TXSTOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTOPPED.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_TXSTOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXSTOPPED.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_TXSTOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_TXSTOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXSTOPPED.Reg) & 0x80000000) >> 31
}

// UARTE.SHORTS: Shortcuts between local events and tasks
func (o *UARTE_Type) SetSHORTS_ENDRX_STARTRX(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20)|value<<5)
}
func (o *UARTE_Type) GetSHORTS_ENDRX_STARTRX() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20) >> 5
}
func (o *UARTE_Type) SetSHORTS_ENDRX_STOPRX(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x40)|value<<6)
}
func (o *UARTE_Type) GetSHORTS_ENDRX_STOPRX() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x40) >> 6
}

// UARTE.INTEN: Enable or disable interrupt
func (o *UARTE_Type) SetINTEN_CTS(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetINTEN_CTS() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *UARTE_Type) SetINTEN_NCTS(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *UARTE_Type) GetINTEN_NCTS() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *UARTE_Type) SetINTEN_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *UARTE_Type) GetINTEN_RXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *UARTE_Type) SetINTEN_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *UARTE_Type) GetINTEN_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *UARTE_Type) SetINTEN_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *UARTE_Type) GetINTEN_TXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *UARTE_Type) SetINTEN_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *UARTE_Type) GetINTEN_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *UARTE_Type) SetINTEN_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *UARTE_Type) GetINTEN_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *UARTE_Type) SetINTEN_RXTO(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20000)|value<<17)
}
func (o *UARTE_Type) GetINTEN_RXTO() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20000) >> 17
}
func (o *UARTE_Type) SetINTEN_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *UARTE_Type) GetINTEN_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *UARTE_Type) SetINTEN_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *UARTE_Type) GetINTEN_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *UARTE_Type) SetINTEN_TXSTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400000)|value<<22)
}
func (o *UARTE_Type) GetINTEN_TXSTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400000) >> 22
}

// UARTE.INTENSET: Enable interrupt
func (o *UARTE_Type) SetINTENSET_CTS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetINTENSET_CTS() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *UARTE_Type) SetINTENSET_NCTS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *UARTE_Type) GetINTENSET_NCTS() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *UARTE_Type) SetINTENSET_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *UARTE_Type) GetINTENSET_RXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *UARTE_Type) SetINTENSET_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *UARTE_Type) GetINTENSET_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *UARTE_Type) SetINTENSET_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *UARTE_Type) GetINTENSET_TXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *UARTE_Type) SetINTENSET_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *UARTE_Type) GetINTENSET_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *UARTE_Type) SetINTENSET_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *UARTE_Type) GetINTENSET_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *UARTE_Type) SetINTENSET_RXTO(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *UARTE_Type) GetINTENSET_RXTO() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *UARTE_Type) SetINTENSET_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *UARTE_Type) GetINTENSET_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *UARTE_Type) SetINTENSET_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *UARTE_Type) GetINTENSET_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *UARTE_Type) SetINTENSET_TXSTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400000)|value<<22)
}
func (o *UARTE_Type) GetINTENSET_TXSTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400000) >> 22
}

// UARTE.INTENCLR: Disable interrupt
func (o *UARTE_Type) SetINTENCLR_CTS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetINTENCLR_CTS() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *UARTE_Type) SetINTENCLR_NCTS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *UARTE_Type) GetINTENCLR_NCTS() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *UARTE_Type) SetINTENCLR_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *UARTE_Type) GetINTENCLR_RXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *UARTE_Type) SetINTENCLR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *UARTE_Type) GetINTENCLR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *UARTE_Type) SetINTENCLR_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *UARTE_Type) GetINTENCLR_TXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *UARTE_Type) SetINTENCLR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *UARTE_Type) GetINTENCLR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *UARTE_Type) SetINTENCLR_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *UARTE_Type) GetINTENCLR_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *UARTE_Type) SetINTENCLR_RXTO(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *UARTE_Type) GetINTENCLR_RXTO() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *UARTE_Type) SetINTENCLR_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *UARTE_Type) GetINTENCLR_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *UARTE_Type) SetINTENCLR_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *UARTE_Type) GetINTENCLR_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *UARTE_Type) SetINTENCLR_TXSTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400000)|value<<22)
}
func (o *UARTE_Type) GetINTENCLR_TXSTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400000) >> 22
}

// UARTE.ERRORSRC: Error source Note : this register is read / write one to clear.
func (o *UARTE_Type) SetERRORSRC_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetERRORSRC_OVERRUN() uint32 {
	return volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x1
}
func (o *UARTE_Type) SetERRORSRC_PARITY(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x2)|value<<1)
}
func (o *UARTE_Type) GetERRORSRC_PARITY() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x2) >> 1
}
func (o *UARTE_Type) SetERRORSRC_FRAMING(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x4)|value<<2)
}
func (o *UARTE_Type) GetERRORSRC_FRAMING() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x4) >> 2
}
func (o *UARTE_Type) SetERRORSRC_BREAK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x8)|value<<3)
}
func (o *UARTE_Type) GetERRORSRC_BREAK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x8) >> 3
}

// UARTE.ENABLE: Enable UART
func (o *UARTE_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// UARTE.BAUDRATE: Baud rate. Accuracy depends on the HFCLK source selected.
func (o *UARTE_Type) SetBAUDRATE(value uint32) {
	volatile.StoreUint32(&o.BAUDRATE.Reg, value)
}
func (o *UARTE_Type) GetBAUDRATE() uint32 {
	return volatile.LoadUint32(&o.BAUDRATE.Reg)
}

// UARTE.CONFIG: Configuration of parity and hardware flow control
func (o *UARTE_Type) SetCONFIG_HWFC(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetCONFIG_HWFC() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *UARTE_Type) SetCONFIG_PARITY(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0xe)|value<<1)
}
func (o *UARTE_Type) GetCONFIG_PARITY() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0xe) >> 1
}
func (o *UARTE_Type) SetCONFIG_STOP(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x10)|value<<4)
}
func (o *UARTE_Type) GetCONFIG_STOP() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x10) >> 4
}
func (o *UARTE_Type) SetCONFIG_PARITYTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x100)|value<<8)
}
func (o *UARTE_Type) GetCONFIG_PARITYTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x100) >> 8
}

type UARTE_PSEL_Type struct {
	RTS volatile.Register32 // 0x508
	TXD volatile.Register32 // 0x50C
	CTS volatile.Register32 // 0x510
	RXD volatile.Register32 // 0x514
}

// UARTE_PSEL.RTS: Pin select for RTS signal
func (o *UARTE_PSEL_Type) SetRTS_PIN(value uint32) {
	volatile.StoreUint32(&o.RTS.Reg, volatile.LoadUint32(&o.RTS.Reg)&^(0x1f)|value)
}
func (o *UARTE_PSEL_Type) GetRTS_PIN() uint32 {
	return volatile.LoadUint32(&o.RTS.Reg) & 0x1f
}
func (o *UARTE_PSEL_Type) SetRTS_PORT(value uint32) {
	volatile.StoreUint32(&o.RTS.Reg, volatile.LoadUint32(&o.RTS.Reg)&^(0x20)|value<<5)
}
func (o *UARTE_PSEL_Type) GetRTS_PORT() uint32 {
	return (volatile.LoadUint32(&o.RTS.Reg) & 0x20) >> 5
}
func (o *UARTE_PSEL_Type) SetRTS_CONNECT(value uint32) {
	volatile.StoreUint32(&o.RTS.Reg, volatile.LoadUint32(&o.RTS.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_PSEL_Type) GetRTS_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.RTS.Reg) & 0x80000000) >> 31
}

// UARTE_PSEL.TXD: Pin select for TXD signal
func (o *UARTE_PSEL_Type) SetTXD_PIN(value uint32) {
	volatile.StoreUint32(&o.TXD.Reg, volatile.LoadUint32(&o.TXD.Reg)&^(0x1f)|value)
}
func (o *UARTE_PSEL_Type) GetTXD_PIN() uint32 {
	return volatile.LoadUint32(&o.TXD.Reg) & 0x1f
}
func (o *UARTE_PSEL_Type) SetTXD_PORT(value uint32) {
	volatile.StoreUint32(&o.TXD.Reg, volatile.LoadUint32(&o.TXD.Reg)&^(0x20)|value<<5)
}
func (o *UARTE_PSEL_Type) GetTXD_PORT() uint32 {
	return (volatile.LoadUint32(&o.TXD.Reg) & 0x20) >> 5
}
func (o *UARTE_PSEL_Type) SetTXD_CONNECT(value uint32) {
	volatile.StoreUint32(&o.TXD.Reg, volatile.LoadUint32(&o.TXD.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_PSEL_Type) GetTXD_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.TXD.Reg) & 0x80000000) >> 31
}

// UARTE_PSEL.CTS: Pin select for CTS signal
func (o *UARTE_PSEL_Type) SetCTS_PIN(value uint32) {
	volatile.StoreUint32(&o.CTS.Reg, volatile.LoadUint32(&o.CTS.Reg)&^(0x1f)|value)
}
func (o *UARTE_PSEL_Type) GetCTS_PIN() uint32 {
	return volatile.LoadUint32(&o.CTS.Reg) & 0x1f
}
func (o *UARTE_PSEL_Type) SetCTS_PORT(value uint32) {
	volatile.StoreUint32(&o.CTS.Reg, volatile.LoadUint32(&o.CTS.Reg)&^(0x20)|value<<5)
}
func (o *UARTE_PSEL_Type) GetCTS_PORT() uint32 {
	return (volatile.LoadUint32(&o.CTS.Reg) & 0x20) >> 5
}
func (o *UARTE_PSEL_Type) SetCTS_CONNECT(value uint32) {
	volatile.StoreUint32(&o.CTS.Reg, volatile.LoadUint32(&o.CTS.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_PSEL_Type) GetCTS_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.CTS.Reg) & 0x80000000) >> 31
}

// UARTE_PSEL.RXD: Pin select for RXD signal
func (o *UARTE_PSEL_Type) SetRXD_PIN(value uint32) {
	volatile.StoreUint32(&o.RXD.Reg, volatile.LoadUint32(&o.RXD.Reg)&^(0x1f)|value)
}
func (o *UARTE_PSEL_Type) GetRXD_PIN() uint32 {
	return volatile.LoadUint32(&o.RXD.Reg) & 0x1f
}
func (o *UARTE_PSEL_Type) SetRXD_PORT(value uint32) {
	volatile.StoreUint32(&o.RXD.Reg, volatile.LoadUint32(&o.RXD.Reg)&^(0x20)|value<<5)
}
func (o *UARTE_PSEL_Type) GetRXD_PORT() uint32 {
	return (volatile.LoadUint32(&o.RXD.Reg) & 0x20) >> 5
}
func (o *UARTE_PSEL_Type) SetRXD_CONNECT(value uint32) {
	volatile.StoreUint32(&o.RXD.Reg, volatile.LoadUint32(&o.RXD.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_PSEL_Type) GetRXD_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.RXD.Reg) & 0x80000000) >> 31
}

type UARTE_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
}

// UARTE_RXD.PTR: Data pointer
func (o *UARTE_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *UARTE_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// UARTE_RXD.MAXCNT: Maximum number of bytes in receive buffer
func (o *UARTE_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *UARTE_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// UARTE_RXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *UARTE_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *UARTE_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

type UARTE_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
}

// UARTE_TXD.PTR: Data pointer
func (o *UARTE_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *UARTE_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// UARTE_TXD.MAXCNT: Maximum number of bytes in transmit buffer
func (o *UARTE_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *UARTE_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// UARTE_TXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *UARTE_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *UARTE_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// GPIO Tasks and Events 0
type GPIOTE_Type struct {
	TASKS_OUT     [8]volatile.Register32 // 0x0
	_             [16]byte
	TASKS_SET     [8]volatile.Register32 // 0x30
	_             [16]byte
	TASKS_CLR     [8]volatile.Register32 // 0x60
	SUBSCRIBE_OUT [8]volatile.Register32 // 0x80
	_             [16]byte
	SUBSCRIBE_SET [8]volatile.Register32 // 0xB0
	_             [16]byte
	SUBSCRIBE_CLR [8]volatile.Register32 // 0xE0
	EVENTS_IN     [8]volatile.Register32 // 0x100
	_             [92]byte
	EVENTS_PORT   volatile.Register32    // 0x17C
	PUBLISH_IN    [8]volatile.Register32 // 0x180
	_             [92]byte
	PUBLISH_PORT  volatile.Register32 // 0x1FC
	_             [260]byte
	INTENSET      volatile.Register32 // 0x304
	INTENCLR      volatile.Register32 // 0x308
	_             [504]byte
	LATENCY       volatile.Register32 // 0x504
	_             [8]byte
	CONFIG        [8]volatile.Register32 // 0x510
}

// GPIOTE.TASKS_OUT: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is configured in CONFIG[n].POLARITY.
func (o *GPIOTE_Type) SetTASKS_OUT(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_OUT[idx].Reg, volatile.LoadUint32(&o.TASKS_OUT[idx].Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetTASKS_OUT(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_OUT[idx].Reg) & 0x1
}

// GPIOTE.TASKS_SET: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is to set it high.
func (o *GPIOTE_Type) SetTASKS_SET(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_SET[idx].Reg, volatile.LoadUint32(&o.TASKS_SET[idx].Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetTASKS_SET(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_SET[idx].Reg) & 0x1
}

// GPIOTE.TASKS_CLR: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is to set it low.
func (o *GPIOTE_Type) SetTASKS_CLR(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_CLR[idx].Reg, volatile.LoadUint32(&o.TASKS_CLR[idx].Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetTASKS_CLR(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_CLR[idx].Reg) & 0x1
}

// GPIOTE.SUBSCRIBE_OUT: Description collection: Subscribe configuration for task OUT[n]
func (o *GPIOTE_Type) SetSUBSCRIBE_OUT_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_OUT[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_OUT[idx].Reg)&^(0xff)|value)
}
func (o *GPIOTE_Type) GetSUBSCRIBE_OUT_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_OUT[idx].Reg) & 0xff
}
func (o *GPIOTE_Type) SetSUBSCRIBE_OUT_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_OUT[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_OUT[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetSUBSCRIBE_OUT_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_OUT[idx].Reg) & 0x80000000) >> 31
}

// GPIOTE.SUBSCRIBE_SET: Description collection: Subscribe configuration for task SET[n]
func (o *GPIOTE_Type) SetSUBSCRIBE_SET_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SET[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_SET[idx].Reg)&^(0xff)|value)
}
func (o *GPIOTE_Type) GetSUBSCRIBE_SET_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SET[idx].Reg) & 0xff
}
func (o *GPIOTE_Type) SetSUBSCRIBE_SET_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SET[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_SET[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetSUBSCRIBE_SET_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SET[idx].Reg) & 0x80000000) >> 31
}

// GPIOTE.SUBSCRIBE_CLR: Description collection: Subscribe configuration for task CLR[n]
func (o *GPIOTE_Type) SetSUBSCRIBE_CLR_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CLR[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_CLR[idx].Reg)&^(0xff)|value)
}
func (o *GPIOTE_Type) GetSUBSCRIBE_CLR_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CLR[idx].Reg) & 0xff
}
func (o *GPIOTE_Type) SetSUBSCRIBE_CLR_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CLR[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_CLR[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetSUBSCRIBE_CLR_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CLR[idx].Reg) & 0x80000000) >> 31
}

// GPIOTE.EVENTS_IN: Description collection: Event generated from pin specified in CONFIG[n].PSEL
func (o *GPIOTE_Type) SetEVENTS_IN(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_IN[idx].Reg, volatile.LoadUint32(&o.EVENTS_IN[idx].Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetEVENTS_IN(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_IN[idx].Reg) & 0x1
}

// GPIOTE.EVENTS_PORT: Event generated from multiple input GPIO pins with SENSE mechanism enabled
func (o *GPIOTE_Type) SetEVENTS_PORT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_PORT.Reg, volatile.LoadUint32(&o.EVENTS_PORT.Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetEVENTS_PORT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_PORT.Reg) & 0x1
}

// GPIOTE.PUBLISH_IN: Description collection: Publish configuration for event IN[n]
func (o *GPIOTE_Type) SetPUBLISH_IN_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_IN[idx].Reg, volatile.LoadUint32(&o.PUBLISH_IN[idx].Reg)&^(0xff)|value)
}
func (o *GPIOTE_Type) GetPUBLISH_IN_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_IN[idx].Reg) & 0xff
}
func (o *GPIOTE_Type) SetPUBLISH_IN_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_IN[idx].Reg, volatile.LoadUint32(&o.PUBLISH_IN[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetPUBLISH_IN_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_IN[idx].Reg) & 0x80000000) >> 31
}

// GPIOTE.PUBLISH_PORT: Publish configuration for event PORT
func (o *GPIOTE_Type) SetPUBLISH_PORT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_PORT.Reg, volatile.LoadUint32(&o.PUBLISH_PORT.Reg)&^(0xff)|value)
}
func (o *GPIOTE_Type) GetPUBLISH_PORT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_PORT.Reg) & 0xff
}
func (o *GPIOTE_Type) SetPUBLISH_PORT_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_PORT.Reg, volatile.LoadUint32(&o.PUBLISH_PORT.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetPUBLISH_PORT_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_PORT.Reg) & 0x80000000) >> 31
}

// GPIOTE.INTENSET: Enable interrupt
func (o *GPIOTE_Type) SetINTENSET_IN0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetINTENSET_IN0() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *GPIOTE_Type) SetINTENSET_IN1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *GPIOTE_Type) GetINTENSET_IN1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *GPIOTE_Type) SetINTENSET_IN2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *GPIOTE_Type) GetINTENSET_IN2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *GPIOTE_Type) SetINTENSET_IN3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *GPIOTE_Type) GetINTENSET_IN3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *GPIOTE_Type) SetINTENSET_IN4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *GPIOTE_Type) GetINTENSET_IN4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *GPIOTE_Type) SetINTENSET_IN5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *GPIOTE_Type) GetINTENSET_IN5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *GPIOTE_Type) SetINTENSET_IN6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *GPIOTE_Type) GetINTENSET_IN6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *GPIOTE_Type) SetINTENSET_IN7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *GPIOTE_Type) GetINTENSET_IN7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *GPIOTE_Type) SetINTENSET_PORT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetINTENSET_PORT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000000) >> 31
}

// GPIOTE.INTENCLR: Disable interrupt
func (o *GPIOTE_Type) SetINTENCLR_IN0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetINTENCLR_IN0() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *GPIOTE_Type) SetINTENCLR_IN1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *GPIOTE_Type) GetINTENCLR_IN1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *GPIOTE_Type) SetINTENCLR_IN2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *GPIOTE_Type) GetINTENCLR_IN2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *GPIOTE_Type) SetINTENCLR_IN3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *GPIOTE_Type) GetINTENCLR_IN3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *GPIOTE_Type) SetINTENCLR_IN4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *GPIOTE_Type) GetINTENCLR_IN4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *GPIOTE_Type) SetINTENCLR_IN5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *GPIOTE_Type) GetINTENCLR_IN5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *GPIOTE_Type) SetINTENCLR_IN6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *GPIOTE_Type) GetINTENCLR_IN6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *GPIOTE_Type) SetINTENCLR_IN7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *GPIOTE_Type) GetINTENCLR_IN7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *GPIOTE_Type) SetINTENCLR_PORT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetINTENCLR_PORT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000000) >> 31
}

// GPIOTE.LATENCY: Latency selection for Event mode (MODE=Event) with rising or falling edge detection on the pin.
func (o *GPIOTE_Type) SetLATENCY(value uint32) {
	volatile.StoreUint32(&o.LATENCY.Reg, volatile.LoadUint32(&o.LATENCY.Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetLATENCY() uint32 {
	return volatile.LoadUint32(&o.LATENCY.Reg) & 0x1
}

// GPIOTE.CONFIG: Description collection: Configuration for OUT[n], SET[n], and CLR[n] tasks and IN[n] event
func (o *GPIOTE_Type) SetCONFIG_MODE(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x3)|value)
}
func (o *GPIOTE_Type) GetCONFIG_MODE(idx int) uint32 {
	return volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x3
}
func (o *GPIOTE_Type) SetCONFIG_PSEL(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x1f00)|value<<8)
}
func (o *GPIOTE_Type) GetCONFIG_PSEL(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x1f00) >> 8
}
func (o *GPIOTE_Type) SetCONFIG_PORT(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GPIOTE_Type) GetCONFIG_PORT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x2000) >> 13
}
func (o *GPIOTE_Type) SetCONFIG_POLARITY(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x30000)|value<<16)
}
func (o *GPIOTE_Type) GetCONFIG_POLARITY(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x30000) >> 16
}
func (o *GPIOTE_Type) SetCONFIG_OUTINIT(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GPIOTE_Type) GetCONFIG_OUTINIT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x100000) >> 20
}

// Analog to Digital Converter 0
type SAADC_Type struct {
	TASKS_START               volatile.Register32 // 0x0
	TASKS_SAMPLE              volatile.Register32 // 0x4
	TASKS_STOP                volatile.Register32 // 0x8
	TASKS_CALIBRATEOFFSET     volatile.Register32 // 0xC
	_                         [112]byte
	SUBSCRIBE_START           volatile.Register32 // 0x80
	SUBSCRIBE_SAMPLE          volatile.Register32 // 0x84
	SUBSCRIBE_STOP            volatile.Register32 // 0x88
	SUBSCRIBE_CALIBRATEOFFSET volatile.Register32 // 0x8C
	_                         [112]byte
	EVENTS_STARTED            volatile.Register32     // 0x100
	EVENTS_END                volatile.Register32     // 0x104
	EVENTS_DONE               volatile.Register32     // 0x108
	EVENTS_RESULTDONE         volatile.Register32     // 0x10C
	EVENTS_CALIBRATEDONE      volatile.Register32     // 0x110
	EVENTS_STOPPED            volatile.Register32     // 0x114
	EVENTS_CH                 [8]SAADC_EVENTS_CH_Type // 0x118
	_                         [40]byte
	PUBLISH_STARTED           volatile.Register32      // 0x180
	PUBLISH_END               volatile.Register32      // 0x184
	PUBLISH_DONE              volatile.Register32      // 0x188
	PUBLISH_RESULTDONE        volatile.Register32      // 0x18C
	PUBLISH_CALIBRATEDONE     volatile.Register32      // 0x190
	PUBLISH_STOPPED           volatile.Register32      // 0x194
	PUBLISH_CH                [8]SAADC_PUBLISH_CH_Type // 0x198
	_                         [296]byte
	INTEN                     volatile.Register32 // 0x300
	INTENSET                  volatile.Register32 // 0x304
	INTENCLR                  volatile.Register32 // 0x308
	_                         [244]byte
	STATUS                    volatile.Register32 // 0x400
	_                         [252]byte
	ENABLE                    volatile.Register32 // 0x500
	_                         [12]byte
	CH                        [8]SAADC_CH_Type // 0x510
	_                         [96]byte
	RESOLUTION                volatile.Register32 // 0x5F0
	OVERSAMPLE                volatile.Register32 // 0x5F4
	SAMPLERATE                volatile.Register32 // 0x5F8
	_                         [48]byte
	RESULT                    SAADC_RESULT_Type // 0x62C
}

// SAADC.TASKS_START: Start the ADC and prepare the result buffer in RAM
func (o *SAADC_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// SAADC.TASKS_SAMPLE: Take one ADC sample, if scan is enabled all channels are sampled
func (o *SAADC_Type) SetTASKS_SAMPLE(value uint32) {
	volatile.StoreUint32(&o.TASKS_SAMPLE.Reg, volatile.LoadUint32(&o.TASKS_SAMPLE.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetTASKS_SAMPLE() uint32 {
	return volatile.LoadUint32(&o.TASKS_SAMPLE.Reg) & 0x1
}

// SAADC.TASKS_STOP: Stop the ADC and terminate any on-going conversion
func (o *SAADC_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// SAADC.TASKS_CALIBRATEOFFSET: Starts offset auto-calibration
func (o *SAADC_Type) SetTASKS_CALIBRATEOFFSET(value uint32) {
	volatile.StoreUint32(&o.TASKS_CALIBRATEOFFSET.Reg, volatile.LoadUint32(&o.TASKS_CALIBRATEOFFSET.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetTASKS_CALIBRATEOFFSET() uint32 {
	return volatile.LoadUint32(&o.TASKS_CALIBRATEOFFSET.Reg) & 0x1
}

// SAADC.SUBSCRIBE_START: Subscribe configuration for task START
func (o *SAADC_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xff)|value)
}
func (o *SAADC_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xff
}
func (o *SAADC_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// SAADC.SUBSCRIBE_SAMPLE: Subscribe configuration for task SAMPLE
func (o *SAADC_Type) SetSUBSCRIBE_SAMPLE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SAMPLE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SAMPLE.Reg)&^(0xff)|value)
}
func (o *SAADC_Type) GetSUBSCRIBE_SAMPLE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SAMPLE.Reg) & 0xff
}
func (o *SAADC_Type) SetSUBSCRIBE_SAMPLE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SAMPLE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SAMPLE.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetSUBSCRIBE_SAMPLE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SAMPLE.Reg) & 0x80000000) >> 31
}

// SAADC.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *SAADC_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *SAADC_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *SAADC_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// SAADC.SUBSCRIBE_CALIBRATEOFFSET: Subscribe configuration for task CALIBRATEOFFSET
func (o *SAADC_Type) SetSUBSCRIBE_CALIBRATEOFFSET_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CALIBRATEOFFSET.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CALIBRATEOFFSET.Reg)&^(0xff)|value)
}
func (o *SAADC_Type) GetSUBSCRIBE_CALIBRATEOFFSET_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CALIBRATEOFFSET.Reg) & 0xff
}
func (o *SAADC_Type) SetSUBSCRIBE_CALIBRATEOFFSET_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CALIBRATEOFFSET.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CALIBRATEOFFSET.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetSUBSCRIBE_CALIBRATEOFFSET_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CALIBRATEOFFSET.Reg) & 0x80000000) >> 31
}

// SAADC.EVENTS_STARTED: The ADC has started
func (o *SAADC_Type) SetEVENTS_STARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STARTED.Reg, volatile.LoadUint32(&o.EVENTS_STARTED.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetEVENTS_STARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STARTED.Reg) & 0x1
}

// SAADC.EVENTS_END: The ADC has filled up the Result buffer
func (o *SAADC_Type) SetEVENTS_END(value uint32) {
	volatile.StoreUint32(&o.EVENTS_END.Reg, volatile.LoadUint32(&o.EVENTS_END.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetEVENTS_END() uint32 {
	return volatile.LoadUint32(&o.EVENTS_END.Reg) & 0x1
}

// SAADC.EVENTS_DONE: A conversion task has been completed. Depending on the mode, multiple conversions might be needed for a result to be transferred to RAM.
func (o *SAADC_Type) SetEVENTS_DONE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DONE.Reg, volatile.LoadUint32(&o.EVENTS_DONE.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetEVENTS_DONE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DONE.Reg) & 0x1
}

// SAADC.EVENTS_RESULTDONE: A result is ready to get transferred to RAM.
func (o *SAADC_Type) SetEVENTS_RESULTDONE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RESULTDONE.Reg, volatile.LoadUint32(&o.EVENTS_RESULTDONE.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetEVENTS_RESULTDONE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RESULTDONE.Reg) & 0x1
}

// SAADC.EVENTS_CALIBRATEDONE: Calibration is complete
func (o *SAADC_Type) SetEVENTS_CALIBRATEDONE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CALIBRATEDONE.Reg, volatile.LoadUint32(&o.EVENTS_CALIBRATEDONE.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetEVENTS_CALIBRATEDONE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CALIBRATEDONE.Reg) & 0x1
}

// SAADC.EVENTS_STOPPED: The ADC has stopped
func (o *SAADC_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// SAADC.PUBLISH_STARTED: Publish configuration for event STARTED
func (o *SAADC_Type) SetPUBLISH_STARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STARTED.Reg, volatile.LoadUint32(&o.PUBLISH_STARTED.Reg)&^(0xff)|value)
}
func (o *SAADC_Type) GetPUBLISH_STARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STARTED.Reg) & 0xff
}
func (o *SAADC_Type) SetPUBLISH_STARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STARTED.Reg, volatile.LoadUint32(&o.PUBLISH_STARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetPUBLISH_STARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STARTED.Reg) & 0x80000000) >> 31
}

// SAADC.PUBLISH_END: Publish configuration for event END
func (o *SAADC_Type) SetPUBLISH_END_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0xff)|value)
}
func (o *SAADC_Type) GetPUBLISH_END_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0xff
}
func (o *SAADC_Type) SetPUBLISH_END_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetPUBLISH_END_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0x80000000) >> 31
}

// SAADC.PUBLISH_DONE: Publish configuration for event DONE
func (o *SAADC_Type) SetPUBLISH_DONE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DONE.Reg, volatile.LoadUint32(&o.PUBLISH_DONE.Reg)&^(0xff)|value)
}
func (o *SAADC_Type) GetPUBLISH_DONE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_DONE.Reg) & 0xff
}
func (o *SAADC_Type) SetPUBLISH_DONE_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DONE.Reg, volatile.LoadUint32(&o.PUBLISH_DONE.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetPUBLISH_DONE_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_DONE.Reg) & 0x80000000) >> 31
}

// SAADC.PUBLISH_RESULTDONE: Publish configuration for event RESULTDONE
func (o *SAADC_Type) SetPUBLISH_RESULTDONE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RESULTDONE.Reg, volatile.LoadUint32(&o.PUBLISH_RESULTDONE.Reg)&^(0xff)|value)
}
func (o *SAADC_Type) GetPUBLISH_RESULTDONE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RESULTDONE.Reg) & 0xff
}
func (o *SAADC_Type) SetPUBLISH_RESULTDONE_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RESULTDONE.Reg, volatile.LoadUint32(&o.PUBLISH_RESULTDONE.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetPUBLISH_RESULTDONE_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RESULTDONE.Reg) & 0x80000000) >> 31
}

// SAADC.PUBLISH_CALIBRATEDONE: Publish configuration for event CALIBRATEDONE
func (o *SAADC_Type) SetPUBLISH_CALIBRATEDONE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CALIBRATEDONE.Reg, volatile.LoadUint32(&o.PUBLISH_CALIBRATEDONE.Reg)&^(0xff)|value)
}
func (o *SAADC_Type) GetPUBLISH_CALIBRATEDONE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_CALIBRATEDONE.Reg) & 0xff
}
func (o *SAADC_Type) SetPUBLISH_CALIBRATEDONE_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CALIBRATEDONE.Reg, volatile.LoadUint32(&o.PUBLISH_CALIBRATEDONE.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetPUBLISH_CALIBRATEDONE_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_CALIBRATEDONE.Reg) & 0x80000000) >> 31
}

// SAADC.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *SAADC_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xff)|value)
}
func (o *SAADC_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xff
}
func (o *SAADC_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// SAADC.INTEN: Enable or disable interrupt
func (o *SAADC_Type) SetINTEN_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetINTEN_STARTED() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *SAADC_Type) SetINTEN_END(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *SAADC_Type) GetINTEN_END() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *SAADC_Type) SetINTEN_DONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *SAADC_Type) GetINTEN_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *SAADC_Type) SetINTEN_RESULTDONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *SAADC_Type) GetINTEN_RESULTDONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *SAADC_Type) SetINTEN_CALIBRATEDONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *SAADC_Type) GetINTEN_CALIBRATEDONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *SAADC_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *SAADC_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *SAADC_Type) SetINTEN_CH0LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *SAADC_Type) GetINTEN_CH0LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *SAADC_Type) SetINTEN_CH0LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *SAADC_Type) GetINTEN_CH0LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *SAADC_Type) SetINTEN_CH1LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *SAADC_Type) GetINTEN_CH1LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *SAADC_Type) SetINTEN_CH1LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *SAADC_Type) GetINTEN_CH1LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *SAADC_Type) SetINTEN_CH2LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400)|value<<10)
}
func (o *SAADC_Type) GetINTEN_CH2LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400) >> 10
}
func (o *SAADC_Type) SetINTEN_CH2LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800)|value<<11)
}
func (o *SAADC_Type) GetINTEN_CH2LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800) >> 11
}
func (o *SAADC_Type) SetINTEN_CH3LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000)|value<<12)
}
func (o *SAADC_Type) GetINTEN_CH3LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000) >> 12
}
func (o *SAADC_Type) SetINTEN_CH3LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2000)|value<<13)
}
func (o *SAADC_Type) GetINTEN_CH3LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2000) >> 13
}
func (o *SAADC_Type) SetINTEN_CH4LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000)|value<<14)
}
func (o *SAADC_Type) GetINTEN_CH4LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000) >> 14
}
func (o *SAADC_Type) SetINTEN_CH4LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8000)|value<<15)
}
func (o *SAADC_Type) GetINTEN_CH4LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8000) >> 15
}
func (o *SAADC_Type) SetINTEN_CH5LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10000)|value<<16)
}
func (o *SAADC_Type) GetINTEN_CH5LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10000) >> 16
}
func (o *SAADC_Type) SetINTEN_CH5LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20000)|value<<17)
}
func (o *SAADC_Type) GetINTEN_CH5LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20000) >> 17
}
func (o *SAADC_Type) SetINTEN_CH6LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40000)|value<<18)
}
func (o *SAADC_Type) GetINTEN_CH6LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40000) >> 18
}
func (o *SAADC_Type) SetINTEN_CH6LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *SAADC_Type) GetINTEN_CH6LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *SAADC_Type) SetINTEN_CH7LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *SAADC_Type) GetINTEN_CH7LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *SAADC_Type) SetINTEN_CH7LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200000)|value<<21)
}
func (o *SAADC_Type) GetINTEN_CH7LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200000) >> 21
}

// SAADC.INTENSET: Enable interrupt
func (o *SAADC_Type) SetINTENSET_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetINTENSET_STARTED() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *SAADC_Type) SetINTENSET_END(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SAADC_Type) GetINTENSET_END() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SAADC_Type) SetINTENSET_DONE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SAADC_Type) GetINTENSET_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *SAADC_Type) SetINTENSET_RESULTDONE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *SAADC_Type) GetINTENSET_RESULTDONE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *SAADC_Type) SetINTENSET_CALIBRATEDONE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SAADC_Type) GetINTENSET_CALIBRATEDONE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SAADC_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *SAADC_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *SAADC_Type) SetINTENSET_CH0LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *SAADC_Type) GetINTENSET_CH0LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *SAADC_Type) SetINTENSET_CH0LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *SAADC_Type) GetINTENSET_CH0LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *SAADC_Type) SetINTENSET_CH1LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *SAADC_Type) GetINTENSET_CH1LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *SAADC_Type) SetINTENSET_CH1LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *SAADC_Type) GetINTENSET_CH1LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *SAADC_Type) SetINTENSET_CH2LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *SAADC_Type) GetINTENSET_CH2LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *SAADC_Type) SetINTENSET_CH2LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *SAADC_Type) GetINTENSET_CH2LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *SAADC_Type) SetINTENSET_CH3LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *SAADC_Type) GetINTENSET_CH3LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *SAADC_Type) SetINTENSET_CH3LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *SAADC_Type) GetINTENSET_CH3LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *SAADC_Type) SetINTENSET_CH4LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *SAADC_Type) GetINTENSET_CH4LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *SAADC_Type) SetINTENSET_CH4LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *SAADC_Type) GetINTENSET_CH4LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}
func (o *SAADC_Type) SetINTENSET_CH5LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *SAADC_Type) GetINTENSET_CH5LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *SAADC_Type) SetINTENSET_CH5LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *SAADC_Type) GetINTENSET_CH5LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *SAADC_Type) SetINTENSET_CH6LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *SAADC_Type) GetINTENSET_CH6LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *SAADC_Type) SetINTENSET_CH6LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *SAADC_Type) GetINTENSET_CH6LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *SAADC_Type) SetINTENSET_CH7LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *SAADC_Type) GetINTENSET_CH7LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *SAADC_Type) SetINTENSET_CH7LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200000)|value<<21)
}
func (o *SAADC_Type) GetINTENSET_CH7LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200000) >> 21
}

// SAADC.INTENCLR: Disable interrupt
func (o *SAADC_Type) SetINTENCLR_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetINTENCLR_STARTED() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *SAADC_Type) SetINTENCLR_END(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SAADC_Type) GetINTENCLR_END() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SAADC_Type) SetINTENCLR_DONE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SAADC_Type) GetINTENCLR_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *SAADC_Type) SetINTENCLR_RESULTDONE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *SAADC_Type) GetINTENCLR_RESULTDONE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *SAADC_Type) SetINTENCLR_CALIBRATEDONE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SAADC_Type) GetINTENCLR_CALIBRATEDONE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SAADC_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *SAADC_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *SAADC_Type) SetINTENCLR_CH0LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *SAADC_Type) GetINTENCLR_CH0LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *SAADC_Type) SetINTENCLR_CH0LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *SAADC_Type) GetINTENCLR_CH0LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *SAADC_Type) SetINTENCLR_CH1LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *SAADC_Type) GetINTENCLR_CH1LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *SAADC_Type) SetINTENCLR_CH1LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *SAADC_Type) GetINTENCLR_CH1LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *SAADC_Type) SetINTENCLR_CH2LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *SAADC_Type) GetINTENCLR_CH2LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *SAADC_Type) SetINTENCLR_CH2LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *SAADC_Type) GetINTENCLR_CH2LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *SAADC_Type) SetINTENCLR_CH3LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *SAADC_Type) GetINTENCLR_CH3LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *SAADC_Type) SetINTENCLR_CH3LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *SAADC_Type) GetINTENCLR_CH3LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *SAADC_Type) SetINTENCLR_CH4LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *SAADC_Type) GetINTENCLR_CH4LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *SAADC_Type) SetINTENCLR_CH4LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *SAADC_Type) GetINTENCLR_CH4LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}
func (o *SAADC_Type) SetINTENCLR_CH5LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *SAADC_Type) GetINTENCLR_CH5LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *SAADC_Type) SetINTENCLR_CH5LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *SAADC_Type) GetINTENCLR_CH5LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *SAADC_Type) SetINTENCLR_CH6LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *SAADC_Type) GetINTENCLR_CH6LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *SAADC_Type) SetINTENCLR_CH6LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *SAADC_Type) GetINTENCLR_CH6LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *SAADC_Type) SetINTENCLR_CH7LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *SAADC_Type) GetINTENCLR_CH7LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *SAADC_Type) SetINTENCLR_CH7LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200000)|value<<21)
}
func (o *SAADC_Type) GetINTENCLR_CH7LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200000) >> 21
}

// SAADC.STATUS: Status
func (o *SAADC_Type) SetSTATUS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetSTATUS() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}

// SAADC.ENABLE: Enable or disable ADC
func (o *SAADC_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// SAADC.RESOLUTION: Resolution configuration
func (o *SAADC_Type) SetRESOLUTION_VAL(value uint32) {
	volatile.StoreUint32(&o.RESOLUTION.Reg, volatile.LoadUint32(&o.RESOLUTION.Reg)&^(0x7)|value)
}
func (o *SAADC_Type) GetRESOLUTION_VAL() uint32 {
	return volatile.LoadUint32(&o.RESOLUTION.Reg) & 0x7
}

// SAADC.OVERSAMPLE: Oversampling configuration. OVERSAMPLE should not be combined with SCAN. The RESOLUTION is applied before averaging, thus for high OVERSAMPLE a higher RESOLUTION should be used.
func (o *SAADC_Type) SetOVERSAMPLE(value uint32) {
	volatile.StoreUint32(&o.OVERSAMPLE.Reg, volatile.LoadUint32(&o.OVERSAMPLE.Reg)&^(0xf)|value)
}
func (o *SAADC_Type) GetOVERSAMPLE() uint32 {
	return volatile.LoadUint32(&o.OVERSAMPLE.Reg) & 0xf
}

// SAADC.SAMPLERATE: Controls normal or continuous sample rate
func (o *SAADC_Type) SetSAMPLERATE_CC(value uint32) {
	volatile.StoreUint32(&o.SAMPLERATE.Reg, volatile.LoadUint32(&o.SAMPLERATE.Reg)&^(0x7ff)|value)
}
func (o *SAADC_Type) GetSAMPLERATE_CC() uint32 {
	return volatile.LoadUint32(&o.SAMPLERATE.Reg) & 0x7ff
}
func (o *SAADC_Type) SetSAMPLERATE_MODE(value uint32) {
	volatile.StoreUint32(&o.SAMPLERATE.Reg, volatile.LoadUint32(&o.SAMPLERATE.Reg)&^(0x1000)|value<<12)
}
func (o *SAADC_Type) GetSAMPLERATE_MODE() uint32 {
	return (volatile.LoadUint32(&o.SAMPLERATE.Reg) & 0x1000) >> 12
}

type SAADC_EVENTS_CH_Type struct {
	LIMITH volatile.Register32 // 0x118
	LIMITL volatile.Register32 // 0x11C
}

// SAADC_EVENTS_CH.LIMITH: Description cluster: Last results is equal or above CH[n].LIMIT.HIGH
func (o *SAADC_EVENTS_CH_Type) SetLIMITH(value uint32) {
	volatile.StoreUint32(&o.LIMITH.Reg, volatile.LoadUint32(&o.LIMITH.Reg)&^(0x1)|value)
}
func (o *SAADC_EVENTS_CH_Type) GetLIMITH() uint32 {
	return volatile.LoadUint32(&o.LIMITH.Reg) & 0x1
}

// SAADC_EVENTS_CH.LIMITL: Description cluster: Last results is equal or below CH[n].LIMIT.LOW
func (o *SAADC_EVENTS_CH_Type) SetLIMITL(value uint32) {
	volatile.StoreUint32(&o.LIMITL.Reg, volatile.LoadUint32(&o.LIMITL.Reg)&^(0x1)|value)
}
func (o *SAADC_EVENTS_CH_Type) GetLIMITL() uint32 {
	return volatile.LoadUint32(&o.LIMITL.Reg) & 0x1
}

type SAADC_PUBLISH_CH_Type struct {
	LIMITH volatile.Register32 // 0x198
	LIMITL volatile.Register32 // 0x19C
}

// SAADC_PUBLISH_CH.LIMITH: Description cluster: Publish configuration for event CH[n].LIMITH
func (o *SAADC_PUBLISH_CH_Type) SetLIMITH_CHIDX(value uint32) {
	volatile.StoreUint32(&o.LIMITH.Reg, volatile.LoadUint32(&o.LIMITH.Reg)&^(0xff)|value)
}
func (o *SAADC_PUBLISH_CH_Type) GetLIMITH_CHIDX() uint32 {
	return volatile.LoadUint32(&o.LIMITH.Reg) & 0xff
}
func (o *SAADC_PUBLISH_CH_Type) SetLIMITH_EN(value uint32) {
	volatile.StoreUint32(&o.LIMITH.Reg, volatile.LoadUint32(&o.LIMITH.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_PUBLISH_CH_Type) GetLIMITH_EN() uint32 {
	return (volatile.LoadUint32(&o.LIMITH.Reg) & 0x80000000) >> 31
}

// SAADC_PUBLISH_CH.LIMITL: Description cluster: Publish configuration for event CH[n].LIMITL
func (o *SAADC_PUBLISH_CH_Type) SetLIMITL_CHIDX(value uint32) {
	volatile.StoreUint32(&o.LIMITL.Reg, volatile.LoadUint32(&o.LIMITL.Reg)&^(0xff)|value)
}
func (o *SAADC_PUBLISH_CH_Type) GetLIMITL_CHIDX() uint32 {
	return volatile.LoadUint32(&o.LIMITL.Reg) & 0xff
}
func (o *SAADC_PUBLISH_CH_Type) SetLIMITL_EN(value uint32) {
	volatile.StoreUint32(&o.LIMITL.Reg, volatile.LoadUint32(&o.LIMITL.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_PUBLISH_CH_Type) GetLIMITL_EN() uint32 {
	return (volatile.LoadUint32(&o.LIMITL.Reg) & 0x80000000) >> 31
}

type SAADC_CH_Type struct {
	PSELP  volatile.Register32 // 0x510
	PSELN  volatile.Register32 // 0x514
	CONFIG volatile.Register32 // 0x518
	LIMIT  volatile.Register32 // 0x51C
}

// SAADC_CH.PSELP: Description cluster: Input positive pin selection for CH[n]
func (o *SAADC_CH_Type) SetPSELP(value uint32) {
	volatile.StoreUint32(&o.PSELP.Reg, volatile.LoadUint32(&o.PSELP.Reg)&^(0x1f)|value)
}
func (o *SAADC_CH_Type) GetPSELP() uint32 {
	return volatile.LoadUint32(&o.PSELP.Reg) & 0x1f
}

// SAADC_CH.PSELN: Description cluster: Input negative pin selection for CH[n]
func (o *SAADC_CH_Type) SetPSELN(value uint32) {
	volatile.StoreUint32(&o.PSELN.Reg, volatile.LoadUint32(&o.PSELN.Reg)&^(0x1f)|value)
}
func (o *SAADC_CH_Type) GetPSELN() uint32 {
	return volatile.LoadUint32(&o.PSELN.Reg) & 0x1f
}

// SAADC_CH.CONFIG: Description cluster: Input configuration for CH[n]
func (o *SAADC_CH_Type) SetCONFIG_RESP(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x3)|value)
}
func (o *SAADC_CH_Type) GetCONFIG_RESP() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x3
}
func (o *SAADC_CH_Type) SetCONFIG_RESN(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x30)|value<<4)
}
func (o *SAADC_CH_Type) GetCONFIG_RESN() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x30) >> 4
}
func (o *SAADC_CH_Type) SetCONFIG_GAIN(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x700)|value<<8)
}
func (o *SAADC_CH_Type) GetCONFIG_GAIN() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x700) >> 8
}
func (o *SAADC_CH_Type) SetCONFIG_REFSEL(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1000)|value<<12)
}
func (o *SAADC_CH_Type) GetCONFIG_REFSEL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x1000) >> 12
}
func (o *SAADC_CH_Type) SetCONFIG_TACQ(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x70000)|value<<16)
}
func (o *SAADC_CH_Type) GetCONFIG_TACQ() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x70000) >> 16
}
func (o *SAADC_CH_Type) SetCONFIG_MODE(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x100000)|value<<20)
}
func (o *SAADC_CH_Type) GetCONFIG_MODE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x100000) >> 20
}
func (o *SAADC_CH_Type) SetCONFIG_BURST(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1000000)|value<<24)
}
func (o *SAADC_CH_Type) GetCONFIG_BURST() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x1000000) >> 24
}

// SAADC_CH.LIMIT: Description cluster: High/low limits for event monitoring a channel
func (o *SAADC_CH_Type) SetLIMIT_LOW(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0xffff)|value)
}
func (o *SAADC_CH_Type) GetLIMIT_LOW() uint32 {
	return volatile.LoadUint32(&o.LIMIT.Reg) & 0xffff
}
func (o *SAADC_CH_Type) SetLIMIT_HIGH(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0xffff0000)|value<<16)
}
func (o *SAADC_CH_Type) GetLIMIT_HIGH() uint32 {
	return (volatile.LoadUint32(&o.LIMIT.Reg) & 0xffff0000) >> 16
}

type SAADC_RESULT_Type struct {
	PTR    volatile.Register32 // 0x62C
	MAXCNT volatile.Register32 // 0x630
	AMOUNT volatile.Register32 // 0x634
}

// SAADC_RESULT.PTR: Data pointer
func (o *SAADC_RESULT_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SAADC_RESULT_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SAADC_RESULT.MAXCNT: Maximum number of buffer words to transfer
func (o *SAADC_RESULT_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x7fff)|value)
}
func (o *SAADC_RESULT_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x7fff
}

// SAADC_RESULT.AMOUNT: Number of buffer words transferred since last START
func (o *SAADC_RESULT_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x7fff)|value)
}
func (o *SAADC_RESULT_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x7fff
}

// Timer/Counter 0
type TIMER_Type struct {
	TASKS_START        volatile.Register32 // 0x0
	TASKS_STOP         volatile.Register32 // 0x4
	TASKS_COUNT        volatile.Register32 // 0x8
	TASKS_CLEAR        volatile.Register32 // 0xC
	TASKS_SHUTDOWN     volatile.Register32 // 0x10
	_                  [44]byte
	TASKS_CAPTURE      [6]volatile.Register32 // 0x40
	_                  [40]byte
	SUBSCRIBE_START    volatile.Register32 // 0x80
	SUBSCRIBE_STOP     volatile.Register32 // 0x84
	SUBSCRIBE_COUNT    volatile.Register32 // 0x88
	SUBSCRIBE_CLEAR    volatile.Register32 // 0x8C
	SUBSCRIBE_SHUTDOWN volatile.Register32 // 0x90
	_                  [44]byte
	SUBSCRIBE_CAPTURE  [6]volatile.Register32 // 0xC0
	_                  [104]byte
	EVENTS_COMPARE     [6]volatile.Register32 // 0x140
	_                  [104]byte
	PUBLISH_COMPARE    [6]volatile.Register32 // 0x1C0
	_                  [40]byte
	SHORTS             volatile.Register32 // 0x200
	_                  [252]byte
	INTEN              volatile.Register32 // 0x300
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [504]byte
	MODE               volatile.Register32 // 0x504
	BITMODE            volatile.Register32 // 0x508
	_                  [4]byte
	PRESCALER          volatile.Register32 // 0x510
	_                  [44]byte
	CC                 [6]volatile.Register32 // 0x540
	_                  [40]byte
	ONESHOTEN          [6]volatile.Register32 // 0x580
}

// TIMER.TASKS_START: Start Timer
func (o *TIMER_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// TIMER.TASKS_STOP: Stop Timer
func (o *TIMER_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// TIMER.TASKS_COUNT: Increment Timer (Counter mode only)
func (o *TIMER_Type) SetTASKS_COUNT(value uint32) {
	volatile.StoreUint32(&o.TASKS_COUNT.Reg, volatile.LoadUint32(&o.TASKS_COUNT.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_COUNT() uint32 {
	return volatile.LoadUint32(&o.TASKS_COUNT.Reg) & 0x1
}

// TIMER.TASKS_CLEAR: Clear time
func (o *TIMER_Type) SetTASKS_CLEAR(value uint32) {
	volatile.StoreUint32(&o.TASKS_CLEAR.Reg, volatile.LoadUint32(&o.TASKS_CLEAR.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_CLEAR() uint32 {
	return volatile.LoadUint32(&o.TASKS_CLEAR.Reg) & 0x1
}

// TIMER.TASKS_SHUTDOWN: Deprecated register - Shut down timer
func (o *TIMER_Type) SetTASKS_SHUTDOWN(value uint32) {
	volatile.StoreUint32(&o.TASKS_SHUTDOWN.Reg, volatile.LoadUint32(&o.TASKS_SHUTDOWN.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_SHUTDOWN() uint32 {
	return volatile.LoadUint32(&o.TASKS_SHUTDOWN.Reg) & 0x1
}

// TIMER.TASKS_CAPTURE: Description collection: Capture Timer value to CC[n] register
func (o *TIMER_Type) SetTASKS_CAPTURE(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_CAPTURE[idx].Reg, volatile.LoadUint32(&o.TASKS_CAPTURE[idx].Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_CAPTURE(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_CAPTURE[idx].Reg) & 0x1
}

// TIMER.SUBSCRIBE_START: Subscribe configuration for task START
func (o *TIMER_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xff)|value)
}
func (o *TIMER_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xff
}
func (o *TIMER_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// TIMER.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *TIMER_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *TIMER_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *TIMER_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// TIMER.SUBSCRIBE_COUNT: Subscribe configuration for task COUNT
func (o *TIMER_Type) SetSUBSCRIBE_COUNT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_COUNT.Reg, volatile.LoadUint32(&o.SUBSCRIBE_COUNT.Reg)&^(0xff)|value)
}
func (o *TIMER_Type) GetSUBSCRIBE_COUNT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_COUNT.Reg) & 0xff
}
func (o *TIMER_Type) SetSUBSCRIBE_COUNT_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_COUNT.Reg, volatile.LoadUint32(&o.SUBSCRIBE_COUNT.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetSUBSCRIBE_COUNT_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_COUNT.Reg) & 0x80000000) >> 31
}

// TIMER.SUBSCRIBE_CLEAR: Subscribe configuration for task CLEAR
func (o *TIMER_Type) SetSUBSCRIBE_CLEAR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CLEAR.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg)&^(0xff)|value)
}
func (o *TIMER_Type) GetSUBSCRIBE_CLEAR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg) & 0xff
}
func (o *TIMER_Type) SetSUBSCRIBE_CLEAR_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CLEAR.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetSUBSCRIBE_CLEAR_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg) & 0x80000000) >> 31
}

// TIMER.SUBSCRIBE_SHUTDOWN: Deprecated register - Subscribe configuration for task SHUTDOWN
func (o *TIMER_Type) SetSUBSCRIBE_SHUTDOWN_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SHUTDOWN.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SHUTDOWN.Reg)&^(0xff)|value)
}
func (o *TIMER_Type) GetSUBSCRIBE_SHUTDOWN_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SHUTDOWN.Reg) & 0xff
}
func (o *TIMER_Type) SetSUBSCRIBE_SHUTDOWN_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SHUTDOWN.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SHUTDOWN.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetSUBSCRIBE_SHUTDOWN_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SHUTDOWN.Reg) & 0x80000000) >> 31
}

// TIMER.SUBSCRIBE_CAPTURE: Description collection: Subscribe configuration for task CAPTURE[n]
func (o *TIMER_Type) SetSUBSCRIBE_CAPTURE_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg)&^(0xff)|value)
}
func (o *TIMER_Type) GetSUBSCRIBE_CAPTURE_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg) & 0xff
}
func (o *TIMER_Type) SetSUBSCRIBE_CAPTURE_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetSUBSCRIBE_CAPTURE_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg) & 0x80000000) >> 31
}

// TIMER.EVENTS_COMPARE: Description collection: Compare event on CC[n] match
func (o *TIMER_Type) SetEVENTS_COMPARE(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_COMPARE[idx].Reg, volatile.LoadUint32(&o.EVENTS_COMPARE[idx].Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetEVENTS_COMPARE(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_COMPARE[idx].Reg) & 0x1
}

// TIMER.PUBLISH_COMPARE: Description collection: Publish configuration for event COMPARE[n]
func (o *TIMER_Type) SetPUBLISH_COMPARE_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_COMPARE[idx].Reg, volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg)&^(0xff)|value)
}
func (o *TIMER_Type) GetPUBLISH_COMPARE_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg) & 0xff
}
func (o *TIMER_Type) SetPUBLISH_COMPARE_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_COMPARE[idx].Reg, volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetPUBLISH_COMPARE_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg) & 0x80000000) >> 31
}

// TIMER.SHORTS: Shortcuts between local events and tasks
func (o *TIMER_Type) SetSHORTS_COMPARE0_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetSHORTS_COMPARE0_CLEAR() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *TIMER_Type) SetSHORTS_COMPARE1_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *TIMER_Type) GetSHORTS_COMPARE1_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *TIMER_Type) SetSHORTS_COMPARE2_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *TIMER_Type) GetSHORTS_COMPARE2_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *TIMER_Type) SetSHORTS_COMPARE3_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *TIMER_Type) GetSHORTS_COMPARE3_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}
func (o *TIMER_Type) SetSHORTS_COMPARE4_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10)|value<<4)
}
func (o *TIMER_Type) GetSHORTS_COMPARE4_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10) >> 4
}
func (o *TIMER_Type) SetSHORTS_COMPARE5_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20)|value<<5)
}
func (o *TIMER_Type) GetSHORTS_COMPARE5_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20) >> 5
}
func (o *TIMER_Type) SetSHORTS_COMPARE0_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10000)|value<<16)
}
func (o *TIMER_Type) GetSHORTS_COMPARE0_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10000) >> 16
}
func (o *TIMER_Type) SetSHORTS_COMPARE1_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20000)|value<<17)
}
func (o *TIMER_Type) GetSHORTS_COMPARE1_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20000) >> 17
}
func (o *TIMER_Type) SetSHORTS_COMPARE2_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x40000)|value<<18)
}
func (o *TIMER_Type) GetSHORTS_COMPARE2_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x40000) >> 18
}
func (o *TIMER_Type) SetSHORTS_COMPARE3_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x80000)|value<<19)
}
func (o *TIMER_Type) GetSHORTS_COMPARE3_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x80000) >> 19
}
func (o *TIMER_Type) SetSHORTS_COMPARE4_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x100000)|value<<20)
}
func (o *TIMER_Type) GetSHORTS_COMPARE4_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x100000) >> 20
}
func (o *TIMER_Type) SetSHORTS_COMPARE5_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x200000)|value<<21)
}
func (o *TIMER_Type) GetSHORTS_COMPARE5_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x200000) >> 21
}

// TIMER.INTEN: Enable or disable interrupt
func (o *TIMER_Type) SetINTEN_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10000)|value<<16)
}
func (o *TIMER_Type) GetINTEN_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10000) >> 16
}
func (o *TIMER_Type) SetINTEN_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20000)|value<<17)
}
func (o *TIMER_Type) GetINTEN_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20000) >> 17
}
func (o *TIMER_Type) SetINTEN_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40000)|value<<18)
}
func (o *TIMER_Type) GetINTEN_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40000) >> 18
}
func (o *TIMER_Type) SetINTEN_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *TIMER_Type) GetINTEN_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *TIMER_Type) SetINTEN_COMPARE4(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *TIMER_Type) GetINTEN_COMPARE4() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *TIMER_Type) SetINTEN_COMPARE5(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200000)|value<<21)
}
func (o *TIMER_Type) GetINTEN_COMPARE5() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200000) >> 21
}

// TIMER.INTENSET: Enable interrupt
func (o *TIMER_Type) SetINTENSET_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *TIMER_Type) GetINTENSET_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *TIMER_Type) SetINTENSET_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *TIMER_Type) GetINTENSET_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *TIMER_Type) SetINTENSET_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *TIMER_Type) GetINTENSET_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *TIMER_Type) SetINTENSET_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *TIMER_Type) GetINTENSET_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *TIMER_Type) SetINTENSET_COMPARE4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *TIMER_Type) GetINTENSET_COMPARE4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *TIMER_Type) SetINTENSET_COMPARE5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200000)|value<<21)
}
func (o *TIMER_Type) GetINTENSET_COMPARE5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200000) >> 21
}

// TIMER.INTENCLR: Disable interrupt
func (o *TIMER_Type) SetINTENCLR_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *TIMER_Type) SetINTENCLR_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *TIMER_Type) SetINTENCLR_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *TIMER_Type) SetINTENCLR_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *TIMER_Type) SetINTENCLR_COMPARE4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *TIMER_Type) SetINTENCLR_COMPARE5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200000)|value<<21)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200000) >> 21
}

// TIMER.MODE: Timer mode selection
func (o *TIMER_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x3)|value)
}
func (o *TIMER_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x3
}

// TIMER.BITMODE: Configure the number of bits used by the TIMER
func (o *TIMER_Type) SetBITMODE(value uint32) {
	volatile.StoreUint32(&o.BITMODE.Reg, volatile.LoadUint32(&o.BITMODE.Reg)&^(0x3)|value)
}
func (o *TIMER_Type) GetBITMODE() uint32 {
	return volatile.LoadUint32(&o.BITMODE.Reg) & 0x3
}

// TIMER.PRESCALER: Timer prescaler register
func (o *TIMER_Type) SetPRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESCALER.Reg, volatile.LoadUint32(&o.PRESCALER.Reg)&^(0xf)|value)
}
func (o *TIMER_Type) GetPRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESCALER.Reg) & 0xf
}

// TIMER.CC: Description collection: Capture/Compare register n
func (o *TIMER_Type) SetCC(idx int, value uint32) {
	volatile.StoreUint32(&o.CC[idx].Reg, value)
}
func (o *TIMER_Type) GetCC(idx int) uint32 {
	return volatile.LoadUint32(&o.CC[idx].Reg)
}

// TIMER.ONESHOTEN: Description collection: Enable one-shot operation for Capture/Compare channel n
func (o *TIMER_Type) SetONESHOTEN(idx int, value uint32) {
	volatile.StoreUint32(&o.ONESHOTEN[idx].Reg, volatile.LoadUint32(&o.ONESHOTEN[idx].Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetONESHOTEN(idx int) uint32 {
	return volatile.LoadUint32(&o.ONESHOTEN[idx].Reg) & 0x1
}

// Real-time counter 0
type RTC_Type struct {
	TASKS_START          volatile.Register32 // 0x0
	TASKS_STOP           volatile.Register32 // 0x4
	TASKS_CLEAR          volatile.Register32 // 0x8
	TASKS_TRIGOVRFLW     volatile.Register32 // 0xC
	_                    [48]byte
	TASKS_CAPTURE        [4]volatile.Register32 // 0x40
	_                    [48]byte
	SUBSCRIBE_START      volatile.Register32 // 0x80
	SUBSCRIBE_STOP       volatile.Register32 // 0x84
	SUBSCRIBE_CLEAR      volatile.Register32 // 0x88
	SUBSCRIBE_TRIGOVRFLW volatile.Register32 // 0x8C
	_                    [48]byte
	SUBSCRIBE_CAPTURE    [4]volatile.Register32 // 0xC0
	_                    [48]byte
	EVENTS_TICK          volatile.Register32 // 0x100
	EVENTS_OVRFLW        volatile.Register32 // 0x104
	_                    [56]byte
	EVENTS_COMPARE       [4]volatile.Register32 // 0x140
	_                    [48]byte
	PUBLISH_TICK         volatile.Register32 // 0x180
	PUBLISH_OVRFLW       volatile.Register32 // 0x184
	_                    [56]byte
	PUBLISH_COMPARE      [4]volatile.Register32 // 0x1C0
	_                    [48]byte
	SHORTS               volatile.Register32 // 0x200
	_                    [256]byte
	INTENSET             volatile.Register32 // 0x304
	INTENCLR             volatile.Register32 // 0x308
	_                    [52]byte
	EVTEN                volatile.Register32 // 0x340
	EVTENSET             volatile.Register32 // 0x344
	EVTENCLR             volatile.Register32 // 0x348
	_                    [440]byte
	COUNTER              volatile.Register32 // 0x504
	PRESCALER            volatile.Register32 // 0x508
	_                    [52]byte
	CC                   [4]volatile.Register32 // 0x540
}

// RTC.TASKS_START: Start RTC counter
func (o *RTC_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// RTC.TASKS_STOP: Stop RTC counter
func (o *RTC_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// RTC.TASKS_CLEAR: Clear RTC counter
func (o *RTC_Type) SetTASKS_CLEAR(value uint32) {
	volatile.StoreUint32(&o.TASKS_CLEAR.Reg, volatile.LoadUint32(&o.TASKS_CLEAR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTASKS_CLEAR() uint32 {
	return volatile.LoadUint32(&o.TASKS_CLEAR.Reg) & 0x1
}

// RTC.TASKS_TRIGOVRFLW: Set counter to 0xFFFFF0
func (o *RTC_Type) SetTASKS_TRIGOVRFLW(value uint32) {
	volatile.StoreUint32(&o.TASKS_TRIGOVRFLW.Reg, volatile.LoadUint32(&o.TASKS_TRIGOVRFLW.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTASKS_TRIGOVRFLW() uint32 {
	return volatile.LoadUint32(&o.TASKS_TRIGOVRFLW.Reg) & 0x1
}

// RTC.TASKS_CAPTURE: Description collection: Capture RTC counter to CC[n] register
func (o *RTC_Type) SetTASKS_CAPTURE(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_CAPTURE[idx].Reg, volatile.LoadUint32(&o.TASKS_CAPTURE[idx].Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTASKS_CAPTURE(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_CAPTURE[idx].Reg) & 0x1
}

// RTC.SUBSCRIBE_START: Subscribe configuration for task START
func (o *RTC_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xff
}
func (o *RTC_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// RTC.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *RTC_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *RTC_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// RTC.SUBSCRIBE_CLEAR: Subscribe configuration for task CLEAR
func (o *RTC_Type) SetSUBSCRIBE_CLEAR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CLEAR.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetSUBSCRIBE_CLEAR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg) & 0xff
}
func (o *RTC_Type) SetSUBSCRIBE_CLEAR_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CLEAR.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSUBSCRIBE_CLEAR_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg) & 0x80000000) >> 31
}

// RTC.SUBSCRIBE_TRIGOVRFLW: Subscribe configuration for task TRIGOVRFLW
func (o *RTC_Type) SetSUBSCRIBE_TRIGOVRFLW_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_TRIGOVRFLW.Reg, volatile.LoadUint32(&o.SUBSCRIBE_TRIGOVRFLW.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetSUBSCRIBE_TRIGOVRFLW_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_TRIGOVRFLW.Reg) & 0xff
}
func (o *RTC_Type) SetSUBSCRIBE_TRIGOVRFLW_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_TRIGOVRFLW.Reg, volatile.LoadUint32(&o.SUBSCRIBE_TRIGOVRFLW.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSUBSCRIBE_TRIGOVRFLW_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_TRIGOVRFLW.Reg) & 0x80000000) >> 31
}

// RTC.SUBSCRIBE_CAPTURE: Description collection: Subscribe configuration for task CAPTURE[n]
func (o *RTC_Type) SetSUBSCRIBE_CAPTURE_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetSUBSCRIBE_CAPTURE_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg) & 0xff
}
func (o *RTC_Type) SetSUBSCRIBE_CAPTURE_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSUBSCRIBE_CAPTURE_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg) & 0x80000000) >> 31
}

// RTC.EVENTS_TICK: Event on counter increment
func (o *RTC_Type) SetEVENTS_TICK(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TICK.Reg, volatile.LoadUint32(&o.EVENTS_TICK.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVENTS_TICK() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TICK.Reg) & 0x1
}

// RTC.EVENTS_OVRFLW: Event on counter overflow
func (o *RTC_Type) SetEVENTS_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.EVENTS_OVRFLW.Reg, volatile.LoadUint32(&o.EVENTS_OVRFLW.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVENTS_OVRFLW() uint32 {
	return volatile.LoadUint32(&o.EVENTS_OVRFLW.Reg) & 0x1
}

// RTC.EVENTS_COMPARE: Description collection: Compare event on CC[n] match
func (o *RTC_Type) SetEVENTS_COMPARE(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_COMPARE[idx].Reg, volatile.LoadUint32(&o.EVENTS_COMPARE[idx].Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVENTS_COMPARE(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_COMPARE[idx].Reg) & 0x1
}

// RTC.PUBLISH_TICK: Publish configuration for event TICK
func (o *RTC_Type) SetPUBLISH_TICK_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TICK.Reg, volatile.LoadUint32(&o.PUBLISH_TICK.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetPUBLISH_TICK_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TICK.Reg) & 0xff
}
func (o *RTC_Type) SetPUBLISH_TICK_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TICK.Reg, volatile.LoadUint32(&o.PUBLISH_TICK.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetPUBLISH_TICK_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TICK.Reg) & 0x80000000) >> 31
}

// RTC.PUBLISH_OVRFLW: Publish configuration for event OVRFLW
func (o *RTC_Type) SetPUBLISH_OVRFLW_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_OVRFLW.Reg, volatile.LoadUint32(&o.PUBLISH_OVRFLW.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetPUBLISH_OVRFLW_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_OVRFLW.Reg) & 0xff
}
func (o *RTC_Type) SetPUBLISH_OVRFLW_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_OVRFLW.Reg, volatile.LoadUint32(&o.PUBLISH_OVRFLW.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetPUBLISH_OVRFLW_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_OVRFLW.Reg) & 0x80000000) >> 31
}

// RTC.PUBLISH_COMPARE: Description collection: Publish configuration for event COMPARE[n]
func (o *RTC_Type) SetPUBLISH_COMPARE_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_COMPARE[idx].Reg, volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetPUBLISH_COMPARE_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg) & 0xff
}
func (o *RTC_Type) SetPUBLISH_COMPARE_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_COMPARE[idx].Reg, volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetPUBLISH_COMPARE_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg) & 0x80000000) >> 31
}

// RTC.SHORTS: Shortcuts between local events and tasks
func (o *RTC_Type) SetSHORTS_COMPARE0_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetSHORTS_COMPARE0_CLEAR() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *RTC_Type) SetSHORTS_COMPARE1_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetSHORTS_COMPARE1_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetSHORTS_COMPARE2_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetSHORTS_COMPARE2_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetSHORTS_COMPARE3_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetSHORTS_COMPARE3_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}

// RTC.INTENSET: Enable interrupt
func (o *RTC_Type) SetINTENSET_TICK(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetINTENSET_TICK() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *RTC_Type) SetINTENSET_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetINTENSET_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetINTENSET_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetINTENSET_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetINTENSET_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetINTENSET_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetINTENSET_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetINTENSET_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetINTENSET_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetINTENSET_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}

// RTC.INTENCLR: Disable interrupt
func (o *RTC_Type) SetINTENCLR_TICK(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetINTENCLR_TICK() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *RTC_Type) SetINTENCLR_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetINTENCLR_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetINTENCLR_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetINTENCLR_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetINTENCLR_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetINTENCLR_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetINTENCLR_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetINTENCLR_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetINTENCLR_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetINTENCLR_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}

// RTC.EVTEN: Enable or disable event routing
func (o *RTC_Type) SetEVTEN_TICK(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVTEN_TICK() uint32 {
	return volatile.LoadUint32(&o.EVTEN.Reg) & 0x1
}
func (o *RTC_Type) SetEVTEN_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetEVTEN_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetEVTEN_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetEVTEN_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetEVTEN_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetEVTEN_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetEVTEN_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetEVTEN_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetEVTEN_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetEVTEN_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x80000) >> 19
}

// RTC.EVTENSET: Enable event routing
func (o *RTC_Type) SetEVTENSET_TICK(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVTENSET_TICK() uint32 {
	return volatile.LoadUint32(&o.EVTENSET.Reg) & 0x1
}
func (o *RTC_Type) SetEVTENSET_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetEVTENSET_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetEVTENSET_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetEVTENSET_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetEVTENSET_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetEVTENSET_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetEVTENSET_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetEVTENSET_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetEVTENSET_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetEVTENSET_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x80000) >> 19
}

// RTC.EVTENCLR: Disable event routing
func (o *RTC_Type) SetEVTENCLR_TICK(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVTENCLR_TICK() uint32 {
	return volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x1
}
func (o *RTC_Type) SetEVTENCLR_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetEVTENCLR_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetEVTENCLR_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetEVTENCLR_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetEVTENCLR_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetEVTENCLR_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetEVTENCLR_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetEVTENCLR_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetEVTENCLR_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetEVTENCLR_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x80000) >> 19
}

// RTC.COUNTER: Current counter value
func (o *RTC_Type) SetCOUNTER(value uint32) {
	volatile.StoreUint32(&o.COUNTER.Reg, volatile.LoadUint32(&o.COUNTER.Reg)&^(0xffffff)|value)
}
func (o *RTC_Type) GetCOUNTER() uint32 {
	return volatile.LoadUint32(&o.COUNTER.Reg) & 0xffffff
}

// RTC.PRESCALER: 12-bit prescaler for counter frequency (32768/(PRESCALER+1)). Must be written when RTC is stopped.
func (o *RTC_Type) SetPRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESCALER.Reg, volatile.LoadUint32(&o.PRESCALER.Reg)&^(0xfff)|value)
}
func (o *RTC_Type) GetPRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESCALER.Reg) & 0xfff
}

// RTC.CC: Description collection: Compare register n
func (o *RTC_Type) SetCC_COMPARE(idx int, value uint32) {
	volatile.StoreUint32(&o.CC[idx].Reg, volatile.LoadUint32(&o.CC[idx].Reg)&^(0xffffff)|value)
}
func (o *RTC_Type) GetCC_COMPARE(idx int) uint32 {
	return volatile.LoadUint32(&o.CC[idx].Reg) & 0xffffff
}

// Distributed programmable peripheral interconnect controller 0
type DPPIC_Type struct {
	TASKS_CHG     [6]DPPIC_TASKS_CHG_Type // 0x0
	_             [80]byte
	SUBSCRIBE_CHG [6]DPPIC_SUBSCRIBE_CHG_Type // 0x80
	_             [1104]byte
	CHEN          volatile.Register32 // 0x500
	CHENSET       volatile.Register32 // 0x504
	CHENCLR       volatile.Register32 // 0x508
	_             [756]byte
	CHG           [6]volatile.Register32 // 0x800
}

// DPPIC.CHEN: Channel enable register
func (o *DPPIC_Type) SetCHEN_CH0(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x1)|value)
}
func (o *DPPIC_Type) GetCHEN_CH0() uint32 {
	return volatile.LoadUint32(&o.CHEN.Reg) & 0x1
}
func (o *DPPIC_Type) SetCHEN_CH1(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x2)|value<<1)
}
func (o *DPPIC_Type) GetCHEN_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x2) >> 1
}
func (o *DPPIC_Type) SetCHEN_CH2(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x4)|value<<2)
}
func (o *DPPIC_Type) GetCHEN_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x4) >> 2
}
func (o *DPPIC_Type) SetCHEN_CH3(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x8)|value<<3)
}
func (o *DPPIC_Type) GetCHEN_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x8) >> 3
}
func (o *DPPIC_Type) SetCHEN_CH4(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x10)|value<<4)
}
func (o *DPPIC_Type) GetCHEN_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x10) >> 4
}
func (o *DPPIC_Type) SetCHEN_CH5(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x20)|value<<5)
}
func (o *DPPIC_Type) GetCHEN_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x20) >> 5
}
func (o *DPPIC_Type) SetCHEN_CH6(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x40)|value<<6)
}
func (o *DPPIC_Type) GetCHEN_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x40) >> 6
}
func (o *DPPIC_Type) SetCHEN_CH7(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x80)|value<<7)
}
func (o *DPPIC_Type) GetCHEN_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x80) >> 7
}
func (o *DPPIC_Type) SetCHEN_CH8(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x100)|value<<8)
}
func (o *DPPIC_Type) GetCHEN_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x100) >> 8
}
func (o *DPPIC_Type) SetCHEN_CH9(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x200)|value<<9)
}
func (o *DPPIC_Type) GetCHEN_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x200) >> 9
}
func (o *DPPIC_Type) SetCHEN_CH10(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x400)|value<<10)
}
func (o *DPPIC_Type) GetCHEN_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x400) >> 10
}
func (o *DPPIC_Type) SetCHEN_CH11(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x800)|value<<11)
}
func (o *DPPIC_Type) GetCHEN_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x800) >> 11
}
func (o *DPPIC_Type) SetCHEN_CH12(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x1000)|value<<12)
}
func (o *DPPIC_Type) GetCHEN_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x1000) >> 12
}
func (o *DPPIC_Type) SetCHEN_CH13(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x2000)|value<<13)
}
func (o *DPPIC_Type) GetCHEN_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x2000) >> 13
}
func (o *DPPIC_Type) SetCHEN_CH14(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x4000)|value<<14)
}
func (o *DPPIC_Type) GetCHEN_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x4000) >> 14
}
func (o *DPPIC_Type) SetCHEN_CH15(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x8000)|value<<15)
}
func (o *DPPIC_Type) GetCHEN_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x8000) >> 15
}
func (o *DPPIC_Type) SetCHEN_CH16(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x10000)|value<<16)
}
func (o *DPPIC_Type) GetCHEN_CH16() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x10000) >> 16
}
func (o *DPPIC_Type) SetCHEN_CH17(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x20000)|value<<17)
}
func (o *DPPIC_Type) GetCHEN_CH17() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x20000) >> 17
}
func (o *DPPIC_Type) SetCHEN_CH18(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x40000)|value<<18)
}
func (o *DPPIC_Type) GetCHEN_CH18() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x40000) >> 18
}
func (o *DPPIC_Type) SetCHEN_CH19(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x80000)|value<<19)
}
func (o *DPPIC_Type) GetCHEN_CH19() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x80000) >> 19
}
func (o *DPPIC_Type) SetCHEN_CH20(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x100000)|value<<20)
}
func (o *DPPIC_Type) GetCHEN_CH20() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x100000) >> 20
}
func (o *DPPIC_Type) SetCHEN_CH21(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x200000)|value<<21)
}
func (o *DPPIC_Type) GetCHEN_CH21() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x200000) >> 21
}
func (o *DPPIC_Type) SetCHEN_CH22(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x400000)|value<<22)
}
func (o *DPPIC_Type) GetCHEN_CH22() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x400000) >> 22
}
func (o *DPPIC_Type) SetCHEN_CH23(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x800000)|value<<23)
}
func (o *DPPIC_Type) GetCHEN_CH23() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x800000) >> 23
}
func (o *DPPIC_Type) SetCHEN_CH24(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x1000000)|value<<24)
}
func (o *DPPIC_Type) GetCHEN_CH24() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x1000000) >> 24
}
func (o *DPPIC_Type) SetCHEN_CH25(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x2000000)|value<<25)
}
func (o *DPPIC_Type) GetCHEN_CH25() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x2000000) >> 25
}
func (o *DPPIC_Type) SetCHEN_CH26(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x4000000)|value<<26)
}
func (o *DPPIC_Type) GetCHEN_CH26() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x4000000) >> 26
}
func (o *DPPIC_Type) SetCHEN_CH27(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x8000000)|value<<27)
}
func (o *DPPIC_Type) GetCHEN_CH27() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x8000000) >> 27
}
func (o *DPPIC_Type) SetCHEN_CH28(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x10000000)|value<<28)
}
func (o *DPPIC_Type) GetCHEN_CH28() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x10000000) >> 28
}
func (o *DPPIC_Type) SetCHEN_CH29(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x20000000)|value<<29)
}
func (o *DPPIC_Type) GetCHEN_CH29() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x20000000) >> 29
}
func (o *DPPIC_Type) SetCHEN_CH30(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x40000000)|value<<30)
}
func (o *DPPIC_Type) GetCHEN_CH30() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x40000000) >> 30
}
func (o *DPPIC_Type) SetCHEN_CH31(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x80000000)|value<<31)
}
func (o *DPPIC_Type) GetCHEN_CH31() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x80000000) >> 31
}

// DPPIC.CHENSET: Channel enable set register
func (o *DPPIC_Type) SetCHENSET_CH0(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x1)|value)
}
func (o *DPPIC_Type) GetCHENSET_CH0() uint32 {
	return volatile.LoadUint32(&o.CHENSET.Reg) & 0x1
}
func (o *DPPIC_Type) SetCHENSET_CH1(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x2)|value<<1)
}
func (o *DPPIC_Type) GetCHENSET_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x2) >> 1
}
func (o *DPPIC_Type) SetCHENSET_CH2(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x4)|value<<2)
}
func (o *DPPIC_Type) GetCHENSET_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x4) >> 2
}
func (o *DPPIC_Type) SetCHENSET_CH3(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x8)|value<<3)
}
func (o *DPPIC_Type) GetCHENSET_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x8) >> 3
}
func (o *DPPIC_Type) SetCHENSET_CH4(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x10)|value<<4)
}
func (o *DPPIC_Type) GetCHENSET_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x10) >> 4
}
func (o *DPPIC_Type) SetCHENSET_CH5(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x20)|value<<5)
}
func (o *DPPIC_Type) GetCHENSET_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x20) >> 5
}
func (o *DPPIC_Type) SetCHENSET_CH6(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x40)|value<<6)
}
func (o *DPPIC_Type) GetCHENSET_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x40) >> 6
}
func (o *DPPIC_Type) SetCHENSET_CH7(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x80)|value<<7)
}
func (o *DPPIC_Type) GetCHENSET_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x80) >> 7
}
func (o *DPPIC_Type) SetCHENSET_CH8(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x100)|value<<8)
}
func (o *DPPIC_Type) GetCHENSET_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x100) >> 8
}
func (o *DPPIC_Type) SetCHENSET_CH9(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x200)|value<<9)
}
func (o *DPPIC_Type) GetCHENSET_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x200) >> 9
}
func (o *DPPIC_Type) SetCHENSET_CH10(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x400)|value<<10)
}
func (o *DPPIC_Type) GetCHENSET_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x400) >> 10
}
func (o *DPPIC_Type) SetCHENSET_CH11(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x800)|value<<11)
}
func (o *DPPIC_Type) GetCHENSET_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x800) >> 11
}
func (o *DPPIC_Type) SetCHENSET_CH12(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x1000)|value<<12)
}
func (o *DPPIC_Type) GetCHENSET_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x1000) >> 12
}
func (o *DPPIC_Type) SetCHENSET_CH13(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x2000)|value<<13)
}
func (o *DPPIC_Type) GetCHENSET_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x2000) >> 13
}
func (o *DPPIC_Type) SetCHENSET_CH14(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x4000)|value<<14)
}
func (o *DPPIC_Type) GetCHENSET_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x4000) >> 14
}
func (o *DPPIC_Type) SetCHENSET_CH15(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x8000)|value<<15)
}
func (o *DPPIC_Type) GetCHENSET_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x8000) >> 15
}
func (o *DPPIC_Type) SetCHENSET_CH16(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x10000)|value<<16)
}
func (o *DPPIC_Type) GetCHENSET_CH16() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x10000) >> 16
}
func (o *DPPIC_Type) SetCHENSET_CH17(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x20000)|value<<17)
}
func (o *DPPIC_Type) GetCHENSET_CH17() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x20000) >> 17
}
func (o *DPPIC_Type) SetCHENSET_CH18(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x40000)|value<<18)
}
func (o *DPPIC_Type) GetCHENSET_CH18() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x40000) >> 18
}
func (o *DPPIC_Type) SetCHENSET_CH19(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x80000)|value<<19)
}
func (o *DPPIC_Type) GetCHENSET_CH19() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x80000) >> 19
}
func (o *DPPIC_Type) SetCHENSET_CH20(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x100000)|value<<20)
}
func (o *DPPIC_Type) GetCHENSET_CH20() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x100000) >> 20
}
func (o *DPPIC_Type) SetCHENSET_CH21(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x200000)|value<<21)
}
func (o *DPPIC_Type) GetCHENSET_CH21() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x200000) >> 21
}
func (o *DPPIC_Type) SetCHENSET_CH22(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x400000)|value<<22)
}
func (o *DPPIC_Type) GetCHENSET_CH22() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x400000) >> 22
}
func (o *DPPIC_Type) SetCHENSET_CH23(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x800000)|value<<23)
}
func (o *DPPIC_Type) GetCHENSET_CH23() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x800000) >> 23
}
func (o *DPPIC_Type) SetCHENSET_CH24(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x1000000)|value<<24)
}
func (o *DPPIC_Type) GetCHENSET_CH24() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x1000000) >> 24
}
func (o *DPPIC_Type) SetCHENSET_CH25(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x2000000)|value<<25)
}
func (o *DPPIC_Type) GetCHENSET_CH25() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x2000000) >> 25
}
func (o *DPPIC_Type) SetCHENSET_CH26(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x4000000)|value<<26)
}
func (o *DPPIC_Type) GetCHENSET_CH26() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x4000000) >> 26
}
func (o *DPPIC_Type) SetCHENSET_CH27(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x8000000)|value<<27)
}
func (o *DPPIC_Type) GetCHENSET_CH27() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x8000000) >> 27
}
func (o *DPPIC_Type) SetCHENSET_CH28(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x10000000)|value<<28)
}
func (o *DPPIC_Type) GetCHENSET_CH28() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x10000000) >> 28
}
func (o *DPPIC_Type) SetCHENSET_CH29(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x20000000)|value<<29)
}
func (o *DPPIC_Type) GetCHENSET_CH29() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x20000000) >> 29
}
func (o *DPPIC_Type) SetCHENSET_CH30(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x40000000)|value<<30)
}
func (o *DPPIC_Type) GetCHENSET_CH30() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x40000000) >> 30
}
func (o *DPPIC_Type) SetCHENSET_CH31(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x80000000)|value<<31)
}
func (o *DPPIC_Type) GetCHENSET_CH31() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x80000000) >> 31
}

// DPPIC.CHENCLR: Channel enable clear register
func (o *DPPIC_Type) SetCHENCLR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x1)|value)
}
func (o *DPPIC_Type) GetCHENCLR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHENCLR.Reg) & 0x1
}
func (o *DPPIC_Type) SetCHENCLR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x2)|value<<1)
}
func (o *DPPIC_Type) GetCHENCLR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x2) >> 1
}
func (o *DPPIC_Type) SetCHENCLR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x4)|value<<2)
}
func (o *DPPIC_Type) GetCHENCLR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x4) >> 2
}
func (o *DPPIC_Type) SetCHENCLR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x8)|value<<3)
}
func (o *DPPIC_Type) GetCHENCLR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x8) >> 3
}
func (o *DPPIC_Type) SetCHENCLR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x10)|value<<4)
}
func (o *DPPIC_Type) GetCHENCLR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x10) >> 4
}
func (o *DPPIC_Type) SetCHENCLR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x20)|value<<5)
}
func (o *DPPIC_Type) GetCHENCLR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x20) >> 5
}
func (o *DPPIC_Type) SetCHENCLR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x40)|value<<6)
}
func (o *DPPIC_Type) GetCHENCLR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x40) >> 6
}
func (o *DPPIC_Type) SetCHENCLR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x80)|value<<7)
}
func (o *DPPIC_Type) GetCHENCLR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x80) >> 7
}
func (o *DPPIC_Type) SetCHENCLR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x100)|value<<8)
}
func (o *DPPIC_Type) GetCHENCLR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x100) >> 8
}
func (o *DPPIC_Type) SetCHENCLR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x200)|value<<9)
}
func (o *DPPIC_Type) GetCHENCLR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x200) >> 9
}
func (o *DPPIC_Type) SetCHENCLR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x400)|value<<10)
}
func (o *DPPIC_Type) GetCHENCLR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x400) >> 10
}
func (o *DPPIC_Type) SetCHENCLR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x800)|value<<11)
}
func (o *DPPIC_Type) GetCHENCLR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x800) >> 11
}
func (o *DPPIC_Type) SetCHENCLR_CH12(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *DPPIC_Type) GetCHENCLR_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x1000) >> 12
}
func (o *DPPIC_Type) SetCHENCLR_CH13(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *DPPIC_Type) GetCHENCLR_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x2000) >> 13
}
func (o *DPPIC_Type) SetCHENCLR_CH14(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *DPPIC_Type) GetCHENCLR_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x4000) >> 14
}
func (o *DPPIC_Type) SetCHENCLR_CH15(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *DPPIC_Type) GetCHENCLR_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x8000) >> 15
}
func (o *DPPIC_Type) SetCHENCLR_CH16(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *DPPIC_Type) GetCHENCLR_CH16() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x10000) >> 16
}
func (o *DPPIC_Type) SetCHENCLR_CH17(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *DPPIC_Type) GetCHENCLR_CH17() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x20000) >> 17
}
func (o *DPPIC_Type) SetCHENCLR_CH18(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *DPPIC_Type) GetCHENCLR_CH18() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x40000) >> 18
}
func (o *DPPIC_Type) SetCHENCLR_CH19(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *DPPIC_Type) GetCHENCLR_CH19() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x80000) >> 19
}
func (o *DPPIC_Type) SetCHENCLR_CH20(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *DPPIC_Type) GetCHENCLR_CH20() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x100000) >> 20
}
func (o *DPPIC_Type) SetCHENCLR_CH21(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x200000)|value<<21)
}
func (o *DPPIC_Type) GetCHENCLR_CH21() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x200000) >> 21
}
func (o *DPPIC_Type) SetCHENCLR_CH22(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x400000)|value<<22)
}
func (o *DPPIC_Type) GetCHENCLR_CH22() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x400000) >> 22
}
func (o *DPPIC_Type) SetCHENCLR_CH23(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x800000)|value<<23)
}
func (o *DPPIC_Type) GetCHENCLR_CH23() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x800000) >> 23
}
func (o *DPPIC_Type) SetCHENCLR_CH24(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *DPPIC_Type) GetCHENCLR_CH24() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x1000000) >> 24
}
func (o *DPPIC_Type) SetCHENCLR_CH25(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *DPPIC_Type) GetCHENCLR_CH25() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x2000000) >> 25
}
func (o *DPPIC_Type) SetCHENCLR_CH26(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *DPPIC_Type) GetCHENCLR_CH26() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x4000000) >> 26
}
func (o *DPPIC_Type) SetCHENCLR_CH27(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *DPPIC_Type) GetCHENCLR_CH27() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x8000000) >> 27
}
func (o *DPPIC_Type) SetCHENCLR_CH28(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *DPPIC_Type) GetCHENCLR_CH28() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x10000000) >> 28
}
func (o *DPPIC_Type) SetCHENCLR_CH29(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *DPPIC_Type) GetCHENCLR_CH29() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x20000000) >> 29
}
func (o *DPPIC_Type) SetCHENCLR_CH30(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *DPPIC_Type) GetCHENCLR_CH30() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x40000000) >> 30
}
func (o *DPPIC_Type) SetCHENCLR_CH31(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *DPPIC_Type) GetCHENCLR_CH31() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x80000000) >> 31
}

// DPPIC.CHG: Description collection: Channel group n Note: Writes to this register are ignored if either SUBSCRIBE_CHG[n].EN or SUBSCRIBE_CHG[n].DIS is enabled
func (o *DPPIC_Type) SetCHG_CH0(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x1)|value)
}
func (o *DPPIC_Type) GetCHG_CH0(idx int) uint32 {
	return volatile.LoadUint32(&o.CHG[idx].Reg) & 0x1
}
func (o *DPPIC_Type) SetCHG_CH1(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x2)|value<<1)
}
func (o *DPPIC_Type) GetCHG_CH1(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x2) >> 1
}
func (o *DPPIC_Type) SetCHG_CH2(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x4)|value<<2)
}
func (o *DPPIC_Type) GetCHG_CH2(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x4) >> 2
}
func (o *DPPIC_Type) SetCHG_CH3(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x8)|value<<3)
}
func (o *DPPIC_Type) GetCHG_CH3(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x8) >> 3
}
func (o *DPPIC_Type) SetCHG_CH4(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x10)|value<<4)
}
func (o *DPPIC_Type) GetCHG_CH4(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x10) >> 4
}
func (o *DPPIC_Type) SetCHG_CH5(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x20)|value<<5)
}
func (o *DPPIC_Type) GetCHG_CH5(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x20) >> 5
}
func (o *DPPIC_Type) SetCHG_CH6(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x40)|value<<6)
}
func (o *DPPIC_Type) GetCHG_CH6(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x40) >> 6
}
func (o *DPPIC_Type) SetCHG_CH7(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x80)|value<<7)
}
func (o *DPPIC_Type) GetCHG_CH7(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x80) >> 7
}
func (o *DPPIC_Type) SetCHG_CH8(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x100)|value<<8)
}
func (o *DPPIC_Type) GetCHG_CH8(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x100) >> 8
}
func (o *DPPIC_Type) SetCHG_CH9(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x200)|value<<9)
}
func (o *DPPIC_Type) GetCHG_CH9(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x200) >> 9
}
func (o *DPPIC_Type) SetCHG_CH10(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x400)|value<<10)
}
func (o *DPPIC_Type) GetCHG_CH10(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x400) >> 10
}
func (o *DPPIC_Type) SetCHG_CH11(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x800)|value<<11)
}
func (o *DPPIC_Type) GetCHG_CH11(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x800) >> 11
}
func (o *DPPIC_Type) SetCHG_CH12(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x1000)|value<<12)
}
func (o *DPPIC_Type) GetCHG_CH12(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x1000) >> 12
}
func (o *DPPIC_Type) SetCHG_CH13(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x2000)|value<<13)
}
func (o *DPPIC_Type) GetCHG_CH13(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x2000) >> 13
}
func (o *DPPIC_Type) SetCHG_CH14(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x4000)|value<<14)
}
func (o *DPPIC_Type) GetCHG_CH14(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x4000) >> 14
}
func (o *DPPIC_Type) SetCHG_CH15(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x8000)|value<<15)
}
func (o *DPPIC_Type) GetCHG_CH15(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x8000) >> 15
}
func (o *DPPIC_Type) SetCHG_CH16(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x10000)|value<<16)
}
func (o *DPPIC_Type) GetCHG_CH16(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x10000) >> 16
}
func (o *DPPIC_Type) SetCHG_CH17(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x20000)|value<<17)
}
func (o *DPPIC_Type) GetCHG_CH17(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x20000) >> 17
}
func (o *DPPIC_Type) SetCHG_CH18(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x40000)|value<<18)
}
func (o *DPPIC_Type) GetCHG_CH18(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x40000) >> 18
}
func (o *DPPIC_Type) SetCHG_CH19(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x80000)|value<<19)
}
func (o *DPPIC_Type) GetCHG_CH19(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x80000) >> 19
}
func (o *DPPIC_Type) SetCHG_CH20(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x100000)|value<<20)
}
func (o *DPPIC_Type) GetCHG_CH20(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x100000) >> 20
}
func (o *DPPIC_Type) SetCHG_CH21(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x200000)|value<<21)
}
func (o *DPPIC_Type) GetCHG_CH21(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x200000) >> 21
}
func (o *DPPIC_Type) SetCHG_CH22(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x400000)|value<<22)
}
func (o *DPPIC_Type) GetCHG_CH22(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x400000) >> 22
}
func (o *DPPIC_Type) SetCHG_CH23(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x800000)|value<<23)
}
func (o *DPPIC_Type) GetCHG_CH23(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x800000) >> 23
}
func (o *DPPIC_Type) SetCHG_CH24(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *DPPIC_Type) GetCHG_CH24(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x1000000) >> 24
}
func (o *DPPIC_Type) SetCHG_CH25(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *DPPIC_Type) GetCHG_CH25(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x2000000) >> 25
}
func (o *DPPIC_Type) SetCHG_CH26(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *DPPIC_Type) GetCHG_CH26(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x4000000) >> 26
}
func (o *DPPIC_Type) SetCHG_CH27(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *DPPIC_Type) GetCHG_CH27(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x8000000) >> 27
}
func (o *DPPIC_Type) SetCHG_CH28(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *DPPIC_Type) GetCHG_CH28(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x10000000) >> 28
}
func (o *DPPIC_Type) SetCHG_CH29(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *DPPIC_Type) GetCHG_CH29(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x20000000) >> 29
}
func (o *DPPIC_Type) SetCHG_CH30(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *DPPIC_Type) GetCHG_CH30(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x40000000) >> 30
}
func (o *DPPIC_Type) SetCHG_CH31(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *DPPIC_Type) GetCHG_CH31(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x80000000) >> 31
}

type DPPIC_TASKS_CHG_Type struct {
	EN  volatile.Register32 // 0x0
	DIS volatile.Register32 // 0x4
}

// DPPIC_TASKS_CHG.EN: Description cluster: Enable channel group n
func (o *DPPIC_TASKS_CHG_Type) SetEN(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x1)|value)
}
func (o *DPPIC_TASKS_CHG_Type) GetEN() uint32 {
	return volatile.LoadUint32(&o.EN.Reg) & 0x1
}

// DPPIC_TASKS_CHG.DIS: Description cluster: Disable channel group n
func (o *DPPIC_TASKS_CHG_Type) SetDIS(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x1)|value)
}
func (o *DPPIC_TASKS_CHG_Type) GetDIS() uint32 {
	return volatile.LoadUint32(&o.DIS.Reg) & 0x1
}

type DPPIC_SUBSCRIBE_CHG_Type struct {
	EN  volatile.Register32 // 0x80
	DIS volatile.Register32 // 0x84
}

// DPPIC_SUBSCRIBE_CHG.EN: Description cluster: Subscribe configuration for task CHG[n].EN
func (o *DPPIC_SUBSCRIBE_CHG_Type) SetEN_CHIDX(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0xff)|value)
}
func (o *DPPIC_SUBSCRIBE_CHG_Type) GetEN_CHIDX() uint32 {
	return volatile.LoadUint32(&o.EN.Reg) & 0xff
}
func (o *DPPIC_SUBSCRIBE_CHG_Type) SetEN(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x80000000)|value<<31)
}
func (o *DPPIC_SUBSCRIBE_CHG_Type) GetEN() uint32 {
	return (volatile.LoadUint32(&o.EN.Reg) & 0x80000000) >> 31
}

// DPPIC_SUBSCRIBE_CHG.DIS: Description cluster: Subscribe configuration for task CHG[n].DIS
func (o *DPPIC_SUBSCRIBE_CHG_Type) SetDIS_CHIDX(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0xff)|value)
}
func (o *DPPIC_SUBSCRIBE_CHG_Type) GetDIS_CHIDX() uint32 {
	return volatile.LoadUint32(&o.DIS.Reg) & 0xff
}
func (o *DPPIC_SUBSCRIBE_CHG_Type) SetDIS_EN(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x80000000)|value<<31)
}
func (o *DPPIC_SUBSCRIBE_CHG_Type) GetDIS_EN() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x80000000) >> 31
}

// Watchdog Timer 0
type WDT_Type struct {
	TASKS_START     volatile.Register32 // 0x0
	TASKS_STOP      volatile.Register32 // 0x4
	_               [120]byte
	SUBSCRIBE_START volatile.Register32 // 0x80
	SUBSCRIBE_STOP  volatile.Register32 // 0x84
	_               [120]byte
	EVENTS_TIMEOUT  volatile.Register32 // 0x100
	EVENTS_STOPPED  volatile.Register32 // 0x104
	_               [120]byte
	PUBLISH_TIMEOUT volatile.Register32 // 0x180
	PUBLISH_STOPPED volatile.Register32 // 0x184
	_               [380]byte
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [24]byte
	NMIENSET        volatile.Register32 // 0x324
	NMIENCLR        volatile.Register32 // 0x328
	_               [212]byte
	RUNSTATUS       volatile.Register32 // 0x400
	REQSTATUS       volatile.Register32 // 0x404
	_               [252]byte
	CRV             volatile.Register32 // 0x504
	RREN            volatile.Register32 // 0x508
	CONFIG          volatile.Register32 // 0x50C
	_               [16]byte
	TSEN            volatile.Register32 // 0x520
	_               [220]byte
	RR              [8]volatile.Register32 // 0x600
}

// WDT.TASKS_START: Start the watchdog
func (o *WDT_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// WDT.TASKS_STOP: Stop the watchdog timer.
func (o *WDT_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// WDT.SUBSCRIBE_START: Subscribe configuration for task START
func (o *WDT_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xff)|value)
}
func (o *WDT_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xff
}
func (o *WDT_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *WDT_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// WDT.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *WDT_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *WDT_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *WDT_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *WDT_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// WDT.EVENTS_TIMEOUT: Watchdog timeout
func (o *WDT_Type) SetEVENTS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TIMEOUT.Reg, volatile.LoadUint32(&o.EVENTS_TIMEOUT.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetEVENTS_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TIMEOUT.Reg) & 0x1
}

// WDT.EVENTS_STOPPED: Watchdog stopped
func (o *WDT_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// WDT.PUBLISH_TIMEOUT: Publish configuration for event TIMEOUT
func (o *WDT_Type) SetPUBLISH_TIMEOUT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TIMEOUT.Reg, volatile.LoadUint32(&o.PUBLISH_TIMEOUT.Reg)&^(0xff)|value)
}
func (o *WDT_Type) GetPUBLISH_TIMEOUT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TIMEOUT.Reg) & 0xff
}
func (o *WDT_Type) SetPUBLISH_TIMEOUT_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TIMEOUT.Reg, volatile.LoadUint32(&o.PUBLISH_TIMEOUT.Reg)&^(0x80000000)|value<<31)
}
func (o *WDT_Type) GetPUBLISH_TIMEOUT_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TIMEOUT.Reg) & 0x80000000) >> 31
}

// WDT.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *WDT_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xff)|value)
}
func (o *WDT_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xff
}
func (o *WDT_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *WDT_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// WDT.INTENSET: Enable interrupt
func (o *WDT_Type) SetINTENSET_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetINTENSET_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *WDT_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}

// WDT.INTENCLR: Disable interrupt
func (o *WDT_Type) SetINTENCLR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetINTENCLR_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *WDT_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}

// WDT.NMIENSET: Enable interrupt
func (o *WDT_Type) SetNMIENSET_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.NMIENSET.Reg, volatile.LoadUint32(&o.NMIENSET.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetNMIENSET_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.NMIENSET.Reg) & 0x1
}
func (o *WDT_Type) SetNMIENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.NMIENSET.Reg, volatile.LoadUint32(&o.NMIENSET.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetNMIENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.NMIENSET.Reg) & 0x2) >> 1
}

// WDT.NMIENCLR: Disable interrupt
func (o *WDT_Type) SetNMIENCLR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.NMIENCLR.Reg, volatile.LoadUint32(&o.NMIENCLR.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetNMIENCLR_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.NMIENCLR.Reg) & 0x1
}
func (o *WDT_Type) SetNMIENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.NMIENCLR.Reg, volatile.LoadUint32(&o.NMIENCLR.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetNMIENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.NMIENCLR.Reg) & 0x2) >> 1
}

// WDT.RUNSTATUS: Run status
func (o *WDT_Type) SetRUNSTATUS_RUNSTATUSWDT(value uint32) {
	volatile.StoreUint32(&o.RUNSTATUS.Reg, volatile.LoadUint32(&o.RUNSTATUS.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetRUNSTATUS_RUNSTATUSWDT() uint32 {
	return volatile.LoadUint32(&o.RUNSTATUS.Reg) & 0x1
}

// WDT.REQSTATUS: Request status
func (o *WDT_Type) SetREQSTATUS_RR0(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetREQSTATUS_RR0() uint32 {
	return volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x1
}
func (o *WDT_Type) SetREQSTATUS_RR1(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetREQSTATUS_RR1() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x2) >> 1
}
func (o *WDT_Type) SetREQSTATUS_RR2(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *WDT_Type) GetREQSTATUS_RR2() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x4) >> 2
}
func (o *WDT_Type) SetREQSTATUS_RR3(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *WDT_Type) GetREQSTATUS_RR3() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x8) >> 3
}
func (o *WDT_Type) SetREQSTATUS_RR4(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *WDT_Type) GetREQSTATUS_RR4() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x10) >> 4
}
func (o *WDT_Type) SetREQSTATUS_RR5(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *WDT_Type) GetREQSTATUS_RR5() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x20) >> 5
}
func (o *WDT_Type) SetREQSTATUS_RR6(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *WDT_Type) GetREQSTATUS_RR6() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x40) >> 6
}
func (o *WDT_Type) SetREQSTATUS_RR7(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *WDT_Type) GetREQSTATUS_RR7() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x80) >> 7
}

// WDT.CRV: Counter reload value
func (o *WDT_Type) SetCRV(value uint32) {
	volatile.StoreUint32(&o.CRV.Reg, value)
}
func (o *WDT_Type) GetCRV() uint32 {
	return volatile.LoadUint32(&o.CRV.Reg)
}

// WDT.RREN: Enable register for reload request registers
func (o *WDT_Type) SetRREN_RR0(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetRREN_RR0() uint32 {
	return volatile.LoadUint32(&o.RREN.Reg) & 0x1
}
func (o *WDT_Type) SetRREN_RR1(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetRREN_RR1() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x2) >> 1
}
func (o *WDT_Type) SetRREN_RR2(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x4)|value<<2)
}
func (o *WDT_Type) GetRREN_RR2() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x4) >> 2
}
func (o *WDT_Type) SetRREN_RR3(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x8)|value<<3)
}
func (o *WDT_Type) GetRREN_RR3() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x8) >> 3
}
func (o *WDT_Type) SetRREN_RR4(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x10)|value<<4)
}
func (o *WDT_Type) GetRREN_RR4() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x10) >> 4
}
func (o *WDT_Type) SetRREN_RR5(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x20)|value<<5)
}
func (o *WDT_Type) GetRREN_RR5() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x20) >> 5
}
func (o *WDT_Type) SetRREN_RR6(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x40)|value<<6)
}
func (o *WDT_Type) GetRREN_RR6() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x40) >> 6
}
func (o *WDT_Type) SetRREN_RR7(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x80)|value<<7)
}
func (o *WDT_Type) GetRREN_RR7() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x80) >> 7
}

// WDT.CONFIG: Configuration register
func (o *WDT_Type) SetCONFIG_SLEEP(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetCONFIG_SLEEP() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *WDT_Type) SetCONFIG_HALT(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x8)|value<<3)
}
func (o *WDT_Type) GetCONFIG_HALT() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x8) >> 3
}
func (o *WDT_Type) SetCONFIG_STOPEN(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x40)|value<<6)
}
func (o *WDT_Type) GetCONFIG_STOPEN() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x40) >> 6
}

// WDT.TSEN: Task Stop Enable
func (o *WDT_Type) SetTSEN(value uint32) {
	volatile.StoreUint32(&o.TSEN.Reg, value)
}
func (o *WDT_Type) GetTSEN() uint32 {
	return volatile.LoadUint32(&o.TSEN.Reg)
}

// WDT.RR: Description collection: Reload request n
func (o *WDT_Type) SetRR(idx int, value uint32) {
	volatile.StoreUint32(&o.RR[idx].Reg, value)
}
func (o *WDT_Type) GetRR(idx int) uint32 {
	return volatile.LoadUint32(&o.RR[idx].Reg)
}

// Comparator 0
type COMP_Type struct {
	TASKS_START      volatile.Register32 // 0x0
	TASKS_STOP       volatile.Register32 // 0x4
	TASKS_SAMPLE     volatile.Register32 // 0x8
	_                [116]byte
	SUBSCRIBE_START  volatile.Register32 // 0x80
	SUBSCRIBE_STOP   volatile.Register32 // 0x84
	SUBSCRIBE_SAMPLE volatile.Register32 // 0x88
	_                [116]byte
	EVENTS_READY     volatile.Register32 // 0x100
	EVENTS_DOWN      volatile.Register32 // 0x104
	EVENTS_UP        volatile.Register32 // 0x108
	EVENTS_CROSS     volatile.Register32 // 0x10C
	_                [112]byte
	PUBLISH_READY    volatile.Register32 // 0x180
	PUBLISH_DOWN     volatile.Register32 // 0x184
	PUBLISH_UP       volatile.Register32 // 0x188
	PUBLISH_CROSS    volatile.Register32 // 0x18C
	_                [112]byte
	SHORTS           volatile.Register32 // 0x200
	_                [252]byte
	INTEN            volatile.Register32 // 0x300
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [244]byte
	RESULT           volatile.Register32 // 0x400
	_                [252]byte
	ENABLE           volatile.Register32 // 0x500
	PSEL             volatile.Register32 // 0x504
	REFSEL           volatile.Register32 // 0x508
	EXTREFSEL        volatile.Register32 // 0x50C
	_                [32]byte
	TH               volatile.Register32 // 0x530
	MODE             volatile.Register32 // 0x534
	HYST             volatile.Register32 // 0x538
	ISOURCE          volatile.Register32 // 0x53C
}

// COMP.TASKS_START: Start comparator
func (o *COMP_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// COMP.TASKS_STOP: Stop comparator
func (o *COMP_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// COMP.TASKS_SAMPLE: Sample comparator value
func (o *COMP_Type) SetTASKS_SAMPLE(value uint32) {
	volatile.StoreUint32(&o.TASKS_SAMPLE.Reg, volatile.LoadUint32(&o.TASKS_SAMPLE.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetTASKS_SAMPLE() uint32 {
	return volatile.LoadUint32(&o.TASKS_SAMPLE.Reg) & 0x1
}

// COMP.SUBSCRIBE_START: Subscribe configuration for task START
func (o *COMP_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xff)|value)
}
func (o *COMP_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xff
}
func (o *COMP_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// COMP.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *COMP_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *COMP_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *COMP_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// COMP.SUBSCRIBE_SAMPLE: Subscribe configuration for task SAMPLE
func (o *COMP_Type) SetSUBSCRIBE_SAMPLE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SAMPLE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SAMPLE.Reg)&^(0xff)|value)
}
func (o *COMP_Type) GetSUBSCRIBE_SAMPLE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SAMPLE.Reg) & 0xff
}
func (o *COMP_Type) SetSUBSCRIBE_SAMPLE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SAMPLE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SAMPLE.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetSUBSCRIBE_SAMPLE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SAMPLE.Reg) & 0x80000000) >> 31
}

// COMP.EVENTS_READY: COMP is ready and output is valid
func (o *COMP_Type) SetEVENTS_READY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_READY.Reg, volatile.LoadUint32(&o.EVENTS_READY.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetEVENTS_READY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_READY.Reg) & 0x1
}

// COMP.EVENTS_DOWN: Downward crossing
func (o *COMP_Type) SetEVENTS_DOWN(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DOWN.Reg, volatile.LoadUint32(&o.EVENTS_DOWN.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetEVENTS_DOWN() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DOWN.Reg) & 0x1
}

// COMP.EVENTS_UP: Upward crossing
func (o *COMP_Type) SetEVENTS_UP(value uint32) {
	volatile.StoreUint32(&o.EVENTS_UP.Reg, volatile.LoadUint32(&o.EVENTS_UP.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetEVENTS_UP() uint32 {
	return volatile.LoadUint32(&o.EVENTS_UP.Reg) & 0x1
}

// COMP.EVENTS_CROSS: Downward or upward crossing
func (o *COMP_Type) SetEVENTS_CROSS(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CROSS.Reg, volatile.LoadUint32(&o.EVENTS_CROSS.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetEVENTS_CROSS() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CROSS.Reg) & 0x1
}

// COMP.PUBLISH_READY: Publish configuration for event READY
func (o *COMP_Type) SetPUBLISH_READY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_READY.Reg, volatile.LoadUint32(&o.PUBLISH_READY.Reg)&^(0xff)|value)
}
func (o *COMP_Type) GetPUBLISH_READY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_READY.Reg) & 0xff
}
func (o *COMP_Type) SetPUBLISH_READY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_READY.Reg, volatile.LoadUint32(&o.PUBLISH_READY.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetPUBLISH_READY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_READY.Reg) & 0x80000000) >> 31
}

// COMP.PUBLISH_DOWN: Publish configuration for event DOWN
func (o *COMP_Type) SetPUBLISH_DOWN_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DOWN.Reg, volatile.LoadUint32(&o.PUBLISH_DOWN.Reg)&^(0xff)|value)
}
func (o *COMP_Type) GetPUBLISH_DOWN_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_DOWN.Reg) & 0xff
}
func (o *COMP_Type) SetPUBLISH_DOWN_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DOWN.Reg, volatile.LoadUint32(&o.PUBLISH_DOWN.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetPUBLISH_DOWN_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_DOWN.Reg) & 0x80000000) >> 31
}

// COMP.PUBLISH_UP: Publish configuration for event UP
func (o *COMP_Type) SetPUBLISH_UP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_UP.Reg, volatile.LoadUint32(&o.PUBLISH_UP.Reg)&^(0xff)|value)
}
func (o *COMP_Type) GetPUBLISH_UP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_UP.Reg) & 0xff
}
func (o *COMP_Type) SetPUBLISH_UP_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_UP.Reg, volatile.LoadUint32(&o.PUBLISH_UP.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetPUBLISH_UP_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_UP.Reg) & 0x80000000) >> 31
}

// COMP.PUBLISH_CROSS: Publish configuration for event CROSS
func (o *COMP_Type) SetPUBLISH_CROSS_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CROSS.Reg, volatile.LoadUint32(&o.PUBLISH_CROSS.Reg)&^(0xff)|value)
}
func (o *COMP_Type) GetPUBLISH_CROSS_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_CROSS.Reg) & 0xff
}
func (o *COMP_Type) SetPUBLISH_CROSS_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CROSS.Reg, volatile.LoadUint32(&o.PUBLISH_CROSS.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetPUBLISH_CROSS_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_CROSS.Reg) & 0x80000000) >> 31
}

// COMP.SHORTS: Shortcuts between local events and tasks
func (o *COMP_Type) SetSHORTS_READY_SAMPLE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetSHORTS_READY_SAMPLE() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *COMP_Type) SetSHORTS_READY_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *COMP_Type) GetSHORTS_READY_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *COMP_Type) SetSHORTS_DOWN_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *COMP_Type) GetSHORTS_DOWN_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *COMP_Type) SetSHORTS_UP_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *COMP_Type) GetSHORTS_UP_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}
func (o *COMP_Type) SetSHORTS_CROSS_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10)|value<<4)
}
func (o *COMP_Type) GetSHORTS_CROSS_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10) >> 4
}

// COMP.INTEN: Enable or disable interrupt
func (o *COMP_Type) SetINTEN_READY(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetINTEN_READY() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *COMP_Type) SetINTEN_DOWN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *COMP_Type) GetINTEN_DOWN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *COMP_Type) SetINTEN_UP(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *COMP_Type) GetINTEN_UP() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *COMP_Type) SetINTEN_CROSS(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *COMP_Type) GetINTEN_CROSS() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}

// COMP.INTENSET: Enable interrupt
func (o *COMP_Type) SetINTENSET_READY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetINTENSET_READY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *COMP_Type) SetINTENSET_DOWN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *COMP_Type) GetINTENSET_DOWN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *COMP_Type) SetINTENSET_UP(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *COMP_Type) GetINTENSET_UP() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *COMP_Type) SetINTENSET_CROSS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *COMP_Type) GetINTENSET_CROSS() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}

// COMP.INTENCLR: Disable interrupt
func (o *COMP_Type) SetINTENCLR_READY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetINTENCLR_READY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *COMP_Type) SetINTENCLR_DOWN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *COMP_Type) GetINTENCLR_DOWN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *COMP_Type) SetINTENCLR_UP(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *COMP_Type) GetINTENCLR_UP() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *COMP_Type) SetINTENCLR_CROSS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *COMP_Type) GetINTENCLR_CROSS() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}

// COMP.RESULT: Compare result
func (o *COMP_Type) SetRESULT(value uint32) {
	volatile.StoreUint32(&o.RESULT.Reg, volatile.LoadUint32(&o.RESULT.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetRESULT() uint32 {
	return volatile.LoadUint32(&o.RESULT.Reg) & 0x1
}

// COMP.ENABLE: COMP enable
func (o *COMP_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x3)|value)
}
func (o *COMP_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x3
}

// COMP.PSEL: Pin select
func (o *COMP_Type) SetPSEL(value uint32) {
	volatile.StoreUint32(&o.PSEL.Reg, volatile.LoadUint32(&o.PSEL.Reg)&^(0x7)|value)
}
func (o *COMP_Type) GetPSEL() uint32 {
	return volatile.LoadUint32(&o.PSEL.Reg) & 0x7
}

// COMP.REFSEL: Reference source select for single-ended mode
func (o *COMP_Type) SetREFSEL(value uint32) {
	volatile.StoreUint32(&o.REFSEL.Reg, volatile.LoadUint32(&o.REFSEL.Reg)&^(0x7)|value)
}
func (o *COMP_Type) GetREFSEL() uint32 {
	return volatile.LoadUint32(&o.REFSEL.Reg) & 0x7
}

// COMP.EXTREFSEL: External reference select
func (o *COMP_Type) SetEXTREFSEL(value uint32) {
	volatile.StoreUint32(&o.EXTREFSEL.Reg, volatile.LoadUint32(&o.EXTREFSEL.Reg)&^(0x7)|value)
}
func (o *COMP_Type) GetEXTREFSEL() uint32 {
	return volatile.LoadUint32(&o.EXTREFSEL.Reg) & 0x7
}

// COMP.TH: Threshold configuration for hysteresis unit
func (o *COMP_Type) SetTH_THDOWN(value uint32) {
	volatile.StoreUint32(&o.TH.Reg, volatile.LoadUint32(&o.TH.Reg)&^(0x3f)|value)
}
func (o *COMP_Type) GetTH_THDOWN() uint32 {
	return volatile.LoadUint32(&o.TH.Reg) & 0x3f
}
func (o *COMP_Type) SetTH_THUP(value uint32) {
	volatile.StoreUint32(&o.TH.Reg, volatile.LoadUint32(&o.TH.Reg)&^(0x3f00)|value<<8)
}
func (o *COMP_Type) GetTH_THUP() uint32 {
	return (volatile.LoadUint32(&o.TH.Reg) & 0x3f00) >> 8
}

// COMP.MODE: Mode configuration
func (o *COMP_Type) SetMODE_SP(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x3)|value)
}
func (o *COMP_Type) GetMODE_SP() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x3
}
func (o *COMP_Type) SetMODE_MAIN(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x100)|value<<8)
}
func (o *COMP_Type) GetMODE_MAIN() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x100) >> 8
}

// COMP.HYST: Comparator hysteresis enable
func (o *COMP_Type) SetHYST(value uint32) {
	volatile.StoreUint32(&o.HYST.Reg, volatile.LoadUint32(&o.HYST.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetHYST() uint32 {
	return volatile.LoadUint32(&o.HYST.Reg) & 0x1
}

// COMP.ISOURCE: Current source select on analog input
func (o *COMP_Type) SetISOURCE(value uint32) {
	volatile.StoreUint32(&o.ISOURCE.Reg, volatile.LoadUint32(&o.ISOURCE.Reg)&^(0x3)|value)
}
func (o *COMP_Type) GetISOURCE() uint32 {
	return volatile.LoadUint32(&o.ISOURCE.Reg) & 0x3
}

// Low-power comparator 0
type LPCOMP_Type struct {
	TASKS_START      volatile.Register32 // 0x0
	TASKS_STOP       volatile.Register32 // 0x4
	TASKS_SAMPLE     volatile.Register32 // 0x8
	_                [116]byte
	SUBSCRIBE_START  volatile.Register32 // 0x80
	SUBSCRIBE_STOP   volatile.Register32 // 0x84
	SUBSCRIBE_SAMPLE volatile.Register32 // 0x88
	_                [116]byte
	EVENTS_READY     volatile.Register32 // 0x100
	EVENTS_DOWN      volatile.Register32 // 0x104
	EVENTS_UP        volatile.Register32 // 0x108
	EVENTS_CROSS     volatile.Register32 // 0x10C
	_                [112]byte
	PUBLISH_READY    volatile.Register32 // 0x180
	PUBLISH_DOWN     volatile.Register32 // 0x184
	PUBLISH_UP       volatile.Register32 // 0x188
	PUBLISH_CROSS    volatile.Register32 // 0x18C
	_                [112]byte
	SHORTS           volatile.Register32 // 0x200
	_                [256]byte
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [244]byte
	RESULT           volatile.Register32 // 0x400
	_                [252]byte
	ENABLE           volatile.Register32 // 0x500
	PSEL             volatile.Register32 // 0x504
	REFSEL           volatile.Register32 // 0x508
	EXTREFSEL        volatile.Register32 // 0x50C
	_                [16]byte
	ANADETECT        volatile.Register32 // 0x520
	_                [20]byte
	HYST             volatile.Register32 // 0x538
}

// LPCOMP.TASKS_START: Start comparator
func (o *LPCOMP_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// LPCOMP.TASKS_STOP: Stop comparator
func (o *LPCOMP_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// LPCOMP.TASKS_SAMPLE: Sample comparator value
func (o *LPCOMP_Type) SetTASKS_SAMPLE(value uint32) {
	volatile.StoreUint32(&o.TASKS_SAMPLE.Reg, volatile.LoadUint32(&o.TASKS_SAMPLE.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetTASKS_SAMPLE() uint32 {
	return volatile.LoadUint32(&o.TASKS_SAMPLE.Reg) & 0x1
}

// LPCOMP.SUBSCRIBE_START: Subscribe configuration for task START
func (o *LPCOMP_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xff)|value)
}
func (o *LPCOMP_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xff
}
func (o *LPCOMP_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *LPCOMP_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// LPCOMP.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *LPCOMP_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *LPCOMP_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *LPCOMP_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *LPCOMP_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// LPCOMP.SUBSCRIBE_SAMPLE: Subscribe configuration for task SAMPLE
func (o *LPCOMP_Type) SetSUBSCRIBE_SAMPLE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SAMPLE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SAMPLE.Reg)&^(0xff)|value)
}
func (o *LPCOMP_Type) GetSUBSCRIBE_SAMPLE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SAMPLE.Reg) & 0xff
}
func (o *LPCOMP_Type) SetSUBSCRIBE_SAMPLE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SAMPLE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SAMPLE.Reg)&^(0x80000000)|value<<31)
}
func (o *LPCOMP_Type) GetSUBSCRIBE_SAMPLE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SAMPLE.Reg) & 0x80000000) >> 31
}

// LPCOMP.EVENTS_READY: LPCOMP is ready and output is valid
func (o *LPCOMP_Type) SetEVENTS_READY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_READY.Reg, volatile.LoadUint32(&o.EVENTS_READY.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetEVENTS_READY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_READY.Reg) & 0x1
}

// LPCOMP.EVENTS_DOWN: Downward crossing
func (o *LPCOMP_Type) SetEVENTS_DOWN(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DOWN.Reg, volatile.LoadUint32(&o.EVENTS_DOWN.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetEVENTS_DOWN() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DOWN.Reg) & 0x1
}

// LPCOMP.EVENTS_UP: Upward crossing
func (o *LPCOMP_Type) SetEVENTS_UP(value uint32) {
	volatile.StoreUint32(&o.EVENTS_UP.Reg, volatile.LoadUint32(&o.EVENTS_UP.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetEVENTS_UP() uint32 {
	return volatile.LoadUint32(&o.EVENTS_UP.Reg) & 0x1
}

// LPCOMP.EVENTS_CROSS: Downward or upward crossing
func (o *LPCOMP_Type) SetEVENTS_CROSS(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CROSS.Reg, volatile.LoadUint32(&o.EVENTS_CROSS.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetEVENTS_CROSS() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CROSS.Reg) & 0x1
}

// LPCOMP.PUBLISH_READY: Publish configuration for event READY
func (o *LPCOMP_Type) SetPUBLISH_READY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_READY.Reg, volatile.LoadUint32(&o.PUBLISH_READY.Reg)&^(0xff)|value)
}
func (o *LPCOMP_Type) GetPUBLISH_READY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_READY.Reg) & 0xff
}
func (o *LPCOMP_Type) SetPUBLISH_READY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_READY.Reg, volatile.LoadUint32(&o.PUBLISH_READY.Reg)&^(0x80000000)|value<<31)
}
func (o *LPCOMP_Type) GetPUBLISH_READY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_READY.Reg) & 0x80000000) >> 31
}

// LPCOMP.PUBLISH_DOWN: Publish configuration for event DOWN
func (o *LPCOMP_Type) SetPUBLISH_DOWN_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DOWN.Reg, volatile.LoadUint32(&o.PUBLISH_DOWN.Reg)&^(0xff)|value)
}
func (o *LPCOMP_Type) GetPUBLISH_DOWN_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_DOWN.Reg) & 0xff
}
func (o *LPCOMP_Type) SetPUBLISH_DOWN_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DOWN.Reg, volatile.LoadUint32(&o.PUBLISH_DOWN.Reg)&^(0x80000000)|value<<31)
}
func (o *LPCOMP_Type) GetPUBLISH_DOWN_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_DOWN.Reg) & 0x80000000) >> 31
}

// LPCOMP.PUBLISH_UP: Publish configuration for event UP
func (o *LPCOMP_Type) SetPUBLISH_UP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_UP.Reg, volatile.LoadUint32(&o.PUBLISH_UP.Reg)&^(0xff)|value)
}
func (o *LPCOMP_Type) GetPUBLISH_UP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_UP.Reg) & 0xff
}
func (o *LPCOMP_Type) SetPUBLISH_UP_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_UP.Reg, volatile.LoadUint32(&o.PUBLISH_UP.Reg)&^(0x80000000)|value<<31)
}
func (o *LPCOMP_Type) GetPUBLISH_UP_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_UP.Reg) & 0x80000000) >> 31
}

// LPCOMP.PUBLISH_CROSS: Publish configuration for event CROSS
func (o *LPCOMP_Type) SetPUBLISH_CROSS_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CROSS.Reg, volatile.LoadUint32(&o.PUBLISH_CROSS.Reg)&^(0xff)|value)
}
func (o *LPCOMP_Type) GetPUBLISH_CROSS_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_CROSS.Reg) & 0xff
}
func (o *LPCOMP_Type) SetPUBLISH_CROSS_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CROSS.Reg, volatile.LoadUint32(&o.PUBLISH_CROSS.Reg)&^(0x80000000)|value<<31)
}
func (o *LPCOMP_Type) GetPUBLISH_CROSS_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_CROSS.Reg) & 0x80000000) >> 31
}

// LPCOMP.SHORTS: Shortcuts between local events and tasks
func (o *LPCOMP_Type) SetSHORTS_READY_SAMPLE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetSHORTS_READY_SAMPLE() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *LPCOMP_Type) SetSHORTS_READY_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *LPCOMP_Type) GetSHORTS_READY_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *LPCOMP_Type) SetSHORTS_DOWN_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *LPCOMP_Type) GetSHORTS_DOWN_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *LPCOMP_Type) SetSHORTS_UP_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *LPCOMP_Type) GetSHORTS_UP_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}
func (o *LPCOMP_Type) SetSHORTS_CROSS_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10)|value<<4)
}
func (o *LPCOMP_Type) GetSHORTS_CROSS_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10) >> 4
}

// LPCOMP.INTENSET: Enable interrupt
func (o *LPCOMP_Type) SetINTENSET_READY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetINTENSET_READY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *LPCOMP_Type) SetINTENSET_DOWN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *LPCOMP_Type) GetINTENSET_DOWN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *LPCOMP_Type) SetINTENSET_UP(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *LPCOMP_Type) GetINTENSET_UP() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *LPCOMP_Type) SetINTENSET_CROSS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *LPCOMP_Type) GetINTENSET_CROSS() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}

// LPCOMP.INTENCLR: Disable interrupt
func (o *LPCOMP_Type) SetINTENCLR_READY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetINTENCLR_READY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *LPCOMP_Type) SetINTENCLR_DOWN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *LPCOMP_Type) GetINTENCLR_DOWN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *LPCOMP_Type) SetINTENCLR_UP(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *LPCOMP_Type) GetINTENCLR_UP() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *LPCOMP_Type) SetINTENCLR_CROSS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *LPCOMP_Type) GetINTENCLR_CROSS() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}

// LPCOMP.RESULT: Compare result
func (o *LPCOMP_Type) SetRESULT(value uint32) {
	volatile.StoreUint32(&o.RESULT.Reg, volatile.LoadUint32(&o.RESULT.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetRESULT() uint32 {
	return volatile.LoadUint32(&o.RESULT.Reg) & 0x1
}

// LPCOMP.ENABLE: Enable LPCOMP
func (o *LPCOMP_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x3)|value)
}
func (o *LPCOMP_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x3
}

// LPCOMP.PSEL: Input pin select
func (o *LPCOMP_Type) SetPSEL(value uint32) {
	volatile.StoreUint32(&o.PSEL.Reg, volatile.LoadUint32(&o.PSEL.Reg)&^(0x7)|value)
}
func (o *LPCOMP_Type) GetPSEL() uint32 {
	return volatile.LoadUint32(&o.PSEL.Reg) & 0x7
}

// LPCOMP.REFSEL: Reference select
func (o *LPCOMP_Type) SetREFSEL(value uint32) {
	volatile.StoreUint32(&o.REFSEL.Reg, volatile.LoadUint32(&o.REFSEL.Reg)&^(0xf)|value)
}
func (o *LPCOMP_Type) GetREFSEL() uint32 {
	return volatile.LoadUint32(&o.REFSEL.Reg) & 0xf
}

// LPCOMP.EXTREFSEL: External reference select
func (o *LPCOMP_Type) SetEXTREFSEL(value uint32) {
	volatile.StoreUint32(&o.EXTREFSEL.Reg, volatile.LoadUint32(&o.EXTREFSEL.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetEXTREFSEL() uint32 {
	return volatile.LoadUint32(&o.EXTREFSEL.Reg) & 0x1
}

// LPCOMP.ANADETECT: Analog detect configuration
func (o *LPCOMP_Type) SetANADETECT(value uint32) {
	volatile.StoreUint32(&o.ANADETECT.Reg, volatile.LoadUint32(&o.ANADETECT.Reg)&^(0x3)|value)
}
func (o *LPCOMP_Type) GetANADETECT() uint32 {
	return volatile.LoadUint32(&o.ANADETECT.Reg) & 0x3
}

// LPCOMP.HYST: Comparator hysteresis enable
func (o *LPCOMP_Type) SetHYST(value uint32) {
	volatile.StoreUint32(&o.HYST.Reg, volatile.LoadUint32(&o.HYST.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetHYST() uint32 {
	return volatile.LoadUint32(&o.HYST.Reg) & 0x1
}

// Event generator unit 0
type EGU_Type struct {
	TASKS_TRIGGER     [16]volatile.Register32 // 0x0
	_                 [64]byte
	SUBSCRIBE_TRIGGER [16]volatile.Register32 // 0x80
	_                 [64]byte
	EVENTS_TRIGGERED  [16]volatile.Register32 // 0x100
	_                 [64]byte
	PUBLISH_TRIGGERED [16]volatile.Register32 // 0x180
	_                 [320]byte
	INTEN             volatile.Register32 // 0x300
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
}

// EGU.TASKS_TRIGGER: Description collection: Trigger n for triggering the corresponding TRIGGERED[n] event
func (o *EGU_Type) SetTASKS_TRIGGER(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_TRIGGER[idx].Reg, volatile.LoadUint32(&o.TASKS_TRIGGER[idx].Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetTASKS_TRIGGER(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_TRIGGER[idx].Reg) & 0x1
}

// EGU.SUBSCRIBE_TRIGGER: Description collection: Subscribe configuration for task TRIGGER[n]
func (o *EGU_Type) SetSUBSCRIBE_TRIGGER_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_TRIGGER[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_TRIGGER[idx].Reg)&^(0xff)|value)
}
func (o *EGU_Type) GetSUBSCRIBE_TRIGGER_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_TRIGGER[idx].Reg) & 0xff
}
func (o *EGU_Type) SetSUBSCRIBE_TRIGGER_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_TRIGGER[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_TRIGGER[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *EGU_Type) GetSUBSCRIBE_TRIGGER_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_TRIGGER[idx].Reg) & 0x80000000) >> 31
}

// EGU.EVENTS_TRIGGERED: Description collection: Event number n generated by triggering the corresponding TRIGGER[n] task
func (o *EGU_Type) SetEVENTS_TRIGGERED(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_TRIGGERED[idx].Reg, volatile.LoadUint32(&o.EVENTS_TRIGGERED[idx].Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetEVENTS_TRIGGERED(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_TRIGGERED[idx].Reg) & 0x1
}

// EGU.PUBLISH_TRIGGERED: Description collection: Publish configuration for event TRIGGERED[n]
func (o *EGU_Type) SetPUBLISH_TRIGGERED_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TRIGGERED[idx].Reg, volatile.LoadUint32(&o.PUBLISH_TRIGGERED[idx].Reg)&^(0xff)|value)
}
func (o *EGU_Type) GetPUBLISH_TRIGGERED_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TRIGGERED[idx].Reg) & 0xff
}
func (o *EGU_Type) SetPUBLISH_TRIGGERED_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TRIGGERED[idx].Reg, volatile.LoadUint32(&o.PUBLISH_TRIGGERED[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *EGU_Type) GetPUBLISH_TRIGGERED_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TRIGGERED[idx].Reg) & 0x80000000) >> 31
}

// EGU.INTEN: Enable or disable interrupt
func (o *EGU_Type) SetINTEN_TRIGGERED0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetINTEN_TRIGGERED0() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *EGU_Type) SetINTEN_TRIGGERED1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *EGU_Type) GetINTEN_TRIGGERED1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *EGU_Type) SetINTEN_TRIGGERED2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *EGU_Type) GetINTEN_TRIGGERED2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *EGU_Type) SetINTEN_TRIGGERED3(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *EGU_Type) GetINTEN_TRIGGERED3() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *EGU_Type) SetINTEN_TRIGGERED4(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *EGU_Type) GetINTEN_TRIGGERED4() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *EGU_Type) SetINTEN_TRIGGERED5(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *EGU_Type) GetINTEN_TRIGGERED5() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *EGU_Type) SetINTEN_TRIGGERED6(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *EGU_Type) GetINTEN_TRIGGERED6() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *EGU_Type) SetINTEN_TRIGGERED7(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *EGU_Type) GetINTEN_TRIGGERED7() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *EGU_Type) SetINTEN_TRIGGERED8(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *EGU_Type) GetINTEN_TRIGGERED8() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *EGU_Type) SetINTEN_TRIGGERED9(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *EGU_Type) GetINTEN_TRIGGERED9() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *EGU_Type) SetINTEN_TRIGGERED10(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400)|value<<10)
}
func (o *EGU_Type) GetINTEN_TRIGGERED10() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400) >> 10
}
func (o *EGU_Type) SetINTEN_TRIGGERED11(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800)|value<<11)
}
func (o *EGU_Type) GetINTEN_TRIGGERED11() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800) >> 11
}
func (o *EGU_Type) SetINTEN_TRIGGERED12(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000)|value<<12)
}
func (o *EGU_Type) GetINTEN_TRIGGERED12() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000) >> 12
}
func (o *EGU_Type) SetINTEN_TRIGGERED13(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2000)|value<<13)
}
func (o *EGU_Type) GetINTEN_TRIGGERED13() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2000) >> 13
}
func (o *EGU_Type) SetINTEN_TRIGGERED14(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000)|value<<14)
}
func (o *EGU_Type) GetINTEN_TRIGGERED14() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000) >> 14
}
func (o *EGU_Type) SetINTEN_TRIGGERED15(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8000)|value<<15)
}
func (o *EGU_Type) GetINTEN_TRIGGERED15() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8000) >> 15
}

// EGU.INTENSET: Enable interrupt
func (o *EGU_Type) SetINTENSET_TRIGGERED0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED0() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *EGU_Type) SetINTENSET_TRIGGERED1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *EGU_Type) SetINTENSET_TRIGGERED2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *EGU_Type) SetINTENSET_TRIGGERED3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *EGU_Type) SetINTENSET_TRIGGERED4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *EGU_Type) SetINTENSET_TRIGGERED5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *EGU_Type) SetINTENSET_TRIGGERED6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *EGU_Type) SetINTENSET_TRIGGERED7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *EGU_Type) SetINTENSET_TRIGGERED8(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED8() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *EGU_Type) SetINTENSET_TRIGGERED9(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED9() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *EGU_Type) SetINTENSET_TRIGGERED10(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED10() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *EGU_Type) SetINTENSET_TRIGGERED11(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED11() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *EGU_Type) SetINTENSET_TRIGGERED12(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED12() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *EGU_Type) SetINTENSET_TRIGGERED13(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED13() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *EGU_Type) SetINTENSET_TRIGGERED14(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED14() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *EGU_Type) SetINTENSET_TRIGGERED15(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED15() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}

// EGU.INTENCLR: Disable interrupt
func (o *EGU_Type) SetINTENCLR_TRIGGERED0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED0() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED8(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED8() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED9(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED9() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED10(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED10() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED11(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED11() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED12(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED12() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED13(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED13() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED14(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED14() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED15(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED15() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}

// Pulse width modulation unit 0
type PWM_Type struct {
	_                    [4]byte
	TASKS_STOP           volatile.Register32    // 0x4
	TASKS_SEQSTART       [2]volatile.Register32 // 0x8
	TASKS_NEXTSTEP       volatile.Register32    // 0x10
	_                    [112]byte
	SUBSCRIBE_STOP       volatile.Register32    // 0x84
	SUBSCRIBE_SEQSTART   [2]volatile.Register32 // 0x88
	SUBSCRIBE_NEXTSTEP   volatile.Register32    // 0x90
	_                    [112]byte
	EVENTS_STOPPED       volatile.Register32    // 0x104
	EVENTS_SEQSTARTED    [2]volatile.Register32 // 0x108
	EVENTS_SEQEND        [2]volatile.Register32 // 0x110
	EVENTS_PWMPERIODEND  volatile.Register32    // 0x118
	EVENTS_LOOPSDONE     volatile.Register32    // 0x11C
	_                    [100]byte
	PUBLISH_STOPPED      volatile.Register32    // 0x184
	PUBLISH_SEQSTARTED   [2]volatile.Register32 // 0x188
	PUBLISH_SEQEND       [2]volatile.Register32 // 0x190
	PUBLISH_PWMPERIODEND volatile.Register32    // 0x198
	PUBLISH_LOOPSDONE    volatile.Register32    // 0x19C
	_                    [96]byte
	SHORTS               volatile.Register32 // 0x200
	_                    [252]byte
	INTEN                volatile.Register32 // 0x300
	INTENSET             volatile.Register32 // 0x304
	INTENCLR             volatile.Register32 // 0x308
	_                    [500]byte
	ENABLE               volatile.Register32 // 0x500
	MODE                 volatile.Register32 // 0x504
	COUNTERTOP           volatile.Register32 // 0x508
	PRESCALER            volatile.Register32 // 0x50C
	DECODER              volatile.Register32 // 0x510
	LOOP                 volatile.Register32 // 0x514
	_                    [8]byte
	SEQ                  [2]PWM_SEQ_Type // 0x520
	PSEL                 PWM_PSEL_Type   // 0x560
}

// PWM.TASKS_STOP: Stops PWM pulse generation on all channels at the end of current PWM period, and stops sequence playback
func (o *PWM_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// PWM.TASKS_SEQSTART: Description collection: Loads the first PWM value on all enabled channels from sequence n, and starts playing that sequence at the rate defined in SEQ[n]REFRESH and/or DECODER.MODE. Causes PWM generation to start if not running.
func (o *PWM_Type) SetTASKS_SEQSTART(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_SEQSTART[idx].Reg, volatile.LoadUint32(&o.TASKS_SEQSTART[idx].Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetTASKS_SEQSTART(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_SEQSTART[idx].Reg) & 0x1
}

// PWM.TASKS_NEXTSTEP: Steps by one value in the current sequence on all enabled channels if DECODER.MODE=NextStep. Does not cause PWM generation to start if not running.
func (o *PWM_Type) SetTASKS_NEXTSTEP(value uint32) {
	volatile.StoreUint32(&o.TASKS_NEXTSTEP.Reg, volatile.LoadUint32(&o.TASKS_NEXTSTEP.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetTASKS_NEXTSTEP() uint32 {
	return volatile.LoadUint32(&o.TASKS_NEXTSTEP.Reg) & 0x1
}

// PWM.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *PWM_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *PWM_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// PWM.SUBSCRIBE_SEQSTART: Description collection: Subscribe configuration for task SEQSTART[n]
func (o *PWM_Type) SetSUBSCRIBE_SEQSTART_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SEQSTART[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_SEQSTART[idx].Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetSUBSCRIBE_SEQSTART_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SEQSTART[idx].Reg) & 0xff
}
func (o *PWM_Type) SetSUBSCRIBE_SEQSTART_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SEQSTART[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_SEQSTART[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetSUBSCRIBE_SEQSTART_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SEQSTART[idx].Reg) & 0x80000000) >> 31
}

// PWM.SUBSCRIBE_NEXTSTEP: Subscribe configuration for task NEXTSTEP
func (o *PWM_Type) SetSUBSCRIBE_NEXTSTEP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_NEXTSTEP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_NEXTSTEP.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetSUBSCRIBE_NEXTSTEP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_NEXTSTEP.Reg) & 0xff
}
func (o *PWM_Type) SetSUBSCRIBE_NEXTSTEP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_NEXTSTEP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_NEXTSTEP.Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetSUBSCRIBE_NEXTSTEP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_NEXTSTEP.Reg) & 0x80000000) >> 31
}

// PWM.EVENTS_STOPPED: Response to STOP task, emitted when PWM pulses are no longer generated
func (o *PWM_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// PWM.EVENTS_SEQSTARTED: Description collection: First PWM period started on sequence n
func (o *PWM_Type) SetEVENTS_SEQSTARTED(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_SEQSTARTED[idx].Reg, volatile.LoadUint32(&o.EVENTS_SEQSTARTED[idx].Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetEVENTS_SEQSTARTED(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_SEQSTARTED[idx].Reg) & 0x1
}

// PWM.EVENTS_SEQEND: Description collection: Emitted at end of every sequence n, when last value from RAM has been applied to wave counter
func (o *PWM_Type) SetEVENTS_SEQEND(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_SEQEND[idx].Reg, volatile.LoadUint32(&o.EVENTS_SEQEND[idx].Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetEVENTS_SEQEND(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_SEQEND[idx].Reg) & 0x1
}

// PWM.EVENTS_PWMPERIODEND: Emitted at the end of each PWM period
func (o *PWM_Type) SetEVENTS_PWMPERIODEND(value uint32) {
	volatile.StoreUint32(&o.EVENTS_PWMPERIODEND.Reg, volatile.LoadUint32(&o.EVENTS_PWMPERIODEND.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetEVENTS_PWMPERIODEND() uint32 {
	return volatile.LoadUint32(&o.EVENTS_PWMPERIODEND.Reg) & 0x1
}

// PWM.EVENTS_LOOPSDONE: Concatenated sequences have been played the amount of times defined in LOOP.CNT
func (o *PWM_Type) SetEVENTS_LOOPSDONE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_LOOPSDONE.Reg, volatile.LoadUint32(&o.EVENTS_LOOPSDONE.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetEVENTS_LOOPSDONE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_LOOPSDONE.Reg) & 0x1
}

// PWM.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *PWM_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xff
}
func (o *PWM_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// PWM.PUBLISH_SEQSTARTED: Description collection: Publish configuration for event SEQSTARTED[n]
func (o *PWM_Type) SetPUBLISH_SEQSTARTED_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SEQSTARTED[idx].Reg, volatile.LoadUint32(&o.PUBLISH_SEQSTARTED[idx].Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetPUBLISH_SEQSTARTED_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_SEQSTARTED[idx].Reg) & 0xff
}
func (o *PWM_Type) SetPUBLISH_SEQSTARTED_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SEQSTARTED[idx].Reg, volatile.LoadUint32(&o.PUBLISH_SEQSTARTED[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetPUBLISH_SEQSTARTED_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_SEQSTARTED[idx].Reg) & 0x80000000) >> 31
}

// PWM.PUBLISH_SEQEND: Description collection: Publish configuration for event SEQEND[n]
func (o *PWM_Type) SetPUBLISH_SEQEND_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SEQEND[idx].Reg, volatile.LoadUint32(&o.PUBLISH_SEQEND[idx].Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetPUBLISH_SEQEND_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_SEQEND[idx].Reg) & 0xff
}
func (o *PWM_Type) SetPUBLISH_SEQEND_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SEQEND[idx].Reg, volatile.LoadUint32(&o.PUBLISH_SEQEND[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetPUBLISH_SEQEND_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_SEQEND[idx].Reg) & 0x80000000) >> 31
}

// PWM.PUBLISH_PWMPERIODEND: Publish configuration for event PWMPERIODEND
func (o *PWM_Type) SetPUBLISH_PWMPERIODEND_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_PWMPERIODEND.Reg, volatile.LoadUint32(&o.PUBLISH_PWMPERIODEND.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetPUBLISH_PWMPERIODEND_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_PWMPERIODEND.Reg) & 0xff
}
func (o *PWM_Type) SetPUBLISH_PWMPERIODEND_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_PWMPERIODEND.Reg, volatile.LoadUint32(&o.PUBLISH_PWMPERIODEND.Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetPUBLISH_PWMPERIODEND_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_PWMPERIODEND.Reg) & 0x80000000) >> 31
}

// PWM.PUBLISH_LOOPSDONE: Publish configuration for event LOOPSDONE
func (o *PWM_Type) SetPUBLISH_LOOPSDONE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LOOPSDONE.Reg, volatile.LoadUint32(&o.PUBLISH_LOOPSDONE.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetPUBLISH_LOOPSDONE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_LOOPSDONE.Reg) & 0xff
}
func (o *PWM_Type) SetPUBLISH_LOOPSDONE_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LOOPSDONE.Reg, volatile.LoadUint32(&o.PUBLISH_LOOPSDONE.Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetPUBLISH_LOOPSDONE_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_LOOPSDONE.Reg) & 0x80000000) >> 31
}

// PWM.SHORTS: Shortcuts between local events and tasks
func (o *PWM_Type) SetSHORTS_SEQEND0_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSHORTS_SEQEND0_STOP() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *PWM_Type) SetSHORTS_SEQEND1_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSHORTS_SEQEND1_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSHORTS_LOOPSDONE_SEQSTART0(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSHORTS_LOOPSDONE_SEQSTART0() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSHORTS_LOOPSDONE_SEQSTART1(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSHORTS_LOOPSDONE_SEQSTART1() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetSHORTS_LOOPSDONE_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetSHORTS_LOOPSDONE_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10) >> 4
}

// PWM.INTEN: Enable or disable interrupt
func (o *PWM_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetINTEN_SEQSTARTED0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetINTEN_SEQSTARTED0() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetINTEN_SEQSTARTED1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetINTEN_SEQSTARTED1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetINTEN_SEQEND0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetINTEN_SEQEND0() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetINTEN_SEQEND1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetINTEN_SEQEND1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetINTEN_PWMPERIODEND(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetINTEN_PWMPERIODEND() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetINTEN_LOOPSDONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetINTEN_LOOPSDONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}

// PWM.INTENSET: Enable interrupt
func (o *PWM_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetINTENSET_SEQSTARTED0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetINTENSET_SEQSTARTED0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetINTENSET_SEQSTARTED1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetINTENSET_SEQSTARTED1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetINTENSET_SEQEND0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetINTENSET_SEQEND0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetINTENSET_SEQEND1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetINTENSET_SEQEND1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetINTENSET_PWMPERIODEND(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetINTENSET_PWMPERIODEND() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetINTENSET_LOOPSDONE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetINTENSET_LOOPSDONE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}

// PWM.INTENCLR: Disable interrupt
func (o *PWM_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetINTENCLR_SEQSTARTED0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetINTENCLR_SEQSTARTED0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetINTENCLR_SEQSTARTED1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetINTENCLR_SEQSTARTED1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetINTENCLR_SEQEND0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetINTENCLR_SEQEND0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetINTENCLR_SEQEND1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetINTENCLR_SEQEND1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetINTENCLR_PWMPERIODEND(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetINTENCLR_PWMPERIODEND() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetINTENCLR_LOOPSDONE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetINTENCLR_LOOPSDONE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}

// PWM.ENABLE: PWM module enable register
func (o *PWM_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// PWM.MODE: Selects operating mode of the wave counter
func (o *PWM_Type) SetMODE_UPDOWN(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetMODE_UPDOWN() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x1
}

// PWM.COUNTERTOP: Value up to which the pulse generator counter counts
func (o *PWM_Type) SetCOUNTERTOP(value uint32) {
	volatile.StoreUint32(&o.COUNTERTOP.Reg, volatile.LoadUint32(&o.COUNTERTOP.Reg)&^(0x7fff)|value)
}
func (o *PWM_Type) GetCOUNTERTOP() uint32 {
	return volatile.LoadUint32(&o.COUNTERTOP.Reg) & 0x7fff
}

// PWM.PRESCALER: Configuration for PWM_CLK
func (o *PWM_Type) SetPRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESCALER.Reg, volatile.LoadUint32(&o.PRESCALER.Reg)&^(0x7)|value)
}
func (o *PWM_Type) GetPRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESCALER.Reg) & 0x7
}

// PWM.DECODER: Configuration of the decoder
func (o *PWM_Type) SetDECODER_LOAD(value uint32) {
	volatile.StoreUint32(&o.DECODER.Reg, volatile.LoadUint32(&o.DECODER.Reg)&^(0x3)|value)
}
func (o *PWM_Type) GetDECODER_LOAD() uint32 {
	return volatile.LoadUint32(&o.DECODER.Reg) & 0x3
}
func (o *PWM_Type) SetDECODER_MODE(value uint32) {
	volatile.StoreUint32(&o.DECODER.Reg, volatile.LoadUint32(&o.DECODER.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetDECODER_MODE() uint32 {
	return (volatile.LoadUint32(&o.DECODER.Reg) & 0x100) >> 8
}

// PWM.LOOP: Number of playbacks of a loop
func (o *PWM_Type) SetLOOP_CNT(value uint32) {
	volatile.StoreUint32(&o.LOOP.Reg, volatile.LoadUint32(&o.LOOP.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetLOOP_CNT() uint32 {
	return volatile.LoadUint32(&o.LOOP.Reg) & 0xffff
}

type PWM_SEQ_Type struct {
	PTR      volatile.Register32 // 0x520
	CNT      volatile.Register32 // 0x524
	REFRESH  volatile.Register32 // 0x528
	ENDDELAY volatile.Register32 // 0x52C
	_        [16]byte
}

// PWM_SEQ.PTR: Description cluster: Beginning address in RAM of this sequence
func (o *PWM_SEQ_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *PWM_SEQ_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// PWM_SEQ.CNT: Description cluster: Number of values (duty cycles) in this sequence
func (o *PWM_SEQ_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0x7fff)|value)
}
func (o *PWM_SEQ_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0x7fff
}

// PWM_SEQ.REFRESH: Description cluster: Number of additional PWM periods between samples loaded into compare register
func (o *PWM_SEQ_Type) SetREFRESH_CNT(value uint32) {
	volatile.StoreUint32(&o.REFRESH.Reg, volatile.LoadUint32(&o.REFRESH.Reg)&^(0xffffff)|value)
}
func (o *PWM_SEQ_Type) GetREFRESH_CNT() uint32 {
	return volatile.LoadUint32(&o.REFRESH.Reg) & 0xffffff
}

// PWM_SEQ.ENDDELAY: Description cluster: Time added after the sequence
func (o *PWM_SEQ_Type) SetENDDELAY_CNT(value uint32) {
	volatile.StoreUint32(&o.ENDDELAY.Reg, volatile.LoadUint32(&o.ENDDELAY.Reg)&^(0xffffff)|value)
}
func (o *PWM_SEQ_Type) GetENDDELAY_CNT() uint32 {
	return volatile.LoadUint32(&o.ENDDELAY.Reg) & 0xffffff
}

type PWM_PSEL_Type struct {
	OUT [4]volatile.Register32 // 0x560
}

// Pulse Density Modulation (Digital Microphone) Interface 0
type PDM_Type struct {
	TASKS_START     volatile.Register32 // 0x0
	TASKS_STOP      volatile.Register32 // 0x4
	_               [120]byte
	SUBSCRIBE_START volatile.Register32 // 0x80
	SUBSCRIBE_STOP  volatile.Register32 // 0x84
	_               [120]byte
	EVENTS_STARTED  volatile.Register32 // 0x100
	EVENTS_STOPPED  volatile.Register32 // 0x104
	EVENTS_END      volatile.Register32 // 0x108
	_               [116]byte
	PUBLISH_STARTED volatile.Register32 // 0x180
	PUBLISH_STOPPED volatile.Register32 // 0x184
	PUBLISH_END     volatile.Register32 // 0x188
	_               [372]byte
	INTEN           volatile.Register32 // 0x300
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [500]byte
	ENABLE          volatile.Register32 // 0x500
	PDMCLKCTRL      volatile.Register32 // 0x504
	MODE            volatile.Register32 // 0x508
	_               [12]byte
	GAINL           volatile.Register32 // 0x518
	GAINR           volatile.Register32 // 0x51C
	RATIO           volatile.Register32 // 0x520
	_               [28]byte
	PSEL            PDM_PSEL_Type // 0x540
	_               [4]byte
	MCLKCONFIG      volatile.Register32 // 0x54C
	_               [16]byte
	SAMPLE          PDM_SAMPLE_Type // 0x560
}

// PDM.TASKS_START: Starts continuous PDM transfer
func (o *PDM_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// PDM.TASKS_STOP: Stops PDM transfer
func (o *PDM_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// PDM.SUBSCRIBE_START: Subscribe configuration for task START
func (o *PDM_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xff)|value)
}
func (o *PDM_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xff
}
func (o *PDM_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *PDM_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// PDM.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *PDM_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *PDM_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *PDM_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *PDM_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// PDM.EVENTS_STARTED: PDM transfer has started
func (o *PDM_Type) SetEVENTS_STARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STARTED.Reg, volatile.LoadUint32(&o.EVENTS_STARTED.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetEVENTS_STARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STARTED.Reg) & 0x1
}

// PDM.EVENTS_STOPPED: PDM transfer has finished
func (o *PDM_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// PDM.EVENTS_END: The PDM has written the last sample specified by SAMPLE.MAXCNT (or the last sample after a STOP task has been received) to Data RAM
func (o *PDM_Type) SetEVENTS_END(value uint32) {
	volatile.StoreUint32(&o.EVENTS_END.Reg, volatile.LoadUint32(&o.EVENTS_END.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetEVENTS_END() uint32 {
	return volatile.LoadUint32(&o.EVENTS_END.Reg) & 0x1
}

// PDM.PUBLISH_STARTED: Publish configuration for event STARTED
func (o *PDM_Type) SetPUBLISH_STARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STARTED.Reg, volatile.LoadUint32(&o.PUBLISH_STARTED.Reg)&^(0xff)|value)
}
func (o *PDM_Type) GetPUBLISH_STARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STARTED.Reg) & 0xff
}
func (o *PDM_Type) SetPUBLISH_STARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STARTED.Reg, volatile.LoadUint32(&o.PUBLISH_STARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *PDM_Type) GetPUBLISH_STARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STARTED.Reg) & 0x80000000) >> 31
}

// PDM.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *PDM_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xff)|value)
}
func (o *PDM_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xff
}
func (o *PDM_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *PDM_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// PDM.PUBLISH_END: Publish configuration for event END
func (o *PDM_Type) SetPUBLISH_END_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0xff)|value)
}
func (o *PDM_Type) GetPUBLISH_END_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0xff
}
func (o *PDM_Type) SetPUBLISH_END_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0x80000000)|value<<31)
}
func (o *PDM_Type) GetPUBLISH_END_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0x80000000) >> 31
}

// PDM.INTEN: Enable or disable interrupt
func (o *PDM_Type) SetINTEN_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetINTEN_STARTED() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *PDM_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *PDM_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *PDM_Type) SetINTEN_END(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *PDM_Type) GetINTEN_END() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}

// PDM.INTENSET: Enable interrupt
func (o *PDM_Type) SetINTENSET_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetINTENSET_STARTED() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *PDM_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *PDM_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *PDM_Type) SetINTENSET_END(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *PDM_Type) GetINTENSET_END() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}

// PDM.INTENCLR: Disable interrupt
func (o *PDM_Type) SetINTENCLR_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetINTENCLR_STARTED() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *PDM_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *PDM_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *PDM_Type) SetINTENCLR_END(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *PDM_Type) GetINTENCLR_END() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}

// PDM.ENABLE: PDM module enable register
func (o *PDM_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// PDM.PDMCLKCTRL: PDM clock generator control
func (o *PDM_Type) SetPDMCLKCTRL(value uint32) {
	volatile.StoreUint32(&o.PDMCLKCTRL.Reg, value)
}
func (o *PDM_Type) GetPDMCLKCTRL() uint32 {
	return volatile.LoadUint32(&o.PDMCLKCTRL.Reg)
}

// PDM.MODE: Defines the routing of the connected PDM microphones' signals
func (o *PDM_Type) SetMODE_OPERATION(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetMODE_OPERATION() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x1
}
func (o *PDM_Type) SetMODE_EDGE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x2)|value<<1)
}
func (o *PDM_Type) GetMODE_EDGE() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x2) >> 1
}

// PDM.GAINL: Left output gain adjustment
func (o *PDM_Type) SetGAINL(value uint32) {
	volatile.StoreUint32(&o.GAINL.Reg, volatile.LoadUint32(&o.GAINL.Reg)&^(0x7f)|value)
}
func (o *PDM_Type) GetGAINL() uint32 {
	return volatile.LoadUint32(&o.GAINL.Reg) & 0x7f
}

// PDM.GAINR: Right output gain adjustment
func (o *PDM_Type) SetGAINR(value uint32) {
	volatile.StoreUint32(&o.GAINR.Reg, volatile.LoadUint32(&o.GAINR.Reg)&^(0x7f)|value)
}
func (o *PDM_Type) GetGAINR() uint32 {
	return volatile.LoadUint32(&o.GAINR.Reg) & 0x7f
}

// PDM.RATIO: Selects the ratio between PDM_CLK and output sample rate. Change PDMCLKCTRL accordingly.
func (o *PDM_Type) SetRATIO(value uint32) {
	volatile.StoreUint32(&o.RATIO.Reg, volatile.LoadUint32(&o.RATIO.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetRATIO() uint32 {
	return volatile.LoadUint32(&o.RATIO.Reg) & 0x1
}

// PDM.MCLKCONFIG: Master clock generator configuration
func (o *PDM_Type) SetMCLKCONFIG_SRC(value uint32) {
	volatile.StoreUint32(&o.MCLKCONFIG.Reg, volatile.LoadUint32(&o.MCLKCONFIG.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetMCLKCONFIG_SRC() uint32 {
	return volatile.LoadUint32(&o.MCLKCONFIG.Reg) & 0x1
}

type PDM_PSEL_Type struct {
	CLK volatile.Register32 // 0x540
	DIN volatile.Register32 // 0x544
}

// PDM_PSEL.CLK: Pin number configuration for PDM CLK signal
func (o *PDM_PSEL_Type) SetCLK_PIN(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x1f)|value)
}
func (o *PDM_PSEL_Type) GetCLK_PIN() uint32 {
	return volatile.LoadUint32(&o.CLK.Reg) & 0x1f
}
func (o *PDM_PSEL_Type) SetCLK_PORT(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x20)|value<<5)
}
func (o *PDM_PSEL_Type) GetCLK_PORT() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x20) >> 5
}
func (o *PDM_PSEL_Type) SetCLK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x80000000)|value<<31)
}
func (o *PDM_PSEL_Type) GetCLK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x80000000) >> 31
}

// PDM_PSEL.DIN: Pin number configuration for PDM DIN signal
func (o *PDM_PSEL_Type) SetDIN_PIN(value uint32) {
	volatile.StoreUint32(&o.DIN.Reg, volatile.LoadUint32(&o.DIN.Reg)&^(0x1f)|value)
}
func (o *PDM_PSEL_Type) GetDIN_PIN() uint32 {
	return volatile.LoadUint32(&o.DIN.Reg) & 0x1f
}
func (o *PDM_PSEL_Type) SetDIN_PORT(value uint32) {
	volatile.StoreUint32(&o.DIN.Reg, volatile.LoadUint32(&o.DIN.Reg)&^(0x20)|value<<5)
}
func (o *PDM_PSEL_Type) GetDIN_PORT() uint32 {
	return (volatile.LoadUint32(&o.DIN.Reg) & 0x20) >> 5
}
func (o *PDM_PSEL_Type) SetDIN_CONNECT(value uint32) {
	volatile.StoreUint32(&o.DIN.Reg, volatile.LoadUint32(&o.DIN.Reg)&^(0x80000000)|value<<31)
}
func (o *PDM_PSEL_Type) GetDIN_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.DIN.Reg) & 0x80000000) >> 31
}

type PDM_SAMPLE_Type struct {
	PTR    volatile.Register32 // 0x560
	MAXCNT volatile.Register32 // 0x564
}

// PDM_SAMPLE.PTR: RAM address pointer to write samples to with EasyDMA
func (o *PDM_SAMPLE_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *PDM_SAMPLE_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// PDM_SAMPLE.MAXCNT: Number of samples to allocate memory for in EasyDMA mode
func (o *PDM_SAMPLE_Type) SetMAXCNT_BUFFSIZE(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x7fff)|value)
}
func (o *PDM_SAMPLE_Type) GetMAXCNT_BUFFSIZE() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x7fff
}

// Inter-IC Sound 0
type I2S_Type struct {
	TASKS_START        volatile.Register32 // 0x0
	TASKS_STOP         volatile.Register32 // 0x4
	_                  [120]byte
	SUBSCRIBE_START    volatile.Register32 // 0x80
	SUBSCRIBE_STOP     volatile.Register32 // 0x84
	_                  [124]byte
	EVENTS_RXPTRUPD    volatile.Register32 // 0x104
	EVENTS_STOPPED     volatile.Register32 // 0x108
	_                  [8]byte
	EVENTS_TXPTRUPD    volatile.Register32 // 0x114
	_                  [4]byte
	EVENTS_FRAMESTART  volatile.Register32 // 0x11C
	_                  [100]byte
	PUBLISH_RXPTRUPD   volatile.Register32 // 0x184
	PUBLISH_STOPPED    volatile.Register32 // 0x188
	_                  [8]byte
	PUBLISH_TXPTRUPD   volatile.Register32 // 0x194
	_                  [4]byte
	PUBLISH_FRAMESTART volatile.Register32 // 0x19C
	_                  [352]byte
	INTEN              volatile.Register32 // 0x300
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [500]byte
	ENABLE             volatile.Register32 // 0x500
	CONFIG             I2S_CONFIG_Type     // 0x504
	_                  [8]byte
	RXD                I2S_RXD_Type // 0x538
	_                  [4]byte
	TXD                I2S_TXD_Type // 0x540
	_                  [12]byte
	RXTXD              I2S_RXTXD_Type // 0x550
	_                  [12]byte
	PSEL               I2S_PSEL_Type // 0x560
}

// I2S.TASKS_START: Starts continuous I2S transfer. Also starts MCK generator when this is enabled
func (o *I2S_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// I2S.TASKS_STOP: Stops I2S transfer and MCK generator. Triggering this task will cause the event STOPPED to be generated.
func (o *I2S_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// I2S.SUBSCRIBE_START: Subscribe configuration for task START
func (o *I2S_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xff)|value)
}
func (o *I2S_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xff
}
func (o *I2S_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// I2S.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *I2S_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *I2S_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *I2S_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// I2S.EVENTS_RXPTRUPD: The RXD.PTR register has been copied to internal double-buffers. When the I2S module is started and RX is enabled, this event will be generated for every RXTXD.MAXCNT words received on the SDIN pin.
func (o *I2S_Type) SetEVENTS_RXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXPTRUPD.Reg, volatile.LoadUint32(&o.EVENTS_RXPTRUPD.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetEVENTS_RXPTRUPD() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXPTRUPD.Reg) & 0x1
}

// I2S.EVENTS_STOPPED: I2S transfer stopped.
func (o *I2S_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// I2S.EVENTS_TXPTRUPD: The TDX.PTR register has been copied to internal double-buffers. When the I2S module is started and TX is enabled, this event will be generated for every RXTXD.MAXCNT words that are sent on the SDOUT pin.
func (o *I2S_Type) SetEVENTS_TXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXPTRUPD.Reg, volatile.LoadUint32(&o.EVENTS_TXPTRUPD.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetEVENTS_TXPTRUPD() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXPTRUPD.Reg) & 0x1
}

// I2S.EVENTS_FRAMESTART: Frame start event, generated on the active edge of LRCK
func (o *I2S_Type) SetEVENTS_FRAMESTART(value uint32) {
	volatile.StoreUint32(&o.EVENTS_FRAMESTART.Reg, volatile.LoadUint32(&o.EVENTS_FRAMESTART.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetEVENTS_FRAMESTART() uint32 {
	return volatile.LoadUint32(&o.EVENTS_FRAMESTART.Reg) & 0x1
}

// I2S.PUBLISH_RXPTRUPD: Publish configuration for event RXPTRUPD
func (o *I2S_Type) SetPUBLISH_RXPTRUPD_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXPTRUPD.Reg, volatile.LoadUint32(&o.PUBLISH_RXPTRUPD.Reg)&^(0xff)|value)
}
func (o *I2S_Type) GetPUBLISH_RXPTRUPD_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXPTRUPD.Reg) & 0xff
}
func (o *I2S_Type) SetPUBLISH_RXPTRUPD_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXPTRUPD.Reg, volatile.LoadUint32(&o.PUBLISH_RXPTRUPD.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetPUBLISH_RXPTRUPD_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXPTRUPD.Reg) & 0x80000000) >> 31
}

// I2S.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *I2S_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xff)|value)
}
func (o *I2S_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xff
}
func (o *I2S_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// I2S.PUBLISH_TXPTRUPD: Publish configuration for event TXPTRUPD
func (o *I2S_Type) SetPUBLISH_TXPTRUPD_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXPTRUPD.Reg, volatile.LoadUint32(&o.PUBLISH_TXPTRUPD.Reg)&^(0xff)|value)
}
func (o *I2S_Type) GetPUBLISH_TXPTRUPD_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXPTRUPD.Reg) & 0xff
}
func (o *I2S_Type) SetPUBLISH_TXPTRUPD_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXPTRUPD.Reg, volatile.LoadUint32(&o.PUBLISH_TXPTRUPD.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetPUBLISH_TXPTRUPD_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXPTRUPD.Reg) & 0x80000000) >> 31
}

// I2S.PUBLISH_FRAMESTART: Publish configuration for event FRAMESTART
func (o *I2S_Type) SetPUBLISH_FRAMESTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_FRAMESTART.Reg, volatile.LoadUint32(&o.PUBLISH_FRAMESTART.Reg)&^(0xff)|value)
}
func (o *I2S_Type) GetPUBLISH_FRAMESTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_FRAMESTART.Reg) & 0xff
}
func (o *I2S_Type) SetPUBLISH_FRAMESTART_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_FRAMESTART.Reg, volatile.LoadUint32(&o.PUBLISH_FRAMESTART.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetPUBLISH_FRAMESTART_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_FRAMESTART.Reg) & 0x80000000) >> 31
}

// I2S.INTEN: Enable or disable interrupt
func (o *I2S_Type) SetINTEN_RXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINTEN_RXPTRUPD() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINTEN_TXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINTEN_TXPTRUPD() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetINTEN_FRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetINTEN_FRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}

// I2S.INTENSET: Enable interrupt
func (o *I2S_Type) SetINTENSET_RXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINTENSET_RXPTRUPD() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINTENSET_TXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINTENSET_TXPTRUPD() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetINTENSET_FRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetINTENSET_FRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}

// I2S.INTENCLR: Disable interrupt
func (o *I2S_Type) SetINTENCLR_RXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINTENCLR_RXPTRUPD() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINTENCLR_TXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINTENCLR_TXPTRUPD() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetINTENCLR_FRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetINTENCLR_FRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}

// I2S.ENABLE: Enable I2S module
func (o *I2S_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

type I2S_CONFIG_Type struct {
	MODE      volatile.Register32 // 0x504
	RXEN      volatile.Register32 // 0x508
	TXEN      volatile.Register32 // 0x50C
	MCKEN     volatile.Register32 // 0x510
	MCKFREQ   volatile.Register32 // 0x514
	RATIO     volatile.Register32 // 0x518
	SWIDTH    volatile.Register32 // 0x51C
	ALIGN     volatile.Register32 // 0x520
	FORMAT    volatile.Register32 // 0x524
	CHANNELS  volatile.Register32 // 0x528
	CLKCONFIG volatile.Register32 // 0x52C
}

// I2S_CONFIG.MODE: I2S mode
func (o *I2S_CONFIG_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x1
}

// I2S_CONFIG.RXEN: Reception (RX) enable
func (o *I2S_CONFIG_Type) SetRXEN(value uint32) {
	volatile.StoreUint32(&o.RXEN.Reg, volatile.LoadUint32(&o.RXEN.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetRXEN() uint32 {
	return volatile.LoadUint32(&o.RXEN.Reg) & 0x1
}

// I2S_CONFIG.TXEN: Transmission (TX) enable
func (o *I2S_CONFIG_Type) SetTXEN(value uint32) {
	volatile.StoreUint32(&o.TXEN.Reg, volatile.LoadUint32(&o.TXEN.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetTXEN() uint32 {
	return volatile.LoadUint32(&o.TXEN.Reg) & 0x1
}

// I2S_CONFIG.MCKEN: Master clock generator enable
func (o *I2S_CONFIG_Type) SetMCKEN(value uint32) {
	volatile.StoreUint32(&o.MCKEN.Reg, volatile.LoadUint32(&o.MCKEN.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetMCKEN() uint32 {
	return volatile.LoadUint32(&o.MCKEN.Reg) & 0x1
}

// I2S_CONFIG.MCKFREQ: I2S clock generator control
func (o *I2S_CONFIG_Type) SetMCKFREQ(value uint32) {
	volatile.StoreUint32(&o.MCKFREQ.Reg, value)
}
func (o *I2S_CONFIG_Type) GetMCKFREQ() uint32 {
	return volatile.LoadUint32(&o.MCKFREQ.Reg)
}

// I2S_CONFIG.RATIO: MCK / LRCK ratio
func (o *I2S_CONFIG_Type) SetRATIO(value uint32) {
	volatile.StoreUint32(&o.RATIO.Reg, volatile.LoadUint32(&o.RATIO.Reg)&^(0xf)|value)
}
func (o *I2S_CONFIG_Type) GetRATIO() uint32 {
	return volatile.LoadUint32(&o.RATIO.Reg) & 0xf
}

// I2S_CONFIG.SWIDTH: Sample width
func (o *I2S_CONFIG_Type) SetSWIDTH(value uint32) {
	volatile.StoreUint32(&o.SWIDTH.Reg, volatile.LoadUint32(&o.SWIDTH.Reg)&^(0x7)|value)
}
func (o *I2S_CONFIG_Type) GetSWIDTH() uint32 {
	return volatile.LoadUint32(&o.SWIDTH.Reg) & 0x7
}

// I2S_CONFIG.ALIGN: Alignment of sample within a frame
func (o *I2S_CONFIG_Type) SetALIGN(value uint32) {
	volatile.StoreUint32(&o.ALIGN.Reg, volatile.LoadUint32(&o.ALIGN.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetALIGN() uint32 {
	return volatile.LoadUint32(&o.ALIGN.Reg) & 0x1
}

// I2S_CONFIG.FORMAT: Frame format
func (o *I2S_CONFIG_Type) SetFORMAT(value uint32) {
	volatile.StoreUint32(&o.FORMAT.Reg, volatile.LoadUint32(&o.FORMAT.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetFORMAT() uint32 {
	return volatile.LoadUint32(&o.FORMAT.Reg) & 0x1
}

// I2S_CONFIG.CHANNELS: Enable channels
func (o *I2S_CONFIG_Type) SetCHANNELS(value uint32) {
	volatile.StoreUint32(&o.CHANNELS.Reg, volatile.LoadUint32(&o.CHANNELS.Reg)&^(0x3)|value)
}
func (o *I2S_CONFIG_Type) GetCHANNELS() uint32 {
	return volatile.LoadUint32(&o.CHANNELS.Reg) & 0x3
}

// I2S_CONFIG.CLKCONFIG: Clock source selection for the I2S module
func (o *I2S_CONFIG_Type) SetCLKCONFIG_CLKSRC(value uint32) {
	volatile.StoreUint32(&o.CLKCONFIG.Reg, volatile.LoadUint32(&o.CLKCONFIG.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetCLKCONFIG_CLKSRC() uint32 {
	return volatile.LoadUint32(&o.CLKCONFIG.Reg) & 0x1
}
func (o *I2S_CONFIG_Type) SetCLKCONFIG_BYPASS(value uint32) {
	volatile.StoreUint32(&o.CLKCONFIG.Reg, volatile.LoadUint32(&o.CLKCONFIG.Reg)&^(0x100)|value<<8)
}
func (o *I2S_CONFIG_Type) GetCLKCONFIG_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.CLKCONFIG.Reg) & 0x100) >> 8
}

type I2S_RXD_Type struct {
	PTR volatile.Register32 // 0x538
}

// I2S_RXD.PTR: Receive buffer RAM start address.
func (o *I2S_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *I2S_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

type I2S_TXD_Type struct {
	PTR volatile.Register32 // 0x540
}

// I2S_TXD.PTR: Transmit buffer RAM start address
func (o *I2S_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *I2S_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

type I2S_RXTXD_Type struct {
	MAXCNT volatile.Register32 // 0x550
}

// I2S_RXTXD.MAXCNT: Size of RXD and TXD buffers
func (o *I2S_RXTXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x3fff)|value)
}
func (o *I2S_RXTXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x3fff
}

type I2S_PSEL_Type struct {
	MCK   volatile.Register32 // 0x560
	SCK   volatile.Register32 // 0x564
	LRCK  volatile.Register32 // 0x568
	SDIN  volatile.Register32 // 0x56C
	SDOUT volatile.Register32 // 0x570
}

// I2S_PSEL.MCK: Pin select for MCK signal
func (o *I2S_PSEL_Type) SetMCK_PIN(value uint32) {
	volatile.StoreUint32(&o.MCK.Reg, volatile.LoadUint32(&o.MCK.Reg)&^(0x1f)|value)
}
func (o *I2S_PSEL_Type) GetMCK_PIN() uint32 {
	return volatile.LoadUint32(&o.MCK.Reg) & 0x1f
}
func (o *I2S_PSEL_Type) SetMCK_PORT(value uint32) {
	volatile.StoreUint32(&o.MCK.Reg, volatile.LoadUint32(&o.MCK.Reg)&^(0x20)|value<<5)
}
func (o *I2S_PSEL_Type) GetMCK_PORT() uint32 {
	return (volatile.LoadUint32(&o.MCK.Reg) & 0x20) >> 5
}
func (o *I2S_PSEL_Type) SetMCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MCK.Reg, volatile.LoadUint32(&o.MCK.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_PSEL_Type) GetMCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MCK.Reg) & 0x80000000) >> 31
}

// I2S_PSEL.SCK: Pin select for SCK signal
func (o *I2S_PSEL_Type) SetSCK_PIN(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x1f)|value)
}
func (o *I2S_PSEL_Type) GetSCK_PIN() uint32 {
	return volatile.LoadUint32(&o.SCK.Reg) & 0x1f
}
func (o *I2S_PSEL_Type) SetSCK_PORT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x20)|value<<5)
}
func (o *I2S_PSEL_Type) GetSCK_PORT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x20) >> 5
}
func (o *I2S_PSEL_Type) SetSCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_PSEL_Type) GetSCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x80000000) >> 31
}

// I2S_PSEL.LRCK: Pin select for LRCK signal
func (o *I2S_PSEL_Type) SetLRCK_PIN(value uint32) {
	volatile.StoreUint32(&o.LRCK.Reg, volatile.LoadUint32(&o.LRCK.Reg)&^(0x1f)|value)
}
func (o *I2S_PSEL_Type) GetLRCK_PIN() uint32 {
	return volatile.LoadUint32(&o.LRCK.Reg) & 0x1f
}
func (o *I2S_PSEL_Type) SetLRCK_PORT(value uint32) {
	volatile.StoreUint32(&o.LRCK.Reg, volatile.LoadUint32(&o.LRCK.Reg)&^(0x20)|value<<5)
}
func (o *I2S_PSEL_Type) GetLRCK_PORT() uint32 {
	return (volatile.LoadUint32(&o.LRCK.Reg) & 0x20) >> 5
}
func (o *I2S_PSEL_Type) SetLRCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.LRCK.Reg, volatile.LoadUint32(&o.LRCK.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_PSEL_Type) GetLRCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.LRCK.Reg) & 0x80000000) >> 31
}

// I2S_PSEL.SDIN: Pin select for SDIN signal
func (o *I2S_PSEL_Type) SetSDIN_PIN(value uint32) {
	volatile.StoreUint32(&o.SDIN.Reg, volatile.LoadUint32(&o.SDIN.Reg)&^(0x1f)|value)
}
func (o *I2S_PSEL_Type) GetSDIN_PIN() uint32 {
	return volatile.LoadUint32(&o.SDIN.Reg) & 0x1f
}
func (o *I2S_PSEL_Type) SetSDIN_PORT(value uint32) {
	volatile.StoreUint32(&o.SDIN.Reg, volatile.LoadUint32(&o.SDIN.Reg)&^(0x20)|value<<5)
}
func (o *I2S_PSEL_Type) GetSDIN_PORT() uint32 {
	return (volatile.LoadUint32(&o.SDIN.Reg) & 0x20) >> 5
}
func (o *I2S_PSEL_Type) SetSDIN_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SDIN.Reg, volatile.LoadUint32(&o.SDIN.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_PSEL_Type) GetSDIN_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SDIN.Reg) & 0x80000000) >> 31
}

// I2S_PSEL.SDOUT: Pin select for SDOUT signal
func (o *I2S_PSEL_Type) SetSDOUT_PIN(value uint32) {
	volatile.StoreUint32(&o.SDOUT.Reg, volatile.LoadUint32(&o.SDOUT.Reg)&^(0x1f)|value)
}
func (o *I2S_PSEL_Type) GetSDOUT_PIN() uint32 {
	return volatile.LoadUint32(&o.SDOUT.Reg) & 0x1f
}
func (o *I2S_PSEL_Type) SetSDOUT_PORT(value uint32) {
	volatile.StoreUint32(&o.SDOUT.Reg, volatile.LoadUint32(&o.SDOUT.Reg)&^(0x20)|value<<5)
}
func (o *I2S_PSEL_Type) GetSDOUT_PORT() uint32 {
	return (volatile.LoadUint32(&o.SDOUT.Reg) & 0x20) >> 5
}
func (o *I2S_PSEL_Type) SetSDOUT_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SDOUT.Reg, volatile.LoadUint32(&o.SDOUT.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_PSEL_Type) GetSDOUT_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SDOUT.Reg) & 0x80000000) >> 31
}

// Interprocessor communication 0
type IPC_Type struct {
	TASKS_SEND      [16]volatile.Register32 // 0x0
	_               [64]byte
	SUBSCRIBE_SEND  [16]volatile.Register32 // 0x80
	_               [64]byte
	EVENTS_RECEIVE  [16]volatile.Register32 // 0x100
	_               [64]byte
	PUBLISH_RECEIVE [16]volatile.Register32 // 0x180
	_               [320]byte
	INTEN           volatile.Register32 // 0x300
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	INTPEND         volatile.Register32 // 0x30C
	_               [512]byte
	SEND_CNF        [16]volatile.Register32 // 0x510
	_               [64]byte
	RECEIVE_CNF     [16]volatile.Register32 // 0x590
	_               [64]byte
	GPMEM           [2]volatile.Register32 // 0x610
}

// IPC.TASKS_SEND: Description collection: Trigger events on IPC channel enabled in SEND_CNF[n]
func (o *IPC_Type) SetTASKS_SEND(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_SEND[idx].Reg, volatile.LoadUint32(&o.TASKS_SEND[idx].Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetTASKS_SEND(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_SEND[idx].Reg) & 0x1
}

// IPC.SUBSCRIBE_SEND: Description collection: Subscribe configuration for task SEND[n]
func (o *IPC_Type) SetSUBSCRIBE_SEND_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SEND[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_SEND[idx].Reg)&^(0xff)|value)
}
func (o *IPC_Type) GetSUBSCRIBE_SEND_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SEND[idx].Reg) & 0xff
}
func (o *IPC_Type) SetSUBSCRIBE_SEND_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SEND[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_SEND[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *IPC_Type) GetSUBSCRIBE_SEND_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SEND[idx].Reg) & 0x80000000) >> 31
}

// IPC.EVENTS_RECEIVE: Description collection: Event received on one or more of the enabled IPC channels in RECEIVE_CNF[n]
func (o *IPC_Type) SetEVENTS_RECEIVE(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_RECEIVE[idx].Reg, volatile.LoadUint32(&o.EVENTS_RECEIVE[idx].Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetEVENTS_RECEIVE(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_RECEIVE[idx].Reg) & 0x1
}

// IPC.PUBLISH_RECEIVE: Description collection: Publish configuration for event RECEIVE[n]
func (o *IPC_Type) SetPUBLISH_RECEIVE_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RECEIVE[idx].Reg, volatile.LoadUint32(&o.PUBLISH_RECEIVE[idx].Reg)&^(0xff)|value)
}
func (o *IPC_Type) GetPUBLISH_RECEIVE_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RECEIVE[idx].Reg) & 0xff
}
func (o *IPC_Type) SetPUBLISH_RECEIVE_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RECEIVE[idx].Reg, volatile.LoadUint32(&o.PUBLISH_RECEIVE[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *IPC_Type) GetPUBLISH_RECEIVE_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RECEIVE[idx].Reg) & 0x80000000) >> 31
}

// IPC.INTEN: Enable or disable interrupt
func (o *IPC_Type) SetINTEN_RECEIVE0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetINTEN_RECEIVE0() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *IPC_Type) SetINTEN_RECEIVE1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *IPC_Type) GetINTEN_RECEIVE1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *IPC_Type) SetINTEN_RECEIVE2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *IPC_Type) GetINTEN_RECEIVE2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *IPC_Type) SetINTEN_RECEIVE3(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *IPC_Type) GetINTEN_RECEIVE3() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *IPC_Type) SetINTEN_RECEIVE4(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *IPC_Type) GetINTEN_RECEIVE4() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *IPC_Type) SetINTEN_RECEIVE5(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *IPC_Type) GetINTEN_RECEIVE5() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *IPC_Type) SetINTEN_RECEIVE6(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *IPC_Type) GetINTEN_RECEIVE6() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *IPC_Type) SetINTEN_RECEIVE7(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *IPC_Type) GetINTEN_RECEIVE7() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *IPC_Type) SetINTEN_RECEIVE8(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *IPC_Type) GetINTEN_RECEIVE8() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *IPC_Type) SetINTEN_RECEIVE9(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *IPC_Type) GetINTEN_RECEIVE9() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *IPC_Type) SetINTEN_RECEIVE10(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400)|value<<10)
}
func (o *IPC_Type) GetINTEN_RECEIVE10() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400) >> 10
}
func (o *IPC_Type) SetINTEN_RECEIVE11(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800)|value<<11)
}
func (o *IPC_Type) GetINTEN_RECEIVE11() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800) >> 11
}
func (o *IPC_Type) SetINTEN_RECEIVE12(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000)|value<<12)
}
func (o *IPC_Type) GetINTEN_RECEIVE12() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000) >> 12
}
func (o *IPC_Type) SetINTEN_RECEIVE13(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2000)|value<<13)
}
func (o *IPC_Type) GetINTEN_RECEIVE13() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2000) >> 13
}
func (o *IPC_Type) SetINTEN_RECEIVE14(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000)|value<<14)
}
func (o *IPC_Type) GetINTEN_RECEIVE14() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000) >> 14
}
func (o *IPC_Type) SetINTEN_RECEIVE15(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8000)|value<<15)
}
func (o *IPC_Type) GetINTEN_RECEIVE15() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8000) >> 15
}

// IPC.INTENSET: Enable interrupt
func (o *IPC_Type) SetINTENSET_RECEIVE0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetINTENSET_RECEIVE0() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *IPC_Type) SetINTENSET_RECEIVE1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *IPC_Type) GetINTENSET_RECEIVE1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *IPC_Type) SetINTENSET_RECEIVE2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *IPC_Type) GetINTENSET_RECEIVE2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *IPC_Type) SetINTENSET_RECEIVE3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *IPC_Type) GetINTENSET_RECEIVE3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *IPC_Type) SetINTENSET_RECEIVE4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *IPC_Type) GetINTENSET_RECEIVE4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *IPC_Type) SetINTENSET_RECEIVE5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *IPC_Type) GetINTENSET_RECEIVE5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *IPC_Type) SetINTENSET_RECEIVE6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *IPC_Type) GetINTENSET_RECEIVE6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *IPC_Type) SetINTENSET_RECEIVE7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *IPC_Type) GetINTENSET_RECEIVE7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *IPC_Type) SetINTENSET_RECEIVE8(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *IPC_Type) GetINTENSET_RECEIVE8() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *IPC_Type) SetINTENSET_RECEIVE9(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *IPC_Type) GetINTENSET_RECEIVE9() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *IPC_Type) SetINTENSET_RECEIVE10(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *IPC_Type) GetINTENSET_RECEIVE10() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *IPC_Type) SetINTENSET_RECEIVE11(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *IPC_Type) GetINTENSET_RECEIVE11() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *IPC_Type) SetINTENSET_RECEIVE12(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *IPC_Type) GetINTENSET_RECEIVE12() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *IPC_Type) SetINTENSET_RECEIVE13(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *IPC_Type) GetINTENSET_RECEIVE13() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *IPC_Type) SetINTENSET_RECEIVE14(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *IPC_Type) GetINTENSET_RECEIVE14() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *IPC_Type) SetINTENSET_RECEIVE15(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *IPC_Type) GetINTENSET_RECEIVE15() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}

// IPC.INTENCLR: Disable interrupt
func (o *IPC_Type) SetINTENCLR_RECEIVE0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE0() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *IPC_Type) SetINTENCLR_RECEIVE1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *IPC_Type) SetINTENCLR_RECEIVE2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *IPC_Type) SetINTENCLR_RECEIVE3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *IPC_Type) SetINTENCLR_RECEIVE4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *IPC_Type) SetINTENCLR_RECEIVE5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *IPC_Type) SetINTENCLR_RECEIVE6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *IPC_Type) SetINTENCLR_RECEIVE7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *IPC_Type) SetINTENCLR_RECEIVE8(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE8() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *IPC_Type) SetINTENCLR_RECEIVE9(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE9() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *IPC_Type) SetINTENCLR_RECEIVE10(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE10() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *IPC_Type) SetINTENCLR_RECEIVE11(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE11() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *IPC_Type) SetINTENCLR_RECEIVE12(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE12() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *IPC_Type) SetINTENCLR_RECEIVE13(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE13() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *IPC_Type) SetINTENCLR_RECEIVE14(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE14() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *IPC_Type) SetINTENCLR_RECEIVE15(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE15() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}

// IPC.INTPEND: Pending interrupts
func (o *IPC_Type) SetINTPEND_RECEIVE0(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetINTPEND_RECEIVE0() uint32 {
	return volatile.LoadUint32(&o.INTPEND.Reg) & 0x1
}
func (o *IPC_Type) SetINTPEND_RECEIVE1(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x2)|value<<1)
}
func (o *IPC_Type) GetINTPEND_RECEIVE1() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x2) >> 1
}
func (o *IPC_Type) SetINTPEND_RECEIVE2(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x4)|value<<2)
}
func (o *IPC_Type) GetINTPEND_RECEIVE2() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x4) >> 2
}
func (o *IPC_Type) SetINTPEND_RECEIVE3(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x8)|value<<3)
}
func (o *IPC_Type) GetINTPEND_RECEIVE3() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x8) >> 3
}
func (o *IPC_Type) SetINTPEND_RECEIVE4(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x10)|value<<4)
}
func (o *IPC_Type) GetINTPEND_RECEIVE4() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x10) >> 4
}
func (o *IPC_Type) SetINTPEND_RECEIVE5(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x20)|value<<5)
}
func (o *IPC_Type) GetINTPEND_RECEIVE5() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x20) >> 5
}
func (o *IPC_Type) SetINTPEND_RECEIVE6(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x40)|value<<6)
}
func (o *IPC_Type) GetINTPEND_RECEIVE6() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x40) >> 6
}
func (o *IPC_Type) SetINTPEND_RECEIVE7(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x80)|value<<7)
}
func (o *IPC_Type) GetINTPEND_RECEIVE7() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x80) >> 7
}
func (o *IPC_Type) SetINTPEND_RECEIVE8(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x100)|value<<8)
}
func (o *IPC_Type) GetINTPEND_RECEIVE8() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x100) >> 8
}
func (o *IPC_Type) SetINTPEND_RECEIVE9(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x200)|value<<9)
}
func (o *IPC_Type) GetINTPEND_RECEIVE9() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x200) >> 9
}
func (o *IPC_Type) SetINTPEND_RECEIVE10(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x400)|value<<10)
}
func (o *IPC_Type) GetINTPEND_RECEIVE10() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x400) >> 10
}
func (o *IPC_Type) SetINTPEND_RECEIVE11(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x800)|value<<11)
}
func (o *IPC_Type) GetINTPEND_RECEIVE11() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x800) >> 11
}
func (o *IPC_Type) SetINTPEND_RECEIVE12(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x1000)|value<<12)
}
func (o *IPC_Type) GetINTPEND_RECEIVE12() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x1000) >> 12
}
func (o *IPC_Type) SetINTPEND_RECEIVE13(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x2000)|value<<13)
}
func (o *IPC_Type) GetINTPEND_RECEIVE13() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x2000) >> 13
}
func (o *IPC_Type) SetINTPEND_RECEIVE14(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x4000)|value<<14)
}
func (o *IPC_Type) GetINTPEND_RECEIVE14() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x4000) >> 14
}
func (o *IPC_Type) SetINTPEND_RECEIVE15(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x8000)|value<<15)
}
func (o *IPC_Type) GetINTPEND_RECEIVE15() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x8000) >> 15
}

// IPC.SEND_CNF: Description collection: Send event configuration for TASKS_SEND[n]
func (o *IPC_Type) SetSEND_CNF_CHEN0(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetSEND_CNF_CHEN0(idx int) uint32 {
	return volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x1
}
func (o *IPC_Type) SetSEND_CNF_CHEN1(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x2)|value<<1)
}
func (o *IPC_Type) GetSEND_CNF_CHEN1(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x2) >> 1
}
func (o *IPC_Type) SetSEND_CNF_CHEN2(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x4)|value<<2)
}
func (o *IPC_Type) GetSEND_CNF_CHEN2(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x4) >> 2
}
func (o *IPC_Type) SetSEND_CNF_CHEN3(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x8)|value<<3)
}
func (o *IPC_Type) GetSEND_CNF_CHEN3(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x8) >> 3
}
func (o *IPC_Type) SetSEND_CNF_CHEN4(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x10)|value<<4)
}
func (o *IPC_Type) GetSEND_CNF_CHEN4(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x10) >> 4
}
func (o *IPC_Type) SetSEND_CNF_CHEN5(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x20)|value<<5)
}
func (o *IPC_Type) GetSEND_CNF_CHEN5(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x20) >> 5
}
func (o *IPC_Type) SetSEND_CNF_CHEN6(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x40)|value<<6)
}
func (o *IPC_Type) GetSEND_CNF_CHEN6(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x40) >> 6
}
func (o *IPC_Type) SetSEND_CNF_CHEN7(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x80)|value<<7)
}
func (o *IPC_Type) GetSEND_CNF_CHEN7(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x80) >> 7
}
func (o *IPC_Type) SetSEND_CNF_CHEN8(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x100)|value<<8)
}
func (o *IPC_Type) GetSEND_CNF_CHEN8(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x100) >> 8
}
func (o *IPC_Type) SetSEND_CNF_CHEN9(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x200)|value<<9)
}
func (o *IPC_Type) GetSEND_CNF_CHEN9(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x200) >> 9
}
func (o *IPC_Type) SetSEND_CNF_CHEN10(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x400)|value<<10)
}
func (o *IPC_Type) GetSEND_CNF_CHEN10(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x400) >> 10
}
func (o *IPC_Type) SetSEND_CNF_CHEN11(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x800)|value<<11)
}
func (o *IPC_Type) GetSEND_CNF_CHEN11(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x800) >> 11
}
func (o *IPC_Type) SetSEND_CNF_CHEN12(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x1000)|value<<12)
}
func (o *IPC_Type) GetSEND_CNF_CHEN12(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x1000) >> 12
}
func (o *IPC_Type) SetSEND_CNF_CHEN13(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x2000)|value<<13)
}
func (o *IPC_Type) GetSEND_CNF_CHEN13(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x2000) >> 13
}
func (o *IPC_Type) SetSEND_CNF_CHEN14(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x4000)|value<<14)
}
func (o *IPC_Type) GetSEND_CNF_CHEN14(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x4000) >> 14
}
func (o *IPC_Type) SetSEND_CNF_CHEN15(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x8000)|value<<15)
}
func (o *IPC_Type) GetSEND_CNF_CHEN15(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x8000) >> 15
}

// IPC.RECEIVE_CNF: Description collection: Receive event configuration for EVENTS_RECEIVE[n]
func (o *IPC_Type) SetRECEIVE_CNF_CHEN0(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN0(idx int) uint32 {
	return volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x1
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN1(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x2)|value<<1)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN1(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x2) >> 1
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN2(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x4)|value<<2)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN2(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x4) >> 2
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN3(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x8)|value<<3)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN3(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x8) >> 3
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN4(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x10)|value<<4)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN4(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x10) >> 4
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN5(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x20)|value<<5)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN5(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x20) >> 5
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN6(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x40)|value<<6)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN6(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x40) >> 6
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN7(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x80)|value<<7)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN7(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x80) >> 7
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN8(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x100)|value<<8)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN8(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x100) >> 8
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN9(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x200)|value<<9)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN9(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x200) >> 9
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN10(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x400)|value<<10)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN10(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x400) >> 10
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN11(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x800)|value<<11)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN11(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x800) >> 11
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN12(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x1000)|value<<12)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN12(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x1000) >> 12
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN13(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x2000)|value<<13)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN13(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x2000) >> 13
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN14(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x4000)|value<<14)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN14(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x4000) >> 14
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN15(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x8000)|value<<15)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN15(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x8000) >> 15
}

// IPC.GPMEM: Description collection: General purpose memory
func (o *IPC_Type) SetGPMEM(idx int, value uint32) {
	volatile.StoreUint32(&o.GPMEM[idx].Reg, value)
}
func (o *IPC_Type) GetGPMEM(idx int) uint32 {
	return volatile.LoadUint32(&o.GPMEM[idx].Reg)
}

// External flash interface 0
type QSPI_Type struct {
	TASKS_ACTIVATE       volatile.Register32 // 0x0
	TASKS_READSTART      volatile.Register32 // 0x4
	TASKS_WRITESTART     volatile.Register32 // 0x8
	TASKS_ERASESTART     volatile.Register32 // 0xC
	TASKS_DEACTIVATE     volatile.Register32 // 0x10
	_                    [108]byte
	SUBSCRIBE_ACTIVATE   volatile.Register32 // 0x80
	SUBSCRIBE_READSTART  volatile.Register32 // 0x84
	SUBSCRIBE_WRITESTART volatile.Register32 // 0x88
	SUBSCRIBE_ERASESTART volatile.Register32 // 0x8C
	SUBSCRIBE_DEACTIVATE volatile.Register32 // 0x90
	_                    [108]byte
	EVENTS_READY         volatile.Register32 // 0x100
	_                    [124]byte
	PUBLISH_READY        volatile.Register32 // 0x180
	_                    [380]byte
	INTEN                volatile.Register32 // 0x300
	INTENSET             volatile.Register32 // 0x304
	INTENCLR             volatile.Register32 // 0x308
	_                    [500]byte
	ENABLE               volatile.Register32 // 0x500
	READ                 QSPI_READ_Type      // 0x504
	WRITE                QSPI_WRITE_Type     // 0x510
	ERASE                QSPI_ERASE_Type     // 0x51C
	PSEL                 QSPI_PSEL_Type      // 0x524
	XIPOFFSET            volatile.Register32 // 0x540
	IFCONFIG0            volatile.Register32 // 0x544
	_                    [4]byte
	XIPEN                volatile.Register32 // 0x54C
	_                    [16]byte
	XIP_ENC              QSPI_XIP_ENC_Type // 0x560
	DMA_ENC              QSPI_DMA_ENC_Type // 0x580
	_                    [96]byte
	IFCONFIG1            volatile.Register32 // 0x600
	STATUS               volatile.Register32 // 0x604
	_                    [12]byte
	DPMDUR               volatile.Register32 // 0x614
	_                    [12]byte
	ADDRCONF             volatile.Register32 // 0x624
	_                    [12]byte
	CINSTRCONF           volatile.Register32 // 0x634
	CINSTRDAT0           volatile.Register32 // 0x638
	CINSTRDAT1           volatile.Register32 // 0x63C
	IFTIMING             volatile.Register32 // 0x640
}

// QSPI.TASKS_ACTIVATE: Activate QSPI interface
func (o *QSPI_Type) SetTASKS_ACTIVATE(value uint32) {
	volatile.StoreUint32(&o.TASKS_ACTIVATE.Reg, volatile.LoadUint32(&o.TASKS_ACTIVATE.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetTASKS_ACTIVATE() uint32 {
	return volatile.LoadUint32(&o.TASKS_ACTIVATE.Reg) & 0x1
}

// QSPI.TASKS_READSTART: Start transfer from external flash memory to internal RAM
func (o *QSPI_Type) SetTASKS_READSTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_READSTART.Reg, volatile.LoadUint32(&o.TASKS_READSTART.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetTASKS_READSTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_READSTART.Reg) & 0x1
}

// QSPI.TASKS_WRITESTART: Start transfer from internal RAM to external flash memory
func (o *QSPI_Type) SetTASKS_WRITESTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_WRITESTART.Reg, volatile.LoadUint32(&o.TASKS_WRITESTART.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetTASKS_WRITESTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_WRITESTART.Reg) & 0x1
}

// QSPI.TASKS_ERASESTART: Start external flash memory erase operation
func (o *QSPI_Type) SetTASKS_ERASESTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_ERASESTART.Reg, volatile.LoadUint32(&o.TASKS_ERASESTART.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetTASKS_ERASESTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_ERASESTART.Reg) & 0x1
}

// QSPI.TASKS_DEACTIVATE: Deactivate QSPI interface
func (o *QSPI_Type) SetTASKS_DEACTIVATE(value uint32) {
	volatile.StoreUint32(&o.TASKS_DEACTIVATE.Reg, volatile.LoadUint32(&o.TASKS_DEACTIVATE.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetTASKS_DEACTIVATE() uint32 {
	return volatile.LoadUint32(&o.TASKS_DEACTIVATE.Reg) & 0x1
}

// QSPI.SUBSCRIBE_ACTIVATE: Subscribe configuration for task ACTIVATE
func (o *QSPI_Type) SetSUBSCRIBE_ACTIVATE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_ACTIVATE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_ACTIVATE.Reg)&^(0xff)|value)
}
func (o *QSPI_Type) GetSUBSCRIBE_ACTIVATE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_ACTIVATE.Reg) & 0xff
}
func (o *QSPI_Type) SetSUBSCRIBE_ACTIVATE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_ACTIVATE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_ACTIVATE.Reg)&^(0x80000000)|value<<31)
}
func (o *QSPI_Type) GetSUBSCRIBE_ACTIVATE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_ACTIVATE.Reg) & 0x80000000) >> 31
}

// QSPI.SUBSCRIBE_READSTART: Subscribe configuration for task READSTART
func (o *QSPI_Type) SetSUBSCRIBE_READSTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_READSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_READSTART.Reg)&^(0xff)|value)
}
func (o *QSPI_Type) GetSUBSCRIBE_READSTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_READSTART.Reg) & 0xff
}
func (o *QSPI_Type) SetSUBSCRIBE_READSTART_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_READSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_READSTART.Reg)&^(0x80000000)|value<<31)
}
func (o *QSPI_Type) GetSUBSCRIBE_READSTART_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_READSTART.Reg) & 0x80000000) >> 31
}

// QSPI.SUBSCRIBE_WRITESTART: Subscribe configuration for task WRITESTART
func (o *QSPI_Type) SetSUBSCRIBE_WRITESTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_WRITESTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_WRITESTART.Reg)&^(0xff)|value)
}
func (o *QSPI_Type) GetSUBSCRIBE_WRITESTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_WRITESTART.Reg) & 0xff
}
func (o *QSPI_Type) SetSUBSCRIBE_WRITESTART_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_WRITESTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_WRITESTART.Reg)&^(0x80000000)|value<<31)
}
func (o *QSPI_Type) GetSUBSCRIBE_WRITESTART_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_WRITESTART.Reg) & 0x80000000) >> 31
}

// QSPI.SUBSCRIBE_ERASESTART: Subscribe configuration for task ERASESTART
func (o *QSPI_Type) SetSUBSCRIBE_ERASESTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_ERASESTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_ERASESTART.Reg)&^(0xff)|value)
}
func (o *QSPI_Type) GetSUBSCRIBE_ERASESTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_ERASESTART.Reg) & 0xff
}
func (o *QSPI_Type) SetSUBSCRIBE_ERASESTART_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_ERASESTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_ERASESTART.Reg)&^(0x80000000)|value<<31)
}
func (o *QSPI_Type) GetSUBSCRIBE_ERASESTART_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_ERASESTART.Reg) & 0x80000000) >> 31
}

// QSPI.SUBSCRIBE_DEACTIVATE: Subscribe configuration for task DEACTIVATE
func (o *QSPI_Type) SetSUBSCRIBE_DEACTIVATE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_DEACTIVATE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_DEACTIVATE.Reg)&^(0xff)|value)
}
func (o *QSPI_Type) GetSUBSCRIBE_DEACTIVATE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_DEACTIVATE.Reg) & 0xff
}
func (o *QSPI_Type) SetSUBSCRIBE_DEACTIVATE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_DEACTIVATE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_DEACTIVATE.Reg)&^(0x80000000)|value<<31)
}
func (o *QSPI_Type) GetSUBSCRIBE_DEACTIVATE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_DEACTIVATE.Reg) & 0x80000000) >> 31
}

// QSPI.EVENTS_READY: QSPI peripheral is ready. This event will be generated as a response to all QSPI tasks except DEACTIVATE.
func (o *QSPI_Type) SetEVENTS_READY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_READY.Reg, volatile.LoadUint32(&o.EVENTS_READY.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetEVENTS_READY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_READY.Reg) & 0x1
}

// QSPI.PUBLISH_READY: Publish configuration for event READY
func (o *QSPI_Type) SetPUBLISH_READY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_READY.Reg, volatile.LoadUint32(&o.PUBLISH_READY.Reg)&^(0xff)|value)
}
func (o *QSPI_Type) GetPUBLISH_READY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_READY.Reg) & 0xff
}
func (o *QSPI_Type) SetPUBLISH_READY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_READY.Reg, volatile.LoadUint32(&o.PUBLISH_READY.Reg)&^(0x80000000)|value<<31)
}
func (o *QSPI_Type) GetPUBLISH_READY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_READY.Reg) & 0x80000000) >> 31
}

// QSPI.INTEN: Enable or disable interrupt
func (o *QSPI_Type) SetINTEN_READY(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetINTEN_READY() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}

// QSPI.INTENSET: Enable interrupt
func (o *QSPI_Type) SetINTENSET_READY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetINTENSET_READY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}

// QSPI.INTENCLR: Disable interrupt
func (o *QSPI_Type) SetINTENCLR_READY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetINTENCLR_READY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}

// QSPI.ENABLE: Enable QSPI peripheral and acquire the pins selected in PSELn registers
func (o *QSPI_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// QSPI.XIPOFFSET: Address offset into the external memory for Execute in Place operation.
func (o *QSPI_Type) SetXIPOFFSET(value uint32) {
	volatile.StoreUint32(&o.XIPOFFSET.Reg, value)
}
func (o *QSPI_Type) GetXIPOFFSET() uint32 {
	return volatile.LoadUint32(&o.XIPOFFSET.Reg)
}

// QSPI.IFCONFIG0: Interface configuration.
func (o *QSPI_Type) SetIFCONFIG0_READOC(value uint32) {
	volatile.StoreUint32(&o.IFCONFIG0.Reg, volatile.LoadUint32(&o.IFCONFIG0.Reg)&^(0x7)|value)
}
func (o *QSPI_Type) GetIFCONFIG0_READOC() uint32 {
	return volatile.LoadUint32(&o.IFCONFIG0.Reg) & 0x7
}
func (o *QSPI_Type) SetIFCONFIG0_WRITEOC(value uint32) {
	volatile.StoreUint32(&o.IFCONFIG0.Reg, volatile.LoadUint32(&o.IFCONFIG0.Reg)&^(0x38)|value<<3)
}
func (o *QSPI_Type) GetIFCONFIG0_WRITEOC() uint32 {
	return (volatile.LoadUint32(&o.IFCONFIG0.Reg) & 0x38) >> 3
}
func (o *QSPI_Type) SetIFCONFIG0_ADDRMODE(value uint32) {
	volatile.StoreUint32(&o.IFCONFIG0.Reg, volatile.LoadUint32(&o.IFCONFIG0.Reg)&^(0x40)|value<<6)
}
func (o *QSPI_Type) GetIFCONFIG0_ADDRMODE() uint32 {
	return (volatile.LoadUint32(&o.IFCONFIG0.Reg) & 0x40) >> 6
}
func (o *QSPI_Type) SetIFCONFIG0_DPMENABLE(value uint32) {
	volatile.StoreUint32(&o.IFCONFIG0.Reg, volatile.LoadUint32(&o.IFCONFIG0.Reg)&^(0x80)|value<<7)
}
func (o *QSPI_Type) GetIFCONFIG0_DPMENABLE() uint32 {
	return (volatile.LoadUint32(&o.IFCONFIG0.Reg) & 0x80) >> 7
}
func (o *QSPI_Type) SetIFCONFIG0_PPSIZE(value uint32) {
	volatile.StoreUint32(&o.IFCONFIG0.Reg, volatile.LoadUint32(&o.IFCONFIG0.Reg)&^(0x1000)|value<<12)
}
func (o *QSPI_Type) GetIFCONFIG0_PPSIZE() uint32 {
	return (volatile.LoadUint32(&o.IFCONFIG0.Reg) & 0x1000) >> 12
}

// QSPI.XIPEN: Enable Execute in Place operation.
func (o *QSPI_Type) SetXIPEN(value uint32) {
	volatile.StoreUint32(&o.XIPEN.Reg, volatile.LoadUint32(&o.XIPEN.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetXIPEN() uint32 {
	return volatile.LoadUint32(&o.XIPEN.Reg) & 0x1
}

// QSPI.IFCONFIG1: Interface configuration.
func (o *QSPI_Type) SetIFCONFIG1_SCKDELAY(value uint32) {
	volatile.StoreUint32(&o.IFCONFIG1.Reg, volatile.LoadUint32(&o.IFCONFIG1.Reg)&^(0xff)|value)
}
func (o *QSPI_Type) GetIFCONFIG1_SCKDELAY() uint32 {
	return volatile.LoadUint32(&o.IFCONFIG1.Reg) & 0xff
}
func (o *QSPI_Type) SetIFCONFIG1_DPMEN(value uint32) {
	volatile.StoreUint32(&o.IFCONFIG1.Reg, volatile.LoadUint32(&o.IFCONFIG1.Reg)&^(0x1000000)|value<<24)
}
func (o *QSPI_Type) GetIFCONFIG1_DPMEN() uint32 {
	return (volatile.LoadUint32(&o.IFCONFIG1.Reg) & 0x1000000) >> 24
}
func (o *QSPI_Type) SetIFCONFIG1_SPIMODE(value uint32) {
	volatile.StoreUint32(&o.IFCONFIG1.Reg, volatile.LoadUint32(&o.IFCONFIG1.Reg)&^(0x2000000)|value<<25)
}
func (o *QSPI_Type) GetIFCONFIG1_SPIMODE() uint32 {
	return (volatile.LoadUint32(&o.IFCONFIG1.Reg) & 0x2000000) >> 25
}
func (o *QSPI_Type) SetIFCONFIG1_SCKFREQ(value uint32) {
	volatile.StoreUint32(&o.IFCONFIG1.Reg, volatile.LoadUint32(&o.IFCONFIG1.Reg)&^(0xf0000000)|value<<28)
}
func (o *QSPI_Type) GetIFCONFIG1_SCKFREQ() uint32 {
	return (volatile.LoadUint32(&o.IFCONFIG1.Reg) & 0xf0000000) >> 28
}

// QSPI.STATUS: Status register.
func (o *QSPI_Type) SetSTATUS_DPM(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *QSPI_Type) GetSTATUS_DPM() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *QSPI_Type) SetSTATUS_READY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *QSPI_Type) GetSTATUS_READY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *QSPI_Type) SetSTATUS_SREG(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xff000000)|value<<24)
}
func (o *QSPI_Type) GetSTATUS_SREG() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xff000000) >> 24
}

// QSPI.DPMDUR: Set the duration required to enter/exit deep power-down mode (DPM).
func (o *QSPI_Type) SetDPMDUR_ENTER(value uint32) {
	volatile.StoreUint32(&o.DPMDUR.Reg, volatile.LoadUint32(&o.DPMDUR.Reg)&^(0xffff)|value)
}
func (o *QSPI_Type) GetDPMDUR_ENTER() uint32 {
	return volatile.LoadUint32(&o.DPMDUR.Reg) & 0xffff
}
func (o *QSPI_Type) SetDPMDUR_EXIT(value uint32) {
	volatile.StoreUint32(&o.DPMDUR.Reg, volatile.LoadUint32(&o.DPMDUR.Reg)&^(0xffff0000)|value<<16)
}
func (o *QSPI_Type) GetDPMDUR_EXIT() uint32 {
	return (volatile.LoadUint32(&o.DPMDUR.Reg) & 0xffff0000) >> 16
}

// QSPI.ADDRCONF: Extended address configuration.
func (o *QSPI_Type) SetADDRCONF_OPCODE(value uint32) {
	volatile.StoreUint32(&o.ADDRCONF.Reg, volatile.LoadUint32(&o.ADDRCONF.Reg)&^(0xff)|value)
}
func (o *QSPI_Type) GetADDRCONF_OPCODE() uint32 {
	return volatile.LoadUint32(&o.ADDRCONF.Reg) & 0xff
}
func (o *QSPI_Type) SetADDRCONF_BYTE0(value uint32) {
	volatile.StoreUint32(&o.ADDRCONF.Reg, volatile.LoadUint32(&o.ADDRCONF.Reg)&^(0xff00)|value<<8)
}
func (o *QSPI_Type) GetADDRCONF_BYTE0() uint32 {
	return (volatile.LoadUint32(&o.ADDRCONF.Reg) & 0xff00) >> 8
}
func (o *QSPI_Type) SetADDRCONF_BYTE1(value uint32) {
	volatile.StoreUint32(&o.ADDRCONF.Reg, volatile.LoadUint32(&o.ADDRCONF.Reg)&^(0xff0000)|value<<16)
}
func (o *QSPI_Type) GetADDRCONF_BYTE1() uint32 {
	return (volatile.LoadUint32(&o.ADDRCONF.Reg) & 0xff0000) >> 16
}
func (o *QSPI_Type) SetADDRCONF_MODE(value uint32) {
	volatile.StoreUint32(&o.ADDRCONF.Reg, volatile.LoadUint32(&o.ADDRCONF.Reg)&^(0x3000000)|value<<24)
}
func (o *QSPI_Type) GetADDRCONF_MODE() uint32 {
	return (volatile.LoadUint32(&o.ADDRCONF.Reg) & 0x3000000) >> 24
}
func (o *QSPI_Type) SetADDRCONF_WIPWAIT(value uint32) {
	volatile.StoreUint32(&o.ADDRCONF.Reg, volatile.LoadUint32(&o.ADDRCONF.Reg)&^(0x4000000)|value<<26)
}
func (o *QSPI_Type) GetADDRCONF_WIPWAIT() uint32 {
	return (volatile.LoadUint32(&o.ADDRCONF.Reg) & 0x4000000) >> 26
}
func (o *QSPI_Type) SetADDRCONF_WREN(value uint32) {
	volatile.StoreUint32(&o.ADDRCONF.Reg, volatile.LoadUint32(&o.ADDRCONF.Reg)&^(0x8000000)|value<<27)
}
func (o *QSPI_Type) GetADDRCONF_WREN() uint32 {
	return (volatile.LoadUint32(&o.ADDRCONF.Reg) & 0x8000000) >> 27
}

// QSPI.CINSTRCONF: Custom instruction configuration register.
func (o *QSPI_Type) SetCINSTRCONF_OPCODE(value uint32) {
	volatile.StoreUint32(&o.CINSTRCONF.Reg, volatile.LoadUint32(&o.CINSTRCONF.Reg)&^(0xff)|value)
}
func (o *QSPI_Type) GetCINSTRCONF_OPCODE() uint32 {
	return volatile.LoadUint32(&o.CINSTRCONF.Reg) & 0xff
}
func (o *QSPI_Type) SetCINSTRCONF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.CINSTRCONF.Reg, volatile.LoadUint32(&o.CINSTRCONF.Reg)&^(0xf00)|value<<8)
}
func (o *QSPI_Type) GetCINSTRCONF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.CINSTRCONF.Reg) & 0xf00) >> 8
}
func (o *QSPI_Type) SetCINSTRCONF_LIO2(value uint32) {
	volatile.StoreUint32(&o.CINSTRCONF.Reg, volatile.LoadUint32(&o.CINSTRCONF.Reg)&^(0x1000)|value<<12)
}
func (o *QSPI_Type) GetCINSTRCONF_LIO2() uint32 {
	return (volatile.LoadUint32(&o.CINSTRCONF.Reg) & 0x1000) >> 12
}
func (o *QSPI_Type) SetCINSTRCONF_LIO3(value uint32) {
	volatile.StoreUint32(&o.CINSTRCONF.Reg, volatile.LoadUint32(&o.CINSTRCONF.Reg)&^(0x2000)|value<<13)
}
func (o *QSPI_Type) GetCINSTRCONF_LIO3() uint32 {
	return (volatile.LoadUint32(&o.CINSTRCONF.Reg) & 0x2000) >> 13
}
func (o *QSPI_Type) SetCINSTRCONF_WIPWAIT(value uint32) {
	volatile.StoreUint32(&o.CINSTRCONF.Reg, volatile.LoadUint32(&o.CINSTRCONF.Reg)&^(0x4000)|value<<14)
}
func (o *QSPI_Type) GetCINSTRCONF_WIPWAIT() uint32 {
	return (volatile.LoadUint32(&o.CINSTRCONF.Reg) & 0x4000) >> 14
}
func (o *QSPI_Type) SetCINSTRCONF_WREN(value uint32) {
	volatile.StoreUint32(&o.CINSTRCONF.Reg, volatile.LoadUint32(&o.CINSTRCONF.Reg)&^(0x8000)|value<<15)
}
func (o *QSPI_Type) GetCINSTRCONF_WREN() uint32 {
	return (volatile.LoadUint32(&o.CINSTRCONF.Reg) & 0x8000) >> 15
}
func (o *QSPI_Type) SetCINSTRCONF_LFEN(value uint32) {
	volatile.StoreUint32(&o.CINSTRCONF.Reg, volatile.LoadUint32(&o.CINSTRCONF.Reg)&^(0x10000)|value<<16)
}
func (o *QSPI_Type) GetCINSTRCONF_LFEN() uint32 {
	return (volatile.LoadUint32(&o.CINSTRCONF.Reg) & 0x10000) >> 16
}
func (o *QSPI_Type) SetCINSTRCONF_LFSTOP(value uint32) {
	volatile.StoreUint32(&o.CINSTRCONF.Reg, volatile.LoadUint32(&o.CINSTRCONF.Reg)&^(0x20000)|value<<17)
}
func (o *QSPI_Type) GetCINSTRCONF_LFSTOP() uint32 {
	return (volatile.LoadUint32(&o.CINSTRCONF.Reg) & 0x20000) >> 17
}

// QSPI.CINSTRDAT0: Custom instruction data register 0.
func (o *QSPI_Type) SetCINSTRDAT0_BYTE0(value uint32) {
	volatile.StoreUint32(&o.CINSTRDAT0.Reg, volatile.LoadUint32(&o.CINSTRDAT0.Reg)&^(0xff)|value)
}
func (o *QSPI_Type) GetCINSTRDAT0_BYTE0() uint32 {
	return volatile.LoadUint32(&o.CINSTRDAT0.Reg) & 0xff
}
func (o *QSPI_Type) SetCINSTRDAT0_BYTE1(value uint32) {
	volatile.StoreUint32(&o.CINSTRDAT0.Reg, volatile.LoadUint32(&o.CINSTRDAT0.Reg)&^(0xff00)|value<<8)
}
func (o *QSPI_Type) GetCINSTRDAT0_BYTE1() uint32 {
	return (volatile.LoadUint32(&o.CINSTRDAT0.Reg) & 0xff00) >> 8
}
func (o *QSPI_Type) SetCINSTRDAT0_BYTE2(value uint32) {
	volatile.StoreUint32(&o.CINSTRDAT0.Reg, volatile.LoadUint32(&o.CINSTRDAT0.Reg)&^(0xff0000)|value<<16)
}
func (o *QSPI_Type) GetCINSTRDAT0_BYTE2() uint32 {
	return (volatile.LoadUint32(&o.CINSTRDAT0.Reg) & 0xff0000) >> 16
}
func (o *QSPI_Type) SetCINSTRDAT0_BYTE3(value uint32) {
	volatile.StoreUint32(&o.CINSTRDAT0.Reg, volatile.LoadUint32(&o.CINSTRDAT0.Reg)&^(0xff000000)|value<<24)
}
func (o *QSPI_Type) GetCINSTRDAT0_BYTE3() uint32 {
	return (volatile.LoadUint32(&o.CINSTRDAT0.Reg) & 0xff000000) >> 24
}

// QSPI.CINSTRDAT1: Custom instruction data register 1.
func (o *QSPI_Type) SetCINSTRDAT1_BYTE4(value uint32) {
	volatile.StoreUint32(&o.CINSTRDAT1.Reg, volatile.LoadUint32(&o.CINSTRDAT1.Reg)&^(0xff)|value)
}
func (o *QSPI_Type) GetCINSTRDAT1_BYTE4() uint32 {
	return volatile.LoadUint32(&o.CINSTRDAT1.Reg) & 0xff
}
func (o *QSPI_Type) SetCINSTRDAT1_BYTE5(value uint32) {
	volatile.StoreUint32(&o.CINSTRDAT1.Reg, volatile.LoadUint32(&o.CINSTRDAT1.Reg)&^(0xff00)|value<<8)
}
func (o *QSPI_Type) GetCINSTRDAT1_BYTE5() uint32 {
	return (volatile.LoadUint32(&o.CINSTRDAT1.Reg) & 0xff00) >> 8
}
func (o *QSPI_Type) SetCINSTRDAT1_BYTE6(value uint32) {
	volatile.StoreUint32(&o.CINSTRDAT1.Reg, volatile.LoadUint32(&o.CINSTRDAT1.Reg)&^(0xff0000)|value<<16)
}
func (o *QSPI_Type) GetCINSTRDAT1_BYTE6() uint32 {
	return (volatile.LoadUint32(&o.CINSTRDAT1.Reg) & 0xff0000) >> 16
}
func (o *QSPI_Type) SetCINSTRDAT1_BYTE7(value uint32) {
	volatile.StoreUint32(&o.CINSTRDAT1.Reg, volatile.LoadUint32(&o.CINSTRDAT1.Reg)&^(0xff000000)|value<<24)
}
func (o *QSPI_Type) GetCINSTRDAT1_BYTE7() uint32 {
	return (volatile.LoadUint32(&o.CINSTRDAT1.Reg) & 0xff000000) >> 24
}

type QSPI_READ_Type struct {
	SRC volatile.Register32 // 0x504
	DST volatile.Register32 // 0x508
	CNT volatile.Register32 // 0x50C
}

// QSPI_READ.SRC: Flash memory source address
func (o *QSPI_READ_Type) SetSRC(value uint32) {
	volatile.StoreUint32(&o.SRC.Reg, value)
}
func (o *QSPI_READ_Type) GetSRC() uint32 {
	return volatile.LoadUint32(&o.SRC.Reg)
}

// QSPI_READ.DST: RAM destination address
func (o *QSPI_READ_Type) SetDST(value uint32) {
	volatile.StoreUint32(&o.DST.Reg, value)
}
func (o *QSPI_READ_Type) GetDST() uint32 {
	return volatile.LoadUint32(&o.DST.Reg)
}

// QSPI_READ.CNT: Read transfer length
func (o *QSPI_READ_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0x1fffff)|value)
}
func (o *QSPI_READ_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0x1fffff
}

type QSPI_WRITE_Type struct {
	DST volatile.Register32 // 0x510
	SRC volatile.Register32 // 0x514
	CNT volatile.Register32 // 0x518
}

// QSPI_WRITE.DST: Flash destination address
func (o *QSPI_WRITE_Type) SetDST(value uint32) {
	volatile.StoreUint32(&o.DST.Reg, value)
}
func (o *QSPI_WRITE_Type) GetDST() uint32 {
	return volatile.LoadUint32(&o.DST.Reg)
}

// QSPI_WRITE.SRC: RAM source address
func (o *QSPI_WRITE_Type) SetSRC(value uint32) {
	volatile.StoreUint32(&o.SRC.Reg, value)
}
func (o *QSPI_WRITE_Type) GetSRC() uint32 {
	return volatile.LoadUint32(&o.SRC.Reg)
}

// QSPI_WRITE.CNT: Write transfer length
func (o *QSPI_WRITE_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0x1fffff)|value)
}
func (o *QSPI_WRITE_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0x1fffff
}

type QSPI_ERASE_Type struct {
	PTR volatile.Register32 // 0x51C
	LEN volatile.Register32 // 0x520
}

// QSPI_ERASE.PTR: Start address of flash block to be erased
func (o *QSPI_ERASE_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *QSPI_ERASE_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// QSPI_ERASE.LEN: Size of block to be erased.
func (o *QSPI_ERASE_Type) SetLEN(value uint32) {
	volatile.StoreUint32(&o.LEN.Reg, volatile.LoadUint32(&o.LEN.Reg)&^(0x3)|value)
}
func (o *QSPI_ERASE_Type) GetLEN() uint32 {
	return volatile.LoadUint32(&o.LEN.Reg) & 0x3
}

type QSPI_PSEL_Type struct {
	SCK volatile.Register32 // 0x524
	CSN volatile.Register32 // 0x528
	_   [4]byte
	IO0 volatile.Register32 // 0x530
	IO1 volatile.Register32 // 0x534
	IO2 volatile.Register32 // 0x538
	IO3 volatile.Register32 // 0x53C
}

// QSPI_PSEL.SCK: Pin select for serial clock SCK
func (o *QSPI_PSEL_Type) SetSCK_PIN(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x1f)|value)
}
func (o *QSPI_PSEL_Type) GetSCK_PIN() uint32 {
	return volatile.LoadUint32(&o.SCK.Reg) & 0x1f
}
func (o *QSPI_PSEL_Type) SetSCK_PORT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x20)|value<<5)
}
func (o *QSPI_PSEL_Type) GetSCK_PORT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x20) >> 5
}
func (o *QSPI_PSEL_Type) SetSCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x80000000)|value<<31)
}
func (o *QSPI_PSEL_Type) GetSCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x80000000) >> 31
}

// QSPI_PSEL.CSN: Pin select for chip select signal CSN.
func (o *QSPI_PSEL_Type) SetCSN_PIN(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x1f)|value)
}
func (o *QSPI_PSEL_Type) GetCSN_PIN() uint32 {
	return volatile.LoadUint32(&o.CSN.Reg) & 0x1f
}
func (o *QSPI_PSEL_Type) SetCSN_PORT(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x20)|value<<5)
}
func (o *QSPI_PSEL_Type) GetCSN_PORT() uint32 {
	return (volatile.LoadUint32(&o.CSN.Reg) & 0x20) >> 5
}
func (o *QSPI_PSEL_Type) SetCSN_CONNECT(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x80000000)|value<<31)
}
func (o *QSPI_PSEL_Type) GetCSN_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.CSN.Reg) & 0x80000000) >> 31
}

// QSPI_PSEL.IO0: Pin select for serial data MOSI/IO0.
func (o *QSPI_PSEL_Type) SetIO0_PIN(value uint32) {
	volatile.StoreUint32(&o.IO0.Reg, volatile.LoadUint32(&o.IO0.Reg)&^(0x1f)|value)
}
func (o *QSPI_PSEL_Type) GetIO0_PIN() uint32 {
	return volatile.LoadUint32(&o.IO0.Reg) & 0x1f
}
func (o *QSPI_PSEL_Type) SetIO0_PORT(value uint32) {
	volatile.StoreUint32(&o.IO0.Reg, volatile.LoadUint32(&o.IO0.Reg)&^(0x20)|value<<5)
}
func (o *QSPI_PSEL_Type) GetIO0_PORT() uint32 {
	return (volatile.LoadUint32(&o.IO0.Reg) & 0x20) >> 5
}
func (o *QSPI_PSEL_Type) SetIO0_CONNECT(value uint32) {
	volatile.StoreUint32(&o.IO0.Reg, volatile.LoadUint32(&o.IO0.Reg)&^(0x80000000)|value<<31)
}
func (o *QSPI_PSEL_Type) GetIO0_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.IO0.Reg) & 0x80000000) >> 31
}

// QSPI_PSEL.IO1: Pin select for serial data MISO/IO1.
func (o *QSPI_PSEL_Type) SetIO1_PIN(value uint32) {
	volatile.StoreUint32(&o.IO1.Reg, volatile.LoadUint32(&o.IO1.Reg)&^(0x1f)|value)
}
func (o *QSPI_PSEL_Type) GetIO1_PIN() uint32 {
	return volatile.LoadUint32(&o.IO1.Reg) & 0x1f
}
func (o *QSPI_PSEL_Type) SetIO1_PORT(value uint32) {
	volatile.StoreUint32(&o.IO1.Reg, volatile.LoadUint32(&o.IO1.Reg)&^(0x20)|value<<5)
}
func (o *QSPI_PSEL_Type) GetIO1_PORT() uint32 {
	return (volatile.LoadUint32(&o.IO1.Reg) & 0x20) >> 5
}
func (o *QSPI_PSEL_Type) SetIO1_CONNECT(value uint32) {
	volatile.StoreUint32(&o.IO1.Reg, volatile.LoadUint32(&o.IO1.Reg)&^(0x80000000)|value<<31)
}
func (o *QSPI_PSEL_Type) GetIO1_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.IO1.Reg) & 0x80000000) >> 31
}

// QSPI_PSEL.IO2: Pin select for serial data IO2.
func (o *QSPI_PSEL_Type) SetIO2_PIN(value uint32) {
	volatile.StoreUint32(&o.IO2.Reg, volatile.LoadUint32(&o.IO2.Reg)&^(0x1f)|value)
}
func (o *QSPI_PSEL_Type) GetIO2_PIN() uint32 {
	return volatile.LoadUint32(&o.IO2.Reg) & 0x1f
}
func (o *QSPI_PSEL_Type) SetIO2_PORT(value uint32) {
	volatile.StoreUint32(&o.IO2.Reg, volatile.LoadUint32(&o.IO2.Reg)&^(0x20)|value<<5)
}
func (o *QSPI_PSEL_Type) GetIO2_PORT() uint32 {
	return (volatile.LoadUint32(&o.IO2.Reg) & 0x20) >> 5
}
func (o *QSPI_PSEL_Type) SetIO2_CONNECT(value uint32) {
	volatile.StoreUint32(&o.IO2.Reg, volatile.LoadUint32(&o.IO2.Reg)&^(0x80000000)|value<<31)
}
func (o *QSPI_PSEL_Type) GetIO2_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.IO2.Reg) & 0x80000000) >> 31
}

// QSPI_PSEL.IO3: Pin select for serial data IO3.
func (o *QSPI_PSEL_Type) SetIO3_PIN(value uint32) {
	volatile.StoreUint32(&o.IO3.Reg, volatile.LoadUint32(&o.IO3.Reg)&^(0x1f)|value)
}
func (o *QSPI_PSEL_Type) GetIO3_PIN() uint32 {
	return volatile.LoadUint32(&o.IO3.Reg) & 0x1f
}
func (o *QSPI_PSEL_Type) SetIO3_PORT(value uint32) {
	volatile.StoreUint32(&o.IO3.Reg, volatile.LoadUint32(&o.IO3.Reg)&^(0x20)|value<<5)
}
func (o *QSPI_PSEL_Type) GetIO3_PORT() uint32 {
	return (volatile.LoadUint32(&o.IO3.Reg) & 0x20) >> 5
}
func (o *QSPI_PSEL_Type) SetIO3_CONNECT(value uint32) {
	volatile.StoreUint32(&o.IO3.Reg, volatile.LoadUint32(&o.IO3.Reg)&^(0x80000000)|value<<31)
}
func (o *QSPI_PSEL_Type) GetIO3_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.IO3.Reg) & 0x80000000) >> 31
}

type QSPI_XIP_ENC_Type struct {
	KEY0   volatile.Register32 // 0x560
	KEY1   volatile.Register32 // 0x564
	KEY2   volatile.Register32 // 0x568
	KEY3   volatile.Register32 // 0x56C
	NONCE0 volatile.Register32 // 0x570
	NONCE1 volatile.Register32 // 0x574
	NONCE2 volatile.Register32 // 0x578
	ENABLE volatile.Register32 // 0x57C
}

// QSPI_XIP_ENC.KEY0: Bits 31:0 of XIP AES KEY
func (o *QSPI_XIP_ENC_Type) SetKEY0(value uint32) {
	volatile.StoreUint32(&o.KEY0.Reg, value)
}
func (o *QSPI_XIP_ENC_Type) GetKEY0() uint32 {
	return volatile.LoadUint32(&o.KEY0.Reg)
}

// QSPI_XIP_ENC.KEY1: Bits 63:32 of XIP AES KEY
func (o *QSPI_XIP_ENC_Type) SetKEY1(value uint32) {
	volatile.StoreUint32(&o.KEY1.Reg, value)
}
func (o *QSPI_XIP_ENC_Type) GetKEY1() uint32 {
	return volatile.LoadUint32(&o.KEY1.Reg)
}

// QSPI_XIP_ENC.KEY2: Bits 95:64 of XIP AES KEY
func (o *QSPI_XIP_ENC_Type) SetKEY2(value uint32) {
	volatile.StoreUint32(&o.KEY2.Reg, value)
}
func (o *QSPI_XIP_ENC_Type) GetKEY2() uint32 {
	return volatile.LoadUint32(&o.KEY2.Reg)
}

// QSPI_XIP_ENC.KEY3: Bits 127:96 of XIP AES KEY
func (o *QSPI_XIP_ENC_Type) SetKEY3(value uint32) {
	volatile.StoreUint32(&o.KEY3.Reg, value)
}
func (o *QSPI_XIP_ENC_Type) GetKEY3() uint32 {
	return volatile.LoadUint32(&o.KEY3.Reg)
}

// QSPI_XIP_ENC.NONCE0: Bits 31:0 of XIP NONCE
func (o *QSPI_XIP_ENC_Type) SetNONCE0(value uint32) {
	volatile.StoreUint32(&o.NONCE0.Reg, value)
}
func (o *QSPI_XIP_ENC_Type) GetNONCE0() uint32 {
	return volatile.LoadUint32(&o.NONCE0.Reg)
}

// QSPI_XIP_ENC.NONCE1: Bits 63:32 of XIP NONCE
func (o *QSPI_XIP_ENC_Type) SetNONCE1(value uint32) {
	volatile.StoreUint32(&o.NONCE1.Reg, value)
}
func (o *QSPI_XIP_ENC_Type) GetNONCE1() uint32 {
	return volatile.LoadUint32(&o.NONCE1.Reg)
}

// QSPI_XIP_ENC.NONCE2: Bits 95:64 of XIP NONCE
func (o *QSPI_XIP_ENC_Type) SetNONCE2(value uint32) {
	volatile.StoreUint32(&o.NONCE2.Reg, value)
}
func (o *QSPI_XIP_ENC_Type) GetNONCE2() uint32 {
	return volatile.LoadUint32(&o.NONCE2.Reg)
}

// QSPI_XIP_ENC.ENABLE: Enable stream cipher for XIP
func (o *QSPI_XIP_ENC_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *QSPI_XIP_ENC_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

type QSPI_DMA_ENC_Type struct {
	KEY0   volatile.Register32 // 0x580
	KEY1   volatile.Register32 // 0x584
	KEY2   volatile.Register32 // 0x588
	KEY3   volatile.Register32 // 0x58C
	NONCE0 volatile.Register32 // 0x590
	NONCE1 volatile.Register32 // 0x594
	NONCE2 volatile.Register32 // 0x598
	ENABLE volatile.Register32 // 0x59C
}

// QSPI_DMA_ENC.KEY0: Bits 31:0 of DMA AES KEY
func (o *QSPI_DMA_ENC_Type) SetKEY0(value uint32) {
	volatile.StoreUint32(&o.KEY0.Reg, value)
}
func (o *QSPI_DMA_ENC_Type) GetKEY0() uint32 {
	return volatile.LoadUint32(&o.KEY0.Reg)
}

// QSPI_DMA_ENC.KEY1: Bits 63:32 of DMA AES KEY
func (o *QSPI_DMA_ENC_Type) SetKEY1(value uint32) {
	volatile.StoreUint32(&o.KEY1.Reg, value)
}
func (o *QSPI_DMA_ENC_Type) GetKEY1() uint32 {
	return volatile.LoadUint32(&o.KEY1.Reg)
}

// QSPI_DMA_ENC.KEY2: Bits 95:64 of DMA AES KEY
func (o *QSPI_DMA_ENC_Type) SetKEY2(value uint32) {
	volatile.StoreUint32(&o.KEY2.Reg, value)
}
func (o *QSPI_DMA_ENC_Type) GetKEY2() uint32 {
	return volatile.LoadUint32(&o.KEY2.Reg)
}

// QSPI_DMA_ENC.KEY3: Bits 127:96 of DMA AES KEY
func (o *QSPI_DMA_ENC_Type) SetKEY3(value uint32) {
	volatile.StoreUint32(&o.KEY3.Reg, value)
}
func (o *QSPI_DMA_ENC_Type) GetKEY3() uint32 {
	return volatile.LoadUint32(&o.KEY3.Reg)
}

// QSPI_DMA_ENC.NONCE0: Bits 31:0 of DMA NONCE
func (o *QSPI_DMA_ENC_Type) SetNONCE0(value uint32) {
	volatile.StoreUint32(&o.NONCE0.Reg, value)
}
func (o *QSPI_DMA_ENC_Type) GetNONCE0() uint32 {
	return volatile.LoadUint32(&o.NONCE0.Reg)
}

// QSPI_DMA_ENC.NONCE1: Bits 63:32 of DMA NONCE
func (o *QSPI_DMA_ENC_Type) SetNONCE1(value uint32) {
	volatile.StoreUint32(&o.NONCE1.Reg, value)
}
func (o *QSPI_DMA_ENC_Type) GetNONCE1() uint32 {
	return volatile.LoadUint32(&o.NONCE1.Reg)
}

// QSPI_DMA_ENC.NONCE2: Bits 95:64 of DMA NONCE
func (o *QSPI_DMA_ENC_Type) SetNONCE2(value uint32) {
	volatile.StoreUint32(&o.NONCE2.Reg, value)
}
func (o *QSPI_DMA_ENC_Type) GetNONCE2() uint32 {
	return volatile.LoadUint32(&o.NONCE2.Reg)
}

// QSPI_DMA_ENC.ENABLE: Enable stream cipher for EasyDMA
func (o *QSPI_DMA_ENC_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *QSPI_DMA_ENC_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// NFC-A compatible radio 0
type NFCT_Type struct {
	TASKS_ACTIVATE            volatile.Register32 // 0x0
	TASKS_DISABLE             volatile.Register32 // 0x4
	TASKS_SENSE               volatile.Register32 // 0x8
	TASKS_STARTTX             volatile.Register32 // 0xC
	_                         [12]byte
	TASKS_ENABLERXDATA        volatile.Register32 // 0x1C
	_                         [4]byte
	TASKS_GOIDLE              volatile.Register32 // 0x24
	TASKS_GOSLEEP             volatile.Register32 // 0x28
	_                         [84]byte
	SUBSCRIBE_ACTIVATE        volatile.Register32 // 0x80
	SUBSCRIBE_DISABLE         volatile.Register32 // 0x84
	SUBSCRIBE_SENSE           volatile.Register32 // 0x88
	SUBSCRIBE_STARTTX         volatile.Register32 // 0x8C
	_                         [12]byte
	SUBSCRIBE_ENABLERXDATA    volatile.Register32 // 0x9C
	_                         [4]byte
	SUBSCRIBE_GOIDLE          volatile.Register32 // 0xA4
	SUBSCRIBE_GOSLEEP         volatile.Register32 // 0xA8
	_                         [84]byte
	EVENTS_READY              volatile.Register32 // 0x100
	EVENTS_FIELDDETECTED      volatile.Register32 // 0x104
	EVENTS_FIELDLOST          volatile.Register32 // 0x108
	EVENTS_TXFRAMESTART       volatile.Register32 // 0x10C
	EVENTS_TXFRAMEEND         volatile.Register32 // 0x110
	EVENTS_RXFRAMESTART       volatile.Register32 // 0x114
	EVENTS_RXFRAMEEND         volatile.Register32 // 0x118
	EVENTS_ERROR              volatile.Register32 // 0x11C
	_                         [8]byte
	EVENTS_RXERROR            volatile.Register32 // 0x128
	EVENTS_ENDRX              volatile.Register32 // 0x12C
	EVENTS_ENDTX              volatile.Register32 // 0x130
	_                         [4]byte
	EVENTS_AUTOCOLRESSTARTED  volatile.Register32 // 0x138
	_                         [12]byte
	EVENTS_COLLISION          volatile.Register32 // 0x148
	EVENTS_SELECTED           volatile.Register32 // 0x14C
	EVENTS_STARTED            volatile.Register32 // 0x150
	_                         [44]byte
	PUBLISH_READY             volatile.Register32 // 0x180
	PUBLISH_FIELDDETECTED     volatile.Register32 // 0x184
	PUBLISH_FIELDLOST         volatile.Register32 // 0x188
	PUBLISH_TXFRAMESTART      volatile.Register32 // 0x18C
	PUBLISH_TXFRAMEEND        volatile.Register32 // 0x190
	PUBLISH_RXFRAMESTART      volatile.Register32 // 0x194
	PUBLISH_RXFRAMEEND        volatile.Register32 // 0x198
	PUBLISH_ERROR             volatile.Register32 // 0x19C
	_                         [8]byte
	PUBLISH_RXERROR           volatile.Register32 // 0x1A8
	PUBLISH_ENDRX             volatile.Register32 // 0x1AC
	PUBLISH_ENDTX             volatile.Register32 // 0x1B0
	_                         [4]byte
	PUBLISH_AUTOCOLRESSTARTED volatile.Register32 // 0x1B8
	_                         [12]byte
	PUBLISH_COLLISION         volatile.Register32 // 0x1C8
	PUBLISH_SELECTED          volatile.Register32 // 0x1CC
	PUBLISH_STARTED           volatile.Register32 // 0x1D0
	_                         [44]byte
	SHORTS                    volatile.Register32 // 0x200
	_                         [252]byte
	INTEN                     volatile.Register32 // 0x300
	INTENSET                  volatile.Register32 // 0x304
	INTENCLR                  volatile.Register32 // 0x308
	_                         [248]byte
	ERRORSTATUS               volatile.Register32 // 0x404
	_                         [4]byte
	FRAMESTATUS               NFCT_FRAMESTATUS_Type // 0x40C
	NFCTAGSTATE               volatile.Register32   // 0x410
	_                         [12]byte
	SLEEPSTATE                volatile.Register32 // 0x420
	_                         [24]byte
	FIELDPRESENT              volatile.Register32 // 0x43C
	_                         [196]byte
	FRAMEDELAYMIN             volatile.Register32 // 0x504
	FRAMEDELAYMAX             volatile.Register32 // 0x508
	FRAMEDELAYMODE            volatile.Register32 // 0x50C
	PACKETPTR                 volatile.Register32 // 0x510
	MAXLEN                    volatile.Register32 // 0x514
	TXD                       NFCT_TXD_Type       // 0x518
	RXD                       NFCT_RXD_Type       // 0x520
	_                         [4]byte
	MODULATIONCTRL            volatile.Register32 // 0x52C
	_                         [8]byte
	MODULATIONPSEL            volatile.Register32 // 0x538
	_                         [84]byte
	NFCID1_LAST               volatile.Register32 // 0x590
	NFCID1_2ND_LAST           volatile.Register32 // 0x594
	NFCID1_3RD_LAST           volatile.Register32 // 0x598
	AUTOCOLRESCONFIG          volatile.Register32 // 0x59C
	SENSRES                   volatile.Register32 // 0x5A0
	SELRES                    volatile.Register32 // 0x5A4
}

// NFCT.TASKS_ACTIVATE: Activate NFCT peripheral for incoming and outgoing frames, change state to activated
func (o *NFCT_Type) SetTASKS_ACTIVATE(value uint32) {
	volatile.StoreUint32(&o.TASKS_ACTIVATE.Reg, volatile.LoadUint32(&o.TASKS_ACTIVATE.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetTASKS_ACTIVATE() uint32 {
	return volatile.LoadUint32(&o.TASKS_ACTIVATE.Reg) & 0x1
}

// NFCT.TASKS_DISABLE: Disable NFCT peripheral
func (o *NFCT_Type) SetTASKS_DISABLE(value uint32) {
	volatile.StoreUint32(&o.TASKS_DISABLE.Reg, volatile.LoadUint32(&o.TASKS_DISABLE.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetTASKS_DISABLE() uint32 {
	return volatile.LoadUint32(&o.TASKS_DISABLE.Reg) & 0x1
}

// NFCT.TASKS_SENSE: Enable NFC sense field mode, change state to sense mode
func (o *NFCT_Type) SetTASKS_SENSE(value uint32) {
	volatile.StoreUint32(&o.TASKS_SENSE.Reg, volatile.LoadUint32(&o.TASKS_SENSE.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetTASKS_SENSE() uint32 {
	return volatile.LoadUint32(&o.TASKS_SENSE.Reg) & 0x1
}

// NFCT.TASKS_STARTTX: Start transmission of an outgoing frame, change state to transmit
func (o *NFCT_Type) SetTASKS_STARTTX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTTX.Reg, volatile.LoadUint32(&o.TASKS_STARTTX.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetTASKS_STARTTX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTTX.Reg) & 0x1
}

// NFCT.TASKS_ENABLERXDATA: Initializes the EasyDMA for receive.
func (o *NFCT_Type) SetTASKS_ENABLERXDATA(value uint32) {
	volatile.StoreUint32(&o.TASKS_ENABLERXDATA.Reg, volatile.LoadUint32(&o.TASKS_ENABLERXDATA.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetTASKS_ENABLERXDATA() uint32 {
	return volatile.LoadUint32(&o.TASKS_ENABLERXDATA.Reg) & 0x1
}

// NFCT.TASKS_GOIDLE: Force state machine to IDLE state
func (o *NFCT_Type) SetTASKS_GOIDLE(value uint32) {
	volatile.StoreUint32(&o.TASKS_GOIDLE.Reg, volatile.LoadUint32(&o.TASKS_GOIDLE.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetTASKS_GOIDLE() uint32 {
	return volatile.LoadUint32(&o.TASKS_GOIDLE.Reg) & 0x1
}

// NFCT.TASKS_GOSLEEP: Force state machine to SLEEP_A state
func (o *NFCT_Type) SetTASKS_GOSLEEP(value uint32) {
	volatile.StoreUint32(&o.TASKS_GOSLEEP.Reg, volatile.LoadUint32(&o.TASKS_GOSLEEP.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetTASKS_GOSLEEP() uint32 {
	return volatile.LoadUint32(&o.TASKS_GOSLEEP.Reg) & 0x1
}

// NFCT.SUBSCRIBE_ACTIVATE: Subscribe configuration for task ACTIVATE
func (o *NFCT_Type) SetSUBSCRIBE_ACTIVATE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_ACTIVATE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_ACTIVATE.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetSUBSCRIBE_ACTIVATE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_ACTIVATE.Reg) & 0xff
}
func (o *NFCT_Type) SetSUBSCRIBE_ACTIVATE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_ACTIVATE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_ACTIVATE.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetSUBSCRIBE_ACTIVATE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_ACTIVATE.Reg) & 0x80000000) >> 31
}

// NFCT.SUBSCRIBE_DISABLE: Subscribe configuration for task DISABLE
func (o *NFCT_Type) SetSUBSCRIBE_DISABLE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_DISABLE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_DISABLE.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetSUBSCRIBE_DISABLE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_DISABLE.Reg) & 0xff
}
func (o *NFCT_Type) SetSUBSCRIBE_DISABLE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_DISABLE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_DISABLE.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetSUBSCRIBE_DISABLE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_DISABLE.Reg) & 0x80000000) >> 31
}

// NFCT.SUBSCRIBE_SENSE: Subscribe configuration for task SENSE
func (o *NFCT_Type) SetSUBSCRIBE_SENSE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SENSE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SENSE.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetSUBSCRIBE_SENSE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SENSE.Reg) & 0xff
}
func (o *NFCT_Type) SetSUBSCRIBE_SENSE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SENSE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SENSE.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetSUBSCRIBE_SENSE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SENSE.Reg) & 0x80000000) >> 31
}

// NFCT.SUBSCRIBE_STARTTX: Subscribe configuration for task STARTTX
func (o *NFCT_Type) SetSUBSCRIBE_STARTTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetSUBSCRIBE_STARTTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg) & 0xff
}
func (o *NFCT_Type) SetSUBSCRIBE_STARTTX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetSUBSCRIBE_STARTTX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg) & 0x80000000) >> 31
}

// NFCT.SUBSCRIBE_ENABLERXDATA: Subscribe configuration for task ENABLERXDATA
func (o *NFCT_Type) SetSUBSCRIBE_ENABLERXDATA_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_ENABLERXDATA.Reg, volatile.LoadUint32(&o.SUBSCRIBE_ENABLERXDATA.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetSUBSCRIBE_ENABLERXDATA_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_ENABLERXDATA.Reg) & 0xff
}
func (o *NFCT_Type) SetSUBSCRIBE_ENABLERXDATA_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_ENABLERXDATA.Reg, volatile.LoadUint32(&o.SUBSCRIBE_ENABLERXDATA.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetSUBSCRIBE_ENABLERXDATA_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_ENABLERXDATA.Reg) & 0x80000000) >> 31
}

// NFCT.SUBSCRIBE_GOIDLE: Subscribe configuration for task GOIDLE
func (o *NFCT_Type) SetSUBSCRIBE_GOIDLE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_GOIDLE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_GOIDLE.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetSUBSCRIBE_GOIDLE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_GOIDLE.Reg) & 0xff
}
func (o *NFCT_Type) SetSUBSCRIBE_GOIDLE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_GOIDLE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_GOIDLE.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetSUBSCRIBE_GOIDLE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_GOIDLE.Reg) & 0x80000000) >> 31
}

// NFCT.SUBSCRIBE_GOSLEEP: Subscribe configuration for task GOSLEEP
func (o *NFCT_Type) SetSUBSCRIBE_GOSLEEP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_GOSLEEP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_GOSLEEP.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetSUBSCRIBE_GOSLEEP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_GOSLEEP.Reg) & 0xff
}
func (o *NFCT_Type) SetSUBSCRIBE_GOSLEEP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_GOSLEEP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_GOSLEEP.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetSUBSCRIBE_GOSLEEP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_GOSLEEP.Reg) & 0x80000000) >> 31
}

// NFCT.EVENTS_READY: The NFCT peripheral is ready to receive and send frames
func (o *NFCT_Type) SetEVENTS_READY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_READY.Reg, volatile.LoadUint32(&o.EVENTS_READY.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_READY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_READY.Reg) & 0x1
}

// NFCT.EVENTS_FIELDDETECTED: Remote NFC field detected
func (o *NFCT_Type) SetEVENTS_FIELDDETECTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_FIELDDETECTED.Reg, volatile.LoadUint32(&o.EVENTS_FIELDDETECTED.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_FIELDDETECTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_FIELDDETECTED.Reg) & 0x1
}

// NFCT.EVENTS_FIELDLOST: Remote NFC field lost
func (o *NFCT_Type) SetEVENTS_FIELDLOST(value uint32) {
	volatile.StoreUint32(&o.EVENTS_FIELDLOST.Reg, volatile.LoadUint32(&o.EVENTS_FIELDLOST.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_FIELDLOST() uint32 {
	return volatile.LoadUint32(&o.EVENTS_FIELDLOST.Reg) & 0x1
}

// NFCT.EVENTS_TXFRAMESTART: Marks the start of the first symbol of a transmitted frame
func (o *NFCT_Type) SetEVENTS_TXFRAMESTART(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXFRAMESTART.Reg, volatile.LoadUint32(&o.EVENTS_TXFRAMESTART.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_TXFRAMESTART() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXFRAMESTART.Reg) & 0x1
}

// NFCT.EVENTS_TXFRAMEEND: Marks the end of the last transmitted on-air symbol of a frame
func (o *NFCT_Type) SetEVENTS_TXFRAMEEND(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXFRAMEEND.Reg, volatile.LoadUint32(&o.EVENTS_TXFRAMEEND.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_TXFRAMEEND() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXFRAMEEND.Reg) & 0x1
}

// NFCT.EVENTS_RXFRAMESTART: Marks the end of the first symbol of a received frame
func (o *NFCT_Type) SetEVENTS_RXFRAMESTART(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXFRAMESTART.Reg, volatile.LoadUint32(&o.EVENTS_RXFRAMESTART.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_RXFRAMESTART() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXFRAMESTART.Reg) & 0x1
}

// NFCT.EVENTS_RXFRAMEEND: Received data has been checked (CRC, parity) and transferred to RAM, and EasyDMA has ended accessing the RX buffer
func (o *NFCT_Type) SetEVENTS_RXFRAMEEND(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXFRAMEEND.Reg, volatile.LoadUint32(&o.EVENTS_RXFRAMEEND.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_RXFRAMEEND() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXFRAMEEND.Reg) & 0x1
}

// NFCT.EVENTS_ERROR: NFC error reported. The ERRORSTATUS register contains details on the source of the error.
func (o *NFCT_Type) SetEVENTS_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_ERROR.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERROR.Reg) & 0x1
}

// NFCT.EVENTS_RXERROR: NFC RX frame error reported. The FRAMESTATUS.RX register contains details on the source of the error.
func (o *NFCT_Type) SetEVENTS_RXERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXERROR.Reg, volatile.LoadUint32(&o.EVENTS_RXERROR.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_RXERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXERROR.Reg) & 0x1
}

// NFCT.EVENTS_ENDRX: RX buffer (as defined by PACKETPTR and MAXLEN) in Data RAM full.
func (o *NFCT_Type) SetEVENTS_ENDRX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDRX.Reg, volatile.LoadUint32(&o.EVENTS_ENDRX.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_ENDRX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDRX.Reg) & 0x1
}

// NFCT.EVENTS_ENDTX: Transmission of data in RAM has ended, and EasyDMA has ended accessing the TX buffer
func (o *NFCT_Type) SetEVENTS_ENDTX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDTX.Reg, volatile.LoadUint32(&o.EVENTS_ENDTX.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_ENDTX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDTX.Reg) & 0x1
}

// NFCT.EVENTS_AUTOCOLRESSTARTED: Auto collision resolution process has started
func (o *NFCT_Type) SetEVENTS_AUTOCOLRESSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_AUTOCOLRESSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_AUTOCOLRESSTARTED.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_AUTOCOLRESSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_AUTOCOLRESSTARTED.Reg) & 0x1
}

// NFCT.EVENTS_COLLISION: NFC auto collision resolution error reported.
func (o *NFCT_Type) SetEVENTS_COLLISION(value uint32) {
	volatile.StoreUint32(&o.EVENTS_COLLISION.Reg, volatile.LoadUint32(&o.EVENTS_COLLISION.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_COLLISION() uint32 {
	return volatile.LoadUint32(&o.EVENTS_COLLISION.Reg) & 0x1
}

// NFCT.EVENTS_SELECTED: NFC auto collision resolution successfully completed
func (o *NFCT_Type) SetEVENTS_SELECTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SELECTED.Reg, volatile.LoadUint32(&o.EVENTS_SELECTED.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_SELECTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SELECTED.Reg) & 0x1
}

// NFCT.EVENTS_STARTED: EasyDMA is ready to receive or send frames.
func (o *NFCT_Type) SetEVENTS_STARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STARTED.Reg, volatile.LoadUint32(&o.EVENTS_STARTED.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_STARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STARTED.Reg) & 0x1
}

// NFCT.PUBLISH_READY: Publish configuration for event READY
func (o *NFCT_Type) SetPUBLISH_READY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_READY.Reg, volatile.LoadUint32(&o.PUBLISH_READY.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetPUBLISH_READY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_READY.Reg) & 0xff
}
func (o *NFCT_Type) SetPUBLISH_READY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_READY.Reg, volatile.LoadUint32(&o.PUBLISH_READY.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetPUBLISH_READY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_READY.Reg) & 0x80000000) >> 31
}

// NFCT.PUBLISH_FIELDDETECTED: Publish configuration for event FIELDDETECTED
func (o *NFCT_Type) SetPUBLISH_FIELDDETECTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_FIELDDETECTED.Reg, volatile.LoadUint32(&o.PUBLISH_FIELDDETECTED.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetPUBLISH_FIELDDETECTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_FIELDDETECTED.Reg) & 0xff
}
func (o *NFCT_Type) SetPUBLISH_FIELDDETECTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_FIELDDETECTED.Reg, volatile.LoadUint32(&o.PUBLISH_FIELDDETECTED.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetPUBLISH_FIELDDETECTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_FIELDDETECTED.Reg) & 0x80000000) >> 31
}

// NFCT.PUBLISH_FIELDLOST: Publish configuration for event FIELDLOST
func (o *NFCT_Type) SetPUBLISH_FIELDLOST_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_FIELDLOST.Reg, volatile.LoadUint32(&o.PUBLISH_FIELDLOST.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetPUBLISH_FIELDLOST_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_FIELDLOST.Reg) & 0xff
}
func (o *NFCT_Type) SetPUBLISH_FIELDLOST_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_FIELDLOST.Reg, volatile.LoadUint32(&o.PUBLISH_FIELDLOST.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetPUBLISH_FIELDLOST_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_FIELDLOST.Reg) & 0x80000000) >> 31
}

// NFCT.PUBLISH_TXFRAMESTART: Publish configuration for event TXFRAMESTART
func (o *NFCT_Type) SetPUBLISH_TXFRAMESTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXFRAMESTART.Reg, volatile.LoadUint32(&o.PUBLISH_TXFRAMESTART.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetPUBLISH_TXFRAMESTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXFRAMESTART.Reg) & 0xff
}
func (o *NFCT_Type) SetPUBLISH_TXFRAMESTART_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXFRAMESTART.Reg, volatile.LoadUint32(&o.PUBLISH_TXFRAMESTART.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetPUBLISH_TXFRAMESTART_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXFRAMESTART.Reg) & 0x80000000) >> 31
}

// NFCT.PUBLISH_TXFRAMEEND: Publish configuration for event TXFRAMEEND
func (o *NFCT_Type) SetPUBLISH_TXFRAMEEND_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXFRAMEEND.Reg, volatile.LoadUint32(&o.PUBLISH_TXFRAMEEND.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetPUBLISH_TXFRAMEEND_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXFRAMEEND.Reg) & 0xff
}
func (o *NFCT_Type) SetPUBLISH_TXFRAMEEND_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXFRAMEEND.Reg, volatile.LoadUint32(&o.PUBLISH_TXFRAMEEND.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetPUBLISH_TXFRAMEEND_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXFRAMEEND.Reg) & 0x80000000) >> 31
}

// NFCT.PUBLISH_RXFRAMESTART: Publish configuration for event RXFRAMESTART
func (o *NFCT_Type) SetPUBLISH_RXFRAMESTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXFRAMESTART.Reg, volatile.LoadUint32(&o.PUBLISH_RXFRAMESTART.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetPUBLISH_RXFRAMESTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXFRAMESTART.Reg) & 0xff
}
func (o *NFCT_Type) SetPUBLISH_RXFRAMESTART_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXFRAMESTART.Reg, volatile.LoadUint32(&o.PUBLISH_RXFRAMESTART.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetPUBLISH_RXFRAMESTART_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXFRAMESTART.Reg) & 0x80000000) >> 31
}

// NFCT.PUBLISH_RXFRAMEEND: Publish configuration for event RXFRAMEEND
func (o *NFCT_Type) SetPUBLISH_RXFRAMEEND_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXFRAMEEND.Reg, volatile.LoadUint32(&o.PUBLISH_RXFRAMEEND.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetPUBLISH_RXFRAMEEND_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXFRAMEEND.Reg) & 0xff
}
func (o *NFCT_Type) SetPUBLISH_RXFRAMEEND_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXFRAMEEND.Reg, volatile.LoadUint32(&o.PUBLISH_RXFRAMEEND.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetPUBLISH_RXFRAMEEND_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXFRAMEEND.Reg) & 0x80000000) >> 31
}

// NFCT.PUBLISH_ERROR: Publish configuration for event ERROR
func (o *NFCT_Type) SetPUBLISH_ERROR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetPUBLISH_ERROR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0xff
}
func (o *NFCT_Type) SetPUBLISH_ERROR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetPUBLISH_ERROR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0x80000000) >> 31
}

// NFCT.PUBLISH_RXERROR: Publish configuration for event RXERROR
func (o *NFCT_Type) SetPUBLISH_RXERROR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXERROR.Reg, volatile.LoadUint32(&o.PUBLISH_RXERROR.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetPUBLISH_RXERROR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXERROR.Reg) & 0xff
}
func (o *NFCT_Type) SetPUBLISH_RXERROR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXERROR.Reg, volatile.LoadUint32(&o.PUBLISH_RXERROR.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetPUBLISH_RXERROR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXERROR.Reg) & 0x80000000) >> 31
}

// NFCT.PUBLISH_ENDRX: Publish configuration for event ENDRX
func (o *NFCT_Type) SetPUBLISH_ENDRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetPUBLISH_ENDRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0xff
}
func (o *NFCT_Type) SetPUBLISH_ENDRX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetPUBLISH_ENDRX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0x80000000) >> 31
}

// NFCT.PUBLISH_ENDTX: Publish configuration for event ENDTX
func (o *NFCT_Type) SetPUBLISH_ENDTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDTX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetPUBLISH_ENDTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg) & 0xff
}
func (o *NFCT_Type) SetPUBLISH_ENDTX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDTX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetPUBLISH_ENDTX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg) & 0x80000000) >> 31
}

// NFCT.PUBLISH_AUTOCOLRESSTARTED: Publish configuration for event AUTOCOLRESSTARTED
func (o *NFCT_Type) SetPUBLISH_AUTOCOLRESSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_AUTOCOLRESSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_AUTOCOLRESSTARTED.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetPUBLISH_AUTOCOLRESSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_AUTOCOLRESSTARTED.Reg) & 0xff
}
func (o *NFCT_Type) SetPUBLISH_AUTOCOLRESSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_AUTOCOLRESSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_AUTOCOLRESSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetPUBLISH_AUTOCOLRESSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_AUTOCOLRESSTARTED.Reg) & 0x80000000) >> 31
}

// NFCT.PUBLISH_COLLISION: Publish configuration for event COLLISION
func (o *NFCT_Type) SetPUBLISH_COLLISION_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_COLLISION.Reg, volatile.LoadUint32(&o.PUBLISH_COLLISION.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetPUBLISH_COLLISION_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_COLLISION.Reg) & 0xff
}
func (o *NFCT_Type) SetPUBLISH_COLLISION_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_COLLISION.Reg, volatile.LoadUint32(&o.PUBLISH_COLLISION.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetPUBLISH_COLLISION_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_COLLISION.Reg) & 0x80000000) >> 31
}

// NFCT.PUBLISH_SELECTED: Publish configuration for event SELECTED
func (o *NFCT_Type) SetPUBLISH_SELECTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SELECTED.Reg, volatile.LoadUint32(&o.PUBLISH_SELECTED.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetPUBLISH_SELECTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_SELECTED.Reg) & 0xff
}
func (o *NFCT_Type) SetPUBLISH_SELECTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SELECTED.Reg, volatile.LoadUint32(&o.PUBLISH_SELECTED.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetPUBLISH_SELECTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_SELECTED.Reg) & 0x80000000) >> 31
}

// NFCT.PUBLISH_STARTED: Publish configuration for event STARTED
func (o *NFCT_Type) SetPUBLISH_STARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STARTED.Reg, volatile.LoadUint32(&o.PUBLISH_STARTED.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetPUBLISH_STARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STARTED.Reg) & 0xff
}
func (o *NFCT_Type) SetPUBLISH_STARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STARTED.Reg, volatile.LoadUint32(&o.PUBLISH_STARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetPUBLISH_STARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STARTED.Reg) & 0x80000000) >> 31
}

// NFCT.SHORTS: Shortcuts between local events and tasks
func (o *NFCT_Type) SetSHORTS_FIELDDETECTED_ACTIVATE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetSHORTS_FIELDDETECTED_ACTIVATE() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *NFCT_Type) SetSHORTS_FIELDLOST_SENSE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *NFCT_Type) GetSHORTS_FIELDLOST_SENSE() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *NFCT_Type) SetSHORTS_TXFRAMEEND_ENABLERXDATA(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20)|value<<5)
}
func (o *NFCT_Type) GetSHORTS_TXFRAMEEND_ENABLERXDATA() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20) >> 5
}

// NFCT.INTEN: Enable or disable interrupt
func (o *NFCT_Type) SetINTEN_READY(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetINTEN_READY() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *NFCT_Type) SetINTEN_FIELDDETECTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *NFCT_Type) GetINTEN_FIELDDETECTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *NFCT_Type) SetINTEN_FIELDLOST(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *NFCT_Type) GetINTEN_FIELDLOST() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *NFCT_Type) SetINTEN_TXFRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *NFCT_Type) GetINTEN_TXFRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *NFCT_Type) SetINTEN_TXFRAMEEND(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *NFCT_Type) GetINTEN_TXFRAMEEND() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *NFCT_Type) SetINTEN_RXFRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *NFCT_Type) GetINTEN_RXFRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *NFCT_Type) SetINTEN_RXFRAMEEND(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *NFCT_Type) GetINTEN_RXFRAMEEND() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *NFCT_Type) SetINTEN_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *NFCT_Type) GetINTEN_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *NFCT_Type) SetINTEN_RXERROR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400)|value<<10)
}
func (o *NFCT_Type) GetINTEN_RXERROR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400) >> 10
}
func (o *NFCT_Type) SetINTEN_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800)|value<<11)
}
func (o *NFCT_Type) GetINTEN_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800) >> 11
}
func (o *NFCT_Type) SetINTEN_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000)|value<<12)
}
func (o *NFCT_Type) GetINTEN_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000) >> 12
}
func (o *NFCT_Type) SetINTEN_AUTOCOLRESSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000)|value<<14)
}
func (o *NFCT_Type) GetINTEN_AUTOCOLRESSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000) >> 14
}
func (o *NFCT_Type) SetINTEN_COLLISION(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40000)|value<<18)
}
func (o *NFCT_Type) GetINTEN_COLLISION() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40000) >> 18
}
func (o *NFCT_Type) SetINTEN_SELECTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *NFCT_Type) GetINTEN_SELECTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *NFCT_Type) SetINTEN_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *NFCT_Type) GetINTEN_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}

// NFCT.INTENSET: Enable interrupt
func (o *NFCT_Type) SetINTENSET_READY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetINTENSET_READY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *NFCT_Type) SetINTENSET_FIELDDETECTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *NFCT_Type) GetINTENSET_FIELDDETECTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *NFCT_Type) SetINTENSET_FIELDLOST(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *NFCT_Type) GetINTENSET_FIELDLOST() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *NFCT_Type) SetINTENSET_TXFRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *NFCT_Type) GetINTENSET_TXFRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *NFCT_Type) SetINTENSET_TXFRAMEEND(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *NFCT_Type) GetINTENSET_TXFRAMEEND() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *NFCT_Type) SetINTENSET_RXFRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *NFCT_Type) GetINTENSET_RXFRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *NFCT_Type) SetINTENSET_RXFRAMEEND(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *NFCT_Type) GetINTENSET_RXFRAMEEND() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *NFCT_Type) SetINTENSET_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *NFCT_Type) GetINTENSET_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *NFCT_Type) SetINTENSET_RXERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *NFCT_Type) GetINTENSET_RXERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *NFCT_Type) SetINTENSET_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *NFCT_Type) GetINTENSET_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *NFCT_Type) SetINTENSET_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *NFCT_Type) GetINTENSET_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *NFCT_Type) SetINTENSET_AUTOCOLRESSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *NFCT_Type) GetINTENSET_AUTOCOLRESSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *NFCT_Type) SetINTENSET_COLLISION(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *NFCT_Type) GetINTENSET_COLLISION() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *NFCT_Type) SetINTENSET_SELECTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *NFCT_Type) GetINTENSET_SELECTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *NFCT_Type) SetINTENSET_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *NFCT_Type) GetINTENSET_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}

// NFCT.INTENCLR: Disable interrupt
func (o *NFCT_Type) SetINTENCLR_READY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetINTENCLR_READY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *NFCT_Type) SetINTENCLR_FIELDDETECTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *NFCT_Type) GetINTENCLR_FIELDDETECTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *NFCT_Type) SetINTENCLR_FIELDLOST(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *NFCT_Type) GetINTENCLR_FIELDLOST() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *NFCT_Type) SetINTENCLR_TXFRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *NFCT_Type) GetINTENCLR_TXFRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *NFCT_Type) SetINTENCLR_TXFRAMEEND(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *NFCT_Type) GetINTENCLR_TXFRAMEEND() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *NFCT_Type) SetINTENCLR_RXFRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *NFCT_Type) GetINTENCLR_RXFRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *NFCT_Type) SetINTENCLR_RXFRAMEEND(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *NFCT_Type) GetINTENCLR_RXFRAMEEND() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *NFCT_Type) SetINTENCLR_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *NFCT_Type) GetINTENCLR_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *NFCT_Type) SetINTENCLR_RXERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *NFCT_Type) GetINTENCLR_RXERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *NFCT_Type) SetINTENCLR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *NFCT_Type) GetINTENCLR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *NFCT_Type) SetINTENCLR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *NFCT_Type) GetINTENCLR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *NFCT_Type) SetINTENCLR_AUTOCOLRESSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *NFCT_Type) GetINTENCLR_AUTOCOLRESSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *NFCT_Type) SetINTENCLR_COLLISION(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *NFCT_Type) GetINTENCLR_COLLISION() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *NFCT_Type) SetINTENCLR_SELECTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *NFCT_Type) GetINTENCLR_SELECTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *NFCT_Type) SetINTENCLR_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *NFCT_Type) GetINTENCLR_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}

// NFCT.ERRORSTATUS: NFC Error Status register
func (o *NFCT_Type) SetERRORSTATUS_FRAMEDELAYTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.ERRORSTATUS.Reg, volatile.LoadUint32(&o.ERRORSTATUS.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetERRORSTATUS_FRAMEDELAYTIMEOUT() uint32 {
	return volatile.LoadUint32(&o.ERRORSTATUS.Reg) & 0x1
}

// NFCT.NFCTAGSTATE: NfcTag state register
func (o *NFCT_Type) SetNFCTAGSTATE(value uint32) {
	volatile.StoreUint32(&o.NFCTAGSTATE.Reg, volatile.LoadUint32(&o.NFCTAGSTATE.Reg)&^(0x7)|value)
}
func (o *NFCT_Type) GetNFCTAGSTATE() uint32 {
	return volatile.LoadUint32(&o.NFCTAGSTATE.Reg) & 0x7
}

// NFCT.SLEEPSTATE: Sleep state during automatic collision resolution
func (o *NFCT_Type) SetSLEEPSTATE(value uint32) {
	volatile.StoreUint32(&o.SLEEPSTATE.Reg, volatile.LoadUint32(&o.SLEEPSTATE.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetSLEEPSTATE() uint32 {
	return volatile.LoadUint32(&o.SLEEPSTATE.Reg) & 0x1
}

// NFCT.FIELDPRESENT: Indicates the presence or not of a valid field
func (o *NFCT_Type) SetFIELDPRESENT(value uint32) {
	volatile.StoreUint32(&o.FIELDPRESENT.Reg, volatile.LoadUint32(&o.FIELDPRESENT.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetFIELDPRESENT() uint32 {
	return volatile.LoadUint32(&o.FIELDPRESENT.Reg) & 0x1
}
func (o *NFCT_Type) SetFIELDPRESENT_LOCKDETECT(value uint32) {
	volatile.StoreUint32(&o.FIELDPRESENT.Reg, volatile.LoadUint32(&o.FIELDPRESENT.Reg)&^(0x2)|value<<1)
}
func (o *NFCT_Type) GetFIELDPRESENT_LOCKDETECT() uint32 {
	return (volatile.LoadUint32(&o.FIELDPRESENT.Reg) & 0x2) >> 1
}

// NFCT.FRAMEDELAYMIN: Minimum frame delay
func (o *NFCT_Type) SetFRAMEDELAYMIN(value uint32) {
	volatile.StoreUint32(&o.FRAMEDELAYMIN.Reg, volatile.LoadUint32(&o.FRAMEDELAYMIN.Reg)&^(0xffff)|value)
}
func (o *NFCT_Type) GetFRAMEDELAYMIN() uint32 {
	return volatile.LoadUint32(&o.FRAMEDELAYMIN.Reg) & 0xffff
}

// NFCT.FRAMEDELAYMAX: Maximum frame delay
func (o *NFCT_Type) SetFRAMEDELAYMAX(value uint32) {
	volatile.StoreUint32(&o.FRAMEDELAYMAX.Reg, volatile.LoadUint32(&o.FRAMEDELAYMAX.Reg)&^(0xfffff)|value)
}
func (o *NFCT_Type) GetFRAMEDELAYMAX() uint32 {
	return volatile.LoadUint32(&o.FRAMEDELAYMAX.Reg) & 0xfffff
}

// NFCT.FRAMEDELAYMODE: Configuration register for the Frame Delay Timer
func (o *NFCT_Type) SetFRAMEDELAYMODE(value uint32) {
	volatile.StoreUint32(&o.FRAMEDELAYMODE.Reg, volatile.LoadUint32(&o.FRAMEDELAYMODE.Reg)&^(0x3)|value)
}
func (o *NFCT_Type) GetFRAMEDELAYMODE() uint32 {
	return volatile.LoadUint32(&o.FRAMEDELAYMODE.Reg) & 0x3
}

// NFCT.PACKETPTR: Packet pointer for TXD and RXD data storage in Data RAM
func (o *NFCT_Type) SetPACKETPTR(value uint32) {
	volatile.StoreUint32(&o.PACKETPTR.Reg, value)
}
func (o *NFCT_Type) GetPACKETPTR() uint32 {
	return volatile.LoadUint32(&o.PACKETPTR.Reg)
}

// NFCT.MAXLEN: Size of the RAM buffer allocated to TXD and RXD data storage each
func (o *NFCT_Type) SetMAXLEN(value uint32) {
	volatile.StoreUint32(&o.MAXLEN.Reg, volatile.LoadUint32(&o.MAXLEN.Reg)&^(0x1ff)|value)
}
func (o *NFCT_Type) GetMAXLEN() uint32 {
	return volatile.LoadUint32(&o.MAXLEN.Reg) & 0x1ff
}

// NFCT.MODULATIONCTRL: Enables the modulation output to a GPIO pin which can be connected to a second external antenna.
func (o *NFCT_Type) SetMODULATIONCTRL(value uint32) {
	volatile.StoreUint32(&o.MODULATIONCTRL.Reg, volatile.LoadUint32(&o.MODULATIONCTRL.Reg)&^(0x3)|value)
}
func (o *NFCT_Type) GetMODULATIONCTRL() uint32 {
	return volatile.LoadUint32(&o.MODULATIONCTRL.Reg) & 0x3
}

// NFCT.MODULATIONPSEL: Pin select for Modulation control.
func (o *NFCT_Type) SetMODULATIONPSEL_PIN(value uint32) {
	volatile.StoreUint32(&o.MODULATIONPSEL.Reg, volatile.LoadUint32(&o.MODULATIONPSEL.Reg)&^(0x1f)|value)
}
func (o *NFCT_Type) GetMODULATIONPSEL_PIN() uint32 {
	return volatile.LoadUint32(&o.MODULATIONPSEL.Reg) & 0x1f
}
func (o *NFCT_Type) SetMODULATIONPSEL_PORT(value uint32) {
	volatile.StoreUint32(&o.MODULATIONPSEL.Reg, volatile.LoadUint32(&o.MODULATIONPSEL.Reg)&^(0x60)|value<<5)
}
func (o *NFCT_Type) GetMODULATIONPSEL_PORT() uint32 {
	return (volatile.LoadUint32(&o.MODULATIONPSEL.Reg) & 0x60) >> 5
}
func (o *NFCT_Type) SetMODULATIONPSEL_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MODULATIONPSEL.Reg, volatile.LoadUint32(&o.MODULATIONPSEL.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetMODULATIONPSEL_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MODULATIONPSEL.Reg) & 0x80000000) >> 31
}

// NFCT.NFCID1_LAST: Last NFCID1 part (4, 7 or 10 bytes ID)
func (o *NFCT_Type) SetNFCID1_LAST_NFCID1_Z(value uint32) {
	volatile.StoreUint32(&o.NFCID1_LAST.Reg, volatile.LoadUint32(&o.NFCID1_LAST.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetNFCID1_LAST_NFCID1_Z() uint32 {
	return volatile.LoadUint32(&o.NFCID1_LAST.Reg) & 0xff
}
func (o *NFCT_Type) SetNFCID1_LAST_NFCID1_Y(value uint32) {
	volatile.StoreUint32(&o.NFCID1_LAST.Reg, volatile.LoadUint32(&o.NFCID1_LAST.Reg)&^(0xff00)|value<<8)
}
func (o *NFCT_Type) GetNFCID1_LAST_NFCID1_Y() uint32 {
	return (volatile.LoadUint32(&o.NFCID1_LAST.Reg) & 0xff00) >> 8
}
func (o *NFCT_Type) SetNFCID1_LAST_NFCID1_X(value uint32) {
	volatile.StoreUint32(&o.NFCID1_LAST.Reg, volatile.LoadUint32(&o.NFCID1_LAST.Reg)&^(0xff0000)|value<<16)
}
func (o *NFCT_Type) GetNFCID1_LAST_NFCID1_X() uint32 {
	return (volatile.LoadUint32(&o.NFCID1_LAST.Reg) & 0xff0000) >> 16
}
func (o *NFCT_Type) SetNFCID1_LAST_NFCID1_W(value uint32) {
	volatile.StoreUint32(&o.NFCID1_LAST.Reg, volatile.LoadUint32(&o.NFCID1_LAST.Reg)&^(0xff000000)|value<<24)
}
func (o *NFCT_Type) GetNFCID1_LAST_NFCID1_W() uint32 {
	return (volatile.LoadUint32(&o.NFCID1_LAST.Reg) & 0xff000000) >> 24
}

// NFCT.NFCID1_2ND_LAST: Second last NFCID1 part (7 or 10 bytes ID)
func (o *NFCT_Type) SetNFCID1_2ND_LAST_NFCID1_V(value uint32) {
	volatile.StoreUint32(&o.NFCID1_2ND_LAST.Reg, volatile.LoadUint32(&o.NFCID1_2ND_LAST.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetNFCID1_2ND_LAST_NFCID1_V() uint32 {
	return volatile.LoadUint32(&o.NFCID1_2ND_LAST.Reg) & 0xff
}
func (o *NFCT_Type) SetNFCID1_2ND_LAST_NFCID1_U(value uint32) {
	volatile.StoreUint32(&o.NFCID1_2ND_LAST.Reg, volatile.LoadUint32(&o.NFCID1_2ND_LAST.Reg)&^(0xff00)|value<<8)
}
func (o *NFCT_Type) GetNFCID1_2ND_LAST_NFCID1_U() uint32 {
	return (volatile.LoadUint32(&o.NFCID1_2ND_LAST.Reg) & 0xff00) >> 8
}
func (o *NFCT_Type) SetNFCID1_2ND_LAST_NFCID1_T(value uint32) {
	volatile.StoreUint32(&o.NFCID1_2ND_LAST.Reg, volatile.LoadUint32(&o.NFCID1_2ND_LAST.Reg)&^(0xff0000)|value<<16)
}
func (o *NFCT_Type) GetNFCID1_2ND_LAST_NFCID1_T() uint32 {
	return (volatile.LoadUint32(&o.NFCID1_2ND_LAST.Reg) & 0xff0000) >> 16
}

// NFCT.NFCID1_3RD_LAST: Third last NFCID1 part (10 bytes ID)
func (o *NFCT_Type) SetNFCID1_3RD_LAST_NFCID1_S(value uint32) {
	volatile.StoreUint32(&o.NFCID1_3RD_LAST.Reg, volatile.LoadUint32(&o.NFCID1_3RD_LAST.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetNFCID1_3RD_LAST_NFCID1_S() uint32 {
	return volatile.LoadUint32(&o.NFCID1_3RD_LAST.Reg) & 0xff
}
func (o *NFCT_Type) SetNFCID1_3RD_LAST_NFCID1_R(value uint32) {
	volatile.StoreUint32(&o.NFCID1_3RD_LAST.Reg, volatile.LoadUint32(&o.NFCID1_3RD_LAST.Reg)&^(0xff00)|value<<8)
}
func (o *NFCT_Type) GetNFCID1_3RD_LAST_NFCID1_R() uint32 {
	return (volatile.LoadUint32(&o.NFCID1_3RD_LAST.Reg) & 0xff00) >> 8
}
func (o *NFCT_Type) SetNFCID1_3RD_LAST_NFCID1_Q(value uint32) {
	volatile.StoreUint32(&o.NFCID1_3RD_LAST.Reg, volatile.LoadUint32(&o.NFCID1_3RD_LAST.Reg)&^(0xff0000)|value<<16)
}
func (o *NFCT_Type) GetNFCID1_3RD_LAST_NFCID1_Q() uint32 {
	return (volatile.LoadUint32(&o.NFCID1_3RD_LAST.Reg) & 0xff0000) >> 16
}

// NFCT.AUTOCOLRESCONFIG: Controls the auto collision resolution function. This setting must be done before the NFCT peripheral is activated.
func (o *NFCT_Type) SetAUTOCOLRESCONFIG_MODE(value uint32) {
	volatile.StoreUint32(&o.AUTOCOLRESCONFIG.Reg, volatile.LoadUint32(&o.AUTOCOLRESCONFIG.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetAUTOCOLRESCONFIG_MODE() uint32 {
	return volatile.LoadUint32(&o.AUTOCOLRESCONFIG.Reg) & 0x1
}

// NFCT.SENSRES: NFC-A SENS_RES auto-response settings
func (o *NFCT_Type) SetSENSRES_BITFRAMESDD(value uint32) {
	volatile.StoreUint32(&o.SENSRES.Reg, volatile.LoadUint32(&o.SENSRES.Reg)&^(0x1f)|value)
}
func (o *NFCT_Type) GetSENSRES_BITFRAMESDD() uint32 {
	return volatile.LoadUint32(&o.SENSRES.Reg) & 0x1f
}
func (o *NFCT_Type) SetSENSRES_RFU5(value uint32) {
	volatile.StoreUint32(&o.SENSRES.Reg, volatile.LoadUint32(&o.SENSRES.Reg)&^(0x20)|value<<5)
}
func (o *NFCT_Type) GetSENSRES_RFU5() uint32 {
	return (volatile.LoadUint32(&o.SENSRES.Reg) & 0x20) >> 5
}
func (o *NFCT_Type) SetSENSRES_NFCIDSIZE(value uint32) {
	volatile.StoreUint32(&o.SENSRES.Reg, volatile.LoadUint32(&o.SENSRES.Reg)&^(0xc0)|value<<6)
}
func (o *NFCT_Type) GetSENSRES_NFCIDSIZE() uint32 {
	return (volatile.LoadUint32(&o.SENSRES.Reg) & 0xc0) >> 6
}
func (o *NFCT_Type) SetSENSRES_PLATFCONFIG(value uint32) {
	volatile.StoreUint32(&o.SENSRES.Reg, volatile.LoadUint32(&o.SENSRES.Reg)&^(0xf00)|value<<8)
}
func (o *NFCT_Type) GetSENSRES_PLATFCONFIG() uint32 {
	return (volatile.LoadUint32(&o.SENSRES.Reg) & 0xf00) >> 8
}
func (o *NFCT_Type) SetSENSRES_RFU74(value uint32) {
	volatile.StoreUint32(&o.SENSRES.Reg, volatile.LoadUint32(&o.SENSRES.Reg)&^(0xf000)|value<<12)
}
func (o *NFCT_Type) GetSENSRES_RFU74() uint32 {
	return (volatile.LoadUint32(&o.SENSRES.Reg) & 0xf000) >> 12
}

// NFCT.SELRES: NFC-A SEL_RES auto-response settings
func (o *NFCT_Type) SetSELRES_RFU10(value uint32) {
	volatile.StoreUint32(&o.SELRES.Reg, volatile.LoadUint32(&o.SELRES.Reg)&^(0x3)|value)
}
func (o *NFCT_Type) GetSELRES_RFU10() uint32 {
	return volatile.LoadUint32(&o.SELRES.Reg) & 0x3
}
func (o *NFCT_Type) SetSELRES_CASCADE(value uint32) {
	volatile.StoreUint32(&o.SELRES.Reg, volatile.LoadUint32(&o.SELRES.Reg)&^(0x4)|value<<2)
}
func (o *NFCT_Type) GetSELRES_CASCADE() uint32 {
	return (volatile.LoadUint32(&o.SELRES.Reg) & 0x4) >> 2
}
func (o *NFCT_Type) SetSELRES_RFU43(value uint32) {
	volatile.StoreUint32(&o.SELRES.Reg, volatile.LoadUint32(&o.SELRES.Reg)&^(0x18)|value<<3)
}
func (o *NFCT_Type) GetSELRES_RFU43() uint32 {
	return (volatile.LoadUint32(&o.SELRES.Reg) & 0x18) >> 3
}
func (o *NFCT_Type) SetSELRES_PROTOCOL(value uint32) {
	volatile.StoreUint32(&o.SELRES.Reg, volatile.LoadUint32(&o.SELRES.Reg)&^(0x60)|value<<5)
}
func (o *NFCT_Type) GetSELRES_PROTOCOL() uint32 {
	return (volatile.LoadUint32(&o.SELRES.Reg) & 0x60) >> 5
}
func (o *NFCT_Type) SetSELRES_RFU7(value uint32) {
	volatile.StoreUint32(&o.SELRES.Reg, volatile.LoadUint32(&o.SELRES.Reg)&^(0x80)|value<<7)
}
func (o *NFCT_Type) GetSELRES_RFU7() uint32 {
	return (volatile.LoadUint32(&o.SELRES.Reg) & 0x80) >> 7
}

type NFCT_FRAMESTATUS_Type struct {
	RX volatile.Register32 // 0x40C
}

// NFCT_FRAMESTATUS.RX: Result of last incoming frame
func (o *NFCT_FRAMESTATUS_Type) SetRX_CRCERROR(value uint32) {
	volatile.StoreUint32(&o.RX.Reg, volatile.LoadUint32(&o.RX.Reg)&^(0x1)|value)
}
func (o *NFCT_FRAMESTATUS_Type) GetRX_CRCERROR() uint32 {
	return volatile.LoadUint32(&o.RX.Reg) & 0x1
}
func (o *NFCT_FRAMESTATUS_Type) SetRX_PARITYSTATUS(value uint32) {
	volatile.StoreUint32(&o.RX.Reg, volatile.LoadUint32(&o.RX.Reg)&^(0x4)|value<<2)
}
func (o *NFCT_FRAMESTATUS_Type) GetRX_PARITYSTATUS() uint32 {
	return (volatile.LoadUint32(&o.RX.Reg) & 0x4) >> 2
}
func (o *NFCT_FRAMESTATUS_Type) SetRX_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.RX.Reg, volatile.LoadUint32(&o.RX.Reg)&^(0x8)|value<<3)
}
func (o *NFCT_FRAMESTATUS_Type) GetRX_OVERRUN() uint32 {
	return (volatile.LoadUint32(&o.RX.Reg) & 0x8) >> 3
}

type NFCT_TXD_Type struct {
	FRAMECONFIG volatile.Register32 // 0x518
	AMOUNT      volatile.Register32 // 0x51C
}

// NFCT_TXD.FRAMECONFIG: Configuration of outgoing frames
func (o *NFCT_TXD_Type) SetFRAMECONFIG_PARITY(value uint32) {
	volatile.StoreUint32(&o.FRAMECONFIG.Reg, volatile.LoadUint32(&o.FRAMECONFIG.Reg)&^(0x1)|value)
}
func (o *NFCT_TXD_Type) GetFRAMECONFIG_PARITY() uint32 {
	return volatile.LoadUint32(&o.FRAMECONFIG.Reg) & 0x1
}
func (o *NFCT_TXD_Type) SetFRAMECONFIG_DISCARDMODE(value uint32) {
	volatile.StoreUint32(&o.FRAMECONFIG.Reg, volatile.LoadUint32(&o.FRAMECONFIG.Reg)&^(0x2)|value<<1)
}
func (o *NFCT_TXD_Type) GetFRAMECONFIG_DISCARDMODE() uint32 {
	return (volatile.LoadUint32(&o.FRAMECONFIG.Reg) & 0x2) >> 1
}
func (o *NFCT_TXD_Type) SetFRAMECONFIG_SOF(value uint32) {
	volatile.StoreUint32(&o.FRAMECONFIG.Reg, volatile.LoadUint32(&o.FRAMECONFIG.Reg)&^(0x4)|value<<2)
}
func (o *NFCT_TXD_Type) GetFRAMECONFIG_SOF() uint32 {
	return (volatile.LoadUint32(&o.FRAMECONFIG.Reg) & 0x4) >> 2
}
func (o *NFCT_TXD_Type) SetFRAMECONFIG_CRCMODETX(value uint32) {
	volatile.StoreUint32(&o.FRAMECONFIG.Reg, volatile.LoadUint32(&o.FRAMECONFIG.Reg)&^(0x10)|value<<4)
}
func (o *NFCT_TXD_Type) GetFRAMECONFIG_CRCMODETX() uint32 {
	return (volatile.LoadUint32(&o.FRAMECONFIG.Reg) & 0x10) >> 4
}

// NFCT_TXD.AMOUNT: Size of outgoing frame
func (o *NFCT_TXD_Type) SetAMOUNT_TXDATABITS(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x7)|value)
}
func (o *NFCT_TXD_Type) GetAMOUNT_TXDATABITS() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x7
}
func (o *NFCT_TXD_Type) SetAMOUNT_TXDATABYTES(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xff8)|value<<3)
}
func (o *NFCT_TXD_Type) GetAMOUNT_TXDATABYTES() uint32 {
	return (volatile.LoadUint32(&o.AMOUNT.Reg) & 0xff8) >> 3
}

type NFCT_RXD_Type struct {
	FRAMECONFIG volatile.Register32 // 0x520
	AMOUNT      volatile.Register32 // 0x524
}

// NFCT_RXD.FRAMECONFIG: Configuration of incoming frames
func (o *NFCT_RXD_Type) SetFRAMECONFIG_PARITY(value uint32) {
	volatile.StoreUint32(&o.FRAMECONFIG.Reg, volatile.LoadUint32(&o.FRAMECONFIG.Reg)&^(0x1)|value)
}
func (o *NFCT_RXD_Type) GetFRAMECONFIG_PARITY() uint32 {
	return volatile.LoadUint32(&o.FRAMECONFIG.Reg) & 0x1
}
func (o *NFCT_RXD_Type) SetFRAMECONFIG_SOF(value uint32) {
	volatile.StoreUint32(&o.FRAMECONFIG.Reg, volatile.LoadUint32(&o.FRAMECONFIG.Reg)&^(0x4)|value<<2)
}
func (o *NFCT_RXD_Type) GetFRAMECONFIG_SOF() uint32 {
	return (volatile.LoadUint32(&o.FRAMECONFIG.Reg) & 0x4) >> 2
}
func (o *NFCT_RXD_Type) SetFRAMECONFIG_CRCMODERX(value uint32) {
	volatile.StoreUint32(&o.FRAMECONFIG.Reg, volatile.LoadUint32(&o.FRAMECONFIG.Reg)&^(0x10)|value<<4)
}
func (o *NFCT_RXD_Type) GetFRAMECONFIG_CRCMODERX() uint32 {
	return (volatile.LoadUint32(&o.FRAMECONFIG.Reg) & 0x10) >> 4
}

// NFCT_RXD.AMOUNT: Size of last incoming frame
func (o *NFCT_RXD_Type) SetAMOUNT_RXDATABITS(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x7)|value)
}
func (o *NFCT_RXD_Type) GetAMOUNT_RXDATABITS() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x7
}
func (o *NFCT_RXD_Type) SetAMOUNT_RXDATABYTES(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xff8)|value<<3)
}
func (o *NFCT_RXD_Type) GetAMOUNT_RXDATABYTES() uint32 {
	return (volatile.LoadUint32(&o.AMOUNT.Reg) & 0xff8) >> 3
}

// MUTEX 0
type MUTEX_Type struct {
	_     [1024]byte
	MUTEX [16]volatile.Register32 // 0x400
}

// MUTEX.MUTEX: Description collection: Mutex register
func (o *MUTEX_Type) SetMUTEX(idx int, value uint32) {
	volatile.StoreUint32(&o.MUTEX[idx].Reg, volatile.LoadUint32(&o.MUTEX[idx].Reg)&^(0x1)|value)
}
func (o *MUTEX_Type) GetMUTEX(idx int) uint32 {
	return volatile.LoadUint32(&o.MUTEX[idx].Reg) & 0x1
}

// Quadrature Decoder 0
type QDEC_Type struct {
	TASKS_START          volatile.Register32 // 0x0
	TASKS_STOP           volatile.Register32 // 0x4
	TASKS_READCLRACC     volatile.Register32 // 0x8
	TASKS_RDCLRACC       volatile.Register32 // 0xC
	TASKS_RDCLRDBL       volatile.Register32 // 0x10
	_                    [108]byte
	SUBSCRIBE_START      volatile.Register32 // 0x80
	SUBSCRIBE_STOP       volatile.Register32 // 0x84
	SUBSCRIBE_READCLRACC volatile.Register32 // 0x88
	SUBSCRIBE_RDCLRACC   volatile.Register32 // 0x8C
	SUBSCRIBE_RDCLRDBL   volatile.Register32 // 0x90
	_                    [108]byte
	EVENTS_SAMPLERDY     volatile.Register32 // 0x100
	EVENTS_REPORTRDY     volatile.Register32 // 0x104
	EVENTS_ACCOF         volatile.Register32 // 0x108
	EVENTS_DBLRDY        volatile.Register32 // 0x10C
	EVENTS_STOPPED       volatile.Register32 // 0x110
	_                    [108]byte
	PUBLISH_SAMPLERDY    volatile.Register32 // 0x180
	PUBLISH_REPORTRDY    volatile.Register32 // 0x184
	PUBLISH_ACCOF        volatile.Register32 // 0x188
	PUBLISH_DBLRDY       volatile.Register32 // 0x18C
	PUBLISH_STOPPED      volatile.Register32 // 0x190
	_                    [108]byte
	SHORTS               volatile.Register32 // 0x200
	_                    [256]byte
	INTENSET             volatile.Register32 // 0x304
	INTENCLR             volatile.Register32 // 0x308
	_                    [500]byte
	ENABLE               volatile.Register32 // 0x500
	LEDPOL               volatile.Register32 // 0x504
	SAMPLEPER            volatile.Register32 // 0x508
	SAMPLE               volatile.Register32 // 0x50C
	REPORTPER            volatile.Register32 // 0x510
	ACC                  volatile.Register32 // 0x514
	ACCREAD              volatile.Register32 // 0x518
	PSEL                 QDEC_PSEL_Type      // 0x51C
	DBFEN                volatile.Register32 // 0x528
	_                    [20]byte
	LEDPRE               volatile.Register32 // 0x540
	ACCDBL               volatile.Register32 // 0x544
	ACCDBLREAD           volatile.Register32 // 0x548
}

// QDEC.TASKS_START: Task starting the quadrature decoder
func (o *QDEC_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// QDEC.TASKS_STOP: Task stopping the quadrature decoder
func (o *QDEC_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// QDEC.TASKS_READCLRACC: Read and clear ACC and ACCDBL
func (o *QDEC_Type) SetTASKS_READCLRACC(value uint32) {
	volatile.StoreUint32(&o.TASKS_READCLRACC.Reg, volatile.LoadUint32(&o.TASKS_READCLRACC.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetTASKS_READCLRACC() uint32 {
	return volatile.LoadUint32(&o.TASKS_READCLRACC.Reg) & 0x1
}

// QDEC.TASKS_RDCLRACC: Read and clear ACC
func (o *QDEC_Type) SetTASKS_RDCLRACC(value uint32) {
	volatile.StoreUint32(&o.TASKS_RDCLRACC.Reg, volatile.LoadUint32(&o.TASKS_RDCLRACC.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetTASKS_RDCLRACC() uint32 {
	return volatile.LoadUint32(&o.TASKS_RDCLRACC.Reg) & 0x1
}

// QDEC.TASKS_RDCLRDBL: Read and clear ACCDBL
func (o *QDEC_Type) SetTASKS_RDCLRDBL(value uint32) {
	volatile.StoreUint32(&o.TASKS_RDCLRDBL.Reg, volatile.LoadUint32(&o.TASKS_RDCLRDBL.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetTASKS_RDCLRDBL() uint32 {
	return volatile.LoadUint32(&o.TASKS_RDCLRDBL.Reg) & 0x1
}

// QDEC.SUBSCRIBE_START: Subscribe configuration for task START
func (o *QDEC_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xff)|value)
}
func (o *QDEC_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xff
}
func (o *QDEC_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *QDEC_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// QDEC.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *QDEC_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *QDEC_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *QDEC_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *QDEC_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// QDEC.SUBSCRIBE_READCLRACC: Subscribe configuration for task READCLRACC
func (o *QDEC_Type) SetSUBSCRIBE_READCLRACC_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_READCLRACC.Reg, volatile.LoadUint32(&o.SUBSCRIBE_READCLRACC.Reg)&^(0xff)|value)
}
func (o *QDEC_Type) GetSUBSCRIBE_READCLRACC_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_READCLRACC.Reg) & 0xff
}
func (o *QDEC_Type) SetSUBSCRIBE_READCLRACC_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_READCLRACC.Reg, volatile.LoadUint32(&o.SUBSCRIBE_READCLRACC.Reg)&^(0x80000000)|value<<31)
}
func (o *QDEC_Type) GetSUBSCRIBE_READCLRACC_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_READCLRACC.Reg) & 0x80000000) >> 31
}

// QDEC.SUBSCRIBE_RDCLRACC: Subscribe configuration for task RDCLRACC
func (o *QDEC_Type) SetSUBSCRIBE_RDCLRACC_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RDCLRACC.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RDCLRACC.Reg)&^(0xff)|value)
}
func (o *QDEC_Type) GetSUBSCRIBE_RDCLRACC_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_RDCLRACC.Reg) & 0xff
}
func (o *QDEC_Type) SetSUBSCRIBE_RDCLRACC_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RDCLRACC.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RDCLRACC.Reg)&^(0x80000000)|value<<31)
}
func (o *QDEC_Type) GetSUBSCRIBE_RDCLRACC_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_RDCLRACC.Reg) & 0x80000000) >> 31
}

// QDEC.SUBSCRIBE_RDCLRDBL: Subscribe configuration for task RDCLRDBL
func (o *QDEC_Type) SetSUBSCRIBE_RDCLRDBL_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RDCLRDBL.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RDCLRDBL.Reg)&^(0xff)|value)
}
func (o *QDEC_Type) GetSUBSCRIBE_RDCLRDBL_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_RDCLRDBL.Reg) & 0xff
}
func (o *QDEC_Type) SetSUBSCRIBE_RDCLRDBL_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RDCLRDBL.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RDCLRDBL.Reg)&^(0x80000000)|value<<31)
}
func (o *QDEC_Type) GetSUBSCRIBE_RDCLRDBL_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_RDCLRDBL.Reg) & 0x80000000) >> 31
}

// QDEC.EVENTS_SAMPLERDY: Event being generated for every new sample value written to the SAMPLE register
func (o *QDEC_Type) SetEVENTS_SAMPLERDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SAMPLERDY.Reg, volatile.LoadUint32(&o.EVENTS_SAMPLERDY.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetEVENTS_SAMPLERDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SAMPLERDY.Reg) & 0x1
}

// QDEC.EVENTS_REPORTRDY: Non-null report ready
func (o *QDEC_Type) SetEVENTS_REPORTRDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_REPORTRDY.Reg, volatile.LoadUint32(&o.EVENTS_REPORTRDY.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetEVENTS_REPORTRDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_REPORTRDY.Reg) & 0x1
}

// QDEC.EVENTS_ACCOF: ACC or ACCDBL register overflow
func (o *QDEC_Type) SetEVENTS_ACCOF(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ACCOF.Reg, volatile.LoadUint32(&o.EVENTS_ACCOF.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetEVENTS_ACCOF() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ACCOF.Reg) & 0x1
}

// QDEC.EVENTS_DBLRDY: Double displacement(s) detected
func (o *QDEC_Type) SetEVENTS_DBLRDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DBLRDY.Reg, volatile.LoadUint32(&o.EVENTS_DBLRDY.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetEVENTS_DBLRDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DBLRDY.Reg) & 0x1
}

// QDEC.EVENTS_STOPPED: QDEC has been stopped
func (o *QDEC_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// QDEC.PUBLISH_SAMPLERDY: Publish configuration for event SAMPLERDY
func (o *QDEC_Type) SetPUBLISH_SAMPLERDY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SAMPLERDY.Reg, volatile.LoadUint32(&o.PUBLISH_SAMPLERDY.Reg)&^(0xff)|value)
}
func (o *QDEC_Type) GetPUBLISH_SAMPLERDY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_SAMPLERDY.Reg) & 0xff
}
func (o *QDEC_Type) SetPUBLISH_SAMPLERDY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SAMPLERDY.Reg, volatile.LoadUint32(&o.PUBLISH_SAMPLERDY.Reg)&^(0x80000000)|value<<31)
}
func (o *QDEC_Type) GetPUBLISH_SAMPLERDY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_SAMPLERDY.Reg) & 0x80000000) >> 31
}

// QDEC.PUBLISH_REPORTRDY: Publish configuration for event REPORTRDY
func (o *QDEC_Type) SetPUBLISH_REPORTRDY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_REPORTRDY.Reg, volatile.LoadUint32(&o.PUBLISH_REPORTRDY.Reg)&^(0xff)|value)
}
func (o *QDEC_Type) GetPUBLISH_REPORTRDY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_REPORTRDY.Reg) & 0xff
}
func (o *QDEC_Type) SetPUBLISH_REPORTRDY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_REPORTRDY.Reg, volatile.LoadUint32(&o.PUBLISH_REPORTRDY.Reg)&^(0x80000000)|value<<31)
}
func (o *QDEC_Type) GetPUBLISH_REPORTRDY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_REPORTRDY.Reg) & 0x80000000) >> 31
}

// QDEC.PUBLISH_ACCOF: Publish configuration for event ACCOF
func (o *QDEC_Type) SetPUBLISH_ACCOF_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ACCOF.Reg, volatile.LoadUint32(&o.PUBLISH_ACCOF.Reg)&^(0xff)|value)
}
func (o *QDEC_Type) GetPUBLISH_ACCOF_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ACCOF.Reg) & 0xff
}
func (o *QDEC_Type) SetPUBLISH_ACCOF_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ACCOF.Reg, volatile.LoadUint32(&o.PUBLISH_ACCOF.Reg)&^(0x80000000)|value<<31)
}
func (o *QDEC_Type) GetPUBLISH_ACCOF_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ACCOF.Reg) & 0x80000000) >> 31
}

// QDEC.PUBLISH_DBLRDY: Publish configuration for event DBLRDY
func (o *QDEC_Type) SetPUBLISH_DBLRDY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DBLRDY.Reg, volatile.LoadUint32(&o.PUBLISH_DBLRDY.Reg)&^(0xff)|value)
}
func (o *QDEC_Type) GetPUBLISH_DBLRDY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_DBLRDY.Reg) & 0xff
}
func (o *QDEC_Type) SetPUBLISH_DBLRDY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DBLRDY.Reg, volatile.LoadUint32(&o.PUBLISH_DBLRDY.Reg)&^(0x80000000)|value<<31)
}
func (o *QDEC_Type) GetPUBLISH_DBLRDY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_DBLRDY.Reg) & 0x80000000) >> 31
}

// QDEC.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *QDEC_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xff)|value)
}
func (o *QDEC_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xff
}
func (o *QDEC_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *QDEC_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// QDEC.SHORTS: Shortcuts between local events and tasks
func (o *QDEC_Type) SetSHORTS_REPORTRDY_READCLRACC(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetSHORTS_REPORTRDY_READCLRACC() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *QDEC_Type) SetSHORTS_SAMPLERDY_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *QDEC_Type) GetSHORTS_SAMPLERDY_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *QDEC_Type) SetSHORTS_REPORTRDY_RDCLRACC(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *QDEC_Type) GetSHORTS_REPORTRDY_RDCLRACC() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *QDEC_Type) SetSHORTS_REPORTRDY_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *QDEC_Type) GetSHORTS_REPORTRDY_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}
func (o *QDEC_Type) SetSHORTS_DBLRDY_RDCLRDBL(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10)|value<<4)
}
func (o *QDEC_Type) GetSHORTS_DBLRDY_RDCLRDBL() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10) >> 4
}
func (o *QDEC_Type) SetSHORTS_DBLRDY_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20)|value<<5)
}
func (o *QDEC_Type) GetSHORTS_DBLRDY_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20) >> 5
}
func (o *QDEC_Type) SetSHORTS_SAMPLERDY_READCLRACC(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x40)|value<<6)
}
func (o *QDEC_Type) GetSHORTS_SAMPLERDY_READCLRACC() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x40) >> 6
}

// QDEC.INTENSET: Enable interrupt
func (o *QDEC_Type) SetINTENSET_SAMPLERDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetINTENSET_SAMPLERDY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *QDEC_Type) SetINTENSET_REPORTRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *QDEC_Type) GetINTENSET_REPORTRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *QDEC_Type) SetINTENSET_ACCOF(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *QDEC_Type) GetINTENSET_ACCOF() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *QDEC_Type) SetINTENSET_DBLRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *QDEC_Type) GetINTENSET_DBLRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *QDEC_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *QDEC_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}

// QDEC.INTENCLR: Disable interrupt
func (o *QDEC_Type) SetINTENCLR_SAMPLERDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetINTENCLR_SAMPLERDY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *QDEC_Type) SetINTENCLR_REPORTRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *QDEC_Type) GetINTENCLR_REPORTRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *QDEC_Type) SetINTENCLR_ACCOF(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *QDEC_Type) GetINTENCLR_ACCOF() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *QDEC_Type) SetINTENCLR_DBLRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *QDEC_Type) GetINTENCLR_DBLRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *QDEC_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *QDEC_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}

// QDEC.ENABLE: Enable the quadrature decoder
func (o *QDEC_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// QDEC.LEDPOL: LED output pin polarity
func (o *QDEC_Type) SetLEDPOL(value uint32) {
	volatile.StoreUint32(&o.LEDPOL.Reg, volatile.LoadUint32(&o.LEDPOL.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetLEDPOL() uint32 {
	return volatile.LoadUint32(&o.LEDPOL.Reg) & 0x1
}

// QDEC.SAMPLEPER: Sample period
func (o *QDEC_Type) SetSAMPLEPER(value uint32) {
	volatile.StoreUint32(&o.SAMPLEPER.Reg, volatile.LoadUint32(&o.SAMPLEPER.Reg)&^(0xf)|value)
}
func (o *QDEC_Type) GetSAMPLEPER() uint32 {
	return volatile.LoadUint32(&o.SAMPLEPER.Reg) & 0xf
}

// QDEC.SAMPLE: Motion sample value
func (o *QDEC_Type) SetSAMPLE(value uint32) {
	volatile.StoreUint32(&o.SAMPLE.Reg, value)
}
func (o *QDEC_Type) GetSAMPLE() uint32 {
	return volatile.LoadUint32(&o.SAMPLE.Reg)
}

// QDEC.REPORTPER: Number of samples to be taken before REPORTRDY and DBLRDY events can be generated
func (o *QDEC_Type) SetREPORTPER(value uint32) {
	volatile.StoreUint32(&o.REPORTPER.Reg, volatile.LoadUint32(&o.REPORTPER.Reg)&^(0xf)|value)
}
func (o *QDEC_Type) GetREPORTPER() uint32 {
	return volatile.LoadUint32(&o.REPORTPER.Reg) & 0xf
}

// QDEC.ACC: Register accumulating the valid transitions
func (o *QDEC_Type) SetACC(value uint32) {
	volatile.StoreUint32(&o.ACC.Reg, value)
}
func (o *QDEC_Type) GetACC() uint32 {
	return volatile.LoadUint32(&o.ACC.Reg)
}

// QDEC.ACCREAD: Snapshot of the ACC register, updated by the READCLRACC or RDCLRACC task
func (o *QDEC_Type) SetACCREAD(value uint32) {
	volatile.StoreUint32(&o.ACCREAD.Reg, value)
}
func (o *QDEC_Type) GetACCREAD() uint32 {
	return volatile.LoadUint32(&o.ACCREAD.Reg)
}

// QDEC.DBFEN: Enable input debounce filters
func (o *QDEC_Type) SetDBFEN(value uint32) {
	volatile.StoreUint32(&o.DBFEN.Reg, volatile.LoadUint32(&o.DBFEN.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetDBFEN() uint32 {
	return volatile.LoadUint32(&o.DBFEN.Reg) & 0x1
}

// QDEC.LEDPRE: Time period the LED is switched ON prior to sampling
func (o *QDEC_Type) SetLEDPRE(value uint32) {
	volatile.StoreUint32(&o.LEDPRE.Reg, volatile.LoadUint32(&o.LEDPRE.Reg)&^(0x1ff)|value)
}
func (o *QDEC_Type) GetLEDPRE() uint32 {
	return volatile.LoadUint32(&o.LEDPRE.Reg) & 0x1ff
}

// QDEC.ACCDBL: Register accumulating the number of detected double transitions
func (o *QDEC_Type) SetACCDBL(value uint32) {
	volatile.StoreUint32(&o.ACCDBL.Reg, volatile.LoadUint32(&o.ACCDBL.Reg)&^(0xf)|value)
}
func (o *QDEC_Type) GetACCDBL() uint32 {
	return volatile.LoadUint32(&o.ACCDBL.Reg) & 0xf
}

// QDEC.ACCDBLREAD: Snapshot of the ACCDBL, updated by the READCLRACC or RDCLRDBL task
func (o *QDEC_Type) SetACCDBLREAD(value uint32) {
	volatile.StoreUint32(&o.ACCDBLREAD.Reg, volatile.LoadUint32(&o.ACCDBLREAD.Reg)&^(0xf)|value)
}
func (o *QDEC_Type) GetACCDBLREAD() uint32 {
	return volatile.LoadUint32(&o.ACCDBLREAD.Reg) & 0xf
}

type QDEC_PSEL_Type struct {
	LED volatile.Register32 // 0x51C
	A   volatile.Register32 // 0x520
	B   volatile.Register32 // 0x524
}

// QDEC_PSEL.LED: Pin select for LED signal
func (o *QDEC_PSEL_Type) SetLED_PIN(value uint32) {
	volatile.StoreUint32(&o.LED.Reg, volatile.LoadUint32(&o.LED.Reg)&^(0x1f)|value)
}
func (o *QDEC_PSEL_Type) GetLED_PIN() uint32 {
	return volatile.LoadUint32(&o.LED.Reg) & 0x1f
}
func (o *QDEC_PSEL_Type) SetLED_PORT(value uint32) {
	volatile.StoreUint32(&o.LED.Reg, volatile.LoadUint32(&o.LED.Reg)&^(0x20)|value<<5)
}
func (o *QDEC_PSEL_Type) GetLED_PORT() uint32 {
	return (volatile.LoadUint32(&o.LED.Reg) & 0x20) >> 5
}
func (o *QDEC_PSEL_Type) SetLED_CONNECT(value uint32) {
	volatile.StoreUint32(&o.LED.Reg, volatile.LoadUint32(&o.LED.Reg)&^(0x80000000)|value<<31)
}
func (o *QDEC_PSEL_Type) GetLED_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.LED.Reg) & 0x80000000) >> 31
}

// QDEC_PSEL.A: Pin select for A signal
func (o *QDEC_PSEL_Type) SetA_PIN(value uint32) {
	volatile.StoreUint32(&o.A.Reg, volatile.LoadUint32(&o.A.Reg)&^(0x1f)|value)
}
func (o *QDEC_PSEL_Type) GetA_PIN() uint32 {
	return volatile.LoadUint32(&o.A.Reg) & 0x1f
}
func (o *QDEC_PSEL_Type) SetA_PORT(value uint32) {
	volatile.StoreUint32(&o.A.Reg, volatile.LoadUint32(&o.A.Reg)&^(0x20)|value<<5)
}
func (o *QDEC_PSEL_Type) GetA_PORT() uint32 {
	return (volatile.LoadUint32(&o.A.Reg) & 0x20) >> 5
}
func (o *QDEC_PSEL_Type) SetA_CONNECT(value uint32) {
	volatile.StoreUint32(&o.A.Reg, volatile.LoadUint32(&o.A.Reg)&^(0x80000000)|value<<31)
}
func (o *QDEC_PSEL_Type) GetA_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.A.Reg) & 0x80000000) >> 31
}

// QDEC_PSEL.B: Pin select for B signal
func (o *QDEC_PSEL_Type) SetB_PIN(value uint32) {
	volatile.StoreUint32(&o.B.Reg, volatile.LoadUint32(&o.B.Reg)&^(0x1f)|value)
}
func (o *QDEC_PSEL_Type) GetB_PIN() uint32 {
	return volatile.LoadUint32(&o.B.Reg) & 0x1f
}
func (o *QDEC_PSEL_Type) SetB_PORT(value uint32) {
	volatile.StoreUint32(&o.B.Reg, volatile.LoadUint32(&o.B.Reg)&^(0x20)|value<<5)
}
func (o *QDEC_PSEL_Type) GetB_PORT() uint32 {
	return (volatile.LoadUint32(&o.B.Reg) & 0x20) >> 5
}
func (o *QDEC_PSEL_Type) SetB_CONNECT(value uint32) {
	volatile.StoreUint32(&o.B.Reg, volatile.LoadUint32(&o.B.Reg)&^(0x80000000)|value<<31)
}
func (o *QDEC_PSEL_Type) GetB_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.B.Reg) & 0x80000000) >> 31
}

// Universal serial bus device 0
type USBD_Type struct {
	_                     [4]byte
	TASKS_STARTEPIN       [8]volatile.Register32 // 0x4
	TASKS_STARTISOIN      volatile.Register32    // 0x24
	TASKS_STARTEPOUT      [8]volatile.Register32 // 0x28
	TASKS_STARTISOOUT     volatile.Register32    // 0x48
	TASKS_EP0RCVOUT       volatile.Register32    // 0x4C
	TASKS_EP0STATUS       volatile.Register32    // 0x50
	TASKS_EP0STALL        volatile.Register32    // 0x54
	TASKS_DPDMDRIVE       volatile.Register32    // 0x58
	TASKS_DPDMNODRIVE     volatile.Register32    // 0x5C
	_                     [36]byte
	SUBSCRIBE_STARTEPIN   [8]volatile.Register32 // 0x84
	SUBSCRIBE_STARTISOIN  volatile.Register32    // 0xA4
	SUBSCRIBE_STARTEPOUT  [8]volatile.Register32 // 0xA8
	SUBSCRIBE_STARTISOOUT volatile.Register32    // 0xC8
	SUBSCRIBE_EP0RCVOUT   volatile.Register32    // 0xCC
	SUBSCRIBE_EP0STATUS   volatile.Register32    // 0xD0
	SUBSCRIBE_EP0STALL    volatile.Register32    // 0xD4
	SUBSCRIBE_DPDMDRIVE   volatile.Register32    // 0xD8
	SUBSCRIBE_DPDMNODRIVE volatile.Register32    // 0xDC
	_                     [32]byte
	EVENTS_USBRESET       volatile.Register32    // 0x100
	EVENTS_STARTED        volatile.Register32    // 0x104
	EVENTS_ENDEPIN        [8]volatile.Register32 // 0x108
	EVENTS_EP0DATADONE    volatile.Register32    // 0x128
	EVENTS_ENDISOIN       volatile.Register32    // 0x12C
	EVENTS_ENDEPOUT       [8]volatile.Register32 // 0x130
	EVENTS_ENDISOOUT      volatile.Register32    // 0x150
	EVENTS_SOF            volatile.Register32    // 0x154
	EVENTS_USBEVENT       volatile.Register32    // 0x158
	EVENTS_EP0SETUP       volatile.Register32    // 0x15C
	EVENTS_EPDATA         volatile.Register32    // 0x160
	_                     [28]byte
	PUBLISH_USBRESET      volatile.Register32    // 0x180
	PUBLISH_STARTED       volatile.Register32    // 0x184
	PUBLISH_ENDEPIN       [8]volatile.Register32 // 0x188
	PUBLISH_EP0DATADONE   volatile.Register32    // 0x1A8
	PUBLISH_ENDISOIN      volatile.Register32    // 0x1AC
	PUBLISH_ENDEPOUT      [8]volatile.Register32 // 0x1B0
	PUBLISH_ENDISOOUT     volatile.Register32    // 0x1D0
	PUBLISH_SOF           volatile.Register32    // 0x1D4
	PUBLISH_USBEVENT      volatile.Register32    // 0x1D8
	PUBLISH_EP0SETUP      volatile.Register32    // 0x1DC
	PUBLISH_EPDATA        volatile.Register32    // 0x1E0
	_                     [28]byte
	SHORTS                volatile.Register32 // 0x200
	_                     [252]byte
	INTEN                 volatile.Register32 // 0x300
	INTENSET              volatile.Register32 // 0x304
	INTENCLR              volatile.Register32 // 0x308
	_                     [244]byte
	EVENTCAUSE            volatile.Register32 // 0x400
	_                     [28]byte
	HALTED                USBD_HALTED_Type // 0x420
	_                     [4]byte
	EPSTATUS              volatile.Register32 // 0x468
	EPDATASTATUS          volatile.Register32 // 0x46C
	USBADDR               volatile.Register32 // 0x470
	_                     [12]byte
	BMREQUESTTYPE         volatile.Register32 // 0x480
	BREQUEST              volatile.Register32 // 0x484
	WVALUEL               volatile.Register32 // 0x488
	WVALUEH               volatile.Register32 // 0x48C
	WINDEXL               volatile.Register32 // 0x490
	WINDEXH               volatile.Register32 // 0x494
	WLENGTHL              volatile.Register32 // 0x498
	WLENGTHH              volatile.Register32 // 0x49C
	SIZE                  USBD_SIZE_Type      // 0x4A0
	_                     [60]byte
	ENABLE                volatile.Register32 // 0x500
	USBPULLUP             volatile.Register32 // 0x504
	DPDMVALUE             volatile.Register32 // 0x508
	DTOGGLE               volatile.Register32 // 0x50C
	EPINEN                volatile.Register32 // 0x510
	EPOUTEN               volatile.Register32 // 0x514
	EPSTALL               volatile.Register32 // 0x518
	ISOSPLIT              volatile.Register32 // 0x51C
	FRAMECNTR             volatile.Register32 // 0x520
	_                     [8]byte
	LOWPOWER              volatile.Register32 // 0x52C
	ISOINCONFIG           volatile.Register32 // 0x530
	_                     [204]byte
	EPIN                  [8]USBD_EPIN_Type // 0x600
	ISOIN                 USBD_ISOIN_Type   // 0x6A0
	_                     [84]byte
	EPOUT                 [8]USBD_EPOUT_Type // 0x700
	ISOOUT                USBD_ISOOUT_Type   // 0x7A0
}

// USBD.TASKS_STARTEPIN: Description collection: Captures the EPIN[n].PTR and EPIN[n].MAXCNT registers values, and enables endpoint IN n to respond to traffic from host
func (o *USBD_Type) SetTASKS_STARTEPIN(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTEPIN[idx].Reg, volatile.LoadUint32(&o.TASKS_STARTEPIN[idx].Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetTASKS_STARTEPIN(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTEPIN[idx].Reg) & 0x1
}

// USBD.TASKS_STARTISOIN: Captures the ISOIN.PTR and ISOIN.MAXCNT registers values, and enables sending data on ISO endpoint
func (o *USBD_Type) SetTASKS_STARTISOIN(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTISOIN.Reg, volatile.LoadUint32(&o.TASKS_STARTISOIN.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetTASKS_STARTISOIN() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTISOIN.Reg) & 0x1
}

// USBD.TASKS_STARTEPOUT: Description collection: Captures the EPOUT[n].PTR and EPOUT[n].MAXCNT registers values, and enables endpoint n to respond to traffic from host
func (o *USBD_Type) SetTASKS_STARTEPOUT(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTEPOUT[idx].Reg, volatile.LoadUint32(&o.TASKS_STARTEPOUT[idx].Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetTASKS_STARTEPOUT(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTEPOUT[idx].Reg) & 0x1
}

// USBD.TASKS_STARTISOOUT: Captures the ISOOUT.PTR and ISOOUT.MAXCNT registers values, and enables receiving of data on ISO endpoint
func (o *USBD_Type) SetTASKS_STARTISOOUT(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTISOOUT.Reg, volatile.LoadUint32(&o.TASKS_STARTISOOUT.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetTASKS_STARTISOOUT() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTISOOUT.Reg) & 0x1
}

// USBD.TASKS_EP0RCVOUT: Allows OUT data stage on control endpoint 0
func (o *USBD_Type) SetTASKS_EP0RCVOUT(value uint32) {
	volatile.StoreUint32(&o.TASKS_EP0RCVOUT.Reg, volatile.LoadUint32(&o.TASKS_EP0RCVOUT.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetTASKS_EP0RCVOUT() uint32 {
	return volatile.LoadUint32(&o.TASKS_EP0RCVOUT.Reg) & 0x1
}

// USBD.TASKS_EP0STATUS: Allows status stage on control endpoint 0
func (o *USBD_Type) SetTASKS_EP0STATUS(value uint32) {
	volatile.StoreUint32(&o.TASKS_EP0STATUS.Reg, volatile.LoadUint32(&o.TASKS_EP0STATUS.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetTASKS_EP0STATUS() uint32 {
	return volatile.LoadUint32(&o.TASKS_EP0STATUS.Reg) & 0x1
}

// USBD.TASKS_EP0STALL: Stalls data and status stage on control endpoint 0
func (o *USBD_Type) SetTASKS_EP0STALL(value uint32) {
	volatile.StoreUint32(&o.TASKS_EP0STALL.Reg, volatile.LoadUint32(&o.TASKS_EP0STALL.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetTASKS_EP0STALL() uint32 {
	return volatile.LoadUint32(&o.TASKS_EP0STALL.Reg) & 0x1
}

// USBD.TASKS_DPDMDRIVE: Forces D+ and D- lines into the state defined in the DPDMVALUE register
func (o *USBD_Type) SetTASKS_DPDMDRIVE(value uint32) {
	volatile.StoreUint32(&o.TASKS_DPDMDRIVE.Reg, volatile.LoadUint32(&o.TASKS_DPDMDRIVE.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetTASKS_DPDMDRIVE() uint32 {
	return volatile.LoadUint32(&o.TASKS_DPDMDRIVE.Reg) & 0x1
}

// USBD.TASKS_DPDMNODRIVE: Stops forcing D+ and D- lines into any state (USB engine takes control)
func (o *USBD_Type) SetTASKS_DPDMNODRIVE(value uint32) {
	volatile.StoreUint32(&o.TASKS_DPDMNODRIVE.Reg, volatile.LoadUint32(&o.TASKS_DPDMNODRIVE.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetTASKS_DPDMNODRIVE() uint32 {
	return volatile.LoadUint32(&o.TASKS_DPDMNODRIVE.Reg) & 0x1
}

// USBD.SUBSCRIBE_STARTEPIN: Description collection: Subscribe configuration for task STARTEPIN[n]
func (o *USBD_Type) SetSUBSCRIBE_STARTEPIN_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTEPIN[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTEPIN[idx].Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetSUBSCRIBE_STARTEPIN_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STARTEPIN[idx].Reg) & 0xff
}
func (o *USBD_Type) SetSUBSCRIBE_STARTEPIN_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTEPIN[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTEPIN[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetSUBSCRIBE_STARTEPIN_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STARTEPIN[idx].Reg) & 0x80000000) >> 31
}

// USBD.SUBSCRIBE_STARTISOIN: Subscribe configuration for task STARTISOIN
func (o *USBD_Type) SetSUBSCRIBE_STARTISOIN_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTISOIN.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTISOIN.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetSUBSCRIBE_STARTISOIN_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STARTISOIN.Reg) & 0xff
}
func (o *USBD_Type) SetSUBSCRIBE_STARTISOIN_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTISOIN.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTISOIN.Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetSUBSCRIBE_STARTISOIN_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STARTISOIN.Reg) & 0x80000000) >> 31
}

// USBD.SUBSCRIBE_STARTEPOUT: Description collection: Subscribe configuration for task STARTEPOUT[n]
func (o *USBD_Type) SetSUBSCRIBE_STARTEPOUT_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTEPOUT[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTEPOUT[idx].Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetSUBSCRIBE_STARTEPOUT_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STARTEPOUT[idx].Reg) & 0xff
}
func (o *USBD_Type) SetSUBSCRIBE_STARTEPOUT_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTEPOUT[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTEPOUT[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetSUBSCRIBE_STARTEPOUT_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STARTEPOUT[idx].Reg) & 0x80000000) >> 31
}

// USBD.SUBSCRIBE_STARTISOOUT: Subscribe configuration for task STARTISOOUT
func (o *USBD_Type) SetSUBSCRIBE_STARTISOOUT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTISOOUT.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTISOOUT.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetSUBSCRIBE_STARTISOOUT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STARTISOOUT.Reg) & 0xff
}
func (o *USBD_Type) SetSUBSCRIBE_STARTISOOUT_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTISOOUT.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTISOOUT.Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetSUBSCRIBE_STARTISOOUT_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STARTISOOUT.Reg) & 0x80000000) >> 31
}

// USBD.SUBSCRIBE_EP0RCVOUT: Subscribe configuration for task EP0RCVOUT
func (o *USBD_Type) SetSUBSCRIBE_EP0RCVOUT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_EP0RCVOUT.Reg, volatile.LoadUint32(&o.SUBSCRIBE_EP0RCVOUT.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetSUBSCRIBE_EP0RCVOUT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_EP0RCVOUT.Reg) & 0xff
}
func (o *USBD_Type) SetSUBSCRIBE_EP0RCVOUT_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_EP0RCVOUT.Reg, volatile.LoadUint32(&o.SUBSCRIBE_EP0RCVOUT.Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetSUBSCRIBE_EP0RCVOUT_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_EP0RCVOUT.Reg) & 0x80000000) >> 31
}

// USBD.SUBSCRIBE_EP0STATUS: Subscribe configuration for task EP0STATUS
func (o *USBD_Type) SetSUBSCRIBE_EP0STATUS_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_EP0STATUS.Reg, volatile.LoadUint32(&o.SUBSCRIBE_EP0STATUS.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetSUBSCRIBE_EP0STATUS_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_EP0STATUS.Reg) & 0xff
}
func (o *USBD_Type) SetSUBSCRIBE_EP0STATUS_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_EP0STATUS.Reg, volatile.LoadUint32(&o.SUBSCRIBE_EP0STATUS.Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetSUBSCRIBE_EP0STATUS_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_EP0STATUS.Reg) & 0x80000000) >> 31
}

// USBD.SUBSCRIBE_EP0STALL: Subscribe configuration for task EP0STALL
func (o *USBD_Type) SetSUBSCRIBE_EP0STALL_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_EP0STALL.Reg, volatile.LoadUint32(&o.SUBSCRIBE_EP0STALL.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetSUBSCRIBE_EP0STALL_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_EP0STALL.Reg) & 0xff
}
func (o *USBD_Type) SetSUBSCRIBE_EP0STALL_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_EP0STALL.Reg, volatile.LoadUint32(&o.SUBSCRIBE_EP0STALL.Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetSUBSCRIBE_EP0STALL_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_EP0STALL.Reg) & 0x80000000) >> 31
}

// USBD.SUBSCRIBE_DPDMDRIVE: Subscribe configuration for task DPDMDRIVE
func (o *USBD_Type) SetSUBSCRIBE_DPDMDRIVE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_DPDMDRIVE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_DPDMDRIVE.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetSUBSCRIBE_DPDMDRIVE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_DPDMDRIVE.Reg) & 0xff
}
func (o *USBD_Type) SetSUBSCRIBE_DPDMDRIVE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_DPDMDRIVE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_DPDMDRIVE.Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetSUBSCRIBE_DPDMDRIVE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_DPDMDRIVE.Reg) & 0x80000000) >> 31
}

// USBD.SUBSCRIBE_DPDMNODRIVE: Subscribe configuration for task DPDMNODRIVE
func (o *USBD_Type) SetSUBSCRIBE_DPDMNODRIVE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_DPDMNODRIVE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_DPDMNODRIVE.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetSUBSCRIBE_DPDMNODRIVE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_DPDMNODRIVE.Reg) & 0xff
}
func (o *USBD_Type) SetSUBSCRIBE_DPDMNODRIVE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_DPDMNODRIVE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_DPDMNODRIVE.Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetSUBSCRIBE_DPDMNODRIVE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_DPDMNODRIVE.Reg) & 0x80000000) >> 31
}

// USBD.EVENTS_USBRESET: Signals that a USB reset condition has been detected on USB lines
func (o *USBD_Type) SetEVENTS_USBRESET(value uint32) {
	volatile.StoreUint32(&o.EVENTS_USBRESET.Reg, volatile.LoadUint32(&o.EVENTS_USBRESET.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_USBRESET() uint32 {
	return volatile.LoadUint32(&o.EVENTS_USBRESET.Reg) & 0x1
}

// USBD.EVENTS_STARTED: Confirms that the EPIN[n].PTR and EPIN[n].MAXCNT, or EPOUT[n].PTR and EPOUT[n].MAXCNT registers have been captured on all endpoints reported in the EPSTATUS register
func (o *USBD_Type) SetEVENTS_STARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STARTED.Reg, volatile.LoadUint32(&o.EVENTS_STARTED.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_STARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STARTED.Reg) & 0x1
}

// USBD.EVENTS_ENDEPIN: Description collection: The whole EPIN[n] buffer has been consumed. The buffer can be accessed safely by software.
func (o *USBD_Type) SetEVENTS_ENDEPIN(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDEPIN[idx].Reg, volatile.LoadUint32(&o.EVENTS_ENDEPIN[idx].Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_ENDEPIN(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDEPIN[idx].Reg) & 0x1
}

// USBD.EVENTS_EP0DATADONE: An acknowledged data transfer has taken place on the control endpoint
func (o *USBD_Type) SetEVENTS_EP0DATADONE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_EP0DATADONE.Reg, volatile.LoadUint32(&o.EVENTS_EP0DATADONE.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_EP0DATADONE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_EP0DATADONE.Reg) & 0x1
}

// USBD.EVENTS_ENDISOIN: The whole ISOIN buffer has been consumed. The buffer can be accessed safely by software.
func (o *USBD_Type) SetEVENTS_ENDISOIN(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDISOIN.Reg, volatile.LoadUint32(&o.EVENTS_ENDISOIN.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_ENDISOIN() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDISOIN.Reg) & 0x1
}

// USBD.EVENTS_ENDEPOUT: Description collection: The whole EPOUT[n] buffer has been consumed. The buffer can be accessed safely by software.
func (o *USBD_Type) SetEVENTS_ENDEPOUT(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDEPOUT[idx].Reg, volatile.LoadUint32(&o.EVENTS_ENDEPOUT[idx].Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_ENDEPOUT(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDEPOUT[idx].Reg) & 0x1
}

// USBD.EVENTS_ENDISOOUT: The whole ISOOUT buffer has been consumed. The buffer can be accessed safely by software.
func (o *USBD_Type) SetEVENTS_ENDISOOUT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDISOOUT.Reg, volatile.LoadUint32(&o.EVENTS_ENDISOOUT.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_ENDISOOUT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDISOOUT.Reg) & 0x1
}

// USBD.EVENTS_SOF: Signals that a SOF (start of frame) condition has been detected on USB lines
func (o *USBD_Type) SetEVENTS_SOF(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SOF.Reg, volatile.LoadUint32(&o.EVENTS_SOF.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_SOF() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SOF.Reg) & 0x1
}

// USBD.EVENTS_USBEVENT: An event or an error not covered by specific events has occurred. Check EVENTCAUSE register to find the cause.
func (o *USBD_Type) SetEVENTS_USBEVENT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_USBEVENT.Reg, volatile.LoadUint32(&o.EVENTS_USBEVENT.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_USBEVENT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_USBEVENT.Reg) & 0x1
}

// USBD.EVENTS_EP0SETUP: A valid SETUP token has been received (and acknowledged) on the control endpoint
func (o *USBD_Type) SetEVENTS_EP0SETUP(value uint32) {
	volatile.StoreUint32(&o.EVENTS_EP0SETUP.Reg, volatile.LoadUint32(&o.EVENTS_EP0SETUP.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_EP0SETUP() uint32 {
	return volatile.LoadUint32(&o.EVENTS_EP0SETUP.Reg) & 0x1
}

// USBD.EVENTS_EPDATA: A data transfer has occurred on a data endpoint, indicated by the EPDATASTATUS register
func (o *USBD_Type) SetEVENTS_EPDATA(value uint32) {
	volatile.StoreUint32(&o.EVENTS_EPDATA.Reg, volatile.LoadUint32(&o.EVENTS_EPDATA.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_EPDATA() uint32 {
	return volatile.LoadUint32(&o.EVENTS_EPDATA.Reg) & 0x1
}

// USBD.PUBLISH_USBRESET: Publish configuration for event USBRESET
func (o *USBD_Type) SetPUBLISH_USBRESET_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_USBRESET.Reg, volatile.LoadUint32(&o.PUBLISH_USBRESET.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetPUBLISH_USBRESET_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_USBRESET.Reg) & 0xff
}
func (o *USBD_Type) SetPUBLISH_USBRESET_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_USBRESET.Reg, volatile.LoadUint32(&o.PUBLISH_USBRESET.Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetPUBLISH_USBRESET_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_USBRESET.Reg) & 0x80000000) >> 31
}

// USBD.PUBLISH_STARTED: Publish configuration for event STARTED
func (o *USBD_Type) SetPUBLISH_STARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STARTED.Reg, volatile.LoadUint32(&o.PUBLISH_STARTED.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetPUBLISH_STARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STARTED.Reg) & 0xff
}
func (o *USBD_Type) SetPUBLISH_STARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STARTED.Reg, volatile.LoadUint32(&o.PUBLISH_STARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetPUBLISH_STARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STARTED.Reg) & 0x80000000) >> 31
}

// USBD.PUBLISH_ENDEPIN: Description collection: Publish configuration for event ENDEPIN[n]
func (o *USBD_Type) SetPUBLISH_ENDEPIN_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDEPIN[idx].Reg, volatile.LoadUint32(&o.PUBLISH_ENDEPIN[idx].Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetPUBLISH_ENDEPIN_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDEPIN[idx].Reg) & 0xff
}
func (o *USBD_Type) SetPUBLISH_ENDEPIN_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDEPIN[idx].Reg, volatile.LoadUint32(&o.PUBLISH_ENDEPIN[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetPUBLISH_ENDEPIN_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDEPIN[idx].Reg) & 0x80000000) >> 31
}

// USBD.PUBLISH_EP0DATADONE: Publish configuration for event EP0DATADONE
func (o *USBD_Type) SetPUBLISH_EP0DATADONE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_EP0DATADONE.Reg, volatile.LoadUint32(&o.PUBLISH_EP0DATADONE.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetPUBLISH_EP0DATADONE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_EP0DATADONE.Reg) & 0xff
}
func (o *USBD_Type) SetPUBLISH_EP0DATADONE_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_EP0DATADONE.Reg, volatile.LoadUint32(&o.PUBLISH_EP0DATADONE.Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetPUBLISH_EP0DATADONE_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_EP0DATADONE.Reg) & 0x80000000) >> 31
}

// USBD.PUBLISH_ENDISOIN: Publish configuration for event ENDISOIN
func (o *USBD_Type) SetPUBLISH_ENDISOIN_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDISOIN.Reg, volatile.LoadUint32(&o.PUBLISH_ENDISOIN.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetPUBLISH_ENDISOIN_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDISOIN.Reg) & 0xff
}
func (o *USBD_Type) SetPUBLISH_ENDISOIN_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDISOIN.Reg, volatile.LoadUint32(&o.PUBLISH_ENDISOIN.Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetPUBLISH_ENDISOIN_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDISOIN.Reg) & 0x80000000) >> 31
}

// USBD.PUBLISH_ENDEPOUT: Description collection: Publish configuration for event ENDEPOUT[n]
func (o *USBD_Type) SetPUBLISH_ENDEPOUT_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDEPOUT[idx].Reg, volatile.LoadUint32(&o.PUBLISH_ENDEPOUT[idx].Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetPUBLISH_ENDEPOUT_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDEPOUT[idx].Reg) & 0xff
}
func (o *USBD_Type) SetPUBLISH_ENDEPOUT_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDEPOUT[idx].Reg, volatile.LoadUint32(&o.PUBLISH_ENDEPOUT[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetPUBLISH_ENDEPOUT_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDEPOUT[idx].Reg) & 0x80000000) >> 31
}

// USBD.PUBLISH_ENDISOOUT: Publish configuration for event ENDISOOUT
func (o *USBD_Type) SetPUBLISH_ENDISOOUT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDISOOUT.Reg, volatile.LoadUint32(&o.PUBLISH_ENDISOOUT.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetPUBLISH_ENDISOOUT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDISOOUT.Reg) & 0xff
}
func (o *USBD_Type) SetPUBLISH_ENDISOOUT_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDISOOUT.Reg, volatile.LoadUint32(&o.PUBLISH_ENDISOOUT.Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetPUBLISH_ENDISOOUT_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDISOOUT.Reg) & 0x80000000) >> 31
}

// USBD.PUBLISH_SOF: Publish configuration for event SOF
func (o *USBD_Type) SetPUBLISH_SOF_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SOF.Reg, volatile.LoadUint32(&o.PUBLISH_SOF.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetPUBLISH_SOF_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_SOF.Reg) & 0xff
}
func (o *USBD_Type) SetPUBLISH_SOF_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SOF.Reg, volatile.LoadUint32(&o.PUBLISH_SOF.Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetPUBLISH_SOF_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_SOF.Reg) & 0x80000000) >> 31
}

// USBD.PUBLISH_USBEVENT: Publish configuration for event USBEVENT
func (o *USBD_Type) SetPUBLISH_USBEVENT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_USBEVENT.Reg, volatile.LoadUint32(&o.PUBLISH_USBEVENT.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetPUBLISH_USBEVENT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_USBEVENT.Reg) & 0xff
}
func (o *USBD_Type) SetPUBLISH_USBEVENT_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_USBEVENT.Reg, volatile.LoadUint32(&o.PUBLISH_USBEVENT.Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetPUBLISH_USBEVENT_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_USBEVENT.Reg) & 0x80000000) >> 31
}

// USBD.PUBLISH_EP0SETUP: Publish configuration for event EP0SETUP
func (o *USBD_Type) SetPUBLISH_EP0SETUP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_EP0SETUP.Reg, volatile.LoadUint32(&o.PUBLISH_EP0SETUP.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetPUBLISH_EP0SETUP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_EP0SETUP.Reg) & 0xff
}
func (o *USBD_Type) SetPUBLISH_EP0SETUP_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_EP0SETUP.Reg, volatile.LoadUint32(&o.PUBLISH_EP0SETUP.Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetPUBLISH_EP0SETUP_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_EP0SETUP.Reg) & 0x80000000) >> 31
}

// USBD.PUBLISH_EPDATA: Publish configuration for event EPDATA
func (o *USBD_Type) SetPUBLISH_EPDATA_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_EPDATA.Reg, volatile.LoadUint32(&o.PUBLISH_EPDATA.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetPUBLISH_EPDATA_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_EPDATA.Reg) & 0xff
}
func (o *USBD_Type) SetPUBLISH_EPDATA_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_EPDATA.Reg, volatile.LoadUint32(&o.PUBLISH_EPDATA.Reg)&^(0x80000000)|value<<31)
}
func (o *USBD_Type) GetPUBLISH_EPDATA_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_EPDATA.Reg) & 0x80000000) >> 31
}

// USBD.SHORTS: Shortcuts between local events and tasks
func (o *USBD_Type) SetSHORTS_EP0DATADONE_STARTEPIN0(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetSHORTS_EP0DATADONE_STARTEPIN0() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *USBD_Type) SetSHORTS_EP0DATADONE_STARTEPOUT0(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *USBD_Type) GetSHORTS_EP0DATADONE_STARTEPOUT0() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *USBD_Type) SetSHORTS_EP0DATADONE_EP0STATUS(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *USBD_Type) GetSHORTS_EP0DATADONE_EP0STATUS() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *USBD_Type) SetSHORTS_ENDEPOUT0_EP0STATUS(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *USBD_Type) GetSHORTS_ENDEPOUT0_EP0STATUS() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}
func (o *USBD_Type) SetSHORTS_ENDEPOUT0_EP0RCVOUT(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10)|value<<4)
}
func (o *USBD_Type) GetSHORTS_ENDEPOUT0_EP0RCVOUT() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10) >> 4
}

// USBD.INTEN: Enable or disable interrupt
func (o *USBD_Type) SetINTEN_USBRESET(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetINTEN_USBRESET() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *USBD_Type) SetINTEN_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *USBD_Type) GetINTEN_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *USBD_Type) SetINTEN_ENDEPIN0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *USBD_Type) GetINTEN_ENDEPIN0() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *USBD_Type) SetINTEN_ENDEPIN1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *USBD_Type) GetINTEN_ENDEPIN1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *USBD_Type) SetINTEN_ENDEPIN2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *USBD_Type) GetINTEN_ENDEPIN2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *USBD_Type) SetINTEN_ENDEPIN3(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *USBD_Type) GetINTEN_ENDEPIN3() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *USBD_Type) SetINTEN_ENDEPIN4(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *USBD_Type) GetINTEN_ENDEPIN4() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *USBD_Type) SetINTEN_ENDEPIN5(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetINTEN_ENDEPIN5() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *USBD_Type) SetINTEN_ENDEPIN6(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *USBD_Type) GetINTEN_ENDEPIN6() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *USBD_Type) SetINTEN_ENDEPIN7(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *USBD_Type) GetINTEN_ENDEPIN7() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *USBD_Type) SetINTEN_EP0DATADONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400)|value<<10)
}
func (o *USBD_Type) GetINTEN_EP0DATADONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400) >> 10
}
func (o *USBD_Type) SetINTEN_ENDISOIN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800)|value<<11)
}
func (o *USBD_Type) GetINTEN_ENDISOIN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800) >> 11
}
func (o *USBD_Type) SetINTEN_ENDEPOUT0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000)|value<<12)
}
func (o *USBD_Type) GetINTEN_ENDEPOUT0() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000) >> 12
}
func (o *USBD_Type) SetINTEN_ENDEPOUT1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2000)|value<<13)
}
func (o *USBD_Type) GetINTEN_ENDEPOUT1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2000) >> 13
}
func (o *USBD_Type) SetINTEN_ENDEPOUT2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000)|value<<14)
}
func (o *USBD_Type) GetINTEN_ENDEPOUT2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000) >> 14
}
func (o *USBD_Type) SetINTEN_ENDEPOUT3(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8000)|value<<15)
}
func (o *USBD_Type) GetINTEN_ENDEPOUT3() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8000) >> 15
}
func (o *USBD_Type) SetINTEN_ENDEPOUT4(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10000)|value<<16)
}
func (o *USBD_Type) GetINTEN_ENDEPOUT4() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10000) >> 16
}
func (o *USBD_Type) SetINTEN_ENDEPOUT5(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20000)|value<<17)
}
func (o *USBD_Type) GetINTEN_ENDEPOUT5() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20000) >> 17
}
func (o *USBD_Type) SetINTEN_ENDEPOUT6(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40000)|value<<18)
}
func (o *USBD_Type) GetINTEN_ENDEPOUT6() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40000) >> 18
}
func (o *USBD_Type) SetINTEN_ENDEPOUT7(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *USBD_Type) GetINTEN_ENDEPOUT7() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *USBD_Type) SetINTEN_ENDISOOUT(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *USBD_Type) GetINTEN_ENDISOOUT() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *USBD_Type) SetINTEN_SOF(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200000)|value<<21)
}
func (o *USBD_Type) GetINTEN_SOF() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200000) >> 21
}
func (o *USBD_Type) SetINTEN_USBEVENT(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400000)|value<<22)
}
func (o *USBD_Type) GetINTEN_USBEVENT() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400000) >> 22
}
func (o *USBD_Type) SetINTEN_EP0SETUP(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800000)|value<<23)
}
func (o *USBD_Type) GetINTEN_EP0SETUP() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800000) >> 23
}
func (o *USBD_Type) SetINTEN_EPDATA(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000000)|value<<24)
}
func (o *USBD_Type) GetINTEN_EPDATA() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000000) >> 24
}

// USBD.INTENSET: Enable interrupt
func (o *USBD_Type) SetINTENSET_USBRESET(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetINTENSET_USBRESET() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *USBD_Type) SetINTENSET_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *USBD_Type) GetINTENSET_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *USBD_Type) SetINTENSET_ENDEPIN0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *USBD_Type) GetINTENSET_ENDEPIN0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *USBD_Type) SetINTENSET_ENDEPIN1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *USBD_Type) GetINTENSET_ENDEPIN1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *USBD_Type) SetINTENSET_ENDEPIN2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *USBD_Type) GetINTENSET_ENDEPIN2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *USBD_Type) SetINTENSET_ENDEPIN3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *USBD_Type) GetINTENSET_ENDEPIN3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *USBD_Type) SetINTENSET_ENDEPIN4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *USBD_Type) GetINTENSET_ENDEPIN4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *USBD_Type) SetINTENSET_ENDEPIN5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetINTENSET_ENDEPIN5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *USBD_Type) SetINTENSET_ENDEPIN6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *USBD_Type) GetINTENSET_ENDEPIN6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *USBD_Type) SetINTENSET_ENDEPIN7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *USBD_Type) GetINTENSET_ENDEPIN7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *USBD_Type) SetINTENSET_EP0DATADONE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *USBD_Type) GetINTENSET_EP0DATADONE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *USBD_Type) SetINTENSET_ENDISOIN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *USBD_Type) GetINTENSET_ENDISOIN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *USBD_Type) SetINTENSET_ENDEPOUT0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *USBD_Type) GetINTENSET_ENDEPOUT0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *USBD_Type) SetINTENSET_ENDEPOUT1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *USBD_Type) GetINTENSET_ENDEPOUT1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *USBD_Type) SetINTENSET_ENDEPOUT2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *USBD_Type) GetINTENSET_ENDEPOUT2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *USBD_Type) SetINTENSET_ENDEPOUT3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *USBD_Type) GetINTENSET_ENDEPOUT3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}
func (o *USBD_Type) SetINTENSET_ENDEPOUT4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *USBD_Type) GetINTENSET_ENDEPOUT4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *USBD_Type) SetINTENSET_ENDEPOUT5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *USBD_Type) GetINTENSET_ENDEPOUT5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *USBD_Type) SetINTENSET_ENDEPOUT6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *USBD_Type) GetINTENSET_ENDEPOUT6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *USBD_Type) SetINTENSET_ENDEPOUT7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *USBD_Type) GetINTENSET_ENDEPOUT7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *USBD_Type) SetINTENSET_ENDISOOUT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *USBD_Type) GetINTENSET_ENDISOOUT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *USBD_Type) SetINTENSET_SOF(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200000)|value<<21)
}
func (o *USBD_Type) GetINTENSET_SOF() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200000) >> 21
}
func (o *USBD_Type) SetINTENSET_USBEVENT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400000)|value<<22)
}
func (o *USBD_Type) GetINTENSET_USBEVENT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400000) >> 22
}
func (o *USBD_Type) SetINTENSET_EP0SETUP(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800000)|value<<23)
}
func (o *USBD_Type) GetINTENSET_EP0SETUP() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800000) >> 23
}
func (o *USBD_Type) SetINTENSET_EPDATA(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000000)|value<<24)
}
func (o *USBD_Type) GetINTENSET_EPDATA() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000000) >> 24
}

// USBD.INTENCLR: Disable interrupt
func (o *USBD_Type) SetINTENCLR_USBRESET(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetINTENCLR_USBRESET() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *USBD_Type) SetINTENCLR_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *USBD_Type) GetINTENCLR_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *USBD_Type) SetINTENCLR_ENDEPIN0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *USBD_Type) GetINTENCLR_ENDEPIN0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *USBD_Type) SetINTENCLR_ENDEPIN1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *USBD_Type) GetINTENCLR_ENDEPIN1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *USBD_Type) SetINTENCLR_ENDEPIN2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *USBD_Type) GetINTENCLR_ENDEPIN2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *USBD_Type) SetINTENCLR_ENDEPIN3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *USBD_Type) GetINTENCLR_ENDEPIN3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *USBD_Type) SetINTENCLR_ENDEPIN4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *USBD_Type) GetINTENCLR_ENDEPIN4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *USBD_Type) SetINTENCLR_ENDEPIN5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetINTENCLR_ENDEPIN5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *USBD_Type) SetINTENCLR_ENDEPIN6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *USBD_Type) GetINTENCLR_ENDEPIN6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *USBD_Type) SetINTENCLR_ENDEPIN7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *USBD_Type) GetINTENCLR_ENDEPIN7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *USBD_Type) SetINTENCLR_EP0DATADONE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *USBD_Type) GetINTENCLR_EP0DATADONE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *USBD_Type) SetINTENCLR_ENDISOIN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *USBD_Type) GetINTENCLR_ENDISOIN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *USBD_Type) SetINTENCLR_ENDEPOUT0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *USBD_Type) GetINTENCLR_ENDEPOUT0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *USBD_Type) SetINTENCLR_ENDEPOUT1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *USBD_Type) GetINTENCLR_ENDEPOUT1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *USBD_Type) SetINTENCLR_ENDEPOUT2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *USBD_Type) GetINTENCLR_ENDEPOUT2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *USBD_Type) SetINTENCLR_ENDEPOUT3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *USBD_Type) GetINTENCLR_ENDEPOUT3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}
func (o *USBD_Type) SetINTENCLR_ENDEPOUT4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *USBD_Type) GetINTENCLR_ENDEPOUT4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *USBD_Type) SetINTENCLR_ENDEPOUT5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *USBD_Type) GetINTENCLR_ENDEPOUT5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *USBD_Type) SetINTENCLR_ENDEPOUT6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *USBD_Type) GetINTENCLR_ENDEPOUT6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *USBD_Type) SetINTENCLR_ENDEPOUT7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *USBD_Type) GetINTENCLR_ENDEPOUT7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *USBD_Type) SetINTENCLR_ENDISOOUT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *USBD_Type) GetINTENCLR_ENDISOOUT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *USBD_Type) SetINTENCLR_SOF(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200000)|value<<21)
}
func (o *USBD_Type) GetINTENCLR_SOF() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200000) >> 21
}
func (o *USBD_Type) SetINTENCLR_USBEVENT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400000)|value<<22)
}
func (o *USBD_Type) GetINTENCLR_USBEVENT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400000) >> 22
}
func (o *USBD_Type) SetINTENCLR_EP0SETUP(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800000)|value<<23)
}
func (o *USBD_Type) GetINTENCLR_EP0SETUP() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800000) >> 23
}
func (o *USBD_Type) SetINTENCLR_EPDATA(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *USBD_Type) GetINTENCLR_EPDATA() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000000) >> 24
}

// USBD.EVENTCAUSE: Details on what caused the USBEVENT event
func (o *USBD_Type) SetEVENTCAUSE_ISOOUTCRC(value uint32) {
	volatile.StoreUint32(&o.EVENTCAUSE.Reg, volatile.LoadUint32(&o.EVENTCAUSE.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTCAUSE_ISOOUTCRC() uint32 {
	return volatile.LoadUint32(&o.EVENTCAUSE.Reg) & 0x1
}
func (o *USBD_Type) SetEVENTCAUSE_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.EVENTCAUSE.Reg, volatile.LoadUint32(&o.EVENTCAUSE.Reg)&^(0x100)|value<<8)
}
func (o *USBD_Type) GetEVENTCAUSE_SUSPEND() uint32 {
	return (volatile.LoadUint32(&o.EVENTCAUSE.Reg) & 0x100) >> 8
}
func (o *USBD_Type) SetEVENTCAUSE_RESUME(value uint32) {
	volatile.StoreUint32(&o.EVENTCAUSE.Reg, volatile.LoadUint32(&o.EVENTCAUSE.Reg)&^(0x200)|value<<9)
}
func (o *USBD_Type) GetEVENTCAUSE_RESUME() uint32 {
	return (volatile.LoadUint32(&o.EVENTCAUSE.Reg) & 0x200) >> 9
}
func (o *USBD_Type) SetEVENTCAUSE_USBWUALLOWED(value uint32) {
	volatile.StoreUint32(&o.EVENTCAUSE.Reg, volatile.LoadUint32(&o.EVENTCAUSE.Reg)&^(0x400)|value<<10)
}
func (o *USBD_Type) GetEVENTCAUSE_USBWUALLOWED() uint32 {
	return (volatile.LoadUint32(&o.EVENTCAUSE.Reg) & 0x400) >> 10
}
func (o *USBD_Type) SetEVENTCAUSE_READY(value uint32) {
	volatile.StoreUint32(&o.EVENTCAUSE.Reg, volatile.LoadUint32(&o.EVENTCAUSE.Reg)&^(0x800)|value<<11)
}
func (o *USBD_Type) GetEVENTCAUSE_READY() uint32 {
	return (volatile.LoadUint32(&o.EVENTCAUSE.Reg) & 0x800) >> 11
}

// USBD.EPSTATUS: Provides information on which endpoint's EasyDMA registers have been captured
func (o *USBD_Type) SetEPSTATUS_EPIN0(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEPSTATUS_EPIN0() uint32 {
	return volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x1
}
func (o *USBD_Type) SetEPSTATUS_EPIN1(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *USBD_Type) GetEPSTATUS_EPIN1() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x2) >> 1
}
func (o *USBD_Type) SetEPSTATUS_EPIN2(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *USBD_Type) GetEPSTATUS_EPIN2() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x4) >> 2
}
func (o *USBD_Type) SetEPSTATUS_EPIN3(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *USBD_Type) GetEPSTATUS_EPIN3() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x8) >> 3
}
func (o *USBD_Type) SetEPSTATUS_EPIN4(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *USBD_Type) GetEPSTATUS_EPIN4() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x10) >> 4
}
func (o *USBD_Type) SetEPSTATUS_EPIN5(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *USBD_Type) GetEPSTATUS_EPIN5() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x20) >> 5
}
func (o *USBD_Type) SetEPSTATUS_EPIN6(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *USBD_Type) GetEPSTATUS_EPIN6() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x40) >> 6
}
func (o *USBD_Type) SetEPSTATUS_EPIN7(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetEPSTATUS_EPIN7() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x80) >> 7
}
func (o *USBD_Type) SetEPSTATUS_EPIN8(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x100)|value<<8)
}
func (o *USBD_Type) GetEPSTATUS_EPIN8() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x100) >> 8
}
func (o *USBD_Type) SetEPSTATUS_EPOUT0(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x10000)|value<<16)
}
func (o *USBD_Type) GetEPSTATUS_EPOUT0() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x10000) >> 16
}
func (o *USBD_Type) SetEPSTATUS_EPOUT1(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x20000)|value<<17)
}
func (o *USBD_Type) GetEPSTATUS_EPOUT1() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x20000) >> 17
}
func (o *USBD_Type) SetEPSTATUS_EPOUT2(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x40000)|value<<18)
}
func (o *USBD_Type) GetEPSTATUS_EPOUT2() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x40000) >> 18
}
func (o *USBD_Type) SetEPSTATUS_EPOUT3(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x80000)|value<<19)
}
func (o *USBD_Type) GetEPSTATUS_EPOUT3() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x80000) >> 19
}
func (o *USBD_Type) SetEPSTATUS_EPOUT4(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x100000)|value<<20)
}
func (o *USBD_Type) GetEPSTATUS_EPOUT4() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x100000) >> 20
}
func (o *USBD_Type) SetEPSTATUS_EPOUT5(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x200000)|value<<21)
}
func (o *USBD_Type) GetEPSTATUS_EPOUT5() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x200000) >> 21
}
func (o *USBD_Type) SetEPSTATUS_EPOUT6(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x400000)|value<<22)
}
func (o *USBD_Type) GetEPSTATUS_EPOUT6() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x400000) >> 22
}
func (o *USBD_Type) SetEPSTATUS_EPOUT7(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x800000)|value<<23)
}
func (o *USBD_Type) GetEPSTATUS_EPOUT7() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x800000) >> 23
}
func (o *USBD_Type) SetEPSTATUS_EPOUT8(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *USBD_Type) GetEPSTATUS_EPOUT8() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x1000000) >> 24
}

// USBD.EPDATASTATUS: Provides information on which endpoint(s) an acknowledged data transfer has occurred (EPDATA event)
func (o *USBD_Type) SetEPDATASTATUS_EPIN1(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x2)|value<<1)
}
func (o *USBD_Type) GetEPDATASTATUS_EPIN1() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x2) >> 1
}
func (o *USBD_Type) SetEPDATASTATUS_EPIN2(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x4)|value<<2)
}
func (o *USBD_Type) GetEPDATASTATUS_EPIN2() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x4) >> 2
}
func (o *USBD_Type) SetEPDATASTATUS_EPIN3(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x8)|value<<3)
}
func (o *USBD_Type) GetEPDATASTATUS_EPIN3() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x8) >> 3
}
func (o *USBD_Type) SetEPDATASTATUS_EPIN4(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x10)|value<<4)
}
func (o *USBD_Type) GetEPDATASTATUS_EPIN4() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x10) >> 4
}
func (o *USBD_Type) SetEPDATASTATUS_EPIN5(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x20)|value<<5)
}
func (o *USBD_Type) GetEPDATASTATUS_EPIN5() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x20) >> 5
}
func (o *USBD_Type) SetEPDATASTATUS_EPIN6(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x40)|value<<6)
}
func (o *USBD_Type) GetEPDATASTATUS_EPIN6() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x40) >> 6
}
func (o *USBD_Type) SetEPDATASTATUS_EPIN7(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetEPDATASTATUS_EPIN7() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x80) >> 7
}
func (o *USBD_Type) SetEPDATASTATUS_EPOUT1(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x20000)|value<<17)
}
func (o *USBD_Type) GetEPDATASTATUS_EPOUT1() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x20000) >> 17
}
func (o *USBD_Type) SetEPDATASTATUS_EPOUT2(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x40000)|value<<18)
}
func (o *USBD_Type) GetEPDATASTATUS_EPOUT2() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x40000) >> 18
}
func (o *USBD_Type) SetEPDATASTATUS_EPOUT3(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x80000)|value<<19)
}
func (o *USBD_Type) GetEPDATASTATUS_EPOUT3() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x80000) >> 19
}
func (o *USBD_Type) SetEPDATASTATUS_EPOUT4(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x100000)|value<<20)
}
func (o *USBD_Type) GetEPDATASTATUS_EPOUT4() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x100000) >> 20
}
func (o *USBD_Type) SetEPDATASTATUS_EPOUT5(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x200000)|value<<21)
}
func (o *USBD_Type) GetEPDATASTATUS_EPOUT5() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x200000) >> 21
}
func (o *USBD_Type) SetEPDATASTATUS_EPOUT6(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x400000)|value<<22)
}
func (o *USBD_Type) GetEPDATASTATUS_EPOUT6() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x400000) >> 22
}
func (o *USBD_Type) SetEPDATASTATUS_EPOUT7(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x800000)|value<<23)
}
func (o *USBD_Type) GetEPDATASTATUS_EPOUT7() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x800000) >> 23
}

// USBD.USBADDR: Device USB address
func (o *USBD_Type) SetUSBADDR_ADDR(value uint32) {
	volatile.StoreUint32(&o.USBADDR.Reg, volatile.LoadUint32(&o.USBADDR.Reg)&^(0x7f)|value)
}
func (o *USBD_Type) GetUSBADDR_ADDR() uint32 {
	return volatile.LoadUint32(&o.USBADDR.Reg) & 0x7f
}

// USBD.BMREQUESTTYPE: SETUP data, byte 0, bmRequestType
func (o *USBD_Type) SetBMREQUESTTYPE_RECIPIENT(value uint32) {
	volatile.StoreUint32(&o.BMREQUESTTYPE.Reg, volatile.LoadUint32(&o.BMREQUESTTYPE.Reg)&^(0x1f)|value)
}
func (o *USBD_Type) GetBMREQUESTTYPE_RECIPIENT() uint32 {
	return volatile.LoadUint32(&o.BMREQUESTTYPE.Reg) & 0x1f
}
func (o *USBD_Type) SetBMREQUESTTYPE_TYPE(value uint32) {
	volatile.StoreUint32(&o.BMREQUESTTYPE.Reg, volatile.LoadUint32(&o.BMREQUESTTYPE.Reg)&^(0x60)|value<<5)
}
func (o *USBD_Type) GetBMREQUESTTYPE_TYPE() uint32 {
	return (volatile.LoadUint32(&o.BMREQUESTTYPE.Reg) & 0x60) >> 5
}
func (o *USBD_Type) SetBMREQUESTTYPE_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.BMREQUESTTYPE.Reg, volatile.LoadUint32(&o.BMREQUESTTYPE.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetBMREQUESTTYPE_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.BMREQUESTTYPE.Reg) & 0x80) >> 7
}

// USBD.BREQUEST: SETUP data, byte 1, bRequest
func (o *USBD_Type) SetBREQUEST(value uint32) {
	volatile.StoreUint32(&o.BREQUEST.Reg, volatile.LoadUint32(&o.BREQUEST.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetBREQUEST() uint32 {
	return volatile.LoadUint32(&o.BREQUEST.Reg) & 0xff
}

// USBD.WVALUEL: SETUP data, byte 2, LSB of wValue
func (o *USBD_Type) SetWVALUEL(value uint32) {
	volatile.StoreUint32(&o.WVALUEL.Reg, volatile.LoadUint32(&o.WVALUEL.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetWVALUEL() uint32 {
	return volatile.LoadUint32(&o.WVALUEL.Reg) & 0xff
}

// USBD.WVALUEH: SETUP data, byte 3, MSB of wValue
func (o *USBD_Type) SetWVALUEH(value uint32) {
	volatile.StoreUint32(&o.WVALUEH.Reg, volatile.LoadUint32(&o.WVALUEH.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetWVALUEH() uint32 {
	return volatile.LoadUint32(&o.WVALUEH.Reg) & 0xff
}

// USBD.WINDEXL: SETUP data, byte 4, LSB of wIndex
func (o *USBD_Type) SetWINDEXL(value uint32) {
	volatile.StoreUint32(&o.WINDEXL.Reg, volatile.LoadUint32(&o.WINDEXL.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetWINDEXL() uint32 {
	return volatile.LoadUint32(&o.WINDEXL.Reg) & 0xff
}

// USBD.WINDEXH: SETUP data, byte 5, MSB of wIndex
func (o *USBD_Type) SetWINDEXH(value uint32) {
	volatile.StoreUint32(&o.WINDEXH.Reg, volatile.LoadUint32(&o.WINDEXH.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetWINDEXH() uint32 {
	return volatile.LoadUint32(&o.WINDEXH.Reg) & 0xff
}

// USBD.WLENGTHL: SETUP data, byte 6, LSB of wLength
func (o *USBD_Type) SetWLENGTHL(value uint32) {
	volatile.StoreUint32(&o.WLENGTHL.Reg, volatile.LoadUint32(&o.WLENGTHL.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetWLENGTHL() uint32 {
	return volatile.LoadUint32(&o.WLENGTHL.Reg) & 0xff
}

// USBD.WLENGTHH: SETUP data, byte 7, MSB of wLength
func (o *USBD_Type) SetWLENGTHH(value uint32) {
	volatile.StoreUint32(&o.WLENGTHH.Reg, volatile.LoadUint32(&o.WLENGTHH.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetWLENGTHH() uint32 {
	return volatile.LoadUint32(&o.WLENGTHH.Reg) & 0xff
}

// USBD.ENABLE: Enable USB
func (o *USBD_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// USBD.USBPULLUP: Control of the USB pull-up
func (o *USBD_Type) SetUSBPULLUP_CONNECT(value uint32) {
	volatile.StoreUint32(&o.USBPULLUP.Reg, volatile.LoadUint32(&o.USBPULLUP.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetUSBPULLUP_CONNECT() uint32 {
	return volatile.LoadUint32(&o.USBPULLUP.Reg) & 0x1
}

// USBD.DPDMVALUE: State D+ and D- lines will be forced into by the DPDMDRIVE task. The DPDMNODRIVE task reverts the control of the lines to MAC IP (no forcing).
func (o *USBD_Type) SetDPDMVALUE_STATE(value uint32) {
	volatile.StoreUint32(&o.DPDMVALUE.Reg, volatile.LoadUint32(&o.DPDMVALUE.Reg)&^(0x1f)|value)
}
func (o *USBD_Type) GetDPDMVALUE_STATE() uint32 {
	return volatile.LoadUint32(&o.DPDMVALUE.Reg) & 0x1f
}

// USBD.DTOGGLE: Data toggle control and status
func (o *USBD_Type) SetDTOGGLE_EP(value uint32) {
	volatile.StoreUint32(&o.DTOGGLE.Reg, volatile.LoadUint32(&o.DTOGGLE.Reg)&^(0x7)|value)
}
func (o *USBD_Type) GetDTOGGLE_EP() uint32 {
	return volatile.LoadUint32(&o.DTOGGLE.Reg) & 0x7
}
func (o *USBD_Type) SetDTOGGLE_IO(value uint32) {
	volatile.StoreUint32(&o.DTOGGLE.Reg, volatile.LoadUint32(&o.DTOGGLE.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetDTOGGLE_IO() uint32 {
	return (volatile.LoadUint32(&o.DTOGGLE.Reg) & 0x80) >> 7
}
func (o *USBD_Type) SetDTOGGLE_VALUE(value uint32) {
	volatile.StoreUint32(&o.DTOGGLE.Reg, volatile.LoadUint32(&o.DTOGGLE.Reg)&^(0x300)|value<<8)
}
func (o *USBD_Type) GetDTOGGLE_VALUE() uint32 {
	return (volatile.LoadUint32(&o.DTOGGLE.Reg) & 0x300) >> 8
}

// USBD.EPINEN: Endpoint IN enable
func (o *USBD_Type) SetEPINEN_IN0(value uint32) {
	volatile.StoreUint32(&o.EPINEN.Reg, volatile.LoadUint32(&o.EPINEN.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEPINEN_IN0() uint32 {
	return volatile.LoadUint32(&o.EPINEN.Reg) & 0x1
}
func (o *USBD_Type) SetEPINEN_IN1(value uint32) {
	volatile.StoreUint32(&o.EPINEN.Reg, volatile.LoadUint32(&o.EPINEN.Reg)&^(0x2)|value<<1)
}
func (o *USBD_Type) GetEPINEN_IN1() uint32 {
	return (volatile.LoadUint32(&o.EPINEN.Reg) & 0x2) >> 1
}
func (o *USBD_Type) SetEPINEN_IN2(value uint32) {
	volatile.StoreUint32(&o.EPINEN.Reg, volatile.LoadUint32(&o.EPINEN.Reg)&^(0x4)|value<<2)
}
func (o *USBD_Type) GetEPINEN_IN2() uint32 {
	return (volatile.LoadUint32(&o.EPINEN.Reg) & 0x4) >> 2
}
func (o *USBD_Type) SetEPINEN_IN3(value uint32) {
	volatile.StoreUint32(&o.EPINEN.Reg, volatile.LoadUint32(&o.EPINEN.Reg)&^(0x8)|value<<3)
}
func (o *USBD_Type) GetEPINEN_IN3() uint32 {
	return (volatile.LoadUint32(&o.EPINEN.Reg) & 0x8) >> 3
}
func (o *USBD_Type) SetEPINEN_IN4(value uint32) {
	volatile.StoreUint32(&o.EPINEN.Reg, volatile.LoadUint32(&o.EPINEN.Reg)&^(0x10)|value<<4)
}
func (o *USBD_Type) GetEPINEN_IN4() uint32 {
	return (volatile.LoadUint32(&o.EPINEN.Reg) & 0x10) >> 4
}
func (o *USBD_Type) SetEPINEN_IN5(value uint32) {
	volatile.StoreUint32(&o.EPINEN.Reg, volatile.LoadUint32(&o.EPINEN.Reg)&^(0x20)|value<<5)
}
func (o *USBD_Type) GetEPINEN_IN5() uint32 {
	return (volatile.LoadUint32(&o.EPINEN.Reg) & 0x20) >> 5
}
func (o *USBD_Type) SetEPINEN_IN6(value uint32) {
	volatile.StoreUint32(&o.EPINEN.Reg, volatile.LoadUint32(&o.EPINEN.Reg)&^(0x40)|value<<6)
}
func (o *USBD_Type) GetEPINEN_IN6() uint32 {
	return (volatile.LoadUint32(&o.EPINEN.Reg) & 0x40) >> 6
}
func (o *USBD_Type) SetEPINEN_IN7(value uint32) {
	volatile.StoreUint32(&o.EPINEN.Reg, volatile.LoadUint32(&o.EPINEN.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetEPINEN_IN7() uint32 {
	return (volatile.LoadUint32(&o.EPINEN.Reg) & 0x80) >> 7
}
func (o *USBD_Type) SetEPINEN_ISOIN(value uint32) {
	volatile.StoreUint32(&o.EPINEN.Reg, volatile.LoadUint32(&o.EPINEN.Reg)&^(0x100)|value<<8)
}
func (o *USBD_Type) GetEPINEN_ISOIN() uint32 {
	return (volatile.LoadUint32(&o.EPINEN.Reg) & 0x100) >> 8
}

// USBD.EPOUTEN: Endpoint OUT enable
func (o *USBD_Type) SetEPOUTEN_OUT0(value uint32) {
	volatile.StoreUint32(&o.EPOUTEN.Reg, volatile.LoadUint32(&o.EPOUTEN.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEPOUTEN_OUT0() uint32 {
	return volatile.LoadUint32(&o.EPOUTEN.Reg) & 0x1
}
func (o *USBD_Type) SetEPOUTEN_OUT1(value uint32) {
	volatile.StoreUint32(&o.EPOUTEN.Reg, volatile.LoadUint32(&o.EPOUTEN.Reg)&^(0x2)|value<<1)
}
func (o *USBD_Type) GetEPOUTEN_OUT1() uint32 {
	return (volatile.LoadUint32(&o.EPOUTEN.Reg) & 0x2) >> 1
}
func (o *USBD_Type) SetEPOUTEN_OUT2(value uint32) {
	volatile.StoreUint32(&o.EPOUTEN.Reg, volatile.LoadUint32(&o.EPOUTEN.Reg)&^(0x4)|value<<2)
}
func (o *USBD_Type) GetEPOUTEN_OUT2() uint32 {
	return (volatile.LoadUint32(&o.EPOUTEN.Reg) & 0x4) >> 2
}
func (o *USBD_Type) SetEPOUTEN_OUT3(value uint32) {
	volatile.StoreUint32(&o.EPOUTEN.Reg, volatile.LoadUint32(&o.EPOUTEN.Reg)&^(0x8)|value<<3)
}
func (o *USBD_Type) GetEPOUTEN_OUT3() uint32 {
	return (volatile.LoadUint32(&o.EPOUTEN.Reg) & 0x8) >> 3
}
func (o *USBD_Type) SetEPOUTEN_OUT4(value uint32) {
	volatile.StoreUint32(&o.EPOUTEN.Reg, volatile.LoadUint32(&o.EPOUTEN.Reg)&^(0x10)|value<<4)
}
func (o *USBD_Type) GetEPOUTEN_OUT4() uint32 {
	return (volatile.LoadUint32(&o.EPOUTEN.Reg) & 0x10) >> 4
}
func (o *USBD_Type) SetEPOUTEN_OUT5(value uint32) {
	volatile.StoreUint32(&o.EPOUTEN.Reg, volatile.LoadUint32(&o.EPOUTEN.Reg)&^(0x20)|value<<5)
}
func (o *USBD_Type) GetEPOUTEN_OUT5() uint32 {
	return (volatile.LoadUint32(&o.EPOUTEN.Reg) & 0x20) >> 5
}
func (o *USBD_Type) SetEPOUTEN_OUT6(value uint32) {
	volatile.StoreUint32(&o.EPOUTEN.Reg, volatile.LoadUint32(&o.EPOUTEN.Reg)&^(0x40)|value<<6)
}
func (o *USBD_Type) GetEPOUTEN_OUT6() uint32 {
	return (volatile.LoadUint32(&o.EPOUTEN.Reg) & 0x40) >> 6
}
func (o *USBD_Type) SetEPOUTEN_OUT7(value uint32) {
	volatile.StoreUint32(&o.EPOUTEN.Reg, volatile.LoadUint32(&o.EPOUTEN.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetEPOUTEN_OUT7() uint32 {
	return (volatile.LoadUint32(&o.EPOUTEN.Reg) & 0x80) >> 7
}
func (o *USBD_Type) SetEPOUTEN_ISOOUT(value uint32) {
	volatile.StoreUint32(&o.EPOUTEN.Reg, volatile.LoadUint32(&o.EPOUTEN.Reg)&^(0x100)|value<<8)
}
func (o *USBD_Type) GetEPOUTEN_ISOOUT() uint32 {
	return (volatile.LoadUint32(&o.EPOUTEN.Reg) & 0x100) >> 8
}

// USBD.EPSTALL: STALL endpoints
func (o *USBD_Type) SetEPSTALL_EP(value uint32) {
	volatile.StoreUint32(&o.EPSTALL.Reg, volatile.LoadUint32(&o.EPSTALL.Reg)&^(0x7)|value)
}
func (o *USBD_Type) GetEPSTALL_EP() uint32 {
	return volatile.LoadUint32(&o.EPSTALL.Reg) & 0x7
}
func (o *USBD_Type) SetEPSTALL_IO(value uint32) {
	volatile.StoreUint32(&o.EPSTALL.Reg, volatile.LoadUint32(&o.EPSTALL.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetEPSTALL_IO() uint32 {
	return (volatile.LoadUint32(&o.EPSTALL.Reg) & 0x80) >> 7
}
func (o *USBD_Type) SetEPSTALL_STALL(value uint32) {
	volatile.StoreUint32(&o.EPSTALL.Reg, volatile.LoadUint32(&o.EPSTALL.Reg)&^(0x100)|value<<8)
}
func (o *USBD_Type) GetEPSTALL_STALL() uint32 {
	return (volatile.LoadUint32(&o.EPSTALL.Reg) & 0x100) >> 8
}

// USBD.ISOSPLIT: Controls the split of ISO buffers
func (o *USBD_Type) SetISOSPLIT_SPLIT(value uint32) {
	volatile.StoreUint32(&o.ISOSPLIT.Reg, volatile.LoadUint32(&o.ISOSPLIT.Reg)&^(0xffff)|value)
}
func (o *USBD_Type) GetISOSPLIT_SPLIT() uint32 {
	return volatile.LoadUint32(&o.ISOSPLIT.Reg) & 0xffff
}

// USBD.FRAMECNTR: Returns the current value of the start of frame counter
func (o *USBD_Type) SetFRAMECNTR(value uint32) {
	volatile.StoreUint32(&o.FRAMECNTR.Reg, volatile.LoadUint32(&o.FRAMECNTR.Reg)&^(0x7ff)|value)
}
func (o *USBD_Type) GetFRAMECNTR() uint32 {
	return volatile.LoadUint32(&o.FRAMECNTR.Reg) & 0x7ff
}

// USBD.LOWPOWER: Controls USBD peripheral low power mode during USB suspend
func (o *USBD_Type) SetLOWPOWER(value uint32) {
	volatile.StoreUint32(&o.LOWPOWER.Reg, volatile.LoadUint32(&o.LOWPOWER.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetLOWPOWER() uint32 {
	return volatile.LoadUint32(&o.LOWPOWER.Reg) & 0x1
}

// USBD.ISOINCONFIG: Controls the response of the ISO IN endpoint to an IN token when no data is ready to be sent
func (o *USBD_Type) SetISOINCONFIG_RESPONSE(value uint32) {
	volatile.StoreUint32(&o.ISOINCONFIG.Reg, volatile.LoadUint32(&o.ISOINCONFIG.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetISOINCONFIG_RESPONSE() uint32 {
	return volatile.LoadUint32(&o.ISOINCONFIG.Reg) & 0x1
}

type USBD_HALTED_Type struct {
	EPIN  [8]volatile.Register32 // 0x420
	_     [4]byte
	EPOUT [8]volatile.Register32 // 0x444
}

type USBD_SIZE_Type struct {
	EPOUT  [8]volatile.Register32 // 0x4A0
	ISOOUT volatile.Register32    // 0x4C0
}

// USBD_SIZE.ISOOUT: Number of bytes received last on this ISO OUT data endpoint
func (o *USBD_SIZE_Type) SetISOOUT_SIZE(value uint32) {
	volatile.StoreUint32(&o.ISOOUT.Reg, volatile.LoadUint32(&o.ISOOUT.Reg)&^(0x3ff)|value)
}
func (o *USBD_SIZE_Type) GetISOOUT_SIZE() uint32 {
	return volatile.LoadUint32(&o.ISOOUT.Reg) & 0x3ff
}
func (o *USBD_SIZE_Type) SetISOOUT_ZERO(value uint32) {
	volatile.StoreUint32(&o.ISOOUT.Reg, volatile.LoadUint32(&o.ISOOUT.Reg)&^(0x10000)|value<<16)
}
func (o *USBD_SIZE_Type) GetISOOUT_ZERO() uint32 {
	return (volatile.LoadUint32(&o.ISOOUT.Reg) & 0x10000) >> 16
}

type USBD_EPIN_Type struct {
	PTR    volatile.Register32 // 0x600
	MAXCNT volatile.Register32 // 0x604
	AMOUNT volatile.Register32 // 0x608
	_      [8]byte
}

// USBD_EPIN.PTR: Description cluster: Data pointer
func (o *USBD_EPIN_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *USBD_EPIN_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// USBD_EPIN.MAXCNT: Description cluster: Maximum number of bytes to transfer
func (o *USBD_EPIN_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x7f)|value)
}
func (o *USBD_EPIN_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x7f
}

// USBD_EPIN.AMOUNT: Description cluster: Number of bytes transferred in the last transaction
func (o *USBD_EPIN_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x7f)|value)
}
func (o *USBD_EPIN_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x7f
}

type USBD_ISOIN_Type struct {
	PTR    volatile.Register32 // 0x6A0
	MAXCNT volatile.Register32 // 0x6A4
	AMOUNT volatile.Register32 // 0x6A8
}

// USBD_ISOIN.PTR: Data pointer
func (o *USBD_ISOIN_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *USBD_ISOIN_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// USBD_ISOIN.MAXCNT: Maximum number of bytes to transfer
func (o *USBD_ISOIN_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x3ff)|value)
}
func (o *USBD_ISOIN_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x3ff
}

// USBD_ISOIN.AMOUNT: Number of bytes transferred in the last transaction
func (o *USBD_ISOIN_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x3ff)|value)
}
func (o *USBD_ISOIN_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x3ff
}

type USBD_EPOUT_Type struct {
	PTR    volatile.Register32 // 0x700
	MAXCNT volatile.Register32 // 0x704
	AMOUNT volatile.Register32 // 0x708
	_      [8]byte
}

// USBD_EPOUT.PTR: Description cluster: Data pointer
func (o *USBD_EPOUT_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *USBD_EPOUT_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// USBD_EPOUT.MAXCNT: Description cluster: Maximum number of bytes to transfer
func (o *USBD_EPOUT_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x7f)|value)
}
func (o *USBD_EPOUT_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x7f
}

// USBD_EPOUT.AMOUNT: Description cluster: Number of bytes transferred in the last transaction
func (o *USBD_EPOUT_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x7f)|value)
}
func (o *USBD_EPOUT_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x7f
}

type USBD_ISOOUT_Type struct {
	PTR    volatile.Register32 // 0x7A0
	MAXCNT volatile.Register32 // 0x7A4
	AMOUNT volatile.Register32 // 0x7A8
}

// USBD_ISOOUT.PTR: Data pointer
func (o *USBD_ISOOUT_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *USBD_ISOOUT_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// USBD_ISOOUT.MAXCNT: Maximum number of bytes to transfer
func (o *USBD_ISOOUT_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x3ff)|value)
}
func (o *USBD_ISOOUT_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x3ff
}

// USBD_ISOOUT.AMOUNT: Number of bytes transferred in the last transaction
func (o *USBD_ISOOUT_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x3ff)|value)
}
func (o *USBD_ISOOUT_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x3ff
}

// USB Regulator 0
type USBREG_Type struct {
	_                   [256]byte
	EVENTS_USBDETECTED  volatile.Register32 // 0x100
	EVENTS_USBREMOVED   volatile.Register32 // 0x104
	EVENTS_USBPWRRDY    volatile.Register32 // 0x108
	_                   [116]byte
	PUBLISH_USBDETECTED volatile.Register32 // 0x180
	PUBLISH_USBREMOVED  volatile.Register32 // 0x184
	PUBLISH_USBPWRRDY   volatile.Register32 // 0x188
	_                   [372]byte
	INTEN               volatile.Register32 // 0x300
	INTENSET            volatile.Register32 // 0x304
	INTENCLR            volatile.Register32 // 0x308
	_                   [244]byte
	USBREGSTATUS        volatile.Register32 // 0x400
}

// USBREG.EVENTS_USBDETECTED: Voltage supply detected on VBUS
func (o *USBREG_Type) SetEVENTS_USBDETECTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_USBDETECTED.Reg, volatile.LoadUint32(&o.EVENTS_USBDETECTED.Reg)&^(0x1)|value)
}
func (o *USBREG_Type) GetEVENTS_USBDETECTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_USBDETECTED.Reg) & 0x1
}

// USBREG.EVENTS_USBREMOVED: Voltage supply removed from VBUS
func (o *USBREG_Type) SetEVENTS_USBREMOVED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_USBREMOVED.Reg, volatile.LoadUint32(&o.EVENTS_USBREMOVED.Reg)&^(0x1)|value)
}
func (o *USBREG_Type) GetEVENTS_USBREMOVED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_USBREMOVED.Reg) & 0x1
}

// USBREG.EVENTS_USBPWRRDY: USB 3.3 V supply ready
func (o *USBREG_Type) SetEVENTS_USBPWRRDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_USBPWRRDY.Reg, volatile.LoadUint32(&o.EVENTS_USBPWRRDY.Reg)&^(0x1)|value)
}
func (o *USBREG_Type) GetEVENTS_USBPWRRDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_USBPWRRDY.Reg) & 0x1
}

// USBREG.PUBLISH_USBDETECTED: Publish configuration for event USBDETECTED
func (o *USBREG_Type) SetPUBLISH_USBDETECTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_USBDETECTED.Reg, volatile.LoadUint32(&o.PUBLISH_USBDETECTED.Reg)&^(0xff)|value)
}
func (o *USBREG_Type) GetPUBLISH_USBDETECTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_USBDETECTED.Reg) & 0xff
}
func (o *USBREG_Type) SetPUBLISH_USBDETECTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_USBDETECTED.Reg, volatile.LoadUint32(&o.PUBLISH_USBDETECTED.Reg)&^(0x80000000)|value<<31)
}
func (o *USBREG_Type) GetPUBLISH_USBDETECTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_USBDETECTED.Reg) & 0x80000000) >> 31
}

// USBREG.PUBLISH_USBREMOVED: Publish configuration for event USBREMOVED
func (o *USBREG_Type) SetPUBLISH_USBREMOVED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_USBREMOVED.Reg, volatile.LoadUint32(&o.PUBLISH_USBREMOVED.Reg)&^(0xff)|value)
}
func (o *USBREG_Type) GetPUBLISH_USBREMOVED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_USBREMOVED.Reg) & 0xff
}
func (o *USBREG_Type) SetPUBLISH_USBREMOVED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_USBREMOVED.Reg, volatile.LoadUint32(&o.PUBLISH_USBREMOVED.Reg)&^(0x80000000)|value<<31)
}
func (o *USBREG_Type) GetPUBLISH_USBREMOVED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_USBREMOVED.Reg) & 0x80000000) >> 31
}

// USBREG.PUBLISH_USBPWRRDY: Publish configuration for event USBPWRRDY
func (o *USBREG_Type) SetPUBLISH_USBPWRRDY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_USBPWRRDY.Reg, volatile.LoadUint32(&o.PUBLISH_USBPWRRDY.Reg)&^(0xff)|value)
}
func (o *USBREG_Type) GetPUBLISH_USBPWRRDY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_USBPWRRDY.Reg) & 0xff
}
func (o *USBREG_Type) SetPUBLISH_USBPWRRDY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_USBPWRRDY.Reg, volatile.LoadUint32(&o.PUBLISH_USBPWRRDY.Reg)&^(0x80000000)|value<<31)
}
func (o *USBREG_Type) GetPUBLISH_USBPWRRDY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_USBPWRRDY.Reg) & 0x80000000) >> 31
}

// USBREG.INTEN: Enable or disable interrupt
func (o *USBREG_Type) SetINTEN_USBDETECTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *USBREG_Type) GetINTEN_USBDETECTED() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *USBREG_Type) SetINTEN_USBREMOVED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *USBREG_Type) GetINTEN_USBREMOVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *USBREG_Type) SetINTEN_USBPWRRDY(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *USBREG_Type) GetINTEN_USBPWRRDY() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}

// USBREG.INTENSET: Enable interrupt
func (o *USBREG_Type) SetINTENSET_USBDETECTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *USBREG_Type) GetINTENSET_USBDETECTED() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *USBREG_Type) SetINTENSET_USBREMOVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *USBREG_Type) GetINTENSET_USBREMOVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *USBREG_Type) SetINTENSET_USBPWRRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *USBREG_Type) GetINTENSET_USBPWRRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}

// USBREG.INTENCLR: Disable interrupt
func (o *USBREG_Type) SetINTENCLR_USBDETECTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *USBREG_Type) GetINTENCLR_USBDETECTED() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *USBREG_Type) SetINTENCLR_USBREMOVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *USBREG_Type) GetINTENCLR_USBREMOVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *USBREG_Type) SetINTENCLR_USBPWRRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *USBREG_Type) GetINTENCLR_USBPWRRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}

// USBREG.USBREGSTATUS: USB supply status
func (o *USBREG_Type) SetUSBREGSTATUS_VBUSDETECT(value uint32) {
	volatile.StoreUint32(&o.USBREGSTATUS.Reg, volatile.LoadUint32(&o.USBREGSTATUS.Reg)&^(0x1)|value)
}
func (o *USBREG_Type) GetUSBREGSTATUS_VBUSDETECT() uint32 {
	return volatile.LoadUint32(&o.USBREGSTATUS.Reg) & 0x1
}
func (o *USBREG_Type) SetUSBREGSTATUS_OUTPUTRDY(value uint32) {
	volatile.StoreUint32(&o.USBREGSTATUS.Reg, volatile.LoadUint32(&o.USBREGSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *USBREG_Type) GetUSBREGSTATUS_OUTPUTRDY() uint32 {
	return (volatile.LoadUint32(&o.USBREGSTATUS.Reg) & 0x2) >> 1
}

// Key management unit 0
type KMU_Type struct {
	TASKS_PUSH_KEYSLOT     volatile.Register32 // 0x0
	_                      [252]byte
	EVENTS_KEYSLOT_PUSHED  volatile.Register32 // 0x100
	EVENTS_KEYSLOT_REVOKED volatile.Register32 // 0x104
	EVENTS_KEYSLOT_ERROR   volatile.Register32 // 0x108
	_                      [500]byte
	INTEN                  volatile.Register32 // 0x300
	INTENSET               volatile.Register32 // 0x304
	INTENCLR               volatile.Register32 // 0x308
	INTPEND                volatile.Register32 // 0x30C
	_                      [252]byte
	STATUS                 volatile.Register32 // 0x40C
	_                      [240]byte
	SELECTKEYSLOT          volatile.Register32 // 0x500
}

// KMU.TASKS_PUSH_KEYSLOT: Push a key slot over secure APB
func (o *KMU_Type) SetTASKS_PUSH_KEYSLOT(value uint32) {
	volatile.StoreUint32(&o.TASKS_PUSH_KEYSLOT.Reg, volatile.LoadUint32(&o.TASKS_PUSH_KEYSLOT.Reg)&^(0x1)|value)
}
func (o *KMU_Type) GetTASKS_PUSH_KEYSLOT() uint32 {
	return volatile.LoadUint32(&o.TASKS_PUSH_KEYSLOT.Reg) & 0x1
}

// KMU.EVENTS_KEYSLOT_PUSHED: Key slot successfully pushed over secure APB
func (o *KMU_Type) SetEVENTS_KEYSLOT_PUSHED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_KEYSLOT_PUSHED.Reg, volatile.LoadUint32(&o.EVENTS_KEYSLOT_PUSHED.Reg)&^(0x1)|value)
}
func (o *KMU_Type) GetEVENTS_KEYSLOT_PUSHED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_KEYSLOT_PUSHED.Reg) & 0x1
}

// KMU.EVENTS_KEYSLOT_REVOKED: Key slot has been revoked and cannot be tasked for selection
func (o *KMU_Type) SetEVENTS_KEYSLOT_REVOKED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_KEYSLOT_REVOKED.Reg, volatile.LoadUint32(&o.EVENTS_KEYSLOT_REVOKED.Reg)&^(0x1)|value)
}
func (o *KMU_Type) GetEVENTS_KEYSLOT_REVOKED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_KEYSLOT_REVOKED.Reg) & 0x1
}

// KMU.EVENTS_KEYSLOT_ERROR: No key slot selected, no destination address defined, or error during push operation
func (o *KMU_Type) SetEVENTS_KEYSLOT_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_KEYSLOT_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_KEYSLOT_ERROR.Reg)&^(0x1)|value)
}
func (o *KMU_Type) GetEVENTS_KEYSLOT_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_KEYSLOT_ERROR.Reg) & 0x1
}

// KMU.INTEN: Enable or disable interrupt
func (o *KMU_Type) SetINTEN_KEYSLOT_PUSHED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *KMU_Type) GetINTEN_KEYSLOT_PUSHED() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *KMU_Type) SetINTEN_KEYSLOT_REVOKED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *KMU_Type) GetINTEN_KEYSLOT_REVOKED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *KMU_Type) SetINTEN_KEYSLOT_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *KMU_Type) GetINTEN_KEYSLOT_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}

// KMU.INTENSET: Enable interrupt
func (o *KMU_Type) SetINTENSET_KEYSLOT_PUSHED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *KMU_Type) GetINTENSET_KEYSLOT_PUSHED() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *KMU_Type) SetINTENSET_KEYSLOT_REVOKED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *KMU_Type) GetINTENSET_KEYSLOT_REVOKED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *KMU_Type) SetINTENSET_KEYSLOT_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *KMU_Type) GetINTENSET_KEYSLOT_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}

// KMU.INTENCLR: Disable interrupt
func (o *KMU_Type) SetINTENCLR_KEYSLOT_PUSHED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *KMU_Type) GetINTENCLR_KEYSLOT_PUSHED() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *KMU_Type) SetINTENCLR_KEYSLOT_REVOKED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *KMU_Type) GetINTENCLR_KEYSLOT_REVOKED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *KMU_Type) SetINTENCLR_KEYSLOT_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *KMU_Type) GetINTENCLR_KEYSLOT_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}

// KMU.INTPEND: Pending interrupts
func (o *KMU_Type) SetINTPEND_KEYSLOT_PUSHED(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x1)|value)
}
func (o *KMU_Type) GetINTPEND_KEYSLOT_PUSHED() uint32 {
	return volatile.LoadUint32(&o.INTPEND.Reg) & 0x1
}
func (o *KMU_Type) SetINTPEND_KEYSLOT_REVOKED(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x2)|value<<1)
}
func (o *KMU_Type) GetINTPEND_KEYSLOT_REVOKED() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x2) >> 1
}
func (o *KMU_Type) SetINTPEND_KEYSLOT_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x4)|value<<2)
}
func (o *KMU_Type) GetINTPEND_KEYSLOT_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x4) >> 2
}

// KMU.STATUS: Status bits for KMU operation
func (o *KMU_Type) SetSTATUS_SELECTED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *KMU_Type) GetSTATUS_SELECTED() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *KMU_Type) SetSTATUS_BLOCKED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *KMU_Type) GetSTATUS_BLOCKED() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}

// KMU.SELECTKEYSLOT: Select key slot to be read over AHB or pushed over secure APB when TASKS_PUSH_KEYSLOT is started
func (o *KMU_Type) SetSELECTKEYSLOT_ID(value uint32) {
	volatile.StoreUint32(&o.SELECTKEYSLOT.Reg, volatile.LoadUint32(&o.SELECTKEYSLOT.Reg)&^(0xff)|value)
}
func (o *KMU_Type) GetSELECTKEYSLOT_ID() uint32 {
	return volatile.LoadUint32(&o.SELECTKEYSLOT.Reg) & 0xff
}

// Non-volatile memory controller 0
type NVMC_Type struct {
	_                   [1024]byte
	READY               volatile.Register32 // 0x400
	_                   [4]byte
	READYNEXT           volatile.Register32 // 0x408
	_                   [248]byte
	CONFIG              volatile.Register32 // 0x504
	_                   [4]byte
	ERASEALL            volatile.Register32 // 0x50C
	_                   [12]byte
	ERASEPAGEPARTIALCFG volatile.Register32 // 0x51C
	_                   [100]byte
	CONFIGNS            volatile.Register32 // 0x584
	WRITEUICRNS         volatile.Register32 // 0x588
}

// NVMC.READY: Ready flag
func (o *NVMC_Type) SetREADY(value uint32) {
	volatile.StoreUint32(&o.READY.Reg, volatile.LoadUint32(&o.READY.Reg)&^(0x1)|value)
}
func (o *NVMC_Type) GetREADY() uint32 {
	return volatile.LoadUint32(&o.READY.Reg) & 0x1
}

// NVMC.READYNEXT: Ready flag
func (o *NVMC_Type) SetREADYNEXT(value uint32) {
	volatile.StoreUint32(&o.READYNEXT.Reg, volatile.LoadUint32(&o.READYNEXT.Reg)&^(0x1)|value)
}
func (o *NVMC_Type) GetREADYNEXT() uint32 {
	return volatile.LoadUint32(&o.READYNEXT.Reg) & 0x1
}

// NVMC.CONFIG: Configuration register
func (o *NVMC_Type) SetCONFIG_WEN(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x7)|value)
}
func (o *NVMC_Type) GetCONFIG_WEN() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x7
}

// NVMC.ERASEALL: Register for erasing all non-volatile user memory
func (o *NVMC_Type) SetERASEALL(value uint32) {
	volatile.StoreUint32(&o.ERASEALL.Reg, volatile.LoadUint32(&o.ERASEALL.Reg)&^(0x1)|value)
}
func (o *NVMC_Type) GetERASEALL() uint32 {
	return volatile.LoadUint32(&o.ERASEALL.Reg) & 0x1
}

// NVMC.ERASEPAGEPARTIALCFG: Register for partial erase configuration
func (o *NVMC_Type) SetERASEPAGEPARTIALCFG_DURATION(value uint32) {
	volatile.StoreUint32(&o.ERASEPAGEPARTIALCFG.Reg, volatile.LoadUint32(&o.ERASEPAGEPARTIALCFG.Reg)&^(0x7f)|value)
}
func (o *NVMC_Type) GetERASEPAGEPARTIALCFG_DURATION() uint32 {
	return volatile.LoadUint32(&o.ERASEPAGEPARTIALCFG.Reg) & 0x7f
}

// NVMC.CONFIGNS: Unspecified
func (o *NVMC_Type) SetCONFIGNS_WEN(value uint32) {
	volatile.StoreUint32(&o.CONFIGNS.Reg, volatile.LoadUint32(&o.CONFIGNS.Reg)&^(0x3)|value)
}
func (o *NVMC_Type) GetCONFIGNS_WEN() uint32 {
	return volatile.LoadUint32(&o.CONFIGNS.Reg) & 0x3
}

// NVMC.WRITEUICRNS: Non-secure APPROTECT enable register
func (o *NVMC_Type) SetWRITEUICRNS_SET(value uint32) {
	volatile.StoreUint32(&o.WRITEUICRNS.Reg, volatile.LoadUint32(&o.WRITEUICRNS.Reg)&^(0x1)|value)
}
func (o *NVMC_Type) GetWRITEUICRNS_SET() uint32 {
	return volatile.LoadUint32(&o.WRITEUICRNS.Reg) & 0x1
}
func (o *NVMC_Type) SetWRITEUICRNS_KEY(value uint32) {
	volatile.StoreUint32(&o.WRITEUICRNS.Reg, volatile.LoadUint32(&o.WRITEUICRNS.Reg)&^(0xfffffff0)|value<<4)
}
func (o *NVMC_Type) GetWRITEUICRNS_KEY() uint32 {
	return (volatile.LoadUint32(&o.WRITEUICRNS.Reg) & 0xfffffff0) >> 4
}

// GPIO Port 0
type GPIO_Type struct {
	_              [4]byte
	OUT            volatile.Register32 // 0x4
	OUTSET         volatile.Register32 // 0x8
	OUTCLR         volatile.Register32 // 0xC
	IN             volatile.Register32 // 0x10
	DIR            volatile.Register32 // 0x14
	DIRSET         volatile.Register32 // 0x18
	DIRCLR         volatile.Register32 // 0x1C
	LATCH          volatile.Register32 // 0x20
	DETECTMODE     volatile.Register32 // 0x24
	DETECTMODE_SEC volatile.Register32 // 0x28
	_              [468]byte
	PIN_CNF        [32]volatile.Register32 // 0x200
}

// GPIO.OUT: Write GPIO port
func (o *GPIO_Type) SetOUT_PIN0(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOUT_PIN0() uint32 {
	return volatile.LoadUint32(&o.OUT.Reg) & 0x1
}
func (o *GPIO_Type) SetOUT_PIN1(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOUT_PIN1() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOUT_PIN2(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOUT_PIN2() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOUT_PIN3(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOUT_PIN3() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOUT_PIN4(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOUT_PIN4() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOUT_PIN5(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOUT_PIN5() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOUT_PIN6(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOUT_PIN6() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOUT_PIN7(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOUT_PIN7() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOUT_PIN8(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOUT_PIN8() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOUT_PIN9(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOUT_PIN9() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOUT_PIN10(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOUT_PIN10() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOUT_PIN11(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOUT_PIN11() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOUT_PIN12(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOUT_PIN12() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOUT_PIN13(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOUT_PIN13() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOUT_PIN14(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOUT_PIN14() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOUT_PIN15(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOUT_PIN15() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOUT_PIN16(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetOUT_PIN16() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetOUT_PIN17(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetOUT_PIN17() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetOUT_PIN18(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetOUT_PIN18() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetOUT_PIN19(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetOUT_PIN19() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetOUT_PIN20(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetOUT_PIN20() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetOUT_PIN21(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetOUT_PIN21() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetOUT_PIN22(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetOUT_PIN22() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetOUT_PIN23(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetOUT_PIN23() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetOUT_PIN24(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetOUT_PIN24() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetOUT_PIN25(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetOUT_PIN25() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetOUT_PIN26(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetOUT_PIN26() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetOUT_PIN27(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetOUT_PIN27() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetOUT_PIN28(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetOUT_PIN28() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetOUT_PIN29(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetOUT_PIN29() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetOUT_PIN30(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetOUT_PIN30() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetOUT_PIN31(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetOUT_PIN31() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x80000000) >> 31
}

// GPIO.OUTSET: Set individual bits in GPIO port
func (o *GPIO_Type) SetOUTSET_PIN0(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOUTSET_PIN0() uint32 {
	return volatile.LoadUint32(&o.OUTSET.Reg) & 0x1
}
func (o *GPIO_Type) SetOUTSET_PIN1(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOUTSET_PIN1() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOUTSET_PIN2(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOUTSET_PIN2() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOUTSET_PIN3(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOUTSET_PIN3() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOUTSET_PIN4(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOUTSET_PIN4() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOUTSET_PIN5(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOUTSET_PIN5() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOUTSET_PIN6(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOUTSET_PIN6() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOUTSET_PIN7(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOUTSET_PIN7() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOUTSET_PIN8(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOUTSET_PIN8() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOUTSET_PIN9(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOUTSET_PIN9() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOUTSET_PIN10(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOUTSET_PIN10() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOUTSET_PIN11(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOUTSET_PIN11() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOUTSET_PIN12(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOUTSET_PIN12() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOUTSET_PIN13(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOUTSET_PIN13() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOUTSET_PIN14(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOUTSET_PIN14() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOUTSET_PIN15(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOUTSET_PIN15() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOUTSET_PIN16(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetOUTSET_PIN16() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetOUTSET_PIN17(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetOUTSET_PIN17() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetOUTSET_PIN18(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetOUTSET_PIN18() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetOUTSET_PIN19(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetOUTSET_PIN19() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetOUTSET_PIN20(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetOUTSET_PIN20() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetOUTSET_PIN21(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetOUTSET_PIN21() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetOUTSET_PIN22(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetOUTSET_PIN22() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetOUTSET_PIN23(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetOUTSET_PIN23() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetOUTSET_PIN24(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetOUTSET_PIN24() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetOUTSET_PIN25(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetOUTSET_PIN25() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetOUTSET_PIN26(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetOUTSET_PIN26() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetOUTSET_PIN27(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetOUTSET_PIN27() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetOUTSET_PIN28(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetOUTSET_PIN28() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetOUTSET_PIN29(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetOUTSET_PIN29() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetOUTSET_PIN30(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetOUTSET_PIN30() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetOUTSET_PIN31(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetOUTSET_PIN31() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x80000000) >> 31
}

// GPIO.OUTCLR: Clear individual bits in GPIO port
func (o *GPIO_Type) SetOUTCLR_PIN0(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOUTCLR_PIN0() uint32 {
	return volatile.LoadUint32(&o.OUTCLR.Reg) & 0x1
}
func (o *GPIO_Type) SetOUTCLR_PIN1(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOUTCLR_PIN1() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOUTCLR_PIN2(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOUTCLR_PIN2() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOUTCLR_PIN3(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOUTCLR_PIN3() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOUTCLR_PIN4(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOUTCLR_PIN4() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOUTCLR_PIN5(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOUTCLR_PIN5() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOUTCLR_PIN6(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOUTCLR_PIN6() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOUTCLR_PIN7(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOUTCLR_PIN7() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOUTCLR_PIN8(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOUTCLR_PIN8() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOUTCLR_PIN9(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOUTCLR_PIN9() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOUTCLR_PIN10(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOUTCLR_PIN10() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOUTCLR_PIN11(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOUTCLR_PIN11() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOUTCLR_PIN12(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOUTCLR_PIN12() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOUTCLR_PIN13(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOUTCLR_PIN13() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOUTCLR_PIN14(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOUTCLR_PIN14() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOUTCLR_PIN15(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOUTCLR_PIN15() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOUTCLR_PIN16(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetOUTCLR_PIN16() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetOUTCLR_PIN17(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetOUTCLR_PIN17() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetOUTCLR_PIN18(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetOUTCLR_PIN18() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetOUTCLR_PIN19(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetOUTCLR_PIN19() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetOUTCLR_PIN20(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetOUTCLR_PIN20() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetOUTCLR_PIN21(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetOUTCLR_PIN21() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetOUTCLR_PIN22(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetOUTCLR_PIN22() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetOUTCLR_PIN23(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetOUTCLR_PIN23() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetOUTCLR_PIN24(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetOUTCLR_PIN24() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetOUTCLR_PIN25(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetOUTCLR_PIN25() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetOUTCLR_PIN26(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetOUTCLR_PIN26() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetOUTCLR_PIN27(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetOUTCLR_PIN27() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetOUTCLR_PIN28(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetOUTCLR_PIN28() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetOUTCLR_PIN29(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetOUTCLR_PIN29() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetOUTCLR_PIN30(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetOUTCLR_PIN30() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetOUTCLR_PIN31(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetOUTCLR_PIN31() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x80000000) >> 31
}

// GPIO.IN: Read GPIO port
func (o *GPIO_Type) SetIN_PIN0(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIN_PIN0() uint32 {
	return volatile.LoadUint32(&o.IN.Reg) & 0x1
}
func (o *GPIO_Type) SetIN_PIN1(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIN_PIN1() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIN_PIN2(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIN_PIN2() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIN_PIN3(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIN_PIN3() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIN_PIN4(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIN_PIN4() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIN_PIN5(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIN_PIN5() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIN_PIN6(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIN_PIN6() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIN_PIN7(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIN_PIN7() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIN_PIN8(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIN_PIN8() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIN_PIN9(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIN_PIN9() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIN_PIN10(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIN_PIN10() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIN_PIN11(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIN_PIN11() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIN_PIN12(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIN_PIN12() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIN_PIN13(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIN_PIN13() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIN_PIN14(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIN_PIN14() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIN_PIN15(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIN_PIN15() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIN_PIN16(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetIN_PIN16() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetIN_PIN17(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetIN_PIN17() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetIN_PIN18(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetIN_PIN18() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetIN_PIN19(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetIN_PIN19() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetIN_PIN20(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetIN_PIN20() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetIN_PIN21(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetIN_PIN21() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetIN_PIN22(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetIN_PIN22() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetIN_PIN23(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetIN_PIN23() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetIN_PIN24(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetIN_PIN24() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetIN_PIN25(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetIN_PIN25() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetIN_PIN26(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetIN_PIN26() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetIN_PIN27(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetIN_PIN27() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetIN_PIN28(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetIN_PIN28() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetIN_PIN29(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetIN_PIN29() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetIN_PIN30(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetIN_PIN30() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetIN_PIN31(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetIN_PIN31() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x80000000) >> 31
}

// GPIO.DIR: Direction of GPIO pins
func (o *GPIO_Type) SetDIR_PIN0(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIR_PIN0() uint32 {
	return volatile.LoadUint32(&o.DIR.Reg) & 0x1
}
func (o *GPIO_Type) SetDIR_PIN1(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIR_PIN1() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIR_PIN2(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIR_PIN2() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIR_PIN3(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIR_PIN3() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIR_PIN4(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIR_PIN4() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIR_PIN5(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIR_PIN5() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIR_PIN6(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIR_PIN6() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIR_PIN7(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIR_PIN7() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIR_PIN8(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIR_PIN8() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIR_PIN9(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIR_PIN9() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIR_PIN10(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIR_PIN10() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIR_PIN11(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIR_PIN11() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIR_PIN12(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIR_PIN12() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIR_PIN13(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIR_PIN13() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIR_PIN14(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIR_PIN14() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIR_PIN15(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIR_PIN15() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIR_PIN16(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIR_PIN16() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIR_PIN17(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIR_PIN17() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIR_PIN18(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIR_PIN18() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIR_PIN19(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIR_PIN19() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIR_PIN20(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIR_PIN20() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIR_PIN21(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIR_PIN21() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIR_PIN22(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIR_PIN22() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIR_PIN23(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIR_PIN23() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIR_PIN24(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIR_PIN24() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIR_PIN25(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIR_PIN25() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIR_PIN26(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIR_PIN26() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIR_PIN27(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIR_PIN27() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIR_PIN28(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIR_PIN28() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIR_PIN29(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIR_PIN29() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIR_PIN30(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIR_PIN30() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIR_PIN31(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIR_PIN31() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x80000000) >> 31
}

// GPIO.DIRSET: DIR set register
func (o *GPIO_Type) SetDIRSET_PIN0(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIRSET_PIN0() uint32 {
	return volatile.LoadUint32(&o.DIRSET.Reg) & 0x1
}
func (o *GPIO_Type) SetDIRSET_PIN1(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIRSET_PIN1() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIRSET_PIN2(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIRSET_PIN2() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIRSET_PIN3(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIRSET_PIN3() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIRSET_PIN4(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIRSET_PIN4() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIRSET_PIN5(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIRSET_PIN5() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIRSET_PIN6(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIRSET_PIN6() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIRSET_PIN7(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIRSET_PIN7() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIRSET_PIN8(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIRSET_PIN8() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIRSET_PIN9(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIRSET_PIN9() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIRSET_PIN10(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIRSET_PIN10() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIRSET_PIN11(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIRSET_PIN11() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIRSET_PIN12(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIRSET_PIN12() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIRSET_PIN13(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIRSET_PIN13() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIRSET_PIN14(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIRSET_PIN14() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIRSET_PIN15(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIRSET_PIN15() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIRSET_PIN16(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIRSET_PIN16() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIRSET_PIN17(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIRSET_PIN17() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIRSET_PIN18(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIRSET_PIN18() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIRSET_PIN19(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIRSET_PIN19() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIRSET_PIN20(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIRSET_PIN20() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIRSET_PIN21(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIRSET_PIN21() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIRSET_PIN22(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIRSET_PIN22() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIRSET_PIN23(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIRSET_PIN23() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIRSET_PIN24(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIRSET_PIN24() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIRSET_PIN25(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIRSET_PIN25() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIRSET_PIN26(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIRSET_PIN26() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIRSET_PIN27(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIRSET_PIN27() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIRSET_PIN28(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIRSET_PIN28() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIRSET_PIN29(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIRSET_PIN29() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIRSET_PIN30(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIRSET_PIN30() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIRSET_PIN31(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIRSET_PIN31() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x80000000) >> 31
}

// GPIO.DIRCLR: DIR clear register
func (o *GPIO_Type) SetDIRCLR_PIN0(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIRCLR_PIN0() uint32 {
	return volatile.LoadUint32(&o.DIRCLR.Reg) & 0x1
}
func (o *GPIO_Type) SetDIRCLR_PIN1(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIRCLR_PIN1() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIRCLR_PIN2(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIRCLR_PIN2() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIRCLR_PIN3(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIRCLR_PIN3() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIRCLR_PIN4(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIRCLR_PIN4() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIRCLR_PIN5(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIRCLR_PIN5() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIRCLR_PIN6(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIRCLR_PIN6() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIRCLR_PIN7(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIRCLR_PIN7() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIRCLR_PIN8(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIRCLR_PIN8() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIRCLR_PIN9(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIRCLR_PIN9() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIRCLR_PIN10(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIRCLR_PIN10() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIRCLR_PIN11(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIRCLR_PIN11() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIRCLR_PIN12(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIRCLR_PIN12() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIRCLR_PIN13(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIRCLR_PIN13() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIRCLR_PIN14(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIRCLR_PIN14() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIRCLR_PIN15(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIRCLR_PIN15() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIRCLR_PIN16(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIRCLR_PIN16() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIRCLR_PIN17(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIRCLR_PIN17() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIRCLR_PIN18(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIRCLR_PIN18() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIRCLR_PIN19(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIRCLR_PIN19() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIRCLR_PIN20(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIRCLR_PIN20() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIRCLR_PIN21(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIRCLR_PIN21() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIRCLR_PIN22(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIRCLR_PIN22() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIRCLR_PIN23(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIRCLR_PIN23() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIRCLR_PIN24(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIRCLR_PIN24() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIRCLR_PIN25(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIRCLR_PIN25() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIRCLR_PIN26(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIRCLR_PIN26() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIRCLR_PIN27(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIRCLR_PIN27() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIRCLR_PIN28(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIRCLR_PIN28() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIRCLR_PIN29(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIRCLR_PIN29() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIRCLR_PIN30(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIRCLR_PIN30() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIRCLR_PIN31(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIRCLR_PIN31() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x80000000) >> 31
}

// GPIO.LATCH: Latch register indicating what GPIO pins that have met the criteria set in the PIN_CNF[n].SENSE registers
func (o *GPIO_Type) SetLATCH_PIN0(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLATCH_PIN0() uint32 {
	return volatile.LoadUint32(&o.LATCH.Reg) & 0x1
}
func (o *GPIO_Type) SetLATCH_PIN1(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLATCH_PIN1() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLATCH_PIN2(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLATCH_PIN2() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLATCH_PIN3(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLATCH_PIN3() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLATCH_PIN4(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLATCH_PIN4() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLATCH_PIN5(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLATCH_PIN5() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLATCH_PIN6(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLATCH_PIN6() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLATCH_PIN7(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLATCH_PIN7() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLATCH_PIN8(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLATCH_PIN8() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLATCH_PIN9(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLATCH_PIN9() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLATCH_PIN10(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLATCH_PIN10() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLATCH_PIN11(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLATCH_PIN11() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLATCH_PIN12(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLATCH_PIN12() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLATCH_PIN13(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLATCH_PIN13() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLATCH_PIN14(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLATCH_PIN14() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLATCH_PIN15(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLATCH_PIN15() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLATCH_PIN16(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLATCH_PIN16() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLATCH_PIN17(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetLATCH_PIN17() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetLATCH_PIN18(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetLATCH_PIN18() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetLATCH_PIN19(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetLATCH_PIN19() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetLATCH_PIN20(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetLATCH_PIN20() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetLATCH_PIN21(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetLATCH_PIN21() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetLATCH_PIN22(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetLATCH_PIN22() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetLATCH_PIN23(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetLATCH_PIN23() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetLATCH_PIN24(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetLATCH_PIN24() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetLATCH_PIN25(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetLATCH_PIN25() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetLATCH_PIN26(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetLATCH_PIN26() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetLATCH_PIN27(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetLATCH_PIN27() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetLATCH_PIN28(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetLATCH_PIN28() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetLATCH_PIN29(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetLATCH_PIN29() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetLATCH_PIN30(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetLATCH_PIN30() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetLATCH_PIN31(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetLATCH_PIN31() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x80000000) >> 31
}

// GPIO.DETECTMODE: Select between default DETECT signal behavior and LDETECT mode (For non-secure pin only)
func (o *GPIO_Type) SetDETECTMODE(value uint32) {
	volatile.StoreUint32(&o.DETECTMODE.Reg, volatile.LoadUint32(&o.DETECTMODE.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDETECTMODE() uint32 {
	return volatile.LoadUint32(&o.DETECTMODE.Reg) & 0x1
}

// GPIO.DETECTMODE_SEC: Select between default DETECT signal behavior and LDETECT mode (For secure pin only)
func (o *GPIO_Type) SetDETECTMODE_SEC_DETECTMODE(value uint32) {
	volatile.StoreUint32(&o.DETECTMODE_SEC.Reg, volatile.LoadUint32(&o.DETECTMODE_SEC.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDETECTMODE_SEC_DETECTMODE() uint32 {
	return volatile.LoadUint32(&o.DETECTMODE_SEC.Reg) & 0x1
}

// GPIO.PIN_CNF: Description collection: Configuration of GPIO pins
func (o *GPIO_Type) SetPIN_CNF_DIR(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetPIN_CNF_DIR(idx int) uint32 {
	return volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0x1
}
func (o *GPIO_Type) SetPIN_CNF_INPUT(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetPIN_CNF_INPUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetPIN_CNF_PULL(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPIN_CNF_PULL(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPIN_CNF_DRIVE(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetPIN_CNF_DRIVE(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetPIN_CNF_SENSE(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPIN_CNF_SENSE(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetPIN_CNF_MCUSEL(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0x70000000)|value<<28)
}
func (o *GPIO_Type) GetPIN_CNF_MCUSEL(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0x70000000) >> 28
}

// ARM TrustZone CryptoCell register interface
type CRYPTOCELL_Type struct {
	_      [1280]byte
	ENABLE volatile.Register32 // 0x500
}

// CRYPTOCELL.ENABLE: Enable CRYPTOCELL subsystem.
func (o *CRYPTOCELL_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *CRYPTOCELL_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// Volatile Memory controller 0
type VMC_Type struct {
	_   [1536]byte
	RAM [8]VMC_RAM_Type // 0x600
}

type VMC_RAM_Type struct {
	POWER    volatile.Register32 // 0x600
	POWERSET volatile.Register32 // 0x604
	POWERCLR volatile.Register32 // 0x608
	_        [4]byte
}

// VMC_RAM.POWER: Description cluster: RAM[n] power control register
func (o *VMC_RAM_Type) SetPOWER_S0POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x1)|value)
}
func (o *VMC_RAM_Type) GetPOWER_S0POWER() uint32 {
	return volatile.LoadUint32(&o.POWER.Reg) & 0x1
}
func (o *VMC_RAM_Type) SetPOWER_S1POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x2)|value<<1)
}
func (o *VMC_RAM_Type) GetPOWER_S1POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x2) >> 1
}
func (o *VMC_RAM_Type) SetPOWER_S2POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x4)|value<<2)
}
func (o *VMC_RAM_Type) GetPOWER_S2POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x4) >> 2
}
func (o *VMC_RAM_Type) SetPOWER_S3POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x8)|value<<3)
}
func (o *VMC_RAM_Type) GetPOWER_S3POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x8) >> 3
}
func (o *VMC_RAM_Type) SetPOWER_S4POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x10)|value<<4)
}
func (o *VMC_RAM_Type) GetPOWER_S4POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x10) >> 4
}
func (o *VMC_RAM_Type) SetPOWER_S5POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x20)|value<<5)
}
func (o *VMC_RAM_Type) GetPOWER_S5POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x20) >> 5
}
func (o *VMC_RAM_Type) SetPOWER_S6POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x40)|value<<6)
}
func (o *VMC_RAM_Type) GetPOWER_S6POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x40) >> 6
}
func (o *VMC_RAM_Type) SetPOWER_S7POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x80)|value<<7)
}
func (o *VMC_RAM_Type) GetPOWER_S7POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x80) >> 7
}
func (o *VMC_RAM_Type) SetPOWER_S8POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x100)|value<<8)
}
func (o *VMC_RAM_Type) GetPOWER_S8POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x100) >> 8
}
func (o *VMC_RAM_Type) SetPOWER_S9POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x200)|value<<9)
}
func (o *VMC_RAM_Type) GetPOWER_S9POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x200) >> 9
}
func (o *VMC_RAM_Type) SetPOWER_S10POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x400)|value<<10)
}
func (o *VMC_RAM_Type) GetPOWER_S10POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x400) >> 10
}
func (o *VMC_RAM_Type) SetPOWER_S11POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x800)|value<<11)
}
func (o *VMC_RAM_Type) GetPOWER_S11POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x800) >> 11
}
func (o *VMC_RAM_Type) SetPOWER_S12POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x1000)|value<<12)
}
func (o *VMC_RAM_Type) GetPOWER_S12POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x1000) >> 12
}
func (o *VMC_RAM_Type) SetPOWER_S13POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x2000)|value<<13)
}
func (o *VMC_RAM_Type) GetPOWER_S13POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x2000) >> 13
}
func (o *VMC_RAM_Type) SetPOWER_S14POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x4000)|value<<14)
}
func (o *VMC_RAM_Type) GetPOWER_S14POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x4000) >> 14
}
func (o *VMC_RAM_Type) SetPOWER_S15POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x8000)|value<<15)
}
func (o *VMC_RAM_Type) GetPOWER_S15POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x8000) >> 15
}
func (o *VMC_RAM_Type) SetPOWER_S0RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x10000)|value<<16)
}
func (o *VMC_RAM_Type) GetPOWER_S0RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x10000) >> 16
}
func (o *VMC_RAM_Type) SetPOWER_S1RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x20000)|value<<17)
}
func (o *VMC_RAM_Type) GetPOWER_S1RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x20000) >> 17
}
func (o *VMC_RAM_Type) SetPOWER_S2RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x40000)|value<<18)
}
func (o *VMC_RAM_Type) GetPOWER_S2RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x40000) >> 18
}
func (o *VMC_RAM_Type) SetPOWER_S3RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x80000)|value<<19)
}
func (o *VMC_RAM_Type) GetPOWER_S3RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x80000) >> 19
}
func (o *VMC_RAM_Type) SetPOWER_S4RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x100000)|value<<20)
}
func (o *VMC_RAM_Type) GetPOWER_S4RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x100000) >> 20
}
func (o *VMC_RAM_Type) SetPOWER_S5RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x200000)|value<<21)
}
func (o *VMC_RAM_Type) GetPOWER_S5RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x200000) >> 21
}
func (o *VMC_RAM_Type) SetPOWER_S6RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x400000)|value<<22)
}
func (o *VMC_RAM_Type) GetPOWER_S6RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x400000) >> 22
}
func (o *VMC_RAM_Type) SetPOWER_S7RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x800000)|value<<23)
}
func (o *VMC_RAM_Type) GetPOWER_S7RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x800000) >> 23
}
func (o *VMC_RAM_Type) SetPOWER_S8RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x1000000)|value<<24)
}
func (o *VMC_RAM_Type) GetPOWER_S8RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x1000000) >> 24
}
func (o *VMC_RAM_Type) SetPOWER_S9RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x2000000)|value<<25)
}
func (o *VMC_RAM_Type) GetPOWER_S9RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x2000000) >> 25
}
func (o *VMC_RAM_Type) SetPOWER_S10RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x4000000)|value<<26)
}
func (o *VMC_RAM_Type) GetPOWER_S10RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x4000000) >> 26
}
func (o *VMC_RAM_Type) SetPOWER_S11RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x8000000)|value<<27)
}
func (o *VMC_RAM_Type) GetPOWER_S11RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x8000000) >> 27
}
func (o *VMC_RAM_Type) SetPOWER_S12RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x10000000)|value<<28)
}
func (o *VMC_RAM_Type) GetPOWER_S12RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x10000000) >> 28
}
func (o *VMC_RAM_Type) SetPOWER_S13RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x20000000)|value<<29)
}
func (o *VMC_RAM_Type) GetPOWER_S13RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x20000000) >> 29
}
func (o *VMC_RAM_Type) SetPOWER_S14RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x40000000)|value<<30)
}
func (o *VMC_RAM_Type) GetPOWER_S14RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x40000000) >> 30
}
func (o *VMC_RAM_Type) SetPOWER_S15RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x80000000)|value<<31)
}
func (o *VMC_RAM_Type) GetPOWER_S15RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x80000000) >> 31
}

// VMC_RAM.POWERSET: Description cluster: RAM[n] power control set register
func (o *VMC_RAM_Type) SetPOWERSET_S0POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x1)|value)
}
func (o *VMC_RAM_Type) GetPOWERSET_S0POWER() uint32 {
	return volatile.LoadUint32(&o.POWERSET.Reg) & 0x1
}
func (o *VMC_RAM_Type) SetPOWERSET_S1POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x2)|value<<1)
}
func (o *VMC_RAM_Type) GetPOWERSET_S1POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x2) >> 1
}
func (o *VMC_RAM_Type) SetPOWERSET_S2POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x4)|value<<2)
}
func (o *VMC_RAM_Type) GetPOWERSET_S2POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x4) >> 2
}
func (o *VMC_RAM_Type) SetPOWERSET_S3POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x8)|value<<3)
}
func (o *VMC_RAM_Type) GetPOWERSET_S3POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x8) >> 3
}
func (o *VMC_RAM_Type) SetPOWERSET_S4POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x10)|value<<4)
}
func (o *VMC_RAM_Type) GetPOWERSET_S4POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x10) >> 4
}
func (o *VMC_RAM_Type) SetPOWERSET_S5POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x20)|value<<5)
}
func (o *VMC_RAM_Type) GetPOWERSET_S5POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x20) >> 5
}
func (o *VMC_RAM_Type) SetPOWERSET_S6POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x40)|value<<6)
}
func (o *VMC_RAM_Type) GetPOWERSET_S6POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x40) >> 6
}
func (o *VMC_RAM_Type) SetPOWERSET_S7POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x80)|value<<7)
}
func (o *VMC_RAM_Type) GetPOWERSET_S7POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x80) >> 7
}
func (o *VMC_RAM_Type) SetPOWERSET_S8POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x100)|value<<8)
}
func (o *VMC_RAM_Type) GetPOWERSET_S8POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x100) >> 8
}
func (o *VMC_RAM_Type) SetPOWERSET_S9POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x200)|value<<9)
}
func (o *VMC_RAM_Type) GetPOWERSET_S9POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x200) >> 9
}
func (o *VMC_RAM_Type) SetPOWERSET_S10POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x400)|value<<10)
}
func (o *VMC_RAM_Type) GetPOWERSET_S10POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x400) >> 10
}
func (o *VMC_RAM_Type) SetPOWERSET_S11POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x800)|value<<11)
}
func (o *VMC_RAM_Type) GetPOWERSET_S11POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x800) >> 11
}
func (o *VMC_RAM_Type) SetPOWERSET_S12POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x1000)|value<<12)
}
func (o *VMC_RAM_Type) GetPOWERSET_S12POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x1000) >> 12
}
func (o *VMC_RAM_Type) SetPOWERSET_S13POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x2000)|value<<13)
}
func (o *VMC_RAM_Type) GetPOWERSET_S13POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x2000) >> 13
}
func (o *VMC_RAM_Type) SetPOWERSET_S14POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x4000)|value<<14)
}
func (o *VMC_RAM_Type) GetPOWERSET_S14POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x4000) >> 14
}
func (o *VMC_RAM_Type) SetPOWERSET_S15POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x8000)|value<<15)
}
func (o *VMC_RAM_Type) GetPOWERSET_S15POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x8000) >> 15
}
func (o *VMC_RAM_Type) SetPOWERSET_S0RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x10000)|value<<16)
}
func (o *VMC_RAM_Type) GetPOWERSET_S0RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x10000) >> 16
}
func (o *VMC_RAM_Type) SetPOWERSET_S1RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x20000)|value<<17)
}
func (o *VMC_RAM_Type) GetPOWERSET_S1RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x20000) >> 17
}
func (o *VMC_RAM_Type) SetPOWERSET_S2RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x40000)|value<<18)
}
func (o *VMC_RAM_Type) GetPOWERSET_S2RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x40000) >> 18
}
func (o *VMC_RAM_Type) SetPOWERSET_S3RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x80000)|value<<19)
}
func (o *VMC_RAM_Type) GetPOWERSET_S3RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x80000) >> 19
}
func (o *VMC_RAM_Type) SetPOWERSET_S4RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x100000)|value<<20)
}
func (o *VMC_RAM_Type) GetPOWERSET_S4RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x100000) >> 20
}
func (o *VMC_RAM_Type) SetPOWERSET_S5RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x200000)|value<<21)
}
func (o *VMC_RAM_Type) GetPOWERSET_S5RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x200000) >> 21
}
func (o *VMC_RAM_Type) SetPOWERSET_S6RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x400000)|value<<22)
}
func (o *VMC_RAM_Type) GetPOWERSET_S6RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x400000) >> 22
}
func (o *VMC_RAM_Type) SetPOWERSET_S7RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x800000)|value<<23)
}
func (o *VMC_RAM_Type) GetPOWERSET_S7RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x800000) >> 23
}
func (o *VMC_RAM_Type) SetPOWERSET_S8RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x1000000)|value<<24)
}
func (o *VMC_RAM_Type) GetPOWERSET_S8RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x1000000) >> 24
}
func (o *VMC_RAM_Type) SetPOWERSET_S9RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x2000000)|value<<25)
}
func (o *VMC_RAM_Type) GetPOWERSET_S9RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x2000000) >> 25
}
func (o *VMC_RAM_Type) SetPOWERSET_S10RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x4000000)|value<<26)
}
func (o *VMC_RAM_Type) GetPOWERSET_S10RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x4000000) >> 26
}
func (o *VMC_RAM_Type) SetPOWERSET_S11RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x8000000)|value<<27)
}
func (o *VMC_RAM_Type) GetPOWERSET_S11RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x8000000) >> 27
}
func (o *VMC_RAM_Type) SetPOWERSET_S12RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x10000000)|value<<28)
}
func (o *VMC_RAM_Type) GetPOWERSET_S12RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x10000000) >> 28
}
func (o *VMC_RAM_Type) SetPOWERSET_S13RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x20000000)|value<<29)
}
func (o *VMC_RAM_Type) GetPOWERSET_S13RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x20000000) >> 29
}
func (o *VMC_RAM_Type) SetPOWERSET_S14RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x40000000)|value<<30)
}
func (o *VMC_RAM_Type) GetPOWERSET_S14RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x40000000) >> 30
}
func (o *VMC_RAM_Type) SetPOWERSET_S15RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x80000000)|value<<31)
}
func (o *VMC_RAM_Type) GetPOWERSET_S15RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x80000000) >> 31
}

// VMC_RAM.POWERCLR: Description cluster: RAM[n] power control clear register
func (o *VMC_RAM_Type) SetPOWERCLR_S0POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x1)|value)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S0POWER() uint32 {
	return volatile.LoadUint32(&o.POWERCLR.Reg) & 0x1
}
func (o *VMC_RAM_Type) SetPOWERCLR_S1POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x2)|value<<1)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S1POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x2) >> 1
}
func (o *VMC_RAM_Type) SetPOWERCLR_S2POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x4)|value<<2)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S2POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x4) >> 2
}
func (o *VMC_RAM_Type) SetPOWERCLR_S3POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x8)|value<<3)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S3POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x8) >> 3
}
func (o *VMC_RAM_Type) SetPOWERCLR_S4POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x10)|value<<4)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S4POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x10) >> 4
}
func (o *VMC_RAM_Type) SetPOWERCLR_S5POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x20)|value<<5)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S5POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x20) >> 5
}
func (o *VMC_RAM_Type) SetPOWERCLR_S6POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x40)|value<<6)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S6POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x40) >> 6
}
func (o *VMC_RAM_Type) SetPOWERCLR_S7POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x80)|value<<7)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S7POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x80) >> 7
}
func (o *VMC_RAM_Type) SetPOWERCLR_S8POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x100)|value<<8)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S8POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x100) >> 8
}
func (o *VMC_RAM_Type) SetPOWERCLR_S9POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x200)|value<<9)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S9POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x200) >> 9
}
func (o *VMC_RAM_Type) SetPOWERCLR_S10POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x400)|value<<10)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S10POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x400) >> 10
}
func (o *VMC_RAM_Type) SetPOWERCLR_S11POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x800)|value<<11)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S11POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x800) >> 11
}
func (o *VMC_RAM_Type) SetPOWERCLR_S12POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x1000)|value<<12)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S12POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x1000) >> 12
}
func (o *VMC_RAM_Type) SetPOWERCLR_S13POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x2000)|value<<13)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S13POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x2000) >> 13
}
func (o *VMC_RAM_Type) SetPOWERCLR_S14POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x4000)|value<<14)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S14POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x4000) >> 14
}
func (o *VMC_RAM_Type) SetPOWERCLR_S15POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x8000)|value<<15)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S15POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x8000) >> 15
}
func (o *VMC_RAM_Type) SetPOWERCLR_S0RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x10000)|value<<16)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S0RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x10000) >> 16
}
func (o *VMC_RAM_Type) SetPOWERCLR_S1RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x20000)|value<<17)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S1RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x20000) >> 17
}
func (o *VMC_RAM_Type) SetPOWERCLR_S2RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x40000)|value<<18)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S2RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x40000) >> 18
}
func (o *VMC_RAM_Type) SetPOWERCLR_S3RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x80000)|value<<19)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S3RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x80000) >> 19
}
func (o *VMC_RAM_Type) SetPOWERCLR_S4RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x100000)|value<<20)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S4RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x100000) >> 20
}
func (o *VMC_RAM_Type) SetPOWERCLR_S5RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x200000)|value<<21)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S5RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x200000) >> 21
}
func (o *VMC_RAM_Type) SetPOWERCLR_S6RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x400000)|value<<22)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S6RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x400000) >> 22
}
func (o *VMC_RAM_Type) SetPOWERCLR_S7RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x800000)|value<<23)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S7RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x800000) >> 23
}
func (o *VMC_RAM_Type) SetPOWERCLR_S8RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S8RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x1000000) >> 24
}
func (o *VMC_RAM_Type) SetPOWERCLR_S9RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S9RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x2000000) >> 25
}
func (o *VMC_RAM_Type) SetPOWERCLR_S10RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S10RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x4000000) >> 26
}
func (o *VMC_RAM_Type) SetPOWERCLR_S11RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S11RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x8000000) >> 27
}
func (o *VMC_RAM_Type) SetPOWERCLR_S12RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S12RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x10000000) >> 28
}
func (o *VMC_RAM_Type) SetPOWERCLR_S13RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S13RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x20000000) >> 29
}
func (o *VMC_RAM_Type) SetPOWERCLR_S14RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S14RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x40000000) >> 30
}
func (o *VMC_RAM_Type) SetPOWERCLR_S15RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S15RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x80000000) >> 31
}

// Constants for CACHEDATA_S: CACHEDATA
const ()

// Constants for CACHEINFO_S: CACHEINFO
const (
	// SET.WAY: Description collection: Cache information for SET[n], WAY[o].
	// Position of TAG field.
	CACHEINFO_SET_WAY_TAG_Pos = 0x0
	// Bit mask of TAG field.
	CACHEINFO_SET_WAY_TAG_Msk = 0x1ffff
	// Position of V field.
	CACHEINFO_SET_WAY_V_Pos = 0x1e
	// Bit mask of V field.
	CACHEINFO_SET_WAY_V_Msk = 0x40000000
	// Bit V.
	CACHEINFO_SET_WAY_V = 0x40000000
	// Invalid cache line
	CACHEINFO_SET_WAY_V_Invalid = 0x0
	// Valid cache line
	CACHEINFO_SET_WAY_V_Valid = 0x1
	// Position of MRU field.
	CACHEINFO_SET_WAY_MRU_Pos = 0x1f
	// Bit mask of MRU field.
	CACHEINFO_SET_WAY_MRU_Msk = 0x80000000
	// Bit MRU.
	CACHEINFO_SET_WAY_MRU = 0x80000000
	// Way0 was most recently used
	CACHEINFO_SET_WAY_MRU_Way0 = 0x0
	// Way1 was most recently used
	CACHEINFO_SET_WAY_MRU_Way1 = 0x1
)

// Constants for FICR_S: Factory Information Configuration Registers
const (
	// INFO.CONFIGID: Configuration identifier
	// Position of HWID field.
	FICR_INFO_CONFIGID_HWID_Pos = 0x0
	// Bit mask of HWID field.
	FICR_INFO_CONFIGID_HWID_Msk = 0xffff

	// INFO.DEVICEID: Description collection: Device identifier
	// Position of DEVICEID field.
	FICR_INFO_DEVICEID_DEVICEID_Pos = 0x0
	// Bit mask of DEVICEID field.
	FICR_INFO_DEVICEID_DEVICEID_Msk = 0xffffffff

	// INFO.PART: Part code
	// Position of PART field.
	FICR_INFO_PART_PART_Pos = 0x0
	// Bit mask of PART field.
	FICR_INFO_PART_PART_Msk = 0xffffffff
	// nRF5340
	FICR_INFO_PART_PART_N5340 = 0x5340
	// Unspecified
	FICR_INFO_PART_PART_Unspecified = 0xffffffff

	// INFO.VARIANT: Part Variant, Hardware version and Production configuration
	// Position of VARIANT field.
	FICR_INFO_VARIANT_VARIANT_Pos = 0x0
	// Bit mask of VARIANT field.
	FICR_INFO_VARIANT_VARIANT_Msk = 0xffffffff
	// QKAA
	FICR_INFO_VARIANT_VARIANT_QKAA = 0x514b4141
	// Unspecified
	FICR_INFO_VARIANT_VARIANT_Unspecified = 0xffffffff

	// INFO.PACKAGE: Package option
	// Position of PACKAGE field.
	FICR_INFO_PACKAGE_PACKAGE_Pos = 0x0
	// Bit mask of PACKAGE field.
	FICR_INFO_PACKAGE_PACKAGE_Msk = 0xffffffff
	// QFxx - 94 pin QFN
	FICR_INFO_PACKAGE_PACKAGE_QF = 0x2000
	// Unspecified
	FICR_INFO_PACKAGE_PACKAGE_Unspecified = 0xffffffff

	// INFO.RAM: RAM variant
	// Position of RAM field.
	FICR_INFO_RAM_RAM_Pos = 0x0
	// Bit mask of RAM field.
	FICR_INFO_RAM_RAM_Msk = 0xffffffff
	// 16 kByte RAM
	FICR_INFO_RAM_RAM_K16 = 0x10
	// 32 kByte RAM
	FICR_INFO_RAM_RAM_K32 = 0x20
	// 64 kByte RAM
	FICR_INFO_RAM_RAM_K64 = 0x40
	// 128 kByte RAM
	FICR_INFO_RAM_RAM_K128 = 0x80
	// 256 kByte RAM
	FICR_INFO_RAM_RAM_K256 = 0x100
	// 512 kByte RAM
	FICR_INFO_RAM_RAM_K512 = 0x200
	// Unspecified
	FICR_INFO_RAM_RAM_Unspecified = 0xffffffff

	// INFO.FLASH: Flash variant
	// Position of FLASH field.
	FICR_INFO_FLASH_FLASH_Pos = 0x0
	// Bit mask of FLASH field.
	FICR_INFO_FLASH_FLASH_Msk = 0xffffffff
	// 128 kByte FLASH
	FICR_INFO_FLASH_FLASH_K128 = 0x80
	// 256 kByte FLASH
	FICR_INFO_FLASH_FLASH_K256 = 0x100
	// 512 kByte FLASH
	FICR_INFO_FLASH_FLASH_K512 = 0x200
	// 1 MByte FLASH
	FICR_INFO_FLASH_FLASH_K1024 = 0x400
	// 2 MByte FLASH
	FICR_INFO_FLASH_FLASH_K2048 = 0x800
	// Unspecified
	FICR_INFO_FLASH_FLASH_Unspecified = 0xffffffff

	// INFO.CODEPAGESIZE: Code memory page size in bytes
	// Position of CODEPAGESIZE field.
	FICR_INFO_CODEPAGESIZE_CODEPAGESIZE_Pos = 0x0
	// Bit mask of CODEPAGESIZE field.
	FICR_INFO_CODEPAGESIZE_CODEPAGESIZE_Msk = 0xffffffff
	// 4 kByte
	FICR_INFO_CODEPAGESIZE_CODEPAGESIZE_K4096 = 0x1000

	// INFO.CODESIZE: Code memory size
	// Position of CODESIZE field.
	FICR_INFO_CODESIZE_CODESIZE_Pos = 0x0
	// Bit mask of CODESIZE field.
	FICR_INFO_CODESIZE_CODESIZE_Msk = 0xffffffff
	// 256 pages
	FICR_INFO_CODESIZE_CODESIZE_P256 = 0x100

	// INFO.DEVICETYPE: Device type
	// Position of DEVICETYPE field.
	FICR_INFO_DEVICETYPE_DEVICETYPE_Pos = 0x0
	// Bit mask of DEVICETYPE field.
	FICR_INFO_DEVICETYPE_DEVICETYPE_Msk = 0xffffffff
	// Device is an physical DIE
	FICR_INFO_DEVICETYPE_DEVICETYPE_Die = 0x0
	// Device is an FPGA
	FICR_INFO_DEVICETYPE_DEVICETYPE_FPGA = 0xffffffff

	// TRIMCNF.ADDR: Description cluster: Address of the PAR register which will be written
	// Position of Address field.
	FICR_TRIMCNF_ADDR_Address_Pos = 0x0
	// Bit mask of Address field.
	FICR_TRIMCNF_ADDR_Address_Msk = 0xffffffff

	// TRIMCNF.DATA: Description cluster: Data
	// Position of Data field.
	FICR_TRIMCNF_DATA_Data_Pos = 0x0
	// Bit mask of Data field.
	FICR_TRIMCNF_DATA_Data_Msk = 0xffffffff

	// NFC.TAGHEADER0: Default header for NFC Tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST and NFCID1_LAST.
	// Position of MFGID field.
	FICR_NFC_TAGHEADER0_MFGID_Pos = 0x0
	// Bit mask of MFGID field.
	FICR_NFC_TAGHEADER0_MFGID_Msk = 0xff
	// Position of UD1 field.
	FICR_NFC_TAGHEADER0_UD1_Pos = 0x8
	// Bit mask of UD1 field.
	FICR_NFC_TAGHEADER0_UD1_Msk = 0xff00
	// Position of UD2 field.
	FICR_NFC_TAGHEADER0_UD2_Pos = 0x10
	// Bit mask of UD2 field.
	FICR_NFC_TAGHEADER0_UD2_Msk = 0xff0000
	// Position of UD3 field.
	FICR_NFC_TAGHEADER0_UD3_Pos = 0x18
	// Bit mask of UD3 field.
	FICR_NFC_TAGHEADER0_UD3_Msk = 0xff000000

	// NFC.TAGHEADER1: Default header for NFC Tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST and NFCID1_LAST.
	// Position of UD4 field.
	FICR_NFC_TAGHEADER1_UD4_Pos = 0x0
	// Bit mask of UD4 field.
	FICR_NFC_TAGHEADER1_UD4_Msk = 0xff
	// Position of UD5 field.
	FICR_NFC_TAGHEADER1_UD5_Pos = 0x8
	// Bit mask of UD5 field.
	FICR_NFC_TAGHEADER1_UD5_Msk = 0xff00
	// Position of UD6 field.
	FICR_NFC_TAGHEADER1_UD6_Pos = 0x10
	// Bit mask of UD6 field.
	FICR_NFC_TAGHEADER1_UD6_Msk = 0xff0000
	// Position of UD7 field.
	FICR_NFC_TAGHEADER1_UD7_Pos = 0x18
	// Bit mask of UD7 field.
	FICR_NFC_TAGHEADER1_UD7_Msk = 0xff000000

	// NFC.TAGHEADER2: Default header for NFC Tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST and NFCID1_LAST.
	// Position of UD8 field.
	FICR_NFC_TAGHEADER2_UD8_Pos = 0x0
	// Bit mask of UD8 field.
	FICR_NFC_TAGHEADER2_UD8_Msk = 0xff
	// Position of UD9 field.
	FICR_NFC_TAGHEADER2_UD9_Pos = 0x8
	// Bit mask of UD9 field.
	FICR_NFC_TAGHEADER2_UD9_Msk = 0xff00
	// Position of UD10 field.
	FICR_NFC_TAGHEADER2_UD10_Pos = 0x10
	// Bit mask of UD10 field.
	FICR_NFC_TAGHEADER2_UD10_Msk = 0xff0000
	// Position of UD11 field.
	FICR_NFC_TAGHEADER2_UD11_Pos = 0x18
	// Bit mask of UD11 field.
	FICR_NFC_TAGHEADER2_UD11_Msk = 0xff000000

	// NFC.TAGHEADER3: Default header for NFC Tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST and NFCID1_LAST.
	// Position of UD12 field.
	FICR_NFC_TAGHEADER3_UD12_Pos = 0x0
	// Bit mask of UD12 field.
	FICR_NFC_TAGHEADER3_UD12_Msk = 0xff
	// Position of UD13 field.
	FICR_NFC_TAGHEADER3_UD13_Pos = 0x8
	// Bit mask of UD13 field.
	FICR_NFC_TAGHEADER3_UD13_Msk = 0xff00
	// Position of UD14 field.
	FICR_NFC_TAGHEADER3_UD14_Pos = 0x10
	// Bit mask of UD14 field.
	FICR_NFC_TAGHEADER3_UD14_Msk = 0xff0000
	// Position of UD15 field.
	FICR_NFC_TAGHEADER3_UD15_Pos = 0x18
	// Bit mask of UD15 field.
	FICR_NFC_TAGHEADER3_UD15_Msk = 0xff000000

	// TRNG90B.BYTES: Amount of bytes for the required entropy bits
	// Position of BYTES field.
	FICR_TRNG90B_BYTES_BYTES_Pos = 0x0
	// Bit mask of BYTES field.
	FICR_TRNG90B_BYTES_BYTES_Msk = 0xffffffff

	// TRNG90B.RCCUTOFF: Repetition counter cutoff
	// Position of RCCUTOFF field.
	FICR_TRNG90B_RCCUTOFF_RCCUTOFF_Pos = 0x0
	// Bit mask of RCCUTOFF field.
	FICR_TRNG90B_RCCUTOFF_RCCUTOFF_Msk = 0xffffffff

	// TRNG90B.APCUTOFF: Adaptive proportion cutoff
	// Position of APCUTOFF field.
	FICR_TRNG90B_APCUTOFF_APCUTOFF_Pos = 0x0
	// Bit mask of APCUTOFF field.
	FICR_TRNG90B_APCUTOFF_APCUTOFF_Msk = 0xffffffff

	// TRNG90B.STARTUP: Amount of bytes for the startup tests
	// Position of STARTUP field.
	FICR_TRNG90B_STARTUP_STARTUP_Pos = 0x0
	// Bit mask of STARTUP field.
	FICR_TRNG90B_STARTUP_STARTUP_Msk = 0xffffffff

	// TRNG90B.ROSC1: Sample count for ring oscillator 1
	// Position of ROSC1 field.
	FICR_TRNG90B_ROSC1_ROSC1_Pos = 0x0
	// Bit mask of ROSC1 field.
	FICR_TRNG90B_ROSC1_ROSC1_Msk = 0xffffffff

	// TRNG90B.ROSC2: Sample count for ring oscillator 2
	// Position of ROSC2 field.
	FICR_TRNG90B_ROSC2_ROSC2_Pos = 0x0
	// Bit mask of ROSC2 field.
	FICR_TRNG90B_ROSC2_ROSC2_Msk = 0xffffffff

	// TRNG90B.ROSC3: Sample count for ring oscillator 3
	// Position of ROSC3 field.
	FICR_TRNG90B_ROSC3_ROSC3_Pos = 0x0
	// Bit mask of ROSC3 field.
	FICR_TRNG90B_ROSC3_ROSC3_Msk = 0xffffffff

	// TRNG90B.ROSC4: Sample count for ring oscillator 4
	// Position of ROSC4 field.
	FICR_TRNG90B_ROSC4_ROSC4_Pos = 0x0
	// Bit mask of ROSC4 field.
	FICR_TRNG90B_ROSC4_ROSC4_Msk = 0xffffffff

	// XOSC32MTRIM: XOSC32M capacitor selection trim values
	// Position of SLOPE field.
	FICR_XOSC32MTRIM_SLOPE_Pos = 0x0
	// Bit mask of SLOPE field.
	FICR_XOSC32MTRIM_SLOPE_Msk = 0x1f
	// Position of OFFSET field.
	FICR_XOSC32MTRIM_OFFSET_Pos = 0x5
	// Bit mask of OFFSET field.
	FICR_XOSC32MTRIM_OFFSET_Msk = 0x3e0
)

// Constants for UICR_S: User Information Configuration Registers User information configuration registers
const (
	// APPROTECT: Access port protection
	// Position of PALL field.
	UICR_APPROTECT_PALL_Pos = 0x0
	// Bit mask of PALL field.
	UICR_APPROTECT_PALL_Msk = 0xffffffff
	// Unprotected
	UICR_APPROTECT_PALL_Unprotected = 0xffffffff
	// Protected
	UICR_APPROTECT_PALL_Protected = 0x0

	// EXTSUPPLY: Enable external circuitry to be supplied from VDD pin. Applicable in 'High voltage mode' only.
	// Position of EXTSUPPLY field.
	UICR_EXTSUPPLY_EXTSUPPLY_Pos = 0x0
	// Bit mask of EXTSUPPLY field.
	UICR_EXTSUPPLY_EXTSUPPLY_Msk = 0x1
	// Bit EXTSUPPLY.
	UICR_EXTSUPPLY_EXTSUPPLY = 0x1
	// No current can be drawn from the VDD pin.
	UICR_EXTSUPPLY_EXTSUPPLY_Disabled = 0x1
	// It is allowed to supply external circuitry from the VDD pin.
	UICR_EXTSUPPLY_EXTSUPPLY_Enabled = 0x0

	// VREGHVOUT: GPIO reference voltage / external output supply voltage in 'High voltage mode'.
	// Position of VREGHVOUT field.
	UICR_VREGHVOUT_VREGHVOUT_Pos = 0x0
	// Bit mask of VREGHVOUT field.
	UICR_VREGHVOUT_VREGHVOUT_Msk = 0x7
	// 1.8 V
	UICR_VREGHVOUT_VREGHVOUT_1V8 = 0x0
	// 2.1 V
	UICR_VREGHVOUT_VREGHVOUT_2V1 = 0x1
	// 2.4 V
	UICR_VREGHVOUT_VREGHVOUT_2V4 = 0x2
	// 2.7 V
	UICR_VREGHVOUT_VREGHVOUT_2V7 = 0x3
	// 3.0 V
	UICR_VREGHVOUT_VREGHVOUT_3V0 = 0x4
	// 3.3 V
	UICR_VREGHVOUT_VREGHVOUT_3V3 = 0x5
	// Default voltage: 1.8 V
	UICR_VREGHVOUT_VREGHVOUT_DEFAULT = 0x7

	// HFXOCNT: HFXO startup counter
	// Position of HFXOCNT field.
	UICR_HFXOCNT_HFXOCNT_Pos = 0x0
	// Bit mask of HFXOCNT field.
	UICR_HFXOCNT_HFXOCNT_Msk = 0xff
	// Min debounce time = (0*64 us + 0.5 us)
	UICR_HFXOCNT_HFXOCNT_MinDebounceTime = 0x0
	// Max debounce time = (254*64 us + 0.5 us)
	UICR_HFXOCNT_HFXOCNT_MaxDebounceTime = 0xfe
	// Default debounce time for erased UICR = 4*64 us + 0.5 us
	UICR_HFXOCNT_HFXOCNT_DefaultDebounceTime = 0xff

	// SECUREAPPROTECT: Secure access port protection
	// Position of PALL field.
	UICR_SECUREAPPROTECT_PALL_Pos = 0x0
	// Bit mask of PALL field.
	UICR_SECUREAPPROTECT_PALL_Msk = 0xffffffff
	// Unprotected
	UICR_SECUREAPPROTECT_PALL_Unprotected = 0xffffffff
	// Protected
	UICR_SECUREAPPROTECT_PALL_Protected = 0x0

	// ERASEPROTECT: Erase protection
	// Position of PALL field.
	UICR_ERASEPROTECT_PALL_Pos = 0x0
	// Bit mask of PALL field.
	UICR_ERASEPROTECT_PALL_Msk = 0xffffffff
	// Unprotected
	UICR_ERASEPROTECT_PALL_Unprotected = 0xffffffff
	// Protected
	UICR_ERASEPROTECT_PALL_Protected = 0x0

	// TINSTANCE: SW-DP Target instance
	// Position of TINSTANCE field.
	UICR_TINSTANCE_TINSTANCE_Pos = 0x1c
	// Bit mask of TINSTANCE field.
	UICR_TINSTANCE_TINSTANCE_Msk = 0xf0000000

	// NFCPINS: Setting of pins dedicated to NFC functionality: NFC antenna or GPIO
	// Position of PROTECT field.
	UICR_NFCPINS_PROTECT_Pos = 0x0
	// Bit mask of PROTECT field.
	UICR_NFCPINS_PROTECT_Msk = 0x1
	// Bit PROTECT.
	UICR_NFCPINS_PROTECT = 0x1
	// Operation as GPIO pins. Same protection as normal GPIO pins
	UICR_NFCPINS_PROTECT_Disabled = 0x0
	// Operation as NFC antenna pins. Configures the protection for NFC operation
	UICR_NFCPINS_PROTECT_NFC = 0x1

	// OTP: Description collection: One time programmable memory
	// Position of LOWER field.
	UICR_OTP_LOWER_Pos = 0x0
	// Bit mask of LOWER field.
	UICR_OTP_LOWER_Msk = 0xffff
	// Position of UPPER field.
	UICR_OTP_UPPER_Pos = 0x10
	// Bit mask of UPPER field.
	UICR_OTP_UPPER_Msk = 0xffff0000
)

// Constants for CTI_S: Cross-Trigger Interface control. NOTE: this is not a separate peripheral, but describes CM33 functionality.
const (
	// CTICONTROL: CTI Control register
	// Position of GLBEN field.
	CTI_CTICONTROL_GLBEN_Pos = 0x0
	// Bit mask of GLBEN field.
	CTI_CTICONTROL_GLBEN_Msk = 0x1
	// Bit GLBEN.
	CTI_CTICONTROL_GLBEN = 0x1
	// All cross-triggering mapping logic functionality is disabled.
	CTI_CTICONTROL_GLBEN_Disabled = 0x0
	// Cross-triggering mapping logic functionality is enabled.
	CTI_CTICONTROL_GLBEN_Enabled = 0x1

	// CTIINTACK: CTI Interrupt Acknowledge register
	// Position of DEBUGREQ field.
	CTI_CTIINTACK_DEBUGREQ_Pos = 0x0
	// Bit mask of DEBUGREQ field.
	CTI_CTIINTACK_DEBUGREQ_Msk = 0x1
	// Bit DEBUGREQ.
	CTI_CTIINTACK_DEBUGREQ = 0x1
	// Clears the ctitrigout.
	CTI_CTIINTACK_DEBUGREQ_Acknowledge = 0x1
	// Position of CPURESTART field.
	CTI_CTIINTACK_CPURESTART_Pos = 0x1
	// Bit mask of CPURESTART field.
	CTI_CTIINTACK_CPURESTART_Msk = 0x2
	// Bit CPURESTART.
	CTI_CTIINTACK_CPURESTART = 0x2
	// Clears the ctitrigout.
	CTI_CTIINTACK_CPURESTART_Acknowledge = 0x1
	// Position of UNUSED0 field.
	CTI_CTIINTACK_UNUSED0_Pos = 0x2
	// Bit mask of UNUSED0 field.
	CTI_CTIINTACK_UNUSED0_Msk = 0x4
	// Bit UNUSED0.
	CTI_CTIINTACK_UNUSED0 = 0x4
	// Clears the ctitrigout.
	CTI_CTIINTACK_UNUSED0_Acknowledge = 0x1
	// Position of UNUSED1 field.
	CTI_CTIINTACK_UNUSED1_Pos = 0x3
	// Bit mask of UNUSED1 field.
	CTI_CTIINTACK_UNUSED1_Msk = 0x8
	// Bit UNUSED1.
	CTI_CTIINTACK_UNUSED1 = 0x8
	// Clears the ctitrigout.
	CTI_CTIINTACK_UNUSED1_Acknowledge = 0x1
	// Position of ETMEVTIN0 field.
	CTI_CTIINTACK_ETMEVTIN0_Pos = 0x4
	// Bit mask of ETMEVTIN0 field.
	CTI_CTIINTACK_ETMEVTIN0_Msk = 0x10
	// Bit ETMEVTIN0.
	CTI_CTIINTACK_ETMEVTIN0 = 0x10
	// Clears the ctitrigout.
	CTI_CTIINTACK_ETMEVTIN0_Acknowledge = 0x1
	// Position of ETMEVTIN1 field.
	CTI_CTIINTACK_ETMEVTIN1_Pos = 0x5
	// Bit mask of ETMEVTIN1 field.
	CTI_CTIINTACK_ETMEVTIN1_Msk = 0x20
	// Bit ETMEVTIN1.
	CTI_CTIINTACK_ETMEVTIN1 = 0x20
	// Clears the ctitrigout.
	CTI_CTIINTACK_ETMEVTIN1_Acknowledge = 0x1
	// Position of ETMEVTIN2 field.
	CTI_CTIINTACK_ETMEVTIN2_Pos = 0x6
	// Bit mask of ETMEVTIN2 field.
	CTI_CTIINTACK_ETMEVTIN2_Msk = 0x40
	// Bit ETMEVTIN2.
	CTI_CTIINTACK_ETMEVTIN2 = 0x40
	// Clears the ctitrigout.
	CTI_CTIINTACK_ETMEVTIN2_Acknowledge = 0x1
	// Position of ETMEVTIN3 field.
	CTI_CTIINTACK_ETMEVTIN3_Pos = 0x7
	// Bit mask of ETMEVTIN3 field.
	CTI_CTIINTACK_ETMEVTIN3_Msk = 0x80
	// Bit ETMEVTIN3.
	CTI_CTIINTACK_ETMEVTIN3 = 0x80
	// Clears the ctitrigout.
	CTI_CTIINTACK_ETMEVTIN3_Acknowledge = 0x1

	// CTIAPPSET: CTI Application Trigger Set register
	// Position of APPSET_0 field.
	CTI_CTIAPPSET_APPSET_0_Pos = 0x0
	// Bit mask of APPSET_0 field.
	CTI_CTIAPPSET_APPSET_0_Msk = 0x1
	// Bit APPSET_0.
	CTI_CTIAPPSET_APPSET_0 = 0x1
	// Application trigger 0 is inactive.
	CTI_CTIAPPSET_APPSET_0_Inactive = 0x0
	// Application trigger 0 is active.
	CTI_CTIAPPSET_APPSET_0_Active = 0x1
	// Generate channel event for channel 0.
	CTI_CTIAPPSET_APPSET_0_Activate = 0x1
	// Position of APPSET_1 field.
	CTI_CTIAPPSET_APPSET_1_Pos = 0x1
	// Bit mask of APPSET_1 field.
	CTI_CTIAPPSET_APPSET_1_Msk = 0x2
	// Bit APPSET_1.
	CTI_CTIAPPSET_APPSET_1 = 0x2
	// Application trigger 1 is inactive.
	CTI_CTIAPPSET_APPSET_1_Inactive = 0x0
	// Application trigger 1 is active.
	CTI_CTIAPPSET_APPSET_1_Active = 0x1
	// Generate channel event for channel 1.
	CTI_CTIAPPSET_APPSET_1_Activate = 0x1
	// Position of APPSET_2 field.
	CTI_CTIAPPSET_APPSET_2_Pos = 0x2
	// Bit mask of APPSET_2 field.
	CTI_CTIAPPSET_APPSET_2_Msk = 0x4
	// Bit APPSET_2.
	CTI_CTIAPPSET_APPSET_2 = 0x4
	// Application trigger 2 is inactive.
	CTI_CTIAPPSET_APPSET_2_Inactive = 0x0
	// Application trigger 2 is active.
	CTI_CTIAPPSET_APPSET_2_Active = 0x1
	// Generate channel event for channel 2.
	CTI_CTIAPPSET_APPSET_2_Activate = 0x1
	// Position of APPSET_3 field.
	CTI_CTIAPPSET_APPSET_3_Pos = 0x3
	// Bit mask of APPSET_3 field.
	CTI_CTIAPPSET_APPSET_3_Msk = 0x8
	// Bit APPSET_3.
	CTI_CTIAPPSET_APPSET_3 = 0x8
	// Application trigger 3 is inactive.
	CTI_CTIAPPSET_APPSET_3_Inactive = 0x0
	// Application trigger 3 is active.
	CTI_CTIAPPSET_APPSET_3_Active = 0x1
	// Generate channel event for channel 3.
	CTI_CTIAPPSET_APPSET_3_Activate = 0x1

	// CTIAPPCLEAR: CTI Application Trigger Clear register
	// Position of APPCLEAR_0 field.
	CTI_CTIAPPCLEAR_APPCLEAR_0_Pos = 0x0
	// Bit mask of APPCLEAR_0 field.
	CTI_CTIAPPCLEAR_APPCLEAR_0_Msk = 0x1
	// Bit APPCLEAR_0.
	CTI_CTIAPPCLEAR_APPCLEAR_0 = 0x1
	// Clears the event for channel 0.
	CTI_CTIAPPCLEAR_APPCLEAR_0_Clear = 0x1
	// Position of APPCLEAR_1 field.
	CTI_CTIAPPCLEAR_APPCLEAR_1_Pos = 0x1
	// Bit mask of APPCLEAR_1 field.
	CTI_CTIAPPCLEAR_APPCLEAR_1_Msk = 0x2
	// Bit APPCLEAR_1.
	CTI_CTIAPPCLEAR_APPCLEAR_1 = 0x2
	// Clears the event for channel 1.
	CTI_CTIAPPCLEAR_APPCLEAR_1_Clear = 0x1
	// Position of APPCLEAR_2 field.
	CTI_CTIAPPCLEAR_APPCLEAR_2_Pos = 0x2
	// Bit mask of APPCLEAR_2 field.
	CTI_CTIAPPCLEAR_APPCLEAR_2_Msk = 0x4
	// Bit APPCLEAR_2.
	CTI_CTIAPPCLEAR_APPCLEAR_2 = 0x4
	// Clears the event for channel 2.
	CTI_CTIAPPCLEAR_APPCLEAR_2_Clear = 0x1
	// Position of APPCLEAR_3 field.
	CTI_CTIAPPCLEAR_APPCLEAR_3_Pos = 0x3
	// Bit mask of APPCLEAR_3 field.
	CTI_CTIAPPCLEAR_APPCLEAR_3_Msk = 0x8
	// Bit APPCLEAR_3.
	CTI_CTIAPPCLEAR_APPCLEAR_3 = 0x8
	// Clears the event for channel 3.
	CTI_CTIAPPCLEAR_APPCLEAR_3_Clear = 0x1

	// CTIAPPPULSE: CTI Application Pulse register
	// Position of APPULSE_0 field.
	CTI_CTIAPPPULSE_APPULSE_0_Pos = 0x0
	// Bit mask of APPULSE_0 field.
	CTI_CTIAPPPULSE_APPULSE_0_Msk = 0x1
	// Bit APPULSE_0.
	CTI_CTIAPPPULSE_APPULSE_0 = 0x1
	// Generates an event pulse on channel 0.
	CTI_CTIAPPPULSE_APPULSE_0_Generate = 0x1
	// Position of APPULSE_1 field.
	CTI_CTIAPPPULSE_APPULSE_1_Pos = 0x1
	// Bit mask of APPULSE_1 field.
	CTI_CTIAPPPULSE_APPULSE_1_Msk = 0x2
	// Bit APPULSE_1.
	CTI_CTIAPPPULSE_APPULSE_1 = 0x2
	// Generates an event pulse on channel 1.
	CTI_CTIAPPPULSE_APPULSE_1_Generate = 0x1
	// Position of APPULSE_2 field.
	CTI_CTIAPPPULSE_APPULSE_2_Pos = 0x2
	// Bit mask of APPULSE_2 field.
	CTI_CTIAPPPULSE_APPULSE_2_Msk = 0x4
	// Bit APPULSE_2.
	CTI_CTIAPPPULSE_APPULSE_2 = 0x4
	// Generates an event pulse on channel 2.
	CTI_CTIAPPPULSE_APPULSE_2_Generate = 0x1
	// Position of APPULSE_3 field.
	CTI_CTIAPPPULSE_APPULSE_3_Pos = 0x3
	// Bit mask of APPULSE_3 field.
	CTI_CTIAPPPULSE_APPULSE_3_Msk = 0x8
	// Bit APPULSE_3.
	CTI_CTIAPPPULSE_APPULSE_3 = 0x8
	// Generates an event pulse on channel 3.
	CTI_CTIAPPPULSE_APPULSE_3_Generate = 0x1

	// CTIINEN: Description collection: CTI Trigger input
	// Position of TRIGINEN_0 field.
	CTI_CTIINEN_TRIGINEN_0_Pos = 0x0
	// Bit mask of TRIGINEN_0 field.
	CTI_CTIINEN_TRIGINEN_0_Msk = 0x1
	// Bit TRIGINEN_0.
	CTI_CTIINEN_TRIGINEN_0 = 0x1
	// Input trigger n events are ignored by channel 0.
	CTI_CTIINEN_TRIGINEN_0_Disabled = 0x0
	// When an event is received on input trigger n (ctitrigin[n]), generate an event on channel 0.
	CTI_CTIINEN_TRIGINEN_0_Enabled = 0x1
	// Position of TRIGINEN_1 field.
	CTI_CTIINEN_TRIGINEN_1_Pos = 0x1
	// Bit mask of TRIGINEN_1 field.
	CTI_CTIINEN_TRIGINEN_1_Msk = 0x2
	// Bit TRIGINEN_1.
	CTI_CTIINEN_TRIGINEN_1 = 0x2
	// Input trigger n events are ignored by channel 1.
	CTI_CTIINEN_TRIGINEN_1_Disabled = 0x0
	// When an event is received on input trigger n (ctitrigin[n]), generate an event on channel 1.
	CTI_CTIINEN_TRIGINEN_1_Enabled = 0x1
	// Position of TRIGINEN_2 field.
	CTI_CTIINEN_TRIGINEN_2_Pos = 0x2
	// Bit mask of TRIGINEN_2 field.
	CTI_CTIINEN_TRIGINEN_2_Msk = 0x4
	// Bit TRIGINEN_2.
	CTI_CTIINEN_TRIGINEN_2 = 0x4
	// Input trigger n events are ignored by channel 2.
	CTI_CTIINEN_TRIGINEN_2_Disabled = 0x0
	// When an event is received on input trigger n (ctitrigin[n]), generate an event on channel 2.
	CTI_CTIINEN_TRIGINEN_2_Enabled = 0x1
	// Position of TRIGINEN_3 field.
	CTI_CTIINEN_TRIGINEN_3_Pos = 0x3
	// Bit mask of TRIGINEN_3 field.
	CTI_CTIINEN_TRIGINEN_3_Msk = 0x8
	// Bit TRIGINEN_3.
	CTI_CTIINEN_TRIGINEN_3 = 0x8
	// Input trigger n events are ignored by channel 3.
	CTI_CTIINEN_TRIGINEN_3_Disabled = 0x0
	// When an event is received on input trigger n (ctitrigin[n]), generate an event on channel 3.
	CTI_CTIINEN_TRIGINEN_3_Enabled = 0x1

	// CTIOUTEN: Description collection: CTI Trigger output
	// Position of TRIGOUTEN_0 field.
	CTI_CTIOUTEN_TRIGOUTEN_0_Pos = 0x0
	// Bit mask of TRIGOUTEN_0 field.
	CTI_CTIOUTEN_TRIGOUTEN_0_Msk = 0x1
	// Bit TRIGOUTEN_0.
	CTI_CTIOUTEN_TRIGOUTEN_0 = 0x1
	// Channel 0 is ignored by output trigger n.
	CTI_CTIOUTEN_TRIGOUTEN_0_Disabled = 0x0
	// When an event occurs on channel 0, generate an event on output event n (ctitrigout[n]).
	CTI_CTIOUTEN_TRIGOUTEN_0_Enabled = 0x1
	// Position of TRIGOUTEN_1 field.
	CTI_CTIOUTEN_TRIGOUTEN_1_Pos = 0x1
	// Bit mask of TRIGOUTEN_1 field.
	CTI_CTIOUTEN_TRIGOUTEN_1_Msk = 0x2
	// Bit TRIGOUTEN_1.
	CTI_CTIOUTEN_TRIGOUTEN_1 = 0x2
	// Channel 1 is ignored by output trigger n.
	CTI_CTIOUTEN_TRIGOUTEN_1_Disabled = 0x0
	// When an event occurs on channel 1, generate an event on output event n (ctitrigout[n]).
	CTI_CTIOUTEN_TRIGOUTEN_1_Enabled = 0x1
	// Position of TRIGOUTEN_2 field.
	CTI_CTIOUTEN_TRIGOUTEN_2_Pos = 0x2
	// Bit mask of TRIGOUTEN_2 field.
	CTI_CTIOUTEN_TRIGOUTEN_2_Msk = 0x4
	// Bit TRIGOUTEN_2.
	CTI_CTIOUTEN_TRIGOUTEN_2 = 0x4
	// Channel 2 is ignored by output trigger n.
	CTI_CTIOUTEN_TRIGOUTEN_2_Disabled = 0x0
	// When an event occurs on channel 2, generate an event on output event n (ctitrigout[n]).
	CTI_CTIOUTEN_TRIGOUTEN_2_Enabled = 0x1
	// Position of TRIGOUTEN_3 field.
	CTI_CTIOUTEN_TRIGOUTEN_3_Pos = 0x3
	// Bit mask of TRIGOUTEN_3 field.
	CTI_CTIOUTEN_TRIGOUTEN_3_Msk = 0x8
	// Bit TRIGOUTEN_3.
	CTI_CTIOUTEN_TRIGOUTEN_3 = 0x8
	// Channel 3 is ignored by output trigger n.
	CTI_CTIOUTEN_TRIGOUTEN_3_Disabled = 0x0
	// When an event occurs on channel 3, generate an event on output event n (ctitrigout[n]).
	CTI_CTIOUTEN_TRIGOUTEN_3_Enabled = 0x1

	// CTITRIGINSTATUS: CTI Trigger In Status register
	// Position of CPUHALTED field.
	CTI_CTITRIGINSTATUS_CPUHALTED_Pos = 0x0
	// Bit mask of CPUHALTED field.
	CTI_CTITRIGINSTATUS_CPUHALTED_Msk = 0x1
	// Bit CPUHALTED.
	CTI_CTITRIGINSTATUS_CPUHALTED = 0x1
	// Ctitrigin 0 is active.
	CTI_CTITRIGINSTATUS_CPUHALTED_Active = 0x1
	// Ctitrigin 0 is inactive.
	CTI_CTITRIGINSTATUS_CPUHALTED_Inactive = 0x0
	// Position of DWTCOMPOUT0 field.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT0_Pos = 0x1
	// Bit mask of DWTCOMPOUT0 field.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT0_Msk = 0x2
	// Bit DWTCOMPOUT0.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT0 = 0x2
	// Ctitrigin 1 is active.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT0_Active = 0x1
	// Ctitrigin 1 is inactive.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT0_Inactive = 0x0
	// Position of DWTCOMPOUT1 field.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT1_Pos = 0x2
	// Bit mask of DWTCOMPOUT1 field.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT1_Msk = 0x4
	// Bit DWTCOMPOUT1.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT1 = 0x4
	// Ctitrigin 2 is active.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT1_Active = 0x1
	// Ctitrigin 2 is inactive.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT1_Inactive = 0x0
	// Position of DWTCOMPOUT2 field.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT2_Pos = 0x3
	// Bit mask of DWTCOMPOUT2 field.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT2_Msk = 0x8
	// Bit DWTCOMPOUT2.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT2 = 0x8
	// Ctitrigin 3 is active.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT2_Active = 0x1
	// Ctitrigin 3 is inactive.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT2_Inactive = 0x0
	// Position of ETMEVTOUT0 field.
	CTI_CTITRIGINSTATUS_ETMEVTOUT0_Pos = 0x4
	// Bit mask of ETMEVTOUT0 field.
	CTI_CTITRIGINSTATUS_ETMEVTOUT0_Msk = 0x10
	// Bit ETMEVTOUT0.
	CTI_CTITRIGINSTATUS_ETMEVTOUT0 = 0x10
	// Ctitrigin 4 is active.
	CTI_CTITRIGINSTATUS_ETMEVTOUT0_Active = 0x1
	// Ctitrigin 4 is inactive.
	CTI_CTITRIGINSTATUS_ETMEVTOUT0_Inactive = 0x0
	// Position of ETMEVTOUT1 field.
	CTI_CTITRIGINSTATUS_ETMEVTOUT1_Pos = 0x5
	// Bit mask of ETMEVTOUT1 field.
	CTI_CTITRIGINSTATUS_ETMEVTOUT1_Msk = 0x20
	// Bit ETMEVTOUT1.
	CTI_CTITRIGINSTATUS_ETMEVTOUT1 = 0x20
	// Ctitrigin 5 is active.
	CTI_CTITRIGINSTATUS_ETMEVTOUT1_Active = 0x1
	// Ctitrigin 5 is inactive.
	CTI_CTITRIGINSTATUS_ETMEVTOUT1_Inactive = 0x0
	// Position of UNUSED0 field.
	CTI_CTITRIGINSTATUS_UNUSED0_Pos = 0x6
	// Bit mask of UNUSED0 field.
	CTI_CTITRIGINSTATUS_UNUSED0_Msk = 0x40
	// Bit UNUSED0.
	CTI_CTITRIGINSTATUS_UNUSED0 = 0x40
	// Ctitrigin 6 is active.
	CTI_CTITRIGINSTATUS_UNUSED0_Active = 0x1
	// Ctitrigin 6 is inactive.
	CTI_CTITRIGINSTATUS_UNUSED0_Inactive = 0x0
	// Position of UNUSED1 field.
	CTI_CTITRIGINSTATUS_UNUSED1_Pos = 0x7
	// Bit mask of UNUSED1 field.
	CTI_CTITRIGINSTATUS_UNUSED1_Msk = 0x80
	// Bit UNUSED1.
	CTI_CTITRIGINSTATUS_UNUSED1 = 0x80
	// Ctitrigin 7 is active.
	CTI_CTITRIGINSTATUS_UNUSED1_Active = 0x1
	// Ctitrigin 7 is inactive.
	CTI_CTITRIGINSTATUS_UNUSED1_Inactive = 0x0

	// CTITRIGOUTSTATUS: CTI Trigger Out Status register
	// Position of DEBUGREQ field.
	CTI_CTITRIGOUTSTATUS_DEBUGREQ_Pos = 0x0
	// Bit mask of DEBUGREQ field.
	CTI_CTITRIGOUTSTATUS_DEBUGREQ_Msk = 0x1
	// Bit DEBUGREQ.
	CTI_CTITRIGOUTSTATUS_DEBUGREQ = 0x1
	// Ctitrigout 0 is active.
	CTI_CTITRIGOUTSTATUS_DEBUGREQ_Active = 0x1
	// Ctitrigout 0 is inactive.
	CTI_CTITRIGOUTSTATUS_DEBUGREQ_Inactive = 0x0
	// Position of CPURESTART field.
	CTI_CTITRIGOUTSTATUS_CPURESTART_Pos = 0x1
	// Bit mask of CPURESTART field.
	CTI_CTITRIGOUTSTATUS_CPURESTART_Msk = 0x2
	// Bit CPURESTART.
	CTI_CTITRIGOUTSTATUS_CPURESTART = 0x2
	// Ctitrigout 1 is active.
	CTI_CTITRIGOUTSTATUS_CPURESTART_Active = 0x1
	// Ctitrigout 1 is inactive.
	CTI_CTITRIGOUTSTATUS_CPURESTART_Inactive = 0x0
	// Position of UNUSED0 field.
	CTI_CTITRIGOUTSTATUS_UNUSED0_Pos = 0x2
	// Bit mask of UNUSED0 field.
	CTI_CTITRIGOUTSTATUS_UNUSED0_Msk = 0x4
	// Bit UNUSED0.
	CTI_CTITRIGOUTSTATUS_UNUSED0 = 0x4
	// Ctitrigout 2 is active.
	CTI_CTITRIGOUTSTATUS_UNUSED0_Active = 0x1
	// Ctitrigout 2 is inactive.
	CTI_CTITRIGOUTSTATUS_UNUSED0_Inactive = 0x0
	// Position of UNUSED1 field.
	CTI_CTITRIGOUTSTATUS_UNUSED1_Pos = 0x3
	// Bit mask of UNUSED1 field.
	CTI_CTITRIGOUTSTATUS_UNUSED1_Msk = 0x8
	// Bit UNUSED1.
	CTI_CTITRIGOUTSTATUS_UNUSED1 = 0x8
	// Ctitrigout 3 is active.
	CTI_CTITRIGOUTSTATUS_UNUSED1_Active = 0x1
	// Ctitrigout 3 is inactive.
	CTI_CTITRIGOUTSTATUS_UNUSED1_Inactive = 0x0
	// Position of ETMEVTIN0 field.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN0_Pos = 0x4
	// Bit mask of ETMEVTIN0 field.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN0_Msk = 0x10
	// Bit ETMEVTIN0.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN0 = 0x10
	// Ctitrigout 4 is active.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN0_Active = 0x1
	// Ctitrigout 4 is inactive.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN0_Inactive = 0x0
	// Position of ETMEVTIN1 field.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN1_Pos = 0x5
	// Bit mask of ETMEVTIN1 field.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN1_Msk = 0x20
	// Bit ETMEVTIN1.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN1 = 0x20
	// Ctitrigout 5 is active.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN1_Active = 0x1
	// Ctitrigout 5 is inactive.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN1_Inactive = 0x0
	// Position of ETMEVTIN2 field.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN2_Pos = 0x6
	// Bit mask of ETMEVTIN2 field.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN2_Msk = 0x40
	// Bit ETMEVTIN2.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN2 = 0x40
	// Ctitrigout 6 is active.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN2_Active = 0x1
	// Ctitrigout 6 is inactive.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN2_Inactive = 0x0
	// Position of ETMEVTIN3 field.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN3_Pos = 0x7
	// Bit mask of ETMEVTIN3 field.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN3_Msk = 0x80
	// Bit ETMEVTIN3.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN3 = 0x80
	// Ctitrigout 7 is active.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN3_Active = 0x1
	// Ctitrigout 7 is inactive.
	CTI_CTITRIGOUTSTATUS_ETMEVTIN3_Inactive = 0x0

	// CTICHINSTATUS: CTI Channel In Status register
	// Position of CTICHINSTATUS_0 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_0_Pos = 0x0
	// Bit mask of CTICHINSTATUS_0 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_0_Msk = 0x1
	// Bit CTICHINSTATUS_0.
	CTI_CTICHINSTATUS_CTICHINSTATUS_0 = 0x1
	// Ctichin 0 is active.
	CTI_CTICHINSTATUS_CTICHINSTATUS_0_Active = 0x1
	// Ctichin 0 is inactive.
	CTI_CTICHINSTATUS_CTICHINSTATUS_0_Inactive = 0x0
	// Position of CTICHINSTATUS_1 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_1_Pos = 0x1
	// Bit mask of CTICHINSTATUS_1 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_1_Msk = 0x2
	// Bit CTICHINSTATUS_1.
	CTI_CTICHINSTATUS_CTICHINSTATUS_1 = 0x2
	// Ctichin 1 is active.
	CTI_CTICHINSTATUS_CTICHINSTATUS_1_Active = 0x1
	// Ctichin 1 is inactive.
	CTI_CTICHINSTATUS_CTICHINSTATUS_1_Inactive = 0x0
	// Position of CTICHINSTATUS_2 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_2_Pos = 0x2
	// Bit mask of CTICHINSTATUS_2 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_2_Msk = 0x4
	// Bit CTICHINSTATUS_2.
	CTI_CTICHINSTATUS_CTICHINSTATUS_2 = 0x4
	// Ctichin 2 is active.
	CTI_CTICHINSTATUS_CTICHINSTATUS_2_Active = 0x1
	// Ctichin 2 is inactive.
	CTI_CTICHINSTATUS_CTICHINSTATUS_2_Inactive = 0x0
	// Position of CTICHINSTATUS_3 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_3_Pos = 0x3
	// Bit mask of CTICHINSTATUS_3 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_3_Msk = 0x8
	// Bit CTICHINSTATUS_3.
	CTI_CTICHINSTATUS_CTICHINSTATUS_3 = 0x8
	// Ctichin 3 is active.
	CTI_CTICHINSTATUS_CTICHINSTATUS_3_Active = 0x1
	// Ctichin 3 is inactive.
	CTI_CTICHINSTATUS_CTICHINSTATUS_3_Inactive = 0x0

	// CTIGATE: Enable CTI Channel Gate register
	// Position of CTIGATEEN_0 field.
	CTI_CTIGATE_CTIGATEEN_0_Pos = 0x0
	// Bit mask of CTIGATEEN_0 field.
	CTI_CTIGATE_CTIGATEEN_0_Msk = 0x1
	// Bit CTIGATEEN_0.
	CTI_CTIGATE_CTIGATEEN_0 = 0x1
	// Enable ctichout channel 0 propagation.
	CTI_CTIGATE_CTIGATEEN_0_Enabled = 0x1
	// Disable ctichout channel 0 propagation.
	CTI_CTIGATE_CTIGATEEN_0_Disabled = 0x0
	// Position of CTIGATEEN_1 field.
	CTI_CTIGATE_CTIGATEEN_1_Pos = 0x1
	// Bit mask of CTIGATEEN_1 field.
	CTI_CTIGATE_CTIGATEEN_1_Msk = 0x2
	// Bit CTIGATEEN_1.
	CTI_CTIGATE_CTIGATEEN_1 = 0x2
	// Enable ctichout channel 1 propagation.
	CTI_CTIGATE_CTIGATEEN_1_Enabled = 0x1
	// Disable ctichout channel 1 propagation.
	CTI_CTIGATE_CTIGATEEN_1_Disabled = 0x0
	// Position of CTIGATEEN_2 field.
	CTI_CTIGATE_CTIGATEEN_2_Pos = 0x2
	// Bit mask of CTIGATEEN_2 field.
	CTI_CTIGATE_CTIGATEEN_2_Msk = 0x4
	// Bit CTIGATEEN_2.
	CTI_CTIGATE_CTIGATEEN_2 = 0x4
	// Enable ctichout channel 2 propagation.
	CTI_CTIGATE_CTIGATEEN_2_Enabled = 0x1
	// Disable ctichout channel 2 propagation.
	CTI_CTIGATE_CTIGATEEN_2_Disabled = 0x0
	// Position of CTIGATEEN_3 field.
	CTI_CTIGATE_CTIGATEEN_3_Pos = 0x3
	// Bit mask of CTIGATEEN_3 field.
	CTI_CTIGATE_CTIGATEEN_3_Msk = 0x8
	// Bit CTIGATEEN_3.
	CTI_CTIGATE_CTIGATEEN_3 = 0x8
	// Enable ctichout channel 3 propagation.
	CTI_CTIGATE_CTIGATEEN_3_Enabled = 0x1
	// Disable ctichout channel 3 propagation.
	CTI_CTIGATE_CTIGATEEN_3_Disabled = 0x0

	// DEVARCH: Device Architecture register
	// Position of Architecture field.
	CTI_DEVARCH_Architecture_Pos = 0x0
	// Bit mask of Architecture field.
	CTI_DEVARCH_Architecture_Msk = 0x1
	// Bit Architecture.
	CTI_DEVARCH_Architecture = 0x1

	// DEVID: Device Configuration register
	// Position of EXTMUXNUM field.
	CTI_DEVID_EXTMUXNUM_Pos = 0x0
	// Bit mask of EXTMUXNUM field.
	CTI_DEVID_EXTMUXNUM_Msk = 0x1f
	// Position of NUMTRIG field.
	CTI_DEVID_NUMTRIG_Pos = 0x8
	// Bit mask of NUMTRIG field.
	CTI_DEVID_NUMTRIG_Msk = 0xff00
	// Position of NUMCH field.
	CTI_DEVID_NUMCH_Pos = 0x10
	// Bit mask of NUMCH field.
	CTI_DEVID_NUMCH_Msk = 0xf0000

	// DEVTYPE: Device Type Identifier register
	// Position of MAJOR field.
	CTI_DEVTYPE_MAJOR_Pos = 0x0
	// Bit mask of MAJOR field.
	CTI_DEVTYPE_MAJOR_Msk = 0xf
	// Indicates that this component allows a debugger to control other components in a CoreSight SoC-400 system.
	CTI_DEVTYPE_MAJOR_Controller = 0x4
	// Position of SUB field.
	CTI_DEVTYPE_SUB_Pos = 0x4
	// Bit mask of SUB field.
	CTI_DEVTYPE_SUB_Msk = 0xf0
	// Indicates that this component is a sub-triggering component.
	CTI_DEVTYPE_SUB_Crosstrigger = 0x1

	// PIDR4: Peripheral ID4 Register
	// Position of DES_2 field.
	CTI_PIDR4_DES_2_Pos = 0x0
	// Bit mask of DES_2 field.
	CTI_PIDR4_DES_2_Msk = 0xf
	// JEDEC continuation code
	CTI_PIDR4_DES_2_Code = 0x4
	// Position of SIZE field.
	CTI_PIDR4_SIZE_Pos = 0x4
	// Bit mask of SIZE field.
	CTI_PIDR4_SIZE_Msk = 0xf0

	// PIDR0: Peripheral ID0 Register
	// Position of PART_0 field.
	CTI_PIDR0_PART_0_Pos = 0x0
	// Bit mask of PART_0 field.
	CTI_PIDR0_PART_0_Msk = 0xff
	// Indicates bits[7:0] of the part number of the component.
	CTI_PIDR0_PART_0_PartnumberL = 0x21

	// PIDR1: Peripheral ID1 Register
	// Position of PART_1 field.
	CTI_PIDR1_PART_1_Pos = 0x0
	// Bit mask of PART_1 field.
	CTI_PIDR1_PART_1_Msk = 0xf
	// Indicates bits[11:8] of the part number of the component.
	CTI_PIDR1_PART_1_PartnumberH = 0xd
	// Position of DES_0 field.
	CTI_PIDR1_DES_0_Pos = 0x4
	// Bit mask of DES_0 field.
	CTI_PIDR1_DES_0_Msk = 0xf0
	// ARM. Bits[3:0] of the JEDEC JEP106 Identity Code
	CTI_PIDR1_DES_0_Arm = 0xb

	// PIDR2: Peripheral ID2 Register
	// Position of DES_1 field.
	CTI_PIDR2_DES_1_Pos = 0x0
	// Bit mask of DES_1 field.
	CTI_PIDR2_DES_1_Msk = 0x7
	// ARM. Bits[6:4] of the JEDEC JEP106 Identity Code
	CTI_PIDR2_DES_1_Arm = 0x3
	// Position of JEDEC field.
	CTI_PIDR2_JEDEC_Pos = 0x3
	// Bit mask of JEDEC field.
	CTI_PIDR2_JEDEC_Msk = 0x8
	// Bit JEDEC.
	CTI_PIDR2_JEDEC = 0x8
	// Position of REVISION field.
	CTI_PIDR2_REVISION_Pos = 0x4
	// Bit mask of REVISION field.
	CTI_PIDR2_REVISION_Msk = 0xf0
	// This device is at r0p0
	CTI_PIDR2_REVISION_Rev0p0 = 0x0

	// PIDR3: Peripheral ID3 Register
	// Position of CMOD field.
	CTI_PIDR3_CMOD_Pos = 0x0
	// Bit mask of CMOD field.
	CTI_PIDR3_CMOD_Msk = 0xf
	// Indicates that the customer has not modified this component.
	CTI_PIDR3_CMOD_Unmodified = 0x0
	// Position of REVAND field.
	CTI_PIDR3_REVAND_Pos = 0x4
	// Bit mask of REVAND field.
	CTI_PIDR3_REVAND_Msk = 0xf0
	// Indicates that there are no errata fixes to this component.
	CTI_PIDR3_REVAND_NoErrata = 0x0

	// CIDR0: Component ID0 Register
	// Position of PRMBL_0 field.
	CTI_CIDR0_PRMBL_0_Pos = 0x0
	// Bit mask of PRMBL_0 field.
	CTI_CIDR0_PRMBL_0_Msk = 0xff
	// Bits[7:0] of the identification code.
	CTI_CIDR0_PRMBL_0_Value = 0xd

	// CIDR1: Component ID1 Register
	// Position of PRMBL_1 field.
	CTI_CIDR1_PRMBL_1_Pos = 0x0
	// Bit mask of PRMBL_1 field.
	CTI_CIDR1_PRMBL_1_Msk = 0xf
	// Bits[11:8] of the identification code.
	CTI_CIDR1_PRMBL_1_Value = 0x0
	// Position of CLASS field.
	CTI_CIDR1_CLASS_Pos = 0x4
	// Bit mask of CLASS field.
	CTI_CIDR1_CLASS_Msk = 0xf0
	// Indicates that the component is a CoreSight component.
	CTI_CIDR1_CLASS_Coresight = 0x9

	// CIDR2: Component ID2 Register
	// Position of PRMBL_2 field.
	CTI_CIDR2_PRMBL_2_Pos = 0x0
	// Bit mask of PRMBL_2 field.
	CTI_CIDR2_PRMBL_2_Msk = 0xff
	// Bits[23:16] of the identification code.
	CTI_CIDR2_PRMBL_2_Value = 0x5

	// CIDR3: Component ID3 Register
	// Position of PRMBL_3 field.
	CTI_CIDR3_PRMBL_3_Pos = 0x0
	// Bit mask of PRMBL_3 field.
	CTI_CIDR3_PRMBL_3_Msk = 0xff
	// Bits[31:24] of the identification code.
	CTI_CIDR3_PRMBL_3_Value = 0xb1
)

// Constants for TAD_S: Trace and debug control
const (
	// CLOCKSTART: Start all trace and debug clocks.
	// Position of START field.
	TAD_CLOCKSTART_START_Pos = 0x0
	// Bit mask of START field.
	TAD_CLOCKSTART_START_Msk = 0x1
	// Bit START.
	TAD_CLOCKSTART_START = 0x1
	// Start all trace and debug clocks.
	TAD_CLOCKSTART_START_Start = 0x1

	// CLOCKSTOP: Stop all trace and debug clocks.
	// Position of STOP field.
	TAD_CLOCKSTOP_STOP_Pos = 0x0
	// Bit mask of STOP field.
	TAD_CLOCKSTOP_STOP_Msk = 0x1
	// Bit STOP.
	TAD_CLOCKSTOP_STOP = 0x1
	// Stop all trace and debug clocks.
	TAD_CLOCKSTOP_STOP_Stop = 0x1

	// ENABLE: Enable debug domain and aquire selected GPIOs
	// Position of ENABLE field.
	TAD_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	TAD_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	TAD_ENABLE_ENABLE = 0x1
	// Disable debug domain and release selected GPIOs
	TAD_ENABLE_ENABLE_DISABLED = 0x0
	// Enable debug domain and aquire selected GPIOs
	TAD_ENABLE_ENABLE_ENABLED = 0x1

	// PSEL.TRACECLK: Pin configuration for TRACECLK
	// Position of PIN field.
	TAD_PSEL_TRACECLK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TAD_PSEL_TRACECLK_PIN_Msk = 0x1f
	// TRACECLK pin
	TAD_PSEL_TRACECLK_PIN_Traceclk = 0xc
	// Position of CONNECT field.
	TAD_PSEL_TRACECLK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TAD_PSEL_TRACECLK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TAD_PSEL_TRACECLK_CONNECT = 0x80000000
	// Disconnect
	TAD_PSEL_TRACECLK_CONNECT_Disconnected = 0x1
	// Connect
	TAD_PSEL_TRACECLK_CONNECT_Connected = 0x0

	// PSEL.TRACEDATA0: Pin configuration for TRACEDATA[0] and SWO
	// Position of PIN field.
	TAD_PSEL_TRACEDATA0_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TAD_PSEL_TRACEDATA0_PIN_Msk = 0x1f
	// TRACEDATA0/SWO pin
	TAD_PSEL_TRACEDATA0_PIN_Tracedata0 = 0xb
	// Position of CONNECT field.
	TAD_PSEL_TRACEDATA0_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TAD_PSEL_TRACEDATA0_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TAD_PSEL_TRACEDATA0_CONNECT = 0x80000000
	// Disconnect
	TAD_PSEL_TRACEDATA0_CONNECT_Disconnected = 0x1
	// Connect
	TAD_PSEL_TRACEDATA0_CONNECT_Connected = 0x0

	// PSEL.TRACEDATA1: Pin configuration for TRACEDATA[1]
	// Position of PIN field.
	TAD_PSEL_TRACEDATA1_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TAD_PSEL_TRACEDATA1_PIN_Msk = 0x1f
	// TRACEDATA1 pin
	TAD_PSEL_TRACEDATA1_PIN_Tracedata1 = 0xa
	// Position of CONNECT field.
	TAD_PSEL_TRACEDATA1_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TAD_PSEL_TRACEDATA1_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TAD_PSEL_TRACEDATA1_CONNECT = 0x80000000
	// Disconnect
	TAD_PSEL_TRACEDATA1_CONNECT_Disconnected = 0x1
	// Connect
	TAD_PSEL_TRACEDATA1_CONNECT_Connected = 0x0

	// PSEL.TRACEDATA2: Pin configuration for TRACEDATA[2]
	// Position of PIN field.
	TAD_PSEL_TRACEDATA2_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TAD_PSEL_TRACEDATA2_PIN_Msk = 0x1f
	// TRACEDATA2 pin
	TAD_PSEL_TRACEDATA2_PIN_Tracedata2 = 0x9
	// Position of CONNECT field.
	TAD_PSEL_TRACEDATA2_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TAD_PSEL_TRACEDATA2_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TAD_PSEL_TRACEDATA2_CONNECT = 0x80000000
	// Disconnect
	TAD_PSEL_TRACEDATA2_CONNECT_Disconnected = 0x1
	// Connect
	TAD_PSEL_TRACEDATA2_CONNECT_Connected = 0x0

	// PSEL.TRACEDATA3: Pin configuration for TRACEDATA[3]
	// Position of PIN field.
	TAD_PSEL_TRACEDATA3_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TAD_PSEL_TRACEDATA3_PIN_Msk = 0x1f
	// TRACEDATA3 pin
	TAD_PSEL_TRACEDATA3_PIN_Tracedata3 = 0x8
	// Position of CONNECT field.
	TAD_PSEL_TRACEDATA3_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TAD_PSEL_TRACEDATA3_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TAD_PSEL_TRACEDATA3_CONNECT = 0x80000000
	// Disconnect
	TAD_PSEL_TRACEDATA3_CONNECT_Disconnected = 0x1
	// Connect
	TAD_PSEL_TRACEDATA3_CONNECT_Connected = 0x0

	// TRACEPORTSPEED: Clocking options for the Trace Port debug interface.
	// Position of TRACEPORTSPEED field.
	TAD_TRACEPORTSPEED_TRACEPORTSPEED_Pos = 0x0
	// Bit mask of TRACEPORTSPEED field.
	TAD_TRACEPORTSPEED_TRACEPORTSPEED_Msk = 0x3
	// Trace Port clock is: 64MHz
	TAD_TRACEPORTSPEED_TRACEPORTSPEED_64MHz = 0x0
	// Trace Port clock is: 32MHz
	TAD_TRACEPORTSPEED_TRACEPORTSPEED_32MHz = 0x1
	// Trace Port clock is: 8MHz
	TAD_TRACEPORTSPEED_TRACEPORTSPEED_8MHz = 0x2
	// Trace Port clock is: 4MHz
	TAD_TRACEPORTSPEED_TRACEPORTSPEED_4MHz = 0x3
)

// Constants for DCNF_NS: Domain configuration management 0
const (
	// CPUID: CPU ID of this subsystem
	// Position of CPUID field.
	DCNF_CPUID_CPUID_Pos = 0x0
	// Bit mask of CPUID field.
	DCNF_CPUID_CPUID_Msk = 0xff

	// EXTPERI.PROTECT: Description cluster: Control access for master connected to AMLI master port EXTPERI[n]
	// Position of SLAVE0 field.
	DCNF_EXTPERI_PROTECT_SLAVE0_Pos = 0x0
	// Bit mask of SLAVE0 field.
	DCNF_EXTPERI_PROTECT_SLAVE0_Msk = 0x1
	// Bit SLAVE0.
	DCNF_EXTPERI_PROTECT_SLAVE0 = 0x1
	// Access to slave is allowed
	DCNF_EXTPERI_PROTECT_SLAVE0_Allowed = 0x0
	// Access to slave is blocked
	DCNF_EXTPERI_PROTECT_SLAVE0_Blocked = 0x1

	// EXTRAM.PROTECT: Description cluster: Control access from master connected to AMLI master port EXTRAM[n]
	// Position of SLAVE0 field.
	DCNF_EXTRAM_PROTECT_SLAVE0_Pos = 0x0
	// Bit mask of SLAVE0 field.
	DCNF_EXTRAM_PROTECT_SLAVE0_Msk = 0x1
	// Bit SLAVE0.
	DCNF_EXTRAM_PROTECT_SLAVE0 = 0x1
	// Access to slave is allowed
	DCNF_EXTRAM_PROTECT_SLAVE0_Allowed = 0x0
	// Access to slave is blocked
	DCNF_EXTRAM_PROTECT_SLAVE0_Blocked = 0x1
	// Position of SLAVE1 field.
	DCNF_EXTRAM_PROTECT_SLAVE1_Pos = 0x1
	// Bit mask of SLAVE1 field.
	DCNF_EXTRAM_PROTECT_SLAVE1_Msk = 0x2
	// Bit SLAVE1.
	DCNF_EXTRAM_PROTECT_SLAVE1 = 0x2
	// Access to slave is allowed
	DCNF_EXTRAM_PROTECT_SLAVE1_Allowed = 0x0
	// Access to slave is blocked
	DCNF_EXTRAM_PROTECT_SLAVE1_Blocked = 0x1
	// Position of SLAVE2 field.
	DCNF_EXTRAM_PROTECT_SLAVE2_Pos = 0x2
	// Bit mask of SLAVE2 field.
	DCNF_EXTRAM_PROTECT_SLAVE2_Msk = 0x4
	// Bit SLAVE2.
	DCNF_EXTRAM_PROTECT_SLAVE2 = 0x4
	// Access to slave is allowed
	DCNF_EXTRAM_PROTECT_SLAVE2_Allowed = 0x0
	// Access to slave is blocked
	DCNF_EXTRAM_PROTECT_SLAVE2_Blocked = 0x1
	// Position of SLAVE3 field.
	DCNF_EXTRAM_PROTECT_SLAVE3_Pos = 0x3
	// Bit mask of SLAVE3 field.
	DCNF_EXTRAM_PROTECT_SLAVE3_Msk = 0x8
	// Bit SLAVE3.
	DCNF_EXTRAM_PROTECT_SLAVE3 = 0x8
	// Access to slave is allowed
	DCNF_EXTRAM_PROTECT_SLAVE3_Allowed = 0x0
	// Access to slave is blocked
	DCNF_EXTRAM_PROTECT_SLAVE3_Blocked = 0x1
	// Position of SLAVE4 field.
	DCNF_EXTRAM_PROTECT_SLAVE4_Pos = 0x4
	// Bit mask of SLAVE4 field.
	DCNF_EXTRAM_PROTECT_SLAVE4_Msk = 0x10
	// Bit SLAVE4.
	DCNF_EXTRAM_PROTECT_SLAVE4 = 0x10
	// Access to slave is allowed
	DCNF_EXTRAM_PROTECT_SLAVE4_Allowed = 0x0
	// Access to slave is blocked
	DCNF_EXTRAM_PROTECT_SLAVE4_Blocked = 0x1
	// Position of SLAVE5 field.
	DCNF_EXTRAM_PROTECT_SLAVE5_Pos = 0x5
	// Bit mask of SLAVE5 field.
	DCNF_EXTRAM_PROTECT_SLAVE5_Msk = 0x20
	// Bit SLAVE5.
	DCNF_EXTRAM_PROTECT_SLAVE5 = 0x20
	// Access to slave is allowed
	DCNF_EXTRAM_PROTECT_SLAVE5_Allowed = 0x0
	// Access to slave is blocked
	DCNF_EXTRAM_PROTECT_SLAVE5_Blocked = 0x1
	// Position of SLAVE6 field.
	DCNF_EXTRAM_PROTECT_SLAVE6_Pos = 0x6
	// Bit mask of SLAVE6 field.
	DCNF_EXTRAM_PROTECT_SLAVE6_Msk = 0x40
	// Bit SLAVE6.
	DCNF_EXTRAM_PROTECT_SLAVE6 = 0x40
	// Access to slave is allowed
	DCNF_EXTRAM_PROTECT_SLAVE6_Allowed = 0x0
	// Access to slave is blocked
	DCNF_EXTRAM_PROTECT_SLAVE6_Blocked = 0x1
	// Position of SLAVE7 field.
	DCNF_EXTRAM_PROTECT_SLAVE7_Pos = 0x7
	// Bit mask of SLAVE7 field.
	DCNF_EXTRAM_PROTECT_SLAVE7_Msk = 0x80
	// Bit SLAVE7.
	DCNF_EXTRAM_PROTECT_SLAVE7 = 0x80
	// Access to slave is allowed
	DCNF_EXTRAM_PROTECT_SLAVE7_Allowed = 0x0
	// Access to slave is blocked
	DCNF_EXTRAM_PROTECT_SLAVE7_Blocked = 0x1

	// EXTCODE.PROTECT: Description cluster: Control access from master connected to AMLI master port EXTCODE[n]
	// Position of SLAVE0 field.
	DCNF_EXTCODE_PROTECT_SLAVE0_Pos = 0x0
	// Bit mask of SLAVE0 field.
	DCNF_EXTCODE_PROTECT_SLAVE0_Msk = 0x1
	// Bit SLAVE0.
	DCNF_EXTCODE_PROTECT_SLAVE0 = 0x1
	// Access to slave is allowed
	DCNF_EXTCODE_PROTECT_SLAVE0_Allowed = 0x0
	// Access to slave is blocked
	DCNF_EXTCODE_PROTECT_SLAVE0_Blocked = 0x1
)

// Constants for FPU_NS: FPU control peripheral 0
const (
	// EVENTS_INVALIDOPERATION: An FPUIOC exception triggered by an invalid operation has occurred in the FPU
	// Position of EVENTS_INVALIDOPERATION field.
	FPU_EVENTS_INVALIDOPERATION_EVENTS_INVALIDOPERATION_Pos = 0x0
	// Bit mask of EVENTS_INVALIDOPERATION field.
	FPU_EVENTS_INVALIDOPERATION_EVENTS_INVALIDOPERATION_Msk = 0x1
	// Bit EVENTS_INVALIDOPERATION.
	FPU_EVENTS_INVALIDOPERATION_EVENTS_INVALIDOPERATION = 0x1
	// Event not generated
	FPU_EVENTS_INVALIDOPERATION_EVENTS_INVALIDOPERATION_NotGenerated = 0x0
	// Event generated
	FPU_EVENTS_INVALIDOPERATION_EVENTS_INVALIDOPERATION_Generated = 0x1

	// EVENTS_DIVIDEBYZERO: An FPUDZC exception triggered by a floating-point divide-by-zero operation has occurred in the FPU
	// Position of EVENTS_DIVIDEBYZERO field.
	FPU_EVENTS_DIVIDEBYZERO_EVENTS_DIVIDEBYZERO_Pos = 0x0
	// Bit mask of EVENTS_DIVIDEBYZERO field.
	FPU_EVENTS_DIVIDEBYZERO_EVENTS_DIVIDEBYZERO_Msk = 0x1
	// Bit EVENTS_DIVIDEBYZERO.
	FPU_EVENTS_DIVIDEBYZERO_EVENTS_DIVIDEBYZERO = 0x1
	// Event not generated
	FPU_EVENTS_DIVIDEBYZERO_EVENTS_DIVIDEBYZERO_NotGenerated = 0x0
	// Event generated
	FPU_EVENTS_DIVIDEBYZERO_EVENTS_DIVIDEBYZERO_Generated = 0x1

	// EVENTS_OVERFLOW: An FPUOFC exception triggered by a floating-point overflow has occurred in the FPU
	// Position of EVENTS_OVERFLOW field.
	FPU_EVENTS_OVERFLOW_EVENTS_OVERFLOW_Pos = 0x0
	// Bit mask of EVENTS_OVERFLOW field.
	FPU_EVENTS_OVERFLOW_EVENTS_OVERFLOW_Msk = 0x1
	// Bit EVENTS_OVERFLOW.
	FPU_EVENTS_OVERFLOW_EVENTS_OVERFLOW = 0x1
	// Event not generated
	FPU_EVENTS_OVERFLOW_EVENTS_OVERFLOW_NotGenerated = 0x0
	// Event generated
	FPU_EVENTS_OVERFLOW_EVENTS_OVERFLOW_Generated = 0x1

	// EVENTS_UNDERFLOW: An FPUUFC exception triggered by a floating-point underflow has occurred in the FPU
	// Position of EVENTS_UNDERFLOW field.
	FPU_EVENTS_UNDERFLOW_EVENTS_UNDERFLOW_Pos = 0x0
	// Bit mask of EVENTS_UNDERFLOW field.
	FPU_EVENTS_UNDERFLOW_EVENTS_UNDERFLOW_Msk = 0x1
	// Bit EVENTS_UNDERFLOW.
	FPU_EVENTS_UNDERFLOW_EVENTS_UNDERFLOW = 0x1
	// Event not generated
	FPU_EVENTS_UNDERFLOW_EVENTS_UNDERFLOW_NotGenerated = 0x0
	// Event generated
	FPU_EVENTS_UNDERFLOW_EVENTS_UNDERFLOW_Generated = 0x1

	// EVENTS_INEXACT: An FPUIXC exception triggered by an inexact floating-point operation has occurred in the FPU
	// Position of EVENTS_INEXACT field.
	FPU_EVENTS_INEXACT_EVENTS_INEXACT_Pos = 0x0
	// Bit mask of EVENTS_INEXACT field.
	FPU_EVENTS_INEXACT_EVENTS_INEXACT_Msk = 0x1
	// Bit EVENTS_INEXACT.
	FPU_EVENTS_INEXACT_EVENTS_INEXACT = 0x1
	// Event not generated
	FPU_EVENTS_INEXACT_EVENTS_INEXACT_NotGenerated = 0x0
	// Event generated
	FPU_EVENTS_INEXACT_EVENTS_INEXACT_Generated = 0x1

	// EVENTS_DENORMALINPUT: An FPUIDC exception triggered by a denormal floating-point input has occurred in the FPU
	// Position of EVENTS_DENORMALINPUT field.
	FPU_EVENTS_DENORMALINPUT_EVENTS_DENORMALINPUT_Pos = 0x0
	// Bit mask of EVENTS_DENORMALINPUT field.
	FPU_EVENTS_DENORMALINPUT_EVENTS_DENORMALINPUT_Msk = 0x1
	// Bit EVENTS_DENORMALINPUT.
	FPU_EVENTS_DENORMALINPUT_EVENTS_DENORMALINPUT = 0x1
	// Event not generated
	FPU_EVENTS_DENORMALINPUT_EVENTS_DENORMALINPUT_NotGenerated = 0x0
	// Event generated
	FPU_EVENTS_DENORMALINPUT_EVENTS_DENORMALINPUT_Generated = 0x1

	// INTEN: Enable or disable interrupt
	// Position of INVALIDOPERATION field.
	FPU_INTEN_INVALIDOPERATION_Pos = 0x0
	// Bit mask of INVALIDOPERATION field.
	FPU_INTEN_INVALIDOPERATION_Msk = 0x1
	// Bit INVALIDOPERATION.
	FPU_INTEN_INVALIDOPERATION = 0x1
	// Disable
	FPU_INTEN_INVALIDOPERATION_Disabled = 0x0
	// Enable
	FPU_INTEN_INVALIDOPERATION_Enabled = 0x1
	// Position of DIVIDEBYZERO field.
	FPU_INTEN_DIVIDEBYZERO_Pos = 0x1
	// Bit mask of DIVIDEBYZERO field.
	FPU_INTEN_DIVIDEBYZERO_Msk = 0x2
	// Bit DIVIDEBYZERO.
	FPU_INTEN_DIVIDEBYZERO = 0x2
	// Disable
	FPU_INTEN_DIVIDEBYZERO_Disabled = 0x0
	// Enable
	FPU_INTEN_DIVIDEBYZERO_Enabled = 0x1
	// Position of OVERFLOW field.
	FPU_INTEN_OVERFLOW_Pos = 0x2
	// Bit mask of OVERFLOW field.
	FPU_INTEN_OVERFLOW_Msk = 0x4
	// Bit OVERFLOW.
	FPU_INTEN_OVERFLOW = 0x4
	// Disable
	FPU_INTEN_OVERFLOW_Disabled = 0x0
	// Enable
	FPU_INTEN_OVERFLOW_Enabled = 0x1
	// Position of UNDERFLOW field.
	FPU_INTEN_UNDERFLOW_Pos = 0x3
	// Bit mask of UNDERFLOW field.
	FPU_INTEN_UNDERFLOW_Msk = 0x8
	// Bit UNDERFLOW.
	FPU_INTEN_UNDERFLOW = 0x8
	// Disable
	FPU_INTEN_UNDERFLOW_Disabled = 0x0
	// Enable
	FPU_INTEN_UNDERFLOW_Enabled = 0x1
	// Position of INEXACT field.
	FPU_INTEN_INEXACT_Pos = 0x4
	// Bit mask of INEXACT field.
	FPU_INTEN_INEXACT_Msk = 0x10
	// Bit INEXACT.
	FPU_INTEN_INEXACT = 0x10
	// Disable
	FPU_INTEN_INEXACT_Disabled = 0x0
	// Enable
	FPU_INTEN_INEXACT_Enabled = 0x1
	// Position of DENORMALINPUT field.
	FPU_INTEN_DENORMALINPUT_Pos = 0x5
	// Bit mask of DENORMALINPUT field.
	FPU_INTEN_DENORMALINPUT_Msk = 0x20
	// Bit DENORMALINPUT.
	FPU_INTEN_DENORMALINPUT = 0x20
	// Disable
	FPU_INTEN_DENORMALINPUT_Disabled = 0x0
	// Enable
	FPU_INTEN_DENORMALINPUT_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of INVALIDOPERATION field.
	FPU_INTENSET_INVALIDOPERATION_Pos = 0x0
	// Bit mask of INVALIDOPERATION field.
	FPU_INTENSET_INVALIDOPERATION_Msk = 0x1
	// Bit INVALIDOPERATION.
	FPU_INTENSET_INVALIDOPERATION = 0x1
	// Read: Disabled
	FPU_INTENSET_INVALIDOPERATION_Disabled = 0x0
	// Read: Enabled
	FPU_INTENSET_INVALIDOPERATION_Enabled = 0x1
	// Enable
	FPU_INTENSET_INVALIDOPERATION_Set = 0x1
	// Position of DIVIDEBYZERO field.
	FPU_INTENSET_DIVIDEBYZERO_Pos = 0x1
	// Bit mask of DIVIDEBYZERO field.
	FPU_INTENSET_DIVIDEBYZERO_Msk = 0x2
	// Bit DIVIDEBYZERO.
	FPU_INTENSET_DIVIDEBYZERO = 0x2
	// Read: Disabled
	FPU_INTENSET_DIVIDEBYZERO_Disabled = 0x0
	// Read: Enabled
	FPU_INTENSET_DIVIDEBYZERO_Enabled = 0x1
	// Enable
	FPU_INTENSET_DIVIDEBYZERO_Set = 0x1
	// Position of OVERFLOW field.
	FPU_INTENSET_OVERFLOW_Pos = 0x2
	// Bit mask of OVERFLOW field.
	FPU_INTENSET_OVERFLOW_Msk = 0x4
	// Bit OVERFLOW.
	FPU_INTENSET_OVERFLOW = 0x4
	// Read: Disabled
	FPU_INTENSET_OVERFLOW_Disabled = 0x0
	// Read: Enabled
	FPU_INTENSET_OVERFLOW_Enabled = 0x1
	// Enable
	FPU_INTENSET_OVERFLOW_Set = 0x1
	// Position of UNDERFLOW field.
	FPU_INTENSET_UNDERFLOW_Pos = 0x3
	// Bit mask of UNDERFLOW field.
	FPU_INTENSET_UNDERFLOW_Msk = 0x8
	// Bit UNDERFLOW.
	FPU_INTENSET_UNDERFLOW = 0x8
	// Read: Disabled
	FPU_INTENSET_UNDERFLOW_Disabled = 0x0
	// Read: Enabled
	FPU_INTENSET_UNDERFLOW_Enabled = 0x1
	// Enable
	FPU_INTENSET_UNDERFLOW_Set = 0x1
	// Position of INEXACT field.
	FPU_INTENSET_INEXACT_Pos = 0x4
	// Bit mask of INEXACT field.
	FPU_INTENSET_INEXACT_Msk = 0x10
	// Bit INEXACT.
	FPU_INTENSET_INEXACT = 0x10
	// Read: Disabled
	FPU_INTENSET_INEXACT_Disabled = 0x0
	// Read: Enabled
	FPU_INTENSET_INEXACT_Enabled = 0x1
	// Enable
	FPU_INTENSET_INEXACT_Set = 0x1
	// Position of DENORMALINPUT field.
	FPU_INTENSET_DENORMALINPUT_Pos = 0x5
	// Bit mask of DENORMALINPUT field.
	FPU_INTENSET_DENORMALINPUT_Msk = 0x20
	// Bit DENORMALINPUT.
	FPU_INTENSET_DENORMALINPUT = 0x20
	// Read: Disabled
	FPU_INTENSET_DENORMALINPUT_Disabled = 0x0
	// Read: Enabled
	FPU_INTENSET_DENORMALINPUT_Enabled = 0x1
	// Enable
	FPU_INTENSET_DENORMALINPUT_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of INVALIDOPERATION field.
	FPU_INTENCLR_INVALIDOPERATION_Pos = 0x0
	// Bit mask of INVALIDOPERATION field.
	FPU_INTENCLR_INVALIDOPERATION_Msk = 0x1
	// Bit INVALIDOPERATION.
	FPU_INTENCLR_INVALIDOPERATION = 0x1
	// Read: Disabled
	FPU_INTENCLR_INVALIDOPERATION_Disabled = 0x0
	// Read: Enabled
	FPU_INTENCLR_INVALIDOPERATION_Enabled = 0x1
	// Disable
	FPU_INTENCLR_INVALIDOPERATION_Clear = 0x1
	// Position of DIVIDEBYZERO field.
	FPU_INTENCLR_DIVIDEBYZERO_Pos = 0x1
	// Bit mask of DIVIDEBYZERO field.
	FPU_INTENCLR_DIVIDEBYZERO_Msk = 0x2
	// Bit DIVIDEBYZERO.
	FPU_INTENCLR_DIVIDEBYZERO = 0x2
	// Read: Disabled
	FPU_INTENCLR_DIVIDEBYZERO_Disabled = 0x0
	// Read: Enabled
	FPU_INTENCLR_DIVIDEBYZERO_Enabled = 0x1
	// Disable
	FPU_INTENCLR_DIVIDEBYZERO_Clear = 0x1
	// Position of OVERFLOW field.
	FPU_INTENCLR_OVERFLOW_Pos = 0x2
	// Bit mask of OVERFLOW field.
	FPU_INTENCLR_OVERFLOW_Msk = 0x4
	// Bit OVERFLOW.
	FPU_INTENCLR_OVERFLOW = 0x4
	// Read: Disabled
	FPU_INTENCLR_OVERFLOW_Disabled = 0x0
	// Read: Enabled
	FPU_INTENCLR_OVERFLOW_Enabled = 0x1
	// Disable
	FPU_INTENCLR_OVERFLOW_Clear = 0x1
	// Position of UNDERFLOW field.
	FPU_INTENCLR_UNDERFLOW_Pos = 0x3
	// Bit mask of UNDERFLOW field.
	FPU_INTENCLR_UNDERFLOW_Msk = 0x8
	// Bit UNDERFLOW.
	FPU_INTENCLR_UNDERFLOW = 0x8
	// Read: Disabled
	FPU_INTENCLR_UNDERFLOW_Disabled = 0x0
	// Read: Enabled
	FPU_INTENCLR_UNDERFLOW_Enabled = 0x1
	// Disable
	FPU_INTENCLR_UNDERFLOW_Clear = 0x1
	// Position of INEXACT field.
	FPU_INTENCLR_INEXACT_Pos = 0x4
	// Bit mask of INEXACT field.
	FPU_INTENCLR_INEXACT_Msk = 0x10
	// Bit INEXACT.
	FPU_INTENCLR_INEXACT = 0x10
	// Read: Disabled
	FPU_INTENCLR_INEXACT_Disabled = 0x0
	// Read: Enabled
	FPU_INTENCLR_INEXACT_Enabled = 0x1
	// Disable
	FPU_INTENCLR_INEXACT_Clear = 0x1
	// Position of DENORMALINPUT field.
	FPU_INTENCLR_DENORMALINPUT_Pos = 0x5
	// Bit mask of DENORMALINPUT field.
	FPU_INTENCLR_DENORMALINPUT_Msk = 0x20
	// Bit DENORMALINPUT.
	FPU_INTENCLR_DENORMALINPUT = 0x20
	// Read: Disabled
	FPU_INTENCLR_DENORMALINPUT_Disabled = 0x0
	// Read: Enabled
	FPU_INTENCLR_DENORMALINPUT_Enabled = 0x1
	// Disable
	FPU_INTENCLR_DENORMALINPUT_Clear = 0x1
)

// Constants for CACHE_S: Cache
const (
	// PROFILING.IHIT: Description cluster: Instruction fetch cache hit counter for cache region n, where n=0 means Flash and n=1 means XIP.
	// Position of HITS field.
	CACHE_PROFILING_IHIT_HITS_Pos = 0x0
	// Bit mask of HITS field.
	CACHE_PROFILING_IHIT_HITS_Msk = 0xffffffff

	// PROFILING.IMISS: Description cluster: Instruction fetch cache miss counter for cache region n, where n=0 means Flash and n=1 means XIP.
	// Position of MISSES field.
	CACHE_PROFILING_IMISS_MISSES_Pos = 0x0
	// Bit mask of MISSES field.
	CACHE_PROFILING_IMISS_MISSES_Msk = 0xffffffff

	// PROFILING.DHIT: Description cluster: Data fetch cache hit counter for cache region n, where n=0 means Flash and n=1 means XIP.
	// Position of HITS field.
	CACHE_PROFILING_DHIT_HITS_Pos = 0x0
	// Bit mask of HITS field.
	CACHE_PROFILING_DHIT_HITS_Msk = 0xffffffff

	// PROFILING.DMISS: Description cluster: Data fetch cache miss counter for cache region n, where n=0 means Flash and n=1 means XIP.
	// Position of MISSES field.
	CACHE_PROFILING_DMISS_MISSES_Pos = 0x0
	// Bit mask of MISSES field.
	CACHE_PROFILING_DMISS_MISSES_Msk = 0xffffffff

	// ENABLE: Enable cache
	// Position of ENABLE field.
	CACHE_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	CACHE_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	CACHE_ENABLE_ENABLE = 0x1
	// Disable cache
	CACHE_ENABLE_ENABLE_Disabled = 0x0
	// Enable cache
	CACHE_ENABLE_ENABLE_Enabled = 0x1

	// INVALIDATE: Invalidate the cache
	// Position of INVALIDATE field.
	CACHE_INVALIDATE_INVALIDATE_Pos = 0x0
	// Bit mask of INVALIDATE field.
	CACHE_INVALIDATE_INVALIDATE_Msk = 0x1
	// Bit INVALIDATE.
	CACHE_INVALIDATE_INVALIDATE = 0x1
	// Invalidate the cache
	CACHE_INVALIDATE_INVALIDATE_Invalidate = 0x1

	// ERASE: Erase the cache
	// Position of ERASE field.
	CACHE_ERASE_ERASE_Pos = 0x0
	// Bit mask of ERASE field.
	CACHE_ERASE_ERASE_Msk = 0x1
	// Bit ERASE.
	CACHE_ERASE_ERASE = 0x1
	// Erase cache
	CACHE_ERASE_ERASE_Erase = 0x1

	// PROFILINGENABLE: Enable the profiling counters
	// Position of ENABLE field.
	CACHE_PROFILINGENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	CACHE_PROFILINGENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	CACHE_PROFILINGENABLE_ENABLE = 0x1
	// Disable profiling
	CACHE_PROFILINGENABLE_ENABLE_Disable = 0x0
	// Enable profiling
	CACHE_PROFILINGENABLE_ENABLE_Enable = 0x1

	// PROFILINGCLEAR: Clear the profiling counters
	// Position of CLEAR field.
	CACHE_PROFILINGCLEAR_CLEAR_Pos = 0x0
	// Bit mask of CLEAR field.
	CACHE_PROFILINGCLEAR_CLEAR_Msk = 0x1
	// Bit CLEAR.
	CACHE_PROFILINGCLEAR_CLEAR = 0x1
	// Clear the profiling counters
	CACHE_PROFILINGCLEAR_CLEAR_Clear = 0x1

	// MODE: Cache mode. Switching from Cache to RAM mode causes the RAM to be cleared. Switching from RAM to Cache mode causes the cache to be invalidated.
	// Position of MODE field.
	CACHE_MODE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	CACHE_MODE_MODE_Msk = 0x1
	// Bit MODE.
	CACHE_MODE_MODE = 0x1
	// Cache mode
	CACHE_MODE_MODE_Cache = 0x0
	// RAM mode
	CACHE_MODE_MODE_Ram = 0x1

	// DEBUGLOCK: Lock debug mode Ignored in RAM mode.
	// Position of DEBUGLOCK field.
	CACHE_DEBUGLOCK_DEBUGLOCK_Pos = 0x0
	// Bit mask of DEBUGLOCK field.
	CACHE_DEBUGLOCK_DEBUGLOCK_Msk = 0x1
	// Bit DEBUGLOCK.
	CACHE_DEBUGLOCK_DEBUGLOCK = 0x1
	// Debug mode unlocked
	CACHE_DEBUGLOCK_DEBUGLOCK_Unlocked = 0x0
	// Debug mode locked
	CACHE_DEBUGLOCK_DEBUGLOCK_Locked = 0x1

	// ERASESTATUS: Cache erase status
	// Position of ERASESTATUS field.
	CACHE_ERASESTATUS_ERASESTATUS_Pos = 0x0
	// Bit mask of ERASESTATUS field.
	CACHE_ERASESTATUS_ERASESTATUS_Msk = 0x1
	// Bit ERASESTATUS.
	CACHE_ERASESTATUS_ERASESTATUS = 0x1
	// Erase is not complete or hasn't started
	CACHE_ERASESTATUS_ERASESTATUS_Idle = 0x0
	// Cache erase is finished
	CACHE_ERASESTATUS_ERASESTATUS_Finished = 0x1

	// WRITELOCK: Lock cache updates. Prevents updating of cache content on cache misses, but will continue to lookup instruction/data fetches in content already present in the cache. Ignored in RAM mode.
	// Position of WRITELOCK field.
	CACHE_WRITELOCK_WRITELOCK_Pos = 0x0
	// Bit mask of WRITELOCK field.
	CACHE_WRITELOCK_WRITELOCK_Msk = 0x1
	// Bit WRITELOCK.
	CACHE_WRITELOCK_WRITELOCK = 0x1
	// Cache updates unlocked
	CACHE_WRITELOCK_WRITELOCK_Unlocked = 0x0
	// Cache updates locked
	CACHE_WRITELOCK_WRITELOCK_Locked = 0x1
)

// Constants for SPU_S: System protection unit
const (
	// EVENTS_RAMACCERR: A security violation has been detected for the RAM memory space
	// Position of EVENTS_RAMACCERR field.
	SPU_EVENTS_RAMACCERR_EVENTS_RAMACCERR_Pos = 0x0
	// Bit mask of EVENTS_RAMACCERR field.
	SPU_EVENTS_RAMACCERR_EVENTS_RAMACCERR_Msk = 0x1
	// Bit EVENTS_RAMACCERR.
	SPU_EVENTS_RAMACCERR_EVENTS_RAMACCERR = 0x1
	// Event not generated
	SPU_EVENTS_RAMACCERR_EVENTS_RAMACCERR_NotGenerated = 0x0
	// Event generated
	SPU_EVENTS_RAMACCERR_EVENTS_RAMACCERR_Generated = 0x1

	// EVENTS_FLASHACCERR: A security violation has been detected for the flash memory space
	// Position of EVENTS_FLASHACCERR field.
	SPU_EVENTS_FLASHACCERR_EVENTS_FLASHACCERR_Pos = 0x0
	// Bit mask of EVENTS_FLASHACCERR field.
	SPU_EVENTS_FLASHACCERR_EVENTS_FLASHACCERR_Msk = 0x1
	// Bit EVENTS_FLASHACCERR.
	SPU_EVENTS_FLASHACCERR_EVENTS_FLASHACCERR = 0x1
	// Event not generated
	SPU_EVENTS_FLASHACCERR_EVENTS_FLASHACCERR_NotGenerated = 0x0
	// Event generated
	SPU_EVENTS_FLASHACCERR_EVENTS_FLASHACCERR_Generated = 0x1

	// EVENTS_PERIPHACCERR: A security violation has been detected on one or several peripherals
	// Position of EVENTS_PERIPHACCERR field.
	SPU_EVENTS_PERIPHACCERR_EVENTS_PERIPHACCERR_Pos = 0x0
	// Bit mask of EVENTS_PERIPHACCERR field.
	SPU_EVENTS_PERIPHACCERR_EVENTS_PERIPHACCERR_Msk = 0x1
	// Bit EVENTS_PERIPHACCERR.
	SPU_EVENTS_PERIPHACCERR_EVENTS_PERIPHACCERR = 0x1
	// Event not generated
	SPU_EVENTS_PERIPHACCERR_EVENTS_PERIPHACCERR_NotGenerated = 0x0
	// Event generated
	SPU_EVENTS_PERIPHACCERR_EVENTS_PERIPHACCERR_Generated = 0x1

	// PUBLISH_RAMACCERR: Publish configuration for event RAMACCERR
	// Position of CHIDX field.
	SPU_PUBLISH_RAMACCERR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPU_PUBLISH_RAMACCERR_CHIDX_Msk = 0xff
	// Position of EN field.
	SPU_PUBLISH_RAMACCERR_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPU_PUBLISH_RAMACCERR_EN_Msk = 0x80000000
	// Bit EN.
	SPU_PUBLISH_RAMACCERR_EN = 0x80000000
	// Disable publishing
	SPU_PUBLISH_RAMACCERR_EN_Disabled = 0x0
	// Enable publishing
	SPU_PUBLISH_RAMACCERR_EN_Enabled = 0x1

	// PUBLISH_FLASHACCERR: Publish configuration for event FLASHACCERR
	// Position of CHIDX field.
	SPU_PUBLISH_FLASHACCERR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPU_PUBLISH_FLASHACCERR_CHIDX_Msk = 0xff
	// Position of EN field.
	SPU_PUBLISH_FLASHACCERR_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPU_PUBLISH_FLASHACCERR_EN_Msk = 0x80000000
	// Bit EN.
	SPU_PUBLISH_FLASHACCERR_EN = 0x80000000
	// Disable publishing
	SPU_PUBLISH_FLASHACCERR_EN_Disabled = 0x0
	// Enable publishing
	SPU_PUBLISH_FLASHACCERR_EN_Enabled = 0x1

	// PUBLISH_PERIPHACCERR: Publish configuration for event PERIPHACCERR
	// Position of CHIDX field.
	SPU_PUBLISH_PERIPHACCERR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPU_PUBLISH_PERIPHACCERR_CHIDX_Msk = 0xff
	// Position of EN field.
	SPU_PUBLISH_PERIPHACCERR_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPU_PUBLISH_PERIPHACCERR_EN_Msk = 0x80000000
	// Bit EN.
	SPU_PUBLISH_PERIPHACCERR_EN = 0x80000000
	// Disable publishing
	SPU_PUBLISH_PERIPHACCERR_EN_Disabled = 0x0
	// Enable publishing
	SPU_PUBLISH_PERIPHACCERR_EN_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of RAMACCERR field.
	SPU_INTEN_RAMACCERR_Pos = 0x0
	// Bit mask of RAMACCERR field.
	SPU_INTEN_RAMACCERR_Msk = 0x1
	// Bit RAMACCERR.
	SPU_INTEN_RAMACCERR = 0x1
	// Disable
	SPU_INTEN_RAMACCERR_Disabled = 0x0
	// Enable
	SPU_INTEN_RAMACCERR_Enabled = 0x1
	// Position of FLASHACCERR field.
	SPU_INTEN_FLASHACCERR_Pos = 0x1
	// Bit mask of FLASHACCERR field.
	SPU_INTEN_FLASHACCERR_Msk = 0x2
	// Bit FLASHACCERR.
	SPU_INTEN_FLASHACCERR = 0x2
	// Disable
	SPU_INTEN_FLASHACCERR_Disabled = 0x0
	// Enable
	SPU_INTEN_FLASHACCERR_Enabled = 0x1
	// Position of PERIPHACCERR field.
	SPU_INTEN_PERIPHACCERR_Pos = 0x2
	// Bit mask of PERIPHACCERR field.
	SPU_INTEN_PERIPHACCERR_Msk = 0x4
	// Bit PERIPHACCERR.
	SPU_INTEN_PERIPHACCERR = 0x4
	// Disable
	SPU_INTEN_PERIPHACCERR_Disabled = 0x0
	// Enable
	SPU_INTEN_PERIPHACCERR_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of RAMACCERR field.
	SPU_INTENSET_RAMACCERR_Pos = 0x0
	// Bit mask of RAMACCERR field.
	SPU_INTENSET_RAMACCERR_Msk = 0x1
	// Bit RAMACCERR.
	SPU_INTENSET_RAMACCERR = 0x1
	// Read: Disabled
	SPU_INTENSET_RAMACCERR_Disabled = 0x0
	// Read: Enabled
	SPU_INTENSET_RAMACCERR_Enabled = 0x1
	// Enable
	SPU_INTENSET_RAMACCERR_Set = 0x1
	// Position of FLASHACCERR field.
	SPU_INTENSET_FLASHACCERR_Pos = 0x1
	// Bit mask of FLASHACCERR field.
	SPU_INTENSET_FLASHACCERR_Msk = 0x2
	// Bit FLASHACCERR.
	SPU_INTENSET_FLASHACCERR = 0x2
	// Read: Disabled
	SPU_INTENSET_FLASHACCERR_Disabled = 0x0
	// Read: Enabled
	SPU_INTENSET_FLASHACCERR_Enabled = 0x1
	// Enable
	SPU_INTENSET_FLASHACCERR_Set = 0x1
	// Position of PERIPHACCERR field.
	SPU_INTENSET_PERIPHACCERR_Pos = 0x2
	// Bit mask of PERIPHACCERR field.
	SPU_INTENSET_PERIPHACCERR_Msk = 0x4
	// Bit PERIPHACCERR.
	SPU_INTENSET_PERIPHACCERR = 0x4
	// Read: Disabled
	SPU_INTENSET_PERIPHACCERR_Disabled = 0x0
	// Read: Enabled
	SPU_INTENSET_PERIPHACCERR_Enabled = 0x1
	// Enable
	SPU_INTENSET_PERIPHACCERR_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of RAMACCERR field.
	SPU_INTENCLR_RAMACCERR_Pos = 0x0
	// Bit mask of RAMACCERR field.
	SPU_INTENCLR_RAMACCERR_Msk = 0x1
	// Bit RAMACCERR.
	SPU_INTENCLR_RAMACCERR = 0x1
	// Read: Disabled
	SPU_INTENCLR_RAMACCERR_Disabled = 0x0
	// Read: Enabled
	SPU_INTENCLR_RAMACCERR_Enabled = 0x1
	// Disable
	SPU_INTENCLR_RAMACCERR_Clear = 0x1
	// Position of FLASHACCERR field.
	SPU_INTENCLR_FLASHACCERR_Pos = 0x1
	// Bit mask of FLASHACCERR field.
	SPU_INTENCLR_FLASHACCERR_Msk = 0x2
	// Bit FLASHACCERR.
	SPU_INTENCLR_FLASHACCERR = 0x2
	// Read: Disabled
	SPU_INTENCLR_FLASHACCERR_Disabled = 0x0
	// Read: Enabled
	SPU_INTENCLR_FLASHACCERR_Enabled = 0x1
	// Disable
	SPU_INTENCLR_FLASHACCERR_Clear = 0x1
	// Position of PERIPHACCERR field.
	SPU_INTENCLR_PERIPHACCERR_Pos = 0x2
	// Bit mask of PERIPHACCERR field.
	SPU_INTENCLR_PERIPHACCERR_Msk = 0x4
	// Bit PERIPHACCERR.
	SPU_INTENCLR_PERIPHACCERR = 0x4
	// Read: Disabled
	SPU_INTENCLR_PERIPHACCERR_Disabled = 0x0
	// Read: Enabled
	SPU_INTENCLR_PERIPHACCERR_Enabled = 0x1
	// Disable
	SPU_INTENCLR_PERIPHACCERR_Clear = 0x1

	// CAP: Show implemented features for the current device
	// Position of TZM field.
	SPU_CAP_TZM_Pos = 0x0
	// Bit mask of TZM field.
	SPU_CAP_TZM_Msk = 0x1
	// Bit TZM.
	SPU_CAP_TZM = 0x1
	// ARM TrustZone support not available
	SPU_CAP_TZM_NotAvailable = 0x0
	// ARM TrustZone support is available
	SPU_CAP_TZM_Enabled = 0x1

	// CPULOCK: Configure bits to lock down CPU features at runtime
	// Position of LOCKSVTAIRCR field.
	SPU_CPULOCK_LOCKSVTAIRCR_Pos = 0x0
	// Bit mask of LOCKSVTAIRCR field.
	SPU_CPULOCK_LOCKSVTAIRCR_Msk = 0x1
	// Bit LOCKSVTAIRCR.
	SPU_CPULOCK_LOCKSVTAIRCR = 0x1
	// Disables writes to the VTOR_S, AIRCR.PRIS, and AIRCR.BFHFNMINS registers
	SPU_CPULOCK_LOCKSVTAIRCR_Locked = 0x1
	// These registers can be updated
	SPU_CPULOCK_LOCKSVTAIRCR_Unlocked = 0x0
	// Position of LOCKNSVTOR field.
	SPU_CPULOCK_LOCKNSVTOR_Pos = 0x1
	// Bit mask of LOCKNSVTOR field.
	SPU_CPULOCK_LOCKNSVTOR_Msk = 0x2
	// Bit LOCKNSVTOR.
	SPU_CPULOCK_LOCKNSVTOR = 0x2
	// The address of the non-secure vector table is locked
	SPU_CPULOCK_LOCKNSVTOR_Locked = 0x1
	// The address of the non-secure vector table can be updated
	SPU_CPULOCK_LOCKNSVTOR_Unlocked = 0x0
	// Position of LOCKSMPU field.
	SPU_CPULOCK_LOCKSMPU_Pos = 0x2
	// Bit mask of LOCKSMPU field.
	SPU_CPULOCK_LOCKSMPU_Msk = 0x4
	// Bit LOCKSMPU.
	SPU_CPULOCK_LOCKSMPU = 0x4
	// Disables writes to the MPU_CTRL, MPU_RNR, MPU_RBAR, MPU_RLAR, MPU_RBAR_An and MPU_RLAR_An from software or from a debug agent connected to the processor in Secure state
	SPU_CPULOCK_LOCKSMPU_Locked = 0x1
	// These registers can be updated
	SPU_CPULOCK_LOCKSMPU_Unlocked = 0x0
	// Position of LOCKNSMPU field.
	SPU_CPULOCK_LOCKNSMPU_Pos = 0x3
	// Bit mask of LOCKNSMPU field.
	SPU_CPULOCK_LOCKNSMPU_Msk = 0x8
	// Bit LOCKNSMPU.
	SPU_CPULOCK_LOCKNSMPU = 0x8
	// Disables writes to the MPU_CTRL_NS, MPU_RNR_NS, MPU_RBAR_NS, MPU_RLAR_NS, MPU_RBAR_A_NSn and MPU_RLAR_A_NSn from software or from a debug agent connected to the processor
	SPU_CPULOCK_LOCKNSMPU_Locked = 0x1
	// These registers can be updated
	SPU_CPULOCK_LOCKNSMPU_Unlocked = 0x0
	// Position of LOCKSAU field.
	SPU_CPULOCK_LOCKSAU_Pos = 0x4
	// Bit mask of LOCKSAU field.
	SPU_CPULOCK_LOCKSAU_Msk = 0x10
	// Bit LOCKSAU.
	SPU_CPULOCK_LOCKSAU = 0x10
	// Disables writes to the SAU_CTRL, SAU_RNR, SAU_RBAR and SAU_RLAR registers from software or from a debug agent connected to the processor
	SPU_CPULOCK_LOCKSAU_Locked = 0x1
	// These registers can be updated
	SPU_CPULOCK_LOCKSAU_Unlocked = 0x0

	// EXTDOMAIN.PERM: Description cluster: Access for bus access generated from the external domain n List capabilities of the external domain n
	// Position of SECUREMAPPING field.
	SPU_EXTDOMAIN_PERM_SECUREMAPPING_Pos = 0x0
	// Bit mask of SECUREMAPPING field.
	SPU_EXTDOMAIN_PERM_SECUREMAPPING_Msk = 0x3
	// The bus access from this external domain always have the non-secure attribute set
	SPU_EXTDOMAIN_PERM_SECUREMAPPING_NonSecure = 0x0
	// The bus access from this external domain always have the secure attribute set
	SPU_EXTDOMAIN_PERM_SECUREMAPPING_Secure = 0x1
	// Non-secure or secure attribute for bus access from this domain is defined by the EXTDOMAIN[n].PERM register
	SPU_EXTDOMAIN_PERM_SECUREMAPPING_UserSelectable = 0x2
	// Position of SECATTR field.
	SPU_EXTDOMAIN_PERM_SECATTR_Pos = 0x4
	// Bit mask of SECATTR field.
	SPU_EXTDOMAIN_PERM_SECATTR_Msk = 0x10
	// Bit SECATTR.
	SPU_EXTDOMAIN_PERM_SECATTR = 0x10
	// Bus accesses from this domain have the non-secure attribute set
	SPU_EXTDOMAIN_PERM_SECATTR_NonSecure = 0x0
	// Bus accesses from this domain have secure attribute set
	SPU_EXTDOMAIN_PERM_SECATTR_Secure = 0x1
	// Position of LOCK field.
	SPU_EXTDOMAIN_PERM_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	SPU_EXTDOMAIN_PERM_LOCK_Msk = 0x100
	// Bit LOCK.
	SPU_EXTDOMAIN_PERM_LOCK = 0x100
	// This register can be updated
	SPU_EXTDOMAIN_PERM_LOCK_Unlocked = 0x0
	// The content of this register can't be changed until the next reset
	SPU_EXTDOMAIN_PERM_LOCK_Locked = 0x1

	// DPPI.PERM: Description cluster: Select between secure and non-secure attribute for the DPPI channels.
	// Position of CHANNEL0 field.
	SPU_DPPI_PERM_CHANNEL0_Pos = 0x0
	// Bit mask of CHANNEL0 field.
	SPU_DPPI_PERM_CHANNEL0_Msk = 0x1
	// Bit CHANNEL0.
	SPU_DPPI_PERM_CHANNEL0 = 0x1
	// Channel0 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL0_Secure = 0x1
	// Channel0 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL0_NonSecure = 0x0
	// Position of CHANNEL1 field.
	SPU_DPPI_PERM_CHANNEL1_Pos = 0x1
	// Bit mask of CHANNEL1 field.
	SPU_DPPI_PERM_CHANNEL1_Msk = 0x2
	// Bit CHANNEL1.
	SPU_DPPI_PERM_CHANNEL1 = 0x2
	// Channel1 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL1_Secure = 0x1
	// Channel1 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL1_NonSecure = 0x0
	// Position of CHANNEL2 field.
	SPU_DPPI_PERM_CHANNEL2_Pos = 0x2
	// Bit mask of CHANNEL2 field.
	SPU_DPPI_PERM_CHANNEL2_Msk = 0x4
	// Bit CHANNEL2.
	SPU_DPPI_PERM_CHANNEL2 = 0x4
	// Channel2 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL2_Secure = 0x1
	// Channel2 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL2_NonSecure = 0x0
	// Position of CHANNEL3 field.
	SPU_DPPI_PERM_CHANNEL3_Pos = 0x3
	// Bit mask of CHANNEL3 field.
	SPU_DPPI_PERM_CHANNEL3_Msk = 0x8
	// Bit CHANNEL3.
	SPU_DPPI_PERM_CHANNEL3 = 0x8
	// Channel3 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL3_Secure = 0x1
	// Channel3 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL3_NonSecure = 0x0
	// Position of CHANNEL4 field.
	SPU_DPPI_PERM_CHANNEL4_Pos = 0x4
	// Bit mask of CHANNEL4 field.
	SPU_DPPI_PERM_CHANNEL4_Msk = 0x10
	// Bit CHANNEL4.
	SPU_DPPI_PERM_CHANNEL4 = 0x10
	// Channel4 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL4_Secure = 0x1
	// Channel4 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL4_NonSecure = 0x0
	// Position of CHANNEL5 field.
	SPU_DPPI_PERM_CHANNEL5_Pos = 0x5
	// Bit mask of CHANNEL5 field.
	SPU_DPPI_PERM_CHANNEL5_Msk = 0x20
	// Bit CHANNEL5.
	SPU_DPPI_PERM_CHANNEL5 = 0x20
	// Channel5 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL5_Secure = 0x1
	// Channel5 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL5_NonSecure = 0x0
	// Position of CHANNEL6 field.
	SPU_DPPI_PERM_CHANNEL6_Pos = 0x6
	// Bit mask of CHANNEL6 field.
	SPU_DPPI_PERM_CHANNEL6_Msk = 0x40
	// Bit CHANNEL6.
	SPU_DPPI_PERM_CHANNEL6 = 0x40
	// Channel6 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL6_Secure = 0x1
	// Channel6 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL6_NonSecure = 0x0
	// Position of CHANNEL7 field.
	SPU_DPPI_PERM_CHANNEL7_Pos = 0x7
	// Bit mask of CHANNEL7 field.
	SPU_DPPI_PERM_CHANNEL7_Msk = 0x80
	// Bit CHANNEL7.
	SPU_DPPI_PERM_CHANNEL7 = 0x80
	// Channel7 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL7_Secure = 0x1
	// Channel7 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL7_NonSecure = 0x0
	// Position of CHANNEL8 field.
	SPU_DPPI_PERM_CHANNEL8_Pos = 0x8
	// Bit mask of CHANNEL8 field.
	SPU_DPPI_PERM_CHANNEL8_Msk = 0x100
	// Bit CHANNEL8.
	SPU_DPPI_PERM_CHANNEL8 = 0x100
	// Channel8 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL8_Secure = 0x1
	// Channel8 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL8_NonSecure = 0x0
	// Position of CHANNEL9 field.
	SPU_DPPI_PERM_CHANNEL9_Pos = 0x9
	// Bit mask of CHANNEL9 field.
	SPU_DPPI_PERM_CHANNEL9_Msk = 0x200
	// Bit CHANNEL9.
	SPU_DPPI_PERM_CHANNEL9 = 0x200
	// Channel9 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL9_Secure = 0x1
	// Channel9 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL9_NonSecure = 0x0
	// Position of CHANNEL10 field.
	SPU_DPPI_PERM_CHANNEL10_Pos = 0xa
	// Bit mask of CHANNEL10 field.
	SPU_DPPI_PERM_CHANNEL10_Msk = 0x400
	// Bit CHANNEL10.
	SPU_DPPI_PERM_CHANNEL10 = 0x400
	// Channel10 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL10_Secure = 0x1
	// Channel10 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL10_NonSecure = 0x0
	// Position of CHANNEL11 field.
	SPU_DPPI_PERM_CHANNEL11_Pos = 0xb
	// Bit mask of CHANNEL11 field.
	SPU_DPPI_PERM_CHANNEL11_Msk = 0x800
	// Bit CHANNEL11.
	SPU_DPPI_PERM_CHANNEL11 = 0x800
	// Channel11 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL11_Secure = 0x1
	// Channel11 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL11_NonSecure = 0x0
	// Position of CHANNEL12 field.
	SPU_DPPI_PERM_CHANNEL12_Pos = 0xc
	// Bit mask of CHANNEL12 field.
	SPU_DPPI_PERM_CHANNEL12_Msk = 0x1000
	// Bit CHANNEL12.
	SPU_DPPI_PERM_CHANNEL12 = 0x1000
	// Channel12 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL12_Secure = 0x1
	// Channel12 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL12_NonSecure = 0x0
	// Position of CHANNEL13 field.
	SPU_DPPI_PERM_CHANNEL13_Pos = 0xd
	// Bit mask of CHANNEL13 field.
	SPU_DPPI_PERM_CHANNEL13_Msk = 0x2000
	// Bit CHANNEL13.
	SPU_DPPI_PERM_CHANNEL13 = 0x2000
	// Channel13 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL13_Secure = 0x1
	// Channel13 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL13_NonSecure = 0x0
	// Position of CHANNEL14 field.
	SPU_DPPI_PERM_CHANNEL14_Pos = 0xe
	// Bit mask of CHANNEL14 field.
	SPU_DPPI_PERM_CHANNEL14_Msk = 0x4000
	// Bit CHANNEL14.
	SPU_DPPI_PERM_CHANNEL14 = 0x4000
	// Channel14 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL14_Secure = 0x1
	// Channel14 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL14_NonSecure = 0x0
	// Position of CHANNEL15 field.
	SPU_DPPI_PERM_CHANNEL15_Pos = 0xf
	// Bit mask of CHANNEL15 field.
	SPU_DPPI_PERM_CHANNEL15_Msk = 0x8000
	// Bit CHANNEL15.
	SPU_DPPI_PERM_CHANNEL15 = 0x8000
	// Channel15 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL15_Secure = 0x1
	// Channel15 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL15_NonSecure = 0x0
	// Position of CHANNEL16 field.
	SPU_DPPI_PERM_CHANNEL16_Pos = 0x10
	// Bit mask of CHANNEL16 field.
	SPU_DPPI_PERM_CHANNEL16_Msk = 0x10000
	// Bit CHANNEL16.
	SPU_DPPI_PERM_CHANNEL16 = 0x10000
	// Channel16 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL16_Secure = 0x1
	// Channel16 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL16_NonSecure = 0x0
	// Position of CHANNEL17 field.
	SPU_DPPI_PERM_CHANNEL17_Pos = 0x11
	// Bit mask of CHANNEL17 field.
	SPU_DPPI_PERM_CHANNEL17_Msk = 0x20000
	// Bit CHANNEL17.
	SPU_DPPI_PERM_CHANNEL17 = 0x20000
	// Channel17 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL17_Secure = 0x1
	// Channel17 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL17_NonSecure = 0x0
	// Position of CHANNEL18 field.
	SPU_DPPI_PERM_CHANNEL18_Pos = 0x12
	// Bit mask of CHANNEL18 field.
	SPU_DPPI_PERM_CHANNEL18_Msk = 0x40000
	// Bit CHANNEL18.
	SPU_DPPI_PERM_CHANNEL18 = 0x40000
	// Channel18 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL18_Secure = 0x1
	// Channel18 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL18_NonSecure = 0x0
	// Position of CHANNEL19 field.
	SPU_DPPI_PERM_CHANNEL19_Pos = 0x13
	// Bit mask of CHANNEL19 field.
	SPU_DPPI_PERM_CHANNEL19_Msk = 0x80000
	// Bit CHANNEL19.
	SPU_DPPI_PERM_CHANNEL19 = 0x80000
	// Channel19 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL19_Secure = 0x1
	// Channel19 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL19_NonSecure = 0x0
	// Position of CHANNEL20 field.
	SPU_DPPI_PERM_CHANNEL20_Pos = 0x14
	// Bit mask of CHANNEL20 field.
	SPU_DPPI_PERM_CHANNEL20_Msk = 0x100000
	// Bit CHANNEL20.
	SPU_DPPI_PERM_CHANNEL20 = 0x100000
	// Channel20 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL20_Secure = 0x1
	// Channel20 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL20_NonSecure = 0x0
	// Position of CHANNEL21 field.
	SPU_DPPI_PERM_CHANNEL21_Pos = 0x15
	// Bit mask of CHANNEL21 field.
	SPU_DPPI_PERM_CHANNEL21_Msk = 0x200000
	// Bit CHANNEL21.
	SPU_DPPI_PERM_CHANNEL21 = 0x200000
	// Channel21 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL21_Secure = 0x1
	// Channel21 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL21_NonSecure = 0x0
	// Position of CHANNEL22 field.
	SPU_DPPI_PERM_CHANNEL22_Pos = 0x16
	// Bit mask of CHANNEL22 field.
	SPU_DPPI_PERM_CHANNEL22_Msk = 0x400000
	// Bit CHANNEL22.
	SPU_DPPI_PERM_CHANNEL22 = 0x400000
	// Channel22 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL22_Secure = 0x1
	// Channel22 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL22_NonSecure = 0x0
	// Position of CHANNEL23 field.
	SPU_DPPI_PERM_CHANNEL23_Pos = 0x17
	// Bit mask of CHANNEL23 field.
	SPU_DPPI_PERM_CHANNEL23_Msk = 0x800000
	// Bit CHANNEL23.
	SPU_DPPI_PERM_CHANNEL23 = 0x800000
	// Channel23 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL23_Secure = 0x1
	// Channel23 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL23_NonSecure = 0x0
	// Position of CHANNEL24 field.
	SPU_DPPI_PERM_CHANNEL24_Pos = 0x18
	// Bit mask of CHANNEL24 field.
	SPU_DPPI_PERM_CHANNEL24_Msk = 0x1000000
	// Bit CHANNEL24.
	SPU_DPPI_PERM_CHANNEL24 = 0x1000000
	// Channel24 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL24_Secure = 0x1
	// Channel24 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL24_NonSecure = 0x0
	// Position of CHANNEL25 field.
	SPU_DPPI_PERM_CHANNEL25_Pos = 0x19
	// Bit mask of CHANNEL25 field.
	SPU_DPPI_PERM_CHANNEL25_Msk = 0x2000000
	// Bit CHANNEL25.
	SPU_DPPI_PERM_CHANNEL25 = 0x2000000
	// Channel25 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL25_Secure = 0x1
	// Channel25 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL25_NonSecure = 0x0
	// Position of CHANNEL26 field.
	SPU_DPPI_PERM_CHANNEL26_Pos = 0x1a
	// Bit mask of CHANNEL26 field.
	SPU_DPPI_PERM_CHANNEL26_Msk = 0x4000000
	// Bit CHANNEL26.
	SPU_DPPI_PERM_CHANNEL26 = 0x4000000
	// Channel26 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL26_Secure = 0x1
	// Channel26 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL26_NonSecure = 0x0
	// Position of CHANNEL27 field.
	SPU_DPPI_PERM_CHANNEL27_Pos = 0x1b
	// Bit mask of CHANNEL27 field.
	SPU_DPPI_PERM_CHANNEL27_Msk = 0x8000000
	// Bit CHANNEL27.
	SPU_DPPI_PERM_CHANNEL27 = 0x8000000
	// Channel27 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL27_Secure = 0x1
	// Channel27 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL27_NonSecure = 0x0
	// Position of CHANNEL28 field.
	SPU_DPPI_PERM_CHANNEL28_Pos = 0x1c
	// Bit mask of CHANNEL28 field.
	SPU_DPPI_PERM_CHANNEL28_Msk = 0x10000000
	// Bit CHANNEL28.
	SPU_DPPI_PERM_CHANNEL28 = 0x10000000
	// Channel28 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL28_Secure = 0x1
	// Channel28 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL28_NonSecure = 0x0
	// Position of CHANNEL29 field.
	SPU_DPPI_PERM_CHANNEL29_Pos = 0x1d
	// Bit mask of CHANNEL29 field.
	SPU_DPPI_PERM_CHANNEL29_Msk = 0x20000000
	// Bit CHANNEL29.
	SPU_DPPI_PERM_CHANNEL29 = 0x20000000
	// Channel29 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL29_Secure = 0x1
	// Channel29 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL29_NonSecure = 0x0
	// Position of CHANNEL30 field.
	SPU_DPPI_PERM_CHANNEL30_Pos = 0x1e
	// Bit mask of CHANNEL30 field.
	SPU_DPPI_PERM_CHANNEL30_Msk = 0x40000000
	// Bit CHANNEL30.
	SPU_DPPI_PERM_CHANNEL30 = 0x40000000
	// Channel30 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL30_Secure = 0x1
	// Channel30 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL30_NonSecure = 0x0
	// Position of CHANNEL31 field.
	SPU_DPPI_PERM_CHANNEL31_Pos = 0x1f
	// Bit mask of CHANNEL31 field.
	SPU_DPPI_PERM_CHANNEL31_Msk = 0x80000000
	// Bit CHANNEL31.
	SPU_DPPI_PERM_CHANNEL31 = 0x80000000
	// Channel31 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL31_Secure = 0x1
	// Channel31 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL31_NonSecure = 0x0

	// DPPI.LOCK: Description cluster: Prevent further modification of the corresponding PERM register
	// Position of LOCK field.
	SPU_DPPI_LOCK_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	SPU_DPPI_LOCK_LOCK_Msk = 0x1
	// Bit LOCK.
	SPU_DPPI_LOCK_LOCK = 0x1
	// DPPI[n].PERM register can't be changed until next reset
	SPU_DPPI_LOCK_LOCK_Locked = 0x1
	// DPPI[n].PERM register content can be changed
	SPU_DPPI_LOCK_LOCK_Unlocked = 0x0

	// GPIOPORT.PERM: Description cluster: Select between secure and non-secure attribute for pins 0 to 31 of port n.
	// Position of PIN0 field.
	SPU_GPIOPORT_PERM_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	SPU_GPIOPORT_PERM_PIN0_Msk = 0x1
	// Bit PIN0.
	SPU_GPIOPORT_PERM_PIN0 = 0x1
	// Pin 0 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN0_Secure = 0x1
	// Pin 0 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN0_NonSecure = 0x0
	// Position of PIN1 field.
	SPU_GPIOPORT_PERM_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	SPU_GPIOPORT_PERM_PIN1_Msk = 0x2
	// Bit PIN1.
	SPU_GPIOPORT_PERM_PIN1 = 0x2
	// Pin 1 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN1_Secure = 0x1
	// Pin 1 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN1_NonSecure = 0x0
	// Position of PIN2 field.
	SPU_GPIOPORT_PERM_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	SPU_GPIOPORT_PERM_PIN2_Msk = 0x4
	// Bit PIN2.
	SPU_GPIOPORT_PERM_PIN2 = 0x4
	// Pin 2 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN2_Secure = 0x1
	// Pin 2 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN2_NonSecure = 0x0
	// Position of PIN3 field.
	SPU_GPIOPORT_PERM_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	SPU_GPIOPORT_PERM_PIN3_Msk = 0x8
	// Bit PIN3.
	SPU_GPIOPORT_PERM_PIN3 = 0x8
	// Pin 3 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN3_Secure = 0x1
	// Pin 3 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN3_NonSecure = 0x0
	// Position of PIN4 field.
	SPU_GPIOPORT_PERM_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	SPU_GPIOPORT_PERM_PIN4_Msk = 0x10
	// Bit PIN4.
	SPU_GPIOPORT_PERM_PIN4 = 0x10
	// Pin 4 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN4_Secure = 0x1
	// Pin 4 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN4_NonSecure = 0x0
	// Position of PIN5 field.
	SPU_GPIOPORT_PERM_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	SPU_GPIOPORT_PERM_PIN5_Msk = 0x20
	// Bit PIN5.
	SPU_GPIOPORT_PERM_PIN5 = 0x20
	// Pin 5 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN5_Secure = 0x1
	// Pin 5 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN5_NonSecure = 0x0
	// Position of PIN6 field.
	SPU_GPIOPORT_PERM_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	SPU_GPIOPORT_PERM_PIN6_Msk = 0x40
	// Bit PIN6.
	SPU_GPIOPORT_PERM_PIN6 = 0x40
	// Pin 6 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN6_Secure = 0x1
	// Pin 6 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN6_NonSecure = 0x0
	// Position of PIN7 field.
	SPU_GPIOPORT_PERM_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	SPU_GPIOPORT_PERM_PIN7_Msk = 0x80
	// Bit PIN7.
	SPU_GPIOPORT_PERM_PIN7 = 0x80
	// Pin 7 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN7_Secure = 0x1
	// Pin 7 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN7_NonSecure = 0x0
	// Position of PIN8 field.
	SPU_GPIOPORT_PERM_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	SPU_GPIOPORT_PERM_PIN8_Msk = 0x100
	// Bit PIN8.
	SPU_GPIOPORT_PERM_PIN8 = 0x100
	// Pin 8 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN8_Secure = 0x1
	// Pin 8 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN8_NonSecure = 0x0
	// Position of PIN9 field.
	SPU_GPIOPORT_PERM_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	SPU_GPIOPORT_PERM_PIN9_Msk = 0x200
	// Bit PIN9.
	SPU_GPIOPORT_PERM_PIN9 = 0x200
	// Pin 9 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN9_Secure = 0x1
	// Pin 9 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN9_NonSecure = 0x0
	// Position of PIN10 field.
	SPU_GPIOPORT_PERM_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	SPU_GPIOPORT_PERM_PIN10_Msk = 0x400
	// Bit PIN10.
	SPU_GPIOPORT_PERM_PIN10 = 0x400
	// Pin 10 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN10_Secure = 0x1
	// Pin 10 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN10_NonSecure = 0x0
	// Position of PIN11 field.
	SPU_GPIOPORT_PERM_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	SPU_GPIOPORT_PERM_PIN11_Msk = 0x800
	// Bit PIN11.
	SPU_GPIOPORT_PERM_PIN11 = 0x800
	// Pin 11 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN11_Secure = 0x1
	// Pin 11 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN11_NonSecure = 0x0
	// Position of PIN12 field.
	SPU_GPIOPORT_PERM_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	SPU_GPIOPORT_PERM_PIN12_Msk = 0x1000
	// Bit PIN12.
	SPU_GPIOPORT_PERM_PIN12 = 0x1000
	// Pin 12 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN12_Secure = 0x1
	// Pin 12 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN12_NonSecure = 0x0
	// Position of PIN13 field.
	SPU_GPIOPORT_PERM_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	SPU_GPIOPORT_PERM_PIN13_Msk = 0x2000
	// Bit PIN13.
	SPU_GPIOPORT_PERM_PIN13 = 0x2000
	// Pin 13 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN13_Secure = 0x1
	// Pin 13 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN13_NonSecure = 0x0
	// Position of PIN14 field.
	SPU_GPIOPORT_PERM_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	SPU_GPIOPORT_PERM_PIN14_Msk = 0x4000
	// Bit PIN14.
	SPU_GPIOPORT_PERM_PIN14 = 0x4000
	// Pin 14 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN14_Secure = 0x1
	// Pin 14 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN14_NonSecure = 0x0
	// Position of PIN15 field.
	SPU_GPIOPORT_PERM_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	SPU_GPIOPORT_PERM_PIN15_Msk = 0x8000
	// Bit PIN15.
	SPU_GPIOPORT_PERM_PIN15 = 0x8000
	// Pin 15 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN15_Secure = 0x1
	// Pin 15 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN15_NonSecure = 0x0
	// Position of PIN16 field.
	SPU_GPIOPORT_PERM_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	SPU_GPIOPORT_PERM_PIN16_Msk = 0x10000
	// Bit PIN16.
	SPU_GPIOPORT_PERM_PIN16 = 0x10000
	// Pin 16 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN16_Secure = 0x1
	// Pin 16 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN16_NonSecure = 0x0
	// Position of PIN17 field.
	SPU_GPIOPORT_PERM_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	SPU_GPIOPORT_PERM_PIN17_Msk = 0x20000
	// Bit PIN17.
	SPU_GPIOPORT_PERM_PIN17 = 0x20000
	// Pin 17 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN17_Secure = 0x1
	// Pin 17 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN17_NonSecure = 0x0
	// Position of PIN18 field.
	SPU_GPIOPORT_PERM_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	SPU_GPIOPORT_PERM_PIN18_Msk = 0x40000
	// Bit PIN18.
	SPU_GPIOPORT_PERM_PIN18 = 0x40000
	// Pin 18 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN18_Secure = 0x1
	// Pin 18 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN18_NonSecure = 0x0
	// Position of PIN19 field.
	SPU_GPIOPORT_PERM_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	SPU_GPIOPORT_PERM_PIN19_Msk = 0x80000
	// Bit PIN19.
	SPU_GPIOPORT_PERM_PIN19 = 0x80000
	// Pin 19 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN19_Secure = 0x1
	// Pin 19 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN19_NonSecure = 0x0
	// Position of PIN20 field.
	SPU_GPIOPORT_PERM_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	SPU_GPIOPORT_PERM_PIN20_Msk = 0x100000
	// Bit PIN20.
	SPU_GPIOPORT_PERM_PIN20 = 0x100000
	// Pin 20 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN20_Secure = 0x1
	// Pin 20 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN20_NonSecure = 0x0
	// Position of PIN21 field.
	SPU_GPIOPORT_PERM_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	SPU_GPIOPORT_PERM_PIN21_Msk = 0x200000
	// Bit PIN21.
	SPU_GPIOPORT_PERM_PIN21 = 0x200000
	// Pin 21 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN21_Secure = 0x1
	// Pin 21 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN21_NonSecure = 0x0
	// Position of PIN22 field.
	SPU_GPIOPORT_PERM_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	SPU_GPIOPORT_PERM_PIN22_Msk = 0x400000
	// Bit PIN22.
	SPU_GPIOPORT_PERM_PIN22 = 0x400000
	// Pin 22 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN22_Secure = 0x1
	// Pin 22 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN22_NonSecure = 0x0
	// Position of PIN23 field.
	SPU_GPIOPORT_PERM_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	SPU_GPIOPORT_PERM_PIN23_Msk = 0x800000
	// Bit PIN23.
	SPU_GPIOPORT_PERM_PIN23 = 0x800000
	// Pin 23 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN23_Secure = 0x1
	// Pin 23 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN23_NonSecure = 0x0
	// Position of PIN24 field.
	SPU_GPIOPORT_PERM_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	SPU_GPIOPORT_PERM_PIN24_Msk = 0x1000000
	// Bit PIN24.
	SPU_GPIOPORT_PERM_PIN24 = 0x1000000
	// Pin 24 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN24_Secure = 0x1
	// Pin 24 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN24_NonSecure = 0x0
	// Position of PIN25 field.
	SPU_GPIOPORT_PERM_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	SPU_GPIOPORT_PERM_PIN25_Msk = 0x2000000
	// Bit PIN25.
	SPU_GPIOPORT_PERM_PIN25 = 0x2000000
	// Pin 25 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN25_Secure = 0x1
	// Pin 25 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN25_NonSecure = 0x0
	// Position of PIN26 field.
	SPU_GPIOPORT_PERM_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	SPU_GPIOPORT_PERM_PIN26_Msk = 0x4000000
	// Bit PIN26.
	SPU_GPIOPORT_PERM_PIN26 = 0x4000000
	// Pin 26 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN26_Secure = 0x1
	// Pin 26 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN26_NonSecure = 0x0
	// Position of PIN27 field.
	SPU_GPIOPORT_PERM_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	SPU_GPIOPORT_PERM_PIN27_Msk = 0x8000000
	// Bit PIN27.
	SPU_GPIOPORT_PERM_PIN27 = 0x8000000
	// Pin 27 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN27_Secure = 0x1
	// Pin 27 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN27_NonSecure = 0x0
	// Position of PIN28 field.
	SPU_GPIOPORT_PERM_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	SPU_GPIOPORT_PERM_PIN28_Msk = 0x10000000
	// Bit PIN28.
	SPU_GPIOPORT_PERM_PIN28 = 0x10000000
	// Pin 28 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN28_Secure = 0x1
	// Pin 28 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN28_NonSecure = 0x0
	// Position of PIN29 field.
	SPU_GPIOPORT_PERM_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	SPU_GPIOPORT_PERM_PIN29_Msk = 0x20000000
	// Bit PIN29.
	SPU_GPIOPORT_PERM_PIN29 = 0x20000000
	// Pin 29 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN29_Secure = 0x1
	// Pin 29 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN29_NonSecure = 0x0
	// Position of PIN30 field.
	SPU_GPIOPORT_PERM_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	SPU_GPIOPORT_PERM_PIN30_Msk = 0x40000000
	// Bit PIN30.
	SPU_GPIOPORT_PERM_PIN30 = 0x40000000
	// Pin 30 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN30_Secure = 0x1
	// Pin 30 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN30_NonSecure = 0x0
	// Position of PIN31 field.
	SPU_GPIOPORT_PERM_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	SPU_GPIOPORT_PERM_PIN31_Msk = 0x80000000
	// Bit PIN31.
	SPU_GPIOPORT_PERM_PIN31 = 0x80000000
	// Pin 31 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN31_Secure = 0x1
	// Pin 31 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN31_NonSecure = 0x0

	// GPIOPORT.LOCK: Description cluster: Prevent further modification of the corresponding PERM register
	// Position of LOCK field.
	SPU_GPIOPORT_LOCK_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	SPU_GPIOPORT_LOCK_LOCK_Msk = 0x1
	// Bit LOCK.
	SPU_GPIOPORT_LOCK_LOCK = 0x1
	// GPIOPORT[n].PERM register can't be changed until next reset
	SPU_GPIOPORT_LOCK_LOCK_Locked = 0x1
	// GPIOPORT[n].PERM register content can be changed
	SPU_GPIOPORT_LOCK_LOCK_Unlocked = 0x0

	// FLASHNSC.REGION: Description cluster: Define which flash region can contain the non-secure callable (NSC) region n
	// Position of REGION field.
	SPU_FLASHNSC_REGION_REGION_Pos = 0x0
	// Bit mask of REGION field.
	SPU_FLASHNSC_REGION_REGION_Msk = 0x3f
	// Position of LOCK field.
	SPU_FLASHNSC_REGION_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	SPU_FLASHNSC_REGION_LOCK_Msk = 0x100
	// Bit LOCK.
	SPU_FLASHNSC_REGION_LOCK = 0x100
	// This register can be updated
	SPU_FLASHNSC_REGION_LOCK_Unlocked = 0x0
	// The content of this register can't be changed until the next reset
	SPU_FLASHNSC_REGION_LOCK_Locked = 0x1

	// FLASHNSC.SIZE: Description cluster: Define the size of the non-secure callable (NSC) region n
	// Position of SIZE field.
	SPU_FLASHNSC_SIZE_SIZE_Pos = 0x0
	// Bit mask of SIZE field.
	SPU_FLASHNSC_SIZE_SIZE_Msk = 0xf
	// The region n is not defined as a non-secure callable region. Normal security attributes (secure or non-secure) are enforced.
	SPU_FLASHNSC_SIZE_SIZE_Disabled = 0x0
	// The region n is defined as non-secure callable with a 32-byte size
	SPU_FLASHNSC_SIZE_SIZE_32 = 0x1
	// The region n is defined as non-secure callable with a 64-byte size
	SPU_FLASHNSC_SIZE_SIZE_64 = 0x2
	// The region n is defined as non-secure callable with a 128-byte size
	SPU_FLASHNSC_SIZE_SIZE_128 = 0x3
	// The region n is defined as non-secure callable with a 256-byte size
	SPU_FLASHNSC_SIZE_SIZE_256 = 0x4
	// The region n is defined as non-secure callable with a 512-byte size
	SPU_FLASHNSC_SIZE_SIZE_512 = 0x5
	// The region n is defined as non-secure callable with a 1024-byte size
	SPU_FLASHNSC_SIZE_SIZE_1024 = 0x6
	// The region n is defined as non-secure callable with a 2048-byte size
	SPU_FLASHNSC_SIZE_SIZE_2048 = 0x7
	// The region n is defined as non-secure callable with a 4096-byte size
	SPU_FLASHNSC_SIZE_SIZE_4096 = 0x8
	// Position of LOCK field.
	SPU_FLASHNSC_SIZE_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	SPU_FLASHNSC_SIZE_LOCK_Msk = 0x100
	// Bit LOCK.
	SPU_FLASHNSC_SIZE_LOCK = 0x100
	// This register can be updated
	SPU_FLASHNSC_SIZE_LOCK_Unlocked = 0x0
	// The content of this register can't be changed until the next reset
	SPU_FLASHNSC_SIZE_LOCK_Locked = 0x1

	// RAMNSC.REGION: Description cluster: Define which RAM region can contain the non-secure callable (NSC) region n
	// Position of REGION field.
	SPU_RAMNSC_REGION_REGION_Pos = 0x0
	// Bit mask of REGION field.
	SPU_RAMNSC_REGION_REGION_Msk = 0x3f
	// Position of LOCK field.
	SPU_RAMNSC_REGION_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	SPU_RAMNSC_REGION_LOCK_Msk = 0x100
	// Bit LOCK.
	SPU_RAMNSC_REGION_LOCK = 0x100
	// This register can be updated
	SPU_RAMNSC_REGION_LOCK_Unlocked = 0x0
	// The content of this register can't be changed until the next reset
	SPU_RAMNSC_REGION_LOCK_Locked = 0x1

	// RAMNSC.SIZE: Description cluster: Define the size of the non-secure callable (NSC) region n
	// Position of SIZE field.
	SPU_RAMNSC_SIZE_SIZE_Pos = 0x0
	// Bit mask of SIZE field.
	SPU_RAMNSC_SIZE_SIZE_Msk = 0xf
	// The region n is not defined as a non-secure callable region. Normal security attributes (secure or non-secure) are enforced.
	SPU_RAMNSC_SIZE_SIZE_Disabled = 0x0
	// The region n is defined as non-secure callable with a 32-byte size
	SPU_RAMNSC_SIZE_SIZE_32 = 0x1
	// The region n is defined as non-secure callable with a 64-byte size
	SPU_RAMNSC_SIZE_SIZE_64 = 0x2
	// The region n is defined as non-secure callable with a 128-byte size
	SPU_RAMNSC_SIZE_SIZE_128 = 0x3
	// The region n is defined as non-secure callable with a 256-byte size
	SPU_RAMNSC_SIZE_SIZE_256 = 0x4
	// The region n is defined as non-secure callable with a 512-byte size
	SPU_RAMNSC_SIZE_SIZE_512 = 0x5
	// The region n is defined as non-secure callable with a 1024-byte size
	SPU_RAMNSC_SIZE_SIZE_1024 = 0x6
	// The region n is defined as non-secure callable with a 2048-byte size
	SPU_RAMNSC_SIZE_SIZE_2048 = 0x7
	// The region n is defined as non-secure callable with a 4096-byte size
	SPU_RAMNSC_SIZE_SIZE_4096 = 0x8
	// Position of LOCK field.
	SPU_RAMNSC_SIZE_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	SPU_RAMNSC_SIZE_LOCK_Msk = 0x100
	// Bit LOCK.
	SPU_RAMNSC_SIZE_LOCK = 0x100
	// This register can be updated
	SPU_RAMNSC_SIZE_LOCK_Unlocked = 0x0
	// The content of this register can't be changed until the next reset
	SPU_RAMNSC_SIZE_LOCK_Locked = 0x1

	// FLASHREGION.PERM: Description cluster: Access permissions for flash region n
	// Position of EXECUTE field.
	SPU_FLASHREGION_PERM_EXECUTE_Pos = 0x0
	// Bit mask of EXECUTE field.
	SPU_FLASHREGION_PERM_EXECUTE_Msk = 0x1
	// Bit EXECUTE.
	SPU_FLASHREGION_PERM_EXECUTE = 0x1
	// Allow instruction fetches from flash region n
	SPU_FLASHREGION_PERM_EXECUTE_Enable = 0x1
	// Block instruction fetches from flash region n
	SPU_FLASHREGION_PERM_EXECUTE_Disable = 0x0
	// Position of WRITE field.
	SPU_FLASHREGION_PERM_WRITE_Pos = 0x1
	// Bit mask of WRITE field.
	SPU_FLASHREGION_PERM_WRITE_Msk = 0x2
	// Bit WRITE.
	SPU_FLASHREGION_PERM_WRITE = 0x2
	// Allow write operation to region n
	SPU_FLASHREGION_PERM_WRITE_Enable = 0x1
	// Block write operation to region n
	SPU_FLASHREGION_PERM_WRITE_Disable = 0x0
	// Position of READ field.
	SPU_FLASHREGION_PERM_READ_Pos = 0x2
	// Bit mask of READ field.
	SPU_FLASHREGION_PERM_READ_Msk = 0x4
	// Bit READ.
	SPU_FLASHREGION_PERM_READ = 0x4
	// Allow read operation from flash region n
	SPU_FLASHREGION_PERM_READ_Enable = 0x1
	// Block read operation from flash region n
	SPU_FLASHREGION_PERM_READ_Disable = 0x0
	// Position of SECATTR field.
	SPU_FLASHREGION_PERM_SECATTR_Pos = 0x4
	// Bit mask of SECATTR field.
	SPU_FLASHREGION_PERM_SECATTR_Msk = 0x10
	// Bit SECATTR.
	SPU_FLASHREGION_PERM_SECATTR = 0x10
	// Flash region n security attribute is non-secure
	SPU_FLASHREGION_PERM_SECATTR_Non_Secure = 0x0
	// Flash region n security attribute is secure
	SPU_FLASHREGION_PERM_SECATTR_Secure = 0x1
	// Position of LOCK field.
	SPU_FLASHREGION_PERM_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	SPU_FLASHREGION_PERM_LOCK_Msk = 0x100
	// Bit LOCK.
	SPU_FLASHREGION_PERM_LOCK = 0x100
	// This register can be updated
	SPU_FLASHREGION_PERM_LOCK_Unlocked = 0x0
	// The content of this register can't be changed until the next reset
	SPU_FLASHREGION_PERM_LOCK_Locked = 0x1

	// RAMREGION.PERM: Description cluster: Access permissions for RAM region n
	// Position of EXECUTE field.
	SPU_RAMREGION_PERM_EXECUTE_Pos = 0x0
	// Bit mask of EXECUTE field.
	SPU_RAMREGION_PERM_EXECUTE_Msk = 0x1
	// Bit EXECUTE.
	SPU_RAMREGION_PERM_EXECUTE = 0x1
	// Allow instruction fetches from RAM region n
	SPU_RAMREGION_PERM_EXECUTE_Enable = 0x1
	// Block instruction fetches from RAM region n
	SPU_RAMREGION_PERM_EXECUTE_Disable = 0x0
	// Position of WRITE field.
	SPU_RAMREGION_PERM_WRITE_Pos = 0x1
	// Bit mask of WRITE field.
	SPU_RAMREGION_PERM_WRITE_Msk = 0x2
	// Bit WRITE.
	SPU_RAMREGION_PERM_WRITE = 0x2
	// Allow write operation to RAM region n
	SPU_RAMREGION_PERM_WRITE_Enable = 0x1
	// Block write operation to RAM region n
	SPU_RAMREGION_PERM_WRITE_Disable = 0x0
	// Position of READ field.
	SPU_RAMREGION_PERM_READ_Pos = 0x2
	// Bit mask of READ field.
	SPU_RAMREGION_PERM_READ_Msk = 0x4
	// Bit READ.
	SPU_RAMREGION_PERM_READ = 0x4
	// Allow read operation from RAM region n
	SPU_RAMREGION_PERM_READ_Enable = 0x1
	// Block read operation from RAM region n
	SPU_RAMREGION_PERM_READ_Disable = 0x0
	// Position of SECATTR field.
	SPU_RAMREGION_PERM_SECATTR_Pos = 0x4
	// Bit mask of SECATTR field.
	SPU_RAMREGION_PERM_SECATTR_Msk = 0x10
	// Bit SECATTR.
	SPU_RAMREGION_PERM_SECATTR = 0x10
	// RAM region n security attribute is non-secure
	SPU_RAMREGION_PERM_SECATTR_Non_Secure = 0x0
	// RAM region n security attribute is secure
	SPU_RAMREGION_PERM_SECATTR_Secure = 0x1
	// Position of LOCK field.
	SPU_RAMREGION_PERM_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	SPU_RAMREGION_PERM_LOCK_Msk = 0x100
	// Bit LOCK.
	SPU_RAMREGION_PERM_LOCK = 0x100
	// This register can be updated
	SPU_RAMREGION_PERM_LOCK_Unlocked = 0x0
	// The content of this register can't be changed until the next reset
	SPU_RAMREGION_PERM_LOCK_Locked = 0x1

	// PERIPHID.PERM: Description cluster: List capabilities and access permissions for the peripheral with ID n
	// Position of SECUREMAPPING field.
	SPU_PERIPHID_PERM_SECUREMAPPING_Pos = 0x0
	// Bit mask of SECUREMAPPING field.
	SPU_PERIPHID_PERM_SECUREMAPPING_Msk = 0x3
	// This peripheral is always accessible as a non-secure peripheral
	SPU_PERIPHID_PERM_SECUREMAPPING_NonSecure = 0x0
	// This peripheral is always accessible as a secure peripheral
	SPU_PERIPHID_PERM_SECUREMAPPING_Secure = 0x1
	// Non-secure or secure attribute for this peripheral is defined by the PERIPHID[n].PERM register
	SPU_PERIPHID_PERM_SECUREMAPPING_UserSelectable = 0x2
	// This peripheral implements the split security mechanism. Non-secure or secure attribute for this peripheral is defined by the PERIPHID[n].PERM register.
	SPU_PERIPHID_PERM_SECUREMAPPING_Split = 0x3
	// Position of DMA field.
	SPU_PERIPHID_PERM_DMA_Pos = 0x2
	// Bit mask of DMA field.
	SPU_PERIPHID_PERM_DMA_Msk = 0xc
	// Peripheral has no DMA capability
	SPU_PERIPHID_PERM_DMA_NoDMA = 0x0
	// Peripheral has DMA and DMA transfers always have the same security attribute as assigned to the peripheral
	SPU_PERIPHID_PERM_DMA_NoSeparateAttribute = 0x1
	// Peripheral has DMA and DMA transfers can have a different security attribute than the one assigned to the peripheral
	SPU_PERIPHID_PERM_DMA_SeparateAttribute = 0x2
	// Position of SECATTR field.
	SPU_PERIPHID_PERM_SECATTR_Pos = 0x4
	// Bit mask of SECATTR field.
	SPU_PERIPHID_PERM_SECATTR_Msk = 0x10
	// Bit SECATTR.
	SPU_PERIPHID_PERM_SECATTR = 0x10
	// Peripheral is mapped in secure peripheral address space
	SPU_PERIPHID_PERM_SECATTR_Secure = 0x1
	// If SECUREMAPPING == UserSelectable: Peripheral is mapped in non-secure peripheral address space. If SECUREMAPPING == Split: Peripheral is mapped in non-secure and secure peripheral address space.
	SPU_PERIPHID_PERM_SECATTR_NonSecure = 0x0
	// Position of DMASEC field.
	SPU_PERIPHID_PERM_DMASEC_Pos = 0x5
	// Bit mask of DMASEC field.
	SPU_PERIPHID_PERM_DMASEC_Msk = 0x20
	// Bit DMASEC.
	SPU_PERIPHID_PERM_DMASEC = 0x20
	// DMA transfers initiated by this peripheral have the secure attribute set
	SPU_PERIPHID_PERM_DMASEC_Secure = 0x1
	// DMA transfers initiated by this peripheral have the non-secure attribute set
	SPU_PERIPHID_PERM_DMASEC_NonSecure = 0x0
	// Position of LOCK field.
	SPU_PERIPHID_PERM_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	SPU_PERIPHID_PERM_LOCK_Msk = 0x100
	// Bit LOCK.
	SPU_PERIPHID_PERM_LOCK = 0x100
	// This register can be updated
	SPU_PERIPHID_PERM_LOCK_Unlocked = 0x0
	// The content of this register can't be changed until the next reset
	SPU_PERIPHID_PERM_LOCK_Locked = 0x1
	// Position of PRESENT field.
	SPU_PERIPHID_PERM_PRESENT_Pos = 0x1f
	// Bit mask of PRESENT field.
	SPU_PERIPHID_PERM_PRESENT_Msk = 0x80000000
	// Bit PRESENT.
	SPU_PERIPHID_PERM_PRESENT = 0x80000000
	// Peripheral is not present
	SPU_PERIPHID_PERM_PRESENT_NotPresent = 0x0
	// Peripheral is present
	SPU_PERIPHID_PERM_PRESENT_IsPresent = 0x1
)

// Constants for OSCILLATORS_NS: Oscillator control 0
const (
	// XOSC32MCAPS: Programmable capacitance of XC1 and XC2
	// Position of CAPVALUE field.
	OSCILLATORS_XOSC32MCAPS_CAPVALUE_Pos = 0x0
	// Bit mask of CAPVALUE field.
	OSCILLATORS_XOSC32MCAPS_CAPVALUE_Msk = 0x1f
	// Position of ENABLE field.
	OSCILLATORS_XOSC32MCAPS_ENABLE_Pos = 0x8
	// Bit mask of ENABLE field.
	OSCILLATORS_XOSC32MCAPS_ENABLE_Msk = 0x100
	// Bit ENABLE.
	OSCILLATORS_XOSC32MCAPS_ENABLE = 0x100
	// Capacitor disabled (use external caps)
	OSCILLATORS_XOSC32MCAPS_ENABLE_Disabled = 0x0
	// Capacitor enabled
	OSCILLATORS_XOSC32MCAPS_ENABLE_Enabled = 0x1

	// XOSC32KI.BYPASS: Enable or disable bypass of LFCLK crystal oscillator with external clock source
	// Position of BYPASS field.
	OSCILLATORS_XOSC32KI_BYPASS_BYPASS_Pos = 0x0
	// Bit mask of BYPASS field.
	OSCILLATORS_XOSC32KI_BYPASS_BYPASS_Msk = 0x1
	// Bit BYPASS.
	OSCILLATORS_XOSC32KI_BYPASS_BYPASS = 0x1
	// Disable (use with crystal or low-swing external source)
	OSCILLATORS_XOSC32KI_BYPASS_BYPASS_Disabled = 0x0
	// Enable (use with rail-to-rail external source)
	OSCILLATORS_XOSC32KI_BYPASS_BYPASS_Enabled = 0x1

	// XOSC32KI.INTCAP: Control usage of internal load capacitors
	// Position of INTCAP field.
	OSCILLATORS_XOSC32KI_INTCAP_INTCAP_Pos = 0x0
	// Bit mask of INTCAP field.
	OSCILLATORS_XOSC32KI_INTCAP_INTCAP_Msk = 0x3
	// Use external load capacitors
	OSCILLATORS_XOSC32KI_INTCAP_INTCAP_External = 0x0
	// 6 pF internal load capacitance
	OSCILLATORS_XOSC32KI_INTCAP_INTCAP_C6PF = 0x1
	// 7 pF internal load capacitance
	OSCILLATORS_XOSC32KI_INTCAP_INTCAP_C7PF = 0x2
	// 11 pF internal load capacitance
	OSCILLATORS_XOSC32KI_INTCAP_INTCAP_C11PF = 0x3
)

// Constants for REGULATORS_NS: Voltage regulators 0
const (
	// MAINREGSTATUS: Main supply status
	// Position of VREGH field.
	REGULATORS_MAINREGSTATUS_VREGH_Pos = 0x0
	// Bit mask of VREGH field.
	REGULATORS_MAINREGSTATUS_VREGH_Msk = 0x1
	// Bit VREGH.
	REGULATORS_MAINREGSTATUS_VREGH = 0x1
	// Normal voltage mode. Voltage supplied on VDD and VDDH.
	REGULATORS_MAINREGSTATUS_VREGH_Inactive = 0x0
	// High voltage mode. Voltage supplied on VDDH.
	REGULATORS_MAINREGSTATUS_VREGH_Active = 0x1

	// SYSTEMOFF: System OFF register
	// Position of SYSTEMOFF field.
	REGULATORS_SYSTEMOFF_SYSTEMOFF_Pos = 0x0
	// Bit mask of SYSTEMOFF field.
	REGULATORS_SYSTEMOFF_SYSTEMOFF_Msk = 0x1
	// Bit SYSTEMOFF.
	REGULATORS_SYSTEMOFF_SYSTEMOFF = 0x1
	// Enable System OFF mode
	REGULATORS_SYSTEMOFF_SYSTEMOFF_Enter = 0x1

	// POFCON: Power-fail comparator configuration
	// Position of POF field.
	REGULATORS_POFCON_POF_Pos = 0x0
	// Bit mask of POF field.
	REGULATORS_POFCON_POF_Msk = 0x1
	// Bit POF.
	REGULATORS_POFCON_POF = 0x1
	// Disable
	REGULATORS_POFCON_POF_Disabled = 0x0
	// Enable
	REGULATORS_POFCON_POF_Enabled = 0x1
	// Position of THRESHOLD field.
	REGULATORS_POFCON_THRESHOLD_Pos = 0x1
	// Bit mask of THRESHOLD field.
	REGULATORS_POFCON_THRESHOLD_Msk = 0x1e
	// Set threshold to 1.9 V
	REGULATORS_POFCON_THRESHOLD_V19 = 0x6
	// Set threshold to 2.0 V
	REGULATORS_POFCON_THRESHOLD_V20 = 0x7
	// Set threshold to 2.1 V
	REGULATORS_POFCON_THRESHOLD_V21 = 0x8
	// Set threshold to 2.2 V
	REGULATORS_POFCON_THRESHOLD_V22 = 0x9
	// Set threshold to 2.3 V
	REGULATORS_POFCON_THRESHOLD_V23 = 0xa
	// Set threshold to 2.4 V
	REGULATORS_POFCON_THRESHOLD_V24 = 0xb
	// Set threshold to 2.5 V
	REGULATORS_POFCON_THRESHOLD_V25 = 0xc
	// Set threshold to 2.6 V
	REGULATORS_POFCON_THRESHOLD_V26 = 0xd
	// Set threshold to 2.7 V
	REGULATORS_POFCON_THRESHOLD_V27 = 0xe
	// Set threshold to 2.8 V
	REGULATORS_POFCON_THRESHOLD_V28 = 0xf
	// Position of THRESHOLDVDDH field.
	REGULATORS_POFCON_THRESHOLDVDDH_Pos = 0x8
	// Bit mask of THRESHOLDVDDH field.
	REGULATORS_POFCON_THRESHOLDVDDH_Msk = 0xf00
	// Set threshold to 2.7 V
	REGULATORS_POFCON_THRESHOLDVDDH_V27 = 0x0
	// Set threshold to 2.8 V
	REGULATORS_POFCON_THRESHOLDVDDH_V28 = 0x1
	// Set threshold to 2.9 V
	REGULATORS_POFCON_THRESHOLDVDDH_V29 = 0x2
	// Set threshold to 3.0 V
	REGULATORS_POFCON_THRESHOLDVDDH_V30 = 0x3
	// Set threshold to 3.1 V
	REGULATORS_POFCON_THRESHOLDVDDH_V31 = 0x4
	// Set threshold to 3.2 V
	REGULATORS_POFCON_THRESHOLDVDDH_V32 = 0x5
	// Set threshold to 3.3 V
	REGULATORS_POFCON_THRESHOLDVDDH_V33 = 0x6
	// Set threshold to 3.4 V
	REGULATORS_POFCON_THRESHOLDVDDH_V34 = 0x7
	// Set threshold to 3.5 V
	REGULATORS_POFCON_THRESHOLDVDDH_V35 = 0x8
	// Set threshold to 3.6 V
	REGULATORS_POFCON_THRESHOLDVDDH_V36 = 0x9
	// Set threshold to 3.7 V
	REGULATORS_POFCON_THRESHOLDVDDH_V37 = 0xa
	// Set threshold to 3.8 V
	REGULATORS_POFCON_THRESHOLDVDDH_V38 = 0xb
	// Set threshold to 3.9 V
	REGULATORS_POFCON_THRESHOLDVDDH_V39 = 0xc
	// Set threshold to 4.0 V
	REGULATORS_POFCON_THRESHOLDVDDH_V40 = 0xd
	// Set threshold to 4.1 V
	REGULATORS_POFCON_THRESHOLDVDDH_V41 = 0xe
	// Set threshold to 4.2 V
	REGULATORS_POFCON_THRESHOLDVDDH_V42 = 0xf

	// VREGMAIN.DCDCEN: DC/DC enable register for VREGMAIN
	// Position of DCDCEN field.
	REGULATORS_VREGMAIN_DCDCEN_DCDCEN_Pos = 0x0
	// Bit mask of DCDCEN field.
	REGULATORS_VREGMAIN_DCDCEN_DCDCEN_Msk = 0x1
	// Bit DCDCEN.
	REGULATORS_VREGMAIN_DCDCEN_DCDCEN = 0x1
	// Disable
	REGULATORS_VREGMAIN_DCDCEN_DCDCEN_Disabled = 0x0
	// Enable
	REGULATORS_VREGMAIN_DCDCEN_DCDCEN_Enabled = 0x1

	// VREGRADIO.DCDCEN: DC/DC enable register for VREGRADIO
	// Position of DCDCEN field.
	REGULATORS_VREGRADIO_DCDCEN_DCDCEN_Pos = 0x0
	// Bit mask of DCDCEN field.
	REGULATORS_VREGRADIO_DCDCEN_DCDCEN_Msk = 0x1
	// Bit DCDCEN.
	REGULATORS_VREGRADIO_DCDCEN_DCDCEN = 0x1
	// Disable
	REGULATORS_VREGRADIO_DCDCEN_DCDCEN_Disabled = 0x0
	// Enable
	REGULATORS_VREGRADIO_DCDCEN_DCDCEN_Enabled = 0x1

	// VREGH.DCDCEN: DC/DC enable register for VREGH
	// Position of DCDCEN field.
	REGULATORS_VREGH_DCDCEN_DCDCEN_Pos = 0x0
	// Bit mask of DCDCEN field.
	REGULATORS_VREGH_DCDCEN_DCDCEN_Msk = 0x1
	// Bit DCDCEN.
	REGULATORS_VREGH_DCDCEN_DCDCEN = 0x1
	// Disable
	REGULATORS_VREGH_DCDCEN_DCDCEN_Disabled = 0x0
	// Enable
	REGULATORS_VREGH_DCDCEN_DCDCEN_Enabled = 0x1
)

// Constants for CLOCK_NS: Clock management 0
const (
	// TASKS_HFCLKSTART: Start HFCLK128M/HFCLK64M source as selected in HFCLKSRC
	// Position of TASKS_HFCLKSTART field.
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Pos = 0x0
	// Bit mask of TASKS_HFCLKSTART field.
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Msk = 0x1
	// Bit TASKS_HFCLKSTART.
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART = 0x1
	// Trigger task
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Trigger = 0x1

	// TASKS_HFCLKSTOP: Stop HFCLK128M/HFCLK64M source
	// Position of TASKS_HFCLKSTOP field.
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP_Pos = 0x0
	// Bit mask of TASKS_HFCLKSTOP field.
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP_Msk = 0x1
	// Bit TASKS_HFCLKSTOP.
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP = 0x1
	// Trigger task
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP_Trigger = 0x1

	// TASKS_LFCLKSTART: Start LFCLK source as selected in LFCLKSRC
	// Position of TASKS_LFCLKSTART field.
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART_Pos = 0x0
	// Bit mask of TASKS_LFCLKSTART field.
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART_Msk = 0x1
	// Bit TASKS_LFCLKSTART.
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART = 0x1
	// Trigger task
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART_Trigger = 0x1

	// TASKS_LFCLKSTOP: Stop LFCLK source
	// Position of TASKS_LFCLKSTOP field.
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP_Pos = 0x0
	// Bit mask of TASKS_LFCLKSTOP field.
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP_Msk = 0x1
	// Bit TASKS_LFCLKSTOP.
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP = 0x1
	// Trigger task
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP_Trigger = 0x1

	// TASKS_CAL: Start calibration of LFRC oscillator
	// Position of TASKS_CAL field.
	CLOCK_TASKS_CAL_TASKS_CAL_Pos = 0x0
	// Bit mask of TASKS_CAL field.
	CLOCK_TASKS_CAL_TASKS_CAL_Msk = 0x1
	// Bit TASKS_CAL.
	CLOCK_TASKS_CAL_TASKS_CAL = 0x1
	// Trigger task
	CLOCK_TASKS_CAL_TASKS_CAL_Trigger = 0x1

	// TASKS_HFCLKAUDIOSTART: Start HFCLKAUDIO source
	// Position of TASKS_HFCLKAUDIOSTART field.
	CLOCK_TASKS_HFCLKAUDIOSTART_TASKS_HFCLKAUDIOSTART_Pos = 0x0
	// Bit mask of TASKS_HFCLKAUDIOSTART field.
	CLOCK_TASKS_HFCLKAUDIOSTART_TASKS_HFCLKAUDIOSTART_Msk = 0x1
	// Bit TASKS_HFCLKAUDIOSTART.
	CLOCK_TASKS_HFCLKAUDIOSTART_TASKS_HFCLKAUDIOSTART = 0x1
	// Trigger task
	CLOCK_TASKS_HFCLKAUDIOSTART_TASKS_HFCLKAUDIOSTART_Trigger = 0x1

	// TASKS_HFCLKAUDIOSTOP: Stop HFCLKAUDIO source
	// Position of TASKS_HFCLKAUDIOSTOP field.
	CLOCK_TASKS_HFCLKAUDIOSTOP_TASKS_HFCLKAUDIOSTOP_Pos = 0x0
	// Bit mask of TASKS_HFCLKAUDIOSTOP field.
	CLOCK_TASKS_HFCLKAUDIOSTOP_TASKS_HFCLKAUDIOSTOP_Msk = 0x1
	// Bit TASKS_HFCLKAUDIOSTOP.
	CLOCK_TASKS_HFCLKAUDIOSTOP_TASKS_HFCLKAUDIOSTOP = 0x1
	// Trigger task
	CLOCK_TASKS_HFCLKAUDIOSTOP_TASKS_HFCLKAUDIOSTOP_Trigger = 0x1

	// TASKS_HFCLK192MSTART: Start HFCLK192M source as selected in HFCLK192MSRC
	// Position of TASKS_HFCLK192MSTART field.
	CLOCK_TASKS_HFCLK192MSTART_TASKS_HFCLK192MSTART_Pos = 0x0
	// Bit mask of TASKS_HFCLK192MSTART field.
	CLOCK_TASKS_HFCLK192MSTART_TASKS_HFCLK192MSTART_Msk = 0x1
	// Bit TASKS_HFCLK192MSTART.
	CLOCK_TASKS_HFCLK192MSTART_TASKS_HFCLK192MSTART = 0x1
	// Trigger task
	CLOCK_TASKS_HFCLK192MSTART_TASKS_HFCLK192MSTART_Trigger = 0x1

	// TASKS_HFCLK192MSTOP: Stop HFCLK192M source
	// Position of TASKS_HFCLK192MSTOP field.
	CLOCK_TASKS_HFCLK192MSTOP_TASKS_HFCLK192MSTOP_Pos = 0x0
	// Bit mask of TASKS_HFCLK192MSTOP field.
	CLOCK_TASKS_HFCLK192MSTOP_TASKS_HFCLK192MSTOP_Msk = 0x1
	// Bit TASKS_HFCLK192MSTOP.
	CLOCK_TASKS_HFCLK192MSTOP_TASKS_HFCLK192MSTOP = 0x1
	// Trigger task
	CLOCK_TASKS_HFCLK192MSTOP_TASKS_HFCLK192MSTOP_Trigger = 0x1

	// SUBSCRIBE_HFCLKSTART: Subscribe configuration for task HFCLKSTART
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKSTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKSTART_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_HFCLKSTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_HFCLKSTART_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_HFCLKSTART_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_HFCLKSTART_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_HFCLKSTART_EN_Enabled = 0x1

	// SUBSCRIBE_HFCLKSTOP: Subscribe configuration for task HFCLKSTOP
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKSTOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKSTOP_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN_Enabled = 0x1

	// SUBSCRIBE_LFCLKSTART: Subscribe configuration for task LFCLKSTART
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_LFCLKSTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_LFCLKSTART_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_LFCLKSTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_LFCLKSTART_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_LFCLKSTART_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_LFCLKSTART_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_LFCLKSTART_EN_Enabled = 0x1

	// SUBSCRIBE_LFCLKSTOP: Subscribe configuration for task LFCLKSTOP
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_LFCLKSTOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_LFCLKSTOP_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN_Enabled = 0x1

	// SUBSCRIBE_CAL: Subscribe configuration for task CAL
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_CAL_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_CAL_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_CAL_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_CAL_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_CAL_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_CAL_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_CAL_EN_Enabled = 0x1

	// SUBSCRIBE_HFCLKAUDIOSTART: Subscribe configuration for task HFCLKAUDIOSTART
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKAUDIOSTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKAUDIOSTART_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_HFCLKAUDIOSTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_HFCLKAUDIOSTART_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_HFCLKAUDIOSTART_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_HFCLKAUDIOSTART_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_HFCLKAUDIOSTART_EN_Enabled = 0x1

	// SUBSCRIBE_HFCLKAUDIOSTOP: Subscribe configuration for task HFCLKAUDIOSTOP
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKAUDIOSTOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKAUDIOSTOP_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_HFCLKAUDIOSTOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_HFCLKAUDIOSTOP_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_HFCLKAUDIOSTOP_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_HFCLKAUDIOSTOP_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_HFCLKAUDIOSTOP_EN_Enabled = 0x1

	// SUBSCRIBE_HFCLK192MSTART: Subscribe configuration for task HFCLK192MSTART
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLK192MSTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLK192MSTART_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_HFCLK192MSTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_HFCLK192MSTART_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_HFCLK192MSTART_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_HFCLK192MSTART_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_HFCLK192MSTART_EN_Enabled = 0x1

	// SUBSCRIBE_HFCLK192MSTOP: Subscribe configuration for task HFCLK192MSTOP
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLK192MSTOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLK192MSTOP_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_HFCLK192MSTOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_HFCLK192MSTOP_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_HFCLK192MSTOP_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_HFCLK192MSTOP_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_HFCLK192MSTOP_EN_Enabled = 0x1

	// EVENTS_HFCLKSTARTED: HFCLK128M/HFCLK64M source started
	// Position of EVENTS_HFCLKSTARTED field.
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Pos = 0x0
	// Bit mask of EVENTS_HFCLKSTARTED field.
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Msk = 0x1
	// Bit EVENTS_HFCLKSTARTED.
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED = 0x1
	// Event not generated
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Generated = 0x1

	// EVENTS_LFCLKSTARTED: LFCLK source started
	// Position of EVENTS_LFCLKSTARTED field.
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_Pos = 0x0
	// Bit mask of EVENTS_LFCLKSTARTED field.
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_Msk = 0x1
	// Bit EVENTS_LFCLKSTARTED.
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED = 0x1
	// Event not generated
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_Generated = 0x1

	// EVENTS_DONE: Calibration of LFRC oscillator complete event
	// Position of EVENTS_DONE field.
	CLOCK_EVENTS_DONE_EVENTS_DONE_Pos = 0x0
	// Bit mask of EVENTS_DONE field.
	CLOCK_EVENTS_DONE_EVENTS_DONE_Msk = 0x1
	// Bit EVENTS_DONE.
	CLOCK_EVENTS_DONE_EVENTS_DONE = 0x1
	// Event not generated
	CLOCK_EVENTS_DONE_EVENTS_DONE_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_DONE_EVENTS_DONE_Generated = 0x1

	// EVENTS_HFCLKAUDIOSTARTED: HFCLKAUDIO source started
	// Position of EVENTS_HFCLKAUDIOSTARTED field.
	CLOCK_EVENTS_HFCLKAUDIOSTARTED_EVENTS_HFCLKAUDIOSTARTED_Pos = 0x0
	// Bit mask of EVENTS_HFCLKAUDIOSTARTED field.
	CLOCK_EVENTS_HFCLKAUDIOSTARTED_EVENTS_HFCLKAUDIOSTARTED_Msk = 0x1
	// Bit EVENTS_HFCLKAUDIOSTARTED.
	CLOCK_EVENTS_HFCLKAUDIOSTARTED_EVENTS_HFCLKAUDIOSTARTED = 0x1
	// Event not generated
	CLOCK_EVENTS_HFCLKAUDIOSTARTED_EVENTS_HFCLKAUDIOSTARTED_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_HFCLKAUDIOSTARTED_EVENTS_HFCLKAUDIOSTARTED_Generated = 0x1

	// EVENTS_HFCLK192MSTARTED: HFCLK192M source started
	// Position of EVENTS_HFCLK192MSTARTED field.
	CLOCK_EVENTS_HFCLK192MSTARTED_EVENTS_HFCLK192MSTARTED_Pos = 0x0
	// Bit mask of EVENTS_HFCLK192MSTARTED field.
	CLOCK_EVENTS_HFCLK192MSTARTED_EVENTS_HFCLK192MSTARTED_Msk = 0x1
	// Bit EVENTS_HFCLK192MSTARTED.
	CLOCK_EVENTS_HFCLK192MSTARTED_EVENTS_HFCLK192MSTARTED = 0x1
	// Event not generated
	CLOCK_EVENTS_HFCLK192MSTARTED_EVENTS_HFCLK192MSTARTED_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_HFCLK192MSTARTED_EVENTS_HFCLK192MSTARTED_Generated = 0x1

	// PUBLISH_HFCLKSTARTED: Publish configuration for event HFCLKSTARTED
	// Position of CHIDX field.
	CLOCK_PUBLISH_HFCLKSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_PUBLISH_HFCLKSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_PUBLISH_HFCLKSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_PUBLISH_HFCLKSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_PUBLISH_HFCLKSTARTED_EN = 0x80000000
	// Disable publishing
	CLOCK_PUBLISH_HFCLKSTARTED_EN_Disabled = 0x0
	// Enable publishing
	CLOCK_PUBLISH_HFCLKSTARTED_EN_Enabled = 0x1

	// PUBLISH_LFCLKSTARTED: Publish configuration for event LFCLKSTARTED
	// Position of CHIDX field.
	CLOCK_PUBLISH_LFCLKSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_PUBLISH_LFCLKSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_PUBLISH_LFCLKSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_PUBLISH_LFCLKSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_PUBLISH_LFCLKSTARTED_EN = 0x80000000
	// Disable publishing
	CLOCK_PUBLISH_LFCLKSTARTED_EN_Disabled = 0x0
	// Enable publishing
	CLOCK_PUBLISH_LFCLKSTARTED_EN_Enabled = 0x1

	// PUBLISH_DONE: Publish configuration for event DONE
	// Position of CHIDX field.
	CLOCK_PUBLISH_DONE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_PUBLISH_DONE_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_PUBLISH_DONE_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_PUBLISH_DONE_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_PUBLISH_DONE_EN = 0x80000000
	// Disable publishing
	CLOCK_PUBLISH_DONE_EN_Disabled = 0x0
	// Enable publishing
	CLOCK_PUBLISH_DONE_EN_Enabled = 0x1

	// PUBLISH_HFCLKAUDIOSTARTED: Publish configuration for event HFCLKAUDIOSTARTED
	// Position of CHIDX field.
	CLOCK_PUBLISH_HFCLKAUDIOSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_PUBLISH_HFCLKAUDIOSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_PUBLISH_HFCLKAUDIOSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_PUBLISH_HFCLKAUDIOSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_PUBLISH_HFCLKAUDIOSTARTED_EN = 0x80000000
	// Disable publishing
	CLOCK_PUBLISH_HFCLKAUDIOSTARTED_EN_Disabled = 0x0
	// Enable publishing
	CLOCK_PUBLISH_HFCLKAUDIOSTARTED_EN_Enabled = 0x1

	// PUBLISH_HFCLK192MSTARTED: Publish configuration for event HFCLK192MSTARTED
	// Position of CHIDX field.
	CLOCK_PUBLISH_HFCLK192MSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_PUBLISH_HFCLK192MSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_PUBLISH_HFCLK192MSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_PUBLISH_HFCLK192MSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_PUBLISH_HFCLK192MSTARTED_EN = 0x80000000
	// Disable publishing
	CLOCK_PUBLISH_HFCLK192MSTARTED_EN_Disabled = 0x0
	// Enable publishing
	CLOCK_PUBLISH_HFCLK192MSTARTED_EN_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of HFCLKSTARTED field.
	CLOCK_INTEN_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTEN_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTEN_HFCLKSTARTED = 0x1
	// Disable
	CLOCK_INTEN_HFCLKSTARTED_Disabled = 0x0
	// Enable
	CLOCK_INTEN_HFCLKSTARTED_Enabled = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTEN_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTEN_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTEN_LFCLKSTARTED = 0x2
	// Disable
	CLOCK_INTEN_LFCLKSTARTED_Disabled = 0x0
	// Enable
	CLOCK_INTEN_LFCLKSTARTED_Enabled = 0x1
	// Position of DONE field.
	CLOCK_INTEN_DONE_Pos = 0x7
	// Bit mask of DONE field.
	CLOCK_INTEN_DONE_Msk = 0x80
	// Bit DONE.
	CLOCK_INTEN_DONE = 0x80
	// Disable
	CLOCK_INTEN_DONE_Disabled = 0x0
	// Enable
	CLOCK_INTEN_DONE_Enabled = 0x1
	// Position of HFCLKAUDIOSTARTED field.
	CLOCK_INTEN_HFCLKAUDIOSTARTED_Pos = 0x8
	// Bit mask of HFCLKAUDIOSTARTED field.
	CLOCK_INTEN_HFCLKAUDIOSTARTED_Msk = 0x100
	// Bit HFCLKAUDIOSTARTED.
	CLOCK_INTEN_HFCLKAUDIOSTARTED = 0x100
	// Disable
	CLOCK_INTEN_HFCLKAUDIOSTARTED_Disabled = 0x0
	// Enable
	CLOCK_INTEN_HFCLKAUDIOSTARTED_Enabled = 0x1
	// Position of HFCLK192MSTARTED field.
	CLOCK_INTEN_HFCLK192MSTARTED_Pos = 0x9
	// Bit mask of HFCLK192MSTARTED field.
	CLOCK_INTEN_HFCLK192MSTARTED_Msk = 0x200
	// Bit HFCLK192MSTARTED.
	CLOCK_INTEN_HFCLK192MSTARTED = 0x200
	// Disable
	CLOCK_INTEN_HFCLK192MSTARTED_Disabled = 0x0
	// Enable
	CLOCK_INTEN_HFCLK192MSTARTED_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of HFCLKSTARTED field.
	CLOCK_INTENSET_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTENSET_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTENSET_HFCLKSTARTED = 0x1
	// Read: Disabled
	CLOCK_INTENSET_HFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_HFCLKSTARTED_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_HFCLKSTARTED_Set = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTENSET_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTENSET_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTENSET_LFCLKSTARTED = 0x2
	// Read: Disabled
	CLOCK_INTENSET_LFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_LFCLKSTARTED_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_LFCLKSTARTED_Set = 0x1
	// Position of DONE field.
	CLOCK_INTENSET_DONE_Pos = 0x7
	// Bit mask of DONE field.
	CLOCK_INTENSET_DONE_Msk = 0x80
	// Bit DONE.
	CLOCK_INTENSET_DONE = 0x80
	// Read: Disabled
	CLOCK_INTENSET_DONE_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_DONE_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_DONE_Set = 0x1
	// Position of HFCLKAUDIOSTARTED field.
	CLOCK_INTENSET_HFCLKAUDIOSTARTED_Pos = 0x8
	// Bit mask of HFCLKAUDIOSTARTED field.
	CLOCK_INTENSET_HFCLKAUDIOSTARTED_Msk = 0x100
	// Bit HFCLKAUDIOSTARTED.
	CLOCK_INTENSET_HFCLKAUDIOSTARTED = 0x100
	// Read: Disabled
	CLOCK_INTENSET_HFCLKAUDIOSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_HFCLKAUDIOSTARTED_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_HFCLKAUDIOSTARTED_Set = 0x1
	// Position of HFCLK192MSTARTED field.
	CLOCK_INTENSET_HFCLK192MSTARTED_Pos = 0x9
	// Bit mask of HFCLK192MSTARTED field.
	CLOCK_INTENSET_HFCLK192MSTARTED_Msk = 0x200
	// Bit HFCLK192MSTARTED.
	CLOCK_INTENSET_HFCLK192MSTARTED = 0x200
	// Read: Disabled
	CLOCK_INTENSET_HFCLK192MSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_HFCLK192MSTARTED_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_HFCLK192MSTARTED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of HFCLKSTARTED field.
	CLOCK_INTENCLR_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTENCLR_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTENCLR_HFCLKSTARTED = 0x1
	// Read: Disabled
	CLOCK_INTENCLR_HFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_HFCLKSTARTED_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_HFCLKSTARTED_Clear = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTENCLR_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTENCLR_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTENCLR_LFCLKSTARTED = 0x2
	// Read: Disabled
	CLOCK_INTENCLR_LFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_LFCLKSTARTED_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_LFCLKSTARTED_Clear = 0x1
	// Position of DONE field.
	CLOCK_INTENCLR_DONE_Pos = 0x7
	// Bit mask of DONE field.
	CLOCK_INTENCLR_DONE_Msk = 0x80
	// Bit DONE.
	CLOCK_INTENCLR_DONE = 0x80
	// Read: Disabled
	CLOCK_INTENCLR_DONE_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_DONE_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_DONE_Clear = 0x1
	// Position of HFCLKAUDIOSTARTED field.
	CLOCK_INTENCLR_HFCLKAUDIOSTARTED_Pos = 0x8
	// Bit mask of HFCLKAUDIOSTARTED field.
	CLOCK_INTENCLR_HFCLKAUDIOSTARTED_Msk = 0x100
	// Bit HFCLKAUDIOSTARTED.
	CLOCK_INTENCLR_HFCLKAUDIOSTARTED = 0x100
	// Read: Disabled
	CLOCK_INTENCLR_HFCLKAUDIOSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_HFCLKAUDIOSTARTE