/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.search;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXAppAdapter;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.search.SearchControlSequence;
import com.dickimawbooks.texparserlib.search.SearchFileName;
import com.dickimawbooks.texparserlib.search.SearchMatcher;
import com.dickimawbooks.texparserlib.search.SearchObject;
import com.dickimawbooks.texparserlib.search.SearchResult;
import com.dickimawbooks.texparserlib.search.SearchResultListener;
import com.dickimawbooks.texparserlib.search.SearchTerminatedException;
import com.dickimawbooks.texparserlib.search.SearchURI;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Vector;

public class SearchTeXFiles
extends LaTeXParserListener
implements Writeable {
    private Vector<SearchResultListener> searchResultListeners;
    private Vector<SearchMatcher> searchMatchers;
    private Vector<SearchResult> searchResults;
    private boolean stopOnNextMatch = false;
    private TeXApp texApp;

    public SearchTeXFiles(TeXApp teXApp) {
        super(null, false);
        this.texApp = teXApp;
        this.setWriteable(this);
        this.searchMatchers = new Vector();
        this.searchResults = new Vector();
    }

    public SearchTeXFiles() {
        this(new TeXAppAdapter(){

            @Override
            public void message(String string) {
            }

            @Override
            public void warning(TeXParser teXParser, String string) {
            }

            @Override
            public void error(Exception exception) {
            }

            @Override
            public String requestUserInput(String string) throws IOException {
                return null;
            }

            @Override
            public boolean isWriteAccessAllowed(File file) {
                return false;
            }
        });
    }

    public void setStopOnNextMatch(boolean bl) {
        this.stopOnNextMatch = bl;
    }

    public boolean isStopOnNextMatchOn() {
        return this.stopOnNextMatch;
    }

    public void addMatcher(SearchMatcher searchMatcher) {
        this.searchMatchers.add(searchMatcher);
    }

    public Vector<SearchResult> getResults() {
        return this.searchResults;
    }

    public void clearResults() {
        this.searchResults.clear();
    }

    @Override
    public ControlSequence getControlSequence(String string) {
        ControlSequence controlSequence = super.getControlSequence(string);
        if (controlSequence instanceof SearchControlSequence) {
            return controlSequence;
        }
        for (SearchMatcher searchMatcher : this.searchMatchers) {
            if (!searchMatcher.isMatch(controlSequence)) continue;
            SearchControlSequence searchControlSequence = new SearchControlSequence(controlSequence, searchMatcher, this);
            this.parser.putControlSequence(searchControlSequence);
            return searchControlSequence;
        }
        return controlSequence;
    }

    @Override
    public void beginParse(File file, Charset charset) throws IOException {
    }

    @Override
    public void endParse(File file) throws IOException {
    }

    public void addSearchResultListener(SearchResultListener searchResultListener) {
        if (this.searchResultListeners == null) {
            this.searchResultListeners = new Vector();
        }
        this.searchResultListeners.add(searchResultListener);
    }

    public boolean removeSearchResultListener(SearchResultListener searchResultListener) {
        if (this.searchResultListeners == null) {
            return false;
        }
        return this.searchResultListeners.remove(searchResultListener);
    }

    public void registerMatch(SearchObject searchObject) throws SearchTerminatedException {
        SearchResult searchResult = new SearchResult(this.parser, searchObject);
        if (this.searchResultListeners != null) {
            for (SearchResultListener searchResultListener : this.searchResultListeners) {
                searchResultListener.matchFound(searchResult);
            }
        }
        this.searchResults.add(searchResult);
        if (this.stopOnNextMatch) {
            throw new SearchTerminatedException();
        }
    }

    @Override
    public void includegraphics(KeyValList keyValList, String string) throws IOException {
        File file = this.getImageFile(string);
        for (SearchMatcher searchMatcher : this.searchMatchers) {
            if (!searchMatcher.isMatch(file)) continue;
            this.registerMatch(new SearchFileName(file, searchMatcher));
            return;
        }
    }

    @Override
    public void href(String string, TeXObject teXObject) throws IOException {
        try {
            URI uRI = new URI(string);
            for (SearchMatcher searchMatcher : this.searchMatchers) {
                if (!searchMatcher.isMatch(uRI)) continue;
                this.registerMatch(new SearchURI(uRI, searchMatcher));
                return;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            this.texApp.error(uRISyntaxException);
        }
        teXObject.process(this.parser);
    }

    @Override
    public void abovewithdelims(TeXObject teXObject, TeXObject teXObject2, TeXDimension teXDimension, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
        if (teXObject != null) {
            teXObject.process(this.parser);
        }
        teXObject3.process(this.parser);
        teXObject4.process(this.parser);
        if (teXObject2 != null) {
            teXObject2.process(this.parser);
        }
    }

    @Override
    public void overwithdelims(TeXObject teXObject, TeXObject teXObject2, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
        if (teXObject != null) {
            teXObject.process(this.parser);
        }
        teXObject3.process(this.parser);
        if (teXObject2 != null) {
            teXObject2.process(this.parser);
        }
    }

    @Override
    public void superscript(TeXObject teXObject) throws IOException {
        teXObject.process(this.parser);
    }

    @Override
    public void subscript(TeXObject teXObject) throws IOException {
        teXObject.process(this.parser);
    }

    @Override
    public void substituting(String string, String string2) {
        this.texApp.substituting(this.parser, string, string2);
    }

    @Override
    public void skipping(Ignoreable ignoreable) throws IOException {
    }

    @Override
    public void writeln(String string) {
    }

    @Override
    public void write(String string) {
    }

    @Override
    public void write(char c) {
    }

    @Override
    public void writeCodePoint(int n) {
    }

    @Override
    public TeXApp getTeXApp() {
        return this.texApp;
    }
}

