/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;
import org.eclipse.jdt.internal.compiler.parser.ConflictedParser;
import org.eclipse.jdt.internal.compiler.parser.NLSTag;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.CharDeduplication;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Scanner
implements TerminalTokens {
    public long sourceLevel;
    public long complianceLevel;
    public boolean useAssertAsAnIndentifier = false;
    public boolean containsAssertKeyword = false;
    public boolean previewEnabled;
    public boolean useEnumAsAnIndentifier = false;
    public boolean recordLineSeparator = false;
    public char currentCharacter;
    public int startPosition;
    public int currentPosition;
    public int initialPosition;
    public int eofPosition;
    public boolean skipComments = false;
    public boolean tokenizeComments = false;
    public boolean tokenizeWhiteSpace = false;
    public char[] source;
    public char[] withoutUnicodeBuffer;
    public int withoutUnicodePtr;
    public boolean unicodeAsBackSlash = false;
    public boolean scanningFloatLiteral = false;
    public static final int COMMENT_ARRAYS_SIZE = 30;
    public int[] commentStops = new int[30];
    public int[] commentStarts = new int[30];
    public int[] commentTagStarts = new int[30];
    public int commentPtr = -1;
    public int lastCommentLinePosition = -1;
    public char[][] foundTaskTags = null;
    public char[][] foundTaskMessages;
    public char[][] foundTaskPriorities = null;
    public int[][] foundTaskPositions;
    public int foundTaskCount = 0;
    public char[][] taskTags = null;
    public char[][] taskPriorities = null;
    public boolean isTaskCaseSensitive = true;
    public boolean diet = false;
    public int[] lineEnds = new int[250];
    public int linePtr = -1;
    public boolean wasAcr = false;
    public boolean fakeInModule = false;
    public int caseStartPosition = -1;
    boolean inCondition = false;
    int yieldColons = -1;
    boolean breakPreviewAllowed = false;
    protected ScanContext scanContext = null;
    protected boolean insideModuleInfo = false;
    public static final String END_OF_SOURCE = "End_Of_Source";
    public static final String INVALID_HEXA = "Invalid_Hexa_Literal";
    public static final String INVALID_OCTAL = "Invalid_Octal_Literal";
    public static final String INVALID_CHARACTER_CONSTANT = "Invalid_Character_Constant";
    public static final String INVALID_ESCAPE = "Invalid_Escape";
    public static final String INVALID_INPUT = "Invalid_Input";
    public static final String INVALID_TEXTBLOCK = "Invalid_Textblock";
    public static final String INVALID_UNICODE_ESCAPE = "Invalid_Unicode_Escape";
    public static final String INVALID_FLOAT = "Invalid_Float_Literal";
    public static final String INVALID_LOW_SURROGATE = "Invalid_Low_Surrogate";
    public static final String INVALID_HIGH_SURROGATE = "Invalid_High_Surrogate";
    public static final String NULL_SOURCE_STRING = "Null_Source_String";
    public static final String UNTERMINATED_STRING = "Unterminated_String";
    public static final String UNTERMINATED_TEXT_BLOCK = "Unterminated_Text_Block";
    public static final String UNTERMINATED_COMMENT = "Unterminated_Comment";
    public static final String INVALID_CHAR_IN_STRING = "Invalid_Char_In_String";
    public static final String INVALID_DIGIT = "Invalid_Digit";
    private static final int[] EMPTY_LINE_ENDS = Util.EMPTY_INT_ARRAY;
    public static final String INVALID_BINARY = "Invalid_Binary_Literal";
    public static final String BINARY_LITERAL_NOT_BELOW_17 = "Binary_Literal_Not_Below_17";
    public static final String ILLEGAL_HEXA_LITERAL = "Illegal_Hexa_Literal";
    public static final String INVALID_UNDERSCORE = "Invalid_Underscore";
    public static final String UNDERSCORES_IN_LITERALS_NOT_BELOW_17 = "Underscores_In_Literals_Not_Below_17";
    public static final char[] TAG_PREFIX = "//$NON-NLS-".toCharArray();
    public static final int TAG_PREFIX_LENGTH = TAG_PREFIX.length;
    public static final char TAG_POSTFIX = '$';
    public static final int TAG_POSTFIX_LENGTH = 1;
    public static final char[] IDENTITY_COMPARISON_TAG = "//$IDENTITY-COMPARISON$".toCharArray();
    public boolean[] validIdentityComparisonLines;
    public boolean checkUninternedIdentityComparison;
    private NLSTag[] nlsTags = null;
    protected int nlsTagsPtr;
    public boolean checkNonExternalizedStringLiterals;
    protected int lastPosition;
    public boolean returnOnlyGreater = false;
    public boolean insideRecovery = false;
    int[] lookBack = new int[2];
    protected int nextToken = 0;
    private VanguardScanner vanguardScanner;
    private VanguardParser vanguardParser;
    ConflictedParser activeParser = null;
    private boolean consumingEllipsisAnnotations = false;
    protected boolean multiCaseLabelComma = false;
    public static final int RoundBracket = 0;
    public static final int SquareBracket = 1;
    public static final int CurlyBracket = 2;
    public static final int BracketKinds = 3;
    public static final int LOW_SURROGATE_MIN_VALUE = 56320;
    public static final int HIGH_SURROGATE_MIN_VALUE = 55296;
    public static final int HIGH_SURROGATE_MAX_VALUE = 56319;
    public static final int LOW_SURROGATE_MAX_VALUE = 57343;
    protected int rawStart = -1;
    Map<String, Integer> _Keywords = null;
    private CharDeduplication deduplication = CharDeduplication.getThreadLocalInstance();

    public Scanner() {
        this(false, false, false, 0x2F0000L, null, null, true);
    }

    public Scanner(boolean bl, boolean bl2, boolean bl3, long l, long l2, char[][] object, char[][] object2, boolean bl4, boolean bl5) {
        this.eofPosition = Integer.MAX_VALUE;
        this.tokenizeComments = bl;
        this.tokenizeWhiteSpace = bl2;
        this.sourceLevel = l;
        this.nextToken = 0;
        this.lookBack[1] = 0;
        this.lookBack[0] = 0;
        this.consumingEllipsisAnnotations = false;
        this.complianceLevel = l2;
        this.checkNonExternalizedStringLiterals = bl3;
        this.previewEnabled = bl5;
        this.caseStartPosition = -1;
        this.multiCaseLabelComma = false;
        if (object != null) {
            int n;
            int n2 = n = ((char[][])object).length;
            if (object2 != null) {
                int n3 = ((char[][])object2).length;
                if (n3 != n) {
                    if (n3 > n) {
                        char[][] cArray = object2;
                        char[][] cArrayArray = new char[n][];
                        object2 = cArrayArray;
                        System.arraycopy(cArray, 0, cArrayArray, 0, n);
                    } else {
                        char[][] cArray = object;
                        char[][] cArrayArray = new char[n3][];
                        object = cArrayArray;
                        System.arraycopy(cArray, 0, cArrayArray, 0, n3);
                        n2 = n3;
                    }
                }
                int[] nArray = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = i;
                }
                Util.reverseQuickSort(object, 0, n2 - 1, nArray);
                char[][] cArrayArray = new char[n2][];
                for (int i = 0; i < n2; ++i) {
                    cArrayArray[i] = object2[nArray[i]];
                }
                this.taskPriorities = cArrayArray;
            } else {
                Util.reverseQuickSort(object, 0, n2 - 1);
            }
            this.taskTags = object;
            this.isTaskCaseSensitive = bl4;
        }
    }

    public Scanner(boolean bl, boolean bl2, boolean bl3, long l, char[][] cArray, char[][] cArray2, boolean bl4, boolean bl5) {
        this(bl, bl2, bl3, l, l, cArray, cArray2, bl4, bl5);
    }

    public Scanner(boolean bl, boolean bl2, boolean bl3, long l, char[][] cArray, char[][] cArray2, boolean bl4) {
        this(bl, bl2, bl3, l, l, cArray, cArray2, bl4, false);
    }

    public final boolean atEnd() {
        return this.eofPosition <= this.currentPosition;
    }

    public void checkTaskTag(int n, int n2) throws InvalidInputException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        char[] cArray = this.source;
        if (this.foundTaskCount > 0 && this.foundTaskPositions[this.foundTaskCount - 1][0] >= n) {
            return;
        }
        int n9 = this.foundTaskCount;
        char c = cArray[n + 1];
        for (n8 = n + 2; n8 < n2 && n8 < this.eofPosition; ++n8) {
            char[] cArray2 = null;
            char[] cArray3 = null;
            if (c != '@') {
                block1: for (n7 = 0; n7 < this.taskTags.length; ++n7) {
                    cArray2 = this.taskTags[n7];
                    n6 = cArray2.length;
                    if (n6 == 0 || ScannerHelper.isJavaIdentifierStart(this.complianceLevel, cArray2[0]) && ScannerHelper.isJavaIdentifierPart(this.complianceLevel, c)) continue;
                    for (n5 = 0; n5 < n6; ++n5) {
                        char c2;
                        int n10 = n8 + n5;
                        if (n10 >= this.eofPosition || n10 >= n2 || (n4 = cArray[n8 + n5]) != (c2 = cArray2[n5]) && (this.isTaskCaseSensitive || ScannerHelper.toLowerCase((char)n4) != ScannerHelper.toLowerCase(c2))) continue block1;
                    }
                    if (n8 + n6 < n2 && ScannerHelper.isJavaIdentifierPart(this.complianceLevel, cArray[n8 + n6 - 1]) && ScannerHelper.isJavaIdentifierPart(this.complianceLevel, cArray[n8 + n6])) continue;
                    if (this.foundTaskTags == null) {
                        this.foundTaskTags = new char[5][];
                        this.foundTaskMessages = new char[5][];
                        this.foundTaskPriorities = new char[5][];
                        this.foundTaskPositions = new int[5][];
                    } else if (this.foundTaskCount == this.foundTaskTags.length) {
                        char[][] cArrayArray = new char[this.foundTaskCount * 2][];
                        this.foundTaskTags = cArrayArray;
                        System.arraycopy(this.foundTaskTags, 0, cArrayArray, 0, this.foundTaskCount);
                        char[][] cArrayArray2 = new char[this.foundTaskCount * 2][];
                        this.foundTaskMessages = cArrayArray2;
                        System.arraycopy(this.foundTaskMessages, 0, cArrayArray2, 0, this.foundTaskCount);
                        char[][] cArrayArray3 = new char[this.foundTaskCount * 2][];
                        this.foundTaskPriorities = cArrayArray3;
                        System.arraycopy(this.foundTaskPriorities, 0, cArrayArray3, 0, this.foundTaskCount);
                        int[][] nArrayArray = new int[this.foundTaskCount * 2][];
                        this.foundTaskPositions = nArrayArray;
                        System.arraycopy(this.foundTaskPositions, 0, nArrayArray, 0, this.foundTaskCount);
                    }
                    cArray3 = this.taskPriorities != null && n7 < this.taskPriorities.length ? this.taskPriorities[n7] : null;
                    this.foundTaskTags[this.foundTaskCount] = cArray2;
                    this.foundTaskPriorities[this.foundTaskCount] = cArray3;
                    this.foundTaskPositions[this.foundTaskCount] = new int[]{n8, n8 + n6 - 1};
                    this.foundTaskMessages[this.foundTaskCount] = CharOperation.NO_CHAR;
                    ++this.foundTaskCount;
                    n8 += n6 - '\u0001';
                    break;
                }
            }
            c = cArray[n8];
        }
        n8 = 0;
        for (n3 = n9; n3 < this.foundTaskCount; ++n3) {
            int n11 = this.foundTaskPositions[n3][0] + this.foundTaskTags[n3].length;
            int n12 = n7 = n3 + 1 < this.foundTaskCount ? this.foundTaskPositions[n3 + 1][0] - 1 : n2 - 1;
            if (n7 < n11) {
                n7 = n11;
            }
            n6 = -1;
            for (n4 = n11; n4 < n7; ++n4) {
                n5 = cArray[n4];
                if (n5 != 10 && n5 != 13) continue;
                n6 = n4 - 1;
                break;
            }
            if (n6 == -1) {
                for (n4 = n7; n4 > n11; --n4) {
                    n5 = cArray[n4];
                    if (n5 != 42) continue;
                    n6 = n4 - 1;
                    break;
                }
                if (n6 == -1) {
                    n6 = n7;
                }
            }
            if (n11 == n6) {
                n8 = 1;
                continue;
            }
            while (CharOperation.isWhitespace(cArray[n6]) && n11 <= n6) {
                --n6;
            }
            this.foundTaskPositions[n3][1] = n6;
            n4 = n6 - n11 + 1;
            char[] cArray4 = new char[n4];
            System.arraycopy(cArray, n11, cArray4, 0, n4);
            this.foundTaskMessages[n3] = cArray4;
        }
        if (n8 != 0) {
            int n13 = this.foundTaskCount;
            block7: for (n3 = n9; n3 < n13; ++n3) {
                if (this.foundTaskMessages[n3].length != 0) continue;
                for (n7 = n3 + 1; n7 < n13; ++n7) {
                    if (this.foundTaskMessages[n7].length == 0) continue;
                    this.foundTaskMessages[n3] = this.foundTaskMessages[n7];
                    this.foundTaskPositions[n3][1] = this.foundTaskPositions[n7][1];
                    continue block7;
                }
            }
        }
    }

    public char[] getCurrentIdentifierSource() {
        if (this.withoutUnicodePtr != 0) {
            char[] cArray = new char[this.withoutUnicodePtr];
            System.arraycopy(this.withoutUnicodeBuffer, 1, cArray, 0, this.withoutUnicodePtr);
            return cArray;
        }
        int n = this.currentPosition - this.startPosition;
        if (n == this.eofPosition) {
            return this.source;
        }
        return this.deduplication.sharedCopyOfRange(this.source, this.startPosition, this.currentPosition);
    }

    public int getCurrentTokenEndPosition() {
        return this.currentPosition - 1;
    }

    public char[] getCurrentTokenSource() {
        char[] cArray;
        if (this.withoutUnicodePtr != 0) {
            cArray = new char[this.withoutUnicodePtr];
            System.arraycopy(this.withoutUnicodeBuffer, 1, cArray, 0, this.withoutUnicodePtr);
        } else {
            int n = this.currentPosition - this.startPosition;
            cArray = new char[n];
            System.arraycopy(this.source, this.startPosition, cArray, 0, n);
        }
        return cArray;
    }

    public final String getCurrentTokenString() {
        if (this.withoutUnicodePtr != 0) {
            return new String(this.withoutUnicodeBuffer, 1, this.withoutUnicodePtr);
        }
        return new String(this.source, this.startPosition, this.currentPosition - this.startPosition);
    }

    public char[] getCurrentTokenSourceString() {
        char[] cArray;
        if (this.withoutUnicodePtr != 0) {
            cArray = new char[this.withoutUnicodePtr - 2];
            System.arraycopy(this.withoutUnicodeBuffer, 2, cArray, 0, this.withoutUnicodePtr - 2);
        } else {
            int n = this.currentPosition - this.startPosition - 2;
            cArray = new char[n];
            System.arraycopy(this.source, this.startPosition + 1, cArray, 0, n);
        }
        return cArray;
    }

    protected final boolean scanForTextBlockBeginning() {
        try {
            int n = this.currentPosition;
            if (this.source[n++] == '\"' && this.source[n++] == '\"') {
                char c = this.source[n++];
                while (ScannerHelper.isWhitespace(c)) {
                    switch (c) {
                        case '\n': {
                            this.currentCharacter = c;
                            this.currentPosition = n;
                            return true;
                        }
                    }
                    c = this.source[n++];
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    protected final boolean scanForTextBlockClose() throws InvalidInputException {
        try {
            if (this.source[this.currentPosition] == '\"' && this.source[this.currentPosition + 1] == '\"') {
                return true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public char[] getCurrentTextBlock() {
        Object object;
        int n;
        char[] cArray;
        if (this.withoutUnicodePtr != 0) {
            cArray = CharOperation.subarray(this.withoutUnicodeBuffer, this.rawStart + 1, this.withoutUnicodePtr + 1);
        } else {
            cArray = CharOperation.subarray(this.source, this.startPosition + this.rawStart, this.currentPosition - 3);
            if (cArray == null) {
                cArray = new char[]{};
            }
        }
        cArray = this.normalize(cArray);
        char[][] cArray2 = CharOperation.splitOn('\n', cArray);
        int n2 = cArray2.length;
        ArrayList<char[]> arrayList = new ArrayList<char[]>(cArray2.length);
        for (n = 0; n < cArray2.length; ++n) {
            char[] cArray3 = cArray2[n];
            if (n + 1 == n2 && cArray3.length == 0) {
                arrayList.add(cArray3);
                break;
            }
            object = CharOperation.splitOn('\r', cArray3);
            if (((char[][])object).length == 0) {
                arrayList.add(cArray3);
                continue;
            }
            for (char[] cArray4 : object) {
                arrayList.add(cArray4);
            }
        }
        n2 = arrayList.size();
        cArray2 = (char[][])arrayList.toArray((T[])new char[n2][]);
        n = -1;
        for (int i = 0; i < n2; ++i) {
            object = cArray2[i];
            boolean bl = true;
            int n3 = 0;
            for (char[] cArray5 : object) {
                if (!bl) continue;
                if (ScannerHelper.isWhitespace((char)cArray5)) {
                    ++n3;
                    continue;
                }
                bl = false;
            }
            if (bl && i + 1 != n2 || n >= 0 && n3 >= n) continue;
            n = n3;
        }
        if (n == -1) {
            n = 0;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < cArray2.length; ++i) {
            int n4;
            int n5;
            char[] cArray6 = cArray2[i];
            for (n5 = n4 = cArray6.length; n5 > 0 && ScannerHelper.isWhitespace(cArray6[n5 - 1]); --n5) {
            }
            if (i >= n2 - 1) {
                if (bl) {
                    stringBuilder.append('\n');
                }
                if (n5 < n) continue;
                bl = this.getLineContent(stringBuilder, cArray6, n, n5 - 1, false, true);
                continue;
            }
            if (i > 0 && bl) {
                stringBuilder.append('\n');
            }
            if (n5 <= n) {
                bl = true;
                continue;
            }
            int n6 = n4 > 0 && cArray6[n4 - 1] == '\\' ? 1 : 0;
            bl = this.getLineContent(stringBuilder, cArray6, n, n5 - 1, n6 != 0, false);
        }
        this.rawStart = -1;
        return stringBuilder.toString().toCharArray();
    }

    private char[] normalize(char[] cArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        block4: for (char c : cArray) {
            switch (c) {
                case '\r': {
                    stringBuilder.append(c);
                    bl = true;
                    continue block4;
                }
                case '\n': {
                    if (!bl) {
                        stringBuilder.append(c);
                    }
                    bl = false;
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                    bl = false;
                }
            }
        }
        return stringBuilder.toString().toCharArray();
    }

    private boolean getLineContent(StringBuilder stringBuilder, char[] cArray, int n, int n2, boolean bl, boolean bl2) {
        char[] cArray2;
        int n3 = 0;
        int n4 = n;
        block12: while (n4 < n2) {
            char c = cArray[n4];
            if (c != '\\') {
                ++n4;
                continue;
            }
            if (n4 >= n2) continue;
            if (n3 + 1 <= n4) {
                stringBuilder.append(CharOperation.subarray(cArray, n3 == 0 ? n : n3, n4));
            }
            char c2 = cArray[++n4];
            switch (c2) {
                case '\\': {
                    stringBuilder.append('\\');
                    if (n4 != n2) break;
                    bl = false;
                    break;
                }
                case 's': {
                    stringBuilder.append(' ');
                    break;
                }
                case '\"': {
                    stringBuilder.append('\"');
                    break;
                }
                case 'b': {
                    stringBuilder.append('\b');
                    break;
                }
                case 'n': {
                    stringBuilder.append('\n');
                    break;
                }
                case 'r': {
                    stringBuilder.append('\r');
                    break;
                }
                case 't': {
                    stringBuilder.append('\t');
                    break;
                }
                case 'f': {
                    stringBuilder.append('\f');
                    break;
                }
                default: {
                    int n5 = n4 + 1;
                    int n6 = ScannerHelper.getHexadecimalValue(c2);
                    if (n6 >= 0 && n6 <= 7) {
                        boolean bl3 = n6 > 3;
                        try {
                            c2 = cArray[n5];
                            if (ScannerHelper.isDigit(c2)) {
                                ++n5;
                                int n7 = ScannerHelper.getHexadecimalValue(c2);
                                if (n7 >= 0 && n7 <= 7) {
                                    n6 = n6 * 8 + n7;
                                    c2 = cArray[n5];
                                    if (ScannerHelper.isDigit(c2)) {
                                        ++n5;
                                        if (!bl3 && (n7 = ScannerHelper.getHexadecimalValue(c2)) >= 0 && n7 <= 7) {
                                            n6 = n6 * 8 + n7;
                                        }
                                    }
                                }
                            }
                        }
                        catch (InvalidInputException invalidInputException) {
                            // empty catch block
                        }
                        if (n6 < 255) {
                            c2 = (char)n6;
                        }
                        stringBuilder.append(c2);
                        n3 = n4 = n5;
                        continue block12;
                    }
                    stringBuilder.append(c);
                    n3 = n4;
                    continue block12;
                }
            }
            n3 = ++n4;
        }
        n2 = bl ? n2 : (n2 >= cArray.length ? n2 : n2 + 1);
        char[] cArray3 = cArray2 = n3 == 0 ? CharOperation.subarray(cArray, n, n2) : CharOperation.subarray(cArray, n3, n2);
        if (cArray2 != null && cArray2.length > 0) {
            stringBuilder.append(cArray2);
        }
        return !bl && !bl2;
    }

    public final String getCurrentStringLiteral() {
        if (this.withoutUnicodePtr != 0) {
            return new String(this.withoutUnicodeBuffer, 2, this.withoutUnicodePtr - 2);
        }
        return new String(this.source, this.startPosition + 1, this.currentPosition - this.startPosition - 2);
    }

    public final char[] getRawTokenSource() {
        int n = this.currentPosition - this.startPosition;
        char[] cArray = new char[n];
        System.arraycopy(this.source, this.startPosition, cArray, 0, n);
        return cArray;
    }

    public final char[] getRawTokenSourceEnd() {
        int n = this.eofPosition - this.currentPosition - 1;
        char[] cArray = new char[n];
        System.arraycopy(this.source, this.currentPosition, cArray, 0, n);
        return cArray;
    }

    public int getCurrentTokenStartPosition() {
        return this.startPosition;
    }

    public final int getLineEnd(int n) {
        if (this.lineEnds == null || this.linePtr == -1) {
            return -1;
        }
        if (n > this.lineEnds.length + 1) {
            return -1;
        }
        if (n <= 0) {
            return -1;
        }
        if (n == this.lineEnds.length + 1) {
            return this.eofPosition;
        }
        return this.lineEnds[n - 1];
    }

    public final int[] getLineEnds() {
        if (this.linePtr == -1) {
            return EMPTY_LINE_ENDS;
        }
        int[] nArray = new int[this.linePtr + 1];
        System.arraycopy(this.lineEnds, 0, nArray, 0, this.linePtr + 1);
        return nArray;
    }

    public final int getLineStart(int n) {
        if (this.lineEnds == null || this.linePtr == -1) {
            return -1;
        }
        if (n > this.lineEnds.length + 1) {
            return -1;
        }
        if (n <= 0) {
            return -1;
        }
        if (n == 1) {
            return this.initialPosition;
        }
        return this.lineEnds[n - 2] + 1;
    }

    public final int getNextChar() {
        try {
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                this.getNextUnicodeChar();
            } else {
                this.unicodeAsBackSlash = false;
                if (this.withoutUnicodePtr != 0) {
                    this.unicodeStore();
                }
            }
            return this.currentCharacter;
        }
        catch (IndexOutOfBoundsException | InvalidInputException exception) {
            return -1;
        }
    }

    public final int getNextCharWithBoundChecks() {
        if (this.currentPosition >= this.eofPosition) {
            return -1;
        }
        this.currentCharacter = this.source[this.currentPosition++];
        if (this.currentPosition >= this.eofPosition) {
            this.unicodeAsBackSlash = false;
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return this.currentCharacter;
        }
        if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
            try {
                this.getNextUnicodeChar();
            }
            catch (InvalidInputException invalidInputException) {
                return -1;
            }
        } else {
            this.unicodeAsBackSlash = false;
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
        }
        return this.currentCharacter;
    }

    public final boolean getNextChar(char c) {
        if (this.currentPosition >= this.eofPosition) {
            this.unicodeAsBackSlash = false;
            return false;
        }
        int n = this.currentPosition;
        try {
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                this.getNextUnicodeChar();
                if (this.currentCharacter != c) {
                    this.currentPosition = n;
                    --this.withoutUnicodePtr;
                    return false;
                }
                return true;
            }
            if (this.currentCharacter != c) {
                this.currentPosition = n;
                return false;
            }
            this.unicodeAsBackSlash = false;
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return true;
        }
        catch (IndexOutOfBoundsException | InvalidInputException exception) {
            this.unicodeAsBackSlash = false;
            this.currentPosition = n;
            return false;
        }
    }

    public final int getNextChar(char c, char c2) {
        if (this.currentPosition >= this.eofPosition) {
            return -1;
        }
        int n = this.currentPosition;
        try {
            int n2;
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                int n3;
                this.getNextUnicodeChar();
                if (this.currentCharacter == c) {
                    n3 = 0;
                } else if (this.currentCharacter == c2) {
                    n3 = 1;
                } else {
                    this.currentPosition = n;
                    --this.withoutUnicodePtr;
                    n3 = -1;
                }
                return n3;
            }
            if (this.currentCharacter == c) {
                n2 = 0;
            } else if (this.currentCharacter == c2) {
                n2 = 1;
            } else {
                this.currentPosition = n;
                return -1;
            }
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return n2;
        }
        catch (IndexOutOfBoundsException | InvalidInputException exception) {
            this.currentPosition = n;
            return -1;
        }
    }

    private final void consumeDigits(int n) throws InvalidInputException {
        this.consumeDigits(n, false);
    }

    private final void consumeDigits(int n, boolean bl) throws InvalidInputException {
        switch (this.consumeDigits0(n, 1, 2, bl)) {
            case 1: {
                if (this.sourceLevel >= 0x330000L) break;
                throw new InvalidInputException(UNDERSCORES_IN_LITERALS_NOT_BELOW_17);
            }
            case 2: {
                if (this.sourceLevel < 0x330000L) {
                    throw new InvalidInputException(UNDERSCORES_IN_LITERALS_NOT_BELOW_17);
                }
                throw new InvalidInputException(INVALID_UNDERSCORE);
            }
        }
    }

    private final int consumeDigits0(int n, int n2, int n3, boolean bl) throws InvalidInputException {
        int n4 = 0;
        if (this.getNextChar('_')) {
            if (bl) {
                return n3;
            }
            n4 = n2;
            while (this.getNextChar('_')) {
            }
        }
        if (this.getNextCharAsDigit(n)) {
            while (this.getNextCharAsDigit(n)) {
            }
            int n5 = this.consumeDigits0(n, n2, n3, false);
            if (n5 == 0) {
                return n4;
            }
            return n5;
        }
        if (n4 == n2) {
            return n3;
        }
        return n4;
    }

    public final boolean getNextCharAsDigit() throws InvalidInputException {
        if (this.currentPosition >= this.eofPosition) {
            return false;
        }
        int n = this.currentPosition;
        try {
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                this.getNextUnicodeChar();
                if (!ScannerHelper.isDigit(this.currentCharacter)) {
                    this.currentPosition = n;
                    --this.withoutUnicodePtr;
                    return false;
                }
                return true;
            }
            if (!ScannerHelper.isDigit(this.currentCharacter)) {
                this.currentPosition = n;
                return false;
            }
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return true;
        }
        catch (IndexOutOfBoundsException | InvalidInputException exception) {
            this.currentPosition = n;
            return false;
        }
    }

    public final boolean getNextCharAsDigit(int n) {
        if (this.currentPosition >= this.eofPosition) {
            return false;
        }
        int n2 = this.currentPosition;
        try {
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                this.getNextUnicodeChar();
                if (ScannerHelper.digit(this.currentCharacter, n) == -1) {
                    this.currentPosition = n2;
                    --this.withoutUnicodePtr;
                    return false;
                }
                return true;
            }
            if (ScannerHelper.digit(this.currentCharacter, n) == -1) {
                this.currentPosition = n2;
                return false;
            }
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return true;
        }
        catch (IndexOutOfBoundsException | InvalidInputException exception) {
            this.currentPosition = n2;
            return false;
        }
    }

    public boolean getNextCharAsJavaIdentifierPartWithBoundCheck() {
        int n = this.currentPosition;
        if (n >= this.eofPosition) {
            return false;
        }
        int n2 = this.withoutUnicodePtr;
        try {
            boolean bl = false;
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentPosition < this.eofPosition && this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                this.getNextUnicodeChar();
                bl = true;
            }
            char c = this.currentCharacter;
            boolean bl2 = false;
            if (c >= '\ud800' && c <= '\udbff') {
                if (this.complianceLevel < 0x310000L) {
                    this.currentPosition = n;
                    this.withoutUnicodePtr = n2;
                    return false;
                }
                char c2 = (char)this.getNextCharWithBoundChecks();
                if (c2 < '\udc00' || c2 > '\udfff') {
                    this.currentPosition = n;
                    this.withoutUnicodePtr = n2;
                    return false;
                }
                bl2 = ScannerHelper.isJavaIdentifierPart(this.complianceLevel, c, c2);
            } else {
                if (c >= '\udc00' && c <= '\udfff') {
                    this.currentPosition = n;
                    this.withoutUnicodePtr = n2;
                    return false;
                }
                bl2 = ScannerHelper.isJavaIdentifierPart(this.complianceLevel, c);
            }
            if (bl) {
                if (!bl2) {
                    this.currentPosition = n;
                    this.withoutUnicodePtr = n2;
                    return false;
                }
                return true;
            }
            if (!bl2) {
                this.currentPosition = n;
                return false;
            }
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return true;
        }
        catch (InvalidInputException invalidInputException) {
            this.currentPosition = n;
            this.withoutUnicodePtr = n2;
            return false;
        }
    }

    public boolean getNextCharAsJavaIdentifierPart() {
        int n = this.currentPosition;
        if (n >= this.eofPosition) {
            return false;
        }
        int n2 = this.withoutUnicodePtr;
        try {
            boolean bl = false;
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                this.getNextUnicodeChar();
                bl = true;
            }
            char c = this.currentCharacter;
            boolean bl2 = false;
            if (c >= '\ud800' && c <= '\udbff') {
                if (this.complianceLevel < 0x310000L) {
                    this.currentPosition = n;
                    this.withoutUnicodePtr = n2;
                    return false;
                }
                char c2 = (char)this.getNextChar();
                if (c2 < '\udc00' || c2 > '\udfff') {
                    this.currentPosition = n;
                    this.withoutUnicodePtr = n2;
                    return false;
                }
                bl2 = ScannerHelper.isJavaIdentifierPart(this.complianceLevel, c, c2);
            } else {
                if (c >= '\udc00' && c <= '\udfff') {
                    this.currentPosition = n;
                    this.withoutUnicodePtr = n2;
                    return false;
                }
                bl2 = ScannerHelper.isJavaIdentifierPart(this.complianceLevel, c);
            }
            if (bl) {
                if (!bl2) {
                    this.currentPosition = n;
                    this.withoutUnicodePtr = n2;
                    return false;
                }
                return true;
            }
            if (!bl2) {
                this.currentPosition = n;
                return false;
            }
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return true;
        }
        catch (IndexOutOfBoundsException | InvalidInputException exception) {
            this.currentPosition = n;
            this.withoutUnicodePtr = n2;
            return false;
        }
    }

    public int scanIdentifier() throws InvalidInputException {
        boolean bl;
        char c;
        int n;
        int n2;
        boolean bl2;
        int n3 = 0;
        this.withoutUnicodePtr = 0;
        n3 = this.currentPosition;
        boolean bl3 = false;
        boolean bl4 = false;
        do {
            n2 = this.withoutUnicodePtr;
            n = this.currentPosition;
            this.startPosition = this.currentPosition;
            if (this.currentPosition >= this.eofPosition) {
                if (this.tokenizeWhiteSpace && n3 != this.currentPosition - 1) {
                    --this.currentPosition;
                    this.startPosition = n3;
                    return 1000;
                }
                return 64;
            }
            this.currentCharacter = this.source[this.currentPosition++];
            bl4 = this.currentPosition < this.eofPosition && this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u';
            if (bl4) {
                bl2 = this.jumpOverUnicodeWhiteSpace();
                n = this.currentPosition - n;
            } else {
                n = this.currentPosition - n;
                switch (this.currentCharacter) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        bl2 = true;
                        break;
                    }
                    default: {
                        bl2 = false;
                    }
                }
            }
            if (!bl2) continue;
            bl3 = true;
        } while (bl2);
        if (bl3) {
            if (this.tokenizeWhiteSpace) {
                this.currentPosition -= n;
                this.startPosition = n3;
                if (bl4) {
                    this.withoutUnicodePtr = n2;
                }
                return 1000;
            }
            if (bl4) {
                this.withoutUnicodePtr = 0;
                this.unicodeStore();
            } else {
                this.withoutUnicodePtr = 0;
            }
        }
        if ((c = this.currentCharacter) < '\u0080') {
            if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 0x40) != 0) {
                return this.scanIdentifierOrKeywordWithBoundCheck();
            }
            return 136;
        }
        if (c >= '\ud800' && c <= '\udbff') {
            if (this.complianceLevel < 0x310000L) {
                throw new InvalidInputException(INVALID_UNICODE_ESCAPE);
            }
            char c2 = (char)this.getNextCharWithBoundChecks();
            if (c2 < '\udc00' || c2 > '\udfff') {
                throw new InvalidInputException(INVALID_LOW_SURROGATE);
            }
            bl = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, c, c2);
        } else {
            if (c >= '\udc00' && c <= '\udfff') {
                if (this.complianceLevel < 0x310000L) {
                    throw new InvalidInputException(INVALID_UNICODE_ESCAPE);
                }
                throw new InvalidInputException(INVALID_HIGH_SURROGATE);
            }
            bl = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, c);
        }
        if (bl) {
            return this.scanIdentifierOrKeywordWithBoundCheck();
        }
        return 136;
    }

    public void ungetToken(int n) {
        if (this.nextToken != 0) {
            throw new ArrayIndexOutOfBoundsException("Single cell array overflow");
        }
        this.nextToken = n;
    }

    private void updateCase(int n) {
        if (n == 91) {
            this.caseStartPosition = this.startPosition;
            this.breakPreviewAllowed = true;
        }
    }

    public int getNextToken() throws InvalidInputException {
        if (this.nextToken != 0) {
            int n = this.nextToken;
            this.nextToken = 0;
            return n;
        }
        if (this.scanContext == null) {
            this.scanContext = this.isInModuleDeclaration() ? ScanContext.EXPECTING_KEYWORD : ScanContext.INACTIVE;
        }
        int n = this.getNextToken0();
        if (this.areRestrictedModuleKeywordsActive()) {
            if (Scanner.isRestrictedKeyword(n)) {
                n = this.disambiguatedRestrictedKeyword(n);
            }
            this.updateScanContext(n);
        }
        if (this.activeParser == null) {
            return n;
        }
        if (n == 23 || n == 11 || n == 36 || n == 104) {
            n = this.disambiguatedToken(n, this);
        } else if (n == 120) {
            this.consumingEllipsisAnnotations = false;
        } else if (this.mayBeAtCasePattern(n)) {
            n = this.disambiguateCasePattern(n, this);
        }
        this.lookBack[0] = this.lookBack[1];
        this.lookBack[1] = n;
        this.multiCaseLabelComma = false;
        this.updateCase(n);
        return n;
    }

    /*
     * Unable to fully structure code
     */
    protected int getNextToken0() throws InvalidInputException {
        this.wasAcr = false;
        if (this.diet) {
            this.jumpOverMethodBody();
            this.diet = false;
            return this.currentPosition > this.eofPosition ? 64 : 33;
        }
        var1_1 = 0;
        block47: while (true) lbl-1000:
        // 3 sources

        {
            block48: while (true) {
                this.withoutUnicodePtr = 0;
                var1_1 = ++this.currentPosition;
                var3_4 = false;
                var6_7 = false;
                do {
                    block159: {
                        var5_6 = this.withoutUnicodePtr;
                        var4_5 = this.currentPosition;
                        this.startPosition = this.currentPosition;
                        try {
                            this.currentCharacter = this.source[this.currentPosition++];
                            var6_7 = this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u';
                        }
                        catch (IndexOutOfBoundsException var7_8) {
                            if (this.tokenizeWhiteSpace && var1_1 != this.currentPosition - 1) {
                                --this.currentPosition;
                                this.startPosition = var1_1;
                                return 1000;
                            }
                            if (this.currentPosition <= this.eofPosition) break block159;
                            return 64;
                        }
                    }
                    if (this.currentPosition > this.eofPosition) {
                        if (this.tokenizeWhiteSpace && var1_1 != this.currentPosition - 1) {
                            --this.currentPosition;
                            this.startPosition = var1_1;
                            return 1000;
                        }
                        return 64;
                    }
                    if (var6_7) {
                        var2_2 = this.jumpOverUnicodeWhiteSpace();
                        var4_5 = this.currentPosition - var4_5;
                    } else {
                        var4_5 = this.currentPosition - var4_5;
                        if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                            this.pushLineSeparator();
                        }
                        switch (this.currentCharacter) {
                            case '\t': 
                            case '\n': 
                            case '\f': 
                            case '\r': 
                            case ' ': {
                                var2_2 = true;
                                break;
                            }
                            default: {
                                var2_2 = false;
                            }
                        }
                    }
                    if (!var2_2) continue;
                    var3_4 = true;
                } while (var2_2);
                if (var3_4) {
                    if (this.tokenizeWhiteSpace) {
                        this.currentPosition -= var4_5;
                        this.startPosition = var1_1;
                        if (var6_7) {
                            this.withoutUnicodePtr = var5_6;
                        }
                        return 1000;
                    }
                    if (var6_7) {
                        this.withoutUnicodePtr = 0;
                        this.unicodeStore();
                    } else {
                        this.withoutUnicodePtr = 0;
                    }
                }
                switch (this.currentCharacter) {
                    case '@': {
                        return 36;
                    }
                    case '(': {
                        return 23;
                    }
                    case ')': {
                        return 26;
                    }
                    case '{': {
                        return 39;
                    }
                    case '}': {
                        return 33;
                    }
                    case '[': {
                        return 6;
                    }
                    case ']': {
                        return 69;
                    }
                    case ';': {
                        return 25;
                    }
                    case ',': {
                        return 32;
                    }
                    case '.': {
                        if (this.getNextCharAsDigit()) {
                            return this.scanNumber(true);
                        }
                        var7_9 = this.currentPosition;
                        if (this.getNextChar('.')) {
                            if (this.getNextChar('.')) {
                                return 120;
                            }
                            this.currentPosition = var7_9;
                            return 1;
                        }
                        this.currentPosition = var7_9;
                        return 1;
                    }
                    case '+': {
                        var8_10 = this.getNextChar('+', '=');
                        if (var8_10 == 0) {
                            return 2;
                        }
                        if (var8_10 > 0) {
                            return 93;
                        }
                        return 4;
                    }
                    case '-': {
                        var8_10 = this.getNextChar('-', '=');
                        if (var8_10 == 0) {
                            return 3;
                        }
                        if (var8_10 > 0) {
                            return 94;
                        }
                        if (this.getNextChar('>')) {
                            return 104;
                        }
                        return 5;
                    }
                    case '~': {
                        return 67;
                    }
                    case '!': {
                        if (this.getNextChar('=')) {
                            return 21;
                        }
                        return 66;
                    }
                    case '*': {
                        if (this.getNextChar('=')) {
                            return 95;
                        }
                        return 8;
                    }
                    case '%': {
                        if (this.getNextChar('=')) {
                            return 100;
                        }
                        return 9;
                    }
                    case '<': {
                        var8_10 = this.getNextChar('=', '<');
                        if (var8_10 == 0) {
                            return 12;
                        }
                        if (var8_10 > 0) {
                            if (this.getNextChar('=')) {
                                return 101;
                            }
                            return 18;
                        }
                        return 11;
                    }
                    case '>': {
                        if (this.returnOnlyGreater) {
                            return 15;
                        }
                        var8_10 = this.getNextChar('=', '>');
                        if (var8_10 == 0) {
                            return 13;
                        }
                        if (var8_10 > 0) {
                            var8_10 = this.getNextChar('=', '>');
                            if (var8_10 == 0) {
                                return 102;
                            }
                            if (var8_10 > 0) {
                                if (this.getNextChar('=')) {
                                    return 103;
                                }
                                return 16;
                            }
                            return 14;
                        }
                        return 15;
                    }
                    case '=': {
                        if (this.getNextChar('=')) {
                            return 20;
                        }
                        return 77;
                    }
                    case '&': {
                        var8_10 = this.getNextChar('&', '=');
                        if (var8_10 == 0) {
                            return 29;
                        }
                        if (var8_10 > 0) {
                            return 97;
                        }
                        return 22;
                    }
                    case '|': {
                        var8_10 = this.getNextChar('|', '=');
                        if (var8_10 == 0) {
                            return 31;
                        }
                        if (var8_10 > 0) {
                            return 98;
                        }
                        return 28;
                    }
                    case '^': {
                        if (this.getNextChar('=')) {
                            return 99;
                        }
                        return 24;
                    }
                    case '?': {
                        return 30;
                    }
                    case ':': {
                        if (this.getNextChar(':')) {
                            return 7;
                        }
                        ++this.yieldColons;
                        return 65;
                    }
                    case '\'': {
                        var8_10 = this.getNextChar('\n', '\r');
                        if (var8_10 == 0) {
                            throw new InvalidInputException("Invalid_Character_Constant");
                        }
                        if (var8_10 > 0) {
                            for (var9_12 = 0; var9_12 < 3 && this.currentPosition + var9_12 != this.eofPosition && this.source[this.currentPosition + var9_12] != '\n'; ++var9_12) {
                                if (this.source[this.currentPosition + var9_12] != '\'') continue;
                                this.currentPosition += var9_12 + 1;
                                break;
                            }
                            throw new InvalidInputException("Invalid_Character_Constant");
                        }
                        if (this.getNextChar('\'')) {
                            for (var8_10 = 0; var8_10 < 3 && this.currentPosition + var8_10 != this.eofPosition && this.source[this.currentPosition + var8_10] != '\n'; ++var8_10) {
                                if (this.source[this.currentPosition + var8_10] != '\'') continue;
                                this.currentPosition += var8_10 + 1;
                                break;
                            }
                            throw new InvalidInputException("Invalid_Character_Constant");
                        }
                        if (this.getNextChar('\\')) {
                            if (this.unicodeAsBackSlash) {
                                this.unicodeAsBackSlash = false;
                                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                } else if (this.withoutUnicodePtr != 0) {
                                    this.unicodeStore();
                                }
                            } else {
                                this.currentCharacter = this.source[this.currentPosition++];
                            }
                            this.scanEscapeCharacter();
                        } else {
                            this.unicodeAsBackSlash = false;
                            var6_7 = false;
                            try {
                                this.currentCharacter = this.source[this.currentPosition++];
                                var6_7 = this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u';
                            }
                            catch (IndexOutOfBoundsException var8_11) {
                                --this.currentPosition;
                                throw new InvalidInputException("Invalid_Character_Constant");
                            }
                            if (var6_7) {
                                this.getNextUnicodeChar();
                            } else if (this.withoutUnicodePtr != 0) {
                                this.unicodeStore();
                            }
                        }
                        if (this.getNextChar('\'')) {
                            return 59;
                        }
                        for (var8_10 = 0; var8_10 < 20 && this.currentPosition + var8_10 != this.eofPosition && this.source[this.currentPosition + var8_10] != '\n'; ++var8_10) {
                            if (this.source[this.currentPosition + var8_10] != '\'') continue;
                            this.currentPosition += var8_10 + 1;
                            break;
                        }
                        throw new InvalidInputException("Invalid_Character_Constant");
                    }
                    case '\"': {
                        return this.scanForStringLiteral();
                    }
                    case '/': {
                        if (this.skipComments) ** GOTO lbl354
                        var8_10 = this.getNextChar('/', '*');
                        if (var8_10 != 0) ** GOTO lbl283
                        this.lastCommentLinePosition = this.currentPosition--;
                        try {
                            this.currentCharacter = this.source[this.currentPosition++];
                            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                this.getNextUnicodeChar();
                            }
                            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                ++this.currentPosition;
                            }
                            var9_13 = false;
                            while (this.currentCharacter != '\r' && this.currentCharacter != '\n') {
                                if (this.currentPosition >= this.eofPosition) {
                                    this.lastCommentLinePosition = this.currentPosition++;
                                    throw new IndexOutOfBoundsException();
                                }
                                this.lastCommentLinePosition = this.currentPosition;
                                var9_13 = false;
                                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                    var9_13 = true;
                                }
                                if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                ++this.currentPosition;
                            }
                            if (this.currentCharacter == '\r' && this.eofPosition > this.currentPosition) {
                                if (this.source[this.currentPosition] == '\n') {
                                    ++this.currentPosition;
                                    this.currentCharacter = (char)10;
                                } else if (this.source[this.currentPosition] == '\\' && this.source[this.currentPosition + 1] == 'u') {
                                    this.getNextUnicodeChar();
                                    var9_13 = true;
                                }
                            }
                            this.recordComment(1001);
                            if (this.taskTags != null) {
                                this.checkTaskTag(this.startPosition, this.currentPosition);
                            }
                            if (this.currentCharacter == '\r' || this.currentCharacter == '\n') {
                                if ((this.checkNonExternalizedStringLiterals || this.checkUninternedIdentityComparison) && this.lastPosition < this.currentPosition) {
                                    this.parseTags();
                                }
                                if (this.recordLineSeparator) {
                                    if (var9_13) {
                                        this.pushUnicodeLineSeparator();
                                    } else {
                                        this.pushLineSeparator();
                                    }
                                }
                            }
                            if (!this.tokenizeComments) ** GOTO lbl-1000
                            return 1001;
                        }
                        catch (IndexOutOfBoundsException var9_14) {
                            this.recordComment(1001);
                            if (this.taskTags != null) {
                                this.checkTaskTag(this.startPosition, this.currentPosition);
                            }
                            if ((this.checkNonExternalizedStringLiterals || this.checkUninternedIdentityComparison) && this.lastPosition < this.currentPosition) {
                                this.parseTags();
                            }
                            if (this.tokenizeComments) {
                                return 1001;
                            }
                            continue block48;
                        }
lbl283:
                        // 1 sources

                        if (var8_10 > 0) {
                            try {
                                var9_15 = false;
                                var10_18 = '\u0000';
                                var11_19 = false;
                                this.unicodeAsBackSlash = false;
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                    var11_19 = true;
                                } else {
                                    var11_19 = false;
                                    if (this.withoutUnicodePtr != 0) {
                                        this.unicodeStore();
                                    }
                                }
                                if (this.currentCharacter == '*') {
                                    var9_15 = true;
                                    var10_18 = '\u0001';
                                }
                                if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                                    if (var11_19) {
                                        this.pushUnicodeLineSeparator();
                                    } else {
                                        this.pushLineSeparator();
                                    }
                                }
                                var11_19 = false;
                                var12_20 = this.currentPosition;
                                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                    var11_19 = true;
                                } else {
                                    var11_19 = false;
                                }
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                    ++this.currentPosition;
                                }
                                if (this.currentCharacter == '/') {
                                    var9_15 = false;
                                }
                                var13_21 = 0;
                                while (this.currentCharacter != '/' || var10_18 == '\u0000') {
                                    if (this.currentPosition >= this.eofPosition) {
                                        throw new InvalidInputException("Unterminated_Comment");
                                    }
                                    if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                                        if (var11_19) {
                                            this.pushUnicodeLineSeparator();
                                        } else {
                                            this.pushLineSeparator();
                                        }
                                    }
                                    switch (this.currentCharacter) {
                                        case '*': {
                                            var10_18 = '\u0001';
                                            break;
                                        }
                                        case '@': {
                                            if (var13_21 == 0 && this.isFirstTag()) {
                                                var13_21 = var12_20;
                                            }
                                        }
                                        default: {
                                            var10_18 = '\u0000';
                                        }
                                    }
                                    var12_20 = this.currentPosition;
                                    this.currentCharacter = this.source[this.currentPosition++];
                                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                        var11_19 = true;
                                    } else {
                                        var11_19 = false;
                                    }
                                    if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                    ++this.currentPosition;
                                }
                                var14_22 = var9_15 != false ? 1003 : 1002;
                                this.recordComment(var14_22);
                                this.commentTagStarts[this.commentPtr] = var13_21;
                                if (this.taskTags != null) {
                                    this.checkTaskTag(this.startPosition, this.currentPosition);
                                }
                                if (!this.tokenizeComments) continue block47;
                                return var14_22;
                            }
                            catch (IndexOutOfBoundsException var9_16) {
                                --this.currentPosition;
                                throw new InvalidInputException("Unterminated_Comment");
                            }
                        }
lbl354:
                        // 3 sources

                        if (this.getNextChar('=')) {
                            return 96;
                        }
                        return 10;
                    }
                    case '\u001a': {
                        if (this.atEnd()) {
                            return 64;
                        }
                        throw new InvalidInputException("Ctrl-Z");
                    }
                    default: {
                        var8_10 = this.currentCharacter;
                        if (var8_10 < 128) {
                            if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[var8_10] & 64) != 0) {
                                return this.scanIdentifierOrKeyword();
                            }
                            if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[var8_10] & 4) != 0) {
                                return this.scanNumber(false);
                            }
                            return 136;
                        }
                        if (var8_10 >= 55296 && var8_10 <= 56319) {
                            if (this.complianceLevel < 0x310000L) {
                                throw new InvalidInputException("Invalid_Unicode_Escape");
                            }
                            var10_18 = (char)this.getNextChar();
                            if (var10_18 < '\udc00' || var10_18 > '\udfff') {
                                throw new InvalidInputException("Invalid_Low_Surrogate");
                            }
                            var9_17 = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, (char)var8_10, var10_18);
                        } else {
                            if (var8_10 >= 56320 && var8_10 <= 57343) {
                                if (this.complianceLevel < 0x310000L) {
                                    throw new InvalidInputException("Invalid_Unicode_Escape");
                                }
                                throw new InvalidInputException("Invalid_High_Surrogate");
                            }
                            var9_17 = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, (char)var8_10);
                        }
                        if (var9_17) {
                            return this.scanIdentifierOrKeyword();
                        }
                        if (ScannerHelper.isDigit(this.currentCharacter)) {
                            return this.scanNumber(false);
                        }
                        return 136;
                    }
                }
            }
            break;
        }
        catch (IndexOutOfBoundsException var2_3) {
            if (this.tokenizeWhiteSpace && var1_1 != this.currentPosition - 1) {
                --this.currentPosition;
                this.startPosition = var1_1;
                return 1000;
            }
            return 64;
        }
    }

    private int scanForStringLiteral() throws InvalidInputException {
        boolean bl = false;
        this.unicodeAsBackSlash = false;
        boolean bl2 = false;
        bl = this.scanForTextBlockBeginning();
        if (bl) {
            return this.scanForTextBlock();
        }
        try {
            this.unicodeAsBackSlash = false;
            bl2 = false;
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                this.getNextUnicodeChar();
                bl2 = true;
            } else if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            while (this.currentCharacter != '\"') {
                if (this.currentPosition >= this.eofPosition) {
                    throw new InvalidInputException(UNTERMINATED_STRING);
                }
                if (this.currentCharacter == '\n' || this.currentCharacter == '\r') {
                    if (bl2) {
                        int n = this.currentPosition;
                        for (int i = 0; i < 50; ++i) {
                            if (this.currentPosition >= this.eofPosition) {
                                this.currentPosition = n;
                                break;
                            }
                            if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                bl2 = true;
                                this.getNextUnicodeChar();
                            } else {
                                bl2 = false;
                            }
                            if (!bl2 && this.currentCharacter == '\n') {
                                --this.currentPosition;
                                break;
                            }
                            if (this.currentCharacter != '\"') continue;
                            throw new InvalidInputException(INVALID_CHAR_IN_STRING);
                        }
                    } else {
                        --this.currentPosition;
                    }
                    throw new InvalidInputException(INVALID_CHAR_IN_STRING);
                }
                if (this.currentCharacter == '\\') {
                    if (this.unicodeAsBackSlash) {
                        --this.withoutUnicodePtr;
                        this.unicodeAsBackSlash = false;
                        if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                            this.getNextUnicodeChar();
                            bl2 = true;
                            --this.withoutUnicodePtr;
                        } else {
                            bl2 = false;
                        }
                    } else {
                        if (this.withoutUnicodePtr == 0) {
                            this.unicodeInitializeBuffer(this.currentPosition - this.startPosition);
                        }
                        --this.withoutUnicodePtr;
                        this.currentCharacter = this.source[this.currentPosition++];
                    }
                    this.scanEscapeCharacter();
                    if (this.withoutUnicodePtr != 0) {
                        this.unicodeStore();
                    }
                }
                this.unicodeAsBackSlash = false;
                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                    this.getNextUnicodeChar();
                    bl2 = true;
                    continue;
                }
                bl2 = false;
                if (this.withoutUnicodePtr == 0) continue;
                this.unicodeStore();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            --this.currentPosition;
            throw new InvalidInputException(UNTERMINATED_STRING);
        }
        catch (InvalidInputException invalidInputException) {
            if (invalidInputException.getMessage().equals(INVALID_ESCAPE)) {
                for (int i = 0; i < 50 && this.currentPosition + i != this.eofPosition && this.source[this.currentPosition + i] != '\n'; ++i) {
                    if (this.source[this.currentPosition + i] != '\"') continue;
                    this.currentPosition += i + 1;
                    break;
                }
            }
            throw invalidInputException;
        }
        return 60;
    }

    protected int scanForTextBlock() throws InvalidInputException {
        int n = 0;
        try {
            this.rawStart = this.currentPosition - this.startPosition;
            block8: while (this.currentPosition <= this.eofPosition) {
                block23: {
                    if (this.currentCharacter == '\"') {
                        n = this.currentPosition;
                        if (this.scanForTextBlockClose()) {
                            this.currentPosition += 2;
                            return 61;
                        }
                        if (this.withoutUnicodePtr != 0) {
                            this.unicodeStore();
                        }
                    } else if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                        this.pushLineSeparator();
                    }
                    if (this.currentCharacter == '\\') {
                        switch (this.source[this.currentPosition]) {
                            case 'f': 
                            case 'n': 
                            case 'r': 
                            case 's': {
                                break block23;
                            }
                            case '\n': 
                            case '\r': {
                                this.currentCharacter = (char)92;
                                ++this.currentPosition;
                                break;
                            }
                            case '\"': {
                                ++this.currentPosition;
                                this.currentCharacter = this.source[this.currentPosition++];
                                continue block8;
                            }
                            case '\\': {
                                ++this.currentPosition;
                                break;
                            }
                            default: {
                                if (this.unicodeAsBackSlash) {
                                    --this.withoutUnicodePtr;
                                    if (this.currentPosition >= this.eofPosition) break;
                                    this.unicodeAsBackSlash = false;
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                        --this.withoutUnicodePtr;
                                    }
                                } else {
                                    if (this.withoutUnicodePtr == 0) {
                                        this.unicodeInitializeBuffer(this.currentPosition - this.startPosition);
                                    }
                                    --this.withoutUnicodePtr;
                                    this.currentCharacter = this.source[this.currentPosition++];
                                }
                                int n2 = this.currentPosition - 1;
                                this.scanEscapeCharacter();
                                if (!ScannerHelper.isWhitespace(this.currentCharacter)) break;
                                if (this.withoutUnicodePtr == 0) {
                                    this.unicodeInitializeBuffer(this.currentPosition - this.startPosition);
                                }
                                this.unicodeStore('\\');
                                this.currentPosition = n2;
                                this.currentCharacter = this.source[this.currentPosition];
                                break block23;
                            }
                        }
                        if (this.withoutUnicodePtr != 0) {
                            this.unicodeStore();
                        }
                    }
                }
                this.unicodeAsBackSlash = false;
                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                    this.getNextUnicodeChar();
                    continue;
                }
                if (this.currentCharacter == '\"' || this.withoutUnicodePtr == 0) continue;
                this.unicodeStore();
            }
            if (n > 0) {
                this.currentPosition = n;
            }
            this.currentPosition = n > 0 ? n : this.startPosition + this.rawStart;
            throw new InvalidInputException(UNTERMINATED_TEXT_BLOCK);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.currentPosition = n > 0 ? n : this.startPosition + this.rawStart;
            throw new InvalidInputException(UNTERMINATED_TEXT_BLOCK);
        }
    }

    public void getNextUnicodeChar() throws InvalidInputException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 6;
        ++this.currentPosition;
        if (this.currentPosition < this.eofPosition) {
            while (this.source[this.currentPosition] == 'u') {
                ++this.currentPosition;
                if (this.currentPosition >= this.eofPosition) {
                    --this.currentPosition;
                    throw new InvalidInputException(INVALID_UNICODE_ESCAPE);
                }
                ++n5;
            }
        } else {
            --this.currentPosition;
            throw new InvalidInputException(INVALID_UNICODE_ESCAPE);
        }
        if (this.currentPosition + 4 > this.eofPosition) {
            this.currentPosition += this.eofPosition - this.currentPosition;
            throw new InvalidInputException(INVALID_UNICODE_ESCAPE);
        }
        if ((n = ScannerHelper.getHexadecimalValue(this.source[this.currentPosition++])) > 15 || n < 0 || (n2 = ScannerHelper.getHexadecimalValue(this.source[this.currentPosition++])) > 15 || n2 < 0 || (n3 = ScannerHelper.getHexadecimalValue(this.source[this.currentPosition++])) > 15 || n3 < 0 || (n4 = ScannerHelper.getHexadecimalValue(this.source[this.currentPosition++])) > 15 || n4 < 0) {
            throw new InvalidInputException(INVALID_UNICODE_ESCAPE);
        }
        this.currentCharacter = (char)(((n * 16 + n2) * 16 + n3) * 16 + n4);
        if (this.withoutUnicodePtr == 0) {
            this.unicodeInitializeBuffer(this.currentPosition - n5 - this.startPosition);
        }
        this.unicodeStore();
        this.unicodeAsBackSlash = this.currentCharacter == '\\';
    }

    public NLSTag[] getNLSTags() {
        int n = this.nlsTagsPtr;
        if (n != 0) {
            NLSTag[] nLSTagArray = new NLSTag[n];
            System.arraycopy(this.nlsTags, 0, nLSTagArray, 0, n);
            this.nlsTagsPtr = 0;
            return nLSTagArray;
        }
        return null;
    }

    public boolean[] getIdentityComparisonLines() {
        boolean[] blArray = this.validIdentityComparisonLines;
        this.validIdentityComparisonLines = null;
        return blArray;
    }

    public char[] getSource() {
        return this.source;
    }

    protected boolean isFirstTag() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public final void jumpOverMethodBody() {
        this.wasAcr = false;
        var1_1 = 1;
        block37: while (true) {
            block38: while (true) {
                this.withoutUnicodePtr = 0;
                do {
                    this.startPosition = ++this.currentPosition;
                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                        var2_2 = this.jumpOverUnicodeWhiteSpace();
                        continue;
                    }
                    if (this.recordLineSeparator && (this.currentCharacter == '\r' || this.currentCharacter == '\n')) {
                        this.pushLineSeparator();
                    }
                    var2_2 = CharOperation.isWhitespace(this.currentCharacter);
                } while (var2_2);
                block10 : switch (this.currentCharacter) {
                    case '{': {
                        ++var1_1;
                        break;
                    }
                    case '}': {
                        if (--var1_1 != 0) continue block37;
                        return;
                    }
                    case '\'': {
                        var3_4 = this.getNextChar('\\');
                        if (var3_4) {
                            try {
                                if (this.unicodeAsBackSlash) {
                                    this.unicodeAsBackSlash = false;
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                    } else if (this.withoutUnicodePtr != 0) {
                                        this.unicodeStore();
                                    }
                                } else {
                                    this.currentCharacter = this.source[this.currentPosition++];
                                }
                                this.scanEscapeCharacter();
                            }
                            catch (InvalidInputException var4_5) {}
                        } else {
                            try {
                                this.unicodeAsBackSlash = false;
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                } else if (this.withoutUnicodePtr != 0) {
                                    this.unicodeStore();
                                }
                            }
                            catch (InvalidInputException var4_6) {
                                // empty catch block
                            }
                        }
                        this.getNextChar('\'');
                        break;
                    }
                    case '\"': {
                        var3_4 = false;
                        var4_7 = 0;
                        try {
                            try {
                                var3_4 = this.scanForTextBlockBeginning();
                                if (!var3_4) {
                                    this.unicodeAsBackSlash = false;
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                    } else if (this.withoutUnicodePtr != 0) {
                                        this.unicodeStore();
                                    }
                                }
                            }
                            catch (InvalidInputException var5_8) {
                                // empty catch block
                            }
                            while (true) {
                                if (this.currentPosition > this.eofPosition) continue block37;
                                if (!var3_4) ** GOTO lbl96
                                switch (this.currentCharacter) {
                                    case '\"': {
                                        if (this.scanForTextBlockClose()) {
                                            this.currentPosition += 2;
                                            this.currentCharacter = this.source[this.currentPosition];
                                            var3_4 = false;
                                            break block10;
                                        }
                                        ** GOTO lbl97
                                    }
                                    case '}': {
                                        if (var4_7 == 0) {
                                            var4_7 = this.currentPosition;
                                        }
                                        ** GOTO lbl97
                                    }
                                    case '\r': {
                                        if (this.source[this.currentPosition] == '\n') {
                                            ++this.currentPosition;
                                        }
                                    }
                                    case '\n': {
                                        this.pushLineSeparator();
                                    }
                                    default: {
                                        if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\"') {
                                            ++this.currentPosition;
                                        }
                                        this.currentCharacter = this.source[this.currentPosition++];
                                        break;
                                    }
                                }
                                continue;
lbl96:
                                // 1 sources

                                if (this.currentCharacter == '\"') continue block38;
lbl97:
                                // 3 sources

                                if (this.currentCharacter == '\r') {
                                    if (this.source[this.currentPosition] != '\n') continue block37;
                                    break block10;
                                }
                                if (this.currentCharacter == '\n') continue block38;
                                if (this.currentCharacter == '\\') {
                                    try {
                                        if (this.unicodeAsBackSlash) {
                                            this.unicodeAsBackSlash = false;
                                            if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                                this.getNextUnicodeChar();
                                            } else if (this.withoutUnicodePtr != 0) {
                                                this.unicodeStore();
                                            }
                                        } else {
                                            this.currentCharacter = this.source[this.currentPosition++];
                                        }
                                        this.scanEscapeCharacter();
                                    }
                                    catch (InvalidInputException var5_9) {
                                        // empty catch block
                                    }
                                }
                                try {
                                    this.unicodeAsBackSlash = false;
                                    this.currentCharacter = this.source[this.currentPosition++];
                                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                        continue;
                                    }
                                    if (this.withoutUnicodePtr == 0) continue;
                                    this.unicodeStore();
                                }
                                catch (InvalidInputException var5_10) {}
                            }
                        }
                        catch (IndexOutOfBoundsException var5_11) {
                            if (!var3_4 || var4_7 <= 0) continue block37;
                            this.currentPosition = var4_7 - 1;
                            break;
                        }
                    }
                    case '/': {
                        var5_12 = this.getNextChar('/', '*');
                        if (var5_12 == 0) {
                            try {
                                this.lastCommentLinePosition = this.currentPosition;
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                }
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                    ++this.currentPosition;
                                }
                                var6_15 = false;
                                while (this.currentCharacter != '\r' && this.currentCharacter != '\n') {
                                    if (this.currentPosition >= this.eofPosition) {
                                        this.lastCommentLinePosition = this.currentPosition++;
                                        throw new IndexOutOfBoundsException();
                                    }
                                    this.lastCommentLinePosition = this.currentPosition;
                                    var6_15 = false;
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        var6_15 = true;
                                        this.getNextUnicodeChar();
                                    }
                                    if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                    ++this.currentPosition;
                                }
                                if (this.currentCharacter == '\r' && this.eofPosition > this.currentPosition) {
                                    if (this.source[this.currentPosition] == '\n') {
                                        ++this.currentPosition;
                                        this.currentCharacter = (char)10;
                                    } else if (this.source[this.currentPosition] == '\\' && this.source[this.currentPosition + 1] == 'u') {
                                        var6_15 = true;
                                        this.getNextUnicodeChar();
                                    }
                                }
                                this.recordComment(1001);
                                if (!this.recordLineSeparator || this.currentCharacter != '\r' && this.currentCharacter != '\n') continue block37;
                                if ((this.checkNonExternalizedStringLiterals || this.checkUninternedIdentityComparison) && this.lastPosition < this.currentPosition) {
                                    this.parseTags();
                                }
                                if (!this.recordLineSeparator) continue block37;
                                if (var6_15) {
                                    this.pushUnicodeLineSeparator();
                                    break;
                                }
                                this.pushLineSeparator();
                            }
                            catch (IndexOutOfBoundsException var6_16) {
                                --this.currentPosition;
                                this.recordComment(1001);
                                if ((this.checkNonExternalizedStringLiterals || this.checkUninternedIdentityComparison) && this.lastPosition < this.currentPosition) {
                                    this.parseTags();
                                }
                                if (this.tokenizeComments) continue block37;
                                ++this.currentPosition;
                            }
                            continue block38;
                        }
                        if (var5_12 <= 0) continue block37;
                        var6_17 = false;
                        try {
                            var7_19 = '\u0000';
                            var9_22 = false;
                            this.unicodeAsBackSlash = false;
                            this.currentCharacter = this.source[this.currentPosition++];
                            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                this.getNextUnicodeChar();
                                var9_22 = true;
                            } else {
                                var9_22 = false;
                                if (this.withoutUnicodePtr != 0) {
                                    this.unicodeStore();
                                }
                            }
                            if (this.currentCharacter == '*') {
                                var6_17 = true;
                                var7_19 = '\u0001';
                            }
                            if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                                if (var9_22) {
                                    this.pushUnicodeLineSeparator();
                                } else {
                                    this.pushLineSeparator();
                                }
                            }
                            var9_22 = false;
                            var8_21 = this.currentPosition;
                            if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                this.getNextUnicodeChar();
                                var9_22 = true;
                            } else {
                                var9_22 = false;
                            }
                            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                ++this.currentPosition;
                            }
                            if (this.currentCharacter == '/') {
                                var6_17 = false;
                            }
                            var10_23 = 0;
                            while (this.currentCharacter != '/' || var7_19 == '\u0000') {
                                if (this.currentPosition >= this.eofPosition) {
                                    return;
                                }
                                if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                                    if (var9_22) {
                                        this.pushUnicodeLineSeparator();
                                    } else {
                                        this.pushLineSeparator();
                                    }
                                }
                                switch (this.currentCharacter) {
                                    case '*': {
                                        var7_19 = '\u0001';
                                        break;
                                    }
                                    case '@': {
                                        if (var10_23 == 0 && this.isFirstTag()) {
                                            var10_23 = var8_21;
                                        }
                                    }
                                    default: {
                                        var7_19 = '\u0000';
                                    }
                                }
                                var8_21 = this.currentPosition;
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                    var9_22 = true;
                                } else {
                                    var9_22 = false;
                                }
                                if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                ++this.currentPosition;
                            }
                            this.recordComment(var6_17 != false ? 1003 : 1002);
                            this.commentTagStarts[this.commentPtr] = var10_23;
                            break;
                        }
                        catch (IndexOutOfBoundsException var7_20) {
                            return;
                        }
                    }
                    default: {
                        try {
                            var5_13 = this.currentCharacter;
                            if (var5_13 < '\u0080') {
                                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[var5_13] & 64) != 0) {
                                    this.scanIdentifierOrKeyword();
                                    break;
                                }
                                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[var5_13] & 4) == 0) continue block37;
                                this.scanNumber(false);
                                break;
                            }
                            if (var5_13 >= '\ud800' && var5_13 <= '\udbff') {
                                if (this.complianceLevel < 0x310000L) {
                                    throw new InvalidInputException("Invalid_Unicode_Escape");
                                }
                                var7_19 = (char)this.getNextChar();
                                if (var7_19 < '\udc00') continue block37;
                                if (var7_19 > '\udfff') continue block38;
                                var6_18 = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, var5_13, var7_19);
                            } else {
                                if (var5_13 >= '\udc00' && var5_13 <= '\udfff') continue block38;
                                var6_18 = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, var5_13);
                            }
                            if (var6_18) ** break;
                            continue block37;
                            this.scanIdentifierOrKeyword();
                            break;
                        }
                        catch (InvalidInputException var5_14) {
                            // empty catch block
                        }
                    }
                }
            }
            break;
        }
        catch (IndexOutOfBoundsException | InvalidInputException var2_3) {
            return;
        }
    }

    public final boolean jumpOverUnicodeWhiteSpace() throws InvalidInputException {
        this.wasAcr = false;
        this.getNextUnicodeChar();
        return CharOperation.isWhitespace(this.currentCharacter);
    }

    public boolean isInModuleDeclaration() {
        return this.fakeInModule || this.insideModuleInfo || this.activeParser != null && this.activeParser.isParsingModuleDeclaration();
    }

    protected boolean areRestrictedModuleKeywordsActive() {
        return this.scanContext != null && this.scanContext != ScanContext.INACTIVE;
    }

    void updateScanContext(int n) {
        switch (n) {
            case 25: 
            case 26: 
            case 33: {
                this.scanContext = ScanContext.EXPECTING_KEYWORD;
                break;
            }
            case 119: {
                this.scanContext = ScanContext.EXPECTING_KEYWORD;
                break;
            }
            case 122: {
                this.scanContext = ScanContext.AFTER_REQUIRES;
                break;
            }
            case 1: 
            case 27: 
            case 32: 
            case 36: 
            case 111: 
            case 118: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 132: 
            case 133: {
                this.scanContext = ScanContext.EXPECTING_IDENTIFIER;
                break;
            }
            case 19: {
                this.scanContext = ScanContext.EXPECTING_KEYWORD;
                break;
            }
            case 39: {
                this.scanContext = ScanContext.EXPECTING_KEYWORD;
                break;
            }
        }
    }

    private void parseTags() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = this.startPosition;
        int n6 = this.linePtr;
        if (n6 >= 0) {
            n4 = this.lineEnds[n6] + 1;
        }
        while (ScannerHelper.isWhitespace(this.source[n4])) {
            ++n4;
        }
        if (n5 == n4) {
            return;
        }
        char[] cArray = null;
        int n7 = this.currentPosition;
        int n8 = n5;
        int n9 = 0;
        if (this.withoutUnicodePtr != 0) {
            cArray = new char[this.withoutUnicodePtr];
            System.arraycopy(this.withoutUnicodeBuffer, 1, cArray, 0, this.withoutUnicodePtr);
            n7 = this.withoutUnicodePtr;
            n8 = 1;
            n9 = n5;
        } else {
            cArray = this.source;
        }
        if (this.checkNonExternalizedStringLiterals && (n3 = CharOperation.indexOf(TAG_PREFIX, cArray, true, n8, n7)) != -1) {
            if (this.nlsTags == null) {
                this.nlsTags = new NLSTag[10];
                this.nlsTagsPtr = 0;
            }
            while (n3 != -1) {
                n2 = n3 + TAG_PREFIX_LENGTH;
                n = CharOperation.indexOf('$', cArray, n2, n7);
                if (n != -1) {
                    NLSTag nLSTag = null;
                    int n10 = n6 + 1;
                    try {
                        nLSTag = new NLSTag(n3 + n9, n + n9, n10, this.extractInt(cArray, n2, n));
                    }
                    catch (NumberFormatException numberFormatException) {
                        nLSTag = new NLSTag(n3 + n9, n + n9, n10, -1);
                    }
                    if (this.nlsTagsPtr == this.nlsTags.length) {
                        this.nlsTags = new NLSTag[this.nlsTagsPtr + 10];
                        System.arraycopy(this.nlsTags, 0, this.nlsTags, 0, this.nlsTagsPtr);
                    }
                    this.nlsTags[this.nlsTagsPtr++] = nLSTag;
                } else {
                    n = n2;
                }
                n3 = CharOperation.indexOf(TAG_PREFIX, cArray, true, n, n7);
            }
        }
        if (this.checkUninternedIdentityComparison && (n3 = CharOperation.indexOf(IDENTITY_COMPARISON_TAG, cArray, true, n8, n7)) != -1) {
            if (this.validIdentityComparisonLines == null) {
                this.validIdentityComparisonLines = new boolean[0];
            }
            n2 = n6 + 1;
            n = this.validIdentityComparisonLines.length;
            this.validIdentityComparisonLines = new boolean[n2 + 1];
            System.arraycopy(this.validIdentityComparisonLines, 0, this.validIdentityComparisonLines, 0, n);
            this.validIdentityComparisonLines[n2] = true;
        }
    }

    private int extractInt(char[] cArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            int n4 = 0;
            switch (c) {
                case '0': {
                    n4 = 0;
                    break;
                }
                case '1': {
                    n4 = 1;
                    break;
                }
                case '2': {
                    n4 = 2;
                    break;
                }
                case '3': {
                    n4 = 3;
                    break;
                }
                case '4': {
                    n4 = 4;
                    break;
                }
                case '5': {
                    n4 = 5;
                    break;
                }
                case '6': {
                    n4 = 6;
                    break;
                }
                case '7': {
                    n4 = 7;
                    break;
                }
                case '8': {
                    n4 = 8;
                    break;
                }
                case '9': {
                    n4 = 9;
                    break;
                }
                default: {
                    throw new NumberFormatException();
                }
            }
            n3 *= 10;
            if (n4 < 0) {
                throw new NumberFormatException();
            }
            n3 += n4;
        }
        return n3;
    }

    public final void pushLineSeparator() {
        block12: {
            if (this.currentCharacter == '\r') {
                int n = this.currentPosition - 1;
                if (this.linePtr >= 0 && this.lineEnds[this.linePtr] >= n) {
                    return;
                }
                int n2 = this.lineEnds.length;
                if (++this.linePtr >= n2) {
                    this.lineEnds = new int[2 * n2 + 250];
                    System.arraycopy(this.lineEnds, 0, this.lineEnds, 0, n2);
                }
                this.lineEnds[this.linePtr] = n;
                try {
                    if (this.source[this.currentPosition] == '\n') {
                        this.lineEnds[this.linePtr] = this.currentPosition++;
                        this.wasAcr = false;
                        break block12;
                    }
                    this.wasAcr = true;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.wasAcr = true;
                }
            } else if (this.currentCharacter == '\n') {
                if (this.wasAcr && this.lineEnds[this.linePtr] == this.currentPosition - 2) {
                    this.lineEnds[this.linePtr] = this.currentPosition - 1;
                } else {
                    int n = this.currentPosition - 1;
                    if (this.linePtr >= 0 && this.lineEnds[this.linePtr] >= n) {
                        return;
                    }
                    int n3 = this.lineEnds.length;
                    if (++this.linePtr >= n3) {
                        this.lineEnds = new int[2 * n3 + 250];
                        System.arraycopy(this.lineEnds, 0, this.lineEnds, 0, n3);
                    }
                    this.lineEnds[this.linePtr] = n;
                }
                this.wasAcr = false;
            }
        }
    }

    public final void pushUnicodeLineSeparator() {
        if (this.currentCharacter == '\r') {
            this.wasAcr = this.source[this.currentPosition] != '\n';
        } else if (this.currentCharacter == '\n') {
            this.wasAcr = false;
        }
    }

    public void recordComment(int n) {
        int n2 = this.startPosition;
        int n3 = this.currentPosition;
        switch (n) {
            case 1001: {
                n2 = -this.startPosition;
                n3 = -this.lastCommentLinePosition;
                break;
            }
            case 1002: {
                n3 = -this.currentPosition;
            }
        }
        int n4 = this.commentStops.length;
        if (++this.commentPtr >= n4) {
            int n5 = n4 + 300;
            this.commentStops = new int[n5];
            System.arraycopy(this.commentStops, 0, this.commentStops, 0, n4);
            this.commentStarts = new int[n5];
            System.arraycopy(this.commentStarts, 0, this.commentStarts, 0, n4);
            this.commentTagStarts = new int[n5];
            System.arraycopy(this.commentTagStarts, 0, this.commentTagStarts, 0, n4);
        }
        this.commentStops[this.commentPtr] = n3;
        this.commentStarts[this.commentPtr] = n2;
    }

    public void resetTo(int n, int n2) {
        this.resetTo(n, n2, this.isInModuleDeclaration());
    }

    public void resetTo(int n, int n2, boolean bl) {
        this.resetTo(n, n2, bl, null);
    }

    public void resetTo(int n, int n2, boolean bl, ScanContext scanContext) {
        this.diet = false;
        this.startPosition = this.currentPosition = n;
        this.initialPosition = this.currentPosition;
        this.eofPosition = this.source != null && this.source.length < n2 ? this.source.length : (n2 < Integer.MAX_VALUE ? n2 + 1 : n2);
        this.commentPtr = -1;
        this.foundTaskCount = 0;
        this.nextToken = 0;
        this.lookBack[1] = 0;
        this.lookBack[0] = 0;
        this.consumingEllipsisAnnotations = false;
        this.insideModuleInfo = bl;
        this.scanContext = scanContext == null ? this.getScanContext(n) : scanContext;
        this.multiCaseLabelComma = false;
    }

    private ScanContext getScanContext(int n) {
        if (!this.isInModuleDeclaration()) {
            return ScanContext.INACTIVE;
        }
        if (n == 0) {
            return ScanContext.EXPECTING_KEYWORD;
        }
        CompilerOptions compilerOptions = new CompilerOptions();
        compilerOptions.complianceLevel = this.complianceLevel;
        compilerOptions.sourceLevel = this.sourceLevel;
        ScanContextDetector scanContextDetector = new ScanContextDetector(compilerOptions);
        return scanContextDetector.getScanContext(this.source, n - 1);
    }

    protected final void scanEscapeCharacter() throws InvalidInputException {
        switch (this.currentCharacter) {
            case 'b': {
                this.currentCharacter = (char)8;
                break;
            }
            case 't': {
                this.currentCharacter = (char)9;
                break;
            }
            case 'n': {
                this.currentCharacter = (char)10;
                break;
            }
            case 'f': {
                this.currentCharacter = (char)12;
                break;
            }
            case 'r': {
                this.currentCharacter = (char)13;
                break;
            }
            case '\"': {
                this.currentCharacter = (char)34;
                break;
            }
            case '\'': {
                this.currentCharacter = (char)39;
                break;
            }
            case 's': {
                if (this.sourceLevel < 0x3B0000L) {
                    throw new InvalidInputException(INVALID_ESCAPE);
                }
                this.currentCharacter = (char)32;
                break;
            }
            case '\\': {
                this.currentCharacter = (char)92;
                break;
            }
            default: {
                int n = ScannerHelper.getHexadecimalValue(this.currentCharacter);
                if (n >= 0 && n <= 7) {
                    boolean bl = n > 3;
                    if (ScannerHelper.isDigit(this.currentCharacter = this.source[this.currentPosition++])) {
                        int n2 = ScannerHelper.getHexadecimalValue(this.currentCharacter);
                        if (n2 >= 0 && n2 <= 7) {
                            n = n * 8 + n2;
                            if (ScannerHelper.isDigit(this.currentCharacter = this.source[this.currentPosition++])) {
                                if (bl) {
                                    --this.currentPosition;
                                } else {
                                    n2 = ScannerHelper.getHexadecimalValue(this.currentCharacter);
                                    if (n2 >= 0 && n2 <= 7) {
                                        n = n * 8 + n2;
                                    } else {
                                        --this.currentPosition;
                                    }
                                }
                            } else {
                                --this.currentPosition;
                            }
                        } else {
                            --this.currentPosition;
                        }
                    } else {
                        --this.currentPosition;
                    }
                    if (n > 255) {
                        throw new InvalidInputException(INVALID_ESCAPE);
                    }
                    this.currentCharacter = (char)n;
                    break;
                }
                throw new InvalidInputException(INVALID_ESCAPE);
            }
        }
    }

    public int scanIdentifierOrKeywordWithBoundCheck() {
        char[] cArray;
        int n;
        this.useAssertAsAnIndentifier = false;
        this.useEnumAsAnIndentifier = false;
        char[] cArray2 = this.source;
        int n2 = this.eofPosition;
        while ((n = ++this.currentPosition) < n2) {
            char c = cArray2[n];
            if (c < '\u0080') {
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 0x3C) != 0) {
                    if (this.withoutUnicodePtr != 0) {
                        this.currentCharacter = c;
                        this.unicodeStore();
                    }
                    continue;
                }
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 0x102) != 0) {
                    this.currentCharacter = c;
                    break;
                }
                while (this.getNextCharAsJavaIdentifierPartWithBoundCheck()) {
                }
            } else {
                while (this.getNextCharAsJavaIdentifierPartWithBoundCheck()) {
                }
            }
            break;
        }
        if (this.withoutUnicodePtr == 0) {
            n2 = this.currentPosition - this.startPosition;
            if (n2 == 1) {
                return 19;
            }
            cArray = this.source;
            n = this.startPosition;
        } else {
            n2 = this.withoutUnicodePtr;
            if (n2 == 1) {
                return 19;
            }
            cArray = this.withoutUnicodeBuffer;
            n = 1;
        }
        return this.internalScanIdentifierOrKeyword(n, n2, cArray);
    }

    public int scanIdentifierOrKeyword() {
        char[] cArray;
        int n;
        this.useAssertAsAnIndentifier = false;
        this.useEnumAsAnIndentifier = false;
        char[] cArray2 = this.source;
        int n2 = this.eofPosition;
        while ((n = ++this.currentPosition) < n2) {
            char c = cArray2[n];
            if (c < '\u0080') {
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 0x3C) != 0) {
                    if (this.withoutUnicodePtr != 0) {
                        this.currentCharacter = c;
                        this.unicodeStore();
                    }
                    continue;
                }
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 0x102) != 0) {
                    this.currentCharacter = c;
                    break;
                }
                while (this.getNextCharAsJavaIdentifierPart()) {
                }
            } else {
                while (this.getNextCharAsJavaIdentifierPart()) {
                }
            }
            break;
        }
        if (this.withoutUnicodePtr == 0) {
            n2 = this.currentPosition - this.startPosition;
            if (n2 == 1) {
                return 19;
            }
            cArray = this.source;
            n = this.startPosition;
        } else {
            n2 = this.withoutUnicodePtr;
            if (n2 == 1) {
                return 19;
            }
            cArray = this.withoutUnicodeBuffer;
            n = 1;
        }
        return this.internalScanIdentifierOrKeyword(n, n2, cArray);
    }

    private int internalScanIdentifierOrKeyword(int n, int n2, char[] cArray) {
        switch (cArray[n]) {
            case 'a': {
                switch (n2) {
                    case 8: {
                        if (cArray[++n] == 'b' && cArray[++n] == 's' && cArray[++n] == 't' && cArray[++n] == 'r' && cArray[++n] == 'a' && cArray[++n] == 'c' && cArray[++n] == 't') {
                            return 42;
                        }
                        return 19;
                    }
                    case 6: {
                        if (cArray[++n] == 's' && cArray[++n] == 's' && cArray[++n] == 'e' && cArray[++n] == 'r' && cArray[++n] == 't') {
                            if (this.sourceLevel >= 0x300000L) {
                                this.containsAssertKeyword = true;
                                return 81;
                            }
                            this.useAssertAsAnIndentifier = true;
                            return 19;
                        }
                        return 19;
                    }
                }
                return 19;
            }
            case 'b': {
                switch (n2) {
                    case 4: {
                        if (cArray[++n] == 'y' && cArray[++n] == 't' && cArray[++n] == 'e') {
                            return 106;
                        }
                        return 19;
                    }
                    case 5: {
                        if (cArray[++n] == 'r' && cArray[++n] == 'e' && cArray[++n] == 'a' && cArray[++n] == 'k') {
                            return 82;
                        }
                        return 19;
                    }
                    case 7: {
                        if (cArray[++n] == 'o' && cArray[++n] == 'o' && cArray[++n] == 'l' && cArray[++n] == 'e' && cArray[++n] == 'a' && cArray[++n] == 'n') {
                            return 105;
                        }
                        return 19;
                    }
                }
                return 19;
            }
            case 'c': {
                switch (n2) {
                    case 4: {
                        if (cArray[++n] == 'a') {
                            if (cArray[++n] == 's' && cArray[++n] == 'e') {
                                return 91;
                            }
                            return 19;
                        }
                        if (cArray[n] == 'h' && cArray[++n] == 'a' && cArray[++n] == 'r') {
                            return 108;
                        }
                        return 19;
                    }
                    case 5: {
                        if (cArray[++n] == 'a') {
                            if (cArray[++n] == 't' && cArray[++n] == 'c' && cArray[++n] == 'h') {
                                return 107;
                            }
                            return 19;
                        }
                        if (cArray[n] == 'l') {
                            if (cArray[++n] == 'a' && cArray[++n] == 's' && cArray[++n] == 's') {
                                return 70;
                            }
                            return 19;
                        }
                        if (cArray[n] == 'o' && cArray[++n] == 'n' && cArray[++n] == 's' && cArray[++n] == 't') {
                            return 134;
                        }
                        return 19;
                    }
                    case 8: {
                        if (cArray[++n] == 'o' && cArray[++n] == 'n' && cArray[++n] == 't' && cArray[++n] == 'i' && cArray[++n] == 'n' && cArray[++n] == 'u' && cArray[++n] == 'e') {
                            return 83;
                        }
                        return 19;
                    }
                }
                return 19;
            }
            case 'd': {
                switch (n2) {
                    case 2: {
                        if (cArray[++n] == 'o') {
                            return 84;
                        }
                        return 19;
                    }
                    case 6: {
                        if (cArray[++n] == 'o' && cArray[++n] == 'u' && cArray[++n] == 'b' && cArray[++n] == 'l' && cArray[++n] == 'e') {
                            return 109;
                        }
                        return 19;
                    }
                    case 7: {
                        if (cArray[++n] == 'e' && cArray[++n] == 'f' && cArray[++n] == 'a' && cArray[++n] == 'u' && cArray[++n] == 'l' && cArray[++n] == 't') {
                            return 76;
                        }
                        return 19;
                    }
                }
                return 19;
            }
            case 'e': {
                switch (n2) {
                    case 4: {
                        if (cArray[++n] == 'l') {
                            if (cArray[++n] == 's' && cArray[++n] == 'e') {
                                return 121;
                            }
                            return 19;
                        }
                        if (cArray[n] == 'n' && cArray[++n] == 'u' && cArray[++n] == 'm') {
                            if (this.sourceLevel >= 0x310000L) {
                                return 74;
                            }
                            this.useEnumAsAnIndentifier = true;
                            return 19;
                        }
                        return 19;
                    }
                    case 7: {
                        if (cArray[++n] == 'x') {
                            if (cArray[++n] == 't' && cArray[++n] == 'e' && cArray[++n] == 'n' && cArray[++n] == 'd' && cArray[++n] == 's') {
                                return 92;
                            }
                            if (this.areRestrictedModuleKeywordsActive() && cArray[n] == 'p' && cArray[++n] == 'o' && cArray[++n] == 'r' && cArray[++n] == 't' && cArray[++n] == 's') {
                                return 123;
                            }
                            return 19;
                        }
                        return 19;
                    }
                }
                return 19;
            }
            case 'f': {
                switch (n2) {
                    case 3: {
                        if (cArray[++n] == 'o' && cArray[++n] == 'r') {
                            return 85;
                        }
                        return 19;
                    }
                    case 5: {
                        if (cArray[++n] == 'i') {
                            if (cArray[++n] == 'n' && cArray[++n] == 'a' && cArray[++n] == 'l') {
                                return 43;
                            }
                            return 19;
                        }
                        if (cArray[n] == 'l') {
                            if (cArray[++n] == 'o' && cArray[++n] == 'a' && cArray[++n] == 't') {
                                return 110;
                            }
                            return 19;
                        }
                        if (cArray[n] == 'a' && cArray[++n] == 'l' && cArray[++n] == 's' && cArray[++n] == 'e') {
                            return 52;
                        }
                        return 19;
                    }
                    case 7: {
                        if (cArray[++n] == 'i' && cArray[++n] == 'n' && cArray[++n] == 'a' && cArray[++n] == 'l' && cArray[++n] == 'l' && cArray[++n] == 'y') {
                            return 116;
                        }
                        return 19;
                    }
                }
                return 19;
            }
            case 'g': {
                if (n2 == 4 && cArray[++n] == 'o' && cArray[++n] == 't' && cArray[++n] == 'o') {
                    return 135;
                }
                return 19;
            }
            case 'i': {
                switch (n2) {
                    case 2: {
                        if (cArray[++n] == 'f') {
                            return 86;
                        }
                        return 19;
                    }
                    case 3: {
                        if (cArray[++n] == 'n' && cArray[++n] == 't') {
                            return 112;
                        }
                        return 19;
                    }
                    case 6: {
                        if (cArray[++n] == 'm' && cArray[++n] == 'p' && cArray[++n] == 'o' && cArray[++n] == 'r' && cArray[++n] == 't') {
                            return 111;
                        }
                        return 19;
                    }
                    case 9: {
                        if (cArray[++n] == 'n' && cArray[++n] == 't' && cArray[++n] == 'e' && cArray[++n] == 'r' && cArray[++n] == 'f' && cArray[++n] == 'a' && cArray[++n] == 'c' && cArray[++n] == 'e') {
                            return 73;
                        }
                        return 19;
                    }
                    case 10: {
                        if (cArray[++n] == 'm') {
                            if (cArray[++n] == 'p' && cArray[++n] == 'l' && cArray[++n] == 'e' && cArray[++n] == 'm' && cArray[++n] == 'e' && cArray[++n] == 'n' && cArray[++n] == 't' && cArray[++n] == 's') {
                                return 131;
                            }
                            return 19;
                        }
                        if (cArray[n] == 'n' && cArray[++n] == 's' && cArray[++n] == 't' && cArray[++n] == 'a' && cArray[++n] == 'n' && cArray[++n] == 'c' && cArray[++n] == 'e' && cArray[++n] == 'o' && cArray[++n] == 'f') {
                            return 17;
                        }
                        return 19;
                    }
                }
                return 19;
            }
            case 'l': {
                if (n2 == 4 && cArray[++n] == 'o' && cArray[++n] == 'n' && cArray[++n] == 'g') {
                    return 113;
                }
                return 19;
            }
            case 'm': {
                switch (n2) {
                    case 6: {
                        if (this.areRestrictedModuleKeywordsActive() && cArray[++n] == 'o' && cArray[++n] == 'd' && cArray[++n] == 'u' && cArray[++n] == 'l' && cArray[++n] == 'e') {
                            return 118;
                        }
                        return 19;
                    }
                }
                return 19;
            }
            case 'n': {
                switch (n2) {
                    case 3: {
                        if (cArray[++n] == 'e' && cArray[++n] == 'w') {
                            return 37;
                        }
                        int n3 = this.checkFor_KeyWord(n - 1, n2, cArray);
                        return n3 != 0 ? n3 : 19;
                    }
                    case 4: {
                        if (cArray[++n] == 'u' && cArray[++n] == 'l' && cArray[++n] == 'l') {
                            return 53;
                        }
                        return 19;
                    }
                    case 6: {
                        if (cArray[++n] == 'a' && cArray[++n] == 't' && cArray[++n] == 'i' && cArray[++n] == 'v' && cArray[++n] == 'e') {
                            return 44;
                        }
                        return 19;
                    }
                }
                return 19;
            }
            case 'o': {
                switch (n2) {
                    case 4: {
                        if (this.areRestrictedModuleKeywordsActive() && cArray[++n] == 'p' && cArray[++n] == 'e' && cArray[++n] == 'n') {
                            return 119;
                        }
                        return 19;
                    }
                    case 5: {
                        if (this.areRestrictedModuleKeywordsActive() && cArray[++n] == 'p' && cArray[++n] == 'e' && cArray[++n] == 'n' && cArray[++n] == 's') {
                            return 124;
                        }
                        return 19;
                    }
                }
                return 19;
            }
            case 'p': {
                switch (n2) {
                    case 6: {
                        if (cArray[++n] == 'u' && cArray[++n] == 'b' && cArray[++n] == 'l' && cArray[++n] == 'i' && cArray[++n] == 'c') {
                            return 48;
                        }
                        return 19;
                    }
                    case 7: {
                        if (cArray[++n] == 'a') {
                            if (cArray[++n] == 'c' && cArray[++n] == 'k' && cArray[++n] == 'a' && cArray[++n] == 'g' && cArray[++n] == 'e') {
                                return 90;
                            }
                            return 19;
                        }
                        if (cArray[n] == 'r' && cArray[++n] == 'i' && cArray[++n] == 'v' && cArray[++n] == 'a' && cArray[++n] == 't' && cArray[++n] == 'e') {
                            return 46;
                        }
                        if (cArray[n] == 'e' && cArray[++n] == 'r' && cArray[++n] == 'm' && cArray[++n] == 'i' && cArray[++n] == 't' && cArray[++n] == 's') {
                            return this.disambiguatedRestrictedIdentifierpermits(127);
                        }
                        return 19;
                    }
                    case 8: {
                        if (this.areRestrictedModuleKeywordsActive() && cArray[++n] == 'r' && cArray[++n] == 'o' && cArray[++n] == 'v' && cArray[++n] == 'i' && cArray[++n] == 'd' && cArray[++n] == 'e' && cArray[++n] == 's') {
                            return 126;
                        }
                        return 19;
                    }
                    case 9: {
                        if (cArray[++n] == 'r' && cArray[++n] == 'o' && cArray[++n] == 't' && cArray[++n] == 'e' && cArray[++n] == 'c' && cArray[++n] == 't' && cArray[++n] == 'e' && cArray[++n] == 'd') {
                            return 47;
                        }
                        return 19;
                    }
                }
                return 19;
            }
            case 'r': {
                switch (n2) {
                    case 6: {
                        if (cArray[++n] == 'e') {
                            if (cArray[++n] == 't' && cArray[++n] == 'u' && cArray[++n] == 'r' && cArray[++n] == 'n') {
                                return 87;
                            }
                            if (cArray[n] == 'c' && cArray[++n] == 'o' && cArray[++n] == 'r' && cArray[++n] == 'd') {
                                return this.disambiguatedRestrictedIdentifierrecord(75);
                            }
                        }
                        return 19;
                    }
                    case 8: {
                        if (this.areRestrictedModuleKeywordsActive() && cArray[++n] == 'e' && cArray[++n] == 'q' && cArray[++n] == 'u' && cArray[++n] == 'i' && cArray[++n] == 'r' && cArray[++n] == 'e' && cArray[++n] == 's') {
                            return 122;
                        }
                        return 19;
                    }
                }
                return 19;
            }
            case 's': {
                switch (n2) {
                    case 5: {
                        if (cArray[++n] == 'h') {
                            if (cArray[++n] == 'o' && cArray[++n] == 'r' && cArray[++n] == 't') {
                                return 114;
                            }
                            return 19;
                        }
                        if (cArray[n] == 'u' && cArray[++n] == 'p' && cArray[++n] == 'e' && cArray[++n] == 'r') {
                            return 34;
                        }
                        return 19;
                    }
                    case 6: {
                        if (cArray[++n] == 't') {
                            if (cArray[++n] == 'a' && cArray[++n] == 't' && cArray[++n] == 'i' && cArray[++n] == 'c') {
                                return 38;
                            }
                            return 19;
                        }
                        if (cArray[n] == 'w' && cArray[++n] == 'i' && cArray[++n] == 't' && cArray[++n] == 'c' && cArray[++n] == 'h') {
                            return 63;
                        }
                        if (cArray[n] == 'e' && cArray[++n] == 'a' && cArray[++n] == 'l' && cArray[++n] == 'e' && cArray[++n] == 'd') {
                            return this.disambiguatedRestrictedIdentifiersealed(41);
                        }
                        return 19;
                    }
                    case 8: {
                        if (cArray[++n] == 't' && cArray[++n] == 'r' && cArray[++n] == 'i' && cArray[++n] == 'c' && cArray[++n] == 't' && cArray[++n] == 'f' && cArray[++n] == 'p') {
                            return 49;
                        }
                        return 19;
                    }
                    case 12: {
                        if (cArray[++n] == 'y' && cArray[++n] == 'n' && cArray[++n] == 'c' && cArray[++n] == 'h' && cArray[++n] == 'r' && cArray[++n] == 'o' && cArray[++n] == 'n' && cArray[++n] == 'i' && cArray[++n] == 'z' && cArray[++n] == 'e' && cArray[++n] == 'd') {
                            return 40;
                        }
                        return 19;
                    }
                }
                return 19;
            }
            case 't': {
                switch (n2) {
                    case 2: {
                        if (this.areRestrictedModuleKeywordsActive() && cArray[++n] == 'o') {
                            return 132;
                        }
                        return 19;
                    }
                    case 3: {
                        if (cArray[++n] == 'r' && cArray[++n] == 'y') {
                            return 88;
                        }
                        return 19;
                    }
                    case 4: {
                        if (cArray[++n] == 'h') {
                            if (cArray[++n] == 'i' && cArray[++n] == 's') {
                                return 35;
                            }
                            return 19;
                        }
                        if (cArray[n] == 'r' && cArray[++n] == 'u' && cArray[++n] == 'e') {
                            return 54;
                        }
                        return 19;
                    }
                    case 5: {
                        if (cArray[++n] == 'h' && cArray[++n] == 'r' && cArray[++n] == 'o' && cArray[++n] == 'w') {
                            return 78;
                        }
                        return 19;
                    }
                    case 6: {
                        if (cArray[++n] == 'h' && cArray[++n] == 'r' && cArray[++n] == 'o' && cArray[++n] == 'w' && cArray[++n] == 's') {
                            return 117;
                        }
                        return 19;
                    }
                    case 9: {
                        if (cArray[++n] == 'r' && cArray[++n] == 'a' && cArray[++n] == 'n' && cArray[++n] == 's' && cArray[++n] == 'i' && cArray[++n] == 'e' && cArray[++n] == 'n' && cArray[++n] == 't') {
                            return 50;
                        }
                        return 19;
                    }
                    case 10: {
                        if (this.areRestrictedModuleKeywordsActive() && cArray[++n] == 'r' && cArray[++n] == 'a' && cArray[++n] == 'n' && cArray[++n] == 's' && cArray[++n] == 'i' && cArray[++n] == 't' && cArray[++n] == 'i' && cArray[++n] == 'v' && cArray[++n] == 'e') {
                            return 128;
                        }
                        return 19;
                    }
                }
                return 19;
            }
            case 'u': {
                switch (n2) {
                    case 4: {
                        if (this.areRestrictedModuleKeywordsActive() && cArray[++n] == 's' && cArray[++n] == 'e' && cArray[++n] == 's') {
                            return 125;
                        }
                        return 19;
                    }
                }
                return 19;
            }
            case 'v': {
                switch (n2) {
                    case 4: {
                        if (cArray[++n] == 'o' && cArray[++n] == 'i' && cArray[++n] == 'd') {
                            return 115;
                        }
                        return 19;
                    }
                    case 8: {
                        if (cArray[++n] == 'o' && cArray[++n] == 'l' && cArray[++n] == 'a' && cArray[++n] == 't' && cArray[++n] == 'i' && cArray[++n] == 'l' && cArray[++n] == 'e') {
                            return 51;
                        }
                        return 19;
                    }
                }
                return 19;
            }
            case 'w': {
                switch (n2) {
                    case 4: {
                        if (this.areRestrictedModuleKeywordsActive() && cArray[++n] == 'i' && cArray[++n] == 't' && cArray[++n] == 'h') {
                            return 133;
                        }
                        return 19;
                    }
                    case 5: {
                        if (cArray[++n] == 'h' && cArray[++n] == 'i' && cArray[++n] == 'l' && cArray[++n] == 'e') {
                            return 79;
                        }
                        return 19;
                    }
                }
                return 19;
            }
            case 'y': {
                switch (n2) {
                    case 5: {
                        if (cArray[++n] != 'i' || cArray[++n] != 'e' || cArray[++n] != 'l' || cArray[++n] != 'd') break;
                        return this.disambiguatedRestrictedIdentifierYield(80);
                    }
                }
                return 19;
            }
        }
        return 19;
    }

    private int checkFor_KeyWord(int n, int n2, char[] cArray) {
        if (this._Keywords == null) {
            this._Keywords = new HashMap<String, Integer>(0);
            if (JavaFeature.RECORDS.isSupported(this.complianceLevel, this.previewEnabled)) {
                this._Keywords.put("non-sealed", 45);
            }
        }
        for (String string : this._Keywords.keySet()) {
            if (!CharOperation.prefixEquals(string.toCharArray(), cArray, true, n)) continue;
            this.currentPosition = this.currentPosition - n2 + string.length();
            if (this.currentPosition < this.eofPosition) {
                this.currentCharacter = cArray[this.currentPosition];
            }
            return this._Keywords.get(string);
        }
        return 0;
    }

    public int scanNumber(boolean bl) throws InvalidInputException {
        boolean bl2 = bl;
        if (!bl && this.currentCharacter == '0') {
            if (this.getNextChar('x', 'X') >= 0) {
                int n = this.currentPosition;
                this.consumeDigits(16, true);
                int n2 = this.currentPosition;
                if (this.getNextChar('l', 'L') >= 0) {
                    if (n2 == n) {
                        throw new InvalidInputException(INVALID_HEXA);
                    }
                    return 56;
                }
                if (this.getNextChar('.')) {
                    boolean bl3 = n2 == n;
                    n = this.currentPosition;
                    this.consumeDigits(16, true);
                    n2 = this.currentPosition;
                    if (bl3 && n2 == n) {
                        if (this.sourceLevel < 0x310000L) {
                            throw new InvalidInputException(ILLEGAL_HEXA_LITERAL);
                        }
                        throw new InvalidInputException(INVALID_HEXA);
                    }
                    if (this.getNextChar('p', 'P') >= 0) {
                        this.unicodeAsBackSlash = false;
                        if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                            this.getNextUnicodeChar();
                        } else if (this.withoutUnicodePtr != 0) {
                            this.unicodeStore();
                        }
                        if (this.currentCharacter == '-' || this.currentCharacter == '+') {
                            this.unicodeAsBackSlash = false;
                            if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                this.getNextUnicodeChar();
                            } else if (this.withoutUnicodePtr != 0) {
                                this.unicodeStore();
                            }
                        }
                        if (!ScannerHelper.isDigit(this.currentCharacter)) {
                            if (this.sourceLevel < 0x310000L) {
                                throw new InvalidInputException(ILLEGAL_HEXA_LITERAL);
                            }
                            if (this.currentCharacter == '_') {
                                this.consumeDigits(10);
                                throw new InvalidInputException(INVALID_UNDERSCORE);
                            }
                            throw new InvalidInputException(INVALID_HEXA);
                        }
                        this.consumeDigits(10);
                        if (this.getNextChar('f', 'F') >= 0) {
                            if (this.sourceLevel < 0x310000L) {
                                throw new InvalidInputException(ILLEGAL_HEXA_LITERAL);
                            }
                            return 57;
                        }
                        if (this.getNextChar('d', 'D') >= 0) {
                            if (this.sourceLevel < 0x310000L) {
                                throw new InvalidInputException(ILLEGAL_HEXA_LITERAL);
                            }
                            return 58;
                        }
                        if (this.getNextChar('l', 'L') >= 0) {
                            if (this.sourceLevel < 0x310000L) {
                                throw new InvalidInputException(ILLEGAL_HEXA_LITERAL);
                            }
                            throw new InvalidInputException(INVALID_HEXA);
                        }
                        if (this.sourceLevel < 0x310000L) {
                            throw new InvalidInputException(ILLEGAL_HEXA_LITERAL);
                        }
                        return 58;
                    }
                    if (this.sourceLevel < 0x310000L) {
                        throw new InvalidInputException(ILLEGAL_HEXA_LITERAL);
                    }
                    throw new InvalidInputException(INVALID_HEXA);
                }
                if (this.getNextChar('p', 'P') >= 0) {
                    if (n2 == n) {
                        if (this.sourceLevel < 0x310000L) {
                            throw new InvalidInputException(ILLEGAL_HEXA_LITERAL);
                        }
                        throw new InvalidInputException(INVALID_HEXA);
                    }
                    this.unicodeAsBackSlash = false;
                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                        this.getNextUnicodeChar();
                    } else if (this.withoutUnicodePtr != 0) {
                        this.unicodeStore();
                    }
                    if (this.currentCharacter == '-' || this.currentCharacter == '+') {
                        this.unicodeAsBackSlash = false;
                        if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                            this.getNextUnicodeChar();
                        } else if (this.withoutUnicodePtr != 0) {
                            this.unicodeStore();
                        }
                    }
                    if (!ScannerHelper.isDigit(this.currentCharacter)) {
                        if (this.sourceLevel < 0x310000L) {
                            throw new InvalidInputException(ILLEGAL_HEXA_LITERAL);
                        }
                        if (this.currentCharacter == '_') {
                            this.consumeDigits(10);
                            throw new InvalidInputException(INVALID_UNDERSCORE);
                        }
                        throw new InvalidInputException(INVALID_FLOAT);
                    }
                    this.consumeDigits(10);
                    if (this.getNextChar('f', 'F') >= 0) {
                        if (this.sourceLevel < 0x310000L) {
                            throw new InvalidInputException(ILLEGAL_HEXA_LITERAL);
                        }
                        return 57;
                    }
                    if (this.getNextChar('d', 'D') >= 0) {
                        if (this.sourceLevel < 0x310000L) {
                            throw new InvalidInputException(ILLEGAL_HEXA_LITERAL);
                        }
                        return 58;
                    }
                    if (this.getNextChar('l', 'L') >= 0) {
                        if (this.sourceLevel < 0x310000L) {
                            throw new InvalidInputException(ILLEGAL_HEXA_LITERAL);
                        }
                        throw new InvalidInputException(INVALID_HEXA);
                    }
                    if (this.sourceLevel < 0x310000L) {
                        throw new InvalidInputException(ILLEGAL_HEXA_LITERAL);
                    }
                    return 58;
                }
                if (n2 == n) {
                    throw new InvalidInputException(INVALID_HEXA);
                }
                return 55;
            }
            if (this.getNextChar('b', 'B') >= 0) {
                int n = this.currentPosition;
                this.consumeDigits(2, true);
                int n3 = this.currentPosition;
                if (n3 == n) {
                    if (this.sourceLevel < 0x330000L) {
                        throw new InvalidInputException(BINARY_LITERAL_NOT_BELOW_17);
                    }
                    throw new InvalidInputException(INVALID_BINARY);
                }
                if (this.getNextChar('l', 'L') >= 0) {
                    if (this.sourceLevel < 0x330000L) {
                        throw new InvalidInputException(BINARY_LITERAL_NOT_BELOW_17);
                    }
                    return 56;
                }
                if (this.sourceLevel < 0x330000L) {
                    throw new InvalidInputException(BINARY_LITERAL_NOT_BELOW_17);
                }
                return 55;
            }
            if (this.getNextCharAsDigit()) {
                this.consumeDigits(10);
                if (this.getNextChar('l', 'L') >= 0) {
                    return 56;
                }
                if (this.getNextChar('f', 'F') >= 0) {
                    return 57;
                }
                if (this.getNextChar('d', 'D') >= 0) {
                    return 58;
                }
                boolean bl4 = true;
                if (this.getNextChar('.')) {
                    bl4 = false;
                    this.consumeDigits(10);
                }
                if (this.getNextChar('e', 'E') >= 0) {
                    bl4 = false;
                    this.unicodeAsBackSlash = false;
                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                        this.getNextUnicodeChar();
                    } else if (this.withoutUnicodePtr != 0) {
                        this.unicodeStore();
                    }
                    if (this.currentCharacter == '-' || this.currentCharacter == '+') {
                        this.unicodeAsBackSlash = false;
                        if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                            this.getNextUnicodeChar();
                        } else if (this.withoutUnicodePtr != 0) {
                            this.unicodeStore();
                        }
                    }
                    if (!ScannerHelper.isDigit(this.currentCharacter)) {
                        if (this.currentCharacter == '_') {
                            this.consumeDigits(10);
                            throw new InvalidInputException(INVALID_UNDERSCORE);
                        }
                        throw new InvalidInputException(INVALID_FLOAT);
                    }
                    this.consumeDigits(10);
                }
                if (this.getNextChar('f', 'F') >= 0) {
                    return 57;
                }
                if (this.getNextChar('d', 'D') >= 0 || !bl4) {
                    return 58;
                }
                return 55;
            }
        }
        this.consumeDigits(10);
        if (!bl && this.getNextChar('l', 'L') >= 0) {
            return 56;
        }
        if (!bl && this.getNextChar('.')) {
            this.consumeDigits(10, true);
            bl2 = true;
        }
        if (this.getNextChar('e', 'E') >= 0) {
            bl2 = true;
            this.unicodeAsBackSlash = false;
            if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                this.getNextUnicodeChar();
            } else if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            if (this.currentCharacter == '-' || this.currentCharacter == '+') {
                this.unicodeAsBackSlash = false;
                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                    this.getNextUnicodeChar();
                } else if (this.withoutUnicodePtr != 0) {
                    this.unicodeStore();
                }
            }
            if (!ScannerHelper.isDigit(this.currentCharacter)) {
                if (this.currentCharacter == '_') {
                    this.consumeDigits(10);
                    throw new InvalidInputException(INVALID_UNDERSCORE);
                }
                throw new InvalidInputException(INVALID_FLOAT);
            }
            this.consumeDigits(10);
        }
        if (this.getNextChar('d', 'D') >= 0) {
            return 58;
        }
        if (this.getNextChar('f', 'F') >= 0) {
            return 57;
        }
        return bl2 ? 58 : 55;
    }

    public final int getLineNumber(int n) {
        return Util.getLineNumber(n, this.lineEnds, 0, this.linePtr);
    }

    public final void setSource(char[] cArray) {
        int n;
        if (cArray == null) {
            this.source = CharOperation.NO_CHAR;
            n = 0;
        } else {
            this.source = cArray;
            n = cArray.length;
        }
        this.startPosition = -1;
        this.eofPosition = n;
        this.currentPosition = 0;
        this.initialPosition = 0;
        this.containsAssertKeyword = false;
        this.linePtr = -1;
        this.scanContext = null;
        this.yieldColons = -1;
        this.insideModuleInfo = false;
    }

    public final void setSource(char[] cArray, CompilationResult compilationResult) {
        Object[] objectArray;
        if (cArray == null) {
            objectArray = compilationResult.compilationUnit.getContents();
            this.setSource((char[])objectArray);
        } else {
            this.setSource(cArray);
        }
        objectArray = compilationResult.lineSeparatorPositions;
        if (objectArray != null) {
            this.lineEnds = objectArray;
            this.linePtr = objectArray.length - 1;
        }
    }

    public final void setSource(CompilationResult compilationResult) {
        this.setSource(null, compilationResult);
    }

    public String toString() {
        int n;
        if (this.startPosition == this.eofPosition) {
            return "EOF\n\n" + new String(this.source);
        }
        if (this.currentPosition > this.eofPosition) {
            return "behind the EOF\n\n" + new String(this.source);
        }
        if (this.currentPosition <= 0) {
            return "NOT started!\n\n" + (this.source != null ? new String(this.source) : "");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.startPosition < 1000) {
            stringBuilder.append(this.source, 0, this.startPosition);
        } else {
            stringBuilder.append("<source beginning>\n...\n");
            n = Util.getLineNumber(this.startPosition - 1000, this.lineEnds, 0, this.linePtr);
            int n2 = this.getLineStart(n);
            stringBuilder.append(this.source, n2, this.startPosition - n2);
        }
        stringBuilder.append("\n===============================\nStarts here -->");
        n = this.currentPosition - 1 - this.startPosition + 1;
        if (n > -1) {
            stringBuilder.append(this.source, this.startPosition, n);
        }
        if (this.nextToken != 0) {
            stringBuilder.append("<-- Ends here [in pipeline " + this.toStringAction(this.nextToken) + "]\n===============================\n");
        } else {
            stringBuilder.append("<-- Ends here\n===============================\n");
        }
        stringBuilder.append(this.source, this.currentPosition - 1 + 1, this.eofPosition - (this.currentPosition - 1) - 1);
        return stringBuilder.toString();
    }

    public String toStringAction(int n) {
        switch (n) {
            case 19: {
                return "Identifier(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 80: {
                return "yield";
            }
            case 75: {
                return "record";
            }
            case 42: {
                return "abstract";
            }
            case 105: {
                return "boolean";
            }
            case 82: {
                return "break";
            }
            case 106: {
                return "byte";
            }
            case 91: {
                return "case";
            }
            case 107: {
                return "catch";
            }
            case 108: {
                return "char";
            }
            case 70: {
                return "class";
            }
            case 83: {
                return "continue";
            }
            case 76: {
                return "default";
            }
            case 84: {
                return "do";
            }
            case 109: {
                return "double";
            }
            case 121: {
                return "else";
            }
            case 92: {
                return "extends";
            }
            case 52: {
                return "false";
            }
            case 43: {
                return "final";
            }
            case 116: {
                return "finally";
            }
            case 110: {
                return "float";
            }
            case 85: {
                return "for";
            }
            case 86: {
                return "if";
            }
            case 131: {
                return "implements";
            }
            case 111: {
                return "import";
            }
            case 17: {
                return "instanceof";
            }
            case 112: {
                return "int";
            }
            case 73: {
                return "interface";
            }
            case 113: {
                return "long";
            }
            case 44: {
                return "native";
            }
            case 37: {
                return "new";
            }
            case 45: {
                return "non-sealed";
            }
            case 53: {
                return "null";
            }
            case 90: {
                return "package";
            }
            case 127: {
                return "permits";
            }
            case 46: {
                return "private";
            }
            case 47: {
                return "protected";
            }
            case 48: {
                return "public";
            }
            case 87: {
                return "return";
            }
            case 41: {
                return "sealed";
            }
            case 114: {
                return "short";
            }
            case 38: {
                return "static";
            }
            case 34: {
                return "super";
            }
            case 63: {
                return "switch";
            }
            case 40: {
                return "synchronized";
            }
            case 35: {
                return "this";
            }
            case 78: {
                return "throw";
            }
            case 117: {
                return "throws";
            }
            case 50: {
                return "transient";
            }
            case 54: {
                return "true";
            }
            case 88: {
                return "try";
            }
            case 115: {
                return "void";
            }
            case 51: {
                return "volatile";
            }
            case 79: {
                return "while";
            }
            case 118: {
                return "module";
            }
            case 122: {
                return "requires";
            }
            case 123: {
                return "exports";
            }
            case 55: {
                return "Integer(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 56: {
                return "Long(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 57: {
                return "Float(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 58: {
                return "Double(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 59: {
                return "Char(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 60: {
                return "String(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 61: {
                return "String(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 2: {
                return "++";
            }
            case 3: {
                return "--";
            }
            case 20: {
                return "==";
            }
            case 12: {
                return "<=";
            }
            case 13: {
                return ">=";
            }
            case 21: {
                return "!=";
            }
            case 18: {
                return "<<";
            }
            case 14: {
                return ">>";
            }
            case 16: {
                return ">>>";
            }
            case 93: {
                return "+=";
            }
            case 94: {
                return "-=";
            }
            case 104: {
                return "->";
            }
            case 95: {
                return "*=";
            }
            case 96: {
                return "/=";
            }
            case 97: {
                return "&=";
            }
            case 98: {
                return "|=";
            }
            case 99: {
                return "^=";
            }
            case 100: {
                return "%=";
            }
            case 101: {
                return "<<=";
            }
            case 102: {
                return ">>=";
            }
            case 103: {
                return ">>>=";
            }
            case 31: {
                return "||";
            }
            case 29: {
                return "&&";
            }
            case 4: {
                return "+";
            }
            case 5: {
                return "-";
            }
            case 66: {
                return "!";
            }
            case 9: {
                return "%";
            }
            case 24: {
                return "^";
            }
            case 22: {
                return "&";
            }
            case 8: {
                return "*";
            }
            case 28: {
                return "|";
            }
            case 67: {
                return "~";
            }
            case 10: {
                return "/";
            }
            case 15: {
                return ">";
            }
            case 11: {
                return "<";
            }
            case 23: {
                return "(";
            }
            case 26: {
                return ")";
            }
            case 39: {
                return "{";
            }
            case 33: {
                return "}";
            }
            case 6: {
                return "[";
            }
            case 69: {
                return "]";
            }
            case 25: {
                return ";";
            }
            case 30: {
                return "?";
            }
            case 65: {
                return ":";
            }
            case 7: {
                return "::";
            }
            case 32: {
                return ",";
            }
            case 1: {
                return ".";
            }
            case 77: {
                return "=";
            }
            case 64: {
                return "EOF";
            }
            case 1000: {
                return "white_space(" + new String(this.getCurrentTokenSource()) + ")";
            }
        }
        return "not-a-token";
    }

    public void unicodeInitializeBuffer(int n) {
        int n2;
        this.withoutUnicodePtr = n;
        if (this.withoutUnicodeBuffer == null) {
            this.withoutUnicodeBuffer = new char[n + 11];
        }
        if (1 + n >= (n2 = this.withoutUnicodeBuffer.length)) {
            this.withoutUnicodeBuffer = new char[n + 11];
            System.arraycopy(this.withoutUnicodeBuffer, 0, this.withoutUnicodeBuffer, 0, n2);
        }
        System.arraycopy(this.source, this.startPosition, this.withoutUnicodeBuffer, 1, n);
    }

    public void unicodeStore() {
        int n;
        int n2 = ++this.withoutUnicodePtr;
        if (this.withoutUnicodeBuffer == null) {
            this.withoutUnicodeBuffer = new char[10];
        }
        if (n2 == (n = this.withoutUnicodeBuffer.length)) {
            this.withoutUnicodeBuffer = new char[n * 2];
            System.arraycopy(this.withoutUnicodeBuffer, 0, this.withoutUnicodeBuffer, 0, n);
        }
        this.withoutUnicodeBuffer[n2] = this.currentCharacter;
    }

    public void unicodeStore(char c) {
        int n;
        int n2 = ++this.withoutUnicodePtr;
        if (this.withoutUnicodeBuffer == null) {
            this.withoutUnicodeBuffer = new char[10];
        }
        if (n2 == (n = this.withoutUnicodeBuffer.length)) {
            this.withoutUnicodeBuffer = new char[n * 2];
            System.arraycopy(this.withoutUnicodeBuffer, 0, this.withoutUnicodeBuffer, 0, n);
        }
        this.withoutUnicodeBuffer[n2] = c;
    }

    public static boolean isIdentifier(int n) {
        return n == 19;
    }

    public static boolean isLiteral(int n) {
        switch (n) {
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                return true;
            }
        }
        return false;
    }

    public static boolean isKeyword(int n) {
        switch (n) {
            case 17: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 63: 
            case 70: 
            case 73: 
            case 76: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 92: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 121: 
            case 131: {
                return true;
            }
        }
        return false;
    }

    private VanguardParser getVanguardParser() {
        if (this.vanguardParser == null) {
            this.vanguardScanner = new VanguardScanner(this.sourceLevel, this.complianceLevel, this.previewEnabled);
            this.vanguardParser = new VanguardParser(this.vanguardScanner);
            this.vanguardScanner.setActiveParser(this.vanguardParser);
        }
        this.vanguardScanner.setSource(this.source);
        this.vanguardScanner.resetTo(this.startPosition, this.eofPosition - 1, this.isInModuleDeclaration(), this.scanContext);
        return this.vanguardParser;
    }

    private VanguardParser getNewVanguardParser() {
        VanguardScanner vanguardScanner = this.getNewVanguardScanner();
        VanguardParser vanguardParser = new VanguardParser(vanguardScanner);
        vanguardScanner.setActiveParser(vanguardParser);
        return vanguardParser;
    }

    private VanguardScanner getNewVanguardScanner() {
        VanguardScanner vanguardScanner = new VanguardScanner(this.sourceLevel, this.complianceLevel, this.previewEnabled);
        vanguardScanner.setSource(this.source);
        vanguardScanner.resetTo(this.startPosition, this.eofPosition - 1, this.isInModuleDeclaration(), this.scanContext);
        return vanguardScanner;
    }

    protected final boolean mayBeAtCasePattern(int n) {
        return this.complianceLevel == 0x3D0000L && this.previewEnabled && (n == 91 || this.multiCaseLabelComma);
    }

    protected final boolean mayBeAtBreakPreview() {
        return this.breakPreviewAllowed && this.lookBack[1] != 104;
    }

    protected final boolean maybeAtLambdaOrCast() {
        switch (this.lookBack[1]) {
            case 19: 
            case 34: 
            case 35: 
            case 40: 
            case 63: 
            case 79: 
            case 85: 
            case 86: 
            case 88: 
            case 107: {
                return false;
            }
        }
        return this.activeParser.atConflictScenario(23);
    }

    protected final boolean maybeAtReferenceExpression() {
        switch (this.lookBack[1]) {
            case 19: {
                switch (this.lookBack[0]) {
                    case 11: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 22: 
                    case 25: 
                    case 33: 
                    case 34: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 70: 
                    case 73: 
                    case 74: 
                    case 76: 
                    case 92: 
                    case 117: 
                    case 127: 
                    case 131: {
                        return false;
                    }
                }
                break;
            }
            case 0: {
                break;
            }
            default: {
                return false;
            }
        }
        return this.activeParser.atConflictScenario(11);
    }

    private final boolean maybeAtEllipsisAnnotationsStart() {
        if (this.consumingEllipsisAnnotations) {
            return false;
        }
        switch (this.lookBack[1]) {
            case 1: 
            case 11: 
            case 17: 
            case 22: 
            case 32: 
            case 34: 
            case 37: 
            case 39: 
            case 92: 
            case 117: 
            case 127: 
            case 131: {
                return false;
            }
        }
        return true;
    }

    protected final boolean atTypeAnnotation() {
        return !this.activeParser.atConflictScenario(36);
    }

    public void setActiveParser(ConflictedParser conflictedParser) {
        this.activeParser = conflictedParser;
        this.lookBack[1] = 0;
        this.lookBack[0] = 0;
        if (conflictedParser != null) {
            this.insideModuleInfo = conflictedParser.isParsingModuleDeclaration();
        }
        this.multiCaseLabelComma = false;
    }

    public static boolean isRestrictedKeyword(int n) {
        switch (n) {
            case 118: 
            case 119: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 132: 
            case 133: {
                return true;
            }
        }
        return false;
    }

    private boolean mayBeAtAnYieldStatement() {
        switch (this.lookBack[1]) {
            case 25: 
            case 26: 
            case 33: 
            case 39: 
            case 84: 
            case 121: {
                return true;
            }
            case 65: {
                return this.lookBack[0] == 76 || this.yieldColons == 1;
            }
        }
        return false;
    }

    private boolean mayBeAtARestricedIdentifier(int n) {
        switch (n) {
            case 41: {
                break;
            }
        }
        return true;
    }

    int disambiguatedRestrictedIdentifierrecord(int n) {
        if (n != 75) {
            return n;
        }
        if (!JavaFeature.RECORDS.isSupported(this.complianceLevel, this.previewEnabled)) {
            return 19;
        }
        return this.disambiguaterecordWithLookAhead() ? n : 19;
    }

    private int getNextTokenAfterTypeParameterHeader() {
        block7: {
            int n = 1;
            try {
                int n2;
                while ((n2 = this.vanguardScanner.getNextToken()) != 0 && n2 != 64) {
                    if (n2 == 11) {
                        ++n;
                    }
                    if (n2 == 15) {
                        --n;
                    }
                    if (n2 == 14) {
                        n -= 2;
                    }
                    if (n2 == 16) {
                        n -= 3;
                    }
                    if (n > 0) continue;
                    return this.vanguardScanner.getNextToken();
                }
            }
            catch (InvalidInputException invalidInputException) {
                if (invalidInputException.getMessage().equals(INVALID_CHAR_IN_STRING)) break block7;
                invalidInputException.printStackTrace();
            }
        }
        return 64;
    }

    private boolean disambiguaterecordWithLookAhead() {
        block5: {
            if (this.isInModuleDeclaration()) {
                return false;
            }
            this.getVanguardParser();
            this.vanguardScanner.resetTo(this.currentPosition, this.eofPosition - 1);
            try {
                int n = this.vanguardScanner.getNextToken();
                if (n == 19) {
                    int n2 = this.vanguardScanner.getNextToken();
                    int n3 = n2 = n2 == 11 ? this.getNextTokenAfterTypeParameterHeader() : n2;
                    if (n2 == 39) {
                        return true;
                    }
                    return n2 == 23;
                }
            }
            catch (InvalidInputException invalidInputException) {
                if (invalidInputException.getMessage().equals(INVALID_CHAR_IN_STRING)) break block5;
                invalidInputException.printStackTrace();
            }
        }
        return false;
    }

    private boolean disambiguateYieldWithLookAhead() {
        this.getVanguardParser();
        this.vanguardScanner.resetTo(this.currentPosition, this.eofPosition - 1);
        try {
            int n = this.vanguardScanner.getNextToken();
            switch (n) {
                case 1: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 24: 
                case 25: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 36: 
                case 39: 
                case 65: 
                case 67: 
                case 69: 
                case 77: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 120: {
                    return false;
                }
                case 2: 
                case 3: {
                    int n2 = this.vanguardScanner.getNextToken();
                    return n2 == 19;
                }
            }
            return true;
        }
        catch (InvalidInputException invalidInputException) {
            if (!invalidInputException.getMessage().equals(INVALID_CHAR_IN_STRING)) {
                invalidInputException.printStackTrace();
            }
            return false;
        }
    }

    int disambiguatedRestrictedIdentifierpermits(int n) {
        if (n != 127) {
            return n;
        }
        if (!JavaFeature.RECORDS.isSupported(this.complianceLevel, this.previewEnabled)) {
            return 19;
        }
        return this.disambiguatesRestrictedIdentifierWithLookAhead(this::mayBeAtARestricedIdentifier, n, Goal.RestrictedIdentifierPermitsGoal);
    }

    int disambiguatedRestrictedIdentifiersealed(int n) {
        if (n != 41) {
            return n;
        }
        if (!JavaFeature.RECORDS.isSupported(this.complianceLevel, this.previewEnabled)) {
            return 19;
        }
        return this.disambiguatesRestrictedIdentifierWithLookAhead(this::mayBeAtARestricedIdentifier, n, Goal.RestrictedIdentifierSealedGoal);
    }

    int disambiguatedRestrictedIdentifierYield(int n) {
        if (n != 80) {
            return n;
        }
        if (this.sourceLevel < 0x3A0000L) {
            return 19;
        }
        return this.mayBeAtAnYieldStatement() && this.disambiguateYieldWithLookAhead() ? n : 19;
    }

    int disambiguatedRestrictedKeyword(int n) {
        int n2 = n;
        if (this.scanContext == ScanContext.EXPECTING_IDENTIFIER) {
            return 19;
        }
        switch (n) {
            case 128: {
                if (this.scanContext != ScanContext.AFTER_REQUIRES) {
                    n2 = 19;
                    break;
                }
                this.getVanguardParser();
                this.vanguardScanner.resetTo(this.currentPosition, this.eofPosition - 1, true, ScanContext.EXPECTING_IDENTIFIER);
                try {
                    int n3 = this.vanguardScanner.getNextToken();
                    if (n3 != 25) break;
                    n2 = 19;
                }
                catch (InvalidInputException invalidInputException) {}
                break;
            }
            case 118: 
            case 119: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 132: 
            case 133: {
                if (this.scanContext == ScanContext.EXPECTING_KEYWORD) break;
                n2 = 19;
            }
        }
        return n2;
    }

    int disambiguatesRestrictedIdentifierWithLookAhead(Predicate<Integer> predicate, int n, Goal goal) {
        if (predicate.test(n)) {
            VanguardParser vanguardParser = this.getNewVanguardParser();
            VanguardScanner vanguardScanner = (VanguardScanner)vanguardParser.scanner;
            vanguardScanner.resetTo(this.currentPosition, this.eofPosition - 1);
            if (vanguardParser.parse(goal)) {
                return n;
            }
        }
        return 19;
    }

    private VanguardScanner getNewVanguardScanner(char[] cArray) {
        VanguardScanner vanguardScanner = new VanguardScanner(this.sourceLevel, this.complianceLevel, this.previewEnabled);
        vanguardScanner.setSource(cArray);
        vanguardScanner.resetTo(0, cArray.length, this.isInModuleDeclaration(), this.scanContext);
        return vanguardScanner;
    }

    private VanguardParser getNewVanguardParser(char[] cArray) {
        VanguardScanner vanguardScanner = this.getNewVanguardScanner(cArray);
        VanguardParser vanguardParser = new VanguardParser(vanguardScanner);
        vanguardScanner.setActiveParser(vanguardParser);
        return vanguardParser;
    }

    int disambiguatedToken(int n, Scanner scanner) {
        VanguardParser vanguardParser = this.getVanguardParser();
        if (n == 104 && this.mayBeAtCaseLabelExpr() && scanner.caseStartPosition < scanner.startPosition) {
            char[] cArray = CharOperation.append(Arrays.copyOfRange(scanner.source, scanner.caseStartPosition, scanner.startPosition), ':');
            VanguardParser vanguardParser2 = this.getNewVanguardParser(cArray);
            if (vanguardParser2.parse(Goal.SwitchLabelCaseLhsGoal)) {
                scanner.nextToken = 104;
                return 72;
            }
        } else if (n == 23 && this.maybeAtLambdaOrCast()) {
            if (vanguardParser.parse(Goal.LambdaParameterListGoal)) {
                scanner.nextToken = 23;
                return 62;
            }
            scanner.vanguardScanner.resetTo(scanner.startPosition, scanner.eofPosition - 1);
            if (vanguardParser.parse(Goal.IntersectionCastGoal)) {
                scanner.nextToken = 23;
                return 68;
            }
        } else if (n == 11 && this.maybeAtReferenceExpression()) {
            if (vanguardParser.parse(Goal.ReferenceExpressionGoal)) {
                scanner.nextToken = 11;
                return 89;
            }
        } else if (n == 36 && this.atTypeAnnotation()) {
            n = 27;
            if (this.maybeAtEllipsisAnnotationsStart() && vanguardParser.parse(Goal.VarargTypeAnnotationGoal)) {
                scanner.consumingEllipsisAnnotations = true;
                scanner.nextToken = 27;
                return 129;
            }
        }
        return n;
    }

    int disambiguateCasePattern(int n, Scanner scanner) {
        assert (this.mayBeAtCasePattern(n));
        int n2 = n == 91 ? 4 : 0;
        VanguardParser vanguardParser = this.getNewVanguardParser();
        vanguardParser.scanner.resetTo(vanguardParser.scanner.currentPosition + n2, vanguardParser.scanner.eofPosition);
        if (vanguardParser.parse(Goal.PatternGoal)) {
            if (n == 91) {
                scanner.nextToken = 130;
            } else {
                scanner.nextToken = n;
                n = 130;
            }
        }
        return n;
    }

    private boolean mayBeAtCaseLabelExpr() {
        if (this.caseStartPosition <= 0) {
            return false;
        }
        if (this.lookBack[1] == 76) {
            return this.complianceLevel == 0x3D0000L && this.previewEnabled ? this.lookBack[0] == 91 || this.lookBack[0] == 32 : false;
        }
        return true;
    }

    protected boolean isAtAssistIdentifier() {
        return false;
    }

    public int fastForward(Statement statement) {
        block8: while (true) {
            int n;
            try {
                n = this.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                return 64;
            }
            switch (n) {
                case 19: {
                    if (this.isAtAssistIdentifier()) {
                        return n;
                    }
                }
                case 2: 
                case 3: 
                case 11: 
                case 23: 
                case 27: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 70: 
                case 72: 
                case 73: 
                case 74: 
                case 76: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 91: 
                case 105: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 112: 
                case 113: 
                case 114: 
                case 115: {
                    if (!this.getVanguardParser().parse(Goal.BlockStatementoptGoal)) continue block8;
                    return n;
                }
                case 25: 
                case 64: {
                    return n;
                }
                case 33: {
                    this.ungetToken(n);
                    return 25;
                }
            }
        }
    }

    protected int getNextNotFakedToken() throws InvalidInputException {
        return this.getNextToken();
    }

    private class ScanContextDetector
    extends VanguardParser {
        ScanContextDetector(CompilerOptions compilerOptions) {
            super(new ProblemReporter(DefaultErrorHandlingPolicies.ignoreAllProblems(), compilerOptions, new DefaultProblemFactory()));
            this.problemReporter.options.performStatementsRecovery = false;
            this.reportSyntaxErrorIsRequired = false;
            this.reportOnlyOneSyntaxError = false;
        }

        @Override
        public void initializeScanner() {
            this.scanner = new Scanner(false, false, false, this.options.sourceLevel, this.options.complianceLevel, this.options.taskTags, this.options.taskPriorities, this.options.isTaskCaseSensitive, this.options.enablePreviewFeatures){

                @Override
                void updateScanContext(int n) {
                    if (n != 64) {
                        super.updateScanContext(n);
                    }
                }
            };
            this.scanner.recordLineSeparator = false;
            this.scanner.setActiveParser(this);
            this.scanner.previewEnabled = this.options.enablePreviewFeatures;
        }

        @Override
        public boolean isParsingModuleDeclaration() {
            return true;
        }

        public ScanContext getScanContext(char[] cArray, int n) {
            this.scanner.setSource(cArray);
            this.scanner.resetTo(0, n);
            this.goForCompilationUnit();
            Goal goal = new Goal(2, null, 0){

                @Override
                boolean hasBeenReached(int n, int n2) {
                    return n2 == 64;
                }
            };
            this.parse(goal);
            return this.scanner.scanContext;
        }
    }

    private static class VanguardParser
    extends Parser {
        public static final boolean SUCCESS = true;
        public static final boolean FAILURE = false;
        Goal currentGoal;

        public VanguardParser(VanguardScanner vanguardScanner) {
            this.scanner = vanguardScanner;
        }

        public VanguardParser(ProblemReporter problemReporter) {
            super(problemReporter, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean parse(Goal goal) {
            this.currentGoal = goal;
            try {
                int n = 990;
                this.stateStackTop = -1;
                this.currentToken = goal.first;
                while (true) {
                    int n2;
                    if (++this.stateStackTop >= (n2 = this.stack.length)) {
                        this.stack = new int[n2 + 255];
                        System.arraycopy(this.stack, 0, this.stack, 0, n2);
                    }
                    this.stack[this.stateStackTop] = n;
                    if ((n = Parser.tAction(n, this.currentToken)) == 18203) {
                        return false;
                    }
                    if (n <= 932) {
                        --this.stateStackTop;
                    } else if (n > 18203) {
                        this.unstackedAct = n;
                        try {
                            this.currentToken = this.scanner.getNextToken();
                        }
                        finally {
                            this.unstackedAct = 18203;
                        }
                        n -= 18203;
                    } else {
                        if (n < 18202) {
                            this.unstackedAct = n;
                            try {
                                this.currentToken = this.scanner.getNextToken();
                            }
                            finally {
                                this.unstackedAct = 18203;
                            }
                            continue;
                        }
                        return false;
                    }
                    do {
                        if (goal.hasBeenReached(n, this.currentToken)) {
                            return true;
                        }
                        this.stateStackTop -= Parser.rhs[n] - 1;
                    } while ((n = Parser.ntAction(this.stack[this.stateStackTop], Parser.lhs[n])) <= 932);
                }
            }
            catch (Exception exception) {
                return false;
            }
        }

        @Override
        public String toString() {
            return "\n\n\n----------------Scanner--------------\n" + this.scanner.toString();
        }
    }

    private static class Goal {
        int first;
        int[] follow;
        int[] rules;
        static int LambdaParameterListRule = 0;
        static int IntersectionCastRule = 0;
        static int ReferenceExpressionRule = 0;
        static int VarargTypeAnnotationsRule = 0;
        static int BlockStatementoptRule = 0;
        static int YieldStatementRule = 0;
        static int SwitchLabelCaseLhsRule = 0;
        static int[] RestrictedIdentifierSealedRule;
        static int[] RestrictedIdentifierPermitsRule;
        static int[] PatternRules;
        static Goal LambdaParameterListGoal;
        static Goal IntersectionCastGoal;
        static Goal VarargTypeAnnotationGoal;
        static Goal ReferenceExpressionGoal;
        static Goal BlockStatementoptGoal;
        static Goal YieldStatementGoal;
        static Goal SwitchLabelCaseLhsGoal;
        static Goal RestrictedIdentifierSealedGoal;
        static Goal RestrictedIdentifierPermitsGoal;
        static Goal PatternGoal;
        static int[] RestrictedIdentifierSealedFollow;
        static int[] RestrictedIdentifierPermitsFollow;
        static int[] PatternCaseLabelFollow;

        Goal(int n, int[] nArray, int n2) {
            this.first = n;
            this.follow = nArray;
            this.rules = new int[]{n2};
        }

        Goal(int n, int[] nArray, int[] nArray2) {
            this.first = n;
            this.follow = nArray;
            this.rules = nArray2;
        }

        boolean hasBeenReached(int n, int n2) {
            boolean bl = false;
            int[] nArray = this.rules;
            int n3 = nArray.length;
            for (int i = 0; i < n3; ++i) {
                int n4 = nArray[i];
                if (n != n4) continue;
                bl = true;
                break;
            }
            if (bl) {
                int n5 = this.follow.length;
                if (n5 == 0) {
                    return true;
                }
                for (n3 = 0; n3 < n5; ++n3) {
                    if (this.follow[n3] != n2) continue;
                    return true;
                }
            }
            return false;
        }

        private static int[] followSetOfCast() {
            return new int[]{19, 37, 34, 35, 52, 54, 53, 55, 56, 57, 58, 59, 60, 61, 66, 67, 23};
        }

        static {
            RestrictedIdentifierSealedFollow = new int[]{70, 73, 74, 75};
            RestrictedIdentifierPermitsFollow = new int[]{39};
            PatternCaseLabelFollow = new int[]{65, 104, 32};
            ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            for (int i = 1; i <= 932; ++i) {
                if ("ParenthesizedLambdaParameterList".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    LambdaParameterListRule = i;
                    continue;
                }
                if ("ParenthesizedCastNameAndBounds".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    IntersectionCastRule = i;
                    continue;
                }
                if ("ReferenceExpressionTypeArgumentsAndTrunk".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    ReferenceExpressionRule = i;
                    continue;
                }
                if ("TypeAnnotations".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    VarargTypeAnnotationsRule = i;
                    continue;
                }
                if ("BlockStatementopt".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    BlockStatementoptRule = i;
                    continue;
                }
                if ("YieldStatement".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    YieldStatementRule = i;
                    continue;
                }
                if ("Modifiersopt".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    arrayList.add(i);
                    continue;
                }
                if ("PermittedSubclasses".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    arrayList2.add(i);
                    continue;
                }
                if ("SwitchLabelCaseLhs".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    SwitchLabelCaseLhsRule = i;
                    continue;
                }
                if ("TypePattern".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    arrayList3.add(i);
                    continue;
                }
                if ("PrimaryPattern".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    arrayList3.add(i);
                    continue;
                }
                if ("GuardedPattern".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    arrayList3.add(i);
                    continue;
                }
                if ("Pattern".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    arrayList3.add(i);
                    continue;
                }
                if (!"ParenthesizedPattern".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) continue;
                arrayList3.add(i);
            }
            RestrictedIdentifierSealedRule = arrayList.stream().mapToInt(Integer::intValue).toArray();
            RestrictedIdentifierPermitsRule = arrayList2.stream().mapToInt(Integer::intValue).toArray();
            PatternRules = arrayList3.stream().mapToInt(Integer::intValue).toArray();
            LambdaParameterListGoal = new Goal(104, new int[]{104}, LambdaParameterListRule);
            IntersectionCastGoal = new Goal(23, Goal.followSetOfCast(), IntersectionCastRule);
            VarargTypeAnnotationGoal = new Goal(36, new int[]{120}, VarargTypeAnnotationsRule);
            ReferenceExpressionGoal = new Goal(11, new int[]{7}, ReferenceExpressionRule);
            BlockStatementoptGoal = new Goal(39, new int[0], BlockStatementoptRule);
            YieldStatementGoal = new Goal(104, new int[0], YieldStatementRule);
            SwitchLabelCaseLhsGoal = new Goal(104, new int[0], SwitchLabelCaseLhsRule);
            RestrictedIdentifierSealedGoal = new Goal(41, RestrictedIdentifierSealedFollow, RestrictedIdentifierSealedRule);
            RestrictedIdentifierPermitsGoal = new Goal(127, RestrictedIdentifierPermitsFollow, RestrictedIdentifierPermitsRule);
            PatternGoal = new Goal(130, PatternCaseLabelFollow, PatternRules);
        }
    }

    private static final class VanguardScanner
    extends Scanner {
        public VanguardScanner(long l, long l2, boolean bl) {
            super(false, false, false, l, l2, null, null, false, bl);
        }

        @Override
        public int getNextToken() throws InvalidInputException {
            if (this.nextToken != 0) {
                int n = this.nextToken;
                this.nextToken = 0;
                return n;
            }
            if (this.scanContext == null) {
                this.scanContext = this.isInModuleDeclaration() ? ScanContext.EXPECTING_KEYWORD : ScanContext.INACTIVE;
            }
            int n = this.getNextToken0();
            if (this.areRestrictedModuleKeywordsActive()) {
                if (VanguardScanner.isRestrictedKeyword(n)) {
                    n = this.disambiguatedRestrictedKeyword(n);
                }
                this.updateScanContext(n);
            } else if (this.mayBeAtCasePattern(n)) {
                n = this.disambiguateCasePattern(n, this);
            } else if (n == 36 && this.atTypeAnnotation()) {
                n = ((VanguardParser)this.activeParser).currentGoal == Goal.LambdaParameterListGoal ? this.disambiguatedToken(n, this) : 27;
            }
            return n == 64 ? 0 : n;
        }
    }

    static enum ScanContext {
        EXPECTING_KEYWORD,
        EXPECTING_IDENTIFIER,
        AFTER_REQUIRES,
        INACTIVE;

    }
}

