/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTPermission;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.peer.DesktopPeer;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import sun.awt.AppContext;
import sun.awt.DesktopBrowse;
import sun.awt.SunToolkit;

public class Desktop {
    private DesktopPeer peer = Toolkit.getDefaultToolkit().createDesktopPeer(this);

    private Desktop() {
    }

    public static synchronized Desktop getDesktop() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (!Desktop.isDesktopSupported()) {
            throw new UnsupportedOperationException("Desktop API is not supported on the current platform");
        }
        AppContext context = AppContext.getAppContext();
        Desktop desktop = (Desktop)context.get(Desktop.class);
        if (desktop == null) {
            desktop = new Desktop();
            context.put(Desktop.class, desktop);
        }
        return desktop;
    }

    public static boolean isDesktopSupported() {
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        if (defaultToolkit instanceof SunToolkit) {
            return ((SunToolkit)defaultToolkit).isDesktopSupported();
        }
        return false;
    }

    public boolean isSupported(Action action) {
        return this.peer.isSupported(action);
    }

    private static void checkFileValidation(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("The file: " + file.getPath() + " doesn't exist.");
        }
    }

    private void checkActionSupport(Action actionType) {
        if (!this.isSupported(actionType)) {
            throw new UnsupportedOperationException("The " + actionType.name() + " action is not supported on the current platform!");
        }
    }

    private void checkAWTPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AWTPermission("showWindowWithoutWarningBanner"));
        }
    }

    public void open(File file) throws IOException {
        file = new File(file.getPath());
        this.checkAWTPermission();
        this.checkExec();
        this.checkActionSupport(Action.OPEN);
        Desktop.checkFileValidation(file);
        this.peer.open(file);
    }

    public void edit(File file) throws IOException {
        file = new File(file.getPath());
        this.checkAWTPermission();
        this.checkExec();
        this.checkActionSupport(Action.EDIT);
        file.canWrite();
        Desktop.checkFileValidation(file);
        this.peer.edit(file);
    }

    public void print(File file) throws IOException {
        file = new File(file.getPath());
        this.checkExec();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPrintJobAccess();
        }
        this.checkActionSupport(Action.PRINT);
        Desktop.checkFileValidation(file);
        this.peer.print(file);
    }

    public void browse(URI uri) throws IOException {
        SecurityException securityException = null;
        try {
            this.checkAWTPermission();
            this.checkExec();
        }
        catch (SecurityException e) {
            securityException = e;
        }
        this.checkActionSupport(Action.BROWSE);
        if (uri == null) {
            throw new NullPointerException();
        }
        if (securityException == null) {
            this.peer.browse(uri);
            return;
        }
        URL url = null;
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to convert URI to URL", e);
        }
        DesktopBrowse db = DesktopBrowse.getInstance();
        if (db == null) {
            throw securityException;
        }
        db.browse(url);
    }

    public void mail() throws IOException {
        this.checkAWTPermission();
        this.checkExec();
        this.checkActionSupport(Action.MAIL);
        URI mailtoURI = null;
        try {
            mailtoURI = new URI("mailto:?");
            this.peer.mail(mailtoURI);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public void mail(URI mailtoURI) throws IOException {
        this.checkAWTPermission();
        this.checkExec();
        this.checkActionSupport(Action.MAIL);
        if (mailtoURI == null) {
            throw new NullPointerException();
        }
        if (!"mailto".equalsIgnoreCase(mailtoURI.getScheme())) {
            throw new IllegalArgumentException("URI scheme is not \"mailto\"");
        }
        this.peer.mail(mailtoURI);
    }

    private void checkExec() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new FilePermission("<<ALL FILES>>", "execute"));
        }
    }

    public static enum Action {
        OPEN,
        EDIT,
        PRINT,
        MAIL,
        BROWSE;

    }
}

