/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.juli.WebappProperties;

public class ClassLoaderLogManager
extends LogManager {
    private static final boolean isJava9;
    private static ThreadLocal<Boolean> addingLocalRootLogger;
    public static final String DEBUG_PROPERTY;
    protected final Map<ClassLoader, ClassLoaderLogInfo> classLoaderLoggers = new WeakHashMap<ClassLoader, ClassLoaderLogInfo>();
    protected final ThreadLocal<String> prefix = new ThreadLocal();
    protected volatile boolean useShutdownHook = true;

    public ClassLoaderLogManager() {
        try {
            Runtime.getRuntime().addShutdownHook(new Cleaner());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public boolean isUseShutdownHook() {
        return this.useShutdownHook;
    }

    public void setUseShutdownHook(boolean bl) {
        this.useShutdownHook = bl;
    }

    @Override
    public synchronized boolean addLogger(Logger logger) {
        Object object;
        Object object2;
        int n;
        String string = logger.getName();
        ClassLoader classLoader = ClassLoaderLogManager.getClassLoader();
        ClassLoaderLogInfo classLoaderLogInfo = this.getClassLoaderInfo(classLoader);
        if (classLoaderLogInfo.loggers.containsKey(string)) {
            return false;
        }
        classLoaderLogInfo.loggers.put(string, logger);
        String string2 = this.getProperty(string + ".level");
        if (string2 != null) {
            try {
                AccessController.doPrivileged(() -> {
                    logger.setLevel(Level.parse(string2.trim()));
                    return null;
                });
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((n = string.lastIndexOf(46)) >= 0) {
            object2 = string.substring(0, n);
            Logger.getLogger((String)object2);
        }
        object2 = classLoaderLogInfo.rootNode.findNode(string);
        ((LogNode)object2).logger = logger;
        Logger logger2 = ((LogNode)object2).findParentLogger();
        if (logger2 != null) {
            ClassLoaderLogManager.doSetParentLogger(logger, logger2);
        }
        ((LogNode)object2).setParentLogger(logger);
        String string3 = this.getProperty(string + ".handlers");
        if (string3 != null) {
            logger.setUseParentHandlers(false);
            object = new StringTokenizer(string3, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string4 = ((StringTokenizer)object).nextToken().trim();
                Handler handler = null;
                for (ClassLoader classLoader2 = classLoader; classLoader2 != null && ((classLoaderLogInfo = this.classLoaderLoggers.get(classLoader2)) == null || (handler = classLoaderLogInfo.handlers.get(string4)) == null); classLoader2 = classLoader2.getParent()) {
                }
                if (handler == null) continue;
                logger.addHandler(handler);
            }
        }
        if (Boolean.parseBoolean((String)(object = this.getProperty(string + ".useParentHandlers")))) {
            logger.setUseParentHandlers(true);
        }
        return true;
    }

    @Override
    public synchronized Logger getLogger(String string) {
        ClassLoader classLoader = ClassLoaderLogManager.getClassLoader();
        return this.getClassLoaderInfo((ClassLoader)classLoader).loggers.get(string);
    }

    @Override
    public synchronized Enumeration<String> getLoggerNames() {
        ClassLoader classLoader = ClassLoaderLogManager.getClassLoader();
        return Collections.enumeration(this.getClassLoaderInfo((ClassLoader)classLoader).loggers.keySet());
    }

    @Override
    public String getProperty(String string) {
        if (".handlers".equals(string) && !addingLocalRootLogger.get().booleanValue()) {
            return null;
        }
        String string2 = this.prefix.get();
        String string3 = null;
        if (string2 != null) {
            string3 = this.findProperty(string2 + string);
        }
        if (string3 == null) {
            string3 = this.findProperty(string);
        }
        if (string3 != null) {
            string3 = this.replace(string3);
        }
        return string3;
    }

    private synchronized String findProperty(String string) {
        ClassLoader classLoader = ClassLoaderLogManager.getClassLoader();
        ClassLoaderLogInfo classLoaderLogInfo = this.getClassLoaderInfo(classLoader);
        String string2 = classLoaderLogInfo.props.getProperty(string);
        if (string2 == null && classLoaderLogInfo.props.isEmpty()) {
            if (classLoader != null) {
                for (ClassLoader classLoader2 = classLoader.getParent(); classLoader2 != null && ((classLoaderLogInfo = this.classLoaderLoggers.get(classLoader2)) == null || (string2 = classLoaderLogInfo.props.getProperty(string)) == null && classLoaderLogInfo.props.isEmpty()); classLoader2 = classLoader2.getParent()) {
                }
            }
            if (string2 == null) {
                string2 = super.getProperty(string);
            }
        }
        return string2;
    }

    @Override
    public void readConfiguration() throws IOException, SecurityException {
        this.checkAccess();
        this.readConfiguration(ClassLoaderLogManager.getClassLoader());
    }

    @Override
    public void readConfiguration(InputStream inputStream) throws IOException, SecurityException {
        this.checkAccess();
        this.reset();
        this.readConfiguration(inputStream, ClassLoaderLogManager.getClassLoader());
    }

    @Override
    public void reset() throws SecurityException {
        Thread thread = Thread.currentThread();
        if (thread.getClass().getName().startsWith("java.util.logging.LogManager$")) {
            return;
        }
        ClassLoader classLoader = ClassLoaderLogManager.getClassLoader();
        ClassLoaderLogInfo classLoaderLogInfo = this.getClassLoaderInfo(classLoader);
        this.resetLoggers(classLoaderLogInfo);
    }

    public synchronized void shutdown() {
        for (ClassLoaderLogInfo classLoaderLogInfo : this.classLoaderLoggers.values()) {
            this.resetLoggers(classLoaderLogInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetLoggers(ClassLoaderLogInfo classLoaderLogInfo) {
        ClassLoaderLogInfo classLoaderLogInfo2 = classLoaderLogInfo;
        synchronized (classLoaderLogInfo2) {
            for (Logger object : classLoaderLogInfo.loggers.values()) {
                Handler[] handlerArray;
                for (Handler handler : handlerArray = object.getHandlers()) {
                    object.removeHandler(handler);
                }
            }
            for (Handler handler : classLoaderLogInfo.handlers.values()) {
                try {
                    handler.close();
                }
                catch (Exception exception) {}
            }
            classLoaderLogInfo.handlers.clear();
        }
    }

    protected synchronized ClassLoaderLogInfo getClassLoaderInfo(ClassLoader classLoader) {
        ClassLoaderLogInfo classLoaderLogInfo;
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if ((classLoaderLogInfo = this.classLoaderLoggers.get(classLoader)) == null) {
            ClassLoader classLoader2 = classLoader;
            AccessController.doPrivileged(() -> {
                try {
                    this.readConfiguration(classLoader2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            });
            classLoaderLogInfo = this.classLoaderLoggers.get(classLoader);
        }
        return classLoaderLogInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void readConfiguration(ClassLoader classLoader) throws IOException {
        Object object;
        Object object2;
        Object object3;
        InputStream inputStream;
        block25: {
            inputStream = null;
            try {
                if (classLoader instanceof WebappProperties) {
                    if (((WebappProperties)((Object)classLoader)).hasLoggingConfig()) {
                        inputStream = classLoader.getResourceAsStream("logging.properties");
                    }
                } else if (classLoader instanceof URLClassLoader) {
                    object3 = ((URLClassLoader)classLoader).findResource("logging.properties");
                    if (null != object3) {
                        if (Boolean.getBoolean(DEBUG_PROPERTY)) {
                            System.err.println(this.getClass().getName() + ".readConfiguration(): Found logging.properties at " + object3);
                        }
                        inputStream = classLoader.getResourceAsStream("logging.properties");
                    } else if (Boolean.getBoolean(DEBUG_PROPERTY)) {
                        System.err.println(this.getClass().getName() + ".readConfiguration(): Found no logging.properties");
                    }
                }
            }
            catch (AccessControlException accessControlException) {
                object2 = this.classLoaderLoggers.get(ClassLoader.getSystemClassLoader());
                if (object2 == null || (object = ((ClassLoaderLogInfo)object2).loggers.get("")) == null) break block25;
                Permission permission = accessControlException.getPermission();
                if (permission instanceof FilePermission && permission.getActions().equals("read")) {
                    ((Logger)object).warning("Reading " + permission.getName() + " is not permitted. See \"per context logging\" in the default catalina.policy file.");
                }
                ((Logger)object).warning("Reading logging.properties is not permitted in some context. See \"per context logging\" in the default catalina.policy file.");
                ((Logger)object).warning("Original error was: " + accessControlException.getMessage());
            }
        }
        if (inputStream == null && classLoader == ClassLoader.getSystemClassLoader()) {
            object3 = System.getProperty("java.util.logging.config.file");
            if (object3 != null) {
                try {
                    inputStream = new FileInputStream(this.replace((String)object3));
                }
                catch (IOException iOException) {
                    System.err.println("Configuration error");
                    iOException.printStackTrace();
                }
            }
            if (inputStream == null) {
                object2 = new File(new File(System.getProperty("java.home"), isJava9 ? "conf" : "lib"), "logging.properties");
                try {
                    inputStream = new FileInputStream((File)object2);
                }
                catch (IOException iOException) {
                    System.err.println("Configuration error");
                    iOException.printStackTrace();
                }
            }
        }
        object3 = new RootLogger();
        if (inputStream == null) {
            object = null;
            for (object2 = classLoader.getParent(); object2 != null && object == null; object2 = ((ClassLoader)object2).getParent()) {
                object = this.getClassLoaderInfo((ClassLoader)object2);
            }
            if (object != null) {
                ((Logger)object3).setParent(((ClassLoaderLogInfo)object).rootNode.logger);
            }
        }
        object2 = new ClassLoaderLogInfo(new LogNode(null, (Logger)object3));
        this.classLoaderLoggers.put(classLoader, (ClassLoaderLogInfo)object2);
        if (inputStream != null) {
            this.readConfiguration(inputStream, classLoader);
        }
        try {
            addingLocalRootLogger.set(Boolean.TRUE);
            this.addLogger((Logger)object3);
        }
        finally {
            addingLocalRootLogger.set(Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void readConfiguration(InputStream inputStream, ClassLoader classLoader) throws IOException {
        ClassLoaderLogInfo classLoaderLogInfo = this.classLoaderLoggers.get(classLoader);
        try {
            classLoaderLogInfo.props.load(inputStream);
        }
        catch (IOException iOException) {
            System.err.println("Configuration error");
            iOException.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        String string = classLoaderLogInfo.props.getProperty(".handlers");
        String string2 = classLoaderLogInfo.props.getProperty("handlers");
        Logger logger = classLoaderLogInfo.rootNode.logger;
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                int n;
                String string3;
                String string4 = string3 = stringTokenizer.nextToken().trim();
                String string5 = "";
                if (string4.length() <= 0) continue;
                if (Character.isDigit(string4.charAt(0)) && (n = string4.indexOf(46)) >= 0) {
                    string5 = string4.substring(0, n + 1);
                    string4 = string4.substring(n + 1);
                }
                try {
                    this.prefix.set(string5);
                    Handler handler = (Handler)classLoader.loadClass(string4).getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.prefix.set(null);
                    classLoaderLogInfo.handlers.put(string3, handler);
                    if (string != null) continue;
                    logger.addHandler(handler);
                }
                catch (Exception exception) {
                    System.err.println("Handler error");
                    exception.printStackTrace();
                }
            }
        }
    }

    protected static void doSetParentLogger(Logger logger, Logger logger2) {
        AccessController.doPrivileged(() -> {
            logger.setParent(logger2);
            return null;
        });
    }

    protected String replace(String string) {
        String string2 = string;
        int n = string.indexOf("${");
        if (n >= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = -1;
            while (n >= 0) {
                stringBuilder.append(string, n2 + 1, n);
                n2 = string.indexOf(125, n + 2);
                if (n2 < 0) {
                    n2 = n - 1;
                    break;
                }
                String string3 = string.substring(n + 2, n2);
                String string4 = this.replaceWebApplicationProperties(string3);
                if (string4 == null) {
                    String string5 = string4 = string3.length() > 0 ? System.getProperty(string3) : null;
                }
                if (string4 != null) {
                    stringBuilder.append(string4);
                } else {
                    stringBuilder.append(string, n, n2 + 1);
                }
                n = string.indexOf("${", n2 + 1);
            }
            stringBuilder.append(string, n2 + 1, string.length());
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    private String replaceWebApplicationProperties(String string) {
        ClassLoader classLoader = ClassLoaderLogManager.getClassLoader();
        if (classLoader instanceof WebappProperties) {
            WebappProperties webappProperties = (WebappProperties)((Object)classLoader);
            if ("classloader.webappName".equals(string)) {
                return webappProperties.getWebappName();
            }
            if ("classloader.hostName".equals(string)) {
                return webappProperties.getHostName();
            }
            if ("classloader.serviceName".equals(string)) {
                return webappProperties.getServiceName();
            }
            return null;
        }
        return null;
    }

    static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoaderLogManager.class.getClassLoader();
        }
        return classLoader;
    }

    static {
        addingLocalRootLogger = ThreadLocal.withInitial(() -> Boolean.FALSE);
        DEBUG_PROPERTY = ClassLoaderLogManager.class.getName() + ".debug";
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.lang.Runtime$Version");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        isJava9 = clazz != null;
    }

    protected static class RootLogger
    extends Logger {
        public RootLogger() {
            super("", null);
        }
    }

    protected static final class ClassLoaderLogInfo {
        final LogNode rootNode;
        final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
        final Map<String, Handler> handlers = new HashMap<String, Handler>();
        final Properties props = new Properties();

        ClassLoaderLogInfo(LogNode logNode) {
            this.rootNode = logNode;
        }
    }

    protected static final class LogNode {
        Logger logger;
        final Map<String, LogNode> children = new HashMap<String, LogNode>();
        final LogNode parent;

        LogNode(LogNode logNode, Logger logger) {
            this.parent = logNode;
            this.logger = logger;
        }

        LogNode(LogNode logNode) {
            this(logNode, null);
        }

        LogNode findNode(String string) {
            LogNode logNode = this;
            if (this.logger.getName().equals(string)) {
                return this;
            }
            while (string != null) {
                String string2;
                int n = string.indexOf(46);
                if (n < 0) {
                    string2 = string;
                    string = null;
                } else {
                    string2 = string.substring(0, n);
                    string = string.substring(n + 1);
                }
                LogNode logNode2 = logNode.children.get(string2);
                if (logNode2 == null) {
                    logNode2 = new LogNode(logNode);
                    logNode.children.put(string2, logNode2);
                }
                logNode = logNode2;
            }
            return logNode;
        }

        Logger findParentLogger() {
            Logger logger = null;
            LogNode logNode = this.parent;
            while (logNode != null && logger == null) {
                logger = logNode.logger;
                logNode = logNode.parent;
            }
            return logger;
        }

        void setParentLogger(Logger logger) {
            for (LogNode logNode : this.children.values()) {
                if (logNode.logger == null) {
                    logNode.setParentLogger(logger);
                    continue;
                }
                ClassLoaderLogManager.doSetParentLogger(logNode.logger, logger);
            }
        }
    }

    private final class Cleaner
    extends Thread {
        private Cleaner() {
        }

        @Override
        public void run() {
            if (ClassLoaderLogManager.this.useShutdownHook) {
                ClassLoaderLogManager.this.shutdown();
            }
        }
    }
}

