/* multimap.c generated by valac 0.56.0, the Vala compiler
 * generated from multimap.vala, do not modify */

/* multimap.vala
 *
 * Copyright (C) 2009  Ali Sabil
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Ali Sabil <ali.sabil@gmail.com>
 */

#include "gee.h"
#include <glib-object.h>
#include <glib.h>

#define GEE_TYPE_READ_ONLY_MULTI_MAP (gee_read_only_multi_map_get_type ())
#define GEE_READ_ONLY_MULTI_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_READ_ONLY_MULTI_MAP, GeeReadOnlyMultiMap))
#define GEE_READ_ONLY_MULTI_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_READ_ONLY_MULTI_MAP, GeeReadOnlyMultiMapClass))
#define GEE_IS_READ_ONLY_MULTI_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_READ_ONLY_MULTI_MAP))
#define GEE_IS_READ_ONLY_MULTI_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_READ_ONLY_MULTI_MAP))
#define GEE_READ_ONLY_MULTI_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_READ_ONLY_MULTI_MAP, GeeReadOnlyMultiMapClass))

typedef struct _GeeReadOnlyMultiMap GeeReadOnlyMultiMap;
typedef struct _GeeReadOnlyMultiMapClass GeeReadOnlyMultiMapClass;

 G_GNUC_INTERNAL GeeReadOnlyMultiMap* gee_read_only_multi_map_new (GType k_type,
                                                  GBoxedCopyFunc k_dup_func,
                                                  GDestroyNotify k_destroy_func,
                                                  GType v_type,
                                                  GBoxedCopyFunc v_dup_func,
                                                  GDestroyNotify v_destroy_func,
                                                  GeeMultiMap* multimap);
 G_GNUC_INTERNAL GeeReadOnlyMultiMap* gee_read_only_multi_map_construct (GType object_type,
                                                        GType k_type,
                                                        GBoxedCopyFunc k_dup_func,
                                                        GDestroyNotify k_destroy_func,
                                                        GType v_type,
                                                        GBoxedCopyFunc v_dup_func,
                                                        GDestroyNotify v_destroy_func,
                                                        GeeMultiMap* multimap);
 G_GNUC_INTERNAL GType gee_read_only_multi_map_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType gee_multi_map_get_type_once (void);

/**
 * Returns the keys of this multimap as a read-only set.
 *
 * @return the keys of the map
 */
GeeSet*
gee_multi_map_get_keys (GeeMultiMap* self)
{
	GeeMultiMapIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_MULTI_MAP_GET_INTERFACE (self);
	if (_iface_->get_keys) {
		return _iface_->get_keys (self);
	}
	return NULL;
}

/**
 * Returns the keys of this multimap as a read-only set.
 *
 * @return the keys of the map
 */
GeeMultiSet*
gee_multi_map_get_all_keys (GeeMultiMap* self)
{
	GeeMultiMapIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_MULTI_MAP_GET_INTERFACE (self);
	if (_iface_->get_all_keys) {
		return _iface_->get_all_keys (self);
	}
	return NULL;
}

/**
 * Returns the values of this map as a read-only collection.
 *
 * @return the values of the map
 */
GeeCollection*
gee_multi_map_get_values (GeeMultiMap* self)
{
	GeeMultiMapIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_MULTI_MAP_GET_INTERFACE (self);
	if (_iface_->get_values) {
		return _iface_->get_values (self);
	}
	return NULL;
}

/**
 * Determines whether this map contains the specified key.
 *
 * @param key the key to locate in the map
 *
 * @return    ``true`` if key is found, ``false`` otherwise
 */
gboolean
gee_multi_map_contains (GeeMultiMap* self,
                        gconstpointer key)
{
	GeeMultiMapIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_MULTI_MAP_GET_INTERFACE (self);
	if (_iface_->contains) {
		return _iface_->contains (self, key);
	}
	return FALSE;
}

/**
 * Returns the values for the specified key in this map.
 *
 * @param key the key whose values are to be retrieved
 *
 * @return    a Collection of values associated with the given key
 */
GeeCollection*
gee_multi_map_get (GeeMultiMap* self,
                   gconstpointer key)
{
	GeeMultiMapIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_MULTI_MAP_GET_INTERFACE (self);
	if (_iface_->get) {
		return _iface_->get (self, key);
	}
	return NULL;
}

/**
 * Inserts a key/value pair into this map.
 *
 * @param key   the key to insert
 * @param value the value to associate with the key
 */
void
gee_multi_map_set (GeeMultiMap* self,
                   gconstpointer key,
                   gconstpointer value)
{
	GeeMultiMapIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GEE_MULTI_MAP_GET_INTERFACE (self);
	if (_iface_->set) {
		_iface_->set (self, key, value);
	}
}

/**
 * Removes the specified key/value pair from this multimap.
 *
 * @param key   the key to remove from the map
 * @param value the value to remove from the map
 *
 * @return      ``true`` if the map has been changed, ``false`` otherwise
 */
gboolean
gee_multi_map_remove (GeeMultiMap* self,
                      gconstpointer key,
                      gconstpointer value)
{
	GeeMultiMapIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_MULTI_MAP_GET_INTERFACE (self);
	if (_iface_->remove) {
		return _iface_->remove (self, key, value);
	}
	return FALSE;
}

/**
 * Removes the specified key and all the associated values from this
 * multimap.
 *
 * @param key the key to remove from the map
 *
 * @return    ``true`` if the map has been changed, ``false`` otherwise
 */
gboolean
gee_multi_map_remove_all (GeeMultiMap* self,
                          gconstpointer key)
{
	GeeMultiMapIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_MULTI_MAP_GET_INTERFACE (self);
	if (_iface_->remove_all) {
		return _iface_->remove_all (self, key);
	}
	return FALSE;
}

/**
 * Removes all items from this collection.
 */
void
gee_multi_map_clear (GeeMultiMap* self)
{
	GeeMultiMapIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GEE_MULTI_MAP_GET_INTERFACE (self);
	if (_iface_->clear) {
		_iface_->clear (self);
	}
}

/**
 * Returns an iterator for this map.
 *
 * @return a map iterator
 */
GeeMapIterator*
gee_multi_map_map_iterator (GeeMultiMap* self)
{
	GeeMultiMapIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_MULTI_MAP_GET_INTERFACE (self);
	if (_iface_->map_iterator) {
		return _iface_->map_iterator (self);
	}
	return NULL;
}

gint
gee_multi_map_get_size (GeeMultiMap* self)
{
	GeeMultiMapIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = GEE_MULTI_MAP_GET_INTERFACE (self);
	if (_iface_->get_size) {
		return _iface_->get_size (self);
	}
	return -1;
}

gboolean
gee_multi_map_get_read_only (GeeMultiMap* self)
{
	GeeMultiMapIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_MULTI_MAP_GET_INTERFACE (self);
	if (_iface_->get_read_only) {
		return _iface_->get_read_only (self);
	}
	return FALSE;
}

GType
gee_multi_map_get_key_type (GeeMultiMap* self)
{
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = GEE_MULTI_MAP_GET_INTERFACE (self)->get_k_type (self);
	return result;
}

GType
gee_multi_map_get_value_type (GeeMultiMap* self)
{
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = GEE_MULTI_MAP_GET_INTERFACE (self)->get_v_type (self);
	return result;
}

GeeMultiMap*
gee_multi_map_get_read_only_view (GeeMultiMap* self)
{
	GeeMultiMapIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_MULTI_MAP_GET_INTERFACE (self);
	if (_iface_->get_read_only_view) {
		return _iface_->get_read_only_view (self);
	}
	return NULL;
}

static GeeMultiMap*
gee_multi_map_real_get_read_only_view (GeeMultiMap* base)
{
	GeeMultiMap* result;
	GeeMultiMap* self;
	GeeReadOnlyMultiMap* _tmp0_;
	self = base;
	_tmp0_ = gee_read_only_multi_map_new (GEE_MULTI_MAP_GET_INTERFACE (self)->get_k_type (self), (GBoxedCopyFunc) GEE_MULTI_MAP_GET_INTERFACE (self)->get_k_dup_func (self), (GDestroyNotify) GEE_MULTI_MAP_GET_INTERFACE (self)->get_k_destroy_func (self), GEE_MULTI_MAP_GET_INTERFACE (self)->get_v_type (self), (GBoxedCopyFunc) GEE_MULTI_MAP_GET_INTERFACE (self)->get_v_dup_func (self), (GDestroyNotify) GEE_MULTI_MAP_GET_INTERFACE (self)->get_v_destroy_func (self), self);
	result = (GeeMultiMap*) _tmp0_;
	return result;
}

static void
gee_multi_map_default_init (GeeMultiMapIface * iface,
                            gpointer iface_data)
{
	/**
	 * The number of key/value pairs in this map.
	 */
	g_object_interface_install_property (iface, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Specifies whether this collection can change - i.e. whether {@link set},
	 * {@link remove} etc. are legal operations.
	 */
	g_object_interface_install_property (iface, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	iface->get_read_only_view = gee_multi_map_real_get_read_only_view;
}

/**
 * A map with multiple values per key.
 */
static GType
gee_multi_map_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeMultiMapIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_multi_map_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gee_multi_map_type_id;
	gee_multi_map_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeMultiMap", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gee_multi_map_type_id, G_TYPE_OBJECT);
	return gee_multi_map_type_id;
}

GType
gee_multi_map_get_type (void)
{
	static volatile gsize gee_multi_map_type_id__once = 0;
	if (g_once_init_enter (&gee_multi_map_type_id__once)) {
		GType gee_multi_map_type_id;
		gee_multi_map_type_id = gee_multi_map_get_type_once ();
		g_once_init_leave (&gee_multi_map_type_id__once, gee_multi_map_type_id);
	}
	return gee_multi_map_type_id__once;
}

