/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;

public class TileItemContainer
extends FreeColGameObject {
    private static final Logger logger = Logger.getLogger(TileItemContainer.class.getName());
    public static final String TAG = "tileItemContainer";
    private Tile tile;
    private final List<TileItem> tileItems = new ArrayList<TileItem>();
    private static final String TILE_TAG = "tile";
    private static final String OLD_TILE_IMPROVEMENT_TAG = "tileimprovement";

    public TileItemContainer(Game game, Tile tile) {
        super(game);
        if (tile == null) {
            throw new RuntimeException("Tile must not be null: " + this);
        }
        this.tile = tile;
    }

    public TileItemContainer(Game game, String id) {
        super(game, id);
    }

    public final Tile getTile() {
        return this.tile;
    }

    private void invalidateCache() {
        Colony colony = this.tile.getColony();
        if (colony != null && colony.isTileInUse(this.tile)) {
            colony.invalidateCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TileItem> getTileItems() {
        List<TileItem> list = this.tileItems;
        synchronized (list) {
            return new ArrayList<TileItem>(this.tileItems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTileItems() {
        List<TileItem> list = this.tileItems;
        synchronized (list) {
            this.tileItems.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTileItems(List<TileItem> newTileItems) {
        this.clearTileItems();
        if (newTileItems != null) {
            List<TileItem> list = this.tileItems;
            synchronized (list) {
                this.tileItems.addAll(newTileItems);
            }
        }
        this.invalidateCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addTileItem(TileItem item) {
        int zIndex = item.getZIndex();
        int i = 0;
        List<TileItem> list = this.tileItems;
        synchronized (list) {
            for (TileItem ti : this.tileItems) {
                if (ti.getZIndex() < zIndex) break;
                ++i;
            }
            this.tileItems.add(i, item);
        }
    }

    public final TileItem tryAddTileItem(TileItem item) {
        if (item == null) {
            return null;
        }
        if (item instanceof TileImprovement) {
            TileImprovement newTip = (TileImprovement)item;
            for (TileItem oldItem : this.getTileItems()) {
                if (!(oldItem instanceof TileImprovement)) continue;
                TileImprovement oldTip = (TileImprovement)oldItem;
                if (oldTip.getType().getId().equals(newTip.getType().getId())) {
                    if (oldTip.getMagnitude() < newTip.getMagnitude()) {
                        oldTip.setMagnitude(newTip.getMagnitude());
                        oldTip.setStyle(newTip.getStyle());
                        oldTip.setVirtual(newTip.getVirtual());
                        this.invalidateCache();
                    }
                    return oldItem;
                }
                if (oldItem.getZIndex() <= item.getZIndex()) continue;
                break;
            }
        }
        this.addTileItem(item);
        this.invalidateCache();
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends TileItem> T removeTileItem(T item) {
        boolean removed;
        List<TileItem> list = this.tileItems;
        synchronized (list) {
            removed = this.tileItems.remove(item);
        }
        if (removed) {
            item.setLocation(null);
            this.invalidateCache();
            return item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends TileItem> void removeAll(Class<T> c) {
        List<TileItem> list = this.tileItems;
        synchronized (list) {
            CollectionUtils.removeInPlace(this.tileItems, ti -> c.isInstance(ti));
        }
    }

    public List<TileItem> getCompleteItems() {
        return CollectionUtils.transform(this.getTileItems(), TileItem::isComplete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TileImprovement getImprovement(TileImprovementType type) {
        List<TileItem> list = this.tileItems;
        synchronized (list) {
            return (TileImprovement)CollectionUtils.find(this.tileItems, ti -> ti instanceof TileImprovement && ((TileImprovement)ti).getType() == type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TileImprovement> getImprovements(boolean completedOnly) {
        List<TileItem> list = this.tileItems;
        synchronized (list) {
            return CollectionUtils.transform(this.tileItems, ti -> ti instanceof TileImprovement && (!completedOnly || ((TileImprovement)ti).isComplete()), ti -> (TileImprovement)ti);
        }
    }

    public List<TileImprovement> getImprovements() {
        return this.getImprovements(false);
    }

    public List<TileImprovement> getCompleteImprovements() {
        return this.getImprovements(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TileItem findTileItem(Predicate<TileItem> pred) {
        List<TileItem> list = this.tileItems;
        synchronized (list) {
            return CollectionUtils.find(this.tileItems, pred);
        }
    }

    public final LostCityRumour getLostCityRumour() {
        return (LostCityRumour)this.findTileItem(ti -> ti instanceof LostCityRumour);
    }

    public final Resource getResource() {
        return (Resource)this.findTileItem(ti -> ti instanceof Resource);
    }

    public TileImprovement getRoad() {
        return (TileImprovement)this.findTileItem(ti -> ti instanceof TileImprovement && ((TileImprovement)ti).isRoad());
    }

    public TileImprovement getRiver() {
        return (TileImprovement)this.findTileItem(ti -> ti instanceof TileImprovement && ((TileImprovement)ti).isRiver());
    }

    public boolean hasImprovement(TileImprovementType type) {
        TileImprovement improvement = this.getImprovement(type);
        return improvement != null && improvement.isComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIncompatibleImprovements() {
        TileType tileType = this.tile.getType();
        boolean removed = false;
        List<TileItem> list = this.tileItems;
        synchronized (list) {
            TileImprovement river = this.getRiver();
            if (river != null && !river.isTileTypeAllowed(tileType) && !tileType.isWater()) {
                river.updateRiverConnections(null);
            }
            removed = CollectionUtils.removeInPlace(this.tileItems, ti -> !ti.isTileTypeAllowed(tileType));
        }
        if (removed) {
            this.invalidateCache();
        }
    }

    public int getTotalBonusPotential(GoodsType goodsType, UnitType unitType, int potential, boolean onlyNatural) {
        int result = potential;
        for (TileItem item : CollectionUtils.transform(this.getTileItems(), ti -> !onlyNatural || ti.isNatural())) {
            result = item.applyBonus(goodsType, unitType, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<Modifier> getProductionModifiers(GoodsType goodsType, UnitType unitType) {
        List<TileItem> list = this.tileItems;
        synchronized (list) {
            return CollectionUtils.flatten(this.tileItems, ti -> ti.getProductionModifiers(goodsType, unitType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canProduce(GoodsType goodsType, UnitType unitType) {
        List<TileItem> list = this.tileItems;
        synchronized (list) {
            return CollectionUtils.any(this.tileItems, ti -> ti.canProduce(goodsType, unitType));
        }
    }

    public int getMoveCost(Tile fromTile, Tile targetTile, int basicMoveCost) {
        int moveCost = basicMoveCost;
        for (TileItem item : CollectionUtils.transform(this.getTileItems(), ti -> ti instanceof TileImprovement && ((TileImprovement)ti).isComplete())) {
            Direction direction = targetTile.getDirection(fromTile);
            if (direction == null) {
                return Integer.MAX_VALUE;
            }
            moveCost = Math.min(moveCost, ((TileImprovement)item).getMoveCost(direction, moveCost));
        }
        return moveCost;
    }

    public void copyFrom(TileItemContainer tic, Map.Layer layer) {
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        List<TileItem> otherItems = tic.getTileItems();
        ArrayList<TileItem> result = new ArrayList<TileItem>();
        for (TileItem item : CollectionUtils.transform(otherItems, ti -> layer.compareTo(ti.getLayer()) >= 0)) {
            FreeColSpecObjectType type;
            if (item instanceof Resource) {
                Resource resource = (Resource)item;
                type = spec.getResourceType(resource.getType().getId());
                result.add(new Resource(game, this.tile, (ResourceType)type, resource.getQuantity()));
                continue;
            }
            if (item instanceof LostCityRumour) {
                LostCityRumour rumour = (LostCityRumour)item;
                result.add(new LostCityRumour(game, this.tile, rumour.getType(), rumour.getName()));
                continue;
            }
            if (item instanceof TileImprovement) {
                TileImprovement improvement = (TileImprovement)item;
                if (layer.compareTo(Map.Layer.ALL) < 0 && !improvement.getType().isNatural()) continue;
                type = spec.getTileImprovementType(improvement.getType().getId());
                result.add(new TileImprovement(game, this.tile, (TileImprovementType)type, improvement.getStyle()));
                continue;
            }
            logger.warning("Bogus tile item: " + item.getId());
        }
        this.setTileItems(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(TileItem t) {
        List<TileItem> list = this.tileItems;
        synchronized (list) {
            return this.tileItems.contains(t);
        }
    }

    @Override
    public void disposeResources() {
        this.clearTileItems();
        super.disposeResources();
    }

    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        for (TileItem ti : this.getTileItems()) {
            Constants.IntegrityType integ = ti.checkIntegrity(fix, lb);
            if (fix) {
                TileImprovement tim;
                if (ti instanceof TileImprovement && (tim = (TileImprovement)ti).isRiver()) {
                    if (tim.getStyle() == null) {
                        lb.add("\n  TileImprovement null river style: ", tim);
                        integ = integ.fail();
                    } else if ("0000".equals(tim.getStyle().toString())) {
                        lb.add("\n  TileImprovement 0000 river: ", tim);
                        integ = integ.fail();
                    }
                }
                if (!integ.safe()) {
                    logger.warning("Removing broken TileImprovement: " + ti.getId());
                    this.removeTileItem(ti);
                    integ = integ.fix();
                }
            }
            result = result.combine(integ);
        }
        return result;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        TileItemContainer o = this.copyInCast(other, TileItemContainer.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Game game = this.getGame();
        this.tile = game.updateRef(o.getTile());
        this.clearTileItems();
        for (TileItem ti : o.getTileItems()) {
            TileItem nti = game.update(ti, true);
            if (nti == null) {
                throw new RuntimeException("TileItem class fail " + ti);
            }
            this.addTileItem(nti);
        }
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(TILE_TAG, this.tile);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (TileItem item : this.getTileItems()) {
            item.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.tile = xr.findFreeColGameObject(this.getGame(), TILE_TAG, Tile.class, null, true);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.clearTileItems();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if ("lostCityRumour".equals(tag)) {
            LostCityRumour lcr = xr.readFreeColObject(game, LostCityRumour.class);
            if (lcr != null) {
                this.addTileItem(lcr);
            }
        } else if ("resource".equals(tag)) {
            this.addTileItem(xr.readFreeColObject(game, Resource.class));
        } else if ("tileImprovement".equals(tag) || OLD_TILE_IMPROVEMENT_TAG.equals(tag)) {
            this.addTileItem(xr.readFreeColObject(game, TileImprovement.class));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[').append(this.getId());
        for (TileItem item : this.getTileItems()) {
            sb.append(' ').append(item);
        }
        sb.append(']');
        return sb.toString();
    }
}

