/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.io.FreeColDataFile;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.sza.SimpleZippedAnimation;
import net.sf.freecol.common.resources.AudioResource;
import net.sf.freecol.common.resources.ColorResource;
import net.sf.freecol.common.resources.FAFile;
import net.sf.freecol.common.resources.FAFileResource;
import net.sf.freecol.common.resources.FontResource;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.ResourceMapping;
import net.sf.freecol.common.resources.SZAResource;
import net.sf.freecol.common.resources.StringResource;
import net.sf.freecol.common.resources.Video;
import net.sf.freecol.common.resources.VideoResource;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;

public class ResourceManager {
    private static final Logger logger = Logger.getLogger(ResourceManager.class.getName());
    private static Thread preloadThread = null;
    private static volatile boolean preloadDone = false;
    private static ResourceMapping mergedContainer = new ResourceMapping();
    private static FreeColDataFile baseDataFile = null;
    private static ResourceMapping baseResourceMapping = new ResourceMapping();
    private static FreeColDataFile tcDataFile = null;
    private static ResourceMapping tcResourceMapping = new ResourceMapping();
    private static List<? extends FreeColDataFile> mods = new ArrayList<FreeColDataFile>();
    private static List<ResourceMapping> modResourceMappings = new ArrayList<ResourceMapping>();
    private static FreeColSavegameFile savegameFile = null;
    private static ResourceMapping savegameResourceMapping = new ResourceMapping();

    public static void setBaseData(FreeColDataFile baseDataFile) {
        ResourceManager.baseDataFile = baseDataFile;
        baseResourceMapping = baseDataFile.getResourceMapping();
    }

    public static void setTcData(FreeColDataFile tcDataFile) {
        ResourceManager.tcDataFile = tcDataFile;
        tcResourceMapping = tcDataFile != null ? tcDataFile.getResourceMapping() : new ResourceMapping();
        ResourceManager.prepare();
    }

    public static <T extends FreeColDataFile> void setMods(List<T> mods) {
        ResourceManager.mods = mods;
        modResourceMappings = mods.stream().map(FreeColDataFile::getResourceMapping).collect(Collectors.toList());
        ResourceManager.prepare();
    }

    public static void setSavegameFile(FreeColSavegameFile savegameFile) {
        ResourceManager.savegameFile = savegameFile;
        savegameResourceMapping = savegameFile != null ? savegameFile.getResourceMapping() : new ResourceMapping();
        ResourceManager.prepare();
    }

    public static void prepare() {
        ResourceManager.finishPreloading();
        ResourceMapping newMergedContainer = new ResourceMapping();
        newMergedContainer.addAll(baseResourceMapping);
        newMergedContainer.addAll(tcResourceMapping);
        for (ResourceMapping modResourceMapping : modResourceMappings) {
            newMergedContainer.addAll(modResourceMapping);
        }
        newMergedContainer.addAll(savegameResourceMapping);
        ResourceManager.waitForPreloadingToStop();
        mergedContainer = newMergedContainer;
    }

    public static void reload() {
        baseResourceMapping = baseDataFile.getResourceMapping();
        tcResourceMapping = tcDataFile != null ? tcDataFile.getResourceMapping() : new ResourceMapping();
        modResourceMappings = mods.stream().map(FreeColDataFile::getResourceMapping).collect(Collectors.toList());
        savegameResourceMapping = savegameFile != null ? savegameFile.getResourceMapping() : new ResourceMapping();
        ResourceManager.prepare();
    }

    private static void waitForPreloadingToStop() {
        try {
            while (preloadThread != null) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            logger.warning(e.getMessage());
        }
    }

    public static synchronized void startPreloading(final Runnable afterPreloadHasCompleted) {
        if (FreeCol.getHeadless()) {
            return;
        }
        if (preloadThread != null) {
            return;
        }
        preloadDone = false;
        preloadThread = new Thread("FreeColClient:-Resource loader"){

            @Override
            public void run() {
                logger.info("Preload thread started");
                int n = mergedContainer.preload(() -> !preloadDone);
                logger.info("Preload done, " + n + " resources.");
                preloadThread = null;
                SwingUtilities.invokeLater(() -> afterPreloadHasCompleted.run());
            }
        };
        preloadThread.start();
    }

    public static synchronized void finishPreloading() {
        preloadDone = true;
    }

    public static AudioResource getAudioResource(String key, boolean warn) {
        AudioResource r = mergedContainer.getAudioResource(key);
        if (warn && r == null) {
            logger.warning("getAudioResource(" + key + ") failed");
        }
        return r;
    }

    public static ColorResource getColorResource(String key, boolean warn) {
        ColorResource r = mergedContainer.getColorResource(key);
        if (warn && r == null) {
            logger.warning("getColorResource(" + key + ") failed");
        }
        return r;
    }

    public static FAFileResource getFAFileResource(String key, boolean warn) {
        FAFileResource r = mergedContainer.getFAFileResource(key);
        if (warn && r == null) {
            logger.warning("getFAFileResource(" + key + ") failed");
        }
        return r;
    }

    public static FontResource getFontResource(String key, boolean warn) {
        FontResource r = mergedContainer.getFontResource(key);
        if (warn && r == null) {
            logger.warning("getFontResource(" + key + ") failed");
        }
        return r;
    }

    public static ImageResource getImageResource(String key, boolean warn) {
        ImageResource r = mergedContainer.getImageResource(key);
        if (warn && r == null) {
            logger.warning("getImageResource(" + key + ") failed");
        }
        return r;
    }

    public static StringResource getStringResource(String key, boolean warn) {
        StringResource r = mergedContainer.getStringResource(key);
        if (warn && r == null) {
            logger.warning("getStringResource(" + key + ") failed");
        }
        return r;
    }

    public static SZAResource getSZAResource(String key, boolean warn) {
        SZAResource r = mergedContainer.getSZAResource(key);
        if (warn && r == null) {
            logger.warning("getSZAResource(" + key + ") failed");
        }
        return r;
    }

    public static VideoResource getVideoResource(String key, boolean warn) {
        VideoResource r = mergedContainer.getVideoResource(key);
        if (warn && r == null) {
            logger.warning("getVideoResource(" + key + ") failed");
        }
        return r;
    }

    public static File getAudio(String key) {
        AudioResource r = ResourceManager.getAudioResource(key, true);
        return r == null ? null : r.getAudio();
    }

    public static Color getColor(String key, Color replacement) {
        ColorResource r = ResourceManager.getColorResource(key, true);
        return r != null ? r.getColor() : (replacement != null ? replacement : ColorResource.REPLACEMENT_COLOR);
    }

    public static FAFile getFAFile(String key) {
        FAFileResource r = ResourceManager.getFAFileResource(key, true);
        return r == null ? null : r.getFAFile();
    }

    public static Font getFont(String key) {
        FontResource r = ResourceManager.getFontResource(key, true);
        if (r == null) {
            return FontResource.getEmergencyFont();
        }
        return r.getFont();
    }

    public static BufferedImage getImage(String key) {
        ImageResource ir = ResourceManager.getImageResource(key, true);
        return ir == null ? null : ir.getImage();
    }

    public static BufferedImage getImage(String key, Dimension size, boolean grayscale) {
        ImageResource ir = ResourceManager.getImageResource(key, true);
        return ir == null ? null : ir.getImage(size, grayscale);
    }

    public static List<String> getImageKeys(String prefix) {
        return CollectionUtils.transform(mergedContainer.getImageKeySet(), k -> k.startsWith(prefix));
    }

    public static String getString(String key) {
        StringResource r = ResourceManager.getStringResource(key, true);
        return r == null ? "X" : r.getString();
    }

    public static SimpleZippedAnimation getSZA(String key) {
        SZAResource r = ResourceManager.getSZAResource(key, true);
        return r != null ? r.getSimpleZippedAnimation() : null;
    }

    public static SimpleZippedAnimation getSZA(String key, float scale) {
        SZAResource r = ResourceManager.getSZAResource(key, true);
        return r != null ? r.getSimpleZippedAnimation(scale) : null;
    }

    public static Video getVideo(String key) {
        VideoResource r = ResourceManager.getVideoResource(key, true);
        return r != null ? r.getVideo() : null;
    }

    public static void summarizeImageResources(StringBuilder sb) {
        Set<String> keys = mergedContainer.getImageKeySet();
        sb.append("All keys\n").append(StringUtils.join(" ", keys)).append('\n');
    }
}

