/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColSavegameFile;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SaveGameValidator {
    public static void main(String[] args) throws Exception {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        File schemaLocation = new File("schema/data/data-savedGame.xsd");
        Schema schema = factory.newSchema(schemaLocation);
        Validator saveGameValidator = schema.newValidator();
        ArrayList<File> allFiles = new ArrayList<File>();
        for (String name : args) {
            File file = new File(name);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                allFiles.addAll(FreeColDirectories.getSavegameFileList(file));
                continue;
            }
            if (!FreeColDirectories.saveGameFilter.test(file)) continue;
            allFiles.add(file);
        }
        int ret = 0;
        for (File file : allFiles) {
            try {
                FreeColSavegameFile mapFile = new FreeColSavegameFile(file);
                saveGameValidator.validate(new StreamSource(mapFile.getSavegameInputStream()));
                System.out.println("Successfully validated " + file.getName());
            }
            catch (SAXParseException e) {
                System.out.println(e.getMessage() + " at line=" + e.getLineNumber() + " column=" + e.getColumnNumber());
                ret = Math.max(ret, 1);
            }
            catch (IOException | SAXException e) {
                System.out.println("Failed to read " + file.getName());
                ret = 2;
            }
        }
        System.exit(ret);
    }
}

