/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.render;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.osmand.PlatformUtil;
import net.osmand.render.RenderingRule;
import net.osmand.render.RenderingRuleProperty;
import net.osmand.render.RenderingRuleSearchRequest;
import net.osmand.render.RenderingRuleStorageProperties;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RenderingRulesStorage {
    private static final Log log = PlatformUtil.getLog(RenderingRulesStorage.class);
    static boolean STORE_ATTTRIBUTES = false;
    public static final int MULTY_POLYGON_TYPE = 0;
    public static final int POINT_RULES = 1;
    public static final int LINE_RULES = 2;
    public static final int POLYGON_RULES = 3;
    public static final int TEXT_RULES = 4;
    public static final int ORDER_RULES = 5;
    public static final int LENGTH_RULES = 6;
    private static final int SHIFT_TAG_VAL = 16;
    List<String> dictionary = new ArrayList<String>();
    Map<String, Integer> dictionaryMap = new LinkedHashMap<String, Integer>();
    public RenderingRuleStorageProperties PROPS = new RenderingRuleStorageProperties();
    public TIntObjectHashMap<RenderingRule>[] tagValueGlobalRules = new TIntObjectHashMap[6];
    protected Map<String, RenderingRule> renderingAttributes = new LinkedHashMap<String, RenderingRule>();
    protected Map<String, String> renderingConstants = new LinkedHashMap<String, String>();
    protected String renderingName;
    protected String internalRenderingName;

    public RenderingRulesStorage(String name, Map<String, String> renderingConstants) {
        this.getDictionaryValue("");
        this.renderingName = name;
        if (renderingConstants != null) {
            this.renderingConstants.putAll(renderingConstants);
        }
    }

    public int getDictionaryValue(String val) {
        if (this.dictionaryMap.containsKey(val)) {
            return this.dictionaryMap.get(val);
        }
        int nextInd = this.dictionaryMap.size();
        this.dictionaryMap.put(val, nextInd);
        this.dictionary.add(val);
        return nextInd;
    }

    public String getStringValue(int i) {
        return this.dictionary.get(i);
    }

    public String getName() {
        return this.renderingName;
    }

    public String getInternalRenderingName() {
        return this.internalRenderingName;
    }

    public void parseRulesFromXmlInputStream(InputStream is, RenderingRulesStorageResolver resolver) throws XmlPullParserException, IOException {
        XmlPullParser parser = PlatformUtil.newXMLPullParser();
        RenderingRulesHandler handler = new RenderingRulesHandler(parser, resolver);
        handler.parse(is);
        RenderingRulesStorage depends = handler.getDependsStorage();
        if (depends != null) {
            for (Map.Entry<String, RenderingRule> e : depends.renderingAttributes.entrySet()) {
                if (this.renderingAttributes.containsKey(e.getKey())) {
                    RenderingRule root = this.renderingAttributes.get(e.getKey());
                    List<RenderingRule> list = e.getValue().getIfElseChildren();
                    for (RenderingRule every : list) {
                        root.addIfElseChildren(every);
                    }
                    e.getValue().addToBeginIfElseChildren(root);
                    continue;
                }
                this.renderingAttributes.put(e.getKey(), e.getValue());
            }
            for (int i = 0; i < 6; ++i) {
                if (depends.tagValueGlobalRules[i] == null || depends.tagValueGlobalRules[i].isEmpty()) continue;
                if (this.tagValueGlobalRules[i] != null) {
                    int[] keys = depends.tagValueGlobalRules[i].keys();
                    for (int j = 0; j < keys.length; ++j) {
                        RenderingRule rule = (RenderingRule)this.tagValueGlobalRules[i].get(keys[j]);
                        RenderingRule dependsRule = (RenderingRule)depends.tagValueGlobalRules[i].get(keys[j]);
                        if (dependsRule == null) continue;
                        if (rule != null) {
                            RenderingRule toInsert = this.createTagValueRootWrapperRule(keys[j], rule);
                            toInsert.addIfElseChildren(dependsRule);
                            this.tagValueGlobalRules[i].put(keys[j], (Object)toInsert);
                            continue;
                        }
                        this.tagValueGlobalRules[i].put(keys[j], (Object)dependsRule);
                    }
                    continue;
                }
                this.tagValueGlobalRules[i] = depends.tagValueGlobalRules[i];
            }
        }
    }

    public static String colorToString(int color2) {
        if ((0xFF000000 & color2) == -16777216) {
            return "#" + Integer.toHexString(color2 & 0xFFFFFF);
        }
        return "#" + Integer.toHexString(color2);
    }

    private void registerGlobalRule(RenderingRule rr, int state, String tagS, String valueS) throws XmlPullParserException {
        int value;
        if (tagS == null || valueS == null) {
            throw new XmlPullParserException("Attribute tag should be specified for root filter " + rr.toString());
        }
        int tag = this.getDictionaryValue(tagS);
        int key = (tag << 16) + (value = this.getDictionaryValue(valueS));
        RenderingRule insert = (RenderingRule)this.tagValueGlobalRules[state].get(key);
        if (insert != null) {
            insert = this.createTagValueRootWrapperRule(key, insert);
            insert.addIfElseChildren(rr);
        } else {
            insert = rr;
        }
        this.tagValueGlobalRules[state].put(key, (Object)insert);
    }

    private RenderingRule createTagValueRootWrapperRule(int tagValueKey, RenderingRule previous) {
        if (previous.getProperties().length > 0) {
            HashMap<String, String> m = new HashMap<String, String>();
            RenderingRule toInsert = new RenderingRule(m, true, this);
            toInsert.addIfElseChildren(previous);
            return toInsert;
        }
        return previous;
    }

    public int getTagValueKey(String tag, String value) {
        int itag = this.getDictionaryValue(tag);
        int ivalue = this.getDictionaryValue(value);
        return itag << 16 | ivalue;
    }

    public String getValueString(int tagValueKey) {
        return this.getStringValue(tagValueKey & 0xFFFF);
    }

    public String getTagString(int tagValueKey) {
        return this.getStringValue(tagValueKey >> 16);
    }

    protected RenderingRule getRule(int state, int itag, int ivalue) {
        if (this.tagValueGlobalRules[state] != null) {
            return (RenderingRule)this.tagValueGlobalRules[state].get(itag << 16 | ivalue);
        }
        return null;
    }

    protected RenderingRule getRenderingAttributeRule(String attribute) {
        return this.renderingAttributes.get(attribute);
    }

    public String[] getRenderingAttributeNames() {
        return this.renderingAttributes.keySet().toArray(new String[this.renderingAttributes.size()]);
    }

    public RenderingRule[] getRenderingAttributeValues() {
        return this.renderingAttributes.values().toArray(new RenderingRule[this.renderingAttributes.size()]);
    }

    public RenderingRule[] getRules(int state) {
        if (state >= this.tagValueGlobalRules.length || this.tagValueGlobalRules[state] == null) {
            return new RenderingRule[0];
        }
        return (RenderingRule[])this.tagValueGlobalRules[state].values((Object[])new RenderingRule[this.tagValueGlobalRules[state].size()]);
    }

    public int getRuleTagValueKey(int state, int ind) {
        return this.tagValueGlobalRules[state].keys()[ind];
    }

    public void printDebug(int state, PrintStream out) {
        for (int key : this.tagValueGlobalRules[state].keys()) {
            RenderingRule rr = (RenderingRule)this.tagValueGlobalRules[state].get(key);
            out.print("\n\n" + this.getTagString(key) + " : " + this.getValueString(key) + "\n ");
            RenderingRulesStorage.printRenderingRule(" ", rr, out);
        }
    }

    private static void printRenderingRule(String indent, RenderingRule rr, PrintStream out) {
        out.print(rr.toString(indent, new StringBuilder()).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws XmlPullParserException, IOException {
        STORE_ATTTRIBUTES = true;
        String loc = "/Users/victorshcherb/osmand/repos/resources/rendering_styles/";
        String defaultFile = "/Users/victorshcherb/osmand/repos/resources/rendering_styles/UniRS.render.xml";
        if (args.length > 0) {
            defaultFile = args[0];
        }
        final LinkedHashMap<String, String> renderingConstants = new LinkedHashMap<String, String>();
        try (FileInputStream is = new FileInputStream("/Users/victorshcherb/osmand/repos/resources/rendering_styles/default.render.xml");){
            int tok;
            XmlPullParser parser = PlatformUtil.newXMLPullParser();
            parser.setInput((InputStream)is, "UTF-8");
            while ((tok = parser.next()) != 1) {
                String tagName;
                if (tok != 2 || !(tagName = parser.getName()).equals("renderingConstant") || renderingConstants.containsKey(parser.getAttributeValue("", "name"))) continue;
                renderingConstants.put(parser.getAttributeValue("", "name"), parser.getAttributeValue("", "value"));
            }
        }
        RenderingRulesStorage storage = new RenderingRulesStorage("default", renderingConstants);
        RenderingRulesStorageResolver resolver = new RenderingRulesStorageResolver(){

            @Override
            public RenderingRulesStorage resolve(String name, RenderingRulesStorageResolver ref) throws XmlPullParserException, IOException {
                RenderingRulesStorage depends = new RenderingRulesStorage(name, renderingConstants);
                depends.parseRulesFromXmlInputStream(new FileInputStream("/Users/victorshcherb/osmand/repos/resources/rendering_styles/" + name + ".render.xml"), ref);
                return depends;
            }
        };
        is = new FileInputStream(defaultFile);
        storage.parseRulesFromXmlInputStream(is, resolver);
        for (RenderingRuleProperty p : storage.PROPS.getCustomRules()) {
            System.out.println(p.getCategory() + " " + p.getName() + " " + p.getAttrName());
        }
    }

    protected static void testSearch(RenderingRulesStorage storage) {
        RenderingRuleSearchRequest searchRequest = new RenderingRuleSearchRequest(storage);
        searchRequest.setStringFilter(storage.PROPS.R_TAG, "highway");
        searchRequest.setStringFilter(storage.PROPS.R_VALUE, "residential");
        searchRequest.setIntFilter(storage.PROPS.R_MINZOOM, 13);
        searchRequest.setIntFilter(storage.PROPS.R_MAXZOOM, 13);
        boolean res = searchRequest.search(2);
        System.out.println("Result " + res);
        RenderingRulesStorage.printResult(searchRequest, System.out);
    }

    protected static void printAllRules(RenderingRulesStorage storage) {
        System.out.println("\n\n--------- POINTS ----- ");
        storage.printDebug(1, System.out);
        System.out.println("\n\n--------- POLYGON ----- ");
        storage.printDebug(3, System.out);
        System.out.println("\n\n--------- LINES ----- ");
        storage.printDebug(2, System.out);
        System.out.println("\n\n--------- ORDER ----- ");
        storage.printDebug(5, System.out);
        System.out.println("\n\n--------- TEXT ----- ");
        storage.printDebug(4, System.out);
    }

    private static void printResult(RenderingRuleSearchRequest searchRequest, PrintStream out) {
        if (searchRequest.isFound()) {
            out.print(" Found : ");
            for (RenderingRuleProperty rp : searchRequest.getProperties()) {
                if (!rp.isOutputProperty() || !searchRequest.isSpecified(rp)) continue;
                out.print(" " + rp.getAttrName() + "= ");
                if (rp.isString()) {
                    out.print("\"" + searchRequest.getStringPropertyValue(rp) + "\"");
                    continue;
                }
                if (rp.isFloat()) {
                    out.print(searchRequest.getFloatPropertyValue(rp));
                    continue;
                }
                if (rp.isColor()) {
                    out.print(searchRequest.getColorStringPropertyValue(rp));
                    continue;
                }
                if (!rp.isIntParse()) continue;
                out.print(searchRequest.getIntPropertyValue(rp));
            }
        } else {
            out.println("Not found");
        }
    }

    private class RenderingRulesHandler {
        private final XmlPullParser parser;
        private int state;
        Stack<RenderingRule> stack = new Stack();
        Map<String, String> attrsMap = new LinkedHashMap<String, String>();
        private final RenderingRulesStorageResolver resolver;
        private RenderingRulesStorage dependsStorage;

        public RenderingRulesHandler(XmlPullParser parser, RenderingRulesStorageResolver resolver) {
            this.parser = parser;
            this.resolver = resolver;
        }

        public void parse(InputStream is) throws XmlPullParserException, IOException {
            int tok;
            this.parser.setInput(is, "UTF-8");
            while ((tok = this.parser.next()) != 1) {
                if (tok == 2) {
                    this.startElement(this.parser.getName());
                    continue;
                }
                if (tok != 3) continue;
                this.endElement(this.parser.getName());
            }
        }

        public RenderingRulesStorage getDependsStorage() {
            return this.dependsStorage;
        }

        private boolean isTopCase() {
            for (int i = 0; i < this.stack.size(); ++i) {
                if (((RenderingRule)this.stack.get(i)).isGroup()) continue;
                return false;
            }
            return true;
        }

        public void startElement(String name) throws XmlPullParserException, IOException {
            boolean stateChanged = false;
            boolean isCase = this.isCase(name);
            boolean isSwitch = this.isSwitch(name);
            if (isCase || isSwitch) {
                this.attrsMap.clear();
                boolean top = this.stack.size() == 0 || this.isTopCase();
                this.parseAttributes(this.attrsMap);
                RenderingRule renderingRule = new RenderingRule(this.attrsMap, isSwitch, RenderingRulesStorage.this);
                if (top || STORE_ATTTRIBUTES) {
                    renderingRule.storeAttributes(this.attrsMap);
                }
                if (this.stack.size() > 0 && this.stack.peek() instanceof RenderingRule) {
                    RenderingRule parent = this.stack.peek();
                    parent.addIfElseChildren(renderingRule);
                }
                this.stack.push(renderingRule);
            } else if (this.isApply(name)) {
                this.attrsMap.clear();
                this.parseAttributes(this.attrsMap);
                RenderingRule renderingRule = new RenderingRule(this.attrsMap, false, RenderingRulesStorage.this);
                if (STORE_ATTTRIBUTES) {
                    renderingRule.storeAttributes(this.attrsMap);
                }
                if (this.stack.size() <= 0 || !(this.stack.peek() instanceof RenderingRule)) {
                    throw new XmlPullParserException("Apply (groupFilter) without parent");
                }
                this.stack.peek().addIfChildren(renderingRule);
                this.stack.push(renderingRule);
            } else if ("order".equals(name)) {
                this.state = 5;
                stateChanged = true;
            } else if ("text".equals(name)) {
                this.state = 4;
                stateChanged = true;
            } else if ("point".equals(name)) {
                this.state = 1;
                stateChanged = true;
            } else if ("line".equals(name)) {
                this.state = 2;
                stateChanged = true;
            } else if ("polygon".equals(name)) {
                this.state = 3;
                stateChanged = true;
            } else if ("renderingAttribute".equals(name)) {
                String attr = this.parser.getAttributeValue("", "name");
                RenderingRule root = new RenderingRule(new HashMap<String, String>(), false, RenderingRulesStorage.this);
                RenderingRulesStorage.this.renderingAttributes.put(attr, root);
                this.stack.push(root);
            } else if ("renderingProperty".equals(name)) {
                String attr = this.parser.getAttributeValue("", "attr");
                String type = this.parser.getAttributeValue("", "type");
                RenderingRuleProperty prop = "boolean".equalsIgnoreCase(type) ? RenderingRuleProperty.createInputBooleanProperty(attr) : ("string".equalsIgnoreCase(type) ? RenderingRuleProperty.createInputStringProperty(attr) : RenderingRuleProperty.createInputIntProperty(attr));
                prop.setDescription(this.parser.getAttributeValue("", "description"));
                prop.setDefaultValueDescription(this.parser.getAttributeValue("", "defaultValueDescription"));
                prop.setCategory(this.parser.getAttributeValue("", "category"));
                prop.setName(this.parser.getAttributeValue("", "name"));
                if (this.parser.getAttributeValue("", "possibleValues") != null) {
                    prop.setPossibleValues(this.parser.getAttributeValue("", "possibleValues").split(","));
                }
                RenderingRulesStorage.this.PROPS.registerRule(prop);
            } else if ("renderingConstant".equals(name)) {
                if (!RenderingRulesStorage.this.renderingConstants.containsKey(this.parser.getAttributeValue("", "name"))) {
                    RenderingRulesStorage.this.renderingConstants.put(this.parser.getAttributeValue("", "name"), this.parser.getAttributeValue("", "value"));
                }
            } else if ("renderingStyle".equals(name)) {
                String depends = this.parser.getAttributeValue("", "depends");
                if (depends != null && depends.length() > 0) {
                    this.dependsStorage = this.resolver.resolve(depends, this.resolver);
                }
                if (this.dependsStorage != null) {
                    RenderingRulesStorage.this.dictionary = new ArrayList<String>(this.dependsStorage.dictionary);
                    RenderingRulesStorage.this.dictionaryMap = new LinkedHashMap<String, Integer>(this.dependsStorage.dictionaryMap);
                    RenderingRulesStorage.this.PROPS = new RenderingRuleStorageProperties(this.dependsStorage.PROPS);
                }
                RenderingRulesStorage.this.internalRenderingName = this.parser.getAttributeValue("", "name");
            } else {
                if ("renderer".equals(name)) {
                    throw new XmlPullParserException("Rendering style is deprecated and no longer supported.");
                }
                log.warn((Object)("Unknown tag : " + name));
            }
            if (stateChanged) {
                RenderingRulesStorage.this.tagValueGlobalRules[this.state] = new TIntObjectHashMap();
            }
        }

        protected boolean isCase(String name) {
            return "filter".equals(name) || "case".equals(name);
        }

        protected boolean isApply(String name) {
            return "groupFilter".equals(name) || "apply".equals(name) || "apply_if".equals(name);
        }

        protected boolean isSwitch(String name) {
            return "group".equals(name) || "switch".equals(name);
        }

        private Map<String, String> parseAttributes(Map<String, String> m) {
            for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                String name = this.parser.getAttributeName(i);
                String vl = this.parser.getAttributeValue(i);
                if (vl != null && vl.startsWith("$")) {
                    String cv = vl.substring(1);
                    if (!RenderingRulesStorage.this.renderingConstants.containsKey(cv) && !RenderingRulesStorage.this.renderingAttributes.containsKey(cv)) {
                        throw new IllegalStateException("Rendering constant or attribute '" + cv + "' was not specified.");
                    }
                    if (RenderingRulesStorage.this.renderingConstants.containsKey(cv)) {
                        vl = RenderingRulesStorage.this.renderingConstants.get(cv);
                    }
                }
                m.put(name, vl);
            }
            return m;
        }

        public void endElement(String name) throws XmlPullParserException {
            if (this.isCase(name) || this.isSwitch(name)) {
                RenderingRule renderingRule = this.stack.pop();
                if (this.stack.size() == 0) {
                    this.registerTopLevel(renderingRule, null, Collections.EMPTY_MAP);
                }
            } else if (this.isApply(name)) {
                this.stack.pop();
            } else if ("renderingAttribute".equals(name)) {
                this.stack.pop();
            }
        }

        protected void registerTopLevel(RenderingRule renderingRule, List<RenderingRule> applyRules, Map<String, String> attrs) throws XmlPullParserException {
            block6: {
                block5: {
                    if (!renderingRule.isGroup() || renderingRule.getIntPropertyValue("tag") != -1 && renderingRule.getIntPropertyValue("value") != -1) break block5;
                    List<RenderingRule> caseChildren = renderingRule.getIfElseChildren();
                    for (RenderingRule ch : caseChildren) {
                        List<RenderingRule> apply = applyRules;
                        if (!renderingRule.getIfChildren().isEmpty()) {
                            apply = new ArrayList<RenderingRule>();
                            apply.addAll(renderingRule.getIfChildren());
                            if (applyRules != null) {
                                apply.addAll(applyRules);
                            }
                        }
                        HashMap<String, String> cattrs = new HashMap<String, String>(attrs);
                        cattrs.putAll(renderingRule.getAttributes());
                        this.registerTopLevel(ch, apply, cattrs);
                    }
                    break block6;
                }
                String tg = null;
                String vl = null;
                HashMap<String, String> ns = new HashMap<String, String>(attrs);
                ns.putAll(renderingRule.getAttributes());
                tg = ns.remove("tag");
                vl = ns.remove("value");
                renderingRule.init(ns);
                if (STORE_ATTTRIBUTES) {
                    renderingRule.storeAttributes(ns);
                }
                RenderingRulesStorage.this.registerGlobalRule(renderingRule, this.state, tg, vl);
                if (applyRules == null) break block6;
                for (RenderingRule apply : applyRules) {
                    renderingRule.addIfChildren(apply);
                }
            }
        }
    }

    public static interface RenderingRulesStorageResolver {
        public RenderingRulesStorage resolve(String var1, RenderingRulesStorageResolver var2) throws XmlPullParserException, IOException;
    }
}

