/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.LatLon;
import net.osmand.router.TurnType;
import net.osmand.util.MapUtils;

public class RouteSegmentResult {
    private final RouteDataObject object;
    private int startPointIndex;
    private int endPointIndex;
    private List<RouteSegmentResult>[] attachedRoutes;
    private RouteSegmentResult[][] preAttachedRoutes;
    private float segmentTime;
    private float routingTime;
    private float speed;
    private float distance;
    private String description = "";
    private TurnType turnType;

    public RouteSegmentResult(RouteDataObject object, int startPointIndex, int endPointIndex) {
        this.object = object;
        this.startPointIndex = startPointIndex;
        this.endPointIndex = endPointIndex;
        this.updateCapacity();
    }

    private void updateCapacity() {
        int capacity = Math.abs(this.endPointIndex - this.startPointIndex) + 1;
        List<RouteSegmentResult>[] old = this.attachedRoutes;
        this.attachedRoutes = new List[capacity];
        if (old != null) {
            System.arraycopy(old, 0, this.attachedRoutes, 0, Math.min(old.length, this.attachedRoutes.length));
        }
    }

    public void attachRoute(int roadIndex, RouteSegmentResult r) {
        int st = Math.abs(roadIndex - this.startPointIndex);
        if (this.attachedRoutes[st] == null) {
            this.attachedRoutes[st] = new ArrayList<RouteSegmentResult>();
        }
        this.attachedRoutes[st].add(r);
    }

    public void copyPreattachedRoutes(RouteSegmentResult toCopy, int shift) {
        if (toCopy.preAttachedRoutes != null) {
            int l = toCopy.preAttachedRoutes.length - shift;
            this.preAttachedRoutes = new RouteSegmentResult[l][];
            System.arraycopy(toCopy.preAttachedRoutes, shift, this.preAttachedRoutes, 0, l);
        }
    }

    public RouteSegmentResult[] getPreAttachedRoutes(int routeInd) {
        int st = Math.abs(routeInd - this.startPointIndex);
        if (this.preAttachedRoutes != null && st < this.preAttachedRoutes.length) {
            return this.preAttachedRoutes[st];
        }
        return null;
    }

    public List<RouteSegmentResult> getAttachedRoutes(int routeInd) {
        int st = Math.abs(routeInd - this.startPointIndex);
        List<RouteSegmentResult> list = this.attachedRoutes[st];
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public TurnType getTurnType() {
        return this.turnType;
    }

    public void setTurnType(TurnType turnType) {
        this.turnType = turnType;
    }

    public RouteDataObject getObject() {
        return this.object;
    }

    public float getSegmentTime() {
        return this.segmentTime;
    }

    public float getBearingBegin() {
        return (float)(this.object.directionRoute(this.startPointIndex, this.startPointIndex < this.endPointIndex) / Math.PI * 180.0);
    }

    public float getBearing(int point, boolean plus) {
        return (float)(this.object.directionRoute(point, plus) / Math.PI * 180.0);
    }

    public float getDistance(int point, boolean plus) {
        return (float)(plus ? this.object.distance(point, this.endPointIndex) : this.object.distance(this.startPointIndex, point));
    }

    public float getBearingEnd() {
        return (float)(MapUtils.alignAngleDifference(this.object.directionRoute(this.endPointIndex, this.startPointIndex > this.endPointIndex) - Math.PI) / Math.PI * 180.0);
    }

    public void setSegmentTime(float segmentTime) {
        this.segmentTime = segmentTime;
    }

    public void setRoutingTime(float routingTime) {
        this.routingTime = routingTime;
    }

    public float getRoutingTime() {
        return this.routingTime;
    }

    public LatLon getStartPoint() {
        return this.convertPoint(this.object, this.startPointIndex);
    }

    public int getStartPointIndex() {
        return this.startPointIndex;
    }

    public int getEndPointIndex() {
        return this.endPointIndex;
    }

    public LatLon getPoint(int i) {
        return this.convertPoint(this.object, i);
    }

    public LatLon getEndPoint() {
        return this.convertPoint(this.object, this.endPointIndex);
    }

    public boolean isForwardDirection() {
        return this.endPointIndex - this.startPointIndex > 0;
    }

    private LatLon convertPoint(RouteDataObject o, int ind) {
        return new LatLon(MapUtils.get31LatitudeY(o.getPoint31YTile(ind)), MapUtils.get31LongitudeX(o.getPoint31XTile(ind)));
    }

    public void setSegmentSpeed(float speed) {
        this.speed = speed;
    }

    public void setEndPointIndex(int endPointIndex) {
        this.endPointIndex = endPointIndex;
        this.updateCapacity();
    }

    public void setStartPointIndex(int startPointIndex) {
        this.startPointIndex = startPointIndex;
        this.updateCapacity();
    }

    public float getSegmentSpeed() {
        return this.speed;
    }

    public float getDistance() {
        return this.distance;
    }

    public void setDistance(float distance) {
        this.distance = distance;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "RouteSegmentResult [object=" + this.object + ", startPointIndex=" + this.startPointIndex + ", endPointIndex=" + this.endPointIndex + ", attachedRoutes=" + Arrays.toString(this.attachedRoutes) + ", preAttachedRoutes=" + Arrays.toString((Object[])this.preAttachedRoutes) + ", segmentTime=" + this.segmentTime + ", routingTime=" + this.routingTime + ", speed=" + this.speed + ", distance=" + this.distance + ", description=" + this.description + ", turnType=" + this.turnType + "]";
    }
}

