/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.AQMessageI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIaqm;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4Ctoh;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
final class T4Caqe
extends T4CTTIfun {
    static final int KPD_AQ_BUFMSG = 2;
    static final int KPD_AQ_EITHER = 16;
    static final int OCI_COMMIT_ON_SUCCESS = 32;
    static final int ATTR_TRANSFORMATION = 196;
    static final int AQEVER_DEFAULT = 1;
    T4CTTIaqm aqm;
    T4Ctoh toh;
    private byte[] queueNameBytes;
    private AQEnqueueOptions enqueueOptions;
    private AQMessagePropertiesI messageProperties;
    private byte[] messageData;
    private byte[] messageOid;
    private int aqever;
    private boolean isRawQueue;
    private int nbExtensions;
    private byte[][] extensionTextValues;
    private byte[][] extensionBinaryValues;
    private int[] extensionKeywords;
    private AQAgentI[] attrRecipientList;
    private byte[][] recipientTextValues;
    private byte[][] recipientBinaryValues;
    private int[] recipientKeywords;
    private byte[] aqmcorBytes;
    private byte[] aqmeqnBytes;
    private boolean retrieveMessageId;
    private byte[] outMsgid;
    private byte[] senderAgentName;
    private byte[] senderAgentAddress;
    private byte senderAgentProtocol;
    private boolean isJsonQueue;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    T4Caqe(T4CConnection _connection) {
        super(_connection, (byte)3);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4Caqe.class, $$$methodRef$$$5, null, _connection);
            }
            this.queueNameBytes = null;
            this.enqueueOptions = null;
            this.messageProperties = null;
            this.messageData = null;
            this.messageOid = null;
            this.aqever = 1;
            this.isRawQueue = false;
            this.nbExtensions = 0;
            this.extensionTextValues = null;
            this.extensionBinaryValues = null;
            this.extensionKeywords = null;
            this.attrRecipientList = null;
            this.recipientTextValues = null;
            this.recipientBinaryValues = null;
            this.recipientKeywords = null;
            this.retrieveMessageId = false;
            this.outMsgid = null;
            this.senderAgentName = null;
            this.senderAgentAddress = null;
            this.senderAgentProtocol = 0;
            this.setFunCode((short)121);
            this.toh = new T4Ctoh(_connection);
            this.aqm = new T4CTTIaqm(this.connection, this.toh);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4Caqe.class, $$$methodRef$$$5, null);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4Caqe.class, $$$methodRef$$$5, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4Caqe.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void doOAQEQ(String string, AQEnqueueOptions aQEnqueueOptions, AQMessagePropertiesI aQMessagePropertiesI, byte[] byArray, byte[] byArray2, int n2, boolean bl) throws SQLException, IOException {
        boolean bl2 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            String transformation;
            void _queueName;
            void _isRawQueue;
            void _messageVersion;
            void _messageOid;
            void _messageData;
            void _messageProperties;
            void _enqueueOptions;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4Caqe.class, $$$methodRef$$$0, this, string, aQEnqueueOptions, aQMessagePropertiesI, byArray, byArray2, n2, bl);
            }
            this.enqueueOptions = _enqueueOptions;
            this.messageProperties = _messageProperties;
            String aqmcor = this.messageProperties.getCorrelation();
            this.aqmcorBytes = (byte[])(aqmcor != null && aqmcor.length() != 0 ? this.meg.conv.StringToCharBytes(aqmcor) : null);
            String aqmeqn = this.messageProperties.getExceptionQueue();
            this.aqmeqnBytes = (byte[])(aqmeqn != null && aqmeqn.length() != 0 ? this.meg.conv.StringToCharBytes(aqmeqn) : null);
            AQAgentI senderAgent = (AQAgentI)this.messageProperties.getSender();
            if (senderAgent != null) {
                this.senderAgentName = (byte[])(senderAgent.getName() != null ? this.meg.conv.StringToCharBytes(senderAgent.getName()) : null);
                this.senderAgentAddress = (byte[])(senderAgent.getAddress() != null ? this.meg.conv.StringToCharBytes(senderAgent.getAddress()) : null);
                this.senderAgentProtocol = (byte)senderAgent.getProtocol();
            } else {
                this.senderAgentName = null;
                this.senderAgentAddress = null;
                this.senderAgentProtocol = 0;
            }
            this.messageData = _messageData;
            this.messageOid = _messageOid;
            this.aqever = _messageVersion;
            this.isRawQueue = _isRawQueue;
            this.isJsonQueue = AQMessageI.compareToid(this.messageOid, TypeDescriptor.JSONTOID);
            this.queueNameBytes = (byte[])(_queueName != null && _queueName.length() != 0 ? this.meg.conv.StringToCharBytes((String)_queueName) : null);
            this.attrRecipientList = (AQAgentI[])this.messageProperties.getRecipientList();
            if (this.attrRecipientList != null && this.attrRecipientList.length > 0) {
                this.recipientTextValues = new byte[this.attrRecipientList.length * 3][];
                this.recipientBinaryValues = new byte[this.attrRecipientList.length * 3][];
                this.recipientKeywords = new int[this.attrRecipientList.length * 3];
                for (int i2 = 0; i2 < this.attrRecipientList.length; ++i2) {
                    if (this.attrRecipientList[i2].getName() != null) {
                        this.recipientTextValues[3 * i2] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i2].getName());
                    }
                    if (this.attrRecipientList[i2].getAddress() != null) {
                        this.recipientTextValues[3 * i2 + 1] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i2].getAddress());
                    }
                    this.recipientBinaryValues[3 * i2 + 2] = new byte[1];
                    this.recipientBinaryValues[3 * i2 + 2][0] = (byte)this.attrRecipientList[i2].getProtocol();
                    this.recipientKeywords[3 * i2] = 3 * i2;
                    this.recipientKeywords[3 * i2 + 1] = 3 * i2 + 1;
                    this.recipientKeywords[3 * i2 + 2] = 3 * i2 + 2;
                }
            }
            if ((transformation = this.enqueueOptions.getTransformation()) != null && transformation.length() > 0) {
                this.nbExtensions = 1;
                this.extensionTextValues = new byte[this.nbExtensions][];
                this.extensionBinaryValues = new byte[this.nbExtensions][];
                this.extensionKeywords = new int[this.nbExtensions];
                this.extensionTextValues[0] = this.meg.conv.StringToCharBytes(transformation);
                this.extensionBinaryValues[0] = null;
                this.extensionKeywords[0] = 196;
            } else {
                this.nbExtensions = 0;
            }
            this.outMsgid = null;
            this.doRPC();
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4Caqe.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4Caqe.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4Caqe.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void marshal() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4Caqe.class, $$$methodRef$$$1, this, new Object[0]);
            }
            if (this.queueNameBytes != null && this.queueNameBytes.length != 0) {
                this.meg.marshalPTR();
                this.meg.marshalSWORD(this.queueNameBytes.length);
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
            }
            this.aqm.initToDefaultValues();
            this.aqm.aqmpri = this.messageProperties.getPriority();
            this.aqm.aqmdel = this.messageProperties.getDelay();
            this.aqm.aqmexp = this.messageProperties.getExpiration();
            this.aqm.aqmcorBytes = this.aqmcorBytes;
            this.aqm.aqmeqnBytes = this.aqmeqnBytes;
            this.aqm.senderAgentName = this.senderAgentName;
            this.aqm.senderAgentAddress = this.senderAgentAddress;
            this.aqm.senderAgentProtocol = this.senderAgentProtocol;
            this.aqm.originalMsgId = this.messageProperties.getPreviousQueueMessageId();
            this.aqm.marshal();
            AQAgentI[] attrRecipientList = (AQAgentI[])this.messageProperties.getRecipientList();
            if (attrRecipientList != null && attrRecipientList.length > 0) {
                this.meg.marshalPTR();
                this.meg.marshalSWORD(attrRecipientList.length * 3);
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
            }
            this.meg.marshalSB4(this.enqueueOptions.getVisibility().getCode());
            boolean sendRelativeMessageId = false;
            if (this.enqueueOptions.getRelativeMessageId() != null && this.enqueueOptions.getRelativeMessageId().length > 0) {
                sendRelativeMessageId = true;
                this.meg.marshalPTR();
                this.meg.marshalSWORD(this.enqueueOptions.getRelativeMessageId().length);
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
            }
            this.meg.marshalSWORD(this.enqueueOptions.getSequenceDeviation().getCode());
            this.meg.marshalPTR();
            this.meg.marshalSWORD(16);
            this.meg.marshalUB2(this.aqever);
            if (!this.isRawQueue) {
                if (this.isJsonQueue) {
                    this.meg.marshalNULLPTR();
                    this.meg.marshalNULLPTR();
                    this.meg.marshalUB4(0L);
                } else {
                    this.meg.marshalPTR();
                    this.meg.marshalNULLPTR();
                    this.meg.marshalUB4(0L);
                }
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalPTR();
                this.meg.marshalUB4(this.messageData.length);
            }
            if (this.enqueueOptions.getRetrieveMessageId()) {
                this.retrieveMessageId = true;
                this.meg.marshalPTR();
                this.meg.marshalSWORD(16);
            } else {
                this.retrieveMessageId = false;
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
            }
            int aqeflg = 0;
            if (this.connection.autocommit) {
                aqeflg = 32;
            }
            if (this.enqueueOptions.getDeliveryMode() == AQEnqueueOptions.DeliveryMode.BUFFERED) {
                aqeflg |= 2;
            }
            this.meg.marshalUB4(aqeflg);
            this.meg.marshalNULLPTR();
            this.meg.marshalNULLPTR();
            if (this.nbExtensions > 0) {
                this.meg.marshalPTR();
                this.meg.marshalSWORD(this.nbExtensions);
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
            }
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
            this.meg.marshalNULLPTR();
            if (this.connection.getTTCVersion() >= 4) {
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
                this.meg.marshalNULLPTR();
                this.meg.marshalNULLPTR();
                if (this.connection.getTTCVersion() >= 14) {
                    if (this.isJsonQueue) {
                        this.meg.marshalPTR();
                    } else {
                        this.meg.marshalNULLPTR();
                    }
                }
            }
            if (this.queueNameBytes != null && this.queueNameBytes.length != 0) {
                this.meg.marshalCHR(this.queueNameBytes);
            }
            if (attrRecipientList != null && attrRecipientList.length > 0) {
                this.meg.marshalKPDKV(this.recipientTextValues, this.recipientBinaryValues, this.recipientKeywords);
            }
            if (sendRelativeMessageId) {
                this.meg.marshalB1Array(this.enqueueOptions.getRelativeMessageId());
            }
            this.meg.marshalB1Array(this.messageOid);
            if (!this.isRawQueue) {
                if (!this.isJsonQueue) {
                    this.toh.init(this.messageOid, this.messageData.length);
                    this.toh.marshal(this.meg);
                    this.meg.marshalCLR(this.messageData, 0, this.messageData.length);
                }
            } else {
                this.meg.marshalB1Array(this.messageData);
            }
            if (this.nbExtensions > 0) {
                this.meg.marshalKPDKV(this.extensionTextValues, this.extensionBinaryValues, this.extensionKeywords);
            }
            if (this.isJsonQueue) {
                byte[] quasiLocator = T4CConnection.setupQuasiLocator(this.messageData.length);
                this.meg.marshalUB4(quasiLocator.length);
                this.meg.marshalB1Array(quasiLocator);
                if (this.connection.isZeroCopyIOEnabled()) {
                    this.meg.writeZeroCopyIO(this.messageData, 0, this.messageData.length);
                } else {
                    this.meg.marshalCLR(this.messageData, 0, this.messageData.length);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4Caqe.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4Caqe.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4Caqe.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    byte[] getMessageId() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4Caqe.class, $$$methodRef$$$2, this, new Object[0]);
            }
            byte[] byArray = this.outMsgid;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4Caqe.class, $$$methodRef$$$2, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4Caqe.class, $$$methodRef$$$2, this, null);
            }
            return this.outMsgid;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4Caqe.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void readRPA() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4Caqe.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (this.retrieveMessageId) {
                this.outMsgid = new byte[16];
                this.meg.unmarshalBuffer(this.outMsgid, 0, 16);
            }
            int ign1 = this.meg.unmarshalUB2();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4Caqe.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4Caqe.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4Caqe.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4Caqe.class, $$$methodRef$$$4, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4Caqe.class, $$$methodRef$$$4, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4Caqe.class, $$$methodRef$$$4, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4Caqe.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$5 = T4Caqe.class.getDeclaredConstructor(T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4Caqe.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4Caqe.class.getDeclaredMethod("readRPA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4Caqe.class.getDeclaredMethod("getMessageId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4Caqe.class.getDeclaredMethod("marshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4Caqe.class.getDeclaredMethod("doOAQEQ", String.class, AQEnqueueOptions.class, AQMessagePropertiesI.class, byte[].class, byte[].class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

