/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint.config;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionRule;
import schemacrawler.tools.lint.LintSeverity;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.ObjectToString;
import us.fatehi.utility.Utility;

public class LinterConfig
implements Serializable,
Comparable<LinterConfig> {
    private static final long serialVersionUID = 83079182550531365L;
    private final String linterId;
    private final Map<String, Object> config;
    private final boolean runLinter;
    private final LintSeverity severity;
    private final int threshold;
    private final String tableInclusionPattern;
    private final String tableExclusionPattern;
    private final String columnInclusionPattern;
    private final String columnExclusionPattern;

    @ConstructorProperties(value={"id", "run", "severity", "threshold", "table-inclusion-pattern", "table-exclusion-pattern", "column-inclusion-pattern", "column-exclusion-pattern", "config"})
    public LinterConfig(String linterId, Boolean runLinter, LintSeverity severity, Integer threshold, String tableInclusionPattern, String tableExclusionPattern, String columnInclusionPattern, String columnExclusionPattern, Map<String, Object> config) {
        this.linterId = Utility.requireNotBlank((String)linterId, (String)"No linter id provided");
        this.runLinter = runLinter == null ? true : runLinter;
        this.severity = severity;
        this.threshold = threshold == null ? Integer.MAX_VALUE : threshold;
        this.tableInclusionPattern = tableInclusionPattern;
        this.tableExclusionPattern = tableExclusionPattern;
        this.columnInclusionPattern = columnInclusionPattern;
        this.columnExclusionPattern = columnExclusionPattern;
        this.config = config == null ? new HashMap<String, Object>() : new HashMap<String, Object>(config);
    }

    @Override
    public int compareTo(LinterConfig other) {
        if (other == null) {
            return -1;
        }
        int comparison = 0;
        if (comparison == 0) {
            comparison = -1 * (this.severity == null ? LintSeverity.low : this.severity).compareTo(other.severity == null ? LintSeverity.low : other.severity);
        }
        if (comparison == 0) {
            comparison = this.linterId.compareTo(other.linterId);
        }
        return comparison;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinterConfig)) {
            return false;
        }
        LinterConfig other = (LinterConfig)obj;
        if (!Objects.equals(this.linterId, other.linterId)) {
            return false;
        }
        return this.severity == other.severity;
    }

    public InclusionRule getColumnInclusionRule() {
        return new RegularExpressionRule(this.columnInclusionPattern, this.columnExclusionPattern);
    }

    public Config getConfig() {
        return new Config(this.config);
    }

    public String getLinterId() {
        return this.linterId;
    }

    public LintSeverity getSeverity() {
        return this.severity;
    }

    public InclusionRule getTableInclusionRule() {
        return new RegularExpressionRule(this.tableInclusionPattern, this.tableExclusionPattern);
    }

    public int getThreshold() {
        return this.threshold;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.linterId == null ? 0 : this.linterId.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        return result;
    }

    public boolean isRunLinter() {
        return this.runLinter;
    }

    public void put(String key, String value) {
        if (Utility.isBlank((CharSequence)key)) {
            return;
        }
        this.config.put(key, value);
    }

    public String toString() {
        return ObjectToString.toString((Object)this);
    }

    void setContext(Map<String, Object> config) {
        if (config != null) {
            HashMap<String, Object> linterConfig = new HashMap<String, Object>();
            linterConfig.putAll(config);
            linterConfig.putAll(this.config);
            this.config.clear();
            this.config.putAll(linterConfig);
        }
    }
}

