/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.utility;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import schemacrawler.crawl.ConnectionInfoBuilder;
import schemacrawler.crawl.ResultsCrawler;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ConnectionInfo;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.tools.catalogloader.CatalogLoaderRegistry;
import schemacrawler.tools.catalogloader.ChainedCatalogLoader;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorRegistry;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.PropertiesUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.string.ObjectToStringFormat;
import us.fatehi.utility.string.StringFormat;

public final class SchemaCrawlerUtility {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawlerUtility.class.getName());

    public static Catalog getCatalog(Connection connection, SchemaCrawlerOptions schemaCrawlerOptions) {
        SchemaCrawlerUtility.checkConnection(connection);
        LOGGER.log(Level.CONFIG, (Supplier<String>)new ObjectToStringFormat((Object)schemaCrawlerOptions));
        SchemaRetrievalOptions schemaRetrievalOptions = SchemaCrawlerUtility.matchSchemaRetrievalOptions(connection);
        return SchemaCrawlerUtility.getCatalog(connection, schemaRetrievalOptions, schemaCrawlerOptions, new Config());
    }

    public static Catalog getCatalog(Connection connection, SchemaRetrievalOptions schemaRetrievalOptions, SchemaCrawlerOptions schemaCrawlerOptions, Config additionalConfig) {
        CatalogLoaderRegistry catalogLoaderRegistry = new CatalogLoaderRegistry();
        ChainedCatalogLoader catalogLoader = catalogLoaderRegistry.newChainedCatalogLoader();
        LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Catalog loader: %s", new Object[]{catalogLoader}));
        SchemaCrawlerUtility.logConnection(connection);
        catalogLoader.setConnection(connection);
        catalogLoader.setSchemaRetrievalOptions(schemaRetrievalOptions);
        catalogLoader.setSchemaCrawlerOptions(schemaCrawlerOptions);
        catalogLoader.setAdditionalConfiguration(additionalConfig);
        catalogLoader.loadCatalog();
        Catalog catalog = catalogLoader.getCatalog();
        Objects.requireNonNull(catalog, "Catalog could not be retrieved");
        return catalog;
    }

    public static ResultsColumns getResultsColumns(ResultSet resultSet) {
        try {
            SchemaCrawlerUtility.checkResultSet(resultSet);
            ResultsCrawler resultSetCrawler = new ResultsCrawler(resultSet);
            ResultsColumns resultsColumns = resultSetCrawler.crawl();
            return resultsColumns;
        }
        catch (SQLException e) {
            throw new DatabaseAccessException("Could not retrieve result-set metadata", e);
        }
    }

    public static SchemaRetrievalOptions matchSchemaRetrievalOptions(Connection connection) {
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaCrawlerUtility.buildSchemaRetrievalOptions(connection);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        return schemaRetrievalOptions;
    }

    private static SchemaRetrievalOptionsBuilder buildSchemaRetrievalOptions(Connection connection) {
        SchemaCrawlerUtility.checkConnection(connection);
        DatabaseConnectorRegistry registry = DatabaseConnectorRegistry.getDatabaseConnectorRegistry();
        DatabaseConnector dbConnector = registry.findDatabaseConnector(connection);
        DatabaseServerType databaseServerType = dbConnector.getDatabaseServerType();
        LOGGER.log(Level.INFO, "Using database plugin for " + databaseServerType);
        boolean useMatchedDatabasePlugin = SchemaCrawlerUtility.useMatchedDatabasePlugin(connection, databaseServerType);
        if (!useMatchedDatabasePlugin) {
            dbConnector = DatabaseConnector.UNKNOWN;
        }
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = dbConnector.getSchemaRetrievalOptionsBuilder(connection);
        return schemaRetrievalOptionsBuilder;
    }

    private static void checkConnection(Connection connection) {
        try {
            DatabaseUtility.checkConnection((Connection)connection);
        }
        catch (SQLException e) {
            throw new InternalRuntimeException("Bad database connection", (Throwable)e);
        }
    }

    private static void checkResultSet(ResultSet resultSet) {
        try {
            DatabaseUtility.checkResultSet((ResultSet)resultSet);
        }
        catch (SQLException e) {
            throw new DatabaseAccessException("Bad result-set", e);
        }
    }

    private static String extractDatabaseServerTypeFromUrl(String url) {
        String urlDBServerType;
        Pattern urlPattern = Pattern.compile("jdbc:(.*?):.*");
        Matcher matcher = urlPattern.matcher(url);
        if (!matcher.matches()) {
            return "";
        }
        if (matcher.groupCount() == 1) {
            String matchedDBServerType = matcher.group(1);
            urlDBServerType = Arrays.asList("db2", "hsqldb", "mariadb", "mysql", "oracle", "postgresql", "sqlite", "sqlserver").contains(matchedDBServerType) ? matchedDBServerType : null;
        } else {
            urlDBServerType = null;
        }
        if (Utility.isBlank(urlDBServerType)) {
            return "";
        }
        if ("mariadb".equals(urlDBServerType)) {
            return "mysql";
        }
        return urlDBServerType;
    }

    private static String getConnectionUrl(Connection connection) {
        String url;
        Objects.requireNonNull(connection, "No connection provided");
        try {
            url = connection.getMetaData().getURL();
        }
        catch (SQLException e) {
            LOGGER.log(Level.CONFIG, "Cannot get connection URL");
            return "";
        }
        return url;
    }

    private static void logConnection(Connection connection) {
        if (connection == null || !LOGGER.isLoggable(Level.INFO)) {
            return;
        }
        try {
            ConnectionInfo connectionInfo = ConnectionInfoBuilder.builder((Connection)connection).build();
            LOGGER.log(Level.INFO, connectionInfo.toString());
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not log connection information");
            LOGGER.log(Level.FINE, "Could not log connection information", e);
        }
    }

    private static boolean useMatchedDatabasePlugin(Connection connection, DatabaseServerType dbServerType) {
        String url = SchemaCrawlerUtility.getConnectionUrl(connection);
        if (Utility.isBlank((CharSequence)url)) {
            return true;
        }
        String urlDBServerType = SchemaCrawlerUtility.extractDatabaseServerTypeFromUrl(url);
        if (Utility.isBlank((CharSequence)urlDBServerType)) {
            return true;
        }
        boolean dbConnectorPresent = urlDBServerType.equalsIgnoreCase(dbServerType.getDatabaseSystemIdentifier());
        String withoutDatabasePlugin = PropertiesUtility.getSystemConfigurationProperty((String)"SC_WITHOUT_DATABASE_PLUGIN", (String)"");
        boolean useWithoutDatabasePlugin = urlDBServerType.equalsIgnoreCase(withoutDatabasePlugin);
        if (!dbConnectorPresent && !useWithoutDatabasePlugin) {
            throw new InternalRuntimeException(String.format("SchemaCrawler database plugin should be on the CLASSPATH for <%s>, or the SC_WITHOUT_DATABASE_PLUGIN environmental variable should be set", url));
        }
        boolean useMatchedDatabasePlugin = dbConnectorPresent && !useWithoutDatabasePlugin;
        return useMatchedDatabasePlugin;
    }

    private SchemaCrawlerUtility() {
    }
}

