/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbService;
import org.firebirdsql.management.FBServiceManager;
import org.firebirdsql.management.NBackupManager;

public class FBNBackupManager
extends FBServiceManager
implements NBackupManager {
    private final List<String> backupFiles = new ArrayList<String>();
    private int backupLevel = -1;
    private String backupGuid;
    private boolean noDBTriggers;
    private boolean inPlaceRestore;

    public FBNBackupManager() {
    }

    public FBNBackupManager(String gdsType) {
        super(gdsType);
    }

    public FBNBackupManager(GDSType gdsType) {
        super(gdsType);
    }

    @Override
    public void setBackupFile(String backupFile) {
        this.addBackupFile(backupFile);
    }

    @Override
    public void addBackupFile(String backupFile) {
        this.backupFiles.add(backupFile);
    }

    @Override
    public void clearBackupFiles() {
        this.backupFiles.clear();
    }

    @Override
    public void backupDatabase() throws SQLException {
        try (FbService service = this.attachServiceManager();){
            this.executeServicesOperation(service, this.getBackupSRB(service));
        }
    }

    private ServiceRequestBuffer getBackupSRB(FbService service) throws SQLException {
        int options;
        ServiceRequestBuffer backupSPB = service.createServiceRequestBuffer();
        backupSPB.addArgument(20);
        backupSPB.addArgument(106, this.getDatabase());
        if (this.backupFiles.isEmpty()) {
            throw new SQLException("No backup file specified");
        }
        String backupFile = this.backupFiles.get(0);
        backupSPB.addArgument(6, backupFile);
        int resolvedBackupLevel = this.backupLevel == -1 && this.backupGuid == null ? 0 : this.backupLevel;
        backupSPB.addArgument(5, resolvedBackupLevel);
        if (this.backupGuid != null) {
            backupSPB.addArgument(8, this.backupGuid);
        }
        if ((options = this.getOptions()) != 0) {
            backupSPB.addArgument(108, options);
        }
        return backupSPB;
    }

    @Override
    public void restoreDatabase() throws SQLException {
        try (FbService service = this.attachServiceManager();){
            this.executeServicesOperation(service, this.getRestoreSRB(service));
        }
    }

    private ServiceRequestBuffer getRestoreSRB(FbService service) throws SQLException {
        ServiceRequestBuffer restoreSPB = service.createServiceRequestBuffer();
        restoreSPB.addArgument(21);
        restoreSPB.addArgument(106, this.getDatabase());
        if (this.backupFiles.isEmpty()) {
            throw new SQLException("No backup file specified");
        }
        for (String backupFile : this.backupFiles) {
            restoreSPB.addArgument(6, backupFile);
        }
        int options = this.getOptions();
        if (options != 0) {
            restoreSPB.addArgument(108, options);
        }
        return restoreSPB;
    }

    private int getOptions() {
        int options = 0;
        if (this.noDBTriggers) {
            options |= 1;
        }
        if (this.inPlaceRestore) {
            options |= 2;
        }
        return options;
    }

    @Override
    public void setBackupLevel(int backupLevel) {
        this.backupLevel = backupLevel;
    }

    @Override
    public void setBackupGuid(String guid) {
        this.backupGuid = guid;
    }

    @Override
    public void setNoDBTriggers(boolean noDBTriggers) {
        this.noDBTriggers = noDBTriggers;
    }

    @Override
    public void setInPlaceRestore(boolean inPlaceRestore) {
        this.inPlaceRestore = inPlaceRestore;
    }
}

