/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import schemacrawler.crawl.AbstractNamedObjectWithAttributes;
import schemacrawler.crawl.MutableTableConstraintColumn;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.PartialDatabaseObject;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schema.TableReference;
import us.fatehi.utility.CompareUtility;

abstract class AbstractTableReference
extends AbstractNamedObjectWithAttributes
implements TableReference {
    private static final long serialVersionUID = -5164664131926303038L;
    private final SortedSet<ColumnReference> columnReferences = new TreeSet<ColumnReference>();
    private final NamedObjectList<TableConstraintColumn> tableConstraintColumns = new NamedObjectList();
    private transient MemoState state;

    public AbstractTableReference(String name) {
        super(name);
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        if (obj instanceof TableReference) {
            TableReference other = (TableReference)obj;
            List<ColumnReference> thisColumnReferences = this.getColumnReferences();
            List<ColumnReference> otherColumnReferences = other.getColumnReferences();
            return CompareUtility.compareLists(thisColumnReferences, otherColumnReferences);
        }
        if (obj instanceof NamedObject) {
            NamedObject other = obj;
            return super.compareTo(other);
        }
        return -1;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableReference)) {
            return false;
        }
        TableReference other = (TableReference)obj;
        return Objects.equals(this.getColumnReferences(), other.getColumnReferences());
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        return new ArrayList<ColumnReference>(this.columnReferences);
    }

    @Override
    public List<TableConstraintColumn> getConstrainedColumns() {
        return this.tableConstraintColumns.values();
    }

    @Override
    public Table getForeignKeyTable() {
        this.buildState();
        return this.state.getForeignKeyTable();
    }

    @Override
    public Table getParent() {
        return this.getForeignKeyTable();
    }

    @Override
    public Table getPrimaryKeyTable() {
        this.buildState();
        return this.state.getPrimaryKeyTable();
    }

    @Override
    public Schema getSchema() {
        this.buildState();
        return this.state.getForeignKeyTable().getSchema();
    }

    @Override
    public String getShortName() {
        return this.getName();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.columnReferences);
    }

    @Override
    public final boolean isParentPartial() {
        return this.getParent() instanceof PartialDatabaseObject;
    }

    @Override
    public Iterator<ColumnReference> iterator() {
        return this.columnReferences.iterator();
    }

    @Override
    public NamedObjectKey key() {
        this.buildState();
        return this.state.key();
    }

    void addColumnReference(ColumnReference columnReference) {
        if (columnReference == null) {
            return;
        }
        this.columnReferences.add(columnReference);
        this.addTableConstraintColumn(columnReference);
    }

    private void addTableConstraintColumn(ColumnReference columnReference) {
        Column fkColumn = columnReference.getForeignKeyColumn();
        MutableTableConstraintColumn tableConstraintColumn = new MutableTableConstraintColumn(this, fkColumn);
        tableConstraintColumn.setKeyOrdinalPosition(columnReference.getKeySequence());
        this.tableConstraintColumns.add(tableConstraintColumn);
    }

    private void buildState() {
        if (this.state == null) {
            this.state = new MemoState();
        }
    }

    private final class MemoState
    implements Serializable {
        private static final long serialVersionUID = -8137191924777748304L;
        private final Table pkTable;
        private final Table fkTable;
        private final NamedObjectKey key;

        MemoState() {
            Table pkTable = null;
            NamedObject fkTable = null;
            ArrayList columnReferences = new ArrayList(AbstractTableReference.this.columnReferences);
            for (int i = 0; i < columnReferences.size(); ++i) {
                ColumnReference columnReference = (ColumnReference)columnReferences.get(i);
                if (i != 0) continue;
                pkTable = (Table)columnReference.getPrimaryKeyColumn().getParent();
                fkTable = (Table)columnReference.getForeignKeyColumn().getParent();
            }
            this.pkTable = Objects.requireNonNull(pkTable, "No primary table found");
            this.fkTable = Objects.requireNonNull(fkTable, "No foreign table found");
            this.key = fkTable.key().with(AbstractTableReference.this.getName());
        }

        Table getForeignKeyTable() {
            return this.fkTable;
        }

        Table getPrimaryKeyTable() {
            return this.pkTable;
        }

        NamedObjectKey key() {
            return this.key;
        }
    }
}

