"use strict";
/*
 * Copyright (C) 2017, 2018 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LspClientImpl = void 0;
const lsp = __importStar(require("vscode-languageserver/node"));
const ts_protocol_1 = require("./ts-protocol");
class LspClientImpl {
    constructor(connection) {
        this.connection = connection;
    }
    setClientCapabilites(capabilites) {
        this.clientCapabilities = capabilites;
    }
    createProgressReporter() {
        let workDoneProgress;
        return {
            begin: (message = '') => {
                var _a, _b;
                if ((_b = (_a = this.clientCapabilities) === null || _a === void 0 ? void 0 : _a.window) === null || _b === void 0 ? void 0 : _b.workDoneProgress) {
                    workDoneProgress = this.connection.window.createWorkDoneProgress();
                    workDoneProgress
                        .then((progress) => {
                        progress.begin(message);
                    })
                        .catch(() => { });
                }
            },
            report: (message) => {
                if (workDoneProgress) {
                    workDoneProgress
                        .then((progress) => {
                        progress.report(message);
                    })
                        .catch(() => { });
                }
            },
            end: () => {
                if (workDoneProgress) {
                    workDoneProgress
                        .then((progress) => {
                        progress.done();
                    })
                        .catch(() => { });
                    workDoneProgress = undefined;
                }
            }
        };
    }
    publishDiagnostics(args) {
        this.connection.sendNotification(lsp.PublishDiagnosticsNotification.type, args);
    }
    showMessage(args) {
        this.connection.sendNotification(lsp.ShowMessageNotification.type, args);
    }
    logMessage(args) {
        this.connection.sendNotification(lsp.LogMessageNotification.type, args);
    }
    telemetry(args) {
        this.connection.sendNotification(lsp.TelemetryEventNotification.type, args);
    }
    applyWorkspaceEdit(args) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.connection.sendRequest(lsp.ApplyWorkspaceEditRequest.type, args);
        });
    }
    rename(args) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.connection.sendRequest(ts_protocol_1.TypeScriptRenameRequest.type, args);
        });
    }
}
exports.LspClientImpl = LspClientImpl;
//# sourceMappingURL=lsp-client.js.map