//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.7
//
// <auto-generated>
//
// Generated from file `Registry.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceGrid_Registry_h__
#define __IceGrid_Registry_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/SlicedDataF.h>
#include <IceGrid/Exception.h>
#include <IceGrid/Session.h>
#include <IceGrid/Admin.h>
#include <Ice/Locator.h>
#include <IceUtil/UndefSysMacros.h>
#include <IceGrid/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 7
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEGRID_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEGRID_API /**/
#   elif defined(ICEGRID_API_EXPORTS)
#       define ICEGRID_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEGRID_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceGrid
{

class Query;
class QueryPrx;
class Registry;
class RegistryPrx;
class Locator;
class LocatorPrx;

}

namespace IceGrid
{

/**
 * Determines which load sampling interval to use.
 */
enum class LoadSample : unsigned char
{
    /**
     * Sample every minute.
     */
    LoadSample1,
    /**
     * Sample every five minutes.
     */
    LoadSample5,
    /**
     * Sample every fifteen minutes.
     */
    LoadSample15
};

}

namespace IceGrid
{

/**
 * The IceGrid query interface. This interface is accessible to
 * Ice clients who wish to look up well-known objects.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API Query : public virtual ::Ice::Object
{
public:

    using ProxyType = QueryPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Find a well-known object by identity.
     * @param id The identity.
     * @param current The Current object for the invocation.
     * @return The proxy or null if no such object has been found.
     */
    virtual ::std::shared_ptr<::Ice::ObjectPrx> findObjectById(::Ice::Identity id, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_findObjectById(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     * @param type The object type.
     * @param current The Current object for the invocation.
     * @return The proxy or null, if no such object has been found.
     */
    virtual ::std::shared_ptr<::Ice::ObjectPrx> findObjectByType(::std::string type, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_findObjectByType(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     * @param type The object type.
     * @param sample The sampling interval.
     * @param current The Current object for the invocation.
     * @return The proxy or null, if no such object has been found.
     */
    virtual ::std::shared_ptr<::Ice::ObjectPrx> findObjectByTypeOnLeastLoadedNode(::std::string type, LoadSample sample, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_findObjectByTypeOnLeastLoadedNode(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Find all the well-known objects with the given type.
     * @param type The object type.
     * @param current The Current object for the invocation.
     * @return The proxies or an empty sequence, if no such objects
     * have been found.
     */
    virtual ::Ice::ObjectProxySeq findAllObjectsByType(::std::string type, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_findAllObjectsByType(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     * @param proxy The object proxy.
     * @param current The Current object for the invocation.
     * @return The proxies of each object replica or an empty sequence,
     * if the given proxy is not from a replica group.
     */
    virtual ::Ice::ObjectProxySeq findAllReplicas(::std::shared_ptr<::Ice::ObjectPrx> proxy, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_findAllReplicas(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * The IceGrid registry allows clients create sessions
 * directly with the registry.
 * @see Session
 * @see AdminSession
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API Registry : public virtual ::Ice::Object
{
public:

    using ProxyType = RegistryPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Create a client session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param current The Current object for the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    virtual ::std::shared_ptr<SessionPrx> createSession(::std::string userId, ::std::string password, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_createSession(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Create an administrative session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param current The Current object for the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    virtual ::std::shared_ptr<AdminSessionPrx> createAdminSession(::std::string userId, ::std::string password, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_createAdminSession(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Create a client session from a secure connection.
     * @param current The Current object for the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    virtual ::std::shared_ptr<SessionPrx> createSessionFromSecureConnection(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_createSessionFromSecureConnection(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Create an administrative session from a secure connection.
     * @param current The Current object for the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    virtual ::std::shared_ptr<AdminSessionPrx> createAdminSessionFromSecureConnection(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_createAdminSessionFromSecureConnection(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * @param current The Current object for the invocation.
     * @return The timeout (in seconds).
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     */
    virtual int getSessionTimeout(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getSessionTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param current The Current object for the invocation.
     * @return The timeout (in seconds).
     */
    virtual int getACMTimeout(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getACMTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * The IceGrid locator interface provides access to the {@link Query}
 * and {@link Registry} object of the IceGrid registry.
 * @see Query
 * @see Registry
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API Locator : public virtual ::Ice::Locator
{
public:

    using ProxyType = LocatorPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Get the proxy of the registry object hosted by this IceGrid
     * registry.
     * @param current The Current object for the invocation.
     * @return The proxy of the registry object.
     */
    virtual ::std::shared_ptr<RegistryPrx> getLocalRegistry(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getLocalRegistry(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the proxy of the query object hosted by this IceGrid
     * registry.
     * @param current The Current object for the invocation.
     * @return The proxy of the query object.
     */
    virtual ::std::shared_ptr<QueryPrx> getLocalQuery(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getLocalQuery(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

}

namespace IceGrid
{

/**
 * The IceGrid query interface. This interface is accessible to
 * Ice clients who wish to look up well-known objects.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) QueryPrx : public virtual ::Ice::Proxy<QueryPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Find a well-known object by identity.
     * @param id The identity.
     * @param context The Context map to send with the invocation.
     * @return The proxy or null if no such object has been found.
     */
    ::std::shared_ptr<::Ice::ObjectPrx> findObjectById(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &QueryPrx::_iceI_findObjectById, id, context).get();
    }

    /**
     * Find a well-known object by identity.
     * @param id The identity.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto findObjectByIdAsync(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &QueryPrx::_iceI_findObjectById, id, context);
    }

    /**
     * Find a well-known object by identity.
     * @param id The identity.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    findObjectByIdAsync(const ::Ice::Identity& id,
                        ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::QueryPrx::_iceI_findObjectById, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_findObjectById(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::Ice::Identity&, const ::Ice::Context&);
    /// \endcond

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @return The proxy or null, if no such object has been found.
     */
    ::std::shared_ptr<::Ice::ObjectPrx> findObjectByType(const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &QueryPrx::_iceI_findObjectByType, type, context).get();
    }

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto findObjectByTypeAsync(const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &QueryPrx::_iceI_findObjectByType, type, context);
    }

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     * @param type The object type.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    findObjectByTypeAsync(const ::std::string& type,
                          ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::QueryPrx::_iceI_findObjectByType, type, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_findObjectByType(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     * @param type The object type.
     * @param sample The sampling interval.
     * @param context The Context map to send with the invocation.
     * @return The proxy or null, if no such object has been found.
     */
    ::std::shared_ptr<::Ice::ObjectPrx> findObjectByTypeOnLeastLoadedNode(const ::std::string& type, LoadSample sample, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &QueryPrx::_iceI_findObjectByTypeOnLeastLoadedNode, type, sample, context).get();
    }

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     * @param type The object type.
     * @param sample The sampling interval.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto findObjectByTypeOnLeastLoadedNodeAsync(const ::std::string& type, LoadSample sample, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &QueryPrx::_iceI_findObjectByTypeOnLeastLoadedNode, type, sample, context);
    }

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     * @param type The object type.
     * @param sample The sampling interval.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    findObjectByTypeOnLeastLoadedNodeAsync(const ::std::string& type, LoadSample sample,
                                           ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                           ::std::function<void(bool)> sent = nullptr,
                                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::QueryPrx::_iceI_findObjectByTypeOnLeastLoadedNode, type, sample, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_findObjectByTypeOnLeastLoadedNode(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::std::string&, LoadSample, const ::Ice::Context&);
    /// \endcond

    /**
     * Find all the well-known objects with the given type.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @return The proxies or an empty sequence, if no such objects
     * have been found.
     */
    ::Ice::ObjectProxySeq findAllObjectsByType(const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::ObjectProxySeq>(true, this, &QueryPrx::_iceI_findAllObjectsByType, type, context).get();
    }

    /**
     * Find all the well-known objects with the given type.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto findAllObjectsByTypeAsync(const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::ObjectProxySeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::ObjectProxySeq, P>(false, this, &QueryPrx::_iceI_findAllObjectsByType, type, context);
    }

    /**
     * Find all the well-known objects with the given type.
     * @param type The object type.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    findAllObjectsByTypeAsync(const ::std::string& type,
                              ::std::function<void(::Ice::ObjectProxySeq)> response,
                              ::std::function<void(::std::exception_ptr)> ex = nullptr,
                              ::std::function<void(bool)> sent = nullptr,
                              const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::ObjectProxySeq>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::QueryPrx::_iceI_findAllObjectsByType, type, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_findAllObjectsByType(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::ObjectProxySeq>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     * @param proxy The object proxy.
     * @param context The Context map to send with the invocation.
     * @return The proxies of each object replica or an empty sequence,
     * if the given proxy is not from a replica group.
     */
    ::Ice::ObjectProxySeq findAllReplicas(const ::std::shared_ptr<::Ice::ObjectPrx>& proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::ObjectProxySeq>(true, this, &QueryPrx::_iceI_findAllReplicas, proxy, context).get();
    }

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     * @param proxy The object proxy.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto findAllReplicasAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::ObjectProxySeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::ObjectProxySeq, P>(false, this, &QueryPrx::_iceI_findAllReplicas, proxy, context);
    }

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     * @param proxy The object proxy.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    findAllReplicasAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& proxy,
                         ::std::function<void(::Ice::ObjectProxySeq)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::ObjectProxySeq>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::QueryPrx::_iceI_findAllReplicas, proxy, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_findAllReplicas(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::ObjectProxySeq>>&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    QueryPrx() = default;
    friend ::std::shared_ptr<QueryPrx> IceInternal::createProxy<QueryPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * The IceGrid registry allows clients create sessions
 * directly with the registry.
 * @see Session
 * @see AdminSession
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) RegistryPrx : public virtual ::Ice::Proxy<RegistryPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Create a client session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    ::std::shared_ptr<SessionPrx> createSession(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::SessionPrx>>(true, this, &RegistryPrx::_iceI_createSession, userId, password, context).get();
    }

    /**
     * Create a client session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto createSessionAsync(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::SessionPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::SessionPrx>, P>(false, this, &RegistryPrx::_iceI_createSession, userId, password, context);
    }

    /**
     * Create a client session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    createSessionAsync(const ::std::string& userId, const ::std::string& password,
                       ::std::function<void(::std::shared_ptr<::IceGrid::SessionPrx>)> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::SessionPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::RegistryPrx::_iceI_createSession, userId, password, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_createSession(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::SessionPrx>>>&, const ::std::string&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Create an administrative session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    ::std::shared_ptr<AdminSessionPrx> createAdminSession(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::AdminSessionPrx>>(true, this, &RegistryPrx::_iceI_createAdminSession, userId, password, context).get();
    }

    /**
     * Create an administrative session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto createAdminSessionAsync(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::AdminSessionPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::AdminSessionPrx>, P>(false, this, &RegistryPrx::_iceI_createAdminSession, userId, password, context);
    }

    /**
     * Create an administrative session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    createAdminSessionAsync(const ::std::string& userId, const ::std::string& password,
                            ::std::function<void(::std::shared_ptr<::IceGrid::AdminSessionPrx>)> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::AdminSessionPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::RegistryPrx::_iceI_createAdminSession, userId, password, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_createAdminSession(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::AdminSessionPrx>>>&, const ::std::string&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Create a client session from a secure connection.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    ::std::shared_ptr<SessionPrx> createSessionFromSecureConnection(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::SessionPrx>>(true, this, &RegistryPrx::_iceI_createSessionFromSecureConnection, context).get();
    }

    /**
     * Create a client session from a secure connection.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto createSessionFromSecureConnectionAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::SessionPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::SessionPrx>, P>(false, this, &RegistryPrx::_iceI_createSessionFromSecureConnection, context);
    }

    /**
     * Create a client session from a secure connection.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    createSessionFromSecureConnectionAsync(::std::function<void(::std::shared_ptr<::IceGrid::SessionPrx>)> response,
                                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                           ::std::function<void(bool)> sent = nullptr,
                                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::SessionPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::RegistryPrx::_iceI_createSessionFromSecureConnection, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_createSessionFromSecureConnection(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::SessionPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Create an administrative session from a secure connection.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    ::std::shared_ptr<AdminSessionPrx> createAdminSessionFromSecureConnection(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::AdminSessionPrx>>(true, this, &RegistryPrx::_iceI_createAdminSessionFromSecureConnection, context).get();
    }

    /**
     * Create an administrative session from a secure connection.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto createAdminSessionFromSecureConnectionAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::AdminSessionPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::AdminSessionPrx>, P>(false, this, &RegistryPrx::_iceI_createAdminSessionFromSecureConnection, context);
    }

    /**
     * Create an administrative session from a secure connection.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    createAdminSessionFromSecureConnectionAsync(::std::function<void(::std::shared_ptr<::IceGrid::AdminSessionPrx>)> response,
                                                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                                ::std::function<void(bool)> sent = nullptr,
                                                const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::AdminSessionPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::RegistryPrx::_iceI_createAdminSessionFromSecureConnection, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_createAdminSessionFromSecureConnection(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::AdminSessionPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * @param context The Context map to send with the invocation.
     * @return The timeout (in seconds).
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     */
    int getSessionTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &RegistryPrx::_iceI_getSessionTimeout, context).get();
    }

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     */
    template<template<typename> class P = ::std::promise>
    auto getSessionTimeoutAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &RegistryPrx::_iceI_getSessionTimeout, context);
    }

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     */
    ::std::function<void()>
    getSessionTimeoutAsync(::std::function<void(int)> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::RegistryPrx::_iceI_getSessionTimeout, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getSessionTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param context The Context map to send with the invocation.
     * @return The timeout (in seconds).
     */
    int getACMTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &RegistryPrx::_iceI_getACMTimeout, context).get();
    }

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getACMTimeoutAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &RegistryPrx::_iceI_getACMTimeout, context);
    }

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getACMTimeoutAsync(::std::function<void(int)> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::RegistryPrx::_iceI_getACMTimeout, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getACMTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    RegistryPrx() = default;
    friend ::std::shared_ptr<RegistryPrx> IceInternal::createProxy<RegistryPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * The IceGrid locator interface provides access to the {@link Query}
 * and {@link Registry} object of the IceGrid registry.
 * @see Query
 * @see Registry
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) LocatorPrx : public virtual ::Ice::Proxy<LocatorPrx, ::Ice::LocatorPrx>
{
public:

    /**
     * Get the proxy of the registry object hosted by this IceGrid
     * registry.
     * @param context The Context map to send with the invocation.
     * @return The proxy of the registry object.
     */
    ::std::shared_ptr<RegistryPrx> getLocalRegistry(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::RegistryPrx>>(true, this, &LocatorPrx::_iceI_getLocalRegistry, context).get();
    }

    /**
     * Get the proxy of the registry object hosted by this IceGrid
     * registry.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getLocalRegistryAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::RegistryPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::RegistryPrx>, P>(false, this, &LocatorPrx::_iceI_getLocalRegistry, context);
    }

    /**
     * Get the proxy of the registry object hosted by this IceGrid
     * registry.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getLocalRegistryAsync(::std::function<void(::std::shared_ptr<::IceGrid::RegistryPrx>)> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::RegistryPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::LocatorPrx::_iceI_getLocalRegistry, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getLocalRegistry(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::RegistryPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the proxy of the query object hosted by this IceGrid
     * registry.
     * @param context The Context map to send with the invocation.
     * @return The proxy of the query object.
     */
    ::std::shared_ptr<QueryPrx> getLocalQuery(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::QueryPrx>>(true, this, &LocatorPrx::_iceI_getLocalQuery, context).get();
    }

    /**
     * Get the proxy of the query object hosted by this IceGrid
     * registry.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getLocalQueryAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::QueryPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::QueryPrx>, P>(false, this, &LocatorPrx::_iceI_getLocalQuery, context);
    }

    /**
     * Get the proxy of the query object hosted by this IceGrid
     * registry.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getLocalQueryAsync(::std::function<void(::std::shared_ptr<::IceGrid::QueryPrx>)> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::QueryPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::LocatorPrx::_iceI_getLocalQuery, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getLocalQuery(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::QueryPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    LocatorPrx() = default;
    friend ::std::shared_ptr<LocatorPrx> IceInternal::createProxy<LocatorPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::IceGrid::LoadSample>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 2;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

}
/// \endcond

/// \cond INTERNAL
namespace IceGrid
{

using QueryPtr = ::std::shared_ptr<Query>;
using QueryPrxPtr = ::std::shared_ptr<QueryPrx>;

using RegistryPtr = ::std::shared_ptr<Registry>;
using RegistryPrxPtr = ::std::shared_ptr<RegistryPrx>;

using LocatorPtr = ::std::shared_ptr<Locator>;
using LocatorPrxPtr = ::std::shared_ptr<LocatorPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace IceGrid
{

class Query;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Query>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(Query*);
/// \endcond

class Registry;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Registry>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(Registry*);
/// \endcond

class Locator;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Locator>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(Locator*);
/// \endcond

}

}

namespace IceGrid
{

class Query;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(Query*);
/// \endcond
typedef ::IceInternal::Handle< Query> QueryPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::Query> QueryPrx;
typedef QueryPrx QueryPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(QueryPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class Registry;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(Registry*);
/// \endcond
typedef ::IceInternal::Handle< Registry> RegistryPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::Registry> RegistryPrx;
typedef RegistryPrx RegistryPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(RegistryPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class Locator;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(Locator*);
/// \endcond
typedef ::IceInternal::Handle< Locator> LocatorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::Locator> LocatorPrx;
typedef LocatorPrx LocatorPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(LocatorPtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

namespace IceGrid
{

/**
 * Determines which load sampling interval to use.
 */
enum LoadSample
{
    /**
     * Sample every minute.
     */
    LoadSample1,
    /**
     * Sample every five minutes.
     */
    LoadSample5,
    /**
     * Sample every fifteen minutes.
     */
    LoadSample15
};

}

/// \cond INTERNAL
namespace IceAsync
{

}
/// \endcond

namespace IceGrid
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Query::begin_findObjectById.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Query_findObjectById.
 */
class Callback_Query_findObjectById_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Query_findObjectById_Base> Callback_Query_findObjectByIdPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Query::begin_findObjectByType.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Query_findObjectByType.
 */
class Callback_Query_findObjectByType_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Query_findObjectByType_Base> Callback_Query_findObjectByTypePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Query::begin_findObjectByTypeOnLeastLoadedNode.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Query_findObjectByTypeOnLeastLoadedNode.
 */
class Callback_Query_findObjectByTypeOnLeastLoadedNode_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Query_findObjectByTypeOnLeastLoadedNode_Base> Callback_Query_findObjectByTypeOnLeastLoadedNodePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Query::begin_findAllObjectsByType.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Query_findAllObjectsByType.
 */
class Callback_Query_findAllObjectsByType_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Query_findAllObjectsByType_Base> Callback_Query_findAllObjectsByTypePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Query::begin_findAllReplicas.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Query_findAllReplicas.
 */
class Callback_Query_findAllReplicas_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Query_findAllReplicas_Base> Callback_Query_findAllReplicasPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Registry::begin_createSession.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Registry_createSession.
 */
class Callback_Registry_createSession_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Registry_createSession_Base> Callback_Registry_createSessionPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Registry::begin_createAdminSession.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Registry_createAdminSession.
 */
class Callback_Registry_createAdminSession_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Registry_createAdminSession_Base> Callback_Registry_createAdminSessionPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Registry::begin_createSessionFromSecureConnection.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Registry_createSessionFromSecureConnection.
 */
class Callback_Registry_createSessionFromSecureConnection_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Registry_createSessionFromSecureConnection_Base> Callback_Registry_createSessionFromSecureConnectionPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Registry::begin_createAdminSessionFromSecureConnection.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Registry_createAdminSessionFromSecureConnection.
 */
class Callback_Registry_createAdminSessionFromSecureConnection_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Registry_createAdminSessionFromSecureConnection_Base> Callback_Registry_createAdminSessionFromSecureConnectionPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Registry::begin_getSessionTimeout.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Registry_getSessionTimeout.
 */
class Callback_Registry_getSessionTimeout_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Registry_getSessionTimeout_Base> Callback_Registry_getSessionTimeoutPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Registry::begin_getACMTimeout.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Registry_getACMTimeout.
 */
class Callback_Registry_getACMTimeout_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Registry_getACMTimeout_Base> Callback_Registry_getACMTimeoutPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Locator::begin_getLocalRegistry.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Locator_getLocalRegistry.
 */
class Callback_Locator_getLocalRegistry_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Locator_getLocalRegistry_Base> Callback_Locator_getLocalRegistryPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Locator::begin_getLocalQuery.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Locator_getLocalQuery.
 */
class Callback_Locator_getLocalQuery_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Locator_getLocalQuery_Base> Callback_Locator_getLocalQueryPtr;

}

namespace IceProxy
{

namespace IceGrid
{

class ICE_CLASS(ICEGRID_API) Query : public virtual ::Ice::Proxy<Query, ::IceProxy::Ice::Object>
{
public:

    /**
     * Find a well-known object by identity.
     * @param id The identity.
     * @param context The Context map to send with the invocation.
     * @return The proxy or null if no such object has been found.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx findObjectById(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_findObjectById(_iceI_begin_findObjectById(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Find a well-known object by identity.
     * @param id The identity.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_findObjectById(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Find a well-known object by identity.
     * @param id The identity.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Find a well-known object by identity.
     * @param id The identity.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(id, context, cb, cookie);
    }

    /**
     * Find a well-known object by identity.
     * @param id The identity.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& id, const ::IceGrid::Callback_Query_findObjectByIdPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Find a well-known object by identity.
     * @param id The identity.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& id, const ::Ice::Context& context, const ::IceGrid::Callback_Query_findObjectByIdPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_findObjectById.
     * @param result The asynchronous result object for the invocation.
     * @return The proxy or null if no such object has been found.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx end_findObjectById(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_findObjectById(const ::Ice::Identity&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @return The proxy or null, if no such object has been found.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx findObjectByType(const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_findObjectByType(_iceI_begin_findObjectByType(type, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectByType(const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_findObjectByType(type, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     * @param type The object type.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectByType(const ::std::string& type, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectByType(type, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectByType(const ::std::string& type, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectByType(type, context, cb, cookie);
    }

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     * @param type The object type.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectByType(const ::std::string& type, const ::IceGrid::Callback_Query_findObjectByTypePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectByType(type, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectByType(const ::std::string& type, const ::Ice::Context& context, const ::IceGrid::Callback_Query_findObjectByTypePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectByType(type, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_findObjectByType.
     * @param result The asynchronous result object for the invocation.
     * @return The proxy or null, if no such object has been found.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx end_findObjectByType(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_findObjectByType(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     * @param type The object type.
     * @param sample The sampling interval.
     * @param context The Context map to send with the invocation.
     * @return The proxy or null, if no such object has been found.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx findObjectByTypeOnLeastLoadedNode(const ::std::string& type, ::IceGrid::LoadSample sample, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_findObjectByTypeOnLeastLoadedNode(_iceI_begin_findObjectByTypeOnLeastLoadedNode(type, sample, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     * @param type The object type.
     * @param sample The sampling interval.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectByTypeOnLeastLoadedNode(const ::std::string& type, ::IceGrid::LoadSample sample, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_findObjectByTypeOnLeastLoadedNode(type, sample, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     * @param type The object type.
     * @param sample The sampling interval.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectByTypeOnLeastLoadedNode(const ::std::string& type, ::IceGrid::LoadSample sample, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectByTypeOnLeastLoadedNode(type, sample, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     * @param type The object type.
     * @param sample The sampling interval.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectByTypeOnLeastLoadedNode(const ::std::string& type, ::IceGrid::LoadSample sample, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectByTypeOnLeastLoadedNode(type, sample, context, cb, cookie);
    }

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     * @param type The object type.
     * @param sample The sampling interval.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectByTypeOnLeastLoadedNode(const ::std::string& type, ::IceGrid::LoadSample sample, const ::IceGrid::Callback_Query_findObjectByTypeOnLeastLoadedNodePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectByTypeOnLeastLoadedNode(type, sample, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     * @param type The object type.
     * @param sample The sampling interval.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectByTypeOnLeastLoadedNode(const ::std::string& type, ::IceGrid::LoadSample sample, const ::Ice::Context& context, const ::IceGrid::Callback_Query_findObjectByTypeOnLeastLoadedNodePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectByTypeOnLeastLoadedNode(type, sample, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_findObjectByTypeOnLeastLoadedNode.
     * @param result The asynchronous result object for the invocation.
     * @return The proxy or null, if no such object has been found.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx end_findObjectByTypeOnLeastLoadedNode(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_findObjectByTypeOnLeastLoadedNode(const ::std::string&, ::IceGrid::LoadSample, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Find all the well-known objects with the given type.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @return The proxies or an empty sequence, if no such objects
     * have been found.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectProxySeq findAllObjectsByType(const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_findAllObjectsByType(_iceI_begin_findAllObjectsByType(type, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Find all the well-known objects with the given type.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAllObjectsByType(const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_findAllObjectsByType(type, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Find all the well-known objects with the given type.
     * @param type The object type.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAllObjectsByType(const ::std::string& type, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAllObjectsByType(type, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Find all the well-known objects with the given type.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAllObjectsByType(const ::std::string& type, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAllObjectsByType(type, context, cb, cookie);
    }

    /**
     * Find all the well-known objects with the given type.
     * @param type The object type.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAllObjectsByType(const ::std::string& type, const ::IceGrid::Callback_Query_findAllObjectsByTypePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAllObjectsByType(type, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Find all the well-known objects with the given type.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAllObjectsByType(const ::std::string& type, const ::Ice::Context& context, const ::IceGrid::Callback_Query_findAllObjectsByTypePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAllObjectsByType(type, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_findAllObjectsByType.
     * @param result The asynchronous result object for the invocation.
     * @return The proxies or an empty sequence, if no such objects
     * have been found.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectProxySeq end_findAllObjectsByType(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_findAllObjectsByType(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     * @param proxy The object proxy.
     * @param context The Context map to send with the invocation.
     * @return The proxies of each object replica or an empty sequence,
     * if the given proxy is not from a replica group.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectProxySeq findAllReplicas(const ::Ice::ObjectPrx& proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_findAllReplicas(_iceI_begin_findAllReplicas(proxy, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     * @param proxy The object proxy.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAllReplicas(const ::Ice::ObjectPrx& proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_findAllReplicas(proxy, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     * @param proxy The object proxy.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAllReplicas(const ::Ice::ObjectPrx& proxy, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAllReplicas(proxy, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     * @param proxy The object proxy.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAllReplicas(const ::Ice::ObjectPrx& proxy, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAllReplicas(proxy, context, cb, cookie);
    }

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     * @param proxy The object proxy.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAllReplicas(const ::Ice::ObjectPrx& proxy, const ::IceGrid::Callback_Query_findAllReplicasPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAllReplicas(proxy, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     * @param proxy The object proxy.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAllReplicas(const ::Ice::ObjectPrx& proxy, const ::Ice::Context& context, const ::IceGrid::Callback_Query_findAllReplicasPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAllReplicas(proxy, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_findAllReplicas.
     * @param result The asynchronous result object for the invocation.
     * @return The proxies of each object replica or an empty sequence,
     * if the given proxy is not from a replica group.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectProxySeq end_findAllReplicas(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_findAllReplicas(const ::Ice::ObjectPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) Registry : public virtual ::Ice::Proxy<Registry, ::IceProxy::Ice::Object>
{
public:

    /**
     * Create a client session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::SessionPrx createSession(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_createSession(_iceI_begin_createSession(userId, password, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Create a client session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_createSession(userId, password, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Create a client session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& userId, const ::std::string& password, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSession(userId, password, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a client session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSession(userId, password, context, cb, cookie);
    }

    /**
     * Create a client session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& userId, const ::std::string& password, const ::IceGrid::Callback_Registry_createSessionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSession(userId, password, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a client session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context, const ::IceGrid::Callback_Registry_createSessionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSession(userId, password, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_createSession.
     * @param result The asynchronous result object for the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::SessionPrx end_createSession(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_createSession(const ::std::string&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Create an administrative session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::AdminSessionPrx createAdminSession(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_createAdminSession(_iceI_begin_createAdminSession(userId, password, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Create an administrative session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createAdminSession(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_createAdminSession(userId, password, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Create an administrative session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createAdminSession(const ::std::string& userId, const ::std::string& password, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createAdminSession(userId, password, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create an administrative session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createAdminSession(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createAdminSession(userId, password, context, cb, cookie);
    }

    /**
     * Create an administrative session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createAdminSession(const ::std::string& userId, const ::std::string& password, const ::IceGrid::Callback_Registry_createAdminSessionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createAdminSession(userId, password, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create an administrative session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createAdminSession(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context, const ::IceGrid::Callback_Registry_createAdminSessionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createAdminSession(userId, password, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_createAdminSession.
     * @param result The asynchronous result object for the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::AdminSessionPrx end_createAdminSession(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_createAdminSession(const ::std::string&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Create a client session from a secure connection.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::SessionPrx createSessionFromSecureConnection(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_createSessionFromSecureConnection(_iceI_begin_createSessionFromSecureConnection(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Create a client session from a secure connection.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_createSessionFromSecureConnection(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Create a client session from a secure connection.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSessionFromSecureConnection(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a client session from a secure connection.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSessionFromSecureConnection(context, cb, cookie);
    }

    /**
     * Create a client session from a secure connection.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::IceGrid::Callback_Registry_createSessionFromSecureConnectionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSessionFromSecureConnection(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a client session from a secure connection.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::Ice::Context& context, const ::IceGrid::Callback_Registry_createSessionFromSecureConnectionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSessionFromSecureConnection(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_createSessionFromSecureConnection.
     * @param result The asynchronous result object for the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::SessionPrx end_createSessionFromSecureConnection(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_createSessionFromSecureConnection(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Create an administrative session from a secure connection.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::AdminSessionPrx createAdminSessionFromSecureConnection(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_createAdminSessionFromSecureConnection(_iceI_begin_createAdminSessionFromSecureConnection(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Create an administrative session from a secure connection.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createAdminSessionFromSecureConnection(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_createAdminSessionFromSecureConnection(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Create an administrative session from a secure connection.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createAdminSessionFromSecureConnection(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createAdminSessionFromSecureConnection(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create an administrative session from a secure connection.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createAdminSessionFromSecureConnection(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createAdminSessionFromSecureConnection(context, cb, cookie);
    }

    /**
     * Create an administrative session from a secure connection.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createAdminSessionFromSecureConnection(const ::IceGrid::Callback_Registry_createAdminSessionFromSecureConnectionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createAdminSessionFromSecureConnection(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create an administrative session from a secure connection.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_createAdminSessionFromSecureConnection(const ::Ice::Context& context, const ::IceGrid::Callback_Registry_createAdminSessionFromSecureConnectionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createAdminSessionFromSecureConnection(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_createAdminSessionFromSecureConnection.
     * @param result The asynchronous result object for the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::AdminSessionPrx end_createAdminSessionFromSecureConnection(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_createAdminSessionFromSecureConnection(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * @param context The Context map to send with the invocation.
     * @return The timeout (in seconds).
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::Int getSessionTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getSessionTimeout(_iceI_begin_getSessionTimeout(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     */
    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getSessionTimeout(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     */
    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     */
    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(context, cb, cookie);
    }

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     */
    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::IceGrid::Callback_Registry_getSessionTimeoutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     */
    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::Context& context, const ::IceGrid::Callback_Registry_getSessionTimeoutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getSessionTimeout.
     * @param result The asynchronous result object for the invocation.
     * @return The timeout (in seconds).
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::Int end_getSessionTimeout(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getSessionTimeout(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param context The Context map to send with the invocation.
     * @return The timeout (in seconds).
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::Int getACMTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getACMTimeout(_iceI_begin_getACMTimeout(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getACMTimeout(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACMTimeout(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACMTimeout(context, cb, cookie);
    }

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::IceGrid::Callback_Registry_getACMTimeoutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACMTimeout(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::Ice::Context& context, const ::IceGrid::Callback_Registry_getACMTimeoutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACMTimeout(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getACMTimeout.
     * @param result The asynchronous result object for the invocation.
     * @return The timeout (in seconds).
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::Int end_getACMTimeout(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getACMTimeout(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) Locator : public virtual ::Ice::Proxy<Locator, ::IceProxy::Ice::Locator>
{
public:

    /**
     * Get the proxy of the registry object hosted by this IceGrid
     * registry.
     * @param context The Context map to send with the invocation.
     * @return The proxy of the registry object.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::RegistryPrx getLocalRegistry(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getLocalRegistry(_iceI_begin_getLocalRegistry(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the proxy of the registry object hosted by this IceGrid
     * registry.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLocalRegistry(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getLocalRegistry(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the proxy of the registry object hosted by this IceGrid
     * registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLocalRegistry(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocalRegistry(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the proxy of the registry object hosted by this IceGrid
     * registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLocalRegistry(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocalRegistry(context, cb, cookie);
    }

    /**
     * Get the proxy of the registry object hosted by this IceGrid
     * registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLocalRegistry(const ::IceGrid::Callback_Locator_getLocalRegistryPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocalRegistry(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the proxy of the registry object hosted by this IceGrid
     * registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLocalRegistry(const ::Ice::Context& context, const ::IceGrid::Callback_Locator_getLocalRegistryPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocalRegistry(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getLocalRegistry.
     * @param result The asynchronous result object for the invocation.
     * @return The proxy of the registry object.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::RegistryPrx end_getLocalRegistry(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getLocalRegistry(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the proxy of the query object hosted by this IceGrid
     * registry.
     * @param context The Context map to send with the invocation.
     * @return The proxy of the query object.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::QueryPrx getLocalQuery(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getLocalQuery(_iceI_begin_getLocalQuery(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the proxy of the query object hosted by this IceGrid
     * registry.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLocalQuery(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getLocalQuery(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the proxy of the query object hosted by this IceGrid
     * registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLocalQuery(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocalQuery(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the proxy of the query object hosted by this IceGrid
     * registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLocalQuery(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocalQuery(context, cb, cookie);
    }

    /**
     * Get the proxy of the query object hosted by this IceGrid
     * registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLocalQuery(const ::IceGrid::Callback_Locator_getLocalQueryPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocalQuery(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the proxy of the query object hosted by this IceGrid
     * registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLocalQuery(const ::Ice::Context& context, const ::IceGrid::Callback_Locator_getLocalQueryPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocalQuery(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getLocalQuery.
     * @param result The asynchronous result object for the invocation.
     * @return The proxy of the query object.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::QueryPrx end_getLocalQuery(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getLocalQuery(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace IceGrid
{

/**
 * The IceGrid query interface. This interface is accessible to
 * Ice clients who wish to look up well-known objects.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API Query : public virtual ::Ice::Object
{
public:

    typedef QueryPrx ProxyType;
    typedef QueryPtr PointerType;

    virtual ~Query();

#ifdef ICE_CPP11_COMPILER
    Query() = default;
    Query(const Query&) = default;
    Query& operator=(const Query&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Find a well-known object by identity.
     * @param id The identity.
     * @param current The Current object for the invocation.
     * @return The proxy or null if no such object has been found.
     */
    virtual ::Ice::ObjectPrx findObjectById(const ::Ice::Identity& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_findObjectById(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     * @param type The object type.
     * @param current The Current object for the invocation.
     * @return The proxy or null, if no such object has been found.
     */
    virtual ::Ice::ObjectPrx findObjectByType(const ::std::string& type, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_findObjectByType(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     * @param type The object type.
     * @param sample The sampling interval.
     * @param current The Current object for the invocation.
     * @return The proxy or null, if no such object has been found.
     */
    virtual ::Ice::ObjectPrx findObjectByTypeOnLeastLoadedNode(const ::std::string& type, LoadSample sample, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_findObjectByTypeOnLeastLoadedNode(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Find all the well-known objects with the given type.
     * @param type The object type.
     * @param current The Current object for the invocation.
     * @return The proxies or an empty sequence, if no such objects
     * have been found.
     */
    virtual ::Ice::ObjectProxySeq findAllObjectsByType(const ::std::string& type, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_findAllObjectsByType(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     * @param proxy The object proxy.
     * @param current The Current object for the invocation.
     * @return The proxies of each object replica or an empty sequence,
     * if the given proxy is not from a replica group.
     */
    virtual ::Ice::ObjectProxySeq findAllReplicas(const ::Ice::ObjectPrx& proxy, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_findAllReplicas(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Query& lhs, const Query& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Query& lhs, const Query& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * The IceGrid registry allows clients create sessions
 * directly with the registry.
 * @see Session
 * @see AdminSession
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API Registry : public virtual ::Ice::Object
{
public:

    typedef RegistryPrx ProxyType;
    typedef RegistryPtr PointerType;

    virtual ~Registry();

#ifdef ICE_CPP11_COMPILER
    Registry() = default;
    Registry(const Registry&) = default;
    Registry& operator=(const Registry&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Create a client session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param current The Current object for the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    virtual SessionPrx createSession(const ::std::string& userId, const ::std::string& password, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_createSession(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Create an administrative session.
     * @param userId The user id.
     * @param password The password for the given user id.
     * @param current The Current object for the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    virtual AdminSessionPrx createAdminSession(const ::std::string& userId, const ::std::string& password, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_createAdminSession(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Create a client session from a secure connection.
     * @param current The Current object for the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    virtual SessionPrx createSessionFromSecureConnection(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_createSessionFromSecureConnection(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Create an administrative session from a secure connection.
     * @param current The Current object for the invocation.
     * @return A proxy for the newly created session.
     * @throws IceGrid::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    virtual AdminSessionPrx createAdminSessionFromSecureConnection(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_createAdminSessionFromSecureConnection(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * @param current The Current object for the invocation.
     * @return The timeout (in seconds).
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     */
    virtual ::Ice::Int getSessionTimeout(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getSessionTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param current The Current object for the invocation.
     * @return The timeout (in seconds).
     */
    virtual ::Ice::Int getACMTimeout(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getACMTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Registry& lhs, const Registry& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Registry& lhs, const Registry& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * The IceGrid locator interface provides access to the {@link Query}
 * and {@link Registry} object of the IceGrid registry.
 * @see Query
 * @see Registry
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API Locator : virtual public ::Ice::Locator
{
public:

    typedef LocatorPrx ProxyType;
    typedef LocatorPtr PointerType;

    virtual ~Locator();

#ifdef ICE_CPP11_COMPILER
    Locator() = default;
    Locator(const Locator&) = default;
    Locator& operator=(const Locator&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Get the proxy of the registry object hosted by this IceGrid
     * registry.
     * @param current The Current object for the invocation.
     * @return The proxy of the registry object.
     */
    virtual RegistryPrx getLocalRegistry(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getLocalRegistry(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the proxy of the query object hosted by this IceGrid
     * registry.
     * @param current The Current object for the invocation.
     * @return The proxy of the query object.
     */
    virtual QueryPrx getLocalQuery(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getLocalQuery(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Locator& lhs, const Locator& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Locator& lhs, const Locator& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::IceGrid::LoadSample>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 2;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

}
/// \endcond

namespace IceGrid
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Query::begin_findObjectById.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Query_findObjectById.
 */
template<class T>
class CallbackNC_Query_findObjectById : public Callback_Query_findObjectById_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Query_findObjectById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        QueryPrx proxy = QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_findObjectById(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findObjectById.
 */
template<class T> Callback_Query_findObjectByIdPtr
newCallback_Query_findObjectById(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findObjectById<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findObjectById.
 */
template<class T> Callback_Query_findObjectByIdPtr
newCallback_Query_findObjectById(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findObjectById<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Query::begin_findObjectById.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Query_findObjectById.
 */
template<class T, typename CT>
class Callback_Query_findObjectById : public Callback_Query_findObjectById_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Query_findObjectById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        QueryPrx proxy = QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_findObjectById(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findObjectById.
 */
template<class T, typename CT> Callback_Query_findObjectByIdPtr
newCallback_Query_findObjectById(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findObjectById<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findObjectById.
 */
template<class T, typename CT> Callback_Query_findObjectByIdPtr
newCallback_Query_findObjectById(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findObjectById<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Query::begin_findObjectByType.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Query_findObjectByType.
 */
template<class T>
class CallbackNC_Query_findObjectByType : public Callback_Query_findObjectByType_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Query_findObjectByType(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        QueryPrx proxy = QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_findObjectByType(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findObjectByType.
 */
template<class T> Callback_Query_findObjectByTypePtr
newCallback_Query_findObjectByType(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findObjectByType<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findObjectByType.
 */
template<class T> Callback_Query_findObjectByTypePtr
newCallback_Query_findObjectByType(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findObjectByType<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Query::begin_findObjectByType.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Query_findObjectByType.
 */
template<class T, typename CT>
class Callback_Query_findObjectByType : public Callback_Query_findObjectByType_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Query_findObjectByType(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        QueryPrx proxy = QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_findObjectByType(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findObjectByType.
 */
template<class T, typename CT> Callback_Query_findObjectByTypePtr
newCallback_Query_findObjectByType(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findObjectByType<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findObjectByType.
 */
template<class T, typename CT> Callback_Query_findObjectByTypePtr
newCallback_Query_findObjectByType(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findObjectByType<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Query::begin_findObjectByTypeOnLeastLoadedNode.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Query_findObjectByTypeOnLeastLoadedNode.
 */
template<class T>
class CallbackNC_Query_findObjectByTypeOnLeastLoadedNode : public Callback_Query_findObjectByTypeOnLeastLoadedNode_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Query_findObjectByTypeOnLeastLoadedNode(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        QueryPrx proxy = QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_findObjectByTypeOnLeastLoadedNode(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findObjectByTypeOnLeastLoadedNode.
 */
template<class T> Callback_Query_findObjectByTypeOnLeastLoadedNodePtr
newCallback_Query_findObjectByTypeOnLeastLoadedNode(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findObjectByTypeOnLeastLoadedNode<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findObjectByTypeOnLeastLoadedNode.
 */
template<class T> Callback_Query_findObjectByTypeOnLeastLoadedNodePtr
newCallback_Query_findObjectByTypeOnLeastLoadedNode(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findObjectByTypeOnLeastLoadedNode<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Query::begin_findObjectByTypeOnLeastLoadedNode.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Query_findObjectByTypeOnLeastLoadedNode.
 */
template<class T, typename CT>
class Callback_Query_findObjectByTypeOnLeastLoadedNode : public Callback_Query_findObjectByTypeOnLeastLoadedNode_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Query_findObjectByTypeOnLeastLoadedNode(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        QueryPrx proxy = QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_findObjectByTypeOnLeastLoadedNode(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findObjectByTypeOnLeastLoadedNode.
 */
template<class T, typename CT> Callback_Query_findObjectByTypeOnLeastLoadedNodePtr
newCallback_Query_findObjectByTypeOnLeastLoadedNode(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findObjectByTypeOnLeastLoadedNode<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findObjectByTypeOnLeastLoadedNode.
 */
template<class T, typename CT> Callback_Query_findObjectByTypeOnLeastLoadedNodePtr
newCallback_Query_findObjectByTypeOnLeastLoadedNode(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findObjectByTypeOnLeastLoadedNode<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Query::begin_findAllObjectsByType.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Query_findAllObjectsByType.
 */
template<class T>
class CallbackNC_Query_findAllObjectsByType : public Callback_Query_findAllObjectsByType_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectProxySeq&);

    CallbackNC_Query_findAllObjectsByType(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        QueryPrx proxy = QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectProxySeq ret;
        try
        {
            ret = proxy->end_findAllObjectsByType(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findAllObjectsByType.
 */
template<class T> Callback_Query_findAllObjectsByTypePtr
newCallback_Query_findAllObjectsByType(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectProxySeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findAllObjectsByType<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findAllObjectsByType.
 */
template<class T> Callback_Query_findAllObjectsByTypePtr
newCallback_Query_findAllObjectsByType(T* instance, void (T::*cb)(const ::Ice::ObjectProxySeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findAllObjectsByType<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Query::begin_findAllObjectsByType.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Query_findAllObjectsByType.
 */
template<class T, typename CT>
class Callback_Query_findAllObjectsByType : public Callback_Query_findAllObjectsByType_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectProxySeq&, const CT&);

    Callback_Query_findAllObjectsByType(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        QueryPrx proxy = QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectProxySeq ret;
        try
        {
            ret = proxy->end_findAllObjectsByType(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findAllObjectsByType.
 */
template<class T, typename CT> Callback_Query_findAllObjectsByTypePtr
newCallback_Query_findAllObjectsByType(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectProxySeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findAllObjectsByType<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findAllObjectsByType.
 */
template<class T, typename CT> Callback_Query_findAllObjectsByTypePtr
newCallback_Query_findAllObjectsByType(T* instance, void (T::*cb)(const ::Ice::ObjectProxySeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findAllObjectsByType<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Query::begin_findAllReplicas.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Query_findAllReplicas.
 */
template<class T>
class CallbackNC_Query_findAllReplicas : public Callback_Query_findAllReplicas_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectProxySeq&);

    CallbackNC_Query_findAllReplicas(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        QueryPrx proxy = QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectProxySeq ret;
        try
        {
            ret = proxy->end_findAllReplicas(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findAllReplicas.
 */
template<class T> Callback_Query_findAllReplicasPtr
newCallback_Query_findAllReplicas(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectProxySeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findAllReplicas<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findAllReplicas.
 */
template<class T> Callback_Query_findAllReplicasPtr
newCallback_Query_findAllReplicas(T* instance, void (T::*cb)(const ::Ice::ObjectProxySeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findAllReplicas<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Query::begin_findAllReplicas.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Query_findAllReplicas.
 */
template<class T, typename CT>
class Callback_Query_findAllReplicas : public Callback_Query_findAllReplicas_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectProxySeq&, const CT&);

    Callback_Query_findAllReplicas(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        QueryPrx proxy = QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectProxySeq ret;
        try
        {
            ret = proxy->end_findAllReplicas(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findAllReplicas.
 */
template<class T, typename CT> Callback_Query_findAllReplicasPtr
newCallback_Query_findAllReplicas(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectProxySeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findAllReplicas<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Query::begin_findAllReplicas.
 */
template<class T, typename CT> Callback_Query_findAllReplicasPtr
newCallback_Query_findAllReplicas(T* instance, void (T::*cb)(const ::Ice::ObjectProxySeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findAllReplicas<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Registry::begin_createSession.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Registry_createSession.
 */
template<class T>
class CallbackNC_Registry_createSession : public Callback_Registry_createSession_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const SessionPrx&);

    CallbackNC_Registry_createSession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RegistryPrx proxy = RegistryPrx::uncheckedCast(result->getProxy());
        SessionPrx ret;
        try
        {
            ret = proxy->end_createSession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_createSession.
 */
template<class T> Callback_Registry_createSessionPtr
newCallback_Registry_createSession(const IceUtil::Handle<T>& instance, void (T::*cb)(const SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_createSession<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_createSession.
 */
template<class T> Callback_Registry_createSessionPtr
newCallback_Registry_createSession(T* instance, void (T::*cb)(const SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_createSession<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Registry::begin_createSession.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Registry_createSession.
 */
template<class T, typename CT>
class Callback_Registry_createSession : public Callback_Registry_createSession_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const SessionPrx&, const CT&);

    Callback_Registry_createSession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RegistryPrx proxy = RegistryPrx::uncheckedCast(result->getProxy());
        SessionPrx ret;
        try
        {
            ret = proxy->end_createSession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_createSession.
 */
template<class T, typename CT> Callback_Registry_createSessionPtr
newCallback_Registry_createSession(const IceUtil::Handle<T>& instance, void (T::*cb)(const SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_createSession<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_createSession.
 */
template<class T, typename CT> Callback_Registry_createSessionPtr
newCallback_Registry_createSession(T* instance, void (T::*cb)(const SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_createSession<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Registry::begin_createAdminSession.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Registry_createAdminSession.
 */
template<class T>
class CallbackNC_Registry_createAdminSession : public Callback_Registry_createAdminSession_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const AdminSessionPrx&);

    CallbackNC_Registry_createAdminSession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RegistryPrx proxy = RegistryPrx::uncheckedCast(result->getProxy());
        AdminSessionPrx ret;
        try
        {
            ret = proxy->end_createAdminSession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_createAdminSession.
 */
template<class T> Callback_Registry_createAdminSessionPtr
newCallback_Registry_createAdminSession(const IceUtil::Handle<T>& instance, void (T::*cb)(const AdminSessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_createAdminSession<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_createAdminSession.
 */
template<class T> Callback_Registry_createAdminSessionPtr
newCallback_Registry_createAdminSession(T* instance, void (T::*cb)(const AdminSessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_createAdminSession<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Registry::begin_createAdminSession.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Registry_createAdminSession.
 */
template<class T, typename CT>
class Callback_Registry_createAdminSession : public Callback_Registry_createAdminSession_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const AdminSessionPrx&, const CT&);

    Callback_Registry_createAdminSession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RegistryPrx proxy = RegistryPrx::uncheckedCast(result->getProxy());
        AdminSessionPrx ret;
        try
        {
            ret = proxy->end_createAdminSession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_createAdminSession.
 */
template<class T, typename CT> Callback_Registry_createAdminSessionPtr
newCallback_Registry_createAdminSession(const IceUtil::Handle<T>& instance, void (T::*cb)(const AdminSessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_createAdminSession<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_createAdminSession.
 */
template<class T, typename CT> Callback_Registry_createAdminSessionPtr
newCallback_Registry_createAdminSession(T* instance, void (T::*cb)(const AdminSessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_createAdminSession<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Registry::begin_createSessionFromSecureConnection.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Registry_createSessionFromSecureConnection.
 */
template<class T>
class CallbackNC_Registry_createSessionFromSecureConnection : public Callback_Registry_createSessionFromSecureConnection_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const SessionPrx&);

    CallbackNC_Registry_createSessionFromSecureConnection(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RegistryPrx proxy = RegistryPrx::uncheckedCast(result->getProxy());
        SessionPrx ret;
        try
        {
            ret = proxy->end_createSessionFromSecureConnection(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_createSessionFromSecureConnection.
 */
template<class T> Callback_Registry_createSessionFromSecureConnectionPtr
newCallback_Registry_createSessionFromSecureConnection(const IceUtil::Handle<T>& instance, void (T::*cb)(const SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_createSessionFromSecureConnection<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_createSessionFromSecureConnection.
 */
template<class T> Callback_Registry_createSessionFromSecureConnectionPtr
newCallback_Registry_createSessionFromSecureConnection(T* instance, void (T::*cb)(const SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_createSessionFromSecureConnection<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Registry::begin_createSessionFromSecureConnection.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Registry_createSessionFromSecureConnection.
 */
template<class T, typename CT>
class Callback_Registry_createSessionFromSecureConnection : public Callback_Registry_createSessionFromSecureConnection_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const SessionPrx&, const CT&);

    Callback_Registry_createSessionFromSecureConnection(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RegistryPrx proxy = RegistryPrx::uncheckedCast(result->getProxy());
        SessionPrx ret;
        try
        {
            ret = proxy->end_createSessionFromSecureConnection(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_createSessionFromSecureConnection.
 */
template<class T, typename CT> Callback_Registry_createSessionFromSecureConnectionPtr
newCallback_Registry_createSessionFromSecureConnection(const IceUtil::Handle<T>& instance, void (T::*cb)(const SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_createSessionFromSecureConnection<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_createSessionFromSecureConnection.
 */
template<class T, typename CT> Callback_Registry_createSessionFromSecureConnectionPtr
newCallback_Registry_createSessionFromSecureConnection(T* instance, void (T::*cb)(const SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_createSessionFromSecureConnection<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Registry::begin_createAdminSessionFromSecureConnection.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Registry_createAdminSessionFromSecureConnection.
 */
template<class T>
class CallbackNC_Registry_createAdminSessionFromSecureConnection : public Callback_Registry_createAdminSessionFromSecureConnection_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const AdminSessionPrx&);

    CallbackNC_Registry_createAdminSessionFromSecureConnection(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RegistryPrx proxy = RegistryPrx::uncheckedCast(result->getProxy());
        AdminSessionPrx ret;
        try
        {
            ret = proxy->end_createAdminSessionFromSecureConnection(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_createAdminSessionFromSecureConnection.
 */
template<class T> Callback_Registry_createAdminSessionFromSecureConnectionPtr
newCallback_Registry_createAdminSessionFromSecureConnection(const IceUtil::Handle<T>& instance, void (T::*cb)(const AdminSessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_createAdminSessionFromSecureConnection<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_createAdminSessionFromSecureConnection.
 */
template<class T> Callback_Registry_createAdminSessionFromSecureConnectionPtr
newCallback_Registry_createAdminSessionFromSecureConnection(T* instance, void (T::*cb)(const AdminSessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_createAdminSessionFromSecureConnection<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Registry::begin_createAdminSessionFromSecureConnection.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Registry_createAdminSessionFromSecureConnection.
 */
template<class T, typename CT>
class Callback_Registry_createAdminSessionFromSecureConnection : public Callback_Registry_createAdminSessionFromSecureConnection_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const AdminSessionPrx&, const CT&);

    Callback_Registry_createAdminSessionFromSecureConnection(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RegistryPrx proxy = RegistryPrx::uncheckedCast(result->getProxy());
        AdminSessionPrx ret;
        try
        {
            ret = proxy->end_createAdminSessionFromSecureConnection(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_createAdminSessionFromSecureConnection.
 */
template<class T, typename CT> Callback_Registry_createAdminSessionFromSecureConnectionPtr
newCallback_Registry_createAdminSessionFromSecureConnection(const IceUtil::Handle<T>& instance, void (T::*cb)(const AdminSessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_createAdminSessionFromSecureConnection<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_createAdminSessionFromSecureConnection.
 */
template<class T, typename CT> Callback_Registry_createAdminSessionFromSecureConnectionPtr
newCallback_Registry_createAdminSessionFromSecureConnection(T* instance, void (T::*cb)(const AdminSessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_createAdminSessionFromSecureConnection<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Registry::begin_getSessionTimeout.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Registry_getSessionTimeout.
 */
template<class T>
class CallbackNC_Registry_getSessionTimeout : public Callback_Registry_getSessionTimeout_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Int);

    CallbackNC_Registry_getSessionTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RegistryPrx proxy = RegistryPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getSessionTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_getSessionTimeout.
 */
template<class T> Callback_Registry_getSessionTimeoutPtr
newCallback_Registry_getSessionTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_getSessionTimeout<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_getSessionTimeout.
 */
template<class T> Callback_Registry_getSessionTimeoutPtr
newCallback_Registry_getSessionTimeout(T* instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_getSessionTimeout<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Registry::begin_getSessionTimeout.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Registry_getSessionTimeout.
 */
template<class T, typename CT>
class Callback_Registry_getSessionTimeout : public Callback_Registry_getSessionTimeout_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Int, const CT&);

    Callback_Registry_getSessionTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RegistryPrx proxy = RegistryPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getSessionTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_getSessionTimeout.
 */
template<class T, typename CT> Callback_Registry_getSessionTimeoutPtr
newCallback_Registry_getSessionTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_getSessionTimeout<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_getSessionTimeout.
 */
template<class T, typename CT> Callback_Registry_getSessionTimeoutPtr
newCallback_Registry_getSessionTimeout(T* instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_getSessionTimeout<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Registry::begin_getACMTimeout.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Registry_getACMTimeout.
 */
template<class T>
class CallbackNC_Registry_getACMTimeout : public Callback_Registry_getACMTimeout_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Int);

    CallbackNC_Registry_getACMTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RegistryPrx proxy = RegistryPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getACMTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_getACMTimeout.
 */
template<class T> Callback_Registry_getACMTimeoutPtr
newCallback_Registry_getACMTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_getACMTimeout<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_getACMTimeout.
 */
template<class T> Callback_Registry_getACMTimeoutPtr
newCallback_Registry_getACMTimeout(T* instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_getACMTimeout<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Registry::begin_getACMTimeout.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Registry_getACMTimeout.
 */
template<class T, typename CT>
class Callback_Registry_getACMTimeout : public Callback_Registry_getACMTimeout_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Int, const CT&);

    Callback_Registry_getACMTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RegistryPrx proxy = RegistryPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getACMTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_getACMTimeout.
 */
template<class T, typename CT> Callback_Registry_getACMTimeoutPtr
newCallback_Registry_getACMTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_getACMTimeout<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Registry::begin_getACMTimeout.
 */
template<class T, typename CT> Callback_Registry_getACMTimeoutPtr
newCallback_Registry_getACMTimeout(T* instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_getACMTimeout<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Locator::begin_getLocalRegistry.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Locator_getLocalRegistry.
 */
template<class T>
class CallbackNC_Locator_getLocalRegistry : public Callback_Locator_getLocalRegistry_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const RegistryPrx&);

    CallbackNC_Locator_getLocalRegistry(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        LocatorPrx proxy = LocatorPrx::uncheckedCast(result->getProxy());
        RegistryPrx ret;
        try
        {
            ret = proxy->end_getLocalRegistry(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Locator::begin_getLocalRegistry.
 */
template<class T> Callback_Locator_getLocalRegistryPtr
newCallback_Locator_getLocalRegistry(const IceUtil::Handle<T>& instance, void (T::*cb)(const RegistryPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_getLocalRegistry<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Locator::begin_getLocalRegistry.
 */
template<class T> Callback_Locator_getLocalRegistryPtr
newCallback_Locator_getLocalRegistry(T* instance, void (T::*cb)(const RegistryPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_getLocalRegistry<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Locator::begin_getLocalRegistry.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Locator_getLocalRegistry.
 */
template<class T, typename CT>
class Callback_Locator_getLocalRegistry : public Callback_Locator_getLocalRegistry_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const RegistryPrx&, const CT&);

    Callback_Locator_getLocalRegistry(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        LocatorPrx proxy = LocatorPrx::uncheckedCast(result->getProxy());
        RegistryPrx ret;
        try
        {
            ret = proxy->end_getLocalRegistry(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Locator::begin_getLocalRegistry.
 */
template<class T, typename CT> Callback_Locator_getLocalRegistryPtr
newCallback_Locator_getLocalRegistry(const IceUtil::Handle<T>& instance, void (T::*cb)(const RegistryPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_getLocalRegistry<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Locator::begin_getLocalRegistry.
 */
template<class T, typename CT> Callback_Locator_getLocalRegistryPtr
newCallback_Locator_getLocalRegistry(T* instance, void (T::*cb)(const RegistryPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_getLocalRegistry<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Locator::begin_getLocalQuery.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Locator_getLocalQuery.
 */
template<class T>
class CallbackNC_Locator_getLocalQuery : public Callback_Locator_getLocalQuery_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const QueryPrx&);

    CallbackNC_Locator_getLocalQuery(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        LocatorPrx proxy = LocatorPrx::uncheckedCast(result->getProxy());
        QueryPrx ret;
        try
        {
            ret = proxy->end_getLocalQuery(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Locator::begin_getLocalQuery.
 */
template<class T> Callback_Locator_getLocalQueryPtr
newCallback_Locator_getLocalQuery(const IceUtil::Handle<T>& instance, void (T::*cb)(const QueryPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_getLocalQuery<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Locator::begin_getLocalQuery.
 */
template<class T> Callback_Locator_getLocalQueryPtr
newCallback_Locator_getLocalQuery(T* instance, void (T::*cb)(const QueryPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_getLocalQuery<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Locator::begin_getLocalQuery.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Locator_getLocalQuery.
 */
template<class T, typename CT>
class Callback_Locator_getLocalQuery : public Callback_Locator_getLocalQuery_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const QueryPrx&, const CT&);

    Callback_Locator_getLocalQuery(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        LocatorPrx proxy = LocatorPrx::uncheckedCast(result->getProxy());
        QueryPrx ret;
        try
        {
            ret = proxy->end_getLocalQuery(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Locator::begin_getLocalQuery.
 */
template<class T, typename CT> Callback_Locator_getLocalQueryPtr
newCallback_Locator_getLocalQuery(const IceUtil::Handle<T>& instance, void (T::*cb)(const QueryPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_getLocalQuery<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Locator::begin_getLocalQuery.
 */
template<class T, typename CT> Callback_Locator_getLocalQueryPtr
newCallback_Locator_getLocalQuery(T* instance, void (T::*cb)(const QueryPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_getLocalQuery<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
