/* ListItem.c generated by valac 0.56.0, the Vala compiler
 * generated from ListItem.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "placesindicator.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <gio/gio.h>
#include <gdk/gdk.h>

enum  {
	LIST_ITEM_0_PROPERTY,
	LIST_ITEM_NUM_PROPERTIES
};
static GParamSpec* list_item_properties[LIST_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	LIST_ITEM_SEND_MESSAGE_SIGNAL,
	LIST_ITEM_CLOSE_POPOVER_SIGNAL,
	LIST_ITEM_NUM_SIGNALS
};
static guint list_item_signals[LIST_ITEM_NUM_SIGNALS] = {0};

static gpointer list_item_parent_class = NULL;
static GType list_item_type_id = 0;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void list_item_real_cancel_operation (ListItem* self);
static void list_item_finalize (GObject * obj);

ListItem*
list_item_construct (GType object_type)
{
	ListItem * self = NULL;
	GtkToolButton* _tmp0_;
	GtkToolButton* _tmp1_;
	GtkWidget* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkToolButton* _tmp4_;
	GtkOverlay* _tmp5_;
	GtkOverlay* _tmp6_;
	GtkToolButton* _tmp7_;
	GtkOverlay* _tmp8_;
	self = (ListItem*) g_object_new (object_type, NULL);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_box_set_spacing ((GtkBox*) self, 0);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->name_button);
	self->name_button = _tmp0_;
	_tmp1_ = self->name_button;
	_tmp2_ = gtk_bin_get_child ((GtkBin*) _tmp1_);
	_tmp3_ = gtk_widget_get_style_context (_tmp2_);
	gtk_style_context_add_class (_tmp3_, "name-button");
	_tmp4_ = self->name_button;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp4_, FALSE);
	_tmp5_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->overlay);
	self->overlay = _tmp5_;
	_tmp6_ = self->overlay;
	_tmp7_ = self->name_button;
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = self->overlay;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp8_, TRUE, TRUE, (guint) 0);
	return self;
}

void
list_item_set_button (ListItem* self,
                      const gchar* label,
                      GtkImage* image,
                      gboolean spinner,
                      gboolean offset_spinner)
{
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkLabel* label_w = NULL;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkBox* _tmp6_;
	GtkLabel* _tmp7_;
	GtkToolButton* _tmp13_;
	GtkBox* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (image != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	gtk_widget_set_margin_end ((GtkWidget*) image, 5);
	_tmp1_ = box;
	gtk_box_pack_start (_tmp1_, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
	_tmp2_ = (GtkLabel*) gtk_label_new (label);
	g_object_ref_sink (_tmp2_);
	label_w = _tmp2_;
	_tmp3_ = label_w;
	gtk_label_set_max_width_chars (_tmp3_, 25);
	_tmp4_ = label_w;
	gtk_label_set_ellipsize (_tmp4_, PANGO_ELLIPSIZE_END);
	_tmp5_ = label_w;
	gtk_widget_set_halign ((GtkWidget*) _tmp5_, GTK_ALIGN_START);
	_tmp6_ = box;
	_tmp7_ = label_w;
	gtk_box_pack_start (_tmp6_, (GtkWidget*) _tmp7_, TRUE, TRUE, (guint) 0);
	if (spinner) {
		GtkSpinner* _tmp8_;
		GtkSpinner* _tmp9_;
		GtkBox* _tmp11_;
		GtkSpinner* _tmp12_;
		_tmp8_ = (GtkSpinner*) gtk_spinner_new ();
		g_object_ref_sink (_tmp8_);
		_g_object_unref0 (self->spin);
		self->spin = _tmp8_;
		_tmp9_ = self->spin;
		gtk_widget_set_halign ((GtkWidget*) _tmp9_, GTK_ALIGN_END);
		if (offset_spinner) {
			GtkSpinner* _tmp10_;
			_tmp10_ = self->spin;
			gtk_widget_set_margin_end ((GtkWidget*) _tmp10_, 25);
		}
		_tmp11_ = box;
		_tmp12_ = self->spin;
		gtk_box_pack_end (_tmp11_, (GtkWidget*) _tmp12_, FALSE, FALSE, (guint) 2);
	}
	_tmp13_ = self->name_button;
	_tmp14_ = box;
	gtk_tool_button_set_label_widget (_tmp13_, (GtkWidget*) _tmp14_);
	_g_object_unref0 (label_w);
	_g_object_unref0 (box);
}

GtkImage*
list_item_get_icon (ListItem* self,
                    GIcon* icon)
{
	gchar* icon_name = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	const gchar* _tmp8_;
	GtkImage* _tmp9_;
	GtkImage* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (icon != NULL) {
		GtkImage* _tmp0_;
		_tmp0_ = (GtkImage*) gtk_image_new_from_gicon (icon, (GtkIconSize) GTK_ICON_SIZE_MENU);
		g_object_ref_sink (_tmp0_);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = self->item_class;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("device")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("drive-harddisk-symbolic");
				_g_free0 (icon_name);
				icon_name = _tmp5_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("network")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("folder-remote-symbolic");
				_g_free0 (icon_name);
				icon_name = _tmp6_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("folder-symbolic");
				_g_free0 (icon_name);
				icon_name = _tmp7_;
				break;
			}
		}
	}
	_tmp8_ = icon_name;
	_tmp9_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp8_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp9_);
	result = _tmp9_;
	_g_free0 (icon_name);
	return result;
}

gchar*
list_item_get_item_category (ListItem* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->category_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
list_item_open_directory (ListItem* self,
                          GFile* root)
{
	GAppLaunchContext* launch_context = NULL;
	GdkDisplay* _tmp0_;
	GdkAppLaunchContext* _tmp1_;
	GList* file_list = NULL;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (root == NULL) {
		return;
	}
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_display_get_app_launch_context (_tmp0_);
	launch_context = (GAppLaunchContext*) _tmp1_;
	file_list = NULL;
	_tmp2_ = _g_object_ref0 (root);
	file_list = g_list_append (file_list, _tmp2_);
	{
		GAppInfo* _tmp3_;
		GAppInfo* _tmp4_;
		GList* _tmp5_;
		GAppLaunchContext* _tmp6_;
		_tmp3_ = g_app_info_get_default_for_type ("inode/directory", TRUE);
		_tmp4_ = _tmp3_;
		_tmp5_ = file_list;
		_tmp6_ = launch_context;
		g_app_info_launch (_tmp4_, _tmp5_, _tmp6_, &_inner_error0_);
		_g_object_unref0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_signal_emit (self, list_item_signals[LIST_ITEM_CLOSE_POPOVER_SIGNAL], 0);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("ListItem.vala:113: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		(file_list == NULL) ? NULL : (file_list = (_g_list_free__g_object_unref0_ (file_list), NULL));
		_g_object_unref0 (launch_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	(file_list == NULL) ? NULL : (file_list = (_g_list_free__g_object_unref0_ (file_list), NULL));
	_g_object_unref0 (launch_context);
}

static void
list_item_real_cancel_operation (ListItem* self)
{
}

void
list_item_cancel_operation (ListItem* self)
{
	ListItemClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = LIST_ITEM_GET_CLASS (self);
	if (_klass_->cancel_operation) {
		_klass_->cancel_operation (self);
	}
}

static void
list_item_class_init (ListItemClass * klass,
                      gpointer klass_data)
{
	list_item_parent_class = g_type_class_peek_parent (klass);
	((ListItemClass *) klass)->cancel_operation = (void (*) (ListItem*)) list_item_real_cancel_operation;
	G_OBJECT_CLASS (klass)->finalize = list_item_finalize;
	list_item_signals[LIST_ITEM_SEND_MESSAGE_SIGNAL] = g_signal_new ("send-message", TYPE_LIST_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	list_item_signals[LIST_ITEM_CLOSE_POPOVER_SIGNAL] = g_signal_new ("close-popover", TYPE_LIST_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
list_item_instance_init (ListItem * self,
                         gpointer klass)
{
}

static void
list_item_finalize (GObject * obj)
{
	ListItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIST_ITEM, ListItem);
	_g_free0 (self->item_class);
	_g_free0 (self->category_name);
	_g_object_unref0 (self->name_button);
	_g_object_unref0 (self->overlay);
	_g_object_unref0 (self->spin);
	G_OBJECT_CLASS (list_item_parent_class)->finalize (obj);
}

GType
list_item_get_type (void)
{
	return list_item_type_id;
}

GType
list_item_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ListItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) list_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ListItem), 0, (GInstanceInitFunc) list_item_instance_init, NULL };
	list_item_type_id = g_type_module_register_type (module, gtk_box_get_type (), "ListItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return list_item_type_id;
}

