"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    }
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var jsonToAST = require("json-to-ast");
var messageRegistry = require("../../resources/errorMessages");
var schemaUtil = require("./schemaUtil");
var JSONSchemaError = /** @class */ (function () {
    function JSONSchemaError(entry, params, path, range, isWarning) {
        this.entry = entry;
        this.params = params;
        this.path = path;
        this.range = range;
        this.isWarning = isWarning;
    }
    return JSONSchemaError;
}());
var RecursiveValidator = /** @class */ (function () {
    function RecursiveValidator() {
    }
    RecursiveValidator.prototype.validate = function (content) {
        var jsonObj = jsonToAST(content, { verbose: true });
        var obj = JSON.parse(content);
        var result = [];
        this.validateInternal(obj, jsonObj, result, "");
        return result;
    };
    RecursiveValidator.prototype.validateInternal = function (obj, rootObj, errors, _jsonPath) {
        var _this = this;
        var jsonPath = _jsonPath.length == 0
            ? ""
            : ((_jsonPath.charAt(_jsonPath.length - 1) == "/")
                ? _jsonPath
                : (_jsonPath + "/"));
        this.doValidate(obj, rootObj, jsonPath).forEach(function (x) { return errors.push(x); });
        if (typeof obj != "object") {
            return;
        }
        Object.keys(obj).forEach(function (x) {
            var val = obj[x];
            if (val != null && typeof val == "object" && (x === "properties" || x === "patternProperties")) {
                for (var _i = 0, _a = Object.keys(val); _i < _a.length; _i++) {
                    var pName = _a[_i];
                    var propPath = jsonPath + "properties/" + pName;
                    _this.validateInternal(val[pName], rootObj, errors, propPath);
                }
            }
            else if (x === "items" || x === "additionalItems" || x == "additionalProperties") {
                _this.validateInternal(val, rootObj, errors, jsonPath + "/" + x);
            }
        });
    };
    RecursiveValidator.prototype.createError = function (entry, params, rootObj, jsonPath, isWarning) {
        var range = schemaUtil.getJSONRange("", rootObj, jsonPath);
        var result = new JSONSchemaError(entry, params, jsonPath, range, isWarning);
        return result;
    };
    return RecursiveValidator;
}());
var Draft4Validator = /** @class */ (function (_super) {
    __extends(Draft4Validator, _super);
    function Draft4Validator() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Draft4Validator.prototype.doValidate = function (obj, rootObj, jsonPath) {
        var result = [];
        if (typeof obj != "object" || Array.isArray(obj)) {
            return result;
        }
        var requiredObj = obj['required'];
        if (requiredObj != null && !Array.isArray(requiredObj)) {
            var errPath = jsonPath + "required";
            var err = this.createError(messageRegistry.REQUIRED_MUST_BE_ARRAY_IN_DRAFT_4, {}, rootObj, errPath, false);
            result.push(err);
        }
        return result;
    };
    return Draft4Validator;
}(RecursiveValidator));
exports.Draft4Validator = Draft4Validator;
var Draft3Validator = /** @class */ (function (_super) {
    __extends(Draft3Validator, _super);
    function Draft3Validator() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Draft3Validator.prototype.doValidate = function (obj, rootObj, jsonPath) {
        var result = [];
        if (typeof obj != "object" || Array.isArray(obj)) {
            return result;
        }
        var requiredObj = obj['required'];
        if (requiredObj != null && typeof requiredObj != "boolean") {
            var errPath = jsonPath + "required";
            var err = this.createError(messageRegistry.REQUIRED_MUST_BE_BOOLEAN_IN_DRAFT_3, {}, rootObj, errPath, false);
            result.push(err);
        }
        return result;
    };
    return Draft3Validator;
}(RecursiveValidator));
exports.Draft3Validator = Draft3Validator;
//# sourceMappingURL=jsonSchemaValidation.js.map