/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.dialog.FreeColDialog;
import net.sf.freecol.client.gui.option.OptionGroupUI;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.option.OptionGroup;

public abstract class OptionsDialog
extends FreeColDialog<OptionGroup> {
    private static final Logger logger = Logger.getLogger(OptionsDialog.class.getName());
    private final boolean editable;
    private OptionGroup group;
    private OptionGroupUI ui;
    private final String defaultFileName;
    private final String optionGroupId;
    private JScrollPane scrollPane;
    private MigPanel optionPanel;
    protected MigPanel panel;

    protected OptionsDialog(FreeColClient freeColClient, JFrame frame, boolean editable, OptionGroup group, String headerKey, String defaultFileName, String optionGroupId) {
        super(freeColClient, frame);
        this.editable = editable;
        this.group = group;
        this.ui = new OptionGroupUI(this.getGUI(), this.group, this.editable);
        this.defaultFileName = defaultFileName;
        this.optionGroupId = optionGroupId;
        this.preparePanel(headerKey, this.ui);
    }

    protected boolean isEditable() {
        return this.editable;
    }

    protected OptionGroup getGroup() {
        return this.group;
    }

    protected OptionGroupUI getOptionUI() {
        return this.ui;
    }

    protected String getDefaultFileName() {
        return this.defaultFileName;
    }

    protected String getOptionGroupId() {
        return this.optionGroupId;
    }

    private void preparePanel(String headerKey, OptionGroupUI ui) {
        this.optionPanel = new MigPanel(new MigLayout("fill"));
        this.optionPanel.setOpaque(false);
        this.optionPanel.add((Component)ui, "grow");
        this.optionPanel.setSize(this.optionPanel.getPreferredSize());
        this.panel = new MigPanel(new MigLayout("wrap 1, fill"));
        this.panel.add((Component)Utility.localizedHeader(Messages.nameKey(headerKey), Utility.FONTSPEC_TITLE), "span, center");
    }

    protected void initialize(JFrame frame, List<ChoiceItem<OptionGroup>> c) {
        this.panel.add((Component)this.optionPanel, "width 100%, height 100%");
        float scaleFactor = this.getImageLibrary().getScaleFactor();
        int maxWidth = (int)(850.0f * scaleFactor);
        int maxHeight = (int)(650.0f * scaleFactor);
        int width = Math.min(maxWidth, frame.getWidth() - 200);
        int height = Math.min(maxHeight, frame.getHeight() - 200);
        this.panel.setPreferredSize(new Dimension(width, height));
        this.panel.setSize(this.panel.getPreferredSize());
        c.add(new ChoiceItem<OptionGroup>(Messages.message("ok"), this.group).okOption());
        c.add(new ChoiceItem<OptionGroup>(Messages.message("cancel"), null, this.isEditable()).cancelOption().defaultOption());
        this.initializeDialog(frame, FreeColDialog.DialogType.PLAIN, true, this.panel, null, c);
    }

    protected void set(OptionGroup group) {
        this.group = group;
        this.update();
    }

    private void update() {
        this.optionPanel.removeAll();
        this.ui = new OptionGroupUI(this.getGUI(), this.group, this.editable);
        this.optionPanel.add((Component)this.ui, "grow");
        this.invalidate();
        this.validate();
        this.repaint();
    }

    protected boolean load(File file) {
        OptionGroup og = OptionGroup.loadOptionGroup(file, this.getOptionGroupId(), this.getSpecification());
        if (og == null) {
            return false;
        }
        this.set(og);
        return true;
    }

    protected boolean save(File file) {
        if (this.group.save(file, null, true)) {
            return true;
        }
        this.getGUI().showErrorPanel(FreeCol.badFile("error.couldNotSave", file));
        return false;
    }

    protected boolean loadDefaultOptions() {
        File f = FreeColDirectories.getOptionsFile(this.getDefaultFileName());
        return f.exists() ? this.load(f) : false;
    }

    protected boolean saveDefaultOptions() {
        File f = FreeColDirectories.getOptionsFile(this.getDefaultFileName());
        return this.save(f);
    }

    @Override
    public OptionGroup getResponse() {
        OptionGroup value = (OptionGroup)super.getResponse();
        if (value != null) {
            this.getOptionUI().updateOption();
        }
        return value;
    }
}

