/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.screenshot;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.TileRenderer;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.awt.Cursor;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.gephi.ui.utils.DialogFileFilter;
import org.gephi.utils.longtask.api.LongTaskExecutor;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.gephi.visualization.VizArchitecture;
import org.gephi.visualization.VizController;
import org.gephi.visualization.apiimpl.VizConfig;
import org.gephi.visualization.opengl.AbstractEngine;
import org.gephi.visualization.screenshot.OffscreenCanvas;
import org.gephi.visualization.screenshot.ScreenshotSettingsPanel;
import org.gephi.visualization.text.TextManager;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

public class ScreenshotMaker
implements VizArchitecture,
LongTask,
Runnable {
    private static final String DATE_FORMAT_NOW = "HHmmss";
    private final String LAST_PATH = "ScreenshotMaker_Last_Path";
    private final String LAST_PATH_DEFAULT = "ScreenshotMaker_Last_Path_Default";
    private final String ANTIALIASING_DEFAULT = "ScreenshotMaker_Antialiasing_Default";
    private final String WIDTH_DEFAULT = "ScreenshotMaker_Width_Default";
    private final String HEIGHT_DEFAULT = "ScreenshotMaker_Height_Default";
    private final String TRANSPARENT_BACKGROUND_DEFAULT = "ScreenshotMaker_TransparentBackground_Default";
    private final String AUTOSAVE_DEFAULT = "ScreenshotMaker_Autosave_Default";
    private final String SHOW_MESSAGE = "ScreenshotMaker_Show_Message";
    private final LongTaskExecutor executor;
    private AbstractEngine engine;
    private VizConfig vizConfig;
    private TextManager textManager;
    private ProgressTicket progressTicket;
    private boolean cancel;
    private int antiAliasing = 2;
    private int width = 1024;
    private int height = 768;
    private int tileWidth = this.width / 16;
    private int tileHeight = this.height / 12;
    private boolean transparentBackground = false;
    private boolean finishedMessage = true;
    private boolean autoSave = false;
    private String defaultDirectory;
    private File file;

    public ScreenshotMaker() {
        String lastPathDefault = NbPreferences.forModule(ScreenshotMaker.class).get("ScreenshotMaker_Last_Path_Default", null);
        this.defaultDirectory = NbPreferences.forModule(ScreenshotMaker.class).get("ScreenshotMaker_Last_Path", lastPathDefault);
        this.antiAliasing = NbPreferences.forModule(ScreenshotMaker.class).getInt("ScreenshotMaker_Antialiasing_Default", this.antiAliasing);
        this.width = NbPreferences.forModule(ScreenshotMaker.class).getInt("ScreenshotMaker_Width_Default", this.width);
        this.height = NbPreferences.forModule(ScreenshotMaker.class).getInt("ScreenshotMaker_Height_Default", this.height);
        this.transparentBackground = NbPreferences.forModule(ScreenshotMaker.class).getBoolean("ScreenshotMaker_TransparentBackground_Default", this.transparentBackground);
        this.autoSave = NbPreferences.forModule(ScreenshotMaker.class).getBoolean("ScreenshotMaker_Autosave_Default", this.autoSave);
        this.finishedMessage = NbPreferences.forModule(ScreenshotMaker.class).getBoolean("ScreenshotMaker_Show_Message", this.finishedMessage);
        this.executor = new LongTaskExecutor(true, "Screenshot Maker");
        this.tileWidth = this.width / 16;
        this.tileHeight = this.height / 12;
    }

    @Override
    public void initArchitecture() {
        this.engine = VizController.getInstance().getEngine();
        this.vizConfig = VizController.getInstance().getVizConfig();
        this.textManager = VizController.getInstance().getTextManager();
    }

    public void takeScreenshot() {
        this.executor.execute((LongTask)this, (Runnable)this, NbBundle.getMessage(ScreenshotMaker.class, (String)"ScreenshotMaker.progress.message"), null);
    }

    @Override
    public void run() {
        this.beforeTaking();
        try {
            this.engine.stopDisplay();
            Progress.start((ProgressTicket)this.progressTicket);
            Thread.sleep(100L);
            OffscreenCanvas drawable = new OffscreenCanvas(this.tileWidth, this.tileHeight, this.transparentBackground, this.antiAliasing);
            GLAutoDrawable autoDrawable = drawable.getGLAutoDrawable();
            final TileRenderer renderer = new TileRenderer();
            renderer.setImageSize(this.width, this.height);
            renderer.setTileSize(this.tileWidth, this.tileHeight, 0);
            renderer.attachAutoDrawable(autoDrawable);
            final GLPixelBuffer.GLPixelBufferProvider pixelBufferProvider = GLPixelBuffer.defaultProviderWithRowStride;
            final boolean[] flipVertically = new boolean[]{false};
            GLEventListener preTileGLEL = new GLEventListener(){

                public void init(GLAutoDrawable drawable) {
                    GL2 gl = drawable.getGL().getGL2();
                    GLPixelBuffer.GLPixelAttributes pixelAttribs = pixelBufferProvider.getAttributes((GL)gl, ScreenshotMaker.this.transparentBackground ? 4 : 3, true);
                    GLPixelBuffer imageBuffer = pixelBufferProvider.allocate((GL)gl, null, pixelAttribs, true, ScreenshotMaker.this.width, ScreenshotMaker.this.height, 1, 0);
                    renderer.setImageBuffer(imageBuffer);
                    flipVertically[0] = !drawable.isGLOriented();
                }

                public void dispose(GLAutoDrawable drawable) {
                }

                public void display(GLAutoDrawable drawable) {
                }

                public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
                }
            };
            renderer.setGLEventListener(preTileGLEL, null);
            this.vizConfig.setDisableLOD(true);
            this.engine.updateLOD();
            int tiles = renderer.getParam(15) * renderer.getParam(14);
            Progress.switchToDeterminate((ProgressTicket)this.progressTicket, (int)tiles);
            while (!renderer.eot() && !this.cancel) {
                renderer.display();
                Progress.progress((ProgressTicket)this.progressTicket);
            }
            Progress.switchToIndeterminate((ProgressTicket)this.progressTicket);
            renderer.detachAutoDrawable();
            autoDrawable.invoke(true, new GLRunnable(){

                public boolean run(GLAutoDrawable drawable) {
                    drawable.getGL().glViewport(0, 0, drawable.getSurfaceWidth(), drawable.getSurfaceHeight());
                    return false;
                }
            });
            this.vizConfig.setDisableLOD(false);
            this.engine.updateLOD();
            if (!this.cancel) {
                GLPixelBuffer imageBuffer = renderer.getImageBuffer();
                TextureData textureData = new TextureData(autoDrawable.getChosenGLCapabilities().getGLProfile(), this.transparentBackground ? 6408 : 6407, this.width, this.height, 0, imageBuffer.pixelAttributes, false, false, flipVertically[0], imageBuffer.buffer, null);
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (!ScreenshotMaker.this.autoSave) {
                            String lastPathDefault = NbPreferences.forModule(ScreenshotMaker.class).get("ScreenshotMaker_Last_Path_Default", null);
                            String lastPath = NbPreferences.forModule(ScreenshotMaker.class).get("ScreenshotMaker_Last_Path", lastPathDefault);
                            JFileChooser chooser = new JFileChooser(lastPath);
                            chooser.setAcceptAllFileFilterUsed(false);
                            chooser.setDialogTitle(NbBundle.getMessage(ScreenshotMaker.class, (String)"ScreenshotMaker.filechooser.title"));
                            DialogFileFilter dialogFileFilter = new DialogFileFilter(NbBundle.getMessage(ScreenshotMaker.class, (String)"ScreenshotMaker.filechooser.pngDescription"));
                            dialogFileFilter.addExtension("png");
                            chooser.addChoosableFileFilter((FileFilter)dialogFileFilter);
                            File selectedFile = new File(chooser.getCurrentDirectory(), ScreenshotMaker.this.getDefaultFileName() + ".png");
                            chooser.setSelectedFile(selectedFile);
                            int returnFile = chooser.showSaveDialog(null);
                            if (returnFile == 0) {
                                ScreenshotMaker.this.file = chooser.getSelectedFile();
                                if (!ScreenshotMaker.this.file.getPath().endsWith(".png")) {
                                    ScreenshotMaker.this.file = new File(ScreenshotMaker.this.file.getPath() + ".png");
                                }
                                ScreenshotMaker.this.defaultDirectory = ScreenshotMaker.this.file.getParentFile().getAbsolutePath();
                                NbPreferences.forModule(ScreenshotMaker.class).put("ScreenshotMaker_Last_Path", ScreenshotMaker.this.defaultDirectory);
                            } else {
                                ScreenshotMaker.this.file = null;
                            }
                        } else {
                            ScreenshotMaker.this.file = new File(ScreenshotMaker.this.defaultDirectory, ScreenshotMaker.this.getDefaultFileName() + ".png");
                        }
                    }
                });
                if (this.file != null) {
                    TextureIO.write((TextureData)textureData, (File)this.file);
                }
            }
            autoDrawable.destroy();
            this.textManager.reinitRenderers();
            this.engine.startDisplay();
            Progress.finish((ProgressTicket)this.progressTicket);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.afterTaking();
    }

    private void beforeTaking() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowManager.getDefault().getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
            }
        });
    }

    private void afterTaking() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowManager.getDefault().getMainWindow().setCursor(Cursor.getDefaultCursor());
                if (ScreenshotMaker.this.finishedMessage && ScreenshotMaker.this.file != null) {
                    if (ScreenshotMaker.this.autoSave) {
                        String msg = NbBundle.getMessage(ScreenshotMaker.class, (String)"ScreenshotMaker.finishedMessage.message", (Object)ScreenshotMaker.this.file.getAbsolutePath());
                        StatusDisplayer.getDefault().setStatusText(msg);
                    } else {
                        String msg = NbBundle.getMessage(ScreenshotMaker.class, (String)"ScreenshotMaker.finishedMessage.message", (Object)ScreenshotMaker.this.file.getName());
                        JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), msg, NbBundle.getMessage(ScreenshotMaker.class, (String)"ScreenshotMaker.finishedMessage.title"), 1);
                    }
                }
            }
        });
    }

    private String getDefaultFileName() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_NOW);
        String datetime = dateFormat.format(cal.getTime());
        return "screenshot_" + datetime;
    }

    public void configure() {
        ScreenshotSettingsPanel panel = new ScreenshotSettingsPanel();
        panel.setup(this);
        ValidationPanel validationPanel = ScreenshotSettingsPanel.createValidationPanel(panel);
        if (validationPanel.showOkCancelDialog(NbBundle.getMessage(ScreenshotMaker.class, (String)"ScreenshotMaker.configure.title"))) {
            panel.unsetup(this);
        }
    }

    public int getAntiAliasing() {
        return this.antiAliasing;
    }

    public void setAntiAliasing(int antiAliasing) {
        this.antiAliasing = antiAliasing;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public boolean isTransparentBackground() {
        return this.transparentBackground;
    }

    public void setTransparentBackground(boolean transparentBackground) {
        this.transparentBackground = transparentBackground;
    }

    public String getDefaultDirectory() {
        return this.defaultDirectory;
    }

    public void setDefaultDirectory(File directory) {
        if (directory != null && directory.exists()) {
            this.defaultDirectory = directory.getAbsolutePath();
            NbPreferences.forModule(ScreenshotMaker.class).put("ScreenshotMaker_Last_Path", this.defaultDirectory);
        }
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }
}

