/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import javajs.util.M3;
import javajs.util.Matrix;
import javajs.util.PT;
import org.jmol.adapter.readers.cif.Cif2DataParser;
import org.jmol.adapter.readers.cif.CifReader;
import org.jmol.adapter.readers.cif.MSRdr;

public class MSCifParser
extends MSRdr {
    private String field;
    private static final int FWV_ID = 0;
    private static final int WV_ID = 1;
    private static final int WV_X = 2;
    private static final int WV_Y = 3;
    private static final int WV_Z = 4;
    private static final int FWV_X = 5;
    private static final int FWV_Y = 6;
    private static final int FWV_Z = 7;
    private static final int FWV_Q_COEF = 8;
    private static final int JANA_FWV_Q1_COEF = 9;
    private static final int JANA_FWV_Q2_COEF = 10;
    private static final int JANA_FWV_Q3_COEF = 11;
    private static final int FWV_DISP_LABEL = 12;
    private static final int FWV_DISP_AXIS = 13;
    private static final int FWV_DISP_SEQ_ID = 14;
    private static final int FWV_DISP_COS = 15;
    private static final int FWV_DISP_SIN = 16;
    private static final int FWV_DISP_MODULUS = 17;
    private static final int FWV_DISP_PHASE = 18;
    private static final int DISP_SPEC_LABEL = 19;
    private static final int DISP_SAW_AX = 20;
    private static final int DISP_SAW_AY = 21;
    private static final int DISP_SAW_AZ = 22;
    private static final int DISP_SAW_C = 23;
    private static final int DISP_SAW_W = 24;
    private static final int FWV_OCC_LABEL = 25;
    private static final int FWV_OCC_SEQ_ID = 26;
    private static final int FWV_OCC_COS = 27;
    private static final int FWV_OCC_SIN = 28;
    private static final int FWV_OCC_MODULUS = 29;
    private static final int FWV_OCC_PHASE = 30;
    private static final int OCC_SPECIAL_LABEL = 31;
    private static final int OCC_CRENEL_C = 32;
    private static final int OCC_CRENEL_W = 33;
    private static final int FWV_U_LABEL = 34;
    private static final int FWV_U_TENS = 35;
    private static final int FWV_U_SEQ_ID = 36;
    private static final int FWV_U_COS = 37;
    private static final int FWV_U_SIN = 38;
    private static final int FWV_U_MODULUS = 39;
    private static final int FWV_U_PHASE = 40;
    private static final int FD_ID = 41;
    private static final int FO_ID = 42;
    private static final int FU_ID = 43;
    private static final int FDP_ID = 44;
    private static final int FOP_ID = 45;
    private static final int FUP_ID = 46;
    private static final int JANA_OCC_ABS_LABEL = 47;
    private static final int JANA_OCC_ABS_O_0 = 48;
    private static final int FWV_SPIN_LABEL = 49;
    private static final int FWV_SPIN_AXIS = 50;
    private static final int FWV_SPIN_SEQ_ID = 51;
    private static final int FWV_SPIN_COS = 52;
    private static final int FWV_SPIN_SIN = 53;
    private static final int FWV_SPIN_MODULUS = 54;
    private static final int FWV_SPIN_PHASE = 55;
    private static final int SPIN_SPEC_LABEL = 56;
    private static final int SPIN_SAW_AX = 57;
    private static final int SPIN_SAW_AY = 58;
    private static final int SPIN_SAW_AZ = 59;
    private static final int SPIN_SAW_C = 60;
    private static final int SPIN_SAW_W = 61;
    private static final int LEG_DISP_LABEL = 62;
    private static final int LEG_DISP_AXIS = 63;
    private static final int LEG_DISP_ORDER = 64;
    private static final int LEG_DISP_COEF = 65;
    private static final int LEG_U_LABEL = 66;
    private static final int LEG_U_TENS = 67;
    private static final int LEG_U_ORDER = 68;
    private static final int LEG_U_COEF = 69;
    private static final int LEG_OCC_LABEL = 70;
    private static final int LEG_OCC_ORDER = 71;
    private static final int LEG_OCC_COEF = 72;
    private static final int DEPR_FD_COS = 73;
    private static final int DEPR_FD_SIN = 74;
    private static final int DEPR_FO_COS = 75;
    private static final int DEPR_FO_SIN = 76;
    private static final int DEPR_FU_COS = 77;
    private static final int DEPR_FU_SIN = 78;
    private static final String[] modulationFields = new String[]{"*_fourier_wave_vector_seq_id", "_cell_wave_vector_seq_id", "_cell_wave_vector_x", "_cell_wave_vector_y", "_cell_wave_vector_z", "*_fourier_wave_vector_x", "*_fourier_wave_vector_y", "*_fourier_wave_vector_z", "*_fourier_wave_vector_q_coeff", "*_fourier_wave_vector_q1_coeff", "*_fourier_wave_vector_q2_coeff", "*_fourier_wave_vector_q3_coeff", "*_displace_fourier_atom_site_label", "*_displace_fourier_axis", "*_displace_fourier_wave_vector_seq_id", "*_displace_fourier_param_cos", "*_displace_fourier_param_sin", "*_displace_fourier_param_modulus", "*_displace_fourier_param_phase", "*_displace_special_func_atom_site_label", "*_displace_special_func_sawtooth_ax", "*_displace_special_func_sawtooth_ay", "*_displace_special_func_sawtooth_az", "*_displace_special_func_sawtooth_c", "*_displace_special_func_sawtooth_w", "*_occ_fourier_atom_site_label", "*_occ_fourier_wave_vector_seq_id", "*_occ_fourier_param_cos", "*_occ_fourier_param_sin", "*_occ_fourier_param_modulus", "*_occ_fourier_param_phase", "*_occ_special_func_atom_site_label", "*_occ_special_func_crenel_c", "*_occ_special_func_crenel_w", "*_u_fourier_atom_site_label", "*_u_fourier_tens_elem", "*_u_fourier_wave_vector_seq_id", "*_u_fourier_param_cos", "*_u_fourier_param_sin", "*_u_fourier_param_modulus", "*_u_fourier_param_phase", "*_displace_fourier_id", "*_occ_fourier_id", "*_u_fourier_id", "*_displace_fourier_param_id", "*_occ_fourier_param_id", "*_u_fourier_param_id", "*_occ_fourier_absolute_site_label", "*_occ_fourier_absolute", "*_moment_fourier_atom_site_label", "*_moment_fourier_axis", "*_moment_fourier_wave_vector_seq_id", "*_moment_fourier_param_cos", "*_moment_fourier_param_sin", "*_moment_fourier_param_modulus", "*_moment_fourier_param_phase", "*_moment_special_func_atom_site_label", "*_moment_special_func_sawtooth_ax", "*_moment_special_func_sawtooth_ay", "*_moment_special_func_sawtooth_az", "*_moment_special_func_sawtooth_c", "*_moment_special_func_sawtooth_w", "*_displace_legendre_atom_site_label", "*_displace_legendre_axis", "*_displace_legendre_param_order", "*_displace_legendre_param_coeff", "*_u_legendre_atom_site_label", "*_u_legendre_tens_elem", "*_u_legendre_param_order", "*_u_legendre_param_coeff", "*_occ_legendre_atom_site_label", "*_occ_legendre_param_order", "*_occ_legendre_param_coeff", "*_displace_fourier_cos", "*_displace_fourier_sin", "*_occ_fourier_cos", "*_occ_fourier_sin", "*_u_fourier_cos", "*_u_fourier_sin"};
    private static final int NONE = -1;
    static final String SEP = "_";
    private M3 comSSMat;

    public void processEntry() throws Exception {
        CifReader cr = (CifReader)this.cr;
        if (cr.key.equals("_cell_commen_t_section_1")) {
            this.isCommensurate = true;
            this.commensurateSection1 = cr.parseIntStr(cr.data);
        }
        if (cr.key.startsWith("_cell_commen_supercell_matrix")) {
            this.isCommensurate = true;
            if (this.comSSMat == null) {
                this.comSSMat = M3.newM3(null);
            }
            String[] tokens = PT.split(cr.key, SEP);
            int r = cr.parseIntStr(tokens[tokens.length - 2]);
            int c = cr.parseIntStr(tokens[tokens.length - 1]);
            if (r > 0 && c > 0) {
                this.comSSMat.setElement(r - 1, c - 1, cr.parseFloatStr(cr.data));
            }
        }
    }

    public int processLoopBlock() throws Exception {
        CifReader cr = (CifReader)this.cr;
        String key = cr.key;
        if (key.equals("_cell_subsystem_code")) {
            return this.processSubsystemLoopBlock();
        }
        if (!(key.startsWith("_cell_wave") || key.contains("fourier") || key.contains("legendre") || key.contains("_special_func"))) {
            if (key.contains("crenel_ortho")) {
                cr.appendLoadNote("WARNING: Orthogonalized non-Legendre functions not supported.\nThe following block has been ignored. Use Legendre functions instead.\n\n" + cr.cifParser.skipLoop(true) + "=================================\n");
            }
            return 0;
        }
        if (cr.asc.iSet < 0) {
            cr.asc.newAtomSet();
        }
        cr.parseLoopParametersFor("_atom_site", modulationFields);
        block40: while (cr.cifParser.getData()) {
            int nzero;
            boolean ignore = false;
            String type_id = null;
            String atomLabel = null;
            String axis = null;
            double[] pt = new double[]{Double.NaN, Double.NaN, Double.NaN};
            double[] q = null;
            double c = Double.NaN;
            double w = Double.NaN;
            String fid = null;
            int n = cr.cifParser.getColumnCount();
            String sep = SEP;
            block41: for (int i = 0; i < n; ++i) {
                int tok = this.fieldProperty(cr, i);
                switch (tok) {
                    case 0: {
                        pt[2] = 0.0;
                        pt[1] = 0.0;
                        pt[0] = 0.0;
                        type_id = "F_";
                        fid = this.field;
                        sep = "";
                        continue block41;
                    }
                    case 1: {
                        cr.haveCellWaveVector = true;
                        sep = "";
                    }
                    case 41: 
                    case 42: 
                    case 43: {
                        pt[2] = 0.0;
                        pt[1] = 0.0;
                        pt[0] = 0.0;
                        sep = "";
                    }
                    case 14: 
                    case 26: 
                    case 36: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 51: {
                        switch (tok) {
                            case 1: {
                                type_id = "W_";
                                sep = "";
                                break;
                            }
                            case 41: 
                            case 42: 
                            case 43: {
                                fid = "?" + this.field;
                                pt[2] = 1.0;
                                continue block41;
                            }
                            case 44: 
                            case 45: 
                            case 46: {
                                axis = "*";
                                atomLabel = "*";
                            }
                            case 14: 
                            case 26: 
                            case 36: 
                            case 51: {
                                type_id = modulationFields[tok].substring(11, 12).toUpperCase();
                            }
                        }
                        type_id = type_id + sep + this.field;
                        continue block41;
                    }
                    case 47: {
                        type_id = "J_O";
                        pt[2] = 1.0;
                        pt[0] = 1.0;
                        axis = "0";
                        atomLabel = this.field;
                        continue block41;
                    }
                    case 31: {
                        type_id = "O_0";
                        axis = "0";
                        atomLabel = this.field;
                        continue block41;
                    }
                    case 19: {
                        type_id = "D_S";
                        axis = "0";
                        atomLabel = this.field;
                        continue block41;
                    }
                    case 56: {
                        type_id = "M_T";
                        axis = "0";
                        atomLabel = this.field;
                        continue block41;
                    }
                    case 62: {
                        type_id = "D_L";
                        atomLabel = this.field;
                        continue block41;
                    }
                    case 66: {
                        type_id = "U_L";
                        atomLabel = this.field;
                        continue block41;
                    }
                    case 70: {
                        type_id = "O_L";
                        atomLabel = this.field;
                        continue block41;
                    }
                    case 12: 
                    case 25: 
                    case 34: 
                    case 49: {
                        atomLabel = this.field;
                        continue block41;
                    }
                    case 13: 
                    case 50: 
                    case 63: {
                        axis = this.field;
                        if (this.modAxes == null || this.modAxes.indexOf(axis.toUpperCase()) >= 0) continue block41;
                        ignore = true;
                        continue block41;
                    }
                    case 35: 
                    case 67: {
                        axis = this.field.toUpperCase();
                        continue block41;
                    }
                    case 8: {
                        q = Cif2DataParser.getArrayFromStringList(this.field, this.modDim);
                        continue block41;
                    }
                    default: {
                        float f = cr.parseFloatStr(this.field);
                        switch (tok) {
                            case 65: 
                            case 69: 
                            case 72: {
                                pt[0] = f;
                                if (f == 0.0f) continue block41;
                                pt[2] = 0.0;
                                continue block41;
                            }
                            case 16: 
                            case 28: 
                            case 32: 
                            case 38: 
                            case 53: 
                            case 74: 
                            case 76: 
                            case 78: {
                                pt[2] = 0.0;
                            }
                            case 2: 
                            case 5: 
                            case 20: 
                            case 57: {
                                pt[0] = f;
                                continue block41;
                            }
                            case 9: {
                                if (q == null) {
                                    q = new double[this.modDim];
                                }
                                q[0] = f;
                                continue block41;
                            }
                            case 10: {
                                if (q == null) {
                                    q = new double[this.modDim];
                                }
                                q[1] = f;
                                continue block41;
                            }
                            case 11: {
                                if (q == null) {
                                    q = new double[this.modDim];
                                }
                                q[2] = f;
                                continue block41;
                            }
                            case 17: 
                            case 29: 
                            case 39: 
                            case 54: {
                                pt[0] = f;
                                pt[2] = 1.0;
                                continue block41;
                            }
                            case 27: 
                            case 71: 
                            case 75: {
                                axis = "0";
                            }
                            case 3: 
                            case 6: 
                            case 15: 
                            case 18: 
                            case 21: 
                            case 30: 
                            case 33: 
                            case 37: 
                            case 40: 
                            case 48: 
                            case 52: 
                            case 55: 
                            case 58: 
                            case 64: 
                            case 68: 
                            case 73: 
                            case 77: {
                                pt[1] = f;
                                continue block41;
                            }
                            case 4: 
                            case 7: 
                            case 22: 
                            case 59: {
                                pt[2] = f;
                                continue block41;
                            }
                            case 23: 
                            case 60: {
                                c = f;
                                continue block41;
                            }
                            case 24: 
                            case 61: {
                                w = f;
                            }
                        }
                    }
                }
            }
            if (ignore || type_id == null && q == null || atomLabel != null && !atomLabel.equals("*") && cr.rejectAtomName(atomLabel)) continue;
            boolean ok = true;
            if (q != null) {
                nzero = q.length;
                for (int j = 0; j < q.length; ++j) {
                    if (!Double.isNaN(q[j]) && !(q[j] > 1.0E100) && (q[j] != 0.0 || --nzero != 0)) continue;
                    ok = false;
                }
                if (!ok) continue;
                this.addMod("F_coefs_", fid, q);
                pt[0] = Double.NaN;
            }
            nzero = pt.length;
            for (int j = 0; j < pt.length; ++j) {
                if (!Double.isNaN(pt[j]) && !(pt[j] > 1.0E100) && (pt[j] != 0.0 || --nzero != 0)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            switch (type_id.charAt(0)) {
                case 'C': 
                case 'D': 
                case 'J': 
                case 'M': 
                case 'O': 
                case 'U': {
                    if (atomLabel == null || axis == null) continue block40;
                    if (type_id.equals("D_S") || type_id.equals("M_T")) {
                        if (Double.isNaN(c) || Double.isNaN(w)) continue block40;
                        if (pt[0] != 0.0) {
                            this.addMod(type_id + "#x;" + atomLabel, fid, new double[]{c, w, pt[0]});
                        }
                        if (pt[1] != 0.0) {
                            this.addMod(type_id + "#y;" + atomLabel, fid, new double[]{c, w, pt[1]});
                        }
                        if (pt[2] == 0.0) continue block40;
                        this.addMod(type_id + "#z;" + atomLabel, fid, new double[]{c, w, pt[2]});
                        continue block40;
                    }
                    if (type_id.indexOf("_L") == 1) {
                        if (type_id.startsWith("U")) {
                            type_id = type_id + (int)pt[1];
                        } else {
                            axis = axis + (int)pt[1];
                        }
                    }
                    type_id = type_id + "#" + axis + ";" + atomLabel;
                }
            }
            this.addMod(type_id, fid, pt);
        }
        return 1;
    }

    private void addMod(String id, String fid, double[] params) {
        if (fid != null) {
            id = id + fid;
        }
        this.addModulation(null, id, params, -1);
    }

    private int processSubsystemLoopBlock() throws Exception {
        CifReader cr = (CifReader)this.cr;
        cr.parseLoopParameters(null);
        while (cr.cifParser.getData()) {
            this.fieldProperty(cr, 0);
            String id = this.field;
            this.addSubsystem(id, this.getSparseMatrix(cr, "_w_", 1, 3 + this.modDim));
        }
        return 1;
    }

    private Matrix getSparseMatrix(CifReader cr, String term, int i, int dim) {
        Matrix m = new Matrix(null, dim, dim);
        double[][] a = m.getArray();
        int n = cr.cifParser.getColumnCount();
        while (i < n) {
            String key;
            int p = this.fieldProperty(cr, i);
            if (p >= 0 && (key = cr.cifParser.getColumnName(p)).contains(term)) {
                String[] tokens = PT.split(key, SEP);
                int r = cr.parseIntStr(tokens[tokens.length - 2]);
                int c = cr.parseIntStr(tokens[tokens.length - 1]);
                if (r > 0 && c > 0) {
                    a[r - 1][c - 1] = cr.parseFloatStr(this.field);
                }
            }
            ++i;
        }
        return m;
    }

    private int fieldProperty(CifReader cr, int i) {
        this.field = (String)cr.cifParser.getColumnData(i);
        return this.field.length() > 0 && this.field.charAt(0) != '\u0000' ? cr.col2key[i] : -1;
    }
}

