/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockFileDocumentManagerImpl
extends FileDocumentManager {
    private static final Key<VirtualFile> MOCK_VIRTUAL_FILE_KEY = Key.create("MockVirtualFile");
    private final Function<? super CharSequence, ? extends Document> myFactory;
    @Nullable
    private final Key<Document> myCachedDocumentKey;
    private static final Key<Document> MOCK_DOC_KEY = Key.create("MOCK_DOC_KEY");

    public MockFileDocumentManagerImpl(@Nullable Key<Document> cachedDocumentKey, @NotNull Function<? super CharSequence, ? extends Document> factory2) {
        if (factory2 == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(0);
        }
        this.myFactory = factory2;
        this.myCachedDocumentKey = cachedDocumentKey;
    }

    private static boolean isBinaryWithoutDecompiler(VirtualFile file2) {
        FileType ft = file2.getFileType();
        return ft.isBinary() && BinaryFileTypeDecompilers.getInstance().forFileType(ft) == null;
    }

    @Override
    public Document getDocument(@NotNull VirtualFile file2) {
        Document document;
        if (file2 == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(1);
        }
        if ((document = file2.getUserData(MOCK_DOC_KEY)) == null) {
            if (file2.isDirectory() || MockFileDocumentManagerImpl.isBinaryWithoutDecompiler(file2)) {
                return null;
            }
            CharSequence text2 = LoadTextUtil.loadText(file2);
            document = this.myFactory.fun(text2);
            document.putUserData(MOCK_VIRTUAL_FILE_KEY, file2);
            document = file2.putUserDataIfAbsent(MOCK_DOC_KEY, document);
        }
        return document;
    }

    @Override
    public Document getCachedDocument(@NotNull VirtualFile file2) {
        if (file2 == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(2);
        }
        if (this.myCachedDocumentKey != null) {
            return file2.getUserData(this.myCachedDocumentKey);
        }
        return null;
    }

    @Override
    public VirtualFile getFile(@NotNull Document document) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(3);
        }
        return document.getUserData(MOCK_VIRTUAL_FILE_KEY);
    }

    @Override
    public void saveDocument(@NotNull Document document) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(5);
        }
    }

    @Override
    public void saveDocumentAsIs(@NotNull Document document) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(6);
        }
    }

    @Override
    public boolean isDocumentUnsaved(@NotNull Document document) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(8);
        }
        return false;
    }

    @Override
    public void reloadFromDisk(@NotNull Document document) {
        if (document == null) {
            MockFileDocumentManagerImpl.$$$reportNull$$$0(11);
        }
    }

    @Override
    @NotNull
    public String getLineSeparator(VirtualFile file2, Project project) {
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/mock/MockFileDocumentManagerImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/mock/MockFileDocumentManagerImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedDocuments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDocument";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveDocuments";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveDocument";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveDocumentAsIs";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDocumentUnsaved";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isFileModified";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPartialPreviewOfALargeFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDisk";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reloadFiles";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "requestWriting";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

