/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.inference;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.resolve.DoubleColonLHS;
import org.jetbrains.kotlin.fir.resolve.inference.InputOutputTypes;
import org.jetbrains.kotlin.fir.resolve.inference.PostponedAtomsKt;
import org.jetbrains.kotlin.fir.resolve.inference.PostponedResolvedAtom;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.resolve.calls.model.PostponedCallableReferenceMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u00103\u001a\u0002042\u0006\u0010\u000f\u001a\u000205H\u0016R\u0014\u0010\f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0015R\u0016\u0010#\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000eR\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0011\"\u0004\b.\u0010/R$\u00101\u001a\u0004\u0018\u00010\u00062\b\u00100\u001a\u0004\u0018\u00010\u00068V@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0011R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/ResolvedCallableReferenceAtom;", "Lorg/jetbrains/kotlin/fir/resolve/inference/PostponedResolvedAtom;", "Lorg/jetbrains/kotlin/resolve/calls/model/PostponedCallableReferenceMarker;", "reference", "Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;", "initialExpectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "lhs", "Lorg/jetbrains/kotlin/fir/resolve/DoubleColonLHS;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/resolve/DoubleColonLHS;Lorg/jetbrains/kotlin/fir/FirSession;)V", "atom", "getAtom", "()Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;", "expectedType", "getExpectedType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "hasBeenPostponed", "", "getHasBeenPostponed", "()Z", "setHasBeenPostponed", "(Z)V", "hasBeenResolvedOnce", "getHasBeenResolvedOnce", "setHasBeenResolvedOnce", "inputTypes", "", "getInputTypes", "()Ljava/util/Collection;", "getLhs", "()Lorg/jetbrains/kotlin/fir/resolve/DoubleColonLHS;", "mightNeedAdditionalResolution", "getMightNeedAdditionalResolution", "outputType", "getOutputType", "getReference", "resultingReference", "Lorg/jetbrains/kotlin/fir/references/FirNamedReference;", "getResultingReference", "()Lorg/jetbrains/kotlin/fir/references/FirNamedReference;", "setResultingReference", "(Lorg/jetbrains/kotlin/fir/references/FirNamedReference;)V", "resultingTypeForCallableReference", "getResultingTypeForCallableReference", "setResultingTypeForCallableReference", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "<set-?>", "revisedExpectedType", "getRevisedExpectedType", "reviseExpectedType", "", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "resolve"})
public final class ResolvedCallableReferenceAtom
extends PostponedResolvedAtom
implements PostponedCallableReferenceMarker {
    @NotNull
    private final FirCallableReferenceAccess reference;
    @Nullable
    private final ConeKotlinType initialExpectedType;
    @Nullable
    private final DoubleColonLHS lhs;
    @NotNull
    private final FirSession session;
    private boolean hasBeenResolvedOnce;
    private boolean hasBeenPostponed;
    @Nullable
    private FirNamedReference resultingReference;
    @Nullable
    private ConeKotlinType resultingTypeForCallableReference;
    @Nullable
    private ConeKotlinType revisedExpectedType;

    public ResolvedCallableReferenceAtom(@NotNull FirCallableReferenceAccess reference, @Nullable ConeKotlinType initialExpectedType, @Nullable DoubleColonLHS lhs, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        Intrinsics.checkNotNullParameter(session2, "session");
        super(null);
        this.reference = reference;
        this.initialExpectedType = initialExpectedType;
        this.lhs = lhs;
        this.session = session2;
    }

    @NotNull
    public final FirCallableReferenceAccess getReference() {
        return this.reference;
    }

    @Nullable
    public final DoubleColonLHS getLhs() {
        return this.lhs;
    }

    @Override
    @NotNull
    public FirCallableReferenceAccess getAtom() {
        return this.reference;
    }

    public final boolean getHasBeenResolvedOnce() {
        return this.hasBeenResolvedOnce;
    }

    public final void setHasBeenResolvedOnce(boolean bl) {
        this.hasBeenResolvedOnce = bl;
    }

    public final boolean getHasBeenPostponed() {
        return this.hasBeenPostponed;
    }

    public final void setHasBeenPostponed(boolean bl) {
        this.hasBeenPostponed = bl;
    }

    public final boolean getMightNeedAdditionalResolution() {
        return !this.hasBeenResolvedOnce || this.hasBeenPostponed;
    }

    @Nullable
    public final FirNamedReference getResultingReference() {
        return this.resultingReference;
    }

    public final void setResultingReference(@Nullable FirNamedReference firNamedReference) {
        this.resultingReference = firNamedReference;
    }

    @Nullable
    public final ConeKotlinType getResultingTypeForCallableReference() {
        return this.resultingTypeForCallableReference;
    }

    public final void setResultingTypeForCallableReference(@Nullable ConeKotlinType coneKotlinType) {
        this.resultingTypeForCallableReference = coneKotlinType;
    }

    @Override
    @NotNull
    public Collection<ConeKotlinType> getInputTypes() {
        if (!this.hasBeenPostponed) {
            return CollectionsKt.emptyList();
        }
        Object object = PostponedAtomsKt.extractInputOutputTypesFromCallableReferenceExpectedType(this.getExpectedType(), this.session);
        return object != null && (object = ((InputOutputTypes)object).getInputTypes()) != null ? (Collection)object : (Collection)CollectionsKt.listOfNotNull(this.getExpectedType());
    }

    @Override
    @Nullable
    public ConeKotlinType getOutputType() {
        if (!this.hasBeenPostponed) {
            return null;
        }
        InputOutputTypes inputOutputTypes = PostponedAtomsKt.extractInputOutputTypesFromCallableReferenceExpectedType(this.getExpectedType(), this.session);
        return inputOutputTypes != null ? inputOutputTypes.getOutputType() : null;
    }

    @Override
    @Nullable
    public ConeKotlinType getExpectedType() {
        ConeKotlinType coneKotlinType;
        if (!this.hasBeenPostponed) {
            coneKotlinType = this.initialExpectedType;
        } else {
            coneKotlinType = this.getRevisedExpectedType();
            if (coneKotlinType == null) {
                coneKotlinType = this.initialExpectedType;
            }
        }
        return coneKotlinType;
    }

    @Override
    @Nullable
    public ConeKotlinType getRevisedExpectedType() {
        return this.hasBeenPostponed ? this.revisedExpectedType : this.getExpectedType();
    }

    @Override
    public void reviseExpectedType(@NotNull KotlinTypeMarker expectedType) {
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        if (!this.getMightNeedAdditionalResolution()) {
            return;
        }
        if (!(expectedType instanceof ConeKotlinType)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.revisedExpectedType = (ConeKotlinType)expectedType;
    }
}

