/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/NullableExtensionOperatorWithSafeCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "RELEVANT_OPERATORS", "", "Lorg/jetbrains/kotlin/name/Name;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isNullableSafeCallReceiver", "", "receiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "frontend"})
public final class NullableExtensionOperatorWithSafeCallChecker
implements CallChecker {
    @NotNull
    public static final NullableExtensionOperatorWithSafeCallChecker INSTANCE;
    @NotNull
    private static final Set<Name> RELEVANT_OPERATORS;

    private NullableExtensionOperatorWithSafeCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!ArgumentMappingKt.isReallySuccess(resolvedCall2)) {
            return;
        }
        Name name = resolvedCall2.getResultingDescriptor().getName();
        Intrinsics.checkNotNullExpressionValue(name, "resolvedCall.resultingDescriptor.name");
        Name name2 = name;
        if (!RELEVANT_OPERATORS.contains(name2)) {
            return;
        }
        if (!this.isNullableSafeCallReceiver(resolvedCall2.getExtensionReceiver())) {
            return;
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue(ktElement, "resolvedCall.call.callElement");
        KtElement callElement = ktElement;
        if (callElement instanceof KtCallExpression) {
            KtExpression ktExpression = ((KtCallExpression)callElement).getCalleeExpression();
            KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
            if (Intrinsics.areEqual(name2.getIdentifier(), ktNameReferenceExpression != null ? ktNameReferenceExpression.getReferencedName() : null)) {
                return;
            }
        }
        context2.getTrace().report(Errors.NULLABLE_EXTENSION_OPERATOR_WITH_SAFE_CALL_RECEIVER.on(reportOn));
    }

    private final boolean isNullableSafeCallReceiver(ReceiverValue receiverValue) {
        block6: {
            block5: {
                if (!(receiverValue instanceof ExpressionReceiver)) {
                    return false;
                }
                KotlinType kotlinType = ((ExpressionReceiver)receiverValue).getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "receiverValue.type");
                if (!KotlinTypeKt.isNullable(kotlinType)) break block5;
                KotlinType kotlinType2 = ((ExpressionReceiver)receiverValue).getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType2, "receiverValue.type");
                if (!FlexibleTypesKt.isFlexible(kotlinType2)) break block6;
            }
            return false;
        }
        KtExpression expression2 = ((ExpressionReceiver)receiverValue).getExpression();
        if (!(expression2 instanceof KtSafeQualifiedExpression)) {
            return false;
        }
        return !(((KtSafeQualifiedExpression)expression2).getParent() instanceof KtParenthesizedExpression);
    }

    static {
        Set set;
        INSTANCE = new NullableExtensionOperatorWithSafeCallChecker();
        Set $this$RELEVANT_OPERATORS_u24lambda_u2d0 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        $this$RELEVANT_OPERATORS_u24lambda_u2d0.addAll((Collection)OperatorNameConventions.ASSIGNMENT_OPERATIONS);
        $this$RELEVANT_OPERATORS_u24lambda_u2d0.add(OperatorNameConventions.INC);
        $this$RELEVANT_OPERATORS_u24lambda_u2d0.add(OperatorNameConventions.DEC);
        $this$RELEVANT_OPERATORS_u24lambda_u2d0.add(OperatorNameConventions.GET);
        $this$RELEVANT_OPERATORS_u24lambda_u2d0.add(OperatorNameConventions.SET);
        RELEVANT_OPERATORS = set;
    }
}

