/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.tools.Pixel;
import javafx.scene.paint.Color;

public class MatrixIcon {
    public static final Color BACKGROUND = Tile.BACKGROUND.darker();
    private Pixel[][] matrix = new Pixel[][]{{new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND)}, {new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND)}, {new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND)}, {new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND)}, {new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND)}, {new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND)}, {new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND)}, {new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND), new Pixel(BACKGROUND)}};

    public Pixel[][] getMatrix() {
        return this.matrix;
    }

    public Pixel getPixelAt(int X, int Y) {
        if (!this.isValid(X) || !this.isValid(Y)) {
            throw new IllegalArgumentException("x/y values need to be in the range of 0-7");
        }
        return this.matrix[X][Y];
    }

    public void setPixelAt(int X, int Y, Color COLOR) {
        if (!this.isValid(X) || !this.isValid(Y)) {
            throw new IllegalArgumentException("x/y values need to be in the range of 0-7");
        }
        this.matrix[X][Y].setColor(COLOR);
    }

    public void fillPixels(int X_START, int X_END, int Y, Color COLOR) {
        if (!(this.isValid(X_START) && this.isValid(X_END) && this.isValid(Y))) {
            throw new IllegalArgumentException("x/y values need to be in the range of 0-7");
        }
        if (X_START > X_END) {
            throw new IllegalArgumentException("start x cannot be greater than end x");
        }
        for (int x = X_START; x <= X_END; ++x) {
            this.matrix[x][Y].setColor(COLOR);
        }
    }

    public String getCode() {
        StringBuilder code = new StringBuilder().append("MatrixIcon icon = new MatrixIcon();").append("\n");
        int startIndex = -1;
        int endIndex = -1;
        Color lastPixelColor = null;
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                Color nextPixelColor;
                Color currentPixelColor = this.getPixelAt(x, y).getColor();
                Color color = nextPixelColor = x == 7 ? null : this.getPixelAt(x + 1, y).getColor();
                if (currentPixelColor.equals(nextPixelColor)) {
                    if (startIndex == -1) {
                        startIndex = x;
                    }
                } else if (x == 7) {
                    if (currentPixelColor.equals(lastPixelColor)) {
                        if (startIndex > -1) {
                            endIndex = x;
                            code.append("icon.fillPixels(").append(startIndex).append(", ").append(endIndex).append(", ").append(y).append(", Color.web(\"").append(currentPixelColor.toString().replace("0x", "#")).append("\"));\n");
                        } else {
                            code.append("icon.setPixel(").append(x).append(", ").append(y).append(", Color.web(\"").append(currentPixelColor.toString().replace("0x", "#")).append("\"));\n");
                        }
                    } else {
                        code.append("icon.setPixel(").append(x).append(", ").append(y).append(", Color.web(\"").append(currentPixelColor.toString().replace("0x", "#")).append("\"));\n");
                    }
                } else {
                    endIndex = x;
                    if (startIndex == -1) {
                        code.append("icon.setPixel(").append(x).append(", ").append(y).append(", Color.web(\"").append(currentPixelColor.toString().replace("0x", "#")).append("\"));\n");
                    } else {
                        code.append("icon.fillPixels(").append(startIndex).append(", ").append(endIndex).append(", ").append(y).append(", Color.web(\"").append(currentPixelColor.toString().replace("0x", "#")).append("\"));\n");
                        startIndex = -1;
                        endIndex = -1;
                    }
                }
                lastPixelColor = currentPixelColor;
            }
            startIndex = -1;
            endIndex = -1;
            lastPixelColor = null;
        }
        return code.toString();
    }

    private boolean isValid(int VALUE) {
        return VALUE >= 0 && VALUE <= 7;
    }
}

