/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.creole.Stripe;
import net.sourceforge.plantuml.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.creole.legacy.AtomText;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class Fission {
    private final Stripe stripe;
    private final LineBreakStrategy maxWidth;

    public Fission(Stripe stripe, LineBreakStrategy maxWidth) {
        this.stripe = stripe;
        this.maxWidth = Objects.requireNonNull(maxWidth);
    }

    public List<Stripe> getSplitted(StringBounder stringBounder) {
        double valueMaxWidth = this.maxWidth.getMaxWidth();
        if (valueMaxWidth == 0.0) {
            return Arrays.asList(this.stripe);
        }
        ArrayList<StripeSimpleInternal> result = new ArrayList<StripeSimpleInternal>();
        StripeSimpleInternal current = new StripeSimpleInternal(this.stripe.getLHeader());
        double remainingSpace = valueMaxWidth;
        block0: for (Atom atom : this.noHeader()) {
            while (true) {
                List<Atom> splitInTwo = atom.splitInTwo(stringBounder, remainingSpace);
                Atom part1 = splitInTwo.get(0);
                double widthPart1 = part1.calculateDimension(stringBounder).getWidth();
                current.addAtom(part1, widthPart1);
                remainingSpace -= widthPart1;
                if (remainingSpace <= 0.0) {
                    result.add(current);
                    current = new StripeSimpleInternal(Fission.blank(this.stripe.getLHeader()));
                    remainingSpace = valueMaxWidth;
                }
                if (splitInTwo.size() == 1) continue block0;
                atom = splitInTwo.get(1);
                if (!(remainingSpace < valueMaxWidth) || !(atom.calculateDimension(stringBounder).getWidth() > remainingSpace)) continue;
                result.add(current);
                current = new StripeSimpleInternal(Fission.blank(this.stripe.getLHeader()));
                remainingSpace = valueMaxWidth;
            }
        }
        if (remainingSpace < valueMaxWidth) {
            result.add(current);
        }
        return Collections.unmodifiableList(result);
    }

    private List<Atom> noHeader() {
        List<Atom> atoms = this.stripe.getAtoms();
        if (this.stripe.getLHeader() == null) {
            return atoms;
        }
        return atoms.subList(1, atoms.size());
    }

    private static Atom blank(final Atom header) {
        if (header == null) {
            return null;
        }
        return new AbstractAtom(){

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return header.calculateDimension(stringBounder);
            }

            @Override
            public double getStartingAltitude(StringBounder stringBounder) {
                return header.getStartingAltitude(stringBounder);
            }

            @Override
            public void drawU(UGraphic ug) {
            }
        };
    }

    private Collection<? extends Atom> getSplitted(StringBounder stringBounder, Atom atom) {
        if (atom instanceof AtomText) {
            return ((AtomText)atom).getSplitted(stringBounder, this.maxWidth);
        }
        return Collections.singleton(atom);
    }

    static class StripeSimpleInternal
    implements Stripe {
        private final List<Atom> atoms = new ArrayList<Atom>();
        private double totalWidth;

        private StripeSimpleInternal(Atom header) {
            if (header != null) {
                this.atoms.add(header);
            }
        }

        @Override
        public List<Atom> getAtoms() {
            return Collections.unmodifiableList(this.atoms);
        }

        private void addAtom(Atom atom, double width) {
            this.atoms.add(atom);
            this.totalWidth += width;
        }

        @Override
        public Atom getLHeader() {
            return null;
        }
    }
}

