/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.StringUtils;

public enum LeafType {
    EMPTY_PACKAGE,
    ABSTRACT_CLASS,
    CLASS,
    INTERFACE,
    ANNOTATION,
    LOLLIPOP_FULL,
    LOLLIPOP_HALF,
    NOTE,
    TIPS,
    OBJECT,
    MAP,
    JSON,
    ASSOCIATION,
    ENUM,
    CIRCLE,
    USECASE,
    USECASE_BUSINESS,
    DESCRIPTION,
    ARC_CIRCLE,
    ACTIVITY,
    BRANCH,
    SYNCHRO_BAR,
    CIRCLE_START,
    CIRCLE_END,
    POINT_FOR_ASSOCIATION,
    ACTIVITY_CONCURRENT,
    STATE,
    STATE_CONCURRENT,
    PSEUDO_STATE,
    DEEP_HISTORY,
    STATE_CHOICE,
    STATE_FORK_JOIN,
    BLOCK,
    ENTITY,
    DOMAIN,
    REQUIREMENT,
    PORT,
    PORTIN,
    PORTOUT,
    STILL_UNKNOWN;


    public static LeafType getLeafType(String type) {
        if ((type = StringUtils.goUpperCase(type)).startsWith("ABSTRACT")) {
            return ABSTRACT_CLASS;
        }
        if (type.startsWith("DIAMOND")) {
            return STATE_CHOICE;
        }
        return LeafType.valueOf(type);
    }

    public boolean isLikeClass() {
        return this == ANNOTATION || this == ABSTRACT_CLASS || this == CLASS || this == INTERFACE || this == ENUM || this == ENTITY;
    }

    public String toHtml() {
        String html = StringUtils.goLowerCase(this.toString().replace('_', ' '));
        return StringUtils.capitalize(html);
    }
}

