/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;

public class Padder {
    private final double margin;
    private final double padding;
    private final HColor backgroundColor;
    private final HColor borderColor;
    private final double roundCorner;
    public static final Padder NONE = new Padder(0.0, 0.0, null, null, 0.0);

    public String toString() {
        return "" + this.margin + "/" + this.padding + "/" + this.borderColor + "/" + this.backgroundColor;
    }

    private Padder(double margin, double padding, HColor backgroundColor, HColor borderColor, double roundCorner) {
        this.margin = margin;
        this.padding = padding;
        this.borderColor = borderColor;
        this.backgroundColor = backgroundColor;
        this.roundCorner = roundCorner;
    }

    public Padder withMargin(double margin) {
        return new Padder(margin, this.padding, this.backgroundColor, this.borderColor, this.roundCorner);
    }

    public Padder withPadding(double padding) {
        return new Padder(this.margin, padding, this.backgroundColor, this.borderColor, this.roundCorner);
    }

    public Padder withBackgroundColor(HColor backgroundColor) {
        return new Padder(this.margin, this.padding, backgroundColor, this.borderColor, this.roundCorner);
    }

    public Padder withBorderColor(HColor borderColor) {
        return new Padder(this.margin, this.padding, this.backgroundColor, borderColor, this.roundCorner);
    }

    public Padder withRoundCorner(double roundCorner) {
        return new Padder(this.margin, this.padding, this.backgroundColor, this.borderColor, roundCorner);
    }

    public final double getMargin() {
        return this.margin;
    }

    public final double getPadding() {
        return this.padding;
    }

    public final HColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public final HColor getBorderColor() {
        return this.borderColor;
    }

    public TextBlock apply(final TextBlock orig) {
        if (this == NONE) {
            return orig;
        }
        return new AbstractTextBlock(){

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return Dimension2DDouble.delta(orig.calculateDimension(stringBounder), 2.0 * (Padder.this.margin + Padder.this.padding));
            }

            @Override
            public void drawU(UGraphic ug) {
                UGraphic ug2 = ug = ug.apply(new UTranslate(Padder.this.margin, Padder.this.margin));
                ug2 = Padder.this.borderColor == null ? ug2.apply(new HColorNone()) : ug2.apply(Padder.this.borderColor);
                ug2 = Padder.this.backgroundColor == null ? ug2.apply(new HColorNone().bg()) : ug2.apply(Padder.this.backgroundColor.bg());
                Dimension2D originalDim = orig.calculateDimension(ug.getStringBounder());
                URectangle rect = new URectangle(Dimension2DDouble.delta(originalDim, 2.0 * Padder.this.padding)).rounded(Padder.this.roundCorner);
                ug2.draw(rect);
                orig.drawU(ug.apply(new UTranslate(Padder.this.padding, Padder.this.padding)));
            }
        };
    }
}

