/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.timingdiagram.ChangeState;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class PlayerBinary
extends Player {
    private static final String LOW_STRING = "0";
    private static final String HIGH_STRING = "1";
    private final List<TimeConstraint> constraints = new ArrayList<TimeConstraint>();
    private final SortedMap<TimeTick, ChangeState> values = new TreeMap<TimeTick, ChangeState>();
    private ChangeState initialState;
    private final Style style;
    private final double ymargin = 8.0;

    public PlayerBinary(String code, ISkinParam skinParam, TimingRuler ruler, boolean compact) {
        super(code, skinParam, ruler, compact);
        this.style = this.getStyleSignature().getMergedStyle(skinParam.getCurrentStyleBuilder());
        this.suggestedHeight = 30;
    }

    private double getHeightForConstraints(StringBounder stringBounder) {
        return TimeConstraint.getHeightForConstraints(stringBounder, this.constraints);
    }

    @Override
    public double getFullHeight(StringBounder stringBounder) {
        return this.getHeightForConstraints(stringBounder) + (double)this.suggestedHeight;
    }

    @Override
    protected StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram, SName.binary);
    }

    @Override
    protected SymbolContext getContextLegacy() {
        if (!UseStyle.useBetaStyle()) {
            return new SymbolContext(HColorUtils.COL_D7E0F2, HColorUtils.COL_038048).withStroke(new UStroke(2.0));
        }
        HColor lineColor = this.style.value(PName.LineColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
        HColor backgroundColor = this.style.value(PName.BackGroundColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
        return new SymbolContext(backgroundColor, lineColor).withStroke(this.getStroke());
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        double x = this.ruler.getPosInPixel(tick);
        return new IntricatedPoint(new Point2D.Double(x, this.getYpos(stringBounder, HIGH_STRING)), new Point2D.Double(x, this.getYpos(stringBounder, HIGH_STRING)));
    }

    @Override
    public void addNote(TimeTick now, Display note, Position position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void defineState(String stateCode, String label) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setState(TimeTick now, String comment, Colors color, String ... states) {
        ChangeState cs = new ChangeState(now, comment, color, this.convert(states[0]));
        if (now == null) {
            this.initialState = cs;
        } else {
            this.values.put(now, cs);
        }
    }

    private String[] convert(String value) {
        if (HIGH_STRING.equals(value) || "high".equalsIgnoreCase(value)) {
            return new String[]{HIGH_STRING};
        }
        return new String[]{LOW_STRING};
    }

    @Override
    public void createConstraint(TimeTick tick1, TimeTick tick2, String message) {
        this.constraints.add(new TimeConstraint(tick1, tick2, message, this.skinParam));
    }

    private double getYpos(StringBounder stringBounder, String state) {
        if (state.equalsIgnoreCase(LOW_STRING)) {
            return this.getYlow(stringBounder);
        }
        return this.getYhigh(stringBounder);
    }

    private double getYlow(StringBounder stringBounder) {
        return this.getFullHeight(stringBounder) - 8.0;
    }

    private double getYhigh(StringBounder stringBounder) {
        return 8.0 + this.getHeightForConstraints(stringBounder);
    }

    @Override
    public TextBlock getPart1(double fullAvailableWidth, double specialVSpace) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                StringBounder stringBounder = ug.getStringBounder();
                TextBlock title = PlayerBinary.this.getTitle();
                Dimension2D dim = title.calculateDimension(stringBounder);
                double y = (PlayerBinary.this.getFullHeight(stringBounder) - dim.getHeight()) / 2.0;
                title.drawU(ug.apply(UTranslate.dy(y)));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dim = PlayerBinary.this.getTitle().calculateDimension(stringBounder);
                return Dimension2DDouble.delta(dim, 5.0, 0.0);
            }
        };
    }

    @Override
    public UDrawable getPart2() {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                ug = PlayerBinary.this.getContext().apply(ug);
                double lastx = 0.0;
                String lastValue = PlayerBinary.this.initialState == null ? PlayerBinary.LOW_STRING : PlayerBinary.this.initialState.getState();
                StringBounder stringBounder = ug.getStringBounder();
                ULine vline = ULine.vline(PlayerBinary.this.getYlow(stringBounder) - PlayerBinary.this.getYhigh(stringBounder));
                for (Map.Entry ent : PlayerBinary.this.values.entrySet()) {
                    ChangeState value = (ChangeState)ent.getValue();
                    double x = PlayerBinary.this.ruler.getPosInPixel((TimeTick)ent.getKey());
                    ug.apply(new UTranslate(lastx, PlayerBinary.this.getYpos(stringBounder, lastValue))).draw(ULine.hline(x - lastx));
                    if (!lastValue.equalsIgnoreCase(value.getState())) {
                        ug.apply(new UTranslate(x, PlayerBinary.this.getYhigh(stringBounder))).draw(vline);
                    }
                    if (value.getComment() != null) {
                        TextBlock label = PlayerBinary.this.getTextBlock(value.getComment());
                        label.drawU(ug.apply(new UTranslate(x + 2.0, PlayerBinary.this.getYhigh(stringBounder))));
                    }
                    lastx = x;
                    lastValue = value.getState();
                }
                ug.apply(new UTranslate(lastx, PlayerBinary.this.getYpos(stringBounder, lastValue))).draw(ULine.hline(PlayerBinary.this.ruler.getWidth() - lastx));
                PlayerBinary.this.drawConstraints(ug.apply(UTranslate.dy(PlayerBinary.this.getHeightForConstraints(ug.getStringBounder()))));
            }
        };
    }

    protected final FontConfiguration getCommentFontConfiguration() {
        if (!UseStyle.useBetaStyle()) {
            return FontConfiguration.create(this.skinParam, FontParam.TIMING, null);
        }
        return FontConfiguration.create(this.skinParam, this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder()));
    }

    private TextBlock getTextBlock(String value) {
        Display display = Display.getWithNewlines(value);
        return display.create(this.getCommentFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    private void drawConstraints(UGraphic ug) {
        for (TimeConstraint constraint : this.constraints) {
            constraint.drawU(ug, this.ruler);
        }
    }
}

