/* ShowDesktopApplet.c generated by valac 0.56.0, the Vala compiler
 * generated from ShowDesktopApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "showdesktopapplet.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plugin.h"
#include <glib-object.h>
#include <libwnck/libwnck.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <libpeas/peas.h>

enum  {
	SHOW_DESKTOP_PLUGIN_0_PROPERTY,
	SHOW_DESKTOP_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* show_desktop_plugin_properties[SHOW_DESKTOP_PLUGIN_NUM_PROPERTIES];
enum  {
	SHOW_DESKTOP_APPLET_0_PROPERTY,
	SHOW_DESKTOP_APPLET_NUM_PROPERTIES
};
static GParamSpec* show_desktop_applet_properties[SHOW_DESKTOP_APPLET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _ShowDesktopAppletPrivate {
	WnckScreen* wscreen;
	GList* window_list;
};

struct _Block1Data {
	int _ref_count_;
	ShowDesktopApplet* self;
	WnckWindow* window;
};

static gpointer show_desktop_plugin_parent_class = NULL;
static BudgiePluginIface * show_desktop_plugin_budgie_plugin_parent_iface = NULL;
static GType show_desktop_plugin_type_id = 0;
static gint ShowDesktopApplet_private_offset;
static gpointer show_desktop_applet_parent_class = NULL;
static GType show_desktop_applet_type_id = 0;

static BudgieApplet* show_desktop_plugin_real_get_panel_widget (BudgiePlugin* base,
                                                         const gchar* uuid);
static void __lambda4_ (ShowDesktopApplet* self);
static void ___lambda4__wnck_screen_window_opened (WnckScreen* _sender,
                                            WnckWindow* window,
                                            gpointer self);
static void __lambda5_ (ShowDesktopApplet* self);
static void show_desktop_applet_record_windows_state (ShowDesktopApplet* self,
                                               WnckWindow* window);
static void _show_desktop_applet_record_windows_state_gfunc (gconstpointer data,
                                                      gpointer self);
static void show_desktop_applet_unminimize_windows (ShowDesktopApplet* self,
                                             gulong xid);
static void _show_desktop_applet_unminimize_windows_gfunc (gconstpointer data,
                                                    gpointer self);
static void ___lambda5__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                            gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda6_ (Block1Data* _data1_);
static void ___lambda6__wnck_window_state_changed (WnckWindow* _sender,
                                            WnckWindowState changed_mask,
                                            WnckWindowState new_state,
                                            gpointer self);
static void show_desktop_applet_finalize (GObject * obj);

static BudgieApplet*
show_desktop_plugin_real_get_panel_widget (BudgiePlugin* base,
                                           const gchar* uuid)
{
	ShowDesktopPlugin * self;
	ShowDesktopApplet* _tmp0_;
	BudgieApplet* result;
	self = (ShowDesktopPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = show_desktop_applet_new ();
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

ShowDesktopPlugin*
show_desktop_plugin_construct (GType object_type)
{
	ShowDesktopPlugin * self = NULL;
	self = (ShowDesktopPlugin*) g_object_new (object_type, NULL);
	return self;
}

ShowDesktopPlugin*
show_desktop_plugin_new (void)
{
	return show_desktop_plugin_construct (TYPE_SHOW_DESKTOP_PLUGIN);
}

static void
show_desktop_plugin_class_init (ShowDesktopPluginClass * klass,
                                gpointer klass_data)
{
	show_desktop_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
show_desktop_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                                  gpointer iface_data)
{
	show_desktop_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) show_desktop_plugin_real_get_panel_widget;
}

static void
show_desktop_plugin_instance_init (ShowDesktopPlugin * self,
                                   gpointer klass)
{
}

GType
show_desktop_plugin_get_type (void)
{
	return show_desktop_plugin_type_id;
}

GType
show_desktop_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ShowDesktopPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) show_desktop_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ShowDesktopPlugin), 0, (GInstanceInitFunc) show_desktop_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) show_desktop_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	show_desktop_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "ShowDesktopPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, show_desktop_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return show_desktop_plugin_type_id;
}

static inline gpointer
show_desktop_applet_get_instance_private (ShowDesktopApplet* self)
{
	return G_STRUCT_MEMBER_P (self, ShowDesktopApplet_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda4_ (ShowDesktopApplet* self)
{
	GtkToggleButton* _tmp0_;
	(self->priv->window_list == NULL) ? NULL : (self->priv->window_list = (g_list_free (self->priv->window_list), NULL));
	self->priv->window_list = NULL;
	_tmp0_ = self->widget;
	gtk_toggle_button_set_active (_tmp0_, FALSE);
}

static void
___lambda4__wnck_screen_window_opened (WnckScreen* _sender,
                                       WnckWindow* window,
                                       gpointer self)
{
	__lambda4_ ((ShowDesktopApplet*) self);
}

static void
_show_desktop_applet_record_windows_state_gfunc (gconstpointer data,
                                                 gpointer self)
{
	show_desktop_applet_record_windows_state ((ShowDesktopApplet*) self, (WnckWindow*) data);
}

static void
_show_desktop_applet_unminimize_windows_gfunc (gconstpointer data,
                                               gpointer self)
{
	show_desktop_applet_unminimize_windows ((ShowDesktopApplet*) self, (gulong) ((guintptr) data));
}

static void
__lambda5_ (ShowDesktopApplet* self)
{
	GtkToggleButton* _tmp0_;
	_tmp0_ = self->widget;
	if (gtk_toggle_button_get_active (_tmp0_)) {
		WnckScreen* _tmp1_;
		GList* _tmp2_;
		_tmp1_ = self->priv->wscreen;
		_tmp2_ = wnck_screen_get_windows_stacked (_tmp1_);
		g_list_foreach (_tmp2_, _show_desktop_applet_record_windows_state_gfunc, self);
	} else {
		GList* _tmp3_;
		_tmp3_ = self->priv->window_list;
		g_list_foreach (_tmp3_, _show_desktop_applet_unminimize_windows_gfunc, self);
	}
}

static void
___lambda5__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                       gpointer self)
{
	__lambda5_ ((ShowDesktopApplet*) self);
}

ShowDesktopApplet*
show_desktop_applet_construct (GType object_type)
{
	ShowDesktopApplet * self = NULL;
	GtkToggleButton* _tmp0_;
	GtkToggleButton* _tmp1_;
	GtkToggleButton* _tmp2_;
	GtkImage* _tmp3_;
	GtkToggleButton* _tmp4_;
	GtkImage* _tmp5_;
	GtkToggleButton* _tmp6_;
	WnckScreen* _tmp7_;
	WnckScreen* _tmp8_;
	WnckScreen* _tmp9_;
	GtkToggleButton* _tmp10_;
	GtkToggleButton* _tmp11_;
	self = (ShowDesktopApplet*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkToggleButton*) gtk_toggle_button_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->widget);
	self->widget = _tmp0_;
	_tmp1_ = self->widget;
	gtk_button_set_relief ((GtkButton*) _tmp1_, GTK_RELIEF_NONE);
	_tmp2_ = self->widget;
	gtk_toggle_button_set_active (_tmp2_, FALSE);
	_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name ("user-desktop-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->img);
	self->img = _tmp3_;
	_tmp4_ = self->widget;
	_tmp5_ = self->img;
	gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = self->widget;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _ ("Toggle the desktop"));
	(self->priv->window_list == NULL) ? NULL : (self->priv->window_list = (g_list_free (self->priv->window_list), NULL));
	self->priv->window_list = NULL;
	_tmp7_ = wnck_screen_get_default ();
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->priv->wscreen);
	self->priv->wscreen = _tmp8_;
	_tmp9_ = self->priv->wscreen;
	g_signal_connect_object (_tmp9_, "window-opened", (GCallback) ___lambda4__wnck_screen_window_opened, self, 0);
	_tmp10_ = self->widget;
	g_signal_connect_object (_tmp10_, "toggled", (GCallback) ___lambda5__gtk_toggle_button_toggled, self, 0);
	_tmp11_ = self->widget;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp11_);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

ShowDesktopApplet*
show_desktop_applet_new (void)
{
	return show_desktop_applet_construct (TYPE_SHOW_DESKTOP_APPLET);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ShowDesktopApplet* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->window);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda6_ (Block1Data* _data1_)
{
	ShowDesktopApplet* self;
	self = _data1_->self;
	if (!wnck_window_is_minimized (_data1_->window)) {
		GtkToggleButton* _tmp0_;
		(self->priv->window_list == NULL) ? NULL : (self->priv->window_list = (g_list_free (self->priv->window_list), NULL));
		self->priv->window_list = NULL;
		_tmp0_ = self->widget;
		gtk_toggle_button_set_active (_tmp0_, FALSE);
	}
}

static void
___lambda6__wnck_window_state_changed (WnckWindow* _sender,
                                       WnckWindowState changed_mask,
                                       WnckWindowState new_state,
                                       gpointer self)
{
	__lambda6_ (self);
}

static void
show_desktop_applet_record_windows_state (ShowDesktopApplet* self,
                                          WnckWindow* window)
{
	Block1Data* _data1_;
	WnckWindow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data1_->window);
	_data1_->window = _tmp0_;
	if (wnck_window_is_skip_pager (_data1_->window)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = wnck_window_is_skip_tasklist (_data1_->window);
	}
	if (_tmp1_) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	g_signal_connect_data (_data1_->window, "state-changed", (GCallback) ___lambda6__wnck_window_state_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	if (!wnck_window_is_minimized (_data1_->window)) {
		self->priv->window_list = g_list_append (self->priv->window_list, (gpointer) ((guintptr) wnck_window_get_xid (_data1_->window)));
		wnck_window_minimize (_data1_->window);
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
show_desktop_applet_unminimize_windows (ShowDesktopApplet* self,
                                        gulong xid)
{
	WnckWindow* window = NULL;
	WnckWindow* _tmp0_;
	WnckWindow* _tmp1_;
	gboolean _tmp2_ = FALSE;
	WnckWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = wnck_window_get (xid);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	_tmp3_ = window;
	if (_tmp3_ != NULL) {
		WnckWindow* _tmp4_;
		_tmp4_ = window;
		_tmp2_ = wnck_window_is_minimized (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		WnckWindow* _tmp5_;
		_tmp5_ = window;
		wnck_window_unminimize (_tmp5_, gtk_get_current_event_time ());
	}
	_g_object_unref0 (window);
}

static void
show_desktop_applet_class_init (ShowDesktopAppletClass * klass,
                                gpointer klass_data)
{
	show_desktop_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ShowDesktopApplet_private_offset);
	G_OBJECT_CLASS (klass)->finalize = show_desktop_applet_finalize;
}

static void
show_desktop_applet_instance_init (ShowDesktopApplet * self,
                                   gpointer klass)
{
	self->priv = show_desktop_applet_get_instance_private (self);
}

static void
show_desktop_applet_finalize (GObject * obj)
{
	ShowDesktopApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SHOW_DESKTOP_APPLET, ShowDesktopApplet);
	_g_object_unref0 (self->widget);
	_g_object_unref0 (self->img);
	_g_object_unref0 (self->priv->wscreen);
	(self->priv->window_list == NULL) ? NULL : (self->priv->window_list = (g_list_free (self->priv->window_list), NULL));
	G_OBJECT_CLASS (show_desktop_applet_parent_class)->finalize (obj);
}

GType
show_desktop_applet_get_type (void)
{
	return show_desktop_applet_type_id;
}

GType
show_desktop_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ShowDesktopAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) show_desktop_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ShowDesktopApplet), 0, (GInstanceInitFunc) show_desktop_applet_instance_init, NULL };
	show_desktop_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "ShowDesktopApplet", &g_define_type_info, 0);
	ShowDesktopApplet_private_offset = sizeof (ShowDesktopAppletPrivate);
	return show_desktop_applet_type_id;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	show_desktop_plugin_register_type (module);
	show_desktop_applet_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_SHOW_DESKTOP_PLUGIN);
	_g_object_unref0 (objmodule);
}

