/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.RemoteRepository;

public final class DefaultMirrorSelector
implements MirrorSelector {
    private static final String WILDCARD = "*";
    private static final String EXTERNAL_WILDCARD = "external:*";
    private static final String EXTERNAL_HTTP_WILDCARD = "external:http:*";
    private final List<MirrorDef> mirrors = new ArrayList<MirrorDef>();

    @Deprecated
    public DefaultMirrorSelector add(String id, String url, String type2, boolean repositoryManager, String mirrorOfIds, String mirrorOfTypes) {
        return this.add(id, url, type2, repositoryManager, false, mirrorOfIds, mirrorOfTypes);
    }

    public DefaultMirrorSelector add(String id, String url, String type2, boolean repositoryManager, boolean blocked, String mirrorOfIds, String mirrorOfTypes) {
        this.mirrors.add(new MirrorDef(id, url, type2, repositoryManager, blocked, mirrorOfIds, mirrorOfTypes));
        return this;
    }

    @Override
    public RemoteRepository getMirror(RemoteRepository repository) {
        MirrorDef mirror = this.findMirror(repository);
        if (mirror == null) {
            return null;
        }
        RemoteRepository.Builder builder = new RemoteRepository.Builder(mirror.id, repository.getContentType(), mirror.url);
        builder.setRepositoryManager(mirror.repositoryManager);
        builder.setBlocked(mirror.blocked);
        if (mirror.type != null && mirror.type.length() > 0) {
            builder.setContentType(mirror.type);
        }
        builder.setSnapshotPolicy(repository.getPolicy(true));
        builder.setReleasePolicy(repository.getPolicy(false));
        builder.setMirroredRepositories(Collections.singletonList(repository));
        return builder.build();
    }

    private MirrorDef findMirror(RemoteRepository repository) {
        String repoId = repository.getId();
        if (repoId != null && !this.mirrors.isEmpty()) {
            for (MirrorDef mirror : this.mirrors) {
                if (!repoId.equals(mirror.mirrorOfIds) || !DefaultMirrorSelector.matchesType(repository.getContentType(), mirror.mirrorOfTypes)) continue;
                return mirror;
            }
            for (MirrorDef mirror : this.mirrors) {
                if (!DefaultMirrorSelector.matchPattern(repository, mirror.mirrorOfIds) || !DefaultMirrorSelector.matchesType(repository.getContentType(), mirror.mirrorOfTypes)) continue;
                return mirror;
            }
        }
        return null;
    }

    static boolean matchPattern(RemoteRepository repository, String pattern) {
        boolean result = false;
        String originalId = repository.getId();
        if (WILDCARD.equals(pattern) || pattern.equals(originalId)) {
            result = true;
        } else {
            String[] repos;
            for (String repo : repos = pattern.split(",")) {
                if (repo.length() > 1 && repo.startsWith("!")) {
                    if (!repo.substring(1).equals(originalId)) continue;
                    result = false;
                    break;
                }
                if (repo.equals(originalId)) {
                    result = true;
                    break;
                }
                if (EXTERNAL_WILDCARD.equals(repo) && DefaultMirrorSelector.isExternalRepo(repository)) {
                    result = true;
                    continue;
                }
                if (EXTERNAL_HTTP_WILDCARD.equals(repo) && DefaultMirrorSelector.isExternalHttpRepo(repository)) {
                    result = true;
                    continue;
                }
                if (!WILDCARD.equals(repo)) continue;
                result = true;
            }
        }
        return result;
    }

    static boolean isExternalRepo(RemoteRepository repository) {
        boolean local2 = DefaultMirrorSelector.isLocal(repository.getHost()) || "file".equalsIgnoreCase(repository.getProtocol());
        return !local2;
    }

    private static boolean isLocal(String host) {
        return "localhost".equals(host) || "127.0.0.1".equals(host);
    }

    static boolean isExternalHttpRepo(RemoteRepository repository) {
        return ("http".equalsIgnoreCase(repository.getProtocol()) || "dav".equalsIgnoreCase(repository.getProtocol()) || "dav:http".equalsIgnoreCase(repository.getProtocol()) || "dav+http".equalsIgnoreCase(repository.getProtocol())) && !DefaultMirrorSelector.isLocal(repository.getHost());
    }

    static boolean matchesType(String repoType, String mirrorType) {
        boolean result = false;
        if (mirrorType == null || mirrorType.length() <= 0 || WILDCARD.equals(mirrorType)) {
            result = true;
        } else if (mirrorType.equals(repoType)) {
            result = true;
        } else {
            String[] layouts;
            for (String layout : layouts = mirrorType.split(",")) {
                if (layout.length() > 1 && layout.startsWith("!")) {
                    if (!layout.substring(1).equals(repoType)) continue;
                    result = false;
                    break;
                }
                if (layout.equals(repoType)) {
                    result = true;
                    break;
                }
                if (!WILDCARD.equals(layout)) continue;
                result = true;
            }
        }
        return result;
    }

    static class MirrorDef {
        final String id;
        final String url;
        final String type;
        final boolean repositoryManager;
        final boolean blocked;
        final String mirrorOfIds;
        final String mirrorOfTypes;

        MirrorDef(String id, String url, String type2, boolean repositoryManager, boolean blocked, String mirrorOfIds, String mirrorOfTypes) {
            this.id = id;
            this.url = url;
            this.type = type2;
            this.repositoryManager = repositoryManager;
            this.blocked = blocked;
            this.mirrorOfIds = mirrorOfIds;
            this.mirrorOfTypes = mirrorOfTypes;
        }
    }
}

