/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.FreeColClientHolder;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.gui.panel.InfoPanel;
import net.sf.freecol.client.gui.panel.MiniMap;
import net.sf.freecol.client.gui.panel.UnitButton;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.Introspector;
import net.sf.freecol.common.util.StringUtils;

public abstract class MapControls
extends FreeColClientHolder {
    private static final Logger logger = Logger.getLogger(MapControls.class.getName());
    public static final int MINI_MAP_WIDTH = 220;
    public static final int MINI_MAP_HEIGHT = 128;
    public static final int GAP = 4;
    protected final InfoPanel infoPanel;
    protected final MiniMap miniMap;
    protected final UnitButton miniMapToggleBorders;
    protected final UnitButton miniMapToggleFogOfWarButton;
    protected final UnitButton miniMapZoomOutButton;
    protected final UnitButton miniMapZoomInButton;
    protected final List<UnitButton> unitButtons = new ArrayList<UnitButton>();

    protected MapControls(FreeColClient freeColClient, boolean useSkin) {
        super(freeColClient);
        this.infoPanel = new InfoPanel(freeColClient, useSkin);
        this.infoPanel.setFocusable(false);
        this.miniMap = new MiniMap(freeColClient);
        ActionManager am = freeColClient.getActionManager();
        List<UnitButton> miniButtons = am.makeMiniMapButtons();
        for (UnitButton ub : miniButtons) {
            ub.setFocusable(false);
        }
        this.miniMapToggleBorders = miniButtons.remove(0);
        this.miniMapToggleFogOfWarButton = miniButtons.remove(0);
        this.miniMapZoomOutButton = miniButtons.remove(0);
        this.miniMapZoomInButton = miniButtons.remove(0);
    }

    public void updateLayoutIfNeeded() {
        this.infoPanel.updateLayoutIfNeeded();
    }

    protected boolean initializeUnitButtons() {
        if (!this.unitButtons.isEmpty()) {
            return false;
        }
        ActionManager am = this.getFreeColClient().getActionManager();
        this.unitButtons.addAll(am.makeUnitActionButtons(this.getSpecification()));
        return true;
    }

    public abstract List<Component> getComponentsToAdd(Dimension var1);

    public abstract List<Component> getComponentsPresent();

    public boolean canZoomInMapControls() {
        return this.miniMap.canZoomIn();
    }

    public boolean canZoomOutMapControls() {
        return this.miniMap.canZoomOut();
    }

    public void repaint() {
        for (Component c : this.getComponentsPresent()) {
            c.repaint();
        }
    }

    public void update(GUI.ViewMode viewMode, Unit active, Tile tile) {
        boolean iub;
        this.updateLayoutIfNeeded();
        if (active != null && (iub = this.initializeUnitButtons())) {
            logger.fine("Unit buttons initialized.");
        }
        for (UnitButton ub : this.unitButtons) {
            ub.setVisible(active != null);
        }
        switch (viewMode) {
            case MOVE_UNITS: {
                this.infoPanel.update(active);
                break;
            }
            case TERRAIN: {
                this.infoPanel.update(tile);
                break;
            }
            case MAP_TRANSFORM: {
                this.infoPanel.update(this.getFreeColClient().getMapEditorController().getMapTransform());
                break;
            }
            case END_TURN: {
                this.infoPanel.update();
                break;
            }
        }
    }

    public void zoomIn() {
        this.miniMap.zoomIn();
        this.repaint();
    }

    public void zoomOut() {
        this.miniMap.zoomOut();
        this.repaint();
    }

    public static MapControls newInstance(FreeColClient freeColClient) {
        String className = freeColClient.getClientOptions().getString("model.option.mapControls");
        String panelName = "net.sf.freecol.client.gui.panel." + StringUtils.lastPart(className, ".");
        try {
            return (MapControls)Introspector.instantiate(panelName, new Class[]{FreeColClient.class}, new Object[]{freeColClient});
        }
        catch (Introspector.IntrospectorException ie) {
            logger.log(Level.WARNING, "Failed in make map controls for: " + panelName, ie);
            return null;
        }
    }
}

