/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Logger;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.util.CollectionUtils;

public abstract class Session {
    private static final Logger logger = Logger.getLogger(Session.class.getName());
    private static final Map<String, Session> allSessions = new HashMap<String, Session>();
    private String key;
    private boolean completed = false;

    protected Session(String key) {
        Session s = Session.getSession(key);
        if (s != null) {
            throw new IllegalArgumentException("Duplicate session: " + key + " -> " + s);
        }
        this.key = key;
        this.completed = false;
        logger.finest("Created session: " + key);
    }

    public String getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() {
        Map<String, Session> map = allSessions;
        synchronized (map) {
            allSessions.put(this.getKey(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Session getSession(String key) {
        Map<String, Session> map = allSessions;
        synchronized (map) {
            return allSessions.get(key);
        }
    }

    private synchronized boolean isComplete() {
        return this.completed;
    }

    protected synchronized boolean complete(ChangeSet cs) {
        boolean ret = this.completed;
        this.completed = true;
        return ret;
    }

    protected static String makeSessionKey(Class type, String o1, String o2) {
        return o1.compareTo(o2) < 0 ? type + "-" + o1 + "-" + o2 : type + "-" + o2 + "-" + o1;
    }

    protected static String makeSessionKey(Class type, FreeColGameObject o1, FreeColGameObject o2) {
        return Session.makeSessionKey(type, o1.getId(), o2.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void completeAll(ChangeSet cs) {
        List<Session> sessions;
        Map<String, Session> map = allSessions;
        synchronized (map) {
            sessions = CollectionUtils.transform(allSessions.values(), s -> !s.isComplete());
            allSessions.clear();
        }
        for (Session ts : sessions) {
            ts.complete(cs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAll() {
        Map<String, Session> map = allSessions;
        synchronized (map) {
            allSessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session findSession(Predicate<Session> pred) {
        Map<String, Session> map = allSessions;
        synchronized (map) {
            return CollectionUtils.find(allSessions.values(), pred);
        }
    }

    public static <T extends Session> T lookup(Class<T> type, FreeColGameObject o1, FreeColGameObject o2) {
        return Session.lookup(type, o1.getId(), o2.getId());
    }

    public static <T extends Session> T lookup(Class<T> type, String s1, String s2) {
        String key = Session.makeSessionKey(type, s1, s2);
        return Session.lookup(type, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Session> T lookup(Class<T> type, String key) {
        Session ts = Session.getSession(key);
        if (ts != null && ts.isComplete()) {
            Map<String, Session> map = allSessions;
            synchronized (map) {
                allSessions.remove(key);
            }
            ts = null;
        }
        return (T)(ts == null ? null : (Session)type.cast(ts));
    }
}

