/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import jnr.posix.FileStat;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyFile;
import org.jruby.RubyFileStat;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.platform.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.TypeConverter;

@JRubyModule(name={"FileTest"})
public class RubyFileTest {
    public static RubyModule createFileTestModule(Ruby runtime2) {
        RubyModule fileTestModule = runtime2.defineModule("FileTest");
        fileTestModule.defineAnnotatedMethods(RubyFileTest.class);
        return fileTestModule;
    }

    @JRubyMethod(name={"blockdev?"}, required=1, module=true)
    public static IRubyObject blockdev_p(IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(filename2).stat();
        return recv2.getRuntime().newBoolean(stat2 != null && stat2.isBlockDev());
    }

    @JRubyMethod(name={"chardev?"}, required=1, module=true)
    public static IRubyObject chardev_p(IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(filename2).stat();
        return recv2.getRuntime().newBoolean(stat2 != null && stat2.isCharDev());
    }

    @Deprecated
    public static IRubyObject directory_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.directory_p(recv2.getRuntime().getCurrentContext(), recv2, filename2);
    }

    public static IRubyObject directory_p(Ruby ruby, IRubyObject filename2) {
        return RubyFileTest.directory_p(ruby.getCurrentContext(), filename2);
    }

    @JRubyMethod(name={"directory?"}, required=1, module=true)
    public static IRubyObject directory_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.directory_p(context, filename2);
    }

    public static IRubyObject directory_p(ThreadContext context, IRubyObject filename2) {
        if (!(filename2 instanceof RubyIO) && filename2.respondsTo("to_io")) {
            filename2 = TypeConverter.convertToType(filename2, context.runtime.getIO(), "to_io");
        }
        return RubyBoolean.newBoolean(context, RubyFile.fileResource(context, filename2).isDirectory());
    }

    @JRubyMethod(name={"executable?"}, required=1, module=true)
    public static IRubyObject executable_p(IRubyObject recv2, IRubyObject filename2) {
        return recv2.getRuntime().newBoolean(RubyFile.fileResource(filename2).canExecute());
    }

    @JRubyMethod(name={"executable_real?"}, required=1, module=true)
    public static IRubyObject executable_real_p(IRubyObject recv2, IRubyObject filename2) {
        if (recv2.getRuntime().getPosix().isNative()) {
            FileStat stat2 = RubyFile.fileResource(filename2).stat();
            return recv2.getRuntime().newBoolean(stat2 != null && stat2.isExecutableReal());
        }
        return RubyFileTest.executable_p(recv2, filename2);
    }

    @Deprecated
    public static IRubyObject exist_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.exist_p(recv2.getRuntime().getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"exist?", "exists?"}, required=1, module=true)
    public static IRubyObject exist_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return RubyBoolean.newBoolean(context, RubyFileTest.exist(context, RubyFile.get_path(context, filename2)));
    }

    static boolean exist(ThreadContext context, RubyString path2) {
        String pathStr = path2.decodeString();
        if (!Ruby.isSecurityRestricted() && JRubyFile.createResource(context.runtime, pathStr).exists()) {
            return true;
        }
        return RubyFileTest.existsOnClasspath(context, pathStr);
    }

    @Deprecated
    public static RubyBoolean file_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.file_p(recv2.getRuntime().getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"file?"}, required=1, module=true)
    public static RubyBoolean file_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return RubyBoolean.newBoolean(context, RubyFile.fileResource(filename2).isFile());
    }

    @JRubyMethod(name={"grpowned?"}, required=1, module=true)
    public static IRubyObject grpowned_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        FileStat stat2 = RubyFile.fileResource(filename2).stat();
        if (Platform.IS_WINDOWS) {
            return runtime2.getFalse();
        }
        return runtime2.newBoolean(stat2 != null && stat2.isGroupOwned());
    }

    @JRubyMethod(name={"identical?"}, required=2, module=true)
    public static IRubyObject identical_p(IRubyObject recv2, IRubyObject filename1, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        FileResource file1 = RubyFile.fileResource(filename1);
        FileResource file2 = RubyFile.fileResource(filename2);
        if (file1.exists() && file2.exists()) {
            try {
                Path canon1 = new File(file1.absolutePath()).getCanonicalFile().toPath();
                Path canon2 = new File(file2.absolutePath()).getCanonicalFile().toPath();
                return runtime2.newBoolean(Files.isSameFile(canon1, canon2));
            }
            catch (IOException canon1) {
                // empty catch block
            }
        }
        if (Platform.IS_WINDOWS || !runtime2.getPosix().isNative()) {
            return runtime2.getFalse();
        }
        FileStat stat1 = file1.stat();
        FileStat stat2 = file2.stat();
        return runtime2.newBoolean(stat1 != null && stat2 != null && stat1.isIdentical(stat2));
    }

    @JRubyMethod(name={"owned?"}, required=1, module=true)
    public static IRubyObject owned_p(IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(filename2).stat();
        return recv2.getRuntime().newBoolean(stat2 != null && stat2.isOwned());
    }

    @JRubyMethod(name={"pipe?"}, required=1, module=true)
    public static IRubyObject pipe_p(IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(filename2).stat();
        return recv2.getRuntime().newBoolean(stat2 != null && stat2.isNamedPipe());
    }

    @Deprecated
    public static IRubyObject readable_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.readable_p(recv2.getRuntime().getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"readable?", "readable_real?"}, required=1, module=true)
    public static IRubyObject readable_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = context.runtime;
        if (!(filename2 instanceof RubyFile)) {
            filename2 = RubyFile.get_path(context, filename2);
        }
        return runtime2.newBoolean(RubyFile.fileResource(filename2).canRead());
    }

    public static IRubyObject rowned_p(IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(filename2).stat();
        return recv2.getRuntime().newBoolean(stat2 != null && stat2.isROwned());
    }

    @JRubyMethod(name={"setgid?"}, required=1, module=true)
    public static IRubyObject setgid_p(IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(filename2).stat();
        return recv2.getRuntime().newBoolean(stat2 != null && stat2.isSetgid());
    }

    @JRubyMethod(name={"setuid?"}, required=1, module=true)
    public static IRubyObject setuid_p(IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(filename2).stat();
        return recv2.getRuntime().newBoolean(stat2 != null && stat2.isSetuid());
    }

    public static IRubyObject size(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.size(recv2.getRuntime().getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"size"}, required=1, module=true)
    public static IRubyObject size(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2;
        if (!(filename2 instanceof RubyFile) && filename2.respondsTo("to_io")) {
            filename2 = TypeConverter.convertToType(filename2, context.runtime.getIO(), "to_io");
        }
        if ((stat2 = RubyFile.fileResource(filename2).stat()) == null) {
            RubyFileTest.noFileError(filename2);
        }
        return context.runtime.newFixnum(stat2.st_size());
    }

    @Deprecated
    public static IRubyObject size_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.size_p(recv2.getRuntime().getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"size?"}, required=1, module=true)
    public static IRubyObject size_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2;
        Ruby runtime2 = context.runtime;
        if (!(filename2 instanceof RubyFile) && filename2.respondsTo("to_io")) {
            filename2 = TypeConverter.convertToType(filename2, runtime2.getIO(), "to_io");
        }
        if ((stat2 = RubyFile.fileResource(filename2).stat()) == null) {
            return runtime2.getNil();
        }
        long length2 = stat2.st_size();
        return length2 > 0L ? runtime2.newFixnum(length2) : runtime2.getNil();
    }

    @JRubyMethod(name={"socket?"}, required=1, module=true)
    public static IRubyObject socket_p(IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(filename2).stat();
        return recv2.getRuntime().newBoolean(stat2 != null && stat2.isSocket());
    }

    @JRubyMethod(name={"sticky?"}, required=1, module=true)
    public static IRubyObject sticky_p(IRubyObject recv2, IRubyObject filename2) {
        FileStat stat2 = RubyFile.fileResource(filename2).stat();
        return recv2.getRuntime().newBoolean(stat2 != null && stat2.isSticky());
    }

    @JRubyMethod(name={"symlink?"}, required=1, module=true)
    public static RubyBoolean symlink_p(IRubyObject recv2, IRubyObject filename2) {
        return recv2.getRuntime().newBoolean(RubyFile.fileResource(filename2).isSymLink());
    }

    @JRubyMethod(name={"writable?", "writable_real?"}, required=1, module=true)
    public static RubyBoolean writable_p(IRubyObject recv2, IRubyObject filename2) {
        return filename2.getRuntime().newBoolean(RubyFile.fileResource(filename2).canWrite());
    }

    @Deprecated
    public static RubyBoolean zero_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.zero_p(recv2.getRuntime().getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"empty?", "zero?"}, required=1, module=true)
    public static RubyBoolean zero_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        FileResource resource2 = RubyFile.fileResource(context, filename2);
        if (resource2.isNull()) {
            return RubyBoolean.newBoolean(context, true);
        }
        FileStat stat2 = resource2.stat();
        if (stat2 == null) {
            return context.fals;
        }
        if (stat2.isDirectory()) {
            return RubyBoolean.newBoolean(context, Platform.IS_WINDOWS);
        }
        return RubyBoolean.newBoolean(context, stat2.st_size() == 0L);
    }

    @JRubyMethod(name={"world_readable?"}, required=1, module=true)
    public static IRubyObject worldReadable(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        RubyFileStat stat2 = RubyFileTest.getRubyFileStat(context, filename2);
        return stat2 == null ? context.nil : stat2.worldReadable(context);
    }

    @JRubyMethod(name={"world_writable?"}, required=1, module=true)
    public static IRubyObject worldWritable(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        RubyFileStat stat2 = RubyFileTest.getRubyFileStat(context, filename2);
        return stat2 == null ? context.nil : stat2.worldWritable(context);
    }

    private static RubyFileStat getRubyFileStat(ThreadContext context, IRubyObject filename2) {
        Ruby runtime2 = context.runtime;
        RubyFileStat stat2 = null;
        if (!(filename2 instanceof RubyFile)) {
            RubyString path2 = RubyFile.get_path(context, filename2);
            FileResource file2 = JRubyFile.createResource(runtime2, path2.getUnicodeValue());
            if (file2.exists()) {
                stat2 = runtime2.newFileStat(file2.absolutePath(), false);
            }
        } else {
            stat2 = (RubyFileStat)((RubyFile)filename2).stat(context);
        }
        return stat2;
    }

    private static boolean existsOnClasspath(ThreadContext context, String path2) {
        if (path2.startsWith("classpath:/")) {
            InputStream is;
            path2 = path2.substring("classpath:/".length());
            ClassLoader classLoader = context.runtime.getJRubyClassLoader();
            if (classLoader == null && Ruby.isSecurityRestricted()) {
                classLoader = context.runtime.getInstanceConfig().getLoader();
            }
            if ((is = ((ClassLoader)classLoader).getResourceAsStream(path2)) != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                return true;
            }
        }
        return false;
    }

    private static void noFileError(IRubyObject filename2) {
        throw filename2.getRuntime().newErrnoENOENTError("No such file or directory - " + filename2.convertToString());
    }

    public static class FileTestFileMethods {
        @JRubyMethod(name={"blockdev?"}, required=1)
        public static IRubyObject blockdev_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.blockdev_p(recv2, filename2);
        }

        @JRubyMethod(name={"chardev?"}, required=1)
        public static IRubyObject chardev_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.chardev_p(recv2, filename2);
        }

        @JRubyMethod(name={"directory?"}, required=1)
        public static IRubyObject directory_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.directory_p(context, recv2, filename2);
        }

        @JRubyMethod(name={"executable?"}, required=1)
        public static IRubyObject executable_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.executable_p(recv2, filename2);
        }

        @JRubyMethod(name={"executable_real?"}, required=1)
        public static IRubyObject executable_real_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.executable_real_p(recv2, filename2);
        }

        @JRubyMethod(name={"exist?", "exists?"}, required=1)
        public static IRubyObject exist_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.exist_p(context, recv2, filename2);
        }

        @JRubyMethod(name={"file?"}, required=1)
        public static RubyBoolean file_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.file_p(context, recv2, filename2);
        }

        @JRubyMethod(name={"grpowned?"}, required=1)
        public static IRubyObject grpowned_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.grpowned_p(recv2, filename2);
        }

        @JRubyMethod(name={"identical?"}, required=2)
        public static IRubyObject identical_p(IRubyObject recv2, IRubyObject filename1, IRubyObject filename2) {
            return RubyFileTest.identical_p(recv2, filename1, filename2);
        }

        @JRubyMethod(name={"owned?"}, required=1)
        public static IRubyObject owned_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.owned_p(recv2, filename2);
        }

        @JRubyMethod(name={"pipe?"}, required=1)
        public static IRubyObject pipe_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.pipe_p(recv2, filename2);
        }

        @JRubyMethod(name={"readable?", "readable_real?"}, required=1)
        public static IRubyObject readable_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.readable_p(context, recv2, filename2);
        }

        @JRubyMethod(name={"setgid?"}, required=1)
        public static IRubyObject setgid_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.setgid_p(recv2, filename2);
        }

        @JRubyMethod(name={"setuid?"}, required=1)
        public static IRubyObject setuid_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.setuid_p(recv2, filename2);
        }

        @JRubyMethod(name={"size"}, required=1)
        public static IRubyObject size(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.size(context, recv2, filename2);
        }

        @JRubyMethod(name={"size?"}, required=1)
        public static IRubyObject size_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.size_p(context, recv2, filename2);
        }

        @JRubyMethod(name={"socket?"}, required=1)
        public static IRubyObject socket_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.socket_p(recv2, filename2);
        }

        @JRubyMethod(name={"sticky?"}, required=1)
        public static IRubyObject sticky_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.sticky_p(recv2, filename2);
        }

        @JRubyMethod(name={"symlink?"}, required=1)
        public static RubyBoolean symlink_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.symlink_p(recv2, filename2);
        }

        @JRubyMethod(name={"writable?", "writable_real?"}, required=1)
        public static RubyBoolean writable_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.writable_p(recv2, filename2);
        }

        @JRubyMethod(name={"empty?", "zero?"}, required=1)
        public static RubyBoolean zero_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.zero_p(context, recv2, filename2);
        }

        @JRubyMethod(name={"world_readable?"}, required=1)
        public static IRubyObject worldReadable(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.worldReadable(context, recv2, filename2);
        }

        @JRubyMethod(name={"world_writable?"}, required=1)
        public static IRubyObject worldWritable(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.worldWritable(context, recv2, filename2);
        }
    }
}

