/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.javafx;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class EventObservableList<E>
extends AbstractList<E>
implements ObservableList<E>,
ListEventListener<E> {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private final EventList<E> source;
    private final List<InvalidationListener> invalidation_listeners = new ArrayList<InvalidationListener>();
    private final List<ListChangeListener> list_listeners = new ArrayList<ListChangeListener>();
    private boolean disposed = false;

    public EventObservableList(EventList<E> source2) {
        this.source = source2;
        source2.addListEventListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.source.removeListEventListener(this);
        List<ListChangeListener> list = this.list_listeners;
        synchronized (list) {
            this.list_listeners.clear();
        }
        list = this.invalidation_listeners;
        synchronized (list) {
            this.invalidation_listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ListChangeListener<? super E> listener) {
        List<ListChangeListener> list = this.list_listeners;
        synchronized (list) {
            this.list_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ListChangeListener<? super E> listener) {
        List<ListChangeListener> list = this.list_listeners;
        synchronized (list) {
            this.list_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(InvalidationListener listener) {
        List<InvalidationListener> list = this.invalidation_listeners;
        synchronized (list) {
            this.invalidation_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(InvalidationListener listener) {
        List<InvalidationListener> list = this.invalidation_listeners;
        synchronized (list) {
            this.invalidation_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(E ... es) {
        this.source.getReadWriteLock().writeLock().lock();
        try {
            boolean bl = this.source.addAll(Arrays.asList(es));
            return bl;
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    public boolean setAll(E ... es) {
        return this.setAll((Collection<? extends E>)Arrays.asList(es));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAll(Collection<? extends E> es) {
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.clear();
            this.addAll(es);
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
        return true;
    }

    public boolean removeAll(E ... es) {
        return this.removeAll((Collection<?>)Arrays.asList(es));
    }

    public boolean retainAll(E ... es) {
        return this.retainAll((Collection<?>)Arrays.asList(es));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int from, int to) {
        this.source.getReadWriteLock().writeLock().lock();
        try {
            if (to - from <= 0) {
                return;
            }
            for (int i = to - 1; i >= from; --i) {
                this.remove(i);
            }
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            int n = this.source.size();
            return n;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            boolean bl = this.source.isEmpty();
            return bl;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        this.source.getReadWriteLock().readLock().lock();
        try {
            boolean bl = this.source.contains(o);
            return bl;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            Iterator iterator2 = this.source.iterator();
            return iterator2;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            Object[] objectArray = this.source.toArray();
            return objectArray;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        this.source.getReadWriteLock().readLock().lock();
        try {
            T[] TArray = this.source.toArray(a);
            return TArray;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        this.source.getReadWriteLock().writeLock().lock();
        try {
            boolean bl = this.source.add(e);
            return bl;
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        this.source.getReadWriteLock().writeLock().lock();
        try {
            boolean bl = this.source.remove(o);
            return bl;
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        this.source.getReadWriteLock().readLock().lock();
        try {
            boolean bl = this.source.containsAll(c);
            return bl;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.source.getReadWriteLock().writeLock().lock();
        try {
            boolean bl = this.source.addAll(c);
            return bl;
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.source.getReadWriteLock().writeLock().lock();
        try {
            boolean bl = this.source.addAll(index, c);
            return bl;
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        this.source.getReadWriteLock().writeLock().lock();
        try {
            boolean bl = this.source.removeAll(c);
            return bl;
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        this.source.getReadWriteLock().writeLock().lock();
        try {
            boolean bl = this.source.retainAll(c);
            return bl;
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.source.clear();
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int index) {
        this.source.getReadWriteLock().readLock().lock();
        try {
            Object e = this.source.get(index);
            return e;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        this.source.getReadWriteLock().writeLock().lock();
        try {
            E e = this.source.set(index, element);
            return e;
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E element) {
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.source.add(index, element);
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        this.source.getReadWriteLock().writeLock().lock();
        try {
            Object e = this.source.remove(index);
            return e;
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object o) {
        this.source.getReadWriteLock().readLock().lock();
        try {
            int n = this.source.indexOf(o);
            return n;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object o) {
        this.source.getReadWriteLock().readLock().lock();
        try {
            int n = this.source.lastIndexOf(o);
            return n;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<E> listIterator() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            ListIterator listIterator = this.source.listIterator();
            return listIterator;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<E> listIterator(int index) {
        this.source.getReadWriteLock().readLock().lock();
        try {
            ListIterator listIterator = this.source.listIterator(index);
            return listIterator;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        this.source.getReadWriteLock().readLock().lock();
        try {
            List list = this.source.subList(fromIndex, toIndex);
            return list;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listChanged(ListEvent<E> source_changes) {
        int i;
        List<InvalidationListener> list = this.invalidation_listeners;
        synchronized (list) {
            for (i = this.invalidation_listeners.size() - 1; i >= 0; --i) {
                this.invalidation_listeners.get(i).invalidated((Observable)this);
            }
        }
        list = this.list_listeners;
        synchronized (list) {
            for (i = this.list_listeners.size() - 1; i >= 0; --i) {
                ListEvent<E> changes_to_distribute = source_changes.copy();
                ListChangeListener.Change change = source_changes.isReordering() ? new GLReorderChangeWrapper(this, changes_to_distribute) : new GLChangeWrapper(this, changes_to_distribute);
                this.list_listeners.get(i).onChanged(change);
            }
        }
    }

    class GLChangeWrapper
    extends ListChangeListener.Change<E> {
        private final ListEvent<E> changes;

        public GLChangeWrapper(ObservableList<E> es, ListEvent<E> changes) {
            super(es);
            this.changes = changes;
        }

        public boolean next() {
            return this.changes.nextBlock();
        }

        public void reset() {
            this.changes.reset();
        }

        public int getFrom() {
            return this.changes.getBlockStartIndex();
        }

        public int getTo() {
            return this.changes.getBlockEndIndex() + 1;
        }

        public List<E> getRemoved() {
            return Collections.singletonList(this.changes.getOldValue());
        }

        public boolean wasReplaced() {
            return this.changes.getType() == 1;
        }

        public boolean wasRemoved() {
            return this.changes.getType() == 0;
        }

        public boolean wasAdded() {
            return this.changes.getType() == 2;
        }

        protected int[] getPermutation() {
            return EMPTY_INT_ARRAY;
        }

        public String toString() {
            return "GLChangeWrapper{changes=" + this.changes + " (" + System.identityHashCode(this.changes) + ")}";
        }
    }

    class GLReorderChangeWrapper
    extends ListChangeListener.Change<E> {
        private final int[] reorder_map;
        private boolean processed;

        public GLReorderChangeWrapper(ObservableList<E> es, ListEvent<E> changes) {
            super(es);
            this.processed = false;
            int[] gl_reorder_map = changes.getReorderMap();
            this.reorder_map = new int[gl_reorder_map.length];
            for (int i = 0; i < gl_reorder_map.length; ++i) {
                this.reorder_map[gl_reorder_map[i]] = i;
            }
        }

        public boolean next() {
            if (this.processed) {
                return false;
            }
            this.processed = true;
            return true;
        }

        public void reset() {
            this.processed = false;
        }

        public int getFrom() {
            return 0;
        }

        public int getTo() {
            return this.reorder_map.length;
        }

        public List<E> getRemoved() {
            return Collections.emptyList();
        }

        protected int[] getPermutation() {
            return this.reorder_map;
        }

        public String toString() {
            return "GLReorderChangeWrapper{reorder_map=" + Arrays.toString(this.reorder_map) + ", processed=" + this.processed + '}';
        }
    }
}

