/*
 * Decompiled with CFR 0.152.
 */
package mediathek;

import java.io.IOException;
import java.net.URL;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import mediathek.Main;
import mediathek.config.Konstanten;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.tool.TimerPool;
import mediathek.tool.UIProgressState;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SplashScreen {
    private static final Logger LOG = LogManager.getLogger(SplashScreen.class);
    private static final double MAXIMUM_STEPS = (double)EnumSet.allOf(UIProgressState.class).size() - 1.0;
    @FXML
    private Label appName;
    @FXML
    private Label appVersion;
    @FXML
    private Label progressText;
    @FXML
    private ProgressBar progressBar;
    private double curSteps;
    private Stage window;

    private String getOsName() {
        String osName = SystemUtils.IS_OS_MAC_OSX ? "macOS" : SystemUtils.OS_NAME;
        return osName;
    }

    public void show() {
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            this.window = new Stage(StageStyle.UNDECORATED);
            this.window.getIcons().add((Object)new Image("/mediathek/res/MediathekView.png"));
            URL url = this.getClass().getResource("/mediathek/res/programm/fxml/splashscreen.fxml");
            FXMLLoader fxmlLoader = new FXMLLoader();
            fxmlLoader.setLocation(url);
            fxmlLoader.setController((Object)this);
            try {
                Scene scene = new Scene((Parent)fxmlLoader.load());
                this.window.setScene(scene);
                this.appName.setText("MediathekView");
                this.appVersion.setText("Version: " + Konstanten.MVVERSION + " (" + this.getOsName() + ")");
                this.progressBar.prefWidthProperty().bind((ObservableValue)scene.widthProperty());
                this.window.setScene(scene);
                this.window.show();
                this.window.centerOnScreen();
            }
            catch (IOException ioException) {
                LOG.error("Can't find/load the splash screen FXML description!", (Throwable)ioException);
            }
        });
    }

    public void close() {
        TimerPool.getTimerPool().schedule(() -> JavaFxUtils.invokeInFxThreadAndWait(() -> {
            this.window.close();
            Main.splashScreen = Optional.empty();
        }), 2L, TimeUnit.SECONDS);
    }

    public void update(UIProgressState state) {
        Platform.runLater(() -> {
            this.curSteps += 1.0;
            double p = this.curSteps / MAXIMUM_STEPS;
            this.progressBar.setProgress(p);
            this.progressText.setText(state.toString());
        });
    }
}

