/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten.abo;

import java.util.function.BiConsumer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import mediathek.daten.abo.AboTags;
import mediathek.daten.abo.FilmLengthState;
import mediathek.tool.GermanStringSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DatenAbo
implements Comparable<DatenAbo> {
    public static final int ABO_NR = 0;
    public static final int ABO_EINGESCHALTET = 1;
    public static final int ABO_NAME = 2;
    public static final int ABO_SENDER = 3;
    public static final int ABO_THEMA = 4;
    public static final int ABO_TITEL = 5;
    public static final int ABO_THEMA_TITEL = 6;
    public static final int ABO_IRGENDWO = 7;
    public static final int ABO_MINDESTDAUER = 8;
    public static final int ABO_MIN = 9;
    public static final int ABO_ZIELPFAD = 10;
    public static final int ABO_DOWN_DATUM = 11;
    public static final int ABO_PSET = 12;
    public static final int ABO_REF = 13;
    public static final String[] COLUMN_NAMES = new String[]{"Nr", "aktiv", "Name", "Sender", "Thema", "Titel", "Thema-Titel", "Irgendwo", "Dauer", "min/max", "Zielpfad", "letztes Abo", "Programmset", ""};
    public static final int MAX_ELEM = 14;
    public static final String TAG = "Abonnement";
    private static final Logger logger = LogManager.getLogger(DatenAbo.class);
    private static final GermanStringSorter sorter = GermanStringSorter.getInstance();
    public static boolean[] spaltenAnzeigen = new boolean[14];
    private String[] irgendwoFilterPattern;
    private String[] themaFilterPattern;
    private String[] titelFilterPattern;
    private int mindestdauerMinuten = 0;
    private int nr;
    private boolean active = true;
    private String name = "";
    private String sender = "";
    private String thema = "";
    private String titel = "";
    private String thema_titel = "";
    private String irgendwo = "";
    private String zielpfad = "";
    private String down_datum = "";
    private String pSetName = "";
    private FilmLengthState filmLengthState = FilmLengthState.MINIMUM;

    public static boolean anzeigen(int i) {
        return spaltenAnzeigen == null || spaltenAnzeigen[i];
    }

    public String[] getTitelFilterPattern() {
        return this.titelFilterPattern;
    }

    public void setTitelFilterPattern(String[] titelFilterPattern) {
        this.titelFilterPattern = titelFilterPattern;
    }

    public String[] getThemaFilterPattern() {
        return this.themaFilterPattern;
    }

    public void setThemaFilterPattern(String[] themaFilterPattern) {
        this.themaFilterPattern = themaFilterPattern;
    }

    public String[] getIrgendwoFilterPattern() {
        return this.irgendwoFilterPattern;
    }

    public void setIrgendwoFilterPattern(String[] irgendwoFilterPattern) {
        this.irgendwoFilterPattern = irgendwoFilterPattern;
    }

    public int getMindestDauerMinuten() {
        return this.mindestdauerMinuten;
    }

    public final void setMindestDauerMinuten(int dauer) {
        this.mindestdauerMinuten = dauer;
    }

    public FilmLengthState getFilmLengthState() {
        return this.filmLengthState;
    }

    public void setFilmLengthState(FilmLengthState filmLengthState) {
        this.filmLengthState = filmLengthState;
    }

    public String getPsetName() {
        return this.pSetName;
    }

    public void setPsetName(String pset) {
        this.pSetName = pset;
    }

    public String getDownDatum() {
        return this.down_datum;
    }

    public void setDownDatum(String datum) {
        this.down_datum = datum;
    }

    public String getZielpfad() {
        return this.zielpfad;
    }

    public void setZielpfad(String ziel) {
        this.zielpfad = ziel;
    }

    public String getIrgendwo() {
        return this.irgendwo;
    }

    public void setIrgendwo(String irgendwo) {
        this.irgendwo = irgendwo;
    }

    public String getThemaTitel() {
        return this.thema_titel;
    }

    public void setThemaTitel(String themaTitel) {
        this.thema_titel = themaTitel;
    }

    public String getTitle() {
        return this.titel;
    }

    public void setTitle(String titel) {
        this.titel = titel;
    }

    public String getThema() {
        return this.thema;
    }

    public void setThema(String thema) {
        this.thema = thema;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNr() {
        return this.nr;
    }

    public void setNr(int nr) {
        this.nr = nr;
    }

    public DatenAbo getCopy() {
        DatenAbo ret = new DatenAbo();
        ret.mindestdauerMinuten = this.mindestdauerMinuten;
        ret.filmLengthState = this.filmLengthState;
        ret.active = this.active;
        ret.name = this.name;
        ret.sender = this.sender;
        ret.thema = this.thema;
        ret.titel = this.titel;
        ret.thema_titel = this.thema_titel;
        ret.down_datum = this.down_datum;
        ret.zielpfad = this.zielpfad;
        ret.pSetName = this.pSetName;
        ret.irgendwo = this.irgendwo;
        return ret;
    }

    public boolean isInvalid() {
        return this.getSender().isEmpty() && this.getThema().isEmpty() && this.getTitle().isEmpty() && this.getThemaTitel().isEmpty() && this.getIrgendwo().isEmpty();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void writeToConfig(@NotNull XMLStreamWriter writer) {
        BiConsumer<String, String> writeElement = (tagName, content) -> {
            try {
                writer.writeCharacters("\t");
                writer.writeStartElement((String)tagName);
                writer.writeCharacters((String)content);
                writer.writeEndElement();
                writer.writeCharacters("\n");
            }
            catch (XMLStreamException e) {
                logger.error("writeElement failed", (Throwable)e);
            }
        };
        try {
            writer.writeStartElement(TAG);
            writer.writeCharacters("\n");
            writeElement.accept(AboTags.EINGESCHALTET.getXmlName(), Boolean.toString(this.isActive()));
            writeElement.accept(AboTags.NAME.getXmlName(), this.getName());
            writeElement.accept(AboTags.SENDER.getXmlName(), this.getSender());
            writeElement.accept(AboTags.THEMA.getXmlName(), this.getThema());
            writeElement.accept(AboTags.TITEL.getXmlName(), this.getTitle());
            writeElement.accept(AboTags.THEMA_TITEL.getXmlName(), this.getThemaTitel());
            writeElement.accept(AboTags.IRGENDWO.getXmlName(), this.getIrgendwo());
            writeElement.accept(AboTags.MINDESTDAUER.getXmlName(), Integer.toString(this.getMindestDauerMinuten()));
            writeElement.accept(AboTags.MIN.getXmlName(), Boolean.toString(this.getFilmLengthState() == FilmLengthState.MINIMUM));
            writeElement.accept(AboTags.ZIELPFAD.getXmlName(), this.getZielpfad());
            writeElement.accept(AboTags.DOWN_DATUM.getXmlName(), this.getDownDatum());
            writeElement.accept(AboTags.PSET.getXmlName(), this.getPsetName());
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        catch (Exception ex) {
            logger.error("writeToConfig", (Throwable)ex);
        }
    }

    public void readFromConfig(@NotNull XMLStreamReader parser) throws XMLStreamException, AssertionError {
        int event;
        while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(TAG))) {
            if (event != 1) continue;
            AboTags.fromXmlTag(parser.getLocalName()).ifPresent(tag -> {
                try {
                    String text = parser.getElementText();
                    switch (tag) {
                        case EINGESCHALTET: {
                            this.setActive(Boolean.parseBoolean(text));
                            break;
                        }
                        case MIN: {
                            if (Boolean.parseBoolean(text)) {
                                this.setFilmLengthState(FilmLengthState.MINIMUM);
                                break;
                            }
                            this.setFilmLengthState(FilmLengthState.MAXIMUM);
                            break;
                        }
                        case NAME: {
                            this.setName(text);
                            break;
                        }
                        case SENDER: {
                            this.setSender(text);
                            break;
                        }
                        case THEMA: {
                            this.setThema(text);
                            break;
                        }
                        case TITEL: {
                            this.setTitle(text);
                            break;
                        }
                        case THEMA_TITEL: {
                            this.setThemaTitel(text);
                            break;
                        }
                        case IRGENDWO: {
                            this.setIrgendwo(text);
                            break;
                        }
                        case MINDESTDAUER: {
                            this.setMindestDauerMinuten(Integer.parseInt(text));
                            break;
                        }
                        case ZIELPFAD: {
                            this.setZielpfad(text);
                            break;
                        }
                        case DOWN_DATUM: {
                            this.setDownDatum(text);
                            break;
                        }
                        case PSET: {
                            this.setPsetName(text);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)"Illegal tag detected");
                        }
                    }
                }
                catch (XMLStreamException e) {
                    logger.error("Error reading abo entry", (Throwable)e);
                }
            });
        }
    }

    @Override
    public int compareTo(@NotNull DatenAbo other) {
        return sorter.compare(this.getName(), other.getName());
    }
}

