/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx;

import java.util.EnumSet;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import mediathek.javafx.tool.JFXHiddenApplication;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ShutdownState;
import org.tbee.javafx.scene.layout.MigPane;

public class ShutdownDialog {
    private static final double MAXIMUM_STEPS = EnumSet.allOf(ShutdownState.class).size();
    private final MediathekGui gui;
    private Label lblStatusText;
    private Stage stage;
    private ProgressBar progress;
    private boolean hidden;
    private double curSteps;

    public ShutdownDialog(MediathekGui gui) {
        this.gui = gui;
        Platform.runLater(() -> {
            this.stage = new Stage();
            this.stage.setOnHidden(e -> {
                this.hidden = true;
            });
            this.stage.setAlwaysOnTop(true);
            this.stage.initOwner((Window)JFXHiddenApplication.getPrimaryStage());
            this.stage.setResizable(false);
            this.stage.setOnCloseRequest(Event::consume);
            this.stage.initStyle(StageStyle.UNDECORATED);
            this.stage.setTitle("Programm beenden");
            this.stage.setScene(this.createScene());
        });
    }

    public void show() {
        Platform.runLater(() -> {
            this.stage.show();
            this.stage.centerOnScreen();
        });
        this.gui.setEnabled(false);
    }

    public void hide() {
        Platform.runLater(() -> {
            if (!this.hidden) {
                this.stage.hide();
            }
        });
        this.gui.setEnabled(true);
    }

    public void setStatusText(ShutdownState state) {
        Platform.runLater(() -> {
            this.curSteps += 1.0;
            double p = this.curSteps / MAXIMUM_STEPS;
            this.progress.setProgress(p);
            this.lblStatusText.setText(state.toString());
        });
    }

    private Scene createScene() {
        MigPane migPane = new MigPane("hidemode 3", "[fill][fill]", "[][][]");
        this.progress = new ProgressBar();
        this.progress.setProgress(0.0);
        this.progress.setPrefWidth(450.0);
        this.progress.setMinWidth(350.0);
        migPane.add((Node)new ProgressIndicator(), "cell 0 0 1 3");
        this.lblStatusText = new Label("Offene Operationen m\u00fcssen noch beendet werden.");
        migPane.add((Node)this.lblStatusText, "cell 1 0");
        migPane.add((Node)this.progress, "cell 1 1");
        migPane.add((Node)new Label(""), "cell 1 2");
        return new Scene((Parent)migPane);
    }
}

