/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.bookmark;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextArea;
import javafx.stage.Stage;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.javafx.bookmark.BookmarkData;
import mediathek.tool.http.MVHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class BookmarkNoteDialog
implements Initializable {
    @FXML
    private DatePicker fxDate;
    @FXML
    private TextArea fxNote;
    @FXML
    protected Button SaveButton;
    @FXML
    protected Button CancelButton;
    @FXML
    protected Button btnWebDate;
    @FXML
    protected Button btnWebLink;
    @FXML
    private ProgressIndicator fxProgress;
    @FXML
    private Label fxStatus;
    @FXML
    private Label fxResult;
    @FXML
    private Label fxExpiry;
    protected Stage dlgstage;
    protected boolean datachanged;
    private BookmarkData data;
    private DateTimeFormatter dateformatter;
    private boolean hasWebURL;
    private static final Pattern[] DATE_PATTERNS = new Pattern[]{null, null};
    private static final String[] DATE_PATTERN_STRINGS = new String[]{"verf\u00fcgbar.+?bis.+?([0-9]{2}\\.[0-9]{2}\\.[0-9]{4})", "verf\u00fcgbar.+?bis.+?([0-9]{2}/[0-9]{2}/[0-9]{4})"};
    private static final int EXCERPT_LEN = 1000;

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.dateformatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        this.fxDate.setOnKeyTyped(e -> this.handleChange());
        this.fxDate.setOnMouseClicked(e -> this.handleChange());
        this.fxDate.getEditor().setOnKeyTyped(e -> this.handleChange());
    }

    @FXML
    protected void handleCancel() {
        this.datachanged = false;
        this.dlgstage.hide();
    }

    @FXML
    protected void handleSave() {
        String dv;
        if (!this.fxNote.getText().equals(this.data.getNote())) {
            this.data.setNote(this.fxNote.getText());
            this.datachanged = true;
        }
        if ((dv = this.getDateValue()) != null || this.data.getExpiry() != null || dv != null && !dv.equals(this.data.getExpiry())) {
            this.data.setExpiry(dv);
            this.datachanged = true;
        }
        this.dlgstage.hide();
    }

    @FXML
    protected void handleChange() {
        boolean isok = this.Verify();
        this.SaveButton.setDisable(!isok);
        int idx = this.fxDate.getEditor().getStyleClass().indexOf((Object)"Invalid");
        if (isok && idx > -1) {
            this.fxDate.getEditor().getStyleClass().remove((Object)"Invalid");
        } else if (!isok && idx == -1) {
            this.fxDate.getEditor().getStyleClass().add((Object)"Invalid");
        }
    }

    @FXML
    private void btnSearchWeb(Event e) {
        this.fxProgress.setVisible(true);
        this.fxStatus.setVisible(true);
        this.btnWebDate.setDisable(true);
        Task<String> task = new Task<String>(){

            protected String call() {
                return BookmarkNoteDialog.this.searchExpiryDate();
            }
        };
        task.setOnSucceeded(arg_0 -> this.lambda$btnSearchWeb$3((Task)task, arg_0));
        new Thread((Runnable)task).start();
    }

    @FXML
    private void btnOpenWebLink(Event e) {
        try {
            if (this.hasWebURL) {
                UrlHyperlinkAction.openURL(null, this.data.getWebUrl());
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public final boolean SetandShow(Stage dlgstage, BookmarkData data) {
        this.dlgstage = dlgstage;
        this.data = data;
        this.hasWebURL = data.hasWebURL();
        this.dlgstage.setTitle(data.getNote() != null || data.getExpiry() != null ? "Anmerkungen \u00e4ndern" : "neue Anmerkungen");
        this.fxNote.setText(data.getNote() != null ? data.getNote() : "");
        if (data.isLiveStream()) {
            this.fxExpiry.setDisable(true);
            this.fxDate.setDisable(true);
            this.btnWebDate.setDisable(true);
        } else {
            if (data.getExpiry() != null && !data.getExpiry().isEmpty()) {
                try {
                    this.fxDate.setValue((Object)LocalDate.parse(data.getExpiry(), this.dateformatter));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.btnWebDate.setDisable(!this.hasWebURL);
            this.btnWebLink.setDisable(!this.hasWebURL);
        }
        this.handleChange();
        this.dlgstage.showAndWait();
        return this.datachanged;
    }

    protected boolean Verify() {
        boolean rc = true;
        String dv = this.getDateValue();
        if (dv != null) {
            try {
                LocalDate.parse(dv, this.dateformatter);
            }
            catch (Exception e) {
                rc = false;
            }
        }
        return rc;
    }

    private String getDateValue() {
        String dv = this.fxDate.getEditor().getText();
        if (dv != null && dv.isEmpty()) {
            dv = null;
        }
        return dv;
    }

    private String searchExpiryDate() {
        String result;
        block35: {
            result = null;
            if (this.hasWebURL) {
                Request request = new Request.Builder().url(this.data.getWebUrl()).get().build();
                try (Response response = MVHttpClient.getInstance().getReducedTimeOutClient().newCall(request).execute();
                     ResponseBody body = response.body();){
                    if (!response.isSuccessful() || body == null) break block35;
                    try (InputStream is = body.byteStream();
                         InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                         BufferedReader in = new BufferedReader(isr);){
                        String str;
                        StringBuilder a = new StringBuilder();
                        boolean save = false;
                        while ((str = in.readLine()) != null) {
                            if (!save) {
                                int idx = str.toLowerCase().indexOf("verf\u00fcgbar ");
                                if (idx <= -1) continue;
                                String sdate = str.substring(idx, str.length() - 1);
                                a.append(sdate);
                                save = true;
                                continue;
                            }
                            if (a.length() >= 1000) break;
                            a.append(str.toLowerCase());
                        }
                        if (a.isEmpty()) break block35;
                        for (int k = 0; k < DATE_PATTERNS.length; ++k) {
                            Matcher matcher;
                            if (DATE_PATTERNS[k] == null) {
                                BookmarkNoteDialog.DATE_PATTERNS[k] = Pattern.compile(DATE_PATTERN_STRINGS[k], 2);
                            }
                            if (!(matcher = DATE_PATTERNS[k].matcher(a)).find()) continue;
                            result = matcher.group(1).replaceAll("/", "\\.");
                            break;
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private /* synthetic */ void lambda$btnSearchWeb$3(Task task, WorkerStateEvent t) {
        String result = (String)task.getValue();
        if (result != null) {
            this.fxResult.setText("\"Verf\u00fcgbar bis Datum\" -" + result + "- gefunden");
            this.fxDate.getEditor().setText(result);
        } else {
            this.fxResult.setText("\"Verf\u00fcgbar bis\" Datum nicht gefunden");
        }
        this.fxProgress.setVisible(false);
        this.fxStatus.setVisible(false);
        this.btnWebDate.setDisable(false);
    }
}

