/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.filterpanel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.NoSuchElementException;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.gui.messages.TableModelChangeEvent;
import mediathek.javafx.filterpanel.CommonViewSettingsPane;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;

public class SwingFilterDialog
extends JDialog {
    private final JFXPanel fxPanel = new JFXPanel();

    public SwingFilterDialog(Frame owner, CommonViewSettingsPane content) {
        super(owner);
        this.setDefaultCloseOperation(1);
        this.setTitle("Filter");
        this.setType(Window.Type.UTILITY);
        this.setContentPane((Container)this.fxPanel);
        Platform.runLater(() -> {
            this.fxPanel.setScene(new Scene((Parent)content));
            SwingUtilities.invokeLater(() -> {
                this.pack();
                this.restoreWindowSizeFromConfig();
                this.restoreDialogVisibility();
                this.registerWindowSizeListener();
            });
        });
        MessageBus.getMessageBus().subscribe(this);
        Daten.getInstance().getFilmeLaden().addAdListener(new ListenerFilmeLaden(){

            @Override
            public void start(ListenerFilmeLadenEvent event) {
                boolean enabled = false;
                SwingFilterDialog.this.setEnabled(false);
                SwingFilterDialog.this.fxPanel.setEnabled(false);
            }

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                boolean enabled = true;
                SwingFilterDialog.this.setEnabled(true);
                SwingFilterDialog.this.fxPanel.setEnabled(true);
            }
        });
    }

    @Handler
    private void handleTableModelChangeEvent(TableModelChangeEvent e) {
        SwingUtilities.invokeLater(() -> this.setEnabled(!e.active));
    }

    private void restoreDialogVisibility() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        boolean visible = config.getBoolean("application.ui.filter_dialog.visible", false);
        this.setVisible(visible);
    }

    private void storeDialogVisibility() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        config.setProperty("application.ui.filter_dialog.visible", this.isVisible());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreWindowSizeFromConfig() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.READ);
            int width = config.getInt("application.ui.filter_dialog.width");
            int height = config.getInt("application.ui.filter_dialog.height");
            int x = config.getInt("application.ui.filter_dialog.location.x");
            int y = config.getInt("application.ui.filter_dialog.location.y");
            this.setBounds(x, y, width, height);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    private void registerWindowSizeListener() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                this.storeWindowPosition(e);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                this.storeWindowPosition(e);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                SwingFilterDialog.this.storeDialogVisibility();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                this.storeWindowPosition(e);
                SwingFilterDialog.this.storeDialogVisibility();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void storeWindowPosition(ComponentEvent e) {
                Configuration config = ApplicationConfiguration.getConfiguration();
                Component component = e.getComponent();
                Dimension dims = component.getSize();
                Point loc = component.getLocation();
                try {
                    config.lock(LockMode.WRITE);
                    config.setProperty("application.ui.filter_dialog.width", dims.width);
                    config.setProperty("application.ui.filter_dialog.height", dims.height);
                    config.setProperty("application.ui.filter_dialog.location.x", loc.x);
                    config.setProperty("application.ui.filter_dialog.location.y", loc.y);
                }
                finally {
                    config.unlock(LockMode.WRITE);
                }
            }
        });
    }
}

