/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.sender_icon_cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import mediathek.gui.messages.SenderIconStyleChangedEvent;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MessageBus;
import mediathek.tool.TimerPool;
import mediathek.tool.sender_icon_cache.SenderIconCacheLoader;
import mediathek.tool.sender_icon_cache.SenderIconSize;
import net.engio.mbassy.listener.Handler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0087\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0003J\b\u0010\u0017\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lmediathek/tool/sender_icon_cache/MVSenderIconCache;", "", "()V", "CONFIG_USE_LOCAL_SENDER_ICONS", "", "largeSenderCache", "Lcom/google/common/cache/LoadingCache;", "Ljava/util/Optional;", "Ljavax/swing/ImageIcon;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "smallSenderCache", "useLocalIcons", "Ljava/util/concurrent/atomic/AtomicBoolean;", "get", "sender", "small", "", "handleSenderIconStyleChangedEvent", "", "e", "Lmediathek/gui/messages/SenderIconStyleChangedEvent;", "setupCleanupScheduler", "MediathekView"})
public final class MVSenderIconCache {
    @NotNull
    public static final MVSenderIconCache INSTANCE = new MVSenderIconCache();
    @NotNull
    private static final AtomicBoolean useLocalIcons = new AtomicBoolean(false);
    @NotNull
    private static final LoadingCache<String, Optional<ImageIcon>> smallSenderCache;
    @NotNull
    private static final LoadingCache<String, Optional<ImageIcon>> largeSenderCache;
    private static final Logger logger;
    @NotNull
    public static final String CONFIG_USE_LOCAL_SENDER_ICONS = "application.sender_icons.use_local";

    private MVSenderIconCache() {
    }

    @Handler
    private final void handleSenderIconStyleChangedEvent(SenderIconStyleChangedEvent e) {
        logger.trace("invalidating caches due to sender icon style change");
        useLocalIcons.set(ApplicationConfiguration.getConfiguration().getBoolean(CONFIG_USE_LOCAL_SENDER_ICONS, false));
        smallSenderCache.invalidateAll();
        largeSenderCache.invalidateAll();
    }

    private final void setupCleanupScheduler() {
        TimerPool.getTimerPool().scheduleAtFixedRate(MVSenderIconCache::setupCleanupScheduler$lambda-0, 5L, 5L, TimeUnit.MINUTES);
    }

    @JvmStatic
    @NotNull
    public static final Optional<ImageIcon> get(@NotNull String sender, boolean small) {
        Optional<ImageIcon> optional;
        Intrinsics.checkNotNullParameter(sender, "sender");
        try {
            optional = small ? smallSenderCache.get(sender) : largeSenderCache.get(sender);
            Intrinsics.checkNotNullExpressionValue(optional, "{\n            if (small)\u2026erCache[sender]\n        }");
        }
        catch (CacheLoader.InvalidCacheLoadException ex) {
            Optional optional2 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional2, "{\n            Optional.empty()\n        }");
            optional = optional2;
        }
        catch (ExecutionException ex) {
            Optional optional3 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional3, "{\n            Optional.empty()\n        }");
            optional = optional3;
        }
        return optional;
    }

    private static final void setupCleanupScheduler$lambda-0() {
        logger.trace("Cleaning sender icon caches");
        largeSenderCache.cleanUp();
        smallSenderCache.cleanUp();
    }

    static {
        logger = LogManager.getLogger();
        logger.trace("Initializing sender icon cache...");
        INSTANCE.setupCleanupScheduler();
        LoadingCache loadingCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).build(new SenderIconCacheLoader(SenderIconSize.LARGE, useLocalIcons));
        Intrinsics.checkNotNullExpressionValue(loadingCache, "newBuilder()\n           \u2026ze.LARGE, useLocalIcons))");
        largeSenderCache = loadingCache;
        loadingCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).build(new SenderIconCacheLoader(SenderIconSize.SMALL, useLocalIcons));
        Intrinsics.checkNotNullExpressionValue(loadingCache, "newBuilder()\n           \u2026ze.SMALL, useLocalIcons))");
        smallSenderCache = loadingCache;
        MessageBus.getMessageBus().subscribe(INSTANCE);
        useLocalIcons.set(ApplicationConfiguration.getConfiguration().getBoolean(CONFIG_USE_LOCAL_SENDER_ICONS, false));
    }
}

