/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.property.editor;

import java.math.BigInteger;
import javafx.beans.binding.NumberExpression;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextField;

class NumericField
extends TextField {
    private final NumericValidator<? extends Number> value;

    public NumericField(Class<? extends Number> cls) {
        this.value = cls == Byte.TYPE || cls == Byte.class || cls == Short.TYPE || cls == Short.class || cls == Integer.TYPE || cls == Integer.class || cls == Long.TYPE || cls == Long.class || cls == BigInteger.class ? new LongValidator(this) : new DoubleValidator(this);
        this.focusedProperty().addListener((observable2, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.value.setValue(this.value.toNumber(this.getText()));
            }
        });
    }

    public final ObservableValue<Number> valueProperty() {
        return this.value;
    }

    public void replaceText(int start, int end, String text) {
        if (this.replaceValid(start, end, text).booleanValue()) {
            super.replaceText(start, end, text);
        }
    }

    public void replaceSelection(String text) {
        IndexRange range = this.getSelection();
        if (this.replaceValid(range.getStart(), range.getEnd(), text).booleanValue()) {
            super.replaceSelection(text);
        }
    }

    private Boolean replaceValid(int start, int end, String fragment) {
        try {
            String newText = this.getText().substring(0, start) + fragment + this.getText().substring(end);
            if (newText.isEmpty()) {
                return true;
            }
            this.value.toNumber(newText);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static class LongValidator
    extends SimpleLongProperty
    implements NumericValidator<Long> {
        private NumericField field;

        public LongValidator(NumericField field) {
            super((Object)field, "value", 0L);
            this.field = field;
        }

        protected void invalidated() {
            this.field.setText(Long.toString(this.get()));
        }

        @Override
        public Long toNumber(String s2) {
            if (s2 == null || s2.trim().isEmpty()) {
                return 0L;
            }
            String d = s2.trim();
            return new Long(d);
        }
    }

    static class DoubleValidator
    extends SimpleDoubleProperty
    implements NumericValidator<Double> {
        private NumericField field;

        public DoubleValidator(NumericField field) {
            super((Object)field, "value", 0.0);
            this.field = field;
        }

        protected void invalidated() {
            this.field.setText(Double.toString(this.get()));
        }

        @Override
        public Double toNumber(String s2) {
            if (s2 == null || s2.trim().isEmpty()) {
                return 0.0;
            }
            String d = s2.trim();
            if (d.endsWith("f") || d.endsWith("d") || d.endsWith("F") || d.endsWith("D")) {
                throw new NumberFormatException("There should be no alpha symbols");
            }
            return new Double(d);
        }
    }

    private static interface NumericValidator<T extends Number>
    extends NumberExpression {
        public void setValue(Number var1);

        public T toNumber(String var1);
    }
}

