/****************************************************************************
**
** Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
** Copyright (C) 2021 Chupligin Sergey <neochapay@gmail.com>
**
** This file is part of the Qt Quick Controls module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Digia Plc and its Subsidiary(-ies) nor the names
**     of its contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 2.6
import QtQuick.Controls 1.0 //needed for the Stack attached property
import QtQuick.Controls.Nemo 1.0
import QtQuick.Controls.Styles.Nemo 1.0

Page {
    id: root

    allowedOrientations:Qt.PortraitOrientation | Qt.LandscapeOrientation
    property real progress: 0
    SequentialAnimation on progress {
        loops: Animation.Infinite
        running: true
        NumberAnimation {
            from: 0
            to: 1
            duration: 3000
        }
        NumberAnimation {
            from: 1
            to: 0
            duration: 3000
        }
    }

    headerTools: HeaderToolsLayout {
        showBackButton: true;
        title: qsTr("Text input")
    }

    Column {
        spacing:Theme.itemSpacingHuge
        anchors.centerIn: parent

        TextField {
            anchors.margins: Theme.itemSpacingLarge
            text: qsTr("Text input")
        }

        TextField {
            anchors.margins: Theme.itemSpacingLarge
            text: qsTr("Readonly Text input")
            readOnly: true
        }

        TextField {
            anchors.margins: Theme.itemSpacingLarge
            text: qsTr("Disabled textfield")
            enabled: false
        }

        TextField {
            anchors.margins: Theme.itemSpacingLarge
            text: qsTr("Text input")
            style: touchStyle
        }

        TextField {
            anchors.margins: Theme.itemSpacingLarge
            text: "Readonly Text input"
            style: touchStyle
            readOnly: true
        }
    }


    Component {
        id: touchStyle

        TextFieldStyle {
            textColor: Theme.textColor
            font.pixelSize: Theme.fontSizeMedium
            background: Item {
                implicitHeight: Theme.itemHeightMedium
                implicitWidth: Theme.itemWidthLarge
                BorderImage {
                    source: "/usr/share/glacier-components/images/textinput.png"
                    border.left: Theme.itemSpacingExtraSmall
                    border.right: Theme.itemSpacingExtraSmall
                    anchors.bottom: parent.bottom
                    anchors.left: parent.left
                    anchors.right: parent.right
                }
            }
        }
    }
}
