#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


    #include "pulse/sample.h"
    #include "pulse/volume.h"
    #include "pulse/def.h"
    #include "pulse/introspect.h"
    #include "pulse/mainloop.h"
    #include "pulse/mainloop-api.h"
    #include "pulse/format.h"
    #include "pulse/context.h"
    #include "pulse/subscribe.h"
    

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // char *()(char *, size_t, pa_cvolume const *)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 156), // char *
/*  2 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/*  3 */ _CFFI_OP(_CFFI_OP_POINTER, 163), // pa_cvolume const *
/*  4 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION, 27), // int()(pa_context *, char const *, pa_context_flags_t, pa_spawn_api const *)
/*  6 */ _CFFI_OP(_CFFI_OP_POINTER, 161), // pa_context *
/*  7 */ _CFFI_OP(_CFFI_OP_POINTER, 156), // char const *
/*  8 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // pa_context_flags_t
/*  9 */ _CFFI_OP(_CFFI_OP_POINTER, 183), // pa_spawn_api const *
/* 10 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION, 27), // int()(pa_cvolume const *)
/* 12 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 13 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 14 */ _CFFI_OP(_CFFI_OP_FUNCTION, 27), // int()(pa_cvolume const *, uint32_t)
/* 15 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 16 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 17 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION, 27), // int()(pa_mainloop *)
/* 19 */ _CFFI_OP(_CFFI_OP_POINTER, 168), // pa_mainloop *
/* 20 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 21 */ _CFFI_OP(_CFFI_OP_FUNCTION, 27), // int()(pa_mainloop *, int *)
/* 22 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 23 */ _CFFI_OP(_CFFI_OP_POINTER, 27), // int *
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION, 27), // int()(pa_mainloop *, int)
/* 26 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 27 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 28 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 29 */ _CFFI_OP(_CFFI_OP_FUNCTION, 27), // int()(pa_mainloop *, int, int *)
/* 30 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 31 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 32 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 33 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // pa_context *()(pa_mainloop_api *, char const *)
/* 35 */ _CFFI_OP(_CFFI_OP_POINTER, 169), // pa_mainloop_api *
/* 36 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 37 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 38 */ _CFFI_OP(_CFFI_OP_FUNCTION, 162), // pa_context_state_t()(pa_context *)
/* 39 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION, 42), // pa_cvolume *()(pa_cvolume *)
/* 42 */ _CFFI_OP(_CFFI_OP_POINTER, 163), // pa_cvolume *
/* 43 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION, 42), // pa_cvolume *()(pa_cvolume *, uint32_t)
/* 45 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 46 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 48 */ _CFFI_OP(_CFFI_OP_FUNCTION, 42), // pa_cvolume *()(pa_cvolume *, unsigned int, uint32_t)
/* 49 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 50 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 51 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 52 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 53 */ _CFFI_OP(_CFFI_OP_FUNCTION, 19), // pa_mainloop *()(void)
/* 54 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 55 */ _CFFI_OP(_CFFI_OP_FUNCTION, 35), // pa_mainloop_api *()(pa_mainloop *)
/* 56 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 58 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // pa_operation *()(pa_context *, char const *, int, void(*)(pa_context *, int, void *), void *)
/* 59 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 60 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 61 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 62 */ _CFFI_OP(_CFFI_OP_POINTER, 111), // void(*)(pa_context *, int, void *)
/* 63 */ _CFFI_OP(_CFFI_OP_POINTER, 189), // void *
/* 64 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 65 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // pa_operation *()(pa_context *, char const *, pa_cvolume const *, void(*)(pa_context *, int, void *), void *)
/* 66 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 67 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 68 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 69 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 70 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // pa_operation *()(pa_context *, pa_subscription_mask_t, void(*)(pa_context *, int, void *), void *)
/* 73 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 74 */ _CFFI_OP(_CFFI_OP_ENUM, 9), // pa_subscription_mask_t
/* 75 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 76 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 77 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 78 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // pa_operation *()(pa_context *, uint32_t, int, void(*)(pa_context *, int, void *), void *)
/* 79 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 80 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 81 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 82 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 83 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 84 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 85 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // pa_operation *()(pa_context *, uint32_t, pa_cvolume const *, void(*)(pa_context *, int, void *), void *)
/* 86 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 87 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 88 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 89 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 90 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 91 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 92 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // pa_operation *()(pa_context *, void(*)(pa_context *, pa_server_info const *, void *), void *)
/* 93 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 94 */ _CFFI_OP(_CFFI_OP_POINTER, 116), // void(*)(pa_context *, pa_server_info const *, void *)
/* 95 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 96 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 97 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // pa_operation *()(pa_context *, void(*)(pa_context *, pa_sink_info const *, int, void *), void *)
/* 98 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 99 */ _CFFI_OP(_CFFI_OP_POINTER, 121), // void(*)(pa_context *, pa_sink_info const *, int, void *)
/* 100 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 101 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 102 */ _CFFI_OP(_CFFI_OP_FUNCTION, 171), // pa_operation_state_t()(pa_operation *)
/* 103 */ _CFFI_OP(_CFFI_OP_POINTER, 170), // pa_operation *
/* 104 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 105 */ _CFFI_OP(_CFFI_OP_FUNCTION, 16), // uint32_t()(pa_cvolume const *)
/* 106 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 107 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION, 189), // void()(pa_context *)
/* 109 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 110 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 111 */ _CFFI_OP(_CFFI_OP_FUNCTION, 189), // void()(pa_context *, int, void *)
/* 112 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 113 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 114 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 115 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 116 */ _CFFI_OP(_CFFI_OP_FUNCTION, 189), // void()(pa_context *, pa_server_info const *, void *)
/* 117 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 118 */ _CFFI_OP(_CFFI_OP_POINTER, 176), // pa_server_info const *
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 120 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 121 */ _CFFI_OP(_CFFI_OP_FUNCTION, 189), // void()(pa_context *, pa_sink_info const *, int, void *)
/* 122 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 123 */ _CFFI_OP(_CFFI_OP_POINTER, 178), // pa_sink_info const *
/* 124 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 125 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 126 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 127 */ _CFFI_OP(_CFFI_OP_FUNCTION, 189), // void()(pa_context *, pa_subscription_event_type_t, uint32_t, void *)
/* 128 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 129 */ _CFFI_OP(_CFFI_OP_ENUM, 8), // pa_subscription_event_type_t
/* 130 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 131 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 132 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 133 */ _CFFI_OP(_CFFI_OP_FUNCTION, 189), // void()(pa_context *, void *)
/* 134 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 135 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 136 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 137 */ _CFFI_OP(_CFFI_OP_FUNCTION, 189), // void()(pa_context *, void(*)(pa_context *, pa_subscription_event_type_t, uint32_t, void *), void *)
/* 138 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 139 */ _CFFI_OP(_CFFI_OP_POINTER, 127), // void(*)(pa_context *, pa_subscription_event_type_t, uint32_t, void *)
/* 140 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 141 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 142 */ _CFFI_OP(_CFFI_OP_FUNCTION, 189), // void()(pa_context *, void(*)(pa_context *, void *), void *)
/* 143 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 144 */ _CFFI_OP(_CFFI_OP_POINTER, 133), // void(*)(pa_context *, void *)
/* 145 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 146 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 147 */ _CFFI_OP(_CFFI_OP_FUNCTION, 189), // void()(pa_mainloop *)
/* 148 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 149 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 150 */ _CFFI_OP(_CFFI_OP_FUNCTION, 189), // void()(pa_mainloop *, int)
/* 151 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 152 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 153 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 154 */ _CFFI_OP(_CFFI_OP_FUNCTION, 189), // void()(void)
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 156 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 157 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // pa_channel_map
/* 158 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // pa_channel_position_t
/* 159 */ _CFFI_OP(_CFFI_OP_ARRAY, 158), // pa_channel_position_t[_cffi_array_len(((pa_channel_map *)0)->map)]
/* 160 */ (_cffi_opcode_t)(_cffi_array_len(((pa_channel_map *)0)->map)),
/* 161 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // pa_context
/* 162 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // pa_context_state_t
/* 163 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // pa_cvolume
/* 164 */ _CFFI_OP(_CFFI_OP_ENUM, 3), // pa_encoding_t
/* 165 */ _CFFI_OP(_CFFI_OP_POINTER, 166), // pa_format_info * *
/* 166 */ _CFFI_OP(_CFFI_OP_POINTER, 167), // pa_format_info *
/* 167 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // pa_format_info
/* 168 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // pa_mainloop
/* 169 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // pa_mainloop_api
/* 170 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // pa_operation
/* 171 */ _CFFI_OP(_CFFI_OP_ENUM, 4), // pa_operation_state_t
/* 172 */ _CFFI_OP(_CFFI_OP_POINTER, 173), // pa_proplist *
/* 173 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // pa_proplist
/* 174 */ _CFFI_OP(_CFFI_OP_ENUM, 5), // pa_sample_format_t
/* 175 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // pa_sample_spec
/* 176 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // pa_server_info
/* 177 */ _CFFI_OP(_CFFI_OP_ENUM, 6), // pa_sink_flags_t
/* 178 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // pa_sink_info
/* 179 */ _CFFI_OP(_CFFI_OP_POINTER, 180), // pa_sink_port_info * *
/* 180 */ _CFFI_OP(_CFFI_OP_POINTER, 181), // pa_sink_port_info *
/* 181 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // pa_sink_port_info
/* 182 */ _CFFI_OP(_CFFI_OP_ENUM, 7), // pa_sink_state_t
/* 183 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // pa_spawn_api
/* 184 */ _CFFI_OP(_CFFI_OP_ARRAY, 16), // uint32_t[_cffi_array_len(((pa_cvolume *)0)->values)]
/* 185 */ (_cffi_opcode_t)(_cffi_array_len(((pa_cvolume *)0)->values)),
/* 186 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24), // uint64_t
/* 187 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18), // uint8_t
/* 188 */ _CFFI_OP(_CFFI_OP_POINTER, 154), // void(*)(void)
/* 189 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_pa_cvolume(pa_cvolume *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->channels) | 0);  /* check that 'pa_cvolume.channels' is an integer */
  { uint32_t *tmp = &p->values[0]; (void)tmp; }
}
struct _cffi_align_typedef_pa_cvolume { char x; pa_cvolume y; };

static int _cffi_const_PA_CHANNEL_POSITION_INVALID(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_INVALID) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_INVALID) | 0);  /* check that PA_CHANNEL_POSITION_INVALID is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_MONO(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_MONO) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_MONO) | 0);  /* check that PA_CHANNEL_POSITION_MONO is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_FRONT_LEFT(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_FRONT_LEFT) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_FRONT_LEFT) | 0);  /* check that PA_CHANNEL_POSITION_FRONT_LEFT is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_FRONT_RIGHT(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_FRONT_RIGHT) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_FRONT_RIGHT) | 0);  /* check that PA_CHANNEL_POSITION_FRONT_RIGHT is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_FRONT_CENTER(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_FRONT_CENTER) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_FRONT_CENTER) | 0);  /* check that PA_CHANNEL_POSITION_FRONT_CENTER is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_LEFT(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_LEFT) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_LEFT) | 0);  /* check that PA_CHANNEL_POSITION_LEFT is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_RIGHT(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_RIGHT) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_RIGHT) | 0);  /* check that PA_CHANNEL_POSITION_RIGHT is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_CENTER(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_CENTER) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_CENTER) | 0);  /* check that PA_CHANNEL_POSITION_CENTER is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_REAR_CENTER(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_REAR_CENTER) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_REAR_CENTER) | 0);  /* check that PA_CHANNEL_POSITION_REAR_CENTER is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_REAR_LEFT(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_REAR_LEFT) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_REAR_LEFT) | 0);  /* check that PA_CHANNEL_POSITION_REAR_LEFT is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_REAR_RIGHT(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_REAR_RIGHT) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_REAR_RIGHT) | 0);  /* check that PA_CHANNEL_POSITION_REAR_RIGHT is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_LFE(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_LFE) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_LFE) | 0);  /* check that PA_CHANNEL_POSITION_LFE is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_SUBWOOFER(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_SUBWOOFER) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_SUBWOOFER) | 0);  /* check that PA_CHANNEL_POSITION_SUBWOOFER is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_FRONT_LEFT_OF_CENTER(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_FRONT_LEFT_OF_CENTER) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_FRONT_LEFT_OF_CENTER) | 0);  /* check that PA_CHANNEL_POSITION_FRONT_LEFT_OF_CENTER is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_FRONT_RIGHT_OF_CENTER(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_FRONT_RIGHT_OF_CENTER) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_FRONT_RIGHT_OF_CENTER) | 0);  /* check that PA_CHANNEL_POSITION_FRONT_RIGHT_OF_CENTER is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_SIDE_LEFT(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_SIDE_LEFT) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_SIDE_LEFT) | 0);  /* check that PA_CHANNEL_POSITION_SIDE_LEFT is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_SIDE_RIGHT(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_SIDE_RIGHT) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_SIDE_RIGHT) | 0);  /* check that PA_CHANNEL_POSITION_SIDE_RIGHT is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX0(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX0) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX0) | 0);  /* check that PA_CHANNEL_POSITION_AUX0 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX1(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX1) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX1) | 0);  /* check that PA_CHANNEL_POSITION_AUX1 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX2(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX2) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX2) | 0);  /* check that PA_CHANNEL_POSITION_AUX2 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX3(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX3) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX3) | 0);  /* check that PA_CHANNEL_POSITION_AUX3 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX4(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX4) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX4) | 0);  /* check that PA_CHANNEL_POSITION_AUX4 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX5(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX5) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX5) | 0);  /* check that PA_CHANNEL_POSITION_AUX5 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX6(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX6) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX6) | 0);  /* check that PA_CHANNEL_POSITION_AUX6 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX7(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX7) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX7) | 0);  /* check that PA_CHANNEL_POSITION_AUX7 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX8(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX8) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX8) | 0);  /* check that PA_CHANNEL_POSITION_AUX8 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX9(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX9) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX9) | 0);  /* check that PA_CHANNEL_POSITION_AUX9 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX10(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX10) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX10) | 0);  /* check that PA_CHANNEL_POSITION_AUX10 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX11(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX11) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX11) | 0);  /* check that PA_CHANNEL_POSITION_AUX11 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX12(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX12) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX12) | 0);  /* check that PA_CHANNEL_POSITION_AUX12 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX13(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX13) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX13) | 0);  /* check that PA_CHANNEL_POSITION_AUX13 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX14(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX14) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX14) | 0);  /* check that PA_CHANNEL_POSITION_AUX14 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX15(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX15) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX15) | 0);  /* check that PA_CHANNEL_POSITION_AUX15 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX16(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX16) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX16) | 0);  /* check that PA_CHANNEL_POSITION_AUX16 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX17(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX17) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX17) | 0);  /* check that PA_CHANNEL_POSITION_AUX17 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX18(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX18) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX18) | 0);  /* check that PA_CHANNEL_POSITION_AUX18 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX19(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX19) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX19) | 0);  /* check that PA_CHANNEL_POSITION_AUX19 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX20(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX20) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX20) | 0);  /* check that PA_CHANNEL_POSITION_AUX20 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX21(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX21) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX21) | 0);  /* check that PA_CHANNEL_POSITION_AUX21 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX22(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX22) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX22) | 0);  /* check that PA_CHANNEL_POSITION_AUX22 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX23(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX23) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX23) | 0);  /* check that PA_CHANNEL_POSITION_AUX23 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX24(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX24) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX24) | 0);  /* check that PA_CHANNEL_POSITION_AUX24 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX25(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX25) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX25) | 0);  /* check that PA_CHANNEL_POSITION_AUX25 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX26(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX26) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX26) | 0);  /* check that PA_CHANNEL_POSITION_AUX26 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX27(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX27) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX27) | 0);  /* check that PA_CHANNEL_POSITION_AUX27 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX28(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX28) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX28) | 0);  /* check that PA_CHANNEL_POSITION_AUX28 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX29(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX29) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX29) | 0);  /* check that PA_CHANNEL_POSITION_AUX29 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX30(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX30) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX30) | 0);  /* check that PA_CHANNEL_POSITION_AUX30 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_AUX31(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_AUX31) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_AUX31) | 0);  /* check that PA_CHANNEL_POSITION_AUX31 is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_TOP_CENTER(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_TOP_CENTER) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_TOP_CENTER) | 0);  /* check that PA_CHANNEL_POSITION_TOP_CENTER is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_TOP_FRONT_LEFT(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_TOP_FRONT_LEFT) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_TOP_FRONT_LEFT) | 0);  /* check that PA_CHANNEL_POSITION_TOP_FRONT_LEFT is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_TOP_FRONT_RIGHT(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_TOP_FRONT_RIGHT) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_TOP_FRONT_RIGHT) | 0);  /* check that PA_CHANNEL_POSITION_TOP_FRONT_RIGHT is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_TOP_FRONT_CENTER(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_TOP_FRONT_CENTER) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_TOP_FRONT_CENTER) | 0);  /* check that PA_CHANNEL_POSITION_TOP_FRONT_CENTER is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_TOP_REAR_LEFT(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_TOP_REAR_LEFT) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_TOP_REAR_LEFT) | 0);  /* check that PA_CHANNEL_POSITION_TOP_REAR_LEFT is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_TOP_REAR_RIGHT(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_TOP_REAR_RIGHT) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_TOP_REAR_RIGHT) | 0);  /* check that PA_CHANNEL_POSITION_TOP_REAR_RIGHT is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_TOP_REAR_CENTER(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_TOP_REAR_CENTER) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_TOP_REAR_CENTER) | 0);  /* check that PA_CHANNEL_POSITION_TOP_REAR_CENTER is an integer */
  return n;
}

static int _cffi_const_PA_CHANNEL_POSITION_MAX(unsigned long long *o)
{
  int n = (PA_CHANNEL_POSITION_MAX) <= 0;
  *o = (unsigned long long)((PA_CHANNEL_POSITION_MAX) | 0);  /* check that PA_CHANNEL_POSITION_MAX is an integer */
  return n;
}

static int _cffi_const_PA_CONTEXT_NOFLAGS(unsigned long long *o)
{
  int n = (PA_CONTEXT_NOFLAGS) <= 0;
  *o = (unsigned long long)((PA_CONTEXT_NOFLAGS) | 0);  /* check that PA_CONTEXT_NOFLAGS is an integer */
  return n;
}

static int _cffi_const_PA_CONTEXT_NOAUTOSPAWN(unsigned long long *o)
{
  int n = (PA_CONTEXT_NOAUTOSPAWN) <= 0;
  *o = (unsigned long long)((PA_CONTEXT_NOAUTOSPAWN) | 0);  /* check that PA_CONTEXT_NOAUTOSPAWN is an integer */
  return n;
}

static int _cffi_const_PA_CONTEXT_NOFAIL(unsigned long long *o)
{
  int n = (PA_CONTEXT_NOFAIL) <= 0;
  *o = (unsigned long long)((PA_CONTEXT_NOFAIL) | 0);  /* check that PA_CONTEXT_NOFAIL is an integer */
  return n;
}

static int _cffi_const_PA_CONTEXT_UNCONNECTED(unsigned long long *o)
{
  int n = (PA_CONTEXT_UNCONNECTED) <= 0;
  *o = (unsigned long long)((PA_CONTEXT_UNCONNECTED) | 0);  /* check that PA_CONTEXT_UNCONNECTED is an integer */
  return n;
}

static int _cffi_const_PA_CONTEXT_CONNECTING(unsigned long long *o)
{
  int n = (PA_CONTEXT_CONNECTING) <= 0;
  *o = (unsigned long long)((PA_CONTEXT_CONNECTING) | 0);  /* check that PA_CONTEXT_CONNECTING is an integer */
  return n;
}

static int _cffi_const_PA_CONTEXT_AUTHORIZING(unsigned long long *o)
{
  int n = (PA_CONTEXT_AUTHORIZING) <= 0;
  *o = (unsigned long long)((PA_CONTEXT_AUTHORIZING) | 0);  /* check that PA_CONTEXT_AUTHORIZING is an integer */
  return n;
}

static int _cffi_const_PA_CONTEXT_SETTING_NAME(unsigned long long *o)
{
  int n = (PA_CONTEXT_SETTING_NAME) <= 0;
  *o = (unsigned long long)((PA_CONTEXT_SETTING_NAME) | 0);  /* check that PA_CONTEXT_SETTING_NAME is an integer */
  return n;
}

static int _cffi_const_PA_CONTEXT_READY(unsigned long long *o)
{
  int n = (PA_CONTEXT_READY) <= 0;
  *o = (unsigned long long)((PA_CONTEXT_READY) | 0);  /* check that PA_CONTEXT_READY is an integer */
  return n;
}

static int _cffi_const_PA_CONTEXT_FAILED(unsigned long long *o)
{
  int n = (PA_CONTEXT_FAILED) <= 0;
  *o = (unsigned long long)((PA_CONTEXT_FAILED) | 0);  /* check that PA_CONTEXT_FAILED is an integer */
  return n;
}

static int _cffi_const_PA_CONTEXT_TERMINATED(unsigned long long *o)
{
  int n = (PA_CONTEXT_TERMINATED) <= 0;
  *o = (unsigned long long)((PA_CONTEXT_TERMINATED) | 0);  /* check that PA_CONTEXT_TERMINATED is an integer */
  return n;
}

static int _cffi_const_PA_ENCODING_ANY(unsigned long long *o)
{
  int n = (PA_ENCODING_ANY) <= 0;
  *o = (unsigned long long)((PA_ENCODING_ANY) | 0);  /* check that PA_ENCODING_ANY is an integer */
  return n;
}

static int _cffi_const_PA_ENCODING_PCM(unsigned long long *o)
{
  int n = (PA_ENCODING_PCM) <= 0;
  *o = (unsigned long long)((PA_ENCODING_PCM) | 0);  /* check that PA_ENCODING_PCM is an integer */
  return n;
}

static int _cffi_const_PA_ENCODING_AC3_IEC61937(unsigned long long *o)
{
  int n = (PA_ENCODING_AC3_IEC61937) <= 0;
  *o = (unsigned long long)((PA_ENCODING_AC3_IEC61937) | 0);  /* check that PA_ENCODING_AC3_IEC61937 is an integer */
  return n;
}

static int _cffi_const_PA_ENCODING_EAC3_IEC61937(unsigned long long *o)
{
  int n = (PA_ENCODING_EAC3_IEC61937) <= 0;
  *o = (unsigned long long)((PA_ENCODING_EAC3_IEC61937) | 0);  /* check that PA_ENCODING_EAC3_IEC61937 is an integer */
  return n;
}

static int _cffi_const_PA_ENCODING_MPEG_IEC61937(unsigned long long *o)
{
  int n = (PA_ENCODING_MPEG_IEC61937) <= 0;
  *o = (unsigned long long)((PA_ENCODING_MPEG_IEC61937) | 0);  /* check that PA_ENCODING_MPEG_IEC61937 is an integer */
  return n;
}

static int _cffi_const_PA_ENCODING_DTS_IEC61937(unsigned long long *o)
{
  int n = (PA_ENCODING_DTS_IEC61937) <= 0;
  *o = (unsigned long long)((PA_ENCODING_DTS_IEC61937) | 0);  /* check that PA_ENCODING_DTS_IEC61937 is an integer */
  return n;
}

static int _cffi_const_PA_ENCODING_MPEG2_AAC_IEC61937(unsigned long long *o)
{
  int n = (PA_ENCODING_MPEG2_AAC_IEC61937) <= 0;
  *o = (unsigned long long)((PA_ENCODING_MPEG2_AAC_IEC61937) | 0);  /* check that PA_ENCODING_MPEG2_AAC_IEC61937 is an integer */
  return n;
}

static int _cffi_const_PA_ENCODING_MAX(unsigned long long *o)
{
  int n = (PA_ENCODING_MAX) <= 0;
  *o = (unsigned long long)((PA_ENCODING_MAX) | 0);  /* check that PA_ENCODING_MAX is an integer */
  return n;
}

static int _cffi_const_PA_ENCODING_INVALID(unsigned long long *o)
{
  int n = (PA_ENCODING_INVALID) <= 0;
  *o = (unsigned long long)((PA_ENCODING_INVALID) | 0);  /* check that PA_ENCODING_INVALID is an integer */
  return n;
}

static int _cffi_const_PA_OPERATION_RUNNING(unsigned long long *o)
{
  int n = (PA_OPERATION_RUNNING) <= 0;
  *o = (unsigned long long)((PA_OPERATION_RUNNING) | 0);  /* check that PA_OPERATION_RUNNING is an integer */
  return n;
}

static int _cffi_const_PA_OPERATION_DONE(unsigned long long *o)
{
  int n = (PA_OPERATION_DONE) <= 0;
  *o = (unsigned long long)((PA_OPERATION_DONE) | 0);  /* check that PA_OPERATION_DONE is an integer */
  return n;
}

static int _cffi_const_PA_OPERATION_CANCELLED(unsigned long long *o)
{
  int n = (PA_OPERATION_CANCELLED) <= 0;
  *o = (unsigned long long)((PA_OPERATION_CANCELLED) | 0);  /* check that PA_OPERATION_CANCELLED is an integer */
  return n;
}

static int _cffi_const_PA_SAMPLE_U8(unsigned long long *o)
{
  int n = (PA_SAMPLE_U8) <= 0;
  *o = (unsigned long long)((PA_SAMPLE_U8) | 0);  /* check that PA_SAMPLE_U8 is an integer */
  return n;
}

static int _cffi_const_PA_SAMPLE_ALAW(unsigned long long *o)
{
  int n = (PA_SAMPLE_ALAW) <= 0;
  *o = (unsigned long long)((PA_SAMPLE_ALAW) | 0);  /* check that PA_SAMPLE_ALAW is an integer */
  return n;
}

static int _cffi_const_PA_SAMPLE_ULAW(unsigned long long *o)
{
  int n = (PA_SAMPLE_ULAW) <= 0;
  *o = (unsigned long long)((PA_SAMPLE_ULAW) | 0);  /* check that PA_SAMPLE_ULAW is an integer */
  return n;
}

static int _cffi_const_PA_SAMPLE_S16LE(unsigned long long *o)
{
  int n = (PA_SAMPLE_S16LE) <= 0;
  *o = (unsigned long long)((PA_SAMPLE_S16LE) | 0);  /* check that PA_SAMPLE_S16LE is an integer */
  return n;
}

static int _cffi_const_PA_SAMPLE_S16BE(unsigned long long *o)
{
  int n = (PA_SAMPLE_S16BE) <= 0;
  *o = (unsigned long long)((PA_SAMPLE_S16BE) | 0);  /* check that PA_SAMPLE_S16BE is an integer */
  return n;
}

static int _cffi_const_PA_SAMPLE_FLOAT32LE(unsigned long long *o)
{
  int n = (PA_SAMPLE_FLOAT32LE) <= 0;
  *o = (unsigned long long)((PA_SAMPLE_FLOAT32LE) | 0);  /* check that PA_SAMPLE_FLOAT32LE is an integer */
  return n;
}

static int _cffi_const_PA_SAMPLE_FLOAT32BE(unsigned long long *o)
{
  int n = (PA_SAMPLE_FLOAT32BE) <= 0;
  *o = (unsigned long long)((PA_SAMPLE_FLOAT32BE) | 0);  /* check that PA_SAMPLE_FLOAT32BE is an integer */
  return n;
}

static int _cffi_const_PA_SAMPLE_S32LE(unsigned long long *o)
{
  int n = (PA_SAMPLE_S32LE) <= 0;
  *o = (unsigned long long)((PA_SAMPLE_S32LE) | 0);  /* check that PA_SAMPLE_S32LE is an integer */
  return n;
}

static int _cffi_const_PA_SAMPLE_S32BE(unsigned long long *o)
{
  int n = (PA_SAMPLE_S32BE) <= 0;
  *o = (unsigned long long)((PA_SAMPLE_S32BE) | 0);  /* check that PA_SAMPLE_S32BE is an integer */
  return n;
}

static int _cffi_const_PA_SAMPLE_S24LE(unsigned long long *o)
{
  int n = (PA_SAMPLE_S24LE) <= 0;
  *o = (unsigned long long)((PA_SAMPLE_S24LE) | 0);  /* check that PA_SAMPLE_S24LE is an integer */
  return n;
}

static int _cffi_const_PA_SAMPLE_S24BE(unsigned long long *o)
{
  int n = (PA_SAMPLE_S24BE) <= 0;
  *o = (unsigned long long)((PA_SAMPLE_S24BE) | 0);  /* check that PA_SAMPLE_S24BE is an integer */
  return n;
}

static int _cffi_const_PA_SAMPLE_S24_32LE(unsigned long long *o)
{
  int n = (PA_SAMPLE_S24_32LE) <= 0;
  *o = (unsigned long long)((PA_SAMPLE_S24_32LE) | 0);  /* check that PA_SAMPLE_S24_32LE is an integer */
  return n;
}

static int _cffi_const_PA_SAMPLE_S24_32BE(unsigned long long *o)
{
  int n = (PA_SAMPLE_S24_32BE) <= 0;
  *o = (unsigned long long)((PA_SAMPLE_S24_32BE) | 0);  /* check that PA_SAMPLE_S24_32BE is an integer */
  return n;
}

static int _cffi_const_PA_SAMPLE_MAX(unsigned long long *o)
{
  int n = (PA_SAMPLE_MAX) <= 0;
  *o = (unsigned long long)((PA_SAMPLE_MAX) | 0);  /* check that PA_SAMPLE_MAX is an integer */
  return n;
}

static int _cffi_const_PA_SAMPLE_INVALID(unsigned long long *o)
{
  int n = (PA_SAMPLE_INVALID) <= 0;
  *o = (unsigned long long)((PA_SAMPLE_INVALID) | 0);  /* check that PA_SAMPLE_INVALID is an integer */
  return n;
}

static int _cffi_const_PA_SINK_NOFLAGS(unsigned long long *o)
{
  int n = (PA_SINK_NOFLAGS) <= 0;
  *o = (unsigned long long)((PA_SINK_NOFLAGS) | 0);  /* check that PA_SINK_NOFLAGS is an integer */
  return n;
}

static int _cffi_const_PA_SINK_HW_VOLUME_CTRL(unsigned long long *o)
{
  int n = (PA_SINK_HW_VOLUME_CTRL) <= 0;
  *o = (unsigned long long)((PA_SINK_HW_VOLUME_CTRL) | 0);  /* check that PA_SINK_HW_VOLUME_CTRL is an integer */
  return n;
}

static int _cffi_const_PA_SINK_LATENCY(unsigned long long *o)
{
  int n = (PA_SINK_LATENCY) <= 0;
  *o = (unsigned long long)((PA_SINK_LATENCY) | 0);  /* check that PA_SINK_LATENCY is an integer */
  return n;
}

static int _cffi_const_PA_SINK_HARDWARE(unsigned long long *o)
{
  int n = (PA_SINK_HARDWARE) <= 0;
  *o = (unsigned long long)((PA_SINK_HARDWARE) | 0);  /* check that PA_SINK_HARDWARE is an integer */
  return n;
}

static int _cffi_const_PA_SINK_NETWORK(unsigned long long *o)
{
  int n = (PA_SINK_NETWORK) <= 0;
  *o = (unsigned long long)((PA_SINK_NETWORK) | 0);  /* check that PA_SINK_NETWORK is an integer */
  return n;
}

static int _cffi_const_PA_SINK_HW_MUTE_CTRL(unsigned long long *o)
{
  int n = (PA_SINK_HW_MUTE_CTRL) <= 0;
  *o = (unsigned long long)((PA_SINK_HW_MUTE_CTRL) | 0);  /* check that PA_SINK_HW_MUTE_CTRL is an integer */
  return n;
}

static int _cffi_const_PA_SINK_DECIBEL_VOLUME(unsigned long long *o)
{
  int n = (PA_SINK_DECIBEL_VOLUME) <= 0;
  *o = (unsigned long long)((PA_SINK_DECIBEL_VOLUME) | 0);  /* check that PA_SINK_DECIBEL_VOLUME is an integer */
  return n;
}

static int _cffi_const_PA_SINK_FLAT_VOLUME(unsigned long long *o)
{
  int n = (PA_SINK_FLAT_VOLUME) <= 0;
  *o = (unsigned long long)((PA_SINK_FLAT_VOLUME) | 0);  /* check that PA_SINK_FLAT_VOLUME is an integer */
  return n;
}

static int _cffi_const_PA_SINK_DYNAMIC_LATENCY(unsigned long long *o)
{
  int n = (PA_SINK_DYNAMIC_LATENCY) <= 0;
  *o = (unsigned long long)((PA_SINK_DYNAMIC_LATENCY) | 0);  /* check that PA_SINK_DYNAMIC_LATENCY is an integer */
  return n;
}

static int _cffi_const_PA_SINK_SET_FORMATS(unsigned long long *o)
{
  int n = (PA_SINK_SET_FORMATS) <= 0;
  *o = (unsigned long long)((PA_SINK_SET_FORMATS) | 0);  /* check that PA_SINK_SET_FORMATS is an integer */
  return n;
}

static int _cffi_const_PA_SINK_INVALID_STATE(unsigned long long *o)
{
  int n = (PA_SINK_INVALID_STATE) <= 0;
  *o = (unsigned long long)((PA_SINK_INVALID_STATE) | 0);  /* check that PA_SINK_INVALID_STATE is an integer */
  return n;
}

static int _cffi_const_PA_SINK_RUNNING(unsigned long long *o)
{
  int n = (PA_SINK_RUNNING) <= 0;
  *o = (unsigned long long)((PA_SINK_RUNNING) | 0);  /* check that PA_SINK_RUNNING is an integer */
  return n;
}

static int _cffi_const_PA_SINK_IDLE(unsigned long long *o)
{
  int n = (PA_SINK_IDLE) <= 0;
  *o = (unsigned long long)((PA_SINK_IDLE) | 0);  /* check that PA_SINK_IDLE is an integer */
  return n;
}

static int _cffi_const_PA_SINK_SUSPENDED(unsigned long long *o)
{
  int n = (PA_SINK_SUSPENDED) <= 0;
  *o = (unsigned long long)((PA_SINK_SUSPENDED) | 0);  /* check that PA_SINK_SUSPENDED is an integer */
  return n;
}

static int _cffi_const_PA_SINK_INIT(unsigned long long *o)
{
  int n = (PA_SINK_INIT) <= 0;
  *o = (unsigned long long)((PA_SINK_INIT) | 0);  /* check that PA_SINK_INIT is an integer */
  return n;
}

static int _cffi_const_PA_SINK_UNLINKED(unsigned long long *o)
{
  int n = (PA_SINK_UNLINKED) <= 0;
  *o = (unsigned long long)((PA_SINK_UNLINKED) | 0);  /* check that PA_SINK_UNLINKED is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_EVENT_SINK(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_EVENT_SINK) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_EVENT_SINK) | 0);  /* check that PA_SUBSCRIPTION_EVENT_SINK is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_EVENT_SOURCE(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_EVENT_SOURCE) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_EVENT_SOURCE) | 0);  /* check that PA_SUBSCRIPTION_EVENT_SOURCE is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_EVENT_SINK_INPUT(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_EVENT_SINK_INPUT) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_EVENT_SINK_INPUT) | 0);  /* check that PA_SUBSCRIPTION_EVENT_SINK_INPUT is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_EVENT_SOURCE_OUTPUT(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_EVENT_SOURCE_OUTPUT) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_EVENT_SOURCE_OUTPUT) | 0);  /* check that PA_SUBSCRIPTION_EVENT_SOURCE_OUTPUT is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_EVENT_MODULE(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_EVENT_MODULE) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_EVENT_MODULE) | 0);  /* check that PA_SUBSCRIPTION_EVENT_MODULE is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_EVENT_CLIENT(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_EVENT_CLIENT) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_EVENT_CLIENT) | 0);  /* check that PA_SUBSCRIPTION_EVENT_CLIENT is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_EVENT_SAMPLE_CACHE(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_EVENT_SAMPLE_CACHE) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_EVENT_SAMPLE_CACHE) | 0);  /* check that PA_SUBSCRIPTION_EVENT_SAMPLE_CACHE is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_EVENT_SERVER(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_EVENT_SERVER) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_EVENT_SERVER) | 0);  /* check that PA_SUBSCRIPTION_EVENT_SERVER is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_EVENT_AUTOLOAD(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_EVENT_AUTOLOAD) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_EVENT_AUTOLOAD) | 0);  /* check that PA_SUBSCRIPTION_EVENT_AUTOLOAD is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_EVENT_CARD(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_EVENT_CARD) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_EVENT_CARD) | 0);  /* check that PA_SUBSCRIPTION_EVENT_CARD is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_EVENT_FACILITY_MASK(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_EVENT_FACILITY_MASK) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_EVENT_FACILITY_MASK) | 0);  /* check that PA_SUBSCRIPTION_EVENT_FACILITY_MASK is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_EVENT_NEW(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_EVENT_NEW) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_EVENT_NEW) | 0);  /* check that PA_SUBSCRIPTION_EVENT_NEW is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_EVENT_CHANGE(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_EVENT_CHANGE) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_EVENT_CHANGE) | 0);  /* check that PA_SUBSCRIPTION_EVENT_CHANGE is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_EVENT_REMOVE(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_EVENT_REMOVE) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_EVENT_REMOVE) | 0);  /* check that PA_SUBSCRIPTION_EVENT_REMOVE is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_EVENT_TYPE_MASK(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_EVENT_TYPE_MASK) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_EVENT_TYPE_MASK) | 0);  /* check that PA_SUBSCRIPTION_EVENT_TYPE_MASK is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_MASK_NULL(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_MASK_NULL) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_MASK_NULL) | 0);  /* check that PA_SUBSCRIPTION_MASK_NULL is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_MASK_SINK(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_MASK_SINK) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_MASK_SINK) | 0);  /* check that PA_SUBSCRIPTION_MASK_SINK is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_MASK_SOURCE(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_MASK_SOURCE) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_MASK_SOURCE) | 0);  /* check that PA_SUBSCRIPTION_MASK_SOURCE is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_MASK_SINK_INPUT(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_MASK_SINK_INPUT) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_MASK_SINK_INPUT) | 0);  /* check that PA_SUBSCRIPTION_MASK_SINK_INPUT is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_MASK_SOURCE_OUTPUT(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_MASK_SOURCE_OUTPUT) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_MASK_SOURCE_OUTPUT) | 0);  /* check that PA_SUBSCRIPTION_MASK_SOURCE_OUTPUT is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_MASK_MODULE(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_MASK_MODULE) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_MASK_MODULE) | 0);  /* check that PA_SUBSCRIPTION_MASK_MODULE is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_MASK_CLIENT(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_MASK_CLIENT) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_MASK_CLIENT) | 0);  /* check that PA_SUBSCRIPTION_MASK_CLIENT is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_MASK_SAMPLE_CACHE(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_MASK_SAMPLE_CACHE) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_MASK_SAMPLE_CACHE) | 0);  /* check that PA_SUBSCRIPTION_MASK_SAMPLE_CACHE is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_MASK_SERVER(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_MASK_SERVER) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_MASK_SERVER) | 0);  /* check that PA_SUBSCRIPTION_MASK_SERVER is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_MASK_AUTOLOAD(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_MASK_AUTOLOAD) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_MASK_AUTOLOAD) | 0);  /* check that PA_SUBSCRIPTION_MASK_AUTOLOAD is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_MASK_CARD(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_MASK_CARD) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_MASK_CARD) | 0);  /* check that PA_SUBSCRIPTION_MASK_CARD is an integer */
  return n;
}

static int _cffi_const_PA_SUBSCRIPTION_MASK_ALL(unsigned long long *o)
{
  int n = (PA_SUBSCRIPTION_MASK_ALL) <= 0;
  *o = (unsigned long long)((PA_SUBSCRIPTION_MASK_ALL) | 0);  /* check that PA_SUBSCRIPTION_MASK_ALL is an integer */
  return n;
}

static struct _cffi_externpy_s _cffi_externpy__qtile_on_server_info =
  { "libqtile.widget._pulse_audio.qtile_on_server_info", 0, 0, 0 };

static void qtile_on_server_info(pa_context * a0, pa_server_info const * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(pa_context * *)(p + 0) = a0;
  *(pa_server_info const * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__qtile_on_server_info, p);
}

static struct _cffi_externpy_s _cffi_externpy__qtile_on_sink_info =
  { "libqtile.widget._pulse_audio.qtile_on_sink_info", 0, 0, 0 };

static void qtile_on_sink_info(pa_context * a0, pa_sink_info const * a1, int a2, void * a3)
{
  char a[32];
  char *p = a;
  *(pa_context * *)(p + 0) = a0;
  *(pa_sink_info const * *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__qtile_on_sink_info, p);
}

static struct _cffi_externpy_s _cffi_externpy__qtile_on_sink_update =
  { "libqtile.widget._pulse_audio.qtile_on_sink_update", 0, 0, 0 };

static void qtile_on_sink_update(pa_context * a0, pa_subscription_event_type_t a1, uint32_t a2, void * a3)
{
  char a[32];
  char *p = a;
  *(pa_context * *)(p + 0) = a0;
  *(pa_subscription_event_type_t *)(p + 8) = a1;
  *(uint32_t *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__qtile_on_sink_update, p);
}

static struct _cffi_externpy_s _cffi_externpy__qtile_pa_context_changed =
  { "libqtile.widget._pulse_audio.qtile_pa_context_changed", 0, 0, 0 };

static void qtile_pa_context_changed(pa_context * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(pa_context * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__qtile_pa_context_changed, p);
}

static int _cffi_d_pa_context_connect(pa_context * x0, char const * x1, pa_context_flags_t x2, pa_spawn_api const * x3)
{
  return pa_context_connect(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_context_connect(PyObject *self, PyObject *args)
{
  pa_context * x0;
  char const * x1;
  pa_context_flags_t x2;
  pa_spawn_api const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "pa_context_connect", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(8), arg2) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (pa_spawn_api const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_context_connect(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_context_connect _cffi_d_pa_context_connect
#endif

static void _cffi_d_pa_context_disconnect(pa_context * x0)
{
  pa_context_disconnect(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_context_disconnect(PyObject *self, PyObject *arg0)
{
  pa_context * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { pa_context_disconnect(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_pa_context_disconnect _cffi_d_pa_context_disconnect
#endif

static pa_operation * _cffi_d_pa_context_get_server_info(pa_context * x0, void(* x1)(pa_context *, pa_server_info const *, void *), void * x2)
{
  return pa_context_get_server_info(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_context_get_server_info(PyObject *self, PyObject *args)
{
  pa_context * x0;
  void(* x1)(pa_context *, pa_server_info const *, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  pa_operation * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "pa_context_get_server_info", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(pa_context *, pa_server_info const *, void *))_cffi_to_c_pointer(arg1, _cffi_type(94));
  if (x1 == (void(*)(pa_context *, pa_server_info const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_context_get_server_info(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_context_get_server_info _cffi_d_pa_context_get_server_info
#endif

static pa_operation * _cffi_d_pa_context_get_sink_info_list(pa_context * x0, void(* x1)(pa_context *, pa_sink_info const *, int, void *), void * x2)
{
  return pa_context_get_sink_info_list(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_context_get_sink_info_list(PyObject *self, PyObject *args)
{
  pa_context * x0;
  void(* x1)(pa_context *, pa_sink_info const *, int, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  pa_operation * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "pa_context_get_sink_info_list", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(pa_context *, pa_sink_info const *, int, void *))_cffi_to_c_pointer(arg1, _cffi_type(99));
  if (x1 == (void(*)(pa_context *, pa_sink_info const *, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_context_get_sink_info_list(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_context_get_sink_info_list _cffi_d_pa_context_get_sink_info_list
#endif

static pa_context_state_t _cffi_d_pa_context_get_state(pa_context * x0)
{
  return pa_context_get_state(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_context_get_state(PyObject *self, PyObject *arg0)
{
  pa_context * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  pa_context_state_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_context_get_state(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(162));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_context_get_state _cffi_d_pa_context_get_state
#endif

static pa_context * _cffi_d_pa_context_new(pa_mainloop_api * x0, char const * x1)
{
  return pa_context_new(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_context_new(PyObject *self, PyObject *args)
{
  pa_mainloop_api * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  pa_context * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "pa_context_new", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_mainloop_api *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(35), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_context_new(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(6));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_context_new _cffi_d_pa_context_new
#endif

static pa_operation * _cffi_d_pa_context_set_sink_mute_by_index(pa_context * x0, uint32_t x1, int x2, void(* x3)(pa_context *, int, void *), void * x4)
{
  return pa_context_set_sink_mute_by_index(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_context_set_sink_mute_by_index(PyObject *self, PyObject *args)
{
  pa_context * x0;
  uint32_t x1;
  int x2;
  void(* x3)(pa_context *, int, void *);
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  pa_operation * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "pa_context_set_sink_mute_by_index", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (void(*)(pa_context *, int, void *))_cffi_to_c_pointer(arg3, _cffi_type(62));
  if (x3 == (void(*)(pa_context *, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_context_set_sink_mute_by_index(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_context_set_sink_mute_by_index _cffi_d_pa_context_set_sink_mute_by_index
#endif

static pa_operation * _cffi_d_pa_context_set_sink_mute_by_name(pa_context * x0, char const * x1, int x2, void(* x3)(pa_context *, int, void *), void * x4)
{
  return pa_context_set_sink_mute_by_name(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_context_set_sink_mute_by_name(PyObject *self, PyObject *args)
{
  pa_context * x0;
  char const * x1;
  int x2;
  void(* x3)(pa_context *, int, void *);
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  pa_operation * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "pa_context_set_sink_mute_by_name", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (void(*)(pa_context *, int, void *))_cffi_to_c_pointer(arg3, _cffi_type(62));
  if (x3 == (void(*)(pa_context *, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_context_set_sink_mute_by_name(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_context_set_sink_mute_by_name _cffi_d_pa_context_set_sink_mute_by_name
#endif

static pa_operation * _cffi_d_pa_context_set_sink_volume_by_index(pa_context * x0, uint32_t x1, pa_cvolume const * x2, void(* x3)(pa_context *, int, void *), void * x4)
{
  return pa_context_set_sink_volume_by_index(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_context_set_sink_volume_by_index(PyObject *self, PyObject *args)
{
  pa_context * x0;
  uint32_t x1;
  pa_cvolume const * x2;
  void(* x3)(pa_context *, int, void *);
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  pa_operation * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "pa_context_set_sink_volume_by_index", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (pa_cvolume const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = (void(*)(pa_context *, int, void *))_cffi_to_c_pointer(arg3, _cffi_type(62));
  if (x3 == (void(*)(pa_context *, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_context_set_sink_volume_by_index(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_context_set_sink_volume_by_index _cffi_d_pa_context_set_sink_volume_by_index
#endif

static pa_operation * _cffi_d_pa_context_set_sink_volume_by_name(pa_context * x0, char const * x1, pa_cvolume const * x2, void(* x3)(pa_context *, int, void *), void * x4)
{
  return pa_context_set_sink_volume_by_name(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_context_set_sink_volume_by_name(PyObject *self, PyObject *args)
{
  pa_context * x0;
  char const * x1;
  pa_cvolume const * x2;
  void(* x3)(pa_context *, int, void *);
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  pa_operation * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "pa_context_set_sink_volume_by_name", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (pa_cvolume const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = (void(*)(pa_context *, int, void *))_cffi_to_c_pointer(arg3, _cffi_type(62));
  if (x3 == (void(*)(pa_context *, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_context_set_sink_volume_by_name(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_context_set_sink_volume_by_name _cffi_d_pa_context_set_sink_volume_by_name
#endif

static void _cffi_d_pa_context_set_state_callback(pa_context * x0, void(* x1)(pa_context *, void *), void * x2)
{
  pa_context_set_state_callback(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_context_set_state_callback(PyObject *self, PyObject *args)
{
  pa_context * x0;
  void(* x1)(pa_context *, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "pa_context_set_state_callback", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(pa_context *, void *))_cffi_to_c_pointer(arg1, _cffi_type(144));
  if (x1 == (void(*)(pa_context *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { pa_context_set_state_callback(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_pa_context_set_state_callback _cffi_d_pa_context_set_state_callback
#endif

static void _cffi_d_pa_context_set_subscribe_callback(pa_context * x0, void(* x1)(pa_context *, pa_subscription_event_type_t, uint32_t, void *), void * x2)
{
  pa_context_set_subscribe_callback(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_context_set_subscribe_callback(PyObject *self, PyObject *args)
{
  pa_context * x0;
  void(* x1)(pa_context *, pa_subscription_event_type_t, uint32_t, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "pa_context_set_subscribe_callback", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(pa_context *, pa_subscription_event_type_t, uint32_t, void *))_cffi_to_c_pointer(arg1, _cffi_type(139));
  if (x1 == (void(*)(pa_context *, pa_subscription_event_type_t, uint32_t, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { pa_context_set_subscribe_callback(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_pa_context_set_subscribe_callback _cffi_d_pa_context_set_subscribe_callback
#endif

static pa_operation * _cffi_d_pa_context_subscribe(pa_context * x0, pa_subscription_mask_t x1, void(* x2)(pa_context *, int, void *), void * x3)
{
  return pa_context_subscribe(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_context_subscribe(PyObject *self, PyObject *args)
{
  pa_context * x0;
  pa_subscription_mask_t x1;
  void(* x2)(pa_context *, int, void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  pa_operation * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "pa_context_subscribe", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(74), arg1) < 0)
    return NULL;

  x2 = (void(*)(pa_context *, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(62));
  if (x2 == (void(*)(pa_context *, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_context_subscribe(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_context_subscribe _cffi_d_pa_context_subscribe
#endif

static void _cffi_d_pa_context_unref(pa_context * x0)
{
  pa_context_unref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_context_unref(PyObject *self, PyObject *arg0)
{
  pa_context * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { pa_context_unref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_pa_context_unref _cffi_d_pa_context_unref
#endif

static uint32_t _cffi_d_pa_cvolume_avg(pa_cvolume const * x0)
{
  return pa_cvolume_avg(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_cvolume_avg(PyObject *self, PyObject *arg0)
{
  pa_cvolume const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_cvolume const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_cvolume_avg(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_cvolume_avg _cffi_d_pa_cvolume_avg
#endif

static int _cffi_d_pa_cvolume_channels_equal_to(pa_cvolume const * x0, uint32_t x1)
{
  return pa_cvolume_channels_equal_to(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_cvolume_channels_equal_to(PyObject *self, PyObject *args)
{
  pa_cvolume const * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "pa_cvolume_channels_equal_to", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_cvolume const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_cvolume_channels_equal_to(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_cvolume_channels_equal_to _cffi_d_pa_cvolume_channels_equal_to
#endif

static pa_cvolume * _cffi_d_pa_cvolume_dec(pa_cvolume * x0, uint32_t x1)
{
  return pa_cvolume_dec(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_cvolume_dec(PyObject *self, PyObject *args)
{
  pa_cvolume * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  pa_cvolume * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "pa_cvolume_dec", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_cvolume *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_cvolume_dec(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(42));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_cvolume_dec _cffi_d_pa_cvolume_dec
#endif

static pa_cvolume * _cffi_d_pa_cvolume_inc(pa_cvolume * x0, uint32_t x1)
{
  return pa_cvolume_inc(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_cvolume_inc(PyObject *self, PyObject *args)
{
  pa_cvolume * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  pa_cvolume * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "pa_cvolume_inc", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_cvolume *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_cvolume_inc(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(42));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_cvolume_inc _cffi_d_pa_cvolume_inc
#endif

static pa_cvolume * _cffi_d_pa_cvolume_init(pa_cvolume * x0)
{
  return pa_cvolume_init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_cvolume_init(PyObject *self, PyObject *arg0)
{
  pa_cvolume * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  pa_cvolume * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_cvolume *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_cvolume_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(42));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_cvolume_init _cffi_d_pa_cvolume_init
#endif

static uint32_t _cffi_d_pa_cvolume_max(pa_cvolume const * x0)
{
  return pa_cvolume_max(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_cvolume_max(PyObject *self, PyObject *arg0)
{
  pa_cvolume const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_cvolume const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_cvolume_max(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_cvolume_max _cffi_d_pa_cvolume_max
#endif

static pa_cvolume * _cffi_d_pa_cvolume_scale(pa_cvolume * x0, uint32_t x1)
{
  return pa_cvolume_scale(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_cvolume_scale(PyObject *self, PyObject *args)
{
  pa_cvolume * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  pa_cvolume * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "pa_cvolume_scale", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_cvolume *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_cvolume_scale(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(42));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_cvolume_scale _cffi_d_pa_cvolume_scale
#endif

static pa_cvolume * _cffi_d_pa_cvolume_set(pa_cvolume * x0, unsigned int x1, uint32_t x2)
{
  return pa_cvolume_set(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_cvolume_set(PyObject *self, PyObject *args)
{
  pa_cvolume * x0;
  unsigned int x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  pa_cvolume * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "pa_cvolume_set", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_cvolume *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_cvolume_set(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(42));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_cvolume_set _cffi_d_pa_cvolume_set
#endif

static char * _cffi_d_pa_cvolume_snprint(char * x0, size_t x1, pa_cvolume const * x2)
{
  return pa_cvolume_snprint(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_cvolume_snprint(PyObject *self, PyObject *args)
{
  char * x0;
  size_t x1;
  pa_cvolume const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "pa_cvolume_snprint", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (pa_cvolume const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_cvolume_snprint(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_cvolume_snprint _cffi_d_pa_cvolume_snprint
#endif

static int _cffi_d_pa_cvolume_valid(pa_cvolume const * x0)
{
  return pa_cvolume_valid(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_cvolume_valid(PyObject *self, PyObject *arg0)
{
  pa_cvolume const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_cvolume const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_cvolume_valid(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_cvolume_valid _cffi_d_pa_cvolume_valid
#endif

static int _cffi_d_pa_mainloop_dispatch(pa_mainloop * x0)
{
  return pa_mainloop_dispatch(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_mainloop_dispatch(PyObject *self, PyObject *arg0)
{
  pa_mainloop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_mainloop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_mainloop_dispatch(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_mainloop_dispatch _cffi_d_pa_mainloop_dispatch
#endif

static void _cffi_d_pa_mainloop_free(pa_mainloop * x0)
{
  pa_mainloop_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_mainloop_free(PyObject *self, PyObject *arg0)
{
  pa_mainloop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_mainloop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { pa_mainloop_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_pa_mainloop_free _cffi_d_pa_mainloop_free
#endif

static pa_mainloop_api * _cffi_d_pa_mainloop_get_api(pa_mainloop * x0)
{
  return pa_mainloop_get_api(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_mainloop_get_api(PyObject *self, PyObject *arg0)
{
  pa_mainloop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  pa_mainloop_api * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_mainloop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_mainloop_get_api(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(35));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_mainloop_get_api _cffi_d_pa_mainloop_get_api
#endif

static int _cffi_d_pa_mainloop_get_retval(pa_mainloop * x0)
{
  return pa_mainloop_get_retval(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_mainloop_get_retval(PyObject *self, PyObject *arg0)
{
  pa_mainloop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_mainloop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_mainloop_get_retval(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_mainloop_get_retval _cffi_d_pa_mainloop_get_retval
#endif

static int _cffi_d_pa_mainloop_iterate(pa_mainloop * x0, int x1, int * x2)
{
  return pa_mainloop_iterate(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_mainloop_iterate(PyObject *self, PyObject *args)
{
  pa_mainloop * x0;
  int x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "pa_mainloop_iterate", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_mainloop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_mainloop_iterate(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_mainloop_iterate _cffi_d_pa_mainloop_iterate
#endif

static pa_mainloop * _cffi_d_pa_mainloop_new(void)
{
  return pa_mainloop_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_mainloop_new(PyObject *self, PyObject *noarg)
{
  pa_mainloop * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_mainloop_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(19));
  return pyresult;
}
#else
#  define _cffi_f_pa_mainloop_new _cffi_d_pa_mainloop_new
#endif

static int _cffi_d_pa_mainloop_poll(pa_mainloop * x0)
{
  return pa_mainloop_poll(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_mainloop_poll(PyObject *self, PyObject *arg0)
{
  pa_mainloop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_mainloop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_mainloop_poll(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_mainloop_poll _cffi_d_pa_mainloop_poll
#endif

static int _cffi_d_pa_mainloop_prepare(pa_mainloop * x0, int x1)
{
  return pa_mainloop_prepare(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_mainloop_prepare(PyObject *self, PyObject *args)
{
  pa_mainloop * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "pa_mainloop_prepare", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_mainloop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_mainloop_prepare(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_mainloop_prepare _cffi_d_pa_mainloop_prepare
#endif

static void _cffi_d_pa_mainloop_quit(pa_mainloop * x0, int x1)
{
  pa_mainloop_quit(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_mainloop_quit(PyObject *self, PyObject *args)
{
  pa_mainloop * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "pa_mainloop_quit", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_mainloop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { pa_mainloop_quit(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_pa_mainloop_quit _cffi_d_pa_mainloop_quit
#endif

static int _cffi_d_pa_mainloop_run(pa_mainloop * x0, int * x1)
{
  return pa_mainloop_run(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_mainloop_run(PyObject *self, PyObject *args)
{
  pa_mainloop * x0;
  int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "pa_mainloop_run", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_mainloop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_mainloop_run(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_mainloop_run _cffi_d_pa_mainloop_run
#endif

static pa_operation_state_t _cffi_d_pa_operation_get_state(pa_operation * x0)
{
  return pa_operation_get_state(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pa_operation_get_state(PyObject *self, PyObject *arg0)
{
  pa_operation * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  pa_operation_state_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(103), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (pa_operation *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(103), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pa_operation_get_state(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(171));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pa_operation_get_state _cffi_d_pa_operation_get_state
#endif

static int _cffi_const_PA_CHANNELS_MAX(unsigned long long *o)
{
  int n = (PA_CHANNELS_MAX) <= 0;
  *o = (unsigned long long)((PA_CHANNELS_MAX) | 0);  /* check that PA_CHANNELS_MAX is an integer */
  return n;
}

static int _cffi_const_PA_VOLUME_MAX(unsigned long long *o)
{
  int n = (PA_VOLUME_MAX) <= 0;
  *o = (unsigned long long)((PA_VOLUME_MAX) | 0);  /* check that PA_VOLUME_MAX is an integer */
  return n;
}

static int _cffi_const_PA_VOLUME_MUTED(unsigned long long *o)
{
  int n = (PA_VOLUME_MUTED) <= 0;
  *o = (unsigned long long)((PA_VOLUME_MUTED) | 0);  /* check that PA_VOLUME_MUTED is an integer */
  return n;
}

static int _cffi_const_PA_VOLUME_NORM(unsigned long long *o)
{
  int n = (PA_VOLUME_NORM) <= 0;
  *o = (unsigned long long)((PA_VOLUME_NORM) | 0);  /* check that PA_VOLUME_NORM is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld__pa_channel_map(pa_channel_map *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->channels) | 0);  /* check that 'pa_channel_map.channels' is an integer */
  { pa_channel_position_t *tmp = &p->map[0]; (void)tmp; }
}
struct _cffi_align__pa_channel_map { char x; pa_channel_map y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__pa_format_info(pa_format_info *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { pa_encoding_t *tmp = &p->encoding; (void)tmp; }
  { pa_proplist * *tmp = &p->plist; (void)tmp; }
}
struct _cffi_align__pa_format_info { char x; pa_format_info y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__pa_sample_spec(pa_sample_spec *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { pa_sample_format_t *tmp = &p->format; (void)tmp; }
  (void)((p->rate) | 0);  /* check that 'pa_sample_spec.rate' is an integer */
  (void)((p->channels) | 0);  /* check that 'pa_sample_spec.channels' is an integer */
}
struct _cffi_align__pa_sample_spec { char x; pa_sample_spec y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__pa_server_info(pa_server_info *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->user_name; (void)tmp; }
  { char const * *tmp = &p->host_name; (void)tmp; }
  { char const * *tmp = &p->server_version; (void)tmp; }
  { char const * *tmp = &p->server_name; (void)tmp; }
  { pa_sample_spec *tmp = &p->sample_spec; (void)tmp; }
  { char const * *tmp = &p->default_sink_name; (void)tmp; }
  { char const * *tmp = &p->default_source_name; (void)tmp; }
  (void)((p->cookie) | 0);  /* check that 'pa_server_info.cookie' is an integer */
  { pa_channel_map *tmp = &p->channel_map; (void)tmp; }
}
struct _cffi_align__pa_server_info { char x; pa_server_info y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__pa_sink_info(pa_sink_info *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  (void)((p->index) | 0);  /* check that 'pa_sink_info.index' is an integer */
  { char const * *tmp = &p->description; (void)tmp; }
  { pa_sample_spec *tmp = &p->sample_spec; (void)tmp; }
  { pa_channel_map *tmp = &p->channel_map; (void)tmp; }
  (void)((p->owner_module) | 0);  /* check that 'pa_sink_info.owner_module' is an integer */
  { pa_cvolume *tmp = &p->volume; (void)tmp; }
  (void)((p->mute) | 0);  /* check that 'pa_sink_info.mute' is an integer */
  (void)((p->monitor_source) | 0);  /* check that 'pa_sink_info.monitor_source' is an integer */
  { char const * *tmp = &p->monitor_source_name; (void)tmp; }
  (void)((p->latency) | 0);  /* check that 'pa_sink_info.latency' is an integer */
  { char const * *tmp = &p->driver; (void)tmp; }
  { pa_sink_flags_t *tmp = &p->flags; (void)tmp; }
  { pa_proplist * *tmp = &p->proplist; (void)tmp; }
  (void)((p->configured_latency) | 0);  /* check that 'pa_sink_info.configured_latency' is an integer */
  (void)((p->base_volume) | 0);  /* check that 'pa_sink_info.base_volume' is an integer */
  { pa_sink_state_t *tmp = &p->state; (void)tmp; }
  (void)((p->n_volume_steps) | 0);  /* check that 'pa_sink_info.n_volume_steps' is an integer */
  (void)((p->card) | 0);  /* check that 'pa_sink_info.card' is an integer */
  (void)((p->n_ports) | 0);  /* check that 'pa_sink_info.n_ports' is an integer */
  { pa_sink_port_info * * *tmp = &p->ports; (void)tmp; }
  { pa_sink_port_info * *tmp = &p->active_port; (void)tmp; }
  (void)((p->n_formats) | 0);  /* check that 'pa_sink_info.n_formats' is an integer */
  { pa_format_info * * *tmp = &p->formats; (void)tmp; }
}
struct _cffi_align__pa_sink_info { char x; pa_sink_info y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__pa_sink_port_info(pa_sink_port_info *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  { char const * *tmp = &p->description; (void)tmp; }
  (void)((p->priority) | 0);  /* check that 'pa_sink_port_info.priority' is an integer */
  (void)((p->available) | 0);  /* check that 'pa_sink_port_info.available' is an integer */
}
struct _cffi_align__pa_sink_port_info { char x; pa_sink_port_info y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__pa_spawn_api(pa_spawn_api *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void(* *tmp)(void) = &p->prefork; (void)tmp; }
  { void(* *tmp)(void) = &p->postfork; (void)tmp; }
  { void(* *tmp)(void) = &p->atfork; (void)tmp; }
}
struct _cffi_align__pa_spawn_api { char x; pa_spawn_api y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "PA_CHANNELS_MAX", (void *)_cffi_const_PA_CHANNELS_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX0", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX0, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX1", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX10", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX10, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX11", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX11, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX12", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX12, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX13", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX13, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX14", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX14, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX15", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX15, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX16", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX16, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX17", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX17, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX18", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX18, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX19", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX19, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX2", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX2, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX20", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX20, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX21", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX21, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX22", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX22, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX23", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX23, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX24", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX24, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX25", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX25, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX26", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX26, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX27", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX27, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX28", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX28, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX29", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX29, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX3", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX3, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX30", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX30, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX31", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX31, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX4", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX4, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX5", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX5, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX6", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX6, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX7", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX7, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX8", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX8, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_AUX9", (void *)_cffi_const_PA_CHANNEL_POSITION_AUX9, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_CENTER", (void *)_cffi_const_PA_CHANNEL_POSITION_CENTER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_FRONT_CENTER", (void *)_cffi_const_PA_CHANNEL_POSITION_FRONT_CENTER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_FRONT_LEFT", (void *)_cffi_const_PA_CHANNEL_POSITION_FRONT_LEFT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_FRONT_LEFT_OF_CENTER", (void *)_cffi_const_PA_CHANNEL_POSITION_FRONT_LEFT_OF_CENTER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_FRONT_RIGHT", (void *)_cffi_const_PA_CHANNEL_POSITION_FRONT_RIGHT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_FRONT_RIGHT_OF_CENTER", (void *)_cffi_const_PA_CHANNEL_POSITION_FRONT_RIGHT_OF_CENTER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_INVALID", (void *)_cffi_const_PA_CHANNEL_POSITION_INVALID, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_LEFT", (void *)_cffi_const_PA_CHANNEL_POSITION_LEFT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_LFE", (void *)_cffi_const_PA_CHANNEL_POSITION_LFE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_MAX", (void *)_cffi_const_PA_CHANNEL_POSITION_MAX, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_MONO", (void *)_cffi_const_PA_CHANNEL_POSITION_MONO, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_REAR_CENTER", (void *)_cffi_const_PA_CHANNEL_POSITION_REAR_CENTER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_REAR_LEFT", (void *)_cffi_const_PA_CHANNEL_POSITION_REAR_LEFT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_REAR_RIGHT", (void *)_cffi_const_PA_CHANNEL_POSITION_REAR_RIGHT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_RIGHT", (void *)_cffi_const_PA_CHANNEL_POSITION_RIGHT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_SIDE_LEFT", (void *)_cffi_const_PA_CHANNEL_POSITION_SIDE_LEFT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_SIDE_RIGHT", (void *)_cffi_const_PA_CHANNEL_POSITION_SIDE_RIGHT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_SUBWOOFER", (void *)_cffi_const_PA_CHANNEL_POSITION_SUBWOOFER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_TOP_CENTER", (void *)_cffi_const_PA_CHANNEL_POSITION_TOP_CENTER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_TOP_FRONT_CENTER", (void *)_cffi_const_PA_CHANNEL_POSITION_TOP_FRONT_CENTER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_TOP_FRONT_LEFT", (void *)_cffi_const_PA_CHANNEL_POSITION_TOP_FRONT_LEFT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_TOP_FRONT_RIGHT", (void *)_cffi_const_PA_CHANNEL_POSITION_TOP_FRONT_RIGHT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_TOP_REAR_CENTER", (void *)_cffi_const_PA_CHANNEL_POSITION_TOP_REAR_CENTER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_TOP_REAR_LEFT", (void *)_cffi_const_PA_CHANNEL_POSITION_TOP_REAR_LEFT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CHANNEL_POSITION_TOP_REAR_RIGHT", (void *)_cffi_const_PA_CHANNEL_POSITION_TOP_REAR_RIGHT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CONTEXT_AUTHORIZING", (void *)_cffi_const_PA_CONTEXT_AUTHORIZING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CONTEXT_CONNECTING", (void *)_cffi_const_PA_CONTEXT_CONNECTING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CONTEXT_FAILED", (void *)_cffi_const_PA_CONTEXT_FAILED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CONTEXT_NOAUTOSPAWN", (void *)_cffi_const_PA_CONTEXT_NOAUTOSPAWN, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CONTEXT_NOFAIL", (void *)_cffi_const_PA_CONTEXT_NOFAIL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CONTEXT_NOFLAGS", (void *)_cffi_const_PA_CONTEXT_NOFLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CONTEXT_READY", (void *)_cffi_const_PA_CONTEXT_READY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CONTEXT_SETTING_NAME", (void *)_cffi_const_PA_CONTEXT_SETTING_NAME, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CONTEXT_TERMINATED", (void *)_cffi_const_PA_CONTEXT_TERMINATED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_CONTEXT_UNCONNECTED", (void *)_cffi_const_PA_CONTEXT_UNCONNECTED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_ENCODING_AC3_IEC61937", (void *)_cffi_const_PA_ENCODING_AC3_IEC61937, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_ENCODING_ANY", (void *)_cffi_const_PA_ENCODING_ANY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_ENCODING_DTS_IEC61937", (void *)_cffi_const_PA_ENCODING_DTS_IEC61937, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_ENCODING_EAC3_IEC61937", (void *)_cffi_const_PA_ENCODING_EAC3_IEC61937, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_ENCODING_INVALID", (void *)_cffi_const_PA_ENCODING_INVALID, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_ENCODING_MAX", (void *)_cffi_const_PA_ENCODING_MAX, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_ENCODING_MPEG2_AAC_IEC61937", (void *)_cffi_const_PA_ENCODING_MPEG2_AAC_IEC61937, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_ENCODING_MPEG_IEC61937", (void *)_cffi_const_PA_ENCODING_MPEG_IEC61937, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_ENCODING_PCM", (void *)_cffi_const_PA_ENCODING_PCM, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_OPERATION_CANCELLED", (void *)_cffi_const_PA_OPERATION_CANCELLED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_OPERATION_DONE", (void *)_cffi_const_PA_OPERATION_DONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_OPERATION_RUNNING", (void *)_cffi_const_PA_OPERATION_RUNNING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SAMPLE_ALAW", (void *)_cffi_const_PA_SAMPLE_ALAW, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SAMPLE_FLOAT32BE", (void *)_cffi_const_PA_SAMPLE_FLOAT32BE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SAMPLE_FLOAT32LE", (void *)_cffi_const_PA_SAMPLE_FLOAT32LE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SAMPLE_INVALID", (void *)_cffi_const_PA_SAMPLE_INVALID, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SAMPLE_MAX", (void *)_cffi_const_PA_SAMPLE_MAX, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SAMPLE_S16BE", (void *)_cffi_const_PA_SAMPLE_S16BE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SAMPLE_S16LE", (void *)_cffi_const_PA_SAMPLE_S16LE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SAMPLE_S24BE", (void *)_cffi_const_PA_SAMPLE_S24BE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SAMPLE_S24LE", (void *)_cffi_const_PA_SAMPLE_S24LE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SAMPLE_S24_32BE", (void *)_cffi_const_PA_SAMPLE_S24_32BE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SAMPLE_S24_32LE", (void *)_cffi_const_PA_SAMPLE_S24_32LE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SAMPLE_S32BE", (void *)_cffi_const_PA_SAMPLE_S32BE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SAMPLE_S32LE", (void *)_cffi_const_PA_SAMPLE_S32LE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SAMPLE_U8", (void *)_cffi_const_PA_SAMPLE_U8, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SAMPLE_ULAW", (void *)_cffi_const_PA_SAMPLE_ULAW, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SINK_DECIBEL_VOLUME", (void *)_cffi_const_PA_SINK_DECIBEL_VOLUME, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SINK_DYNAMIC_LATENCY", (void *)_cffi_const_PA_SINK_DYNAMIC_LATENCY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SINK_FLAT_VOLUME", (void *)_cffi_const_PA_SINK_FLAT_VOLUME, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SINK_HARDWARE", (void *)_cffi_const_PA_SINK_HARDWARE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SINK_HW_MUTE_CTRL", (void *)_cffi_const_PA_SINK_HW_MUTE_CTRL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SINK_HW_VOLUME_CTRL", (void *)_cffi_const_PA_SINK_HW_VOLUME_CTRL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SINK_IDLE", (void *)_cffi_const_PA_SINK_IDLE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SINK_INIT", (void *)_cffi_const_PA_SINK_INIT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SINK_INVALID_STATE", (void *)_cffi_const_PA_SINK_INVALID_STATE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SINK_LATENCY", (void *)_cffi_const_PA_SINK_LATENCY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SINK_NETWORK", (void *)_cffi_const_PA_SINK_NETWORK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SINK_NOFLAGS", (void *)_cffi_const_PA_SINK_NOFLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SINK_RUNNING", (void *)_cffi_const_PA_SINK_RUNNING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SINK_SET_FORMATS", (void *)_cffi_const_PA_SINK_SET_FORMATS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SINK_SUSPENDED", (void *)_cffi_const_PA_SINK_SUSPENDED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SINK_UNLINKED", (void *)_cffi_const_PA_SINK_UNLINKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_EVENT_AUTOLOAD", (void *)_cffi_const_PA_SUBSCRIPTION_EVENT_AUTOLOAD, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_EVENT_CARD", (void *)_cffi_const_PA_SUBSCRIPTION_EVENT_CARD, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_EVENT_CHANGE", (void *)_cffi_const_PA_SUBSCRIPTION_EVENT_CHANGE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_EVENT_CLIENT", (void *)_cffi_const_PA_SUBSCRIPTION_EVENT_CLIENT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_EVENT_FACILITY_MASK", (void *)_cffi_const_PA_SUBSCRIPTION_EVENT_FACILITY_MASK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_EVENT_MODULE", (void *)_cffi_const_PA_SUBSCRIPTION_EVENT_MODULE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_EVENT_NEW", (void *)_cffi_const_PA_SUBSCRIPTION_EVENT_NEW, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_EVENT_REMOVE", (void *)_cffi_const_PA_SUBSCRIPTION_EVENT_REMOVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_EVENT_SAMPLE_CACHE", (void *)_cffi_const_PA_SUBSCRIPTION_EVENT_SAMPLE_CACHE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_EVENT_SERVER", (void *)_cffi_const_PA_SUBSCRIPTION_EVENT_SERVER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_EVENT_SINK", (void *)_cffi_const_PA_SUBSCRIPTION_EVENT_SINK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_EVENT_SINK_INPUT", (void *)_cffi_const_PA_SUBSCRIPTION_EVENT_SINK_INPUT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_EVENT_SOURCE", (void *)_cffi_const_PA_SUBSCRIPTION_EVENT_SOURCE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_EVENT_SOURCE_OUTPUT", (void *)_cffi_const_PA_SUBSCRIPTION_EVENT_SOURCE_OUTPUT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_EVENT_TYPE_MASK", (void *)_cffi_const_PA_SUBSCRIPTION_EVENT_TYPE_MASK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_MASK_ALL", (void *)_cffi_const_PA_SUBSCRIPTION_MASK_ALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_MASK_AUTOLOAD", (void *)_cffi_const_PA_SUBSCRIPTION_MASK_AUTOLOAD, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_MASK_CARD", (void *)_cffi_const_PA_SUBSCRIPTION_MASK_CARD, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_MASK_CLIENT", (void *)_cffi_const_PA_SUBSCRIPTION_MASK_CLIENT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_MASK_MODULE", (void *)_cffi_const_PA_SUBSCRIPTION_MASK_MODULE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_MASK_NULL", (void *)_cffi_const_PA_SUBSCRIPTION_MASK_NULL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_MASK_SAMPLE_CACHE", (void *)_cffi_const_PA_SUBSCRIPTION_MASK_SAMPLE_CACHE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_MASK_SERVER", (void *)_cffi_const_PA_SUBSCRIPTION_MASK_SERVER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_MASK_SINK", (void *)_cffi_const_PA_SUBSCRIPTION_MASK_SINK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_MASK_SINK_INPUT", (void *)_cffi_const_PA_SUBSCRIPTION_MASK_SINK_INPUT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_MASK_SOURCE", (void *)_cffi_const_PA_SUBSCRIPTION_MASK_SOURCE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_SUBSCRIPTION_MASK_SOURCE_OUTPUT", (void *)_cffi_const_PA_SUBSCRIPTION_MASK_SOURCE_OUTPUT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PA_VOLUME_MAX", (void *)_cffi_const_PA_VOLUME_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PA_VOLUME_MUTED", (void *)_cffi_const_PA_VOLUME_MUTED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PA_VOLUME_NORM", (void *)_cffi_const_PA_VOLUME_NORM, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "pa_context_connect", (void *)_cffi_f_pa_context_connect, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 5), (void *)_cffi_d_pa_context_connect },
  { "pa_context_disconnect", (void *)_cffi_f_pa_context_disconnect, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 108), (void *)_cffi_d_pa_context_disconnect },
  { "pa_context_get_server_info", (void *)_cffi_f_pa_context_get_server_info, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 92), (void *)_cffi_d_pa_context_get_server_info },
  { "pa_context_get_sink_info_list", (void *)_cffi_f_pa_context_get_sink_info_list, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 97), (void *)_cffi_d_pa_context_get_sink_info_list },
  { "pa_context_get_state", (void *)_cffi_f_pa_context_get_state, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 38), (void *)_cffi_d_pa_context_get_state },
  { "pa_context_new", (void *)_cffi_f_pa_context_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 34), (void *)_cffi_d_pa_context_new },
  { "pa_context_set_sink_mute_by_index", (void *)_cffi_f_pa_context_set_sink_mute_by_index, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 78), (void *)_cffi_d_pa_context_set_sink_mute_by_index },
  { "pa_context_set_sink_mute_by_name", (void *)_cffi_f_pa_context_set_sink_mute_by_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 58), (void *)_cffi_d_pa_context_set_sink_mute_by_name },
  { "pa_context_set_sink_volume_by_index", (void *)_cffi_f_pa_context_set_sink_volume_by_index, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 85), (void *)_cffi_d_pa_context_set_sink_volume_by_index },
  { "pa_context_set_sink_volume_by_name", (void *)_cffi_f_pa_context_set_sink_volume_by_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 65), (void *)_cffi_d_pa_context_set_sink_volume_by_name },
  { "pa_context_set_state_callback", (void *)_cffi_f_pa_context_set_state_callback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 142), (void *)_cffi_d_pa_context_set_state_callback },
  { "pa_context_set_subscribe_callback", (void *)_cffi_f_pa_context_set_subscribe_callback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 137), (void *)_cffi_d_pa_context_set_subscribe_callback },
  { "pa_context_subscribe", (void *)_cffi_f_pa_context_subscribe, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 72), (void *)_cffi_d_pa_context_subscribe },
  { "pa_context_unref", (void *)_cffi_f_pa_context_unref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 108), (void *)_cffi_d_pa_context_unref },
  { "pa_cvolume_avg", (void *)_cffi_f_pa_cvolume_avg, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 105), (void *)_cffi_d_pa_cvolume_avg },
  { "pa_cvolume_channels_equal_to", (void *)_cffi_f_pa_cvolume_channels_equal_to, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 14), (void *)_cffi_d_pa_cvolume_channels_equal_to },
  { "pa_cvolume_dec", (void *)_cffi_f_pa_cvolume_dec, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 44), (void *)_cffi_d_pa_cvolume_dec },
  { "pa_cvolume_inc", (void *)_cffi_f_pa_cvolume_inc, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 44), (void *)_cffi_d_pa_cvolume_inc },
  { "pa_cvolume_init", (void *)_cffi_f_pa_cvolume_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 41), (void *)_cffi_d_pa_cvolume_init },
  { "pa_cvolume_max", (void *)_cffi_f_pa_cvolume_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 105), (void *)_cffi_d_pa_cvolume_max },
  { "pa_cvolume_scale", (void *)_cffi_f_pa_cvolume_scale, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 44), (void *)_cffi_d_pa_cvolume_scale },
  { "pa_cvolume_set", (void *)_cffi_f_pa_cvolume_set, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 48), (void *)_cffi_d_pa_cvolume_set },
  { "pa_cvolume_snprint", (void *)_cffi_f_pa_cvolume_snprint, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_pa_cvolume_snprint },
  { "pa_cvolume_valid", (void *)_cffi_f_pa_cvolume_valid, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 11), (void *)_cffi_d_pa_cvolume_valid },
  { "pa_mainloop_dispatch", (void *)_cffi_f_pa_mainloop_dispatch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 18), (void *)_cffi_d_pa_mainloop_dispatch },
  { "pa_mainloop_free", (void *)_cffi_f_pa_mainloop_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 147), (void *)_cffi_d_pa_mainloop_free },
  { "pa_mainloop_get_api", (void *)_cffi_f_pa_mainloop_get_api, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 55), (void *)_cffi_d_pa_mainloop_get_api },
  { "pa_mainloop_get_retval", (void *)_cffi_f_pa_mainloop_get_retval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 18), (void *)_cffi_d_pa_mainloop_get_retval },
  { "pa_mainloop_iterate", (void *)_cffi_f_pa_mainloop_iterate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 29), (void *)_cffi_d_pa_mainloop_iterate },
  { "pa_mainloop_new", (void *)_cffi_f_pa_mainloop_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 53), (void *)_cffi_d_pa_mainloop_new },
  { "pa_mainloop_poll", (void *)_cffi_f_pa_mainloop_poll, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 18), (void *)_cffi_d_pa_mainloop_poll },
  { "pa_mainloop_prepare", (void *)_cffi_f_pa_mainloop_prepare, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 25), (void *)_cffi_d_pa_mainloop_prepare },
  { "pa_mainloop_quit", (void *)_cffi_f_pa_mainloop_quit, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 150), (void *)_cffi_d_pa_mainloop_quit },
  { "pa_mainloop_run", (void *)_cffi_f_pa_mainloop_run, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 21), (void *)_cffi_d_pa_mainloop_run },
  { "pa_operation_get_state", (void *)_cffi_f_pa_operation_get_state, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 102), (void *)_cffi_d_pa_operation_get_state },
  { "qtile_on_server_info", (void *)&_cffi_externpy__qtile_on_server_info, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 94), (void *)qtile_on_server_info },
  { "qtile_on_sink_info", (void *)&_cffi_externpy__qtile_on_sink_info, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 99), (void *)qtile_on_sink_info },
  { "qtile_on_sink_update", (void *)&_cffi_externpy__qtile_on_sink_update, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 139), (void *)qtile_on_sink_update },
  { "qtile_pa_context_changed", (void *)&_cffi_externpy__qtile_pa_context_changed, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 144), (void *)qtile_pa_context_changed },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "channels", offsetof(pa_cvolume, channels),
                sizeof(((pa_cvolume *)0)->channels),
                _CFFI_OP(_CFFI_OP_NOOP, 187) },
  { "values", offsetof(pa_cvolume, values),
              sizeof(((pa_cvolume *)0)->values),
              _CFFI_OP(_CFFI_OP_NOOP, 184) },
  { "channels", offsetof(pa_channel_map, channels),
                sizeof(((pa_channel_map *)0)->channels),
                _CFFI_OP(_CFFI_OP_NOOP, 187) },
  { "map", offsetof(pa_channel_map, map),
           sizeof(((pa_channel_map *)0)->map),
           _CFFI_OP(_CFFI_OP_NOOP, 159) },
  { "encoding", offsetof(pa_format_info, encoding),
                sizeof(((pa_format_info *)0)->encoding),
                _CFFI_OP(_CFFI_OP_NOOP, 164) },
  { "plist", offsetof(pa_format_info, plist),
             sizeof(((pa_format_info *)0)->plist),
             _CFFI_OP(_CFFI_OP_NOOP, 172) },
  { "format", offsetof(pa_sample_spec, format),
              sizeof(((pa_sample_spec *)0)->format),
              _CFFI_OP(_CFFI_OP_NOOP, 174) },
  { "rate", offsetof(pa_sample_spec, rate),
            sizeof(((pa_sample_spec *)0)->rate),
            _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "channels", offsetof(pa_sample_spec, channels),
                sizeof(((pa_sample_spec *)0)->channels),
                _CFFI_OP(_CFFI_OP_NOOP, 187) },
  { "user_name", offsetof(pa_server_info, user_name),
                 sizeof(((pa_server_info *)0)->user_name),
                 _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "host_name", offsetof(pa_server_info, host_name),
                 sizeof(((pa_server_info *)0)->host_name),
                 _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "server_version", offsetof(pa_server_info, server_version),
                      sizeof(((pa_server_info *)0)->server_version),
                      _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "server_name", offsetof(pa_server_info, server_name),
                   sizeof(((pa_server_info *)0)->server_name),
                   _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "sample_spec", offsetof(pa_server_info, sample_spec),
                   sizeof(((pa_server_info *)0)->sample_spec),
                   _CFFI_OP(_CFFI_OP_NOOP, 175) },
  { "default_sink_name", offsetof(pa_server_info, default_sink_name),
                         sizeof(((pa_server_info *)0)->default_sink_name),
                         _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "default_source_name", offsetof(pa_server_info, default_source_name),
                           sizeof(((pa_server_info *)0)->default_source_name),
                           _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "cookie", offsetof(pa_server_info, cookie),
              sizeof(((pa_server_info *)0)->cookie),
              _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "channel_map", offsetof(pa_server_info, channel_map),
                   sizeof(((pa_server_info *)0)->channel_map),
                   _CFFI_OP(_CFFI_OP_NOOP, 157) },
  { "name", offsetof(pa_sink_info, name),
            sizeof(((pa_sink_info *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "index", offsetof(pa_sink_info, index),
             sizeof(((pa_sink_info *)0)->index),
             _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "description", offsetof(pa_sink_info, description),
                   sizeof(((pa_sink_info *)0)->description),
                   _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "sample_spec", offsetof(pa_sink_info, sample_spec),
                   sizeof(((pa_sink_info *)0)->sample_spec),
                   _CFFI_OP(_CFFI_OP_NOOP, 175) },
  { "channel_map", offsetof(pa_sink_info, channel_map),
                   sizeof(((pa_sink_info *)0)->channel_map),
                   _CFFI_OP(_CFFI_OP_NOOP, 157) },
  { "owner_module", offsetof(pa_sink_info, owner_module),
                    sizeof(((pa_sink_info *)0)->owner_module),
                    _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "volume", offsetof(pa_sink_info, volume),
              sizeof(((pa_sink_info *)0)->volume),
              _CFFI_OP(_CFFI_OP_NOOP, 163) },
  { "mute", offsetof(pa_sink_info, mute),
            sizeof(((pa_sink_info *)0)->mute),
            _CFFI_OP(_CFFI_OP_NOOP, 27) },
  { "monitor_source", offsetof(pa_sink_info, monitor_source),
                      sizeof(((pa_sink_info *)0)->monitor_source),
                      _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "monitor_source_name", offsetof(pa_sink_info, monitor_source_name),
                           sizeof(((pa_sink_info *)0)->monitor_source_name),
                           _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "latency", offsetof(pa_sink_info, latency),
               sizeof(((pa_sink_info *)0)->latency),
               _CFFI_OP(_CFFI_OP_NOOP, 186) },
  { "driver", offsetof(pa_sink_info, driver),
              sizeof(((pa_sink_info *)0)->driver),
              _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "flags", offsetof(pa_sink_info, flags),
             sizeof(((pa_sink_info *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 177) },
  { "proplist", offsetof(pa_sink_info, proplist),
                sizeof(((pa_sink_info *)0)->proplist),
                _CFFI_OP(_CFFI_OP_NOOP, 172) },
  { "configured_latency", offsetof(pa_sink_info, configured_latency),
                          sizeof(((pa_sink_info *)0)->configured_latency),
                          _CFFI_OP(_CFFI_OP_NOOP, 186) },
  { "base_volume", offsetof(pa_sink_info, base_volume),
                   sizeof(((pa_sink_info *)0)->base_volume),
                   _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "state", offsetof(pa_sink_info, state),
             sizeof(((pa_sink_info *)0)->state),
             _CFFI_OP(_CFFI_OP_NOOP, 182) },
  { "n_volume_steps", offsetof(pa_sink_info, n_volume_steps),
                      sizeof(((pa_sink_info *)0)->n_volume_steps),
                      _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "card", offsetof(pa_sink_info, card),
            sizeof(((pa_sink_info *)0)->card),
            _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "n_ports", offsetof(pa_sink_info, n_ports),
               sizeof(((pa_sink_info *)0)->n_ports),
               _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "ports", offsetof(pa_sink_info, ports),
             sizeof(((pa_sink_info *)0)->ports),
             _CFFI_OP(_CFFI_OP_NOOP, 179) },
  { "active_port", offsetof(pa_sink_info, active_port),
                   sizeof(((pa_sink_info *)0)->active_port),
                   _CFFI_OP(_CFFI_OP_NOOP, 180) },
  { "n_formats", offsetof(pa_sink_info, n_formats),
                 sizeof(((pa_sink_info *)0)->n_formats),
                 _CFFI_OP(_CFFI_OP_NOOP, 187) },
  { "formats", offsetof(pa_sink_info, formats),
               sizeof(((pa_sink_info *)0)->formats),
               _CFFI_OP(_CFFI_OP_NOOP, 165) },
  { "name", offsetof(pa_sink_port_info, name),
            sizeof(((pa_sink_port_info *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "description", offsetof(pa_sink_port_info, description),
                   sizeof(((pa_sink_port_info *)0)->description),
                   _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "priority", offsetof(pa_sink_port_info, priority),
                sizeof(((pa_sink_port_info *)0)->priority),
                _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "available", offsetof(pa_sink_port_info, available),
                 sizeof(((pa_sink_port_info *)0)->available),
                 _CFFI_OP(_CFFI_OP_NOOP, 27) },
  { "prefork", offsetof(pa_spawn_api, prefork),
               sizeof(((pa_spawn_api *)0)->prefork),
               _CFFI_OP(_CFFI_OP_NOOP, 188) },
  { "postfork", offsetof(pa_spawn_api, postfork),
                sizeof(((pa_spawn_api *)0)->postfork),
                _CFFI_OP(_CFFI_OP_NOOP, 188) },
  { "atfork", offsetof(pa_spawn_api, atfork),
              sizeof(((pa_spawn_api *)0)->atfork),
              _CFFI_OP(_CFFI_OP_NOOP, 188) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$pa_cvolume", 163, 0,
    sizeof(pa_cvolume), offsetof(struct _cffi_align_typedef_pa_cvolume, y), 0, 2 },
  { "pa_channel_map", 157, 0,
    sizeof(pa_channel_map), offsetof(struct _cffi_align__pa_channel_map, y), 2, 2 },
  { "pa_context", 161, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "pa_format_info", 167, _CFFI_F_CHECK_FIELDS,
    sizeof(pa_format_info), offsetof(struct _cffi_align__pa_format_info, y), 4, 2 },
  { "pa_mainloop", 168, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "pa_mainloop_api", 169, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "pa_operation", 170, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "pa_proplist", 173, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "pa_sample_spec", 175, _CFFI_F_CHECK_FIELDS,
    sizeof(pa_sample_spec), offsetof(struct _cffi_align__pa_sample_spec, y), 6, 3 },
  { "pa_server_info", 176, 0,
    sizeof(pa_server_info), offsetof(struct _cffi_align__pa_server_info, y), 9, 9 },
  { "pa_sink_info", 178, 0,
    sizeof(pa_sink_info), offsetof(struct _cffi_align__pa_sink_info, y), 18, 24 },
  { "pa_sink_port_info", 181, _CFFI_F_CHECK_FIELDS,
    sizeof(pa_sink_port_info), offsetof(struct _cffi_align__pa_sink_port_info, y), 42, 4 },
  { "pa_spawn_api", 183, _CFFI_F_CHECK_FIELDS,
    sizeof(pa_spawn_api), offsetof(struct _cffi_align__pa_spawn_api, y), 46, 3 },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "pa_channel_position", 158, _cffi_prim_int(sizeof(pa_channel_position_t), ((pa_channel_position_t)-1) <= 0),
    "PA_CHANNEL_POSITION_INVALID,PA_CHANNEL_POSITION_MONO,PA_CHANNEL_POSITION_FRONT_LEFT,PA_CHANNEL_POSITION_FRONT_RIGHT,PA_CHANNEL_POSITION_FRONT_CENTER,PA_CHANNEL_POSITION_LEFT,PA_CHANNEL_POSITION_RIGHT,PA_CHANNEL_POSITION_CENTER,PA_CHANNEL_POSITION_REAR_CENTER,PA_CHANNEL_POSITION_REAR_LEFT,PA_CHANNEL_POSITION_REAR_RIGHT,PA_CHANNEL_POSITION_LFE,PA_CHANNEL_POSITION_SUBWOOFER,PA_CHANNEL_POSITION_FRONT_LEFT_OF_CENTER,PA_CHANNEL_POSITION_FRONT_RIGHT_OF_CENTER,PA_CHANNEL_POSITION_SIDE_LEFT,PA_CHANNEL_POSITION_SIDE_RIGHT,PA_CHANNEL_POSITION_AUX0,PA_CHANNEL_POSITION_AUX1,PA_CHANNEL_POSITION_AUX2,PA_CHANNEL_POSITION_AUX3,PA_CHANNEL_POSITION_AUX4,PA_CHANNEL_POSITION_AUX5,PA_CHANNEL_POSITION_AUX6,PA_CHANNEL_POSITION_AUX7,PA_CHANNEL_POSITION_AUX8,PA_CHANNEL_POSITION_AUX9,PA_CHANNEL_POSITION_AUX10,PA_CHANNEL_POSITION_AUX11,PA_CHANNEL_POSITION_AUX12,PA_CHANNEL_POSITION_AUX13,PA_CHANNEL_POSITION_AUX14,PA_CHANNEL_POSITION_AUX15,PA_CHANNEL_POSITION_AUX16,PA_CHANNEL_POSITION_AUX17,PA_CHANNEL_POSITION_AUX18,PA_CHANNEL_POSITION_AUX19,PA_CHANNEL_POSITION_AUX20,PA_CHANNEL_POSITION_AUX21,PA_CHANNEL_POSITION_AUX22,PA_CHANNEL_POSITION_AUX23,PA_CHANNEL_POSITION_AUX24,PA_CHANNEL_POSITION_AUX25,PA_CHANNEL_POSITION_AUX26,PA_CHANNEL_POSITION_AUX27,PA_CHANNEL_POSITION_AUX28,PA_CHANNEL_POSITION_AUX29,PA_CHANNEL_POSITION_AUX30,PA_CHANNEL_POSITION_AUX31,PA_CHANNEL_POSITION_TOP_CENTER,PA_CHANNEL_POSITION_TOP_FRONT_LEFT,PA_CHANNEL_POSITION_TOP_FRONT_RIGHT,PA_CHANNEL_POSITION_TOP_FRONT_CENTER,PA_CHANNEL_POSITION_TOP_REAR_LEFT,PA_CHANNEL_POSITION_TOP_REAR_RIGHT,PA_CHANNEL_POSITION_TOP_REAR_CENTER,PA_CHANNEL_POSITION_MAX" },
  { "pa_context_flags", 8, _cffi_prim_int(sizeof(pa_context_flags_t), ((pa_context_flags_t)-1) <= 0),
    "PA_CONTEXT_NOFLAGS,PA_CONTEXT_NOAUTOSPAWN,PA_CONTEXT_NOFAIL" },
  { "pa_context_state", 162, _cffi_prim_int(sizeof(pa_context_state_t), ((pa_context_state_t)-1) <= 0),
    "PA_CONTEXT_UNCONNECTED,PA_CONTEXT_CONNECTING,PA_CONTEXT_AUTHORIZING,PA_CONTEXT_SETTING_NAME,PA_CONTEXT_READY,PA_CONTEXT_FAILED,PA_CONTEXT_TERMINATED" },
  { "pa_encoding", 164, _cffi_prim_int(sizeof(pa_encoding_t), ((pa_encoding_t)-1) <= 0),
    "PA_ENCODING_ANY,PA_ENCODING_PCM,PA_ENCODING_AC3_IEC61937,PA_ENCODING_EAC3_IEC61937,PA_ENCODING_MPEG_IEC61937,PA_ENCODING_DTS_IEC61937,PA_ENCODING_MPEG2_AAC_IEC61937,PA_ENCODING_MAX,PA_ENCODING_INVALID" },
  { "pa_operation_state", 171, _cffi_prim_int(sizeof(pa_operation_state_t), ((pa_operation_state_t)-1) <= 0),
    "PA_OPERATION_RUNNING,PA_OPERATION_DONE,PA_OPERATION_CANCELLED" },
  { "pa_sample_format", 174, _cffi_prim_int(sizeof(pa_sample_format_t), ((pa_sample_format_t)-1) <= 0),
    "PA_SAMPLE_U8,PA_SAMPLE_ALAW,PA_SAMPLE_ULAW,PA_SAMPLE_S16LE,PA_SAMPLE_S16BE,PA_SAMPLE_FLOAT32LE,PA_SAMPLE_FLOAT32BE,PA_SAMPLE_S32LE,PA_SAMPLE_S32BE,PA_SAMPLE_S24LE,PA_SAMPLE_S24BE,PA_SAMPLE_S24_32LE,PA_SAMPLE_S24_32BE,PA_SAMPLE_MAX,PA_SAMPLE_INVALID" },
  { "pa_sink_flags", 177, _cffi_prim_int(sizeof(pa_sink_flags_t), ((pa_sink_flags_t)-1) <= 0),
    "PA_SINK_NOFLAGS,PA_SINK_HW_VOLUME_CTRL,PA_SINK_LATENCY,PA_SINK_HARDWARE,PA_SINK_NETWORK,PA_SINK_HW_MUTE_CTRL,PA_SINK_DECIBEL_VOLUME,PA_SINK_FLAT_VOLUME,PA_SINK_DYNAMIC_LATENCY,PA_SINK_SET_FORMATS" },
  { "pa_sink_state", 182, _cffi_prim_int(sizeof(pa_sink_state_t), ((pa_sink_state_t)-1) <= 0),
    "PA_SINK_INVALID_STATE,PA_SINK_RUNNING,PA_SINK_IDLE,PA_SINK_SUSPENDED,PA_SINK_INIT,PA_SINK_UNLINKED" },
  { "pa_subscription_event_type", 129, _cffi_prim_int(sizeof(pa_subscription_event_type_t), ((pa_subscription_event_type_t)-1) <= 0),
    "PA_SUBSCRIPTION_EVENT_SINK,PA_SUBSCRIPTION_EVENT_SOURCE,PA_SUBSCRIPTION_EVENT_SINK_INPUT,PA_SUBSCRIPTION_EVENT_SOURCE_OUTPUT,PA_SUBSCRIPTION_EVENT_MODULE,PA_SUBSCRIPTION_EVENT_CLIENT,PA_SUBSCRIPTION_EVENT_SAMPLE_CACHE,PA_SUBSCRIPTION_EVENT_SERVER,PA_SUBSCRIPTION_EVENT_AUTOLOAD,PA_SUBSCRIPTION_EVENT_CARD,PA_SUBSCRIPTION_EVENT_FACILITY_MASK,PA_SUBSCRIPTION_EVENT_NEW,PA_SUBSCRIPTION_EVENT_CHANGE,PA_SUBSCRIPTION_EVENT_REMOVE,PA_SUBSCRIPTION_EVENT_TYPE_MASK" },
  { "pa_subscription_mask", 74, _cffi_prim_int(sizeof(pa_subscription_mask_t), ((pa_subscription_mask_t)-1) <= 0),
    "PA_SUBSCRIPTION_MASK_NULL,PA_SUBSCRIPTION_MASK_SINK,PA_SUBSCRIPTION_MASK_SOURCE,PA_SUBSCRIPTION_MASK_SINK_INPUT,PA_SUBSCRIPTION_MASK_SOURCE_OUTPUT,PA_SUBSCRIPTION_MASK_MODULE,PA_SUBSCRIPTION_MASK_CLIENT,PA_SUBSCRIPTION_MASK_SAMPLE_CACHE,PA_SUBSCRIPTION_MASK_SERVER,PA_SUBSCRIPTION_MASK_AUTOLOAD,PA_SUBSCRIPTION_MASK_CARD,PA_SUBSCRIPTION_MASK_ALL" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "pa_channel_map", 157 },
  { "pa_channel_position_t", 158 },
  { "pa_context", 161 },
  { "pa_context_flags_t", 8 },
  { "pa_context_notify_cb_t", 144 },
  { "pa_context_state_t", 162 },
  { "pa_context_subscribe_cb_t", 139 },
  { "pa_context_success_cb_t", 62 },
  { "pa_cvolume", 163 },
  { "pa_encoding_t", 164 },
  { "pa_format_info", 167 },
  { "pa_mainloop", 168 },
  { "pa_mainloop_api", 169 },
  { "pa_operation", 170 },
  { "pa_operation_state_t", 171 },
  { "pa_proplist", 173 },
  { "pa_sample_format_t", 174 },
  { "pa_sample_spec", 175 },
  { "pa_server_info", 176 },
  { "pa_server_info_cb_t", 94 },
  { "pa_sink_flags_t", 177 },
  { "pa_sink_info", 178 },
  { "pa_sink_info_cb_t", 99 },
  { "pa_sink_port_info", 181 },
  { "pa_sink_state_t", 182 },
  { "pa_spawn_api", 183 },
  { "pa_subscription_event_type_t", 129 },
  { "pa_subscription_mask_t", 74 },
  { "pa_usec_t", 186 },
  { "pa_volume_t", 16 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  180,  /* num_globals */
  13,  /* num_struct_unions */
  10,  /* num_enums */
  30,  /* num_typenames */
  NULL,  /* no includes */
  190,  /* num_types */
  1,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__pulse_audio(const void *p[])
{
    if (((intptr_t)p[0]) >= 0x0A03) {
        _cffi_call_python_org = (void(*)(struct _cffi_externpy_s *, char *))p[1];
    }
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__pulse_audio(void) { return NULL; }
#  else
     init_pulse_audio(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__pulse_audio(void)
{
  return _cffi_init("libqtile.widget._pulse_audio", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_pulse_audio(void)
{
  _cffi_init("libqtile.widget._pulse_audio", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
