// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32wl5x_cm0p.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32wl5x_cm0p
// +build stm32,stm32wl5x_cm0p

// STM32WL5x_CM0P
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32WL5X_CM0P"
	CPU          = "CM0"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// TrustZone Interrupt Control
	IRQ_TZIC_ILA = 0

	// External interrupt/event controller
	IRQ_PVD_PVM_3 = 1

	// Real-time clock
	IRQ_TAMP_RTCSTAMP_LSECSS_RTCALARM_RTCSSRU_RTCWKUP = 2

	// Flash
	IRQ_FLASH_RCC_C1SEV = 3

	// External interrupt/event controller
	IRQ_EXTI1_0 = 4

	// External interrupt/event controller
	IRQ_EXTI3_2 = 5

	// External interrupt/event controller
	IRQ_EXTI15_4 = 6

	// Analog to digital convertor
	IRQ_ADC_COMP_DAC = 7

	// Direct memory access controller
	IRQ_DMA1_CH3_1 = 8

	// Direct memory access controller
	IRQ_DMA1_CH7_4 = 9

	IRQ_DMA2_CH7_1_DMAMUX1_OVR = 10

	// Low-power timer
	IRQ_LPTIM1 = 11

	// Low-power timer
	IRQ_LPTIM2 = 12

	// Low-power timer
	IRQ_LPTIM3 = 13

	// Advanced-control timers
	IRQ_TIM1_BRK_TIM1_UP_TIM1_TRG_COM_TIM1_CC = 14

	// General-purpose-timers
	IRQ_TIM2 = 15

	// General-purpose timers
	IRQ_TIM16 = 16

	// General-purpose timers
	IRQ_TIM17 = 17

	// Inter Processor communication controller
	IRQ_IPCC_C2_RX_IT_IPCC_C2_TX_IT = 18

	// Hardware semaphore
	IRQ_HSEM = 19

	// True random number generator
	IRQ_True_RNG = 20

	// Advanced encryption standard hardware accelerator 1
	IRQ_AES_PKA = 21

	// Inter-integrated circuit
	IRQ_I2C1_EV_I2C1_ER = 22

	IRQ_I2C2_EV_I2C2_ER = 23

	IRQ_I2C3_EV_I2C3_ER = 24

	// Serial peripheral interface/Inter-IC sound
	IRQ_SPI1 = 25

	IRQ_SPI2S2 = 26

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 27

	IRQ_USART2 = 28

	// Universal synchronous asynchronous receiver transmitter
	IRQ_LPUART1 = 29

	IRQ_SUBGHZSPI = 30

	// External interrupt/event controller
	IRQ_Radio_IRQ_Busy = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export TZIC_ILA_IRQHandler
func interruptTZIC_ILA() {
	callHandlers(IRQ_TZIC_ILA)
}

//export PVD_PVM_3_IRQHandler
func interruptPVD_PVM_3() {
	callHandlers(IRQ_PVD_PVM_3)
}

//export TAMP_RTCSTAMP_LSECSS_RTCALARM_RTCSSRU_RTCWKUP_IRQHandler
func interruptTAMP_RTCSTAMP_LSECSS_RTCALARM_RTCSSRU_RTCWKUP() {
	callHandlers(IRQ_TAMP_RTCSTAMP_LSECSS_RTCALARM_RTCSSRU_RTCWKUP)
}

//export FLASH_RCC_C1SEV_IRQHandler
func interruptFLASH_RCC_C1SEV() {
	callHandlers(IRQ_FLASH_RCC_C1SEV)
}

//export EXTI1_0_IRQHandler
func interruptEXTI1_0() {
	callHandlers(IRQ_EXTI1_0)
}

//export EXTI3_2_IRQHandler
func interruptEXTI3_2() {
	callHandlers(IRQ_EXTI3_2)
}

//export EXTI15_4_IRQHandler
func interruptEXTI15_4() {
	callHandlers(IRQ_EXTI15_4)
}

//export ADC_COMP_DAC_IRQHandler
func interruptADC_COMP_DAC() {
	callHandlers(IRQ_ADC_COMP_DAC)
}

//export DMA1_CH3_1_IRQHandler
func interruptDMA1_CH3_1() {
	callHandlers(IRQ_DMA1_CH3_1)
}

//export DMA1_CH7_4_IRQHandler
func interruptDMA1_CH7_4() {
	callHandlers(IRQ_DMA1_CH7_4)
}

//export DMA2_CH7_1_DMAMUX1_OVR_IRQHandler
func interruptDMA2_CH7_1_DMAMUX1_OVR() {
	callHandlers(IRQ_DMA2_CH7_1_DMAMUX1_OVR)
}

//export LPTIM1_IRQHandler
func interruptLPTIM1() {
	callHandlers(IRQ_LPTIM1)
}

//export LPTIM2_IRQHandler
func interruptLPTIM2() {
	callHandlers(IRQ_LPTIM2)
}

//export LPTIM3_IRQHandler
func interruptLPTIM3() {
	callHandlers(IRQ_LPTIM3)
}

//export TIM1_BRK_TIM1_UP_TIM1_TRG_COM_TIM1_CC_IRQHandler
func interruptTIM1_BRK_TIM1_UP_TIM1_TRG_COM_TIM1_CC() {
	callHandlers(IRQ_TIM1_BRK_TIM1_UP_TIM1_TRG_COM_TIM1_CC)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export TIM16_IRQHandler
func interruptTIM16() {
	callHandlers(IRQ_TIM16)
}

//export TIM17_IRQHandler
func interruptTIM17() {
	callHandlers(IRQ_TIM17)
}

//export IPCC_C2_RX_IT_IPCC_C2_TX_IT_IRQHandler
func interruptIPCC_C2_RX_IT_IPCC_C2_TX_IT() {
	callHandlers(IRQ_IPCC_C2_RX_IT_IPCC_C2_TX_IT)
}

//export HSEM_IRQHandler
func interruptHSEM() {
	callHandlers(IRQ_HSEM)
}

//export True_RNG_IRQHandler
func interruptTrue_RNG() {
	callHandlers(IRQ_True_RNG)
}

//export AES_PKA_IRQHandler
func interruptAES_PKA() {
	callHandlers(IRQ_AES_PKA)
}

//export I2C1_EV_I2C1_ER_IRQHandler
func interruptI2C1_EV_I2C1_ER() {
	callHandlers(IRQ_I2C1_EV_I2C1_ER)
}

//export I2C2_EV_I2C2_ER_IRQHandler
func interruptI2C2_EV_I2C2_ER() {
	callHandlers(IRQ_I2C2_EV_I2C2_ER)
}

//export I2C3_EV_I2C3_ER_IRQHandler
func interruptI2C3_EV_I2C3_ER() {
	callHandlers(IRQ_I2C3_EV_I2C3_ER)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SPI2S2_IRQHandler
func interruptSPI2S2() {
	callHandlers(IRQ_SPI2S2)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export LPUART1_IRQHandler
func interruptLPUART1() {
	callHandlers(IRQ_LPUART1)
}

//export SUBGHZSPI_IRQHandler
func interruptSUBGHZSPI() {
	callHandlers(IRQ_SUBGHZSPI)
}

//export Radio_IRQ_Busy_IRQHandler
func interruptRadio_IRQ_Busy() {
	callHandlers(IRQ_Radio_IRQ_Busy)
}

// Peripherals.
var (
	// Analog to digital convertor
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012400)))

	// Advanced encryption standard hardware accelerator 1
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x58001800)))

	// Comparator
	COMP = (*COMP_Type)(unsafe.Pointer(uintptr(0x40010200)))

	// Cyclic redundancy check calculation unit
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Digital-to-analog converter
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// Direct memory access controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// DMA request multiplexer
	DMAMUX = (*DMAMUX_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x58000800)))

	// Flash
	FLASH = (*Flash_Type)(unsafe.Pointer(uintptr(0x58004000)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000000)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000400)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000800)))

	// General-purpose I/Os
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001c00)))

	// Hardware semaphore
	HSEM = (*HSEM_Type)(unsafe.Pointer(uintptr(0x58001400)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Inter Processor communication controller
	IPCC = (*IPCC_Type)(unsafe.Pointer(uintptr(0x58000c00)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Low-power timer
	LPTIM1 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// Low-power timer
	LPTIM2 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40009400)))

	// Low-power timer
	LPTIM3 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40009800)))

	// Universal synchronous asynchronous receiver transmitter
	LPUART = (*USART_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// Public key accelerator
	PKA = (*PKA_Type)(unsafe.Pointer(uintptr(0x58002000)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x58000400)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x58000000)))

	// True random number generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x58001000)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// Serial peripheral interface/Inter-IC sound
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Tamper and backup registers
	TAMP = (*TAMP_Type)(unsafe.Pointer(uintptr(0x4000b000)))

	// Advanced-control timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// General-purpose-timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General-purpose timers
	TIM16 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// General-purpose timers
	TIM17 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// TrustZone Interrupt Control
	TZIC = (*TZSC_Type)(unsafe.Pointer(uintptr(0x58004800)))

	// Global TrustZone Controller
	TZSC = (*TZSC_Type)(unsafe.Pointer(uintptr(0x58004400)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Voltage reference buffer
	VREFBUF = (*VREFBUF_Type)(unsafe.Pointer(uintptr(0x40010030)))

	// System window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Direct memory access controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// Serial peripheral interface/Inter-IC sound
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Serial peripheral interface/Inter-IC sound
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x58010000)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))
)

// Analog to digital convertor
type ADC_Type struct {
	ISR     volatile.Register32 // 0x0
	IER     volatile.Register32 // 0x4
	CR      volatile.Register32 // 0x8
	CFGR1   volatile.Register32 // 0xC
	CFGR2   volatile.Register32 // 0x10
	SMPR    volatile.Register32 // 0x14
	_       [8]byte
	AWD1TR  volatile.Register32 // 0x20
	AWD2TR  volatile.Register32 // 0x24
	CHSELR0 volatile.Register32 // 0x28
	AWD3TR  volatile.Register32 // 0x2C
	_       [16]byte
	DR      volatile.Register32 // 0x40
	_       [92]byte
	AWD2CR  volatile.Register32 // 0xA0
	AWD3CR  volatile.Register32 // 0xA4
	_       [12]byte
	CALFACT volatile.Register32 // 0xB4
	_       [592]byte
	CCR     volatile.Register32 // 0x308
}

// ADC.ISR: ADC interrupt and status register
func (o *ADC_Type) SetISR_ADRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetISR_ADRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *ADC_Type) SetISR_EOSMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetISR_EOSMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetISR_EOC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetISR_EOC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetISR_EOS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetISR_EOS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetISR_AWD1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetISR_AWD1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetISR_AWD2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetISR_AWD2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetISR_AWD3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetISR_AWD3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetISR_EOCAL(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetISR_EOCAL() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetISR_CCRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetISR_CCRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}

// ADC.IER: ADC interrupt enable register
func (o *ADC_Type) SetIER_ADRDYIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIER_ADRDYIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *ADC_Type) SetIER_EOSMPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIER_EOSMPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIER_EOCIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIER_EOCIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIER_EOSIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIER_EOSIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIER_OVRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIER_OVRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIER_AWD1IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIER_AWD1IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIER_AWD2IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIER_AWD2IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIER_AWD3IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIER_AWD3IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIER_EOCALIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIER_EOCALIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIER_CCRDYIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetIER_CCRDYIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}

// ADC.CR: ADC control register
func (o *ADC_Type) SetCR_ADEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR_ADEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *ADC_Type) SetCR_ADDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR_ADDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCR_ADSTART(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCR_ADSTART() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCR_ADSTP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCR_ADSTP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCR_ADVREGEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetCR_ADVREGEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetCR_ADCAL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetCR_ADCAL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}

// ADC.CFGR1: ADC configuration register 1
func (o *ADC_Type) SetCFGR1_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCFGR1_DMAEN() uint32 {
	return volatile.LoadUint32(&o.CFGR1.Reg) & 0x1
}
func (o *ADC_Type) SetCFGR1_DMACFG(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCFGR1_DMACFG() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCFGR1_SCANDIR(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCFGR1_SCANDIR() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCFGR1_RES(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x18)|value<<3)
}
func (o *ADC_Type) GetCFGR1_RES() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x18) >> 3
}
func (o *ADC_Type) SetCFGR1_ALIGN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCFGR1_ALIGN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCFGR1_EXTSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetCFGR1_EXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetCFGR1_EXTEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0xc00)|value<<10)
}
func (o *ADC_Type) GetCFGR1_EXTEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0xc00) >> 10
}
func (o *ADC_Type) SetCFGR1_OVRMOD(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCFGR1_OVRMOD() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCFGR1_CONT(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCFGR1_CONT() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCFGR1_WAIT(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCFGR1_WAIT() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCFGR1_AUTOFF(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetCFGR1_AUTOFF() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetCFGR1_DISCEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetCFGR1_DISCEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetCFGR1_CHSELRMOD(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetCFGR1_CHSELRMOD() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetCFGR1_AWD1SGL(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCFGR1_AWD1SGL() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCFGR1_AWD1EN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCFGR1_AWD1EN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCFGR1_AWD1CH(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetCFGR1_AWD1CH() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x7c000000) >> 26
}

// ADC.CFGR2: ADC configuration register 2
func (o *ADC_Type) SetCFGR2_OVSE(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCFGR2_OVSE() uint32 {
	return volatile.LoadUint32(&o.CFGR2.Reg) & 0x1
}
func (o *ADC_Type) SetCFGR2_OVSR0(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCFGR2_OVSR0() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCFGR2_OVSR1(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCFGR2_OVSR1() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCFGR2_OVSR2(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCFGR2_OVSR2() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCFGR2_OVSS0(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCFGR2_OVSS0() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCFGR2_OVSS1(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCFGR2_OVSS1() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCFGR2_OVSS2(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCFGR2_OVSS2() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCFGR2_OVSS3(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCFGR2_OVSS3() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCFGR2_TOVS(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCFGR2_TOVS() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCFGR2_LFTRIG(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetCFGR2_LFTRIG() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetCFGR2_CKMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0xc0000000)|value<<30)
}
func (o *ADC_Type) GetCFGR2_CKMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0xc0000000) >> 30
}

// ADC.SMPR: ADC sampling time register
func (o *ADC_Type) SetSMPR_SMP1(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR_SMP1() uint32 {
	return volatile.LoadUint32(&o.SMPR.Reg) & 0x7
}
func (o *ADC_Type) SetSMPR_SMP2(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x70)|value<<4)
}
func (o *ADC_Type) GetSMPR_SMP2() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x70) >> 4
}
func (o *ADC_Type) SetSMPR_SMPSEL(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x3ffff00)|value<<8)
}
func (o *ADC_Type) GetSMPR_SMPSEL() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x3ffff00) >> 8
}

// ADC.AWD1TR: ADC watchdog threshold register
func (o *ADC_Type) SetAWD1TR_LT1(value uint32) {
	volatile.StoreUint32(&o.AWD1TR.Reg, volatile.LoadUint32(&o.AWD1TR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetAWD1TR_LT1() uint32 {
	return volatile.LoadUint32(&o.AWD1TR.Reg) & 0xfff
}
func (o *ADC_Type) SetAWD1TR_HT1(value uint32) {
	volatile.StoreUint32(&o.AWD1TR.Reg, volatile.LoadUint32(&o.AWD1TR.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetAWD1TR_HT1() uint32 {
	return (volatile.LoadUint32(&o.AWD1TR.Reg) & 0xfff0000) >> 16
}

// ADC.AWD2TR: ADC watchdog threshold register
func (o *ADC_Type) SetAWD2TR_LT2(value uint32) {
	volatile.StoreUint32(&o.AWD2TR.Reg, volatile.LoadUint32(&o.AWD2TR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetAWD2TR_LT2() uint32 {
	return volatile.LoadUint32(&o.AWD2TR.Reg) & 0xfff
}
func (o *ADC_Type) SetAWD2TR_HT2(value uint32) {
	volatile.StoreUint32(&o.AWD2TR.Reg, volatile.LoadUint32(&o.AWD2TR.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetAWD2TR_HT2() uint32 {
	return (volatile.LoadUint32(&o.AWD2TR.Reg) & 0xfff0000) >> 16
}

// ADC.CHSELR0: channel selection register
func (o *ADC_Type) SetCHSELR0_CHSEL(value uint32) {
	volatile.StoreUint32(&o.CHSELR0.Reg, volatile.LoadUint32(&o.CHSELR0.Reg)&^(0x3ffff)|value)
}
func (o *ADC_Type) GetCHSELR0_CHSEL() uint32 {
	return volatile.LoadUint32(&o.CHSELR0.Reg) & 0x3ffff
}

// ADC.AWD3TR: ADC watchdog threshold register
func (o *ADC_Type) SetAWD3TR_LT3(value uint32) {
	volatile.StoreUint32(&o.AWD3TR.Reg, volatile.LoadUint32(&o.AWD3TR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetAWD3TR_LT3() uint32 {
	return volatile.LoadUint32(&o.AWD3TR.Reg) & 0xfff
}
func (o *ADC_Type) SetAWD3TR_HT3(value uint32) {
	volatile.StoreUint32(&o.AWD3TR.Reg, volatile.LoadUint32(&o.AWD3TR.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetAWD3TR_HT3() uint32 {
	return (volatile.LoadUint32(&o.AWD3TR.Reg) & 0xfff0000) >> 16
}

// ADC.DR: ADC data register
func (o *ADC_Type) SetDR_DATA(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetDR_DATA() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// ADC.AWD2CR: ADC Analog Watchdog 2 Configuration register
func (o *ADC_Type) SetAWD2CR_AWD2CH(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x3ffff)|value)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH() uint32 {
	return volatile.LoadUint32(&o.AWD2CR.Reg) & 0x3ffff
}

// ADC.AWD3CR: ADC Analog Watchdog 3 Configuration register
func (o *ADC_Type) SetAWD3CR_AWD3CH(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x3ffff)|value)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH() uint32 {
	return volatile.LoadUint32(&o.AWD3CR.Reg) & 0x3ffff
}

// ADC.CALFACT: ADC Calibration factor
func (o *ADC_Type) SetCALFACT(value uint32) {
	volatile.StoreUint32(&o.CALFACT.Reg, volatile.LoadUint32(&o.CALFACT.Reg)&^(0x7f)|value)
}
func (o *ADC_Type) GetCALFACT() uint32 {
	return volatile.LoadUint32(&o.CALFACT.Reg) & 0x7f
}

// ADC.CCR: ADC common configuration register
func (o *ADC_Type) SetCCR_PRESC0(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetCCR_PRESC0() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetCCR_PRESC1(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetCCR_PRESC1() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x80000) >> 19
}
func (o *ADC_Type) SetCCR_PRESC2(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetCCR_PRESC2() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetCCR_PRESC3(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetCCR_PRESC3() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetCCR_VREFEN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCCR_VREFEN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCCR_TSEN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCCR_TSEN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCCR_VBATEN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetCCR_VBATEN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x1000000) >> 24
}

// Advanced encryption standard hardware accelerator 1
type AES_Type struct {
	CR     volatile.Register32 // 0x0
	SR     volatile.Register32 // 0x4
	DINR   volatile.Register32 // 0x8
	DOUTR  volatile.Register32 // 0xC
	KEYR0  volatile.Register32 // 0x10
	KEYR1  volatile.Register32 // 0x14
	KEYR2  volatile.Register32 // 0x18
	KEYR3  volatile.Register32 // 0x1C
	IVR0   volatile.Register32 // 0x20
	IVR1   volatile.Register32 // 0x24
	IVR2   volatile.Register32 // 0x28
	IVR3   volatile.Register32 // 0x2C
	KEYR4  volatile.Register32 // 0x30
	KEYR5  volatile.Register32 // 0x34
	KEYR6  volatile.Register32 // 0x38
	KEYR7  volatile.Register32 // 0x3C
	SUSP0R volatile.Register32 // 0x40
	SUSP1R volatile.Register32 // 0x44
	SUSP2R volatile.Register32 // 0x48
	SUSP3R volatile.Register32 // 0x4C
	SUSP4R volatile.Register32 // 0x50
	SUSP5R volatile.Register32 // 0x54
	SUSP6R volatile.Register32 // 0x58
	SUSP7R volatile.Register32 // 0x5C
}

// AES.CR: control register
func (o *AES_Type) SetCR_NPBLB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00000)|value<<20)
}
func (o *AES_Type) GetCR_NPBLB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00000) >> 20
}
func (o *AES_Type) SetCR_KEYSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *AES_Type) GetCR_KEYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *AES_Type) SetCR_CHMOD2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *AES_Type) GetCR_CHMOD2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *AES_Type) SetCR_GCMPH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x6000)|value<<13)
}
func (o *AES_Type) GetCR_GCMPH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x6000) >> 13
}
func (o *AES_Type) SetCR_DMAOUTEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *AES_Type) GetCR_DMAOUTEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *AES_Type) SetCR_DMAINEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *AES_Type) GetCR_DMAINEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *AES_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *AES_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *AES_Type) SetCR_CCFIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *AES_Type) GetCR_CCFIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *AES_Type) SetCR_ERRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetCR_ERRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetCR_CCFC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *AES_Type) GetCR_CCFC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *AES_Type) SetCR_CHMOD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *AES_Type) GetCR_CHMOD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *AES_Type) SetCR_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *AES_Type) GetCR_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}
func (o *AES_Type) SetCR_DATATYPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x6)|value<<1)
}
func (o *AES_Type) GetCR_DATATYPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x6) >> 1
}
func (o *AES_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// AES.SR: status register
func (o *AES_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *AES_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *AES_Type) SetSR_WRERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *AES_Type) GetSR_WRERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *AES_Type) SetSR_RDERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *AES_Type) GetSR_RDERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *AES_Type) SetSR_CCF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetSR_CCF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// AES.DINR: data input register
func (o *AES_Type) SetDINR(value uint32) {
	volatile.StoreUint32(&o.DINR.Reg, value)
}
func (o *AES_Type) GetDINR() uint32 {
	return volatile.LoadUint32(&o.DINR.Reg)
}

// AES.DOUTR: data output register
func (o *AES_Type) SetDOUTR(value uint32) {
	volatile.StoreUint32(&o.DOUTR.Reg, value)
}
func (o *AES_Type) GetDOUTR() uint32 {
	return volatile.LoadUint32(&o.DOUTR.Reg)
}

// AES.KEYR0: key register 0
func (o *AES_Type) SetKEYR0(value uint32) {
	volatile.StoreUint32(&o.KEYR0.Reg, value)
}
func (o *AES_Type) GetKEYR0() uint32 {
	return volatile.LoadUint32(&o.KEYR0.Reg)
}

// AES.KEYR1: key register 1
func (o *AES_Type) SetKEYR1(value uint32) {
	volatile.StoreUint32(&o.KEYR1.Reg, value)
}
func (o *AES_Type) GetKEYR1() uint32 {
	return volatile.LoadUint32(&o.KEYR1.Reg)
}

// AES.KEYR2: key register 2
func (o *AES_Type) SetKEYR2(value uint32) {
	volatile.StoreUint32(&o.KEYR2.Reg, value)
}
func (o *AES_Type) GetKEYR2() uint32 {
	return volatile.LoadUint32(&o.KEYR2.Reg)
}

// AES.KEYR3: key register 3
func (o *AES_Type) SetKEYR3(value uint32) {
	volatile.StoreUint32(&o.KEYR3.Reg, value)
}
func (o *AES_Type) GetKEYR3() uint32 {
	return volatile.LoadUint32(&o.KEYR3.Reg)
}

// AES.IVR0: initialization vector register 0
func (o *AES_Type) SetIVR0(value uint32) {
	volatile.StoreUint32(&o.IVR0.Reg, value)
}
func (o *AES_Type) GetIVR0() uint32 {
	return volatile.LoadUint32(&o.IVR0.Reg)
}

// AES.IVR1: initialization vector register 1
func (o *AES_Type) SetIVR1(value uint32) {
	volatile.StoreUint32(&o.IVR1.Reg, value)
}
func (o *AES_Type) GetIVR1() uint32 {
	return volatile.LoadUint32(&o.IVR1.Reg)
}

// AES.IVR2: initialization vector register 2
func (o *AES_Type) SetIVR2(value uint32) {
	volatile.StoreUint32(&o.IVR2.Reg, value)
}
func (o *AES_Type) GetIVR2() uint32 {
	return volatile.LoadUint32(&o.IVR2.Reg)
}

// AES.IVR3: initialization vector register 3
func (o *AES_Type) SetIVR3(value uint32) {
	volatile.StoreUint32(&o.IVR3.Reg, value)
}
func (o *AES_Type) GetIVR3() uint32 {
	return volatile.LoadUint32(&o.IVR3.Reg)
}

// AES.KEYR4: key register 4
func (o *AES_Type) SetKEYR4(value uint32) {
	volatile.StoreUint32(&o.KEYR4.Reg, value)
}
func (o *AES_Type) GetKEYR4() uint32 {
	return volatile.LoadUint32(&o.KEYR4.Reg)
}

// AES.KEYR5: key register 5
func (o *AES_Type) SetKEYR5(value uint32) {
	volatile.StoreUint32(&o.KEYR5.Reg, value)
}
func (o *AES_Type) GetKEYR5() uint32 {
	return volatile.LoadUint32(&o.KEYR5.Reg)
}

// AES.KEYR6: key register 6
func (o *AES_Type) SetKEYR6(value uint32) {
	volatile.StoreUint32(&o.KEYR6.Reg, value)
}
func (o *AES_Type) GetKEYR6() uint32 {
	return volatile.LoadUint32(&o.KEYR6.Reg)
}

// AES.KEYR7: key register 7
func (o *AES_Type) SetKEYR7(value uint32) {
	volatile.StoreUint32(&o.KEYR7.Reg, value)
}
func (o *AES_Type) GetKEYR7() uint32 {
	return volatile.LoadUint32(&o.KEYR7.Reg)
}

// AES.SUSP0R: AES suspend register 0
func (o *AES_Type) SetSUSP0R(value uint32) {
	volatile.StoreUint32(&o.SUSP0R.Reg, value)
}
func (o *AES_Type) GetSUSP0R() uint32 {
	return volatile.LoadUint32(&o.SUSP0R.Reg)
}

// AES.SUSP1R: AES suspend register 1
func (o *AES_Type) SetSUSP1R(value uint32) {
	volatile.StoreUint32(&o.SUSP1R.Reg, value)
}
func (o *AES_Type) GetSUSP1R() uint32 {
	return volatile.LoadUint32(&o.SUSP1R.Reg)
}

// AES.SUSP2R: AES suspend register 2
func (o *AES_Type) SetSUSP2R(value uint32) {
	volatile.StoreUint32(&o.SUSP2R.Reg, value)
}
func (o *AES_Type) GetSUSP2R() uint32 {
	return volatile.LoadUint32(&o.SUSP2R.Reg)
}

// AES.SUSP3R: AES suspend register 3
func (o *AES_Type) SetSUSP3R(value uint32) {
	volatile.StoreUint32(&o.SUSP3R.Reg, value)
}
func (o *AES_Type) GetSUSP3R() uint32 {
	return volatile.LoadUint32(&o.SUSP3R.Reg)
}

// AES.SUSP4R: AES suspend register 4
func (o *AES_Type) SetSUSP4R(value uint32) {
	volatile.StoreUint32(&o.SUSP4R.Reg, value)
}
func (o *AES_Type) GetSUSP4R() uint32 {
	return volatile.LoadUint32(&o.SUSP4R.Reg)
}

// AES.SUSP5R: AES suspend register 5
func (o *AES_Type) SetSUSP5R(value uint32) {
	volatile.StoreUint32(&o.SUSP5R.Reg, value)
}
func (o *AES_Type) GetSUSP5R() uint32 {
	return volatile.LoadUint32(&o.SUSP5R.Reg)
}

// AES.SUSP6R: AES suspend register 6
func (o *AES_Type) SetSUSP6R(value uint32) {
	volatile.StoreUint32(&o.SUSP6R.Reg, value)
}
func (o *AES_Type) GetSUSP6R() uint32 {
	return volatile.LoadUint32(&o.SUSP6R.Reg)
}

// AES.SUSP7R: AES suspend register 7
func (o *AES_Type) SetSUSP7R(value uint32) {
	volatile.StoreUint32(&o.SUSP7R.Reg, value)
}
func (o *AES_Type) GetSUSP7R() uint32 {
	return volatile.LoadUint32(&o.SUSP7R.Reg)
}

// Comparator
type COMP_Type struct {
	COMP1_CSR volatile.Register32 // 0x0
	COMP2_CSR volatile.Register32 // 0x4
}

// COMP.COMP1_CSR: COMP1_CSR
func (o *COMP_Type) SetCOMP1_CSR_LOCK(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetCOMP1_CSR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x80000000) >> 31
}
func (o *COMP_Type) SetCOMP1_CSR_VALUE(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *COMP_Type) GetCOMP1_CSR_VALUE() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x40000000) >> 30
}
func (o *COMP_Type) SetCOMP1_CSR_INMESEL(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x6000000)|value<<25)
}
func (o *COMP_Type) GetCOMP1_CSR_INMESEL() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x6000000) >> 25
}
func (o *COMP_Type) SetCOMP1_CSR_SCALEN(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x800000)|value<<23)
}
func (o *COMP_Type) GetCOMP1_CSR_SCALEN() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x800000) >> 23
}
func (o *COMP_Type) SetCOMP1_CSR_BRGEN(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x400000)|value<<22)
}
func (o *COMP_Type) GetCOMP1_CSR_BRGEN() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x400000) >> 22
}
func (o *COMP_Type) SetCOMP1_CSR_BLANKING(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x1c0000)|value<<18)
}
func (o *COMP_Type) GetCOMP1_CSR_BLANKING() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x1c0000) >> 18
}
func (o *COMP_Type) SetCOMP1_CSR_HYST(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x30000)|value<<16)
}
func (o *COMP_Type) GetCOMP1_CSR_HYST() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x30000) >> 16
}
func (o *COMP_Type) SetCOMP1_CSR_POLARITY(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x8000)|value<<15)
}
func (o *COMP_Type) GetCOMP1_CSR_POLARITY() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x8000) >> 15
}
func (o *COMP_Type) SetCOMP1_CSR_INPSEL(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x180)|value<<7)
}
func (o *COMP_Type) GetCOMP1_CSR_INPSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x180) >> 7
}
func (o *COMP_Type) SetCOMP1_CSR_INMSEL(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x70)|value<<4)
}
func (o *COMP_Type) GetCOMP1_CSR_INMSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x70) >> 4
}
func (o *COMP_Type) SetCOMP1_CSR_PWRMODE(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0xc)|value<<2)
}
func (o *COMP_Type) GetCOMP1_CSR_PWRMODE() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0xc) >> 2
}
func (o *COMP_Type) SetCOMP1_CSR_EN(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetCOMP1_CSR_EN() uint32 {
	return volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x1
}

// COMP.COMP2_CSR: COMP2_CSR
func (o *COMP_Type) SetCOMP2_CSR_LOCK(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetCOMP2_CSR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x80000000) >> 31
}
func (o *COMP_Type) SetCOMP2_CSR_VALUE(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *COMP_Type) GetCOMP2_CSR_VALUE() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x40000000) >> 30
}
func (o *COMP_Type) SetCOMP2_CSR_INMESEL(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x6000000)|value<<25)
}
func (o *COMP_Type) GetCOMP2_CSR_INMESEL() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x6000000) >> 25
}
func (o *COMP_Type) SetCOMP2_CSR_SCALEN(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x800000)|value<<23)
}
func (o *COMP_Type) GetCOMP2_CSR_SCALEN() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x800000) >> 23
}
func (o *COMP_Type) SetCOMP2_CSR_BRGEN(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x400000)|value<<22)
}
func (o *COMP_Type) GetCOMP2_CSR_BRGEN() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x400000) >> 22
}
func (o *COMP_Type) SetCOMP2_CSR_BLANKING(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x1c0000)|value<<18)
}
func (o *COMP_Type) GetCOMP2_CSR_BLANKING() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x1c0000) >> 18
}
func (o *COMP_Type) SetCOMP2_CSR_HYST(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x30000)|value<<16)
}
func (o *COMP_Type) GetCOMP2_CSR_HYST() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x30000) >> 16
}
func (o *COMP_Type) SetCOMP2_CSR_POLARITY(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x8000)|value<<15)
}
func (o *COMP_Type) GetCOMP2_CSR_POLARITY() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x8000) >> 15
}
func (o *COMP_Type) SetCOMP2_CSR_WINMODE(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x200)|value<<9)
}
func (o *COMP_Type) GetCOMP2_CSR_WINMODE() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x200) >> 9
}
func (o *COMP_Type) SetCOMP2_CSR_INPSEL(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x180)|value<<7)
}
func (o *COMP_Type) GetCOMP2_CSR_INPSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x180) >> 7
}
func (o *COMP_Type) SetCOMP2_CSR_INMSEL(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x70)|value<<4)
}
func (o *COMP_Type) GetCOMP2_CSR_INMSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x70) >> 4
}
func (o *COMP_Type) SetCOMP2_CSR_PWRMODE(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0xc)|value<<2)
}
func (o *COMP_Type) GetCOMP2_CSR_PWRMODE() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0xc) >> 2
}
func (o *COMP_Type) SetCOMP2_CSR_EN(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetCOMP2_CSR_EN() uint32 {
	return volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x1
}

// Cyclic redundancy check calculation unit
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// CRC.DR: Data register
func (o *CRC_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *CRC_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// CRC.IDR: Independent data register
func (o *CRC_Type) SetIDR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, value)
}
func (o *CRC_Type) GetIDR() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg)
}

// CRC.CR: Control register
func (o *CRC_Type) SetCR_REV_OUT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *CRC_Type) GetCR_REV_OUT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *CRC_Type) SetCR_REV_IN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *CRC_Type) GetCR_REV_IN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *CRC_Type) SetCR_POLYSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *CRC_Type) GetCR_POLYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}
func (o *CRC_Type) SetCR_RESET(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRC_Type) GetCR_RESET() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// CRC.INIT: Initial CRC value
func (o *CRC_Type) SetINIT(value uint32) {
	volatile.StoreUint32(&o.INIT.Reg, value)
}
func (o *CRC_Type) GetINIT() uint32 {
	return volatile.LoadUint32(&o.INIT.Reg)
}

// CRC.POL: polynomial
func (o *CRC_Type) SetPOL(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, value)
}
func (o *CRC_Type) GetPOL() uint32 {
	return volatile.LoadUint32(&o.POL.Reg)
}

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRGR  volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	_       [12]byte
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	_       [4]byte
	SR      volatile.Register32 // 0x34
	CCR     volatile.Register32 // 0x38
	MCR     volatile.Register32 // 0x3C
	SHSR1   volatile.Register32 // 0x40
	_       [4]byte
	SHHR    volatile.Register32 // 0x48
	SHRR    volatile.Register32 // 0x4C
}

// DAC.CR: control register
func (o *DAC_Type) SetCR_CEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *DAC_Type) GetCR_CEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *DAC_Type) SetCR_DMAUDRIE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetCR_DMAUDRIE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *DAC_Type) SetCR_DMAEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *DAC_Type) GetCR_DMAEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *DAC_Type) SetCR_MAMP1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *DAC_Type) GetCR_MAMP1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *DAC_Type) SetCR_WAVE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DAC_Type) GetCR_WAVE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *DAC_Type) SetCR_TEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetCR_TEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetCR_EN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetCR_EN1() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DAC_Type) SetCR_TSEL1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3c)|value<<2)
}
func (o *DAC_Type) GetCR_TSEL1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3c) >> 2
}

// DAC.SWTRGR: software trigger register
func (o *DAC_Type) SetSWTRGR_SWTRIG1(value uint32) {
	volatile.StoreUint32(&o.SWTRGR.Reg, volatile.LoadUint32(&o.SWTRGR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetSWTRGR_SWTRIG1() uint32 {
	return volatile.LoadUint32(&o.SWTRGR.Reg) & 0x1
}

// DAC.DHR12R1: channel1 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R1.Reg, volatile.LoadUint32(&o.DHR12R1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R1.Reg) & 0xfff
}

// DAC.DHR12L1: channel1 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L1.Reg, volatile.LoadUint32(&o.DHR12L1.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L1_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L1.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R1: channel1 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R1.Reg, volatile.LoadUint32(&o.DHR8R1.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R1.Reg) & 0xff
}

// DAC.DHR12RD: Dual DAC 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff
}

// DAC.DHR12LD: Dual DAC 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12LD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12LD_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff0) >> 4
}

// DAC.DHR8RD: Dual DAC 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff
}

// DAC.DOR1: DAC channel1 data output register
func (o *DAC_Type) SetDOR1_DACC1DOR(value uint32) {
	volatile.StoreUint32(&o.DOR1.Reg, volatile.LoadUint32(&o.DOR1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR1_DACC1DOR() uint32 {
	return volatile.LoadUint32(&o.DOR1.Reg) & 0xfff
}

// DAC.SR: status register
func (o *DAC_Type) SetSR_BWST1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *DAC_Type) GetSR_BWST1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *DAC_Type) SetSR_CAL_FLAG1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *DAC_Type) GetSR_CAL_FLAG1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *DAC_Type) SetSR_DMAUDR1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetSR_DMAUDR1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}

// DAC.CCR: calibration control register
func (o *DAC_Type) SetCCR_OTRIM1(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1f)|value)
}
func (o *DAC_Type) GetCCR_OTRIM1() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1f
}

// DAC.MCR: mode control register
func (o *DAC_Type) SetMCR_MODE1(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x7)|value)
}
func (o *DAC_Type) GetMCR_MODE1() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x7
}

// DAC.SHSR1: Sample and Hold sample time register 1
func (o *DAC_Type) SetSHSR1_TSAMPLE1(value uint32) {
	volatile.StoreUint32(&o.SHSR1.Reg, volatile.LoadUint32(&o.SHSR1.Reg)&^(0x3ff)|value)
}
func (o *DAC_Type) GetSHSR1_TSAMPLE1() uint32 {
	return volatile.LoadUint32(&o.SHSR1.Reg) & 0x3ff
}

// DAC.SHHR: Sample and Hold hold time register
func (o *DAC_Type) SetSHHR_THOLD1(value uint32) {
	volatile.StoreUint32(&o.SHHR.Reg, volatile.LoadUint32(&o.SHHR.Reg)&^(0x3ff)|value)
}
func (o *DAC_Type) GetSHHR_THOLD1() uint32 {
	return volatile.LoadUint32(&o.SHHR.Reg) & 0x3ff
}

// DAC.SHRR: Sample and Hold refresh time register
func (o *DAC_Type) SetSHRR_TREFRESH1(value uint32) {
	volatile.StoreUint32(&o.SHRR.Reg, volatile.LoadUint32(&o.SHRR.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetSHRR_TREFRESH1() uint32 {
	return volatile.LoadUint32(&o.SHRR.Reg) & 0xff
}

// Direct memory access controller
type DMA_Type struct {
	ISR    volatile.Register32 // 0x0
	IFCR   volatile.Register32 // 0x4
	CCR1   volatile.Register32 // 0x8
	CNDTR1 volatile.Register32 // 0xC
	CPAR1  volatile.Register32 // 0x10
	CMAR1  volatile.Register32 // 0x14
	_      [4]byte
	CCR2   volatile.Register32 // 0x1C
	CNDTR2 volatile.Register32 // 0x20
	CPAR2  volatile.Register32 // 0x24
	CMAR2  volatile.Register32 // 0x28
	_      [4]byte
	CCR3   volatile.Register32 // 0x30
	CNDTR3 volatile.Register32 // 0x34
	CPAR3  volatile.Register32 // 0x38
	CMAR3  volatile.Register32 // 0x3C
	_      [4]byte
	CCR4   volatile.Register32 // 0x44
	CNDTR4 volatile.Register32 // 0x48
	CPAR4  volatile.Register32 // 0x4C
	CMAR4  volatile.Register32 // 0x50
	_      [4]byte
	CCR5   volatile.Register32 // 0x58
	CNDTR5 volatile.Register32 // 0x5C
	CPAR5  volatile.Register32 // 0x60
	CMAR5  volatile.Register32 // 0x64
	_      [4]byte
	CCR6   volatile.Register32 // 0x6C
	CNDTR6 volatile.Register32 // 0x70
	CPAR6  volatile.Register32 // 0x74
	CMAR6  volatile.Register32 // 0x78
	_      [4]byte
	CCR7   volatile.Register32 // 0x80
	CNDTR7 volatile.Register32 // 0x84
	CPAR7  volatile.Register32 // 0x88
	CMAR7  volatile.Register32 // 0x8C
}

// DMA.ISR: interrupt status register
func (o *DMA_Type) SetISR_TEIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetISR_TEIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetISR_HTIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetISR_HTIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetISR_TCIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetISR_TCIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetISR_GIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetISR_GIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetISR_TEIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetISR_TEIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetISR_HTIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetISR_HTIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetISR_TCIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetISR_TCIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetISR_GIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetISR_GIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetISR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetISR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetISR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetISR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetISR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetISR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetISR_GIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetISR_GIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetISR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetISR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetISR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetISR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetISR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetISR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetISR_GIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetISR_GIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetISR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetISR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetISR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetISR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetISR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetISR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetISR_GIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetISR_GIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetISR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetISR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetISR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetISR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetISR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetISR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetISR_GIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetISR_GIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetISR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetISR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetISR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetISR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetISR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetISR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetISR_GIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetISR_GIF1() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// DMA.IFCR: interrupt flag clear register
func (o *DMA_Type) SetIFCR_TEIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetIFCR_TEIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetIFCR_HTIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetIFCR_HTIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetIFCR_TCIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetIFCR_TCIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetIFCR_GIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetIFCR_GIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetIFCR_TEIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetIFCR_TEIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetIFCR_HTIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetIFCR_HTIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetIFCR_TCIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetIFCR_TCIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetIFCR_GIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetIFCR_GIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetIFCR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetIFCR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetIFCR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetIFCR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetIFCR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetIFCR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetIFCR_GIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetIFCR_GIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetIFCR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetIFCR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetIFCR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetIFCR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetIFCR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetIFCR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetIFCR_GIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIFCR_GIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetIFCR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetIFCR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetIFCR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetIFCR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetIFCR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIFCR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetIFCR_GIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIFCR_GIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIFCR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIFCR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIFCR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIFCR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIFCR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIFCR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIFCR_GIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIFCR_GIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIFCR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIFCR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIFCR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIFCR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIFCR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIFCR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIFCR_GIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIFCR_GIF1() uint32 {
	return volatile.LoadUint32(&o.IFCR.Reg) & 0x1
}

// DMA.CCR1: channel x configuration register
func (o *DMA_Type) SetCCR1_PRIV(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetCCR1_PRIV() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetCCR1_DSEC(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetCCR1_DSEC() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetCCR1_SSEC(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetCCR1_SSEC() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetCCR1_SECM(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetCCR1_SECM() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetCCR1_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR1_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR1_PL(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR1_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR1_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR1_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR1_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR1_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR1_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR1_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR1_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR1_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR1_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR1_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR1_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR1_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR1_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR1_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR1_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR1_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR1_EN(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR1_EN() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0x1
}

// DMA.CNDTR1: channel x number of data to transfer register
func (o *DMA_Type) SetCNDTR1_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR1.Reg, volatile.LoadUint32(&o.CNDTR1.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetCNDTR1_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR1.Reg) & 0x3ffff
}

// DMA.CPAR1: channel x peripheral address register
func (o *DMA_Type) SetCPAR1(value uint32) {
	volatile.StoreUint32(&o.CPAR1.Reg, value)
}
func (o *DMA_Type) GetCPAR1() uint32 {
	return volatile.LoadUint32(&o.CPAR1.Reg)
}

// DMA.CMAR1: channel x memory address register
func (o *DMA_Type) SetCMAR1(value uint32) {
	volatile.StoreUint32(&o.CMAR1.Reg, value)
}
func (o *DMA_Type) GetCMAR1() uint32 {
	return volatile.LoadUint32(&o.CMAR1.Reg)
}

// DMA.CCR2: channel x configuration register
func (o *DMA_Type) SetCCR2_PRIV(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetCCR2_PRIV() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetCCR2_DSEC(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetCCR2_DSEC() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetCCR2_SSEC(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetCCR2_SSEC() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetCCR2_SECM(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetCCR2_SECM() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetCCR2_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR2_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR2_PL(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR2_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR2_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR2_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR2_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR2_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR2_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR2_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR2_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR2_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR2_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR2_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR2_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR2_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR2_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR2_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR2_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR2_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR2_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR2_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR2_EN(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR2_EN() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0x1
}

// DMA.CNDTR2: channel x number of data to transfer register
func (o *DMA_Type) SetCNDTR2_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR2.Reg, volatile.LoadUint32(&o.CNDTR2.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetCNDTR2_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR2.Reg) & 0x3ffff
}

// DMA.CPAR2: channel x peripheral address register
func (o *DMA_Type) SetCPAR2(value uint32) {
	volatile.StoreUint32(&o.CPAR2.Reg, value)
}
func (o *DMA_Type) GetCPAR2() uint32 {
	return volatile.LoadUint32(&o.CPAR2.Reg)
}

// DMA.CMAR2: channel x memory address register
func (o *DMA_Type) SetCMAR2(value uint32) {
	volatile.StoreUint32(&o.CMAR2.Reg, value)
}
func (o *DMA_Type) GetCMAR2() uint32 {
	return volatile.LoadUint32(&o.CMAR2.Reg)
}

// DMA.CCR3: channel x configuration register
func (o *DMA_Type) SetCCR3_PRIV(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetCCR3_PRIV() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetCCR3_DSEC(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetCCR3_DSEC() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetCCR3_SSEC(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetCCR3_SSEC() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetCCR3_SECM(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetCCR3_SECM() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetCCR3_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR3_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR3_PL(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR3_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR3_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR3_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR3_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR3_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR3_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR3_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR3_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR3_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR3_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR3_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR3_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR3_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR3_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR3_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR3_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR3_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR3_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR3_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR3_EN(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR3_EN() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg) & 0x1
}

// DMA.CNDTR3: channel x number of data to transfer register
func (o *DMA_Type) SetCNDTR3_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR3.Reg, volatile.LoadUint32(&o.CNDTR3.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetCNDTR3_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR3.Reg) & 0x3ffff
}

// DMA.CPAR3: channel x peripheral address register
func (o *DMA_Type) SetCPAR3(value uint32) {
	volatile.StoreUint32(&o.CPAR3.Reg, value)
}
func (o *DMA_Type) GetCPAR3() uint32 {
	return volatile.LoadUint32(&o.CPAR3.Reg)
}

// DMA.CMAR3: channel x memory address register
func (o *DMA_Type) SetCMAR3(value uint32) {
	volatile.StoreUint32(&o.CMAR3.Reg, value)
}
func (o *DMA_Type) GetCMAR3() uint32 {
	return volatile.LoadUint32(&o.CMAR3.Reg)
}

// DMA.CCR4: channel x configuration register
func (o *DMA_Type) SetCCR4_PRIV(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetCCR4_PRIV() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetCCR4_DSEC(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetCCR4_DSEC() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetCCR4_SSEC(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetCCR4_SSEC() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetCCR4_SECM(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetCCR4_SECM() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetCCR4_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR4_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR4_PL(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR4_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR4_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR4_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR4_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR4_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR4_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR4_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR4_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR4_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR4_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR4_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR4_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR4_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR4_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR4_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR4_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR4_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR4_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR4_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR4_EN(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR4_EN() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg) & 0x1
}

// DMA.CNDTR4: channel x number of data to transfer register
func (o *DMA_Type) SetCNDTR4_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR4.Reg, volatile.LoadUint32(&o.CNDTR4.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetCNDTR4_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR4.Reg) & 0x3ffff
}

// DMA.CPAR4: channel x peripheral address register
func (o *DMA_Type) SetCPAR4(value uint32) {
	volatile.StoreUint32(&o.CPAR4.Reg, value)
}
func (o *DMA_Type) GetCPAR4() uint32 {
	return volatile.LoadUint32(&o.CPAR4.Reg)
}

// DMA.CMAR4: channel x memory address register
func (o *DMA_Type) SetCMAR4(value uint32) {
	volatile.StoreUint32(&o.CMAR4.Reg, value)
}
func (o *DMA_Type) GetCMAR4() uint32 {
	return volatile.LoadUint32(&o.CMAR4.Reg)
}

// DMA.CCR5: channel x configuration register
func (o *DMA_Type) SetCCR5_PRIV(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetCCR5_PRIV() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetCCR5_DSEC(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetCCR5_DSEC() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetCCR5_SSEC(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetCCR5_SSEC() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetCCR5_SECM(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetCCR5_SECM() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetCCR5_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR5_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR5_PL(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR5_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR5_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR5_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR5_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR5_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR5_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR5_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR5_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR5_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR5_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR5_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR5_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR5_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR5_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR5_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR5_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR5_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR5_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR5_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR5_EN(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR5_EN() uint32 {
	return volatile.LoadUint32(&o.CCR5.Reg) & 0x1
}

// DMA.CNDTR5: channel x number of data to transfer register
func (o *DMA_Type) SetCNDTR5_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR5.Reg, volatile.LoadUint32(&o.CNDTR5.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetCNDTR5_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR5.Reg) & 0x3ffff
}

// DMA.CPAR5: channel x peripheral address register
func (o *DMA_Type) SetCPAR5(value uint32) {
	volatile.StoreUint32(&o.CPAR5.Reg, value)
}
func (o *DMA_Type) GetCPAR5() uint32 {
	return volatile.LoadUint32(&o.CPAR5.Reg)
}

// DMA.CMAR5: channel x memory address register
func (o *DMA_Type) SetCMAR5(value uint32) {
	volatile.StoreUint32(&o.CMAR5.Reg, value)
}
func (o *DMA_Type) GetCMAR5() uint32 {
	return volatile.LoadUint32(&o.CMAR5.Reg)
}

// DMA.CCR6: channel x configuration register
func (o *DMA_Type) SetCCR6_PRIV(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetCCR6_PRIV() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetCCR6_DSEC(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetCCR6_DSEC() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetCCR6_SSEC(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetCCR6_SSEC() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetCCR6_SECM(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetCCR6_SECM() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetCCR6_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR6_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR6_PL(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR6_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR6_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR6_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR6_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR6_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR6_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR6_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR6_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR6_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR6_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR6_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR6_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR6_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR6_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR6_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR6_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR6_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR6_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR6_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR6_EN(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR6_EN() uint32 {
	return volatile.LoadUint32(&o.CCR6.Reg) & 0x1
}

// DMA.CNDTR6: channel x number of data to transfer register
func (o *DMA_Type) SetCNDTR6_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR6.Reg, volatile.LoadUint32(&o.CNDTR6.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetCNDTR6_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR6.Reg) & 0x3ffff
}

// DMA.CPAR6: channel x peripheral address register
func (o *DMA_Type) SetCPAR6(value uint32) {
	volatile.StoreUint32(&o.CPAR6.Reg, value)
}
func (o *DMA_Type) GetCPAR6() uint32 {
	return volatile.LoadUint32(&o.CPAR6.Reg)
}

// DMA.CMAR6: channel x memory address register
func (o *DMA_Type) SetCMAR6(value uint32) {
	volatile.StoreUint32(&o.CMAR6.Reg, value)
}
func (o *DMA_Type) GetCMAR6() uint32 {
	return volatile.LoadUint32(&o.CMAR6.Reg)
}

// DMA.CCR7: channel x configuration register
func (o *DMA_Type) SetCCR7_PRIV(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetCCR7_PRIV() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetCCR7_DSEC(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetCCR7_DSEC() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetCCR7_SSEC(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetCCR7_SSEC() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetCCR7_SECM(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetCCR7_SECM() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetCCR7_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR7_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR7_PL(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR7_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR7_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR7_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR7_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR7_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR7_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR7_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR7_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR7_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR7_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR7_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR7_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR7_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR7_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR7_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR7_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR7_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR7_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR7_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR7_EN(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR7_EN() uint32 {
	return volatile.LoadUint32(&o.CCR7.Reg) & 0x1
}

// DMA.CNDTR7: channel x number of data to transfer register
func (o *DMA_Type) SetCNDTR7_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR7.Reg, volatile.LoadUint32(&o.CNDTR7.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetCNDTR7_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR7.Reg) & 0x3ffff
}

// DMA.CPAR7: channel x peripheral address register
func (o *DMA_Type) SetCPAR7(value uint32) {
	volatile.StoreUint32(&o.CPAR7.Reg, value)
}
func (o *DMA_Type) GetCPAR7() uint32 {
	return volatile.LoadUint32(&o.CPAR7.Reg)
}

// DMA.CMAR7: channel x memory address register
func (o *DMA_Type) SetCMAR7(value uint32) {
	volatile.StoreUint32(&o.CMAR7.Reg, value)
}
func (o *DMA_Type) GetCMAR7() uint32 {
	return volatile.LoadUint32(&o.CMAR7.Reg)
}

// DMA request multiplexer
type DMAMUX_Type struct {
	C0CR  volatile.Register32 // 0x0
	C1CR  volatile.Register32 // 0x4
	C2CR  volatile.Register32 // 0x8
	C3CR  volatile.Register32 // 0xC
	C4CR  volatile.Register32 // 0x10
	C5CR  volatile.Register32 // 0x14
	C6CR  volatile.Register32 // 0x18
	C7CR  volatile.Register32 // 0x1C
	C8CR  volatile.Register32 // 0x20
	C9CR  volatile.Register32 // 0x24
	C10CR volatile.Register32 // 0x28
	C11CR volatile.Register32 // 0x2C
	C12CR volatile.Register32 // 0x30
	C13CR volatile.Register32 // 0x34
	_     [72]byte
	CSR   volatile.Register32 // 0x80
	CCFR  volatile.Register32 // 0x84
	_     [120]byte
	RG0CR volatile.Register32 // 0x100
	RG1CR volatile.Register32 // 0x104
	RG2CR volatile.Register32 // 0x108
	RG3CR volatile.Register32 // 0x10C
	_     [48]byte
	RGSR  volatile.Register32 // 0x140
	RGCFR volatile.Register32 // 0x144
}

// DMAMUX.C0CR: request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC0CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC0CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC0CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC0CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC0CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC0CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC0CR_SE(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC0CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC0CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC0CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC0CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC0CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC0CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC0CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C0CR.Reg) & 0xff
}

// DMAMUX.C1CR: request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC1CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC1CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC1CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC1CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC1CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC1CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC1CR_SE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC1CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC1CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC1CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC1CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC1CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC1CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC1CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C1CR.Reg) & 0xff
}

// DMAMUX.C2CR: request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC2CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC2CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC2CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC2CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC2CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC2CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC2CR_SE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC2CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC2CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC2CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC2CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC2CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC2CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC2CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C2CR.Reg) & 0xff
}

// DMAMUX.C3CR: request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC3CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC3CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC3CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC3CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC3CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC3CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC3CR_SE(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC3CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC3CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC3CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC3CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC3CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC3CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC3CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C3CR.Reg) & 0xff
}

// DMAMUX.C4CR: request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC4CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC4CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC4CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC4CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC4CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC4CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC4CR_SE(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC4CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC4CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC4CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC4CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC4CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC4CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC4CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C4CR.Reg) & 0xff
}

// DMAMUX.C5CR: request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC5CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC5CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC5CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC5CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC5CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC5CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC5CR_SE(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC5CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC5CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC5CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC5CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC5CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC5CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC5CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C5CR.Reg) & 0xff
}

// DMAMUX.C6CR: request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC6CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC6CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC6CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC6CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC6CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC6CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC6CR_SE(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC6CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC6CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC6CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC6CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC6CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC6CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC6CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C6CR.Reg) & 0xff
}

// DMAMUX.C7CR: request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC7CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC7CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC7CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC7CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC7CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC7CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC7CR_SE(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC7CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC7CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC7CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC7CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC7CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC7CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC7CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C7CR.Reg) & 0xff
}

// DMAMUX.C8CR: request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC8CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC8CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC8CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC8CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC8CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC8CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC8CR_SE(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC8CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC8CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC8CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC8CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC8CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC8CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC8CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C8CR.Reg) & 0xff
}

// DMAMUX.C9CR: request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC9CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC9CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC9CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC9CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC9CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC9CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC9CR_SE(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC9CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC9CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC9CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC9CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC9CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC9CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC9CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C9CR.Reg) & 0xff
}

// DMAMUX.C10CR: C10CR
func (o *DMAMUX_Type) SetC10CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC10CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC10CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC10CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC10CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC10CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC10CR_SE(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC10CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC10CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC10CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC10CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC10CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC10CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC10CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C10CR.Reg) & 0xff
}

// DMAMUX.C11CR: C11CR
func (o *DMAMUX_Type) SetC11CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC11CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC11CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC11CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC11CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC11CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC11CR_SE(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC11CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC11CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC11CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC11CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC11CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC11CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC11CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C11CR.Reg) & 0xff
}

// DMAMUX.C12CR: C12CR
func (o *DMAMUX_Type) SetC12CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC12CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC12CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC12CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC12CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC12CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC12CR_SE(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC12CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC12CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC12CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC12CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC12CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC12CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC12CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C12CR.Reg) & 0xff
}

// DMAMUX.C13CR: C13CR
func (o *DMAMUX_Type) SetC13CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC13CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC13CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC13CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC13CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC13CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC13CR_SE(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC13CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC13CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC13CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC13CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC13CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC13CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC13CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C13CR.Reg) & 0xff
}

// DMAMUX.CSR: request line multiplexer interrupt channel status register
func (o *DMAMUX_Type) SetCSR_SOF13(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAMUX_Type) GetCSR_SOF13() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000) >> 13
}
func (o *DMAMUX_Type) SetCSR_SOF12(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAMUX_Type) GetCSR_SOF12() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000) >> 12
}
func (o *DMAMUX_Type) SetCSR_SOF11(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800)|value<<11)
}
func (o *DMAMUX_Type) GetCSR_SOF11() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800) >> 11
}
func (o *DMAMUX_Type) SetCSR_SOF10(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400)|value<<10)
}
func (o *DMAMUX_Type) GetCSR_SOF10() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400) >> 10
}
func (o *DMAMUX_Type) SetCSR_SOF9(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCSR_SOF9() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCSR_SOF8(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCSR_SOF8() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCSR_SOF7(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCSR_SOF7() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}
func (o *DMAMUX_Type) SetCSR_SOF6(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCSR_SOF6() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCSR_SOF5(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMAMUX_Type) GetCSR_SOF5() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *DMAMUX_Type) SetCSR_SOF4(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMAMUX_Type) GetCSR_SOF4() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *DMAMUX_Type) SetCSR_SOF3(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetCSR_SOF3() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetCSR_SOF2(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetCSR_SOF2() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetCSR_SOF1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetCSR_SOF1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetCSR_SOF0(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetCSR_SOF0() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}

// DMAMUX.CCFR: request line multiplexer interrupt channel clear flag register
func (o *DMAMUX_Type) SetCCFR_CSOF13(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAMUX_Type) GetCCFR_CSOF13() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x2000) >> 13
}
func (o *DMAMUX_Type) SetCCFR_CSOF12(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAMUX_Type) GetCCFR_CSOF12() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x1000) >> 12
}
func (o *DMAMUX_Type) SetCCFR_CSOF11(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x800)|value<<11)
}
func (o *DMAMUX_Type) GetCCFR_CSOF11() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x800) >> 11
}
func (o *DMAMUX_Type) SetCCFR_CSOF10(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x400)|value<<10)
}
func (o *DMAMUX_Type) GetCCFR_CSOF10() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x400) >> 10
}
func (o *DMAMUX_Type) SetCCFR_CSOF9(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCFR_CSOF9() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCFR_CSOF8(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCFR_CSOF8() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCFR_CSOF7(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCCFR_CSOF7() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x80) >> 7
}
func (o *DMAMUX_Type) SetCCFR_CSOF6(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCCFR_CSOF6() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCCFR_CSOF5(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x20)|value<<5)
}
func (o *DMAMUX_Type) GetCCFR_CSOF5() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x20) >> 5
}
func (o *DMAMUX_Type) SetCCFR_CSOF4(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x10)|value<<4)
}
func (o *DMAMUX_Type) GetCCFR_CSOF4() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x10) >> 4
}
func (o *DMAMUX_Type) SetCCFR_CSOF3(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetCCFR_CSOF3() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetCCFR_CSOF2(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetCCFR_CSOF2() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetCCFR_CSOF1(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetCCFR_CSOF1() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetCCFR_CSOF0(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetCCFR_CSOF0() uint32 {
	return volatile.LoadUint32(&o.CCFR.Reg) & 0x1
}

// DMAMUX.RG0CR: request generator channel x configuration register
func (o *DMAMUX_Type) SetRG0CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG0CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetRG0CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG0CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG0CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG0CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG0CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG0CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG0CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG0CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG0CR.Reg) & 0x1f
}

// DMAMUX.RG1CR: request generator channel x configuration register
func (o *DMAMUX_Type) SetRG1CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG1CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetRG1CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG1CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG1CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG1CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG1CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG1CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG1CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG1CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG1CR.Reg) & 0x1f
}

// DMAMUX.RG2CR: request generator channel x configuration register
func (o *DMAMUX_Type) SetRG2CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG2CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetRG2CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG2CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG2CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG2CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG2CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG2CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG2CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG2CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG2CR.Reg) & 0x1f
}

// DMAMUX.RG3CR: request generator channel x configuration register
func (o *DMAMUX_Type) SetRG3CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG3CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetRG3CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG3CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG3CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG3CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG3CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG3CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG3CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG3CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG3CR.Reg) & 0x1f
}

// DMAMUX.RGSR: request generator interrupt status register
func (o *DMAMUX_Type) SetRGSR_OF3(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetRGSR_OF3() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetRGSR_OF2(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetRGSR_OF2() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetRGSR_OF1(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetRGSR_OF1() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetRGSR_OF0(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetRGSR_OF0() uint32 {
	return volatile.LoadUint32(&o.RGSR.Reg) & 0x1
}

// DMAMUX.RGCFR: request generator interrupt clear flag register
func (o *DMAMUX_Type) SetRGCFR_COF3(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetRGCFR_COF3() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetRGCFR_COF2(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetRGCFR_COF2() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetRGCFR_COF1(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetRGCFR_COF1() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetRGCFR_COF0(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetRGCFR_COF0() uint32 {
	return volatile.LoadUint32(&o.RGCFR.Reg) & 0x1
}

// External interrupt/event controller
type EXTI_Type struct {
	RTSR1  volatile.Register32 // 0x0
	FTSR1  volatile.Register32 // 0x4
	SWIER1 volatile.Register32 // 0x8
	PR1    volatile.Register32 // 0xC
	_      [16]byte
	RTSR2  volatile.Register32 // 0x20
	FTSR2  volatile.Register32 // 0x24
	SWIER2 volatile.Register32 // 0x28
	PR2    volatile.Register32 // 0x2C
	_      [80]byte
	C1IMR1 volatile.Register32 // 0x80
	C1EMR1 volatile.Register32 // 0x84
	_      [8]byte
	C1IMR2 volatile.Register32 // 0x90
	C1EMR2 volatile.Register32 // 0x94
	_      [40]byte
	C2IMR1 volatile.Register32 // 0xC0
	C2EMR1 volatile.Register32 // 0xC4
	_      [8]byte
	C2IMR2 volatile.Register32 // 0xD0
	C2EMR2 volatile.Register32 // 0xD4
}

// EXTI.RTSR1: rising trigger selection register
func (o *EXTI_Type) SetRTSR1_RT21(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetRTSR1_RT21() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetRTSR1_RT22(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetRTSR1_RT22() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetRTSR1_RT0(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRTSR1_RT0() uint32 {
	return volatile.LoadUint32(&o.RTSR1.Reg) & 0x1
}
func (o *EXTI_Type) SetRTSR1_RT1(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRTSR1_RT1() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRTSR1_RT2(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRTSR1_RT2() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetRTSR1_RT3(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRTSR1_RT3() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRTSR1_RT4(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRTSR1_RT4() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRTSR1_RT5(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRTSR1_RT5() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRTSR1_RT6(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRTSR1_RT6() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetRTSR1_RT7(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetRTSR1_RT7() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetRTSR1_RT8(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRTSR1_RT8() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRTSR1_RT9(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRTSR1_RT9() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetRTSR1_RT10(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetRTSR1_RT10() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetRTSR1_RT11(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetRTSR1_RT11() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetRTSR1_RT12(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetRTSR1_RT12() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetRTSR1_RT13(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetRTSR1_RT13() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetRTSR1_RT14(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetRTSR1_RT14() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetRTSR1_RT15(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetRTSR1_RT15() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetRTSR1_RT16(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetRTSR1_RT16() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x10000) >> 16
}

// EXTI.FTSR1: falling trigger selection register
func (o *EXTI_Type) SetFTSR1_FT21(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetFTSR1_FT21() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetFTSR1_FT22(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetFTSR1_FT22() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetFTSR1_FT0(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFTSR1_FT0() uint32 {
	return volatile.LoadUint32(&o.FTSR1.Reg) & 0x1
}
func (o *EXTI_Type) SetFTSR1_FT1(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFTSR1_FT1() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFTSR1_FT2(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFTSR1_FT2() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetFTSR1_FT3(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFTSR1_FT3() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFTSR1_FT4(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFTSR1_FT4() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFTSR1_FT5(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFTSR1_FT5() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFTSR1_FT6(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFTSR1_FT6() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetFTSR1_FT7(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetFTSR1_FT7() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetFTSR1_FT8(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFTSR1_FT8() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFTSR1_FT9(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFTSR1_FT9() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetFTSR1_FT10(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetFTSR1_FT10() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetFTSR1_FT11(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetFTSR1_FT11() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetFTSR1_FT12(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetFTSR1_FT12() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetFTSR1_FT13(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetFTSR1_FT13() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetFTSR1_FT14(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetFTSR1_FT14() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetFTSR1_FT15(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetFTSR1_FT15() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetFTSR1_FT16(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetFTSR1_FT16() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x10000) >> 16
}

// EXTI.SWIER1: software interrupt event register
func (o *EXTI_Type) SetSWIER1_SWI21(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetSWIER1_SWI21() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetSWIER1_SWI22(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetSWIER1_SWI22() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetSWIER1_SWI0(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSWIER1_SWI0() uint32 {
	return volatile.LoadUint32(&o.SWIER1.Reg) & 0x1
}
func (o *EXTI_Type) SetSWIER1_SWI1(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSWIER1_SWI1() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSWIER1_SWI2(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSWIER1_SWI2() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetSWIER1_SWI3(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSWIER1_SWI3() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSWIER1_SWI4(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSWIER1_SWI4() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSWIER1_SWI5(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSWIER1_SWI5() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSWIER1_SWI6(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSWIER1_SWI6() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetSWIER1_SWI7(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetSWIER1_SWI7() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetSWIER1_SWI8(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSWIER1_SWI8() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSWIER1_SWI9(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSWIER1_SWI9() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetSWIER1_SWI10(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetSWIER1_SWI10() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetSWIER1_SWI11(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetSWIER1_SWI11() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetSWIER1_SWI12(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetSWIER1_SWI12() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetSWIER1_SWI13(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetSWIER1_SWI13() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetSWIER1_SWI14(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetSWIER1_SWI14() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetSWIER1_SWI15(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetSWIER1_SWI15() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetSWIER1_SWI16(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetSWIER1_SWI16() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x10000) >> 16
}

// EXTI.PR1: EXTI pending register
func (o *EXTI_Type) SetPR1_PIF21(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetPR1_PIF21() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetPR1_PIF22(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetPR1_PIF22() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetPR1_PIF0(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetPR1_PIF0() uint32 {
	return volatile.LoadUint32(&o.PR1.Reg) & 0x1
}
func (o *EXTI_Type) SetPR1_PIF1(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetPR1_PIF1() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetPR1_PIF2(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetPR1_PIF2() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetPR1_PIF3(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetPR1_PIF3() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetPR1_PIF4(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetPR1_PIF4() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetPR1_PIF5(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetPR1_PIF5() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetPR1_PIF6(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetPR1_PIF6() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetPR1_PIF7(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetPR1_PIF7() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetPR1_PIF8(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetPR1_PIF8() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetPR1_PIF9(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetPR1_PIF9() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetPR1_PIF10(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetPR1_PIF10() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetPR1_PIF11(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetPR1_PIF11() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetPR1_PIF12(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetPR1_PIF12() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetPR1_PIF13(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetPR1_PIF13() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetPR1_PIF14(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetPR1_PIF14() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetPR1_PIF15(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetPR1_PIF15() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetPR1_PIF16(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetPR1_PIF16() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x10000) >> 16
}

// EXTI.RTSR2: rising trigger selection register
func (o *EXTI_Type) SetRTSR2_RT34(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRTSR2_RT34() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetRTSR2_RT40(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRTSR2_RT40() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRTSR2_RT41(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRTSR2_RT41() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetRTSR2_RT45(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetRTSR2_RT45() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x2000) >> 13
}

// EXTI.FTSR2: falling trigger selection register
func (o *EXTI_Type) SetFTSR2_FT34(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFTSR2_FT34() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetFTSR2_FT40(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFTSR2_FT40() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFTSR2_FT41(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFTSR2_FT41() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetFTSR2_FT45(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetFTSR2_FT45() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x2000) >> 13
}

// EXTI.SWIER2: software interrupt event register
func (o *EXTI_Type) SetSWIER2_SWI34(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSWIER2_SWI34() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetSWIER2_SWI40(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSWIER2_SWI40() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSWIER2_SWI41(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSWIER2_SWI41() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetSWIER2_SWI45(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetSWIER2_SWI45() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x2000) >> 13
}

// EXTI.PR2: pending register
func (o *EXTI_Type) SetPR2_PIF34(value uint32) {
	volatile.StoreUint32(&o.PR2.Reg, volatile.LoadUint32(&o.PR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetPR2_PIF34() uint32 {
	return (volatile.LoadUint32(&o.PR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetPR2_PIF40(value uint32) {
	volatile.StoreUint32(&o.PR2.Reg, volatile.LoadUint32(&o.PR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetPR2_PIF40() uint32 {
	return (volatile.LoadUint32(&o.PR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetPR2_PIF41(value uint32) {
	volatile.StoreUint32(&o.PR2.Reg, volatile.LoadUint32(&o.PR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetPR2_PIF41() uint32 {
	return (volatile.LoadUint32(&o.PR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetPR2_PIF45(value uint32) {
	volatile.StoreUint32(&o.PR2.Reg, volatile.LoadUint32(&o.PR2.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetPR2_PIF45() uint32 {
	return (volatile.LoadUint32(&o.PR2.Reg) & 0x2000) >> 13
}

// EXTI.C1IMR1: interrupt mask register
func (o *EXTI_Type) SetC1IMR1_IM0(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetC1IMR1_IM0() uint32 {
	return volatile.LoadUint32(&o.C1IMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetC1IMR1_IM1(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetC1IMR1_IM1() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetC1IMR1_IM2(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetC1IMR1_IM2() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetC1IMR1_IM3(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetC1IMR1_IM3() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetC1IMR1_IM4(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetC1IMR1_IM4() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetC1IMR1_IM5(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetC1IMR1_IM5() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetC1IMR1_IM6(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetC1IMR1_IM6() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetC1IMR1_IM7(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetC1IMR1_IM7() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetC1IMR1_IM8(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetC1IMR1_IM8() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetC1IMR1_IM9(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetC1IMR1_IM9() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetC1IMR1_IM10(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetC1IMR1_IM10() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetC1IMR1_IM11(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetC1IMR1_IM11() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetC1IMR1_IM12(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetC1IMR1_IM12() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetC1IMR1_IM13(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetC1IMR1_IM13() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetC1IMR1_IM14(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetC1IMR1_IM14() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetC1IMR1_IM15(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetC1IMR1_IM15() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetC1IMR1_IM16(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetC1IMR1_IM16() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetC1IMR1_IM17(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetC1IMR1_IM17() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetC1IMR1_IM18(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetC1IMR1_IM18() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetC1IMR1_IM19(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetC1IMR1_IM19() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetC1IMR1_IM20(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetC1IMR1_IM20() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetC1IMR1_IM21(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetC1IMR1_IM21() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetC1IMR1_IM22(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetC1IMR1_IM22() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetC1IMR1_IM23(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetC1IMR1_IM23() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetC1IMR1_IM24(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetC1IMR1_IM24() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetC1IMR1_IM25(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetC1IMR1_IM25() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetC1IMR1_IM26(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetC1IMR1_IM26() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetC1IMR1_IM27(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetC1IMR1_IM27() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetC1IMR1_IM28(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetC1IMR1_IM28() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetC1IMR1_IM29(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetC1IMR1_IM29() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetC1IMR1_IM30(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetC1IMR1_IM30() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetC1IMR1_IM31(value uint32) {
	volatile.StoreUint32(&o.C1IMR1.Reg, volatile.LoadUint32(&o.C1IMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetC1IMR1_IM31() uint32 {
	return (volatile.LoadUint32(&o.C1IMR1.Reg) & 0x80000000) >> 31
}

// EXTI.C1EMR1: event mask register
func (o *EXTI_Type) SetC1EMR1_EM0(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetC1EMR1_EM0() uint32 {
	return volatile.LoadUint32(&o.C1EMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetC1EMR1_EM1(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetC1EMR1_EM1() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetC1EMR1_EM2(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetC1EMR1_EM2() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetC1EMR1_EM3(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetC1EMR1_EM3() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetC1EMR1_EM4(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetC1EMR1_EM4() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetC1EMR1_EM5(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetC1EMR1_EM5() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetC1EMR1_EM6(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetC1EMR1_EM6() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetC1EMR1_EM7(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetC1EMR1_EM7() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetC1EMR1_EM8(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetC1EMR1_EM8() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetC1EMR1_EM9(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetC1EMR1_EM9() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetC1EMR1_EM10(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetC1EMR1_EM10() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetC1EMR1_EM11(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetC1EMR1_EM11() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetC1EMR1_EM12(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetC1EMR1_EM12() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetC1EMR1_EM13(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetC1EMR1_EM13() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetC1EMR1_EM14(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetC1EMR1_EM14() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetC1EMR1_EM15(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetC1EMR1_EM15() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetC1EMR1_EM17(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetC1EMR1_EM17() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetC1EMR1_EM18(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetC1EMR1_EM18() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetC1EMR1_EM19(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetC1EMR1_EM19() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetC1EMR1_EM20(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetC1EMR1_EM20() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetC1EMR1_EM21(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetC1EMR1_EM21() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetC1EMR1_EM22(value uint32) {
	volatile.StoreUint32(&o.C1EMR1.Reg, volatile.LoadUint32(&o.C1EMR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetC1EMR1_EM22() uint32 {
	return (volatile.LoadUint32(&o.C1EMR1.Reg) & 0x400000) >> 22
}

// EXTI.C1IMR2: wakeup with interrupt mask register
func (o *EXTI_Type) SetC1IMR2_IM34(value uint32) {
	volatile.StoreUint32(&o.C1IMR2.Reg, volatile.LoadUint32(&o.C1IMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetC1IMR2_IM34() uint32 {
	return (volatile.LoadUint32(&o.C1IMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetC1IMR2_IM36(value uint32) {
	volatile.StoreUint32(&o.C1IMR2.Reg, volatile.LoadUint32(&o.C1IMR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetC1IMR2_IM36() uint32 {
	return (volatile.LoadUint32(&o.C1IMR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetC1IMR2_IM37(value uint32) {
	volatile.StoreUint32(&o.C1IMR2.Reg, volatile.LoadUint32(&o.C1IMR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetC1IMR2_IM37() uint32 {
	return (volatile.LoadUint32(&o.C1IMR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetC1IMR2_IM38(value uint32) {
	volatile.StoreUint32(&o.C1IMR2.Reg, volatile.LoadUint32(&o.C1IMR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetC1IMR2_IM38() uint32 {
	return (volatile.LoadUint32(&o.C1IMR2.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetC1IMR2_IM39(value uint32) {
	volatile.StoreUint32(&o.C1IMR2.Reg, volatile.LoadUint32(&o.C1IMR2.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetC1IMR2_IM39() uint32 {
	return (volatile.LoadUint32(&o.C1IMR2.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetC1IMR2_IM40(value uint32) {
	volatile.StoreUint32(&o.C1IMR2.Reg, volatile.LoadUint32(&o.C1IMR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetC1IMR2_IM40() uint32 {
	return (volatile.LoadUint32(&o.C1IMR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetC1IMR2_IM41(value uint32) {
	volatile.StoreUint32(&o.C1IMR2.Reg, volatile.LoadUint32(&o.C1IMR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetC1IMR2_IM41() uint32 {
	return (volatile.LoadUint32(&o.C1IMR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetC1IMR2_IM42(value uint32) {
	volatile.StoreUint32(&o.C1IMR2.Reg, volatile.LoadUint32(&o.C1IMR2.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetC1IMR2_IM42() uint32 {
	return (volatile.LoadUint32(&o.C1IMR2.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetC1IMR2_IM43(value uint32) {
	volatile.StoreUint32(&o.C1IMR2.Reg, volatile.LoadUint32(&o.C1IMR2.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetC1IMR2_IM43() uint32 {
	return (volatile.LoadUint32(&o.C1IMR2.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetC1IMR2_IM44(value uint32) {
	volatile.StoreUint32(&o.C1IMR2.Reg, volatile.LoadUint32(&o.C1IMR2.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetC1IMR2_IM44() uint32 {
	return (volatile.LoadUint32(&o.C1IMR2.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetC1IMR2_IM45(value uint32) {
	volatile.StoreUint32(&o.C1IMR2.Reg, volatile.LoadUint32(&o.C1IMR2.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetC1IMR2_IM45() uint32 {
	return (volatile.LoadUint32(&o.C1IMR2.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetC1IMR2_IM46(value uint32) {
	volatile.StoreUint32(&o.C1IMR2.Reg, volatile.LoadUint32(&o.C1IMR2.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetC1IMR2_IM46() uint32 {
	return (volatile.LoadUint32(&o.C1IMR2.Reg) & 0x4000) >> 14
}

// EXTI.C1EMR2: wakeup with event mask register
func (o *EXTI_Type) SetC1EMR2_EM40(value uint32) {
	volatile.StoreUint32(&o.C1EMR2.Reg, volatile.LoadUint32(&o.C1EMR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetC1EMR2_EM40() uint32 {
	return (volatile.LoadUint32(&o.C1EMR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetC1EMR2_EM41(value uint32) {
	volatile.StoreUint32(&o.C1EMR2.Reg, volatile.LoadUint32(&o.C1EMR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetC1EMR2_EM41() uint32 {
	return (volatile.LoadUint32(&o.C1EMR2.Reg) & 0x200) >> 9
}

// EXTI.C2IMR1: interrupt mask register
func (o *EXTI_Type) SetC2IMR1(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, value)
}
func (o *EXTI_Type) GetC2IMR1() uint32 {
	return volatile.LoadUint32(&o.C2IMR1.Reg)
}

// EXTI.C2EMR1: event mask register
func (o *EXTI_Type) SetC2EMR1_EM0(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetC2EMR1_EM0() uint32 {
	return volatile.LoadUint32(&o.C2EMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetC2EMR1_EM1(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetC2EMR1_EM1() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetC2EMR1_EM2(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetC2EMR1_EM2() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetC2EMR1_EM3(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetC2EMR1_EM3() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetC2EMR1_EM4(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetC2EMR1_EM4() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetC2EMR1_EM5(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetC2EMR1_EM5() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetC2EMR1_EM6(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetC2EMR1_EM6() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetC2EMR1_EM7(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetC2EMR1_EM7() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetC2EMR1_EM8(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetC2EMR1_EM8() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetC2EMR1_EM9(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetC2EMR1_EM9() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetC2EMR1_EM10(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetC2EMR1_EM10() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetC2EMR1_EM11(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetC2EMR1_EM11() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetC2EMR1_EM12(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetC2EMR1_EM12() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetC2EMR1_EM13(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetC2EMR1_EM13() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetC2EMR1_EM14(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetC2EMR1_EM14() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetC2EMR1_EM15(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetC2EMR1_EM15() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetC2EMR1_EM17(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetC2EMR1_EM17() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetC2EMR1_EM18(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetC2EMR1_EM18() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetC2EMR1_EM19(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetC2EMR1_EM19() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetC2EMR1_EM20(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetC2EMR1_EM20() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetC2EMR1_EM21(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetC2EMR1_EM21() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetC2EMR1_EM22(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetC2EMR1_EM22() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x400000) >> 22
}

// EXTI.C2IMR2: wakeup with interrupt mask register
func (o *EXTI_Type) SetC2IMR2_IM34(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetC2IMR2_IM34() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetC2IMR2_IM36(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetC2IMR2_IM36() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetC2IMR2_IM37(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetC2IMR2_IM37() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetC2IMR2_IM38(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetC2IMR2_IM38() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetC2IMR2_IM39(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetC2IMR2_IM39() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetC2IMR2_IM40(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetC2IMR2_IM40() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetC2IMR2_IM41(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetC2IMR2_IM41() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetC2IMR2_IM42(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetC2IMR2_IM42() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetC2IMR2_IM43(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetC2IMR2_IM43() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetC2IMR2_IM44(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetC2IMR2_IM44() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetC2IMR2_IM45(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetC2IMR2_IM45() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetC2IMR2_IM46(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetC2IMR2_IM46() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x4000) >> 14
}

// EXTI.C2EMR2: wakeup with event mask register
func (o *EXTI_Type) SetC2EMR2_EM40(value uint32) {
	volatile.StoreUint32(&o.C2EMR2.Reg, volatile.LoadUint32(&o.C2EMR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetC2EMR2_EM40() uint32 {
	return (volatile.LoadUint32(&o.C2EMR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetC2EMR2_EM41(value uint32) {
	volatile.StoreUint32(&o.C2EMR2.Reg, volatile.LoadUint32(&o.C2EMR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetC2EMR2_EM41() uint32 {
	return (volatile.LoadUint32(&o.C2EMR2.Reg) & 0x200) >> 9
}

// Flash
type Flash_Type struct {
	ACR       volatile.Register32 // 0x0
	ACR2      volatile.Register32 // 0x4
	KEYR      volatile.Register32 // 0x8
	OPTKEYR   volatile.Register32 // 0xC
	SR        volatile.Register32 // 0x10
	CR        volatile.Register32 // 0x14
	ECCR      volatile.Register32 // 0x18
	_         [4]byte
	OPTR      volatile.Register32 // 0x20
	PCROP1ASR volatile.Register32 // 0x24
	PCROP1AER volatile.Register32 // 0x28
	WRP1AR    volatile.Register32 // 0x2C
	WRP1BR    volatile.Register32 // 0x30
	PCROP1BSR volatile.Register32 // 0x34
	PCROP1BER volatile.Register32 // 0x38
	IPCCBR    volatile.Register32 // 0x3C
	_         [28]byte
	C2ACR     volatile.Register32 // 0x5C
	C2SR      volatile.Register32 // 0x60
	C2CR      volatile.Register32 // 0x64
	_         [24]byte
	SFR       volatile.Register32 // 0x80
	SRRVR     volatile.Register32 // 0x84
}

// Flash.ACR: Access control register
func (o *Flash_Type) SetACR_LATENCY(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x7)|value)
}
func (o *Flash_Type) GetACR_LATENCY() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x7
}
func (o *Flash_Type) SetACR_PRFTEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetACR_PRFTEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetACR_ICEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x200)|value<<9)
}
func (o *Flash_Type) GetACR_ICEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x200) >> 9
}
func (o *Flash_Type) SetACR_DCEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x400)|value<<10)
}
func (o *Flash_Type) GetACR_DCEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x400) >> 10
}
func (o *Flash_Type) SetACR_ICRST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x800)|value<<11)
}
func (o *Flash_Type) GetACR_ICRST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x800) >> 11
}
func (o *Flash_Type) SetACR_DCRST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x1000)|value<<12)
}
func (o *Flash_Type) GetACR_DCRST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x1000) >> 12
}
func (o *Flash_Type) SetACR_PES(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x8000)|value<<15)
}
func (o *Flash_Type) GetACR_PES() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x8000) >> 15
}
func (o *Flash_Type) SetACR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetACR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x10000) >> 16
}

// Flash.ACR2: Flash access control register 2
func (o *Flash_Type) SetACR2_PRIVMODE(value uint32) {
	volatile.StoreUint32(&o.ACR2.Reg, volatile.LoadUint32(&o.ACR2.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetACR2_PRIVMODE() uint32 {
	return volatile.LoadUint32(&o.ACR2.Reg) & 0x1
}
func (o *Flash_Type) SetACR2_HDPADIS(value uint32) {
	volatile.StoreUint32(&o.ACR2.Reg, volatile.LoadUint32(&o.ACR2.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetACR2_HDPADIS() uint32 {
	return (volatile.LoadUint32(&o.ACR2.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetACR2_C2SWDBGEN(value uint32) {
	volatile.StoreUint32(&o.ACR2.Reg, volatile.LoadUint32(&o.ACR2.Reg)&^(0x4)|value<<2)
}
func (o *Flash_Type) GetACR2_C2SWDBGEN() uint32 {
	return (volatile.LoadUint32(&o.ACR2.Reg) & 0x4) >> 2
}

// Flash.KEYR: Flash key register
func (o *Flash_Type) SetKEYR(value uint32) {
	volatile.StoreUint32(&o.KEYR.Reg, value)
}
func (o *Flash_Type) GetKEYR() uint32 {
	return volatile.LoadUint32(&o.KEYR.Reg)
}

// Flash.OPTKEYR: Option byte key register
func (o *Flash_Type) SetOPTKEYR(value uint32) {
	volatile.StoreUint32(&o.OPTKEYR.Reg, value)
}
func (o *Flash_Type) GetOPTKEYR() uint32 {
	return volatile.LoadUint32(&o.OPTKEYR.Reg)
}

// Flash.SR: Status register
func (o *Flash_Type) SetSR_EOP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetSR_EOP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *Flash_Type) SetSR_OPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetSR_OPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetSR_PROGERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *Flash_Type) GetSR_PROGERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *Flash_Type) SetSR_WRPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *Flash_Type) GetSR_WRPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *Flash_Type) SetSR_PGAERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *Flash_Type) GetSR_PGAERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *Flash_Type) SetSR_SIZERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *Flash_Type) GetSR_SIZERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *Flash_Type) SetSR_PGSERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *Flash_Type) GetSR_PGSERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *Flash_Type) SetSR_MISSERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetSR_MISSERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetSR_FASTERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *Flash_Type) GetSR_FASTERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *Flash_Type) SetSR_OPTNV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *Flash_Type) GetSR_OPTNV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *Flash_Type) SetSR_RDERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *Flash_Type) GetSR_RDERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *Flash_Type) SetSR_OPTVERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *Flash_Type) GetSR_OPTVERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *Flash_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetSR_CFGBSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetSR_CFGBSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *Flash_Type) SetSR_PESD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *Flash_Type) GetSR_PESD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}

// Flash.CR: Flash control register
func (o *Flash_Type) SetCR_PG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetCR_PG() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *Flash_Type) SetCR_PER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetCR_PER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetCR_MER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *Flash_Type) GetCR_MER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *Flash_Type) SetCR_PNB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3f8)|value<<3)
}
func (o *Flash_Type) GetCR_PNB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3f8) >> 3
}
func (o *Flash_Type) SetCR_STRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetCR_STRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetCR_OPTSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *Flash_Type) GetCR_OPTSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *Flash_Type) SetCR_FSTPG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetCR_FSTPG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *Flash_Type) SetCR_EOPIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetCR_EOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *Flash_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *Flash_Type) SetCR_RDERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *Flash_Type) GetCR_RDERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *Flash_Type) SetCR_OBL_LAUNCH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *Flash_Type) GetCR_OBL_LAUNCH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}
func (o *Flash_Type) SetCR_OPTLOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *Flash_Type) GetCR_OPTLOCK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}
func (o *Flash_Type) SetCR_LOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetCR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}

// Flash.ECCR: Flash ECC register
func (o *Flash_Type) SetECCR_ADDR_ECC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x1ffff)|value)
}
func (o *Flash_Type) GetECCR_ADDR_ECC() uint32 {
	return volatile.LoadUint32(&o.ECCR.Reg) & 0x1ffff
}
func (o *Flash_Type) SetECCR_SYSF_ECC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x100000)|value<<20)
}
func (o *Flash_Type) GetECCR_SYSF_ECC() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x100000) >> 20
}
func (o *Flash_Type) SetECCR_ECCCIE(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetECCR_ECCCIE() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetECCR_CPUID(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x1c000000)|value<<26)
}
func (o *Flash_Type) GetECCR_CPUID() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x1c000000) >> 26
}
func (o *Flash_Type) SetECCR_ECCC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x40000000)|value<<30)
}
func (o *Flash_Type) GetECCR_ECCC() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x40000000) >> 30
}
func (o *Flash_Type) SetECCR_ECCD(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetECCR_ECCD() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x80000000) >> 31
}

// Flash.OPTR: Flash option register
func (o *Flash_Type) SetOPTR_RDP(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetOPTR_RDP() uint32 {
	return volatile.LoadUint32(&o.OPTR.Reg) & 0xff
}
func (o *Flash_Type) SetOPTR_ESE(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetOPTR_ESE() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetOPTR_BOR_LEV(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0xe00)|value<<9)
}
func (o *Flash_Type) GetOPTR_BOR_LEV() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0xe00) >> 9
}
func (o *Flash_Type) SetOPTR_NRST_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x1000)|value<<12)
}
func (o *Flash_Type) GetOPTR_NRST_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x1000) >> 12
}
func (o *Flash_Type) SetOPTR_NRST_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x2000)|value<<13)
}
func (o *Flash_Type) GetOPTR_NRST_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x2000) >> 13
}
func (o *Flash_Type) SetOPTR_NRST_SHDW(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x4000)|value<<14)
}
func (o *Flash_Type) GetOPTR_NRST_SHDW() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x4000) >> 14
}
func (o *Flash_Type) SetOPTR_IWDG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetOPTR_IWDG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetOPTR_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x20000)|value<<17)
}
func (o *Flash_Type) GetOPTR_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x20000) >> 17
}
func (o *Flash_Type) SetOPTR_IWDG_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetOPTR_IWDG_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x40000) >> 18
}
func (o *Flash_Type) SetOPTR_WWDG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x80000)|value<<19)
}
func (o *Flash_Type) GetOPTR_WWDG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x80000) >> 19
}
func (o *Flash_Type) SetOPTR_NBOOT1(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x800000)|value<<23)
}
func (o *Flash_Type) GetOPTR_NBOOT1() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x800000) >> 23
}
func (o *Flash_Type) SetOPTR_SRAM2_PE(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetOPTR_SRAM2_PE() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetOPTR_SRAM_RST(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x2000000)|value<<25)
}
func (o *Flash_Type) GetOPTR_SRAM_RST() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x2000000) >> 25
}
func (o *Flash_Type) SetOPTR_NSWBOOT0(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x4000000)|value<<26)
}
func (o *Flash_Type) GetOPTR_NSWBOOT0() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x4000000) >> 26
}
func (o *Flash_Type) SetOPTR_NBOOT0(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x8000000)|value<<27)
}
func (o *Flash_Type) GetOPTR_NBOOT0() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x8000000) >> 27
}
func (o *Flash_Type) SetOPTR_BOOT_LOCK(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x40000000)|value<<30)
}
func (o *Flash_Type) GetOPTR_BOOT_LOCK() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x40000000) >> 30
}
func (o *Flash_Type) SetOPTR_C2BOOT_LOCK(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetOPTR_C2BOOT_LOCK() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x80000000) >> 31
}

// Flash.PCROP1ASR: Flash PCROP zone A Start address register
func (o *Flash_Type) SetPCROP1ASR_PCROP1A_STRT(value uint32) {
	volatile.StoreUint32(&o.PCROP1ASR.Reg, volatile.LoadUint32(&o.PCROP1ASR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetPCROP1ASR_PCROP1A_STRT() uint32 {
	return volatile.LoadUint32(&o.PCROP1ASR.Reg) & 0xff
}

// Flash.PCROP1AER: Flash PCROP zone A End address register
func (o *Flash_Type) SetPCROP1AER_PCROP1A_END(value uint32) {
	volatile.StoreUint32(&o.PCROP1AER.Reg, volatile.LoadUint32(&o.PCROP1AER.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetPCROP1AER_PCROP1A_END() uint32 {
	return volatile.LoadUint32(&o.PCROP1AER.Reg) & 0xff
}
func (o *Flash_Type) SetPCROP1AER_PCROP_RDP(value uint32) {
	volatile.StoreUint32(&o.PCROP1AER.Reg, volatile.LoadUint32(&o.PCROP1AER.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetPCROP1AER_PCROP_RDP() uint32 {
	return (volatile.LoadUint32(&o.PCROP1AER.Reg) & 0x80000000) >> 31
}

// Flash.WRP1AR: Flash WRP area A address register
func (o *Flash_Type) SetWRP1AR_WRP1A_STRT(value uint32) {
	volatile.StoreUint32(&o.WRP1AR.Reg, volatile.LoadUint32(&o.WRP1AR.Reg)&^(0x7f)|value)
}
func (o *Flash_Type) GetWRP1AR_WRP1A_STRT() uint32 {
	return volatile.LoadUint32(&o.WRP1AR.Reg) & 0x7f
}
func (o *Flash_Type) SetWRP1AR_WRP1A_END(value uint32) {
	volatile.StoreUint32(&o.WRP1AR.Reg, volatile.LoadUint32(&o.WRP1AR.Reg)&^(0x7f0000)|value<<16)
}
func (o *Flash_Type) GetWRP1AR_WRP1A_END() uint32 {
	return (volatile.LoadUint32(&o.WRP1AR.Reg) & 0x7f0000) >> 16
}

// Flash.WRP1BR: Flash WRP area B address register
func (o *Flash_Type) SetWRP1BR_WRP1B_STRT(value uint32) {
	volatile.StoreUint32(&o.WRP1BR.Reg, volatile.LoadUint32(&o.WRP1BR.Reg)&^(0x7f)|value)
}
func (o *Flash_Type) GetWRP1BR_WRP1B_STRT() uint32 {
	return volatile.LoadUint32(&o.WRP1BR.Reg) & 0x7f
}
func (o *Flash_Type) SetWRP1BR_WRP1B_END(value uint32) {
	volatile.StoreUint32(&o.WRP1BR.Reg, volatile.LoadUint32(&o.WRP1BR.Reg)&^(0x7f0000)|value<<16)
}
func (o *Flash_Type) GetWRP1BR_WRP1B_END() uint32 {
	return (volatile.LoadUint32(&o.WRP1BR.Reg) & 0x7f0000) >> 16
}

// Flash.PCROP1BSR: Flash PCROP zone B Start address register
func (o *Flash_Type) SetPCROP1BSR_PCROP1B_STRT(value uint32) {
	volatile.StoreUint32(&o.PCROP1BSR.Reg, volatile.LoadUint32(&o.PCROP1BSR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetPCROP1BSR_PCROP1B_STRT() uint32 {
	return volatile.LoadUint32(&o.PCROP1BSR.Reg) & 0xff
}

// Flash.PCROP1BER: Flash PCROP zone B End address register
func (o *Flash_Type) SetPCROP1BER_PCROP1B_END(value uint32) {
	volatile.StoreUint32(&o.PCROP1BER.Reg, volatile.LoadUint32(&o.PCROP1BER.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetPCROP1BER_PCROP1B_END() uint32 {
	return volatile.LoadUint32(&o.PCROP1BER.Reg) & 0xff
}

// Flash.IPCCBR: Flash IPCC data buffer address register
func (o *Flash_Type) SetIPCCBR_IPCCDBA(value uint32) {
	volatile.StoreUint32(&o.IPCCBR.Reg, volatile.LoadUint32(&o.IPCCBR.Reg)&^(0x3fff)|value)
}
func (o *Flash_Type) GetIPCCBR_IPCCDBA() uint32 {
	return volatile.LoadUint32(&o.IPCCBR.Reg) & 0x3fff
}

// Flash.C2ACR: Flash CPU2 access control register
func (o *Flash_Type) SetC2ACR_PRFTEN(value uint32) {
	volatile.StoreUint32(&o.C2ACR.Reg, volatile.LoadUint32(&o.C2ACR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetC2ACR_PRFTEN() uint32 {
	return (volatile.LoadUint32(&o.C2ACR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetC2ACR_ICEN(value uint32) {
	volatile.StoreUint32(&o.C2ACR.Reg, volatile.LoadUint32(&o.C2ACR.Reg)&^(0x200)|value<<9)
}
func (o *Flash_Type) GetC2ACR_ICEN() uint32 {
	return (volatile.LoadUint32(&o.C2ACR.Reg) & 0x200) >> 9
}
func (o *Flash_Type) SetC2ACR_ICRST(value uint32) {
	volatile.StoreUint32(&o.C2ACR.Reg, volatile.LoadUint32(&o.C2ACR.Reg)&^(0x800)|value<<11)
}
func (o *Flash_Type) GetC2ACR_ICRST() uint32 {
	return (volatile.LoadUint32(&o.C2ACR.Reg) & 0x800) >> 11
}
func (o *Flash_Type) SetC2ACR_PES(value uint32) {
	volatile.StoreUint32(&o.C2ACR.Reg, volatile.LoadUint32(&o.C2ACR.Reg)&^(0x8000)|value<<15)
}
func (o *Flash_Type) GetC2ACR_PES() uint32 {
	return (volatile.LoadUint32(&o.C2ACR.Reg) & 0x8000) >> 15
}

// Flash.C2SR: Flash CPU2 status register
func (o *Flash_Type) SetC2SR_EOP(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetC2SR_EOP() uint32 {
	return volatile.LoadUint32(&o.C2SR.Reg) & 0x1
}
func (o *Flash_Type) SetC2SR_OPERR(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetC2SR_OPERR() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetC2SR_PROGERR(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x8)|value<<3)
}
func (o *Flash_Type) GetC2SR_PROGERR() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x8) >> 3
}
func (o *Flash_Type) SetC2SR_WRPERR(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x10)|value<<4)
}
func (o *Flash_Type) GetC2SR_WRPERR() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x10) >> 4
}
func (o *Flash_Type) SetC2SR_PGAERR(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x20)|value<<5)
}
func (o *Flash_Type) GetC2SR_PGAERR() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x20) >> 5
}
func (o *Flash_Type) SetC2SR_SIZERR(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x40)|value<<6)
}
func (o *Flash_Type) GetC2SR_SIZERR() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x40) >> 6
}
func (o *Flash_Type) SetC2SR_PGSERR(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x80)|value<<7)
}
func (o *Flash_Type) GetC2SR_PGSERR() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x80) >> 7
}
func (o *Flash_Type) SetC2SR_MISSERR(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetC2SR_MISSERR() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetC2SR_FASTERR(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x200)|value<<9)
}
func (o *Flash_Type) GetC2SR_FASTERR() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x200) >> 9
}
func (o *Flash_Type) SetC2SR_RDERR(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x4000)|value<<14)
}
func (o *Flash_Type) GetC2SR_RDERR() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x4000) >> 14
}
func (o *Flash_Type) SetC2SR_BSY(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetC2SR_BSY() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetC2SR_CFGBSY(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetC2SR_CFGBSY() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x40000) >> 18
}
func (o *Flash_Type) SetC2SR_PESD(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x80000)|value<<19)
}
func (o *Flash_Type) GetC2SR_PESD() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x80000) >> 19
}

// Flash.C2CR: Flash CPU2 control register
func (o *Flash_Type) SetC2CR_PG(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetC2CR_PG() uint32 {
	return volatile.LoadUint32(&o.C2CR.Reg) & 0x1
}
func (o *Flash_Type) SetC2CR_PER(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetC2CR_PER() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetC2CR_MER(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x4)|value<<2)
}
func (o *Flash_Type) GetC2CR_MER() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x4) >> 2
}
func (o *Flash_Type) SetC2CR_PNB(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x3f8)|value<<3)
}
func (o *Flash_Type) GetC2CR_PNB() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x3f8) >> 3
}
func (o *Flash_Type) SetC2CR_STRT(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetC2CR_STRT() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetC2CR_FSTPG(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetC2CR_FSTPG() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x40000) >> 18
}
func (o *Flash_Type) SetC2CR_EOPIE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetC2CR_EOPIE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetC2CR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x2000000)|value<<25)
}
func (o *Flash_Type) GetC2CR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x2000000) >> 25
}
func (o *Flash_Type) SetC2CR_RDERRIE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x4000000)|value<<26)
}
func (o *Flash_Type) GetC2CR_RDERRIE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x4000000) >> 26
}

// Flash.SFR: Flash secure Flash start address register
func (o *Flash_Type) SetSFR_SFSA(value uint32) {
	volatile.StoreUint32(&o.SFR.Reg, volatile.LoadUint32(&o.SFR.Reg)&^(0x7f)|value)
}
func (o *Flash_Type) GetSFR_SFSA() uint32 {
	return volatile.LoadUint32(&o.SFR.Reg) & 0x7f
}
func (o *Flash_Type) SetSFR_FSD(value uint32) {
	volatile.StoreUint32(&o.SFR.Reg, volatile.LoadUint32(&o.SFR.Reg)&^(0x80)|value<<7)
}
func (o *Flash_Type) GetSFR_FSD() uint32 {
	return (volatile.LoadUint32(&o.SFR.Reg) & 0x80) >> 7
}
func (o *Flash_Type) SetSFR_DDS(value uint32) {
	volatile.StoreUint32(&o.SFR.Reg, volatile.LoadUint32(&o.SFR.Reg)&^(0x1000)|value<<12)
}
func (o *Flash_Type) GetSFR_DDS() uint32 {
	return (volatile.LoadUint32(&o.SFR.Reg) & 0x1000) >> 12
}
func (o *Flash_Type) SetSFR_HDPSA(value uint32) {
	volatile.StoreUint32(&o.SFR.Reg, volatile.LoadUint32(&o.SFR.Reg)&^(0x7f0000)|value<<16)
}
func (o *Flash_Type) GetSFR_HDPSA() uint32 {
	return (volatile.LoadUint32(&o.SFR.Reg) & 0x7f0000) >> 16
}
func (o *Flash_Type) SetSFR_HDPAD(value uint32) {
	volatile.StoreUint32(&o.SFR.Reg, volatile.LoadUint32(&o.SFR.Reg)&^(0x800000)|value<<23)
}
func (o *Flash_Type) GetSFR_HDPAD() uint32 {
	return (volatile.LoadUint32(&o.SFR.Reg) & 0x800000) >> 23
}
func (o *Flash_Type) SetSFR_SUBGHSPISD(value uint32) {
	volatile.StoreUint32(&o.SFR.Reg, volatile.LoadUint32(&o.SFR.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetSFR_SUBGHSPISD() uint32 {
	return (volatile.LoadUint32(&o.SFR.Reg) & 0x80000000) >> 31
}

// Flash.SRRVR: Flash secure SRAM start address and CPU2 reset vector register
func (o *Flash_Type) SetSRRVR_SBRV(value uint32) {
	volatile.StoreUint32(&o.SRRVR.Reg, volatile.LoadUint32(&o.SRRVR.Reg)&^(0xffff)|value)
}
func (o *Flash_Type) GetSRRVR_SBRV() uint32 {
	return volatile.LoadUint32(&o.SRRVR.Reg) & 0xffff
}
func (o *Flash_Type) SetSRRVR_SBRSA(value uint32) {
	volatile.StoreUint32(&o.SRRVR.Reg, volatile.LoadUint32(&o.SRRVR.Reg)&^(0x7c0000)|value<<18)
}
func (o *Flash_Type) GetSRRVR_SBRSA() uint32 {
	return (volatile.LoadUint32(&o.SRRVR.Reg) & 0x7c0000) >> 18
}
func (o *Flash_Type) SetSRRVR_BRSD(value uint32) {
	volatile.StoreUint32(&o.SRRVR.Reg, volatile.LoadUint32(&o.SRRVR.Reg)&^(0x800000)|value<<23)
}
func (o *Flash_Type) GetSRRVR_BRSD() uint32 {
	return (volatile.LoadUint32(&o.SRRVR.Reg) & 0x800000) >> 23
}
func (o *Flash_Type) SetSRRVR_SNBRSA(value uint32) {
	volatile.StoreUint32(&o.SRRVR.Reg, volatile.LoadUint32(&o.SRRVR.Reg)&^(0x3e000000)|value<<25)
}
func (o *Flash_Type) GetSRRVR_SNBRSA() uint32 {
	return (volatile.LoadUint32(&o.SRRVR.Reg) & 0x3e000000) >> 25
}
func (o *Flash_Type) SetSRRVR_NBRSD(value uint32) {
	volatile.StoreUint32(&o.SRRVR.Reg, volatile.LoadUint32(&o.SRRVR.Reg)&^(0x40000000)|value<<30)
}
func (o *Flash_Type) GetSRRVR_NBRSD() uint32 {
	return (volatile.LoadUint32(&o.SRRVR.Reg) & 0x40000000) >> 30
}
func (o *Flash_Type) SetSRRVR_C2OPT(value uint32) {
	volatile.StoreUint32(&o.SRRVR.Reg, volatile.LoadUint32(&o.SRRVR.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetSRRVR_C2OPT() uint32 {
	return (volatile.LoadUint32(&o.SRRVR.Reg) & 0x80000000) >> 31
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
}

// GPIO.MODER: GPIO port mode register
func (o *GPIO_Type) SetMODER_MODER15(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetMODER_MODER15() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetMODER_MODER14(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetMODER_MODER14() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetMODER_MODER13(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetMODER_MODER13() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetMODER_MODER12(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetMODER_MODER12() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetMODER_MODER11(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetMODER_MODER11() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetMODER_MODER10(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetMODER_MODER10() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetMODER_MODER9(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetMODER_MODER9() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetMODER_MODER8(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetMODER_MODER8() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetMODER_MODER7(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetMODER_MODER7() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetMODER_MODER6(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetMODER_MODER6() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetMODER_MODER5(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetMODER_MODER5() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetMODER_MODER4(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetMODER_MODER4() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetMODER_MODER3(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetMODER_MODER3() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetMODER_MODER2(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetMODER_MODER2() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetMODER_MODER1(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetMODER_MODER1() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetMODER_MODER0(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetMODER_MODER0() uint32 {
	return volatile.LoadUint32(&o.MODER.Reg) & 0x3
}

// GPIO.OTYPER: GPIO port output type register
func (o *GPIO_Type) SetOTYPER_OT15(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOTYPER_OT15() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOTYPER_OT14(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOTYPER_OT14() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOTYPER_OT13(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOTYPER_OT13() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOTYPER_OT12(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOTYPER_OT12() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOTYPER_OT11(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOTYPER_OT11() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOTYPER_OT10(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOTYPER_OT10() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOTYPER_OT9(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOTYPER_OT9() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOTYPER_OT8(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOTYPER_OT8() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOTYPER_OT7(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOTYPER_OT7() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOTYPER_OT6(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOTYPER_OT6() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOTYPER_OT5(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOTYPER_OT5() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOTYPER_OT4(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOTYPER_OT4() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOTYPER_OT3(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOTYPER_OT3() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOTYPER_OT2(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOTYPER_OT2() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOTYPER_OT1(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOTYPER_OT1() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOTYPER_OT0(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOTYPER_OT0() uint32 {
	return volatile.LoadUint32(&o.OTYPER.Reg) & 0x1
}

// GPIO.OSPEEDR: GPIO port output speed register
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR15(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR15() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR14(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR14() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR13(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR13() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR12(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR12() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR11(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR11() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR10(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR10() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR9(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR9() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR8(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR8() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR7(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR7() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR6(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR6() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR5(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR5() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR4(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR4() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR3(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR3() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR2(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR2() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR1(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR1() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR0(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR0() uint32 {
	return volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3
}

// GPIO.PUPDR: GPIO port pull-up/pull-down register
func (o *GPIO_Type) SetPUPDR_PUPDR15(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetPUPDR_PUPDR15() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetPUPDR_PUPDR14(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetPUPDR_PUPDR14() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetPUPDR_PUPDR13(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetPUPDR_PUPDR13() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetPUPDR_PUPDR12(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetPUPDR_PUPDR12() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetPUPDR_PUPDR11(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetPUPDR_PUPDR11() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetPUPDR_PUPDR10(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetPUPDR_PUPDR10() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetPUPDR_PUPDR9(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetPUPDR_PUPDR9() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetPUPDR_PUPDR8(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPUPDR_PUPDR8() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetPUPDR_PUPDR7(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetPUPDR_PUPDR7() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetPUPDR_PUPDR6(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetPUPDR_PUPDR6() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetPUPDR_PUPDR5(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetPUPDR_PUPDR5() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetPUPDR_PUPDR4(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetPUPDR_PUPDR4() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetPUPDR_PUPDR3(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetPUPDR_PUPDR3() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetPUPDR_PUPDR2(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetPUPDR_PUPDR2() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetPUPDR_PUPDR1(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPUPDR_PUPDR1() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPUPDR_PUPDR0(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPUPDR_PUPDR0() uint32 {
	return volatile.LoadUint32(&o.PUPDR.Reg) & 0x3
}

// GPIO.IDR: GPIO port input data register
func (o *GPIO_Type) SetIDR_IDR15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIDR_IDR15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIDR_IDR14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIDR_IDR14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIDR_IDR13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIDR_IDR13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIDR_IDR12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIDR_IDR12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIDR_IDR11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIDR_IDR11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIDR_IDR10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIDR_IDR10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIDR_IDR9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIDR_IDR9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIDR_IDR8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIDR_IDR8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIDR_IDR7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIDR_IDR7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIDR_IDR6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIDR_IDR6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIDR_IDR5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIDR_IDR5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIDR_IDR4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIDR_IDR4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIDR_IDR3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIDR_IDR3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIDR_IDR2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIDR_IDR2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIDR_IDR1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIDR_IDR1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIDR_IDR0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIDR_IDR0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// GPIO.ODR: GPIO port output data register
func (o *GPIO_Type) SetODR_ODR15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetODR_ODR15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetODR_ODR14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetODR_ODR14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetODR_ODR13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetODR_ODR13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetODR_ODR12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetODR_ODR12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetODR_ODR11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetODR_ODR11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetODR_ODR10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetODR_ODR10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetODR_ODR9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetODR_ODR9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetODR_ODR8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetODR_ODR8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetODR_ODR7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetODR_ODR7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetODR_ODR6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetODR_ODR6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetODR_ODR5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetODR_ODR5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetODR_ODR4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetODR_ODR4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetODR_ODR3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetODR_ODR3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetODR_ODR2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetODR_ODR2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetODR_ODR1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetODR_ODR1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetODR_ODR0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetODR_ODR0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}

// GPIO.BSRR: GPIO port bit set/reset register
func (o *GPIO_Type) SetBSRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetBSRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000000) >> 31
}
func (o *GPIO_Type) SetBSRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetBSRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetBSRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetBSRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetBSRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetBSRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetBSRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetBSRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetBSRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetBSRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetBSRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetBSRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetBSRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetBSRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetBSRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetBSRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetBSRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetBSRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetBSRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetBSRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetBSRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetBSRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetBSRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetBSRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetBSRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetBSRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetBSRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetBSRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetBSRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetBSRR_BR0() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetBSRR_BS15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBSRR_BS15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetBSRR_BS14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBSRR_BS14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBSRR_BS13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBSRR_BS13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBSRR_BS12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBSRR_BS12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBSRR_BS11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBSRR_BS11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBSRR_BS10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBSRR_BS10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBSRR_BS9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBSRR_BS9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBSRR_BS8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBSRR_BS8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBSRR_BS7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBSRR_BS7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBSRR_BS6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBSRR_BS6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBSRR_BS5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBSRR_BS5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBSRR_BS4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBSRR_BS4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBSRR_BS3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBSRR_BS3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBSRR_BS2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBSRR_BS2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBSRR_BS1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBSRR_BS1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBSRR_BS0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBSRR_BS0() uint32 {
	return volatile.LoadUint32(&o.BSRR.Reg) & 0x1
}

// GPIO.LCKR: GPIO port configuration lock register
func (o *GPIO_Type) SetLCKR_LCKK(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLCKR_LCKK() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLCKR_LCK15(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLCKR_LCK15() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLCKR_LCK14(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLCKR_LCK14() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLCKR_LCK13(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLCKR_LCK13() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLCKR_LCK12(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLCKR_LCK12() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLCKR_LCK11(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLCKR_LCK11() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLCKR_LCK10(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLCKR_LCK10() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLCKR_LCK9(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLCKR_LCK9() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLCKR_LCK8(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLCKR_LCK8() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLCKR_LCK7(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLCKR_LCK7() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLCKR_LCK6(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLCKR_LCK6() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLCKR_LCK5(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLCKR_LCK5() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLCKR_LCK4(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLCKR_LCK4() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLCKR_LCK3(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLCKR_LCK3() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLCKR_LCK2(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLCKR_LCK2() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLCKR_LCK1(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLCKR_LCK1() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLCKR_LCK0(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLCKR_LCK0() uint32 {
	return volatile.LoadUint32(&o.LCKR.Reg) & 0x1
}

// GPIO.AFRL: GPIO alternate function low register
func (o *GPIO_Type) SetAFRL_AFRL7(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRL_AFRL7() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRL_AFRL6(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRL_AFRL6() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRL_AFRL5(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRL_AFRL5() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRL_AFRL4(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRL_AFRL4() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRL_AFRL3(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRL_AFRL3() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRL_AFRL2(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRL_AFRL2() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRL_AFRL1(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRL_AFRL1() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRL_AFRL0(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRL_AFRL0() uint32 {
	return volatile.LoadUint32(&o.AFRL.Reg) & 0xf
}

// GPIO.AFRH: GPIO alternate function high register
func (o *GPIO_Type) SetAFRH_AFRH15(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRH_AFRH15() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRH_AFRH14(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRH_AFRH14() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRH_AFRH13(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRH_AFRH13() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRH_AFRH12(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRH_AFRH12() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRH_AFRH11(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRH_AFRH11() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRH_AFRH10(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRH_AFRH10() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRH_AFRH9(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRH_AFRH9() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRH_AFRH8(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRH_AFRH8() uint32 {
	return volatile.LoadUint32(&o.AFRH.Reg) & 0xf
}

// GPIO.BRR: GPIO port bit reset register
func (o *GPIO_Type) SetBRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBRR_BR0() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0x1
}
func (o *GPIO_Type) SetBRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x8000) >> 15
}

// Hardware semaphore
type HSEM_Type struct {
	R0     volatile.Register32 // 0x0
	R1     volatile.Register32 // 0x4
	R2     volatile.Register32 // 0x8
	R3     volatile.Register32 // 0xC
	R4     volatile.Register32 // 0x10
	R5     volatile.Register32 // 0x14
	R6     volatile.Register32 // 0x18
	R7     volatile.Register32 // 0x1C
	R8     volatile.Register32 // 0x20
	R9     volatile.Register32 // 0x24
	R10    volatile.Register32 // 0x28
	R11    volatile.Register32 // 0x2C
	R12    volatile.Register32 // 0x30
	R13    volatile.Register32 // 0x34
	R14    volatile.Register32 // 0x38
	R15    volatile.Register32 // 0x3C
	_      [64]byte
	RLR0   volatile.Register32 // 0x80
	RLR1   volatile.Register32 // 0x84
	RLR2   volatile.Register32 // 0x88
	RLR3   volatile.Register32 // 0x8C
	RLR4   volatile.Register32 // 0x90
	RLR5   volatile.Register32 // 0x94
	RLR6   volatile.Register32 // 0x98
	RLR7   volatile.Register32 // 0x9C
	RLR8   volatile.Register32 // 0xA0
	RLR9   volatile.Register32 // 0xA4
	RLR10  volatile.Register32 // 0xA8
	RLR11  volatile.Register32 // 0xAC
	RLR12  volatile.Register32 // 0xB0
	RLR13  volatile.Register32 // 0xB4
	RLR14  volatile.Register32 // 0xB8
	RLR15  volatile.Register32 // 0xBC
	_      [64]byte
	C1IER  volatile.Register32 // 0x100
	C1ICR  volatile.Register32 // 0x104
	C1ISR  volatile.Register32 // 0x108
	C1MISR volatile.Register32 // 0x10C
	C2IER  volatile.Register32 // 0x110
	C2ICR  volatile.Register32 // 0x114
	C2ISR  volatile.Register32 // 0x118
	C2MISR volatile.Register32 // 0x11C
	_      [32]byte
	CR     volatile.Register32 // 0x140
	KEYR   volatile.Register32 // 0x144
}

// HSEM.R0: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR0_PROCID(value uint32) {
	volatile.StoreUint32(&o.R0.Reg, volatile.LoadUint32(&o.R0.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR0_PROCID() uint32 {
	return volatile.LoadUint32(&o.R0.Reg) & 0xff
}
func (o *HSEM_Type) SetR0_COREID(value uint32) {
	volatile.StoreUint32(&o.R0.Reg, volatile.LoadUint32(&o.R0.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetR0_COREID() uint32 {
	return (volatile.LoadUint32(&o.R0.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetR0_LOCK(value uint32) {
	volatile.StoreUint32(&o.R0.Reg, volatile.LoadUint32(&o.R0.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR0_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R0.Reg) & 0x80000000) >> 31
}

// HSEM.R1: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR1_PROCID(value uint32) {
	volatile.StoreUint32(&o.R1.Reg, volatile.LoadUint32(&o.R1.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR1_PROCID() uint32 {
	return volatile.LoadUint32(&o.R1.Reg) & 0xff
}
func (o *HSEM_Type) SetR1_COREID(value uint32) {
	volatile.StoreUint32(&o.R1.Reg, volatile.LoadUint32(&o.R1.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetR1_COREID() uint32 {
	return (volatile.LoadUint32(&o.R1.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetR1_LOCK(value uint32) {
	volatile.StoreUint32(&o.R1.Reg, volatile.LoadUint32(&o.R1.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR1_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R1.Reg) & 0x80000000) >> 31
}

// HSEM.R2: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR2_PROCID(value uint32) {
	volatile.StoreUint32(&o.R2.Reg, volatile.LoadUint32(&o.R2.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR2_PROCID() uint32 {
	return volatile.LoadUint32(&o.R2.Reg) & 0xff
}
func (o *HSEM_Type) SetR2_COREID(value uint32) {
	volatile.StoreUint32(&o.R2.Reg, volatile.LoadUint32(&o.R2.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetR2_COREID() uint32 {
	return (volatile.LoadUint32(&o.R2.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetR2_LOCK(value uint32) {
	volatile.StoreUint32(&o.R2.Reg, volatile.LoadUint32(&o.R2.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR2_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R2.Reg) & 0x80000000) >> 31
}

// HSEM.R3: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR3_PROCID(value uint32) {
	volatile.StoreUint32(&o.R3.Reg, volatile.LoadUint32(&o.R3.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR3_PROCID() uint32 {
	return volatile.LoadUint32(&o.R3.Reg) & 0xff
}
func (o *HSEM_Type) SetR3_COREID(value uint32) {
	volatile.StoreUint32(&o.R3.Reg, volatile.LoadUint32(&o.R3.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetR3_COREID() uint32 {
	return (volatile.LoadUint32(&o.R3.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetR3_LOCK(value uint32) {
	volatile.StoreUint32(&o.R3.Reg, volatile.LoadUint32(&o.R3.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR3_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R3.Reg) & 0x80000000) >> 31
}

// HSEM.R4: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR4_PROCID(value uint32) {
	volatile.StoreUint32(&o.R4.Reg, volatile.LoadUint32(&o.R4.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR4_PROCID() uint32 {
	return volatile.LoadUint32(&o.R4.Reg) & 0xff
}
func (o *HSEM_Type) SetR4_COREID(value uint32) {
	volatile.StoreUint32(&o.R4.Reg, volatile.LoadUint32(&o.R4.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetR4_COREID() uint32 {
	return (volatile.LoadUint32(&o.R4.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetR4_LOCK(value uint32) {
	volatile.StoreUint32(&o.R4.Reg, volatile.LoadUint32(&o.R4.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR4_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R4.Reg) & 0x80000000) >> 31
}

// HSEM.R5: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR5_PROCID(value uint32) {
	volatile.StoreUint32(&o.R5.Reg, volatile.LoadUint32(&o.R5.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR5_PROCID() uint32 {
	return volatile.LoadUint32(&o.R5.Reg) & 0xff
}
func (o *HSEM_Type) SetR5_COREID(value uint32) {
	volatile.StoreUint32(&o.R5.Reg, volatile.LoadUint32(&o.R5.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetR5_COREID() uint32 {
	return (volatile.LoadUint32(&o.R5.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetR5_LOCK(value uint32) {
	volatile.StoreUint32(&o.R5.Reg, volatile.LoadUint32(&o.R5.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR5_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R5.Reg) & 0x80000000) >> 31
}

// HSEM.R6: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR6_PROCID(value uint32) {
	volatile.StoreUint32(&o.R6.Reg, volatile.LoadUint32(&o.R6.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR6_PROCID() uint32 {
	return volatile.LoadUint32(&o.R6.Reg) & 0xff
}
func (o *HSEM_Type) SetR6_COREID(value uint32) {
	volatile.StoreUint32(&o.R6.Reg, volatile.LoadUint32(&o.R6.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetR6_COREID() uint32 {
	return (volatile.LoadUint32(&o.R6.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetR6_LOCK(value uint32) {
	volatile.StoreUint32(&o.R6.Reg, volatile.LoadUint32(&o.R6.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR6_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R6.Reg) & 0x80000000) >> 31
}

// HSEM.R7: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR7_PROCID(value uint32) {
	volatile.StoreUint32(&o.R7.Reg, volatile.LoadUint32(&o.R7.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR7_PROCID() uint32 {
	return volatile.LoadUint32(&o.R7.Reg) & 0xff
}
func (o *HSEM_Type) SetR7_COREID(value uint32) {
	volatile.StoreUint32(&o.R7.Reg, volatile.LoadUint32(&o.R7.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetR7_COREID() uint32 {
	return (volatile.LoadUint32(&o.R7.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetR7_LOCK(value uint32) {
	volatile.StoreUint32(&o.R7.Reg, volatile.LoadUint32(&o.R7.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR7_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R7.Reg) & 0x80000000) >> 31
}

// HSEM.R8: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR8_PROCID(value uint32) {
	volatile.StoreUint32(&o.R8.Reg, volatile.LoadUint32(&o.R8.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR8_PROCID() uint32 {
	return volatile.LoadUint32(&o.R8.Reg) & 0xff
}
func (o *HSEM_Type) SetR8_COREID(value uint32) {
	volatile.StoreUint32(&o.R8.Reg, volatile.LoadUint32(&o.R8.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetR8_COREID() uint32 {
	return (volatile.LoadUint32(&o.R8.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetR8_LOCK(value uint32) {
	volatile.StoreUint32(&o.R8.Reg, volatile.LoadUint32(&o.R8.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR8_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R8.Reg) & 0x80000000) >> 31
}

// HSEM.R9: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR9_PROCID(value uint32) {
	volatile.StoreUint32(&o.R9.Reg, volatile.LoadUint32(&o.R9.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR9_PROCID() uint32 {
	return volatile.LoadUint32(&o.R9.Reg) & 0xff
}
func (o *HSEM_Type) SetR9_COREID(value uint32) {
	volatile.StoreUint32(&o.R9.Reg, volatile.LoadUint32(&o.R9.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetR9_COREID() uint32 {
	return (volatile.LoadUint32(&o.R9.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetR9_LOCK(value uint32) {
	volatile.StoreUint32(&o.R9.Reg, volatile.LoadUint32(&o.R9.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR9_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R9.Reg) & 0x80000000) >> 31
}

// HSEM.R10: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR10_PROCID(value uint32) {
	volatile.StoreUint32(&o.R10.Reg, volatile.LoadUint32(&o.R10.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR10_PROCID() uint32 {
	return volatile.LoadUint32(&o.R10.Reg) & 0xff
}
func (o *HSEM_Type) SetR10_COREID(value uint32) {
	volatile.StoreUint32(&o.R10.Reg, volatile.LoadUint32(&o.R10.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetR10_COREID() uint32 {
	return (volatile.LoadUint32(&o.R10.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetR10_LOCK(value uint32) {
	volatile.StoreUint32(&o.R10.Reg, volatile.LoadUint32(&o.R10.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR10_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R10.Reg) & 0x80000000) >> 31
}

// HSEM.R11: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR11_PROCID(value uint32) {
	volatile.StoreUint32(&o.R11.Reg, volatile.LoadUint32(&o.R11.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR11_PROCID() uint32 {
	return volatile.LoadUint32(&o.R11.Reg) & 0xff
}
func (o *HSEM_Type) SetR11_COREID(value uint32) {
	volatile.StoreUint32(&o.R11.Reg, volatile.LoadUint32(&o.R11.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetR11_COREID() uint32 {
	return (volatile.LoadUint32(&o.R11.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetR11_LOCK(value uint32) {
	volatile.StoreUint32(&o.R11.Reg, volatile.LoadUint32(&o.R11.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR11_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R11.Reg) & 0x80000000) >> 31
}

// HSEM.R12: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR12_PROCID(value uint32) {
	volatile.StoreUint32(&o.R12.Reg, volatile.LoadUint32(&o.R12.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR12_PROCID() uint32 {
	return volatile.LoadUint32(&o.R12.Reg) & 0xff
}
func (o *HSEM_Type) SetR12_COREID(value uint32) {
	volatile.StoreUint32(&o.R12.Reg, volatile.LoadUint32(&o.R12.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetR12_COREID() uint32 {
	return (volatile.LoadUint32(&o.R12.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetR12_LOCK(value uint32) {
	volatile.StoreUint32(&o.R12.Reg, volatile.LoadUint32(&o.R12.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR12_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R12.Reg) & 0x80000000) >> 31
}

// HSEM.R13: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR13_PROCID(value uint32) {
	volatile.StoreUint32(&o.R13.Reg, volatile.LoadUint32(&o.R13.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR13_PROCID() uint32 {
	return volatile.LoadUint32(&o.R13.Reg) & 0xff
}
func (o *HSEM_Type) SetR13_COREID(value uint32) {
	volatile.StoreUint32(&o.R13.Reg, volatile.LoadUint32(&o.R13.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetR13_COREID() uint32 {
	return (volatile.LoadUint32(&o.R13.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetR13_LOCK(value uint32) {
	volatile.StoreUint32(&o.R13.Reg, volatile.LoadUint32(&o.R13.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR13_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R13.Reg) & 0x80000000) >> 31
}

// HSEM.R14: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR14_PROCID(value uint32) {
	volatile.StoreUint32(&o.R14.Reg, volatile.LoadUint32(&o.R14.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR14_PROCID() uint32 {
	return volatile.LoadUint32(&o.R14.Reg) & 0xff
}
func (o *HSEM_Type) SetR14_COREID(value uint32) {
	volatile.StoreUint32(&o.R14.Reg, volatile.LoadUint32(&o.R14.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetR14_COREID() uint32 {
	return (volatile.LoadUint32(&o.R14.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetR14_LOCK(value uint32) {
	volatile.StoreUint32(&o.R14.Reg, volatile.LoadUint32(&o.R14.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR14_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R14.Reg) & 0x80000000) >> 31
}

// HSEM.R15: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR15_PROCID(value uint32) {
	volatile.StoreUint32(&o.R15.Reg, volatile.LoadUint32(&o.R15.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR15_PROCID() uint32 {
	return volatile.LoadUint32(&o.R15.Reg) & 0xff
}
func (o *HSEM_Type) SetR15_COREID(value uint32) {
	volatile.StoreUint32(&o.R15.Reg, volatile.LoadUint32(&o.R15.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetR15_COREID() uint32 {
	return (volatile.LoadUint32(&o.R15.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetR15_LOCK(value uint32) {
	volatile.StoreUint32(&o.R15.Reg, volatile.LoadUint32(&o.R15.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR15_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R15.Reg) & 0x80000000) >> 31
}

// HSEM.RLR0: HSEM Read lock register
func (o *HSEM_Type) SetRLR0_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR0.Reg, volatile.LoadUint32(&o.RLR0.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR0_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR0.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR0_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR0.Reg, volatile.LoadUint32(&o.RLR0.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetRLR0_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR0.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetRLR0_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR0.Reg, volatile.LoadUint32(&o.RLR0.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR0_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR0.Reg) & 0x80000000) >> 31
}

// HSEM.RLR1: HSEM Read lock register
func (o *HSEM_Type) SetRLR1_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR1.Reg, volatile.LoadUint32(&o.RLR1.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR1_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR1.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR1_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR1.Reg, volatile.LoadUint32(&o.RLR1.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetRLR1_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR1.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetRLR1_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR1.Reg, volatile.LoadUint32(&o.RLR1.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR1_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR1.Reg) & 0x80000000) >> 31
}

// HSEM.RLR2: HSEM Read lock register
func (o *HSEM_Type) SetRLR2_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR2.Reg, volatile.LoadUint32(&o.RLR2.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR2_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR2.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR2_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR2.Reg, volatile.LoadUint32(&o.RLR2.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetRLR2_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR2.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetRLR2_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR2.Reg, volatile.LoadUint32(&o.RLR2.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR2_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR2.Reg) & 0x80000000) >> 31
}

// HSEM.RLR3: HSEM Read lock register
func (o *HSEM_Type) SetRLR3_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR3.Reg, volatile.LoadUint32(&o.RLR3.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR3_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR3.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR3_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR3.Reg, volatile.LoadUint32(&o.RLR3.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetRLR3_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR3.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetRLR3_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR3.Reg, volatile.LoadUint32(&o.RLR3.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR3_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR3.Reg) & 0x80000000) >> 31
}

// HSEM.RLR4: HSEM Read lock register
func (o *HSEM_Type) SetRLR4_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR4.Reg, volatile.LoadUint32(&o.RLR4.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR4_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR4.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR4_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR4.Reg, volatile.LoadUint32(&o.RLR4.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetRLR4_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR4.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetRLR4_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR4.Reg, volatile.LoadUint32(&o.RLR4.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR4_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR4.Reg) & 0x80000000) >> 31
}

// HSEM.RLR5: HSEM Read lock register
func (o *HSEM_Type) SetRLR5_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR5.Reg, volatile.LoadUint32(&o.RLR5.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR5_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR5.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR5_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR5.Reg, volatile.LoadUint32(&o.RLR5.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetRLR5_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR5.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetRLR5_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR5.Reg, volatile.LoadUint32(&o.RLR5.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR5_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR5.Reg) & 0x80000000) >> 31
}

// HSEM.RLR6: HSEM Read lock register
func (o *HSEM_Type) SetRLR6_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR6.Reg, volatile.LoadUint32(&o.RLR6.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR6_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR6.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR6_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR6.Reg, volatile.LoadUint32(&o.RLR6.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetRLR6_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR6.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetRLR6_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR6.Reg, volatile.LoadUint32(&o.RLR6.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR6_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR6.Reg) & 0x80000000) >> 31
}

// HSEM.RLR7: HSEM Read lock register
func (o *HSEM_Type) SetRLR7_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR7.Reg, volatile.LoadUint32(&o.RLR7.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR7_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR7.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR7_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR7.Reg, volatile.LoadUint32(&o.RLR7.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetRLR7_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR7.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetRLR7_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR7.Reg, volatile.LoadUint32(&o.RLR7.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR7_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR7.Reg) & 0x80000000) >> 31
}

// HSEM.RLR8: HSEM Read lock register
func (o *HSEM_Type) SetRLR8_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR8.Reg, volatile.LoadUint32(&o.RLR8.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR8_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR8.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR8_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR8.Reg, volatile.LoadUint32(&o.RLR8.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetRLR8_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR8.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetRLR8_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR8.Reg, volatile.LoadUint32(&o.RLR8.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR8_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR8.Reg) & 0x80000000) >> 31
}

// HSEM.RLR9: HSEM Read lock register
func (o *HSEM_Type) SetRLR9_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR9.Reg, volatile.LoadUint32(&o.RLR9.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR9_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR9.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR9_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR9.Reg, volatile.LoadUint32(&o.RLR9.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetRLR9_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR9.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetRLR9_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR9.Reg, volatile.LoadUint32(&o.RLR9.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR9_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR9.Reg) & 0x80000000) >> 31
}

// HSEM.RLR10: HSEM Read lock register
func (o *HSEM_Type) SetRLR10_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR10.Reg, volatile.LoadUint32(&o.RLR10.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR10_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR10.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR10_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR10.Reg, volatile.LoadUint32(&o.RLR10.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetRLR10_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR10.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetRLR10_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR10.Reg, volatile.LoadUint32(&o.RLR10.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR10_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR10.Reg) & 0x80000000) >> 31
}

// HSEM.RLR11: HSEM Read lock register
func (o *HSEM_Type) SetRLR11_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR11.Reg, volatile.LoadUint32(&o.RLR11.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR11_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR11.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR11_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR11.Reg, volatile.LoadUint32(&o.RLR11.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetRLR11_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR11.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetRLR11_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR11.Reg, volatile.LoadUint32(&o.RLR11.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR11_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR11.Reg) & 0x80000000) >> 31
}

// HSEM.RLR12: HSEM Read lock register
func (o *HSEM_Type) SetRLR12_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR12.Reg, volatile.LoadUint32(&o.RLR12.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR12_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR12.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR12_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR12.Reg, volatile.LoadUint32(&o.RLR12.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetRLR12_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR12.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetRLR12_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR12.Reg, volatile.LoadUint32(&o.RLR12.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR12_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR12.Reg) & 0x80000000) >> 31
}

// HSEM.RLR13: HSEM Read lock register
func (o *HSEM_Type) SetRLR13_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR13.Reg, volatile.LoadUint32(&o.RLR13.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR13_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR13.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR13_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR13.Reg, volatile.LoadUint32(&o.RLR13.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetRLR13_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR13.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetRLR13_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR13.Reg, volatile.LoadUint32(&o.RLR13.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR13_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR13.Reg) & 0x80000000) >> 31
}

// HSEM.RLR14: HSEM Read lock register
func (o *HSEM_Type) SetRLR14_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR14.Reg, volatile.LoadUint32(&o.RLR14.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR14_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR14.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR14_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR14.Reg, volatile.LoadUint32(&o.RLR14.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetRLR14_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR14.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetRLR14_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR14.Reg, volatile.LoadUint32(&o.RLR14.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR14_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR14.Reg) & 0x80000000) >> 31
}

// HSEM.RLR15: HSEM Read lock register
func (o *HSEM_Type) SetRLR15_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR15.Reg, volatile.LoadUint32(&o.RLR15.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR15_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR15.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR15_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR15.Reg, volatile.LoadUint32(&o.RLR15.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetRLR15_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR15.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetRLR15_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR15.Reg, volatile.LoadUint32(&o.RLR15.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR15_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR15.Reg) & 0x80000000) >> 31
}

// HSEM.C1IER: HSEM Interrupt enable register
func (o *HSEM_Type) SetC1IER_ISE0(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x1)|value)
}
func (o *HSEM_Type) GetC1IER_ISE0() uint32 {
	return volatile.LoadUint32(&o.C1IER.Reg) & 0x1
}
func (o *HSEM_Type) SetC1IER_ISE1(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x2)|value<<1)
}
func (o *HSEM_Type) GetC1IER_ISE1() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x2) >> 1
}
func (o *HSEM_Type) SetC1IER_ISE2(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x4)|value<<2)
}
func (o *HSEM_Type) GetC1IER_ISE2() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x4) >> 2
}
func (o *HSEM_Type) SetC1IER_ISE3(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x8)|value<<3)
}
func (o *HSEM_Type) GetC1IER_ISE3() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x8) >> 3
}
func (o *HSEM_Type) SetC1IER_ISE4(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x10)|value<<4)
}
func (o *HSEM_Type) GetC1IER_ISE4() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x10) >> 4
}
func (o *HSEM_Type) SetC1IER_ISE5(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x20)|value<<5)
}
func (o *HSEM_Type) GetC1IER_ISE5() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x20) >> 5
}
func (o *HSEM_Type) SetC1IER_ISE6(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x40)|value<<6)
}
func (o *HSEM_Type) GetC1IER_ISE6() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x40) >> 6
}
func (o *HSEM_Type) SetC1IER_ISE7(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x80)|value<<7)
}
func (o *HSEM_Type) GetC1IER_ISE7() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x80) >> 7
}
func (o *HSEM_Type) SetC1IER_ISE8(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x100)|value<<8)
}
func (o *HSEM_Type) GetC1IER_ISE8() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x100) >> 8
}
func (o *HSEM_Type) SetC1IER_ISE9(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x200)|value<<9)
}
func (o *HSEM_Type) GetC1IER_ISE9() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x200) >> 9
}
func (o *HSEM_Type) SetC1IER_ISE10(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x400)|value<<10)
}
func (o *HSEM_Type) GetC1IER_ISE10() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x400) >> 10
}
func (o *HSEM_Type) SetC1IER_ISE11(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x800)|value<<11)
}
func (o *HSEM_Type) GetC1IER_ISE11() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x800) >> 11
}
func (o *HSEM_Type) SetC1IER_ISE12(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x1000)|value<<12)
}
func (o *HSEM_Type) GetC1IER_ISE12() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x1000) >> 12
}
func (o *HSEM_Type) SetC1IER_ISE13(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x2000)|value<<13)
}
func (o *HSEM_Type) GetC1IER_ISE13() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x2000) >> 13
}
func (o *HSEM_Type) SetC1IER_ISE14(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x4000)|value<<14)
}
func (o *HSEM_Type) GetC1IER_ISE14() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x4000) >> 14
}
func (o *HSEM_Type) SetC1IER_ISE15(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x8000)|value<<15)
}
func (o *HSEM_Type) GetC1IER_ISE15() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x8000) >> 15
}

// HSEM.C1ICR: HSEM Interrupt clear register
func (o *HSEM_Type) SetC1ICR_ISC0(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x1)|value)
}
func (o *HSEM_Type) GetC1ICR_ISC0() uint32 {
	return volatile.LoadUint32(&o.C1ICR.Reg) & 0x1
}
func (o *HSEM_Type) SetC1ICR_ISC1(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x2)|value<<1)
}
func (o *HSEM_Type) GetC1ICR_ISC1() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x2) >> 1
}
func (o *HSEM_Type) SetC1ICR_ISC2(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x4)|value<<2)
}
func (o *HSEM_Type) GetC1ICR_ISC2() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x4) >> 2
}
func (o *HSEM_Type) SetC1ICR_ISC3(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x8)|value<<3)
}
func (o *HSEM_Type) GetC1ICR_ISC3() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x8) >> 3
}
func (o *HSEM_Type) SetC1ICR_ISC4(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x10)|value<<4)
}
func (o *HSEM_Type) GetC1ICR_ISC4() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x10) >> 4
}
func (o *HSEM_Type) SetC1ICR_ISC5(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x20)|value<<5)
}
func (o *HSEM_Type) GetC1ICR_ISC5() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x20) >> 5
}
func (o *HSEM_Type) SetC1ICR_ISC6(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x40)|value<<6)
}
func (o *HSEM_Type) GetC1ICR_ISC6() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x40) >> 6
}
func (o *HSEM_Type) SetC1ICR_ISC7(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x80)|value<<7)
}
func (o *HSEM_Type) GetC1ICR_ISC7() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x80) >> 7
}
func (o *HSEM_Type) SetC1ICR_ISC8(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x100)|value<<8)
}
func (o *HSEM_Type) GetC1ICR_ISC8() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x100) >> 8
}
func (o *HSEM_Type) SetC1ICR_ISC9(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x200)|value<<9)
}
func (o *HSEM_Type) GetC1ICR_ISC9() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x200) >> 9
}
func (o *HSEM_Type) SetC1ICR_ISC10(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x400)|value<<10)
}
func (o *HSEM_Type) GetC1ICR_ISC10() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x400) >> 10
}
func (o *HSEM_Type) SetC1ICR_ISC11(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x800)|value<<11)
}
func (o *HSEM_Type) GetC1ICR_ISC11() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x800) >> 11
}
func (o *HSEM_Type) SetC1ICR_ISC12(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x1000)|value<<12)
}
func (o *HSEM_Type) GetC1ICR_ISC12() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x1000) >> 12
}
func (o *HSEM_Type) SetC1ICR_ISC13(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x2000)|value<<13)
}
func (o *HSEM_Type) GetC1ICR_ISC13() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x2000) >> 13
}
func (o *HSEM_Type) SetC1ICR_ISC14(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x4000)|value<<14)
}
func (o *HSEM_Type) GetC1ICR_ISC14() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x4000) >> 14
}
func (o *HSEM_Type) SetC1ICR_ISC15(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x8000)|value<<15)
}
func (o *HSEM_Type) GetC1ICR_ISC15() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x8000) >> 15
}

// HSEM.C1ISR: HSEM Interrupt status register
func (o *HSEM_Type) SetC1ISR_ISF0(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x1)|value)
}
func (o *HSEM_Type) GetC1ISR_ISF0() uint32 {
	return volatile.LoadUint32(&o.C1ISR.Reg) & 0x1
}
func (o *HSEM_Type) SetC1ISR_ISF1(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x2)|value<<1)
}
func (o *HSEM_Type) GetC1ISR_ISF1() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x2) >> 1
}
func (o *HSEM_Type) SetC1ISR_ISF2(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x4)|value<<2)
}
func (o *HSEM_Type) GetC1ISR_ISF2() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x4) >> 2
}
func (o *HSEM_Type) SetC1ISR_ISF3(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x8)|value<<3)
}
func (o *HSEM_Type) GetC1ISR_ISF3() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x8) >> 3
}
func (o *HSEM_Type) SetC1ISR_ISF4(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x10)|value<<4)
}
func (o *HSEM_Type) GetC1ISR_ISF4() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x10) >> 4
}
func (o *HSEM_Type) SetC1ISR_ISF5(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x20)|value<<5)
}
func (o *HSEM_Type) GetC1ISR_ISF5() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x20) >> 5
}
func (o *HSEM_Type) SetC1ISR_ISF6(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x40)|value<<6)
}
func (o *HSEM_Type) GetC1ISR_ISF6() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x40) >> 6
}
func (o *HSEM_Type) SetC1ISR_ISF7(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x80)|value<<7)
}
func (o *HSEM_Type) GetC1ISR_ISF7() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x80) >> 7
}
func (o *HSEM_Type) SetC1ISR_ISF8(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x100)|value<<8)
}
func (o *HSEM_Type) GetC1ISR_ISF8() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x100) >> 8
}
func (o *HSEM_Type) SetC1ISR_ISF9(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x200)|value<<9)
}
func (o *HSEM_Type) GetC1ISR_ISF9() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x200) >> 9
}
func (o *HSEM_Type) SetC1ISR_ISF10(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x400)|value<<10)
}
func (o *HSEM_Type) GetC1ISR_ISF10() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x400) >> 10
}
func (o *HSEM_Type) SetC1ISR_ISF11(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x800)|value<<11)
}
func (o *HSEM_Type) GetC1ISR_ISF11() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x800) >> 11
}
func (o *HSEM_Type) SetC1ISR_ISF12(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x1000)|value<<12)
}
func (o *HSEM_Type) GetC1ISR_ISF12() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x1000) >> 12
}
func (o *HSEM_Type) SetC1ISR_ISF13(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x2000)|value<<13)
}
func (o *HSEM_Type) GetC1ISR_ISF13() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x2000) >> 13
}
func (o *HSEM_Type) SetC1ISR_ISF14(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x4000)|value<<14)
}
func (o *HSEM_Type) GetC1ISR_ISF14() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x4000) >> 14
}
func (o *HSEM_Type) SetC1ISR_ISF15(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x8000)|value<<15)
}
func (o *HSEM_Type) GetC1ISR_ISF15() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x8000) >> 15
}

// HSEM.C1MISR: HSEM Masked interrupt status register
func (o *HSEM_Type) SetC1MISR_MISF0(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x1)|value)
}
func (o *HSEM_Type) GetC1MISR_MISF0() uint32 {
	return volatile.LoadUint32(&o.C1MISR.Reg) & 0x1
}
func (o *HSEM_Type) SetC1MISR_MISF1(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x2)|value<<1)
}
func (o *HSEM_Type) GetC1MISR_MISF1() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x2) >> 1
}
func (o *HSEM_Type) SetC1MISR_MISF2(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x4)|value<<2)
}
func (o *HSEM_Type) GetC1MISR_MISF2() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x4) >> 2
}
func (o *HSEM_Type) SetC1MISR_MISF3(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x8)|value<<3)
}
func (o *HSEM_Type) GetC1MISR_MISF3() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x8) >> 3
}
func (o *HSEM_Type) SetC1MISR_MISF4(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x10)|value<<4)
}
func (o *HSEM_Type) GetC1MISR_MISF4() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x10) >> 4
}
func (o *HSEM_Type) SetC1MISR_MISF5(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x20)|value<<5)
}
func (o *HSEM_Type) GetC1MISR_MISF5() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x20) >> 5
}
func (o *HSEM_Type) SetC1MISR_MISF6(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x40)|value<<6)
}
func (o *HSEM_Type) GetC1MISR_MISF6() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x40) >> 6
}
func (o *HSEM_Type) SetC1MISR_MISF7(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x80)|value<<7)
}
func (o *HSEM_Type) GetC1MISR_MISF7() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x80) >> 7
}
func (o *HSEM_Type) SetC1MISR_MISF8(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x100)|value<<8)
}
func (o *HSEM_Type) GetC1MISR_MISF8() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x100) >> 8
}
func (o *HSEM_Type) SetC1MISR_MISF9(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x200)|value<<9)
}
func (o *HSEM_Type) GetC1MISR_MISF9() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x200) >> 9
}
func (o *HSEM_Type) SetC1MISR_MISF10(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x400)|value<<10)
}
func (o *HSEM_Type) GetC1MISR_MISF10() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x400) >> 10
}
func (o *HSEM_Type) SetC1MISR_MISF11(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x800)|value<<11)
}
func (o *HSEM_Type) GetC1MISR_MISF11() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x800) >> 11
}
func (o *HSEM_Type) SetC1MISR_MISF12(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x1000)|value<<12)
}
func (o *HSEM_Type) GetC1MISR_MISF12() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x1000) >> 12
}
func (o *HSEM_Type) SetC1MISR_MISF13(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x2000)|value<<13)
}
func (o *HSEM_Type) GetC1MISR_MISF13() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x2000) >> 13
}
func (o *HSEM_Type) SetC1MISR_MISF14(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x4000)|value<<14)
}
func (o *HSEM_Type) GetC1MISR_MISF14() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x4000) >> 14
}
func (o *HSEM_Type) SetC1MISR_MISF15(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x8000)|value<<15)
}
func (o *HSEM_Type) GetC1MISR_MISF15() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x8000) >> 15
}

// HSEM.C2IER: HSEM Interrupt enable register
func (o *HSEM_Type) SetC2IER_ISE0(value uint32) {
	volatile.StoreUint32(&o.C2IER.Reg, volatile.LoadUint32(&o.C2IER.Reg)&^(0x1)|value)
}
func (o *HSEM_Type) GetC2IER_ISE0() uint32 {
	return volatile.LoadUint32(&o.C2IER.Reg) & 0x1
}
func (o *HSEM_Type) SetC2IER_ISE1(value uint32) {
	volatile.StoreUint32(&o.C2IER.Reg, volatile.LoadUint32(&o.C2IER.Reg)&^(0x2)|value<<1)
}
func (o *HSEM_Type) GetC2IER_ISE1() uint32 {
	return (volatile.LoadUint32(&o.C2IER.Reg) & 0x2) >> 1
}
func (o *HSEM_Type) SetC2IER_ISE2(value uint32) {
	volatile.StoreUint32(&o.C2IER.Reg, volatile.LoadUint32(&o.C2IER.Reg)&^(0x4)|value<<2)
}
func (o *HSEM_Type) GetC2IER_ISE2() uint32 {
	return (volatile.LoadUint32(&o.C2IER.Reg) & 0x4) >> 2
}
func (o *HSEM_Type) SetC2IER_ISE3(value uint32) {
	volatile.StoreUint32(&o.C2IER.Reg, volatile.LoadUint32(&o.C2IER.Reg)&^(0x8)|value<<3)
}
func (o *HSEM_Type) GetC2IER_ISE3() uint32 {
	return (volatile.LoadUint32(&o.C2IER.Reg) & 0x8) >> 3
}
func (o *HSEM_Type) SetC2IER_ISE4(value uint32) {
	volatile.StoreUint32(&o.C2IER.Reg, volatile.LoadUint32(&o.C2IER.Reg)&^(0x10)|value<<4)
}
func (o *HSEM_Type) GetC2IER_ISE4() uint32 {
	return (volatile.LoadUint32(&o.C2IER.Reg) & 0x10) >> 4
}
func (o *HSEM_Type) SetC2IER_ISE5(value uint32) {
	volatile.StoreUint32(&o.C2IER.Reg, volatile.LoadUint32(&o.C2IER.Reg)&^(0x20)|value<<5)
}
func (o *HSEM_Type) GetC2IER_ISE5() uint32 {
	return (volatile.LoadUint32(&o.C2IER.Reg) & 0x20) >> 5
}
func (o *HSEM_Type) SetC2IER_ISE6(value uint32) {
	volatile.StoreUint32(&o.C2IER.Reg, volatile.LoadUint32(&o.C2IER.Reg)&^(0x40)|value<<6)
}
func (o *HSEM_Type) GetC2IER_ISE6() uint32 {
	return (volatile.LoadUint32(&o.C2IER.Reg) & 0x40) >> 6
}
func (o *HSEM_Type) SetC2IER_ISE7(value uint32) {
	volatile.StoreUint32(&o.C2IER.Reg, volatile.LoadUint32(&o.C2IER.Reg)&^(0x80)|value<<7)
}
func (o *HSEM_Type) GetC2IER_ISE7() uint32 {
	return (volatile.LoadUint32(&o.C2IER.Reg) & 0x80) >> 7
}
func (o *HSEM_Type) SetC2IER_ISE8(value uint32) {
	volatile.StoreUint32(&o.C2IER.Reg, volatile.LoadUint32(&o.C2IER.Reg)&^(0x100)|value<<8)
}
func (o *HSEM_Type) GetC2IER_ISE8() uint32 {
	return (volatile.LoadUint32(&o.C2IER.Reg) & 0x100) >> 8
}
func (o *HSEM_Type) SetC2IER_ISE9(value uint32) {
	volatile.StoreUint32(&o.C2IER.Reg, volatile.LoadUint32(&o.C2IER.Reg)&^(0x200)|value<<9)
}
func (o *HSEM_Type) GetC2IER_ISE9() uint32 {
	return (volatile.LoadUint32(&o.C2IER.Reg) & 0x200) >> 9
}
func (o *HSEM_Type) SetC2IER_ISE10(value uint32) {
	volatile.StoreUint32(&o.C2IER.Reg, volatile.LoadUint32(&o.C2IER.Reg)&^(0x400)|value<<10)
}
func (o *HSEM_Type) GetC2IER_ISE10() uint32 {
	return (volatile.LoadUint32(&o.C2IER.Reg) & 0x400) >> 10
}
func (o *HSEM_Type) SetC2IER_ISE11(value uint32) {
	volatile.StoreUint32(&o.C2IER.Reg, volatile.LoadUint32(&o.C2IER.Reg)&^(0x800)|value<<11)
}
func (o *HSEM_Type) GetC2IER_ISE11() uint32 {
	return (volatile.LoadUint32(&o.C2IER.Reg) & 0x800) >> 11
}
func (o *HSEM_Type) SetC2IER_ISE12(value uint32) {
	volatile.StoreUint32(&o.C2IER.Reg, volatile.LoadUint32(&o.C2IER.Reg)&^(0x1000)|value<<12)
}
func (o *HSEM_Type) GetC2IER_ISE12() uint32 {
	return (volatile.LoadUint32(&o.C2IER.Reg) & 0x1000) >> 12
}
func (o *HSEM_Type) SetC2IER_ISE13(value uint32) {
	volatile.StoreUint32(&o.C2IER.Reg, volatile.LoadUint32(&o.C2IER.Reg)&^(0x2000)|value<<13)
}
func (o *HSEM_Type) GetC2IER_ISE13() uint32 {
	return (volatile.LoadUint32(&o.C2IER.Reg) & 0x2000) >> 13
}
func (o *HSEM_Type) SetC2IER_ISE14(value uint32) {
	volatile.StoreUint32(&o.C2IER.Reg, volatile.LoadUint32(&o.C2IER.Reg)&^(0x4000)|value<<14)
}
func (o *HSEM_Type) GetC2IER_ISE14() uint32 {
	return (volatile.LoadUint32(&o.C2IER.Reg) & 0x4000) >> 14
}
func (o *HSEM_Type) SetC2IER_ISE15(value uint32) {
	volatile.StoreUint32(&o.C2IER.Reg, volatile.LoadUint32(&o.C2IER.Reg)&^(0x8000)|value<<15)
}
func (o *HSEM_Type) GetC2IER_ISE15() uint32 {
	return (volatile.LoadUint32(&o.C2IER.Reg) & 0x8000) >> 15
}

// HSEM.C2ICR: HSEM Interrupt clear register
func (o *HSEM_Type) SetC2ICR_ISC0(value uint32) {
	volatile.StoreUint32(&o.C2ICR.Reg, volatile.LoadUint32(&o.C2ICR.Reg)&^(0x1)|value)
}
func (o *HSEM_Type) GetC2ICR_ISC0() uint32 {
	return volatile.LoadUint32(&o.C2ICR.Reg) & 0x1
}
func (o *HSEM_Type) SetC2ICR_ISC1(value uint32) {
	volatile.StoreUint32(&o.C2ICR.Reg, volatile.LoadUint32(&o.C2ICR.Reg)&^(0x2)|value<<1)
}
func (o *HSEM_Type) GetC2ICR_ISC1() uint32 {
	return (volatile.LoadUint32(&o.C2ICR.Reg) & 0x2) >> 1
}
func (o *HSEM_Type) SetC2ICR_ISC2(value uint32) {
	volatile.StoreUint32(&o.C2ICR.Reg, volatile.LoadUint32(&o.C2ICR.Reg)&^(0x4)|value<<2)
}
func (o *HSEM_Type) GetC2ICR_ISC2() uint32 {
	return (volatile.LoadUint32(&o.C2ICR.Reg) & 0x4) >> 2
}
func (o *HSEM_Type) SetC2ICR_ISC3(value uint32) {
	volatile.StoreUint32(&o.C2ICR.Reg, volatile.LoadUint32(&o.C2ICR.Reg)&^(0x8)|value<<3)
}
func (o *HSEM_Type) GetC2ICR_ISC3() uint32 {
	return (volatile.LoadUint32(&o.C2ICR.Reg) & 0x8) >> 3
}
func (o *HSEM_Type) SetC2ICR_ISC4(value uint32) {
	volatile.StoreUint32(&o.C2ICR.Reg, volatile.LoadUint32(&o.C2ICR.Reg)&^(0x10)|value<<4)
}
func (o *HSEM_Type) GetC2ICR_ISC4() uint32 {
	return (volatile.LoadUint32(&o.C2ICR.Reg) & 0x10) >> 4
}
func (o *HSEM_Type) SetC2ICR_ISC5(value uint32) {
	volatile.StoreUint32(&o.C2ICR.Reg, volatile.LoadUint32(&o.C2ICR.Reg)&^(0x20)|value<<5)
}
func (o *HSEM_Type) GetC2ICR_ISC5() uint32 {
	return (volatile.LoadUint32(&o.C2ICR.Reg) & 0x20) >> 5
}
func (o *HSEM_Type) SetC2ICR_ISC6(value uint32) {
	volatile.StoreUint32(&o.C2ICR.Reg, volatile.LoadUint32(&o.C2ICR.Reg)&^(0x40)|value<<6)
}
func (o *HSEM_Type) GetC2ICR_ISC6() uint32 {
	return (volatile.LoadUint32(&o.C2ICR.Reg) & 0x40) >> 6
}
func (o *HSEM_Type) SetC2ICR_ISC7(value uint32) {
	volatile.StoreUint32(&o.C2ICR.Reg, volatile.LoadUint32(&o.C2ICR.Reg)&^(0x80)|value<<7)
}
func (o *HSEM_Type) GetC2ICR_ISC7() uint32 {
	return (volatile.LoadUint32(&o.C2ICR.Reg) & 0x80) >> 7
}
func (o *HSEM_Type) SetC2ICR_ISC8(value uint32) {
	volatile.StoreUint32(&o.C2ICR.Reg, volatile.LoadUint32(&o.C2ICR.Reg)&^(0x100)|value<<8)
}
func (o *HSEM_Type) GetC2ICR_ISC8() uint32 {
	return (volatile.LoadUint32(&o.C2ICR.Reg) & 0x100) >> 8
}
func (o *HSEM_Type) SetC2ICR_ISC9(value uint32) {
	volatile.StoreUint32(&o.C2ICR.Reg, volatile.LoadUint32(&o.C2ICR.Reg)&^(0x200)|value<<9)
}
func (o *HSEM_Type) GetC2ICR_ISC9() uint32 {
	return (volatile.LoadUint32(&o.C2ICR.Reg) & 0x200) >> 9
}
func (o *HSEM_Type) SetC2ICR_ISC10(value uint32) {
	volatile.StoreUint32(&o.C2ICR.Reg, volatile.LoadUint32(&o.C2ICR.Reg)&^(0x400)|value<<10)
}
func (o *HSEM_Type) GetC2ICR_ISC10() uint32 {
	return (volatile.LoadUint32(&o.C2ICR.Reg) & 0x400) >> 10
}
func (o *HSEM_Type) SetC2ICR_ISC11(value uint32) {
	volatile.StoreUint32(&o.C2ICR.Reg, volatile.LoadUint32(&o.C2ICR.Reg)&^(0x800)|value<<11)
}
func (o *HSEM_Type) GetC2ICR_ISC11() uint32 {
	return (volatile.LoadUint32(&o.C2ICR.Reg) & 0x800) >> 11
}
func (o *HSEM_Type) SetC2ICR_ISC12(value uint32) {
	volatile.StoreUint32(&o.C2ICR.Reg, volatile.LoadUint32(&o.C2ICR.Reg)&^(0x1000)|value<<12)
}
func (o *HSEM_Type) GetC2ICR_ISC12() uint32 {
	return (volatile.LoadUint32(&o.C2ICR.Reg) & 0x1000) >> 12
}
func (o *HSEM_Type) SetC2ICR_ISC13(value uint32) {
	volatile.StoreUint32(&o.C2ICR.Reg, volatile.LoadUint32(&o.C2ICR.Reg)&^(0x2000)|value<<13)
}
func (o *HSEM_Type) GetC2ICR_ISC13() uint32 {
	return (volatile.LoadUint32(&o.C2ICR.Reg) & 0x2000) >> 13
}
func (o *HSEM_Type) SetC2ICR_ISC14(value uint32) {
	volatile.StoreUint32(&o.C2ICR.Reg, volatile.LoadUint32(&o.C2ICR.Reg)&^(0x4000)|value<<14)
}
func (o *HSEM_Type) GetC2ICR_ISC14() uint32 {
	return (volatile.LoadUint32(&o.C2ICR.Reg) & 0x4000) >> 14
}
func (o *HSEM_Type) SetC2ICR_ISC15(value uint32) {
	volatile.StoreUint32(&o.C2ICR.Reg, volatile.LoadUint32(&o.C2ICR.Reg)&^(0x8000)|value<<15)
}
func (o *HSEM_Type) GetC2ICR_ISC15() uint32 {
	return (volatile.LoadUint32(&o.C2ICR.Reg) & 0x8000) >> 15
}

// HSEM.C2ISR: HSEM Interrupt status register
func (o *HSEM_Type) SetC2ISR_ISF0(value uint32) {
	volatile.StoreUint32(&o.C2ISR.Reg, volatile.LoadUint32(&o.C2ISR.Reg)&^(0x1)|value)
}
func (o *HSEM_Type) GetC2ISR_ISF0() uint32 {
	return volatile.LoadUint32(&o.C2ISR.Reg) & 0x1
}
func (o *HSEM_Type) SetC2ISR_ISF1(value uint32) {
	volatile.StoreUint32(&o.C2ISR.Reg, volatile.LoadUint32(&o.C2ISR.Reg)&^(0x2)|value<<1)
}
func (o *HSEM_Type) GetC2ISR_ISF1() uint32 {
	return (volatile.LoadUint32(&o.C2ISR.Reg) & 0x2) >> 1
}
func (o *HSEM_Type) SetC2ISR_ISF2(value uint32) {
	volatile.StoreUint32(&o.C2ISR.Reg, volatile.LoadUint32(&o.C2ISR.Reg)&^(0x4)|value<<2)
}
func (o *HSEM_Type) GetC2ISR_ISF2() uint32 {
	return (volatile.LoadUint32(&o.C2ISR.Reg) & 0x4) >> 2
}
func (o *HSEM_Type) SetC2ISR_ISF3(value uint32) {
	volatile.StoreUint32(&o.C2ISR.Reg, volatile.LoadUint32(&o.C2ISR.Reg)&^(0x8)|value<<3)
}
func (o *HSEM_Type) GetC2ISR_ISF3() uint32 {
	return (volatile.LoadUint32(&o.C2ISR.Reg) & 0x8) >> 3
}
func (o *HSEM_Type) SetC2ISR_ISF4(value uint32) {
	volatile.StoreUint32(&o.C2ISR.Reg, volatile.LoadUint32(&o.C2ISR.Reg)&^(0x10)|value<<4)
}
func (o *HSEM_Type) GetC2ISR_ISF4() uint32 {
	return (volatile.LoadUint32(&o.C2ISR.Reg) & 0x10) >> 4
}
func (o *HSEM_Type) SetC2ISR_ISF5(value uint32) {
	volatile.StoreUint32(&o.C2ISR.Reg, volatile.LoadUint32(&o.C2ISR.Reg)&^(0x20)|value<<5)
}
func (o *HSEM_Type) GetC2ISR_ISF5() uint32 {
	return (volatile.LoadUint32(&o.C2ISR.Reg) & 0x20) >> 5
}
func (o *HSEM_Type) SetC2ISR_ISF6(value uint32) {
	volatile.StoreUint32(&o.C2ISR.Reg, volatile.LoadUint32(&o.C2ISR.Reg)&^(0x40)|value<<6)
}
func (o *HSEM_Type) GetC2ISR_ISF6() uint32 {
	return (volatile.LoadUint32(&o.C2ISR.Reg) & 0x40) >> 6
}
func (o *HSEM_Type) SetC2ISR_ISF7(value uint32) {
	volatile.StoreUint32(&o.C2ISR.Reg, volatile.LoadUint32(&o.C2ISR.Reg)&^(0x80)|value<<7)
}
func (o *HSEM_Type) GetC2ISR_ISF7() uint32 {
	return (volatile.LoadUint32(&o.C2ISR.Reg) & 0x80) >> 7
}
func (o *HSEM_Type) SetC2ISR_ISF8(value uint32) {
	volatile.StoreUint32(&o.C2ISR.Reg, volatile.LoadUint32(&o.C2ISR.Reg)&^(0x100)|value<<8)
}
func (o *HSEM_Type) GetC2ISR_ISF8() uint32 {
	return (volatile.LoadUint32(&o.C2ISR.Reg) & 0x100) >> 8
}
func (o *HSEM_Type) SetC2ISR_ISF9(value uint32) {
	volatile.StoreUint32(&o.C2ISR.Reg, volatile.LoadUint32(&o.C2ISR.Reg)&^(0x200)|value<<9)
}
func (o *HSEM_Type) GetC2ISR_ISF9() uint32 {
	return (volatile.LoadUint32(&o.C2ISR.Reg) & 0x200) >> 9
}
func (o *HSEM_Type) SetC2ISR_ISF10(value uint32) {
	volatile.StoreUint32(&o.C2ISR.Reg, volatile.LoadUint32(&o.C2ISR.Reg)&^(0x400)|value<<10)
}
func (o *HSEM_Type) GetC2ISR_ISF10() uint32 {
	return (volatile.LoadUint32(&o.C2ISR.Reg) & 0x400) >> 10
}
func (o *HSEM_Type) SetC2ISR_ISF11(value uint32) {
	volatile.StoreUint32(&o.C2ISR.Reg, volatile.LoadUint32(&o.C2ISR.Reg)&^(0x800)|value<<11)
}
func (o *HSEM_Type) GetC2ISR_ISF11() uint32 {
	return (volatile.LoadUint32(&o.C2ISR.Reg) & 0x800) >> 11
}
func (o *HSEM_Type) SetC2ISR_ISF12(value uint32) {
	volatile.StoreUint32(&o.C2ISR.Reg, volatile.LoadUint32(&o.C2ISR.Reg)&^(0x1000)|value<<12)
}
func (o *HSEM_Type) GetC2ISR_ISF12() uint32 {
	return (volatile.LoadUint32(&o.C2ISR.Reg) & 0x1000) >> 12
}
func (o *HSEM_Type) SetC2ISR_ISF13(value uint32) {
	volatile.StoreUint32(&o.C2ISR.Reg, volatile.LoadUint32(&o.C2ISR.Reg)&^(0x2000)|value<<13)
}
func (o *HSEM_Type) GetC2ISR_ISF13() uint32 {
	return (volatile.LoadUint32(&o.C2ISR.Reg) & 0x2000) >> 13
}
func (o *HSEM_Type) SetC2ISR_ISF14(value uint32) {
	volatile.StoreUint32(&o.C2ISR.Reg, volatile.LoadUint32(&o.C2ISR.Reg)&^(0x4000)|value<<14)
}
func (o *HSEM_Type) GetC2ISR_ISF14() uint32 {
	return (volatile.LoadUint32(&o.C2ISR.Reg) & 0x4000) >> 14
}
func (o *HSEM_Type) SetC2ISR_ISF15(value uint32) {
	volatile.StoreUint32(&o.C2ISR.Reg, volatile.LoadUint32(&o.C2ISR.Reg)&^(0x8000)|value<<15)
}
func (o *HSEM_Type) GetC2ISR_ISF15() uint32 {
	return (volatile.LoadUint32(&o.C2ISR.Reg) & 0x8000) >> 15
}

// HSEM.C2MISR: HSEM Masked interrupt status register
func (o *HSEM_Type) SetC2MISR_MISF0(value uint32) {
	volatile.StoreUint32(&o.C2MISR.Reg, volatile.LoadUint32(&o.C2MISR.Reg)&^(0x1)|value)
}
func (o *HSEM_Type) GetC2MISR_MISF0() uint32 {
	return volatile.LoadUint32(&o.C2MISR.Reg) & 0x1
}
func (o *HSEM_Type) SetC2MISR_MISF1(value uint32) {
	volatile.StoreUint32(&o.C2MISR.Reg, volatile.LoadUint32(&o.C2MISR.Reg)&^(0x2)|value<<1)
}
func (o *HSEM_Type) GetC2MISR_MISF1() uint32 {
	return (volatile.LoadUint32(&o.C2MISR.Reg) & 0x2) >> 1
}
func (o *HSEM_Type) SetC2MISR_MISF2(value uint32) {
	volatile.StoreUint32(&o.C2MISR.Reg, volatile.LoadUint32(&o.C2MISR.Reg)&^(0x4)|value<<2)
}
func (o *HSEM_Type) GetC2MISR_MISF2() uint32 {
	return (volatile.LoadUint32(&o.C2MISR.Reg) & 0x4) >> 2
}
func (o *HSEM_Type) SetC2MISR_MISF3(value uint32) {
	volatile.StoreUint32(&o.C2MISR.Reg, volatile.LoadUint32(&o.C2MISR.Reg)&^(0x8)|value<<3)
}
func (o *HSEM_Type) GetC2MISR_MISF3() uint32 {
	return (volatile.LoadUint32(&o.C2MISR.Reg) & 0x8) >> 3
}
func (o *HSEM_Type) SetC2MISR_MISF4(value uint32) {
	volatile.StoreUint32(&o.C2MISR.Reg, volatile.LoadUint32(&o.C2MISR.Reg)&^(0x10)|value<<4)
}
func (o *HSEM_Type) GetC2MISR_MISF4() uint32 {
	return (volatile.LoadUint32(&o.C2MISR.Reg) & 0x10) >> 4
}
func (o *HSEM_Type) SetC2MISR_MISF5(value uint32) {
	volatile.StoreUint32(&o.C2MISR.Reg, volatile.LoadUint32(&o.C2MISR.Reg)&^(0x20)|value<<5)
}
func (o *HSEM_Type) GetC2MISR_MISF5() uint32 {
	return (volatile.LoadUint32(&o.C2MISR.Reg) & 0x20) >> 5
}
func (o *HSEM_Type) SetC2MISR_MISF6(value uint32) {
	volatile.StoreUint32(&o.C2MISR.Reg, volatile.LoadUint32(&o.C2MISR.Reg)&^(0x40)|value<<6)
}
func (o *HSEM_Type) GetC2MISR_MISF6() uint32 {
	return (volatile.LoadUint32(&o.C2MISR.Reg) & 0x40) >> 6
}
func (o *HSEM_Type) SetC2MISR_MISF7(value uint32) {
	volatile.StoreUint32(&o.C2MISR.Reg, volatile.LoadUint32(&o.C2MISR.Reg)&^(0x80)|value<<7)
}
func (o *HSEM_Type) GetC2MISR_MISF7() uint32 {
	return (volatile.LoadUint32(&o.C2MISR.Reg) & 0x80) >> 7
}
func (o *HSEM_Type) SetC2MISR_MISF8(value uint32) {
	volatile.StoreUint32(&o.C2MISR.Reg, volatile.LoadUint32(&o.C2MISR.Reg)&^(0x100)|value<<8)
}
func (o *HSEM_Type) GetC2MISR_MISF8() uint32 {
	return (volatile.LoadUint32(&o.C2MISR.Reg) & 0x100) >> 8
}
func (o *HSEM_Type) SetC2MISR_MISF9(value uint32) {
	volatile.StoreUint32(&o.C2MISR.Reg, volatile.LoadUint32(&o.C2MISR.Reg)&^(0x200)|value<<9)
}
func (o *HSEM_Type) GetC2MISR_MISF9() uint32 {
	return (volatile.LoadUint32(&o.C2MISR.Reg) & 0x200) >> 9
}
func (o *HSEM_Type) SetC2MISR_MISF10(value uint32) {
	volatile.StoreUint32(&o.C2MISR.Reg, volatile.LoadUint32(&o.C2MISR.Reg)&^(0x400)|value<<10)
}
func (o *HSEM_Type) GetC2MISR_MISF10() uint32 {
	return (volatile.LoadUint32(&o.C2MISR.Reg) & 0x400) >> 10
}
func (o *HSEM_Type) SetC2MISR_MISF11(value uint32) {
	volatile.StoreUint32(&o.C2MISR.Reg, volatile.LoadUint32(&o.C2MISR.Reg)&^(0x800)|value<<11)
}
func (o *HSEM_Type) GetC2MISR_MISF11() uint32 {
	return (volatile.LoadUint32(&o.C2MISR.Reg) & 0x800) >> 11
}
func (o *HSEM_Type) SetC2MISR_MISF12(value uint32) {
	volatile.StoreUint32(&o.C2MISR.Reg, volatile.LoadUint32(&o.C2MISR.Reg)&^(0x1000)|value<<12)
}
func (o *HSEM_Type) GetC2MISR_MISF12() uint32 {
	return (volatile.LoadUint32(&o.C2MISR.Reg) & 0x1000) >> 12
}
func (o *HSEM_Type) SetC2MISR_MISF13(value uint32) {
	volatile.StoreUint32(&o.C2MISR.Reg, volatile.LoadUint32(&o.C2MISR.Reg)&^(0x2000)|value<<13)
}
func (o *HSEM_Type) GetC2MISR_MISF13() uint32 {
	return (volatile.LoadUint32(&o.C2MISR.Reg) & 0x2000) >> 13
}
func (o *HSEM_Type) SetC2MISR_MISF14(value uint32) {
	volatile.StoreUint32(&o.C2MISR.Reg, volatile.LoadUint32(&o.C2MISR.Reg)&^(0x4000)|value<<14)
}
func (o *HSEM_Type) GetC2MISR_MISF14() uint32 {
	return (volatile.LoadUint32(&o.C2MISR.Reg) & 0x4000) >> 14
}
func (o *HSEM_Type) SetC2MISR_MISF15(value uint32) {
	volatile.StoreUint32(&o.C2MISR.Reg, volatile.LoadUint32(&o.C2MISR.Reg)&^(0x8000)|value<<15)
}
func (o *HSEM_Type) GetC2MISR_MISF15() uint32 {
	return (volatile.LoadUint32(&o.C2MISR.Reg) & 0x8000) >> 15
}

// HSEM.CR: HSEM Clear register
func (o *HSEM_Type) SetCR_COREID(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetCR_COREID() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetCR_KEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xffff0000)|value<<16)
}
func (o *HSEM_Type) GetCR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xffff0000) >> 16
}

// HSEM.KEYR: HSEM Interrupt clear register
func (o *HSEM_Type) SetKEYR_KEY(value uint32) {
	volatile.StoreUint32(&o.KEYR.Reg, volatile.LoadUint32(&o.KEYR.Reg)&^(0xffff0000)|value<<16)
}
func (o *HSEM_Type) GetKEYR_KEY() uint32 {
	return (volatile.LoadUint32(&o.KEYR.Reg) & 0xffff0000) >> 16
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// I2C.CR1: Control register 1
func (o *I2C_Type) SetCR1_PE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCR1_PE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *I2C_Type) SetCR1_TXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCR1_TXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCR1_RXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCR1_RXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCR1_ADDRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCR1_ADDRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCR1_NACKIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCR1_NACKIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCR1_STOPIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCR1_STOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCR1_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCR1_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCR1_DNF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xf00)|value<<8)
}
func (o *I2C_Type) GetCR1_DNF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xf00) >> 8
}
func (o *I2C_Type) SetCR1_ANFOFF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR1_ANFOFF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR1_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR1_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR1_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR1_RXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR1_SBC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetCR1_SBC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetCR1_NOSTRETCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetCR1_NOSTRETCH() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *I2C_Type) SetCR1_WUPEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *I2C_Type) GetCR1_WUPEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *I2C_Type) SetCR1_GCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *I2C_Type) GetCR1_GCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *I2C_Type) SetCR1_SMBHEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100000)|value<<20)
}
func (o *I2C_Type) GetCR1_SMBHEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100000) >> 20
}
func (o *I2C_Type) SetCR1_SMBDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *I2C_Type) GetCR1_SMBDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}
func (o *I2C_Type) SetCR1_ALERTEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *I2C_Type) GetCR1_ALERTEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *I2C_Type) SetCR1_PECEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *I2C_Type) GetCR1_PECEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}

// I2C.CR2: Control register 2
func (o *I2C_Type) SetCR2_PECBYTE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000000)|value<<26)
}
func (o *I2C_Type) GetCR2_PECBYTE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000000) >> 26
}
func (o *I2C_Type) SetCR2_AUTOEND(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C_Type) GetCR2_AUTOEND() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000000) >> 25
}
func (o *I2C_Type) SetCR2_RELOAD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C_Type) GetCR2_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000000) >> 24
}
func (o *I2C_Type) SetCR2_NBYTES(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *I2C_Type) GetCR2_NBYTES() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff0000) >> 16
}
func (o *I2C_Type) SetCR2_NACK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR2_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR2_START(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetCR2_START() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetCR2_HEAD10R(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR2_HEAD10R() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR2_ADD10(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCR2_ADD10() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCR2_RD_WRN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCR2_RD_WRN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCR2_SADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetCR2_SADD() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x3ff
}

// I2C.OAR1: Own address register 1
func (o *I2C_Type) SetOAR1_OA1(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetOAR1_OA1() uint32 {
	return volatile.LoadUint32(&o.OAR1.Reg) & 0x3ff
}
func (o *I2C_Type) SetOAR1_OA1MODE(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetOAR1_OA1MODE() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetOAR1_OA1EN(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR1_OA1EN() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x8000) >> 15
}

// I2C.OAR2: Own address register 2
func (o *I2C_Type) SetOAR2_OA2(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetOAR2_OA2() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetOAR2_OA2MSK(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x700)|value<<8)
}
func (o *I2C_Type) GetOAR2_OA2MSK() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x700) >> 8
}
func (o *I2C_Type) SetOAR2_OA2EN(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR2_OA2EN() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x8000) >> 15
}

// I2C.TIMINGR: Timing register
func (o *I2C_Type) SetTIMINGR_SCLL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTIMINGR_SCLL() uint32 {
	return volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff
}
func (o *I2C_Type) SetTIMINGR_SCLH(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff00)|value<<8)
}
func (o *I2C_Type) GetTIMINGR_SCLH() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff00) >> 8
}
func (o *I2C_Type) SetTIMINGR_SDADEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000)|value<<16)
}
func (o *I2C_Type) GetTIMINGR_SDADEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000) >> 16
}
func (o *I2C_Type) SetTIMINGR_SCLDEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C_Type) GetTIMINGR_SCLDEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf00000) >> 20
}
func (o *I2C_Type) SetTIMINGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000000)|value<<28)
}
func (o *I2C_Type) GetTIMINGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000000) >> 28
}

// I2C.TIMEOUTR: Status register 1
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTA(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff)|value)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTA() uint32 {
	return volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff
}
func (o *I2C_Type) SetTIMEOUTR_TIDLE(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetTIMEOUTR_TIDLE() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetTIMEOUTR_TIMOUTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetTIMEOUTR_TIMOUTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTB(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff0000)|value<<16)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTB() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff0000) >> 16
}
func (o *I2C_Type) SetTIMEOUTR_TEXTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetTIMEOUTR_TEXTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x80000000) >> 31
}

// I2C.ISR: Interrupt and Status register
func (o *I2C_Type) SetISR_ADDCODE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xfe0000)|value<<17)
}
func (o *I2C_Type) GetISR_ADDCODE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xfe0000) >> 17
}
func (o *I2C_Type) SetISR_DIR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetISR_ALERT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetISR_ALERT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetISR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetISR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetISR_PECERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetISR_PECERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetISR_ARLO(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetISR_ARLO() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetISR_BERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetISR_BERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetISR_TCR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetISR_TCR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetISR_STOPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetISR_STOPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetISR_NACKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetISR_NACKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetISR_ADDR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetISR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetISR_TXIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetISR_TXIS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetISR_TXE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// I2C.ICR: Interrupt clear register
func (o *I2C_Type) SetICR_ALERTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetICR_ALERTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetICR_TIMOUTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetICR_TIMOUTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetICR_PECCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetICR_PECCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetICR_OVRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetICR_OVRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetICR_ARLOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetICR_ARLOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetICR_BERRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetICR_BERRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetICR_STOPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetICR_STOPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetICR_NACKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetICR_NACKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetICR_ADDRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetICR_ADDRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}

// I2C.PECR: PEC register
func (o *I2C_Type) SetPECR_PEC(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetPECR_PEC() uint32 {
	return volatile.LoadUint32(&o.PECR.Reg) & 0xff
}

// I2C.RXDR: Receive data register
func (o *I2C_Type) SetRXDR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, volatile.LoadUint32(&o.RXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetRXDR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg) & 0xff
}

// I2C.TXDR: Transmit data register
func (o *I2C_Type) SetTXDR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, volatile.LoadUint32(&o.TXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTXDR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg) & 0xff
}

// Inter Processor communication controller
type IPCC_Type struct {
	C1CR     volatile.Register32 // 0x0
	C1MR     volatile.Register32 // 0x4
	C1SCR    volatile.Register32 // 0x8
	C1TOC2SR volatile.Register32 // 0xC
	C2CR     volatile.Register32 // 0x10
	C2MR     volatile.Register32 // 0x14
	C2SCR    volatile.Register32 // 0x18
	C2TOC1SR volatile.Register32 // 0x1C
	_        [976]byte
	HWCFGR   volatile.Register32 // 0x3F0
	VERR     volatile.Register32 // 0x3F4
	IPIDR    volatile.Register32 // 0x3F8
	SIDR     volatile.Register32 // 0x3FC
}

// IPCC.C1CR: IPCC Processor 1 control register
func (o *IPCC_Type) SetC1CR_RXOIE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x1)|value)
}
func (o *IPCC_Type) GetC1CR_RXOIE() uint32 {
	return volatile.LoadUint32(&o.C1CR.Reg) & 0x1
}
func (o *IPCC_Type) SetC1CR_TXFIE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x10000)|value<<16)
}
func (o *IPCC_Type) GetC1CR_TXFIE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x10000) >> 16
}

// IPCC.C1MR: IPCC Processor 1 mask register
func (o *IPCC_Type) SetC1MR_CH1OM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x1)|value)
}
func (o *IPCC_Type) GetC1MR_CH1OM() uint32 {
	return volatile.LoadUint32(&o.C1MR.Reg) & 0x1
}
func (o *IPCC_Type) SetC1MR_CH2OM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x2)|value<<1)
}
func (o *IPCC_Type) GetC1MR_CH2OM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x2) >> 1
}
func (o *IPCC_Type) SetC1MR_CH3OM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x4)|value<<2)
}
func (o *IPCC_Type) GetC1MR_CH3OM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x4) >> 2
}
func (o *IPCC_Type) SetC1MR_CH4OM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x8)|value<<3)
}
func (o *IPCC_Type) GetC1MR_CH4OM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x8) >> 3
}
func (o *IPCC_Type) SetC1MR_CH5OM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x10)|value<<4)
}
func (o *IPCC_Type) GetC1MR_CH5OM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x10) >> 4
}
func (o *IPCC_Type) SetC1MR_CH6OM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x20)|value<<5)
}
func (o *IPCC_Type) GetC1MR_CH6OM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x20) >> 5
}
func (o *IPCC_Type) SetC1MR_CH1FM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x10000)|value<<16)
}
func (o *IPCC_Type) GetC1MR_CH1FM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x10000) >> 16
}
func (o *IPCC_Type) SetC1MR_CH2FM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x20000)|value<<17)
}
func (o *IPCC_Type) GetC1MR_CH2FM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x20000) >> 17
}
func (o *IPCC_Type) SetC1MR_CH3FM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x40000)|value<<18)
}
func (o *IPCC_Type) GetC1MR_CH3FM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x40000) >> 18
}
func (o *IPCC_Type) SetC1MR_CH4FM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x80000)|value<<19)
}
func (o *IPCC_Type) GetC1MR_CH4FM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x80000) >> 19
}
func (o *IPCC_Type) SetC1MR_CH5FM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x100000)|value<<20)
}
func (o *IPCC_Type) GetC1MR_CH5FM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x100000) >> 20
}
func (o *IPCC_Type) SetC1MR_CH6FM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x200000)|value<<21)
}
func (o *IPCC_Type) GetC1MR_CH6FM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x200000) >> 21
}

// IPCC.C1SCR: Reading this register will always return 0x0000 0000.
func (o *IPCC_Type) SetC1SCR_CH1C(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x1)|value)
}
func (o *IPCC_Type) GetC1SCR_CH1C() uint32 {
	return volatile.LoadUint32(&o.C1SCR.Reg) & 0x1
}
func (o *IPCC_Type) SetC1SCR_CH2C(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x2)|value<<1)
}
func (o *IPCC_Type) GetC1SCR_CH2C() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x2) >> 1
}
func (o *IPCC_Type) SetC1SCR_CH3C(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x4)|value<<2)
}
func (o *IPCC_Type) GetC1SCR_CH3C() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x4) >> 2
}
func (o *IPCC_Type) SetC1SCR_CH4C(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x8)|value<<3)
}
func (o *IPCC_Type) GetC1SCR_CH4C() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x8) >> 3
}
func (o *IPCC_Type) SetC1SCR_CH5C(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x10)|value<<4)
}
func (o *IPCC_Type) GetC1SCR_CH5C() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x10) >> 4
}
func (o *IPCC_Type) SetC1SCR_CH6C(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x20)|value<<5)
}
func (o *IPCC_Type) GetC1SCR_CH6C() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x20) >> 5
}
func (o *IPCC_Type) SetC1SCR_CH1S(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x10000)|value<<16)
}
func (o *IPCC_Type) GetC1SCR_CH1S() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x10000) >> 16
}
func (o *IPCC_Type) SetC1SCR_CH2S(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x20000)|value<<17)
}
func (o *IPCC_Type) GetC1SCR_CH2S() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x20000) >> 17
}
func (o *IPCC_Type) SetC1SCR_CH3S(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x40000)|value<<18)
}
func (o *IPCC_Type) GetC1SCR_CH3S() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x40000) >> 18
}
func (o *IPCC_Type) SetC1SCR_CH4S(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x80000)|value<<19)
}
func (o *IPCC_Type) GetC1SCR_CH4S() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x80000) >> 19
}
func (o *IPCC_Type) SetC1SCR_CH5S(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x100000)|value<<20)
}
func (o *IPCC_Type) GetC1SCR_CH5S() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x100000) >> 20
}
func (o *IPCC_Type) SetC1SCR_CH6S(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x200000)|value<<21)
}
func (o *IPCC_Type) GetC1SCR_CH6S() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x200000) >> 21
}

// IPCC.C1TOC2SR: IPCC processor 1 to processor 2 status register
func (o *IPCC_Type) SetC1TOC2SR_CH1F(value uint32) {
	volatile.StoreUint32(&o.C1TOC2SR.Reg, volatile.LoadUint32(&o.C1TOC2SR.Reg)&^(0x1)|value)
}
func (o *IPCC_Type) GetC1TOC2SR_CH1F() uint32 {
	return volatile.LoadUint32(&o.C1TOC2SR.Reg) & 0x1
}
func (o *IPCC_Type) SetC1TOC2SR_CH2F(value uint32) {
	volatile.StoreUint32(&o.C1TOC2SR.Reg, volatile.LoadUint32(&o.C1TOC2SR.Reg)&^(0x2)|value<<1)
}
func (o *IPCC_Type) GetC1TOC2SR_CH2F() uint32 {
	return (volatile.LoadUint32(&o.C1TOC2SR.Reg) & 0x2) >> 1
}
func (o *IPCC_Type) SetC1TOC2SR_CH3F(value uint32) {
	volatile.StoreUint32(&o.C1TOC2SR.Reg, volatile.LoadUint32(&o.C1TOC2SR.Reg)&^(0x4)|value<<2)
}
func (o *IPCC_Type) GetC1TOC2SR_CH3F() uint32 {
	return (volatile.LoadUint32(&o.C1TOC2SR.Reg) & 0x4) >> 2
}
func (o *IPCC_Type) SetC1TOC2SR_CH4F(value uint32) {
	volatile.StoreUint32(&o.C1TOC2SR.Reg, volatile.LoadUint32(&o.C1TOC2SR.Reg)&^(0x8)|value<<3)
}
func (o *IPCC_Type) GetC1TOC2SR_CH4F() uint32 {
	return (volatile.LoadUint32(&o.C1TOC2SR.Reg) & 0x8) >> 3
}
func (o *IPCC_Type) SetC1TOC2SR_CH5F(value uint32) {
	volatile.StoreUint32(&o.C1TOC2SR.Reg, volatile.LoadUint32(&o.C1TOC2SR.Reg)&^(0x10)|value<<4)
}
func (o *IPCC_Type) GetC1TOC2SR_CH5F() uint32 {
	return (volatile.LoadUint32(&o.C1TOC2SR.Reg) & 0x10) >> 4
}
func (o *IPCC_Type) SetC1TOC2SR_CH6F(value uint32) {
	volatile.StoreUint32(&o.C1TOC2SR.Reg, volatile.LoadUint32(&o.C1TOC2SR.Reg)&^(0x20)|value<<5)
}
func (o *IPCC_Type) GetC1TOC2SR_CH6F() uint32 {
	return (volatile.LoadUint32(&o.C1TOC2SR.Reg) & 0x20) >> 5
}

// IPCC.C2CR: IPCC Processor 2 control register
func (o *IPCC_Type) SetC2CR_RXOIE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x1)|value)
}
func (o *IPCC_Type) GetC2CR_RXOIE() uint32 {
	return volatile.LoadUint32(&o.C2CR.Reg) & 0x1
}
func (o *IPCC_Type) SetC2CR_TXFIE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x10000)|value<<16)
}
func (o *IPCC_Type) GetC2CR_TXFIE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x10000) >> 16
}

// IPCC.C2MR: IPCC Processor 2 mask register
func (o *IPCC_Type) SetC2MR_CH1OM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x1)|value)
}
func (o *IPCC_Type) GetC2MR_CH1OM() uint32 {
	return volatile.LoadUint32(&o.C2MR.Reg) & 0x1
}
func (o *IPCC_Type) SetC2MR_CH2OM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x2)|value<<1)
}
func (o *IPCC_Type) GetC2MR_CH2OM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x2) >> 1
}
func (o *IPCC_Type) SetC2MR_CH3OM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x4)|value<<2)
}
func (o *IPCC_Type) GetC2MR_CH3OM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x4) >> 2
}
func (o *IPCC_Type) SetC2MR_CH4OM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x8)|value<<3)
}
func (o *IPCC_Type) GetC2MR_CH4OM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x8) >> 3
}
func (o *IPCC_Type) SetC2MR_CH5OM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x10)|value<<4)
}
func (o *IPCC_Type) GetC2MR_CH5OM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x10) >> 4
}
func (o *IPCC_Type) SetC2MR_CH6OM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x20)|value<<5)
}
func (o *IPCC_Type) GetC2MR_CH6OM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x20) >> 5
}
func (o *IPCC_Type) SetC2MR_CH1FM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x10000)|value<<16)
}
func (o *IPCC_Type) GetC2MR_CH1FM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x10000) >> 16
}
func (o *IPCC_Type) SetC2MR_CH2FM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x20000)|value<<17)
}
func (o *IPCC_Type) GetC2MR_CH2FM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x20000) >> 17
}
func (o *IPCC_Type) SetC2MR_CH3FM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x40000)|value<<18)
}
func (o *IPCC_Type) GetC2MR_CH3FM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x40000) >> 18
}
func (o *IPCC_Type) SetC2MR_CH4FM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x80000)|value<<19)
}
func (o *IPCC_Type) GetC2MR_CH4FM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x80000) >> 19
}
func (o *IPCC_Type) SetC2MR_CH5FM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x100000)|value<<20)
}
func (o *IPCC_Type) GetC2MR_CH5FM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x100000) >> 20
}
func (o *IPCC_Type) SetC2MR_CH6FM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x200000)|value<<21)
}
func (o *IPCC_Type) GetC2MR_CH6FM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x200000) >> 21
}

// IPCC.C2SCR: Reading this register will always return 0x0000 0000.
func (o *IPCC_Type) SetC2SCR_CH1C(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x1)|value)
}
func (o *IPCC_Type) GetC2SCR_CH1C() uint32 {
	return volatile.LoadUint32(&o.C2SCR.Reg) & 0x1
}
func (o *IPCC_Type) SetC2SCR_CH2C(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x2)|value<<1)
}
func (o *IPCC_Type) GetC2SCR_CH2C() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x2) >> 1
}
func (o *IPCC_Type) SetC2SCR_CH3C(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x4)|value<<2)
}
func (o *IPCC_Type) GetC2SCR_CH3C() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x4) >> 2
}
func (o *IPCC_Type) SetC2SCR_CH4C(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x8)|value<<3)
}
func (o *IPCC_Type) GetC2SCR_CH4C() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x8) >> 3
}
func (o *IPCC_Type) SetC2SCR_CH5C(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x10)|value<<4)
}
func (o *IPCC_Type) GetC2SCR_CH5C() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x10) >> 4
}
func (o *IPCC_Type) SetC2SCR_CH6C(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x20)|value<<5)
}
func (o *IPCC_Type) GetC2SCR_CH6C() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x20) >> 5
}
func (o *IPCC_Type) SetC2SCR_CH1S(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x10000)|value<<16)
}
func (o *IPCC_Type) GetC2SCR_CH1S() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x10000) >> 16
}
func (o *IPCC_Type) SetC2SCR_CH2S(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x20000)|value<<17)
}
func (o *IPCC_Type) GetC2SCR_CH2S() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x20000) >> 17
}
func (o *IPCC_Type) SetC2SCR_CH3S(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x40000)|value<<18)
}
func (o *IPCC_Type) GetC2SCR_CH3S() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x40000) >> 18
}
func (o *IPCC_Type) SetC2SCR_CH4S(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x80000)|value<<19)
}
func (o *IPCC_Type) GetC2SCR_CH4S() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x80000) >> 19
}
func (o *IPCC_Type) SetC2SCR_CH5S(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x100000)|value<<20)
}
func (o *IPCC_Type) GetC2SCR_CH5S() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x100000) >> 20
}
func (o *IPCC_Type) SetC2SCR_CH6S(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x200000)|value<<21)
}
func (o *IPCC_Type) GetC2SCR_CH6S() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x200000) >> 21
}

// IPCC.C2TOC1SR: IPCC processor 2 to processor 1 status register
func (o *IPCC_Type) SetC2TOC1SR_CH1F(value uint32) {
	volatile.StoreUint32(&o.C2TOC1SR.Reg, volatile.LoadUint32(&o.C2TOC1SR.Reg)&^(0x1)|value)
}
func (o *IPCC_Type) GetC2TOC1SR_CH1F() uint32 {
	return volatile.LoadUint32(&o.C2TOC1SR.Reg) & 0x1
}
func (o *IPCC_Type) SetC2TOC1SR_CH2F(value uint32) {
	volatile.StoreUint32(&o.C2TOC1SR.Reg, volatile.LoadUint32(&o.C2TOC1SR.Reg)&^(0x2)|value<<1)
}
func (o *IPCC_Type) GetC2TOC1SR_CH2F() uint32 {
	return (volatile.LoadUint32(&o.C2TOC1SR.Reg) & 0x2) >> 1
}
func (o *IPCC_Type) SetC2TOC1SR_CH3F(value uint32) {
	volatile.StoreUint32(&o.C2TOC1SR.Reg, volatile.LoadUint32(&o.C2TOC1SR.Reg)&^(0x4)|value<<2)
}
func (o *IPCC_Type) GetC2TOC1SR_CH3F() uint32 {
	return (volatile.LoadUint32(&o.C2TOC1SR.Reg) & 0x4) >> 2
}
func (o *IPCC_Type) SetC2TOC1SR_CH4F(value uint32) {
	volatile.StoreUint32(&o.C2TOC1SR.Reg, volatile.LoadUint32(&o.C2TOC1SR.Reg)&^(0x8)|value<<3)
}
func (o *IPCC_Type) GetC2TOC1SR_CH4F() uint32 {
	return (volatile.LoadUint32(&o.C2TOC1SR.Reg) & 0x8) >> 3
}
func (o *IPCC_Type) SetC2TOC1SR_CH5F(value uint32) {
	volatile.StoreUint32(&o.C2TOC1SR.Reg, volatile.LoadUint32(&o.C2TOC1SR.Reg)&^(0x10)|value<<4)
}
func (o *IPCC_Type) GetC2TOC1SR_CH5F() uint32 {
	return (volatile.LoadUint32(&o.C2TOC1SR.Reg) & 0x10) >> 4
}
func (o *IPCC_Type) SetC2TOC1SR_CH6F(value uint32) {
	volatile.StoreUint32(&o.C2TOC1SR.Reg, volatile.LoadUint32(&o.C2TOC1SR.Reg)&^(0x20)|value<<5)
}
func (o *IPCC_Type) GetC2TOC1SR_CH6F() uint32 {
	return (volatile.LoadUint32(&o.C2TOC1SR.Reg) & 0x20) >> 5
}

// IPCC.HWCFGR: IPCC Hardware configuration register
func (o *IPCC_Type) SetHWCFGR_CHANNELS(value uint32) {
	volatile.StoreUint32(&o.HWCFGR.Reg, volatile.LoadUint32(&o.HWCFGR.Reg)&^(0xff)|value)
}
func (o *IPCC_Type) GetHWCFGR_CHANNELS() uint32 {
	return volatile.LoadUint32(&o.HWCFGR.Reg) & 0xff
}

// IPCC.VERR: IPCC IP Version register
func (o *IPCC_Type) SetVERR_MINREV(value uint32) {
	volatile.StoreUint32(&o.VERR.Reg, volatile.LoadUint32(&o.VERR.Reg)&^(0xf)|value)
}
func (o *IPCC_Type) GetVERR_MINREV() uint32 {
	return volatile.LoadUint32(&o.VERR.Reg) & 0xf
}
func (o *IPCC_Type) SetVERR_MAJREV(value uint32) {
	volatile.StoreUint32(&o.VERR.Reg, volatile.LoadUint32(&o.VERR.Reg)&^(0xf0)|value<<4)
}
func (o *IPCC_Type) GetVERR_MAJREV() uint32 {
	return (volatile.LoadUint32(&o.VERR.Reg) & 0xf0) >> 4
}

// IPCC.IPIDR: IPCC IP Identification register
func (o *IPCC_Type) SetIPIDR(value uint32) {
	volatile.StoreUint32(&o.IPIDR.Reg, value)
}
func (o *IPCC_Type) GetIPIDR() uint32 {
	return volatile.LoadUint32(&o.IPIDR.Reg)
}

// IPCC.SIDR: IPCC Size ID register
func (o *IPCC_Type) SetSIDR(value uint32) {
	volatile.StoreUint32(&o.SIDR.Reg, value)
}
func (o *IPCC_Type) GetSIDR() uint32 {
	return volatile.LoadUint32(&o.SIDR.Reg)
}

// Independent watchdog
type IWDG_Type struct {
	KR  volatile.Register32 // 0x0
	PR  volatile.Register32 // 0x4
	RLR volatile.Register32 // 0x8
	SR  volatile.Register32 // 0xC
}

// IWDG.KR: Key register
func (o *IWDG_Type) SetKR_KEY(value uint32) {
	volatile.StoreUint32(&o.KR.Reg, volatile.LoadUint32(&o.KR.Reg)&^(0xffff)|value)
}
func (o *IWDG_Type) GetKR_KEY() uint32 {
	return volatile.LoadUint32(&o.KR.Reg) & 0xffff
}

// IWDG.PR: Prescaler register
func (o *IWDG_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x7)|value)
}
func (o *IWDG_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x7
}

// IWDG.RLR: Reload register
func (o *IWDG_Type) SetRLR_RL(value uint32) {
	volatile.StoreUint32(&o.RLR.Reg, volatile.LoadUint32(&o.RLR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetRLR_RL() uint32 {
	return volatile.LoadUint32(&o.RLR.Reg) & 0xfff
}

// IWDG.SR: Status register
func (o *IWDG_Type) SetSR_WVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *IWDG_Type) GetSR_WVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *IWDG_Type) SetSR_RVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *IWDG_Type) GetSR_RVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *IWDG_Type) SetSR_PVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *IWDG_Type) GetSR_PVU() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// Low-power timer
type LPTIM_Type struct {
	ISR  volatile.Register32 // 0x0
	ICR  volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	CFGR volatile.Register32 // 0xC
	CR   volatile.Register32 // 0x10
	CMP  volatile.Register32 // 0x14
	ARR  volatile.Register32 // 0x18
	CNT  volatile.Register32 // 0x1C
	OR   volatile.Register32 // 0x20
	_    [4]byte
	RCR  volatile.Register32 // 0x28
}

// LPTIM.ISR: interrupt and status register
func (o *LPTIM_Type) SetISR_REPOK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *LPTIM_Type) GetISR_REPOK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *LPTIM_Type) SetISR_UE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *LPTIM_Type) GetISR_UE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *LPTIM_Type) SetISR_DOWN(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetISR_DOWN() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetISR_UP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetISR_UP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetISR_ARROK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetISR_ARROK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetISR_CMPOK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetISR_CMPOK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetISR_EXTTRIG(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetISR_EXTTRIG() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetISR_ARRM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetISR_ARRM() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetISR_CMPM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetISR_CMPM() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// LPTIM.ICR: interrupt clear register
func (o *LPTIM_Type) SetICR_REPOKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *LPTIM_Type) GetICR_REPOKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *LPTIM_Type) SetICR_UECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80)|value<<7)
}
func (o *LPTIM_Type) GetICR_UECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80) >> 7
}
func (o *LPTIM_Type) SetICR_DOWNCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetICR_DOWNCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetICR_UPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetICR_UPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetICR_ARROKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetICR_ARROKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetICR_CMPOKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetICR_CMPOKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetICR_EXTTRIGCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetICR_EXTTRIGCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetICR_ARRMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetICR_ARRMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetICR_CMPMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetICR_CMPMCF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// LPTIM.IER: interrupt enable register
func (o *LPTIM_Type) SetIER_REPOKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *LPTIM_Type) GetIER_REPOKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *LPTIM_Type) SetIER_UEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *LPTIM_Type) GetIER_UEIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *LPTIM_Type) SetIER_DOWNIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetIER_DOWNIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetIER_UPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetIER_UPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetIER_ARROKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetIER_ARROKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetIER_CMPOKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetIER_CMPOKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetIER_EXTTRIGIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetIER_EXTTRIGIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetIER_ARRMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetIER_ARRMIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetIER_CMPMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetIER_CMPMIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// LPTIM.CFGR: configuration register
func (o *LPTIM_Type) SetCFGR_ENC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *LPTIM_Type) GetCFGR_ENC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000000) >> 24
}
func (o *LPTIM_Type) SetCFGR_COUNTMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *LPTIM_Type) GetCFGR_COUNTMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *LPTIM_Type) SetCFGR_PRELOAD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x400000)|value<<22)
}
func (o *LPTIM_Type) GetCFGR_PRELOAD() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x400000) >> 22
}
func (o *LPTIM_Type) SetCFGR_WAVPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x200000)|value<<21)
}
func (o *LPTIM_Type) GetCFGR_WAVPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x200000) >> 21
}
func (o *LPTIM_Type) SetCFGR_WAVE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100000)|value<<20)
}
func (o *LPTIM_Type) GetCFGR_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100000) >> 20
}
func (o *LPTIM_Type) SetCFGR_TIMOUT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000)|value<<19)
}
func (o *LPTIM_Type) GetCFGR_TIMOUT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000) >> 19
}
func (o *LPTIM_Type) SetCFGR_TRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x60000)|value<<17)
}
func (o *LPTIM_Type) GetCFGR_TRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x60000) >> 17
}
func (o *LPTIM_Type) SetCFGR_TRIGSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe000)|value<<13)
}
func (o *LPTIM_Type) GetCFGR_TRIGSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe000) >> 13
}
func (o *LPTIM_Type) SetCFGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe00)|value<<9)
}
func (o *LPTIM_Type) GetCFGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe00) >> 9
}
func (o *LPTIM_Type) SetCFGR_TRGFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc0)|value<<6)
}
func (o *LPTIM_Type) GetCFGR_TRGFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc0) >> 6
}
func (o *LPTIM_Type) SetCFGR_CKFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x18)|value<<3)
}
func (o *LPTIM_Type) GetCFGR_CKFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x18) >> 3
}
func (o *LPTIM_Type) SetCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x6)|value<<1)
}
func (o *LPTIM_Type) GetCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x6) >> 1
}
func (o *LPTIM_Type) SetCFGR_CKSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCFGR_CKSEL() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x1
}

// LPTIM.CR: control register
func (o *LPTIM_Type) SetCR_RSTARE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetCR_RSTARE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetCR_COUNTRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetCR_COUNTRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetCR_CNTSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetCR_CNTSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetCR_SNGSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetCR_SNGSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// LPTIM.CMP: compare register
func (o *LPTIM_Type) SetCMP(value uint32) {
	volatile.StoreUint32(&o.CMP.Reg, volatile.LoadUint32(&o.CMP.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCMP() uint32 {
	return volatile.LoadUint32(&o.CMP.Reg) & 0xffff
}

// LPTIM.ARR: autoreload register
func (o *LPTIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// LPTIM.CNT: counter register
func (o *LPTIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// LPTIM.OR: option register
func (o *LPTIM_Type) SetOR_OR_1(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetOR_OR_1() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetOR_OR_0(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetOR_OR_0() uint32 {
	return volatile.LoadUint32(&o.OR.Reg) & 0x1
}

// LPTIM.RCR: repetition register
func (o *LPTIM_Type) SetRCR_REP(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xff)|value)
}
func (o *LPTIM_Type) GetRCR_REP() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xff
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	CR3   volatile.Register32 // 0x8
	BRR   volatile.Register32 // 0xC
	_     [8]byte
	RQR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	ICR   volatile.Register32 // 0x20
	RDR   volatile.Register32 // 0x24
	TDR   volatile.Register32 // 0x28
	PRESC volatile.Register32 // 0x2C
}

// USART.CR1: Control register 1
func (o *USART_Type) SetCR1_RXFFIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000000)|value<<31)
}
func (o *USART_Type) GetCR1_RXFFIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000000) >> 31
}
func (o *USART_Type) SetCR1_TXFEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetCR1_TXFEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000000) >> 30
}
func (o *USART_Type) SetCR1_FIFOEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetCR1_FIFOEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetCR1_M1(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetCR1_M1() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetCR1_DEAT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3e00000)|value<<21)
}
func (o *USART_Type) GetCR1_DEAT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x3e00000) >> 21
}
func (o *USART_Type) SetCR1_DEDT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1f0000)|value<<16)
}
func (o *USART_Type) GetCR1_DEDT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1f0000) >> 16
}
func (o *USART_Type) SetCR1_CMIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR1_CMIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR1_MME(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR1_MME() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR1_M0(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR1_M0() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR1_WAKE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR1_WAKE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR1_PCE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR1_PCE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR1_PS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR1_PS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR1_PEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR1_PEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR1_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR1_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR1_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR1_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR1_IDLEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR1_IDLEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR1_TE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR1_TE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR1_RE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR1_RE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR1_UESM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR1_UESM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR1_UE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR1_UE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// USART.CR2: Control register 2
func (o *USART_Type) SetCR2_ADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff000000)|value<<24)
}
func (o *USART_Type) GetCR2_ADD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff000000) >> 24
}
func (o *USART_Type) SetCR2_MSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR2_MSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCR2_DATAINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR2_DATAINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR2_TXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetCR2_TXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetCR2_RXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetCR2_RXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetCR2_SWAP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR2_SWAP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetCR2_ADDM7(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR2_ADDM7() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}

// USART.CR3: Control register 3
func (o *USART_Type) SetCR3_TXFTCFG(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe0000000)|value<<29)
}
func (o *USART_Type) GetCR3_TXFTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe0000000) >> 29
}
func (o *USART_Type) SetCR3_RXFTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetCR3_RXFTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetCR3_RXFTCFG(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe000000)|value<<25)
}
func (o *USART_Type) GetCR3_RXFTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe000000) >> 25
}
func (o *USART_Type) SetCR3_TXFTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCR3_TXFTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCR3_WUFIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetCR3_WUFIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetCR3_WUS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x300000)|value<<20)
}
func (o *USART_Type) GetCR3_WUS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x300000) >> 20
}
func (o *USART_Type) SetCR3_DEP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR3_DEP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR3_DEM(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR3_DEM() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR3_DDRE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR3_DDRE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR3_OVRDIS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR3_OVRDIS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR3_CTSIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR3_CTSIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR3_CTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR3_CTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR3_RTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR3_RTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR3_DMAT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR3_DMAT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR3_DMAR(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR3_DMAR() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR3_HDSEL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR3_HDSEL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR3_EIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR3_EIE() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}

// USART.BRR: Baud rate register
func (o *USART_Type) SetBRR(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xfffff)|value)
}
func (o *USART_Type) GetBRR() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0xfffff
}

// USART.RQR: Request register
func (o *USART_Type) SetRQR_TXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetRQR_TXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetRQR_RXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetRQR_RXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetRQR_MMRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetRQR_MMRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetRQR_SBKRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetRQR_SBKRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x2) >> 1
}

// USART.ISR: Interrupt and status register
func (o *USART_Type) SetISR_TXFT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *USART_Type) GetISR_TXFT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *USART_Type) SetISR_RXFT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *USART_Type) GetISR_RXFT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *USART_Type) SetISR_RXFF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetISR_RXFF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *USART_Type) SetISR_TXFE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetISR_TXFE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetISR_REACK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetISR_REACK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetISR_TEACK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetISR_TEACK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetISR_WUF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetISR_WUF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetISR_RWU(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetISR_RWU() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetISR_SBKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetISR_SBKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetISR_CMF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetISR_CMF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetISR_CTS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetISR_CTS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetISR_CTSIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetISR_CTSIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetISR_TXFNF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetISR_TXFNF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetISR_RXFNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetISR_RXFNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetISR_IDLE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetISR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetISR_ORE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetISR_ORE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetISR_NE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetISR_NE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetISR_FE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetISR_FE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetISR_PE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetISR_PE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// USART.ICR: Interrupt flag clear register
func (o *USART_Type) SetICR_WUCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetICR_WUCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetICR_CMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetICR_CMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetICR_CTSCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetICR_CTSCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetICR_TCCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetICR_TCCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetICR_IDLECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetICR_IDLECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetICR_ORECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetICR_ORECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetICR_NCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetICR_NCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetICR_FECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetICR_FECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetICR_PECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetICR_PECF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// USART.RDR: Receive data register
func (o *USART_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0x1ff
}

// USART.TDR: Transmit data register
func (o *USART_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0x1ff
}

// USART.PRESC: Prescaler register
func (o *USART_Type) SetPRESC_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESC.Reg, volatile.LoadUint32(&o.PRESC.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetPRESC_PRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESC.Reg) & 0xf
}

// Memory protection unit
type MPU_Type struct {
	TYPER volatile.Register32 // 0x0
	CTRL  volatile.Register32 // 0x4
	RNR   volatile.Register32 // 0x8
	RBAR  volatile.Register32 // 0xC
	RASR  volatile.Register32 // 0x10
}

// MPU.TYPER: MPU type register
func (o *MPU_Type) SetTYPER_SEPARATE(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetTYPER_SEPARATE() uint32 {
	return volatile.LoadUint32(&o.TYPER.Reg) & 0x1
}
func (o *MPU_Type) SetTYPER_DREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetTYPER_DREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetTYPER_IREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff0000)|value<<16)
}
func (o *MPU_Type) GetTYPER_IREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff0000) >> 16
}

// MPU.CTRL: MPU control register
func (o *MPU_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *MPU_Type) SetCTRL_HFNMIENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *MPU_Type) GetCTRL_HFNMIENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *MPU_Type) SetCTRL_PRIVDEFENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *MPU_Type) GetCTRL_PRIVDEFENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}

// MPU.RNR: MPU region number register
func (o *MPU_Type) SetRNR_REGION(value uint32) {
	volatile.StoreUint32(&o.RNR.Reg, volatile.LoadUint32(&o.RNR.Reg)&^(0xff)|value)
}
func (o *MPU_Type) GetRNR_REGION() uint32 {
	return volatile.LoadUint32(&o.RNR.Reg) & 0xff
}

// MPU.RBAR: MPU region base address register
func (o *MPU_Type) SetRBAR_REGION(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xf)|value)
}
func (o *MPU_Type) GetRBAR_REGION() uint32 {
	return volatile.LoadUint32(&o.RBAR.Reg) & 0xf
}
func (o *MPU_Type) SetRBAR_VALID(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0x10)|value<<4)
}
func (o *MPU_Type) GetRBAR_VALID() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0x10) >> 4
}
func (o *MPU_Type) SetRBAR_ADDR(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *MPU_Type) GetRBAR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0xffffffe0) >> 5
}

// MPU.RASR: MPU region attribute and size register
func (o *MPU_Type) SetRASR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetRASR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.RASR.Reg) & 0x1
}
func (o *MPU_Type) SetRASR_SIZE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x3e)|value<<1)
}
func (o *MPU_Type) GetRASR_SIZE() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x3e) >> 1
}
func (o *MPU_Type) SetRASR_SRD(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetRASR_SRD() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetRASR_B(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000)|value<<16)
}
func (o *MPU_Type) GetRASR_B() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000) >> 16
}
func (o *MPU_Type) SetRASR_C(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x20000)|value<<17)
}
func (o *MPU_Type) GetRASR_C() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x20000) >> 17
}
func (o *MPU_Type) SetRASR_S(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x40000)|value<<18)
}
func (o *MPU_Type) GetRASR_S() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x40000) >> 18
}
func (o *MPU_Type) SetRASR_TEX(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x380000)|value<<19)
}
func (o *MPU_Type) GetRASR_TEX() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x380000) >> 19
}
func (o *MPU_Type) SetRASR_AP(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x7000000)|value<<24)
}
func (o *MPU_Type) GetRASR_AP() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x7000000) >> 24
}
func (o *MPU_Type) SetRASR_XN(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000000)|value<<28)
}
func (o *MPU_Type) GetRASR_XN() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000000) >> 28
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	_     [124]byte
	ICER0 volatile.Register32 // 0x80
	_     [124]byte
	ISPR0 volatile.Register32 // 0x100
	_     [124]byte
	ICPR0 volatile.Register32 // 0x180
	_     [124]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	_     [248]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
}

// NVIC.ISER0: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER0(value uint32) {
	volatile.StoreUint32(&o.ISER0.Reg, value)
}
func (o *NVIC_Type) GetISER0() uint32 {
	return volatile.LoadUint32(&o.ISER0.Reg)
}

// NVIC.ICER0: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER0(value uint32) {
	volatile.StoreUint32(&o.ICER0.Reg, value)
}
func (o *NVIC_Type) GetICER0() uint32 {
	return volatile.LoadUint32(&o.ICER0.Reg)
}

// NVIC.ISPR0: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR0(value uint32) {
	volatile.StoreUint32(&o.ISPR0.Reg, value)
}
func (o *NVIC_Type) GetISPR0() uint32 {
	return volatile.LoadUint32(&o.ISPR0.Reg)
}

// NVIC.ICPR0: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR0(value uint32) {
	volatile.StoreUint32(&o.ICPR0.Reg, value)
}
func (o *NVIC_Type) GetICPR0() uint32 {
	return volatile.LoadUint32(&o.ICPR0.Reg)
}

// NVIC.IABR0: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR0(value uint32) {
	volatile.StoreUint32(&o.IABR0.Reg, value)
}
func (o *NVIC_Type) GetIABR0() uint32 {
	return volatile.LoadUint32(&o.IABR0.Reg)
}

// NVIC.IABR1: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR1(value uint32) {
	volatile.StoreUint32(&o.IABR1.Reg, value)
}
func (o *NVIC_Type) GetIABR1() uint32 {
	return volatile.LoadUint32(&o.IABR1.Reg)
}

// NVIC.IPR0: Interrupt Priority Register
func (o *NVIC_Type) SetIPR0_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR0_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR0.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR0_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR0_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR0_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR0_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR0_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR0_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff000000) >> 24
}

// NVIC.IPR1: Interrupt Priority Register
func (o *NVIC_Type) SetIPR1_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR1_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR1.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR1_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR1_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR1_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR1_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR1_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR1_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff000000) >> 24
}

// NVIC.IPR2: Interrupt Priority Register
func (o *NVIC_Type) SetIPR2_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR2_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR2.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR2_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR2_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR2_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR2_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR2_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR2_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff000000) >> 24
}

// NVIC.IPR3: Interrupt Priority Register
func (o *NVIC_Type) SetIPR3_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR3_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR3.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR3_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR3_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR3_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR3_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR3_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR3_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff000000) >> 24
}

// NVIC.IPR4: Interrupt Priority Register
func (o *NVIC_Type) SetIPR4_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR4_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR4.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR4_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR4_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR4_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR4_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR4_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR4_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff000000) >> 24
}

// NVIC.IPR5: Interrupt Priority Register
func (o *NVIC_Type) SetIPR5_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR5_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR5.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR5_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR5_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR5_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR5_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR5_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR5_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff000000) >> 24
}

// NVIC.IPR6: Interrupt Priority Register
func (o *NVIC_Type) SetIPR6_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR6_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR6.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR6_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR6_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR6_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR6_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR6_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR6_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff000000) >> 24
}

// NVIC.IPR7: Interrupt Priority Register
func (o *NVIC_Type) SetIPR7_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR7_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR7.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR7_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR7_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR7_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR7_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR7_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR7_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff000000) >> 24
}

// NVIC.IPR8: Interrupt Priority Register
func (o *NVIC_Type) SetIPR8_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR8_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR8.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR8_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR8_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR8_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR8_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR8_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR8_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff000000) >> 24
}

// Public key accelerator
type PKA_Type struct {
	CR    volatile.Register32 // 0x0
	SR    volatile.Register32 // 0x4
	CLRFR volatile.Register32 // 0x8
}

// PKA.CR: control register
func (o *PKA_Type) SetCR_ADDRERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *PKA_Type) GetCR_ADDRERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *PKA_Type) SetCR_RAMERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *PKA_Type) GetCR_RAMERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *PKA_Type) SetCR_PROCENDIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *PKA_Type) GetCR_PROCENDIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *PKA_Type) SetCR_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3f00)|value<<8)
}
func (o *PKA_Type) GetCR_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3f00) >> 8
}
func (o *PKA_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *PKA_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *PKA_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *PKA_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// PKA.SR: status register
func (o *PKA_Type) SetSR_ADDRERRF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *PKA_Type) GetSR_ADDRERRF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *PKA_Type) SetSR_RAMERRF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *PKA_Type) GetSR_RAMERRF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *PKA_Type) SetSR_PROCENDF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *PKA_Type) GetSR_PROCENDF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *PKA_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *PKA_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}

// PKA.CLRFR: clear flag register
func (o *PKA_Type) SetCLRFR_ADDRERRFC(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x100000)|value<<20)
}
func (o *PKA_Type) GetCLRFR_ADDRERRFC() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x100000) >> 20
}
func (o *PKA_Type) SetCLRFR_RAMERRFC(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x80000)|value<<19)
}
func (o *PKA_Type) GetCLRFR_RAMERRFC() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x80000) >> 19
}
func (o *PKA_Type) SetCLRFR_PROCENDFC(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x20000)|value<<17)
}
func (o *PKA_Type) GetCLRFR_PROCENDFC() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x20000) >> 17
}

// Power control
type PWR_Type struct {
	CR1         volatile.Register32 // 0x0
	CR2         volatile.Register32 // 0x4
	CR3         volatile.Register32 // 0x8
	CR4         volatile.Register32 // 0xC
	SR1         volatile.Register32 // 0x10
	SR2         volatile.Register32 // 0x14
	SCR         volatile.Register32 // 0x18
	CR5         volatile.Register32 // 0x1C
	PUCRA       volatile.Register32 // 0x20
	PDCRA       volatile.Register32 // 0x24
	PUCRB       volatile.Register32 // 0x28
	PDCRB       volatile.Register32 // 0x2C
	PUCRC       volatile.Register32 // 0x30
	PDCRC       volatile.Register32 // 0x34
	_           [32]byte
	PUCRH       volatile.Register32 // 0x58
	PDCRH       volatile.Register32 // 0x5C
	_           [32]byte
	C2CR1       volatile.Register32 // 0x80
	C2CR3       volatile.Register32 // 0x84
	EXTSCR      volatile.Register32 // 0x88
	SECCFGR     volatile.Register32 // 0x8C
	SUBGHZSPICR volatile.Register32 // 0x90
	_           [4]byte
	RSSCMDR     volatile.Register32 // 0x98
}

// PWR.CR1: Power control register 1
func (o *PWR_Type) SetCR1_LPR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetCR1_LPR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetCR1_VOS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x600)|value<<9)
}
func (o *PWR_Type) GetCR1_VOS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x600) >> 9
}
func (o *PWR_Type) SetCR1_DBP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR1_DBP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR1_FPDS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetCR1_FPDS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetCR1_FPDR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR1_FPDR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR1_SUBGHZSPINSSSEL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR1_SUBGHZSPINSSSEL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR1_LPMS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x7)|value)
}
func (o *PWR_Type) GetCR1_LPMS() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x7
}

// PWR.CR2: Power control register 2
func (o *PWR_Type) SetCR2_PVME3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetCR2_PVME3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetCR2_PLS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xe)|value<<1)
}
func (o *PWR_Type) GetCR2_PLS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xe) >> 1
}
func (o *PWR_Type) SetCR2_PVDE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR2_PVDE() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// PWR.CR3: Power control register 3
func (o *PWR_Type) SetCR3_EIWUL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetCR3_EIWUL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetCR3_EC2H(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetCR3_EC2H() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetCR3_EWRFIRQ(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetCR3_EWRFIRQ() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetCR3_EWRFBUSY(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetCR3_EWRFBUSY() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetCR3_APC(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCR3_APC() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetCR3_RRS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR3_RRS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR3_EWPVD(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR3_EWPVD() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR3_EULPEN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetCR3_EULPEN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetCR3_EWUP3(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR3_EWUP3() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR3_EWUP2(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR3_EWUP2() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR3_EWUP1(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR3_EWUP1() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}

// PWR.CR4: Power control register 4
func (o *PWR_Type) SetCR4_C2BOOT(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetCR4_C2BOOT() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetCR4_WRFBUSYP(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetCR4_WRFBUSYP() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetCR4_VBRS(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR4_VBRS() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR4_VBE(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR4_VBE() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR4_WP3(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR4_WP3() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR4_WP2(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR4_WP2() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR4_WP1(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR4_WP1() uint32 {
	return volatile.LoadUint32(&o.CR4.Reg) & 0x1
}

// PWR.SR1: Power status register 1
func (o *PWR_Type) SetSR1_WUFI(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetSR1_WUFI() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetSR1_C2HF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetSR1_C2HF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetSR1_WRFBUSYF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetSR1_WRFBUSYF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetSR1_WPVDF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetSR1_WPVDF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetSR1_WUF3(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetSR1_WUF3() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetSR1_WUF2(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetSR1_WUF2() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetSR1_WUF1(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetSR1_WUF1() uint32 {
	return volatile.LoadUint32(&o.SR1.Reg) & 0x1
}

// PWR.SR2: Power status register 2
func (o *PWR_Type) SetSR2_PVMO3(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetSR2_PVMO3() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetSR2_PVDO(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetSR2_PVDO() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetSR2_VOSF(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetSR2_VOSF() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetSR2_REGLPF(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetSR2_REGLPF() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetSR2_REGLPS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetSR2_REGLPS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetSR2_FLASHRDY(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetSR2_FLASHRDY() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetSR2_REGMRS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetSR2_REGMRS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetSR2_RFEOLF(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetSR2_RFEOLF() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetSR2_LDORDY(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetSR2_LDORDY() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetSR2_SMPSRDY(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetSR2_SMPSRDY() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetSR2_RFBUSYMS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetSR2_RFBUSYMS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetSR2_RFBUSYS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetSR2_RFBUSYS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetSR2_C2BOOTS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetSR2_C2BOOTS() uint32 {
	return volatile.LoadUint32(&o.SR2.Reg) & 0x1
}

// PWR.SCR: Power status clear register
func (o *PWR_Type) SetSCR_CC2HF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetSCR_CC2HF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetSCR_CWRFBUSYF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetSCR_CWRFBUSYF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetSCR_CWPVDF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetSCR_CWPVDF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetSCR_CWUF3(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetSCR_CWUF3() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetSCR_CWUF2(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetSCR_CWUF2() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetSCR_CWUF1(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetSCR_CWUF1() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0x1
}

// PWR.CR5: Power control register 5
func (o *PWR_Type) SetCR5_SMPSEN(value uint32) {
	volatile.StoreUint32(&o.CR5.Reg, volatile.LoadUint32(&o.CR5.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetCR5_SMPSEN() uint32 {
	return (volatile.LoadUint32(&o.CR5.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetCR5_RFEOLEN(value uint32) {
	volatile.StoreUint32(&o.CR5.Reg, volatile.LoadUint32(&o.CR5.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetCR5_RFEOLEN() uint32 {
	return (volatile.LoadUint32(&o.CR5.Reg) & 0x4000) >> 14
}

// PWR.PUCRA: Power Port A pull-up control register
func (o *PWR_Type) SetPUCRA_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRA_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRA_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRA_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRA_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRA_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRA_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRA_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRA_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRA_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRA_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRA_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRA_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRA_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRA_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRA_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRA_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRA_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRA_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRA_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRA_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRA_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRA_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRA_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRA_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRA_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRA_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRA_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRA_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRA_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRA_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRA_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRA.Reg) & 0x1
}

// PWR.PDCRA: Power Port A pull-down control register
func (o *PWR_Type) SetPDCRA_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRA_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRA_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRA_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRA_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRA_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRA_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRA_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRA_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRA_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRA_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRA_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRA_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRA_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRA_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRA_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRA_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRA_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRA_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRA_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRA_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRA_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRA_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRA_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRA_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRA_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRA_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRA_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRA_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRA_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRA_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRA_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRA.Reg) & 0x1
}

// PWR.PUCRB: Power Port B pull-up control register
func (o *PWR_Type) SetPUCRB_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRB_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRB_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRB_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRB_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRB_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRB_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRB_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRB_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRB_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRB_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRB_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRB_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRB_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRB_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRB_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRB_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRB_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRB_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRB_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRB_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRB_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRB_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRB_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRB_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRB_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRB_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRB_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRB_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRB_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRB_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRB_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRB.Reg) & 0x1
}

// PWR.PDCRB: Power Port B pull-down control register
func (o *PWR_Type) SetPDCRB_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRB_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRB_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRB_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRB_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRB_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRB_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRB_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRB_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRB_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRB_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRB_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRB_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRB_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRB_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRB_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRB_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRB_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRB_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRB_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRB_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRB_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRB_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRB_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRB_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRB_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRB_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRB_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRB_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRB_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRB_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRB_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRB.Reg) & 0x1
}

// PWR.PUCRC: Power Port C pull-up control register
func (o *PWR_Type) SetPUCRC_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRC_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRC_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRC_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRC_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRC_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRC_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRC_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRC_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRC_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRC_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRC_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRC.Reg) & 0x1
}
func (o *PWR_Type) SetPUCRC_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRC_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRC_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRC_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRC_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRC_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRC_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRC_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x40) >> 6
}

// PWR.PDCRC: Power Port C pull-down control register
func (o *PWR_Type) SetPDCRC_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRC_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRC_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRC_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRC_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRC_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRC_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRC_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRC_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRC_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRC_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRC_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRC.Reg) & 0x1
}
func (o *PWR_Type) SetPDCRC_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRC_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRC_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRC_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRC_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRC_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRC_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRC_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x40) >> 6
}

// PWR.PUCRH: Power Port H pull-up control register
func (o *PWR_Type) SetPUCRH_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRH.Reg, volatile.LoadUint32(&o.PUCRH.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRH_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRH.Reg) & 0x8) >> 3
}

// PWR.PDCRH: Power Port H pull-down control register
func (o *PWR_Type) SetPDCRH_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRH.Reg, volatile.LoadUint32(&o.PDCRH.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRH_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRH.Reg) & 0x8) >> 3
}

// PWR.C2CR1: Power CPU2 control register 1 [dual core device only]
func (o *PWR_Type) SetC2CR1_FPDS(value uint32) {
	volatile.StoreUint32(&o.C2CR1.Reg, volatile.LoadUint32(&o.C2CR1.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetC2CR1_FPDS() uint32 {
	return (volatile.LoadUint32(&o.C2CR1.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetC2CR1_FPDR(value uint32) {
	volatile.StoreUint32(&o.C2CR1.Reg, volatile.LoadUint32(&o.C2CR1.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetC2CR1_FPDR() uint32 {
	return (volatile.LoadUint32(&o.C2CR1.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetC2CR1_LPMS(value uint32) {
	volatile.StoreUint32(&o.C2CR1.Reg, volatile.LoadUint32(&o.C2CR1.Reg)&^(0x7)|value)
}
func (o *PWR_Type) GetC2CR1_LPMS() uint32 {
	return volatile.LoadUint32(&o.C2CR1.Reg) & 0x7
}

// PWR.C2CR3: Power CPU2 control register 3 [dual core device only]
func (o *PWR_Type) SetC2CR3_EIWUL(value uint32) {
	volatile.StoreUint32(&o.C2CR3.Reg, volatile.LoadUint32(&o.C2CR3.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetC2CR3_EIWUL() uint32 {
	return (volatile.LoadUint32(&o.C2CR3.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetC2CR3_EWRFIRQ(value uint32) {
	volatile.StoreUint32(&o.C2CR3.Reg, volatile.LoadUint32(&o.C2CR3.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetC2CR3_EWRFIRQ() uint32 {
	return (volatile.LoadUint32(&o.C2CR3.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetC2CR3_EWRFBUSY(value uint32) {
	volatile.StoreUint32(&o.C2CR3.Reg, volatile.LoadUint32(&o.C2CR3.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetC2CR3_EWRFBUSY() uint32 {
	return (volatile.LoadUint32(&o.C2CR3.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetC2CR3_APC(value uint32) {
	volatile.StoreUint32(&o.C2CR3.Reg, volatile.LoadUint32(&o.C2CR3.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetC2CR3_APC() uint32 {
	return (volatile.LoadUint32(&o.C2CR3.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetC2CR3_EWPVD(value uint32) {
	volatile.StoreUint32(&o.C2CR3.Reg, volatile.LoadUint32(&o.C2CR3.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetC2CR3_EWPVD() uint32 {
	return (volatile.LoadUint32(&o.C2CR3.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetC2CR3_EWUP3(value uint32) {
	volatile.StoreUint32(&o.C2CR3.Reg, volatile.LoadUint32(&o.C2CR3.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetC2CR3_EWUP3() uint32 {
	return (volatile.LoadUint32(&o.C2CR3.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetC2CR3_EWUP2(value uint32) {
	volatile.StoreUint32(&o.C2CR3.Reg, volatile.LoadUint32(&o.C2CR3.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetC2CR3_EWUP2() uint32 {
	return (volatile.LoadUint32(&o.C2CR3.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetC2CR3_EWUP1(value uint32) {
	volatile.StoreUint32(&o.C2CR3.Reg, volatile.LoadUint32(&o.C2CR3.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetC2CR3_EWUP1() uint32 {
	return volatile.LoadUint32(&o.C2CR3.Reg) & 0x1
}

// PWR.EXTSCR: Power extended status and status clear register
func (o *PWR_Type) SetEXTSCR_C2DS(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetEXTSCR_C2DS() uint32 {
	return (volatile.LoadUint32(&o.EXTSCR.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetEXTSCR_C1DS(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetEXTSCR_C1DS() uint32 {
	return (volatile.LoadUint32(&o.EXTSCR.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetEXTSCR_C2STOPF(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetEXTSCR_C2STOPF() uint32 {
	return (volatile.LoadUint32(&o.EXTSCR.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetEXTSCR_C2STOP2F(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetEXTSCR_C2STOP2F() uint32 {
	return (volatile.LoadUint32(&o.EXTSCR.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetEXTSCR_C2SBF(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetEXTSCR_C2SBF() uint32 {
	return (volatile.LoadUint32(&o.EXTSCR.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetEXTSCR_C1STOPF(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetEXTSCR_C1STOPF() uint32 {
	return (volatile.LoadUint32(&o.EXTSCR.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetEXTSCR_C1STOP2F(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetEXTSCR_C1STOP2F() uint32 {
	return (volatile.LoadUint32(&o.EXTSCR.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetEXTSCR_C1SBF(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetEXTSCR_C1SBF() uint32 {
	return (volatile.LoadUint32(&o.EXTSCR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetEXTSCR_C2CSSF(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetEXTSCR_C2CSSF() uint32 {
	return (volatile.LoadUint32(&o.EXTSCR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetEXTSCR_C1CSSF(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetEXTSCR_C1CSSF() uint32 {
	return volatile.LoadUint32(&o.EXTSCR.Reg) & 0x1
}

// PWR.SECCFGR: Power security configuration register [dual core device only]
func (o *PWR_Type) SetSECCFGR_C2EWILA(value uint32) {
	volatile.StoreUint32(&o.SECCFGR.Reg, volatile.LoadUint32(&o.SECCFGR.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetSECCFGR_C2EWILA() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR.Reg) & 0x8000) >> 15
}

// PWR.SUBGHZSPICR: Power SPI3 control register
func (o *PWR_Type) SetSUBGHZSPICR_NSS(value uint32) {
	volatile.StoreUint32(&o.SUBGHZSPICR.Reg, volatile.LoadUint32(&o.SUBGHZSPICR.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetSUBGHZSPICR_NSS() uint32 {
	return (volatile.LoadUint32(&o.SUBGHZSPICR.Reg) & 0x8000) >> 15
}

// PWR.RSSCMDR: RSS Command register [dual core device only]
func (o *PWR_Type) SetRSSCMDR_RSSCMD(value uint32) {
	volatile.StoreUint32(&o.RSSCMDR.Reg, volatile.LoadUint32(&o.RSSCMDR.Reg)&^(0xff)|value)
}
func (o *PWR_Type) GetRSSCMDR_RSSCMD() uint32 {
	return volatile.LoadUint32(&o.RSSCMDR.Reg) & 0xff
}

// Reset and clock control
type RCC_Type struct {
	CR           volatile.Register32 // 0x0
	ICSCR        volatile.Register32 // 0x4
	CFGR         volatile.Register32 // 0x8
	PLLCFGR      volatile.Register32 // 0xC
	_            [8]byte
	CIER         volatile.Register32 // 0x18
	CIFR         volatile.Register32 // 0x1C
	CICR         volatile.Register32 // 0x20
	_            [4]byte
	AHB1RSTR     volatile.Register32 // 0x28
	AHB2RSTR     volatile.Register32 // 0x2C
	AHB3RSTR     volatile.Register32 // 0x30
	_            [4]byte
	APB1RSTR1    volatile.Register32 // 0x38
	APB1RSTR2    volatile.Register32 // 0x3C
	APB2RSTR     volatile.Register32 // 0x40
	APB3RSTR     volatile.Register32 // 0x44
	AHB1ENR      volatile.Register32 // 0x48
	AHB2ENR      volatile.Register32 // 0x4C
	AHB3ENR      volatile.Register32 // 0x50
	_            [4]byte
	APB1ENR1     volatile.Register32 // 0x58
	APB1ENR2     volatile.Register32 // 0x5C
	APB2ENR      volatile.Register32 // 0x60
	APB3ENR      volatile.Register32 // 0x64
	AHB1SMENR    volatile.Register32 // 0x68
	AHB2SMENR    volatile.Register32 // 0x6C
	AHB3SMENR    volatile.Register32 // 0x70
	_            [4]byte
	APB1SMENR1   volatile.Register32 // 0x78
	APB1SMENR2   volatile.Register32 // 0x7C
	APB2SMENR    volatile.Register32 // 0x80
	APB3SMENR    volatile.Register32 // 0x84
	CCIPR        volatile.Register32 // 0x88
	_            [4]byte
	BDCR         volatile.Register32 // 0x90
	CSR          volatile.Register32 // 0x94
	_            [112]byte
	EXTCFGR      volatile.Register32 // 0x108
	_            [60]byte
	C2AHB1ENR    volatile.Register32 // 0x148
	C2AHB2ENR    volatile.Register32 // 0x14C
	C2AHB3ENR    volatile.Register32 // 0x150
	_            [4]byte
	C2APB1ENR1   volatile.Register32 // 0x158
	C2APB1ENR2   volatile.Register32 // 0x15C
	C2APB2ENR    volatile.Register32 // 0x160
	C2APB3ENR    volatile.Register32 // 0x164
	C2AHB1SMENR  volatile.Register32 // 0x168
	C2AHB2SMENR  volatile.Register32 // 0x16C
	C2AHB3SMENR  volatile.Register32 // 0x170
	_            [4]byte
	C2APB1SMENR1 volatile.Register32 // 0x178
	C2APB1SMENR2 volatile.Register32 // 0x17C
	C2APB2SMENR  volatile.Register32 // 0x180
	C2APB3SMENR  volatile.Register32 // 0x184
}

// RCC.CR: Clock control register
func (o *RCC_Type) SetCR_PLLRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCR_PLLRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCR_PLLON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCR_PLLON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCR_HSEBYPPWR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetCR_HSEBYPPWR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetCR_HSEPRE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetCR_HSEPRE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetCR_CSSON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCR_CSSON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCR_HSERDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCR_HSERDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCR_HSEON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCR_HSEON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCR_HSIKERDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetCR_HSIKERDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetCR_HSIASFS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetCR_HSIASFS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetCR_HSIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCR_HSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetCR_HSIKERON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCR_HSIKERON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCR_HSION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCR_HSION() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCR_MSIRANGE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf0)|value<<4)
}
func (o *RCC_Type) GetCR_MSIRANGE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf0) >> 4
}
func (o *RCC_Type) SetCR_MSIRGSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCR_MSIRGSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCR_MSIPLLEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCR_MSIPLLEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCR_MSIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCR_MSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCR_MSION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCR_MSION() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// RCC.ICSCR: Internal clock sources calibration register
func (o *RCC_Type) SetICSCR_HSITRIM(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0x7f000000)|value<<24)
}
func (o *RCC_Type) GetICSCR_HSITRIM() uint32 {
	return (volatile.LoadUint32(&o.ICSCR.Reg) & 0x7f000000) >> 24
}
func (o *RCC_Type) SetICSCR_HSICAL(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0xff0000)|value<<16)
}
func (o *RCC_Type) GetICSCR_HSICAL() uint32 {
	return (volatile.LoadUint32(&o.ICSCR.Reg) & 0xff0000) >> 16
}
func (o *RCC_Type) SetICSCR_MSITRIM(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0xff00)|value<<8)
}
func (o *RCC_Type) GetICSCR_MSITRIM() uint32 {
	return (volatile.LoadUint32(&o.ICSCR.Reg) & 0xff00) >> 8
}
func (o *RCC_Type) SetICSCR_MSICAL(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0xff)|value)
}
func (o *RCC_Type) GetICSCR_MSICAL() uint32 {
	return volatile.LoadUint32(&o.ICSCR.Reg) & 0xff
}

// RCC.CFGR: Clock configuration register
func (o *RCC_Type) SetCFGR_MCOPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x70000000)|value<<28)
}
func (o *RCC_Type) GetCFGR_MCOPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x70000000) >> 28
}
func (o *RCC_Type) SetCFGR_MCOSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf000000)|value<<24)
}
func (o *RCC_Type) GetCFGR_MCOSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf000000) >> 24
}
func (o *RCC_Type) SetCFGR_PPRE2F(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCFGR_PPRE2F() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCFGR_PPRE1F(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCFGR_PPRE1F() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCFGR_HPREF(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCFGR_HPREF() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCFGR_STOPWUCK(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetCFGR_STOPWUCK() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetCFGR_PPRE2(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3800)|value<<11)
}
func (o *RCC_Type) GetCFGR_PPRE2() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x3800) >> 11
}
func (o *RCC_Type) SetCFGR_PPRE1(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x700)|value<<8)
}
func (o *RCC_Type) GetCFGR_PPRE1() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x700) >> 8
}
func (o *RCC_Type) SetCFGR_HPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf0)|value<<4)
}
func (o *RCC_Type) GetCFGR_HPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf0) >> 4
}
func (o *RCC_Type) SetCFGR_SWS(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetCFGR_SWS() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc) >> 2
}
func (o *RCC_Type) SetCFGR_SW(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCFGR_SW() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x3
}

// RCC.PLLCFGR: PLL configuration register
func (o *RCC_Type) SetPLLCFGR_PLLR(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0xe0000000)|value<<29)
}
func (o *RCC_Type) GetPLLCFGR_PLLR() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0xe0000000) >> 29
}
func (o *RCC_Type) SetPLLCFGR_PLLREN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetPLLCFGR_PLLREN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetPLLCFGR_PLLQ(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0xe000000)|value<<25)
}
func (o *RCC_Type) GetPLLCFGR_PLLQ() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0xe000000) >> 25
}
func (o *RCC_Type) SetPLLCFGR_PLLQEN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetPLLCFGR_PLLQEN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetPLLCFGR_PLLP(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x3e0000)|value<<17)
}
func (o *RCC_Type) GetPLLCFGR_PLLP() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x3e0000) >> 17
}
func (o *RCC_Type) SetPLLCFGR_PLLPEN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetPLLCFGR_PLLPEN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetPLLCFGR_PLLN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x7f00)|value<<8)
}
func (o *RCC_Type) GetPLLCFGR_PLLN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x7f00) >> 8
}
func (o *RCC_Type) SetPLLCFGR_PLLM(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x70)|value<<4)
}
func (o *RCC_Type) GetPLLCFGR_PLLM() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x70) >> 4
}
func (o *RCC_Type) SetPLLCFGR_PLLSRC(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetPLLCFGR_PLLSRC() uint32 {
	return volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x3
}

// RCC.CIER: Clock interrupt enable register
func (o *RCC_Type) SetCIER_LSECSSIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCIER_LSECSSIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCIER_PLLRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCIER_PLLRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCIER_HSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIER_HSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIER_HSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIER_HSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIER_MSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCIER_MSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCIER_LSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIER_LSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIER_LSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIER_LSIRDYIE() uint32 {
	return volatile.LoadUint32(&o.CIER.Reg) & 0x1
}

// RCC.CIFR: Clock interrupt flag register
func (o *RCC_Type) SetCIFR_LSECSSF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCIFR_LSECSSF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCIFR_CSSF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCIFR_CSSF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCIFR_PLLRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCIFR_PLLRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCIFR_HSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIFR_HSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIFR_HSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIFR_HSIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIFR_MSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCIFR_MSIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCIFR_LSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIFR_LSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIFR_LSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIFR_LSIRDYF() uint32 {
	return volatile.LoadUint32(&o.CIFR.Reg) & 0x1
}

// RCC.CICR: Clock interrupt clear register
func (o *RCC_Type) SetCICR_LSECSSC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCICR_LSECSSC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCICR_CSSC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCICR_CSSC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCICR_PLLRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCICR_PLLRDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCICR_HSERDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCICR_HSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCICR_HSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCICR_HSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCICR_MSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCICR_MSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCICR_LSERDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCICR_LSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCICR_LSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCICR_LSIRDYC() uint32 {
	return volatile.LoadUint32(&o.CICR.Reg) & 0x1
}

// RCC.AHB1RSTR: AHB1 peripheral reset register
func (o *RCC_Type) SetAHB1RSTR_CRCRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1RSTR_CRCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1RSTR_DMAMUX1RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1RSTR_DMAMUX1RST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1RSTR_DMA2RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1RSTR_DMA2RST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1RSTR_DMA1RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1RSTR_DMA1RST() uint32 {
	return volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1
}

// RCC.AHB2RSTR: AHB2 peripheral reset register
func (o *RCC_Type) SetAHB2RSTR_GPIOHRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOHRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2RSTR_GPIOCRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB2RSTR_GPIOBRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOBRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB2RSTR_GPIOARST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOARST() uint32 {
	return volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x1
}

// RCC.AHB3RSTR: AHB3 peripheral reset register
func (o *RCC_Type) SetAHB3RSTR_FLASHRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHB3RSTR_FLASHRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHB3RSTR_IPCCRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAHB3RSTR_IPCCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAHB3RSTR_HSEMRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAHB3RSTR_HSEMRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAHB3RSTR_RNGRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB3RSTR_RNGRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB3RSTR_AESRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB3RSTR_AESRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAHB3RSTR_PKARST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB3RSTR_PKARST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x10000) >> 16
}

// RCC.APB1RSTR1: APB1 peripheral reset register 1
func (o *RCC_Type) SetAPB1RSTR1_LPTIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1RSTR1_LPTIM1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1RSTR1_DACRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1RSTR1_DACRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1RSTR1_I2C3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1RSTR1_I2C3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1RSTR1_I2C2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1RSTR1_I2C2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1RSTR1_I2C1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1RSTR1_I2C1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1RSTR1_USART2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1RSTR1_USART2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1RSTR1_SPI2S2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1RSTR1_SPI2S2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1RSTR1_TIM2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1RSTR1_TIM2RST() uint32 {
	return volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x1
}

// RCC.APB1RSTR2: APB1 peripheral reset register 2
func (o *RCC_Type) SetAPB1RSTR2_LPTIM3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR2.Reg, volatile.LoadUint32(&o.APB1RSTR2.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB1RSTR2_LPTIM3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR2.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB1RSTR2_LPTIM2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR2.Reg, volatile.LoadUint32(&o.APB1RSTR2.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1RSTR2_LPTIM2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR2.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1RSTR2_LPUART1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR2.Reg, volatile.LoadUint32(&o.APB1RSTR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1RSTR2_LPUART1RST() uint32 {
	return volatile.LoadUint32(&o.APB1RSTR2.Reg) & 0x1
}

// RCC.APB2RSTR: APB2 peripheral reset register
func (o *RCC_Type) SetAPB2RSTR_TIM17RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2RSTR_TIM17RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2RSTR_TIM16RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2RSTR_TIM16RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2RSTR_USART1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2RSTR_USART1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2RSTR_SPI1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2RSTR_SPI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2RSTR_TIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2RSTR_TIM1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2RSTR_ADCRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB2RSTR_ADCRST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x200) >> 9
}

// RCC.APB3RSTR: APB3 peripheral reset register
func (o *RCC_Type) SetAPB3RSTR_SUBGHZSPIRST(value uint32) {
	volatile.StoreUint32(&o.APB3RSTR.Reg, volatile.LoadUint32(&o.APB3RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB3RSTR_SUBGHZSPIRST() uint32 {
	return volatile.LoadUint32(&o.APB3RSTR.Reg) & 0x1
}

// RCC.AHB1ENR: AHB1 peripheral clock enable register
func (o *RCC_Type) SetAHB1ENR_CRCEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1ENR_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1ENR_DMAMUX1EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1ENR_DMAMUX1EN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1ENR_DMA2EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1ENR_DMA2EN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1ENR_DMA1EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1ENR_DMA1EN() uint32 {
	return volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1
}

// RCC.AHB2ENR: AHB2 peripheral clock enable register
func (o *RCC_Type) SetAHB2ENR_GPIOHEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2ENR_GPIOHEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2ENR_GPIOCEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB2ENR_GPIOCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB2ENR_GPIOBEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB2ENR_GPIOBEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB2ENR_GPIOAEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2ENR_GPIOAEN() uint32 {
	return volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x1
}

// RCC.AHB3ENR: AHB3 peripheral clock enable register
func (o *RCC_Type) SetAHB3ENR_FLASHEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHB3ENR_FLASHEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHB3ENR_IPCCEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAHB3ENR_IPCCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAHB3ENR_HSEMEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAHB3ENR_HSEMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAHB3ENR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB3ENR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB3ENR_AESEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB3ENR_AESEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAHB3ENR_PKAEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB3ENR_PKAEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x10000) >> 16
}

// RCC.APB1ENR1: APB1 peripheral clock enable register 1
func (o *RCC_Type) SetAPB1ENR1_LPTIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1ENR1_LPTIM1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1ENR1_DAC1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1ENR1_DAC1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1ENR1_I2C3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1ENR1_I2C3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1ENR1_I2C2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1ENR1_I2C2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1ENR1_I2C1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1ENR1_I2C1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1ENR1_USART2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1ENR1_USART2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1ENR1_SPI2S2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1ENR1_SPI2S2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1ENR1_WWDGEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1ENR1_WWDGEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1ENR1_RTCAPBEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB1ENR1_RTCAPBEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB1ENR1_TIM2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1ENR1_TIM2EN() uint32 {
	return volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x1
}

// RCC.APB1ENR2: APB1 peripheral clock enable register 2
func (o *RCC_Type) SetAPB1ENR2_LPTIM3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR2.Reg, volatile.LoadUint32(&o.APB1ENR2.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB1ENR2_LPTIM3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR2.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB1ENR2_LPTIM2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR2.Reg, volatile.LoadUint32(&o.APB1ENR2.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1ENR2_LPTIM2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR2.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1ENR2_LPUART1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR2.Reg, volatile.LoadUint32(&o.APB1ENR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1ENR2_LPUART1EN() uint32 {
	return volatile.LoadUint32(&o.APB1ENR2.Reg) & 0x1
}

// RCC.APB2ENR: APB2 peripheral clock enable register
func (o *RCC_Type) SetAPB2ENR_TIM17EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2ENR_TIM17EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2ENR_TIM16EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2ENR_TIM16EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2ENR_USART1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2ENR_USART1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2ENR_SPI1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2ENR_SPI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2ENR_TIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2ENR_TIM1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2ENR_ADCEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB2ENR_ADCEN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x200) >> 9
}

// RCC.APB3ENR: APB3 peripheral clock enable register
func (o *RCC_Type) SetAPB3ENR_SUBGHZSPIEN(value uint32) {
	volatile.StoreUint32(&o.APB3ENR.Reg, volatile.LoadUint32(&o.APB3ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB3ENR_SUBGHZSPIEN() uint32 {
	return volatile.LoadUint32(&o.APB3ENR.Reg) & 0x1
}

// RCC.AHB1SMENR: AHB1 peripheral clocks enable in Sleep modes register
func (o *RCC_Type) SetAHB1SMENR_CRCSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1SMENR_CRCSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1SMENR_DMAMUX1SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1SMENR_DMAMUX1SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1SMENR_DMA2SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1SMENR_DMA2SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1SMENR_DMA1SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1SMENR_DMA1SMEN() uint32 {
	return volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x1
}

// RCC.AHB2SMENR: AHB2 peripheral clocks enable in Sleep modes register
func (o *RCC_Type) SetAHB2SMENR_GPIOHSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOHSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2SMENR_GPIOCSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOCSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB2SMENR_GPIOBSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOBSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB2SMENR_GPIOASMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOASMEN() uint32 {
	return volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x1
}

// RCC.AHB3SMENR: AHB3 peripheral clocks enable in Sleep and Stop modes register
func (o *RCC_Type) SetAHB3SMENR_FLASHSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB3SMENR.Reg, volatile.LoadUint32(&o.AHB3SMENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHB3SMENR_FLASHSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3SMENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHB3SMENR_SRAM2SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB3SMENR.Reg, volatile.LoadUint32(&o.AHB3SMENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAHB3SMENR_SRAM2SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3SMENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAHB3SMENR_SRAM1SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB3SMENR.Reg, volatile.LoadUint32(&o.AHB3SMENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAHB3SMENR_SRAM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3SMENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAHB3SMENR_RNGSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB3SMENR.Reg, volatile.LoadUint32(&o.AHB3SMENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB3SMENR_RNGSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3SMENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB3SMENR_AESSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB3SMENR.Reg, volatile.LoadUint32(&o.AHB3SMENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB3SMENR_AESSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3SMENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAHB3SMENR_PKASMEN(value uint32) {
	volatile.StoreUint32(&o.AHB3SMENR.Reg, volatile.LoadUint32(&o.AHB3SMENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB3SMENR_PKASMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3SMENR.Reg) & 0x10000) >> 16
}

// RCC.APB1SMENR1: APB1 peripheral clocks enable in Sleep mode register 1
func (o *RCC_Type) SetAPB1SMENR1_LPTIM1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1SMENR1_LPTIM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1SMENR1_DACSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1SMENR1_DACSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1SMENR1_I2C3SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1SMENR1_I2C3SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1SMENR1_I2C2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1SMENR1_I2C2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1SMENR1_I2C1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1SMENR1_I2C1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1SMENR1_USART2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1SMENR1_USART2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1SMENR1_SPI2S2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1SMENR1_SPI2S2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1SMENR1_WWDGSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1SMENR1_WWDGSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1SMENR1_RTCAPBSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB1SMENR1_RTCAPBSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB1SMENR1_TIM2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1SMENR1_TIM2SMEN() uint32 {
	return volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x1
}

// RCC.APB1SMENR2: APB1 peripheral clocks enable in Sleep mode register 2
func (o *RCC_Type) SetAPB1SMENR2_LPTIM3SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR2.Reg, volatile.LoadUint32(&o.APB1SMENR2.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB1SMENR2_LPTIM3SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR2.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB1SMENR2_LPTIM2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR2.Reg, volatile.LoadUint32(&o.APB1SMENR2.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1SMENR2_LPTIM2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR2.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1SMENR2_LPUART1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR2.Reg, volatile.LoadUint32(&o.APB1SMENR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1SMENR2_LPUART1SMEN() uint32 {
	return volatile.LoadUint32(&o.APB1SMENR2.Reg) & 0x1
}

// RCC.APB2SMENR: APB2 peripheral clocks enable in Sleep mode register
func (o *RCC_Type) SetAPB2SMENR_TIM17SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2SMENR_TIM17SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2SMENR_TIM16SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2SMENR_TIM16SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2SMENR_USART1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2SMENR_USART1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2SMENR_SPI1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2SMENR_SPI1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2SMENR_TIM1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2SMENR_TIM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2SMENR_ADCSMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB2SMENR_ADCSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x200) >> 9
}

// RCC.APB3SMENR: APB3 peripheral clock enable in Sleep mode register
func (o *RCC_Type) SetAPB3SMENR_SUBGHZSPISMEN(value uint32) {
	volatile.StoreUint32(&o.APB3SMENR.Reg, volatile.LoadUint32(&o.APB3SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB3SMENR_SUBGHZSPISMEN() uint32 {
	return volatile.LoadUint32(&o.APB3SMENR.Reg) & 0x1
}

// RCC.CCIPR: Peripherals independent clock configuration register
func (o *RCC_Type) SetCCIPR_RNGSEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc0000000)|value<<30)
}
func (o *RCC_Type) GetCCIPR_RNGSEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc0000000) >> 30
}
func (o *RCC_Type) SetCCIPR_ADCSEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x30000000)|value<<28)
}
func (o *RCC_Type) GetCCIPR_ADCSEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x30000000) >> 28
}
func (o *RCC_Type) SetCCIPR_LPTIM3SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc00000)|value<<22)
}
func (o *RCC_Type) GetCCIPR_LPTIM3SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc00000) >> 22
}
func (o *RCC_Type) SetCCIPR_LPTIM2SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x300000)|value<<20)
}
func (o *RCC_Type) GetCCIPR_LPTIM2SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x300000) >> 20
}
func (o *RCC_Type) SetCCIPR_LPTIM1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc0000)|value<<18)
}
func (o *RCC_Type) GetCCIPR_LPTIM1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc0000) >> 18
}
func (o *RCC_Type) SetCCIPR_I2C3SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x30000)|value<<16)
}
func (o *RCC_Type) GetCCIPR_I2C3SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x30000) >> 16
}
func (o *RCC_Type) SetCCIPR_I2C2SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc000)|value<<14)
}
func (o *RCC_Type) GetCCIPR_I2C2SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc000) >> 14
}
func (o *RCC_Type) SetCCIPR_I2C1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x3000)|value<<12)
}
func (o *RCC_Type) GetCCIPR_I2C1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x3000) >> 12
}
func (o *RCC_Type) SetCCIPR_LPUART1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc00)|value<<10)
}
func (o *RCC_Type) GetCCIPR_LPUART1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc00) >> 10
}
func (o *RCC_Type) SetCCIPR_SPI2S2SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetCCIPR_SPI2S2SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x300) >> 8
}
func (o *RCC_Type) SetCCIPR_USART2SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetCCIPR_USART2SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc) >> 2
}
func (o *RCC_Type) SetCCIPR_USART1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCCIPR_USART1SEL() uint32 {
	return volatile.LoadUint32(&o.CCIPR.Reg) & 0x3
}

// RCC.BDCR: Backup domain control register
func (o *RCC_Type) SetBDCR_LSCOSEL(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetBDCR_LSCOSEL() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetBDCR_LSCOEN(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetBDCR_LSCOEN() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetBDCR_BDRST(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetBDCR_BDRST() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetBDCR_RTCEN(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetBDCR_RTCEN() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetBDCR_LSESYSRDY(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetBDCR_LSESYSRDY() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetBDCR_RTCSEL(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetBDCR_RTCSEL() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x300) >> 8
}
func (o *RCC_Type) SetBDCR_LSESYSEN(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetBDCR_LSESYSEN() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetBDCR_LSECSSD(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetBDCR_LSECSSD() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetBDCR_LSECSSON(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetBDCR_LSECSSON() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetBDCR_LSEDRV(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x18)|value<<3)
}
func (o *RCC_Type) GetBDCR_LSEDRV() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x18) >> 3
}
func (o *RCC_Type) SetBDCR_LSEBYP(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetBDCR_LSEBYP() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetBDCR_LSERDY(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetBDCR_LSERDY() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetBDCR_LSEON(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetBDCR_LSEON() uint32 {
	return volatile.LoadUint32(&o.BDCR.Reg) & 0x1
}

// RCC.CSR: Control/status register
func (o *RCC_Type) SetCSR_LPWRRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetCSR_LPWRRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetCSR_WWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetCSR_WWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetCSR_IWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetCSR_IWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetCSR_SFTRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetCSR_SFTRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetCSR_BORRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCSR_BORRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCSR_PINRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCSR_PINRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCSR_OBLRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCSR_OBLRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCSR_RFILARSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCSR_RFILARSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCSR_RMVF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCSR_RMVF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetCSR_RFRST(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetCSR_RFRST() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetCSR_RFRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetCSR_RFRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetCSR_MSISRANGE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0xf00)|value<<8)
}
func (o *RCC_Type) GetCSR_MSISRANGE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0xf00) >> 8
}
func (o *RCC_Type) SetCSR_LSIPRE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCSR_LSIPRE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCSR_LSIRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCSR_LSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCSR_LSION(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCSR_LSION() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}

// RCC.EXTCFGR: Extended clock recovery register
func (o *RCC_Type) SetEXTCFGR_C2HPREF(value uint32) {
	volatile.StoreUint32(&o.EXTCFGR.Reg, volatile.LoadUint32(&o.EXTCFGR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetEXTCFGR_C2HPREF() uint32 {
	return (volatile.LoadUint32(&o.EXTCFGR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetEXTCFGR_SHDHPREF(value uint32) {
	volatile.StoreUint32(&o.EXTCFGR.Reg, volatile.LoadUint32(&o.EXTCFGR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetEXTCFGR_SHDHPREF() uint32 {
	return (volatile.LoadUint32(&o.EXTCFGR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetEXTCFGR_C2HPRE(value uint32) {
	volatile.StoreUint32(&o.EXTCFGR.Reg, volatile.LoadUint32(&o.EXTCFGR.Reg)&^(0xf0)|value<<4)
}
func (o *RCC_Type) GetEXTCFGR_C2HPRE() uint32 {
	return (volatile.LoadUint32(&o.EXTCFGR.Reg) & 0xf0) >> 4
}
func (o *RCC_Type) SetEXTCFGR_SHDHPRE(value uint32) {
	volatile.StoreUint32(&o.EXTCFGR.Reg, volatile.LoadUint32(&o.EXTCFGR.Reg)&^(0xf)|value)
}
func (o *RCC_Type) GetEXTCFGR_SHDHPRE() uint32 {
	return volatile.LoadUint32(&o.EXTCFGR.Reg) & 0xf
}

// RCC.C2AHB1ENR: CPU2 AHB1 peripheral clock enable register
func (o *RCC_Type) SetC2AHB1ENR_CRCEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1ENR.Reg, volatile.LoadUint32(&o.C2AHB1ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetC2AHB1ENR_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB1ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetC2AHB1ENR_DMAMUX1EN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1ENR.Reg, volatile.LoadUint32(&o.C2AHB1ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetC2AHB1ENR_DMAMUX1EN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB1ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetC2AHB1ENR_DMA2EN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1ENR.Reg, volatile.LoadUint32(&o.C2AHB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC2AHB1ENR_DMA2EN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC2AHB1ENR_DMA1EN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1ENR.Reg, volatile.LoadUint32(&o.C2AHB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2AHB1ENR_DMA1EN() uint32 {
	return volatile.LoadUint32(&o.C2AHB1ENR.Reg) & 0x1
}

// RCC.C2AHB2ENR: CPU2 AHB2 peripheral clock enable register
func (o *RCC_Type) SetC2AHB2ENR_GPIOHEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2ENR.Reg, volatile.LoadUint32(&o.C2AHB2ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetC2AHB2ENR_GPIOHEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetC2AHB2ENR_GPIOCEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2ENR.Reg, volatile.LoadUint32(&o.C2AHB2ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetC2AHB2ENR_GPIOCEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetC2AHB2ENR_GPIOBEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2ENR.Reg, volatile.LoadUint32(&o.C2AHB2ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC2AHB2ENR_GPIOBEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC2AHB2ENR_GPIOAEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2ENR.Reg, volatile.LoadUint32(&o.C2AHB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2AHB2ENR_GPIOAEN() uint32 {
	return volatile.LoadUint32(&o.C2AHB2ENR.Reg) & 0x1
}

// RCC.C2AHB3ENR: CPU2 AHB3 peripheral clock enable register [dual core device only]
func (o *RCC_Type) SetC2AHB3ENR_FLASHEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3ENR.Reg, volatile.LoadUint32(&o.C2AHB3ENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetC2AHB3ENR_FLASHEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3ENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetC2AHB3ENR_IPCCEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3ENR.Reg, volatile.LoadUint32(&o.C2AHB3ENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetC2AHB3ENR_IPCCEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3ENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetC2AHB3ENR_HSEMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3ENR.Reg, volatile.LoadUint32(&o.C2AHB3ENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetC2AHB3ENR_HSEMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3ENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetC2AHB3ENR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3ENR.Reg, volatile.LoadUint32(&o.C2AHB3ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetC2AHB3ENR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetC2AHB3ENR_AESEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3ENR.Reg, volatile.LoadUint32(&o.C2AHB3ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetC2AHB3ENR_AESEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetC2AHB3ENR_PKAEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3ENR.Reg, volatile.LoadUint32(&o.C2AHB3ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC2AHB3ENR_PKAEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3ENR.Reg) & 0x10000) >> 16
}

// RCC.C2APB1ENR1: CPU2 APB1 peripheral clock enable register 1 [dual core device only]
func (o *RCC_Type) SetC2APB1ENR1_LPTIM1EN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR1.Reg, volatile.LoadUint32(&o.C2APB1ENR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetC2APB1ENR1_LPTIM1EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR1.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetC2APB1ENR1_DAC1EN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR1.Reg, volatile.LoadUint32(&o.C2APB1ENR1.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetC2APB1ENR1_DAC1EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR1.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetC2APB1ENR1_I2C3EN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR1.Reg, volatile.LoadUint32(&o.C2APB1ENR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetC2APB1ENR1_I2C3EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetC2APB1ENR1_I2C2EN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR1.Reg, volatile.LoadUint32(&o.C2APB1ENR1.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetC2APB1ENR1_I2C2EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR1.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetC2APB1ENR1_I2C1EN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR1.Reg, volatile.LoadUint32(&o.C2APB1ENR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetC2APB1ENR1_I2C1EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetC2APB1ENR1_USART2EN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR1.Reg, volatile.LoadUint32(&o.C2APB1ENR1.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetC2APB1ENR1_USART2EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR1.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetC2APB1ENR1_SPI2S2EN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR1.Reg, volatile.LoadUint32(&o.C2APB1ENR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetC2APB1ENR1_SPI2S2EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetC2APB1ENR1_RTCAPBEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR1.Reg, volatile.LoadUint32(&o.C2APB1ENR1.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetC2APB1ENR1_RTCAPBEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR1.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetC2APB1ENR1_TIM2EN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR1.Reg, volatile.LoadUint32(&o.C2APB1ENR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2APB1ENR1_TIM2EN() uint32 {
	return volatile.LoadUint32(&o.C2APB1ENR1.Reg) & 0x1
}

// RCC.C2APB1ENR2: CPU2 APB1 peripheral clock enable register 2 [dual core device only]
func (o *RCC_Type) SetC2APB1ENR2_LPTIM3EN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR2.Reg, volatile.LoadUint32(&o.C2APB1ENR2.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetC2APB1ENR2_LPTIM3EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR2.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetC2APB1ENR2_LPTIM2EN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR2.Reg, volatile.LoadUint32(&o.C2APB1ENR2.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC2APB1ENR2_LPTIM2EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR2.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC2APB1ENR2_LPUART1EN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR2.Reg, volatile.LoadUint32(&o.C2APB1ENR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2APB1ENR2_LPUART1EN() uint32 {
	return volatile.LoadUint32(&o.C2APB1ENR2.Reg) & 0x1
}

// RCC.C2APB2ENR: CPU2 APB2 peripheral clock enable register [dual core device only]
func (o *RCC_Type) SetC2APB2ENR_TIM17EN(value uint32) {
	volatile.StoreUint32(&o.C2APB2ENR.Reg, volatile.LoadUint32(&o.C2APB2ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetC2APB2ENR_TIM17EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetC2APB2ENR_TIM16EN(value uint32) {
	volatile.StoreUint32(&o.C2APB2ENR.Reg, volatile.LoadUint32(&o.C2APB2ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetC2APB2ENR_TIM16EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetC2APB2ENR_USART1EN(value uint32) {
	volatile.StoreUint32(&o.C2APB2ENR.Reg, volatile.LoadUint32(&o.C2APB2ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetC2APB2ENR_USART1EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetC2APB2ENR_SPI1EN(value uint32) {
	volatile.StoreUint32(&o.C2APB2ENR.Reg, volatile.LoadUint32(&o.C2APB2ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetC2APB2ENR_SPI1EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetC2APB2ENR_TIM1EN(value uint32) {
	volatile.StoreUint32(&o.C2APB2ENR.Reg, volatile.LoadUint32(&o.C2APB2ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetC2APB2ENR_TIM1EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetC2APB2ENR_ADCEN(value uint32) {
	volatile.StoreUint32(&o.C2APB2ENR.Reg, volatile.LoadUint32(&o.C2APB2ENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetC2APB2ENR_ADCEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2ENR.Reg) & 0x200) >> 9
}

// RCC.C2APB3ENR: CPU2 APB3 peripheral clock enable register [dual core device only]
func (o *RCC_Type) SetC2APB3ENR_SUBGHZSPIEN(value uint32) {
	volatile.StoreUint32(&o.C2APB3ENR.Reg, volatile.LoadUint32(&o.C2APB3ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2APB3ENR_SUBGHZSPIEN() uint32 {
	return volatile.LoadUint32(&o.C2APB3ENR.Reg) & 0x1
}

// RCC.C2AHB1SMENR: CPU2 AHB1 peripheral clocks enable in Sleep modes register [dual core device only]
func (o *RCC_Type) SetC2AHB1SMENR_CRCSMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1SMENR.Reg, volatile.LoadUint32(&o.C2AHB1SMENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetC2AHB1SMENR_CRCSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB1SMENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetC2AHB1SMENR_DMAMUX1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1SMENR.Reg, volatile.LoadUint32(&o.C2AHB1SMENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetC2AHB1SMENR_DMAMUX1SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB1SMENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetC2AHB1SMENR_DMA2SMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1SMENR.Reg, volatile.LoadUint32(&o.C2AHB1SMENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC2AHB1SMENR_DMA2SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB1SMENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC2AHB1SMENR_DMA1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1SMENR.Reg, volatile.LoadUint32(&o.C2AHB1SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2AHB1SMENR_DMA1SMEN() uint32 {
	return volatile.LoadUint32(&o.C2AHB1SMENR.Reg) & 0x1
}

// RCC.C2AHB2SMENR: CPU2 AHB2 peripheral clocks enable in Sleep modes register [dual core device only]
func (o *RCC_Type) SetC2AHB2SMENR_GPIOHSMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2SMENR.Reg, volatile.LoadUint32(&o.C2AHB2SMENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetC2AHB2SMENR_GPIOHSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2SMENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetC2AHB2SMENR_GPIOCSMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2SMENR.Reg, volatile.LoadUint32(&o.C2AHB2SMENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetC2AHB2SMENR_GPIOCSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2SMENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetC2AHB2SMENR_GPIOBSMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2SMENR.Reg, volatile.LoadUint32(&o.C2AHB2SMENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC2AHB2SMENR_GPIOBSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2SMENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC2AHB2SMENR_GPIOASMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2SMENR.Reg, volatile.LoadUint32(&o.C2AHB2SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2AHB2SMENR_GPIOASMEN() uint32 {
	return volatile.LoadUint32(&o.C2AHB2SMENR.Reg) & 0x1
}

// RCC.C2AHB3SMENR: CPU2 AHB3 peripheral clocks enable in Sleep mode register [dual core device only]
func (o *RCC_Type) SetC2AHB3SMENR_FLASHSMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3SMENR.Reg, volatile.LoadUint32(&o.C2AHB3SMENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetC2AHB3SMENR_FLASHSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3SMENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetC2AHB3SMENR_SRAM2SMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3SMENR.Reg, volatile.LoadUint32(&o.C2AHB3SMENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetC2AHB3SMENR_SRAM2SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3SMENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetC2AHB3SMENR_SRAM1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3SMENR.Reg, volatile.LoadUint32(&o.C2AHB3SMENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetC2AHB3SMENR_SRAM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3SMENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetC2AHB3SMENR_RNGSMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3SMENR.Reg, volatile.LoadUint32(&o.C2AHB3SMENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetC2AHB3SMENR_RNGSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3SMENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetC2AHB3SMENR_AESSMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3SMENR.Reg, volatile.LoadUint32(&o.C2AHB3SMENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetC2AHB3SMENR_AESSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3SMENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetC2AHB3SMENR_PKASMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3SMENR.Reg, volatile.LoadUint32(&o.C2AHB3SMENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC2AHB3SMENR_PKASMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3SMENR.Reg) & 0x10000) >> 16
}

// RCC.C2APB1SMENR1: CPU2 APB1 peripheral clocks enable in Sleep mode register 1 [dual core device only]
func (o *RCC_Type) SetC2APB1SMENR1_LPTIM1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR1.Reg, volatile.LoadUint32(&o.C2APB1SMENR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetC2APB1SMENR1_LPTIM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR1.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetC2APB1SMENR1_DAC1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR1.Reg, volatile.LoadUint32(&o.C2APB1SMENR1.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetC2APB1SMENR1_DAC1SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR1.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetC2APB1SMENR1_I2C3SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR1.Reg, volatile.LoadUint32(&o.C2APB1SMENR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetC2APB1SMENR1_I2C3SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetC2APB1SMENR1_I2C2SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR1.Reg, volatile.LoadUint32(&o.C2APB1SMENR1.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetC2APB1SMENR1_I2C2SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR1.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetC2APB1SMENR1_I2C1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR1.Reg, volatile.LoadUint32(&o.C2APB1SMENR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetC2APB1SMENR1_I2C1SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetC2APB1SMENR1_USART2SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR1.Reg, volatile.LoadUint32(&o.C2APB1SMENR1.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetC2APB1SMENR1_USART2SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR1.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetC2APB1SMENR1_SPI2S2SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR1.Reg, volatile.LoadUint32(&o.C2APB1SMENR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetC2APB1SMENR1_SPI2S2SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetC2APB1SMENR1_RTCAPBSMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR1.Reg, volatile.LoadUint32(&o.C2APB1SMENR1.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetC2APB1SMENR1_RTCAPBSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR1.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetC2APB1SMENR1_TIM2SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR1.Reg, volatile.LoadUint32(&o.C2APB1SMENR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2APB1SMENR1_TIM2SMEN() uint32 {
	return volatile.LoadUint32(&o.C2APB1SMENR1.Reg) & 0x1
}

// RCC.C2APB1SMENR2: CPU2 APB1 peripheral clocks enable in Sleep mode register 2 [dual core device only]
func (o *RCC_Type) SetC2APB1SMENR2_LPTIM3SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR2.Reg, volatile.LoadUint32(&o.C2APB1SMENR2.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetC2APB1SMENR2_LPTIM3SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR2.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetC2APB1SMENR2_LPTIM2SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR2.Reg, volatile.LoadUint32(&o.C2APB1SMENR2.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC2APB1SMENR2_LPTIM2SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR2.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC2APB1SMENR2_LPUART1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR2.Reg, volatile.LoadUint32(&o.C2APB1SMENR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2APB1SMENR2_LPUART1SMEN() uint32 {
	return volatile.LoadUint32(&o.C2APB1SMENR2.Reg) & 0x1
}

// RCC.C2APB2SMENR: CPU2 APB2 peripheral clocks enable in Sleep mode register [dual core device only]
func (o *RCC_Type) SetC2APB2SMENR_TIM17SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB2SMENR.Reg, volatile.LoadUint32(&o.C2APB2SMENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetC2APB2SMENR_TIM17SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2SMENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetC2APB2SMENR_TIM16SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB2SMENR.Reg, volatile.LoadUint32(&o.C2APB2SMENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetC2APB2SMENR_TIM16SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2SMENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetC2APB2SMENR_USART1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB2SMENR.Reg, volatile.LoadUint32(&o.C2APB2SMENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetC2APB2SMENR_USART1SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2SMENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetC2APB2SMENR_SPI1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB2SMENR.Reg, volatile.LoadUint32(&o.C2APB2SMENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetC2APB2SMENR_SPI1SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2SMENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetC2APB2SMENR_TIM1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB2SMENR.Reg, volatile.LoadUint32(&o.C2APB2SMENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetC2APB2SMENR_TIM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2SMENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetC2APB2SMENR_ADCSMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB2SMENR.Reg, volatile.LoadUint32(&o.C2APB2SMENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetC2APB2SMENR_ADCSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2SMENR.Reg) & 0x200) >> 9
}

// RCC.C2APB3SMENR: CPU2 APB3 peripheral clock enable in Sleep mode register [dual core device only]
func (o *RCC_Type) SetC2APB3SMENR_SUBGHZSPISMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB3SMENR.Reg, volatile.LoadUint32(&o.C2APB3SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2APB3SMENR_SUBGHZSPISMEN() uint32 {
	return volatile.LoadUint32(&o.C2APB3SMENR.Reg) & 0x1
}

// True random number generator
type RNG_Type struct {
	CR   volatile.Register32 // 0x0
	SR   volatile.Register32 // 0x4
	DR   volatile.Register32 // 0x8
	_    [4]byte
	HTCR volatile.Register32 // 0x10
}

// RNG.CR: control register
func (o *RNG_Type) SetCR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetCR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *RNG_Type) SetCR_IE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RNG_Type) GetCR_IE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RNG_Type) SetCR_CED(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *RNG_Type) GetCR_CED() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *RNG_Type) SetCR_RNG_CONFIG3(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *RNG_Type) GetCR_RNG_CONFIG3() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *RNG_Type) SetCR_NISTC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RNG_Type) GetCR_NISTC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RNG_Type) SetCR_RNG_CONFIG2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xe000)|value<<13)
}
func (o *RNG_Type) GetCR_RNG_CONFIG2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xe000) >> 13
}
func (o *RNG_Type) SetCR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf0000)|value<<16)
}
func (o *RNG_Type) GetCR_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf0000) >> 16
}
func (o *RNG_Type) SetCR_RNG_CONFIG1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3f00000)|value<<20)
}
func (o *RNG_Type) GetCR_RNG_CONFIG1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3f00000) >> 20
}
func (o *RNG_Type) SetCR_CONDRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *RNG_Type) GetCR_CONDRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}
func (o *RNG_Type) SetCR_CONFIGLOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *RNG_Type) GetCR_CONFIGLOCK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}

// RNG.SR: status register
func (o *RNG_Type) SetSR_SEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *RNG_Type) GetSR_SEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *RNG_Type) SetSR_CEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *RNG_Type) GetSR_CEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *RNG_Type) SetSR_SECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetSR_SECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RNG_Type) SetSR_CECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RNG_Type) GetSR_CECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RNG_Type) SetSR_DRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetSR_DRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// RNG.DR: data register
func (o *RNG_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *RNG_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// RNG.HTCR: health test control register
func (o *RNG_Type) SetHTCR(value uint32) {
	volatile.StoreUint32(&o.HTCR.Reg, value)
}
func (o *RNG_Type) GetHTCR() uint32 {
	return volatile.LoadUint32(&o.HTCR.Reg)
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	SSR      volatile.Register32 // 0x8
	ICSR     volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	CR       volatile.Register32 // 0x18
	_        [8]byte
	WPR      volatile.Register32 // 0x24
	CALR     volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBR   volatile.Register32 // 0x48
	ALRMBSSR volatile.Register32 // 0x4C
	SR       volatile.Register32 // 0x50
	MISR     volatile.Register32 // 0x54
	_        [4]byte
	SCR      volatile.Register32 // 0x5C
	_        [16]byte
	ALRABINR volatile.Register32 // 0x70
	ALRBBINR volatile.Register32 // 0x74
}

// RTC.TR: Time register
func (o *RTC_Type) SetTR_PM(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTR_HT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTR_HU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTR_ST(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTR_SU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTR_SU() uint32 {
	return volatile.LoadUint32(&o.TR.Reg) & 0xf
}

// RTC.DR: Date register
func (o *RTC_Type) SetDR_YT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00000)|value<<20)
}
func (o *RTC_Type) GetDR_YT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00000) >> 20
}
func (o *RTC_Type) SetDR_YU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetDR_YU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetDR_WDU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetDR_MT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetDR_MT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetDR_MU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetDR_MU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetDR_DT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetDR_DT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetDR_DU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetDR_DU() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xf
}

// RTC.SSR: Sub second register
func (o *RTC_Type) SetSSR(value uint32) {
	volatile.StoreUint32(&o.SSR.Reg, value)
}
func (o *RTC_Type) GetSSR() uint32 {
	return volatile.LoadUint32(&o.SSR.Reg)
}

// RTC.ICSR: Initialization control and status register
func (o *RTC_Type) SetICSR_RECALPF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetICSR_RECALPF() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetICSR_BCDU(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x1c00)|value<<10)
}
func (o *RTC_Type) GetICSR_BCDU() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x1c00) >> 10
}
func (o *RTC_Type) SetICSR_BIN(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x300)|value<<8)
}
func (o *RTC_Type) GetICSR_BIN() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x300) >> 8
}
func (o *RTC_Type) SetICSR_INIT(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetICSR_INIT() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetICSR_INITF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetICSR_INITF() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetICSR_RSF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetICSR_RSF() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetICSR_INITS(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetICSR_INITS() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetICSR_SHPF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetICSR_SHPF() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetICSR_WUTWF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetICSR_WUTWF() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x4) >> 2
}

// RTC.PRER: Pre-scaler register
func (o *RTC_Type) SetPRER_PREDIV_A(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7f0000)|value<<16)
}
func (o *RTC_Type) GetPRER_PREDIV_A() uint32 {
	return (volatile.LoadUint32(&o.PRER.Reg) & 0x7f0000) >> 16
}
func (o *RTC_Type) SetPRER_PREDIV_S(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetPRER_PREDIV_S() uint32 {
	return volatile.LoadUint32(&o.PRER.Reg) & 0x7fff
}

// RTC.WUTR: Wakeup timer register
func (o *RTC_Type) SetWUTR_WUTOCLR(value uint32) {
	volatile.StoreUint32(&o.WUTR.Reg, volatile.LoadUint32(&o.WUTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *RTC_Type) GetWUTR_WUTOCLR() uint32 {
	return (volatile.LoadUint32(&o.WUTR.Reg) & 0xffff0000) >> 16
}
func (o *RTC_Type) SetWUTR_WUT(value uint32) {
	volatile.StoreUint32(&o.WUTR.Reg, volatile.LoadUint32(&o.WUTR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetWUTR_WUT() uint32 {
	return volatile.LoadUint32(&o.WUTR.Reg) & 0xffff
}

// RTC.CR: Control register
func (o *RTC_Type) SetCR_OUT2EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetCR_OUT2EN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetCR_TAMPALRM_TYPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetCR_TAMPALRM_TYPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetCR_TAMPALRM_PU(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_Type) GetCR_TAMPALRM_PU() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *RTC_Type) SetCR_TAMPOE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_Type) GetCR_TAMPOE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *RTC_Type) SetCR_TAMPTS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_Type) GetCR_TAMPTS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *RTC_Type) SetCR_ITSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_Type) GetCR_ITSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *RTC_Type) SetCR_COE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetCR_COE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetCR_OSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *RTC_Type) GetCR_OSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *RTC_Type) SetCR_POL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetCR_POL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetCR_COSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetCR_COSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RTC_Type) SetCR_BKP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetCR_BKP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetCR_SUB1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetCR_SUB1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetCR_ADD1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetCR_ADD1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetCR_TSIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCR_TSIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCR_WUTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCR_WUTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCR_ALRBIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCR_ALRBIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCR_ALRAIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetCR_ALRAIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetCR_TSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetCR_TSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetCR_WUTE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetCR_WUTE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetCR_ALRBE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetCR_ALRBE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetCR_ALRAE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetCR_ALRAE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetCR_SSRUIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetCR_SSRUIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetCR_FMT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetCR_FMT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetCR_BYPSHAD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetCR_BYPSHAD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetCR_REFCKON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCR_REFCKON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCR_TSEDGE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCR_TSEDGE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCR_WUCKSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetCR_WUCKSEL() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7
}

// RTC.WPR: Write protection register
func (o *RTC_Type) SetWPR_KEY(value uint32) {
	volatile.StoreUint32(&o.WPR.Reg, volatile.LoadUint32(&o.WPR.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetWPR_KEY() uint32 {
	return volatile.LoadUint32(&o.WPR.Reg) & 0xff
}

// RTC.CALR: Calibration register
func (o *RTC_Type) SetCALR_CALP(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCALR_CALP() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCALR_CALW8(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCALR_CALW8() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCALR_CALW16(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCALR_CALW16() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCALR_LPCAL(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetCALR_LPCAL() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetCALR_CALM(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x1ff)|value)
}
func (o *RTC_Type) GetCALR_CALM() uint32 {
	return volatile.LoadUint32(&o.CALR.Reg) & 0x1ff
}

// RTC.SHIFTR: Shift control register
func (o *RTC_Type) SetSHIFTR_ADD1S(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSHIFTR_ADD1S() uint32 {
	return (volatile.LoadUint32(&o.SHIFTR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetSHIFTR_SUBFS(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetSHIFTR_SUBFS() uint32 {
	return volatile.LoadUint32(&o.SHIFTR.Reg) & 0x7fff
}

// RTC.TSTR: Timestamp time register
func (o *RTC_Type) SetTSTR_PM(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTSTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTSTR_HT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTSTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTSTR_HU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTSTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTSTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTSTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTSTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSTR_ST(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTSTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTSTR_SU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSTR_SU() uint32 {
	return volatile.LoadUint32(&o.TSTR.Reg) & 0xf
}

// RTC.TSDR: Timestamp date register
func (o *RTC_Type) SetTSDR_WDU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetTSDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetTSDR_MT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetTSDR_MT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetTSDR_MU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSDR_MU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSDR_DT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetTSDR_DT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetTSDR_DU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSDR_DU() uint32 {
	return volatile.LoadUint32(&o.TSDR.Reg) & 0xf
}

// RTC.TSSSR: Timestamp sub second register
func (o *RTC_Type) SetTSSSR(value uint32) {
	volatile.StoreUint32(&o.TSSSR.Reg, value)
}
func (o *RTC_Type) GetTSSSR() uint32 {
	return volatile.LoadUint32(&o.TSSSR.Reg)
}

// RTC.ALRMAR: Alarm A register
func (o *RTC_Type) SetALRMAR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMAR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMAR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMAR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMAR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMAR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMAR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMAR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMAR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMAR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMAR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMAR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMAR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMAR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMAR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMAR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMAR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMAR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMAR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMAR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMAR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMAR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMAR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMAR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMAR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMAR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMAR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMAR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf
}

// RTC.ALRMASSR: Alarm A sub second register
func (o *RTC_Type) SetALRMASSR_SSCLR(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMASSR_SSCLR() uint32 {
	return (volatile.LoadUint32(&o.ALRMASSR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMASSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0x3f000000)|value<<24)
}
func (o *RTC_Type) GetALRMASSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMASSR.Reg) & 0x3f000000) >> 24
}
func (o *RTC_Type) SetALRMASSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMASSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMASSR.Reg) & 0x7fff
}

// RTC.ALRMBR: Alarm B register
func (o *RTC_Type) SetALRMBR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMBR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMBR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMBR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMBR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMBR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMBR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMBR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMBR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMBR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMBR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMBR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMBR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMBR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMBR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMBR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMBR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMBR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMBR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMBR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMBR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMBR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMBR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMBR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMBR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMBR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf
}

// RTC.ALRMBSSR: Alarm B sub second register
func (o *RTC_Type) SetALRMBSSR_SSCLR(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMBSSR_SSCLR() uint32 {
	return (volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMBSSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0x3f000000)|value<<24)
}
func (o *RTC_Type) GetALRMBSSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0x3f000000) >> 24
}
func (o *RTC_Type) SetALRMBSSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMBSSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0x7fff
}

// RTC.SR: Status register (interrupts)
func (o *RTC_Type) SetSR_SSRUF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetSR_SSRUF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetSR_ITSF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetSR_ITSF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetSR_TSOVF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetSR_TSOVF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetSR_TSF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetSR_TSF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetSR_WUTF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetSR_WUTF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetSR_ALRBF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetSR_ALRBF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetSR_ALRAF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetSR_ALRAF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// RTC.MISR: Masked interrupt status register
func (o *RTC_Type) SetMISR_SSRUMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetMISR_SSRUMF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetMISR_ITSMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetMISR_ITSMF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetMISR_TSOVMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetMISR_TSOVMF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetMISR_TSMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetMISR_TSMF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetMISR_WUTMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetMISR_WUTMF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetMISR_ALRBMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetMISR_ALRBMF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetMISR_ALRAMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetMISR_ALRAMF() uint32 {
	return volatile.LoadUint32(&o.MISR.Reg) & 0x1
}

// RTC.SCR: Status clear register (interrupts)
func (o *RTC_Type) SetSCR_CSSRUF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetSCR_CSSRUF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetSCR_CITSF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetSCR_CITSF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetSCR_CTSOVF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetSCR_CTSOVF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetSCR_CTSF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetSCR_CTSF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetSCR_CWUTF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetSCR_CWUTF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetSCR_CALRBF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetSCR_CALRBF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetSCR_CALRAF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetSCR_CALRAF() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0x1
}

// RTC.ALRABINR: RTC alarm A binary mode register
func (o *RTC_Type) SetALRABINR(value uint32) {
	volatile.StoreUint32(&o.ALRABINR.Reg, value)
}
func (o *RTC_Type) GetALRABINR() uint32 {
	return volatile.LoadUint32(&o.ALRABINR.Reg)
}

// RTC.ALRBBINR: RTC alarm B binary mode register
func (o *RTC_Type) SetALRBBINR(value uint32) {
	volatile.StoreUint32(&o.ALRBBINR.Reg, value)
}
func (o *RTC_Type) GetALRBBINR() uint32 {
	return volatile.LoadUint32(&o.ALRBBINR.Reg)
}

// System control block
type SCB_Type struct {
	CPUID                volatile.Register32 // 0x0
	ICSR                 volatile.Register32 // 0x4
	VTOR                 volatile.Register32 // 0x8
	AIRCR                volatile.Register32 // 0xC
	SCR                  volatile.Register32 // 0x10
	CCR                  volatile.Register32 // 0x14
	SHPR1                volatile.Register32 // 0x18
	SHPR2                volatile.Register32 // 0x1C
	SHPR3                volatile.Register32 // 0x20
	SHCSR                volatile.Register32 // 0x24
	CFSR_UFSR_BFSR_MMFSR volatile.Register32 // 0x28
	HFSR                 volatile.Register32 // 0x2C
	_                    [4]byte
	MMFAR                volatile.Register32 // 0x34
	BFAR                 volatile.Register32 // 0x38
	AFSR                 volatile.Register32 // 0x3C
}

// SCB.CPUID: CPUID base register
func (o *SCB_Type) SetCPUID_Revision(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf)|value)
}
func (o *SCB_Type) GetCPUID_Revision() uint32 {
	return volatile.LoadUint32(&o.CPUID.Reg) & 0xf
}
func (o *SCB_Type) SetCPUID_PartNo(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xfff0)|value<<4)
}
func (o *SCB_Type) GetCPUID_PartNo() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xfff0) >> 4
}
func (o *SCB_Type) SetCPUID_Constant(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf0000)|value<<16)
}
func (o *SCB_Type) GetCPUID_Constant() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xf0000) >> 16
}
func (o *SCB_Type) SetCPUID_Variant(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf00000)|value<<20)
}
func (o *SCB_Type) GetCPUID_Variant() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xf00000) >> 20
}
func (o *SCB_Type) SetCPUID_Implementer(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetCPUID_Implementer() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xff000000) >> 24
}

// SCB.ICSR: Interrupt control and state register
func (o *SCB_Type) SetICSR_VECTACTIVE(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x1ff)|value)
}
func (o *SCB_Type) GetICSR_VECTACTIVE() uint32 {
	return volatile.LoadUint32(&o.ICSR.Reg) & 0x1ff
}
func (o *SCB_Type) SetICSR_RETTOBASE(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetICSR_RETTOBASE() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetICSR_VECTPENDING(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x7f000)|value<<12)
}
func (o *SCB_Type) GetICSR_VECTPENDING() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x7f000) >> 12
}
func (o *SCB_Type) SetICSR_ISRPENDING(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x400000)|value<<22)
}
func (o *SCB_Type) GetICSR_ISRPENDING() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x400000) >> 22
}
func (o *SCB_Type) SetICSR_PENDSTCLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x2000000)|value<<25)
}
func (o *SCB_Type) GetICSR_PENDSTCLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x2000000) >> 25
}
func (o *SCB_Type) SetICSR_PENDSTSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x4000000)|value<<26)
}
func (o *SCB_Type) GetICSR_PENDSTSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x4000000) >> 26
}
func (o *SCB_Type) SetICSR_PENDSVCLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x8000000)|value<<27)
}
func (o *SCB_Type) GetICSR_PENDSVCLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x8000000) >> 27
}
func (o *SCB_Type) SetICSR_PENDSVSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x10000000)|value<<28)
}
func (o *SCB_Type) GetICSR_PENDSVSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x10000000) >> 28
}
func (o *SCB_Type) SetICSR_NMIPENDSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x80000000)|value<<31)
}
func (o *SCB_Type) GetICSR_NMIPENDSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x80000000) >> 31
}

// SCB.VTOR: Vector table offset register
func (o *SCB_Type) SetVTOR_TBLOFF(value uint32) {
	volatile.StoreUint32(&o.VTOR.Reg, volatile.LoadUint32(&o.VTOR.Reg)&^(0x3ffffe00)|value<<9)
}
func (o *SCB_Type) GetVTOR_TBLOFF() uint32 {
	return (volatile.LoadUint32(&o.VTOR.Reg) & 0x3ffffe00) >> 9
}

// SCB.AIRCR: Application interrupt and reset control register
func (o *SCB_Type) SetAIRCR_VECTRESET(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetAIRCR_VECTRESET() uint32 {
	return volatile.LoadUint32(&o.AIRCR.Reg) & 0x1
}
func (o *SCB_Type) SetAIRCR_VECTCLRACTIVE(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetAIRCR_VECTCLRACTIVE() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetAIRCR_SYSRESETREQ(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetAIRCR_SYSRESETREQ() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetAIRCR_PRIGROUP(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x700)|value<<8)
}
func (o *SCB_Type) GetAIRCR_PRIGROUP() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x700) >> 8
}
func (o *SCB_Type) SetAIRCR_ENDIANESS(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetAIRCR_ENDIANESS() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetAIRCR_VECTKEYSTAT(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCB_Type) GetAIRCR_VECTKEYSTAT() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0xffff0000) >> 16
}

// SCB.SCR: System control register
func (o *SCB_Type) SetSCR_SLEEPONEXIT(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetSCR_SLEEPONEXIT() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetSCR_SLEEPDEEP(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetSCR_SLEEPDEEP() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetSCR_SEVEONPEND(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetSCR_SEVEONPEND() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}

// SCB.CCR: Configuration and control register
func (o *SCB_Type) SetCCR_NONBASETHRDENA(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetCCR_NONBASETHRDENA() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1
}
func (o *SCB_Type) SetCCR_USERSETMPEND(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetCCR_USERSETMPEND() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetCCR_UNALIGN__TRP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetCCR_UNALIGN__TRP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetCCR_DIV_0_TRP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetCCR_DIV_0_TRP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10) >> 4
}
func (o *SCB_Type) SetCCR_BFHFNMIGN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetCCR_BFHFNMIGN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetCCR_STKALIGN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x200)|value<<9)
}
func (o *SCB_Type) GetCCR_STKALIGN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x200) >> 9
}

// SCB.SHPR1: System handler priority registers
func (o *SCB_Type) SetSHPR1_PRI_4(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff)|value)
}
func (o *SCB_Type) GetSHPR1_PRI_4() uint32 {
	return volatile.LoadUint32(&o.SHPR1.Reg) & 0xff
}
func (o *SCB_Type) SetSHPR1_PRI_5(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff00)|value<<8)
}
func (o *SCB_Type) GetSHPR1_PRI_5() uint32 {
	return (volatile.LoadUint32(&o.SHPR1.Reg) & 0xff00) >> 8
}
func (o *SCB_Type) SetSHPR1_PRI_6(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *SCB_Type) GetSHPR1_PRI_6() uint32 {
	return (volatile.LoadUint32(&o.SHPR1.Reg) & 0xff0000) >> 16
}

// SCB.SHPR2: System handler priority registers
func (o *SCB_Type) SetSHPR2_PRI_11(value uint32) {
	volatile.StoreUint32(&o.SHPR2.Reg, volatile.LoadUint32(&o.SHPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetSHPR2_PRI_11() uint32 {
	return (volatile.LoadUint32(&o.SHPR2.Reg) & 0xff000000) >> 24
}

// SCB.SHPR3: System handler priority registers
func (o *SCB_Type) SetSHPR3_PRI_14(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *SCB_Type) GetSHPR3_PRI_14() uint32 {
	return (volatile.LoadUint32(&o.SHPR3.Reg) & 0xff0000) >> 16
}
func (o *SCB_Type) SetSHPR3_PRI_15(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetSHPR3_PRI_15() uint32 {
	return (volatile.LoadUint32(&o.SHPR3.Reg) & 0xff000000) >> 24
}

// SCB.SHCSR: System handler control and state register
func (o *SCB_Type) SetSHCSR_MEMFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetSHCSR_MEMFAULTACT() uint32 {
	return volatile.LoadUint32(&o.SHCSR.Reg) & 0x1
}
func (o *SCB_Type) SetSHCSR_BUSFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetSHCSR_BUSFAULTACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetSHCSR_USGFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetSHCSR_USGFAULTACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetSHCSR_SVCALLACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x80)|value<<7)
}
func (o *SCB_Type) GetSHCSR_SVCALLACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x80) >> 7
}
func (o *SCB_Type) SetSHCSR_MONITORACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetSHCSR_MONITORACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetSHCSR_PENDSVACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x400)|value<<10)
}
func (o *SCB_Type) GetSHCSR_PENDSVACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x400) >> 10
}
func (o *SCB_Type) SetSHCSR_SYSTICKACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetSHCSR_SYSTICKACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetSHCSR_USGFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x1000)|value<<12)
}
func (o *SCB_Type) GetSHCSR_USGFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x1000) >> 12
}
func (o *SCB_Type) SetSHCSR_MEMFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x2000)|value<<13)
}
func (o *SCB_Type) GetSHCSR_MEMFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x2000) >> 13
}
func (o *SCB_Type) SetSHCSR_BUSFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x4000)|value<<14)
}
func (o *SCB_Type) GetSHCSR_BUSFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x4000) >> 14
}
func (o *SCB_Type) SetSHCSR_SVCALLPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetSHCSR_SVCALLPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetSHCSR_MEMFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x10000)|value<<16)
}
func (o *SCB_Type) GetSHCSR_MEMFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x10000) >> 16
}
func (o *SCB_Type) SetSHCSR_BUSFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x20000)|value<<17)
}
func (o *SCB_Type) GetSHCSR_BUSFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x20000) >> 17
}
func (o *SCB_Type) SetSHCSR_USGFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x40000)|value<<18)
}
func (o *SCB_Type) GetSHCSR_USGFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x40000) >> 18
}

// SCB.CFSR_UFSR_BFSR_MMFSR: Configurable fault status register
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_IACCVIOL(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_IACCVIOL() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MUNSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MUNSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x10) >> 4
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MLSPERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x20)|value<<5)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MLSPERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x20) >> 5
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MMARVALID(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x80)|value<<7)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MMARVALID() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x80) >> 7
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_IBUSERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_IBUSERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_PRECISERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x200)|value<<9)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_PRECISERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x200) >> 9
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_IMPRECISERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x400)|value<<10)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_IMPRECISERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x400) >> 10
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_UNSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_UNSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_STKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x1000)|value<<12)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_STKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x1000) >> 12
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_LSPERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x2000)|value<<13)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_LSPERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x2000) >> 13
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_BFARVALID(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_BFARVALID() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_UNDEFINSTR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x10000)|value<<16)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_UNDEFINSTR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x10000) >> 16
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_INVSTATE(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x20000)|value<<17)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_INVSTATE() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x20000) >> 17
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_INVPC(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x40000)|value<<18)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_INVPC() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x40000) >> 18
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_NOCP(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x80000)|value<<19)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_NOCP() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x80000) >> 19
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_UNALIGNED(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_UNALIGNED() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x1000000) >> 24
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_DIVBYZERO(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_DIVBYZERO() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x2000000) >> 25
}

// SCB.HFSR: Hard fault status register
func (o *SCB_Type) SetHFSR_VECTTBL(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetHFSR_VECTTBL() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetHFSR_FORCED(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *SCB_Type) GetHFSR_FORCED() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x40000000) >> 30
}
func (o *SCB_Type) SetHFSR_DEBUG_VT(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *SCB_Type) GetHFSR_DEBUG_VT() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x80000000) >> 31
}

// SCB.MMFAR: Memory management fault address register
func (o *SCB_Type) SetMMFAR(value uint32) {
	volatile.StoreUint32(&o.MMFAR.Reg, value)
}
func (o *SCB_Type) GetMMFAR() uint32 {
	return volatile.LoadUint32(&o.MMFAR.Reg)
}

// SCB.BFAR: Bus fault address register
func (o *SCB_Type) SetBFAR(value uint32) {
	volatile.StoreUint32(&o.BFAR.Reg, value)
}
func (o *SCB_Type) GetBFAR() uint32 {
	return volatile.LoadUint32(&o.BFAR.Reg)
}

// SCB.AFSR: Auxiliary fault status register
func (o *SCB_Type) SetAFSR(value uint32) {
	volatile.StoreUint32(&o.AFSR.Reg, value)
}
func (o *SCB_Type) GetAFSR() uint32 {
	return volatile.LoadUint32(&o.AFSR.Reg)
}

// Serial peripheral interface/Inter-IC sound
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// SPI.CR1: control register 1
func (o *SPI_Type) SetCR1_BIDIMODE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetCR1_BIDIMODE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *SPI_Type) SetCR1_BIDIOE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR1_BIDIOE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *SPI_Type) SetCR1_CRCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR1_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR1_CRCNEXT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR1_CRCNEXT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR1_CRCL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetCR1_CRCL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetCR1_RXONLY(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetCR1_RXONLY() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetCR1_SSM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetCR1_SSM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetCR1_SSI(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetCR1_SSI() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetCR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR1_SPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR1_SPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR1_BR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x38)|value<<3)
}
func (o *SPI_Type) GetCR1_BR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x38) >> 3
}
func (o *SPI_Type) SetCR1_MSTR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR1_MSTR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR1_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR1_CPHA() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// SPI.CR2: control register 2
func (o *SPI_Type) SetCR2_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR2_RXDMAEN() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *SPI_Type) SetCR2_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR2_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR2_SSOE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR2_SSOE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR2_NSSP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCR2_NSSP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCR2_FRF(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetCR2_FRF() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetCR2_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetCR2_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetCR2_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR2_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR2_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR2_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR2_DS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetCR2_DS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetCR2_FRXTH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR2_FRXTH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR2_LDMA_RX(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR2_LDMA_RX() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR2_LDMA_TX(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR2_LDMA_TX() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}

// SPI.SR: status register
func (o *SPI_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RXNE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SPI_Type) SetSR_TXE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TXE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_CHSIDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_CHSIDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_UDR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_UDR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_CRCERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetSR_CRCERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetSR_FRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_FRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_FRLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x600)|value<<9)
}
func (o *SPI_Type) GetSR_FRLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x600) >> 9
}
func (o *SPI_Type) SetSR_FTLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1800)|value<<11)
}
func (o *SPI_Type) GetSR_FTLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1800) >> 11
}

// SPI.DR: data register
func (o *SPI_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// SPI.CRCPR: CRC polynomial register
func (o *SPI_Type) SetCRCPR_CRCPOLY(value uint32) {
	volatile.StoreUint32(&o.CRCPR.Reg, volatile.LoadUint32(&o.CRCPR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetCRCPR_CRCPOLY() uint32 {
	return volatile.LoadUint32(&o.CRCPR.Reg) & 0xffff
}

// SPI.RXCRCR: RX CRC register
func (o *SPI_Type) SetRXCRCR_RxCRC(value uint32) {
	volatile.StoreUint32(&o.RXCRCR.Reg, volatile.LoadUint32(&o.RXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRXCRCR_RxCRC() uint32 {
	return volatile.LoadUint32(&o.RXCRCR.Reg) & 0xffff
}

// SPI.TXCRCR: TX CRC register
func (o *SPI_Type) SetTXCRCR_TxCRC(value uint32) {
	volatile.StoreUint32(&o.TXCRCR.Reg, volatile.LoadUint32(&o.TXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXCRCR_TxCRC() uint32 {
	return volatile.LoadUint32(&o.TXCRCR.Reg) & 0xffff
}

// SPI.I2SCFGR: configuration register
func (o *SPI_Type) SetI2SCFGR_CHLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetI2SCFGR_CHLEN() uint32 {
	return volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x1
}
func (o *SPI_Type) SetI2SCFGR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x6)|value<<1)
}
func (o *SPI_Type) GetI2SCFGR_DATLEN() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x6) >> 1
}
func (o *SPI_Type) SetI2SCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetI2SCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetI2SCFGR_I2SSTD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x30)|value<<4)
}
func (o *SPI_Type) GetI2SCFGR_I2SSTD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x30) >> 4
}
func (o *SPI_Type) SetI2SCFGR_PCMSYNC(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetI2SCFGR_PCMSYNC() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetI2SCFGR_I2SCFG(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x300)|value<<8)
}
func (o *SPI_Type) GetI2SCFGR_I2SCFG() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x300) >> 8
}
func (o *SPI_Type) SetI2SCFGR_I2SE(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetI2SCFGR_I2SE() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetI2SCFGR_I2SMOD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetI2SCFGR_I2SMOD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetI2SCFGR_ASTRTEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetI2SCFGR_ASTRTEN() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x1000) >> 12
}

// SPI.I2SPR: prescaler register
func (o *SPI_Type) SetI2SPR_I2SDIV(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0xff)|value)
}
func (o *SPI_Type) GetI2SPR_I2SDIV() uint32 {
	return volatile.LoadUint32(&o.I2SPR.Reg) & 0xff
}
func (o *SPI_Type) SetI2SPR_ODD(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetI2SPR_ODD() uint32 {
	return (volatile.LoadUint32(&o.I2SPR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetI2SPR_MCKOE(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetI2SPR_MCKOE() uint32 {
	return (volatile.LoadUint32(&o.I2SPR.Reg) & 0x200) >> 9
}

// SysTick timer
type STK_Type struct {
	CTRL  volatile.Register32 // 0x0
	LOAD  volatile.Register32 // 0x4
	VAL   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// STK.CTRL: SysTick control and status register
func (o *STK_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *STK_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *STK_Type) SetCTRL_TICKINT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *STK_Type) GetCTRL_TICKINT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *STK_Type) SetCTRL_CLKSOURCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *STK_Type) GetCTRL_CLKSOURCE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *STK_Type) SetCTRL_COUNTFLAG(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *STK_Type) GetCTRL_COUNTFLAG() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}

// STK.LOAD: SysTick reload value register
func (o *STK_Type) SetLOAD_RELOAD(value uint32) {
	volatile.StoreUint32(&o.LOAD.Reg, volatile.LoadUint32(&o.LOAD.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetLOAD_RELOAD() uint32 {
	return volatile.LoadUint32(&o.LOAD.Reg) & 0xffffff
}

// STK.VAL: SysTick current value register
func (o *STK_Type) SetVAL_CURRENT(value uint32) {
	volatile.StoreUint32(&o.VAL.Reg, volatile.LoadUint32(&o.VAL.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetVAL_CURRENT() uint32 {
	return volatile.LoadUint32(&o.VAL.Reg) & 0xffffff
}

// STK.CALIB: SysTick calibration value register
func (o *STK_Type) SetCALIB_TENMS(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetCALIB_TENMS() uint32 {
	return volatile.LoadUint32(&o.CALIB.Reg) & 0xffffff
}
func (o *STK_Type) SetCALIB_SKEW(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x40000000)|value<<30)
}
func (o *STK_Type) GetCALIB_SKEW() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x40000000) >> 30
}
func (o *STK_Type) SetCALIB_NOREF(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x80000000)|value<<31)
}
func (o *STK_Type) GetCALIB_NOREF() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x80000000) >> 31
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRMP  volatile.Register32 // 0x0
	CFGR1   volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	SCSR    volatile.Register32 // 0x18
	CFGR2   volatile.Register32 // 0x1C
	SWPR    volatile.Register32 // 0x20
	SKR     volatile.Register32 // 0x24
	_       [216]byte
	IMR1    volatile.Register32 // 0x100
	IMR2    volatile.Register32 // 0x104
	C2IMR1  volatile.Register32 // 0x108
	C2IMR2  volatile.Register32 // 0x10C
	_       [248]byte
	RFDCR   volatile.Register32 // 0x208
}

// SYSCFG.MEMRMP: memory remap register
func (o *SYSCFG_Type) SetMEMRMP_MEM_MODE(value uint32) {
	volatile.StoreUint32(&o.MEMRMP.Reg, volatile.LoadUint32(&o.MEMRMP.Reg)&^(0x7)|value)
}
func (o *SYSCFG_Type) GetMEMRMP_MEM_MODE() uint32 {
	return volatile.LoadUint32(&o.MEMRMP.Reg) & 0x7
}

// SYSCFG.CFGR1: configuration register 1
func (o *SYSCFG_Type) SetCFGR1_I2C3_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCFG_Type) GetCFGR1_I2C3_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x400000) >> 22
}
func (o *SYSCFG_Type) SetCFGR1_I2C2_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCFG_Type) GetCFGR1_I2C2_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x200000) >> 21
}
func (o *SYSCFG_Type) SetCFGR1_I2C1_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCFG_Type) GetCFGR1_I2C1_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x100000) >> 20
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB9_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB9_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x80000) >> 19
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB8_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB8_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x40000) >> 18
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB7_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB7_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x20000) >> 17
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB6_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB6_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x10000) >> 16
}
func (o *SYSCFG_Type) SetCFGR1_BOOSTEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetCFGR1_BOOSTEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x100) >> 8
}

// SYSCFG.EXTICR1: external interrupt configuration register 1
func (o *SYSCFG_Type) SetEXTICR1_EXTI3(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0x7000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI3() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0x7000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI2(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0x700)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI2() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0x700) >> 8
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI1(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0x70)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI1() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0x70) >> 4
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI0(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0x7)|value)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI0() uint32 {
	return volatile.LoadUint32(&o.EXTICR1.Reg) & 0x7
}

// SYSCFG.EXTICR2: external interrupt configuration register 2
func (o *SYSCFG_Type) SetEXTICR2_EXTI7(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0x7000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI7() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0x7000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI6(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0x700)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI6() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0x700) >> 8
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI5(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0x70)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI5() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0x70) >> 4
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI4(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0x7)|value)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI4() uint32 {
	return volatile.LoadUint32(&o.EXTICR2.Reg) & 0x7
}

// SYSCFG.EXTICR3: external interrupt configuration register 3
func (o *SYSCFG_Type) SetEXTICR3_EXTI11(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0x7000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI11() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0x7000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI10(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0x700)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI10() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0x700) >> 8
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI9(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0x70)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI9() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0x70) >> 4
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI8(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0x7)|value)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI8() uint32 {
	return volatile.LoadUint32(&o.EXTICR3.Reg) & 0x7
}

// SYSCFG.EXTICR4: external interrupt configuration register 4
func (o *SYSCFG_Type) SetEXTICR4_EXTI15(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0x7000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0x7000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI14(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0x700)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI14() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0x700) >> 8
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI13(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0x70)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI13() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0x70) >> 4
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI12(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0x7)|value)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI12() uint32 {
	return volatile.LoadUint32(&o.EXTICR4.Reg) & 0x7
}

// SYSCFG.SCSR: SCSR
func (o *SYSCFG_Type) SetSCSR_PKASRAMBSY(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetSCSR_PKASRAMBSY() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetSCSR_SRAMBSY(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetSCSR_SRAMBSY() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetSCSR_SRAM2ER(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetSCSR_SRAM2ER() uint32 {
	return volatile.LoadUint32(&o.SCSR.Reg) & 0x1
}

// SYSCFG.CFGR2: CFGR2
func (o *SYSCFG_Type) SetCFGR2_SPF(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetCFGR2_SPF() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetCFGR2_ECCL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x8)|value<<3)
}
func (o *SYSCFG_Type) GetCFGR2_ECCL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x8) >> 3
}
func (o *SYSCFG_Type) SetCFGR2_PVDL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetCFGR2_PVDL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x4) >> 2
}
func (o *SYSCFG_Type) SetCFGR2_SPL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetCFGR2_SPL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetCFGR2_CLL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetCFGR2_CLL() uint32 {
	return volatile.LoadUint32(&o.CFGR2.Reg) & 0x1
}

// SYSCFG.SWPR: SWPR
func (o *SYSCFG_Type) SetSWPR_P31WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCFG_Type) GetSWPR_P31WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x80000000) >> 31
}
func (o *SYSCFG_Type) SetSWPR_P30WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSCFG_Type) GetSWPR_P30WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x40000000) >> 30
}
func (o *SYSCFG_Type) SetSWPR_P29WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSCFG_Type) GetSWPR_P29WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x20000000) >> 29
}
func (o *SYSCFG_Type) SetSWPR_P28WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSCFG_Type) GetSWPR_P28WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x10000000) >> 28
}
func (o *SYSCFG_Type) SetSWPR_P27WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSCFG_Type) GetSWPR_P27WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x8000000) >> 27
}
func (o *SYSCFG_Type) SetSWPR_P26WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSCFG_Type) GetSWPR_P26WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x4000000) >> 26
}
func (o *SYSCFG_Type) SetSWPR_P25WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSCFG_Type) GetSWPR_P25WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x2000000) >> 25
}
func (o *SYSCFG_Type) SetSWPR_P24WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCFG_Type) GetSWPR_P24WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x1000000) >> 24
}
func (o *SYSCFG_Type) SetSWPR_P23WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCFG_Type) GetSWPR_P23WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x800000) >> 23
}
func (o *SYSCFG_Type) SetSWPR_P22WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCFG_Type) GetSWPR_P22WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x400000) >> 22
}
func (o *SYSCFG_Type) SetSWPR_P21WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCFG_Type) GetSWPR_P21WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x200000) >> 21
}
func (o *SYSCFG_Type) SetSWPR_P20WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCFG_Type) GetSWPR_P20WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x100000) >> 20
}
func (o *SYSCFG_Type) SetSWPR_P19WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCFG_Type) GetSWPR_P19WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x80000) >> 19
}
func (o *SYSCFG_Type) SetSWPR_P18WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCFG_Type) GetSWPR_P18WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x40000) >> 18
}
func (o *SYSCFG_Type) SetSWPR_P17WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCFG_Type) GetSWPR_P17WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x20000) >> 17
}
func (o *SYSCFG_Type) SetSWPR_P16WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetSWPR_P16WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x10000) >> 16
}
func (o *SYSCFG_Type) SetSWPR_P15WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCFG_Type) GetSWPR_P15WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x8000) >> 15
}
func (o *SYSCFG_Type) SetSWPR_P14WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCFG_Type) GetSWPR_P14WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x4000) >> 14
}
func (o *SYSCFG_Type) SetSWPR_P13WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCFG_Type) GetSWPR_P13WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x2000) >> 13
}
func (o *SYSCFG_Type) SetSWPR_P12WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCFG_Type) GetSWPR_P12WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x1000) >> 12
}
func (o *SYSCFG_Type) SetSWPR_P11WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x800)|value<<11)
}
func (o *SYSCFG_Type) GetSWPR_P11WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x800) >> 11
}
func (o *SYSCFG_Type) SetSWPR_P10WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x400)|value<<10)
}
func (o *SYSCFG_Type) GetSWPR_P10WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x400) >> 10
}
func (o *SYSCFG_Type) SetSWPR_P9WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x200)|value<<9)
}
func (o *SYSCFG_Type) GetSWPR_P9WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x200) >> 9
}
func (o *SYSCFG_Type) SetSWPR_P8WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetSWPR_P8WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetSWPR_P7WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x80)|value<<7)
}
func (o *SYSCFG_Type) GetSWPR_P7WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x80) >> 7
}
func (o *SYSCFG_Type) SetSWPR_P6WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x40)|value<<6)
}
func (o *SYSCFG_Type) GetSWPR_P6WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x40) >> 6
}
func (o *SYSCFG_Type) SetSWPR_P5WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x20)|value<<5)
}
func (o *SYSCFG_Type) GetSWPR_P5WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x20) >> 5
}
func (o *SYSCFG_Type) SetSWPR_P4WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x10)|value<<4)
}
func (o *SYSCFG_Type) GetSWPR_P4WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x10) >> 4
}
func (o *SYSCFG_Type) SetSWPR_P3WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x8)|value<<3)
}
func (o *SYSCFG_Type) GetSWPR_P3WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x8) >> 3
}
func (o *SYSCFG_Type) SetSWPR_P2WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetSWPR_P2WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x4) >> 2
}
func (o *SYSCFG_Type) SetSWPR_P1WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetSWPR_P1WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetSWPR_P0WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetSWPR_P0WP() uint32 {
	return volatile.LoadUint32(&o.SWPR.Reg) & 0x1
}

// SYSCFG.SKR: SKR
func (o *SYSCFG_Type) SetSKR_KEY(value uint32) {
	volatile.StoreUint32(&o.SKR.Reg, volatile.LoadUint32(&o.SKR.Reg)&^(0xff)|value)
}
func (o *SYSCFG_Type) GetSKR_KEY() uint32 {
	return volatile.LoadUint32(&o.SKR.Reg) & 0xff
}

// SYSCFG.IMR1: SYSCFG CPU1 interrupt mask register 1
func (o *SYSCFG_Type) SetIMR1_RTCSTAMPTAMPLSECSSIM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetIMR1_RTCSTAMPTAMPLSECSSIM() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *SYSCFG_Type) SetIMR1_RTCSSRUIM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetIMR1_RTCSSRUIM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *SYSCFG_Type) SetIMR1_EXTI5IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCFG_Type) GetIMR1_EXTI5IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x200000) >> 21
}
func (o *SYSCFG_Type) SetIMR1_EXTI6IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCFG_Type) GetIMR1_EXTI6IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x400000) >> 22
}
func (o *SYSCFG_Type) SetIMR1_EXTI7IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCFG_Type) GetIMR1_EXTI7IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x800000) >> 23
}
func (o *SYSCFG_Type) SetIMR1_EXTI8IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCFG_Type) GetIMR1_EXTI8IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x1000000) >> 24
}
func (o *SYSCFG_Type) SetIMR1_EXTI9IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSCFG_Type) GetIMR1_EXTI9IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2000000) >> 25
}
func (o *SYSCFG_Type) SetIMR1_EXTI10IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSCFG_Type) GetIMR1_EXTI10IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4000000) >> 26
}
func (o *SYSCFG_Type) SetIMR1_EXTI11IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSCFG_Type) GetIMR1_EXTI11IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8000000) >> 27
}
func (o *SYSCFG_Type) SetIMR1_EXTI12IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSCFG_Type) GetIMR1_EXTI12IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000000) >> 28
}
func (o *SYSCFG_Type) SetIMR1_EXTI13IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSCFG_Type) GetIMR1_EXTI13IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000000) >> 29
}
func (o *SYSCFG_Type) SetIMR1_EXTI14IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSCFG_Type) GetIMR1_EXTI14IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000000) >> 30
}
func (o *SYSCFG_Type) SetIMR1_EXTI15IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCFG_Type) GetIMR1_EXTI15IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000000) >> 31
}

// SYSCFG.IMR2: SYSCFG CPU1 interrupt mask register 2
func (o *SYSCFG_Type) SetIMR2_PVM3IM(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCFG_Type) GetIMR2_PVM3IM() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40000) >> 18
}
func (o *SYSCFG_Type) SetIMR2_PVDIM(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCFG_Type) GetIMR2_PVDIM() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x100000) >> 20
}

// SYSCFG.C2IMR1: SYSCFG CPU2 interrupt mask register 1
func (o *SYSCFG_Type) SetC2IMR1_RTCSTAMPTAMPLSECSSIM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetC2IMR1_RTCSTAMPTAMPLSECSSIM() uint32 {
	return volatile.LoadUint32(&o.C2IMR1.Reg) & 0x1
}
func (o *SYSCFG_Type) SetC2IMR1_RTCALARMIM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetC2IMR1_RTCALARMIM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetC2IMR1_RTCSSRUIM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetC2IMR1_RTCSSRUIM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x4) >> 2
}
func (o *SYSCFG_Type) SetC2IMR1_RTCWKUPIM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x8)|value<<3)
}
func (o *SYSCFG_Type) GetC2IMR1_RTCWKUPIM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x8) >> 3
}
func (o *SYSCFG_Type) SetC2IMR1_RCCIM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x20)|value<<5)
}
func (o *SYSCFG_Type) GetC2IMR1_RCCIM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x20) >> 5
}
func (o *SYSCFG_Type) SetC2IMR1_FLASHIM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x40)|value<<6)
}
func (o *SYSCFG_Type) GetC2IMR1_FLASHIM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x40) >> 6
}
func (o *SYSCFG_Type) SetC2IMR1_PKAIM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetC2IMR1_PKAIM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetC2IMR1_AESIM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x400)|value<<10)
}
func (o *SYSCFG_Type) GetC2IMR1_AESIM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x400) >> 10
}
func (o *SYSCFG_Type) SetC2IMR1_COMPIM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x800)|value<<11)
}
func (o *SYSCFG_Type) GetC2IMR1_COMPIM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x800) >> 11
}
func (o *SYSCFG_Type) SetC2IMR1_ADCIM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCFG_Type) GetC2IMR1_ADCIM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x1000) >> 12
}
func (o *SYSCFG_Type) SetC2IMR1_DACIM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCFG_Type) GetC2IMR1_DACIM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x2000) >> 13
}
func (o *SYSCFG_Type) SetC2IMR1_EXTI0IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetC2IMR1_EXTI0IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x10000) >> 16
}
func (o *SYSCFG_Type) SetC2IMR1_EXTI1IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCFG_Type) GetC2IMR1_EXTI1IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x20000) >> 17
}
func (o *SYSCFG_Type) SetC2IMR1_EXTI2IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCFG_Type) GetC2IMR1_EXTI2IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x40000) >> 18
}
func (o *SYSCFG_Type) SetC2IMR1_EXTI3IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCFG_Type) GetC2IMR1_EXTI3IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x80000) >> 19
}
func (o *SYSCFG_Type) SetC2IMR1_EXTI4IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCFG_Type) GetC2IMR1_EXTI4IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x100000) >> 20
}
func (o *SYSCFG_Type) SetC2IMR1_EXTI5IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCFG_Type) GetC2IMR1_EXTI5IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x200000) >> 21
}
func (o *SYSCFG_Type) SetC2IMR1_EXTI6IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCFG_Type) GetC2IMR1_EXTI6IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x400000) >> 22
}
func (o *SYSCFG_Type) SetC2IMR1_EXTI7IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCFG_Type) GetC2IMR1_EXTI7IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x800000) >> 23
}
func (o *SYSCFG_Type) SetC2IMR1_EXTI8IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCFG_Type) GetC2IMR1_EXTI8IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x1000000) >> 24
}
func (o *SYSCFG_Type) SetC2IMR1_EXTI9IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSCFG_Type) GetC2IMR1_EXTI9IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x2000000) >> 25
}
func (o *SYSCFG_Type) SetC2IMR1_EXTI10IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSCFG_Type) GetC2IMR1_EXTI10IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x4000000) >> 26
}
func (o *SYSCFG_Type) SetC2IMR1_EXTI11IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSCFG_Type) GetC2IMR1_EXTI11IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x8000000) >> 27
}
func (o *SYSCFG_Type) SetC2IMR1_EXTI12IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSCFG_Type) GetC2IMR1_EXTI12IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x10000000) >> 28
}
func (o *SYSCFG_Type) SetC2IMR1_EXTI13IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSCFG_Type) GetC2IMR1_EXTI13IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x20000000) >> 29
}
func (o *SYSCFG_Type) SetC2IMR1_EXTI14IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSCFG_Type) GetC2IMR1_EXTI14IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x40000000) >> 30
}
func (o *SYSCFG_Type) SetC2IMR1_EXTI15IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCFG_Type) GetC2IMR1_EXTI15IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x80000000) >> 31
}

// SYSCFG.C2IMR2: SYSCFG CPU2 interrupt mask register 2
func (o *SYSCFG_Type) SetC2IMR2_DMA1CH1IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA1CH1IM() uint32 {
	return volatile.LoadUint32(&o.C2IMR2.Reg) & 0x1
}
func (o *SYSCFG_Type) SetC2IMR2_DMA1CH2IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA1CH2IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetC2IMR2_DMA1CH3IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA1CH3IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x4) >> 2
}
func (o *SYSCFG_Type) SetC2IMR2_DMA1CH4IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x8)|value<<3)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA1CH4IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x8) >> 3
}
func (o *SYSCFG_Type) SetC2IMR2_DMA1CH5IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x10)|value<<4)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA1CH5IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x10) >> 4
}
func (o *SYSCFG_Type) SetC2IMR2_DMA1CH6IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x20)|value<<5)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA1CH6IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x20) >> 5
}
func (o *SYSCFG_Type) SetC2IMR2_DMA1CH7IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x40)|value<<6)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA1CH7IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x40) >> 6
}
func (o *SYSCFG_Type) SetC2IMR2_DMA2CH1IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA2CH1IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetC2IMR2_DMA2CH2IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x200)|value<<9)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA2CH2IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x200) >> 9
}
func (o *SYSCFG_Type) SetC2IMR2_DMA2CH3IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x400)|value<<10)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA2CH3IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x400) >> 10
}
func (o *SYSCFG_Type) SetC2IMR2_DMA2CH4IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x800)|value<<11)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA2CH4IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x800) >> 11
}
func (o *SYSCFG_Type) SetC2IMR2_DMA2CH5IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA2CH5IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x1000) >> 12
}
func (o *SYSCFG_Type) SetC2IMR2_DMA2CH6IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA2CH6IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x2000) >> 13
}
func (o *SYSCFG_Type) SetC2IMR2_DMA2CH7IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA2CH7IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x4000) >> 14
}
func (o *SYSCFG_Type) SetC2IMR2_DMAMUX1IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCFG_Type) GetC2IMR2_DMAMUX1IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x8000) >> 15
}
func (o *SYSCFG_Type) SetC2IMR2_PVM3IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCFG_Type) GetC2IMR2_PVM3IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x40000) >> 18
}
func (o *SYSCFG_Type) SetC2IMR2_PVDIM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCFG_Type) GetC2IMR2_PVDIM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x100000) >> 20
}

// SYSCFG.RFDCR: radio debug control register
func (o *SYSCFG_Type) SetRFDCR_RFTBSEL(value uint32) {
	volatile.StoreUint32(&o.RFDCR.Reg, volatile.LoadUint32(&o.RFDCR.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetRFDCR_RFTBSEL() uint32 {
	return volatile.LoadUint32(&o.RFDCR.Reg) & 0x1
}

// Tamper and backup registers
type TAMP_Type struct {
	CR1    volatile.Register32 // 0x0
	CR2    volatile.Register32 // 0x4
	CR3    volatile.Register32 // 0x8
	FLTCR  volatile.Register32 // 0xC
	_      [28]byte
	IER    volatile.Register32 // 0x2C
	SR     volatile.Register32 // 0x30
	MISR   volatile.Register32 // 0x34
	_      [4]byte
	SCR    volatile.Register32 // 0x3C
	COUNTR volatile.Register32 // 0x40
	_      [188]byte
	BKP0R  volatile.Register32 // 0x100
	BKP1R  volatile.Register32 // 0x104
	BKP2R  volatile.Register32 // 0x108
	BKP3R  volatile.Register32 // 0x10C
	BKP4R  volatile.Register32 // 0x110
	BKP5R  volatile.Register32 // 0x114
	BKP6R  volatile.Register32 // 0x118
	BKP7R  volatile.Register32 // 0x11C
	BKP8R  volatile.Register32 // 0x120
	BKP9R  volatile.Register32 // 0x124
	_      [24]byte
	BKP10R volatile.Register32 // 0x140
	BKP11R volatile.Register32 // 0x144
	BKP12R volatile.Register32 // 0x148
	BKP13R volatile.Register32 // 0x14C
	BKP14R volatile.Register32 // 0x150
	BKP15R volatile.Register32 // 0x154
	BKP16R volatile.Register32 // 0x158
	BKP17R volatile.Register32 // 0x15C
	BKP18R volatile.Register32 // 0x160
	BKP19R volatile.Register32 // 0x164
}

// TAMP.CR1: control register 1
func (o *TAMP_Type) SetCR1_TAMP1E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetCR1_TAMP1E() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *TAMP_Type) SetCR1_TAMP2E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetCR1_TAMP2E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetCR1_TAMP3E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetCR1_TAMP3E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetCR1_ITAMP3E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetCR1_ITAMP3E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetCR1_ITAMP5E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetCR1_ITAMP5E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetCR1_ITAMP6E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *TAMP_Type) GetCR1_ITAMP6E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}
func (o *TAMP_Type) SetCR1_ITAMP8E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *TAMP_Type) GetCR1_ITAMP8E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}

// TAMP.CR2: control register 2
func (o *TAMP_Type) SetCR2_TAMP1NOER(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetCR2_TAMP1NOER() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *TAMP_Type) SetCR2_TAMP2NOER(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetCR2_TAMP2NOER() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetCR2_TAMP3NOER(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetCR2_TAMP3NOER() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetCR2_TAMP1MSK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *TAMP_Type) GetCR2_TAMP1MSK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *TAMP_Type) SetCR2_TAMP2MSK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20000)|value<<17)
}
func (o *TAMP_Type) GetCR2_TAMP2MSK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20000) >> 17
}
func (o *TAMP_Type) SetCR2_TAMP3MSK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetCR2_TAMP3MSK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetCR2_BKERASE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800000)|value<<23)
}
func (o *TAMP_Type) GetCR2_BKERASE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800000) >> 23
}
func (o *TAMP_Type) SetCR2_TAMP1TRG(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000000)|value<<24)
}
func (o *TAMP_Type) GetCR2_TAMP1TRG() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000000) >> 24
}
func (o *TAMP_Type) SetCR2_TAMP2TRG(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000000)|value<<25)
}
func (o *TAMP_Type) GetCR2_TAMP2TRG() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000000) >> 25
}
func (o *TAMP_Type) SetCR2_TAMP3TRG(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000000)|value<<26)
}
func (o *TAMP_Type) GetCR2_TAMP3TRG() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000000) >> 26
}

// TAMP.CR3: TAMP control register 3
func (o *TAMP_Type) SetCR3_ITAMP3NOER(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetCR3_ITAMP3NOER() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetCR3_ITAMP5NOER(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *TAMP_Type) GetCR3_ITAMP5NOER() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *TAMP_Type) SetCR3_ITAMP6NOER(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x20)|value<<5)
}
func (o *TAMP_Type) GetCR3_ITAMP6NOER() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x20) >> 5
}
func (o *TAMP_Type) SetCR3_ITAMP8NOER(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *TAMP_Type) GetCR3_ITAMP8NOER() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}

// TAMP.FLTCR: TAMP filter control register
func (o *TAMP_Type) SetFLTCR_TAMPFREQ(value uint32) {
	volatile.StoreUint32(&o.FLTCR.Reg, volatile.LoadUint32(&o.FLTCR.Reg)&^(0x7)|value)
}
func (o *TAMP_Type) GetFLTCR_TAMPFREQ() uint32 {
	return volatile.LoadUint32(&o.FLTCR.Reg) & 0x7
}
func (o *TAMP_Type) SetFLTCR_TAMPFLT(value uint32) {
	volatile.StoreUint32(&o.FLTCR.Reg, volatile.LoadUint32(&o.FLTCR.Reg)&^(0x18)|value<<3)
}
func (o *TAMP_Type) GetFLTCR_TAMPFLT() uint32 {
	return (volatile.LoadUint32(&o.FLTCR.Reg) & 0x18) >> 3
}
func (o *TAMP_Type) SetFLTCR_TAMPPRCH(value uint32) {
	volatile.StoreUint32(&o.FLTCR.Reg, volatile.LoadUint32(&o.FLTCR.Reg)&^(0x60)|value<<5)
}
func (o *TAMP_Type) GetFLTCR_TAMPPRCH() uint32 {
	return (volatile.LoadUint32(&o.FLTCR.Reg) & 0x60) >> 5
}
func (o *TAMP_Type) SetFLTCR_TAMPPUDIS(value uint32) {
	volatile.StoreUint32(&o.FLTCR.Reg, volatile.LoadUint32(&o.FLTCR.Reg)&^(0x80)|value<<7)
}
func (o *TAMP_Type) GetFLTCR_TAMPPUDIS() uint32 {
	return (volatile.LoadUint32(&o.FLTCR.Reg) & 0x80) >> 7
}

// TAMP.IER: TAMP interrupt enable register
func (o *TAMP_Type) SetIER_TAMP1IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetIER_TAMP1IE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *TAMP_Type) SetIER_TAMP2IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetIER_TAMP2IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetIER_TAMP3IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetIER_TAMP3IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetIER_ITAMP3IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetIER_ITAMP3IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetIER_ITAMP5IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetIER_ITAMP5IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetIER_ITAMP6IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *TAMP_Type) GetIER_ITAMP6IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *TAMP_Type) SetIER_ITAMP8IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *TAMP_Type) GetIER_ITAMP8IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}

// TAMP.SR: TAMP status register
func (o *TAMP_Type) SetSR_TAMP1F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetSR_TAMP1F() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TAMP_Type) SetSR_TAMP2F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetSR_TAMP2F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetSR_TAMP3F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetSR_TAMP3F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetSR_ITAMP3F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetSR_ITAMP3F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetSR_ITAMP5F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetSR_ITAMP5F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetSR_ITAMP6F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *TAMP_Type) GetSR_ITAMP6F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}
func (o *TAMP_Type) SetSR_ITAMP8F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800000)|value<<23)
}
func (o *TAMP_Type) GetSR_ITAMP8F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800000) >> 23
}

// TAMP.MISR: TAMP masked interrupt status register
func (o *TAMP_Type) SetMISR_TAMP1MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetMISR_TAMP1MF() uint32 {
	return volatile.LoadUint32(&o.MISR.Reg) & 0x1
}
func (o *TAMP_Type) SetMISR_TAMP2MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetMISR_TAMP2MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetMISR_TAMP3MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetMISR_TAMP3MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetMISR_ITAMP3MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetMISR_ITAMP3MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetMISR_ITAMP5MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetMISR_ITAMP5MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetMISR_ITAMP6MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x200000)|value<<21)
}
func (o *TAMP_Type) GetMISR_ITAMP6MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x200000) >> 21
}
func (o *TAMP_Type) SetMISR_ITAMP8MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x800000)|value<<23)
}
func (o *TAMP_Type) GetMISR_ITAMP8MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x800000) >> 23
}

// TAMP.SCR: TAMP status clear register
func (o *TAMP_Type) SetSCR_CTAMP1F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetSCR_CTAMP1F() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0x1
}
func (o *TAMP_Type) SetSCR_CTAMP2F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetSCR_CTAMP2F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetSCR_CTAMP3F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetSCR_CTAMP3F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetSCR_CITAMP3F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetSCR_CITAMP3F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetSCR_CITAMP5F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetSCR_CITAMP5F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetSCR_CITAMP6F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x200000)|value<<21)
}
func (o *TAMP_Type) GetSCR_CITAMP6F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x200000) >> 21
}
func (o *TAMP_Type) SetSCR_CITAMP8F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x800000)|value<<23)
}
func (o *TAMP_Type) GetSCR_CITAMP8F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x800000) >> 23
}

// TAMP.COUNTR: monotonic counter register
func (o *TAMP_Type) SetCOUNTR(value uint32) {
	volatile.StoreUint32(&o.COUNTR.Reg, value)
}
func (o *TAMP_Type) GetCOUNTR() uint32 {
	return volatile.LoadUint32(&o.COUNTR.Reg)
}

// TAMP.BKP0R: TAMP backup register
func (o *TAMP_Type) SetBKP0R(value uint32) {
	volatile.StoreUint32(&o.BKP0R.Reg, value)
}
func (o *TAMP_Type) GetBKP0R() uint32 {
	return volatile.LoadUint32(&o.BKP0R.Reg)
}

// TAMP.BKP1R: TAMP backup register
func (o *TAMP_Type) SetBKP1R(value uint32) {
	volatile.StoreUint32(&o.BKP1R.Reg, value)
}
func (o *TAMP_Type) GetBKP1R() uint32 {
	return volatile.LoadUint32(&o.BKP1R.Reg)
}

// TAMP.BKP2R: TAMP backup register
func (o *TAMP_Type) SetBKP2R(value uint32) {
	volatile.StoreUint32(&o.BKP2R.Reg, value)
}
func (o *TAMP_Type) GetBKP2R() uint32 {
	return volatile.LoadUint32(&o.BKP2R.Reg)
}

// TAMP.BKP3R: TAMP backup register
func (o *TAMP_Type) SetBKP3R(value uint32) {
	volatile.StoreUint32(&o.BKP3R.Reg, value)
}
func (o *TAMP_Type) GetBKP3R() uint32 {
	return volatile.LoadUint32(&o.BKP3R.Reg)
}

// TAMP.BKP4R: TAMP backup register
func (o *TAMP_Type) SetBKP4R(value uint32) {
	volatile.StoreUint32(&o.BKP4R.Reg, value)
}
func (o *TAMP_Type) GetBKP4R() uint32 {
	return volatile.LoadUint32(&o.BKP4R.Reg)
}

// TAMP.BKP5R: TAMP backup register
func (o *TAMP_Type) SetBKP5R(value uint32) {
	volatile.StoreUint32(&o.BKP5R.Reg, value)
}
func (o *TAMP_Type) GetBKP5R() uint32 {
	return volatile.LoadUint32(&o.BKP5R.Reg)
}

// TAMP.BKP6R: TAMP backup register
func (o *TAMP_Type) SetBKP6R(value uint32) {
	volatile.StoreUint32(&o.BKP6R.Reg, value)
}
func (o *TAMP_Type) GetBKP6R() uint32 {
	return volatile.LoadUint32(&o.BKP6R.Reg)
}

// TAMP.BKP7R: TAMP backup register
func (o *TAMP_Type) SetBKP7R(value uint32) {
	volatile.StoreUint32(&o.BKP7R.Reg, value)
}
func (o *TAMP_Type) GetBKP7R() uint32 {
	return volatile.LoadUint32(&o.BKP7R.Reg)
}

// TAMP.BKP8R: TAMP backup register
func (o *TAMP_Type) SetBKP8R(value uint32) {
	volatile.StoreUint32(&o.BKP8R.Reg, value)
}
func (o *TAMP_Type) GetBKP8R() uint32 {
	return volatile.LoadUint32(&o.BKP8R.Reg)
}

// TAMP.BKP9R: TAMP backup register
func (o *TAMP_Type) SetBKP9R(value uint32) {
	volatile.StoreUint32(&o.BKP9R.Reg, value)
}
func (o *TAMP_Type) GetBKP9R() uint32 {
	return volatile.LoadUint32(&o.BKP9R.Reg)
}

// TAMP.BKP10R: TAMP backup register
func (o *TAMP_Type) SetBKP10R(value uint32) {
	volatile.StoreUint32(&o.BKP10R.Reg, value)
}
func (o *TAMP_Type) GetBKP10R() uint32 {
	return volatile.LoadUint32(&o.BKP10R.Reg)
}

// TAMP.BKP11R: TAMP backup register
func (o *TAMP_Type) SetBKP11R(value uint32) {
	volatile.StoreUint32(&o.BKP11R.Reg, value)
}
func (o *TAMP_Type) GetBKP11R() uint32 {
	return volatile.LoadUint32(&o.BKP11R.Reg)
}

// TAMP.BKP12R: TAMP backup register
func (o *TAMP_Type) SetBKP12R(value uint32) {
	volatile.StoreUint32(&o.BKP12R.Reg, value)
}
func (o *TAMP_Type) GetBKP12R() uint32 {
	return volatile.LoadUint32(&o.BKP12R.Reg)
}

// TAMP.BKP13R: TAMP backup register
func (o *TAMP_Type) SetBKP13R(value uint32) {
	volatile.StoreUint32(&o.BKP13R.Reg, value)
}
func (o *TAMP_Type) GetBKP13R() uint32 {
	return volatile.LoadUint32(&o.BKP13R.Reg)
}

// TAMP.BKP14R: TAMP backup register
func (o *TAMP_Type) SetBKP14R(value uint32) {
	volatile.StoreUint32(&o.BKP14R.Reg, value)
}
func (o *TAMP_Type) GetBKP14R() uint32 {
	return volatile.LoadUint32(&o.BKP14R.Reg)
}

// TAMP.BKP15R: TAMP backup register
func (o *TAMP_Type) SetBKP15R(value uint32) {
	volatile.StoreUint32(&o.BKP15R.Reg, value)
}
func (o *TAMP_Type) GetBKP15R() uint32 {
	return volatile.LoadUint32(&o.BKP15R.Reg)
}

// TAMP.BKP16R: TAMP backup register
func (o *TAMP_Type) SetBKP16R(value uint32) {
	volatile.StoreUint32(&o.BKP16R.Reg, value)
}
func (o *TAMP_Type) GetBKP16R() uint32 {
	return volatile.LoadUint32(&o.BKP16R.Reg)
}

// TAMP.BKP17R: TAMP backup register
func (o *TAMP_Type) SetBKP17R(value uint32) {
	volatile.StoreUint32(&o.BKP17R.Reg, value)
}
func (o *TAMP_Type) GetBKP17R() uint32 {
	return volatile.LoadUint32(&o.BKP17R.Reg)
}

// TAMP.BKP18R: TAMP backup register
func (o *TAMP_Type) SetBKP18R(value uint32) {
	volatile.StoreUint32(&o.BKP18R.Reg, value)
}
func (o *TAMP_Type) GetBKP18R() uint32 {
	return volatile.LoadUint32(&o.BKP18R.Reg)
}

// TAMP.BKP19R: TAMP backup register
func (o *TAMP_Type) SetBKP19R(value uint32) {
	volatile.StoreUint32(&o.BKP19R.Reg, value)
}
func (o *TAMP_Type) GetBKP19R() uint32 {
	return volatile.LoadUint32(&o.BKP19R.Reg)
}

// Advanced-control timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
	OR1          volatile.Register32 // 0x50
	CCMR3_Output volatile.Register32 // 0x54
	CCR5         volatile.Register32 // 0x58
	CCR6         volatile.Register32 // 0x5C
	AF1          volatile.Register32 // 0x60
	AF2          volatile.Register32 // 0x64
	TISEL        volatile.Register32 // 0x68
}

// TIM.CR1: control register 1
func (o *TIM_Type) SetCR1_UIFREMAP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCR1_UIFREMAP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCR1_CKD(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCR1_CKD() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCR1_ARPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR1_ARPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR1_CMS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x60)|value<<5)
}
func (o *TIM_Type) GetCR1_CMS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x60) >> 5
}
func (o *TIM_Type) SetCR1_DIR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCR1_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCR1_OPM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR1_OPM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR1_URS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR1_URS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR1_UDIS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCR1_UDIS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCR1_CEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR1_CEN() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// TIM.CR2: control register 2
func (o *TIM_Type) SetCR2_MMS2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf00000)|value<<20)
}
func (o *TIM_Type) GetCR2_MMS2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf00000) >> 20
}
func (o *TIM_Type) SetCR2_OIS6(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *TIM_Type) GetCR2_OIS6() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *TIM_Type) SetCR2_OIS5(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCR2_OIS5() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCR2_OIS4(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetCR2_OIS4() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetCR2_OIS3N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCR2_OIS3N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCR2_OIS3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCR2_OIS3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCR2_OIS2N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCR2_OIS2N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCR2_OIS2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCR2_OIS2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCR2_OIS1N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCR2_OIS1N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCR2_OIS1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCR2_OIS1() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCR2_TI1S(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR2_TI1S() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR2_MMS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCR2_MMS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCR2_CCDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR2_CCDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR2_CCUS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR2_CCUS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR2_CCPC(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR2_CCPC() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// TIM.SMCR: slave mode control register
func (o *TIM_Type) SetSMCR_TS3_4(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x300000)|value<<20)
}
func (o *TIM_Type) GetSMCR_TS3_4() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x300000) >> 20
}
func (o *TIM_Type) SetSMCR_SMS_3(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetSMCR_SMS_3() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetSMCR_ETP(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetSMCR_ETP() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetSMCR_ECE(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetSMCR_ECE() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetSMCR_ETPS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x3000)|value<<12)
}
func (o *TIM_Type) GetSMCR_ETPS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x3000) >> 12
}
func (o *TIM_Type) SetSMCR_ETF(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0xf00)|value<<8)
}
func (o *TIM_Type) GetSMCR_ETF() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0xf00) >> 8
}
func (o *TIM_Type) SetSMCR_MSM(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSMCR_MSM() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSMCR_TS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetSMCR_TS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetSMCR_OCCS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetSMCR_OCCS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetSMCR_SMS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x7)|value)
}
func (o *TIM_Type) GetSMCR_SMS() uint32 {
	return volatile.LoadUint32(&o.SMCR.Reg) & 0x7
}

// TIM.DIER: DMA/interrupt enable register
func (o *TIM_Type) SetDIER_TDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetDIER_TDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetDIER_COMDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetDIER_COMDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetDIER_CC4DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetDIER_CC4DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetDIER_CC3DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetDIER_CC3DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetDIER_CC2DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetDIER_CC2DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetDIER_CC1DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetDIER_CC1DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetDIER_UDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetDIER_UDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetDIER_BIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetDIER_BIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetDIER_TIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetDIER_TIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetDIER_COMIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetDIER_COMIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetDIER_CC4IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetDIER_CC4IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetDIER_CC3IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetDIER_CC3IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetDIER_CC2IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetDIER_CC2IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetDIER_CC1IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetDIER_CC1IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetDIER_UIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetDIER_UIE() uint32 {
	return volatile.LoadUint32(&o.DIER.Reg) & 0x1
}

// TIM.SR: status register
func (o *TIM_Type) SetSR_CC6IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *TIM_Type) GetSR_CC6IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *TIM_Type) SetSR_CC5IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetSR_CC5IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetSR_SBIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetSR_SBIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetSR_CC4OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetSR_CC4OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetSR_CC3OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetSR_CC3OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetSR_CC2OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetSR_CC2OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetSR_CC1OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetSR_CC1OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetSR_B2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetSR_B2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetSR_BIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSR_BIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSR_TIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetSR_TIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetSR_COMIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetSR_COMIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetSR_CC4IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetSR_CC4IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetSR_CC3IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetSR_CC3IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetSR_CC2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetSR_CC2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetSR_CC1IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetSR_CC1IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetSR_UIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetSR_UIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// TIM.EGR: event generation register
func (o *TIM_Type) SetEGR_B2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetEGR_B2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetEGR_BG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetEGR_BG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetEGR_TG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetEGR_TG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetEGR_COMG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetEGR_COMG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetEGR_CC4G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetEGR_CC4G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetEGR_CC3G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetEGR_CC3G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetEGR_CC2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetEGR_CC2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetEGR_CC1G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetEGR_CC1G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetEGR_UG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetEGR_UG() uint32 {
	return volatile.LoadUint32(&o.EGR.Reg) & 0x1
}

// TIM.CCMR1_Output: capture/compare mode register 1 (output mode)
func (o *TIM_Type) SetCCMR1_Output_OC2M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x1000000) >> 24
}
func (o *TIM_Type) SetCCMR1_Output_OC1M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR1_Output_OC2CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR1_Output_OC2CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR1_Output_OC2M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR1_Output_OC2PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR1_Output_OC2PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR1_Output_OC2FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR1_Output_OC2FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR1_Output_CC2S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR1_Output_CC2S() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR1_Output_OC1CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR1_Output_OC1CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR1_Output_OC1M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR1_Output_OC1PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR1_Output_OC1PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR1_Output_OC1FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR1_Output_OC1FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR1_Output_CC1S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR1_Output_CC1S() uint32 {
	return volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x3
}

// TIM.CCMR2_Output: capture/compare mode register 2 (output mode)
func (o *TIM_Type) SetCCMR2_Output_OC4M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x1000000) >> 24
}
func (o *TIM_Type) SetCCMR2_Output_OC3M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR2_Output_OC4CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR2_Output_OC4CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR2_Output_OC4M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR2_Output_OC4PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR2_Output_OC4PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR2_Output_OC4FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR2_Output_OC4FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR2_Output_CC4S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR2_Output_CC4S() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR2_Output_OC3CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR2_Output_OC3CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR2_Output_OC3M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR2_Output_OC3PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR2_Output_OC3PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR2_Output_OC3FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR2_Output_OC3FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR2_Output_CC3S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR2_Output_CC3S() uint32 {
	return volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x3
}

// TIM.CCER: capture/compare enable register
func (o *TIM_Type) SetCCER_CC6P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x200000)|value<<21)
}
func (o *TIM_Type) GetCCER_CC6P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x200000) >> 21
}
func (o *TIM_Type) SetCCER_CC6E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x100000)|value<<20)
}
func (o *TIM_Type) GetCCER_CC6E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x100000) >> 20
}
func (o *TIM_Type) SetCCER_CC5P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20000)|value<<17)
}
func (o *TIM_Type) GetCCER_CC5P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20000) >> 17
}
func (o *TIM_Type) SetCCER_CC5E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCER_CC5E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCER_CC4P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCCER_CC4P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCCER_CC4E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCCER_CC4E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCCER_CC3NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCER_CC3NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCER_CC3NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCER_CC3NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCER_CC3P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCCER_CC3P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCCER_CC3E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCCER_CC3E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCCER_CC2NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCER_CC2NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCER_CC2NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetCCER_CC2NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetCCER_CC2P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetCCER_CC2P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetCCER_CC2E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCCER_CC2E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCCER_CC1NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCER_CC1NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCER_CC1NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCER_CC1NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCER_CC1P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCCER_CC1P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCCER_CC1E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCCER_CC1E() uint32 {
	return volatile.LoadUint32(&o.CCER.Reg) & 0x1
}

// TIM.CNT: counter
func (o *TIM_Type) SetCNT_UIFCPY(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0x80000000)|value<<31)
}
func (o *TIM_Type) GetCNT_UIFCPY() uint32 {
	return (volatile.LoadUint32(&o.CNT.Reg) & 0x80000000) >> 31
}
func (o *TIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// TIM.PSC: prescaler
func (o *TIM_Type) SetPSC(value uint32) {
	volatile.StoreUint32(&o.PSC.Reg, volatile.LoadUint32(&o.PSC.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetPSC() uint32 {
	return volatile.LoadUint32(&o.PSC.Reg) & 0xffff
}

// TIM.ARR: auto-reload register
func (o *TIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// TIM.RCR: repetition counter register
func (o *TIM_Type) SetRCR_REP(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetRCR_REP() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// TIM.CCR1: capture/compare register 1
func (o *TIM_Type) SetCCR1(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR1() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0xffff
}

// TIM.CCR2: capture/compare register 2
func (o *TIM_Type) SetCCR2(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR2() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0xffff
}

// TIM.CCR3: capture/compare register 3
func (o *TIM_Type) SetCCR3(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR3() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg) & 0xffff
}

// TIM.CCR4: capture/compare register 4
func (o *TIM_Type) SetCCR4(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR4() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg) & 0xffff
}

// TIM.BDTR: break and dead-time register
func (o *TIM_Type) SetBDTR_BK2BID(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x20000000)|value<<29)
}
func (o *TIM_Type) GetBDTR_BK2BID() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x20000000) >> 29
}
func (o *TIM_Type) SetBDTR_BKBID(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x10000000)|value<<28)
}
func (o *TIM_Type) GetBDTR_BKBID() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x10000000) >> 28
}
func (o *TIM_Type) SetBDTR_BK2DSRM(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x8000000)|value<<27)
}
func (o *TIM_Type) GetBDTR_BK2DSRM() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x8000000) >> 27
}
func (o *TIM_Type) SetBDTR_BKDSRM(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x4000000)|value<<26)
}
func (o *TIM_Type) GetBDTR_BKDSRM() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x4000000) >> 26
}
func (o *TIM_Type) SetBDTR_BK2P(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x2000000)|value<<25)
}
func (o *TIM_Type) GetBDTR_BK2P() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x2000000) >> 25
}
func (o *TIM_Type) SetBDTR_BK2E(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetBDTR_BK2E() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x1000000) >> 24
}
func (o *TIM_Type) SetBDTR_BK2F(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xf00000)|value<<20)
}
func (o *TIM_Type) GetBDTR_BK2F() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0xf00000) >> 20
}
func (o *TIM_Type) SetBDTR_BKF(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xf0000)|value<<16)
}
func (o *TIM_Type) GetBDTR_BKF() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0xf0000) >> 16
}
func (o *TIM_Type) SetBDTR_MOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetBDTR_MOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetBDTR_AOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetBDTR_AOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetBDTR_BKP(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetBDTR_BKP() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetBDTR_BKE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetBDTR_BKE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetBDTR_OSSR(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetBDTR_OSSR() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetBDTR_OSSI(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetBDTR_OSSI() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetBDTR_LOCK(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetBDTR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetBDTR_DTG(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xff)|value)
}
func (o *TIM_Type) GetBDTR_DTG() uint32 {
	return volatile.LoadUint32(&o.BDTR.Reg) & 0xff
}

// TIM.DCR: DMA control register
func (o *TIM_Type) SetDCR_DBL(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f00)|value<<8)
}
func (o *TIM_Type) GetDCR_DBL() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f00) >> 8
}
func (o *TIM_Type) SetDCR_DBA(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f)|value)
}
func (o *TIM_Type) GetDCR_DBA() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1f
}

// TIM.DMAR: DMA address for full transfer
func (o *TIM_Type) SetDMAR_DMAB(value uint32) {
	volatile.StoreUint32(&o.DMAR.Reg, volatile.LoadUint32(&o.DMAR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetDMAR_DMAB() uint32 {
	return volatile.LoadUint32(&o.DMAR.Reg) & 0xffff
}

// TIM.OR1: option register 1
func (o *TIM_Type) SetOR1_TI1_RMP(value uint32) {
	volatile.StoreUint32(&o.OR1.Reg, volatile.LoadUint32(&o.OR1.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetOR1_TI1_RMP() uint32 {
	return (volatile.LoadUint32(&o.OR1.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetOR1_TIM1_ETR_ADC1_RMP(value uint32) {
	volatile.StoreUint32(&o.OR1.Reg, volatile.LoadUint32(&o.OR1.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetOR1_TIM1_ETR_ADC1_RMP() uint32 {
	return volatile.LoadUint32(&o.OR1.Reg) & 0x3
}

// TIM.CCMR3_Output: capture/compare mode register 3
func (o *TIM_Type) SetCCMR3_Output_OC6M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR3_Output_OC6M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x1000000) >> 24
}
func (o *TIM_Type) SetCCMR3_Output_OC5M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR3_Output_OC5M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR3_Output_OC6CE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR3_Output_OC6CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR3_Output_OC6M(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR3_Output_OC6M() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR3_Output_OC6PE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR3_Output_OC6PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR3_Output_OC6FE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR3_Output_OC6FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR3_Output_OC5CE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR3_Output_OC5CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR3_Output_OC5M(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR3_Output_OC5M() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR3_Output_OC5PE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR3_Output_OC5PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR3_Output_OC5FE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR3_Output_OC5FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x4) >> 2
}

// TIM.CCR5: capture/compare register 5
func (o *TIM_Type) SetCCR5_GC5C3(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x80000000)|value<<31)
}
func (o *TIM_Type) GetCCR5_GC5C3() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x80000000) >> 31
}
func (o *TIM_Type) SetCCR5_GC5C2(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x40000000)|value<<30)
}
func (o *TIM_Type) GetCCR5_GC5C2() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x40000000) >> 30
}
func (o *TIM_Type) SetCCR5_GC5C1(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x20000000)|value<<29)
}
func (o *TIM_Type) GetCCR5_GC5C1() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x20000000) >> 29
}
func (o *TIM_Type) SetCCR5(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR5() uint32 {
	return volatile.LoadUint32(&o.CCR5.Reg) & 0xffff
}

// TIM.CCR6: capture/compare register 6
func (o *TIM_Type) SetCCR6(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR6() uint32 {
	return volatile.LoadUint32(&o.CCR6.Reg) & 0xffff
}

// TIM.AF1: alternate function option register 1
func (o *TIM_Type) SetAF1_ETRSEL(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x3c000)|value<<14)
}
func (o *TIM_Type) GetAF1_ETRSEL() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x3c000) >> 14
}
func (o *TIM_Type) SetAF1_BKCMP2P(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetAF1_BKCMP2P() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetAF1_BKCMP1P(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetAF1_BKCMP1P() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetAF1_BKINP(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetAF1_BKINP() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetAF1_BKCMP2E(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetAF1_BKCMP2E() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetAF1_BKCMP1E(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetAF1_BKCMP1E() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetAF1_BKINE(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetAF1_BKINE() uint32 {
	return volatile.LoadUint32(&o.AF1.Reg) & 0x1
}

// TIM.AF2: Alternate function register 2
func (o *TIM_Type) SetAF2_BK2CMP2P(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetAF2_BK2CMP2P() uint32 {
	return (volatile.LoadUint32(&o.AF2.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetAF2_BK2CMP1P(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetAF2_BK2CMP1P() uint32 {
	return (volatile.LoadUint32(&o.AF2.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetAF2_BK2INP(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetAF2_BK2INP() uint32 {
	return (volatile.LoadUint32(&o.AF2.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetAF2_BK2CMP2E(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetAF2_BK2CMP2E() uint32 {
	return (volatile.LoadUint32(&o.AF2.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetAF2_BK2CMP1E(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetAF2_BK2CMP1E() uint32 {
	return (volatile.LoadUint32(&o.AF2.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetAF2_BK2INE(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetAF2_BK2INE() uint32 {
	return volatile.LoadUint32(&o.AF2.Reg) & 0x1
}

// TIM.TISEL: timer input selection register
func (o *TIM_Type) SetTISEL_TI4SEL(value uint32) {
	volatile.StoreUint32(&o.TISEL.Reg, volatile.LoadUint32(&o.TISEL.Reg)&^(0xf000000)|value<<24)
}
func (o *TIM_Type) GetTISEL_TI4SEL() uint32 {
	return (volatile.LoadUint32(&o.TISEL.Reg) & 0xf000000) >> 24
}
func (o *TIM_Type) SetTISEL_TI3SEL(value uint32) {
	volatile.StoreUint32(&o.TISEL.Reg, volatile.LoadUint32(&o.TISEL.Reg)&^(0xf0000)|value<<16)
}
func (o *TIM_Type) GetTISEL_TI3SEL() uint32 {
	return (volatile.LoadUint32(&o.TISEL.Reg) & 0xf0000) >> 16
}
func (o *TIM_Type) SetTISEL_TI2SEL(value uint32) {
	volatile.StoreUint32(&o.TISEL.Reg, volatile.LoadUint32(&o.TISEL.Reg)&^(0xf00)|value<<8)
}
func (o *TIM_Type) GetTISEL_TI2SEL() uint32 {
	return (volatile.LoadUint32(&o.TISEL.Reg) & 0xf00) >> 8
}
func (o *TIM_Type) SetTISEL_TI1SEL(value uint32) {
	volatile.StoreUint32(&o.TISEL.Reg, volatile.LoadUint32(&o.TISEL.Reg)&^(0xf)|value)
}
func (o *TIM_Type) GetTISEL_TI1SEL() uint32 {
	return volatile.LoadUint32(&o.TISEL.Reg) & 0xf
}

// TrustZone Interrupt Control
type TZSC_Type struct {
	IER1  volatile.Register32 // 0x0
	_     [12]byte
	MISR1 volatile.Register32 // 0x10
	_     [12]byte
	ICR1  volatile.Register32 // 0x20
}

// TZSC.IER1: TZIC interrupt enable register 1
func (o *TZSC_Type) SetIER1_TZICIE(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x1)|value)
}
func (o *TZSC_Type) GetIER1_TZICIE() uint32 {
	return volatile.LoadUint32(&o.IER1.Reg) & 0x1
}
func (o *TZSC_Type) SetIER1_TZSCIE(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x2)|value<<1)
}
func (o *TZSC_Type) GetIER1_TZSCIE() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x2) >> 1
}
func (o *TZSC_Type) SetIER1_AESIE(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x4)|value<<2)
}
func (o *TZSC_Type) GetIER1_AESIE() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x4) >> 2
}
func (o *TZSC_Type) SetIER1_RNGIE(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x8)|value<<3)
}
func (o *TZSC_Type) GetIER1_RNGIE() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x8) >> 3
}
func (o *TZSC_Type) SetIER1_SUBGHZSPIIE(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x10)|value<<4)
}
func (o *TZSC_Type) GetIER1_SUBGHZSPIIE() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x10) >> 4
}
func (o *TZSC_Type) SetIER1_PWRIE(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x20)|value<<5)
}
func (o *TZSC_Type) GetIER1_PWRIE() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x20) >> 5
}
func (o *TZSC_Type) SetIER1_FLASHIFIE(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x40)|value<<6)
}
func (o *TZSC_Type) GetIER1_FLASHIFIE() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x40) >> 6
}
func (o *TZSC_Type) SetIER1_DMA1IE(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x80)|value<<7)
}
func (o *TZSC_Type) GetIER1_DMA1IE() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x80) >> 7
}
func (o *TZSC_Type) SetIER1_DMA2IE(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x100)|value<<8)
}
func (o *TZSC_Type) GetIER1_DMA2IE() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x100) >> 8
}
func (o *TZSC_Type) SetIER1_DMAMUX1IE(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x200)|value<<9)
}
func (o *TZSC_Type) GetIER1_DMAMUX1IE() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x200) >> 9
}
func (o *TZSC_Type) SetIER1_FLASHIE(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x400)|value<<10)
}
func (o *TZSC_Type) GetIER1_FLASHIE() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x400) >> 10
}
func (o *TZSC_Type) SetIER1_SRAM1IE(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x800)|value<<11)
}
func (o *TZSC_Type) GetIER1_SRAM1IE() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x800) >> 11
}
func (o *TZSC_Type) SetIER1_SRAM2IE(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x1000)|value<<12)
}
func (o *TZSC_Type) GetIER1_SRAM2IE() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x1000) >> 12
}
func (o *TZSC_Type) SetIER1_PKAIE(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x2000)|value<<13)
}
func (o *TZSC_Type) GetIER1_PKAIE() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x2000) >> 13
}

// TZSC.MISR1: TZIC status register 1
func (o *TZSC_Type) SetMISR1_TZICMF(value uint32) {
	volatile.StoreUint32(&o.MISR1.Reg, volatile.LoadUint32(&o.MISR1.Reg)&^(0x1)|value)
}
func (o *TZSC_Type) GetMISR1_TZICMF() uint32 {
	return volatile.LoadUint32(&o.MISR1.Reg) & 0x1
}
func (o *TZSC_Type) SetMISR1_TZSCMF(value uint32) {
	volatile.StoreUint32(&o.MISR1.Reg, volatile.LoadUint32(&o.MISR1.Reg)&^(0x2)|value<<1)
}
func (o *TZSC_Type) GetMISR1_TZSCMF() uint32 {
	return (volatile.LoadUint32(&o.MISR1.Reg) & 0x2) >> 1
}
func (o *TZSC_Type) SetMISR1_AESMF(value uint32) {
	volatile.StoreUint32(&o.MISR1.Reg, volatile.LoadUint32(&o.MISR1.Reg)&^(0x4)|value<<2)
}
func (o *TZSC_Type) GetMISR1_AESMF() uint32 {
	return (volatile.LoadUint32(&o.MISR1.Reg) & 0x4) >> 2
}
func (o *TZSC_Type) SetMISR1_RNGMF(value uint32) {
	volatile.StoreUint32(&o.MISR1.Reg, volatile.LoadUint32(&o.MISR1.Reg)&^(0x8)|value<<3)
}
func (o *TZSC_Type) GetMISR1_RNGMF() uint32 {
	return (volatile.LoadUint32(&o.MISR1.Reg) & 0x8) >> 3
}
func (o *TZSC_Type) SetMISR1_SUBGHZSPIMF(value uint32) {
	volatile.StoreUint32(&o.MISR1.Reg, volatile.LoadUint32(&o.MISR1.Reg)&^(0x10)|value<<4)
}
func (o *TZSC_Type) GetMISR1_SUBGHZSPIMF() uint32 {
	return (volatile.LoadUint32(&o.MISR1.Reg) & 0x10) >> 4
}
func (o *TZSC_Type) SetMISR1_PWRMF(value uint32) {
	volatile.StoreUint32(&o.MISR1.Reg, volatile.LoadUint32(&o.MISR1.Reg)&^(0x20)|value<<5)
}
func (o *TZSC_Type) GetMISR1_PWRMF() uint32 {
	return (volatile.LoadUint32(&o.MISR1.Reg) & 0x20) >> 5
}
func (o *TZSC_Type) SetMISR1_FLASHIFMF(value uint32) {
	volatile.StoreUint32(&o.MISR1.Reg, volatile.LoadUint32(&o.MISR1.Reg)&^(0x40)|value<<6)
}
func (o *TZSC_Type) GetMISR1_FLASHIFMF() uint32 {
	return (volatile.LoadUint32(&o.MISR1.Reg) & 0x40) >> 6
}
func (o *TZSC_Type) SetMISR1_DMA1MF(value uint32) {
	volatile.StoreUint32(&o.MISR1.Reg, volatile.LoadUint32(&o.MISR1.Reg)&^(0x80)|value<<7)
}
func (o *TZSC_Type) GetMISR1_DMA1MF() uint32 {
	return (volatile.LoadUint32(&o.MISR1.Reg) & 0x80) >> 7
}
func (o *TZSC_Type) SetMISR1_DMA2MF(value uint32) {
	volatile.StoreUint32(&o.MISR1.Reg, volatile.LoadUint32(&o.MISR1.Reg)&^(0x100)|value<<8)
}
func (o *TZSC_Type) GetMISR1_DMA2MF() uint32 {
	return (volatile.LoadUint32(&o.MISR1.Reg) & 0x100) >> 8
}
func (o *TZSC_Type) SetMISR1_DMAMUX1MF(value uint32) {
	volatile.StoreUint32(&o.MISR1.Reg, volatile.LoadUint32(&o.MISR1.Reg)&^(0x200)|value<<9)
}
func (o *TZSC_Type) GetMISR1_DMAMUX1MF() uint32 {
	return (volatile.LoadUint32(&o.MISR1.Reg) & 0x200) >> 9
}
func (o *TZSC_Type) SetMISR1_FLASHMF(value uint32) {
	volatile.StoreUint32(&o.MISR1.Reg, volatile.LoadUint32(&o.MISR1.Reg)&^(0x400)|value<<10)
}
func (o *TZSC_Type) GetMISR1_FLASHMF() uint32 {
	return (volatile.LoadUint32(&o.MISR1.Reg) & 0x400) >> 10
}
func (o *TZSC_Type) SetMISR1_SRAM1MF(value uint32) {
	volatile.StoreUint32(&o.MISR1.Reg, volatile.LoadUint32(&o.MISR1.Reg)&^(0x800)|value<<11)
}
func (o *TZSC_Type) GetMISR1_SRAM1MF() uint32 {
	return (volatile.LoadUint32(&o.MISR1.Reg) & 0x800) >> 11
}
func (o *TZSC_Type) SetMISR1_SRAM2MF(value uint32) {
	volatile.StoreUint32(&o.MISR1.Reg, volatile.LoadUint32(&o.MISR1.Reg)&^(0x1000)|value<<12)
}
func (o *TZSC_Type) GetMISR1_SRAM2MF() uint32 {
	return (volatile.LoadUint32(&o.MISR1.Reg) & 0x1000) >> 12
}
func (o *TZSC_Type) SetMISR1_PKAMF(value uint32) {
	volatile.StoreUint32(&o.MISR1.Reg, volatile.LoadUint32(&o.MISR1.Reg)&^(0x2000)|value<<13)
}
func (o *TZSC_Type) GetMISR1_PKAMF() uint32 {
	return (volatile.LoadUint32(&o.MISR1.Reg) & 0x2000) >> 13
}

// TZSC.ICR1: TZIC interrupt status clear register 1
func (o *TZSC_Type) SetICR1_TZICCF(value uint32) {
	volatile.StoreUint32(&o.ICR1.Reg, volatile.LoadUint32(&o.ICR1.Reg)&^(0x1)|value)
}
func (o *TZSC_Type) GetICR1_TZICCF() uint32 {
	return volatile.LoadUint32(&o.ICR1.Reg) & 0x1
}
func (o *TZSC_Type) SetICR1_TZSCCF(value uint32) {
	volatile.StoreUint32(&o.ICR1.Reg, volatile.LoadUint32(&o.ICR1.Reg)&^(0x2)|value<<1)
}
func (o *TZSC_Type) GetICR1_TZSCCF() uint32 {
	return (volatile.LoadUint32(&o.ICR1.Reg) & 0x2) >> 1
}
func (o *TZSC_Type) SetICR1_AESCF(value uint32) {
	volatile.StoreUint32(&o.ICR1.Reg, volatile.LoadUint32(&o.ICR1.Reg)&^(0x4)|value<<2)
}
func (o *TZSC_Type) GetICR1_AESCF() uint32 {
	return (volatile.LoadUint32(&o.ICR1.Reg) & 0x4) >> 2
}
func (o *TZSC_Type) SetICR1_RNGCF(value uint32) {
	volatile.StoreUint32(&o.ICR1.Reg, volatile.LoadUint32(&o.ICR1.Reg)&^(0x8)|value<<3)
}
func (o *TZSC_Type) GetICR1_RNGCF() uint32 {
	return (volatile.LoadUint32(&o.ICR1.Reg) & 0x8) >> 3
}
func (o *TZSC_Type) SetICR1_SUBGHZSPICF(value uint32) {
	volatile.StoreUint32(&o.ICR1.Reg, volatile.LoadUint32(&o.ICR1.Reg)&^(0x10)|value<<4)
}
func (o *TZSC_Type) GetICR1_SUBGHZSPICF() uint32 {
	return (volatile.LoadUint32(&o.ICR1.Reg) & 0x10) >> 4
}
func (o *TZSC_Type) SetICR1_PWRCF(value uint32) {
	volatile.StoreUint32(&o.ICR1.Reg, volatile.LoadUint32(&o.ICR1.Reg)&^(0x20)|value<<5)
}
func (o *TZSC_Type) GetICR1_PWRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR1.Reg) & 0x20) >> 5
}
func (o *TZSC_Type) SetICR1_FLASHIFCF(value uint32) {
	volatile.StoreUint32(&o.ICR1.Reg, volatile.LoadUint32(&o.ICR1.Reg)&^(0x40)|value<<6)
}
func (o *TZSC_Type) GetICR1_FLASHIFCF() uint32 {
	return (volatile.LoadUint32(&o.ICR1.Reg) & 0x40) >> 6
}
func (o *TZSC_Type) SetICR1_DMA1CF(value uint32) {
	volatile.StoreUint32(&o.ICR1.Reg, volatile.LoadUint32(&o.ICR1.Reg)&^(0x80)|value<<7)
}
func (o *TZSC_Type) GetICR1_DMA1CF() uint32 {
	return (volatile.LoadUint32(&o.ICR1.Reg) & 0x80) >> 7
}
func (o *TZSC_Type) SetICR1_DMA2CF(value uint32) {
	volatile.StoreUint32(&o.ICR1.Reg, volatile.LoadUint32(&o.ICR1.Reg)&^(0x100)|value<<8)
}
func (o *TZSC_Type) GetICR1_DMA2CF() uint32 {
	return (volatile.LoadUint32(&o.ICR1.Reg) & 0x100) >> 8
}
func (o *TZSC_Type) SetICR1_DMAMUX1CF(value uint32) {
	volatile.StoreUint32(&o.ICR1.Reg, volatile.LoadUint32(&o.ICR1.Reg)&^(0x200)|value<<9)
}
func (o *TZSC_Type) GetICR1_DMAMUX1CF() uint32 {
	return (volatile.LoadUint32(&o.ICR1.Reg) & 0x200) >> 9
}
func (o *TZSC_Type) SetICR1_FLASHCF(value uint32) {
	volatile.StoreUint32(&o.ICR1.Reg, volatile.LoadUint32(&o.ICR1.Reg)&^(0x400)|value<<10)
}
func (o *TZSC_Type) GetICR1_FLASHCF() uint32 {
	return (volatile.LoadUint32(&o.ICR1.Reg) & 0x400) >> 10
}
func (o *TZSC_Type) SetICR1_SRAM1CF(value uint32) {
	volatile.StoreUint32(&o.ICR1.Reg, volatile.LoadUint32(&o.ICR1.Reg)&^(0x800)|value<<11)
}
func (o *TZSC_Type) GetICR1_SRAM1CF() uint32 {
	return (volatile.LoadUint32(&o.ICR1.Reg) & 0x800) >> 11
}
func (o *TZSC_Type) SetICR1_SRAM2CF(value uint32) {
	volatile.StoreUint32(&o.ICR1.Reg, volatile.LoadUint32(&o.ICR1.Reg)&^(0x1000)|value<<12)
}
func (o *TZSC_Type) GetICR1_SRAM2CF() uint32 {
	return (volatile.LoadUint32(&o.ICR1.Reg) & 0x1000) >> 12
}
func (o *TZSC_Type) SetICR1_PKACF(value uint32) {
	volatile.StoreUint32(&o.ICR1.Reg, volatile.LoadUint32(&o.ICR1.Reg)&^(0x2000)|value<<13)
}
func (o *TZSC_Type) GetICR1_PKACF() uint32 {
	return (volatile.LoadUint32(&o.ICR1.Reg) & 0x2000) >> 13
}

// Voltage reference buffer
type VREFBUF_Type struct {
	CSR volatile.Register32 // 0x0
	CCR volatile.Register32 // 0x4
}

// VREFBUF.CSR: control and status register
func (o *VREFBUF_Type) SetCSR_VRR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *VREFBUF_Type) GetCSR_VRR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *VREFBUF_Type) SetCSR_VRS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *VREFBUF_Type) GetCSR_VRS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *VREFBUF_Type) SetCSR_HIZ(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *VREFBUF_Type) GetCSR_HIZ() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *VREFBUF_Type) SetCSR_ENVR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *VREFBUF_Type) GetCSR_ENVR() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}

// VREFBUF.CCR: calibration control register
func (o *VREFBUF_Type) SetCCR_TRIM(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3f)|value)
}
func (o *VREFBUF_Type) GetCCR_TRIM() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x3f
}

// System window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// WWDG.CR: Control register
func (o *WWDG_Type) SetCR_WDGA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *WWDG_Type) GetCR_WDGA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *WWDG_Type) SetCR_T(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCR_T() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7f
}

// WWDG.CFR: Configuration register
func (o *WWDG_Type) SetCFR_EWI(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x200)|value<<9)
}
func (o *WWDG_Type) GetCFR_EWI() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x200) >> 9
}
func (o *WWDG_Type) SetCFR_W(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCFR_W() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x7f
}
func (o *WWDG_Type) SetCFR_WDGTB(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x3800)|value<<11)
}
func (o *WWDG_Type) GetCFR_WDGTB() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x3800) >> 11
}

// WWDG.SR: Status register
func (o *WWDG_Type) SetSR_EWIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *WWDG_Type) GetSR_EWIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// Constants for ADC: Analog to digital convertor
const (
	// ISR: ADC interrupt and status register
	// Position of ADRDY field.
	ADC_ISR_ADRDY_Pos = 0x0
	// Bit mask of ADRDY field.
	ADC_ISR_ADRDY_Msk = 0x1
	// Bit ADRDY.
	ADC_ISR_ADRDY = 0x1
	// Position of EOSMP field.
	ADC_ISR_EOSMP_Pos = 0x1
	// Bit mask of EOSMP field.
	ADC_ISR_EOSMP_Msk = 0x2
	// Bit EOSMP.
	ADC_ISR_EOSMP = 0x2
	// Position of EOC field.
	ADC_ISR_EOC_Pos = 0x2
	// Bit mask of EOC field.
	ADC_ISR_EOC_Msk = 0x4
	// Bit EOC.
	ADC_ISR_EOC = 0x4
	// Position of EOS field.
	ADC_ISR_EOS_Pos = 0x3
	// Bit mask of EOS field.
	ADC_ISR_EOS_Msk = 0x8
	// Bit EOS.
	ADC_ISR_EOS = 0x8
	// Position of OVR field.
	ADC_ISR_OVR_Pos = 0x4
	// Bit mask of OVR field.
	ADC_ISR_OVR_Msk = 0x10
	// Bit OVR.
	ADC_ISR_OVR = 0x10
	// Position of AWD1 field.
	ADC_ISR_AWD1_Pos = 0x7
	// Bit mask of AWD1 field.
	ADC_ISR_AWD1_Msk = 0x80
	// Bit AWD1.
	ADC_ISR_AWD1 = 0x80
	// Position of AWD2 field.
	ADC_ISR_AWD2_Pos = 0x8
	// Bit mask of AWD2 field.
	ADC_ISR_AWD2_Msk = 0x100
	// Bit AWD2.
	ADC_ISR_AWD2 = 0x100
	// Position of AWD3 field.
	ADC_ISR_AWD3_Pos = 0x9
	// Bit mask of AWD3 field.
	ADC_ISR_AWD3_Msk = 0x200
	// Bit AWD3.
	ADC_ISR_AWD3 = 0x200
	// Position of EOCAL field.
	ADC_ISR_EOCAL_Pos = 0xb
	// Bit mask of EOCAL field.
	ADC_ISR_EOCAL_Msk = 0x800
	// Bit EOCAL.
	ADC_ISR_EOCAL = 0x800
	// Position of CCRDY field.
	ADC_ISR_CCRDY_Pos = 0xd
	// Bit mask of CCRDY field.
	ADC_ISR_CCRDY_Msk = 0x2000
	// Bit CCRDY.
	ADC_ISR_CCRDY = 0x2000

	// IER: ADC interrupt enable register
	// Position of ADRDYIE field.
	ADC_IER_ADRDYIE_Pos = 0x0
	// Bit mask of ADRDYIE field.
	ADC_IER_ADRDYIE_Msk = 0x1
	// Bit ADRDYIE.
	ADC_IER_ADRDYIE = 0x1
	// Position of EOSMPIE field.
	ADC_IER_EOSMPIE_Pos = 0x1
	// Bit mask of EOSMPIE field.
	ADC_IER_EOSMPIE_Msk = 0x2
	// Bit EOSMPIE.
	ADC_IER_EOSMPIE = 0x2
	// Position of EOCIE field.
	ADC_IER_EOCIE_Pos = 0x2
	// Bit mask of EOCIE field.
	ADC_IER_EOCIE_Msk = 0x4
	// Bit EOCIE.
	ADC_IER_EOCIE = 0x4
	// Position of EOSIE field.
	ADC_IER_EOSIE_Pos = 0x3
	// Bit mask of EOSIE field.
	ADC_IER_EOSIE_Msk = 0x8
	// Bit EOSIE.
	ADC_IER_EOSIE = 0x8
	// Position of OVRIE field.
	ADC_IER_OVRIE_Pos = 0x4
	// Bit mask of OVRIE field.
	ADC_IER_OVRIE_Msk = 0x10
	// Bit OVRIE.
	ADC_IER_OVRIE = 0x10
	// Position of AWD1IE field.
	ADC_IER_AWD1IE_Pos = 0x7
	// Bit mask of AWD1IE field.
	ADC_IER_AWD1IE_Msk = 0x80
	// Bit AWD1IE.
	ADC_IER_AWD1IE = 0x80
	// Position of AWD2IE field.
	ADC_IER_AWD2IE_Pos = 0x8
	// Bit mask of AWD2IE field.
	ADC_IER_AWD2IE_Msk = 0x100
	// Bit AWD2IE.
	ADC_IER_AWD2IE = 0x100
	// Position of AWD3IE field.
	ADC_IER_AWD3IE_Pos = 0x9
	// Bit mask of AWD3IE field.
	ADC_IER_AWD3IE_Msk = 0x200
	// Bit AWD3IE.
	ADC_IER_AWD3IE = 0x200
	// Position of EOCALIE field.
	ADC_IER_EOCALIE_Pos = 0xb
	// Bit mask of EOCALIE field.
	ADC_IER_EOCALIE_Msk = 0x800
	// Bit EOCALIE.
	ADC_IER_EOCALIE = 0x800
	// Position of CCRDYIE field.
	ADC_IER_CCRDYIE_Pos = 0xd
	// Bit mask of CCRDYIE field.
	ADC_IER_CCRDYIE_Msk = 0x2000
	// Bit CCRDYIE.
	ADC_IER_CCRDYIE = 0x2000

	// CR: ADC control register
	// Position of ADEN field.
	ADC_CR_ADEN_Pos = 0x0
	// Bit mask of ADEN field.
	ADC_CR_ADEN_Msk = 0x1
	// Bit ADEN.
	ADC_CR_ADEN = 0x1
	// Position of ADDIS field.
	ADC_CR_ADDIS_Pos = 0x1
	// Bit mask of ADDIS field.
	ADC_CR_ADDIS_Msk = 0x2
	// Bit ADDIS.
	ADC_CR_ADDIS = 0x2
	// Position of ADSTART field.
	ADC_CR_ADSTART_Pos = 0x2
	// Bit mask of ADSTART field.
	ADC_CR_ADSTART_Msk = 0x4
	// Bit ADSTART.
	ADC_CR_ADSTART = 0x4
	// Position of ADSTP field.
	ADC_CR_ADSTP_Pos = 0x4
	// Bit mask of ADSTP field.
	ADC_CR_ADSTP_Msk = 0x10
	// Bit ADSTP.
	ADC_CR_ADSTP = 0x10
	// Position of ADVREGEN field.
	ADC_CR_ADVREGEN_Pos = 0x1c
	// Bit mask of ADVREGEN field.
	ADC_CR_ADVREGEN_Msk = 0x10000000
	// Bit ADVREGEN.
	ADC_CR_ADVREGEN = 0x10000000
	// Position of ADCAL field.
	ADC_CR_ADCAL_Pos = 0x1f
	// Bit mask of ADCAL field.
	ADC_CR_ADCAL_Msk = 0x80000000
	// Bit ADCAL.
	ADC_CR_ADCAL = 0x80000000

	// CFGR1: ADC configuration register 1
	// Position of DMAEN field.
	ADC_CFGR1_DMAEN_Pos = 0x0
	// Bit mask of DMAEN field.
	ADC_CFGR1_DMAEN_Msk = 0x1
	// Bit DMAEN.
	ADC_CFGR1_DMAEN = 0x1
	// Position of DMACFG field.
	ADC_CFGR1_DMACFG_Pos = 0x1
	// Bit mask of DMACFG field.
	ADC_CFGR1_DMACFG_Msk = 0x2
	// Bit DMACFG.
	ADC_CFGR1_DMACFG = 0x2
	// Position of SCANDIR field.
	ADC_CFGR1_SCANDIR_Pos = 0x2
	// Bit mask of SCANDIR field.
	ADC_CFGR1_SCANDIR_Msk = 0x4
	// Bit SCANDIR.
	ADC_CFGR1_SCANDIR = 0x4
	// Position of RES field.
	ADC_CFGR1_RES_Pos = 0x3
	// Bit mask of RES field.
	ADC_CFGR1_RES_Msk = 0x18
	// Position of ALIGN field.
	ADC_CFGR1_ALIGN_Pos = 0x5
	// Bit mask of ALIGN field.
	ADC_CFGR1_ALIGN_Msk = 0x20
	// Bit ALIGN.
	ADC_CFGR1_ALIGN = 0x20
	// Position of EXTSEL field.
	ADC_CFGR1_EXTSEL_Pos = 0x6
	// Bit mask of EXTSEL field.
	ADC_CFGR1_EXTSEL_Msk = 0x1c0
	// Position of EXTEN field.
	ADC_CFGR1_EXTEN_Pos = 0xa
	// Bit mask of EXTEN field.
	ADC_CFGR1_EXTEN_Msk = 0xc00
	// Position of OVRMOD field.
	ADC_CFGR1_OVRMOD_Pos = 0xc
	// Bit mask of OVRMOD field.
	ADC_CFGR1_OVRMOD_Msk = 0x1000
	// Bit OVRMOD.
	ADC_CFGR1_OVRMOD = 0x1000
	// Position of CONT field.
	ADC_CFGR1_CONT_Pos = 0xd
	// Bit mask of CONT field.
	ADC_CFGR1_CONT_Msk = 0x2000
	// Bit CONT.
	ADC_CFGR1_CONT = 0x2000
	// Position of WAIT field.
	ADC_CFGR1_WAIT_Pos = 0xe
	// Bit mask of WAIT field.
	ADC_CFGR1_WAIT_Msk = 0x4000
	// Bit WAIT.
	ADC_CFGR1_WAIT = 0x4000
	// Position of AUTOFF field.
	ADC_CFGR1_AUTOFF_Pos = 0xf
	// Bit mask of AUTOFF field.
	ADC_CFGR1_AUTOFF_Msk = 0x8000
	// Bit AUTOFF.
	ADC_CFGR1_AUTOFF = 0x8000
	// Position of DISCEN field.
	ADC_CFGR1_DISCEN_Pos = 0x10
	// Bit mask of DISCEN field.
	ADC_CFGR1_DISCEN_Msk = 0x10000
	// Bit DISCEN.
	ADC_CFGR1_DISCEN = 0x10000
	// Position of CHSELRMOD field.
	ADC_CFGR1_CHSELRMOD_Pos = 0x15
	// Bit mask of CHSELRMOD field.
	ADC_CFGR1_CHSELRMOD_Msk = 0x200000
	// Bit CHSELRMOD.
	ADC_CFGR1_CHSELRMOD = 0x200000
	// Position of AWD1SGL field.
	ADC_CFGR1_AWD1SGL_Pos = 0x16
	// Bit mask of AWD1SGL field.
	ADC_CFGR1_AWD1SGL_Msk = 0x400000
	// Bit AWD1SGL.
	ADC_CFGR1_AWD1SGL = 0x400000
	// Position of AWD1EN field.
	ADC_CFGR1_AWD1EN_Pos = 0x17
	// Bit mask of AWD1EN field.
	ADC_CFGR1_AWD1EN_Msk = 0x800000
	// Bit AWD1EN.
	ADC_CFGR1_AWD1EN = 0x800000
	// Position of AWD1CH field.
	ADC_CFGR1_AWD1CH_Pos = 0x1a
	// Bit mask of AWD1CH field.
	ADC_CFGR1_AWD1CH_Msk = 0x7c000000

	// CFGR2: ADC configuration register 2
	// Position of OVSE field.
	ADC_CFGR2_OVSE_Pos = 0x0
	// Bit mask of OVSE field.
	ADC_CFGR2_OVSE_Msk = 0x1
	// Bit OVSE.
	ADC_CFGR2_OVSE = 0x1
	// Position of OVSR0 field.
	ADC_CFGR2_OVSR0_Pos = 0x2
	// Bit mask of OVSR0 field.
	ADC_CFGR2_OVSR0_Msk = 0x4
	// Bit OVSR0.
	ADC_CFGR2_OVSR0 = 0x4
	// Position of OVSR1 field.
	ADC_CFGR2_OVSR1_Pos = 0x3
	// Bit mask of OVSR1 field.
	ADC_CFGR2_OVSR1_Msk = 0x8
	// Bit OVSR1.
	ADC_CFGR2_OVSR1 = 0x8
	// Position of OVSR2 field.
	ADC_CFGR2_OVSR2_Pos = 0x4
	// Bit mask of OVSR2 field.
	ADC_CFGR2_OVSR2_Msk = 0x10
	// Bit OVSR2.
	ADC_CFGR2_OVSR2 = 0x10
	// Position of OVSS0 field.
	ADC_CFGR2_OVSS0_Pos = 0x5
	// Bit mask of OVSS0 field.
	ADC_CFGR2_OVSS0_Msk = 0x20
	// Bit OVSS0.
	ADC_CFGR2_OVSS0 = 0x20
	// Position of OVSS1 field.
	ADC_CFGR2_OVSS1_Pos = 0x6
	// Bit mask of OVSS1 field.
	ADC_CFGR2_OVSS1_Msk = 0x40
	// Bit OVSS1.
	ADC_CFGR2_OVSS1 = 0x40
	// Position of OVSS2 field.
	ADC_CFGR2_OVSS2_Pos = 0x7
	// Bit mask of OVSS2 field.
	ADC_CFGR2_OVSS2_Msk = 0x80
	// Bit OVSS2.
	ADC_CFGR2_OVSS2 = 0x80
	// Position of OVSS3 field.
	ADC_CFGR2_OVSS3_Pos = 0x8
	// Bit mask of OVSS3 field.
	ADC_CFGR2_OVSS3_Msk = 0x100
	// Bit OVSS3.
	ADC_CFGR2_OVSS3 = 0x100
	// Position of TOVS field.
	ADC_CFGR2_TOVS_Pos = 0x9
	// Bit mask of TOVS field.
	ADC_CFGR2_TOVS_Msk = 0x200
	// Bit TOVS.
	ADC_CFGR2_TOVS = 0x200
	// Position of LFTRIG field.
	ADC_CFGR2_LFTRIG_Pos = 0x1d
	// Bit mask of LFTRIG field.
	ADC_CFGR2_LFTRIG_Msk = 0x20000000
	// Bit LFTRIG.
	ADC_CFGR2_LFTRIG = 0x20000000
	// Position of CKMODE field.
	ADC_CFGR2_CKMODE_Pos = 0x1e
	// Bit mask of CKMODE field.
	ADC_CFGR2_CKMODE_Msk = 0xc0000000

	// SMPR: ADC sampling time register
	// Position of SMP1 field.
	ADC_SMPR_SMP1_Pos = 0x0
	// Bit mask of SMP1 field.
	ADC_SMPR_SMP1_Msk = 0x7
	// Position of SMP2 field.
	ADC_SMPR_SMP2_Pos = 0x4
	// Bit mask of SMP2 field.
	ADC_SMPR_SMP2_Msk = 0x70
	// Position of SMPSEL field.
	ADC_SMPR_SMPSEL_Pos = 0x8
	// Bit mask of SMPSEL field.
	ADC_SMPR_SMPSEL_Msk = 0x3ffff00

	// AWD1TR: ADC watchdog threshold register
	// Position of LT1 field.
	ADC_AWD1TR_LT1_Pos = 0x0
	// Bit mask of LT1 field.
	ADC_AWD1TR_LT1_Msk = 0xfff
	// Position of HT1 field.
	ADC_AWD1TR_HT1_Pos = 0x10
	// Bit mask of HT1 field.
	ADC_AWD1TR_HT1_Msk = 0xfff0000

	// AWD2TR: ADC watchdog threshold register
	// Position of LT2 field.
	ADC_AWD2TR_LT2_Pos = 0x0
	// Bit mask of LT2 field.
	ADC_AWD2TR_LT2_Msk = 0xfff
	// Position of HT2 field.
	ADC_AWD2TR_HT2_Pos = 0x10
	// Bit mask of HT2 field.
	ADC_AWD2TR_HT2_Msk = 0xfff0000

	// CHSELR0: channel selection register
	// Position of CHSEL field.
	ADC_CHSELR0_CHSEL_Pos = 0x0
	// Bit mask of CHSEL field.
	ADC_CHSELR0_CHSEL_Msk = 0x3ffff

	// CHSELR1: channel selection register
	// Position of SQ1 field.
	ADC_CHSELR1_SQ1_Pos = 0x0
	// Bit mask of SQ1 field.
	ADC_CHSELR1_SQ1_Msk = 0xf
	// Position of SQ2 field.
	ADC_CHSELR1_SQ2_Pos = 0x4
	// Bit mask of SQ2 field.
	ADC_CHSELR1_SQ2_Msk = 0xf0
	// Position of SQ3 field.
	ADC_CHSELR1_SQ3_Pos = 0x8
	// Bit mask of SQ3 field.
	ADC_CHSELR1_SQ3_Msk = 0xf00
	// Position of SQ4 field.
	ADC_CHSELR1_SQ4_Pos = 0xc
	// Bit mask of SQ4 field.
	ADC_CHSELR1_SQ4_Msk = 0xf000
	// Position of SQ5 field.
	ADC_CHSELR1_SQ5_Pos = 0x10
	// Bit mask of SQ5 field.
	ADC_CHSELR1_SQ5_Msk = 0xf0000
	// Position of SQ6 field.
	ADC_CHSELR1_SQ6_Pos = 0x14
	// Bit mask of SQ6 field.
	ADC_CHSELR1_SQ6_Msk = 0xf00000
	// Position of SQ7 field.
	ADC_CHSELR1_SQ7_Pos = 0x18
	// Bit mask of SQ7 field.
	ADC_CHSELR1_SQ7_Msk = 0xf000000
	// Position of SQ8 field.
	ADC_CHSELR1_SQ8_Pos = 0x1c
	// Bit mask of SQ8 field.
	ADC_CHSELR1_SQ8_Msk = 0xf0000000

	// AWD3TR: ADC watchdog threshold register
	// Position of LT3 field.
	ADC_AWD3TR_LT3_Pos = 0x0
	// Bit mask of LT3 field.
	ADC_AWD3TR_LT3_Msk = 0xfff
	// Position of HT3 field.
	ADC_AWD3TR_HT3_Pos = 0x10
	// Bit mask of HT3 field.
	ADC_AWD3TR_HT3_Msk = 0xfff0000

	// DR: ADC data register
	// Position of DATA field.
	ADC_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC_DR_DATA_Msk = 0xffff

	// AWD2CR: ADC Analog Watchdog 2 Configuration register
	// Position of AWD2CH field.
	ADC_AWD2CR_AWD2CH_Pos = 0x0
	// Bit mask of AWD2CH field.
	ADC_AWD2CR_AWD2CH_Msk = 0x3ffff

	// AWD3CR: ADC Analog Watchdog 3 Configuration register
	// Position of AWD3CH field.
	ADC_AWD3CR_AWD3CH_Pos = 0x0
	// Bit mask of AWD3CH field.
	ADC_AWD3CR_AWD3CH_Msk = 0x3ffff

	// CALFACT: ADC Calibration factor
	// Position of CALFACT field.
	ADC_CALFACT_CALFACT_Pos = 0x0
	// Bit mask of CALFACT field.
	ADC_CALFACT_CALFACT_Msk = 0x7f

	// CCR: ADC common configuration register
	// Position of PRESC0 field.
	ADC_CCR_PRESC0_Pos = 0x12
	// Bit mask of PRESC0 field.
	ADC_CCR_PRESC0_Msk = 0x40000
	// Bit PRESC0.
	ADC_CCR_PRESC0 = 0x40000
	// Position of PRESC1 field.
	ADC_CCR_PRESC1_Pos = 0x13
	// Bit mask of PRESC1 field.
	ADC_CCR_PRESC1_Msk = 0x80000
	// Bit PRESC1.
	ADC_CCR_PRESC1 = 0x80000
	// Position of PRESC2 field.
	ADC_CCR_PRESC2_Pos = 0x14
	// Bit mask of PRESC2 field.
	ADC_CCR_PRESC2_Msk = 0x100000
	// Bit PRESC2.
	ADC_CCR_PRESC2 = 0x100000
	// Position of PRESC3 field.
	ADC_CCR_PRESC3_Pos = 0x15
	// Bit mask of PRESC3 field.
	ADC_CCR_PRESC3_Msk = 0x200000
	// Bit PRESC3.
	ADC_CCR_PRESC3 = 0x200000
	// Position of VREFEN field.
	ADC_CCR_VREFEN_Pos = 0x16
	// Bit mask of VREFEN field.
	ADC_CCR_VREFEN_Msk = 0x400000
	// Bit VREFEN.
	ADC_CCR_VREFEN = 0x400000
	// Position of TSEN field.
	ADC_CCR_TSEN_Pos = 0x17
	// Bit mask of TSEN field.
	ADC_CCR_TSEN_Msk = 0x800000
	// Bit TSEN.
	ADC_CCR_TSEN = 0x800000
	// Position of VBATEN field.
	ADC_CCR_VBATEN_Pos = 0x18
	// Bit mask of VBATEN field.
	ADC_CCR_VBATEN_Msk = 0x1000000
	// Bit VBATEN.
	ADC_CCR_VBATEN = 0x1000000
)

// Constants for AES: Advanced encryption standard hardware accelerator 1
const (
	// CR: control register
	// Position of NPBLB field.
	AES_CR_NPBLB_Pos = 0x14
	// Bit mask of NPBLB field.
	AES_CR_NPBLB_Msk = 0xf00000
	// Position of KEYSIZE field.
	AES_CR_KEYSIZE_Pos = 0x12
	// Bit mask of KEYSIZE field.
	AES_CR_KEYSIZE_Msk = 0x40000
	// Bit KEYSIZE.
	AES_CR_KEYSIZE = 0x40000
	// 128 bits
	AES_CR_KEYSIZE_Bits128 = 0x0
	// 256 bits
	AES_CR_KEYSIZE_Bits256 = 0x1
	// Position of CHMOD2 field.
	AES_CR_CHMOD2_Pos = 0x10
	// Bit mask of CHMOD2 field.
	AES_CR_CHMOD2_Msk = 0x10000
	// Bit CHMOD2.
	AES_CR_CHMOD2 = 0x10000
	// Mode as per CHMOD (ECB, CBC, CTR, GCM)
	AES_CR_CHMOD2_CHMOD = 0x0
	// Counter with CBC-MAC (CCM) - CHMOD must be 0 (ECB)
	AES_CR_CHMOD2_CCM = 0x1
	// Position of GCMPH field.
	AES_CR_GCMPH_Pos = 0xd
	// Bit mask of GCMPH field.
	AES_CR_GCMPH_Msk = 0x6000
	// Init phase
	AES_CR_GCMPH_Init = 0x0
	// Header phase
	AES_CR_GCMPH_Header = 0x1
	// Payload phase
	AES_CR_GCMPH_Payload = 0x2
	// Final phase
	AES_CR_GCMPH_Final = 0x3
	// Position of DMAOUTEN field.
	AES_CR_DMAOUTEN_Pos = 0xc
	// Bit mask of DMAOUTEN field.
	AES_CR_DMAOUTEN_Msk = 0x1000
	// Bit DMAOUTEN.
	AES_CR_DMAOUTEN = 0x1000
	// Disable DMA Output
	AES_CR_DMAOUTEN_Disabled = 0x0
	// Enabled DMA Output
	AES_CR_DMAOUTEN_Enabled = 0x1
	// Position of DMAINEN field.
	AES_CR_DMAINEN_Pos = 0xb
	// Bit mask of DMAINEN field.
	AES_CR_DMAINEN_Msk = 0x800
	// Bit DMAINEN.
	AES_CR_DMAINEN = 0x800
	// Disable DMA Input
	AES_CR_DMAINEN_Disabled = 0x0
	// Enable DMA Input
	AES_CR_DMAINEN_Enabled = 0x1
	// Position of ERRIE field.
	AES_CR_ERRIE_Pos = 0xa
	// Bit mask of ERRIE field.
	AES_CR_ERRIE_Msk = 0x400
	// Bit ERRIE.
	AES_CR_ERRIE = 0x400
	// Disable (mask) error interrupt
	AES_CR_ERRIE_Disabled = 0x0
	// Enable error interrupt
	AES_CR_ERRIE_Enabled = 0x1
	// Position of CCFIE field.
	AES_CR_CCFIE_Pos = 0x9
	// Bit mask of CCFIE field.
	AES_CR_CCFIE_Msk = 0x200
	// Bit CCFIE.
	AES_CR_CCFIE = 0x200
	// Disable (mask) CCF interrupt
	AES_CR_CCFIE_Disabled = 0x0
	// Enable CCF interrupt
	AES_CR_CCFIE_Enabled = 0x1
	// Position of ERRC field.
	AES_CR_ERRC_Pos = 0x8
	// Bit mask of ERRC field.
	AES_CR_ERRC_Msk = 0x100
	// Bit ERRC.
	AES_CR_ERRC = 0x100
	// Clear RDERR and WRERR flags
	AES_CR_ERRC_Clear = 0x1
	// Position of CCFC field.
	AES_CR_CCFC_Pos = 0x7
	// Bit mask of CCFC field.
	AES_CR_CCFC_Msk = 0x80
	// Bit CCFC.
	AES_CR_CCFC = 0x80
	// Clear computation complete flag
	AES_CR_CCFC_Clear = 0x1
	// Position of CHMOD field.
	AES_CR_CHMOD_Pos = 0x5
	// Bit mask of CHMOD field.
	AES_CR_CHMOD_Msk = 0x60
	// Electronic codebook (ECB) / Counter with CBC-MAC (CCM) if CHMOD2 is 1
	AES_CR_CHMOD_ECB = 0x0
	// Cipher-block chaining (CBC)
	AES_CR_CHMOD_CBC = 0x1
	// Counter mode (CTR)
	AES_CR_CHMOD_CTR = 0x2
	// Galois counter mode (GCM) and Galois message authentication code (GMAC)
	AES_CR_CHMOD_GCM = 0x3
	// Position of MODE field.
	AES_CR_MODE_Pos = 0x3
	// Bit mask of MODE field.
	AES_CR_MODE_Msk = 0x18
	// Mode 1: encryption
	AES_CR_MODE_Mode1 = 0x0
	// Mode 2: key derivation (or key preparation for ECB/CBC decryption)
	AES_CR_MODE_Mode2 = 0x1
	// Mode 3: decryption
	AES_CR_MODE_Mode3 = 0x2
	// Mode 4: key derivation & decrypt (UNDOCUMENTED in ref. manual, exists in CubeMX code)
	AES_CR_MODE_Mode4 = 0x3
	// Position of DATATYPE field.
	AES_CR_DATATYPE_Pos = 0x1
	// Bit mask of DATATYPE field.
	AES_CR_DATATYPE_Msk = 0x6
	// Word
	AES_CR_DATATYPE_None = 0x0
	// Half-word (16-bit)
	AES_CR_DATATYPE_HalfWord = 0x1
	// Byte (8-bit)
	AES_CR_DATATYPE_Byte = 0x2
	// Bit
	AES_CR_DATATYPE_Bit = 0x3
	// Position of EN field.
	AES_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	AES_CR_EN_Msk = 0x1
	// Bit EN.
	AES_CR_EN = 0x1
	// Disable AES
	AES_CR_EN_Disabled = 0x0
	// Enable AES
	AES_CR_EN_Enabled = 0x1

	// SR: status register
	// Position of BUSY field.
	AES_SR_BUSY_Pos = 0x3
	// Bit mask of BUSY field.
	AES_SR_BUSY_Msk = 0x8
	// Bit BUSY.
	AES_SR_BUSY = 0x8
	// Idle
	AES_SR_BUSY_Idle = 0x0
	// Busy
	AES_SR_BUSY_Busy = 0x1
	// Position of WRERR field.
	AES_SR_WRERR_Pos = 0x2
	// Bit mask of WRERR field.
	AES_SR_WRERR_Msk = 0x4
	// Bit WRERR.
	AES_SR_WRERR = 0x4
	// Write error not detected
	AES_SR_WRERR_NoError = 0x0
	// Write error detected
	AES_SR_WRERR_Error = 0x1
	// Position of RDERR field.
	AES_SR_RDERR_Pos = 0x1
	// Bit mask of RDERR field.
	AES_SR_RDERR_Msk = 0x2
	// Bit RDERR.
	AES_SR_RDERR = 0x2
	// Read error not detected
	AES_SR_RDERR_NoError = 0x0
	// Read error detected
	AES_SR_RDERR_Error = 0x1
	// Position of CCF field.
	AES_SR_CCF_Pos = 0x0
	// Bit mask of CCF field.
	AES_SR_CCF_Msk = 0x1
	// Bit CCF.
	AES_SR_CCF = 0x1
	// Computation complete
	AES_SR_CCF_Complete = 0x0
	// Computation not complete
	AES_SR_CCF_NotComplete = 0x1

	// DINR: data input register
	// Position of DIN field.
	AES_DINR_DIN_Pos = 0x0
	// Bit mask of DIN field.
	AES_DINR_DIN_Msk = 0xffffffff

	// DOUTR: data output register
	// Position of DOUT field.
	AES_DOUTR_DOUT_Pos = 0x0
	// Bit mask of DOUT field.
	AES_DOUTR_DOUT_Msk = 0xffffffff

	// KEYR0: key register 0
	// Position of KEY field.
	AES_KEYR0_KEY_Pos = 0x0
	// Bit mask of KEY field.
	AES_KEYR0_KEY_Msk = 0xffffffff

	// KEYR1: key register 1
	// Position of KEY field.
	AES_KEYR1_KEY_Pos = 0x0
	// Bit mask of KEY field.
	AES_KEYR1_KEY_Msk = 0xffffffff

	// KEYR2: key register 2
	// Position of KEY field.
	AES_KEYR2_KEY_Pos = 0x0
	// Bit mask of KEY field.
	AES_KEYR2_KEY_Msk = 0xffffffff

	// KEYR3: key register 3
	// Position of KEY field.
	AES_KEYR3_KEY_Pos = 0x0
	// Bit mask of KEY field.
	AES_KEYR3_KEY_Msk = 0xffffffff

	// IVR0: initialization vector register 0
	// Position of IVI field.
	AES_IVR0_IVI_Pos = 0x0
	// Bit mask of IVI field.
	AES_IVR0_IVI_Msk = 0xffffffff

	// IVR1: initialization vector register 1
	// Position of IVI field.
	AES_IVR1_IVI_Pos = 0x0
	// Bit mask of IVI field.
	AES_IVR1_IVI_Msk = 0xffffffff

	// IVR2: initialization vector register 2
	// Position of IVI field.
	AES_IVR2_IVI_Pos = 0x0
	// Bit mask of IVI field.
	AES_IVR2_IVI_Msk = 0xffffffff

	// IVR3: initialization vector register 3
	// Position of IVI field.
	AES_IVR3_IVI_Pos = 0x0
	// Bit mask of IVI field.
	AES_IVR3_IVI_Msk = 0xffffffff

	// KEYR4: key register 4
	// Position of KEY field.
	AES_KEYR4_KEY_Pos = 0x0
	// Bit mask of KEY field.
	AES_KEYR4_KEY_Msk = 0xffffffff

	// KEYR5: key register 5
	// Position of KEY field.
	AES_KEYR5_KEY_Pos = 0x0
	// Bit mask of KEY field.
	AES_KEYR5_KEY_Msk = 0xffffffff

	// KEYR6: key register 6
	// Position of KEY field.
	AES_KEYR6_KEY_Pos = 0x0
	// Bit mask of KEY field.
	AES_KEYR6_KEY_Msk = 0xffffffff

	// KEYR7: key register 7
	// Position of KEY field.
	AES_KEYR7_KEY_Pos = 0x0
	// Bit mask of KEY field.
	AES_KEYR7_KEY_Msk = 0xffffffff

	// SUSP0R: AES suspend register 0
	// Position of SUSP field.
	AES_SUSP0R_SUSP_Pos = 0x0
	// Bit mask of SUSP field.
	AES_SUSP0R_SUSP_Msk = 0xffffffff

	// SUSP1R: AES suspend register 1
	// Position of SUSP field.
	AES_SUSP1R_SUSP_Pos = 0x0
	// Bit mask of SUSP field.
	AES_SUSP1R_SUSP_Msk = 0xffffffff

	// SUSP2R: AES suspend register 2
	// Position of SUSP field.
	AES_SUSP2R_SUSP_Pos = 0x0
	// Bit mask of SUSP field.
	AES_SUSP2R_SUSP_Msk = 0xffffffff

	// SUSP3R: AES suspend register 3
	// Position of SUSP field.
	AES_SUSP3R_SUSP_Pos = 0x0
	// Bit mask of SUSP field.
	AES_SUSP3R_SUSP_Msk = 0xffffffff

	// SUSP4R: AES suspend register 4
	// Position of SUSP field.
	AES_SUSP4R_SUSP_Pos = 0x0
	// Bit mask of SUSP field.
	AES_SUSP4R_SUSP_Msk = 0xffffffff

	// SUSP5R: AES suspend register 5
	// Position of SUSP field.
	AES_SUSP5R_SUSP_Pos = 0x0
	// Bit mask of SUSP field.
	AES_SUSP5R_SUSP_Msk = 0xffffffff

	// SUSP6R: AES suspend register 6
	// Position of SUSP field.
	AES_SUSP6R_SUSP_Pos = 0x0
	// Bit mask of SUSP field.
	AES_SUSP6R_SUSP_Msk = 0xffffffff

	// SUSP7R: AES suspend register 7
	// Position of SUSP field.
	AES_SUSP7R_SUSP_Pos = 0x0
	// Bit mask of SUSP field.
	AES_SUSP7R_SUSP_Msk = 0xffffffff
)

// Constants for COMP: Comparator
const (
	// COMP1_CSR: COMP1_CSR
	// Position of LOCK field.
	COMP_COMP1_CSR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	COMP_COMP1_CSR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	COMP_COMP1_CSR_LOCK = 0x80000000
	// Comparator CSR bits are read-write
	COMP_COMP1_CSR_LOCK_Unlocked = 0x0
	// Comparator CSR bits are read-only
	COMP_COMP1_CSR_LOCK_Locked = 0x1
	// Position of VALUE field.
	COMP_COMP1_CSR_VALUE_Pos = 0x1e
	// Bit mask of VALUE field.
	COMP_COMP1_CSR_VALUE_Msk = 0x40000000
	// Bit VALUE.
	COMP_COMP1_CSR_VALUE = 0x40000000
	// Comparator output is low
	COMP_COMP1_CSR_VALUE_Low = 0x0
	// Comparator output is high
	COMP_COMP1_CSR_VALUE_High = 0x1
	// Position of INMESEL field.
	COMP_COMP1_CSR_INMESEL_Pos = 0x19
	// Bit mask of INMESEL field.
	COMP_COMP1_CSR_INMESEL_Msk = 0x6000000
	// PA10 connected to input minus
	COMP_COMP1_CSR_INMESEL_PA10 = 0x0
	// PA11 connected to input minus
	COMP_COMP1_CSR_INMESEL_PA11 = 0x1
	// PA15 connected to input minus
	COMP_COMP1_CSR_INMESEL_PA15 = 0x2
	// Position of SCALEN field.
	COMP_COMP1_CSR_SCALEN_Pos = 0x17
	// Bit mask of SCALEN field.
	COMP_COMP1_CSR_SCALEN_Msk = 0x800000
	// Bit SCALEN.
	COMP_COMP1_CSR_SCALEN = 0x800000
	// Voltage scaler disabled
	COMP_COMP1_CSR_SCALEN_Disabled = 0x0
	// Voltage scaler enabled
	COMP_COMP1_CSR_SCALEN_Enabled = 0x1
	// Position of BRGEN field.
	COMP_COMP1_CSR_BRGEN_Pos = 0x16
	// Bit mask of BRGEN field.
	COMP_COMP1_CSR_BRGEN_Msk = 0x400000
	// Bit BRGEN.
	COMP_COMP1_CSR_BRGEN = 0x400000
	// Scaler resistor bridge disabled
	COMP_COMP1_CSR_BRGEN_Disabled = 0x0
	// Scaler resistor bridge enabled
	COMP_COMP1_CSR_BRGEN_Enabled = 0x1
	// Position of BLANKING field.
	COMP_COMP1_CSR_BLANKING_Pos = 0x12
	// Bit mask of BLANKING field.
	COMP_COMP1_CSR_BLANKING_Msk = 0x1c0000
	// No blanking
	COMP_COMP1_CSR_BLANKING_NoBlanking = 0x0
	// TIM1 OC5 selected as blanking source
	COMP_COMP1_CSR_BLANKING_TIM1OC5 = 0x1
	// TIM2 OC3 selected as blanking source
	COMP_COMP1_CSR_BLANKING_TIM2OC3 = 0x2
	// Position of HYST field.
	COMP_COMP1_CSR_HYST_Pos = 0x10
	// Bit mask of HYST field.
	COMP_COMP1_CSR_HYST_Msk = 0x30000
	// No hysteresis
	COMP_COMP1_CSR_HYST_NoHysteresis = 0x0
	// Low hysteresis
	COMP_COMP1_CSR_HYST_LowHysteresis = 0x1
	// Medium hysteresis
	COMP_COMP1_CSR_HYST_MediumHysteresis = 0x2
	// High hysteresis
	COMP_COMP1_CSR_HYST_HighHysteresis = 0x3
	// Position of POLARITY field.
	COMP_COMP1_CSR_POLARITY_Pos = 0xf
	// Bit mask of POLARITY field.
	COMP_COMP1_CSR_POLARITY_Msk = 0x8000
	// Bit POLARITY.
	COMP_COMP1_CSR_POLARITY = 0x8000
	// Output is not inverted
	COMP_COMP1_CSR_POLARITY_NotInverted = 0x0
	// Output is inverted
	COMP_COMP1_CSR_POLARITY_Inverted = 0x1
	// Position of INPSEL field.
	COMP_COMP1_CSR_INPSEL_Pos = 0x7
	// Bit mask of INPSEL field.
	COMP_COMP1_CSR_INPSEL_Msk = 0x180
	// PB4 connected to input plus
	COMP_COMP1_CSR_INPSEL_PB4 = 0x0
	// PB2 connected to input plus
	COMP_COMP1_CSR_INPSEL_PB2 = 0x1
	// Position of INMSEL field.
	COMP_COMP1_CSR_INMSEL_Pos = 0x4
	// Bit mask of INMSEL field.
	COMP_COMP1_CSR_INMSEL_Msk = 0x70
	// 1/4 of VRefint
	COMP_COMP1_CSR_INMSEL_OneQuarterVRef = 0x0
	// 1/2 of VRefint
	COMP_COMP1_CSR_INMSEL_OneHalfVRef = 0x1
	// 3/4 of VRefint
	COMP_COMP1_CSR_INMSEL_ThreeQuarterVRef = 0x2
	// VRefint
	COMP_COMP1_CSR_INMSEL_VRef = 0x3
	// DAC Channel 1
	COMP_COMP1_CSR_INMSEL_DAC_CH1 = 0x4
	// PB3
	COMP_COMP1_CSR_INMSEL_PB3 = 0x6
	// GPIO pin selected by INMESEL
	COMP_COMP1_CSR_INMSEL_GPIO = 0x7
	// Position of PWRMODE field.
	COMP_COMP1_CSR_PWRMODE_Pos = 0x2
	// Bit mask of PWRMODE field.
	COMP_COMP1_CSR_PWRMODE_Msk = 0xc
	// High speed / full power
	COMP_COMP1_CSR_PWRMODE_HighSpeed = 0x0
	// Medium speed / medium power
	COMP_COMP1_CSR_PWRMODE_MediumSpeed = 0x1
	// Low speed / low power
	COMP_COMP1_CSR_PWRMODE_LowSpeed = 0x2
	// Very-low speed / ultra-low power
	COMP_COMP1_CSR_PWRMODE_VeryLowSpeed = 0x3
	// Position of EN field.
	COMP_COMP1_CSR_EN_Pos = 0x0
	// Bit mask of EN field.
	COMP_COMP1_CSR_EN_Msk = 0x1
	// Bit EN.
	COMP_COMP1_CSR_EN = 0x1
	// Comparator 1 disabled
	COMP_COMP1_CSR_EN_Disabled = 0x0
	// Comparator 1 enabled
	COMP_COMP1_CSR_EN_Enabled = 0x1

	// COMP2_CSR: COMP2_CSR
	// Position of LOCK field.
	COMP_COMP2_CSR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	COMP_COMP2_CSR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	COMP_COMP2_CSR_LOCK = 0x80000000
	// Comparator CSR bits are read-write
	COMP_COMP2_CSR_LOCK_Unlocked = 0x0
	// Comparator CSR bits are read-only
	COMP_COMP2_CSR_LOCK_Locked = 0x1
	// Position of VALUE field.
	COMP_COMP2_CSR_VALUE_Pos = 0x1e
	// Bit mask of VALUE field.
	COMP_COMP2_CSR_VALUE_Msk = 0x40000000
	// Bit VALUE.
	COMP_COMP2_CSR_VALUE = 0x40000000
	// Comparator output is low
	COMP_COMP2_CSR_VALUE_Low = 0x0
	// Comparator output is high
	COMP_COMP2_CSR_VALUE_High = 0x1
	// Position of INMESEL field.
	COMP_COMP2_CSR_INMESEL_Pos = 0x19
	// Bit mask of INMESEL field.
	COMP_COMP2_CSR_INMESEL_Msk = 0x6000000
	// PB2 connected to input minus
	COMP_COMP2_CSR_INMESEL_PB2 = 0x0
	// PA10 connected to input minus
	COMP_COMP2_CSR_INMESEL_PA10 = 0x1
	// PA11 connected to input minus
	COMP_COMP2_CSR_INMESEL_PA11 = 0x2
	// Position of SCALEN field.
	COMP_COMP2_CSR_SCALEN_Pos = 0x17
	// Bit mask of SCALEN field.
	COMP_COMP2_CSR_SCALEN_Msk = 0x800000
	// Bit SCALEN.
	COMP_COMP2_CSR_SCALEN = 0x800000
	// Voltage scaler disabled
	COMP_COMP2_CSR_SCALEN_Disabled = 0x0
	// Voltage scaler enabled
	COMP_COMP2_CSR_SCALEN_Enabled = 0x1
	// Position of BRGEN field.
	COMP_COMP2_CSR_BRGEN_Pos = 0x16
	// Bit mask of BRGEN field.
	COMP_COMP2_CSR_BRGEN_Msk = 0x400000
	// Bit BRGEN.
	COMP_COMP2_CSR_BRGEN = 0x400000
	// Scaler resistor bridge disabled
	COMP_COMP2_CSR_BRGEN_Disabled = 0x0
	// Scaler resistor bridge enabled
	COMP_COMP2_CSR_BRGEN_Enabled = 0x1
	// Position of BLANKING field.
	COMP_COMP2_CSR_BLANKING_Pos = 0x12
	// Bit mask of BLANKING field.
	COMP_COMP2_CSR_BLANKING_Msk = 0x1c0000
	// No blanking
	COMP_COMP2_CSR_BLANKING_NoBlanking = 0x0
	// TIM1 OC5 selected as blanking source
	COMP_COMP2_CSR_BLANKING_TIM1OC5 = 0x1
	// TIM2 OC3 selected as blanking source
	COMP_COMP2_CSR_BLANKING_TIM2OC3 = 0x2
	// Position of HYST field.
	COMP_COMP2_CSR_HYST_Pos = 0x10
	// Bit mask of HYST field.
	COMP_COMP2_CSR_HYST_Msk = 0x30000
	// No hysteresis
	COMP_COMP2_CSR_HYST_NoHysteresis = 0x0
	// Low hysteresis
	COMP_COMP2_CSR_HYST_LowHysteresis = 0x1
	// Medium hysteresis
	COMP_COMP2_CSR_HYST_MediumHysteresis = 0x2
	// High hysteresis
	COMP_COMP2_CSR_HYST_HighHysteresis = 0x3
	// Position of POLARITY field.
	COMP_COMP2_CSR_POLARITY_Pos = 0xf
	// Bit mask of POLARITY field.
	COMP_COMP2_CSR_POLARITY_Msk = 0x8000
	// Bit POLARITY.
	COMP_COMP2_CSR_POLARITY = 0x8000
	// Output is not inverted
	COMP_COMP2_CSR_POLARITY_NotInverted = 0x0
	// Output is inverted
	COMP_COMP2_CSR_POLARITY_Inverted = 0x1
	// Position of WINMODE field.
	COMP_COMP2_CSR_WINMODE_Pos = 0x9
	// Bit mask of WINMODE field.
	COMP_COMP2_CSR_WINMODE_Msk = 0x200
	// Bit WINMODE.
	COMP_COMP2_CSR_WINMODE = 0x200
	// COMP2 input plus is not connected to COMP1
	COMP_COMP2_CSR_WINMODE_Disabled = 0x0
	// COMP2 input plus is connected to COMP1
	COMP_COMP2_CSR_WINMODE_Enabled = 0x1
	// Position of INPSEL field.
	COMP_COMP2_CSR_INPSEL_Pos = 0x7
	// Bit mask of INPSEL field.
	COMP_COMP2_CSR_INPSEL_Msk = 0x180
	// PB4 connected to input plus
	COMP_COMP2_CSR_INPSEL_PB4 = 0x0
	// PB1 connected to input plus
	COMP_COMP2_CSR_INPSEL_PB1 = 0x1
	// PA15 connected to input plus
	COMP_COMP2_CSR_INPSEL_PA15 = 0x2
	// Position of INMSEL field.
	COMP_COMP2_CSR_INMSEL_Pos = 0x4
	// Bit mask of INMSEL field.
	COMP_COMP2_CSR_INMSEL_Msk = 0x70
	// 1/4 of VRefint
	COMP_COMP2_CSR_INMSEL_OneQuarterVRef = 0x0
	// 1/2 of VRefint
	COMP_COMP2_CSR_INMSEL_OneHalfVRef = 0x1
	// 3/4 of VRefint
	COMP_COMP2_CSR_INMSEL_ThreeQuarterVRef = 0x2
	// VRefint
	COMP_COMP2_CSR_INMSEL_VRef = 0x3
	// DAC Channel 1
	COMP_COMP2_CSR_INMSEL_DAC_CH1 = 0x4
	// PB3
	COMP_COMP2_CSR_INMSEL_PB3 = 0x6
	// GPIO pin selected by INMESEL
	COMP_COMP2_CSR_INMSEL_GPIO = 0x7
	// Position of PWRMODE field.
	COMP_COMP2_CSR_PWRMODE_Pos = 0x2
	// Bit mask of PWRMODE field.
	COMP_COMP2_CSR_PWRMODE_Msk = 0xc
	// High speed / full power
	COMP_COMP2_CSR_PWRMODE_HighSpeed = 0x0
	// Medium speed / medium power
	COMP_COMP2_CSR_PWRMODE_MediumSpeed = 0x1
	// Low speed / low power
	COMP_COMP2_CSR_PWRMODE_LowSpeed = 0x2
	// Very-low speed / ultra-low power
	COMP_COMP2_CSR_PWRMODE_VeryLowSpeed = 0x3
	// Position of EN field.
	COMP_COMP2_CSR_EN_Pos = 0x0
	// Bit mask of EN field.
	COMP_COMP2_CSR_EN_Msk = 0x1
	// Bit EN.
	COMP_COMP2_CSR_EN = 0x1
	// Comparator 1 disabled
	COMP_COMP2_CSR_EN_Disabled = 0x0
	// Comparator 1 enabled
	COMP_COMP2_CSR_EN_Enabled = 0x1
)

// Constants for CRC: Cyclic redundancy check calculation unit
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// DR8: Data register - byte sized
	// Position of DR8 field.
	CRC_DR8_DR8_Pos = 0x0
	// Bit mask of DR8 field.
	CRC_DR8_DR8_Msk = 0xff

	// DR16: Data register - half-word sized
	// Position of DR16 field.
	CRC_DR16_DR16_Pos = 0x0
	// Bit mask of DR16 field.
	CRC_DR16_DR16_Msk = 0xffff

	// IDR: Independent data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xffffffff

	// CR: Control register
	// Position of REV_OUT field.
	CRC_CR_REV_OUT_Pos = 0x7
	// Bit mask of REV_OUT field.
	CRC_CR_REV_OUT_Msk = 0x80
	// Bit REV_OUT.
	CRC_CR_REV_OUT = 0x80
	// Bit order not affected
	CRC_CR_REV_OUT_Normal = 0x0
	// Bit reversed output
	CRC_CR_REV_OUT_Reversed = 0x1
	// Position of REV_IN field.
	CRC_CR_REV_IN_Pos = 0x5
	// Bit mask of REV_IN field.
	CRC_CR_REV_IN_Msk = 0x60
	// Bit order not affected
	CRC_CR_REV_IN_Normal = 0x0
	// Bit reversal done by byte
	CRC_CR_REV_IN_Byte = 0x1
	// Bit reversal done by half-word
	CRC_CR_REV_IN_HalfWord = 0x2
	// Bit reversal done by word
	CRC_CR_REV_IN_Word = 0x3
	// Position of POLYSIZE field.
	CRC_CR_POLYSIZE_Pos = 0x3
	// Bit mask of POLYSIZE field.
	CRC_CR_POLYSIZE_Msk = 0x18
	// 32-bit polynomial
	CRC_CR_POLYSIZE_Polysize32 = 0x0
	// 16-bit polynomial
	CRC_CR_POLYSIZE_Polysize16 = 0x1
	// 8-bit polynomial
	CRC_CR_POLYSIZE_Polysize8 = 0x2
	// 7-bit polynomial
	CRC_CR_POLYSIZE_Polysize7 = 0x3
	// Position of RESET field.
	CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CR_RESET = 0x1
	// Resets the CRC calculation unit and sets the data register to 0xFFFF FFFF
	CRC_CR_RESET_Reset = 0x1

	// INIT: Initial CRC value
	// Position of INIT field.
	CRC_INIT_INIT_Pos = 0x0
	// Bit mask of INIT field.
	CRC_INIT_INIT_Msk = 0xffffffff

	// POL: polynomial
	// Position of POL field.
	CRC_POL_POL_Pos = 0x0
	// Bit mask of POL field.
	CRC_POL_POL_Msk = 0xffffffff
)

// Constants for DAC: Digital-to-analog converter
const (
	// CR: control register
	// Position of CEN1 field.
	DAC_CR_CEN1_Pos = 0xe
	// Bit mask of CEN1 field.
	DAC_CR_CEN1_Msk = 0x4000
	// Bit CEN1.
	DAC_CR_CEN1 = 0x4000
	// DAC Channel X Normal operating mode
	DAC_CR_CEN1_Normal = 0x0
	// DAC Channel X calibration mode
	DAC_CR_CEN1_Calibration = 0x1
	// Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Pos = 0xd
	// Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000
	// Bit DMAUDRIE1.
	DAC_CR_DMAUDRIE1 = 0x2000
	// DAC Channel X DMA Underrun Interrupt disabled
	DAC_CR_DMAUDRIE1_Disabled = 0x0
	// DAC Channel X DMA Underrun Interrupt enabled
	DAC_CR_DMAUDRIE1_Enabled = 0x1
	// Position of DMAEN1 field.
	DAC_CR_DMAEN1_Pos = 0xc
	// Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1_Msk = 0x1000
	// Bit DMAEN1.
	DAC_CR_DMAEN1 = 0x1000
	// DAC Channel X DMA mode disabled
	DAC_CR_DMAEN1_Disabled = 0x0
	// DAC Channel X DMA mode enabled
	DAC_CR_DMAEN1_Enabled = 0x1
	// Position of MAMP1 field.
	DAC_CR_MAMP1_Pos = 0x8
	// Bit mask of MAMP1 field.
	DAC_CR_MAMP1_Msk = 0xf00
	// Unmask bit0 of LFSR/ triangle amplitude equal to 1
	DAC_CR_MAMP1_Amp1 = 0x0
	// Unmask bits[1:0] of LFSR/ triangle amplitude equal to 3
	DAC_CR_MAMP1_Amp3 = 0x1
	// Unmask bits[2:0] of LFSR/ triangle amplitude equal to 7
	DAC_CR_MAMP1_Amp7 = 0x2
	// Unmask bits[3:0] of LFSR/ triangle amplitude equal to 15
	DAC_CR_MAMP1_Amp15 = 0x3
	// Unmask bits[4:0] of LFSR/ triangle amplitude equal to 31
	DAC_CR_MAMP1_Amp31 = 0x4
	// Unmask bits[5:0] of LFSR/ triangle amplitude equal 63
	DAC_CR_MAMP1_Amp63 = 0x5
	// Unmask bits[6:0] of LFSR/ triangle amplitude equal to 127
	DAC_CR_MAMP1_Amp127 = 0x6
	// Unmask bits[7:0] of LFSR/ triangle amplitude equal to 255
	DAC_CR_MAMP1_Amp255 = 0x7
	// Unmask bits[8:0] of LFSR/ triangle amplitude equal to 511
	DAC_CR_MAMP1_Amp511 = 0x8
	// Unmask bits[9:0] of LFSR/ triangle amplitude equal to 1023
	DAC_CR_MAMP1_Amp1023 = 0x9
	// Unmask bits[10:0] of LFSR/ triangle amplitude equal to 2047
	DAC_CR_MAMP1_Amp2047 = 0xa
	// Unmask bits[11:0] of LFSR/ triangle amplitude equal to 4095
	DAC_CR_MAMP1_Amp4095 = 0xb
	// Position of WAVE1 field.
	DAC_CR_WAVE1_Pos = 0x6
	// Bit mask of WAVE1 field.
	DAC_CR_WAVE1_Msk = 0xc0
	// Wave generation disabled
	DAC_CR_WAVE1_Disabled = 0x0
	// Noise wave generation enabled
	DAC_CR_WAVE1_Noise = 0x1
	// Triangle wave generation enabled
	DAC_CR_WAVE1_Triangle = 0x2
	// Position of TEN1 field.
	DAC_CR_TEN1_Pos = 0x1
	// Bit mask of TEN1 field.
	DAC_CR_TEN1_Msk = 0x2
	// Bit TEN1.
	DAC_CR_TEN1 = 0x2
	// DAC Channel X trigger disabled
	DAC_CR_TEN1_Disabled = 0x0
	// DAC Channel X trigger enabled
	DAC_CR_TEN1_Enabled = 0x1
	// Position of EN1 field.
	DAC_CR_EN1_Pos = 0x0
	// Bit mask of EN1 field.
	DAC_CR_EN1_Msk = 0x1
	// Bit EN1.
	DAC_CR_EN1 = 0x1
	// DAC Channel X disabled
	DAC_CR_EN1_Disabled = 0x0
	// DAC Channel X enabled
	DAC_CR_EN1_Enabled = 0x1
	// Position of TSEL1 field.
	DAC_CR_TSEL1_Pos = 0x2
	// Bit mask of TSEL1 field.
	DAC_CR_TSEL1_Msk = 0x3c
	// SWTRIG1
	DAC_CR_TSEL1_SWTRIG = 0x0
	// dac_chx_trg1
	DAC_CR_TSEL1_TIM1_TRGO = 0x1
	// dac_chx_trg2
	DAC_CR_TSEL1_TIM2_TRGO = 0x2
	// dac_chx_trg3
	DAC_CR_TSEL1_TRG3 = 0x3
	// dac_chx_trg4
	DAC_CR_TSEL1_TRG4 = 0x4
	// dac_chx_trg5
	DAC_CR_TSEL1_TRG5 = 0x5
	// dac_chx_trg6
	DAC_CR_TSEL1_TRG6 = 0x6
	// dac_chx_trg7
	DAC_CR_TSEL1_TRG7 = 0x7
	// dac_chx_trg8
	DAC_CR_TSEL1_TRG8 = 0x8
	// dac_chx_trg9
	DAC_CR_TSEL1_TRG9 = 0x9
	// dac_chx_trg10
	DAC_CR_TSEL1_TRG10 = 0xa
	// dac_chx_trg11
	DAC_CR_TSEL1_LPTIM1_OUT = 0xb
	// dac_chx_trg12
	DAC_CR_TSEL1_LPTIM2_OUT = 0xc
	// dac_chx_trg13
	DAC_CR_TSEL1_LPTIM3_OUT = 0xd
	// dac_chx_trg14
	DAC_CR_TSEL1_EXTI9 = 0xe
	// dac_chx_trg15
	DAC_CR_TSEL1_TRG15 = 0xf

	// SWTRGR: software trigger register
	// Position of SWTRIG1 field.
	DAC_SWTRGR_SWTRIG1_Pos = 0x0
	// Bit mask of SWTRIG1 field.
	DAC_SWTRGR_SWTRIG1_Msk = 0x1
	// Bit SWTRIG1.
	DAC_SWTRGR_SWTRIG1 = 0x1
	// No trigger
	DAC_SWTRGR_SWTRIG1_NoTrigger = 0x0
	// Trigger
	DAC_SWTRGR_SWTRIG1_Trigger = 0x1

	// DHR12R1: channel1 12-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff

	// DHR12L1: channel1 12-bit left aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0

	// DHR8R1: channel1 8-bit right aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff

	// DHR12RD: Dual DAC 12-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Msk = 0xfff

	// DHR12LD: Dual DAC 12-bit left aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Msk = 0xfff0

	// DHR8RD: Dual DAC 8-bit right aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Msk = 0xff

	// DOR1: DAC channel1 data output register
	// Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Pos = 0x0
	// Bit mask of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff

	// SR: status register
	// Position of BWST1 field.
	DAC_SR_BWST1_Pos = 0xf
	// Bit mask of BWST1 field.
	DAC_SR_BWST1_Msk = 0x8000
	// Bit BWST1.
	DAC_SR_BWST1 = 0x8000
	// There is no write operation of DAC_SHSR1 ongoing: DAC_SHSR1 can be written
	DAC_SR_BWST1_Idle = 0x0
	// There is a write operation of DAC_SHSR1 ongoing: DAC_SHSR1 cannot be written
	DAC_SR_BWST1_Busy = 0x1
	// Position of CAL_FLAG1 field.
	DAC_SR_CAL_FLAG1_Pos = 0xe
	// Bit mask of CAL_FLAG1 field.
	DAC_SR_CAL_FLAG1_Msk = 0x4000
	// Bit CAL_FLAG1.
	DAC_SR_CAL_FLAG1 = 0x4000
	// Calibration trimming value is lower than the offset correction value
	DAC_SR_CAL_FLAG1_Lower = 0x0
	// Calibration trimming value is equal or greater than the offset correction value
	DAC_SR_CAL_FLAG1_Equal_Higher = 0x1
	// Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Pos = 0xd
	// Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk = 0x2000
	// Bit DMAUDR1.
	DAC_SR_DMAUDR1 = 0x2000
	// No DMA underrun error condition occurred for DAC channel x
	DAC_SR_DMAUDR1_NoError = 0x0
	// DMA underrun error condition occurred for DAC channel x (the currently selected trigger is driving DAC channel1 conversion at a frequency higher than the DMA service capability rate)
	DAC_SR_DMAUDR1_Error = 0x1

	// CCR: calibration control register
	// Position of OTRIM1 field.
	DAC_CCR_OTRIM1_Pos = 0x0
	// Bit mask of OTRIM1 field.
	DAC_CCR_OTRIM1_Msk = 0x1f

	// MCR: mode control register
	// Position of MODE1 field.
	DAC_MCR_MODE1_Pos = 0x0
	// Bit mask of MODE1 field.
	DAC_MCR_MODE1_Msk = 0x7
	// Normal mode - DAC channelx is connected to external pin with Buffer enabled
	DAC_MCR_MODE1_NormalPinBuffer = 0x0
	// Normal mode - DAC channelx is connected to external pin and to on chip peripherals with Buffer enabled
	DAC_MCR_MODE1_NormalPinChipBuffer = 0x1
	// Normal mode - DAC channelx is connected to external pin with Buffer disabled
	DAC_MCR_MODE1_NormalPinNoBuffer = 0x2
	// Normal mode - DAC channelx is connected to on chip peripherals with Buffer disabled
	DAC_MCR_MODE1_NormalChipNoBuffer = 0x3
	// S&H mode - DAC channelx is connected to external pin with Buffer enabled
	DAC_MCR_MODE1_SHPinBuffer = 0x4
	// S&H mode - DAC channelx is connected to external pin and to on chip peripherals with Buffer enabled
	DAC_MCR_MODE1_SHPinChipBuffer = 0x5
	// S&H mode - DAC channelx is connected to external pin and to on chip peripherals with Buffer disabled
	DAC_MCR_MODE1_SHPinNoBuffer = 0x6
	// S&H mode - DAC channelx is connected to on chip peripherals with Buffer disabled
	DAC_MCR_MODE1_SHChipNoBuffer = 0x7

	// SHSR1: Sample and Hold sample time register 1
	// Position of TSAMPLE1 field.
	DAC_SHSR1_TSAMPLE1_Pos = 0x0
	// Bit mask of TSAMPLE1 field.
	DAC_SHSR1_TSAMPLE1_Msk = 0x3ff

	// SHHR: Sample and Hold hold time register
	// Position of THOLD1 field.
	DAC_SHHR_THOLD1_Pos = 0x0
	// Bit mask of THOLD1 field.
	DAC_SHHR_THOLD1_Msk = 0x3ff

	// SHRR: Sample and Hold refresh time register
	// Position of TREFRESH1 field.
	DAC_SHRR_TREFRESH1_Pos = 0x0
	// Bit mask of TREFRESH1 field.
	DAC_SHRR_TREFRESH1_Msk = 0xff
)

// Constants for DMA1: Direct memory access controller
const (
	// ISR: interrupt status register
	// Position of TEIF7 field.
	DMA_ISR_TEIF7_Pos = 0x1b
	// Bit mask of TEIF7 field.
	DMA_ISR_TEIF7_Msk = 0x8000000
	// Bit TEIF7.
	DMA_ISR_TEIF7 = 0x8000000
	// No transfer error on channel x
	DMA_ISR_TEIF7_NoError = 0x0
	// A transfer error occurred on channel x
	DMA_ISR_TEIF7_Error = 0x1
	// Position of HTIF7 field.
	DMA_ISR_HTIF7_Pos = 0x1a
	// Bit mask of HTIF7 field.
	DMA_ISR_HTIF7_Msk = 0x4000000
	// Bit HTIF7.
	DMA_ISR_HTIF7 = 0x4000000
	// No half transfer event on channel x
	DMA_ISR_HTIF7_NotHalf = 0x0
	// A half transfer event occurred on channel x
	DMA_ISR_HTIF7_Half = 0x1
	// Position of TCIF7 field.
	DMA_ISR_TCIF7_Pos = 0x19
	// Bit mask of TCIF7 field.
	DMA_ISR_TCIF7_Msk = 0x2000000
	// Bit TCIF7.
	DMA_ISR_TCIF7 = 0x2000000
	// No transfer complete event on channel x
	DMA_ISR_TCIF7_NotComplete = 0x0
	// A transfer complete event occurred on channel x
	DMA_ISR_TCIF7_Complete = 0x1
	// Position of GIF7 field.
	DMA_ISR_GIF7_Pos = 0x18
	// Bit mask of GIF7 field.
	DMA_ISR_GIF7_Msk = 0x1000000
	// Bit GIF7.
	DMA_ISR_GIF7 = 0x1000000
	// No TE, HT or TC event on channel x
	DMA_ISR_GIF7_NoEvent = 0x0
	// A TE, HT or TC event occurred on channel x
	DMA_ISR_GIF7_Event = 0x1
	// Position of TEIF6 field.
	DMA_ISR_TEIF6_Pos = 0x17
	// Bit mask of TEIF6 field.
	DMA_ISR_TEIF6_Msk = 0x800000
	// Bit TEIF6.
	DMA_ISR_TEIF6 = 0x800000
	// No transfer error on channel x
	DMA_ISR_TEIF6_NoError = 0x0
	// A transfer error occurred on channel x
	DMA_ISR_TEIF6_Error = 0x1
	// Position of HTIF6 field.
	DMA_ISR_HTIF6_Pos = 0x16
	// Bit mask of HTIF6 field.
	DMA_ISR_HTIF6_Msk = 0x400000
	// Bit HTIF6.
	DMA_ISR_HTIF6 = 0x400000
	// No half transfer event on channel x
	DMA_ISR_HTIF6_NotHalf = 0x0
	// A half transfer event occurred on channel x
	DMA_ISR_HTIF6_Half = 0x1
	// Position of TCIF6 field.
	DMA_ISR_TCIF6_Pos = 0x15
	// Bit mask of TCIF6 field.
	DMA_ISR_TCIF6_Msk = 0x200000
	// Bit TCIF6.
	DMA_ISR_TCIF6 = 0x200000
	// No transfer complete event on channel x
	DMA_ISR_TCIF6_NotComplete = 0x0
	// A transfer complete event occurred on channel x
	DMA_ISR_TCIF6_Complete = 0x1
	// Position of GIF6 field.
	DMA_ISR_GIF6_Pos = 0x14
	// Bit mask of GIF6 field.
	DMA_ISR_GIF6_Msk = 0x100000
	// Bit GIF6.
	DMA_ISR_GIF6 = 0x100000
	// No TE, HT or TC event on channel x
	DMA_ISR_GIF6_NoEvent = 0x0
	// A TE, HT or TC event occurred on channel x
	DMA_ISR_GIF6_Event = 0x1
	// Position of TEIF5 field.
	DMA_ISR_TEIF5_Pos = 0x13
	// Bit mask of TEIF5 field.
	DMA_ISR_TEIF5_Msk = 0x80000
	// Bit TEIF5.
	DMA_ISR_TEIF5 = 0x80000
	// No transfer error on channel x
	DMA_ISR_TEIF5_NoError = 0x0
	// A transfer error occurred on channel x
	DMA_ISR_TEIF5_Error = 0x1
	// Position of HTIF5 field.
	DMA_ISR_HTIF5_Pos = 0x12
	// Bit mask of HTIF5 field.
	DMA_ISR_HTIF5_Msk = 0x40000
	// Bit HTIF5.
	DMA_ISR_HTIF5 = 0x40000
	// No half transfer event on channel x
	DMA_ISR_HTIF5_NotHalf = 0x0
	// A half transfer event occurred on channel x
	DMA_ISR_HTIF5_Half = 0x1
	// Position of TCIF5 field.
	DMA_ISR_TCIF5_Pos = 0x11
	// Bit mask of TCIF5 field.
	DMA_ISR_TCIF5_Msk = 0x20000
	// Bit TCIF5.
	DMA_ISR_TCIF5 = 0x20000
	// No transfer complete event on channel x
	DMA_ISR_TCIF5_NotComplete = 0x0
	// A transfer complete event occurred on channel x
	DMA_ISR_TCIF5_Complete = 0x1
	// Position of GIF5 field.
	DMA_ISR_GIF5_Pos = 0x10
	// Bit mask of GIF5 field.
	DMA_ISR_GIF5_Msk = 0x10000
	// Bit GIF5.
	DMA_ISR_GIF5 = 0x10000
	// No TE, HT or TC event on channel x
	DMA_ISR_GIF5_NoEvent = 0x0
	// A TE, HT or TC event occurred on channel x
	DMA_ISR_GIF5_Event = 0x1
	// Position of TEIF4 field.
	DMA_ISR_TEIF4_Pos = 0xf
	// Bit mask of TEIF4 field.
	DMA_ISR_TEIF4_Msk = 0x8000
	// Bit TEIF4.
	DMA_ISR_TEIF4 = 0x8000
	// No transfer error on channel x
	DMA_ISR_TEIF4_NoError = 0x0
	// A transfer error occurred on channel x
	DMA_ISR_TEIF4_Error = 0x1
	// Position of HTIF4 field.
	DMA_ISR_HTIF4_Pos = 0xe
	// Bit mask of HTIF4 field.
	DMA_ISR_HTIF4_Msk = 0x4000
	// Bit HTIF4.
	DMA_ISR_HTIF4 = 0x4000
	// No half transfer event on channel x
	DMA_ISR_HTIF4_NotHalf = 0x0
	// A half transfer event occurred on channel x
	DMA_ISR_HTIF4_Half = 0x1
	// Position of TCIF4 field.
	DMA_ISR_TCIF4_Pos = 0xd
	// Bit mask of TCIF4 field.
	DMA_ISR_TCIF4_Msk = 0x2000
	// Bit TCIF4.
	DMA_ISR_TCIF4 = 0x2000
	// No transfer complete event on channel x
	DMA_ISR_TCIF4_NotComplete = 0x0
	// A transfer complete event occurred on channel x
	DMA_ISR_TCIF4_Complete = 0x1
	// Position of GIF4 field.
	DMA_ISR_GIF4_Pos = 0xc
	// Bit mask of GIF4 field.
	DMA_ISR_GIF4_Msk = 0x1000
	// Bit GIF4.
	DMA_ISR_GIF4 = 0x1000
	// No TE, HT or TC event on channel x
	DMA_ISR_GIF4_NoEvent = 0x0
	// A TE, HT or TC event occurred on channel x
	DMA_ISR_GIF4_Event = 0x1
	// Position of TEIF3 field.
	DMA_ISR_TEIF3_Pos = 0xb
	// Bit mask of TEIF3 field.
	DMA_ISR_TEIF3_Msk = 0x800
	// Bit TEIF3.
	DMA_ISR_TEIF3 = 0x800
	// No transfer error on channel x
	DMA_ISR_TEIF3_NoError = 0x0
	// A transfer error occurred on channel x
	DMA_ISR_TEIF3_Error = 0x1
	// Position of HTIF3 field.
	DMA_ISR_HTIF3_Pos = 0xa
	// Bit mask of HTIF3 field.
	DMA_ISR_HTIF3_Msk = 0x400
	// Bit HTIF3.
	DMA_ISR_HTIF3 = 0x400
	// No half transfer event on channel x
	DMA_ISR_HTIF3_NotHalf = 0x0
	// A half transfer event occurred on channel x
	DMA_ISR_HTIF3_Half = 0x1
	// Position of TCIF3 field.
	DMA_ISR_TCIF3_Pos = 0x9
	// Bit mask of TCIF3 field.
	DMA_ISR_TCIF3_Msk = 0x200
	// Bit TCIF3.
	DMA_ISR_TCIF3 = 0x200
	// No transfer complete event on channel x
	DMA_ISR_TCIF3_NotComplete = 0x0
	// A transfer complete event occurred on channel x
	DMA_ISR_TCIF3_Complete = 0x1
	// Position of GIF3 field.
	DMA_ISR_GIF3_Pos = 0x8
	// Bit mask of GIF3 field.
	DMA_ISR_GIF3_Msk = 0x100
	// Bit GIF3.
	DMA_ISR_GIF3 = 0x100
	// No TE, HT or TC event on channel x
	DMA_ISR_GIF3_NoEvent = 0x0
	// A TE, HT or TC event occurred on channel x
	DMA_ISR_GIF3_Event = 0x1
	// Position of TEIF2 field.
	DMA_ISR_TEIF2_Pos = 0x7
	// Bit mask of TEIF2 field.
	DMA_ISR_TEIF2_Msk = 0x80
	// Bit TEIF2.
	DMA_ISR_TEIF2 = 0x80
	// No transfer error on channel x
	DMA_ISR_TEIF2_NoError = 0x0
	// A transfer error occurred on channel x
	DMA_ISR_TEIF2_Error = 0x1
	// Position of HTIF2 field.
	DMA_ISR_HTIF2_Pos = 0x6
	// Bit mask of HTIF2 field.
	DMA_ISR_HTIF2_Msk = 0x40
	// Bit HTIF2.
	DMA_ISR_HTIF2 = 0x40
	// No half transfer event on channel x
	DMA_ISR_HTIF2_NotHalf = 0x0
	// A half transfer event occurred on channel x
	DMA_ISR_HTIF2_Half = 0x1
	// Position of TCIF2 field.
	DMA_ISR_TCIF2_Pos = 0x5
	// Bit mask of TCIF2 field.
	DMA_ISR_TCIF2_Msk = 0x20
	// Bit TCIF2.
	DMA_ISR_TCIF2 = 0x20
	// No transfer complete event on channel x
	DMA_ISR_TCIF2_NotComplete = 0x0
	// A transfer complete event occurred on channel x
	DMA_ISR_TCIF2_Complete = 0x1
	// Position of GIF2 field.
	DMA_ISR_GIF2_Pos = 0x4
	// Bit mask of GIF2 field.
	DMA_ISR_GIF2_Msk = 0x10
	// Bit GIF2.
	DMA_ISR_GIF2 = 0x10
	// No TE, HT or TC event on channel x
	DMA_ISR_GIF2_NoEvent = 0x0
	// A TE, HT or TC event occurred on channel x
	DMA_ISR_GIF2_Event = 0x1
	// Position of TEIF1 field.
	DMA_ISR_TEIF1_Pos = 0x3
	// Bit mask of TEIF1 field.
	DMA_ISR_TEIF1_Msk = 0x8
	// Bit TEIF1.
	DMA_ISR_TEIF1 = 0x8
	// No transfer error on channel x
	DMA_ISR_TEIF1_NoError = 0x0
	// A transfer error occurred on channel x
	DMA_ISR_TEIF1_Error = 0x1
	// Position of HTIF1 field.
	DMA_ISR_HTIF1_Pos = 0x2
	// Bit mask of HTIF1 field.
	DMA_ISR_HTIF1_Msk = 0x4
	// Bit HTIF1.
	DMA_ISR_HTIF1 = 0x4
	// No half transfer event on channel x
	DMA_ISR_HTIF1_NotHalf = 0x0
	// A half transfer event occurred on channel x
	DMA_ISR_HTIF1_Half = 0x1
	// Position of TCIF1 field.
	DMA_ISR_TCIF1_Pos = 0x1
	// Bit mask of TCIF1 field.
	DMA_ISR_TCIF1_Msk = 0x2
	// Bit TCIF1.
	DMA_ISR_TCIF1 = 0x2
	// No transfer complete event on channel x
	DMA_ISR_TCIF1_NotComplete = 0x0
	// A transfer complete event occurred on channel x
	DMA_ISR_TCIF1_Complete = 0x1
	// Position of GIF1 field.
	DMA_ISR_GIF1_Pos = 0x0
	// Bit mask of GIF1 field.
	DMA_ISR_GIF1_Msk = 0x1
	// Bit GIF1.
	DMA_ISR_GIF1 = 0x1
	// No TE, HT or TC event on channel x
	DMA_ISR_GIF1_NoEvent = 0x0
	// A TE, HT or TC event occurred on channel x
	DMA_ISR_GIF1_Event = 0x1

	// IFCR: interrupt flag clear register
	// Position of TEIF7 field.
	DMA_IFCR_TEIF7_Pos = 0x1b
	// Bit mask of TEIF7 field.
	DMA_IFCR_TEIF7_Msk = 0x8000000
	// Bit TEIF7.
	DMA_IFCR_TEIF7 = 0x8000000
	// Clear the corresponding TEIFx flag
	DMA_IFCR_TEIF7_Clear = 0x1
	// Position of HTIF7 field.
	DMA_IFCR_HTIF7_Pos = 0x1a
	// Bit mask of HTIF7 field.
	DMA_IFCR_HTIF7_Msk = 0x4000000
	// Bit HTIF7.
	DMA_IFCR_HTIF7 = 0x4000000
	// Clear the corresponding HTIFx flag
	DMA_IFCR_HTIF7_Clear = 0x1
	// Position of TCIF7 field.
	DMA_IFCR_TCIF7_Pos = 0x19
	// Bit mask of TCIF7 field.
	DMA_IFCR_TCIF7_Msk = 0x2000000
	// Bit TCIF7.
	DMA_IFCR_TCIF7 = 0x2000000
	// Clear the corresponding TCIFx flag
	DMA_IFCR_TCIF7_Clear = 0x1
	// Position of GIF7 field.
	DMA_IFCR_GIF7_Pos = 0x18
	// Bit mask of GIF7 field.
	DMA_IFCR_GIF7_Msk = 0x1000000
	// Bit GIF7.
	DMA_IFCR_GIF7 = 0x1000000
	// Clear the corresponding CGIFx flag
	DMA_IFCR_GIF7_Clear = 0x1
	// Position of TEIF6 field.
	DMA_IFCR_TEIF6_Pos = 0x17
	// Bit mask of TEIF6 field.
	DMA_IFCR_TEIF6_Msk = 0x800000
	// Bit TEIF6.
	DMA_IFCR_TEIF6 = 0x800000
	// Clear the corresponding TEIFx flag
	DMA_IFCR_TEIF6_Clear = 0x1
	// Position of HTIF6 field.
	DMA_IFCR_HTIF6_Pos = 0x16
	// Bit mask of HTIF6 field.
	DMA_IFCR_HTIF6_Msk = 0x400000
	// Bit HTIF6.
	DMA_IFCR_HTIF6 = 0x400000
	// Clear the corresponding HTIFx flag
	DMA_IFCR_HTIF6_Clear = 0x1
	// Position of TCIF6 field.
	DMA_IFCR_TCIF6_Pos = 0x15
	// Bit mask of TCIF6 field.
	DMA_IFCR_TCIF6_Msk = 0x200000
	// Bit TCIF6.
	DMA_IFCR_TCIF6 = 0x200000
	// Clear the corresponding TCIFx flag
	DMA_IFCR_TCIF6_Clear = 0x1
	// Position of GIF6 field.
	DMA_IFCR_GIF6_Pos = 0x14
	// Bit mask of GIF6 field.
	DMA_IFCR_GIF6_Msk = 0x100000
	// Bit GIF6.
	DMA_IFCR_GIF6 = 0x100000
	// Clear the corresponding CGIFx flag
	DMA_IFCR_GIF6_Clear = 0x1
	// Position of TEIF5 field.
	DMA_IFCR_TEIF5_Pos = 0x13
	// Bit mask of TEIF5 field.
	DMA_IFCR_TEIF5_Msk = 0x80000
	// Bit TEIF5.
	DMA_IFCR_TEIF5 = 0x80000
	// Clear the corresponding TEIFx flag
	DMA_IFCR_TEIF5_Clear = 0x1
	// Position of HTIF5 field.
	DMA_IFCR_HTIF5_Pos = 0x12
	// Bit mask of HTIF5 field.
	DMA_IFCR_HTIF5_Msk = 0x40000
	// Bit HTIF5.
	DMA_IFCR_HTIF5 = 0x40000
	// Clear the corresponding HTIFx flag
	DMA_IFCR_HTIF5_Clear = 0x1
	// Position of TCIF5 field.
	DMA_IFCR_TCIF5_Pos = 0x11
	// Bit mask of TCIF5 field.
	DMA_IFCR_TCIF5_Msk = 0x20000
	// Bit TCIF5.
	DMA_IFCR_TCIF5 = 0x20000
	// Clear the corresponding TCIFx flag
	DMA_IFCR_TCIF5_Clear = 0x1
	// Position of GIF5 field.
	DMA_IFCR_GIF5_Pos = 0x10
	// Bit mask of GIF5 field.
	DMA_IFCR_GIF5_Msk = 0x10000
	// Bit GIF5.
	DMA_IFCR_GIF5 = 0x10000
	// Clear the corresponding CGIFx flag
	DMA_IFCR_GIF5_Clear = 0x1
	// Position of TEIF4 field.
	DMA_IFCR_TEIF4_Pos = 0xf
	// Bit mask of TEIF4 field.
	DMA_IFCR_TEIF4_Msk = 0x8000
	// Bit TEIF4.
	DMA_IFCR_TEIF4 = 0x8000
	// Clear the corresponding TEIFx flag
	DMA_IFCR_TEIF4_Clear = 0x1
	// Position of HTIF4 field.
	DMA_IFCR_HTIF4_Pos = 0xe
	// Bit mask of HTIF4 field.
	DMA_IFCR_HTIF4_Msk = 0x4000
	// Bit HTIF4.
	DMA_IFCR_HTIF4 = 0x4000
	// Clear the corresponding HTIFx flag
	DMA_IFCR_HTIF4_Clear = 0x1
	// Position of TCIF4 field.
	DMA_IFCR_TCIF4_Pos = 0xd
	// Bit mask of TCIF4 field.
	DMA_IFCR_TCIF4_Msk = 0x2000
	// Bit TCIF4.
	DMA_IFCR_TCIF4 = 0x2000
	// Clear the corresponding TCIFx flag
	DMA_IFCR_TCIF4_Clear = 0x1
	// Position of GIF4 field.
	DMA_IFCR_GIF4_Pos = 0xc
	// Bit mask of GIF4 field.
	DMA_IFCR_GIF4_Msk = 0x1000
	// Bit GIF4.
	DMA_IFCR_GIF4 = 0x1000
	// Clear the corresponding CGIFx flag
	DMA_IFCR_GIF4_Clear = 0x1
	// Position of TEIF3 field.
	DMA_IFCR_TEIF3_Pos = 0xb
	// Bit mask of TEIF3 field.
	DMA_IFCR_TEIF3_Msk = 0x800
	// Bit TEIF3.
	DMA_IFCR_TEIF3 = 0x800
	// Clear the corresponding TEIFx flag
	DMA_IFCR_TEIF3_Clear = 0x1
	// Position of HTIF3 field.
	DMA_IFCR_HTIF3_Pos = 0xa
	// Bit mask of HTIF3 field.
	DMA_IFCR_HTIF3_Msk = 0x400
	// Bit HTIF3.
	DMA_IFCR_HTIF3 = 0x400
	// Clear the corresponding HTIFx flag
	DMA_IFCR_HTIF3_Clear = 0x1
	// Position of TCIF3 field.
	DMA_IFCR_TCIF3_Pos = 0x9
	// Bit mask of TCIF3 field.
	DMA_IFCR_TCIF3_Msk = 0x200
	// Bit TCIF3.
	DMA_IFCR_TCIF3 = 0x200
	// Clear the corresponding TCIFx flag
	DMA_IFCR_TCIF3_Clear = 0x1
	// Position of GIF3 field.
	DMA_IFCR_GIF3_Pos = 0x8
	// Bit mask of GIF3 field.
	DMA_IFCR_GIF3_Msk = 0x100
	// Bit GIF3.
	DMA_IFCR_GIF3 = 0x100
	// Clear the corresponding CGIFx flag
	DMA_IFCR_GIF3_Clear = 0x1
	// Position of TEIF2 field.
	DMA_IFCR_TEIF2_Pos = 0x7
	// Bit mask of TEIF2 field.
	DMA_IFCR_TEIF2_Msk = 0x80
	// Bit TEIF2.
	DMA_IFCR_TEIF2 = 0x80
	// Clear the corresponding TEIFx flag
	DMA_IFCR_TEIF2_Clear = 0x1
	// Position of HTIF2 field.
	DMA_IFCR_HTIF2_Pos = 0x6
	// Bit mask of HTIF2 field.
	DMA_IFCR_HTIF2_Msk = 0x40
	// Bit HTIF2.
	DMA_IFCR_HTIF2 = 0x40
	// Clear the corresponding HTIFx flag
	DMA_IFCR_HTIF2_Clear = 0x1
	// Position of TCIF2 field.
	DMA_IFCR_TCIF2_Pos = 0x5
	// Bit mask of TCIF2 field.
	DMA_IFCR_TCIF2_Msk = 0x20
	// Bit TCIF2.
	DMA_IFCR_TCIF2 = 0x20
	// Clear the corresponding TCIFx flag
	DMA_IFCR_TCIF2_Clear = 0x1
	// Position of GIF2 field.
	DMA_IFCR_GIF2_Pos = 0x4
	// Bit mask of GIF2 field.
	DMA_IFCR_GIF2_Msk = 0x10
	// Bit GIF2.
	DMA_IFCR_GIF2 = 0x10
	// Clear the corresponding CGIFx flag
	DMA_IFCR_GIF2_Clear = 0x1
	// Position of TEIF1 field.
	DMA_IFCR_TEIF1_Pos = 0x3
	// Bit mask of TEIF1 field.
	DMA_IFCR_TEIF1_Msk = 0x8
	// Bit TEIF1.
	DMA_IFCR_TEIF1 = 0x8
	// Clear the corresponding TEIFx flag
	DMA_IFCR_TEIF1_Clear = 0x1
	// Position of HTIF1 field.
	DMA_IFCR_HTIF1_Pos = 0x2
	// Bit mask of HTIF1 field.
	DMA_IFCR_HTIF1_Msk = 0x4
	// Bit HTIF1.
	DMA_IFCR_HTIF1 = 0x4
	// Clear the corresponding HTIFx flag
	DMA_IFCR_HTIF1_Clear = 0x1
	// Position of TCIF1 field.
	DMA_IFCR_TCIF1_Pos = 0x1
	// Bit mask of TCIF1 field.
	DMA_IFCR_TCIF1_Msk = 0x2
	// Bit TCIF1.
	DMA_IFCR_TCIF1 = 0x2
	// Clear the corresponding TCIFx flag
	DMA_IFCR_TCIF1_Clear = 0x1
	// Position of GIF1 field.
	DMA_IFCR_GIF1_Pos = 0x0
	// Bit mask of GIF1 field.
	DMA_IFCR_GIF1_Msk = 0x1
	// Bit GIF1.
	DMA_IFCR_GIF1 = 0x1
	// Clear the corresponding CGIFx flag
	DMA_IFCR_GIF1_Clear = 0x1

	// CCR1: channel x configuration register
	// Position of PRIV field.
	DMA_CCR1_PRIV_Pos = 0x14
	// Bit mask of PRIV field.
	DMA_CCR1_PRIV_Msk = 0x100000
	// Bit PRIV.
	DMA_CCR1_PRIV = 0x100000
	// Disabled
	DMA_CCR1_PRIV_Disabled = 0x0
	// Enabled
	DMA_CCR1_PRIV_Enabled = 0x1
	// Position of DSEC field.
	DMA_CCR1_DSEC_Pos = 0x13
	// Bit mask of DSEC field.
	DMA_CCR1_DSEC_Msk = 0x80000
	// Bit DSEC.
	DMA_CCR1_DSEC = 0x80000
	// Position of SSEC field.
	DMA_CCR1_SSEC_Pos = 0x12
	// Bit mask of SSEC field.
	DMA_CCR1_SSEC_Msk = 0x40000
	// Bit SSEC.
	DMA_CCR1_SSEC = 0x40000
	// Position of SECM field.
	DMA_CCR1_SECM_Pos = 0x11
	// Bit mask of SECM field.
	DMA_CCR1_SECM_Msk = 0x20000
	// Bit SECM.
	DMA_CCR1_SECM = 0x20000
	// Position of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR1_MEM2MEM = 0x4000
	// Disabled
	DMA_CCR1_MEM2MEM_Disabled = 0x0
	// Enabled
	DMA_CCR1_MEM2MEM_Enabled = 0x1
	// Position of PL field.
	DMA_CCR1_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR1_PL_Msk = 0x3000
	// Low
	DMA_CCR1_PL_Low = 0x0
	// Medium
	DMA_CCR1_PL_Medium = 0x1
	// High
	DMA_CCR1_PL_High = 0x2
	// Very high
	DMA_CCR1_PL_VeryHigh = 0x3
	// Position of MSIZE field.
	DMA_CCR1_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR1_MSIZE_Msk = 0xc00
	// 8 bits
	DMA_CCR1_MSIZE_Bits8 = 0x0
	// 16 bits
	DMA_CCR1_MSIZE_Bits16 = 0x1
	// 32 bits
	DMA_CCR1_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_CCR1_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR1_PSIZE_Msk = 0x300
	// 8 bits
	DMA_CCR1_PSIZE_Bits8 = 0x0
	// 16 bits
	DMA_CCR1_PSIZE_Bits16 = 0x1
	// 32 bits
	DMA_CCR1_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_CCR1_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR1_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR1_MINC = 0x80
	// Disabled
	DMA_CCR1_MINC_Disabled = 0x0
	// Enabled
	DMA_CCR1_MINC_Enabled = 0x1
	// Position of PINC field.
	DMA_CCR1_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR1_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR1_PINC = 0x40
	// Disabled
	DMA_CCR1_PINC_Disabled = 0x0
	// Enabled
	DMA_CCR1_PINC_Enabled = 0x1
	// Position of CIRC field.
	DMA_CCR1_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR1_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR1_CIRC = 0x20
	// Disabled
	DMA_CCR1_CIRC_Disabled = 0x0
	// Enabled
	DMA_CCR1_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_CCR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR1_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR1_DIR = 0x10
	// Read from peripheral
	DMA_CCR1_DIR_Peripheral = 0x0
	// Read from memory
	DMA_CCR1_DIR_Memory = 0x1
	// Position of TEIE field.
	DMA_CCR1_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR1_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR1_TEIE = 0x8
	// Disabled
	DMA_CCR1_TEIE_Disabled = 0x0
	// Enabled
	DMA_CCR1_TEIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_CCR1_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR1_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR1_HTIE = 0x4
	// Disabled
	DMA_CCR1_HTIE_Disabled = 0x0
	// Enabled
	DMA_CCR1_HTIE_Enabled = 0x1
	// Position of TCIE field.
	DMA_CCR1_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR1_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR1_TCIE = 0x2
	// Disabled
	DMA_CCR1_TCIE_Disabled = 0x0
	// Enabled
	DMA_CCR1_TCIE_Enabled = 0x1
	// Position of EN field.
	DMA_CCR1_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR1_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR1_EN = 0x1
	// Disabled
	DMA_CCR1_EN_Disabled = 0x0
	// Enabled
	DMA_CCR1_EN_Enabled = 0x1

	// CNDTR1: channel x number of data to transfer register
	// Position of NDT field.
	DMA_CNDTR1_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR1_NDT_Msk = 0x3ffff

	// CPAR1: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR1_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR1_PA_Msk = 0xffffffff

	// CMAR1: channel x memory address register
	// Position of MA field.
	DMA_CMAR1_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR1_MA_Msk = 0xffffffff

	// CCR2: channel x configuration register
	// Position of PRIV field.
	DMA_CCR2_PRIV_Pos = 0x14
	// Bit mask of PRIV field.
	DMA_CCR2_PRIV_Msk = 0x100000
	// Bit PRIV.
	DMA_CCR2_PRIV = 0x100000
	// Disabled
	DMA_CCR2_PRIV_Disabled = 0x0
	// Enabled
	DMA_CCR2_PRIV_Enabled = 0x1
	// Position of DSEC field.
	DMA_CCR2_DSEC_Pos = 0x13
	// Bit mask of DSEC field.
	DMA_CCR2_DSEC_Msk = 0x80000
	// Bit DSEC.
	DMA_CCR2_DSEC = 0x80000
	// Position of SSEC field.
	DMA_CCR2_SSEC_Pos = 0x12
	// Bit mask of SSEC field.
	DMA_CCR2_SSEC_Msk = 0x40000
	// Bit SSEC.
	DMA_CCR2_SSEC = 0x40000
	// Position of SECM field.
	DMA_CCR2_SECM_Pos = 0x11
	// Bit mask of SECM field.
	DMA_CCR2_SECM_Msk = 0x20000
	// Bit SECM.
	DMA_CCR2_SECM = 0x20000
	// Position of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR2_MEM2MEM = 0x4000
	// Disabled
	DMA_CCR2_MEM2MEM_Disabled = 0x0
	// Enabled
	DMA_CCR2_MEM2MEM_Enabled = 0x1
	// Position of PL field.
	DMA_CCR2_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR2_PL_Msk = 0x3000
	// Low
	DMA_CCR2_PL_Low = 0x0
	// Medium
	DMA_CCR2_PL_Medium = 0x1
	// High
	DMA_CCR2_PL_High = 0x2
	// Very high
	DMA_CCR2_PL_VeryHigh = 0x3
	// Position of MSIZE field.
	DMA_CCR2_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR2_MSIZE_Msk = 0xc00
	// 8 bits
	DMA_CCR2_MSIZE_Bits8 = 0x0
	// 16 bits
	DMA_CCR2_MSIZE_Bits16 = 0x1
	// 32 bits
	DMA_CCR2_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_CCR2_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR2_PSIZE_Msk = 0x300
	// 8 bits
	DMA_CCR2_PSIZE_Bits8 = 0x0
	// 16 bits
	DMA_CCR2_PSIZE_Bits16 = 0x1
	// 32 bits
	DMA_CCR2_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_CCR2_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR2_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR2_MINC = 0x80
	// Disabled
	DMA_CCR2_MINC_Disabled = 0x0
	// Enabled
	DMA_CCR2_MINC_Enabled = 0x1
	// Position of PINC field.
	DMA_CCR2_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR2_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR2_PINC = 0x40
	// Disabled
	DMA_CCR2_PINC_Disabled = 0x0
	// Enabled
	DMA_CCR2_PINC_Enabled = 0x1
	// Position of CIRC field.
	DMA_CCR2_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR2_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR2_CIRC = 0x20
	// Disabled
	DMA_CCR2_CIRC_Disabled = 0x0
	// Enabled
	DMA_CCR2_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_CCR2_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR2_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR2_DIR = 0x10
	// Read from peripheral
	DMA_CCR2_DIR_Peripheral = 0x0
	// Read from memory
	DMA_CCR2_DIR_Memory = 0x1
	// Position of TEIE field.
	DMA_CCR2_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR2_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR2_TEIE = 0x8
	// Disabled
	DMA_CCR2_TEIE_Disabled = 0x0
	// Enabled
	DMA_CCR2_TEIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_CCR2_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR2_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR2_HTIE = 0x4
	// Disabled
	DMA_CCR2_HTIE_Disabled = 0x0
	// Enabled
	DMA_CCR2_HTIE_Enabled = 0x1
	// Position of TCIE field.
	DMA_CCR2_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR2_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR2_TCIE = 0x2
	// Disabled
	DMA_CCR2_TCIE_Disabled = 0x0
	// Enabled
	DMA_CCR2_TCIE_Enabled = 0x1
	// Position of EN field.
	DMA_CCR2_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR2_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR2_EN = 0x1
	// Disabled
	DMA_CCR2_EN_Disabled = 0x0
	// Enabled
	DMA_CCR2_EN_Enabled = 0x1

	// CNDTR2: channel x number of data to transfer register
	// Position of NDT field.
	DMA_CNDTR2_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR2_NDT_Msk = 0x3ffff

	// CPAR2: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR2_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR2_PA_Msk = 0xffffffff

	// CMAR2: channel x memory address register
	// Position of MA field.
	DMA_CMAR2_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR2_MA_Msk = 0xffffffff

	// CCR3: channel x configuration register
	// Position of PRIV field.
	DMA_CCR3_PRIV_Pos = 0x14
	// Bit mask of PRIV field.
	DMA_CCR3_PRIV_Msk = 0x100000
	// Bit PRIV.
	DMA_CCR3_PRIV = 0x100000
	// Disabled
	DMA_CCR3_PRIV_Disabled = 0x0
	// Enabled
	DMA_CCR3_PRIV_Enabled = 0x1
	// Position of DSEC field.
	DMA_CCR3_DSEC_Pos = 0x13
	// Bit mask of DSEC field.
	DMA_CCR3_DSEC_Msk = 0x80000
	// Bit DSEC.
	DMA_CCR3_DSEC = 0x80000
	// Position of SSEC field.
	DMA_CCR3_SSEC_Pos = 0x12
	// Bit mask of SSEC field.
	DMA_CCR3_SSEC_Msk = 0x40000
	// Bit SSEC.
	DMA_CCR3_SSEC = 0x40000
	// Position of SECM field.
	DMA_CCR3_SECM_Pos = 0x11
	// Bit mask of SECM field.
	DMA_CCR3_SECM_Msk = 0x20000
	// Bit SECM.
	DMA_CCR3_SECM = 0x20000
	// Position of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR3_MEM2MEM = 0x4000
	// Disabled
	DMA_CCR3_MEM2MEM_Disabled = 0x0
	// Enabled
	DMA_CCR3_MEM2MEM_Enabled = 0x1
	// Position of PL field.
	DMA_CCR3_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR3_PL_Msk = 0x3000
	// Low
	DMA_CCR3_PL_Low = 0x0
	// Medium
	DMA_CCR3_PL_Medium = 0x1
	// High
	DMA_CCR3_PL_High = 0x2
	// Very high
	DMA_CCR3_PL_VeryHigh = 0x3
	// Position of MSIZE field.
	DMA_CCR3_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR3_MSIZE_Msk = 0xc00
	// 8 bits
	DMA_CCR3_MSIZE_Bits8 = 0x0
	// 16 bits
	DMA_CCR3_MSIZE_Bits16 = 0x1
	// 32 bits
	DMA_CCR3_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_CCR3_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR3_PSIZE_Msk = 0x300
	// 8 bits
	DMA_CCR3_PSIZE_Bits8 = 0x0
	// 16 bits
	DMA_CCR3_PSIZE_Bits16 = 0x1
	// 32 bits
	DMA_CCR3_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_CCR3_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR3_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR3_MINC = 0x80
	// Disabled
	DMA_CCR3_MINC_Disabled = 0x0
	// Enabled
	DMA_CCR3_MINC_Enabled = 0x1
	// Position of PINC field.
	DMA_CCR3_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR3_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR3_PINC = 0x40
	// Disabled
	DMA_CCR3_PINC_Disabled = 0x0
	// Enabled
	DMA_CCR3_PINC_Enabled = 0x1
	// Position of CIRC field.
	DMA_CCR3_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR3_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR3_CIRC = 0x20
	// Disabled
	DMA_CCR3_CIRC_Disabled = 0x0
	// Enabled
	DMA_CCR3_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_CCR3_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR3_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR3_DIR = 0x10
	// Read from peripheral
	DMA_CCR3_DIR_Peripheral = 0x0
	// Read from memory
	DMA_CCR3_DIR_Memory = 0x1
	// Position of TEIE field.
	DMA_CCR3_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR3_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR3_TEIE = 0x8
	// Disabled
	DMA_CCR3_TEIE_Disabled = 0x0
	// Enabled
	DMA_CCR3_TEIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_CCR3_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR3_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR3_HTIE = 0x4
	// Disabled
	DMA_CCR3_HTIE_Disabled = 0x0
	// Enabled
	DMA_CCR3_HTIE_Enabled = 0x1
	// Position of TCIE field.
	DMA_CCR3_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR3_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR3_TCIE = 0x2
	// Disabled
	DMA_CCR3_TCIE_Disabled = 0x0
	// Enabled
	DMA_CCR3_TCIE_Enabled = 0x1
	// Position of EN field.
	DMA_CCR3_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR3_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR3_EN = 0x1
	// Disabled
	DMA_CCR3_EN_Disabled = 0x0
	// Enabled
	DMA_CCR3_EN_Enabled = 0x1

	// CNDTR3: channel x number of data to transfer register
	// Position of NDT field.
	DMA_CNDTR3_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR3_NDT_Msk = 0x3ffff

	// CPAR3: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR3_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR3_PA_Msk = 0xffffffff

	// CMAR3: channel x memory address register
	// Position of MA field.
	DMA_CMAR3_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR3_MA_Msk = 0xffffffff

	// CCR4: channel x configuration register
	// Position of PRIV field.
	DMA_CCR4_PRIV_Pos = 0x14
	// Bit mask of PRIV field.
	DMA_CCR4_PRIV_Msk = 0x100000
	// Bit PRIV.
	DMA_CCR4_PRIV = 0x100000
	// Disabled
	DMA_CCR4_PRIV_Disabled = 0x0
	// Enabled
	DMA_CCR4_PRIV_Enabled = 0x1
	// Position of DSEC field.
	DMA_CCR4_DSEC_Pos = 0x13
	// Bit mask of DSEC field.
	DMA_CCR4_DSEC_Msk = 0x80000
	// Bit DSEC.
	DMA_CCR4_DSEC = 0x80000
	// Position of SSEC field.
	DMA_CCR4_SSEC_Pos = 0x12
	// Bit mask of SSEC field.
	DMA_CCR4_SSEC_Msk = 0x40000
	// Bit SSEC.
	DMA_CCR4_SSEC = 0x40000
	// Position of SECM field.
	DMA_CCR4_SECM_Pos = 0x11
	// Bit mask of SECM field.
	DMA_CCR4_SECM_Msk = 0x20000
	// Bit SECM.
	DMA_CCR4_SECM = 0x20000
	// Position of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR4_MEM2MEM = 0x4000
	// Disabled
	DMA_CCR4_MEM2MEM_Disabled = 0x0
	// Enabled
	DMA_CCR4_MEM2MEM_Enabled = 0x1
	// Position of PL field.
	DMA_CCR4_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR4_PL_Msk = 0x3000
	// Low
	DMA_CCR4_PL_Low = 0x0
	// Medium
	DMA_CCR4_PL_Medium = 0x1
	// High
	DMA_CCR4_PL_High = 0x2
	// Very high
	DMA_CCR4_PL_VeryHigh = 0x3
	// Position of MSIZE field.
	DMA_CCR4_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR4_MSIZE_Msk = 0xc00
	// 8 bits
	DMA_CCR4_MSIZE_Bits8 = 0x0
	// 16 bits
	DMA_CCR4_MSIZE_Bits16 = 0x1
	// 32 bits
	DMA_CCR4_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_CCR4_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR4_PSIZE_Msk = 0x300
	// 8 bits
	DMA_CCR4_PSIZE_Bits8 = 0x0
	// 16 bits
	DMA_CCR4_PSIZE_Bits16 = 0x1
	// 32 bits
	DMA_CCR4_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_CCR4_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR4_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR4_MINC = 0x80
	// Disabled
	DMA_CCR4_MINC_Disabled = 0x0
	// Enabled
	DMA_CCR4_MINC_Enabled = 0x1
	// Position of PINC field.
	DMA_CCR4_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR4_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR4_PINC = 0x40
	// Disabled
	DMA_CCR4_PINC_Disabled = 0x0
	// Enabled
	DMA_CCR4_PINC_Enabled = 0x1
	// Position of CIRC field.
	DMA_CCR4_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR4_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR4_CIRC = 0x20
	// Disabled
	DMA_CCR4_CIRC_Disabled = 0x0
	// Enabled
	DMA_CCR4_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_CCR4_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR4_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR4_DIR = 0x10
	// Read from peripheral
	DMA_CCR4_DIR_Peripheral = 0x0
	// Read from memory
	DMA_CCR4_DIR_Memory = 0x1
	// Position of TEIE field.
	DMA_CCR4_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR4_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR4_TEIE = 0x8
	// Disabled
	DMA_CCR4_TEIE_Disabled = 0x0
	// Enabled
	DMA_CCR4_TEIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_CCR4_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR4_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR4_HTIE = 0x4
	// Disabled
	DMA_CCR4_HTIE_Disabled = 0x0
	// Enabled
	DMA_CCR4_HTIE_Enabled = 0x1
	// Position of TCIE field.
	DMA_CCR4_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR4_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR4_TCIE = 0x2
	// Disabled
	DMA_CCR4_TCIE_Disabled = 0x0
	// Enabled
	DMA_CCR4_TCIE_Enabled = 0x1
	// Position of EN field.
	DMA_CCR4_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR4_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR4_EN = 0x1
	// Disabled
	DMA_CCR4_EN_Disabled = 0x0
	// Enabled
	DMA_CCR4_EN_Enabled = 0x1

	// CNDTR4: channel x number of data to transfer register
	// Position of NDT field.
	DMA_CNDTR4_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR4_NDT_Msk = 0x3ffff

	// CPAR4: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR4_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR4_PA_Msk = 0xffffffff

	// CMAR4: channel x memory address register
	// Position of MA field.
	DMA_CMAR4_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR4_MA_Msk = 0xffffffff

	// CCR5: channel x configuration register
	// Position of PRIV field.
	DMA_CCR5_PRIV_Pos = 0x14
	// Bit mask of PRIV field.
	DMA_CCR5_PRIV_Msk = 0x100000
	// Bit PRIV.
	DMA_CCR5_PRIV = 0x100000
	// Disabled
	DMA_CCR5_PRIV_Disabled = 0x0
	// Enabled
	DMA_CCR5_PRIV_Enabled = 0x1
	// Position of DSEC field.
	DMA_CCR5_DSEC_Pos = 0x13
	// Bit mask of DSEC field.
	DMA_CCR5_DSEC_Msk = 0x80000
	// Bit DSEC.
	DMA_CCR5_DSEC = 0x80000
	// Position of SSEC field.
	DMA_CCR5_SSEC_Pos = 0x12
	// Bit mask of SSEC field.
	DMA_CCR5_SSEC_Msk = 0x40000
	// Bit SSEC.
	DMA_CCR5_SSEC = 0x40000
	// Position of SECM field.
	DMA_CCR5_SECM_Pos = 0x11
	// Bit mask of SECM field.
	DMA_CCR5_SECM_Msk = 0x20000
	// Bit SECM.
	DMA_CCR5_SECM = 0x20000
	// Position of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR5_MEM2MEM = 0x4000
	// Disabled
	DMA_CCR5_MEM2MEM_Disabled = 0x0
	// Enabled
	DMA_CCR5_MEM2MEM_Enabled = 0x1
	// Position of PL field.
	DMA_CCR5_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR5_PL_Msk = 0x3000
	// Low
	DMA_CCR5_PL_Low = 0x0
	// Medium
	DMA_CCR5_PL_Medium = 0x1
	// High
	DMA_CCR5_PL_High = 0x2
	// Very high
	DMA_CCR5_PL_VeryHigh = 0x3
	// Position of MSIZE field.
	DMA_CCR5_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR5_MSIZE_Msk = 0xc00
	// 8 bits
	DMA_CCR5_MSIZE_Bits8 = 0x0
	// 16 bits
	DMA_CCR5_MSIZE_Bits16 = 0x1
	// 32 bits
	DMA_CCR5_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_CCR5_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR5_PSIZE_Msk = 0x300
	// 8 bits
	DMA_CCR5_PSIZE_Bits8 = 0x0
	// 16 bits
	DMA_CCR5_PSIZE_Bits16 = 0x1
	// 32 bits
	DMA_CCR5_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_CCR5_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR5_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR5_MINC = 0x80
	// Disabled
	DMA_CCR5_MINC_Disabled = 0x0
	// Enabled
	DMA_CCR5_MINC_Enabled = 0x1
	// Position of PINC field.
	DMA_CCR5_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR5_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR5_PINC = 0x40
	// Disabled
	DMA_CCR5_PINC_Disabled = 0x0
	// Enabled
	DMA_CCR5_PINC_Enabled = 0x1
	// Position of CIRC field.
	DMA_CCR5_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR5_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR5_CIRC = 0x20
	// Disabled
	DMA_CCR5_CIRC_Disabled = 0x0
	// Enabled
	DMA_CCR5_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_CCR5_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR5_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR5_DIR = 0x10
	// Read from peripheral
	DMA_CCR5_DIR_Peripheral = 0x0
	// Read from memory
	DMA_CCR5_DIR_Memory = 0x1
	// Position of TEIE field.
	DMA_CCR5_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR5_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR5_TEIE = 0x8
	// Disabled
	DMA_CCR5_TEIE_Disabled = 0x0
	// Enabled
	DMA_CCR5_TEIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_CCR5_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR5_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR5_HTIE = 0x4
	// Disabled
	DMA_CCR5_HTIE_Disabled = 0x0
	// Enabled
	DMA_CCR5_HTIE_Enabled = 0x1
	// Position of TCIE field.
	DMA_CCR5_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR5_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR5_TCIE = 0x2
	// Disabled
	DMA_CCR5_TCIE_Disabled = 0x0
	// Enabled
	DMA_CCR5_TCIE_Enabled = 0x1
	// Position of EN field.
	DMA_CCR5_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR5_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR5_EN = 0x1
	// Disabled
	DMA_CCR5_EN_Disabled = 0x0
	// Enabled
	DMA_CCR5_EN_Enabled = 0x1

	// CNDTR5: channel x number of data to transfer register
	// Position of NDT field.
	DMA_CNDTR5_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR5_NDT_Msk = 0x3ffff

	// CPAR5: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR5_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR5_PA_Msk = 0xffffffff

	// CMAR5: channel x memory address register
	// Position of MA field.
	DMA_CMAR5_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR5_MA_Msk = 0xffffffff

	// CCR6: channel x configuration register
	// Position of PRIV field.
	DMA_CCR6_PRIV_Pos = 0x14
	// Bit mask of PRIV field.
	DMA_CCR6_PRIV_Msk = 0x100000
	// Bit PRIV.
	DMA_CCR6_PRIV = 0x100000
	// Disabled
	DMA_CCR6_PRIV_Disabled = 0x0
	// Enabled
	DMA_CCR6_PRIV_Enabled = 0x1
	// Position of DSEC field.
	DMA_CCR6_DSEC_Pos = 0x13
	// Bit mask of DSEC field.
	DMA_CCR6_DSEC_Msk = 0x80000
	// Bit DSEC.
	DMA_CCR6_DSEC = 0x80000
	// Position of SSEC field.
	DMA_CCR6_SSEC_Pos = 0x12
	// Bit mask of SSEC field.
	DMA_CCR6_SSEC_Msk = 0x40000
	// Bit SSEC.
	DMA_CCR6_SSEC = 0x40000
	// Position of SECM field.
	DMA_CCR6_SECM_Pos = 0x11
	// Bit mask of SECM field.
	DMA_CCR6_SECM_Msk = 0x20000
	// Bit SECM.
	DMA_CCR6_SECM = 0x20000
	// Position of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR6_MEM2MEM = 0x4000
	// Disabled
	DMA_CCR6_MEM2MEM_Disabled = 0x0
	// Enabled
	DMA_CCR6_MEM2MEM_Enabled = 0x1
	// Position of PL field.
	DMA_CCR6_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR6_PL_Msk = 0x3000
	// Low
	DMA_CCR6_PL_Low = 0x0
	// Medium
	DMA_CCR6_PL_Medium = 0x1
	// High
	DMA_CCR6_PL_High = 0x2
	// Very high
	DMA_CCR6_PL_VeryHigh = 0x3
	// Position of MSIZE field.
	DMA_CCR6_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR6_MSIZE_Msk = 0xc00
	// 8 bits
	DMA_CCR6_MSIZE_Bits8 = 0x0
	// 16 bits
	DMA_CCR6_MSIZE_Bits16 = 0x1
	// 32 bits
	DMA_CCR6_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_CCR6_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR6_PSIZE_Msk = 0x300
	// 8 bits
	DMA_CCR6_PSIZE_Bits8 = 0x0
	// 16 bits
	DMA_CCR6_PSIZE_Bits16 = 0x1
	// 32 bits
	DMA_CCR6_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_CCR6_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR6_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR6_MINC = 0x80
	// Disabled
	DMA_CCR6_MINC_Disabled = 0x0
	// Enabled
	DMA_CCR6_MINC_Enabled = 0x1
	// Position of PINC field.
	DMA_CCR6_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR6_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR6_PINC = 0x40
	// Disabled
	DMA_CCR6_PINC_Disabled = 0x0
	// Enabled
	DMA_CCR6_PINC_Enabled = 0x1
	// Position of CIRC field.
	DMA_CCR6_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR6_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR6_CIRC = 0x20
	// Disabled
	DMA_CCR6_CIRC_Disabled = 0x0
	// Enabled
	DMA_CCR6_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_CCR6_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR6_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR6_DIR = 0x10
	// Read from peripheral
	DMA_CCR6_DIR_Peripheral = 0x0
	// Read from memory
	DMA_CCR6_DIR_Memory = 0x1
	// Position of TEIE field.
	DMA_CCR6_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR6_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR6_TEIE = 0x8
	// Disabled
	DMA_CCR6_TEIE_Disabled = 0x0
	// Enabled
	DMA_CCR6_TEIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_CCR6_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR6_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR6_HTIE = 0x4
	// Disabled
	DMA_CCR6_HTIE_Disabled = 0x0
	// Enabled
	DMA_CCR6_HTIE_Enabled = 0x1
	// Position of TCIE field.
	DMA_CCR6_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR6_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR6_TCIE = 0x2
	// Disabled
	DMA_CCR6_TCIE_Disabled = 0x0
	// Enabled
	DMA_CCR6_TCIE_Enabled = 0x1
	// Position of EN field.
	DMA_CCR6_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR6_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR6_EN = 0x1
	// Disabled
	DMA_CCR6_EN_Disabled = 0x0
	// Enabled
	DMA_CCR6_EN_Enabled = 0x1

	// CNDTR6: channel x number of data to transfer register
	// Position of NDT field.
	DMA_CNDTR6_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR6_NDT_Msk = 0x3ffff

	// CPAR6: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR6_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR6_PA_Msk = 0xffffffff

	// CMAR6: channel x memory address register
	// Position of MA field.
	DMA_CMAR6_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR6_MA_Msk = 0xffffffff

	// CCR7: channel x configuration register
	// Position of PRIV field.
	DMA_CCR7_PRIV_Pos = 0x14
	// Bit mask of PRIV field.
	DMA_CCR7_PRIV_Msk = 0x100000
	// Bit PRIV.
	DMA_CCR7_PRIV = 0x100000
	// Disabled
	DMA_CCR7_PRIV_Disabled = 0x0
	// Enabled
	DMA_CCR7_PRIV_Enabled = 0x1
	// Position of DSEC field.
	DMA_CCR7_DSEC_Pos = 0x13
	// Bit mask of DSEC field.
	DMA_CCR7_DSEC_Msk = 0x80000
	// Bit DSEC.
	DMA_CCR7_DSEC = 0x80000
	// Position of SSEC field.
	DMA_CCR7_SSEC_Pos = 0x12
	// Bit mask of SSEC field.
	DMA_CCR7_SSEC_Msk = 0x40000
	// Bit SSEC.
	DMA_CCR7_SSEC = 0x40000
	// Position of SECM field.
	DMA_CCR7_SECM_Pos = 0x11
	// Bit mask of SECM field.
	DMA_CCR7_SECM_Msk = 0x20000
	// Bit SECM.
	DMA_CCR7_SECM = 0x20000
	// Position of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR7_MEM2MEM = 0x4000
	// Disabled
	DMA_CCR7_MEM2MEM_Disabled = 0x0
	// Enabled
	DMA_CCR7_MEM2MEM_Enabled = 0x1
	// Position of PL field.
	DMA_CCR7_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR7_PL_Msk = 0x3000
	// Low
	DMA_CCR7_PL_Low = 0x0
	// Medium
	DMA_CCR7_PL_Medium = 0x1
	// High
	DMA_CCR7_PL_High = 0x2
	// Very high
	DMA_CCR7_PL_VeryHigh = 0x3
	// Position of MSIZE field.
	DMA_CCR7_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR7_MSIZE_Msk = 0xc00
	// 8 bits
	DMA_CCR7_MSIZE_Bits8 = 0x0
	// 16 bits
	DMA_CCR7_MSIZE_Bits16 = 0x1
	// 32 bits
	DMA_CCR7_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_CCR7_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR7_PSIZE_Msk = 0x300
	// 8 bits
	DMA_CCR7_PSIZE_Bits8 = 0x0
	// 16 bits
	DMA_CCR7_PSIZE_Bits16 = 0x1
	// 32 bits
	DMA_CCR7_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_CCR7_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR7_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR7_MINC = 0x80
	// Disabled
	DMA_CCR7_MINC_Disabled = 0x0
	// Enabled
	DMA_CCR7_MINC_Enabled = 0x1
	// Position of PINC field.
	DMA_CCR7_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR7_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR7_PINC = 0x40
	// Disabled
	DMA_CCR7_PINC_Disabled = 0x0
	// Enabled
	DMA_CCR7_PINC_Enabled = 0x1
	// Position of CIRC field.
	DMA_CCR7_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR7_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR7_CIRC = 0x20
	// Disabled
	DMA_CCR7_CIRC_Disabled = 0x0
	// Enabled
	DMA_CCR7_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_CCR7_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR7_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR7_DIR = 0x10
	// Read from peripheral
	DMA_CCR7_DIR_Peripheral = 0x0
	// Read from memory
	DMA_CCR7_DIR_Memory = 0x1
	// Position of TEIE field.
	DMA_CCR7_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR7_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR7_TEIE = 0x8
	// Disabled
	DMA_CCR7_TEIE_Disabled = 0x0
	// Enabled
	DMA_CCR7_TEIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_CCR7_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR7_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR7_HTIE = 0x4
	// Disabled
	DMA_CCR7_HTIE_Disabled = 0x0
	// Enabled
	DMA_CCR7_HTIE_Enabled = 0x1
	// Position of TCIE field.
	DMA_CCR7_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR7_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR7_TCIE = 0x2
	// Disabled
	DMA_CCR7_TCIE_Disabled = 0x0
	// Enabled
	DMA_CCR7_TCIE_Enabled = 0x1
	// Position of EN field.
	DMA_CCR7_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR7_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR7_EN = 0x1
	// Disabled
	DMA_CCR7_EN_Disabled = 0x0
	// Enabled
	DMA_CCR7_EN_Enabled = 0x1

	// CNDTR7: channel x number of data to transfer register
	// Position of NDT field.
	DMA_CNDTR7_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR7_NDT_Msk = 0x3ffff

	// CPAR7: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR7_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR7_PA_Msk = 0xffffffff

	// CMAR7: channel x memory address register
	// Position of MA field.
	DMA_CMAR7_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR7_MA_Msk = 0xffffffff
)

// Constants for DMAMUX: DMA request multiplexer
const (
	// C0CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C0CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C0CR_SYNC_ID_Msk = 0x1f000000
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_EXTI0 = 0x0
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_EXTI1 = 0x1
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_EXTI2 = 0x2
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_EXTI3 = 0x3
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_EXTI4 = 0x4
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_EXTI5 = 0x5
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_EXTI6 = 0x6
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_EXTI7 = 0x7
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_EXTI8 = 0x8
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_EXTI9 = 0x9
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_EXTI10 = 0xa
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_EXTI11 = 0xb
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_EXTI12 = 0xc
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_EXTI13 = 0xd
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_EXTI14 = 0xe
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_EXTI15 = 0xf
	// Signal `dmamux1_evt0` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_DMAMUX1_EVT0 = 0x10
	// Signal `dmamux1_evt1` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_DMAMUX1_EVT1 = 0x11
	// Signal `lptim1_out` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_LPTIM1_OUT = 0x12
	// Signal `lptim2_out` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_LPTIM2_OUT = 0x13
	// Signal `lptim3_out` selected as synchronization input
	DMAMUX_C0CR_SYNC_ID_LPTIM3_OUT = 0x14
	// Position of NBREQ field.
	DMAMUX_C0CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C0CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C0CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C0CR_SPOL_Msk = 0x60000
	// No event, i.e. no synchronization nor detection
	DMAMUX_C0CR_SPOL_NoEdge = 0x0
	// Rising edge
	DMAMUX_C0CR_SPOL_RisingEdge = 0x1
	// Falling edge
	DMAMUX_C0CR_SPOL_FallingEdge = 0x2
	// Rising and falling edges
	DMAMUX_C0CR_SPOL_BothEdges = 0x3
	// Position of SE field.
	DMAMUX_C0CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C0CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C0CR_SE = 0x10000
	// Synchronization disabled
	DMAMUX_C0CR_SE_Disabled = 0x0
	// Synchronization enabled
	DMAMUX_C0CR_SE_Enabled = 0x1
	// Position of EGE field.
	DMAMUX_C0CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C0CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C0CR_EGE = 0x200
	// Event generation disabled
	DMAMUX_C0CR_EGE_Disabled = 0x0
	// Event generation enabled
	DMAMUX_C0CR_EGE_Enabled = 0x1
	// Position of SOIE field.
	DMAMUX_C0CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C0CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C0CR_SOIE = 0x100
	// Synchronization overrun interrupt disabled
	DMAMUX_C0CR_SOIE_Disabled = 0x0
	// Synchronization overrun interrupt enabled
	DMAMUX_C0CR_SOIE_Enabled = 0x1
	// Position of DMAREQ_ID field.
	DMAMUX_C0CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C0CR_DMAREQ_ID_Msk = 0xff
	// No signal selected as request input
	DMAMUX_C0CR_DMAREQ_ID_NONE = 0x0
	// Signal `dmamux1_req_gen0` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_DMAMUX1_REQ_GEN0 = 0x1
	// Signal `dmamux1_req_gen1` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_DMAMUX1_REQ_GEN1 = 0x2
	// Signal `dmamux1_req_gen2` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_DMAMUX1_REQ_GEN2 = 0x3
	// Signal `dmamux1_req_gen3` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_DMAMUX1_REQ_GEN3 = 0x4
	// Signal `adc1_dma` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_ADC = 0x5
	// Signal `dac_out1_dma` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_DAT_OUT1 = 0x6
	// Signal `spi1_rx_dma` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_SPI1_RX_DMA = 0x7
	// Signal `spi1_tx_dma` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_SPI1_TX_DMA = 0x8
	// Signal `spi2_rx_dma` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_SPI2_RX_DMA = 0x9
	// Signal `spi2_tx_dma` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_SPI2_TX_DMA = 0xa
	// Signal `i2c1_rx_dma` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_I2C1_RX_DMA = 0xb
	// Signal `i2c1_tx_dma` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_I2C1_TX_DMA = 0xc
	// Signal `i2c2_rx_dma` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_I2C2_RX_DMA = 0xd
	// Signal `i2c2_tx_dma` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_I2C2_TX_DMA = 0xe
	// Signal `i2c3_rx_dma` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_I2C3_RX_DMA = 0xf
	// Signal `i2c3_tx_dma` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_I2C3_TX_DMA = 0x10
	// Signal `usart1_rx_dma` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_USART1_RX_DMA = 0x11
	// Signal `usart1_tx_dma` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_USART1_TX_DMA = 0x12
	// Signal `usart2_rx_dma` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_USART2_RX_DMA = 0x13
	// Signal `usart2_tx_dma` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_USART2_TX_DMA = 0x14
	// Signal `lpuart1_rx_dma` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_LPUART1_RX_DMA = 0x15
	// Signal `lpuart1_tx_dma` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_LPUART1_TX_DMA = 0x16
	// Signal `tim1_ch1` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_TIM1_CH1 = 0x17
	// Signal `tim1_ch2` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_TIM1_CH2 = 0x18
	// Signal `tim1_ch3` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_TIM1_CH3 = 0x19
	// Signal `tim1_ch4` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_TIM1_CH4 = 0x1a
	// Signal `tim1_up` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_TIM1_UP = 0x1b
	// Signal `tim1_trig` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_TIM1_TRIG = 0x1c
	// Signal `tim1_com` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_TIM1_COM = 0x1d
	// Signal `tim2_ch1` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_TIM2_CH1 = 0x1e
	// Signal `tim2_ch2` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_TIM2_CH2 = 0x1f
	// Signal `tim2_ch3` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_TIM2_CH3 = 0x20
	// Signal `tim2_ch4` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_TIM2_CH4 = 0x21
	// Signal `tim2_up` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_TIM2_UP = 0x22
	// Signal `tim16_ch1` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_TIM16_CH1 = 0x23
	// Signal `tim16_up` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_TIM16_UP = 0x24
	// Signal `tim17_ch1` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_TIM17_CH1 = 0x25
	// Signal `tim17_up` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_TIM17_UP = 0x26
	// Signal `aes_in` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_AES_IN = 0x27
	// Signal `aes_out` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_AES_OUT = 0x28
	// Signal `subghzspi_rx` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_SUBGHZSPI_RX = 0x29
	// Signal `subghzspi_tx` selected as request input
	DMAMUX_C0CR_DMAREQ_ID_SUBGHZSPI_TX = 0x2a

	// C1CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C1CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C1CR_SYNC_ID_Msk = 0x1f000000
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_EXTI0 = 0x0
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_EXTI1 = 0x1
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_EXTI2 = 0x2
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_EXTI3 = 0x3
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_EXTI4 = 0x4
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_EXTI5 = 0x5
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_EXTI6 = 0x6
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_EXTI7 = 0x7
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_EXTI8 = 0x8
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_EXTI9 = 0x9
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_EXTI10 = 0xa
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_EXTI11 = 0xb
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_EXTI12 = 0xc
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_EXTI13 = 0xd
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_EXTI14 = 0xe
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_EXTI15 = 0xf
	// Signal `dmamux1_evt0` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_DMAMUX1_EVT0 = 0x10
	// Signal `dmamux1_evt1` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_DMAMUX1_EVT1 = 0x11
	// Signal `lptim1_out` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_LPTIM1_OUT = 0x12
	// Signal `lptim2_out` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_LPTIM2_OUT = 0x13
	// Signal `lptim3_out` selected as synchronization input
	DMAMUX_C1CR_SYNC_ID_LPTIM3_OUT = 0x14
	// Position of NBREQ field.
	DMAMUX_C1CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C1CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C1CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C1CR_SPOL_Msk = 0x60000
	// No event, i.e. no synchronization nor detection
	DMAMUX_C1CR_SPOL_NoEdge = 0x0
	// Rising edge
	DMAMUX_C1CR_SPOL_RisingEdge = 0x1
	// Falling edge
	DMAMUX_C1CR_SPOL_FallingEdge = 0x2
	// Rising and falling edges
	DMAMUX_C1CR_SPOL_BothEdges = 0x3
	// Position of SE field.
	DMAMUX_C1CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C1CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C1CR_SE = 0x10000
	// Synchronization disabled
	DMAMUX_C1CR_SE_Disabled = 0x0
	// Synchronization enabled
	DMAMUX_C1CR_SE_Enabled = 0x1
	// Position of EGE field.
	DMAMUX_C1CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C1CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C1CR_EGE = 0x200
	// Event generation disabled
	DMAMUX_C1CR_EGE_Disabled = 0x0
	// Event generation enabled
	DMAMUX_C1CR_EGE_Enabled = 0x1
	// Position of SOIE field.
	DMAMUX_C1CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C1CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C1CR_SOIE = 0x100
	// Synchronization overrun interrupt disabled
	DMAMUX_C1CR_SOIE_Disabled = 0x0
	// Synchronization overrun interrupt enabled
	DMAMUX_C1CR_SOIE_Enabled = 0x1
	// Position of DMAREQ_ID field.
	DMAMUX_C1CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C1CR_DMAREQ_ID_Msk = 0xff
	// No signal selected as request input
	DMAMUX_C1CR_DMAREQ_ID_NONE = 0x0
	// Signal `dmamux1_req_gen0` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_DMAMUX1_REQ_GEN0 = 0x1
	// Signal `dmamux1_req_gen1` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_DMAMUX1_REQ_GEN1 = 0x2
	// Signal `dmamux1_req_gen2` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_DMAMUX1_REQ_GEN2 = 0x3
	// Signal `dmamux1_req_gen3` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_DMAMUX1_REQ_GEN3 = 0x4
	// Signal `adc1_dma` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_ADC = 0x5
	// Signal `dac_out1_dma` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_DAT_OUT1 = 0x6
	// Signal `spi1_rx_dma` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_SPI1_RX_DMA = 0x7
	// Signal `spi1_tx_dma` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_SPI1_TX_DMA = 0x8
	// Signal `spi2_rx_dma` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_SPI2_RX_DMA = 0x9
	// Signal `spi2_tx_dma` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_SPI2_TX_DMA = 0xa
	// Signal `i2c1_rx_dma` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_I2C1_RX_DMA = 0xb
	// Signal `i2c1_tx_dma` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_I2C1_TX_DMA = 0xc
	// Signal `i2c2_rx_dma` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_I2C2_RX_DMA = 0xd
	// Signal `i2c2_tx_dma` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_I2C2_TX_DMA = 0xe
	// Signal `i2c3_rx_dma` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_I2C3_RX_DMA = 0xf
	// Signal `i2c3_tx_dma` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_I2C3_TX_DMA = 0x10
	// Signal `usart1_rx_dma` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_USART1_RX_DMA = 0x11
	// Signal `usart1_tx_dma` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_USART1_TX_DMA = 0x12
	// Signal `usart2_rx_dma` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_USART2_RX_DMA = 0x13
	// Signal `usart2_tx_dma` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_USART2_TX_DMA = 0x14
	// Signal `lpuart1_rx_dma` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_LPUART1_RX_DMA = 0x15
	// Signal `lpuart1_tx_dma` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_LPUART1_TX_DMA = 0x16
	// Signal `tim1_ch1` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_TIM1_CH1 = 0x17
	// Signal `tim1_ch2` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_TIM1_CH2 = 0x18
	// Signal `tim1_ch3` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_TIM1_CH3 = 0x19
	// Signal `tim1_ch4` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_TIM1_CH4 = 0x1a
	// Signal `tim1_up` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_TIM1_UP = 0x1b
	// Signal `tim1_trig` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_TIM1_TRIG = 0x1c
	// Signal `tim1_com` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_TIM1_COM = 0x1d
	// Signal `tim2_ch1` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_TIM2_CH1 = 0x1e
	// Signal `tim2_ch2` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_TIM2_CH2 = 0x1f
	// Signal `tim2_ch3` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_TIM2_CH3 = 0x20
	// Signal `tim2_ch4` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_TIM2_CH4 = 0x21
	// Signal `tim2_up` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_TIM2_UP = 0x22
	// Signal `tim16_ch1` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_TIM16_CH1 = 0x23
	// Signal `tim16_up` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_TIM16_UP = 0x24
	// Signal `tim17_ch1` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_TIM17_CH1 = 0x25
	// Signal `tim17_up` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_TIM17_UP = 0x26
	// Signal `aes_in` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_AES_IN = 0x27
	// Signal `aes_out` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_AES_OUT = 0x28
	// Signal `subghzspi_rx` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_SUBGHZSPI_RX = 0x29
	// Signal `subghzspi_tx` selected as request input
	DMAMUX_C1CR_DMAREQ_ID_SUBGHZSPI_TX = 0x2a

	// C2CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C2CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C2CR_SYNC_ID_Msk = 0x1f000000
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_EXTI0 = 0x0
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_EXTI1 = 0x1
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_EXTI2 = 0x2
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_EXTI3 = 0x3
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_EXTI4 = 0x4
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_EXTI5 = 0x5
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_EXTI6 = 0x6
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_EXTI7 = 0x7
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_EXTI8 = 0x8
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_EXTI9 = 0x9
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_EXTI10 = 0xa
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_EXTI11 = 0xb
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_EXTI12 = 0xc
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_EXTI13 = 0xd
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_EXTI14 = 0xe
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_EXTI15 = 0xf
	// Signal `dmamux1_evt0` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_DMAMUX1_EVT0 = 0x10
	// Signal `dmamux1_evt1` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_DMAMUX1_EVT1 = 0x11
	// Signal `lptim1_out` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_LPTIM1_OUT = 0x12
	// Signal `lptim2_out` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_LPTIM2_OUT = 0x13
	// Signal `lptim3_out` selected as synchronization input
	DMAMUX_C2CR_SYNC_ID_LPTIM3_OUT = 0x14
	// Position of NBREQ field.
	DMAMUX_C2CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C2CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C2CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C2CR_SPOL_Msk = 0x60000
	// No event, i.e. no synchronization nor detection
	DMAMUX_C2CR_SPOL_NoEdge = 0x0
	// Rising edge
	DMAMUX_C2CR_SPOL_RisingEdge = 0x1
	// Falling edge
	DMAMUX_C2CR_SPOL_FallingEdge = 0x2
	// Rising and falling edges
	DMAMUX_C2CR_SPOL_BothEdges = 0x3
	// Position of SE field.
	DMAMUX_C2CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C2CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C2CR_SE = 0x10000
	// Synchronization disabled
	DMAMUX_C2CR_SE_Disabled = 0x0
	// Synchronization enabled
	DMAMUX_C2CR_SE_Enabled = 0x1
	// Position of EGE field.
	DMAMUX_C2CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C2CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C2CR_EGE = 0x200
	// Event generation disabled
	DMAMUX_C2CR_EGE_Disabled = 0x0
	// Event generation enabled
	DMAMUX_C2CR_EGE_Enabled = 0x1
	// Position of SOIE field.
	DMAMUX_C2CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C2CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C2CR_SOIE = 0x100
	// Synchronization overrun interrupt disabled
	DMAMUX_C2CR_SOIE_Disabled = 0x0
	// Synchronization overrun interrupt enabled
	DMAMUX_C2CR_SOIE_Enabled = 0x1
	// Position of DMAREQ_ID field.
	DMAMUX_C2CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C2CR_DMAREQ_ID_Msk = 0xff
	// No signal selected as request input
	DMAMUX_C2CR_DMAREQ_ID_NONE = 0x0
	// Signal `dmamux1_req_gen0` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_DMAMUX1_REQ_GEN0 = 0x1
	// Signal `dmamux1_req_gen1` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_DMAMUX1_REQ_GEN1 = 0x2
	// Signal `dmamux1_req_gen2` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_DMAMUX1_REQ_GEN2 = 0x3
	// Signal `dmamux1_req_gen3` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_DMAMUX1_REQ_GEN3 = 0x4
	// Signal `adc1_dma` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_ADC = 0x5
	// Signal `dac_out1_dma` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_DAT_OUT1 = 0x6
	// Signal `spi1_rx_dma` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_SPI1_RX_DMA = 0x7
	// Signal `spi1_tx_dma` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_SPI1_TX_DMA = 0x8
	// Signal `spi2_rx_dma` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_SPI2_RX_DMA = 0x9
	// Signal `spi2_tx_dma` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_SPI2_TX_DMA = 0xa
	// Signal `i2c1_rx_dma` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_I2C1_RX_DMA = 0xb
	// Signal `i2c1_tx_dma` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_I2C1_TX_DMA = 0xc
	// Signal `i2c2_rx_dma` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_I2C2_RX_DMA = 0xd
	// Signal `i2c2_tx_dma` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_I2C2_TX_DMA = 0xe
	// Signal `i2c3_rx_dma` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_I2C3_RX_DMA = 0xf
	// Signal `i2c3_tx_dma` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_I2C3_TX_DMA = 0x10
	// Signal `usart1_rx_dma` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_USART1_RX_DMA = 0x11
	// Signal `usart1_tx_dma` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_USART1_TX_DMA = 0x12
	// Signal `usart2_rx_dma` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_USART2_RX_DMA = 0x13
	// Signal `usart2_tx_dma` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_USART2_TX_DMA = 0x14
	// Signal `lpuart1_rx_dma` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_LPUART1_RX_DMA = 0x15
	// Signal `lpuart1_tx_dma` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_LPUART1_TX_DMA = 0x16
	// Signal `tim1_ch1` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_TIM1_CH1 = 0x17
	// Signal `tim1_ch2` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_TIM1_CH2 = 0x18
	// Signal `tim1_ch3` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_TIM1_CH3 = 0x19
	// Signal `tim1_ch4` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_TIM1_CH4 = 0x1a
	// Signal `tim1_up` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_TIM1_UP = 0x1b
	// Signal `tim1_trig` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_TIM1_TRIG = 0x1c
	// Signal `tim1_com` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_TIM1_COM = 0x1d
	// Signal `tim2_ch1` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_TIM2_CH1 = 0x1e
	// Signal `tim2_ch2` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_TIM2_CH2 = 0x1f
	// Signal `tim2_ch3` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_TIM2_CH3 = 0x20
	// Signal `tim2_ch4` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_TIM2_CH4 = 0x21
	// Signal `tim2_up` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_TIM2_UP = 0x22
	// Signal `tim16_ch1` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_TIM16_CH1 = 0x23
	// Signal `tim16_up` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_TIM16_UP = 0x24
	// Signal `tim17_ch1` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_TIM17_CH1 = 0x25
	// Signal `tim17_up` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_TIM17_UP = 0x26
	// Signal `aes_in` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_AES_IN = 0x27
	// Signal `aes_out` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_AES_OUT = 0x28
	// Signal `subghzspi_rx` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_SUBGHZSPI_RX = 0x29
	// Signal `subghzspi_tx` selected as request input
	DMAMUX_C2CR_DMAREQ_ID_SUBGHZSPI_TX = 0x2a

	// C3CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C3CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C3CR_SYNC_ID_Msk = 0x1f000000
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_EXTI0 = 0x0
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_EXTI1 = 0x1
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_EXTI2 = 0x2
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_EXTI3 = 0x3
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_EXTI4 = 0x4
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_EXTI5 = 0x5
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_EXTI6 = 0x6
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_EXTI7 = 0x7
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_EXTI8 = 0x8
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_EXTI9 = 0x9
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_EXTI10 = 0xa
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_EXTI11 = 0xb
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_EXTI12 = 0xc
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_EXTI13 = 0xd
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_EXTI14 = 0xe
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_EXTI15 = 0xf
	// Signal `dmamux1_evt0` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_DMAMUX1_EVT0 = 0x10
	// Signal `dmamux1_evt1` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_DMAMUX1_EVT1 = 0x11
	// Signal `lptim1_out` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_LPTIM1_OUT = 0x12
	// Signal `lptim2_out` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_LPTIM2_OUT = 0x13
	// Signal `lptim3_out` selected as synchronization input
	DMAMUX_C3CR_SYNC_ID_LPTIM3_OUT = 0x14
	// Position of NBREQ field.
	DMAMUX_C3CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C3CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C3CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C3CR_SPOL_Msk = 0x60000
	// No event, i.e. no synchronization nor detection
	DMAMUX_C3CR_SPOL_NoEdge = 0x0
	// Rising edge
	DMAMUX_C3CR_SPOL_RisingEdge = 0x1
	// Falling edge
	DMAMUX_C3CR_SPOL_FallingEdge = 0x2
	// Rising and falling edges
	DMAMUX_C3CR_SPOL_BothEdges = 0x3
	// Position of SE field.
	DMAMUX_C3CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C3CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C3CR_SE = 0x10000
	// Synchronization disabled
	DMAMUX_C3CR_SE_Disabled = 0x0
	// Synchronization enabled
	DMAMUX_C3CR_SE_Enabled = 0x1
	// Position of EGE field.
	DMAMUX_C3CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C3CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C3CR_EGE = 0x200
	// Event generation disabled
	DMAMUX_C3CR_EGE_Disabled = 0x0
	// Event generation enabled
	DMAMUX_C3CR_EGE_Enabled = 0x1
	// Position of SOIE field.
	DMAMUX_C3CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C3CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C3CR_SOIE = 0x100
	// Synchronization overrun interrupt disabled
	DMAMUX_C3CR_SOIE_Disabled = 0x0
	// Synchronization overrun interrupt enabled
	DMAMUX_C3CR_SOIE_Enabled = 0x1
	// Position of DMAREQ_ID field.
	DMAMUX_C3CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C3CR_DMAREQ_ID_Msk = 0xff
	// No signal selected as request input
	DMAMUX_C3CR_DMAREQ_ID_NONE = 0x0
	// Signal `dmamux1_req_gen0` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_DMAMUX1_REQ_GEN0 = 0x1
	// Signal `dmamux1_req_gen1` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_DMAMUX1_REQ_GEN1 = 0x2
	// Signal `dmamux1_req_gen2` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_DMAMUX1_REQ_GEN2 = 0x3
	// Signal `dmamux1_req_gen3` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_DMAMUX1_REQ_GEN3 = 0x4
	// Signal `adc1_dma` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_ADC = 0x5
	// Signal `dac_out1_dma` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_DAT_OUT1 = 0x6
	// Signal `spi1_rx_dma` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_SPI1_RX_DMA = 0x7
	// Signal `spi1_tx_dma` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_SPI1_TX_DMA = 0x8
	// Signal `spi2_rx_dma` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_SPI2_RX_DMA = 0x9
	// Signal `spi2_tx_dma` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_SPI2_TX_DMA = 0xa
	// Signal `i2c1_rx_dma` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_I2C1_RX_DMA = 0xb
	// Signal `i2c1_tx_dma` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_I2C1_TX_DMA = 0xc
	// Signal `i2c2_rx_dma` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_I2C2_RX_DMA = 0xd
	// Signal `i2c2_tx_dma` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_I2C2_TX_DMA = 0xe
	// Signal `i2c3_rx_dma` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_I2C3_RX_DMA = 0xf
	// Signal `i2c3_tx_dma` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_I2C3_TX_DMA = 0x10
	// Signal `usart1_rx_dma` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_USART1_RX_DMA = 0x11
	// Signal `usart1_tx_dma` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_USART1_TX_DMA = 0x12
	// Signal `usart2_rx_dma` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_USART2_RX_DMA = 0x13
	// Signal `usart2_tx_dma` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_USART2_TX_DMA = 0x14
	// Signal `lpuart1_rx_dma` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_LPUART1_RX_DMA = 0x15
	// Signal `lpuart1_tx_dma` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_LPUART1_TX_DMA = 0x16
	// Signal `tim1_ch1` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_TIM1_CH1 = 0x17
	// Signal `tim1_ch2` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_TIM1_CH2 = 0x18
	// Signal `tim1_ch3` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_TIM1_CH3 = 0x19
	// Signal `tim1_ch4` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_TIM1_CH4 = 0x1a
	// Signal `tim1_up` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_TIM1_UP = 0x1b
	// Signal `tim1_trig` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_TIM1_TRIG = 0x1c
	// Signal `tim1_com` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_TIM1_COM = 0x1d
	// Signal `tim2_ch1` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_TIM2_CH1 = 0x1e
	// Signal `tim2_ch2` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_TIM2_CH2 = 0x1f
	// Signal `tim2_ch3` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_TIM2_CH3 = 0x20
	// Signal `tim2_ch4` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_TIM2_CH4 = 0x21
	// Signal `tim2_up` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_TIM2_UP = 0x22
	// Signal `tim16_ch1` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_TIM16_CH1 = 0x23
	// Signal `tim16_up` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_TIM16_UP = 0x24
	// Signal `tim17_ch1` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_TIM17_CH1 = 0x25
	// Signal `tim17_up` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_TIM17_UP = 0x26
	// Signal `aes_in` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_AES_IN = 0x27
	// Signal `aes_out` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_AES_OUT = 0x28
	// Signal `subghzspi_rx` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_SUBGHZSPI_RX = 0x29
	// Signal `subghzspi_tx` selected as request input
	DMAMUX_C3CR_DMAREQ_ID_SUBGHZSPI_TX = 0x2a

	// C4CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C4CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C4CR_SYNC_ID_Msk = 0x1f000000
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_EXTI0 = 0x0
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_EXTI1 = 0x1
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_EXTI2 = 0x2
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_EXTI3 = 0x3
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_EXTI4 = 0x4
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_EXTI5 = 0x5
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_EXTI6 = 0x6
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_EXTI7 = 0x7
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_EXTI8 = 0x8
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_EXTI9 = 0x9
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_EXTI10 = 0xa
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_EXTI11 = 0xb
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_EXTI12 = 0xc
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_EXTI13 = 0xd
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_EXTI14 = 0xe
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_EXTI15 = 0xf
	// Signal `dmamux1_evt0` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_DMAMUX1_EVT0 = 0x10
	// Signal `dmamux1_evt1` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_DMAMUX1_EVT1 = 0x11
	// Signal `lptim1_out` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_LPTIM1_OUT = 0x12
	// Signal `lptim2_out` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_LPTIM2_OUT = 0x13
	// Signal `lptim3_out` selected as synchronization input
	DMAMUX_C4CR_SYNC_ID_LPTIM3_OUT = 0x14
	// Position of NBREQ field.
	DMAMUX_C4CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C4CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C4CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C4CR_SPOL_Msk = 0x60000
	// No event, i.e. no synchronization nor detection
	DMAMUX_C4CR_SPOL_NoEdge = 0x0
	// Rising edge
	DMAMUX_C4CR_SPOL_RisingEdge = 0x1
	// Falling edge
	DMAMUX_C4CR_SPOL_FallingEdge = 0x2
	// Rising and falling edges
	DMAMUX_C4CR_SPOL_BothEdges = 0x3
	// Position of SE field.
	DMAMUX_C4CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C4CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C4CR_SE = 0x10000
	// Synchronization disabled
	DMAMUX_C4CR_SE_Disabled = 0x0
	// Synchronization enabled
	DMAMUX_C4CR_SE_Enabled = 0x1
	// Position of EGE field.
	DMAMUX_C4CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C4CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C4CR_EGE = 0x200
	// Event generation disabled
	DMAMUX_C4CR_EGE_Disabled = 0x0
	// Event generation enabled
	DMAMUX_C4CR_EGE_Enabled = 0x1
	// Position of SOIE field.
	DMAMUX_C4CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C4CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C4CR_SOIE = 0x100
	// Synchronization overrun interrupt disabled
	DMAMUX_C4CR_SOIE_Disabled = 0x0
	// Synchronization overrun interrupt enabled
	DMAMUX_C4CR_SOIE_Enabled = 0x1
	// Position of DMAREQ_ID field.
	DMAMUX_C4CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C4CR_DMAREQ_ID_Msk = 0xff
	// No signal selected as request input
	DMAMUX_C4CR_DMAREQ_ID_NONE = 0x0
	// Signal `dmamux1_req_gen0` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_DMAMUX1_REQ_GEN0 = 0x1
	// Signal `dmamux1_req_gen1` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_DMAMUX1_REQ_GEN1 = 0x2
	// Signal `dmamux1_req_gen2` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_DMAMUX1_REQ_GEN2 = 0x3
	// Signal `dmamux1_req_gen3` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_DMAMUX1_REQ_GEN3 = 0x4
	// Signal `adc1_dma` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_ADC = 0x5
	// Signal `dac_out1_dma` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_DAT_OUT1 = 0x6
	// Signal `spi1_rx_dma` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_SPI1_RX_DMA = 0x7
	// Signal `spi1_tx_dma` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_SPI1_TX_DMA = 0x8
	// Signal `spi2_rx_dma` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_SPI2_RX_DMA = 0x9
	// Signal `spi2_tx_dma` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_SPI2_TX_DMA = 0xa
	// Signal `i2c1_rx_dma` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_I2C1_RX_DMA = 0xb
	// Signal `i2c1_tx_dma` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_I2C1_TX_DMA = 0xc
	// Signal `i2c2_rx_dma` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_I2C2_RX_DMA = 0xd
	// Signal `i2c2_tx_dma` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_I2C2_TX_DMA = 0xe
	// Signal `i2c3_rx_dma` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_I2C3_RX_DMA = 0xf
	// Signal `i2c3_tx_dma` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_I2C3_TX_DMA = 0x10
	// Signal `usart1_rx_dma` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_USART1_RX_DMA = 0x11
	// Signal `usart1_tx_dma` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_USART1_TX_DMA = 0x12
	// Signal `usart2_rx_dma` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_USART2_RX_DMA = 0x13
	// Signal `usart2_tx_dma` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_USART2_TX_DMA = 0x14
	// Signal `lpuart1_rx_dma` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_LPUART1_RX_DMA = 0x15
	// Signal `lpuart1_tx_dma` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_LPUART1_TX_DMA = 0x16
	// Signal `tim1_ch1` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_TIM1_CH1 = 0x17
	// Signal `tim1_ch2` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_TIM1_CH2 = 0x18
	// Signal `tim1_ch3` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_TIM1_CH3 = 0x19
	// Signal `tim1_ch4` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_TIM1_CH4 = 0x1a
	// Signal `tim1_up` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_TIM1_UP = 0x1b
	// Signal `tim1_trig` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_TIM1_TRIG = 0x1c
	// Signal `tim1_com` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_TIM1_COM = 0x1d
	// Signal `tim2_ch1` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_TIM2_CH1 = 0x1e
	// Signal `tim2_ch2` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_TIM2_CH2 = 0x1f
	// Signal `tim2_ch3` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_TIM2_CH3 = 0x20
	// Signal `tim2_ch4` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_TIM2_CH4 = 0x21
	// Signal `tim2_up` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_TIM2_UP = 0x22
	// Signal `tim16_ch1` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_TIM16_CH1 = 0x23
	// Signal `tim16_up` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_TIM16_UP = 0x24
	// Signal `tim17_ch1` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_TIM17_CH1 = 0x25
	// Signal `tim17_up` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_TIM17_UP = 0x26
	// Signal `aes_in` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_AES_IN = 0x27
	// Signal `aes_out` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_AES_OUT = 0x28
	// Signal `subghzspi_rx` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_SUBGHZSPI_RX = 0x29
	// Signal `subghzspi_tx` selected as request input
	DMAMUX_C4CR_DMAREQ_ID_SUBGHZSPI_TX = 0x2a

	// C5CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C5CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C5CR_SYNC_ID_Msk = 0x1f000000
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_EXTI0 = 0x0
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_EXTI1 = 0x1
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_EXTI2 = 0x2
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_EXTI3 = 0x3
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_EXTI4 = 0x4
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_EXTI5 = 0x5
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_EXTI6 = 0x6
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_EXTI7 = 0x7
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_EXTI8 = 0x8
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_EXTI9 = 0x9
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_EXTI10 = 0xa
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_EXTI11 = 0xb
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_EXTI12 = 0xc
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_EXTI13 = 0xd
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_EXTI14 = 0xe
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_EXTI15 = 0xf
	// Signal `dmamux1_evt0` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_DMAMUX1_EVT0 = 0x10
	// Signal `dmamux1_evt1` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_DMAMUX1_EVT1 = 0x11
	// Signal `lptim1_out` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_LPTIM1_OUT = 0x12
	// Signal `lptim2_out` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_LPTIM2_OUT = 0x13
	// Signal `lptim3_out` selected as synchronization input
	DMAMUX_C5CR_SYNC_ID_LPTIM3_OUT = 0x14
	// Position of NBREQ field.
	DMAMUX_C5CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C5CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C5CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C5CR_SPOL_Msk = 0x60000
	// No event, i.e. no synchronization nor detection
	DMAMUX_C5CR_SPOL_NoEdge = 0x0
	// Rising edge
	DMAMUX_C5CR_SPOL_RisingEdge = 0x1
	// Falling edge
	DMAMUX_C5CR_SPOL_FallingEdge = 0x2
	// Rising and falling edges
	DMAMUX_C5CR_SPOL_BothEdges = 0x3
	// Position of SE field.
	DMAMUX_C5CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C5CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C5CR_SE = 0x10000
	// Synchronization disabled
	DMAMUX_C5CR_SE_Disabled = 0x0
	// Synchronization enabled
	DMAMUX_C5CR_SE_Enabled = 0x1
	// Position of EGE field.
	DMAMUX_C5CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C5CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C5CR_EGE = 0x200
	// Event generation disabled
	DMAMUX_C5CR_EGE_Disabled = 0x0
	// Event generation enabled
	DMAMUX_C5CR_EGE_Enabled = 0x1
	// Position of SOIE field.
	DMAMUX_C5CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C5CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C5CR_SOIE = 0x100
	// Synchronization overrun interrupt disabled
	DMAMUX_C5CR_SOIE_Disabled = 0x0
	// Synchronization overrun interrupt enabled
	DMAMUX_C5CR_SOIE_Enabled = 0x1
	// Position of DMAREQ_ID field.
	DMAMUX_C5CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C5CR_DMAREQ_ID_Msk = 0xff
	// No signal selected as request input
	DMAMUX_C5CR_DMAREQ_ID_NONE = 0x0
	// Signal `dmamux1_req_gen0` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_DMAMUX1_REQ_GEN0 = 0x1
	// Signal `dmamux1_req_gen1` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_DMAMUX1_REQ_GEN1 = 0x2
	// Signal `dmamux1_req_gen2` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_DMAMUX1_REQ_GEN2 = 0x3
	// Signal `dmamux1_req_gen3` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_DMAMUX1_REQ_GEN3 = 0x4
	// Signal `adc1_dma` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_ADC = 0x5
	// Signal `dac_out1_dma` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_DAT_OUT1 = 0x6
	// Signal `spi1_rx_dma` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_SPI1_RX_DMA = 0x7
	// Signal `spi1_tx_dma` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_SPI1_TX_DMA = 0x8
	// Signal `spi2_rx_dma` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_SPI2_RX_DMA = 0x9
	// Signal `spi2_tx_dma` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_SPI2_TX_DMA = 0xa
	// Signal `i2c1_rx_dma` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_I2C1_RX_DMA = 0xb
	// Signal `i2c1_tx_dma` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_I2C1_TX_DMA = 0xc
	// Signal `i2c2_rx_dma` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_I2C2_RX_DMA = 0xd
	// Signal `i2c2_tx_dma` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_I2C2_TX_DMA = 0xe
	// Signal `i2c3_rx_dma` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_I2C3_RX_DMA = 0xf
	// Signal `i2c3_tx_dma` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_I2C3_TX_DMA = 0x10
	// Signal `usart1_rx_dma` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_USART1_RX_DMA = 0x11
	// Signal `usart1_tx_dma` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_USART1_TX_DMA = 0x12
	// Signal `usart2_rx_dma` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_USART2_RX_DMA = 0x13
	// Signal `usart2_tx_dma` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_USART2_TX_DMA = 0x14
	// Signal `lpuart1_rx_dma` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_LPUART1_RX_DMA = 0x15
	// Signal `lpuart1_tx_dma` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_LPUART1_TX_DMA = 0x16
	// Signal `tim1_ch1` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_TIM1_CH1 = 0x17
	// Signal `tim1_ch2` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_TIM1_CH2 = 0x18
	// Signal `tim1_ch3` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_TIM1_CH3 = 0x19
	// Signal `tim1_ch4` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_TIM1_CH4 = 0x1a
	// Signal `tim1_up` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_TIM1_UP = 0x1b
	// Signal `tim1_trig` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_TIM1_TRIG = 0x1c
	// Signal `tim1_com` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_TIM1_COM = 0x1d
	// Signal `tim2_ch1` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_TIM2_CH1 = 0x1e
	// Signal `tim2_ch2` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_TIM2_CH2 = 0x1f
	// Signal `tim2_ch3` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_TIM2_CH3 = 0x20
	// Signal `tim2_ch4` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_TIM2_CH4 = 0x21
	// Signal `tim2_up` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_TIM2_UP = 0x22
	// Signal `tim16_ch1` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_TIM16_CH1 = 0x23
	// Signal `tim16_up` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_TIM16_UP = 0x24
	// Signal `tim17_ch1` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_TIM17_CH1 = 0x25
	// Signal `tim17_up` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_TIM17_UP = 0x26
	// Signal `aes_in` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_AES_IN = 0x27
	// Signal `aes_out` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_AES_OUT = 0x28
	// Signal `subghzspi_rx` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_SUBGHZSPI_RX = 0x29
	// Signal `subghzspi_tx` selected as request input
	DMAMUX_C5CR_DMAREQ_ID_SUBGHZSPI_TX = 0x2a

	// C6CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C6CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C6CR_SYNC_ID_Msk = 0x1f000000
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_EXTI0 = 0x0
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_EXTI1 = 0x1
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_EXTI2 = 0x2
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_EXTI3 = 0x3
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_EXTI4 = 0x4
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_EXTI5 = 0x5
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_EXTI6 = 0x6
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_EXTI7 = 0x7
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_EXTI8 = 0x8
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_EXTI9 = 0x9
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_EXTI10 = 0xa
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_EXTI11 = 0xb
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_EXTI12 = 0xc
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_EXTI13 = 0xd
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_EXTI14 = 0xe
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_EXTI15 = 0xf
	// Signal `dmamux1_evt0` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_DMAMUX1_EVT0 = 0x10
	// Signal `dmamux1_evt1` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_DMAMUX1_EVT1 = 0x11
	// Signal `lptim1_out` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_LPTIM1_OUT = 0x12
	// Signal `lptim2_out` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_LPTIM2_OUT = 0x13
	// Signal `lptim3_out` selected as synchronization input
	DMAMUX_C6CR_SYNC_ID_LPTIM3_OUT = 0x14
	// Position of NBREQ field.
	DMAMUX_C6CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C6CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C6CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C6CR_SPOL_Msk = 0x60000
	// No event, i.e. no synchronization nor detection
	DMAMUX_C6CR_SPOL_NoEdge = 0x0
	// Rising edge
	DMAMUX_C6CR_SPOL_RisingEdge = 0x1
	// Falling edge
	DMAMUX_C6CR_SPOL_FallingEdge = 0x2
	// Rising and falling edges
	DMAMUX_C6CR_SPOL_BothEdges = 0x3
	// Position of SE field.
	DMAMUX_C6CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C6CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C6CR_SE = 0x10000
	// Synchronization disabled
	DMAMUX_C6CR_SE_Disabled = 0x0
	// Synchronization enabled
	DMAMUX_C6CR_SE_Enabled = 0x1
	// Position of EGE field.
	DMAMUX_C6CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C6CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C6CR_EGE = 0x200
	// Event generation disabled
	DMAMUX_C6CR_EGE_Disabled = 0x0
	// Event generation enabled
	DMAMUX_C6CR_EGE_Enabled = 0x1
	// Position of SOIE field.
	DMAMUX_C6CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C6CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C6CR_SOIE = 0x100
	// Synchronization overrun interrupt disabled
	DMAMUX_C6CR_SOIE_Disabled = 0x0
	// Synchronization overrun interrupt enabled
	DMAMUX_C6CR_SOIE_Enabled = 0x1
	// Position of DMAREQ_ID field.
	DMAMUX_C6CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C6CR_DMAREQ_ID_Msk = 0xff
	// No signal selected as request input
	DMAMUX_C6CR_DMAREQ_ID_NONE = 0x0
	// Signal `dmamux1_req_gen0` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_DMAMUX1_REQ_GEN0 = 0x1
	// Signal `dmamux1_req_gen1` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_DMAMUX1_REQ_GEN1 = 0x2
	// Signal `dmamux1_req_gen2` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_DMAMUX1_REQ_GEN2 = 0x3
	// Signal `dmamux1_req_gen3` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_DMAMUX1_REQ_GEN3 = 0x4
	// Signal `adc1_dma` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_ADC = 0x5
	// Signal `dac_out1_dma` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_DAT_OUT1 = 0x6
	// Signal `spi1_rx_dma` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_SPI1_RX_DMA = 0x7
	// Signal `spi1_tx_dma` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_SPI1_TX_DMA = 0x8
	// Signal `spi2_rx_dma` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_SPI2_RX_DMA = 0x9
	// Signal `spi2_tx_dma` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_SPI2_TX_DMA = 0xa
	// Signal `i2c1_rx_dma` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_I2C1_RX_DMA = 0xb
	// Signal `i2c1_tx_dma` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_I2C1_TX_DMA = 0xc
	// Signal `i2c2_rx_dma` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_I2C2_RX_DMA = 0xd
	// Signal `i2c2_tx_dma` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_I2C2_TX_DMA = 0xe
	// Signal `i2c3_rx_dma` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_I2C3_RX_DMA = 0xf
	// Signal `i2c3_tx_dma` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_I2C3_TX_DMA = 0x10
	// Signal `usart1_rx_dma` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_USART1_RX_DMA = 0x11
	// Signal `usart1_tx_dma` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_USART1_TX_DMA = 0x12
	// Signal `usart2_rx_dma` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_USART2_RX_DMA = 0x13
	// Signal `usart2_tx_dma` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_USART2_TX_DMA = 0x14
	// Signal `lpuart1_rx_dma` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_LPUART1_RX_DMA = 0x15
	// Signal `lpuart1_tx_dma` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_LPUART1_TX_DMA = 0x16
	// Signal `tim1_ch1` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_TIM1_CH1 = 0x17
	// Signal `tim1_ch2` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_TIM1_CH2 = 0x18
	// Signal `tim1_ch3` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_TIM1_CH3 = 0x19
	// Signal `tim1_ch4` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_TIM1_CH4 = 0x1a
	// Signal `tim1_up` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_TIM1_UP = 0x1b
	// Signal `tim1_trig` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_TIM1_TRIG = 0x1c
	// Signal `tim1_com` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_TIM1_COM = 0x1d
	// Signal `tim2_ch1` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_TIM2_CH1 = 0x1e
	// Signal `tim2_ch2` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_TIM2_CH2 = 0x1f
	// Signal `tim2_ch3` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_TIM2_CH3 = 0x20
	// Signal `tim2_ch4` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_TIM2_CH4 = 0x21
	// Signal `tim2_up` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_TIM2_UP = 0x22
	// Signal `tim16_ch1` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_TIM16_CH1 = 0x23
	// Signal `tim16_up` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_TIM16_UP = 0x24
	// Signal `tim17_ch1` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_TIM17_CH1 = 0x25
	// Signal `tim17_up` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_TIM17_UP = 0x26
	// Signal `aes_in` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_AES_IN = 0x27
	// Signal `aes_out` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_AES_OUT = 0x28
	// Signal `subghzspi_rx` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_SUBGHZSPI_RX = 0x29
	// Signal `subghzspi_tx` selected as request input
	DMAMUX_C6CR_DMAREQ_ID_SUBGHZSPI_TX = 0x2a

	// C7CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C7CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C7CR_SYNC_ID_Msk = 0x1f000000
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_EXTI0 = 0x0
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_EXTI1 = 0x1
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_EXTI2 = 0x2
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_EXTI3 = 0x3
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_EXTI4 = 0x4
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_EXTI5 = 0x5
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_EXTI6 = 0x6
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_EXTI7 = 0x7
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_EXTI8 = 0x8
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_EXTI9 = 0x9
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_EXTI10 = 0xa
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_EXTI11 = 0xb
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_EXTI12 = 0xc
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_EXTI13 = 0xd
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_EXTI14 = 0xe
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_EXTI15 = 0xf
	// Signal `dmamux1_evt0` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_DMAMUX1_EVT0 = 0x10
	// Signal `dmamux1_evt1` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_DMAMUX1_EVT1 = 0x11
	// Signal `lptim1_out` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_LPTIM1_OUT = 0x12
	// Signal `lptim2_out` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_LPTIM2_OUT = 0x13
	// Signal `lptim3_out` selected as synchronization input
	DMAMUX_C7CR_SYNC_ID_LPTIM3_OUT = 0x14
	// Position of NBREQ field.
	DMAMUX_C7CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C7CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C7CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C7CR_SPOL_Msk = 0x60000
	// No event, i.e. no synchronization nor detection
	DMAMUX_C7CR_SPOL_NoEdge = 0x0
	// Rising edge
	DMAMUX_C7CR_SPOL_RisingEdge = 0x1
	// Falling edge
	DMAMUX_C7CR_SPOL_FallingEdge = 0x2
	// Rising and falling edges
	DMAMUX_C7CR_SPOL_BothEdges = 0x3
	// Position of SE field.
	DMAMUX_C7CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C7CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C7CR_SE = 0x10000
	// Synchronization disabled
	DMAMUX_C7CR_SE_Disabled = 0x0
	// Synchronization enabled
	DMAMUX_C7CR_SE_Enabled = 0x1
	// Position of EGE field.
	DMAMUX_C7CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C7CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C7CR_EGE = 0x200
	// Event generation disabled
	DMAMUX_C7CR_EGE_Disabled = 0x0
	// Event generation enabled
	DMAMUX_C7CR_EGE_Enabled = 0x1
	// Position of SOIE field.
	DMAMUX_C7CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C7CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C7CR_SOIE = 0x100
	// Synchronization overrun interrupt disabled
	DMAMUX_C7CR_SOIE_Disabled = 0x0
	// Synchronization overrun interrupt enabled
	DMAMUX_C7CR_SOIE_Enabled = 0x1
	// Position of DMAREQ_ID field.
	DMAMUX_C7CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C7CR_DMAREQ_ID_Msk = 0xff
	// No signal selected as request input
	DMAMUX_C7CR_DMAREQ_ID_NONE = 0x0
	// Signal `dmamux1_req_gen0` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_DMAMUX1_REQ_GEN0 = 0x1
	// Signal `dmamux1_req_gen1` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_DMAMUX1_REQ_GEN1 = 0x2
	// Signal `dmamux1_req_gen2` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_DMAMUX1_REQ_GEN2 = 0x3
	// Signal `dmamux1_req_gen3` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_DMAMUX1_REQ_GEN3 = 0x4
	// Signal `adc1_dma` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_ADC = 0x5
	// Signal `dac_out1_dma` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_DAT_OUT1 = 0x6
	// Signal `spi1_rx_dma` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_SPI1_RX_DMA = 0x7
	// Signal `spi1_tx_dma` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_SPI1_TX_DMA = 0x8
	// Signal `spi2_rx_dma` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_SPI2_RX_DMA = 0x9
	// Signal `spi2_tx_dma` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_SPI2_TX_DMA = 0xa
	// Signal `i2c1_rx_dma` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_I2C1_RX_DMA = 0xb
	// Signal `i2c1_tx_dma` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_I2C1_TX_DMA = 0xc
	// Signal `i2c2_rx_dma` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_I2C2_RX_DMA = 0xd
	// Signal `i2c2_tx_dma` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_I2C2_TX_DMA = 0xe
	// Signal `i2c3_rx_dma` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_I2C3_RX_DMA = 0xf
	// Signal `i2c3_tx_dma` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_I2C3_TX_DMA = 0x10
	// Signal `usart1_rx_dma` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_USART1_RX_DMA = 0x11
	// Signal `usart1_tx_dma` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_USART1_TX_DMA = 0x12
	// Signal `usart2_rx_dma` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_USART2_RX_DMA = 0x13
	// Signal `usart2_tx_dma` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_USART2_TX_DMA = 0x14
	// Signal `lpuart1_rx_dma` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_LPUART1_RX_DMA = 0x15
	// Signal `lpuart1_tx_dma` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_LPUART1_TX_DMA = 0x16
	// Signal `tim1_ch1` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_TIM1_CH1 = 0x17
	// Signal `tim1_ch2` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_TIM1_CH2 = 0x18
	// Signal `tim1_ch3` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_TIM1_CH3 = 0x19
	// Signal `tim1_ch4` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_TIM1_CH4 = 0x1a
	// Signal `tim1_up` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_TIM1_UP = 0x1b
	// Signal `tim1_trig` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_TIM1_TRIG = 0x1c
	// Signal `tim1_com` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_TIM1_COM = 0x1d
	// Signal `tim2_ch1` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_TIM2_CH1 = 0x1e
	// Signal `tim2_ch2` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_TIM2_CH2 = 0x1f
	// Signal `tim2_ch3` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_TIM2_CH3 = 0x20
	// Signal `tim2_ch4` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_TIM2_CH4 = 0x21
	// Signal `tim2_up` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_TIM2_UP = 0x22
	// Signal `tim16_ch1` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_TIM16_CH1 = 0x23
	// Signal `tim16_up` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_TIM16_UP = 0x24
	// Signal `tim17_ch1` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_TIM17_CH1 = 0x25
	// Signal `tim17_up` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_TIM17_UP = 0x26
	// Signal `aes_in` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_AES_IN = 0x27
	// Signal `aes_out` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_AES_OUT = 0x28
	// Signal `subghzspi_rx` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_SUBGHZSPI_RX = 0x29
	// Signal `subghzspi_tx` selected as request input
	DMAMUX_C7CR_DMAREQ_ID_SUBGHZSPI_TX = 0x2a

	// C8CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C8CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C8CR_SYNC_ID_Msk = 0x1f000000
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_EXTI0 = 0x0
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_EXTI1 = 0x1
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_EXTI2 = 0x2
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_EXTI3 = 0x3
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_EXTI4 = 0x4
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_EXTI5 = 0x5
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_EXTI6 = 0x6
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_EXTI7 = 0x7
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_EXTI8 = 0x8
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_EXTI9 = 0x9
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_EXTI10 = 0xa
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_EXTI11 = 0xb
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_EXTI12 = 0xc
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_EXTI13 = 0xd
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_EXTI14 = 0xe
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_EXTI15 = 0xf
	// Signal `dmamux1_evt0` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_DMAMUX1_EVT0 = 0x10
	// Signal `dmamux1_evt1` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_DMAMUX1_EVT1 = 0x11
	// Signal `lptim1_out` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_LPTIM1_OUT = 0x12
	// Signal `lptim2_out` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_LPTIM2_OUT = 0x13
	// Signal `lptim3_out` selected as synchronization input
	DMAMUX_C8CR_SYNC_ID_LPTIM3_OUT = 0x14
	// Position of NBREQ field.
	DMAMUX_C8CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C8CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C8CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C8CR_SPOL_Msk = 0x60000
	// No event, i.e. no synchronization nor detection
	DMAMUX_C8CR_SPOL_NoEdge = 0x0
	// Rising edge
	DMAMUX_C8CR_SPOL_RisingEdge = 0x1
	// Falling edge
	DMAMUX_C8CR_SPOL_FallingEdge = 0x2
	// Rising and falling edges
	DMAMUX_C8CR_SPOL_BothEdges = 0x3
	// Position of SE field.
	DMAMUX_C8CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C8CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C8CR_SE = 0x10000
	// Synchronization disabled
	DMAMUX_C8CR_SE_Disabled = 0x0
	// Synchronization enabled
	DMAMUX_C8CR_SE_Enabled = 0x1
	// Position of EGE field.
	DMAMUX_C8CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C8CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C8CR_EGE = 0x200
	// Event generation disabled
	DMAMUX_C8CR_EGE_Disabled = 0x0
	// Event generation enabled
	DMAMUX_C8CR_EGE_Enabled = 0x1
	// Position of SOIE field.
	DMAMUX_C8CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C8CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C8CR_SOIE = 0x100
	// Synchronization overrun interrupt disabled
	DMAMUX_C8CR_SOIE_Disabled = 0x0
	// Synchronization overrun interrupt enabled
	DMAMUX_C8CR_SOIE_Enabled = 0x1
	// Position of DMAREQ_ID field.
	DMAMUX_C8CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C8CR_DMAREQ_ID_Msk = 0xff
	// No signal selected as request input
	DMAMUX_C8CR_DMAREQ_ID_NONE = 0x0
	// Signal `dmamux1_req_gen0` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_DMAMUX1_REQ_GEN0 = 0x1
	// Signal `dmamux1_req_gen1` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_DMAMUX1_REQ_GEN1 = 0x2
	// Signal `dmamux1_req_gen2` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_DMAMUX1_REQ_GEN2 = 0x3
	// Signal `dmamux1_req_gen3` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_DMAMUX1_REQ_GEN3 = 0x4
	// Signal `adc1_dma` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_ADC = 0x5
	// Signal `dac_out1_dma` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_DAT_OUT1 = 0x6
	// Signal `spi1_rx_dma` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_SPI1_RX_DMA = 0x7
	// Signal `spi1_tx_dma` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_SPI1_TX_DMA = 0x8
	// Signal `spi2_rx_dma` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_SPI2_RX_DMA = 0x9
	// Signal `spi2_tx_dma` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_SPI2_TX_DMA = 0xa
	// Signal `i2c1_rx_dma` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_I2C1_RX_DMA = 0xb
	// Signal `i2c1_tx_dma` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_I2C1_TX_DMA = 0xc
	// Signal `i2c2_rx_dma` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_I2C2_RX_DMA = 0xd
	// Signal `i2c2_tx_dma` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_I2C2_TX_DMA = 0xe
	// Signal `i2c3_rx_dma` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_I2C3_RX_DMA = 0xf
	// Signal `i2c3_tx_dma` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_I2C3_TX_DMA = 0x10
	// Signal `usart1_rx_dma` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_USART1_RX_DMA = 0x11
	// Signal `usart1_tx_dma` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_USART1_TX_DMA = 0x12
	// Signal `usart2_rx_dma` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_USART2_RX_DMA = 0x13
	// Signal `usart2_tx_dma` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_USART2_TX_DMA = 0x14
	// Signal `lpuart1_rx_dma` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_LPUART1_RX_DMA = 0x15
	// Signal `lpuart1_tx_dma` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_LPUART1_TX_DMA = 0x16
	// Signal `tim1_ch1` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_TIM1_CH1 = 0x17
	// Signal `tim1_ch2` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_TIM1_CH2 = 0x18
	// Signal `tim1_ch3` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_TIM1_CH3 = 0x19
	// Signal `tim1_ch4` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_TIM1_CH4 = 0x1a
	// Signal `tim1_up` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_TIM1_UP = 0x1b
	// Signal `tim1_trig` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_TIM1_TRIG = 0x1c
	// Signal `tim1_com` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_TIM1_COM = 0x1d
	// Signal `tim2_ch1` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_TIM2_CH1 = 0x1e
	// Signal `tim2_ch2` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_TIM2_CH2 = 0x1f
	// Signal `tim2_ch3` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_TIM2_CH3 = 0x20
	// Signal `tim2_ch4` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_TIM2_CH4 = 0x21
	// Signal `tim2_up` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_TIM2_UP = 0x22
	// Signal `tim16_ch1` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_TIM16_CH1 = 0x23
	// Signal `tim16_up` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_TIM16_UP = 0x24
	// Signal `tim17_ch1` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_TIM17_CH1 = 0x25
	// Signal `tim17_up` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_TIM17_UP = 0x26
	// Signal `aes_in` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_AES_IN = 0x27
	// Signal `aes_out` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_AES_OUT = 0x28
	// Signal `subghzspi_rx` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_SUBGHZSPI_RX = 0x29
	// Signal `subghzspi_tx` selected as request input
	DMAMUX_C8CR_DMAREQ_ID_SUBGHZSPI_TX = 0x2a

	// C9CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C9CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C9CR_SYNC_ID_Msk = 0x1f000000
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_EXTI0 = 0x0
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_EXTI1 = 0x1
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_EXTI2 = 0x2
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_EXTI3 = 0x3
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_EXTI4 = 0x4
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_EXTI5 = 0x5
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_EXTI6 = 0x6
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_EXTI7 = 0x7
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_EXTI8 = 0x8
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_EXTI9 = 0x9
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_EXTI10 = 0xa
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_EXTI11 = 0xb
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_EXTI12 = 0xc
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_EXTI13 = 0xd
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_EXTI14 = 0xe
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_EXTI15 = 0xf
	// Signal `dmamux1_evt0` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_DMAMUX1_EVT0 = 0x10
	// Signal `dmamux1_evt1` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_DMAMUX1_EVT1 = 0x11
	// Signal `lptim1_out` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_LPTIM1_OUT = 0x12
	// Signal `lptim2_out` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_LPTIM2_OUT = 0x13
	// Signal `lptim3_out` selected as synchronization input
	DMAMUX_C9CR_SYNC_ID_LPTIM3_OUT = 0x14
	// Position of NBREQ field.
	DMAMUX_C9CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C9CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C9CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C9CR_SPOL_Msk = 0x60000
	// No event, i.e. no synchronization nor detection
	DMAMUX_C9CR_SPOL_NoEdge = 0x0
	// Rising edge
	DMAMUX_C9CR_SPOL_RisingEdge = 0x1
	// Falling edge
	DMAMUX_C9CR_SPOL_FallingEdge = 0x2
	// Rising and falling edges
	DMAMUX_C9CR_SPOL_BothEdges = 0x3
	// Position of SE field.
	DMAMUX_C9CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C9CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C9CR_SE = 0x10000
	// Synchronization disabled
	DMAMUX_C9CR_SE_Disabled = 0x0
	// Synchronization enabled
	DMAMUX_C9CR_SE_Enabled = 0x1
	// Position of EGE field.
	DMAMUX_C9CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C9CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C9CR_EGE = 0x200
	// Event generation disabled
	DMAMUX_C9CR_EGE_Disabled = 0x0
	// Event generation enabled
	DMAMUX_C9CR_EGE_Enabled = 0x1
	// Position of SOIE field.
	DMAMUX_C9CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C9CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C9CR_SOIE = 0x100
	// Synchronization overrun interrupt disabled
	DMAMUX_C9CR_SOIE_Disabled = 0x0
	// Synchronization overrun interrupt enabled
	DMAMUX_C9CR_SOIE_Enabled = 0x1
	// Position of DMAREQ_ID field.
	DMAMUX_C9CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C9CR_DMAREQ_ID_Msk = 0xff
	// No signal selected as request input
	DMAMUX_C9CR_DMAREQ_ID_NONE = 0x0
	// Signal `dmamux1_req_gen0` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_DMAMUX1_REQ_GEN0 = 0x1
	// Signal `dmamux1_req_gen1` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_DMAMUX1_REQ_GEN1 = 0x2
	// Signal `dmamux1_req_gen2` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_DMAMUX1_REQ_GEN2 = 0x3
	// Signal `dmamux1_req_gen3` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_DMAMUX1_REQ_GEN3 = 0x4
	// Signal `adc1_dma` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_ADC = 0x5
	// Signal `dac_out1_dma` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_DAT_OUT1 = 0x6
	// Signal `spi1_rx_dma` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_SPI1_RX_DMA = 0x7
	// Signal `spi1_tx_dma` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_SPI1_TX_DMA = 0x8
	// Signal `spi2_rx_dma` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_SPI2_RX_DMA = 0x9
	// Signal `spi2_tx_dma` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_SPI2_TX_DMA = 0xa
	// Signal `i2c1_rx_dma` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_I2C1_RX_DMA = 0xb
	// Signal `i2c1_tx_dma` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_I2C1_TX_DMA = 0xc
	// Signal `i2c2_rx_dma` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_I2C2_RX_DMA = 0xd
	// Signal `i2c2_tx_dma` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_I2C2_TX_DMA = 0xe
	// Signal `i2c3_rx_dma` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_I2C3_RX_DMA = 0xf
	// Signal `i2c3_tx_dma` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_I2C3_TX_DMA = 0x10
	// Signal `usart1_rx_dma` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_USART1_RX_DMA = 0x11
	// Signal `usart1_tx_dma` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_USART1_TX_DMA = 0x12
	// Signal `usart2_rx_dma` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_USART2_RX_DMA = 0x13
	// Signal `usart2_tx_dma` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_USART2_TX_DMA = 0x14
	// Signal `lpuart1_rx_dma` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_LPUART1_RX_DMA = 0x15
	// Signal `lpuart1_tx_dma` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_LPUART1_TX_DMA = 0x16
	// Signal `tim1_ch1` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_TIM1_CH1 = 0x17
	// Signal `tim1_ch2` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_TIM1_CH2 = 0x18
	// Signal `tim1_ch3` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_TIM1_CH3 = 0x19
	// Signal `tim1_ch4` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_TIM1_CH4 = 0x1a
	// Signal `tim1_up` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_TIM1_UP = 0x1b
	// Signal `tim1_trig` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_TIM1_TRIG = 0x1c
	// Signal `tim1_com` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_TIM1_COM = 0x1d
	// Signal `tim2_ch1` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_TIM2_CH1 = 0x1e
	// Signal `tim2_ch2` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_TIM2_CH2 = 0x1f
	// Signal `tim2_ch3` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_TIM2_CH3 = 0x20
	// Signal `tim2_ch4` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_TIM2_CH4 = 0x21
	// Signal `tim2_up` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_TIM2_UP = 0x22
	// Signal `tim16_ch1` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_TIM16_CH1 = 0x23
	// Signal `tim16_up` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_TIM16_UP = 0x24
	// Signal `tim17_ch1` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_TIM17_CH1 = 0x25
	// Signal `tim17_up` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_TIM17_UP = 0x26
	// Signal `aes_in` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_AES_IN = 0x27
	// Signal `aes_out` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_AES_OUT = 0x28
	// Signal `subghzspi_rx` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_SUBGHZSPI_RX = 0x29
	// Signal `subghzspi_tx` selected as request input
	DMAMUX_C9CR_DMAREQ_ID_SUBGHZSPI_TX = 0x2a

	// C10CR: C10CR
	// Position of SYNC_ID field.
	DMAMUX_C10CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C10CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C10CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C10CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C10CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C10CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C10CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C10CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C10CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C10CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C10CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C10CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C10CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C10CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C10CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C10CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C10CR_DMAREQ_ID_Msk = 0xff

	// C11CR: C11CR
	// Position of SYNC_ID field.
	DMAMUX_C11CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C11CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C11CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C11CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C11CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C11CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C11CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C11CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C11CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C11CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C11CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C11CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C11CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C11CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C11CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C11CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C11CR_DMAREQ_ID_Msk = 0xff

	// C12CR: C12CR
	// Position of SYNC_ID field.
	DMAMUX_C12CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C12CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C12CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C12CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C12CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C12CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C12CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C12CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C12CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C12CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C12CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C12CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C12CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C12CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C12CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C12CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C12CR_DMAREQ_ID_Msk = 0xff

	// C13CR: C13CR
	// Position of SYNC_ID field.
	DMAMUX_C13CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C13CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C13CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C13CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C13CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C13CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C13CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C13CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C13CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C13CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C13CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C13CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C13CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C13CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C13CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C13CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C13CR_DMAREQ_ID_Msk = 0xff

	// CSR: request line multiplexer interrupt channel status register
	// Position of SOF13 field.
	DMAMUX_CSR_SOF13_Pos = 0xd
	// Bit mask of SOF13 field.
	DMAMUX_CSR_SOF13_Msk = 0x2000
	// Bit SOF13.
	DMAMUX_CSR_SOF13 = 0x2000
	// No synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF13_NoSyncEvent = 0x0
	// Synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF13_SyncEvent = 0x1
	// Position of SOF12 field.
	DMAMUX_CSR_SOF12_Pos = 0xc
	// Bit mask of SOF12 field.
	DMAMUX_CSR_SOF12_Msk = 0x1000
	// Bit SOF12.
	DMAMUX_CSR_SOF12 = 0x1000
	// No synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF12_NoSyncEvent = 0x0
	// Synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF12_SyncEvent = 0x1
	// Position of SOF11 field.
	DMAMUX_CSR_SOF11_Pos = 0xb
	// Bit mask of SOF11 field.
	DMAMUX_CSR_SOF11_Msk = 0x800
	// Bit SOF11.
	DMAMUX_CSR_SOF11 = 0x800
	// No synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF11_NoSyncEvent = 0x0
	// Synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF11_SyncEvent = 0x1
	// Position of SOF10 field.
	DMAMUX_CSR_SOF10_Pos = 0xa
	// Bit mask of SOF10 field.
	DMAMUX_CSR_SOF10_Msk = 0x400
	// Bit SOF10.
	DMAMUX_CSR_SOF10 = 0x400
	// No synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF10_NoSyncEvent = 0x0
	// Synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF10_SyncEvent = 0x1
	// Position of SOF9 field.
	DMAMUX_CSR_SOF9_Pos = 0x9
	// Bit mask of SOF9 field.
	DMAMUX_CSR_SOF9_Msk = 0x200
	// Bit SOF9.
	DMAMUX_CSR_SOF9 = 0x200
	// No synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF9_NoSyncEvent = 0x0
	// Synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF9_SyncEvent = 0x1
	// Position of SOF8 field.
	DMAMUX_CSR_SOF8_Pos = 0x8
	// Bit mask of SOF8 field.
	DMAMUX_CSR_SOF8_Msk = 0x100
	// Bit SOF8.
	DMAMUX_CSR_SOF8 = 0x100
	// No synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF8_NoSyncEvent = 0x0
	// Synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF8_SyncEvent = 0x1
	// Position of SOF7 field.
	DMAMUX_CSR_SOF7_Pos = 0x7
	// Bit mask of SOF7 field.
	DMAMUX_CSR_SOF7_Msk = 0x80
	// Bit SOF7.
	DMAMUX_CSR_SOF7 = 0x80
	// No synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF7_NoSyncEvent = 0x0
	// Synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF7_SyncEvent = 0x1
	// Position of SOF6 field.
	DMAMUX_CSR_SOF6_Pos = 0x6
	// Bit mask of SOF6 field.
	DMAMUX_CSR_SOF6_Msk = 0x40
	// Bit SOF6.
	DMAMUX_CSR_SOF6 = 0x40
	// No synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF6_NoSyncEvent = 0x0
	// Synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF6_SyncEvent = 0x1
	// Position of SOF5 field.
	DMAMUX_CSR_SOF5_Pos = 0x5
	// Bit mask of SOF5 field.
	DMAMUX_CSR_SOF5_Msk = 0x20
	// Bit SOF5.
	DMAMUX_CSR_SOF5 = 0x20
	// No synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF5_NoSyncEvent = 0x0
	// Synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF5_SyncEvent = 0x1
	// Position of SOF4 field.
	DMAMUX_CSR_SOF4_Pos = 0x4
	// Bit mask of SOF4 field.
	DMAMUX_CSR_SOF4_Msk = 0x10
	// Bit SOF4.
	DMAMUX_CSR_SOF4 = 0x10
	// No synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF4_NoSyncEvent = 0x0
	// Synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF4_SyncEvent = 0x1
	// Position of SOF3 field.
	DMAMUX_CSR_SOF3_Pos = 0x3
	// Bit mask of SOF3 field.
	DMAMUX_CSR_SOF3_Msk = 0x8
	// Bit SOF3.
	DMAMUX_CSR_SOF3 = 0x8
	// No synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF3_NoSyncEvent = 0x0
	// Synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF3_SyncEvent = 0x1
	// Position of SOF2 field.
	DMAMUX_CSR_SOF2_Pos = 0x2
	// Bit mask of SOF2 field.
	DMAMUX_CSR_SOF2_Msk = 0x4
	// Bit SOF2.
	DMAMUX_CSR_SOF2 = 0x4
	// No synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF2_NoSyncEvent = 0x0
	// Synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF2_SyncEvent = 0x1
	// Position of SOF1 field.
	DMAMUX_CSR_SOF1_Pos = 0x1
	// Bit mask of SOF1 field.
	DMAMUX_CSR_SOF1_Msk = 0x2
	// Bit SOF1.
	DMAMUX_CSR_SOF1 = 0x2
	// No synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF1_NoSyncEvent = 0x0
	// Synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF1_SyncEvent = 0x1
	// Position of SOF0 field.
	DMAMUX_CSR_SOF0_Pos = 0x0
	// Bit mask of SOF0 field.
	DMAMUX_CSR_SOF0_Msk = 0x1
	// Bit SOF0.
	DMAMUX_CSR_SOF0 = 0x1
	// No synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF0_NoSyncEvent = 0x0
	// Synchronization event occured on a DMA request line multiplexer channel x, while the DMA request counter value is lower than NBREQ
	DMAMUX_CSR_SOF0_SyncEvent = 0x1

	// CCFR: request line multiplexer interrupt channel clear flag register
	// Position of CSOF13 field.
	DMAMUX_CCFR_CSOF13_Pos = 0xd
	// Bit mask of CSOF13 field.
	DMAMUX_CCFR_CSOF13_Msk = 0x2000
	// Bit CSOF13.
	DMAMUX_CCFR_CSOF13 = 0x2000
	// Clear synchronization flag
	DMAMUX_CCFR_CSOF13_Clear = 0x1
	// Position of CSOF12 field.
	DMAMUX_CCFR_CSOF12_Pos = 0xc
	// Bit mask of CSOF12 field.
	DMAMUX_CCFR_CSOF12_Msk = 0x1000
	// Bit CSOF12.
	DMAMUX_CCFR_CSOF12 = 0x1000
	// Clear synchronization flag
	DMAMUX_CCFR_CSOF12_Clear = 0x1
	// Position of CSOF11 field.
	DMAMUX_CCFR_CSOF11_Pos = 0xb
	// Bit mask of CSOF11 field.
	DMAMUX_CCFR_CSOF11_Msk = 0x800
	// Bit CSOF11.
	DMAMUX_CCFR_CSOF11 = 0x800
	// Clear synchronization flag
	DMAMUX_CCFR_CSOF11_Clear = 0x1
	// Position of CSOF10 field.
	DMAMUX_CCFR_CSOF10_Pos = 0xa
	// Bit mask of CSOF10 field.
	DMAMUX_CCFR_CSOF10_Msk = 0x400
	// Bit CSOF10.
	DMAMUX_CCFR_CSOF10 = 0x400
	// Clear synchronization flag
	DMAMUX_CCFR_CSOF10_Clear = 0x1
	// Position of CSOF9 field.
	DMAMUX_CCFR_CSOF9_Pos = 0x9
	// Bit mask of CSOF9 field.
	DMAMUX_CCFR_CSOF9_Msk = 0x200
	// Bit CSOF9.
	DMAMUX_CCFR_CSOF9 = 0x200
	// Clear synchronization flag
	DMAMUX_CCFR_CSOF9_Clear = 0x1
	// Position of CSOF8 field.
	DMAMUX_CCFR_CSOF8_Pos = 0x8
	// Bit mask of CSOF8 field.
	DMAMUX_CCFR_CSOF8_Msk = 0x100
	// Bit CSOF8.
	DMAMUX_CCFR_CSOF8 = 0x100
	// Clear synchronization flag
	DMAMUX_CCFR_CSOF8_Clear = 0x1
	// Position of CSOF7 field.
	DMAMUX_CCFR_CSOF7_Pos = 0x7
	// Bit mask of CSOF7 field.
	DMAMUX_CCFR_CSOF7_Msk = 0x80
	// Bit CSOF7.
	DMAMUX_CCFR_CSOF7 = 0x80
	// Clear synchronization flag
	DMAMUX_CCFR_CSOF7_Clear = 0x1
	// Position of CSOF6 field.
	DMAMUX_CCFR_CSOF6_Pos = 0x6
	// Bit mask of CSOF6 field.
	DMAMUX_CCFR_CSOF6_Msk = 0x40
	// Bit CSOF6.
	DMAMUX_CCFR_CSOF6 = 0x40
	// Clear synchronization flag
	DMAMUX_CCFR_CSOF6_Clear = 0x1
	// Position of CSOF5 field.
	DMAMUX_CCFR_CSOF5_Pos = 0x5
	// Bit mask of CSOF5 field.
	DMAMUX_CCFR_CSOF5_Msk = 0x20
	// Bit CSOF5.
	DMAMUX_CCFR_CSOF5 = 0x20
	// Clear synchronization flag
	DMAMUX_CCFR_CSOF5_Clear = 0x1
	// Position of CSOF4 field.
	DMAMUX_CCFR_CSOF4_Pos = 0x4
	// Bit mask of CSOF4 field.
	DMAMUX_CCFR_CSOF4_Msk = 0x10
	// Bit CSOF4.
	DMAMUX_CCFR_CSOF4 = 0x10
	// Clear synchronization flag
	DMAMUX_CCFR_CSOF4_Clear = 0x1
	// Position of CSOF3 field.
	DMAMUX_CCFR_CSOF3_Pos = 0x3
	// Bit mask of CSOF3 field.
	DMAMUX_CCFR_CSOF3_Msk = 0x8
	// Bit CSOF3.
	DMAMUX_CCFR_CSOF3 = 0x8
	// Clear synchronization flag
	DMAMUX_CCFR_CSOF3_Clear = 0x1
	// Position of CSOF2 field.
	DMAMUX_CCFR_CSOF2_Pos = 0x2
	// Bit mask of CSOF2 field.
	DMAMUX_CCFR_CSOF2_Msk = 0x4
	// Bit CSOF2.
	DMAMUX_CCFR_CSOF2 = 0x4
	// Clear synchronization flag
	DMAMUX_CCFR_CSOF2_Clear = 0x1
	// Position of CSOF1 field.
	DMAMUX_CCFR_CSOF1_Pos = 0x1
	// Bit mask of CSOF1 field.
	DMAMUX_CCFR_CSOF1_Msk = 0x2
	// Bit CSOF1.
	DMAMUX_CCFR_CSOF1 = 0x2
	// Clear synchronization flag
	DMAMUX_CCFR_CSOF1_Clear = 0x1
	// Position of CSOF0 field.
	DMAMUX_CCFR_CSOF0_Pos = 0x0
	// Bit mask of CSOF0 field.
	DMAMUX_CCFR_CSOF0_Msk = 0x1
	// Bit CSOF0.
	DMAMUX_CCFR_CSOF0 = 0x1
	// Clear synchronization flag
	DMAMUX_CCFR_CSOF0_Clear = 0x1

	// RG0CR: request generator channel x configuration register
	// Position of GNBREQ field.
	DMAMUX_RG0CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG0CR_GNBREQ_Msk = 0xf80000
	// Position of GPOL field.
	DMAMUX_RG0CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG0CR_GPOL_Msk = 0x60000
	// No event, i.e. no detection nor generation
	DMAMUX_RG0CR_GPOL_NoEdge = 0x0
	// Rising edge
	DMAMUX_RG0CR_GPOL_RisingEdge = 0x1
	// Falling edge
	DMAMUX_RG0CR_GPOL_FallingEdge = 0x2
	// Rising and falling edges
	DMAMUX_RG0CR_GPOL_BothEdges = 0x3
	// Position of GE field.
	DMAMUX_RG0CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG0CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG0CR_GE = 0x10000
	// DMA request generation disabled
	DMAMUX_RG0CR_GE_Disabled = 0x0
	// DMA request enabled
	DMAMUX_RG0CR_GE_Enabled = 0x1
	// Position of OIE field.
	DMAMUX_RG0CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG0CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG0CR_OIE = 0x100
	// Trigger overrun interrupt disabled
	DMAMUX_RG0CR_OIE_Disabled = 0x0
	// Trigger overrun interrupt enabled
	DMAMUX_RG0CR_OIE_Enabled = 0x1
	// Position of SIG_ID field.
	DMAMUX_RG0CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG0CR_SIG_ID_Msk = 0x1f
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_EXTI0 = 0x0
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_EXTI1 = 0x1
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_EXTI2 = 0x2
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_EXTI3 = 0x3
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_EXTI4 = 0x4
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_EXTI5 = 0x5
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_EXTI6 = 0x6
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_EXTI7 = 0x7
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_EXTI8 = 0x8
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_EXTI9 = 0x9
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_EXTI10 = 0xa
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_EXTI11 = 0xb
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_EXTI12 = 0xc
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_EXTI13 = 0xd
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_EXTI14 = 0xe
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_EXTI15 = 0xf
	// Signal `dmamux1_evt0` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_DMAMUX1_EVT0 = 0x10
	// Signal `dmamux1_evt1` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_DMAMUX1_EVT1 = 0x11
	// Signal `lptim1_out` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_LPTIM1_OUT = 0x12
	// Signal `lptim2_out` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_LPTIM2_OUT = 0x13
	// Signal `lptim3_out` selected as synchronization input
	DMAMUX_RG0CR_SIG_ID_LPTIM3_OUT = 0x14

	// RG1CR: request generator channel x configuration register
	// Position of GNBREQ field.
	DMAMUX_RG1CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG1CR_GNBREQ_Msk = 0xf80000
	// Position of GPOL field.
	DMAMUX_RG1CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG1CR_GPOL_Msk = 0x60000
	// No event, i.e. no detection nor generation
	DMAMUX_RG1CR_GPOL_NoEdge = 0x0
	// Rising edge
	DMAMUX_RG1CR_GPOL_RisingEdge = 0x1
	// Falling edge
	DMAMUX_RG1CR_GPOL_FallingEdge = 0x2
	// Rising and falling edges
	DMAMUX_RG1CR_GPOL_BothEdges = 0x3
	// Position of GE field.
	DMAMUX_RG1CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG1CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG1CR_GE = 0x10000
	// DMA request generation disabled
	DMAMUX_RG1CR_GE_Disabled = 0x0
	// DMA request enabled
	DMAMUX_RG1CR_GE_Enabled = 0x1
	// Position of OIE field.
	DMAMUX_RG1CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG1CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG1CR_OIE = 0x100
	// Trigger overrun interrupt disabled
	DMAMUX_RG1CR_OIE_Disabled = 0x0
	// Trigger overrun interrupt enabled
	DMAMUX_RG1CR_OIE_Enabled = 0x1
	// Position of SIG_ID field.
	DMAMUX_RG1CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG1CR_SIG_ID_Msk = 0x1f
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_EXTI0 = 0x0
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_EXTI1 = 0x1
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_EXTI2 = 0x2
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_EXTI3 = 0x3
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_EXTI4 = 0x4
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_EXTI5 = 0x5
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_EXTI6 = 0x6
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_EXTI7 = 0x7
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_EXTI8 = 0x8
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_EXTI9 = 0x9
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_EXTI10 = 0xa
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_EXTI11 = 0xb
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_EXTI12 = 0xc
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_EXTI13 = 0xd
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_EXTI14 = 0xe
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_EXTI15 = 0xf
	// Signal `dmamux1_evt0` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_DMAMUX1_EVT0 = 0x10
	// Signal `dmamux1_evt1` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_DMAMUX1_EVT1 = 0x11
	// Signal `lptim1_out` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_LPTIM1_OUT = 0x12
	// Signal `lptim2_out` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_LPTIM2_OUT = 0x13
	// Signal `lptim3_out` selected as synchronization input
	DMAMUX_RG1CR_SIG_ID_LPTIM3_OUT = 0x14

	// RG2CR: request generator channel x configuration register
	// Position of GNBREQ field.
	DMAMUX_RG2CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG2CR_GNBREQ_Msk = 0xf80000
	// Position of GPOL field.
	DMAMUX_RG2CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG2CR_GPOL_Msk = 0x60000
	// No event, i.e. no detection nor generation
	DMAMUX_RG2CR_GPOL_NoEdge = 0x0
	// Rising edge
	DMAMUX_RG2CR_GPOL_RisingEdge = 0x1
	// Falling edge
	DMAMUX_RG2CR_GPOL_FallingEdge = 0x2
	// Rising and falling edges
	DMAMUX_RG2CR_GPOL_BothEdges = 0x3
	// Position of GE field.
	DMAMUX_RG2CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG2CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG2CR_GE = 0x10000
	// DMA request generation disabled
	DMAMUX_RG2CR_GE_Disabled = 0x0
	// DMA request enabled
	DMAMUX_RG2CR_GE_Enabled = 0x1
	// Position of OIE field.
	DMAMUX_RG2CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG2CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG2CR_OIE = 0x100
	// Trigger overrun interrupt disabled
	DMAMUX_RG2CR_OIE_Disabled = 0x0
	// Trigger overrun interrupt enabled
	DMAMUX_RG2CR_OIE_Enabled = 0x1
	// Position of SIG_ID field.
	DMAMUX_RG2CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG2CR_SIG_ID_Msk = 0x1f
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_EXTI0 = 0x0
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_EXTI1 = 0x1
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_EXTI2 = 0x2
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_EXTI3 = 0x3
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_EXTI4 = 0x4
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_EXTI5 = 0x5
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_EXTI6 = 0x6
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_EXTI7 = 0x7
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_EXTI8 = 0x8
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_EXTI9 = 0x9
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_EXTI10 = 0xa
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_EXTI11 = 0xb
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_EXTI12 = 0xc
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_EXTI13 = 0xd
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_EXTI14 = 0xe
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_EXTI15 = 0xf
	// Signal `dmamux1_evt0` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_DMAMUX1_EVT0 = 0x10
	// Signal `dmamux1_evt1` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_DMAMUX1_EVT1 = 0x11
	// Signal `lptim1_out` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_LPTIM1_OUT = 0x12
	// Signal `lptim2_out` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_LPTIM2_OUT = 0x13
	// Signal `lptim3_out` selected as synchronization input
	DMAMUX_RG2CR_SIG_ID_LPTIM3_OUT = 0x14

	// RG3CR: request generator channel x configuration register
	// Position of GNBREQ field.
	DMAMUX_RG3CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG3CR_GNBREQ_Msk = 0xf80000
	// Position of GPOL field.
	DMAMUX_RG3CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG3CR_GPOL_Msk = 0x60000
	// No event, i.e. no detection nor generation
	DMAMUX_RG3CR_GPOL_NoEdge = 0x0
	// Rising edge
	DMAMUX_RG3CR_GPOL_RisingEdge = 0x1
	// Falling edge
	DMAMUX_RG3CR_GPOL_FallingEdge = 0x2
	// Rising and falling edges
	DMAMUX_RG3CR_GPOL_BothEdges = 0x3
	// Position of GE field.
	DMAMUX_RG3CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG3CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG3CR_GE = 0x10000
	// DMA request generation disabled
	DMAMUX_RG3CR_GE_Disabled = 0x0
	// DMA request enabled
	DMAMUX_RG3CR_GE_Enabled = 0x1
	// Position of OIE field.
	DMAMUX_RG3CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG3CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG3CR_OIE = 0x100
	// Trigger overrun interrupt disabled
	DMAMUX_RG3CR_OIE_Disabled = 0x0
	// Trigger overrun interrupt enabled
	DMAMUX_RG3CR_OIE_Enabled = 0x1
	// Position of SIG_ID field.
	DMAMUX_RG3CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG3CR_SIG_ID_Msk = 0x1f
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_EXTI0 = 0x0
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_EXTI1 = 0x1
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_EXTI2 = 0x2
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_EXTI3 = 0x3
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_EXTI4 = 0x4
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_EXTI5 = 0x5
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_EXTI6 = 0x6
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_EXTI7 = 0x7
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_EXTI8 = 0x8
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_EXTI9 = 0x9
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_EXTI10 = 0xa
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_EXTI11 = 0xb
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_EXTI12 = 0xc
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_EXTI13 = 0xd
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_EXTI14 = 0xe
	// Signal `EXTIx` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_EXTI15 = 0xf
	// Signal `dmamux1_evt0` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_DMAMUX1_EVT0 = 0x10
	// Signal `dmamux1_evt1` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_DMAMUX1_EVT1 = 0x11
	// Signal `lptim1_out` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_LPTIM1_OUT = 0x12
	// Signal `lptim2_out` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_LPTIM2_OUT = 0x13
	// Signal `lptim3_out` selected as synchronization input
	DMAMUX_RG3CR_SIG_ID_LPTIM3_OUT = 0x14

	// RGSR: request generator interrupt status register
	// Position of OF3 field.
	DMAMUX_RGSR_OF3_Pos = 0x3
	// Bit mask of OF3 field.
	DMAMUX_RGSR_OF3_Msk = 0x8
	// Bit OF3.
	DMAMUX_RGSR_OF3 = 0x8
	// No new trigger event occured on DMA request generator channel x, before the request counter underrun
	DMAMUX_RGSR_OF3_NoTrigger = 0x0
	// New trigger event occured on DMA request generator channel x, before the request counter underrun
	DMAMUX_RGSR_OF3_Trigger = 0x1
	// Position of OF2 field.
	DMAMUX_RGSR_OF2_Pos = 0x2
	// Bit mask of OF2 field.
	DMAMUX_RGSR_OF2_Msk = 0x4
	// Bit OF2.
	DMAMUX_RGSR_OF2 = 0x4
	// No new trigger event occured on DMA request generator channel x, before the request counter underrun
	DMAMUX_RGSR_OF2_NoTrigger = 0x0
	// New trigger event occured on DMA request generator channel x, before the request counter underrun
	DMAMUX_RGSR_OF2_Trigger = 0x1
	// Position of OF1 field.
	DMAMUX_RGSR_OF1_Pos = 0x1
	// Bit mask of OF1 field.
	DMAMUX_RGSR_OF1_Msk = 0x2
	// Bit OF1.
	DMAMUX_RGSR_OF1 = 0x2
	// No new trigger event occured on DMA request generator channel x, before the request counter underrun
	DMAMUX_RGSR_OF1_NoTrigger = 0x0
	// New trigger event occured on DMA request generator channel x, before the request counter underrun
	DMAMUX_RGSR_OF1_Trigger = 0x1
	// Position of OF0 field.
	DMAMUX_RGSR_OF0_Pos = 0x0
	// Bit mask of OF0 field.
	DMAMUX_RGSR_OF0_Msk = 0x1
	// Bit OF0.
	DMAMUX_RGSR_OF0 = 0x1
	// No new trigger event occured on DMA request generator channel x, before the request counter underrun
	DMAMUX_RGSR_OF0_NoTrigger = 0x0
	// New trigger event occured on DMA request generator channel x, before the request counter underrun
	DMAMUX_RGSR_OF0_Trigger = 0x1

	// RGCFR: request generator interrupt clear flag register
	// Position of COF3 field.
	DMAMUX_RGCFR_COF3_Pos = 0x3
	// Bit mask of COF3 field.
	DMAMUX_RGCFR_COF3_Msk = 0x8
	// Bit COF3.
	DMAMUX_RGCFR_COF3 = 0x8
	// Clear overrun flag
	DMAMUX_RGCFR_COF3_Clear = 0x1
	// Position of COF2 field.
	DMAMUX_RGCFR_COF2_Pos = 0x2
	// Bit mask of COF2 field.
	DMAMUX_RGCFR_COF2_Msk = 0x4
	// Bit COF2.
	DMAMUX_RGCFR_COF2 = 0x4
	// Clear overrun flag
	DMAMUX_RGCFR_COF2_Clear = 0x1
	// Position of COF1 field.
	DMAMUX_RGCFR_COF1_Pos = 0x1
	// Bit mask of COF1 field.
	DMAMUX_RGCFR_COF1_Msk = 0x2
	// Bit COF1.
	DMAMUX_RGCFR_COF1 = 0x2
	// Clear overrun flag
	DMAMUX_RGCFR_COF1_Clear = 0x1
	// Position of COF0 field.
	DMAMUX_RGCFR_COF0_Pos = 0x0
	// Bit mask of COF0 field.
	DMAMUX_RGCFR_COF0_Msk = 0x1
	// Bit COF0.
	DMAMUX_RGCFR_COF0 = 0x1
	// Clear overrun flag
	DMAMUX_RGCFR_COF0_Clear = 0x1
)

// Constants for EXTI: External interrupt/event controller
const (
	// RTSR1: rising trigger selection register
	// Position of RT21 field.
	EXTI_RTSR1_RT21_Pos = 0x15
	// Bit mask of RT21 field.
	EXTI_RTSR1_RT21_Msk = 0x200000
	// Bit RT21.
	EXTI_RTSR1_RT21 = 0x200000
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT21_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT21_Enabled = 0x1
	// Position of RT22 field.
	EXTI_RTSR1_RT22_Pos = 0x16
	// Bit mask of RT22 field.
	EXTI_RTSR1_RT22_Msk = 0x400000
	// Bit RT22.
	EXTI_RTSR1_RT22 = 0x400000
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT22_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT22_Enabled = 0x1
	// Position of RT0 field.
	EXTI_RTSR1_RT0_Pos = 0x0
	// Bit mask of RT0 field.
	EXTI_RTSR1_RT0_Msk = 0x1
	// Bit RT0.
	EXTI_RTSR1_RT0 = 0x1
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT0_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT0_Enabled = 0x1
	// Position of RT1 field.
	EXTI_RTSR1_RT1_Pos = 0x1
	// Bit mask of RT1 field.
	EXTI_RTSR1_RT1_Msk = 0x2
	// Bit RT1.
	EXTI_RTSR1_RT1 = 0x2
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT1_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT1_Enabled = 0x1
	// Position of RT2 field.
	EXTI_RTSR1_RT2_Pos = 0x2
	// Bit mask of RT2 field.
	EXTI_RTSR1_RT2_Msk = 0x4
	// Bit RT2.
	EXTI_RTSR1_RT2 = 0x4
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT2_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT2_Enabled = 0x1
	// Position of RT3 field.
	EXTI_RTSR1_RT3_Pos = 0x3
	// Bit mask of RT3 field.
	EXTI_RTSR1_RT3_Msk = 0x8
	// Bit RT3.
	EXTI_RTSR1_RT3 = 0x8
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT3_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT3_Enabled = 0x1
	// Position of RT4 field.
	EXTI_RTSR1_RT4_Pos = 0x4
	// Bit mask of RT4 field.
	EXTI_RTSR1_RT4_Msk = 0x10
	// Bit RT4.
	EXTI_RTSR1_RT4 = 0x10
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT4_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT4_Enabled = 0x1
	// Position of RT5 field.
	EXTI_RTSR1_RT5_Pos = 0x5
	// Bit mask of RT5 field.
	EXTI_RTSR1_RT5_Msk = 0x20
	// Bit RT5.
	EXTI_RTSR1_RT5 = 0x20
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT5_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT5_Enabled = 0x1
	// Position of RT6 field.
	EXTI_RTSR1_RT6_Pos = 0x6
	// Bit mask of RT6 field.
	EXTI_RTSR1_RT6_Msk = 0x40
	// Bit RT6.
	EXTI_RTSR1_RT6 = 0x40
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT6_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT6_Enabled = 0x1
	// Position of RT7 field.
	EXTI_RTSR1_RT7_Pos = 0x7
	// Bit mask of RT7 field.
	EXTI_RTSR1_RT7_Msk = 0x80
	// Bit RT7.
	EXTI_RTSR1_RT7 = 0x80
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT7_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT7_Enabled = 0x1
	// Position of RT8 field.
	EXTI_RTSR1_RT8_Pos = 0x8
	// Bit mask of RT8 field.
	EXTI_RTSR1_RT8_Msk = 0x100
	// Bit RT8.
	EXTI_RTSR1_RT8 = 0x100
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT8_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT8_Enabled = 0x1
	// Position of RT9 field.
	EXTI_RTSR1_RT9_Pos = 0x9
	// Bit mask of RT9 field.
	EXTI_RTSR1_RT9_Msk = 0x200
	// Bit RT9.
	EXTI_RTSR1_RT9 = 0x200
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT9_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT9_Enabled = 0x1
	// Position of RT10 field.
	EXTI_RTSR1_RT10_Pos = 0xa
	// Bit mask of RT10 field.
	EXTI_RTSR1_RT10_Msk = 0x400
	// Bit RT10.
	EXTI_RTSR1_RT10 = 0x400
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT10_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT10_Enabled = 0x1
	// Position of RT11 field.
	EXTI_RTSR1_RT11_Pos = 0xb
	// Bit mask of RT11 field.
	EXTI_RTSR1_RT11_Msk = 0x800
	// Bit RT11.
	EXTI_RTSR1_RT11 = 0x800
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT11_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT11_Enabled = 0x1
	// Position of RT12 field.
	EXTI_RTSR1_RT12_Pos = 0xc
	// Bit mask of RT12 field.
	EXTI_RTSR1_RT12_Msk = 0x1000
	// Bit RT12.
	EXTI_RTSR1_RT12 = 0x1000
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT12_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT12_Enabled = 0x1
	// Position of RT13 field.
	EXTI_RTSR1_RT13_Pos = 0xd
	// Bit mask of RT13 field.
	EXTI_RTSR1_RT13_Msk = 0x2000
	// Bit RT13.
	EXTI_RTSR1_RT13 = 0x2000
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT13_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT13_Enabled = 0x1
	// Position of RT14 field.
	EXTI_RTSR1_RT14_Pos = 0xe
	// Bit mask of RT14 field.
	EXTI_RTSR1_RT14_Msk = 0x4000
	// Bit RT14.
	EXTI_RTSR1_RT14 = 0x4000
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT14_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT14_Enabled = 0x1
	// Position of RT15 field.
	EXTI_RTSR1_RT15_Pos = 0xf
	// Bit mask of RT15 field.
	EXTI_RTSR1_RT15_Msk = 0x8000
	// Bit RT15.
	EXTI_RTSR1_RT15 = 0x8000
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT15_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT15_Enabled = 0x1
	// Position of RT16 field.
	EXTI_RTSR1_RT16_Pos = 0x10
	// Bit mask of RT16 field.
	EXTI_RTSR1_RT16_Msk = 0x10000
	// Bit RT16.
	EXTI_RTSR1_RT16 = 0x10000
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT16_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT16_Enabled = 0x1

	// FTSR1: falling trigger selection register
	// Position of FT21 field.
	EXTI_FTSR1_FT21_Pos = 0x15
	// Bit mask of FT21 field.
	EXTI_FTSR1_FT21_Msk = 0x200000
	// Bit FT21.
	EXTI_FTSR1_FT21 = 0x200000
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT21_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT21_Enabled = 0x1
	// Position of FT22 field.
	EXTI_FTSR1_FT22_Pos = 0x16
	// Bit mask of FT22 field.
	EXTI_FTSR1_FT22_Msk = 0x400000
	// Bit FT22.
	EXTI_FTSR1_FT22 = 0x400000
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT22_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT22_Enabled = 0x1
	// Position of FT0 field.
	EXTI_FTSR1_FT0_Pos = 0x0
	// Bit mask of FT0 field.
	EXTI_FTSR1_FT0_Msk = 0x1
	// Bit FT0.
	EXTI_FTSR1_FT0 = 0x1
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT0_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT0_Enabled = 0x1
	// Position of FT1 field.
	EXTI_FTSR1_FT1_Pos = 0x1
	// Bit mask of FT1 field.
	EXTI_FTSR1_FT1_Msk = 0x2
	// Bit FT1.
	EXTI_FTSR1_FT1 = 0x2
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT1_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT1_Enabled = 0x1
	// Position of FT2 field.
	EXTI_FTSR1_FT2_Pos = 0x2
	// Bit mask of FT2 field.
	EXTI_FTSR1_FT2_Msk = 0x4
	// Bit FT2.
	EXTI_FTSR1_FT2 = 0x4
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT2_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT2_Enabled = 0x1
	// Position of FT3 field.
	EXTI_FTSR1_FT3_Pos = 0x3
	// Bit mask of FT3 field.
	EXTI_FTSR1_FT3_Msk = 0x8
	// Bit FT3.
	EXTI_FTSR1_FT3 = 0x8
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT3_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT3_Enabled = 0x1
	// Position of FT4 field.
	EXTI_FTSR1_FT4_Pos = 0x4
	// Bit mask of FT4 field.
	EXTI_FTSR1_FT4_Msk = 0x10
	// Bit FT4.
	EXTI_FTSR1_FT4 = 0x10
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT4_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT4_Enabled = 0x1
	// Position of FT5 field.
	EXTI_FTSR1_FT5_Pos = 0x5
	// Bit mask of FT5 field.
	EXTI_FTSR1_FT5_Msk = 0x20
	// Bit FT5.
	EXTI_FTSR1_FT5 = 0x20
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT5_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT5_Enabled = 0x1
	// Position of FT6 field.
	EXTI_FTSR1_FT6_Pos = 0x6
	// Bit mask of FT6 field.
	EXTI_FTSR1_FT6_Msk = 0x40
	// Bit FT6.
	EXTI_FTSR1_FT6 = 0x40
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT6_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT6_Enabled = 0x1
	// Position of FT7 field.
	EXTI_FTSR1_FT7_Pos = 0x7
	// Bit mask of FT7 field.
	EXTI_FTSR1_FT7_Msk = 0x80
	// Bit FT7.
	EXTI_FTSR1_FT7 = 0x80
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT7_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT7_Enabled = 0x1
	// Position of FT8 field.
	EXTI_FTSR1_FT8_Pos = 0x8
	// Bit mask of FT8 field.
	EXTI_FTSR1_FT8_Msk = 0x100
	// Bit FT8.
	EXTI_FTSR1_FT8 = 0x100
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT8_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT8_Enabled = 0x1
	// Position of FT9 field.
	EXTI_FTSR1_FT9_Pos = 0x9
	// Bit mask of FT9 field.
	EXTI_FTSR1_FT9_Msk = 0x200
	// Bit FT9.
	EXTI_FTSR1_FT9 = 0x200
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT9_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT9_Enabled = 0x1
	// Position of FT10 field.
	EXTI_FTSR1_FT10_Pos = 0xa
	// Bit mask of FT10 field.
	EXTI_FTSR1_FT10_Msk = 0x400
	// Bit FT10.
	EXTI_FTSR1_FT10 = 0x400
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT10_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT10_Enabled = 0x1
	// Position of FT11 field.
	EXTI_FTSR1_FT11_Pos = 0xb
	// Bit mask of FT11 field.
	EXTI_FTSR1_FT11_Msk = 0x800
	// Bit FT11.
	EXTI_FTSR1_FT11 = 0x800
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT11_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT11_Enabled = 0x1
	// Position of FT12 field.
	EXTI_FTSR1_FT12_Pos = 0xc
	// Bit mask of FT12 field.
	EXTI_FTSR1_FT12_Msk = 0x1000
	// Bit FT12.
	EXTI_FTSR1_FT12 = 0x1000
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT12_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT12_Enabled = 0x1
	// Position of FT13 field.
	EXTI_FTSR1_FT13_Pos = 0xd
	// Bit mask of FT13 field.
	EXTI_FTSR1_FT13_Msk = 0x2000
	// Bit FT13.
	EXTI_FTSR1_FT13 = 0x2000
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT13_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT13_Enabled = 0x1
	// Position of FT14 field.
	EXTI_FTSR1_FT14_Pos = 0xe
	// Bit mask of FT14 field.
	EXTI_FTSR1_FT14_Msk = 0x4000
	// Bit FT14.
	EXTI_FTSR1_FT14 = 0x4000
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT14_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT14_Enabled = 0x1
	// Position of FT15 field.
	EXTI_FTSR1_FT15_Pos = 0xf
	// Bit mask of FT15 field.
	EXTI_FTSR1_FT15_Msk = 0x8000
	// Bit FT15.
	EXTI_FTSR1_FT15 = 0x8000
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT15_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT15_Enabled = 0x1
	// Position of FT16 field.
	EXTI_FTSR1_FT16_Pos = 0x10
	// Bit mask of FT16 field.
	EXTI_FTSR1_FT16_Msk = 0x10000
	// Bit FT16.
	EXTI_FTSR1_FT16 = 0x10000
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT16_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT16_Enabled = 0x1

	// SWIER1: software interrupt event register
	// Position of SWI21 field.
	EXTI_SWIER1_SWI21_Pos = 0x15
	// Bit mask of SWI21 field.
	EXTI_SWIER1_SWI21_Msk = 0x200000
	// Bit SWI21.
	EXTI_SWIER1_SWI21 = 0x200000
	// Generates an interrupt request
	EXTI_SWIER1_SWI21_Pend = 0x1
	// Position of SWI22 field.
	EXTI_SWIER1_SWI22_Pos = 0x16
	// Bit mask of SWI22 field.
	EXTI_SWIER1_SWI22_Msk = 0x400000
	// Bit SWI22.
	EXTI_SWIER1_SWI22 = 0x400000
	// Generates an interrupt request
	EXTI_SWIER1_SWI22_Pend = 0x1
	// Position of SWI0 field.
	EXTI_SWIER1_SWI0_Pos = 0x0
	// Bit mask of SWI0 field.
	EXTI_SWIER1_SWI0_Msk = 0x1
	// Bit SWI0.
	EXTI_SWIER1_SWI0 = 0x1
	// Generates an interrupt request
	EXTI_SWIER1_SWI0_Pend = 0x1
	// Position of SWI1 field.
	EXTI_SWIER1_SWI1_Pos = 0x1
	// Bit mask of SWI1 field.
	EXTI_SWIER1_SWI1_Msk = 0x2
	// Bit SWI1.
	EXTI_SWIER1_SWI1 = 0x2
	// Generates an interrupt request
	EXTI_SWIER1_SWI1_Pend = 0x1
	// Position of SWI2 field.
	EXTI_SWIER1_SWI2_Pos = 0x2
	// Bit mask of SWI2 field.
	EXTI_SWIER1_SWI2_Msk = 0x4
	// Bit SWI2.
	EXTI_SWIER1_SWI2 = 0x4
	// Generates an interrupt request
	EXTI_SWIER1_SWI2_Pend = 0x1
	// Position of SWI3 field.
	EXTI_SWIER1_SWI3_Pos = 0x3
	// Bit mask of SWI3 field.
	EXTI_SWIER1_SWI3_Msk = 0x8
	// Bit SWI3.
	EXTI_SWIER1_SWI3 = 0x8
	// Generates an interrupt request
	EXTI_SWIER1_SWI3_Pend = 0x1
	// Position of SWI4 field.
	EXTI_SWIER1_SWI4_Pos = 0x4
	// Bit mask of SWI4 field.
	EXTI_SWIER1_SWI4_Msk = 0x10
	// Bit SWI4.
	EXTI_SWIER1_SWI4 = 0x10
	// Generates an interrupt request
	EXTI_SWIER1_SWI4_Pend = 0x1
	// Position of SWI5 field.
	EXTI_SWIER1_SWI5_Pos = 0x5
	// Bit mask of SWI5 field.
	EXTI_SWIER1_SWI5_Msk = 0x20
	// Bit SWI5.
	EXTI_SWIER1_SWI5 = 0x20
	// Generates an interrupt request
	EXTI_SWIER1_SWI5_Pend = 0x1
	// Position of SWI6 field.
	EXTI_SWIER1_SWI6_Pos = 0x6
	// Bit mask of SWI6 field.
	EXTI_SWIER1_SWI6_Msk = 0x40
	// Bit SWI6.
	EXTI_SWIER1_SWI6 = 0x40
	// Generates an interrupt request
	EXTI_SWIER1_SWI6_Pend = 0x1
	// Position of SWI7 field.
	EXTI_SWIER1_SWI7_Pos = 0x7
	// Bit mask of SWI7 field.
	EXTI_SWIER1_SWI7_Msk = 0x80
	// Bit SWI7.
	EXTI_SWIER1_SWI7 = 0x80
	// Generates an interrupt request
	EXTI_SWIER1_SWI7_Pend = 0x1
	// Position of SWI8 field.
	EXTI_SWIER1_SWI8_Pos = 0x8
	// Bit mask of SWI8 field.
	EXTI_SWIER1_SWI8_Msk = 0x100
	// Bit SWI8.
	EXTI_SWIER1_SWI8 = 0x100
	// Generates an interrupt request
	EXTI_SWIER1_SWI8_Pend = 0x1
	// Position of SWI9 field.
	EXTI_SWIER1_SWI9_Pos = 0x9
	// Bit mask of SWI9 field.
	EXTI_SWIER1_SWI9_Msk = 0x200
	// Bit SWI9.
	EXTI_SWIER1_SWI9 = 0x200
	// Generates an interrupt request
	EXTI_SWIER1_SWI9_Pend = 0x1
	// Position of SWI10 field.
	EXTI_SWIER1_SWI10_Pos = 0xa
	// Bit mask of SWI10 field.
	EXTI_SWIER1_SWI10_Msk = 0x400
	// Bit SWI10.
	EXTI_SWIER1_SWI10 = 0x400
	// Generates an interrupt request
	EXTI_SWIER1_SWI10_Pend = 0x1
	// Position of SWI11 field.
	EXTI_SWIER1_SWI11_Pos = 0xb
	// Bit mask of SWI11 field.
	EXTI_SWIER1_SWI11_Msk = 0x800
	// Bit SWI11.
	EXTI_SWIER1_SWI11 = 0x800
	// Generates an interrupt request
	EXTI_SWIER1_SWI11_Pend = 0x1
	// Position of SWI12 field.
	EXTI_SWIER1_SWI12_Pos = 0xc
	// Bit mask of SWI12 field.
	EXTI_SWIER1_SWI12_Msk = 0x1000
	// Bit SWI12.
	EXTI_SWIER1_SWI12 = 0x1000
	// Generates an interrupt request
	EXTI_SWIER1_SWI12_Pend = 0x1
	// Position of SWI13 field.
	EXTI_SWIER1_SWI13_Pos = 0xd
	// Bit mask of SWI13 field.
	EXTI_SWIER1_SWI13_Msk = 0x2000
	// Bit SWI13.
	EXTI_SWIER1_SWI13 = 0x2000
	// Generates an interrupt request
	EXTI_SWIER1_SWI13_Pend = 0x1
	// Position of SWI14 field.
	EXTI_SWIER1_SWI14_Pos = 0xe
	// Bit mask of SWI14 field.
	EXTI_SWIER1_SWI14_Msk = 0x4000
	// Bit SWI14.
	EXTI_SWIER1_SWI14 = 0x4000
	// Generates an interrupt request
	EXTI_SWIER1_SWI14_Pend = 0x1
	// Position of SWI15 field.
	EXTI_SWIER1_SWI15_Pos = 0xf
	// Bit mask of SWI15 field.
	EXTI_SWIER1_SWI15_Msk = 0x8000
	// Bit SWI15.
	EXTI_SWIER1_SWI15 = 0x8000
	// Generates an interrupt request
	EXTI_SWIER1_SWI15_Pend = 0x1
	// Position of SWI16 field.
	EXTI_SWIER1_SWI16_Pos = 0x10
	// Bit mask of SWI16 field.
	EXTI_SWIER1_SWI16_Msk = 0x10000
	// Bit SWI16.
	EXTI_SWIER1_SWI16 = 0x10000
	// Generates an interrupt request
	EXTI_SWIER1_SWI16_Pend = 0x1

	// PR1: EXTI pending register
	// Position of PIF21 field.
	EXTI_PR1_PIF21_Pos = 0x15
	// Bit mask of PIF21 field.
	EXTI_PR1_PIF21_Msk = 0x200000
	// Bit PIF21.
	EXTI_PR1_PIF21 = 0x200000
	// No trigger request occurred
	EXTI_PR1_PIF21_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF21_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF21_Clear = 0x1
	// Position of PIF22 field.
	EXTI_PR1_PIF22_Pos = 0x16
	// Bit mask of PIF22 field.
	EXTI_PR1_PIF22_Msk = 0x400000
	// Bit PIF22.
	EXTI_PR1_PIF22 = 0x400000
	// No trigger request occurred
	EXTI_PR1_PIF22_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF22_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF22_Clear = 0x1
	// Position of PIF0 field.
	EXTI_PR1_PIF0_Pos = 0x0
	// Bit mask of PIF0 field.
	EXTI_PR1_PIF0_Msk = 0x1
	// Bit PIF0.
	EXTI_PR1_PIF0 = 0x1
	// No trigger request occurred
	EXTI_PR1_PIF0_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF0_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF0_Clear = 0x1
	// Position of PIF1 field.
	EXTI_PR1_PIF1_Pos = 0x1
	// Bit mask of PIF1 field.
	EXTI_PR1_PIF1_Msk = 0x2
	// Bit PIF1.
	EXTI_PR1_PIF1 = 0x2
	// No trigger request occurred
	EXTI_PR1_PIF1_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF1_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF1_Clear = 0x1
	// Position of PIF2 field.
	EXTI_PR1_PIF2_Pos = 0x2
	// Bit mask of PIF2 field.
	EXTI_PR1_PIF2_Msk = 0x4
	// Bit PIF2.
	EXTI_PR1_PIF2 = 0x4
	// No trigger request occurred
	EXTI_PR1_PIF2_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF2_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF2_Clear = 0x1
	// Position of PIF3 field.
	EXTI_PR1_PIF3_Pos = 0x3
	// Bit mask of PIF3 field.
	EXTI_PR1_PIF3_Msk = 0x8
	// Bit PIF3.
	EXTI_PR1_PIF3 = 0x8
	// No trigger request occurred
	EXTI_PR1_PIF3_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF3_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF3_Clear = 0x1
	// Position of PIF4 field.
	EXTI_PR1_PIF4_Pos = 0x4
	// Bit mask of PIF4 field.
	EXTI_PR1_PIF4_Msk = 0x10
	// Bit PIF4.
	EXTI_PR1_PIF4 = 0x10
	// No trigger request occurred
	EXTI_PR1_PIF4_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF4_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF4_Clear = 0x1
	// Position of PIF5 field.
	EXTI_PR1_PIF5_Pos = 0x5
	// Bit mask of PIF5 field.
	EXTI_PR1_PIF5_Msk = 0x20
	// Bit PIF5.
	EXTI_PR1_PIF5 = 0x20
	// No trigger request occurred
	EXTI_PR1_PIF5_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF5_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF5_Clear = 0x1
	// Position of PIF6 field.
	EXTI_PR1_PIF6_Pos = 0x6
	// Bit mask of PIF6 field.
	EXTI_PR1_PIF6_Msk = 0x40
	// Bit PIF6.
	EXTI_PR1_PIF6 = 0x40
	// No trigger request occurred
	EXTI_PR1_PIF6_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF6_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF6_Clear = 0x1
	// Position of PIF7 field.
	EXTI_PR1_PIF7_Pos = 0x7
	// Bit mask of PIF7 field.
	EXTI_PR1_PIF7_Msk = 0x80
	// Bit PIF7.
	EXTI_PR1_PIF7 = 0x80
	// No trigger request occurred
	EXTI_PR1_PIF7_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF7_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF7_Clear = 0x1
	// Position of PIF8 field.
	EXTI_PR1_PIF8_Pos = 0x8
	// Bit mask of PIF8 field.
	EXTI_PR1_PIF8_Msk = 0x100
	// Bit PIF8.
	EXTI_PR1_PIF8 = 0x100
	// No trigger request occurred
	EXTI_PR1_PIF8_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF8_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF8_Clear = 0x1
	// Position of PIF9 field.
	EXTI_PR1_PIF9_Pos = 0x9
	// Bit mask of PIF9 field.
	EXTI_PR1_PIF9_Msk = 0x200
	// Bit PIF9.
	EXTI_PR1_PIF9 = 0x200
	// No trigger request occurred
	EXTI_PR1_PIF9_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF9_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF9_Clear = 0x1
	// Position of PIF10 field.
	EXTI_PR1_PIF10_Pos = 0xa
	// Bit mask of PIF10 field.
	EXTI_PR1_PIF10_Msk = 0x400
	// Bit PIF10.
	EXTI_PR1_PIF10 = 0x400
	// No trigger request occurred
	EXTI_PR1_PIF10_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF10_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF10_Clear = 0x1
	// Position of PIF11 field.
	EXTI_PR1_PIF11_Pos = 0xb
	// Bit mask of PIF11 field.
	EXTI_PR1_PIF11_Msk = 0x800
	// Bit PIF11.
	EXTI_PR1_PIF11 = 0x800
	// No trigger request occurred
	EXTI_PR1_PIF11_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF11_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF11_Clear = 0x1
	// Position of PIF12 field.
	EXTI_PR1_PIF12_Pos = 0xc
	// Bit mask of PIF12 field.
	EXTI_PR1_PIF12_Msk = 0x1000
	// Bit PIF12.
	EXTI_PR1_PIF12 = 0x1000
	// No trigger request occurred
	EXTI_PR1_PIF12_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF12_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF12_Clear = 0x1
	// Position of PIF13 field.
	EXTI_PR1_PIF13_Pos = 0xd
	// Bit mask of PIF13 field.
	EXTI_PR1_PIF13_Msk = 0x2000
	// Bit PIF13.
	EXTI_PR1_PIF13 = 0x2000
	// No trigger request occurred
	EXTI_PR1_PIF13_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF13_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF13_Clear = 0x1
	// Position of PIF14 field.
	EXTI_PR1_PIF14_Pos = 0xe
	// Bit mask of PIF14 field.
	EXTI_PR1_PIF14_Msk = 0x4000
	// Bit PIF14.
	EXTI_PR1_PIF14 = 0x4000
	// No trigger request occurred
	EXTI_PR1_PIF14_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF14_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF14_Clear = 0x1
	// Position of PIF15 field.
	EXTI_PR1_PIF15_Pos = 0xf
	// Bit mask of PIF15 field.
	EXTI_PR1_PIF15_Msk = 0x8000
	// Bit PIF15.
	EXTI_PR1_PIF15 = 0x8000
	// No trigger request occurred
	EXTI_PR1_PIF15_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF15_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF15_Clear = 0x1
	// Position of PIF16 field.
	EXTI_PR1_PIF16_Pos = 0x10
	// Bit mask of PIF16 field.
	EXTI_PR1_PIF16_Msk = 0x10000
	// Bit PIF16.
	EXTI_PR1_PIF16 = 0x10000
	// No trigger request occurred
	EXTI_PR1_PIF16_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PIF16_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PIF16_Clear = 0x1

	// RTSR2: rising trigger selection register
	// Position of RT34 field.
	EXTI_RTSR2_RT34_Pos = 0x2
	// Bit mask of RT34 field.
	EXTI_RTSR2_RT34_Msk = 0x4
	// Bit RT34.
	EXTI_RTSR2_RT34 = 0x4
	// Rising edge trigger is disabled
	EXTI_RTSR2_RT34_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR2_RT34_Enabled = 0x1
	// Position of RT40 field.
	EXTI_RTSR2_RT40_Pos = 0x8
	// Bit mask of RT40 field.
	EXTI_RTSR2_RT40_Msk = 0x100
	// Bit RT40.
	EXTI_RTSR2_RT40 = 0x100
	// Rising edge trigger is disabled
	EXTI_RTSR2_RT40_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR2_RT40_Enabled = 0x1
	// Position of RT41 field.
	EXTI_RTSR2_RT41_Pos = 0x9
	// Bit mask of RT41 field.
	EXTI_RTSR2_RT41_Msk = 0x200
	// Bit RT41.
	EXTI_RTSR2_RT41 = 0x200
	// Rising edge trigger is disabled
	EXTI_RTSR2_RT41_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR2_RT41_Enabled = 0x1
	// Position of RT45 field.
	EXTI_RTSR2_RT45_Pos = 0xd
	// Bit mask of RT45 field.
	EXTI_RTSR2_RT45_Msk = 0x2000
	// Bit RT45.
	EXTI_RTSR2_RT45 = 0x2000
	// Rising edge trigger is disabled
	EXTI_RTSR2_RT45_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR2_RT45_Enabled = 0x1

	// FTSR2: falling trigger selection register
	// Position of FT34 field.
	EXTI_FTSR2_FT34_Pos = 0x2
	// Bit mask of FT34 field.
	EXTI_FTSR2_FT34_Msk = 0x4
	// Bit FT34.
	EXTI_FTSR2_FT34 = 0x4
	// Falling edge trigger is disabled
	EXTI_FTSR2_FT34_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR2_FT34_Enabled = 0x1
	// Position of FT40 field.
	EXTI_FTSR2_FT40_Pos = 0x8
	// Bit mask of FT40 field.
	EXTI_FTSR2_FT40_Msk = 0x100
	// Bit FT40.
	EXTI_FTSR2_FT40 = 0x100
	// Falling edge trigger is disabled
	EXTI_FTSR2_FT40_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR2_FT40_Enabled = 0x1
	// Position of FT41 field.
	EXTI_FTSR2_FT41_Pos = 0x9
	// Bit mask of FT41 field.
	EXTI_FTSR2_FT41_Msk = 0x200
	// Bit FT41.
	EXTI_FTSR2_FT41 = 0x200
	// Falling edge trigger is disabled
	EXTI_FTSR2_FT41_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR2_FT41_Enabled = 0x1
	// Position of FT45 field.
	EXTI_FTSR2_FT45_Pos = 0xd
	// Bit mask of FT45 field.
	EXTI_FTSR2_FT45_Msk = 0x2000
	// Bit FT45.
	EXTI_FTSR2_FT45 = 0x2000
	// Falling edge trigger is disabled
	EXTI_FTSR2_FT45_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR2_FT45_Enabled = 0x1

	// SWIER2: software interrupt event register
	// Position of SWI34 field.
	EXTI_SWIER2_SWI34_Pos = 0x2
	// Bit mask of SWI34 field.
	EXTI_SWIER2_SWI34_Msk = 0x4
	// Bit SWI34.
	EXTI_SWIER2_SWI34 = 0x4
	// Generates an interrupt request
	EXTI_SWIER2_SWI34_Pend = 0x1
	// Position of SWI40 field.
	EXTI_SWIER2_SWI40_Pos = 0x8
	// Bit mask of SWI40 field.
	EXTI_SWIER2_SWI40_Msk = 0x100
	// Bit SWI40.
	EXTI_SWIER2_SWI40 = 0x100
	// Generates an interrupt request
	EXTI_SWIER2_SWI40_Pend = 0x1
	// Position of SWI41 field.
	EXTI_SWIER2_SWI41_Pos = 0x9
	// Bit mask of SWI41 field.
	EXTI_SWIER2_SWI41_Msk = 0x200
	// Bit SWI41.
	EXTI_SWIER2_SWI41 = 0x200
	// Generates an interrupt request
	EXTI_SWIER2_SWI41_Pend = 0x1
	// Position of SWI45 field.
	EXTI_SWIER2_SWI45_Pos = 0xd
	// Bit mask of SWI45 field.
	EXTI_SWIER2_SWI45_Msk = 0x2000
	// Bit SWI45.
	EXTI_SWIER2_SWI45 = 0x2000
	// Generates an interrupt request
	EXTI_SWIER2_SWI45_Pend = 0x1

	// PR2: pending register
	// Position of PIF34 field.
	EXTI_PR2_PIF34_Pos = 0x2
	// Bit mask of PIF34 field.
	EXTI_PR2_PIF34_Msk = 0x4
	// Bit PIF34.
	EXTI_PR2_PIF34 = 0x4
	// No trigger request occurred
	EXTI_PR2_PIF34_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR2_PIF34_Pending = 0x1
	// Clears pending bit
	EXTI_PR2_PIF34_Clear = 0x1
	// Position of PIF40 field.
	EXTI_PR2_PIF40_Pos = 0x8
	// Bit mask of PIF40 field.
	EXTI_PR2_PIF40_Msk = 0x100
	// Bit PIF40.
	EXTI_PR2_PIF40 = 0x100
	// No trigger request occurred
	EXTI_PR2_PIF40_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR2_PIF40_Pending = 0x1
	// Clears pending bit
	EXTI_PR2_PIF40_Clear = 0x1
	// Position of PIF41 field.
	EXTI_PR2_PIF41_Pos = 0x9
	// Bit mask of PIF41 field.
	EXTI_PR2_PIF41_Msk = 0x200
	// Bit PIF41.
	EXTI_PR2_PIF41 = 0x200
	// No trigger request occurred
	EXTI_PR2_PIF41_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR2_PIF41_Pending = 0x1
	// Clears pending bit
	EXTI_PR2_PIF41_Clear = 0x1
	// Position of PIF45 field.
	EXTI_PR2_PIF45_Pos = 0xd
	// Bit mask of PIF45 field.
	EXTI_PR2_PIF45_Msk = 0x2000
	// Bit PIF45.
	EXTI_PR2_PIF45 = 0x2000
	// No trigger request occurred
	EXTI_PR2_PIF45_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR2_PIF45_Pending = 0x1
	// Clears pending bit
	EXTI_PR2_PIF45_Clear = 0x1

	// C1IMR1: interrupt mask register
	// Position of IM0 field.
	EXTI_C1IMR1_IM0_Pos = 0x0
	// Bit mask of IM0 field.
	EXTI_C1IMR1_IM0_Msk = 0x1
	// Bit IM0.
	EXTI_C1IMR1_IM0 = 0x1
	// Interrupt request line is masked
	EXTI_C1IMR1_IM0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM0_Unmasked = 0x1
	// Position of IM1 field.
	EXTI_C1IMR1_IM1_Pos = 0x1
	// Bit mask of IM1 field.
	EXTI_C1IMR1_IM1_Msk = 0x2
	// Bit IM1.
	EXTI_C1IMR1_IM1 = 0x2
	// Interrupt request line is masked
	EXTI_C1IMR1_IM1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM1_Unmasked = 0x1
	// Position of IM2 field.
	EXTI_C1IMR1_IM2_Pos = 0x2
	// Bit mask of IM2 field.
	EXTI_C1IMR1_IM2_Msk = 0x4
	// Bit IM2.
	EXTI_C1IMR1_IM2 = 0x4
	// Interrupt request line is masked
	EXTI_C1IMR1_IM2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM2_Unmasked = 0x1
	// Position of IM3 field.
	EXTI_C1IMR1_IM3_Pos = 0x3
	// Bit mask of IM3 field.
	EXTI_C1IMR1_IM3_Msk = 0x8
	// Bit IM3.
	EXTI_C1IMR1_IM3 = 0x8
	// Interrupt request line is masked
	EXTI_C1IMR1_IM3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM3_Unmasked = 0x1
	// Position of IM4 field.
	EXTI_C1IMR1_IM4_Pos = 0x4
	// Bit mask of IM4 field.
	EXTI_C1IMR1_IM4_Msk = 0x10
	// Bit IM4.
	EXTI_C1IMR1_IM4 = 0x10
	// Interrupt request line is masked
	EXTI_C1IMR1_IM4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM4_Unmasked = 0x1
	// Position of IM5 field.
	EXTI_C1IMR1_IM5_Pos = 0x5
	// Bit mask of IM5 field.
	EXTI_C1IMR1_IM5_Msk = 0x20
	// Bit IM5.
	EXTI_C1IMR1_IM5 = 0x20
	// Interrupt request line is masked
	EXTI_C1IMR1_IM5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM5_Unmasked = 0x1
	// Position of IM6 field.
	EXTI_C1IMR1_IM6_Pos = 0x6
	// Bit mask of IM6 field.
	EXTI_C1IMR1_IM6_Msk = 0x40
	// Bit IM6.
	EXTI_C1IMR1_IM6 = 0x40
	// Interrupt request line is masked
	EXTI_C1IMR1_IM6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM6_Unmasked = 0x1
	// Position of IM7 field.
	EXTI_C1IMR1_IM7_Pos = 0x7
	// Bit mask of IM7 field.
	EXTI_C1IMR1_IM7_Msk = 0x80
	// Bit IM7.
	EXTI_C1IMR1_IM7 = 0x80
	// Interrupt request line is masked
	EXTI_C1IMR1_IM7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM7_Unmasked = 0x1
	// Position of IM8 field.
	EXTI_C1IMR1_IM8_Pos = 0x8
	// Bit mask of IM8 field.
	EXTI_C1IMR1_IM8_Msk = 0x100
	// Bit IM8.
	EXTI_C1IMR1_IM8 = 0x100
	// Interrupt request line is masked
	EXTI_C1IMR1_IM8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM8_Unmasked = 0x1
	// Position of IM9 field.
	EXTI_C1IMR1_IM9_Pos = 0x9
	// Bit mask of IM9 field.
	EXTI_C1IMR1_IM9_Msk = 0x200
	// Bit IM9.
	EXTI_C1IMR1_IM9 = 0x200
	// Interrupt request line is masked
	EXTI_C1IMR1_IM9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM9_Unmasked = 0x1
	// Position of IM10 field.
	EXTI_C1IMR1_IM10_Pos = 0xa
	// Bit mask of IM10 field.
	EXTI_C1IMR1_IM10_Msk = 0x400
	// Bit IM10.
	EXTI_C1IMR1_IM10 = 0x400
	// Interrupt request line is masked
	EXTI_C1IMR1_IM10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM10_Unmasked = 0x1
	// Position of IM11 field.
	EXTI_C1IMR1_IM11_Pos = 0xb
	// Bit mask of IM11 field.
	EXTI_C1IMR1_IM11_Msk = 0x800
	// Bit IM11.
	EXTI_C1IMR1_IM11 = 0x800
	// Interrupt request line is masked
	EXTI_C1IMR1_IM11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM11_Unmasked = 0x1
	// Position of IM12 field.
	EXTI_C1IMR1_IM12_Pos = 0xc
	// Bit mask of IM12 field.
	EXTI_C1IMR1_IM12_Msk = 0x1000
	// Bit IM12.
	EXTI_C1IMR1_IM12 = 0x1000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM12_Unmasked = 0x1
	// Position of IM13 field.
	EXTI_C1IMR1_IM13_Pos = 0xd
	// Bit mask of IM13 field.
	EXTI_C1IMR1_IM13_Msk = 0x2000
	// Bit IM13.
	EXTI_C1IMR1_IM13 = 0x2000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM13_Unmasked = 0x1
	// Position of IM14 field.
	EXTI_C1IMR1_IM14_Pos = 0xe
	// Bit mask of IM14 field.
	EXTI_C1IMR1_IM14_Msk = 0x4000
	// Bit IM14.
	EXTI_C1IMR1_IM14 = 0x4000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM14_Unmasked = 0x1
	// Position of IM15 field.
	EXTI_C1IMR1_IM15_Pos = 0xf
	// Bit mask of IM15 field.
	EXTI_C1IMR1_IM15_Msk = 0x8000
	// Bit IM15.
	EXTI_C1IMR1_IM15 = 0x8000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM15_Unmasked = 0x1
	// Position of IM16 field.
	EXTI_C1IMR1_IM16_Pos = 0x10
	// Bit mask of IM16 field.
	EXTI_C1IMR1_IM16_Msk = 0x10000
	// Bit IM16.
	EXTI_C1IMR1_IM16 = 0x10000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM16_Unmasked = 0x1
	// Position of IM17 field.
	EXTI_C1IMR1_IM17_Pos = 0x11
	// Bit mask of IM17 field.
	EXTI_C1IMR1_IM17_Msk = 0x20000
	// Bit IM17.
	EXTI_C1IMR1_IM17 = 0x20000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM17_Unmasked = 0x1
	// Position of IM18 field.
	EXTI_C1IMR1_IM18_Pos = 0x12
	// Bit mask of IM18 field.
	EXTI_C1IMR1_IM18_Msk = 0x40000
	// Bit IM18.
	EXTI_C1IMR1_IM18 = 0x40000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM18_Unmasked = 0x1
	// Position of IM19 field.
	EXTI_C1IMR1_IM19_Pos = 0x13
	// Bit mask of IM19 field.
	EXTI_C1IMR1_IM19_Msk = 0x80000
	// Bit IM19.
	EXTI_C1IMR1_IM19 = 0x80000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM19_Unmasked = 0x1
	// Position of IM20 field.
	EXTI_C1IMR1_IM20_Pos = 0x14
	// Bit mask of IM20 field.
	EXTI_C1IMR1_IM20_Msk = 0x100000
	// Bit IM20.
	EXTI_C1IMR1_IM20 = 0x100000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM20_Unmasked = 0x1
	// Position of IM21 field.
	EXTI_C1IMR1_IM21_Pos = 0x15
	// Bit mask of IM21 field.
	EXTI_C1IMR1_IM21_Msk = 0x200000
	// Bit IM21.
	EXTI_C1IMR1_IM21 = 0x200000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM21_Unmasked = 0x1
	// Position of IM22 field.
	EXTI_C1IMR1_IM22_Pos = 0x16
	// Bit mask of IM22 field.
	EXTI_C1IMR1_IM22_Msk = 0x400000
	// Bit IM22.
	EXTI_C1IMR1_IM22 = 0x400000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM22_Unmasked = 0x1
	// Position of IM23 field.
	EXTI_C1IMR1_IM23_Pos = 0x17
	// Bit mask of IM23 field.
	EXTI_C1IMR1_IM23_Msk = 0x800000
	// Bit IM23.
	EXTI_C1IMR1_IM23 = 0x800000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM23_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM23_Unmasked = 0x1
	// Position of IM24 field.
	EXTI_C1IMR1_IM24_Pos = 0x18
	// Bit mask of IM24 field.
	EXTI_C1IMR1_IM24_Msk = 0x1000000
	// Bit IM24.
	EXTI_C1IMR1_IM24 = 0x1000000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM24_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM24_Unmasked = 0x1
	// Position of IM25 field.
	EXTI_C1IMR1_IM25_Pos = 0x19
	// Bit mask of IM25 field.
	EXTI_C1IMR1_IM25_Msk = 0x2000000
	// Bit IM25.
	EXTI_C1IMR1_IM25 = 0x2000000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM25_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM25_Unmasked = 0x1
	// Position of IM26 field.
	EXTI_C1IMR1_IM26_Pos = 0x1a
	// Bit mask of IM26 field.
	EXTI_C1IMR1_IM26_Msk = 0x4000000
	// Bit IM26.
	EXTI_C1IMR1_IM26 = 0x4000000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM26_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM26_Unmasked = 0x1
	// Position of IM27 field.
	EXTI_C1IMR1_IM27_Pos = 0x1b
	// Bit mask of IM27 field.
	EXTI_C1IMR1_IM27_Msk = 0x8000000
	// Bit IM27.
	EXTI_C1IMR1_IM27 = 0x8000000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM27_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM27_Unmasked = 0x1
	// Position of IM28 field.
	EXTI_C1IMR1_IM28_Pos = 0x1c
	// Bit mask of IM28 field.
	EXTI_C1IMR1_IM28_Msk = 0x10000000
	// Bit IM28.
	EXTI_C1IMR1_IM28 = 0x10000000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM28_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM28_Unmasked = 0x1
	// Position of IM29 field.
	EXTI_C1IMR1_IM29_Pos = 0x1d
	// Bit mask of IM29 field.
	EXTI_C1IMR1_IM29_Msk = 0x20000000
	// Bit IM29.
	EXTI_C1IMR1_IM29 = 0x20000000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM29_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM29_Unmasked = 0x1
	// Position of IM30 field.
	EXTI_C1IMR1_IM30_Pos = 0x1e
	// Bit mask of IM30 field.
	EXTI_C1IMR1_IM30_Msk = 0x40000000
	// Bit IM30.
	EXTI_C1IMR1_IM30 = 0x40000000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM30_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM30_Unmasked = 0x1
	// Position of IM31 field.
	EXTI_C1IMR1_IM31_Pos = 0x1f
	// Bit mask of IM31 field.
	EXTI_C1IMR1_IM31_Msk = 0x80000000
	// Bit IM31.
	EXTI_C1IMR1_IM31 = 0x80000000
	// Interrupt request line is masked
	EXTI_C1IMR1_IM31_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR1_IM31_Unmasked = 0x1

	// C1EMR1: event mask register
	// Position of EM0 field.
	EXTI_C1EMR1_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	EXTI_C1EMR1_EM0_Msk = 0x1
	// Bit EM0.
	EXTI_C1EMR1_EM0 = 0x1
	// Interrupt request line is masked
	EXTI_C1EMR1_EM0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM0_Unmasked = 0x1
	// Position of EM1 field.
	EXTI_C1EMR1_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	EXTI_C1EMR1_EM1_Msk = 0x2
	// Bit EM1.
	EXTI_C1EMR1_EM1 = 0x2
	// Interrupt request line is masked
	EXTI_C1EMR1_EM1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM1_Unmasked = 0x1
	// Position of EM2 field.
	EXTI_C1EMR1_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	EXTI_C1EMR1_EM2_Msk = 0x4
	// Bit EM2.
	EXTI_C1EMR1_EM2 = 0x4
	// Interrupt request line is masked
	EXTI_C1EMR1_EM2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM2_Unmasked = 0x1
	// Position of EM3 field.
	EXTI_C1EMR1_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	EXTI_C1EMR1_EM3_Msk = 0x8
	// Bit EM3.
	EXTI_C1EMR1_EM3 = 0x8
	// Interrupt request line is masked
	EXTI_C1EMR1_EM3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM3_Unmasked = 0x1
	// Position of EM4 field.
	EXTI_C1EMR1_EM4_Pos = 0x4
	// Bit mask of EM4 field.
	EXTI_C1EMR1_EM4_Msk = 0x10
	// Bit EM4.
	EXTI_C1EMR1_EM4 = 0x10
	// Interrupt request line is masked
	EXTI_C1EMR1_EM4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM4_Unmasked = 0x1
	// Position of EM5 field.
	EXTI_C1EMR1_EM5_Pos = 0x5
	// Bit mask of EM5 field.
	EXTI_C1EMR1_EM5_Msk = 0x20
	// Bit EM5.
	EXTI_C1EMR1_EM5 = 0x20
	// Interrupt request line is masked
	EXTI_C1EMR1_EM5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM5_Unmasked = 0x1
	// Position of EM6 field.
	EXTI_C1EMR1_EM6_Pos = 0x6
	// Bit mask of EM6 field.
	EXTI_C1EMR1_EM6_Msk = 0x40
	// Bit EM6.
	EXTI_C1EMR1_EM6 = 0x40
	// Interrupt request line is masked
	EXTI_C1EMR1_EM6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM6_Unmasked = 0x1
	// Position of EM7 field.
	EXTI_C1EMR1_EM7_Pos = 0x7
	// Bit mask of EM7 field.
	EXTI_C1EMR1_EM7_Msk = 0x80
	// Bit EM7.
	EXTI_C1EMR1_EM7 = 0x80
	// Interrupt request line is masked
	EXTI_C1EMR1_EM7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM7_Unmasked = 0x1
	// Position of EM8 field.
	EXTI_C1EMR1_EM8_Pos = 0x8
	// Bit mask of EM8 field.
	EXTI_C1EMR1_EM8_Msk = 0x100
	// Bit EM8.
	EXTI_C1EMR1_EM8 = 0x100
	// Interrupt request line is masked
	EXTI_C1EMR1_EM8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM8_Unmasked = 0x1
	// Position of EM9 field.
	EXTI_C1EMR1_EM9_Pos = 0x9
	// Bit mask of EM9 field.
	EXTI_C1EMR1_EM9_Msk = 0x200
	// Bit EM9.
	EXTI_C1EMR1_EM9 = 0x200
	// Interrupt request line is masked
	EXTI_C1EMR1_EM9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM9_Unmasked = 0x1
	// Position of EM10 field.
	EXTI_C1EMR1_EM10_Pos = 0xa
	// Bit mask of EM10 field.
	EXTI_C1EMR1_EM10_Msk = 0x400
	// Bit EM10.
	EXTI_C1EMR1_EM10 = 0x400
	// Interrupt request line is masked
	EXTI_C1EMR1_EM10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM10_Unmasked = 0x1
	// Position of EM11 field.
	EXTI_C1EMR1_EM11_Pos = 0xb
	// Bit mask of EM11 field.
	EXTI_C1EMR1_EM11_Msk = 0x800
	// Bit EM11.
	EXTI_C1EMR1_EM11 = 0x800
	// Interrupt request line is masked
	EXTI_C1EMR1_EM11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM11_Unmasked = 0x1
	// Position of EM12 field.
	EXTI_C1EMR1_EM12_Pos = 0xc
	// Bit mask of EM12 field.
	EXTI_C1EMR1_EM12_Msk = 0x1000
	// Bit EM12.
	EXTI_C1EMR1_EM12 = 0x1000
	// Interrupt request line is masked
	EXTI_C1EMR1_EM12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM12_Unmasked = 0x1
	// Position of EM13 field.
	EXTI_C1EMR1_EM13_Pos = 0xd
	// Bit mask of EM13 field.
	EXTI_C1EMR1_EM13_Msk = 0x2000
	// Bit EM13.
	EXTI_C1EMR1_EM13 = 0x2000
	// Interrupt request line is masked
	EXTI_C1EMR1_EM13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM13_Unmasked = 0x1
	// Position of EM14 field.
	EXTI_C1EMR1_EM14_Pos = 0xe
	// Bit mask of EM14 field.
	EXTI_C1EMR1_EM14_Msk = 0x4000
	// Bit EM14.
	EXTI_C1EMR1_EM14 = 0x4000
	// Interrupt request line is masked
	EXTI_C1EMR1_EM14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM14_Unmasked = 0x1
	// Position of EM15 field.
	EXTI_C1EMR1_EM15_Pos = 0xf
	// Bit mask of EM15 field.
	EXTI_C1EMR1_EM15_Msk = 0x8000
	// Bit EM15.
	EXTI_C1EMR1_EM15 = 0x8000
	// Interrupt request line is masked
	EXTI_C1EMR1_EM15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM15_Unmasked = 0x1
	// Position of EM17 field.
	EXTI_C1EMR1_EM17_Pos = 0x11
	// Bit mask of EM17 field.
	EXTI_C1EMR1_EM17_Msk = 0x20000
	// Bit EM17.
	EXTI_C1EMR1_EM17 = 0x20000
	// Interrupt request line is masked
	EXTI_C1EMR1_EM17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM17_Unmasked = 0x1
	// Position of EM18 field.
	EXTI_C1EMR1_EM18_Pos = 0x12
	// Bit mask of EM18 field.
	EXTI_C1EMR1_EM18_Msk = 0x40000
	// Bit EM18.
	EXTI_C1EMR1_EM18 = 0x40000
	// Interrupt request line is masked
	EXTI_C1EMR1_EM18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM18_Unmasked = 0x1
	// Position of EM19 field.
	EXTI_C1EMR1_EM19_Pos = 0x13
	// Bit mask of EM19 field.
	EXTI_C1EMR1_EM19_Msk = 0x80000
	// Bit EM19.
	EXTI_C1EMR1_EM19 = 0x80000
	// Interrupt request line is masked
	EXTI_C1EMR1_EM19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM19_Unmasked = 0x1
	// Position of EM20 field.
	EXTI_C1EMR1_EM20_Pos = 0x14
	// Bit mask of EM20 field.
	EXTI_C1EMR1_EM20_Msk = 0x100000
	// Bit EM20.
	EXTI_C1EMR1_EM20 = 0x100000
	// Interrupt request line is masked
	EXTI_C1EMR1_EM20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM20_Unmasked = 0x1
	// Position of EM21 field.
	EXTI_C1EMR1_EM21_Pos = 0x15
	// Bit mask of EM21 field.
	EXTI_C1EMR1_EM21_Msk = 0x200000
	// Bit EM21.
	EXTI_C1EMR1_EM21 = 0x200000
	// Interrupt request line is masked
	EXTI_C1EMR1_EM21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM21_Unmasked = 0x1
	// Position of EM22 field.
	EXTI_C1EMR1_EM22_Pos = 0x16
	// Bit mask of EM22 field.
	EXTI_C1EMR1_EM22_Msk = 0x400000
	// Bit EM22.
	EXTI_C1EMR1_EM22 = 0x400000
	// Interrupt request line is masked
	EXTI_C1EMR1_EM22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR1_EM22_Unmasked = 0x1

	// C1IMR2: wakeup with interrupt mask register
	// Position of IM34 field.
	EXTI_C1IMR2_IM34_Pos = 0x2
	// Bit mask of IM34 field.
	EXTI_C1IMR2_IM34_Msk = 0x4
	// Bit IM34.
	EXTI_C1IMR2_IM34 = 0x4
	// Interrupt request line is masked
	EXTI_C1IMR2_IM34_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR2_IM34_Unmasked = 0x1
	// Position of IM36 field.
	EXTI_C1IMR2_IM36_Pos = 0x4
	// Bit mask of IM36 field.
	EXTI_C1IMR2_IM36_Msk = 0x10
	// Bit IM36.
	EXTI_C1IMR2_IM36 = 0x10
	// Interrupt request line is masked
	EXTI_C1IMR2_IM36_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR2_IM36_Unmasked = 0x1
	// Position of IM37 field.
	EXTI_C1IMR2_IM37_Pos = 0x5
	// Bit mask of IM37 field.
	EXTI_C1IMR2_IM37_Msk = 0x20
	// Bit IM37.
	EXTI_C1IMR2_IM37 = 0x20
	// Interrupt request line is masked
	EXTI_C1IMR2_IM37_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR2_IM37_Unmasked = 0x1
	// Position of IM38 field.
	EXTI_C1IMR2_IM38_Pos = 0x6
	// Bit mask of IM38 field.
	EXTI_C1IMR2_IM38_Msk = 0x40
	// Bit IM38.
	EXTI_C1IMR2_IM38 = 0x40
	// Interrupt request line is masked
	EXTI_C1IMR2_IM38_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR2_IM38_Unmasked = 0x1
	// Position of IM39 field.
	EXTI_C1IMR2_IM39_Pos = 0x7
	// Bit mask of IM39 field.
	EXTI_C1IMR2_IM39_Msk = 0x80
	// Bit IM39.
	EXTI_C1IMR2_IM39 = 0x80
	// Interrupt request line is masked
	EXTI_C1IMR2_IM39_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR2_IM39_Unmasked = 0x1
	// Position of IM40 field.
	EXTI_C1IMR2_IM40_Pos = 0x8
	// Bit mask of IM40 field.
	EXTI_C1IMR2_IM40_Msk = 0x100
	// Bit IM40.
	EXTI_C1IMR2_IM40 = 0x100
	// Interrupt request line is masked
	EXTI_C1IMR2_IM40_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR2_IM40_Unmasked = 0x1
	// Position of IM41 field.
	EXTI_C1IMR2_IM41_Pos = 0x9
	// Bit mask of IM41 field.
	EXTI_C1IMR2_IM41_Msk = 0x200
	// Bit IM41.
	EXTI_C1IMR2_IM41 = 0x200
	// Interrupt request line is masked
	EXTI_C1IMR2_IM41_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR2_IM41_Unmasked = 0x1
	// Position of IM42 field.
	EXTI_C1IMR2_IM42_Pos = 0xa
	// Bit mask of IM42 field.
	EXTI_C1IMR2_IM42_Msk = 0x400
	// Bit IM42.
	EXTI_C1IMR2_IM42 = 0x400
	// Interrupt request line is masked
	EXTI_C1IMR2_IM42_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR2_IM42_Unmasked = 0x1
	// Position of IM43 field.
	EXTI_C1IMR2_IM43_Pos = 0xb
	// Bit mask of IM43 field.
	EXTI_C1IMR2_IM43_Msk = 0x800
	// Bit IM43.
	EXTI_C1IMR2_IM43 = 0x800
	// Interrupt request line is masked
	EXTI_C1IMR2_IM43_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR2_IM43_Unmasked = 0x1
	// Position of IM44 field.
	EXTI_C1IMR2_IM44_Pos = 0xc
	// Bit mask of IM44 field.
	EXTI_C1IMR2_IM44_Msk = 0x1000
	// Bit IM44.
	EXTI_C1IMR2_IM44 = 0x1000
	// Interrupt request line is masked
	EXTI_C1IMR2_IM44_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR2_IM44_Unmasked = 0x1
	// Position of IM45 field.
	EXTI_C1IMR2_IM45_Pos = 0xd
	// Bit mask of IM45 field.
	EXTI_C1IMR2_IM45_Msk = 0x2000
	// Bit IM45.
	EXTI_C1IMR2_IM45 = 0x2000
	// Interrupt request line is masked
	EXTI_C1IMR2_IM45_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR2_IM45_Unmasked = 0x1
	// Position of IM46 field.
	EXTI_C1IMR2_IM46_Pos = 0xe
	// Bit mask of IM46 field.
	EXTI_C1IMR2_IM46_Msk = 0x4000
	// Bit IM46.
	EXTI_C1IMR2_IM46 = 0x4000
	// Interrupt request line is masked
	EXTI_C1IMR2_IM46_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1IMR2_IM46_Unmasked = 0x1

	// C1EMR2: wakeup with event mask register
	// Position of EM40 field.
	EXTI_C1EMR2_EM40_Pos = 0x8
	// Bit mask of EM40 field.
	EXTI_C1EMR2_EM40_Msk = 0x100
	// Bit EM40.
	EXTI_C1EMR2_EM40 = 0x100
	// Interrupt request line is masked
	EXTI_C1EMR2_EM40_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR2_EM40_Unmasked = 0x1
	// Position of EM41 field.
	EXTI_C1EMR2_EM41_Pos = 0x9
	// Bit mask of EM41 field.
	EXTI_C1EMR2_EM41_Msk = 0x200
	// Bit EM41.
	EXTI_C1EMR2_EM41 = 0x200
	// Interrupt request line is masked
	EXTI_C1EMR2_EM41_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C1EMR2_EM41_Unmasked = 0x1

	// C2IMR1: interrupt mask register
	// Position of IM field.
	EXTI_C2IMR1_IM_Pos = 0x0
	// Bit mask of IM field.
	EXTI_C2IMR1_IM_Msk = 0xffffffff
	// Interrupt request line is masked
	EXTI_C2IMR1_IM_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2IMR1_IM_Unmasked = 0x1

	// C2EMR1: event mask register
	// Position of EM0 field.
	EXTI_C2EMR1_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	EXTI_C2EMR1_EM0_Msk = 0x1
	// Bit EM0.
	EXTI_C2EMR1_EM0 = 0x1
	// Interrupt request line is masked
	EXTI_C2EMR1_EM0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM0_Unmasked = 0x1
	// Position of EM1 field.
	EXTI_C2EMR1_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	EXTI_C2EMR1_EM1_Msk = 0x2
	// Bit EM1.
	EXTI_C2EMR1_EM1 = 0x2
	// Interrupt request line is masked
	EXTI_C2EMR1_EM1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM1_Unmasked = 0x1
	// Position of EM2 field.
	EXTI_C2EMR1_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	EXTI_C2EMR1_EM2_Msk = 0x4
	// Bit EM2.
	EXTI_C2EMR1_EM2 = 0x4
	// Interrupt request line is masked
	EXTI_C2EMR1_EM2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM2_Unmasked = 0x1
	// Position of EM3 field.
	EXTI_C2EMR1_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	EXTI_C2EMR1_EM3_Msk = 0x8
	// Bit EM3.
	EXTI_C2EMR1_EM3 = 0x8
	// Interrupt request line is masked
	EXTI_C2EMR1_EM3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM3_Unmasked = 0x1
	// Position of EM4 field.
	EXTI_C2EMR1_EM4_Pos = 0x4
	// Bit mask of EM4 field.
	EXTI_C2EMR1_EM4_Msk = 0x10
	// Bit EM4.
	EXTI_C2EMR1_EM4 = 0x10
	// Interrupt request line is masked
	EXTI_C2EMR1_EM4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM4_Unmasked = 0x1
	// Position of EM5 field.
	EXTI_C2EMR1_EM5_Pos = 0x5
	// Bit mask of EM5 field.
	EXTI_C2EMR1_EM5_Msk = 0x20
	// Bit EM5.
	EXTI_C2EMR1_EM5 = 0x20
	// Interrupt request line is masked
	EXTI_C2EMR1_EM5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM5_Unmasked = 0x1
	// Position of EM6 field.
	EXTI_C2EMR1_EM6_Pos = 0x6
	// Bit mask of EM6 field.
	EXTI_C2EMR1_EM6_Msk = 0x40
	// Bit EM6.
	EXTI_C2EMR1_EM6 = 0x40
	// Interrupt request line is masked
	EXTI_C2EMR1_EM6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM6_Unmasked = 0x1
	// Position of EM7 field.
	EXTI_C2EMR1_EM7_Pos = 0x7
	// Bit mask of EM7 field.
	EXTI_C2EMR1_EM7_Msk = 0x80
	// Bit EM7.
	EXTI_C2EMR1_EM7 = 0x80
	// Interrupt request line is masked
	EXTI_C2EMR1_EM7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM7_Unmasked = 0x1
	// Position of EM8 field.
	EXTI_C2EMR1_EM8_Pos = 0x8
	// Bit mask of EM8 field.
	EXTI_C2EMR1_EM8_Msk = 0x100
	// Bit EM8.
	EXTI_C2EMR1_EM8 = 0x100
	// Interrupt request line is masked
	EXTI_C2EMR1_EM8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM8_Unmasked = 0x1
	// Position of EM9 field.
	EXTI_C2EMR1_EM9_Pos = 0x9
	// Bit mask of EM9 field.
	EXTI_C2EMR1_EM9_Msk = 0x200
	// Bit EM9.
	EXTI_C2EMR1_EM9 = 0x200
	// Interrupt request line is masked
	EXTI_C2EMR1_EM9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM9_Unmasked = 0x1
	// Position of EM10 field.
	EXTI_C2EMR1_EM10_Pos = 0xa
	// Bit mask of EM10 field.
	EXTI_C2EMR1_EM10_Msk = 0x400
	// Bit EM10.
	EXTI_C2EMR1_EM10 = 0x400
	// Interrupt request line is masked
	EXTI_C2EMR1_EM10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM10_Unmasked = 0x1
	// Position of EM11 field.
	EXTI_C2EMR1_EM11_Pos = 0xb
	// Bit mask of EM11 field.
	EXTI_C2EMR1_EM11_Msk = 0x800
	// Bit EM11.
	EXTI_C2EMR1_EM11 = 0x800
	// Interrupt request line is masked
	EXTI_C2EMR1_EM11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM11_Unmasked = 0x1
	// Position of EM12 field.
	EXTI_C2EMR1_EM12_Pos = 0xc
	// Bit mask of EM12 field.
	EXTI_C2EMR1_EM12_Msk = 0x1000
	// Bit EM12.
	EXTI_C2EMR1_EM12 = 0x1000
	// Interrupt request line is masked
	EXTI_C2EMR1_EM12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM12_Unmasked = 0x1
	// Position of EM13 field.
	EXTI_C2EMR1_EM13_Pos = 0xd
	// Bit mask of EM13 field.
	EXTI_C2EMR1_EM13_Msk = 0x2000
	// Bit EM13.
	EXTI_C2EMR1_EM13 = 0x2000
	// Interrupt request line is masked
	EXTI_C2EMR1_EM13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM13_Unmasked = 0x1
	// Position of EM14 field.
	EXTI_C2EMR1_EM14_Pos = 0xe
	// Bit mask of EM14 field.
	EXTI_C2EMR1_EM14_Msk = 0x4000
	// Bit EM14.
	EXTI_C2EMR1_EM14 = 0x4000
	// Interrupt request line is masked
	EXTI_C2EMR1_EM14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM14_Unmasked = 0x1
	// Position of EM15 field.
	EXTI_C2EMR1_EM15_Pos = 0xf
	// Bit mask of EM15 field.
	EXTI_C2EMR1_EM15_Msk = 0x8000
	// Bit EM15.
	EXTI_C2EMR1_EM15 = 0x8000
	// Interrupt request line is masked
	EXTI_C2EMR1_EM15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM15_Unmasked = 0x1
	// Position of EM17 field.
	EXTI_C2EMR1_EM17_Pos = 0x11
	// Bit mask of EM17 field.
	EXTI_C2EMR1_EM17_Msk = 0x20000
	// Bit EM17.
	EXTI_C2EMR1_EM17 = 0x20000
	// Interrupt request line is masked
	EXTI_C2EMR1_EM17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM17_Unmasked = 0x1
	// Position of EM18 field.
	EXTI_C2EMR1_EM18_Pos = 0x12
	// Bit mask of EM18 field.
	EXTI_C2EMR1_EM18_Msk = 0x40000
	// Bit EM18.
	EXTI_C2EMR1_EM18 = 0x40000
	// Interrupt request line is masked
	EXTI_C2EMR1_EM18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM18_Unmasked = 0x1
	// Position of EM19 field.
	EXTI_C2EMR1_EM19_Pos = 0x13
	// Bit mask of EM19 field.
	EXTI_C2EMR1_EM19_Msk = 0x80000
	// Bit EM19.
	EXTI_C2EMR1_EM19 = 0x80000
	// Interrupt request line is masked
	EXTI_C2EMR1_EM19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM19_Unmasked = 0x1
	// Position of EM20 field.
	EXTI_C2EMR1_EM20_Pos = 0x14
	// Bit mask of EM20 field.
	EXTI_C2EMR1_EM20_Msk = 0x100000
	// Bit EM20.
	EXTI_C2EMR1_EM20 = 0x100000
	// Interrupt request line is masked
	EXTI_C2EMR1_EM20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM20_Unmasked = 0x1
	// Position of EM21 field.
	EXTI_C2EMR1_EM21_Pos = 0x15
	// Bit mask of EM21 field.
	EXTI_C2EMR1_EM21_Msk = 0x200000
	// Bit EM21.
	EXTI_C2EMR1_EM21 = 0x200000
	// Interrupt request line is masked
	EXTI_C2EMR1_EM21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM21_Unmasked = 0x1
	// Position of EM22 field.
	EXTI_C2EMR1_EM22_Pos = 0x16
	// Bit mask of EM22 field.
	EXTI_C2EMR1_EM22_Msk = 0x400000
	// Bit EM22.
	EXTI_C2EMR1_EM22 = 0x400000
	// Interrupt request line is masked
	EXTI_C2EMR1_EM22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR1_EM22_Unmasked = 0x1

	// C2IMR2: wakeup with interrupt mask register
	// Position of IM34 field.
	EXTI_C2IMR2_IM34_Pos = 0x2
	// Bit mask of IM34 field.
	EXTI_C2IMR2_IM34_Msk = 0x4
	// Bit IM34.
	EXTI_C2IMR2_IM34 = 0x4
	// Interrupt request line is masked
	EXTI_C2IMR2_IM34_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2IMR2_IM34_Unmasked = 0x1
	// Position of IM36 field.
	EXTI_C2IMR2_IM36_Pos = 0x4
	// Bit mask of IM36 field.
	EXTI_C2IMR2_IM36_Msk = 0x10
	// Bit IM36.
	EXTI_C2IMR2_IM36 = 0x10
	// Interrupt request line is masked
	EXTI_C2IMR2_IM36_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2IMR2_IM36_Unmasked = 0x1
	// Position of IM37 field.
	EXTI_C2IMR2_IM37_Pos = 0x5
	// Bit mask of IM37 field.
	EXTI_C2IMR2_IM37_Msk = 0x20
	// Bit IM37.
	EXTI_C2IMR2_IM37 = 0x20
	// Interrupt request line is masked
	EXTI_C2IMR2_IM37_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2IMR2_IM37_Unmasked = 0x1
	// Position of IM38 field.
	EXTI_C2IMR2_IM38_Pos = 0x6
	// Bit mask of IM38 field.
	EXTI_C2IMR2_IM38_Msk = 0x40
	// Bit IM38.
	EXTI_C2IMR2_IM38 = 0x40
	// Interrupt request line is masked
	EXTI_C2IMR2_IM38_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2IMR2_IM38_Unmasked = 0x1
	// Position of IM39 field.
	EXTI_C2IMR2_IM39_Pos = 0x7
	// Bit mask of IM39 field.
	EXTI_C2IMR2_IM39_Msk = 0x80
	// Bit IM39.
	EXTI_C2IMR2_IM39 = 0x80
	// Interrupt request line is masked
	EXTI_C2IMR2_IM39_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2IMR2_IM39_Unmasked = 0x1
	// Position of IM40 field.
	EXTI_C2IMR2_IM40_Pos = 0x8
	// Bit mask of IM40 field.
	EXTI_C2IMR2_IM40_Msk = 0x100
	// Bit IM40.
	EXTI_C2IMR2_IM40 = 0x100
	// Interrupt request line is masked
	EXTI_C2IMR2_IM40_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2IMR2_IM40_Unmasked = 0x1
	// Position of IM41 field.
	EXTI_C2IMR2_IM41_Pos = 0x9
	// Bit mask of IM41 field.
	EXTI_C2IMR2_IM41_Msk = 0x200
	// Bit IM41.
	EXTI_C2IMR2_IM41 = 0x200
	// Interrupt request line is masked
	EXTI_C2IMR2_IM41_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2IMR2_IM41_Unmasked = 0x1
	// Position of IM42 field.
	EXTI_C2IMR2_IM42_Pos = 0xa
	// Bit mask of IM42 field.
	EXTI_C2IMR2_IM42_Msk = 0x400
	// Bit IM42.
	EXTI_C2IMR2_IM42 = 0x400
	// Interrupt request line is masked
	EXTI_C2IMR2_IM42_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2IMR2_IM42_Unmasked = 0x1
	// Position of IM43 field.
	EXTI_C2IMR2_IM43_Pos = 0xb
	// Bit mask of IM43 field.
	EXTI_C2IMR2_IM43_Msk = 0x800
	// Bit IM43.
	EXTI_C2IMR2_IM43 = 0x800
	// Interrupt request line is masked
	EXTI_C2IMR2_IM43_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2IMR2_IM43_Unmasked = 0x1
	// Position of IM44 field.
	EXTI_C2IMR2_IM44_Pos = 0xc
	// Bit mask of IM44 field.
	EXTI_C2IMR2_IM44_Msk = 0x1000
	// Bit IM44.
	EXTI_C2IMR2_IM44 = 0x1000
	// Interrupt request line is masked
	EXTI_C2IMR2_IM44_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2IMR2_IM44_Unmasked = 0x1
	// Position of IM45 field.
	EXTI_C2IMR2_IM45_Pos = 0xd
	// Bit mask of IM45 field.
	EXTI_C2IMR2_IM45_Msk = 0x2000
	// Bit IM45.
	EXTI_C2IMR2_IM45 = 0x2000
	// Interrupt request line is masked
	EXTI_C2IMR2_IM45_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2IMR2_IM45_Unmasked = 0x1
	// Position of IM46 field.
	EXTI_C2IMR2_IM46_Pos = 0xe
	// Bit mask of IM46 field.
	EXTI_C2IMR2_IM46_Msk = 0x4000
	// Bit IM46.
	EXTI_C2IMR2_IM46 = 0x4000
	// Interrupt request line is masked
	EXTI_C2IMR2_IM46_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2IMR2_IM46_Unmasked = 0x1

	// C2EMR2: wakeup with event mask register
	// Position of EM40 field.
	EXTI_C2EMR2_EM40_Pos = 0x8
	// Bit mask of EM40 field.
	EXTI_C2EMR2_EM40_Msk = 0x100
	// Bit EM40.
	EXTI_C2EMR2_EM40 = 0x100
	// Interrupt request line is masked
	EXTI_C2EMR2_EM40_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR2_EM40_Unmasked = 0x1
	// Position of EM41 field.
	EXTI_C2EMR2_EM41_Pos = 0x9
	// Bit mask of EM41 field.
	EXTI_C2EMR2_EM41_Msk = 0x200
	// Bit EM41.
	EXTI_C2EMR2_EM41 = 0x200
	// Interrupt request line is masked
	EXTI_C2EMR2_EM41_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_C2EMR2_EM41_Unmasked = 0x1
)

// Constants for FLASH: Flash
const (
	// ACR: Access control register
	// Position of LATENCY field.
	Flash_ACR_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	Flash_ACR_LATENCY_Msk = 0x7
	// 0 wait states
	Flash_ACR_LATENCY_WS0 = 0x0
	// 1 wait states
	Flash_ACR_LATENCY_WS1 = 0x1
	// 2 wait states
	Flash_ACR_LATENCY_WS2 = 0x2
	// Position of PRFTEN field.
	Flash_ACR_PRFTEN_Pos = 0x8
	// Bit mask of PRFTEN field.
	Flash_ACR_PRFTEN_Msk = 0x100
	// Bit PRFTEN.
	Flash_ACR_PRFTEN = 0x100
	// Prefetch is disabled
	Flash_ACR_PRFTEN_Disabled = 0x0
	// Prefetch is enabled
	Flash_ACR_PRFTEN_Enabled = 0x1
	// Position of ICEN field.
	Flash_ACR_ICEN_Pos = 0x9
	// Bit mask of ICEN field.
	Flash_ACR_ICEN_Msk = 0x200
	// Bit ICEN.
	Flash_ACR_ICEN = 0x200
	// Instruction cache is disabled
	Flash_ACR_ICEN_Disabled = 0x0
	// Instruction cache is enabled
	Flash_ACR_ICEN_Enabled = 0x1
	// Position of DCEN field.
	Flash_ACR_DCEN_Pos = 0xa
	// Bit mask of DCEN field.
	Flash_ACR_DCEN_Msk = 0x400
	// Bit DCEN.
	Flash_ACR_DCEN = 0x400
	// Data cache is disabled
	Flash_ACR_DCEN_Disabled = 0x0
	// Data cache is enabled
	Flash_ACR_DCEN_Enabled = 0x1
	// Position of ICRST field.
	Flash_ACR_ICRST_Pos = 0xb
	// Bit mask of ICRST field.
	Flash_ACR_ICRST_Msk = 0x800
	// Bit ICRST.
	Flash_ACR_ICRST = 0x800
	// Instruction cache is not reset
	Flash_ACR_ICRST_NotReset = 0x0
	// Instruction cache is reset
	Flash_ACR_ICRST_Reset = 0x1
	// Position of DCRST field.
	Flash_ACR_DCRST_Pos = 0xc
	// Bit mask of DCRST field.
	Flash_ACR_DCRST_Msk = 0x1000
	// Bit DCRST.
	Flash_ACR_DCRST = 0x1000
	// Data cache is not reset
	Flash_ACR_DCRST_NotReset = 0x0
	// Data cache is reset
	Flash_ACR_DCRST_Reset = 0x1
	// Position of PES field.
	Flash_ACR_PES_Pos = 0xf
	// Bit mask of PES field.
	Flash_ACR_PES_Msk = 0x8000
	// Bit PES.
	Flash_ACR_PES = 0x8000
	// Flash program and erase operations granted
	Flash_ACR_PES_Granted = 0x0
	// Any new Flash program and erase operation is suspended until this bit is cleared. The PESD bit in FLASH_SR is set when PES bit in FLASH_ACR is set
	Flash_ACR_PES_Suspended = 0x1
	// Position of EMPTY field.
	Flash_ACR_EMPTY_Pos = 0x10
	// Bit mask of EMPTY field.
	Flash_ACR_EMPTY_Msk = 0x10000
	// Bit EMPTY.
	Flash_ACR_EMPTY = 0x10000
	// User Flash programmend
	Flash_ACR_EMPTY_Programmed = 0x0
	// User Flash empty
	Flash_ACR_EMPTY_Empty = 0x1

	// ACR2: Flash access control register 2
	// Position of PRIVMODE field.
	Flash_ACR2_PRIVMODE_Pos = 0x0
	// Bit mask of PRIVMODE field.
	Flash_ACR2_PRIVMODE_Msk = 0x1
	// Bit PRIVMODE.
	Flash_ACR2_PRIVMODE = 0x1
	// Position of HDPADIS field.
	Flash_ACR2_HDPADIS_Pos = 0x1
	// Bit mask of HDPADIS field.
	Flash_ACR2_HDPADIS_Msk = 0x2
	// Bit HDPADIS.
	Flash_ACR2_HDPADIS = 0x2
	// Position of C2SWDBGEN field.
	Flash_ACR2_C2SWDBGEN_Pos = 0x2
	// Bit mask of C2SWDBGEN field.
	Flash_ACR2_C2SWDBGEN_Msk = 0x4
	// Bit C2SWDBGEN.
	Flash_ACR2_C2SWDBGEN = 0x4

	// KEYR: Flash key register
	// Position of KEY field.
	Flash_KEYR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	Flash_KEYR_KEY_Msk = 0xffffffff

	// OPTKEYR: Option byte key register
	// Position of OPTKEY field.
	Flash_OPTKEYR_OPTKEY_Pos = 0x0
	// Bit mask of OPTKEY field.
	Flash_OPTKEYR_OPTKEY_Msk = 0xffffffff

	// SR: Status register
	// Position of EOP field.
	Flash_SR_EOP_Pos = 0x0
	// Bit mask of EOP field.
	Flash_SR_EOP_Msk = 0x1
	// Bit EOP.
	Flash_SR_EOP = 0x1
	// No EOP operation occurred
	Flash_SR_EOP_NoEvent = 0x0
	// An EOP event occurred
	Flash_SR_EOP_Event = 0x1
	// Clear the flag
	Flash_SR_EOP_Clear = 0x1
	// Position of OPERR field.
	Flash_SR_OPERR_Pos = 0x1
	// Bit mask of OPERR field.
	Flash_SR_OPERR_Msk = 0x2
	// Bit OPERR.
	Flash_SR_OPERR = 0x2
	// No memory opreation error happened
	Flash_SR_OPERR_NoError = 0x0
	// Memory operation error happened
	Flash_SR_OPERR_Error = 0x1
	// Clear the flag
	Flash_SR_OPERR_Clear = 0x1
	// Position of PROGERR field.
	Flash_SR_PROGERR_Pos = 0x3
	// Bit mask of PROGERR field.
	Flash_SR_PROGERR_Msk = 0x8
	// Bit PROGERR.
	Flash_SR_PROGERR = 0x8
	// No size programming error happened
	Flash_SR_PROGERR_NoError = 0x0
	// Programming error happened
	Flash_SR_PROGERR_Error = 0x1
	// Clear the flag
	Flash_SR_PROGERR_Clear = 0x1
	// Position of WRPERR field.
	Flash_SR_WRPERR_Pos = 0x4
	// Bit mask of WRPERR field.
	Flash_SR_WRPERR_Msk = 0x10
	// Bit WRPERR.
	Flash_SR_WRPERR = 0x10
	// No write protection error happened
	Flash_SR_WRPERR_NoError = 0x0
	// Write protection error happened
	Flash_SR_WRPERR_Error = 0x1
	// Clear the flag
	Flash_SR_WRPERR_Clear = 0x1
	// Position of PGAERR field.
	Flash_SR_PGAERR_Pos = 0x5
	// Bit mask of PGAERR field.
	Flash_SR_PGAERR_Msk = 0x20
	// Bit PGAERR.
	Flash_SR_PGAERR = 0x20
	// No programming alignment error happened
	Flash_SR_PGAERR_NoError = 0x0
	// Programming alignment error happened
	Flash_SR_PGAERR_Error = 0x1
	// Clear the flag
	Flash_SR_PGAERR_Clear = 0x1
	// Position of SIZERR field.
	Flash_SR_SIZERR_Pos = 0x6
	// Bit mask of SIZERR field.
	Flash_SR_SIZERR_Msk = 0x40
	// Bit SIZERR.
	Flash_SR_SIZERR = 0x40
	// No size error happened
	Flash_SR_SIZERR_NoError = 0x0
	// Size error happened
	Flash_SR_SIZERR_Error = 0x1
	// Clear the flag
	Flash_SR_SIZERR_Clear = 0x1
	// Position of PGSERR field.
	Flash_SR_PGSERR_Pos = 0x7
	// Bit mask of PGSERR field.
	Flash_SR_PGSERR_Msk = 0x80
	// Bit PGSERR.
	Flash_SR_PGSERR = 0x80
	// No fast programming sequence error happened
	Flash_SR_PGSERR_NoError = 0x0
	// Fast programming sequence error happened
	Flash_SR_PGSERR_Error = 0x1
	// Clear the flag
	Flash_SR_PGSERR_Clear = 0x1
	// Position of MISSERR field.
	Flash_SR_MISSERR_Pos = 0x8
	// Bit mask of MISSERR field.
	Flash_SR_MISSERR_Msk = 0x100
	// Bit MISSERR.
	Flash_SR_MISSERR = 0x100
	// No fast programming data miss error happened
	Flash_SR_MISSERR_NoError = 0x0
	// Fast programming data miss error happened
	Flash_SR_MISSERR_Error = 0x1
	// Clear the flag
	Flash_SR_MISSERR_Clear = 0x1
	// Position of FASTERR field.
	Flash_SR_FASTERR_Pos = 0x9
	// Bit mask of FASTERR field.
	Flash_SR_FASTERR_Msk = 0x200
	// Bit FASTERR.
	Flash_SR_FASTERR = 0x200
	// No fast programming error happened
	Flash_SR_FASTERR_NoError = 0x0
	// Fast programming error happened
	Flash_SR_FASTERR_Error = 0x1
	// Clear the flag
	Flash_SR_FASTERR_Clear = 0x1
	// Position of OPTNV field.
	Flash_SR_OPTNV_Pos = 0xd
	// Bit mask of OPTNV field.
	Flash_SR_OPTNV_Msk = 0x2000
	// Bit OPTNV.
	Flash_SR_OPTNV = 0x2000
	// The OBL user option OPTVAL indicates "valid"
	Flash_SR_OPTNV_Valid = 0x0
	// The OBL user option OPTVAL indicates "invalid"
	Flash_SR_OPTNV_Invalid = 0x1
	// Position of RDERR field.
	Flash_SR_RDERR_Pos = 0xe
	// Bit mask of RDERR field.
	Flash_SR_RDERR_Msk = 0x4000
	// Bit RDERR.
	Flash_SR_RDERR = 0x4000
	// No read-only error happened
	Flash_SR_RDERR_NoError = 0x0
	// Read-only error happened
	Flash_SR_RDERR_Error = 0x1
	// Clear the flag
	Flash_SR_RDERR_Clear = 0x1
	// Position of OPTVERR field.
	Flash_SR_OPTVERR_Pos = 0xf
	// Bit mask of OPTVERR field.
	Flash_SR_OPTVERR_Msk = 0x8000
	// Bit OPTVERR.
	Flash_SR_OPTVERR = 0x8000
	// No error in option and engineering bits
	Flash_SR_OPTVERR_NoError = 0x0
	// Error in option and engineering bits
	Flash_SR_OPTVERR_Error = 0x1
	// Clear the flag
	Flash_SR_OPTVERR_Clear = 0x1
	// Position of BSY field.
	Flash_SR_BSY_Pos = 0x10
	// Bit mask of BSY field.
	Flash_SR_BSY_Msk = 0x10000
	// Bit BSY.
	Flash_SR_BSY = 0x10000
	// No write/erase operation is in progress
	Flash_SR_BSY_Inactive = 0x0
	// No write/erase operation is in progress
	Flash_SR_BSY_Active = 0x1
	// Position of CFGBSY field.
	Flash_SR_CFGBSY_Pos = 0x12
	// Bit mask of CFGBSY field.
	Flash_SR_CFGBSY_Msk = 0x40000
	// Bit CFGBSY.
	Flash_SR_CFGBSY = 0x40000
	// PG, PNB, PER, MER bits available for writing
	Flash_SR_CFGBSY_Free = 0x0
	// PG, PNB, PER, MER bits not available for writing (operation ongoing)
	Flash_SR_CFGBSY_Busy = 0x1
	// Position of PESD field.
	Flash_SR_PESD_Pos = 0x13
	// Bit mask of PESD field.
	Flash_SR_PESD_Msk = 0x80000
	// Bit PESD.
	Flash_SR_PESD = 0x80000
	// Flash program and erase operations granted
	Flash_SR_PESD_Granted = 0x0
	// Any new Flash program and erase operation is suspended until this bit is cleared. This bit is set when the PES bit in FLASH_ACR is set
	Flash_SR_PESD_Suspended = 0x1

	// CR: Flash control register
	// Position of PG field.
	Flash_CR_PG_Pos = 0x0
	// Bit mask of PG field.
	Flash_CR_PG_Msk = 0x1
	// Bit PG.
	Flash_CR_PG = 0x1
	// Flash programming disabled
	Flash_CR_PG_Disabled = 0x0
	// Flash programming enabled
	Flash_CR_PG_Enabled = 0x1
	// Position of PER field.
	Flash_CR_PER_Pos = 0x1
	// Bit mask of PER field.
	Flash_CR_PER_Msk = 0x2
	// Bit PER.
	Flash_CR_PER = 0x2
	// Page erase disabled
	Flash_CR_PER_Disabled = 0x0
	// Page erase enabled
	Flash_CR_PER_Enabled = 0x1
	// Position of MER field.
	Flash_CR_MER_Pos = 0x2
	// Bit mask of MER field.
	Flash_CR_MER_Msk = 0x4
	// Bit MER.
	Flash_CR_MER = 0x4
	// No mass erase
	Flash_CR_MER_NoErase = 0x0
	// Trigger mass erase
	Flash_CR_MER_MassErase = 0x1
	// Position of PNB field.
	Flash_CR_PNB_Pos = 0x3
	// Bit mask of PNB field.
	Flash_CR_PNB_Msk = 0x3f8
	// Position of STRT field.
	Flash_CR_STRT_Pos = 0x10
	// Bit mask of STRT field.
	Flash_CR_STRT_Msk = 0x10000
	// Bit STRT.
	Flash_CR_STRT = 0x10000
	// Options modification completed or idle
	Flash_CR_STRT_Done = 0x0
	// Trigger options programming operation
	Flash_CR_STRT_Start = 0x1
	// Position of OPTSTRT field.
	Flash_CR_OPTSTRT_Pos = 0x11
	// Bit mask of OPTSTRT field.
	Flash_CR_OPTSTRT_Msk = 0x20000
	// Bit OPTSTRT.
	Flash_CR_OPTSTRT = 0x20000
	// Options modification completed or idle
	Flash_CR_OPTSTRT_Done = 0x0
	// Trigger options programming operation
	Flash_CR_OPTSTRT_Start = 0x1
	// Position of FSTPG field.
	Flash_CR_FSTPG_Pos = 0x12
	// Bit mask of FSTPG field.
	Flash_CR_FSTPG_Msk = 0x40000
	// Bit FSTPG.
	Flash_CR_FSTPG = 0x40000
	// Fast programming disabled
	Flash_CR_FSTPG_Disabled = 0x0
	// Fast programming enabled
	Flash_CR_FSTPG_Enabled = 0x1
	// Position of EOPIE field.
	Flash_CR_EOPIE_Pos = 0x18
	// Bit mask of EOPIE field.
	Flash_CR_EOPIE_Msk = 0x1000000
	// Bit EOPIE.
	Flash_CR_EOPIE = 0x1000000
	// End of program interrupt disable
	Flash_CR_EOPIE_Disabled = 0x0
	// End of program interrupt enable
	Flash_CR_EOPIE_Enabled = 0x1
	// Position of ERRIE field.
	Flash_CR_ERRIE_Pos = 0x19
	// Bit mask of ERRIE field.
	Flash_CR_ERRIE_Msk = 0x2000000
	// Bit ERRIE.
	Flash_CR_ERRIE = 0x2000000
	// OPERR Error interrupt disable
	Flash_CR_ERRIE_Disabled = 0x0
	// OPERR Error interrupt enable
	Flash_CR_ERRIE_Enabled = 0x1
	// Position of RDERRIE field.
	Flash_CR_RDERRIE_Pos = 0x1a
	// Bit mask of RDERRIE field.
	Flash_CR_RDERRIE_Msk = 0x4000000
	// Bit RDERRIE.
	Flash_CR_RDERRIE = 0x4000000
	// PCROP read error interrupt disable
	Flash_CR_RDERRIE_Disabled = 0x0
	// PCROP read error interrupt enable
	Flash_CR_RDERRIE_Enabled = 0x1
	// Position of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Pos = 0x1b
	// Bit mask of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Msk = 0x8000000
	// Bit OBL_LAUNCH.
	Flash_CR_OBL_LAUNCH = 0x8000000
	// Option byte loaded
	Flash_CR_OBL_LAUNCH_Complete = 0x0
	// Option byte loading to be done
	Flash_CR_OBL_LAUNCH_NotComplete = 0x1
	// Reload option byte
	Flash_CR_OBL_LAUNCH_Reload = 0x1
	// Position of OPTLOCK field.
	Flash_CR_OPTLOCK_Pos = 0x1e
	// Bit mask of OPTLOCK field.
	Flash_CR_OPTLOCK_Msk = 0x40000000
	// Bit OPTLOCK.
	Flash_CR_OPTLOCK = 0x40000000
	// FLASH_CR options are unlocked
	Flash_CR_OPTLOCK_Unlocked = 0x0
	// FLASH_CR options are locked
	Flash_CR_OPTLOCK_Locked = 0x1
	// Position of LOCK field.
	Flash_CR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Flash_CR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Flash_CR_LOCK = 0x80000000
	// FLASH_CR is unlocked
	Flash_CR_LOCK_Unlocked = 0x0
	// FLASH_CR is locked
	Flash_CR_LOCK_Locked = 0x1

	// ECCR: Flash ECC register
	// Position of ADDR_ECC field.
	Flash_ECCR_ADDR_ECC_Pos = 0x0
	// Bit mask of ADDR_ECC field.
	Flash_ECCR_ADDR_ECC_Msk = 0x1ffff
	// Position of SYSF_ECC field.
	Flash_ECCR_SYSF_ECC_Pos = 0x14
	// Bit mask of SYSF_ECC field.
	Flash_ECCR_SYSF_ECC_Msk = 0x100000
	// Bit SYSF_ECC.
	Flash_ECCR_SYSF_ECC = 0x100000
	// No System Flash memory ECC fail
	Flash_ECCR_SYSF_ECC_NotInFlash = 0x0
	// System Flash memory ECC fail
	Flash_ECCR_SYSF_ECC_InFlash = 0x1
	// Position of ECCCIE field.
	Flash_ECCR_ECCCIE_Pos = 0x18
	// Bit mask of ECCCIE field.
	Flash_ECCR_ECCCIE_Msk = 0x1000000
	// Bit ECCCIE.
	Flash_ECCR_ECCCIE = 0x1000000
	// ECCC interrupt disabled
	Flash_ECCR_ECCCIE_Disabled = 0x0
	// ECCC interrupt enabled
	Flash_ECCR_ECCCIE_Enabled = 0x1
	// Position of CPUID field.
	Flash_ECCR_CPUID_Pos = 0x1a
	// Bit mask of CPUID field.
	Flash_ECCR_CPUID_Msk = 0x1c000000
	// Position of ECCC field.
	Flash_ECCR_ECCC_Pos = 0x1e
	// Bit mask of ECCC field.
	Flash_ECCR_ECCC_Msk = 0x40000000
	// Bit ECCC.
	Flash_ECCR_ECCC = 0x40000000
	// ECC error corrected
	Flash_ECCR_ECCC_NoEvent = 0x0
	// No ECC error corrected
	Flash_ECCR_ECCC_Event = 0x1
	// Clear the flag
	Flash_ECCR_ECCC_Clear = 0x1
	// Position of ECCD field.
	Flash_ECCR_ECCD_Pos = 0x1f
	// Bit mask of ECCD field.
	Flash_ECCR_ECCD_Msk = 0x80000000
	// Bit ECCD.
	Flash_ECCR_ECCD = 0x80000000
	// Two ECC errors detected
	Flash_ECCR_ECCD_NoEvent = 0x0
	// No two ECC errors detected
	Flash_ECCR_ECCD_Event = 0x1
	// Clear the flag
	Flash_ECCR_ECCD_Clear = 0x1

	// OPTR: Flash option register
	// Position of RDP field.
	Flash_OPTR_RDP_Pos = 0x0
	// Bit mask of RDP field.
	Flash_OPTR_RDP_Msk = 0xff
	// Level 0, readout protection not active
	Flash_OPTR_RDP_Level0 = 0xaa
	// Level 2, chip readout protection active
	Flash_OPTR_RDP_Level2 = 0xcc
	// Level 1, memories readout protection active (writes 0x88)
	Flash_OPTR_RDP_Level1 = 0x88
	// Position of ESE field.
	Flash_OPTR_ESE_Pos = 0x8
	// Bit mask of ESE field.
	Flash_OPTR_ESE_Msk = 0x100
	// Bit ESE.
	Flash_OPTR_ESE = 0x100
	// Security disabled
	Flash_OPTR_ESE_Disabled = 0x0
	// Security enabled
	Flash_OPTR_ESE_Enabled = 0x1
	// Position of BOR_LEV field.
	Flash_OPTR_BOR_LEV_Pos = 0x9
	// Bit mask of BOR_LEV field.
	Flash_OPTR_BOR_LEV_Msk = 0xe00
	// BOR level 0. Reset level threshold is around 1.7 V
	Flash_OPTR_BOR_LEV_Level0 = 0x0
	// BOR level 1. Reset level threshold is around 2.0 V
	Flash_OPTR_BOR_LEV_Level1 = 0x1
	// BOR level 2. Reset level threshold is around 2.2 V
	Flash_OPTR_BOR_LEV_Level2 = 0x2
	// BOR level 3. Reset level threshold is around 2.5 V
	Flash_OPTR_BOR_LEV_Level3 = 0x3
	// BOR level 4. Reset level threshold is around 2.8 V
	Flash_OPTR_BOR_LEV_Level4 = 0x4
	// Position of NRST_STOP field.
	Flash_OPTR_NRST_STOP_Pos = 0xc
	// Bit mask of NRST_STOP field.
	Flash_OPTR_NRST_STOP_Msk = 0x1000
	// Bit NRST_STOP.
	Flash_OPTR_NRST_STOP = 0x1000
	// Reset generated when entering the Standby mode
	Flash_OPTR_NRST_STOP_Enabled = 0x0
	// No reset generated when entering the Standby mode
	Flash_OPTR_NRST_STOP_Disabled = 0x1
	// Position of NRST_STDBY field.
	Flash_OPTR_NRST_STDBY_Pos = 0xd
	// Bit mask of NRST_STDBY field.
	Flash_OPTR_NRST_STDBY_Msk = 0x2000
	// Bit NRST_STDBY.
	Flash_OPTR_NRST_STDBY = 0x2000
	// Reset generated when entering the Standby mode
	Flash_OPTR_NRST_STDBY_Enabled = 0x0
	// No reset generated when entering the Standby mode
	Flash_OPTR_NRST_STDBY_Disabled = 0x1
	// Position of NRST_SHDW field.
	Flash_OPTR_NRST_SHDW_Pos = 0xe
	// Bit mask of NRST_SHDW field.
	Flash_OPTR_NRST_SHDW_Msk = 0x4000
	// Bit NRST_SHDW.
	Flash_OPTR_NRST_SHDW = 0x4000
	// Reset generated when entering the Shutdown mode
	Flash_OPTR_NRST_SHDW_Enabled = 0x0
	// No reset generated when entering the Shutdown mode
	Flash_OPTR_NRST_SHDW_Disabled = 0x1
	// Position of IWDG_SW field.
	Flash_OPTR_IWDG_SW_Pos = 0x10
	// Bit mask of IWDG_SW field.
	Flash_OPTR_IWDG_SW_Msk = 0x10000
	// Bit IWDG_SW.
	Flash_OPTR_IWDG_SW = 0x10000
	// Hardware independent watchdog
	Flash_OPTR_IWDG_SW_Hardware = 0x0
	// Software independent watchdog
	Flash_OPTR_IWDG_SW_Software = 0x1
	// Position of IWDG_STOP field.
	Flash_OPTR_IWDG_STOP_Pos = 0x11
	// Bit mask of IWDG_STOP field.
	Flash_OPTR_IWDG_STOP_Msk = 0x20000
	// Bit IWDG_STOP.
	Flash_OPTR_IWDG_STOP = 0x20000
	// Independent watchdog counter frozen in Stop mode
	Flash_OPTR_IWDG_STOP_Frozen = 0x0
	// Independent watchdog counter running in Stop mode
	Flash_OPTR_IWDG_STOP_Running = 0x1
	// Position of IWDG_STDBY field.
	Flash_OPTR_IWDG_STDBY_Pos = 0x12
	// Bit mask of IWDG_STDBY field.
	Flash_OPTR_IWDG_STDBY_Msk = 0x40000
	// Bit IWDG_STDBY.
	Flash_OPTR_IWDG_STDBY = 0x40000
	// Independent watchdog counter frozen in Standby mode
	Flash_OPTR_IWDG_STDBY_Frozen = 0x0
	// Independent watchdog counter running in Standby mode
	Flash_OPTR_IWDG_STDBY_Running = 0x1
	// Position of WWDG_SW field.
	Flash_OPTR_WWDG_SW_Pos = 0x13
	// Bit mask of WWDG_SW field.
	Flash_OPTR_WWDG_SW_Msk = 0x80000
	// Bit WWDG_SW.
	Flash_OPTR_WWDG_SW = 0x80000
	// Hardware window watchdog
	Flash_OPTR_WWDG_SW_Hardware = 0x0
	// Software window watchdog
	Flash_OPTR_WWDG_SW_Software = 0x1
	// Position of NBOOT1 field.
	Flash_OPTR_NBOOT1_Pos = 0x17
	// Bit mask of NBOOT1 field.
	Flash_OPTR_NBOOT1_Msk = 0x800000
	// Bit NBOOT1.
	Flash_OPTR_NBOOT1 = 0x800000
	// When nSWBOOT0 is cleared, select boot mode together with nBOOT0
	Flash_OPTR_NBOOT1_Clear = 0x0
	// When nSWBOOT0 is cleared, select boot mode together with nBOOT0
	Flash_OPTR_NBOOT1_Set = 0x1
	// Position of SRAM2_PE field.
	Flash_OPTR_SRAM2_PE_Pos = 0x18
	// Bit mask of SRAM2_PE field.
	Flash_OPTR_SRAM2_PE_Msk = 0x1000000
	// Bit SRAM2_PE.
	Flash_OPTR_SRAM2_PE = 0x1000000
	// SRAM2 Parity check enabled
	Flash_OPTR_SRAM2_PE_Enabled = 0x0
	// SRAM2 Parity check disabled
	Flash_OPTR_SRAM2_PE_Disabled = 0x1
	// Position of SRAM_RST field.
	Flash_OPTR_SRAM_RST_Pos = 0x19
	// Bit mask of SRAM_RST field.
	Flash_OPTR_SRAM_RST_Msk = 0x2000000
	// Bit SRAM_RST.
	Flash_OPTR_SRAM_RST = 0x2000000
	// SRAM1 and SRAM2 erased when a system reset occurs
	Flash_OPTR_SRAM_RST_Reset = 0x0
	// SRAM1 and SRAM2 not erased when a system reset occurs
	Flash_OPTR_SRAM_RST_NotReset = 0x1
	// Position of NSWBOOT0 field.
	Flash_OPTR_NSWBOOT0_Pos = 0x1a
	// Bit mask of NSWBOOT0 field.
	Flash_OPTR_NSWBOOT0_Msk = 0x4000000
	// Bit NSWBOOT0.
	Flash_OPTR_NSWBOOT0 = 0x4000000
	// BOOT0 taken from nBOOT0 in this register
	Flash_OPTR_NSWBOOT0_Bit = 0x0
	// BOOT0 taken from GPIO PH3/BOOT0
	Flash_OPTR_NSWBOOT0_Pin = 0x1
	// Position of NBOOT0 field.
	Flash_OPTR_NBOOT0_Pos = 0x1b
	// Bit mask of NBOOT0 field.
	Flash_OPTR_NBOOT0_Msk = 0x8000000
	// Bit NBOOT0.
	Flash_OPTR_NBOOT0 = 0x8000000
	// When nSWBOOT0 is cleared, select boot mode together with nBOOT1
	Flash_OPTR_NBOOT0_Clear = 0x0
	// When nSWBOOT0 is cleared, select boot mode together with nBOOT1
	Flash_OPTR_NBOOT0_Set = 0x1
	// Position of BOOT_LOCK field.
	Flash_OPTR_BOOT_LOCK_Pos = 0x1e
	// Bit mask of BOOT_LOCK field.
	Flash_OPTR_BOOT_LOCK_Msk = 0x40000000
	// Bit BOOT_LOCK.
	Flash_OPTR_BOOT_LOCK = 0x40000000
	// Boot lock is disabled
	Flash_OPTR_BOOT_LOCK_Disabled = 0x0
	// Boot lock is enabled
	Flash_OPTR_BOOT_LOCK_Enabled = 0x1
	// Position of C2BOOT_LOCK field.
	Flash_OPTR_C2BOOT_LOCK_Pos = 0x1f
	// Bit mask of C2BOOT_LOCK field.
	Flash_OPTR_C2BOOT_LOCK_Msk = 0x80000000
	// Bit C2BOOT_LOCK.
	Flash_OPTR_C2BOOT_LOCK = 0x80000000

	// PCROP1ASR: Flash PCROP zone A Start address register
	// Position of PCROP1A_STRT field.
	Flash_PCROP1ASR_PCROP1A_STRT_Pos = 0x0
	// Bit mask of PCROP1A_STRT field.
	Flash_PCROP1ASR_PCROP1A_STRT_Msk = 0xff

	// PCROP1AER: Flash PCROP zone A End address register
	// Position of PCROP1A_END field.
	Flash_PCROP1AER_PCROP1A_END_Pos = 0x0
	// Bit mask of PCROP1A_END field.
	Flash_PCROP1AER_PCROP1A_END_Msk = 0xff
	// Position of PCROP_RDP field.
	Flash_PCROP1AER_PCROP_RDP_Pos = 0x1f
	// Bit mask of PCROP_RDP field.
	Flash_PCROP1AER_PCROP_RDP_Msk = 0x80000000
	// Bit PCROP_RDP.
	Flash_PCROP1AER_PCROP_RDP = 0x80000000

	// WRP1AR: Flash WRP area A address register
	// Position of WRP1A_STRT field.
	Flash_WRP1AR_WRP1A_STRT_Pos = 0x0
	// Bit mask of WRP1A_STRT field.
	Flash_WRP1AR_WRP1A_STRT_Msk = 0x7f
	// Position of WRP1A_END field.
	Flash_WRP1AR_WRP1A_END_Pos = 0x10
	// Bit mask of WRP1A_END field.
	Flash_WRP1AR_WRP1A_END_Msk = 0x7f0000

	// WRP1BR: Flash WRP area B address register
	// Position of WRP1B_STRT field.
	Flash_WRP1BR_WRP1B_STRT_Pos = 0x0
	// Bit mask of WRP1B_STRT field.
	Flash_WRP1BR_WRP1B_STRT_Msk = 0x7f
	// Position of WRP1B_END field.
	Flash_WRP1BR_WRP1B_END_Pos = 0x10
	// Bit mask of WRP1B_END field.
	Flash_WRP1BR_WRP1B_END_Msk = 0x7f0000

	// PCROP1BSR: Flash PCROP zone B Start address register
	// Position of PCROP1B_STRT field.
	Flash_PCROP1BSR_PCROP1B_STRT_Pos = 0x0
	// Bit mask of PCROP1B_STRT field.
	Flash_PCROP1BSR_PCROP1B_STRT_Msk = 0xff

	// PCROP1BER: Flash PCROP zone B End address register
	// Position of PCROP1B_END field.
	Flash_PCROP1BER_PCROP1B_END_Pos = 0x0
	// Bit mask of PCROP1B_END field.
	Flash_PCROP1BER_PCROP1B_END_Msk = 0xff

	// IPCCBR: Flash IPCC data buffer address register
	// Position of IPCCDBA field.
	Flash_IPCCBR_IPCCDBA_Pos = 0x0
	// Bit mask of IPCCDBA field.
	Flash_IPCCBR_IPCCDBA_Msk = 0x3fff

	// C2ACR: Flash CPU2 access control register
	// Position of PRFTEN field.
	Flash_C2ACR_PRFTEN_Pos = 0x8
	// Bit mask of PRFTEN field.
	Flash_C2ACR_PRFTEN_Msk = 0x100
	// Bit PRFTEN.
	Flash_C2ACR_PRFTEN = 0x100
	// CPU2 prefetch is disabled
	Flash_C2ACR_PRFTEN_Disabled = 0x0
	// CPU2 prefetch is enabled
	Flash_C2ACR_PRFTEN_Enabled = 0x1
	// Position of ICEN field.
	Flash_C2ACR_ICEN_Pos = 0x9
	// Bit mask of ICEN field.
	Flash_C2ACR_ICEN_Msk = 0x200
	// Bit ICEN.
	Flash_C2ACR_ICEN = 0x200
	// CPU2 instruction cache is disabled
	Flash_C2ACR_ICEN_Disabled = 0x0
	// CPU2 instruction cache is enabled
	Flash_C2ACR_ICEN_Enabled = 0x1
	// Position of ICRST field.
	Flash_C2ACR_ICRST_Pos = 0xb
	// Bit mask of ICRST field.
	Flash_C2ACR_ICRST_Msk = 0x800
	// Bit ICRST.
	Flash_C2ACR_ICRST = 0x800
	// CPU2 instruction cache is not reset
	Flash_C2ACR_ICRST_NotReset = 0x0
	// CPU2 instruction cache is reset
	Flash_C2ACR_ICRST_Reset = 0x1
	// Position of PES field.
	Flash_C2ACR_PES_Pos = 0xf
	// Bit mask of PES field.
	Flash_C2ACR_PES_Msk = 0x8000
	// Bit PES.
	Flash_C2ACR_PES = 0x8000
	// Flash program and erase operations granted
	Flash_C2ACR_PES_Granted = 0x0
	// Any new Flash program and erase operation is suspended until this bit is cleared. The PESD bit in FLASH_C2SR is set when PES bit in FLASH_C2ACR is set
	Flash_C2ACR_PES_Suspended = 0x1

	// C2SR: Flash CPU2 status register
	// Position of EOP field.
	Flash_C2SR_EOP_Pos = 0x0
	// Bit mask of EOP field.
	Flash_C2SR_EOP_Msk = 0x1
	// Bit EOP.
	Flash_C2SR_EOP = 0x1
	// No EOP operation occurred
	Flash_C2SR_EOP_NoEvent = 0x0
	// An EOP event occurred
	Flash_C2SR_EOP_Event = 0x1
	// Clear the flag
	Flash_C2SR_EOP_Clear = 0x1
	// Position of OPERR field.
	Flash_C2SR_OPERR_Pos = 0x1
	// Bit mask of OPERR field.
	Flash_C2SR_OPERR_Msk = 0x2
	// Bit OPERR.
	Flash_C2SR_OPERR = 0x2
	// No memory opreation error happened
	Flash_C2SR_OPERR_NoError = 0x0
	// Memory operation error happened
	Flash_C2SR_OPERR_Error = 0x1
	// Clear the flag
	Flash_C2SR_OPERR_Clear = 0x1
	// Position of PROGERR field.
	Flash_C2SR_PROGERR_Pos = 0x3
	// Bit mask of PROGERR field.
	Flash_C2SR_PROGERR_Msk = 0x8
	// Bit PROGERR.
	Flash_C2SR_PROGERR = 0x8
	// No size programming error happened
	Flash_C2SR_PROGERR_NoError = 0x0
	// Programming error happened
	Flash_C2SR_PROGERR_Error = 0x1
	// Clear the flag
	Flash_C2SR_PROGERR_Clear = 0x1
	// Position of WRPERR field.
	Flash_C2SR_WRPERR_Pos = 0x4
	// Bit mask of WRPERR field.
	Flash_C2SR_WRPERR_Msk = 0x10
	// Bit WRPERR.
	Flash_C2SR_WRPERR = 0x10
	// No write protection error happened
	Flash_C2SR_WRPERR_NoError = 0x0
	// Write protection error happened
	Flash_C2SR_WRPERR_Error = 0x1
	// Clear the flag
	Flash_C2SR_WRPERR_Clear = 0x1
	// Position of PGAERR field.
	Flash_C2SR_PGAERR_Pos = 0x5
	// Bit mask of PGAERR field.
	Flash_C2SR_PGAERR_Msk = 0x20
	// Bit PGAERR.
	Flash_C2SR_PGAERR = 0x20
	// No programming alignment error happened
	Flash_C2SR_PGAERR_NoError = 0x0
	// Programming alignment error happened
	Flash_C2SR_PGAERR_Error = 0x1
	// Clear the flag
	Flash_C2SR_PGAERR_Clear = 0x1
	// Position of SIZERR field.
	Flash_C2SR_SIZERR_Pos = 0x6
	// Bit mask of SIZERR field.
	Flash_C2SR_SIZERR_Msk = 0x40
	// Bit SIZERR.
	Flash_C2SR_SIZERR = 0x40
	// No size error happened
	Flash_C2SR_SIZERR_NoError = 0x0
	// Size error happened
	Flash_C2SR_SIZERR_Error = 0x1
	// Clear the flag
	Flash_C2SR_SIZERR_Clear = 0x1
	// Position of PGSERR field.
	Flash_C2SR_PGSERR_Pos = 0x7
	// Bit mask of PGSERR field.
	Flash_C2SR_PGSERR_Msk = 0x80
	// Bit PGSERR.
	Flash_C2SR_PGSERR = 0x80
	// No fast programming sequence error happened
	Flash_C2SR_PGSERR_NoError = 0x0
	// Fast programming sequence error happened
	Flash_C2SR_PGSERR_Error = 0x1
	// Clear the flag
	Flash_C2SR_PGSERR_Clear = 0x1
	// Position of MISSERR field.
	Flash_C2SR_MISSERR_Pos = 0x8
	// Bit mask of MISSERR field.
	Flash_C2SR_MISSERR_Msk = 0x100
	// Bit MISSERR.
	Flash_C2SR_MISSERR = 0x100
	// No fast programming data miss error happened
	Flash_C2SR_MISSERR_NoError = 0x0
	// Fast programming data miss error happened
	Flash_C2SR_MISSERR_Error = 0x1
	// Clear the flag
	Flash_C2SR_MISSERR_Clear = 0x1
	// Position of FASTERR field.
	Flash_C2SR_FASTERR_Pos = 0x9
	// Bit mask of FASTERR field.
	Flash_C2SR_FASTERR_Msk = 0x200
	// Bit FASTERR.
	Flash_C2SR_FASTERR = 0x200
	// No fast programming error happened
	Flash_C2SR_FASTERR_NoError = 0x0
	// Fast programming error happened
	Flash_C2SR_FASTERR_Error = 0x1
	// Clear the flag
	Flash_C2SR_FASTERR_Clear = 0x1
	// Position of RDERR field.
	Flash_C2SR_RDERR_Pos = 0xe
	// Bit mask of RDERR field.
	Flash_C2SR_RDERR_Msk = 0x4000
	// Bit RDERR.
	Flash_C2SR_RDERR = 0x4000
	// No read-only error happened
	Flash_C2SR_RDERR_NoError = 0x0
	// Read-only error happened
	Flash_C2SR_RDERR_Error = 0x1
	// Clear the flag
	Flash_C2SR_RDERR_Clear = 0x1
	// Position of BSY field.
	Flash_C2SR_BSY_Pos = 0x10
	// Bit mask of BSY field.
	Flash_C2SR_BSY_Msk = 0x10000
	// Bit BSY.
	Flash_C2SR_BSY = 0x10000
	// No write/erase operation is in progress
	Flash_C2SR_BSY_Inactive = 0x0
	// No write/erase operation is in progress
	Flash_C2SR_BSY_Active = 0x1
	// Position of CFGBSY field.
	Flash_C2SR_CFGBSY_Pos = 0x12
	// Bit mask of CFGBSY field.
	Flash_C2SR_CFGBSY_Msk = 0x40000
	// Bit CFGBSY.
	Flash_C2SR_CFGBSY = 0x40000
	// PG, PNB, PER, MER bits available for writing
	Flash_C2SR_CFGBSY_Free = 0x0
	// PG, PNB, PER, MER bits not available for writing (operation ongoing)
	Flash_C2SR_CFGBSY_Busy = 0x1
	// Position of PESD field.
	Flash_C2SR_PESD_Pos = 0x13
	// Bit mask of PESD field.
	Flash_C2SR_PESD_Msk = 0x80000
	// Bit PESD.
	Flash_C2SR_PESD = 0x80000
	// Flash program and erase operations granted
	Flash_C2SR_PESD_Granted = 0x0
	// Any new Flash program and erase operation is suspended until this bit is cleared. This bit is set when at least one PES bit in FLASH_ACR or FLASH_C2ACR is set.
	Flash_C2SR_PESD_Suspended = 0x1

	// C2CR: Flash CPU2 control register
	// Position of PG field.
	Flash_C2CR_PG_Pos = 0x0
	// Bit mask of PG field.
	Flash_C2CR_PG_Msk = 0x1
	// Bit PG.
	Flash_C2CR_PG = 0x1
	// Flash programming disabled
	Flash_C2CR_PG_Disabled = 0x0
	// Flash programming enabled
	Flash_C2CR_PG_Enabled = 0x1
	// Position of PER field.
	Flash_C2CR_PER_Pos = 0x1
	// Bit mask of PER field.
	Flash_C2CR_PER_Msk = 0x2
	// Bit PER.
	Flash_C2CR_PER = 0x2
	// Page erase disabled
	Flash_C2CR_PER_Disabled = 0x0
	// Page erase enabled
	Flash_C2CR_PER_Enabled = 0x1
	// Position of MER field.
	Flash_C2CR_MER_Pos = 0x2
	// Bit mask of MER field.
	Flash_C2CR_MER_Msk = 0x4
	// Bit MER.
	Flash_C2CR_MER = 0x4
	// No mass erase
	Flash_C2CR_MER_NoErase = 0x0
	// Trigger mass erase
	Flash_C2CR_MER_MassErase = 0x1
	// Position of PNB field.
	Flash_C2CR_PNB_Pos = 0x3
	// Bit mask of PNB field.
	Flash_C2CR_PNB_Msk = 0x3f8
	// Position of STRT field.
	Flash_C2CR_STRT_Pos = 0x10
	// Bit mask of STRT field.
	Flash_C2CR_STRT_Msk = 0x10000
	// Bit STRT.
	Flash_C2CR_STRT = 0x10000
	// Options modification completed or idle
	Flash_C2CR_STRT_Done = 0x0
	// Trigger options programming operation
	Flash_C2CR_STRT_Start = 0x1
	// Position of FSTPG field.
	Flash_C2CR_FSTPG_Pos = 0x12
	// Bit mask of FSTPG field.
	Flash_C2CR_FSTPG_Msk = 0x40000
	// Bit FSTPG.
	Flash_C2CR_FSTPG = 0x40000
	// Fast programming disabled
	Flash_C2CR_FSTPG_Disabled = 0x0
	// Fast programming enabled
	Flash_C2CR_FSTPG_Enabled = 0x1
	// Position of EOPIE field.
	Flash_C2CR_EOPIE_Pos = 0x18
	// Bit mask of EOPIE field.
	Flash_C2CR_EOPIE_Msk = 0x1000000
	// Bit EOPIE.
	Flash_C2CR_EOPIE = 0x1000000
	// End of program interrupt disable
	Flash_C2CR_EOPIE_Disabled = 0x0
	// End of program interrupt enable
	Flash_C2CR_EOPIE_Enabled = 0x1
	// Position of ERRIE field.
	Flash_C2CR_ERRIE_Pos = 0x19
	// Bit mask of ERRIE field.
	Flash_C2CR_ERRIE_Msk = 0x2000000
	// Bit ERRIE.
	Flash_C2CR_ERRIE = 0x2000000
	// OPERR Error interrupt disable
	Flash_C2CR_ERRIE_Disabled = 0x0
	// OPERR Error interrupt enable
	Flash_C2CR_ERRIE_Enabled = 0x1
	// Position of RDERRIE field.
	Flash_C2CR_RDERRIE_Pos = 0x1a
	// Bit mask of RDERRIE field.
	Flash_C2CR_RDERRIE_Msk = 0x4000000
	// Bit RDERRIE.
	Flash_C2CR_RDERRIE = 0x4000000
	// PCROP read error interrupt disable
	Flash_C2CR_RDERRIE_Disabled = 0x0
	// PCROP read error interrupt enable
	Flash_C2CR_RDERRIE_Enabled = 0x1

	// SFR: Flash secure Flash start address register
	// Position of SFSA field.
	Flash_SFR_SFSA_Pos = 0x0
	// Bit mask of SFSA field.
	Flash_SFR_SFSA_Msk = 0x7f
	// Position of FSD field.
	Flash_SFR_FSD_Pos = 0x7
	// Bit mask of FSD field.
	Flash_SFR_FSD_Msk = 0x80
	// Bit FSD.
	Flash_SFR_FSD = 0x80
	// System and Flash memory secure
	Flash_SFR_FSD_Secure = 0x0
	// System and Flash memory non-secure
	Flash_SFR_FSD_NonSecure = 0x1
	// Position of DDS field.
	Flash_SFR_DDS_Pos = 0xc
	// Bit mask of DDS field.
	Flash_SFR_DDS_Msk = 0x1000
	// Bit DDS.
	Flash_SFR_DDS = 0x1000
	// CPU2 debug access enabled
	Flash_SFR_DDS_Enabled = 0x0
	// CPU2 debug access disabled
	Flash_SFR_DDS_Disabled = 0x1
	// Position of HDPSA field.
	Flash_SFR_HDPSA_Pos = 0x10
	// Bit mask of HDPSA field.
	Flash_SFR_HDPSA_Msk = 0x7f0000
	// Position of HDPAD field.
	Flash_SFR_HDPAD_Pos = 0x17
	// Bit mask of HDPAD field.
	Flash_SFR_HDPAD_Msk = 0x800000
	// Bit HDPAD.
	Flash_SFR_HDPAD = 0x800000
	// User Flash memory hide protection area enabled. HDPSA[6:0] contains the start address of the first 2-Kbyte page of the user Flash memory hide protection area
	Flash_SFR_HDPAD_Enabled = 0x0
	// User Flash memory hide protection area disabled
	Flash_SFR_HDPAD_Disabled = 0x1
	// Position of SUBGHSPISD field.
	Flash_SFR_SUBGHSPISD_Pos = 0x1f
	// Bit mask of SUBGHSPISD field.
	Flash_SFR_SUBGHSPISD_Msk = 0x80000000
	// Bit SUBGHSPISD.
	Flash_SFR_SUBGHSPISD = 0x80000000
	// sub-GHz radio SPI security enabled
	Flash_SFR_SUBGHSPISD_Enabled = 0x0
	// sub-GHz radio SPI security disabled
	Flash_SFR_SUBGHSPISD_Disabled = 0x1

	// SRRVR: Flash secure SRAM start address and CPU2 reset vector register
	// Position of SBRV field.
	Flash_SRRVR_SBRV_Pos = 0x0
	// Bit mask of SBRV field.
	Flash_SRRVR_SBRV_Msk = 0xffff
	// Position of SBRSA field.
	Flash_SRRVR_SBRSA_Pos = 0x12
	// Bit mask of SBRSA field.
	Flash_SRRVR_SBRSA_Msk = 0x7c0000
	// Position of BRSD field.
	Flash_SRRVR_BRSD_Pos = 0x17
	// Bit mask of BRSD field.
	Flash_SRRVR_BRSD_Msk = 0x800000
	// Bit BRSD.
	Flash_SRRVR_BRSD = 0x800000
	// SRAM2 is secure. SNBRSA[4:0] contains the start address of the first 1-Kbyte page of the secure backup SRAM2 area
	Flash_SRRVR_BRSD_Secure = 0x0
	// SRAM2 is non-secure
	Flash_SRRVR_BRSD_NonSecure = 0x1
	// Position of SNBRSA field.
	Flash_SRRVR_SNBRSA_Pos = 0x19
	// Bit mask of SNBRSA field.
	Flash_SRRVR_SNBRSA_Msk = 0x3e000000
	// Position of NBRSD field.
	Flash_SRRVR_NBRSD_Pos = 0x1e
	// Bit mask of NBRSD field.
	Flash_SRRVR_NBRSD_Msk = 0x40000000
	// Bit NBRSD.
	Flash_SRRVR_NBRSD = 0x40000000
	// SRAM1 is secure. SNBRSA[4:0] contains the start address of the first 1-Kbyte page of the secure non-backup SRAM1 area
	Flash_SRRVR_NBRSD_Secure = 0x0
	// SRAM1 is non-secure
	Flash_SRRVR_NBRSD_NonSecure = 0x1
	// Position of C2OPT field.
	Flash_SRRVR_C2OPT_Pos = 0x1f
	// Bit mask of C2OPT field.
	Flash_SRRVR_C2OPT_Msk = 0x80000000
	// Bit C2OPT.
	Flash_SRRVR_C2OPT = 0x80000000
	// SBRV offset addresses SRAM1 or SRAM2, from start address 0x2000_0000 + SBRV
	Flash_SRRVR_C2OPT_SRAM = 0x0
	// SBRV offset addresses the Flash memory, from start address 0x0800_0000 + SBRV
	Flash_SRRVR_C2OPT_Flash = 0x1
)

// Constants for GPIOA: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	// Position of MODER15 field.
	GPIO_MODER_MODER15_Pos = 0x1e
	// Bit mask of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000
	// Input mode (reset state)
	GPIO_MODER_MODER15_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER15_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER15_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER15_Analog = 0x3
	// Position of MODER14 field.
	GPIO_MODER_MODER14_Pos = 0x1c
	// Bit mask of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000
	// Input mode (reset state)
	GPIO_MODER_MODER14_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER14_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER14_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER14_Analog = 0x3
	// Position of MODER13 field.
	GPIO_MODER_MODER13_Pos = 0x1a
	// Bit mask of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000
	// Input mode (reset state)
	GPIO_MODER_MODER13_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER13_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER13_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER13_Analog = 0x3
	// Position of MODER12 field.
	GPIO_MODER_MODER12_Pos = 0x18
	// Bit mask of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000
	// Input mode (reset state)
	GPIO_MODER_MODER12_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER12_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER12_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER12_Analog = 0x3
	// Position of MODER11 field.
	GPIO_MODER_MODER11_Pos = 0x16
	// Bit mask of MO