/* Utils.c generated by valac 0.56.0, the Vala compiler
 * generated from Utils.vala, do not modify */

/*
 * Copyright (c) 2011-2015 Wingpanel Developers (http://launchpad.net/wingpanel)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */
/*
 *   The method for calculating the background information and the classes that are
 *   related to it are copied from Gala.DBus.
 */

#include <glib.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include <glib-object.h>
#include "wingpanel-interface.h"
#include <string.h>
#include <gio/gio.h>
#include <gala.h>
#include <meta/meta-background-group.h>
#include <stdlib.h>
#include <cogl/cogl.h>

#define WINGPANEL_INTERFACE_UTILS_SATURATION_WEIGHT 1.5
#define WINGPANEL_INTERFACE_UTILS_WEIGHT_THRESHOLD 1.0

#define WINGPANEL_INTERFACE_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT (wingpanel_interface_utils_dummy_offscreen_effect_get_type ())
#define WINGPANEL_INTERFACE_UTILS_DUMMY_OFFSCREEN_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WINGPANEL_INTERFACE_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT, WingpanelInterfaceUtilsDummyOffscreenEffect))
#define WINGPANEL_INTERFACE_UTILS_DUMMY_OFFSCREEN_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WINGPANEL_INTERFACE_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT, WingpanelInterfaceUtilsDummyOffscreenEffectClass))
#define WINGPANEL_INTERFACE_UTILS_IS_DUMMY_OFFSCREEN_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WINGPANEL_INTERFACE_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT))
#define WINGPANEL_INTERFACE_UTILS_IS_DUMMY_OFFSCREEN_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WINGPANEL_INTERFACE_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT))
#define WINGPANEL_INTERFACE_UTILS_DUMMY_OFFSCREEN_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WINGPANEL_INTERFACE_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT, WingpanelInterfaceUtilsDummyOffscreenEffectClass))

typedef struct _WingpanelInterfaceUtilsDummyOffscreenEffect WingpanelInterfaceUtilsDummyOffscreenEffect;
typedef struct _WingpanelInterfaceUtilsDummyOffscreenEffectClass WingpanelInterfaceUtilsDummyOffscreenEffectClass;
typedef struct _WingpanelInterfaceUtilsDummyOffscreenEffectPrivate WingpanelInterfaceUtilsDummyOffscreenEffectPrivate;
enum  {
	WINGPANEL_INTERFACE_UTILS_DUMMY_OFFSCREEN_EFFECT_0_PROPERTY,
	WINGPANEL_INTERFACE_UTILS_DUMMY_OFFSCREEN_EFFECT_NUM_PROPERTIES
};
static GParamSpec* wingpanel_interface_utils_dummy_offscreen_effect_properties[WINGPANEL_INTERFACE_UTILS_DUMMY_OFFSCREEN_EFFECT_NUM_PROPERTIES];
enum  {
	WINGPANEL_INTERFACE_UTILS_DUMMY_OFFSCREEN_EFFECT_DONE_PAINTING_SIGNAL,
	WINGPANEL_INTERFACE_UTILS_DUMMY_OFFSCREEN_EFFECT_NUM_SIGNALS
};
static guint wingpanel_interface_utils_dummy_offscreen_effect_signals[WINGPANEL_INTERFACE_UTILS_DUMMY_OFFSCREEN_EFFECT_NUM_SIGNALS] = {0};
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cogl_object_unref0(var) ((var == NULL) ? NULL : (var = (cogl_object_unref (var), NULL)))
typedef struct _WingpanelInterfaceUtilsGetBackgroundColorInformationData WingpanelInterfaceUtilsGetBackgroundColorInformationData;

struct _WingpanelInterfaceUtilsDummyOffscreenEffect {
	ClutterOffscreenEffect parent_instance;
	WingpanelInterfaceUtilsDummyOffscreenEffectPrivate * priv;
};

struct _WingpanelInterfaceUtilsDummyOffscreenEffectClass {
	ClutterOffscreenEffectClass parent_class;
};

struct _Block3Data {
	int _ref_count_;
	ClutterActor* background;
	WingpanelInterfaceUtilsDummyOffscreenEffect* effect;
	gint x_start;
	gint y_start;
	gint width;
	gint height;
	gdouble mean_acutance;
	gdouble variance;
	gdouble mean;
	gdouble r_total;
	gdouble g_total;
	gdouble b_total;
	gulong paint_signal_handler;
	gpointer _async_data_;
};

struct _WingpanelInterfaceUtilsGetBackgroundColorInformationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GalaWindowManager* wm;
	gint monitor;
	gint reference_x;
	gint reference_y;
	gint reference_width;
	gint reference_height;
	WingpanelInterfaceUtilsColorInformation result;
	Block3Data* _data3_;
	MetaBackgroundGroup* _tmp0_;
	MetaBackgroundGroup* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	ClutterActor* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	WingpanelInterfaceUtilsDummyOffscreenEffect* _tmp9_;
	ClutterActor* _tmp10_;
	WingpanelInterfaceUtilsDummyOffscreenEffect* _tmp11_;
	gint bg_actor_width;
	ClutterActor* _tmp12_;
	gfloat _tmp13_;
	gfloat _tmp14_;
	gint bg_actor_height;
	ClutterActor* _tmp15_;
	gfloat _tmp16_;
	gfloat _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GError* _tmp23_;
	GError* _tmp24_;
	WingpanelInterfaceUtilsDummyOffscreenEffect* _tmp25_;
	gulong _tmp26_;
	ClutterActor* _tmp27_;
	WingpanelInterfaceUtilsColorInformation _tmp28_;
	GError* _inner_error0_;
};

static gpointer wingpanel_interface_utils_dummy_offscreen_effect_parent_class = NULL;

VALA_EXTERN GType wingpanel_interface_utils_dummy_offscreen_effect_get_type (void) G_GNUC_CONST ;
static void wingpanel_interface_utils_dummy_offscreen_effect_real_post_paint (ClutterEffect* base,
                                                                       ClutterPaintNode* node,
                                                                       ClutterPaintContext* context);
static gboolean __lambda9_ (WingpanelInterfaceUtilsDummyOffscreenEffect* self);
static gboolean ___lambda9__gsource_func (gpointer self);
VALA_EXTERN WingpanelInterfaceUtilsDummyOffscreenEffect* wingpanel_interface_utils_dummy_offscreen_effect_new (void);
VALA_EXTERN WingpanelInterfaceUtilsDummyOffscreenEffect* wingpanel_interface_utils_dummy_offscreen_effect_construct (GType object_type);
static GType wingpanel_interface_utils_dummy_offscreen_effect_get_type_once (void);
static void wingpanel_interface_utils_get_background_color_information_data_free (gpointer _data);
static gboolean wingpanel_interface_utils_get_background_color_information_co (WingpanelInterfaceUtilsGetBackgroundColorInformationData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda10_ (Block3Data* _data3_);
static void ___lambda10__wingpanel_interface_utils_dummy_offscreen_effect_done_painting (WingpanelInterfaceUtilsDummyOffscreenEffect* _sender,
                                                                                  gpointer self);

static gboolean
__lambda9_ (WingpanelInterfaceUtilsDummyOffscreenEffect* self)
{
	gboolean result;
	g_signal_emit (self, wingpanel_interface_utils_dummy_offscreen_effect_signals[WINGPANEL_INTERFACE_UTILS_DUMMY_OFFSCREEN_EFFECT_DONE_PAINTING_SIGNAL], 0);
	result = FALSE;
	return result;
}

static gboolean
___lambda9__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda9_ ((WingpanelInterfaceUtilsDummyOffscreenEffect*) self);
	return result;
}

static void
wingpanel_interface_utils_dummy_offscreen_effect_real_post_paint (ClutterEffect* base,
                                                                  ClutterPaintNode* node,
                                                                  ClutterPaintContext* context)
{
	WingpanelInterfaceUtilsDummyOffscreenEffect * self;
	self = (WingpanelInterfaceUtilsDummyOffscreenEffect*) base;
	g_return_if_fail (node != NULL);
	g_return_if_fail (context != NULL);
	CLUTTER_EFFECT_CLASS (wingpanel_interface_utils_dummy_offscreen_effect_parent_class)->post_paint ((ClutterEffect*) G_TYPE_CHECK_INSTANCE_CAST (self, clutter_offscreen_effect_get_type (), ClutterOffscreenEffect), node, context);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda9__gsource_func, g_object_ref (self), g_object_unref);
}

WingpanelInterfaceUtilsDummyOffscreenEffect*
wingpanel_interface_utils_dummy_offscreen_effect_construct (GType object_type)
{
	WingpanelInterfaceUtilsDummyOffscreenEffect * self = NULL;
	self = (WingpanelInterfaceUtilsDummyOffscreenEffect*) g_object_new (object_type, NULL);
	return self;
}

WingpanelInterfaceUtilsDummyOffscreenEffect*
wingpanel_interface_utils_dummy_offscreen_effect_new (void)
{
	return wingpanel_interface_utils_dummy_offscreen_effect_construct (WINGPANEL_INTERFACE_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT);
}

static void
wingpanel_interface_utils_dummy_offscreen_effect_class_init (WingpanelInterfaceUtilsDummyOffscreenEffectClass * klass,
                                                             gpointer klass_data)
{
	wingpanel_interface_utils_dummy_offscreen_effect_parent_class = g_type_class_peek_parent (klass);
	((ClutterEffectClass *) klass)->post_paint = (void (*) (ClutterEffect*, ClutterPaintNode*, ClutterPaintContext*)) wingpanel_interface_utils_dummy_offscreen_effect_real_post_paint;
	wingpanel_interface_utils_dummy_offscreen_effect_signals[WINGPANEL_INTERFACE_UTILS_DUMMY_OFFSCREEN_EFFECT_DONE_PAINTING_SIGNAL] = g_signal_new ("done-painting", WINGPANEL_INTERFACE_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
wingpanel_interface_utils_dummy_offscreen_effect_instance_init (WingpanelInterfaceUtilsDummyOffscreenEffect * self,
                                                                gpointer klass)
{
}

static GType
wingpanel_interface_utils_dummy_offscreen_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WingpanelInterfaceUtilsDummyOffscreenEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wingpanel_interface_utils_dummy_offscreen_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WingpanelInterfaceUtilsDummyOffscreenEffect), 0, (GInstanceInitFunc) wingpanel_interface_utils_dummy_offscreen_effect_instance_init, NULL };
	GType wingpanel_interface_utils_dummy_offscreen_effect_type_id;
	wingpanel_interface_utils_dummy_offscreen_effect_type_id = g_type_register_static (clutter_offscreen_effect_get_type (), "WingpanelInterfaceUtilsDummyOffscreenEffect", &g_define_type_info, 0);
	return wingpanel_interface_utils_dummy_offscreen_effect_type_id;
}

GType
wingpanel_interface_utils_dummy_offscreen_effect_get_type (void)
{
	static volatile gsize wingpanel_interface_utils_dummy_offscreen_effect_type_id__once = 0;
	if (g_once_init_enter (&wingpanel_interface_utils_dummy_offscreen_effect_type_id__once)) {
		GType wingpanel_interface_utils_dummy_offscreen_effect_type_id;
		wingpanel_interface_utils_dummy_offscreen_effect_type_id = wingpanel_interface_utils_dummy_offscreen_effect_get_type_once ();
		g_once_init_leave (&wingpanel_interface_utils_dummy_offscreen_effect_type_id__once, wingpanel_interface_utils_dummy_offscreen_effect_type_id);
	}
	return wingpanel_interface_utils_dummy_offscreen_effect_type_id__once;
}

WingpanelInterfaceUtilsColorInformation*
wingpanel_interface_utils_color_information_dup (const WingpanelInterfaceUtilsColorInformation* self)
{
	WingpanelInterfaceUtilsColorInformation* dup;
	dup = g_new0 (WingpanelInterfaceUtilsColorInformation, 1);
	memcpy (dup, self, sizeof (WingpanelInterfaceUtilsColorInformation));
	return dup;
}

void
wingpanel_interface_utils_color_information_free (WingpanelInterfaceUtilsColorInformation* self)
{
	g_free (self);
}

static GType
wingpanel_interface_utils_color_information_get_type_once (void)
{
	GType wingpanel_interface_utils_color_information_type_id;
	wingpanel_interface_utils_color_information_type_id = g_boxed_type_register_static ("WingpanelInterfaceUtilsColorInformation", (GBoxedCopyFunc) wingpanel_interface_utils_color_information_dup, (GBoxedFreeFunc) wingpanel_interface_utils_color_information_free);
	return wingpanel_interface_utils_color_information_type_id;
}

GType
wingpanel_interface_utils_color_information_get_type (void)
{
	static volatile gsize wingpanel_interface_utils_color_information_type_id__once = 0;
	if (g_once_init_enter (&wingpanel_interface_utils_color_information_type_id__once)) {
		GType wingpanel_interface_utils_color_information_type_id;
		wingpanel_interface_utils_color_information_type_id = wingpanel_interface_utils_color_information_get_type_once ();
		g_once_init_leave (&wingpanel_interface_utils_color_information_type_id__once, wingpanel_interface_utils_color_information_type_id);
	}
	return wingpanel_interface_utils_color_information_type_id__once;
}

static void
wingpanel_interface_utils_get_background_color_information_data_free (gpointer _data)
{
	WingpanelInterfaceUtilsGetBackgroundColorInformationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->wm);
	g_slice_free (WingpanelInterfaceUtilsGetBackgroundColorInformationData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
wingpanel_interface_utils_get_background_color_information (GalaWindowManager* wm,
                                                            gint monitor,
                                                            gint reference_x,
                                                            gint reference_y,
                                                            gint reference_width,
                                                            gint reference_height,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	WingpanelInterfaceUtilsGetBackgroundColorInformationData* _data_;
	GalaWindowManager* _tmp0_;
	g_return_if_fail (wm != NULL);
	_data_ = g_slice_new0 (WingpanelInterfaceUtilsGetBackgroundColorInformationData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, wingpanel_interface_utils_get_background_color_information_data_free);
	_tmp0_ = _g_object_ref0 (wm);
	_g_object_unref0 (_data_->wm);
	_data_->wm = _tmp0_;
	_data_->monitor = monitor;
	_data_->reference_x = reference_x;
	_data_->reference_y = reference_y;
	_data_->reference_width = reference_width;
	_data_->reference_height = reference_height;
	wingpanel_interface_utils_get_background_color_information_co (_data_);
}

void
wingpanel_interface_utils_get_background_color_information_finish (GAsyncResult* _res_,
                                                                   WingpanelInterfaceUtilsColorInformation* result,
                                                                   GError** error)
{
	WingpanelInterfaceUtilsGetBackgroundColorInformationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	*result = _data_->result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->effect);
		_g_object_unref0 (_data3_->background);
		g_slice_free (Block3Data, _data3_);
	}
}

static gpointer
_cogl_object_ref0 (gpointer self)
{
	return self ? cogl_object_ref (self) : NULL;
}

static void
__lambda10_ (Block3Data* _data3_)
{
	WingpanelInterfaceUtilsDummyOffscreenEffect* _tmp0_;
	ClutterActor* _tmp1_;
	WingpanelInterfaceUtilsDummyOffscreenEffect* _tmp2_;
	CoglTexture* texture = NULL;
	WingpanelInterfaceUtilsDummyOffscreenEffect* _tmp3_;
	CoglHandle* _tmp4_;
	CoglTexture* _tmp5_;
	guint texture_width = 0U;
	CoglTexture* _tmp6_;
	guint texture_height = 0U;
	CoglTexture* _tmp7_;
	guint8* pixels = NULL;
	guint8* _tmp8_;
	gint pixels_length1;
	gint _pixels_size_;
	gdouble* pixel_lums = NULL;
	gdouble* _tmp9_;
	gint pixel_lums_length1;
	gint _pixel_lums_size_;
	CoglTexture* _tmp10_;
	guint8* _tmp11_;
	gint _tmp11__length1;
	gint size = 0;
	gdouble mean_squares = 0.0;
	gdouble pixel = 0.0;
	gdouble max = 0.0;
	gdouble min = 0.0;
	gdouble score = 0.0;
	gdouble delta = 0.0;
	gdouble score_total = 0.0;
	gdouble r_total2 = 0.0;
	gdouble g_total2 = 0.0;
	gdouble b_total2 = 0.0;
	gdouble max_val = 0.0;
	_tmp0_ = _data3_->effect;
	g_signal_handler_disconnect (_tmp0_, _data3_->paint_signal_handler);
	_tmp1_ = _data3_->background;
	_tmp2_ = _data3_->effect;
	clutter_actor_remove_effect (_tmp1_, (ClutterEffect*) _tmp2_);
	_tmp3_ = _data3_->effect;
	_tmp4_ = clutter_offscreen_effect_get_texture ((ClutterOffscreenEffect*) _tmp3_);
	_tmp5_ = _cogl_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, cogl_texture_get_gtype (), CoglTexture));
	texture = _tmp5_;
	_tmp6_ = texture;
	texture_width = cogl_texture_get_width (_tmp6_);
	_tmp7_ = texture;
	texture_height = cogl_texture_get_height (_tmp7_);
	_tmp8_ = g_new0 (guint8, (texture_width * texture_height) * 4);
	pixels = _tmp8_;
	pixels_length1 = (texture_width * texture_height) * 4;
	_pixels_size_ = pixels_length1;
	_tmp9_ = g_new0 (gdouble, texture_width * texture_height);
	pixel_lums = _tmp9_;
	pixel_lums_length1 = texture_width * texture_height;
	_pixel_lums_size_ = pixel_lums_length1;
	_tmp10_ = texture;
	_tmp11_ = pixels;
	_tmp11__length1 = pixels_length1;
	cogl_texture_get_data (_tmp10_, COGL_PIXEL_FORMAT_BGRA_8888_PRE, (guint) 0, _tmp11_);
	size = _data3_->width * _data3_->height;
	mean_squares = (gdouble) 0;
	pixel = (gdouble) 0;
	score_total = (gdouble) 0;
	r_total2 = (gdouble) 0;
	g_total2 = (gdouble) 0;
	b_total2 = (gdouble) 0;
	{
		gint y = 0;
		y = _data3_->y_start;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = y;
					y = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				if (!(y < (_data3_->y_start + _data3_->height))) {
					break;
				}
				{
					gint x = 0;
					x = _data3_->x_start;
					{
						gboolean _tmp14_ = FALSE;
						_tmp14_ = TRUE;
						while (TRUE) {
							gint i = 0;
							guint8 b = 0U;
							guint8* _tmp16_;
							gint _tmp16__length1;
							guint8 _tmp17_;
							guint8 g = 0U;
							guint8* _tmp18_;
							gint _tmp18__length1;
							guint8 _tmp19_;
							guint8 r = 0U;
							guint8* _tmp20_;
							gint _tmp20__length1;
							guint8 _tmp21_;
							gdouble* _tmp22_;
							gint _tmp22__length1;
							gdouble _tmp23_ = 0.0;
							if (!_tmp14_) {
								gint _tmp15_;
								_tmp15_ = x;
								x = _tmp15_ + 1;
							}
							_tmp14_ = FALSE;
							if (!(x < (_data3_->x_start + _data3_->width))) {
								break;
							}
							i = ((y * ((gint) texture_width)) * 4) + (x * 4);
							_tmp16_ = pixels;
							_tmp16__length1 = pixels_length1;
							_tmp17_ = _tmp16_[i];
							b = _tmp17_;
							_tmp18_ = pixels;
							_tmp18__length1 = pixels_length1;
							_tmp19_ = _tmp18_[i + 1];
							g = _tmp19_;
							_tmp20_ = pixels;
							_tmp20__length1 = pixels_length1;
							_tmp21_ = _tmp20_[i + 2];
							r = _tmp21_;
							pixel = ((0.3 * r) + (0.59 * g)) + (0.11 * b);
							_tmp22_ = pixel_lums;
							_tmp22__length1 = pixel_lums_length1;
							_tmp22_[(y * _data3_->width) + x] = pixel;
							min = (gdouble) MIN (r, MIN (g, b));
							max = (gdouble) MAX (r, MAX (g, b));
							delta = max - min;
							if (delta == ((gdouble) 0)) {
								_tmp23_ = 0.0;
							} else {
								_tmp23_ = delta / max;
							}
							score = WINGPANEL_INTERFACE_UTILS_SATURATION_WEIGHT * _tmp23_;
							_data3_->r_total += score * r;
							_data3_->g_total += score * g;
							_data3_->b_total += score * b;
							score_total += score;
							_data3_->r_total += (gdouble) r;
							_data3_->g_total += (gdouble) g;
							_data3_->b_total += (gdouble) b;
							_data3_->mean += pixel;
							mean_squares += pixel * pixel;
						}
					}
				}
			}
		}
	}
	{
		gint y = 0;
		y = _data3_->y_start + 1;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = y;
					y = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(y < ((_data3_->y_start + _data3_->height) - 1))) {
					break;
				}
				{
					gint x = 0;
					x = _data3_->x_start + 1;
					{
						gboolean _tmp26_ = FALSE;
						_tmp26_ = TRUE;
						while (TRUE) {
							gdouble acutance = 0.0;
							gdouble* _tmp28_;
							gint _tmp28__length1;
							gdouble _tmp29_;
							gdouble* _tmp30_;
							gint _tmp30__length1;
							gdouble _tmp31_;
							gdouble* _tmp32_;
							gint _tmp32__length1;
							gdouble _tmp33_;
							gdouble* _tmp34_;
							gint _tmp34__length1;
							gdouble _tmp35_;
							gdouble* _tmp36_;
							gint _tmp36__length1;
							gdouble _tmp37_;
							gdouble _tmp38_ = 0.0;
							if (!_tmp26_) {
								gint _tmp27_;
								_tmp27_ = x;
								x = _tmp27_ + 1;
							}
							_tmp26_ = FALSE;
							if (!(x < ((_data3_->x_start + _data3_->width) - 1))) {
								break;
							}
							_tmp28_ = pixel_lums;
							_tmp28__length1 = pixel_lums_length1;
							_tmp29_ = _tmp28_[(y * _data3_->width) + x];
							_tmp30_ = pixel_lums;
							_tmp30__length1 = pixel_lums_length1;
							_tmp31_ = _tmp30_[((y * _data3_->width) + x) - 1];
							_tmp32_ = pixel_lums;
							_tmp32__length1 = pixel_lums_length1;
							_tmp33_ = _tmp32_[((y * _data3_->width) + x) + 1];
							_tmp34_ = pixel_lums;
							_tmp34__length1 = pixel_lums_length1;
							_tmp35_ = _tmp34_[((y - 1) * _data3_->width) + x];
							_tmp36_ = pixel_lums;
							_tmp36__length1 = pixel_lums_length1;
							_tmp37_ = _tmp36_[((y + 1) * _data3_->width) + x];
							acutance = (_tmp29_ * 4) - (((_tmp31_ + _tmp33_) + _tmp35_) + _tmp37_);
							if (acutance > ((gdouble) 0)) {
								_tmp38_ = acutance;
							} else {
								_tmp38_ = -acutance;
							}
							_data3_->mean_acutance += _tmp38_;
						}
					}
				}
			}
		}
	}
	score_total /= (gdouble) size;
	_data3_->b_total /= (gdouble) size;
	_data3_->g_total /= (gdouble) size;
	_data3_->r_total /= (gdouble) size;
	if (score_total > 0.0) {
		_data3_->b_total /= score_total;
		_data3_->g_total /= score_total;
		_data3_->r_total /= score_total;
	}
	b_total2 /= (gdouble) (size * G_MAXUINT8);
	g_total2 /= (gdouble) (size * G_MAXUINT8);
	r_total2 /= (gdouble) (size * G_MAXUINT8);
	if (score_total <= WINGPANEL_INTERFACE_UTILS_WEIGHT_THRESHOLD) {
		gdouble f = 0.0;
		gdouble rf = 0.0;
		f = (1.0 / WINGPANEL_INTERFACE_UTILS_WEIGHT_THRESHOLD) * score_total;
		rf = 1.0 - f;
		_data3_->b_total = (_data3_->b_total * f) + (b_total2 * rf);
		_data3_->g_total = (_data3_->g_total * f) + (g_total2 * rf);
		_data3_->r_total = (_data3_->r_total * f) + (r_total2 * rf);
	}
	max_val = MAX (_data3_->r_total, MAX (_data3_->g_total, _data3_->b_total));
	if (max_val > 1.0) {
		_data3_->b_total /= max_val;
		_data3_->g_total /= max_val;
		_data3_->r_total /= max_val;
	}
	_data3_->mean /= (gdouble) size;
	mean_squares = mean_squares / size;
	_data3_->variance = mean_squares - (_data3_->mean * _data3_->mean);
	_data3_->mean_acutance /= (gdouble) ((_data3_->width - 2) * (_data3_->height - 2));
	wingpanel_interface_utils_get_background_color_information_co (_data3_->_async_data_);
	pixel_lums = (g_free (pixel_lums), NULL);
	pixels = (g_free (pixels), NULL);
	_cogl_object_unref0 (texture);
}

static void
___lambda10__wingpanel_interface_utils_dummy_offscreen_effect_done_painting (WingpanelInterfaceUtilsDummyOffscreenEffect* _sender,
                                                                             gpointer self)
{
	__lambda10_ (self);
}

static gboolean
wingpanel_interface_utils_get_background_color_information_co (WingpanelInterfaceUtilsGetBackgroundColorInformationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->_async_data_ = _data_;
	_data_->_tmp0_ = gala_window_manager_get_background_group (_data_->wm);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = clutter_actor_get_child_at_index ((ClutterActor*) _data_->_tmp1_, _data_->monitor);
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
	_data_->_data3_->background = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->_data3_->background;
	if (_data_->_tmp4_ == NULL) {
		_data_->_tmp5_ = g_strdup_printf ("Invalid monitor requested: %i", _data_->monitor);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, _data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_g_free0 (_data_->_tmp6_);
		_data_->_inner_error0_ = _data_->_tmp8_;
		if (_data_->_inner_error0_->domain == G_DBUS_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp9_ = wingpanel_interface_utils_dummy_offscreen_effect_new ();
	g_object_ref_sink (_data_->_tmp9_);
	_data_->_data3_->effect = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->_data3_->background;
	_data_->_tmp11_ = _data_->_data3_->effect;
	clutter_actor_add_effect (_data_->_tmp10_, (ClutterEffect*) _data_->_tmp11_);
	_data_->_tmp12_ = _data_->_data3_->background;
	_data_->_tmp13_ = clutter_actor_get_width (_data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->bg_actor_width = (gint) _data_->_tmp14_;
	_data_->_tmp15_ = _data_->_data3_->background;
	_data_->_tmp16_ = clutter_actor_get_height (_data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	_data_->bg_actor_height = (gint) _data_->_tmp17_;
	_data_->_data3_->x_start = _data_->reference_x;
	if (_data_->_data3_->x_start < 2) {
		_data_->_data3_->x_start = 2;
	}
	_data_->_data3_->y_start = _data_->reference_y;
	if (_data_->_data3_->y_start < 2) {
		_data_->_data3_->y_start = 2;
	}
	_data_->_data3_->width = MIN ((_data_->bg_actor_width - 2) - _data_->reference_x, _data_->reference_width);
	_data_->_data3_->height = MIN ((_data_->bg_actor_height - 2) - _data_->reference_y, _data_->reference_height);
	if (_data_->_data3_->x_start > _data_->bg_actor_width) {
		_data_->_tmp20_ = TRUE;
	} else {
		_data_->_tmp20_ = _data_->_data3_->y_start > _data_->bg_actor_height;
	}
	if (_data_->_tmp20_) {
		_data_->_tmp19_ = TRUE;
	} else {
		_data_->_tmp19_ = _data_->_data3_->width <= 0;
	}
	if (_data_->_tmp19_) {
		_data_->_tmp18_ = TRUE;
	} else {
		_data_->_tmp18_ = _data_->_data3_->height <= 0;
	}
	if (_data_->_tmp18_) {
		_data_->_tmp21_ = g_strdup_printf ("Invalid rectangle specified: %i, %i, %i, %i", _data_->_data3_->x_start, _data_->_data3_->y_start, _data_->_data3_->width, _data_->_data3_->height);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, _data_->_tmp22_);
		_data_->_tmp24_ = _data_->_tmp23_;
		_g_free0 (_data_->_tmp22_);
		_data_->_inner_error0_ = _data_->_tmp24_;
		if (_data_->_inner_error0_->domain == G_DBUS_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_data3_->mean_acutance = (gdouble) 0;
	_data_->_data3_->variance = (gdouble) 0;
	_data_->_data3_->mean = (gdouble) 0;
	_data_->_data3_->r_total = (gdouble) 0;
	_data_->_data3_->g_total = (gdouble) 0;
	_data_->_data3_->b_total = (gdouble) 0;
	_data_->_data3_->paint_signal_handler = (gulong) 0;
	_data_->_tmp25_ = _data_->_data3_->effect;
	_data_->_tmp26_ = g_signal_connect_data (_data_->_tmp25_, "done-painting", (GCallback) ___lambda10__wingpanel_interface_utils_dummy_offscreen_effect_done_painting, block3_data_ref (_data_->_data3_), (GClosureNotify) block3_data_unref, 0);
	_data_->_data3_->paint_signal_handler = _data_->_tmp26_;
	_data_->_tmp27_ = _data_->_data3_->background;
	clutter_actor_queue_redraw (_data_->_tmp27_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	memset (&_data_->_tmp28_, 0, sizeof (WingpanelInterfaceUtilsColorInformation));
	_data_->_tmp28_.average_red = _data_->_data3_->r_total;
	_data_->_tmp28_.average_green = _data_->_data3_->g_total;
	_data_->_tmp28_.average_blue = _data_->_data3_->b_total;
	_data_->_tmp28_.mean_luminance = _data_->_data3_->mean;
	_data_->_tmp28_.luminance_variance = _data_->_data3_->variance;
	_data_->_tmp28_.mean_acutance = _data_->_data3_->mean_acutance;
	_data_->result = _data_->_tmp28_;
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

