/* number.c generated by valac 0.56.0, the Vala compiler
 * generated from number.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/*  This maths library is based on the MP multi-precision floating-point
 *  arithmetic package originally written in FORTRAN by Richard Brent,
 *  Computer Centre, Australian National University in the 1970's.
 *
 *  It has been converted from FORTRAN into C using the freely available
 *  f2c translator, available via netlib on research.att.com.
 *
 *  The subsequently converted C code has then been tidied up, mainly to
 *  remove any dependencies on the libI77 and libF77 support libraries.
 *
 *  FOR A GENERAL DESCRIPTION OF THE PHILOSOPHY AND DESIGN OF MP,
 *  SEE - R. P. BRENT, A FORTRAN MULTIPLE-PRECISION ARITHMETIC
 *  SOME ADDITIONAL DETAILS ARE GIVEN IN THE SAME ISSUE, 71-81.
 *  FOR DETAILS OF THE IMPLEMENTATION, CALLING SEQUENCES ETC. SEE
 *  THE MP USERS GUIDE.
 */

#include <glib.h>
#include "calculator.h"
#include "mpc.h"
#include "mpfr.h"
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include "mpfrg.h"
#include <glib/gi18n-lib.h>

typedef gint (*BitwiseFunc) (gint v1, gint v2, gpointer user_data);
enum  {
	NUMBER_0_PROPERTY,
	NUMBER_NUM_PROPERTIES
};
static GParamSpec* number_properties[NUMBER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _NumberPrivate {
	__mpc_struct num;
};

static gint Number_private_offset;
static gpointer number_parent_class = NULL;
static mpfr_prec_t number__precision;
static mpfr_prec_t number__precision = (mpfr_prec_t) 1000;
static gchar* number__error;
static gchar* number__error = NULL;

static void number_mpc_from_radians (__mpc_struct* res,
                              __mpc_struct* op,
                              AngleUnit unit);
static Number* number_copy (Number* self);
static void number_mpc_to_radians (__mpc_struct* res,
                            __mpc_struct* op,
                            AngleUnit unit);
static Number* number_to_radians (Number* self,
                           AngleUnit unit);
static Number* number_bitwise (Number* self,
                        Number* y,
                        BitwiseFunc bitwise_operator,
                        gpointer bitwise_operator_target,
                        gint wordlen);
static gint __lambda4_ (Number* self,
                 gint v1,
                 gint v2);
static gint ___lambda4__bitwise_func (gint v1,
                               gint v2,
                               gpointer self);
static gint __lambda5_ (Number* self,
                 gint v1,
                 gint v2);
static gint ___lambda5__bitwise_func (gint v1,
                               gint v2,
                               gpointer self);
static gint __lambda6_ (Number* self,
                 gint v1,
                 gint v2);
static gint ___lambda6__bitwise_func (gint v1,
                               gint v2,
                               gpointer self);
static gint __lambda7_ (Number* self,
                 gint v1,
                 gint v2);
static gint ___lambda7__bitwise_func (gint v1,
                               gint v2,
                               gpointer self);
static gchar* number_to_hex_string (Number* self);
static gint __lambda8_ (Number* self,
                 gint v1,
                 gint v2);
static gint ___lambda8__bitwise_func (gint v1,
                               gint v2,
                               gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean _mpc_equal (const __mpc_struct * s1,
                     const __mpc_struct * s2);
static gint number_hex_to_int (Number* self,
                        gchar digit);
static void number_finalize (GObject * obj);
static GType number_get_type_once (void);
static void _vala_number_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec);
static void _vala_number_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec);
VALA_EXTERN gint parse_literal_prefix (const gchar* str,
                           gint* prefix_len);
VALA_EXTERN Number* set_from_sexagesimal (const gchar* str);
VALA_EXTERN gint char_val (gunichar c,
               gint number_base);

static GType
angle_unit_get_type_once (void)
{
	static const GEnumValue values[] = {{ANGLE_UNIT_RADIANS, "ANGLE_UNIT_RADIANS", "radians"}, {ANGLE_UNIT_DEGREES, "ANGLE_UNIT_DEGREES", "degrees"}, {ANGLE_UNIT_GRADIANS, "ANGLE_UNIT_GRADIANS", "gradians"}, {0, NULL, NULL}};
	GType angle_unit_type_id;
	angle_unit_type_id = g_enum_register_static ("AngleUnit", values);
	return angle_unit_type_id;
}

GType
angle_unit_get_type (void)
{
	static volatile gsize angle_unit_type_id__once = 0;
	if (g_once_init_enter (&angle_unit_type_id__once)) {
		GType angle_unit_type_id;
		angle_unit_type_id = angle_unit_get_type_once ();
		g_once_init_leave (&angle_unit_type_id__once, angle_unit_type_id);
	}
	return angle_unit_type_id__once;
}

static inline gpointer
number_get_instance_private (Number* self)
{
	return G_STRUCT_MEMBER_P (self, Number_private_offset);
}

Number*
number_construct_integer (GType object_type,
                          gint64 real,
                          gint64 imag)
{
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	mpc_set_si_si (&self->priv->num, (glong) real, (glong) imag, MPC_RNDNN);
	return self;
}

Number*
number_new_integer (gint64 real,
                    gint64 imag)
{
	return number_construct_integer (TYPE_NUMBER, real, imag);
}

Number*
number_construct_unsigned_integer (GType object_type,
                                   guint64 real,
                                   guint64 imag)
{
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	mpc_set_ui_ui (&self->priv->num, (gulong) real, (gulong) imag, MPC_RNDNN);
	return self;
}

Number*
number_new_unsigned_integer (guint64 real,
                             guint64 imag)
{
	return number_construct_unsigned_integer (TYPE_NUMBER, real, imag);
}

Number*
number_construct_fraction (GType object_type,
                           gint64 numerator,
                           gint64 denominator)
{
	Number * self = NULL;
	if (denominator < ((gint64) 0)) {
		numerator = -numerator;
		denominator = -denominator;
	}
	self = (Number*) number_construct_integer (object_type, numerator, (gint64) 0);
	if (denominator != ((gint64) 1)) {
		mpc_div_ui (&self->priv->num, &self->priv->num, (gulong) ((glong) denominator), MPC_RNDNN);
	}
	return self;
}

Number*
number_new_fraction (gint64 numerator,
                     gint64 denominator)
{
	return number_construct_fraction (TYPE_NUMBER, numerator, denominator);
}

static gint
mpc_set_mpreal (__mpc_struct *self,
                __mpfr_struct* re,
                __mpfr_struct* im,
                mpc_rnd_t rnd)
{
	__mpfr_struct _tmp1_;
	__mpfr_struct _tmp2_;
	gint result;
	g_return_val_if_fail (re != NULL, 0);
	if (im == NULL) {
		__mpfr_struct _tmp0_;
		_tmp0_ = *re;
		result = mpc_set_fr (&(*self), &_tmp0_, rnd);
		return result;
	}
	_tmp1_ = *re;
	_tmp2_ = *im;
	result = mpc_set_fr_fr (&(*self), &_tmp1_, &_tmp2_, rnd);
	return result;
}

Number*
number_construct_mpreal (GType object_type,
                         __mpfr_struct* real,
                         __mpfr_struct* imag)
{
	Number * self = NULL;
	__mpfr_struct _tmp0_;
	g_return_val_if_fail (real != NULL, NULL);
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = *real;
	mpc_set_mpreal (&self->priv->num, &_tmp0_, imag, MPC_RNDNN);
	return self;
}

Number*
number_new_mpreal (__mpfr_struct* real,
                   __mpfr_struct* imag)
{
	return number_construct_mpreal (TYPE_NUMBER, real, imag);
}

Number*
number_construct_double (GType object_type,
                         gdouble real,
                         gdouble imag)
{
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	mpc_set_d_d (&self->priv->num, real, imag, MPC_RNDNN);
	return self;
}

Number*
number_new_double (gdouble real,
                   gdouble imag)
{
	return number_construct_double (TYPE_NUMBER, real, imag);
}

Number*
number_construct_complex (GType object_type,
                          Number* r,
                          Number* i)
{
	Number * self = NULL;
	MPFRGRealRef* _tmp0_;
	MPFRGRealRef* _tmp1_;
	g_return_val_if_fail (r != NULL, NULL);
	g_return_val_if_fail (i != NULL, NULL);
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = mpc_realref (&r->priv->num);
	_tmp1_ = mpc_realref (&i->priv->num);
	mpc_set_mpreal (&self->priv->num, &_tmp0_->val, &_tmp1_->val, MPC_RNDNN);
	return self;
}

Number*
number_new_complex (Number* r,
                    Number* i)
{
	return number_construct_complex (TYPE_NUMBER, r, i);
}

Number*
number_construct_polar (GType object_type,
                        Number* r,
                        Number* theta,
                        AngleUnit unit)
{
	Number * self = NULL;
	Number* x = NULL;
	Number* _tmp0_;
	Number* y = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	g_return_val_if_fail (r != NULL, NULL);
	g_return_val_if_fail (theta != NULL, NULL);
	_tmp0_ = number_cos (theta, unit);
	x = _tmp0_;
	_tmp1_ = number_sin (theta, unit);
	y = _tmp1_;
	_tmp2_ = number_multiply (x, r);
	_tmp3_ = _tmp2_;
	_tmp4_ = number_multiply (y, r);
	_tmp5_ = _tmp4_;
	self = (Number*) number_construct_complex (object_type, _tmp3_, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (y);
	_g_object_unref0 (x);
	return self;
}

Number*
number_new_polar (Number* r,
                  Number* theta,
                  AngleUnit unit)
{
	return number_construct_polar (TYPE_NUMBER, r, theta, unit);
}

Number*
number_construct_eulers (GType object_type)
{
	Number * self = NULL;
	MPFRGRealRef* _tmp0_;
	MPFRGRealRef* _tmp1_;
	MPFRGRealRef* _tmp2_;
	MPFRGRealRef* _tmp3_;
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = mpc_realref (&self->priv->num);
	mpfr_set_ui (&_tmp0_->val, (gulong) 1, MPFR_RNDN);
	_tmp1_ = mpc_realref (&self->priv->num);
	_tmp2_ = mpc_realref (&self->priv->num);
	mpfr_exp (&_tmp1_->val, &_tmp2_->val, MPFR_RNDN);
	_tmp3_ = mpc_imagref (&self->priv->num);
	mpfr_set_zero (&_tmp3_->val, MPFR_RNDN);
	return self;
}

Number*
number_new_eulers (void)
{
	return number_construct_eulers (TYPE_NUMBER);
}

Number*
number_construct_i (GType object_type)
{
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	mpc_set_si_si (&self->priv->num, (glong) 0, (glong) 1, MPC_RNDNN);
	return self;
}

Number*
number_new_i (void)
{
	return number_construct_i (TYPE_NUMBER);
}

Number*
number_construct_pi (GType object_type)
{
	Number * self = NULL;
	MPFRGRealRef* _tmp0_;
	MPFRGRealRef* _tmp1_;
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = mpc_realref (&self->priv->num);
	mpfr_const_pi (&_tmp0_->val, MPFR_RNDN);
	_tmp1_ = mpc_imagref (&self->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	return self;
}

Number*
number_new_pi (void)
{
	return number_construct_pi (TYPE_NUMBER);
}

static gint
mpfr_const_tau (__mpfr_struct *self,
                mpfr_rnd_t rnd)
{
	gint i = 0;
	gint result;
	i = mpfr_const_pi (&(*self), rnd);
	mpfr_mul_si (&(*self), &(*self), (glong) 2, rnd);
	result = i;
	return result;
}

Number*
number_construct_tau (GType object_type)
{
	Number * self = NULL;
	MPFRGRealRef* _tmp0_;
	MPFRGRealRef* _tmp1_;
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = mpc_realref (&self->priv->num);
	mpfr_const_tau (&_tmp0_->val, MPFR_RNDN);
	_tmp1_ = mpc_imagref (&self->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	return self;
}

Number*
number_new_tau (void)
{
	return number_construct_tau (TYPE_NUMBER);
}

Number*
number_construct_random (GType object_type)
{
	Number * self = NULL;
	self = (Number*) number_construct_double (object_type, g_random_double (), (gdouble) 0);
	return self;
}

Number*
number_new_random (void)
{
	return number_construct_random (TYPE_NUMBER);
}

gint64
number_to_integer (Number* self)
{
	MPFRGRealRef* _tmp0_;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = mpc_realref (&self->priv->num);
	result = (gint64) mpfr_get_si (&_tmp0_->val, MPFR_RNDN);
	return result;
}

guint64
number_to_unsigned_integer (Number* self)
{
	MPFRGRealRef* _tmp0_;
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	_tmp0_ = mpc_realref (&self->priv->num);
	result = (guint64) mpfr_get_ui (&_tmp0_->val, MPFR_RNDN);
	return result;
}

gfloat
number_to_float (Number* self)
{
	MPFRGRealRef* _tmp0_;
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = mpc_realref (&self->priv->num);
	result = mpfr_get_flt (&_tmp0_->val, MPFR_RNDN);
	return result;
}

gdouble
number_to_double (Number* self)
{
	MPFRGRealRef* _tmp0_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = mpc_realref (&self->priv->num);
	result = mpfr_get_d (&_tmp0_->val, MPFR_RNDN);
	return result;
}

static gboolean
mpc_is_zero (__mpc_struct *self)
{
	gint res = 0;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	res = mpc_cmp_si_si (&(*self), (glong) 0, (glong) 0);
	if (MPC_INEX_RE (res) == 0) {
		_tmp0_ = MPC_INEX_IM (res) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
number_is_zero (Number* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = mpc_is_zero (&self->priv->num);
	return result;
}

gboolean
number_is_negative (Number* self)
{
	MPFRGRealRef* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = mpc_realref (&self->priv->num);
	result = mpfr_sgn (&_tmp0_->val) < 0;
	return result;
}

gboolean
number_is_integer (Number* self)
{
	MPFRGRealRef* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (number_is_complex (self)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = mpc_realref (&self->priv->num);
	result = mpfr_integer_p (&_tmp0_->val) != 0;
	return result;
}

gboolean
number_is_positive_integer (Number* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (number_is_complex (self)) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp0_ = FALSE;
		MPFRGRealRef* _tmp1_;
		_tmp1_ = mpc_realref (&self->priv->num);
		if (mpfr_sgn (&_tmp1_->val) >= 0) {
			_tmp0_ = number_is_integer (self);
		} else {
			_tmp0_ = FALSE;
		}
		result = _tmp0_;
		return result;
	}
}

gboolean
number_is_natural (Number* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (number_is_complex (self)) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp0_ = FALSE;
		MPFRGRealRef* _tmp1_;
		_tmp1_ = mpc_realref (&self->priv->num);
		if (mpfr_sgn (&_tmp1_->val) > 0) {
			_tmp0_ = number_is_integer (self);
		} else {
			_tmp0_ = FALSE;
		}
		result = _tmp0_;
		return result;
	}
}

gboolean
number_is_complex (Number* self)
{
	MPFRGRealRef* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = mpc_imagref (&self->priv->num);
	result = !mpfr_zero_p (&_tmp0_->val);
	return result;
}

void
number_check_flags (void)
{
	if (mpfr_underflow_p () != 0) {
		number_set_error (_ ("Underflow error"));
	} else {
		if (mpfr_overflow_p () != 0) {
			number_set_error (_ ("Overflow error"));
		}
	}
}

static gboolean
mpc_is_equal (__mpc_struct *self,
              __mpc_struct* c)
{
	gint res = 0;
	__mpc_struct _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = *c;
	res = mpc_cmp (&(*self), &_tmp0_);
	if (MPC_INEX_RE (res) == 0) {
		_tmp1_ = MPC_INEX_IM (res) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}

gboolean
number_equals (Number* self,
               Number* y)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (y != NULL, FALSE);
	result = mpc_is_equal (&self->priv->num, &y->priv->num);
	return result;
}

gint
number_compare (Number* self,
                Number* y)
{
	MPFRGRealRef* _tmp0_;
	MPFRGRealRef* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (y != NULL, 0);
	_tmp0_ = mpc_realref (&self->priv->num);
	_tmp1_ = mpc_realref (&y->priv->num);
	result = mpfr_cmp (&_tmp0_->val, &_tmp1_->val);
	return result;
}

Number*
number_sgn (Number* self)
{
	Number* z = NULL;
	MPFRGRealRef* _tmp0_;
	Number* _tmp1_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = mpc_realref (&self->priv->num);
	_tmp1_ = number_new_integer ((gint64) mpfr_sgn (&_tmp0_->val), (gint64) 0);
	z = _tmp1_;
	result = z;
	return result;
}

Number*
number_invert_sign (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_neg (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_abs (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	MPFRGRealRef* _tmp1_;
	MPFRGRealRef* _tmp2_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	mpc_abs (&_tmp2_->val, &self->priv->num, MPFR_RNDN);
	result = z;
	return result;
}

Number*
number_arg (Number* self,
            AngleUnit unit)
{
	Number* z = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	MPFRGRealRef* _tmp3_;
	Number* _tmp4_;
	MPFRGRealRef* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	gboolean _tmp8_ = FALSE;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_zero (self)) {
		Number* _tmp0_;
		number_set_error (_ ("Argument not defined for zero"));
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = number_new ();
	z = _tmp1_;
	_tmp2_ = z;
	_tmp3_ = mpc_imagref (&_tmp2_->priv->num);
	mpfr_set_zero (&_tmp3_->val, MPFR_RNDN);
	_tmp4_ = z;
	_tmp5_ = mpc_realref (&_tmp4_->priv->num);
	mpc_arg (&_tmp5_->val, &self->priv->num, MPFR_RNDN);
	_tmp6_ = z;
	_tmp7_ = z;
	number_mpc_from_radians (&_tmp6_->priv->num, &_tmp7_->priv->num, unit);
	if (!number_is_complex (self)) {
		_tmp8_ = number_is_negative (self);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		Number* _tmp9_;
		MPFRGRealRef* _tmp10_;
		Number* _tmp11_;
		MPFRGRealRef* _tmp12_;
		_tmp9_ = z;
		_tmp10_ = mpc_realref (&_tmp9_->priv->num);
		_tmp11_ = z;
		_tmp12_ = mpc_realref (&_tmp11_->priv->num);
		mpfr_abs (&_tmp10_->val, &_tmp12_->val, MPFR_RNDN);
	}
	result = z;
	return result;
}

Number*
number_conjugate (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_conj (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_real_component (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	MPFRGRealRef* _tmp1_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_realref (&self->priv->num);
	mpc_set_mpreal (&z->priv->num, &_tmp1_->val, NULL, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_imaginary_component (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	MPFRGRealRef* _tmp1_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&self->priv->num);
	mpc_set_mpreal (&z->priv->num, &_tmp1_->val, NULL, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_integer_component (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	MPFRGRealRef* _tmp1_;
	MPFRGRealRef* _tmp2_;
	MPFRGRealRef* _tmp3_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	_tmp3_ = mpc_realref (&self->priv->num);
	mpfr_trunc (&_tmp2_->val, &_tmp3_->val);
	result = z;
	return result;
}

Number*
number_fractional_component (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	MPFRGRealRef* _tmp1_;
	MPFRGRealRef* _tmp2_;
	MPFRGRealRef* _tmp3_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	_tmp3_ = mpc_realref (&self->priv->num);
	mpfr_frac (&_tmp2_->val, &_tmp3_->val, MPFR_RNDN);
	result = z;
	return result;
}

Number*
number_fractional_part (Number* self)
{
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_floor (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_subtract (self, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

Number*
number_floor (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	MPFRGRealRef* _tmp1_;
	MPFRGRealRef* _tmp2_;
	MPFRGRealRef* _tmp3_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	_tmp3_ = mpc_realref (&self->priv->num);
	mpfr_floor (&_tmp2_->val, &_tmp3_->val);
	result = z;
	return result;
}

Number*
number_ceiling (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	MPFRGRealRef* _tmp1_;
	MPFRGRealRef* _tmp2_;
	MPFRGRealRef* _tmp3_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	_tmp3_ = mpc_realref (&self->priv->num);
	mpfr_ceil (&_tmp2_->val, &_tmp3_->val);
	result = z;
	return result;
}

Number*
number_round (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	MPFRGRealRef* _tmp1_;
	MPFRGRealRef* _tmp2_;
	MPFRGRealRef* _tmp3_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	_tmp3_ = mpc_realref (&self->priv->num);
	mpfr_round (&_tmp2_->val, &_tmp3_->val);
	result = z;
	return result;
}

Number*
number_reciprocal (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	MPFRGRealRef* _tmp1_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_set_si_si (&z->priv->num, (glong) 1, (glong) 0, MPC_RNDNN);
	_tmp1_ = mpc_realref (&z->priv->num);
	mpc_fr_div (&z->priv->num, &_tmp1_->val, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_epowy (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_exp (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_xpowy (Number* self,
              Number* y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	Number* z = NULL;
	Number* _tmp10_;
	Number* _tmp11_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (number_is_zero (self)) {
		_tmp0_ = number_is_negative (y);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Number* _tmp1_;
		number_set_error (_ ("The power of zero is undefined for a negative exponent"));
		_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp1_;
		return result;
	}
	if (number_is_zero (self)) {
		_tmp2_ = number_is_zero (y);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		Number* _tmp3_;
		number_set_error (_ ("Zero raised to zero is undefined"));
		_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp3_;
		return result;
	}
	if (!number_is_complex (self)) {
		_tmp5_ = !number_is_complex (y);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = !number_is_integer (y);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		Number* reciprocal = NULL;
		Number* _tmp6_;
		Number* _tmp7_;
		_tmp6_ = number_reciprocal (y);
		reciprocal = _tmp6_;
		_tmp7_ = reciprocal;
		if (number_is_integer (_tmp7_)) {
			Number* _tmp8_;
			Number* _tmp9_;
			_tmp8_ = reciprocal;
			_tmp9_ = number_root (self, number_to_integer (_tmp8_));
			result = _tmp9_;
			_g_object_unref0 (reciprocal);
			return result;
		}
		_g_object_unref0 (reciprocal);
	}
	_tmp10_ = number_new ();
	z = _tmp10_;
	_tmp11_ = z;
	mpc_pow (&_tmp11_->priv->num, &self->priv->num, &y->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_xpowy_integer (Number* self,
                      gint64 n)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Number* z = NULL;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_zero (self)) {
		_tmp0_ = n < ((gint64) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Number* _tmp1_;
		number_set_error (_ ("The power of zero is undefined for a negative exponent"));
		_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp1_;
		return result;
	}
	if (number_is_zero (self)) {
		_tmp2_ = n == ((gint64) 0);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		Number* _tmp3_;
		number_set_error (_ ("Zero raised to zero is undefined"));
		_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = number_new ();
	z = _tmp4_;
	_tmp5_ = z;
	mpc_pow_si (&_tmp5_->priv->num, &self->priv->num, (glong) n, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_root (Number* self,
             gint64 n)
{
	guint64 p = 0ULL;
	Number* z = NULL;
	Number* _tmp0_;
	gboolean _tmp4_ = FALSE;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	if (n < ((gint64) 0)) {
		Number* _tmp1_;
		_tmp1_ = z;
		mpc_ui_div (&_tmp1_->priv->num, (gulong) 1, &self->priv->num, MPC_RNDNN);
		if (n == G_MININT64) {
			p = ((guint64) G_MAXINT64) + 1;
		} else {
			p = (guint64) (-n);
		}
	} else {
		if (n > ((gint64) 0)) {
			Number* _tmp2_;
			_tmp2_ = z;
			mpc_set (&_tmp2_->priv->num, &self->priv->num, MPC_RNDNN);
			p = (guint64) n;
		} else {
			Number* _tmp3_;
			number_set_error (_ ("The zeroth root of a number is undefined"));
			_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
			result = _tmp3_;
			_g_object_unref0 (z);
			return result;
		}
	}
	if (!number_is_complex (self)) {
		gboolean _tmp5_ = FALSE;
		if (!number_is_negative (self)) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = (p & 1) == ((guint64) 1);
		}
		_tmp4_ = _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		Number* _tmp6_;
		MPFRGRealRef* _tmp7_;
		Number* _tmp8_;
		MPFRGRealRef* _tmp9_;
		Number* _tmp10_;
		MPFRGRealRef* _tmp11_;
		_tmp6_ = z;
		_tmp7_ = mpc_realref (&_tmp6_->priv->num);
		_tmp8_ = z;
		_tmp9_ = mpc_realref (&_tmp8_->priv->num);
		mpfr_root (&_tmp7_->val, &_tmp9_->val, (gulong) p, MPFR_RNDN);
		_tmp10_ = z;
		_tmp11_ = mpc_imagref (&_tmp10_->priv->num);
		mpfr_set_zero (&_tmp11_->val, MPFR_RNDN);
	} else {
		__mpfr_struct tmp = {0};
		mpfr_prec_t _tmp12_;
		mpfr_prec_t _tmp13_;
		Number* _tmp14_;
		Number* _tmp15_;
		_tmp12_ = number_get_precision ();
		_tmp13_ = _tmp12_;
		mpfr_init2 (&tmp, _tmp13_);
		mpfr_set_ui (&tmp, (gulong) p, MPFR_RNDN);
		mpfr_ui_div (&tmp, (gulong) 1, &tmp, MPFR_RNDN);
		_tmp14_ = z;
		_tmp15_ = z;
		mpc_pow_fr (&_tmp14_->priv->num, &_tmp15_->priv->num, &tmp, MPC_RNDNN);
		mpfr_clear (&tmp);
	}
	result = z;
	return result;
}

Number*
number_sqrt (Number* self)
{
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_root (self, (gint64) 2);
	result = _tmp0_;
	return result;
}

Number*
number_ln (Number* self)
{
	Number* z = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	gboolean _tmp3_ = FALSE;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_zero (self)) {
		Number* _tmp0_;
		number_set_error (_ ("Logarithm of zero is undefined"));
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = number_new ();
	z = _tmp1_;
	_tmp2_ = z;
	mpc_log (&_tmp2_->priv->num, &self->priv->num, MPC_RNDNN);
	if (!number_is_complex (self)) {
		_tmp3_ = number_is_negative (self);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		Number* _tmp4_;
		MPFRGRealRef* _tmp5_;
		Number* _tmp6_;
		MPFRGRealRef* _tmp7_;
		_tmp4_ = z;
		_tmp5_ = mpc_imagref (&_tmp4_->priv->num);
		_tmp6_ = z;
		_tmp7_ = mpc_imagref (&_tmp6_->priv->num);
		mpfr_abs (&_tmp5_->val, &_tmp7_->val, MPFR_RNDN);
	}
	result = z;
	return result;
}

Number*
number_logarithm (Number* self,
                  gint64 n)
{
	Number* t1 = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_zero (self)) {
		Number* _tmp0_;
		number_set_error (_ ("Logarithm of zero is undefined"));
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = number_new_integer (n, (gint64) 0);
	t1 = _tmp1_;
	_tmp2_ = number_ln (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = t1;
	_tmp5_ = number_ln (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = number_divide (_tmp3_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp3_);
	result = _tmp8_;
	_g_object_unref0 (t1);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Number*
number_factorial (Number* self)
{
	gint64 value = 0LL;
	Number* z = NULL;
	Number* _tmp12_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_zero (self)) {
		Number* _tmp0_;
		_tmp0_ = number_new_integer ((gint64) 1, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	if (!number_is_natural (self)) {
		gboolean _tmp1_ = FALSE;
		Number* tmp = NULL;
		Number* _tmp3_;
		Number* _tmp4_;
		Number* _tmp5_;
		Number* _tmp6_;
		__mpfr_struct tmp2 = {0};
		mpfr_prec_t _tmp7_;
		mpfr_prec_t _tmp8_;
		Number* _tmp9_;
		MPFRGRealRef* _tmp10_;
		Number* _tmp11_;
		if (number_is_negative (self)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = number_is_complex (self);
		}
		if (_tmp1_) {
			Number* _tmp2_;
			number_set_error (_ ("Factorial is only defined for non-negative real numbers"));
			_tmp2_ = number_new_integer ((gint64) 0, (gint64) 0);
			result = _tmp2_;
			return result;
		}
		_tmp3_ = number_new_integer ((gint64) 1, (gint64) 0);
		_tmp4_ = _tmp3_;
		_tmp5_ = number_add (self, _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		tmp = _tmp6_;
		_tmp7_ = number_get_precision ();
		_tmp8_ = _tmp7_;
		mpfr_init2 (&tmp2, _tmp8_);
		_tmp9_ = tmp;
		_tmp10_ = mpc_realref (&_tmp9_->priv->num);
		mpfr_gamma (&tmp2, &_tmp10_->val, MPFR_RNDN);
		_tmp11_ = number_new_mpreal (&tmp2, NULL);
		result = _tmp11_;
		mpfr_clear (&tmp2);
		_g_object_unref0 (tmp);
		return result;
	}
	value = number_to_integer (self);
	_tmp12_ = _g_object_ref0 (self);
	z = _tmp12_;
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				Number* _tmp15_;
				Number* _tmp16_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				if (!(((gint64) i) < value)) {
					break;
				}
				_tmp15_ = z;
				_tmp16_ = number_multiply_integer (_tmp15_, (gint64) i);
				_g_object_unref0 (z);
				z = _tmp16_;
			}
		}
	}
	result = z;
	return result;
}

Number*
number_add (Number* self,
            Number* y)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_add (&z->priv->num, &self->priv->num, &y->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_subtract (Number* self,
                 Number* y)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_sub (&z->priv->num, &self->priv->num, &y->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_multiply (Number* self,
                 Number* y)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_mul (&z->priv->num, &self->priv->num, &y->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_multiply_integer (Number* self,
                         gint64 y)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_mul_si (&z->priv->num, &self->priv->num, (glong) y, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_divide (Number* self,
               Number* y)
{
	Number* z = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (number_is_zero (y)) {
		Number* _tmp0_;
		number_set_error (_ ("Division by zero is undefined"));
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = number_new ();
	z = _tmp1_;
	_tmp2_ = z;
	mpc_div (&_tmp2_->priv->num, &self->priv->num, &y->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_divide_integer (Number* self,
                       gint64 y)
{
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new_integer (y, (gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_divide (self, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

Number*
number_modulus_divide (Number* self,
                       Number* y)
{
	gboolean _tmp0_ = FALSE;
	Number* t1 = NULL;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* t2 = NULL;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* z = NULL;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	Number* _tmp13_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (!number_is_integer (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !number_is_integer (y);
	}
	if (_tmp0_) {
		Number* _tmp1_;
		number_set_error (_ ("Modulus division is only defined for integers"));
		_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = number_divide (self, y);
	_tmp3_ = _tmp2_;
	_tmp4_ = number_floor (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	t1 = _tmp5_;
	_tmp6_ = t1;
	_tmp7_ = number_multiply (_tmp6_, y);
	t2 = _tmp7_;
	_tmp8_ = t2;
	_tmp9_ = number_subtract (self, _tmp8_);
	z = _tmp9_;
	_tmp10_ = number_new_integer ((gint64) 0, (gint64) 0);
	_g_object_unref0 (t1);
	t1 = _tmp10_;
	_tmp13_ = t1;
	if (number_compare (y, _tmp13_) < 0) {
		Number* _tmp14_;
		Number* _tmp15_;
		_tmp14_ = z;
		_tmp15_ = t1;
		_tmp12_ = number_compare (_tmp14_, _tmp15_) > 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		gboolean _tmp16_ = FALSE;
		Number* _tmp17_;
		_tmp17_ = t1;
		if (number_compare (y, _tmp17_) > 0) {
			Number* _tmp18_;
			Number* _tmp19_;
			_tmp18_ = z;
			_tmp19_ = t1;
			_tmp16_ = number_compare (_tmp18_, _tmp19_) < 0;
		} else {
			_tmp16_ = FALSE;
		}
		_tmp11_ = _tmp16_;
	}
	if (_tmp11_) {
		Number* _tmp20_;
		Number* _tmp21_;
		_tmp20_ = z;
		_tmp21_ = number_add (_tmp20_, y);
		_g_object_unref0 (z);
		z = _tmp21_;
	}
	result = z;
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}

Number*
number_modular_exponentiation (Number* self,
                               Number* exp,
                               Number* mod)
{
	Number* base_value = NULL;
	Number* _tmp0_;
	Number* exp_value = NULL;
	Number* _tmp3_;
	Number* ans = NULL;
	Number* _tmp4_;
	Number* two = NULL;
	Number* _tmp5_;
	Number* _tmp26_;
	Number* _tmp27_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (exp != NULL, NULL);
	g_return_val_if_fail (mod != NULL, NULL);
	_tmp0_ = number_copy (self);
	base_value = _tmp0_;
	if (number_is_negative (exp)) {
		Number* _tmp1_;
		Number* _tmp2_;
		_tmp1_ = base_value;
		_tmp2_ = number_reciprocal (_tmp1_);
		_g_object_unref0 (base_value);
		base_value = _tmp2_;
	}
	_tmp3_ = number_abs (exp);
	exp_value = _tmp3_;
	_tmp4_ = number_new_integer ((gint64) 1, (gint64) 0);
	ans = _tmp4_;
	_tmp5_ = number_new_integer ((gint64) 2, (gint64) 0);
	two = _tmp5_;
	while (TRUE) {
		Number* _tmp6_;
		gboolean is_even = FALSE;
		Number* _tmp7_;
		Number* _tmp8_;
		Number* _tmp9_;
		Number* _tmp10_;
		gboolean _tmp11_;
		Number* _tmp17_;
		Number* _tmp18_;
		Number* _tmp19_;
		Number* _tmp20_;
		Number* _tmp21_;
		Number* _tmp22_;
		Number* _tmp23_;
		Number* _tmp24_;
		Number* _tmp25_;
		_tmp6_ = exp_value;
		if (!(!number_is_zero (_tmp6_))) {
			break;
		}
		_tmp7_ = exp_value;
		_tmp8_ = two;
		_tmp9_ = number_modulus_divide (_tmp7_, _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = number_is_zero (_tmp10_);
		_g_object_unref0 (_tmp10_);
		is_even = _tmp11_;
		if (!is_even) {
			Number* _tmp12_;
			Number* _tmp13_;
			Number* _tmp14_;
			Number* _tmp15_;
			Number* _tmp16_;
			_tmp12_ = ans;
			_tmp13_ = base_value;
			_tmp14_ = number_multiply (_tmp12_, _tmp13_);
			_g_object_unref0 (ans);
			ans = _tmp14_;
			_tmp15_ = ans;
			_tmp16_ = number_modulus_divide (_tmp15_, mod);
			_g_object_unref0 (ans);
			ans = _tmp16_;
		}
		_tmp17_ = base_value;
		_tmp18_ = base_value;
		_tmp19_ = number_multiply (_tmp17_, _tmp18_);
		_g_object_unref0 (base_value);
		base_value = _tmp19_;
		_tmp20_ = base_value;
		_tmp21_ = number_modulus_divide (_tmp20_, mod);
		_g_object_unref0 (base_value);
		base_value = _tmp21_;
		_tmp22_ = exp_value;
		_tmp23_ = number_divide_integer (_tmp22_, (gint64) 2);
		_tmp24_ = _tmp23_;
		_tmp25_ = number_floor (_tmp24_);
		_g_object_unref0 (exp_value);
		exp_value = _tmp25_;
		_g_object_unref0 (_tmp24_);
	}
	_tmp26_ = ans;
	_tmp27_ = number_modulus_divide (_tmp26_, mod);
	result = _tmp27_;
	_g_object_unref0 (two);
	_g_object_unref0 (ans);
	_g_object_unref0 (exp_value);
	_g_object_unref0 (base_value);
	return result;
}

Number*
number_sin (Number* self,
            AngleUnit unit)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	if (number_is_complex (self)) {
		Number* _tmp1_;
		_tmp1_ = z;
		mpc_set (&_tmp1_->priv->num, &self->priv->num, MPC_RNDNN);
	} else {
		Number* _tmp2_;
		_tmp2_ = z;
		number_mpc_to_radians (&_tmp2_->priv->num, &self->priv->num, unit);
	}
	_tmp3_ = z;
	_tmp4_ = z;
	mpc_sin (&_tmp3_->priv->num, &_tmp4_->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_cos (Number* self,
            AngleUnit unit)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	if (number_is_complex (self)) {
		Number* _tmp1_;
		_tmp1_ = z;
		mpc_set (&_tmp1_->priv->num, &self->priv->num, MPC_RNDNN);
	} else {
		Number* _tmp2_;
		_tmp2_ = z;
		number_mpc_to_radians (&_tmp2_->priv->num, &self->priv->num, unit);
	}
	_tmp3_ = z;
	_tmp4_ = z;
	mpc_cos (&_tmp3_->priv->num, &_tmp4_->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_tan (Number* self,
            AngleUnit unit)
{
	Number* x_radians = NULL;
	Number* _tmp0_;
	Number* check = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	Number* _tmp12_;
	Number* z = NULL;
	Number* _tmp14_;
	Number* _tmp17_;
	Number* _tmp18_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_to_radians (self, unit);
	x_radians = _tmp0_;
	_tmp1_ = x_radians;
	_tmp2_ = number_new_pi ();
	_tmp3_ = _tmp2_;
	_tmp4_ = number_divide_integer (_tmp3_, (gint64) 2);
	_tmp5_ = _tmp4_;
	_tmp6_ = number_subtract (_tmp1_, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = number_new_pi ();
	_tmp9_ = _tmp8_;
	_tmp10_ = number_divide (_tmp7_, _tmp9_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	check = _tmp11_;
	_tmp12_ = check;
	if (number_is_integer (_tmp12_)) {
		Number* _tmp13_;
		number_set_error (_ ("Tangent is undefined for angles that are multiples of π (180°) from π∕" \
"2 (90°)"));
		_tmp13_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp13_;
		_g_object_unref0 (check);
		_g_object_unref0 (x_radians);
		return result;
	}
	_tmp14_ = number_new ();
	z = _tmp14_;
	if (number_is_complex (self)) {
		Number* _tmp15_;
		_tmp15_ = z;
		mpc_set (&_tmp15_->priv->num, &self->priv->num, MPC_RNDNN);
	} else {
		Number* _tmp16_;
		_tmp16_ = z;
		number_mpc_to_radians (&_tmp16_->priv->num, &self->priv->num, unit);
	}
	_tmp17_ = z;
	_tmp18_ = z;
	mpc_tan (&_tmp17_->priv->num, &_tmp18_->priv->num, MPC_RNDNN);
	result = z;
	_g_object_unref0 (check);
	_g_object_unref0 (x_radians);
	return result;
}

Number*
number_asin (Number* self,
             AngleUnit unit)
{
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_;
	Number* _tmp2_;
	gboolean _tmp3_;
	Number* z = NULL;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_compare (self, _tmp2_) > 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp4_;
		Number* _tmp5_;
		_tmp4_ = number_new_integer ((gint64) -1, (gint64) 0);
		_tmp5_ = _tmp4_;
		_tmp0_ = number_compare (self, _tmp5_) < 0;
		_g_object_unref0 (_tmp5_);
	}
	if (_tmp0_) {
		Number* _tmp6_;
		number_set_error (_ ("Inverse sine is undefined for values outside [-1, 1]"));
		_tmp6_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = number_new ();
	z = _tmp7_;
	_tmp8_ = z;
	mpc_asin (&_tmp8_->priv->num, &self->priv->num, MPC_RNDNN);
	_tmp9_ = z;
	if (!number_is_complex (_tmp9_)) {
		Number* _tmp10_;
		Number* _tmp11_;
		_tmp10_ = z;
		_tmp11_ = z;
		number_mpc_from_radians (&_tmp10_->priv->num, &_tmp11_->priv->num, unit);
	}
	result = z;
	return result;
}

Number*
number_acos (Number* self,
             AngleUnit unit)
{
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_;
	Number* _tmp2_;
	gboolean _tmp3_;
	Number* z = NULL;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_compare (self, _tmp2_) > 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp4_;
		Number* _tmp5_;
		_tmp4_ = number_new_integer ((gint64) -1, (gint64) 0);
		_tmp5_ = _tmp4_;
		_tmp0_ = number_compare (self, _tmp5_) < 0;
		_g_object_unref0 (_tmp5_);
	}
	if (_tmp0_) {
		Number* _tmp6_;
		number_set_error (_ ("Inverse cosine is undefined for values outside [-1, 1]"));
		_tmp6_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = number_new ();
	z = _tmp7_;
	_tmp8_ = z;
	mpc_acos (&_tmp8_->priv->num, &self->priv->num, MPC_RNDNN);
	_tmp9_ = z;
	if (!number_is_complex (_tmp9_)) {
		Number* _tmp10_;
		Number* _tmp11_;
		_tmp10_ = z;
		_tmp11_ = z;
		number_mpc_from_radians (&_tmp10_->priv->num, &_tmp11_->priv->num, unit);
	}
	result = z;
	return result;
}

Number*
number_atan (Number* self,
             AngleUnit unit)
{
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_;
	Number* _tmp2_;
	gboolean _tmp3_;
	Number* z = NULL;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_new_integer ((gint64) 0, (gint64) 1);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_equals (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp4_;
		Number* _tmp5_;
		_tmp4_ = number_new_integer ((gint64) 0, (gint64) -1);
		_tmp5_ = _tmp4_;
		_tmp0_ = number_equals (self, _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	if (_tmp0_) {
		Number* _tmp6_;
		number_set_error (_ ("Arctangent function is undefined for values i and -i"));
		_tmp6_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = number_new ();
	z = _tmp7_;
	_tmp8_ = z;
	mpc_atan (&_tmp8_->priv->num, &self->priv->num, MPC_RNDNN);
	_tmp9_ = z;
	if (!number_is_complex (_tmp9_)) {
		Number* _tmp10_;
		Number* _tmp11_;
		_tmp10_ = z;
		_tmp11_ = z;
		number_mpc_from_radians (&_tmp10_->priv->num, &_tmp11_->priv->num, unit);
	}
	result = z;
	return result;
}

Number*
number_sinh (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_sinh (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_cosh (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_cosh (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_tanh (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_tanh (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_asinh (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_asinh (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

Number*
number_acosh (Number* self)
{
	Number* t = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* z = NULL;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 1, (gint64) 0);
	t = _tmp0_;
	_tmp1_ = t;
	if (number_compare (self, _tmp1_) < 0) {
		Number* _tmp2_;
		number_set_error (_ ("Inverse hyperbolic cosine is undefined for values less than one"));
		_tmp2_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp2_;
		_g_object_unref0 (t);
		return result;
	}
	_tmp3_ = number_new ();
	z = _tmp3_;
	_tmp4_ = z;
	mpc_acosh (&_tmp4_->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	_g_object_unref0 (t);
	return result;
}

Number*
number_atanh (Number* self)
{
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_;
	Number* _tmp2_;
	gboolean _tmp3_;
	Number* z = NULL;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_compare (self, _tmp2_) >= 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp4_;
		Number* _tmp5_;
		_tmp4_ = number_new_integer ((gint64) -1, (gint64) 0);
		_tmp5_ = _tmp4_;
		_tmp0_ = number_compare (self, _tmp5_) <= 0;
		_g_object_unref0 (_tmp5_);
	}
	if (_tmp0_) {
		Number* _tmp6_;
		number_set_error (_ ("Inverse hyperbolic tangent is undefined for values outside [-1, 1]"));
		_tmp6_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = number_new ();
	z = _tmp7_;
	_tmp8_ = z;
	mpc_atanh (&_tmp8_->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

static gint
__lambda4_ (Number* self,
            gint v1,
            gint v2)
{
	gint result;
	result = v1 & v2;
	return result;
}

static gint
___lambda4__bitwise_func (gint v1,
                          gint v2,
                          gpointer self)
{
	gint result;
	result = __lambda4_ ((Number*) self, v1, v2);
	return result;
}

Number*
number_and (Number* self,
            Number* y)
{
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (!number_is_positive_integer (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !number_is_positive_integer (y);
	}
	if (_tmp0_) {
		number_set_error (_ ("Boolean AND is only defined for positive integers"));
	}
	_tmp1_ = number_bitwise (self, y, ___lambda4__bitwise_func, self, 0);
	result = _tmp1_;
	return result;
}

static gint
__lambda5_ (Number* self,
            gint v1,
            gint v2)
{
	gint result;
	result = v1 | v2;
	return result;
}

static gint
___lambda5__bitwise_func (gint v1,
                          gint v2,
                          gpointer self)
{
	gint result;
	result = __lambda5_ ((Number*) self, v1, v2);
	return result;
}

Number*
number_or (Number* self,
           Number* y)
{
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (!number_is_positive_integer (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !number_is_positive_integer (y);
	}
	if (_tmp0_) {
		number_set_error (_ ("Boolean OR is only defined for positive integers"));
	}
	_tmp1_ = number_bitwise (self, y, ___lambda5__bitwise_func, self, 0);
	result = _tmp1_;
	return result;
}

static gint
__lambda6_ (Number* self,
            gint v1,
            gint v2)
{
	gint result;
	result = v1 ^ v2;
	return result;
}

static gint
___lambda6__bitwise_func (gint v1,
                          gint v2,
                          gpointer self)
{
	gint result;
	result = __lambda6_ ((Number*) self, v1, v2);
	return result;
}

Number*
number_xor (Number* self,
            Number* y)
{
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (!number_is_positive_integer (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !number_is_positive_integer (y);
	}
	if (_tmp0_) {
		number_set_error (_ ("Boolean XOR is only defined for positive integers"));
	}
	_tmp1_ = number_bitwise (self, y, ___lambda6__bitwise_func, self, 0);
	result = _tmp1_;
	return result;
}

static gint
__lambda7_ (Number* self,
            gint v1,
            gint v2)
{
	gint result;
	result = v1 ^ 0xF;
	return result;
}

static gint
___lambda7__bitwise_func (gint v1,
                          gint v2,
                          gpointer self)
{
	gint result;
	result = __lambda7_ ((Number*) self, v1, v2);
	return result;
}

Number*
number_not (Number* self,
            gint wordlen)
{
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!number_is_positive_integer (self)) {
		number_set_error (_ ("Boolean NOT is only defined for positive integers"));
	}
	_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_bitwise (self, _tmp1_, ___lambda7__bitwise_func, self, wordlen);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

Number*
number_mask (Number* self,
             Number* x,
             gint wordlen)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	gint len = 0;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint offset = 0;
	gint _tmp4_ = 0;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = number_to_hex_string (x);
	text = _tmp0_;
	_tmp1_ = text;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	len = _tmp3_;
	offset = wordlen / 4;
	if (len > offset) {
		_tmp4_ = ((gint) len) - offset;
	} else {
		_tmp4_ = 0;
	}
	offset = _tmp4_;
	_tmp5_ = text;
	_tmp6_ = string_substring (_tmp5_, (glong) offset, (glong) -1);
	_tmp7_ = _tmp6_;
	_tmp8_ = mp_set_from_string (_tmp7_, 16);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	result = _tmp9_;
	_g_free0 (text);
	return result;
}

Number*
number_shift (Number* self,
              gint64 count)
{
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!number_is_integer (self)) {
		Number* _tmp0_;
		number_set_error (_ ("Shift is only possible on integer values"));
		_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	if (count >= ((gint64) 0)) {
		gint multiplier = 0;
		Number* _tmp3_;
		multiplier = 1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					if (!(((gint64) i) < count)) {
						break;
					}
					multiplier *= 2;
				}
			}
		}
		_tmp3_ = number_multiply_integer (self, (gint64) multiplier);
		result = _tmp3_;
		return result;
	} else {
		gint multiplier = 0;
		Number* _tmp6_;
		Number* _tmp7_;
		Number* _tmp8_;
		Number* _tmp9_;
		multiplier = 1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp4_ = FALSE;
					if (!(((gint64) i) < (-count))) {
						break;
					}
					multiplier *= 2;
				}
			}
		}
		_tmp6_ = number_divide_integer (self, (gint64) multiplier);
		_tmp7_ = _tmp6_;
		_tmp8_ = number_floor (_tmp7_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		result = _tmp9_;
		return result;
	}
}

static gint
__lambda8_ (Number* self,
            gint v1,
            gint v2)
{
	gint result;
	result = v1 ^ v2;
	return result;
}

static gint
___lambda8__bitwise_func (gint v1,
                          gint v2,
                          gpointer self)
{
	gint result;
	result = __lambda8_ ((Number*) self, v1, v2);
	return result;
}

Number*
number_ones_complement (Number* self,
                        gint wordlen)
{
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_bitwise (self, _tmp1_, ___lambda8__bitwise_func, self, wordlen);
	_tmp3_ = _tmp2_;
	_tmp4_ = number_not (_tmp3_, wordlen);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}

Number*
number_twos_complement (Number* self,
                        gint wordlen)
{
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_ones_complement (self, wordlen);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp3_ = _tmp2_;
	_tmp4_ = number_add (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GList*
number_factorize (Number* self)
{
	GList* factors = NULL;
	Number* value = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	gboolean _tmp7_;
	guint64 num = 0ULL;
	Number* int_max = NULL;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	Number* divisor = NULL;
	Number* _tmp18_;
	Number* _tmp27_;
	Number* root = NULL;
	Number* _tmp28_;
	Number* _tmp29_;
	Number* _tmp48_;
	Number* _tmp49_;
	Number* _tmp50_;
	gboolean _tmp51_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	factors = NULL;
	_tmp0_ = number_abs (self);
	value = _tmp0_;
	_tmp1_ = value;
	if (number_is_zero (_tmp1_)) {
		Number* _tmp2_;
		Number* _tmp3_;
		_tmp2_ = value;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		factors = g_list_append (factors, _tmp3_);
		result = factors;
		_g_object_unref0 (value);
		return result;
	}
	_tmp4_ = value;
	_tmp5_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp6_ = _tmp5_;
	_tmp7_ = number_equals (_tmp4_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	if (_tmp7_) {
		Number* _tmp8_;
		_tmp8_ = _g_object_ref0 (self);
		factors = g_list_append (factors, _tmp8_);
		result = factors;
		_g_object_unref0 (value);
		return result;
	}
	num = (guint64) 1;
	num = num << 63;
	num += num - 1;
	_tmp9_ = number_new_unsigned_integer (num, (guint64) 0);
	int_max = _tmp9_;
	_tmp10_ = value;
	_tmp11_ = int_max;
	if (number_compare (_tmp10_, _tmp11_) <= 0) {
		GList* factors_int64 = NULL;
		Number* _tmp12_;
		GList* _tmp13_;
		_tmp12_ = value;
		_tmp13_ = number_factorize_uint64 (self, number_to_unsigned_integer (_tmp12_));
		factors_int64 = _tmp13_;
		if (number_is_negative (self)) {
			GList* _tmp14_;
			GList* _tmp15_;
			gconstpointer _tmp16_;
			Number* _tmp17_;
			_tmp14_ = factors_int64;
			_tmp15_ = factors_int64;
			_tmp16_ = _tmp15_->data;
			_tmp17_ = number_invert_sign ((Number*) _tmp16_);
			_g_object_unref0 (_tmp14_->data);
			_tmp14_->data = _tmp17_;
		}
		result = factors_int64;
		_g_object_unref0 (int_max);
		_g_object_unref0 (value);
		(factors == NULL) ? NULL : (factors = (_g_list_free__g_object_unref0_ (factors), NULL));
		return result;
	}
	_tmp18_ = number_new_integer ((gint64) 2, (gint64) 0);
	divisor = _tmp18_;
	while (TRUE) {
		Number* tmp = NULL;
		Number* _tmp19_;
		Number* _tmp20_;
		Number* _tmp21_;
		Number* _tmp22_;
		_tmp19_ = value;
		_tmp20_ = divisor;
		_tmp21_ = number_divide (_tmp19_, _tmp20_);
		tmp = _tmp21_;
		_tmp22_ = tmp;
		if (number_is_integer (_tmp22_)) {
			Number* _tmp23_;
			Number* _tmp24_;
			Number* _tmp25_;
			Number* _tmp26_;
			_tmp23_ = tmp;
			_tmp24_ = _g_object_ref0 (_tmp23_);
			_g_object_unref0 (value);
			value = _tmp24_;
			_tmp25_ = divisor;
			_tmp26_ = _g_object_ref0 (_tmp25_);
			factors = g_list_append (factors, _tmp26_);
		} else {
			_g_object_unref0 (tmp);
			break;
		}
		_g_object_unref0 (tmp);
	}
	_tmp27_ = number_new_integer ((gint64) 3, (gint64) 0);
	_g_object_unref0 (divisor);
	divisor = _tmp27_;
	_tmp28_ = value;
	_tmp29_ = number_sqrt (_tmp28_);
	root = _tmp29_;
	while (TRUE) {
		Number* _tmp30_;
		Number* _tmp31_;
		Number* tmp = NULL;
		Number* _tmp32_;
		Number* _tmp33_;
		Number* _tmp34_;
		Number* _tmp35_;
		_tmp30_ = divisor;
		_tmp31_ = root;
		if (!(number_compare (_tmp30_, _tmp31_) <= 0)) {
			break;
		}
		_tmp32_ = value;
		_tmp33_ = divisor;
		_tmp34_ = number_divide (_tmp32_, _tmp33_);
		tmp = _tmp34_;
		_tmp35_ = tmp;
		if (number_is_integer (_tmp35_)) {
			Number* _tmp36_;
			Number* _tmp37_;
			Number* _tmp38_;
			Number* _tmp39_;
			Number* _tmp40_;
			Number* _tmp41_;
			_tmp36_ = tmp;
			_tmp37_ = _g_object_ref0 (_tmp36_);
			_g_object_unref0 (value);
			value = _tmp37_;
			_tmp38_ = value;
			_tmp39_ = number_sqrt (_tmp38_);
			_g_object_unref0 (root);
			root = _tmp39_;
			_tmp40_ = divisor;
			_tmp41_ = _g_object_ref0 (_tmp40_);
			factors = g_list_append (factors, _tmp41_);
		} else {
			Number* _tmp42_;
			Number* _tmp43_;
			Number* _tmp44_;
			Number* _tmp45_;
			Number* _tmp46_;
			Number* _tmp47_;
			_tmp42_ = divisor;
			_tmp43_ = number_new_integer ((gint64) 2, (gint64) 0);
			_tmp44_ = _tmp43_;
			_tmp45_ = number_add (_tmp42_, _tmp44_);
			_g_object_unref0 (tmp);
			tmp = _tmp45_;
			_g_object_unref0 (_tmp44_);
			_tmp46_ = tmp;
			_tmp47_ = _g_object_ref0 (_tmp46_);
			_g_object_unref0 (divisor);
			divisor = _tmp47_;
		}
		_g_object_unref0 (tmp);
	}
	_tmp48_ = value;
	_tmp49_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp50_ = _tmp49_;
	_tmp51_ = number_compare (_tmp48_, _tmp50_) > 0;
	_g_object_unref0 (_tmp50_);
	if (_tmp51_) {
		Number* _tmp52_;
		Number* _tmp53_;
		_tmp52_ = value;
		_tmp53_ = _g_object_ref0 (_tmp52_);
		factors = g_list_append (factors, _tmp53_);
	}
	if (number_is_negative (self)) {
		GList* _tmp54_;
		GList* _tmp55_;
		gconstpointer _tmp56_;
		Number* _tmp57_;
		_tmp54_ = factors;
		_tmp55_ = factors;
		_tmp56_ = _tmp55_->data;
		_tmp57_ = number_invert_sign ((Number*) _tmp56_);
		_g_object_unref0 (_tmp54_->data);
		_tmp54_->data = _tmp57_;
	}
	result = factors;
	_g_object_unref0 (root);
	_g_object_unref0 (divisor);
	_g_object_unref0 (int_max);
	_g_object_unref0 (value);
	return result;
}

GList*
number_factorize_uint64 (Number* self,
                         guint64 n)
{
	GList* factors = NULL;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	factors = NULL;
	while (TRUE) {
		Number* _tmp0_;
		if (!((n % 2) == ((guint64) 0))) {
			break;
		}
		n = n / 2;
		_tmp0_ = number_new_unsigned_integer ((guint64) 2, (guint64) 0);
		factors = g_list_append (factors, _tmp0_);
	}
	{
		guint64 divisor = 0ULL;
		divisor = (guint64) 3;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					divisor += (guint64) 2;
				}
				_tmp1_ = FALSE;
				if (!(divisor <= (n / divisor))) {
					break;
				}
				while (TRUE) {
					Number* _tmp2_;
					if (!((n % divisor) == ((guint64) 0))) {
						break;
					}
					n = n / divisor;
					_tmp2_ = number_new_unsigned_integer (divisor, (guint64) 0);
					factors = g_list_append (factors, _tmp2_);
				}
			}
		}
	}
	if (n > ((guint64) 1)) {
		Number* _tmp3_;
		_tmp3_ = number_new_unsigned_integer (n, (guint64) 0);
		factors = g_list_append (factors, _tmp3_);
	}
	result = factors;
	return result;
}

static Number*
number_copy (Number* self)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_set (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}

static gboolean
_mpc_equal (const __mpc_struct * s1,
            const __mpc_struct * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return FALSE;
}

static void
number_mpc_from_radians (__mpc_struct* res,
                         __mpc_struct* op,
                         AngleUnit unit)
{
	gint i = 0;
	__mpfr_struct scale = {0};
	mpfr_prec_t _tmp1_;
	mpfr_prec_t _tmp2_;
	__mpc_struct _tmp3_;
	g_return_if_fail (res != NULL);
	g_return_if_fail (op != NULL);
	switch (unit) {
		default:
		case ANGLE_UNIT_RADIANS:
		{
			if (_mpc_equal (res, op) != TRUE) {
				__mpc_struct _tmp0_;
				_tmp0_ = *op;
				mpc_set (res, &_tmp0_, MPC_RNDNN);
			}
			return;
		}
		case ANGLE_UNIT_DEGREES:
		{
			i = 180;
			break;
		}
		case ANGLE_UNIT_GRADIANS:
		{
			i = 200;
			break;
		}
	}
	_tmp1_ = number_get_precision ();
	_tmp2_ = _tmp1_;
	mpfr_init2 (&scale, _tmp2_);
	mpfr_const_pi (&scale, MPFR_RNDN);
	mpfr_si_div (&scale, (glong) i, &scale, MPFR_RNDN);
	_tmp3_ = *op;
	mpc_mul_fr (res, &_tmp3_, &scale, MPC_RNDNN);
	mpfr_clear (&scale);
}

static void
number_mpc_to_radians (__mpc_struct* res,
                       __mpc_struct* op,
                       AngleUnit unit)
{
	gint i = 0;
	__mpfr_struct scale = {0};
	mpfr_prec_t _tmp1_;
	mpfr_prec_t _tmp2_;
	__mpc_struct _tmp3_;
	g_return_if_fail (res != NULL);
	g_return_if_fail (op != NULL);
	switch (unit) {
		default:
		case ANGLE_UNIT_RADIANS:
		{
			if (_mpc_equal (res, op) != TRUE) {
				__mpc_struct _tmp0_;
				_tmp0_ = *op;
				mpc_set (res, &_tmp0_, MPC_RNDNN);
			}
			return;
		}
		case ANGLE_UNIT_DEGREES:
		{
			i = 180;
			break;
		}
		case ANGLE_UNIT_GRADIANS:
		{
			i = 200;
			break;
		}
	}
	_tmp1_ = number_get_precision ();
	_tmp2_ = _tmp1_;
	mpfr_init2 (&scale, _tmp2_);
	mpfr_const_pi (&scale, MPFR_RNDN);
	mpfr_div_si (&scale, &scale, (glong) i, MPFR_RNDN);
	_tmp3_ = *op;
	mpc_mul_fr (res, &_tmp3_, &scale, MPC_RNDNN);
	mpfr_clear (&scale);
}

static Number*
number_to_radians (Number* self,
                   AngleUnit unit)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	number_mpc_to_radians (&z->priv->num, &self->priv->num, unit);
	result = z;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static Number*
number_bitwise (Number* self,
                Number* y,
                BitwiseFunc bitwise_operator,
                gpointer bitwise_operator_target,
                gint wordlen)
{
	gchar* text1 = NULL;
	gchar* _tmp0_;
	gchar* text2 = NULL;
	gchar* _tmp1_;
	gint offset1 = 0;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint offset2 = 0;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint offset_out = 0;
	gboolean _tmp9_ = FALSE;
	gchar* text_out = NULL;
	gchar* _tmp12_;
	gint text_out_length1;
	gint _text_out_size_;
	gchar* _tmp22_;
	gint _tmp22__length1;
	Number* _tmp23_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_to_hex_string (self);
	text1 = _tmp0_;
	_tmp1_ = number_to_hex_string (y);
	text2 = _tmp1_;
	_tmp2_ = text1;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	offset1 = _tmp4_ - 1;
	_tmp5_ = text2;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	offset2 = _tmp7_ - 1;
	offset_out = (wordlen / 4) - 1;
	if (offset_out <= 0) {
		gint _tmp8_ = 0;
		if (offset1 > offset2) {
			_tmp8_ = offset1;
		} else {
			_tmp8_ = offset2;
		}
		offset_out = _tmp8_;
	}
	if (offset_out > 0) {
		gboolean _tmp10_ = FALSE;
		if (offset_out < offset1) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = offset_out < offset2;
		}
		_tmp9_ = _tmp10_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		Number* _tmp11_;
		number_set_error ("Overflow. Try a bigger word size");
		_tmp11_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp11_;
		_g_free0 (text2);
		_g_free0 (text1);
		return result;
	}
	_tmp12_ = g_new0 (gchar, offset_out + 2);
	text_out = _tmp12_;
	text_out_length1 = offset_out + 2;
	_text_out_size_ = text_out_length1;
	{
		gchar* _tmp13_;
		gint _tmp13__length1;
		gboolean _tmp14_ = FALSE;
		_tmp13_ = text_out;
		_tmp13__length1 = text_out_length1;
		_tmp13_[offset_out + 1] = '\0';
		_tmp14_ = TRUE;
		while (TRUE) {
			gint v1 = 0;
			gint v2 = 0;
			static const gchar digits[16] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
			gchar* _tmp20_;
			gint _tmp20__length1;
			gchar _tmp21_;
			if (!_tmp14_) {
				gint _tmp15_;
				_tmp15_ = offset_out;
				offset_out = _tmp15_ - 1;
			}
			_tmp14_ = FALSE;
			if (!(offset_out >= 0)) {
				break;
			}
			v1 = 0;
			v2 = 0;
			if (offset1 >= 0) {
				const gchar* _tmp16_;
				gint _tmp17_;
				_tmp16_ = text1;
				v1 = number_hex_to_int (self, string_get (_tmp16_, (glong) offset1));
				_tmp17_ = offset1;
				offset1 = _tmp17_ - 1;
			}
			if (offset2 >= 0) {
				const gchar* _tmp18_;
				gint _tmp19_;
				_tmp18_ = text2;
				v2 = number_hex_to_int (self, string_get (_tmp18_, (glong) offset2));
				_tmp19_ = offset2;
				offset2 = _tmp19_ - 1;
			}
			_tmp20_ = text_out;
			_tmp20__length1 = text_out_length1;
			_tmp21_ = digits[bitwise_operator (v1, v2, bitwise_operator_target)];
			_tmp20_[offset_out] = _tmp21_;
		}
	}
	_tmp22_ = text_out;
	_tmp22__length1 = text_out_length1;
	_tmp23_ = mp_set_from_string ((const gchar*) _tmp22_, 16);
	result = _tmp23_;
	text_out = (g_free (text_out), NULL);
	_g_free0 (text2);
	_g_free0 (text1);
	return result;
}

static gint
number_hex_to_int (Number* self,
                   gchar digit)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (digit >= '0') {
		_tmp0_ = digit <= '9';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = (gint) (digit - '0');
		return result;
	}
	if (digit >= 'A') {
		_tmp1_ = digit <= 'F';
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = (digit - 'A') + 10;
		return result;
	}
	if (digit >= 'a') {
		_tmp2_ = digit <= 'f';
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = (digit - 'a') + 10;
		return result;
	}
	result = 0;
	return result;
}

static gchar*
number_to_hex_string (Number* self)
{
	Serializer* serializer = NULL;
	Serializer* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = serializer_new (DISPLAY_FORMAT_FIXED, 16, 0);
	serializer = _tmp0_;
	_tmp1_ = serializer_to_string (serializer, self);
	result = _tmp1_;
	_g_object_unref0 (serializer);
	return result;
}

Number*
number_construct (GType object_type)
{
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	return self;
}

Number*
number_new (void)
{
	return number_construct (TYPE_NUMBER);
}

mpfr_prec_t
number_get_precision (void)
{
	mpfr_prec_t result;
	result = number__precision;
	return result;
}

void
number_set_precision (mpfr_prec_t value)
{
	number__precision = value;
}

const gchar*
number_get_error (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = number__error;
	result = _tmp0_;
	return result;
}

void
number_set_error (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (number__error);
	number__error = _tmp0_;
}

static void
number_class_init (NumberClass * klass,
                   gpointer klass_data)
{
	number_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Number_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_number_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_number_set_property;
	G_OBJECT_CLASS (klass)->finalize = number_finalize;
}

static void
number_instance_init (Number * self,
                      gpointer klass)
{
	mpfr_prec_t _tmp0_;
	mpfr_prec_t _tmp1_;
	self->priv = number_get_instance_private (self);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpc_init2 (&self->priv->num, _tmp1_);
}

static void
number_finalize (GObject * obj)
{
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NUMBER, Number);
	mpc_clear (&self->priv->num);
	G_OBJECT_CLASS (number_parent_class)->finalize (obj);
}

static GType
number_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NumberClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) number_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Number), 0, (GInstanceInitFunc) number_instance_init, NULL };
	GType number_type_id;
	number_type_id = g_type_register_static (G_TYPE_OBJECT, "Number", &g_define_type_info, 0);
	Number_private_offset = g_type_add_instance_private (number_type_id, sizeof (NumberPrivate));
	return number_type_id;
}

GType
number_get_type (void)
{
	static volatile gsize number_type_id__once = 0;
	if (g_once_init_enter (&number_type_id__once)) {
		GType number_type_id;
		number_type_id = number_get_type_once ();
		g_once_init_leave (&number_type_id__once, number_type_id);
	}
	return number_type_id__once;
}

static void
_vala_number_get_property (GObject * object,
                           guint property_id,
                           GValue * value,
                           GParamSpec * pspec)
{
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NUMBER, Number);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_number_set_property (GObject * object,
                           guint property_id,
                           const GValue * value,
                           GParamSpec * pspec)
{
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NUMBER, Number);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

gint
parse_literal_prefix (const gchar* str,
                      gint* prefix_len)
{
	gint new_base = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gchar prefix = '\0';
	gint result;
	g_return_val_if_fail (str != NULL, 0);
	new_base = 0;
	_tmp1_ = strlen (str);
	_tmp2_ = _tmp1_;
	if (_tmp2_ < 3) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = string_get (str, (glong) 0) != '0';
	}
	if (_tmp0_) {
		result = new_base;
		return result;
	}
	prefix = g_ascii_tolower (string_get (str, (glong) 1));
	if (prefix == 'b') {
		new_base = 2;
	} else {
		if (prefix == 'o') {
			new_base = 8;
		} else {
			if (prefix == 'x') {
				new_base = 16;
			}
		}
	}
	if (new_base != 0) {
		*prefix_len = 2;
	}
	result = new_base;
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gboolean
string_get_prev_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (0 < (*index)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

Number*
mp_set_from_string (const gchar* str,
                    gint default_base)
{
	static const gunichar base_digits[10] = {8320U, 8321U, 8322U, 8323U, 8324U, 8325U, 8326U, 8327U, 8328U, 8329U};
	gint index = 0;
	gint base_prefix = 0;
	gunichar c = 0U;
	gint end = 0;
	gint number_base = 0;
	gint literal_base = 0;
	gint base_multiplier = 0;
	gint _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean negate = FALSE;
	gunichar _tmp12_ = 0U;
	Number* z = NULL;
	Number* _tmp15_;
	static const gunichar fractions[15] = {189U, 8531U, 8532U, 188U, 190U, 8533U, 8534U, 8535U, 8536U, 8537U, 8538U, 8539U, 8540U, 8541U, 8542U};
	static const gint numerators[15] = {1, 1, 2, 1, 3, 1, 2, 3, 4, 1, 5, 1, 3, 5, 7};
	static const gint denominators[15] = {2, 3, 3, 4, 4, 5, 5, 5, 5, 6, 6, 8, 8, 8, 8};
	gboolean has_fraction = FALSE;
	gunichar _tmp25_ = 0U;
	gboolean _tmp26_;
	Number* result;
	g_return_val_if_fail (str != NULL, NULL);
	if (string_index_of_char (str, 176U, 0) >= 0) {
		Number* _tmp0_;
		_tmp0_ = set_from_sexagesimal (str);
		result = _tmp0_;
		return result;
	}
	index = 0;
	base_prefix = 0;
	while (TRUE) {
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_;
		_tmp2_ = string_get_next_char (str, &index, &_tmp1_);
		c = _tmp1_;
		if (!_tmp2_) {
			break;
		}
	}
	end = index;
	number_base = 0;
	literal_base = 0;
	base_multiplier = 1;
	while (TRUE) {
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_;
		gint value = 0;
		_tmp4_ = string_get_prev_char (str, &index, &_tmp3_);
		c = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		value = -1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					gunichar _tmp7_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					if (!(i < G_N_ELEMENTS (base_digits))) {
						break;
					}
					_tmp7_ = base_digits[i];
					if (c == _tmp7_) {
						value = i;
						break;
					}
				}
			}
		}
		if (value < 0) {
			break;
		}
		end = index;
		number_base += value * base_multiplier;
		base_multiplier *= 10;
	}
	_tmp8_ = parse_literal_prefix (str, &base_prefix);
	literal_base = _tmp8_;
	if (number_base != 0) {
		_tmp10_ = literal_base != 0;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		_tmp9_ = literal_base != number_base;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		result = NULL;
		return result;
	}
	if (number_base == 0) {
		gint _tmp11_ = 0;
		if (literal_base != 0) {
			_tmp11_ = literal_base;
		} else {
			_tmp11_ = default_base;
		}
		number_base = _tmp11_;
	}
	negate = FALSE;
	index = base_prefix;
	string_get_next_char (str, &index, &_tmp12_);
	c = _tmp12_;
	if (c == ((gunichar) '+')) {
		negate = FALSE;
	} else {
		gboolean _tmp13_ = FALSE;
		if (c == ((gunichar) '-')) {
			_tmp13_ = TRUE;
		} else {
			_tmp13_ = c == 8722U;
		}
		if (_tmp13_) {
			negate = TRUE;
		} else {
			gunichar _tmp14_ = 0U;
			string_get_prev_char (str, &index, &_tmp14_);
			c = _tmp14_;
		}
	}
	_tmp15_ = number_new_integer ((gint64) 0, (gint64) 0);
	z = _tmp15_;
	while (TRUE) {
		gunichar _tmp16_ = 0U;
		gboolean _tmp17_;
		gint i = 0;
		Number* _tmp19_;
		Number* _tmp20_;
		Number* _tmp21_;
		Number* _tmp22_;
		Number* _tmp23_;
		Number* _tmp24_;
		_tmp17_ = string_get_next_char (str, &index, &_tmp16_);
		c = _tmp16_;
		if (!_tmp17_) {
			break;
		}
		i = char_val (c, number_base);
		if (i > number_base) {
			result = NULL;
			_g_object_unref0 (z);
			return result;
		}
		if (i < 0) {
			gunichar _tmp18_ = 0U;
			string_get_prev_char (str, &index, &_tmp18_);
			c = _tmp18_;
			break;
		}
		_tmp19_ = z;
		_tmp20_ = number_multiply_integer (_tmp19_, (gint64) number_base);
		_tmp21_ = _tmp20_;
		_tmp22_ = number_new_integer ((gint64) i, (gint64) 0);
		_tmp23_ = _tmp22_;
		_tmp24_ = number_add (_tmp21_, _tmp23_);
		_g_object_unref0 (z);
		z = _tmp24_;
		_g_object_unref0 (_tmp23_);
		_g_object_unref0 (_tmp21_);
	}
	has_fraction = FALSE;
	_tmp26_ = string_get_next_char (str, &index, &_tmp25_);
	c = _tmp25_;
	if (_tmp26_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp27_ = FALSE;
				_tmp27_ = TRUE;
				while (TRUE) {
					gunichar _tmp29_;
					if (!_tmp27_) {
						gint _tmp28_;
						_tmp28_ = i;
						i = _tmp28_ + 1;
					}
					_tmp27_ = FALSE;
					if (!(i < G_N_ELEMENTS (fractions))) {
						break;
					}
					_tmp29_ = fractions[i];
					if (c == _tmp29_) {
						Number* fraction = NULL;
						gint _tmp30_;
						gint _tmp31_;
						Number* _tmp32_;
						Number* _tmp33_;
						Number* _tmp34_;
						Number* _tmp35_;
						gunichar _tmp36_ = 0U;
						gboolean _tmp37_;
						_tmp30_ = numerators[i];
						_tmp31_ = denominators[i];
						_tmp32_ = number_new_fraction ((gint64) _tmp30_, (gint64) _tmp31_);
						fraction = _tmp32_;
						_tmp33_ = z;
						_tmp34_ = fraction;
						_tmp35_ = number_add (_tmp33_, _tmp34_);
						_g_object_unref0 (z);
						z = _tmp35_;
						_tmp37_ = string_get_next_char (str, &index, &_tmp36_);
						c = _tmp36_;
						if (!_tmp37_) {
							result = z;
							_g_object_unref0 (fraction);
							return result;
						} else {
							result = NULL;
							_g_object_unref0 (fraction);
							_g_object_unref0 (z);
							return result;
						}
						_g_object_unref0 (fraction);
					}
				}
			}
		}
		if (c == ((gunichar) '.')) {
			has_fraction = TRUE;
		} else {
			gunichar _tmp38_ = 0U;
			string_get_prev_char (str, &index, &_tmp38_);
			c = _tmp38_;
		}
	}
	if (has_fraction) {
		Number* numerator = NULL;
		Number* _tmp39_;
		Number* denominator = NULL;
		Number* _tmp40_;
		Number* _tmp52_;
		Number* _tmp53_;
		Number* _tmp54_;
		Number* _tmp55_;
		Number* _tmp56_;
		Number* _tmp57_;
		_tmp39_ = number_new_integer ((gint64) 0, (gint64) 0);
		numerator = _tmp39_;
		_tmp40_ = number_new_integer ((gint64) 1, (gint64) 0);
		denominator = _tmp40_;
		while (TRUE) {
			gunichar _tmp41_ = 0U;
			gboolean _tmp42_;
			gint i = 0;
			Number* _tmp44_;
			Number* _tmp45_;
			Number* _tmp46_;
			Number* _tmp47_;
			Number* _tmp48_;
			Number* _tmp49_;
			Number* _tmp50_;
			Number* _tmp51_;
			_tmp42_ = string_get_next_char (str, &index, &_tmp41_);
			c = _tmp41_;
			if (!_tmp42_) {
				break;
			}
			i = char_val (c, number_base);
			if (i < 0) {
				gunichar _tmp43_ = 0U;
				string_get_prev_char (str, &index, &_tmp43_);
				c = _tmp43_;
				break;
			}
			_tmp44_ = denominator;
			_tmp45_ = number_multiply_integer (_tmp44_, (gint64) number_base);
			_g_object_unref0 (denominator);
			denominator = _tmp45_;
			_tmp46_ = numerator;
			_tmp47_ = number_multiply_integer (_tmp46_, (gint64) number_base);
			_g_object_unref0 (numerator);
			numerator = _tmp47_;
			_tmp48_ = numerator;
			_tmp49_ = number_new_integer ((gint64) i, (gint64) 0);
			_tmp50_ = _tmp49_;
			_tmp51_ = number_add (_tmp48_, _tmp50_);
			_g_object_unref0 (numerator);
			numerator = _tmp51_;
			_g_object_unref0 (_tmp50_);
		}
		_tmp52_ = numerator;
		_tmp53_ = denominator;
		_tmp54_ = number_divide (_tmp52_, _tmp53_);
		_g_object_unref0 (numerator);
		numerator = _tmp54_;
		_tmp55_ = z;
		_tmp56_ = numerator;
		_tmp57_ = number_add (_tmp55_, _tmp56_);
		_g_object_unref0 (z);
		z = _tmp57_;
		_g_object_unref0 (denominator);
		_g_object_unref0 (numerator);
	}
	if (index != end) {
		result = NULL;
		_g_object_unref0 (z);
		return result;
	}
	if (negate) {
		Number* _tmp58_;
		Number* _tmp59_;
		_tmp58_ = z;
		_tmp59_ = number_invert_sign (_tmp58_);
		_g_object_unref0 (z);
		z = _tmp59_;
	}
	result = z;
	return result;
}

gint
char_val (gunichar c,
          gint number_base)
{
	gint value = 0;
	gint result;
	if (!g_unichar_isxdigit (c)) {
		result = -1;
		return result;
	}
	value = g_unichar_xdigit_value (c);
	if (value >= number_base) {
		result = -1;
		return result;
	}
	result = value;
	return result;
}

Number*
set_from_sexagesimal (const gchar* str)
{
	gint degree_index = 0;
	Number* degrees = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	gint minute_start = 0;
	gunichar c = 0U;
	gunichar _tmp5_ = 0U;
	gint minute_index = 0;
	Number* minutes = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	Number* _tmp12_;
	Number* _tmp13_;
	Number* _tmp14_;
	Number* _tmp15_;
	gint second_start = 0;
	gunichar _tmp16_ = 0U;
	gint second_index = 0;
	Number* seconds = NULL;
	gchar* _tmp17_;
	gchar* _tmp18_;
	Number* _tmp19_;
	Number* _tmp20_;
	Number* _tmp21_;
	Number* _tmp22_;
	Number* _tmp23_;
	Number* _tmp24_;
	Number* _tmp25_;
	Number* _tmp26_;
	gunichar _tmp27_ = 0U;
	Number* result;
	g_return_val_if_fail (str != NULL, NULL);
	degree_index = string_index_of_char (str, 176U, 0);
	if (degree_index < 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = string_substring (str, (glong) 0, (glong) degree_index);
	_tmp1_ = _tmp0_;
	_tmp2_ = mp_set_from_string (_tmp1_, 10);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	degrees = _tmp3_;
	_tmp4_ = degrees;
	if (_tmp4_ == NULL) {
		result = NULL;
		_g_object_unref0 (degrees);
		return result;
	}
	minute_start = degree_index;
	string_get_next_char (str, &minute_start, &_tmp5_);
	c = _tmp5_;
	if (string_get (str, (glong) minute_start) == '\0') {
		result = degrees;
		return result;
	}
	minute_index = string_index_of_char (str, (gunichar) '\'', minute_start);
	if (minute_index < 0) {
		result = NULL;
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp6_ = string_substring (str, (glong) minute_start, (glong) (minute_index - minute_start));
	_tmp7_ = _tmp6_;
	_tmp8_ = mp_set_from_string (_tmp7_, 10);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	minutes = _tmp9_;
	_tmp10_ = minutes;
	if (_tmp10_ == NULL) {
		result = NULL;
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp11_ = degrees;
	_tmp12_ = minutes;
	_tmp13_ = number_divide_integer (_tmp12_, (gint64) 60);
	_tmp14_ = _tmp13_;
	_tmp15_ = number_add (_tmp11_, _tmp14_);
	_g_object_unref0 (degrees);
	degrees = _tmp15_;
	_g_object_unref0 (_tmp14_);
	second_start = minute_index;
	string_get_next_char (str, &second_start, &_tmp16_);
	c = _tmp16_;
	if (string_get (str, (glong) second_start) == '\0') {
		result = degrees;
		_g_object_unref0 (minutes);
		return result;
	}
	second_index = string_index_of_char (str, (gunichar) '"', second_start);
	if (second_index < 0) {
		result = NULL;
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp17_ = string_substring (str, (glong) second_start, (glong) (second_index - second_start));
	_tmp18_ = _tmp17_;
	_tmp19_ = mp_set_from_string (_tmp18_, 10);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp18_);
	seconds = _tmp20_;
	_tmp21_ = seconds;
	if (_tmp21_ == NULL) {
		result = NULL;
		_g_object_unref0 (seconds);
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp22_ = degrees;
	_tmp23_ = seconds;
	_tmp24_ = number_divide_integer (_tmp23_, (gint64) 3600);
	_tmp25_ = _tmp24_;
	_tmp26_ = number_add (_tmp22_, _tmp25_);
	_g_object_unref0 (degrees);
	degrees = _tmp26_;
	_g_object_unref0 (_tmp25_);
	string_get_next_char (str, &second_index, &_tmp27_);
	c = _tmp27_;
	if (string_get (str, (glong) second_index) == '\0') {
		result = degrees;
		_g_object_unref0 (seconds);
		_g_object_unref0 (minutes);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (seconds);
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
}

gboolean
mp_is_overflow (Number* x,
                gint wordlen)
{
	Number* t2 = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	gboolean result;
	g_return_val_if_fail (x != NULL, FALSE);
	_tmp0_ = number_new_integer ((gint64) 2, (gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_xpowy_integer (_tmp1_, (gint64) wordlen);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	t2 = _tmp3_;
	result = number_compare (t2, x) > 0;
	_g_object_unref0 (t2);
	return result;
}

